/*
 * Wine server protocol definitions
 *
 * This file is automatically generated; DO NO EDIT!
 * Edit server/protocol.def instead and re-run tools/make_requests
 */

static void dump_abstime( const char *prefix, const abstime_t *val );
static void dump_apc_result( const char *prefix, const union apc_result *val );
static void dump_async_data( const char *prefix, const struct async_data *val );
static void dump_generic_map( const char *prefix, const struct generic_map *val );
static void dump_hw_input( const char *prefix, const union hw_input *val );
static void dump_ioctl_code( const char *prefix, const ioctl_code_t *val );
static void dump_irp_params( const char *prefix, const union irp_params *val );
static void dump_luid( const char *prefix, const struct luid *val );
static void dump_obj_locator( const char *prefix, const struct obj_locator *val );
static void dump_rectangle( const char *prefix, const struct rectangle *val );
static void dump_timeout( const char *prefix, const timeout_t *val );
static void dump_uint64( const char *prefix, const unsigned __int64 *val );
static void dump_varargs_acl( const char *prefix, data_size_t size );
static void dump_varargs_apc_call( const char *prefix, data_size_t size );
static void dump_varargs_apc_result( const char *prefix, data_size_t size );
static void dump_varargs_bytes( const char *prefix, data_size_t size );
static void dump_varargs_contexts( const char *prefix, data_size_t size );
static void dump_varargs_cursor_positions( const char *prefix, data_size_t size );
static void dump_varargs_debug_event( const char *prefix, data_size_t size );
static void dump_varargs_directory_entries( const char *prefix, data_size_t size );
static void dump_varargs_filesystem_event( const char *prefix, data_size_t size );
static void dump_varargs_handle_infos( const char *prefix, data_size_t size );
static void dump_varargs_ints( const char *prefix, data_size_t size );
static void dump_varargs_luid_attr( const char *prefix, data_size_t size );
static void dump_varargs_message_data( const char *prefix, data_size_t size );
static void dump_varargs_monitor_infos( const char *prefix, data_size_t size );
static void dump_varargs_object_attributes( const char *prefix, data_size_t size );
static void dump_varargs_object_type_info( const char *prefix, data_size_t size );
static void dump_varargs_object_types_info( const char *prefix, data_size_t size );
static void dump_varargs_pe_image_info( const char *prefix, data_size_t size );
static void dump_varargs_process_info( const char *prefix, data_size_t size );
static void dump_varargs_properties( const char *prefix, data_size_t size );
static void dump_varargs_rawinput_devices( const char *prefix, data_size_t size );
static void dump_varargs_rectangles( const char *prefix, data_size_t size );
static void dump_varargs_security_descriptor( const char *prefix, data_size_t size );
static void dump_varargs_select_op( const char *prefix, data_size_t size );
static void dump_varargs_sid( const char *prefix, data_size_t size );
static void dump_varargs_sids( const char *prefix, data_size_t size );
static void dump_varargs_startup_info( const char *prefix, data_size_t size );
static void dump_varargs_string( const char *prefix, data_size_t size );
static void dump_varargs_tcp_connections( const char *prefix, data_size_t size );
static void dump_varargs_udp_endpoints( const char *prefix, data_size_t size );
static void dump_varargs_uints( const char *prefix, data_size_t size );
static void dump_varargs_uints64( const char *prefix, data_size_t size );
static void dump_varargs_unicode_str( const char *prefix, data_size_t size );
static void dump_varargs_unicode_strings( const char *prefix, data_size_t size );
static void dump_varargs_user_handles( const char *prefix, data_size_t size );
static void dump_varargs_ushorts( const char *prefix, data_size_t size );

static const void *cur_data;
static data_size_t cur_size;

static void dump_new_process_request( const struct new_process_request *req )
{
    fprintf( stderr, " token=%04x", req->token );
    fprintf( stderr, ", debug=%04x", req->debug );
    fprintf( stderr, ", parent_process=%04x", req->parent_process );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", socket_fd=%d", req->socket_fd );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", machine=%04x", req->machine );
    fprintf( stderr, ", info_size=%u", req->info_size );
    fprintf( stderr, ", handles_size=%u", req->handles_size );
    fprintf( stderr, ", jobs_size=%u", req->jobs_size );
    dump_varargs_object_attributes( ", objattr=", cur_size );
    dump_varargs_uints( ", handles=", min( cur_size, req->handles_size ));
    dump_varargs_uints( ", jobs=", min( cur_size, req->jobs_size ));
    dump_varargs_startup_info( ", info=", min( cur_size, req->info_size ));
    dump_varargs_unicode_str( ", env=", cur_size );
}

static void dump_new_process_reply( const struct new_process_reply *req )
{
    fprintf( stderr, " info=%04x", req->info );
    fprintf( stderr, ", pid=%04x", req->pid );
    fprintf( stderr, ", handle=%04x", req->handle );
}

static void dump_get_new_process_info_request( const struct get_new_process_info_request *req )
{
    fprintf( stderr, " info=%04x", req->info );
}

static void dump_get_new_process_info_reply( const struct get_new_process_info_reply *req )
{
    fprintf( stderr, " success=%d", req->success );
    fprintf( stderr, ", exit_code=%d", req->exit_code );
}

static void dump_new_thread_request( const struct new_thread_request *req )
{
    fprintf( stderr, " process=%04x", req->process );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", request_fd=%d", req->request_fd );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_new_thread_reply( const struct new_thread_reply *req )
{
    fprintf( stderr, " tid=%04x", req->tid );
    fprintf( stderr, ", handle=%04x", req->handle );
}

static void dump_get_startup_info_request( const struct get_startup_info_request *req )
{
}

static void dump_get_startup_info_reply( const struct get_startup_info_reply *req )
{
    fprintf( stderr, " info_size=%u", req->info_size );
    fprintf( stderr, ", machine=%04x", req->machine );
    dump_varargs_startup_info( ", info=", min( cur_size, req->info_size ));
    dump_varargs_unicode_str( ", env=", cur_size );
}

static void dump_init_process_done_request( const struct init_process_done_request *req )
{
    dump_uint64( " teb=", &req->teb );
    dump_uint64( ", peb=", &req->peb );
    dump_uint64( ", ldt_copy=", &req->ldt_copy );
}

static void dump_init_process_done_reply( const struct init_process_done_reply *req )
{
    fprintf( stderr, " suspend=%d", req->suspend );
}

static void dump_init_first_thread_request( const struct init_first_thread_request *req )
{
    fprintf( stderr, " unix_pid=%d", req->unix_pid );
    fprintf( stderr, ", unix_tid=%d", req->unix_tid );
    fprintf( stderr, ", debug_level=%d", req->debug_level );
    fprintf( stderr, ", reply_fd=%d", req->reply_fd );
    fprintf( stderr, ", wait_fd=%d", req->wait_fd );
}

static void dump_init_first_thread_reply( const struct init_first_thread_reply *req )
{
    fprintf( stderr, " pid=%04x", req->pid );
    fprintf( stderr, ", tid=%04x", req->tid );
    dump_timeout( ", server_start=", &req->server_start );
    fprintf( stderr, ", session_id=%08x", req->session_id );
    fprintf( stderr, ", info_size=%u", req->info_size );
    dump_varargs_ushorts( ", machines=", cur_size );
}

static void dump_init_thread_request( const struct init_thread_request *req )
{
    fprintf( stderr, " unix_tid=%d", req->unix_tid );
    fprintf( stderr, ", reply_fd=%d", req->reply_fd );
    fprintf( stderr, ", wait_fd=%d", req->wait_fd );
    dump_uint64( ", teb=", &req->teb );
    dump_uint64( ", entry=", &req->entry );
}

static void dump_init_thread_reply( const struct init_thread_reply *req )
{
    fprintf( stderr, " suspend=%d", req->suspend );
}

static void dump_terminate_process_request( const struct terminate_process_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", exit_code=%d", req->exit_code );
}

static void dump_terminate_process_reply( const struct terminate_process_reply *req )
{
    fprintf( stderr, " self=%d", req->self );
}

static void dump_terminate_thread_request( const struct terminate_thread_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", exit_code=%d", req->exit_code );
}

static void dump_terminate_thread_reply( const struct terminate_thread_reply *req )
{
    fprintf( stderr, " self=%d", req->self );
}

static void dump_get_process_info_request( const struct get_process_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_process_info_reply( const struct get_process_info_reply *req )
{
    fprintf( stderr, " pid=%04x", req->pid );
    fprintf( stderr, ", ppid=%04x", req->ppid );
    dump_uint64( ", affinity=", &req->affinity );
    dump_uint64( ", peb=", &req->peb );
    dump_timeout( ", start_time=", &req->start_time );
    dump_timeout( ", end_time=", &req->end_time );
    fprintf( stderr, ", session_id=%08x", req->session_id );
    fprintf( stderr, ", exit_code=%d", req->exit_code );
    fprintf( stderr, ", priority=%d", req->priority );
    fprintf( stderr, ", base_priority=%04x", req->base_priority );
    fprintf( stderr, ", machine=%04x", req->machine );
    dump_varargs_pe_image_info( ", image=", cur_size );
}

static void dump_get_process_debug_info_request( const struct get_process_debug_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_process_debug_info_reply( const struct get_process_debug_info_reply *req )
{
    fprintf( stderr, " debug=%04x", req->debug );
    fprintf( stderr, ", debug_children=%d", req->debug_children );
    dump_varargs_pe_image_info( ", image=", cur_size );
}

static void dump_get_process_image_name_request( const struct get_process_image_name_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", pid=%04x", req->pid );
    fprintf( stderr, ", win32=%d", req->win32 );
}

static void dump_get_process_image_name_reply( const struct get_process_image_name_reply *req )
{
    fprintf( stderr, " len=%u", req->len );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_get_process_vm_counters_request( const struct get_process_vm_counters_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_process_vm_counters_reply( const struct get_process_vm_counters_reply *req )
{
    dump_uint64( " peak_virtual_size=", &req->peak_virtual_size );
    dump_uint64( ", virtual_size=", &req->virtual_size );
    dump_uint64( ", peak_working_set_size=", &req->peak_working_set_size );
    dump_uint64( ", working_set_size=", &req->working_set_size );
    dump_uint64( ", pagefile_usage=", &req->pagefile_usage );
    dump_uint64( ", peak_pagefile_usage=", &req->peak_pagefile_usage );
}

static void dump_set_process_info_request( const struct set_process_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", priority=%d", req->priority );
    fprintf( stderr, ", base_priority=%d", req->base_priority );
    dump_uint64( ", affinity=", &req->affinity );
    fprintf( stderr, ", token=%04x", req->token );
    fprintf( stderr, ", mask=%d", req->mask );
}

static void dump_get_thread_info_request( const struct get_thread_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", access=%08x", req->access );
}

static void dump_get_thread_info_reply( const struct get_thread_info_reply *req )
{
    fprintf( stderr, " pid=%04x", req->pid );
    fprintf( stderr, ", tid=%04x", req->tid );
    dump_uint64( ", teb=", &req->teb );
    dump_uint64( ", entry_point=", &req->entry_point );
    dump_uint64( ", affinity=", &req->affinity );
    fprintf( stderr, ", exit_code=%d", req->exit_code );
    fprintf( stderr, ", priority=%d", req->priority );
    fprintf( stderr, ", base_priority=%d", req->base_priority );
    fprintf( stderr, ", suspend_count=%d", req->suspend_count );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", desc_len=%u", req->desc_len );
    dump_varargs_unicode_str( ", desc=", cur_size );
}

static void dump_get_thread_times_request( const struct get_thread_times_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_thread_times_reply( const struct get_thread_times_reply *req )
{
    dump_timeout( " creation_time=", &req->creation_time );
    dump_timeout( ", exit_time=", &req->exit_time );
    fprintf( stderr, ", unix_pid=%d", req->unix_pid );
    fprintf( stderr, ", unix_tid=%d", req->unix_tid );
}

static void dump_set_thread_info_request( const struct set_thread_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", priority=%d", req->priority );
    fprintf( stderr, ", base_priority=%d", req->base_priority );
    dump_uint64( ", affinity=", &req->affinity );
    dump_uint64( ", entry_point=", &req->entry_point );
    fprintf( stderr, ", token=%04x", req->token );
    fprintf( stderr, ", mask=%08x", req->mask );
    dump_varargs_unicode_str( ", desc=", cur_size );
}

static void dump_suspend_thread_request( const struct suspend_thread_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_suspend_thread_reply( const struct suspend_thread_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
}

static void dump_resume_thread_request( const struct resume_thread_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_resume_thread_reply( const struct resume_thread_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
}

static void dump_queue_apc_request( const struct queue_apc_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_varargs_apc_call( ", call=", cur_size );
}

static void dump_queue_apc_reply( const struct queue_apc_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", self=%d", req->self );
}

static void dump_get_apc_result_request( const struct get_apc_result_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_apc_result_reply( const struct get_apc_result_reply *req )
{
    dump_apc_result( " result=", &req->result );
}

static void dump_close_handle_request( const struct close_handle_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_handle_info_request( const struct set_handle_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%d", req->flags );
    fprintf( stderr, ", mask=%d", req->mask );
}

static void dump_set_handle_info_reply( const struct set_handle_info_reply *req )
{
    fprintf( stderr, " old_flags=%d", req->old_flags );
}

static void dump_dup_handle_request( const struct dup_handle_request *req )
{
    fprintf( stderr, " src_process=%04x", req->src_process );
    fprintf( stderr, ", src_handle=%04x", req->src_handle );
    fprintf( stderr, ", dst_process=%04x", req->dst_process );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", options=%08x", req->options );
}

static void dump_dup_handle_reply( const struct dup_handle_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_allocate_reserve_object_request( const struct allocate_reserve_object_request *req )
{
    fprintf( stderr, " type=%d", req->type );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_allocate_reserve_object_reply( const struct allocate_reserve_object_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_compare_objects_request( const struct compare_objects_request *req )
{
    fprintf( stderr, " first=%04x", req->first );
    fprintf( stderr, ", second=%04x", req->second );
}

static void dump_set_object_permanence_request( const struct set_object_permanence_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", permanent=%d", req->permanent );
}

static void dump_open_process_request( const struct open_process_request *req )
{
    fprintf( stderr, " pid=%04x", req->pid );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
}

static void dump_open_process_reply( const struct open_process_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_thread_request( const struct open_thread_request *req )
{
    fprintf( stderr, " tid=%04x", req->tid );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
}

static void dump_open_thread_reply( const struct open_thread_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_select_request( const struct select_request *req )
{
    fprintf( stderr, " flags=%d", req->flags );
    dump_uint64( ", cookie=", &req->cookie );
    dump_abstime( ", timeout=", &req->timeout );
    fprintf( stderr, ", size=%u", req->size );
    fprintf( stderr, ", prev_apc=%04x", req->prev_apc );
    dump_varargs_apc_result( ", result=", cur_size );
    dump_varargs_select_op( ", data=", min( cur_size, req->size ));
    dump_varargs_contexts( ", contexts=", cur_size );
}

static void dump_select_reply( const struct select_reply *req )
{
    fprintf( stderr, " apc_handle=%04x", req->apc_handle );
    fprintf( stderr, ", signaled=%d", req->signaled );
    dump_varargs_apc_call( ", call=", cur_size );
    dump_varargs_contexts( ", contexts=", cur_size );
}

static void dump_create_event_request( const struct create_event_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", manual_reset=%d", req->manual_reset );
    fprintf( stderr, ", initial_state=%d", req->initial_state );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_event_reply( const struct create_event_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_event_op_request( const struct event_op_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", op=%d", req->op );
}

static void dump_event_op_reply( const struct event_op_reply *req )
{
    fprintf( stderr, " state=%d", req->state );
}

static void dump_query_event_request( const struct query_event_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_query_event_reply( const struct query_event_reply *req )
{
    fprintf( stderr, " manual_reset=%d", req->manual_reset );
    fprintf( stderr, ", state=%d", req->state );
}

static void dump_open_event_request( const struct open_event_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_event_reply( const struct open_event_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_create_keyed_event_request( const struct create_keyed_event_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_keyed_event_reply( const struct create_keyed_event_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_keyed_event_request( const struct open_keyed_event_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_keyed_event_reply( const struct open_keyed_event_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_create_mutex_request( const struct create_mutex_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", owned=%d", req->owned );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_mutex_reply( const struct create_mutex_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_release_mutex_request( const struct release_mutex_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_release_mutex_reply( const struct release_mutex_reply *req )
{
    fprintf( stderr, " prev_count=%08x", req->prev_count );
}

static void dump_open_mutex_request( const struct open_mutex_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_mutex_reply( const struct open_mutex_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_query_mutex_request( const struct query_mutex_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_query_mutex_reply( const struct query_mutex_reply *req )
{
    fprintf( stderr, " count=%08x", req->count );
    fprintf( stderr, ", owned=%d", req->owned );
    fprintf( stderr, ", abandoned=%d", req->abandoned );
}

static void dump_create_semaphore_request( const struct create_semaphore_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", initial=%08x", req->initial );
    fprintf( stderr, ", max=%08x", req->max );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_semaphore_reply( const struct create_semaphore_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_release_semaphore_request( const struct release_semaphore_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", count=%08x", req->count );
}

static void dump_release_semaphore_reply( const struct release_semaphore_reply *req )
{
    fprintf( stderr, " prev_count=%08x", req->prev_count );
}

static void dump_query_semaphore_request( const struct query_semaphore_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_query_semaphore_reply( const struct query_semaphore_reply *req )
{
    fprintf( stderr, " current=%08x", req->current );
    fprintf( stderr, ", max=%08x", req->max );
}

static void dump_open_semaphore_request( const struct open_semaphore_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_semaphore_reply( const struct open_semaphore_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_create_file_request( const struct create_file_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", sharing=%08x", req->sharing );
    fprintf( stderr, ", create=%d", req->create );
    fprintf( stderr, ", options=%08x", req->options );
    fprintf( stderr, ", attrs=%08x", req->attrs );
    dump_varargs_object_attributes( ", objattr=", cur_size );
    dump_varargs_string( ", filename=", cur_size );
}

static void dump_create_file_reply( const struct create_file_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_file_object_request( const struct open_file_object_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    fprintf( stderr, ", sharing=%08x", req->sharing );
    fprintf( stderr, ", options=%08x", req->options );
    dump_varargs_unicode_str( ", filename=", cur_size );
}

static void dump_open_file_object_reply( const struct open_file_object_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_alloc_file_handle_request( const struct alloc_file_handle_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", fd=%d", req->fd );
}

static void dump_alloc_file_handle_reply( const struct alloc_file_handle_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_handle_unix_name_request( const struct get_handle_unix_name_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_handle_unix_name_reply( const struct get_handle_unix_name_reply *req )
{
    fprintf( stderr, " name_len=%u", req->name_len );
    dump_varargs_string( ", name=", cur_size );
}

static void dump_get_handle_fd_request( const struct get_handle_fd_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_handle_fd_reply( const struct get_handle_fd_reply *req )
{
    fprintf( stderr, " type=%d", req->type );
    fprintf( stderr, ", cacheable=%d", req->cacheable );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", options=%08x", req->options );
}

static void dump_get_directory_cache_entry_request( const struct get_directory_cache_entry_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_directory_cache_entry_reply( const struct get_directory_cache_entry_reply *req )
{
    fprintf( stderr, " entry=%d", req->entry );
    dump_varargs_ints( ", free=", cur_size );
}

static void dump_flush_request( const struct flush_request *req )
{
    dump_async_data( " async=", &req->async );
}

static void dump_flush_reply( const struct flush_reply *req )
{
    fprintf( stderr, " event=%04x", req->event );
}

static void dump_get_file_info_request( const struct get_file_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", info_class=%08x", req->info_class );
}

static void dump_get_file_info_reply( const struct get_file_info_reply *req )
{
    dump_varargs_bytes( " data=", cur_size );
}

static void dump_get_volume_info_request( const struct get_volume_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_async_data( ", async=", &req->async );
    fprintf( stderr, ", info_class=%08x", req->info_class );
}

static void dump_get_volume_info_reply( const struct get_volume_info_reply *req )
{
    fprintf( stderr, " wait=%04x", req->wait );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_lock_file_request( const struct lock_file_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", offset=", &req->offset );
    dump_uint64( ", count=", &req->count );
    fprintf( stderr, ", shared=%d", req->shared );
    fprintf( stderr, ", wait=%d", req->wait );
}

static void dump_lock_file_reply( const struct lock_file_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", overlapped=%d", req->overlapped );
}

static void dump_unlock_file_request( const struct unlock_file_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", offset=", &req->offset );
    dump_uint64( ", count=", &req->count );
}

static void dump_recv_socket_request( const struct recv_socket_request *req )
{
    fprintf( stderr, " oob=%d", req->oob );
    dump_async_data( ", async=", &req->async );
    fprintf( stderr, ", force_async=%d", req->force_async );
}

static void dump_recv_socket_reply( const struct recv_socket_reply *req )
{
    fprintf( stderr, " wait=%04x", req->wait );
    fprintf( stderr, ", options=%08x", req->options );
    fprintf( stderr, ", nonblocking=%d", req->nonblocking );
}

static void dump_send_socket_request( const struct send_socket_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    dump_async_data( ", async=", &req->async );
}

static void dump_send_socket_reply( const struct send_socket_reply *req )
{
    fprintf( stderr, " wait=%04x", req->wait );
    fprintf( stderr, ", options=%08x", req->options );
    fprintf( stderr, ", nonblocking=%d", req->nonblocking );
}

static void dump_socket_get_events_request( const struct socket_get_events_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", event=%04x", req->event );
}

static void dump_socket_get_events_reply( const struct socket_get_events_reply *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    dump_varargs_uints( ", status=", cur_size );
}

static void dump_socket_send_icmp_id_request( const struct socket_send_icmp_id_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", icmp_id=%04x", req->icmp_id );
    fprintf( stderr, ", icmp_seq=%04x", req->icmp_seq );
}

static void dump_socket_get_icmp_id_request( const struct socket_get_icmp_id_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", icmp_seq=%04x", req->icmp_seq );
}

static void dump_socket_get_icmp_id_reply( const struct socket_get_icmp_id_reply *req )
{
    fprintf( stderr, " icmp_id=%04x", req->icmp_id );
}

static void dump_get_next_console_request_request( const struct get_next_console_request_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", signal=%d", req->signal );
    fprintf( stderr, ", read=%d", req->read );
    fprintf( stderr, ", status=%08x", req->status );
    dump_varargs_bytes( ", out_data=", cur_size );
}

static void dump_get_next_console_request_reply( const struct get_next_console_request_reply *req )
{
    fprintf( stderr, " code=%08x", req->code );
    fprintf( stderr, ", output=%08x", req->output );
    fprintf( stderr, ", out_size=%u", req->out_size );
    dump_varargs_bytes( ", in_data=", cur_size );
}

static void dump_read_directory_changes_request( const struct read_directory_changes_request *req )
{
    fprintf( stderr, " filter=%08x", req->filter );
    fprintf( stderr, ", subtree=%d", req->subtree );
    fprintf( stderr, ", want_data=%d", req->want_data );
    dump_async_data( ", async=", &req->async );
}

static void dump_read_change_request( const struct read_change_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_read_change_reply( const struct read_change_reply *req )
{
    dump_varargs_filesystem_event( " events=", cur_size );
}

static void dump_create_mapping_request( const struct create_mapping_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", file_access=%08x", req->file_access );
    dump_uint64( ", size=", &req->size );
    fprintf( stderr, ", file_handle=%04x", req->file_handle );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_mapping_reply( const struct create_mapping_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_mapping_request( const struct open_mapping_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_mapping_reply( const struct open_mapping_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_mapping_info_request( const struct get_mapping_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", access=%08x", req->access );
}

static void dump_get_mapping_info_reply( const struct get_mapping_info_reply *req )
{
    dump_uint64( " size=", &req->size );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", shared_file=%04x", req->shared_file );
    fprintf( stderr, ", total=%u", req->total );
    dump_varargs_pe_image_info( ", image=", cur_size );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_get_image_map_address_request( const struct get_image_map_address_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_image_map_address_reply( const struct get_image_map_address_reply *req )
{
    dump_uint64( " addr=", &req->addr );
}

static void dump_map_view_request( const struct map_view_request *req )
{
    fprintf( stderr, " mapping=%04x", req->mapping );
    fprintf( stderr, ", access=%08x", req->access );
    dump_uint64( ", base=", &req->base );
    dump_uint64( ", size=", &req->size );
    dump_uint64( ", start=", &req->start );
}

static void dump_map_image_view_request( const struct map_image_view_request *req )
{
    fprintf( stderr, " mapping=%04x", req->mapping );
    dump_uint64( ", base=", &req->base );
    dump_uint64( ", size=", &req->size );
    fprintf( stderr, ", entry=%08x", req->entry );
    fprintf( stderr, ", machine=%04x", req->machine );
}

static void dump_map_builtin_view_request( const struct map_builtin_view_request *req )
{
    dump_varargs_pe_image_info( " image=", cur_size );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_get_image_view_info_request( const struct get_image_view_info_request *req )
{
    fprintf( stderr, " process=%04x", req->process );
    dump_uint64( ", addr=", &req->addr );
}

static void dump_get_image_view_info_reply( const struct get_image_view_info_reply *req )
{
    dump_uint64( " base=", &req->base );
    dump_uint64( ", size=", &req->size );
}

static void dump_unmap_view_request( const struct unmap_view_request *req )
{
    dump_uint64( " base=", &req->base );
}

static void dump_get_mapping_committed_range_request( const struct get_mapping_committed_range_request *req )
{
    dump_uint64( " base=", &req->base );
    dump_uint64( ", offset=", &req->offset );
}

static void dump_get_mapping_committed_range_reply( const struct get_mapping_committed_range_reply *req )
{
    dump_uint64( " size=", &req->size );
    fprintf( stderr, ", committed=%d", req->committed );
}

static void dump_add_mapping_committed_range_request( const struct add_mapping_committed_range_request *req )
{
    dump_uint64( " base=", &req->base );
    dump_uint64( ", offset=", &req->offset );
    dump_uint64( ", size=", &req->size );
}

static void dump_is_same_mapping_request( const struct is_same_mapping_request *req )
{
    dump_uint64( " base1=", &req->base1 );
    dump_uint64( ", base2=", &req->base2 );
}

static void dump_get_mapping_filename_request( const struct get_mapping_filename_request *req )
{
    fprintf( stderr, " process=%04x", req->process );
    dump_uint64( ", addr=", &req->addr );
}

static void dump_get_mapping_filename_reply( const struct get_mapping_filename_reply *req )
{
    fprintf( stderr, " len=%u", req->len );
    dump_varargs_unicode_str( ", filename=", cur_size );
}

static void dump_list_processes_request( const struct list_processes_request *req )
{
}

static void dump_list_processes_reply( const struct list_processes_reply *req )
{
    fprintf( stderr, " info_size=%u", req->info_size );
    fprintf( stderr, ", process_count=%d", req->process_count );
    fprintf( stderr, ", total_thread_count=%d", req->total_thread_count );
    fprintf( stderr, ", total_name_len=%u", req->total_name_len );
    dump_varargs_process_info( ", data=", min( cur_size, req->info_size ));
}

static void dump_create_debug_obj_request( const struct create_debug_obj_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", flags=%08x", req->flags );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_debug_obj_reply( const struct create_debug_obj_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_wait_debug_event_request( const struct wait_debug_event_request *req )
{
    fprintf( stderr, " debug=%04x", req->debug );
}

static void dump_wait_debug_event_reply( const struct wait_debug_event_reply *req )
{
    fprintf( stderr, " pid=%04x", req->pid );
    fprintf( stderr, ", tid=%04x", req->tid );
    dump_varargs_debug_event( ", event=", cur_size );
}

static void dump_queue_exception_event_request( const struct queue_exception_event_request *req )
{
    fprintf( stderr, " first=%d", req->first );
    fprintf( stderr, ", code=%08x", req->code );
    fprintf( stderr, ", flags=%08x", req->flags );
    dump_uint64( ", record=", &req->record );
    dump_uint64( ", address=", &req->address );
    fprintf( stderr, ", len=%u", req->len );
    dump_varargs_uints64( ", params=", min( cur_size, req->len ));
}

static void dump_queue_exception_event_reply( const struct queue_exception_event_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_exception_status_request( const struct get_exception_status_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_continue_debug_event_request( const struct continue_debug_event_request *req )
{
    fprintf( stderr, " debug=%04x", req->debug );
    fprintf( stderr, ", pid=%04x", req->pid );
    fprintf( stderr, ", tid=%04x", req->tid );
    fprintf( stderr, ", status=%08x", req->status );
}

static void dump_debug_process_request( const struct debug_process_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", debug=%04x", req->debug );
    fprintf( stderr, ", attach=%d", req->attach );
}

static void dump_set_debug_obj_info_request( const struct set_debug_obj_info_request *req )
{
    fprintf( stderr, " debug=%04x", req->debug );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_read_process_memory_request( const struct read_process_memory_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", addr=", &req->addr );
}

static void dump_read_process_memory_reply( const struct read_process_memory_reply *req )
{
    dump_varargs_bytes( " data=", cur_size );
}

static void dump_write_process_memory_request( const struct write_process_memory_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", addr=", &req->addr );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_create_key_request( const struct create_key_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", options=%08x", req->options );
    dump_varargs_object_attributes( ", objattr=", cur_size );
    dump_varargs_unicode_str( ", class=", cur_size );
}

static void dump_create_key_reply( const struct create_key_reply *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
}

static void dump_open_key_request( const struct open_key_request *req )
{
    fprintf( stderr, " parent=%04x", req->parent );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_key_reply( const struct open_key_reply *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
}

static void dump_delete_key_request( const struct delete_key_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
}

static void dump_flush_key_request( const struct flush_key_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
}

static void dump_enum_key_request( const struct enum_key_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    fprintf( stderr, ", index=%d", req->index );
    fprintf( stderr, ", info_class=%d", req->info_class );
}

static void dump_enum_key_reply( const struct enum_key_reply *req )
{
    fprintf( stderr, " subkeys=%d", req->subkeys );
    fprintf( stderr, ", max_subkey=%d", req->max_subkey );
    fprintf( stderr, ", max_class=%d", req->max_class );
    fprintf( stderr, ", values=%d", req->values );
    fprintf( stderr, ", max_value=%d", req->max_value );
    fprintf( stderr, ", max_data=%d", req->max_data );
    dump_timeout( ", modif=", &req->modif );
    fprintf( stderr, ", total=%u", req->total );
    fprintf( stderr, ", namelen=%u", req->namelen );
    dump_varargs_unicode_str( ", name=", min( cur_size, req->namelen ));
    dump_varargs_unicode_str( ", class=", cur_size );
}

static void dump_set_key_value_request( const struct set_key_value_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    fprintf( stderr, ", type=%d", req->type );
    fprintf( stderr, ", namelen=%u", req->namelen );
    dump_varargs_unicode_str( ", name=", min( cur_size, req->namelen ));
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_get_key_value_request( const struct get_key_value_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_get_key_value_reply( const struct get_key_value_reply *req )
{
    fprintf( stderr, " type=%d", req->type );
    fprintf( stderr, ", total=%u", req->total );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_enum_key_value_request( const struct enum_key_value_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    fprintf( stderr, ", index=%d", req->index );
    fprintf( stderr, ", info_class=%d", req->info_class );
}

static void dump_enum_key_value_reply( const struct enum_key_value_reply *req )
{
    fprintf( stderr, " type=%d", req->type );
    fprintf( stderr, ", total=%u", req->total );
    fprintf( stderr, ", namelen=%u", req->namelen );
    dump_varargs_unicode_str( ", name=", min( cur_size, req->namelen ));
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_delete_key_value_request( const struct delete_key_value_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_load_registry_request( const struct load_registry_request *req )
{
    fprintf( stderr, " file=%04x", req->file );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_unload_registry_request( const struct unload_registry_request *req )
{
    fprintf( stderr, " parent=%04x", req->parent );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_save_registry_request( const struct save_registry_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    fprintf( stderr, ", file=%04x", req->file );
}

static void dump_set_registry_notification_request( const struct set_registry_notification_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    fprintf( stderr, ", event=%04x", req->event );
    fprintf( stderr, ", subtree=%d", req->subtree );
    fprintf( stderr, ", filter=%08x", req->filter );
}

static void dump_rename_key_request( const struct rename_key_request *req )
{
    fprintf( stderr, " hkey=%04x", req->hkey );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_create_timer_request( const struct create_timer_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", manual=%d", req->manual );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_timer_reply( const struct create_timer_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_timer_request( const struct open_timer_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_timer_reply( const struct open_timer_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_timer_request( const struct set_timer_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_timeout( ", expire=", &req->expire );
    dump_uint64( ", callback=", &req->callback );
    dump_uint64( ", arg=", &req->arg );
    fprintf( stderr, ", period=%d", req->period );
}

static void dump_set_timer_reply( const struct set_timer_reply *req )
{
    fprintf( stderr, " signaled=%d", req->signaled );
}

static void dump_cancel_timer_request( const struct cancel_timer_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_cancel_timer_reply( const struct cancel_timer_reply *req )
{
    fprintf( stderr, " signaled=%d", req->signaled );
}

static void dump_get_timer_info_request( const struct get_timer_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_timer_info_reply( const struct get_timer_info_reply *req )
{
    dump_timeout( " when=", &req->when );
    fprintf( stderr, ", signaled=%d", req->signaled );
}

static void dump_get_thread_context_request( const struct get_thread_context_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", context=%04x", req->context );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", native_flags=%08x", req->native_flags );
    fprintf( stderr, ", machine=%04x", req->machine );
}

static void dump_get_thread_context_reply( const struct get_thread_context_reply *req )
{
    fprintf( stderr, " self=%d", req->self );
    fprintf( stderr, ", handle=%04x", req->handle );
    dump_varargs_contexts( ", contexts=", cur_size );
}

static void dump_set_thread_context_request( const struct set_thread_context_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", native_flags=%08x", req->native_flags );
    dump_varargs_contexts( ", contexts=", cur_size );
}

static void dump_set_thread_context_reply( const struct set_thread_context_reply *req )
{
    fprintf( stderr, " self=%d", req->self );
}

static void dump_get_selector_entry_request( const struct get_selector_entry_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", entry=%d", req->entry );
}

static void dump_get_selector_entry_reply( const struct get_selector_entry_reply *req )
{
    fprintf( stderr, " base=%08x", req->base );
    fprintf( stderr, ", limit=%08x", req->limit );
    fprintf( stderr, ", flags=%02x", req->flags );
}

static void dump_add_atom_request( const struct add_atom_request *req )
{
    dump_varargs_unicode_str( " name=", cur_size );
}

static void dump_add_atom_reply( const struct add_atom_reply *req )
{
    fprintf( stderr, " atom=%04x", req->atom );
}

static void dump_delete_atom_request( const struct delete_atom_request *req )
{
    fprintf( stderr, " atom=%04x", req->atom );
}

static void dump_find_atom_request( const struct find_atom_request *req )
{
    dump_varargs_unicode_str( " name=", cur_size );
}

static void dump_find_atom_reply( const struct find_atom_reply *req )
{
    fprintf( stderr, " atom=%04x", req->atom );
}

static void dump_get_atom_information_request( const struct get_atom_information_request *req )
{
    fprintf( stderr, " atom=%04x", req->atom );
}

static void dump_get_atom_information_reply( const struct get_atom_information_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
    fprintf( stderr, ", pinned=%d", req->pinned );
    fprintf( stderr, ", total=%u", req->total );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_get_msg_queue_handle_request( const struct get_msg_queue_handle_request *req )
{
}

static void dump_get_msg_queue_handle_reply( const struct get_msg_queue_handle_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_msg_queue_request( const struct get_msg_queue_request *req )
{
}

static void dump_get_msg_queue_reply( const struct get_msg_queue_reply *req )
{
    dump_obj_locator( " locator=", &req->locator );
}

static void dump_set_queue_fd_request( const struct set_queue_fd_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_queue_mask_request( const struct set_queue_mask_request *req )
{
    fprintf( stderr, " wake_mask=%08x", req->wake_mask );
    fprintf( stderr, ", changed_mask=%08x", req->changed_mask );
    fprintf( stderr, ", skip_wait=%d", req->skip_wait );
}

static void dump_set_queue_mask_reply( const struct set_queue_mask_reply *req )
{
    fprintf( stderr, " wake_bits=%08x", req->wake_bits );
    fprintf( stderr, ", changed_bits=%08x", req->changed_bits );
}

static void dump_get_queue_status_request( const struct get_queue_status_request *req )
{
    fprintf( stderr, " clear_bits=%08x", req->clear_bits );
}

static void dump_get_queue_status_reply( const struct get_queue_status_reply *req )
{
    fprintf( stderr, " wake_bits=%08x", req->wake_bits );
    fprintf( stderr, ", changed_bits=%08x", req->changed_bits );
}

static void dump_get_process_idle_event_request( const struct get_process_idle_event_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_process_idle_event_reply( const struct get_process_idle_event_reply *req )
{
    fprintf( stderr, " event=%04x", req->event );
}

static void dump_send_message_request( const struct send_message_request *req )
{
    fprintf( stderr, " id=%04x", req->id );
    fprintf( stderr, ", type=%d", req->type );
    fprintf( stderr, ", flags=%d", req->flags );
    fprintf( stderr, ", win=%08x", req->win );
    fprintf( stderr, ", msg=%08x", req->msg );
    dump_uint64( ", wparam=", &req->wparam );
    dump_uint64( ", lparam=", &req->lparam );
    dump_timeout( ", timeout=", &req->timeout );
    dump_varargs_message_data( ", data=", cur_size );
}

static void dump_post_quit_message_request( const struct post_quit_message_request *req )
{
    fprintf( stderr, " exit_code=%d", req->exit_code );
}

static void dump_send_hardware_message_request( const struct send_hardware_message_request *req )
{
    fprintf( stderr, " win=%08x", req->win );
    dump_hw_input( ", input=", &req->input );
    fprintf( stderr, ", flags=%08x", req->flags );
    dump_varargs_bytes( ", report=", cur_size );
}

static void dump_send_hardware_message_reply( const struct send_hardware_message_reply *req )
{
    fprintf( stderr, " wait=%d", req->wait );
    fprintf( stderr, ", prev_x=%d", req->prev_x );
    fprintf( stderr, ", prev_y=%d", req->prev_y );
    fprintf( stderr, ", new_x=%d", req->new_x );
    fprintf( stderr, ", new_y=%d", req->new_y );
}

static void dump_get_message_request( const struct get_message_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", get_win=%08x", req->get_win );
    fprintf( stderr, ", get_first=%08x", req->get_first );
    fprintf( stderr, ", get_last=%08x", req->get_last );
    fprintf( stderr, ", hw_id=%08x", req->hw_id );
    fprintf( stderr, ", wake_mask=%08x", req->wake_mask );
    fprintf( stderr, ", changed_mask=%08x", req->changed_mask );
    fprintf( stderr, ", internal=%08x", req->internal );
}

static void dump_get_message_reply( const struct get_message_reply *req )
{
    fprintf( stderr, " win=%08x", req->win );
    fprintf( stderr, ", msg=%08x", req->msg );
    dump_uint64( ", wparam=", &req->wparam );
    dump_uint64( ", lparam=", &req->lparam );
    fprintf( stderr, ", type=%d", req->type );
    fprintf( stderr, ", x=%d", req->x );
    fprintf( stderr, ", y=%d", req->y );
    fprintf( stderr, ", time=%08x", req->time );
    fprintf( stderr, ", total=%u", req->total );
    dump_varargs_message_data( ", data=", cur_size );
}

static void dump_reply_message_request( const struct reply_message_request *req )
{
    fprintf( stderr, " remove=%d", req->remove );
    dump_uint64( ", result=", &req->result );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_accept_hardware_message_request( const struct accept_hardware_message_request *req )
{
    fprintf( stderr, " hw_id=%08x", req->hw_id );
}

static void dump_get_message_reply_request( const struct get_message_reply_request *req )
{
    fprintf( stderr, " cancel=%d", req->cancel );
}

static void dump_get_message_reply_reply( const struct get_message_reply_reply *req )
{
    dump_uint64( " result=", &req->result );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_set_win_timer_request( const struct set_win_timer_request *req )
{
    fprintf( stderr, " win=%08x", req->win );
    fprintf( stderr, ", msg=%08x", req->msg );
    fprintf( stderr, ", rate=%08x", req->rate );
    dump_uint64( ", id=", &req->id );
    dump_uint64( ", lparam=", &req->lparam );
}

static void dump_set_win_timer_reply( const struct set_win_timer_reply *req )
{
    dump_uint64( " id=", &req->id );
}

static void dump_kill_win_timer_request( const struct kill_win_timer_request *req )
{
    fprintf( stderr, " win=%08x", req->win );
    dump_uint64( ", id=", &req->id );
    fprintf( stderr, ", msg=%08x", req->msg );
}

static void dump_is_window_hung_request( const struct is_window_hung_request *req )
{
    fprintf( stderr, " win=%08x", req->win );
}

static void dump_is_window_hung_reply( const struct is_window_hung_reply *req )
{
    fprintf( stderr, " is_hung=%d", req->is_hung );
}

static void dump_get_serial_info_request( const struct get_serial_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%d", req->flags );
}

static void dump_get_serial_info_reply( const struct get_serial_info_reply *req )
{
    fprintf( stderr, " eventmask=%08x", req->eventmask );
    fprintf( stderr, ", pending_write=%08x", req->pending_write );
}

static void dump_set_serial_info_request( const struct set_serial_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%d", req->flags );
}

static void dump_cancel_sync_request( const struct cancel_sync_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", iosb=", &req->iosb );
}

static void dump_register_async_request( const struct register_async_request *req )
{
    fprintf( stderr, " type=%d", req->type );
    dump_async_data( ", async=", &req->async );
    fprintf( stderr, ", count=%d", req->count );
}

static void dump_cancel_async_request( const struct cancel_async_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", iosb=", &req->iosb );
    fprintf( stderr, ", only_thread=%d", req->only_thread );
}

static void dump_get_async_result_request( const struct get_async_result_request *req )
{
    dump_uint64( " user_arg=", &req->user_arg );
}

static void dump_get_async_result_reply( const struct get_async_result_reply *req )
{
    dump_varargs_bytes( " out_data=", cur_size );
}

static void dump_set_async_direct_result_request( const struct set_async_direct_result_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", information=", &req->information );
    fprintf( stderr, ", status=%08x", req->status );
    fprintf( stderr, ", mark_pending=%d", req->mark_pending );
}

static void dump_set_async_direct_result_reply( const struct set_async_direct_result_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_read_request( const struct read_request *req )
{
    dump_async_data( " async=", &req->async );
    dump_uint64( ", pos=", &req->pos );
}

static void dump_read_reply( const struct read_reply *req )
{
    fprintf( stderr, " wait=%04x", req->wait );
    fprintf( stderr, ", options=%08x", req->options );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_write_request( const struct write_request *req )
{
    dump_async_data( " async=", &req->async );
    dump_uint64( ", pos=", &req->pos );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_write_reply( const struct write_reply *req )
{
    fprintf( stderr, " wait=%04x", req->wait );
    fprintf( stderr, ", options=%08x", req->options );
    fprintf( stderr, ", size=%u", req->size );
}

static void dump_ioctl_request( const struct ioctl_request *req )
{
    dump_ioctl_code( " code=", &req->code );
    dump_async_data( ", async=", &req->async );
    dump_varargs_bytes( ", in_data=", cur_size );
}

static void dump_ioctl_reply( const struct ioctl_reply *req )
{
    fprintf( stderr, " wait=%04x", req->wait );
    fprintf( stderr, ", options=%08x", req->options );
    dump_varargs_bytes( ", out_data=", cur_size );
}

static void dump_set_irp_result_request( const struct set_irp_result_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", status=%08x", req->status );
    fprintf( stderr, ", size=%u", req->size );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_create_named_pipe_request( const struct create_named_pipe_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", options=%08x", req->options );
    fprintf( stderr, ", sharing=%08x", req->sharing );
    fprintf( stderr, ", disposition=%08x", req->disposition );
    fprintf( stderr, ", maxinstances=%08x", req->maxinstances );
    fprintf( stderr, ", outsize=%08x", req->outsize );
    fprintf( stderr, ", insize=%08x", req->insize );
    dump_timeout( ", timeout=", &req->timeout );
    fprintf( stderr, ", flags=%08x", req->flags );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_named_pipe_reply( const struct create_named_pipe_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", created=%d", req->created );
}

static void dump_set_named_pipe_info_request( const struct set_named_pipe_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_create_window_request( const struct create_window_request *req )
{
    fprintf( stderr, " parent=%08x", req->parent );
    fprintf( stderr, ", owner=%08x", req->owner );
    fprintf( stderr, ", atom=%04x", req->atom );
    dump_uint64( ", class_instance=", &req->class_instance );
    dump_uint64( ", instance=", &req->instance );
    fprintf( stderr, ", dpi_context=%08x", req->dpi_context );
    fprintf( stderr, ", style=%08x", req->style );
    fprintf( stderr, ", ex_style=%08x", req->ex_style );
    dump_varargs_unicode_str( ", class=", cur_size );
}

static void dump_create_window_reply( const struct create_window_reply *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", parent=%08x", req->parent );
    fprintf( stderr, ", owner=%08x", req->owner );
    fprintf( stderr, ", extra=%d", req->extra );
    dump_uint64( ", class_ptr=", &req->class_ptr );
}

static void dump_destroy_window_request( const struct destroy_window_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_get_desktop_window_request( const struct get_desktop_window_request *req )
{
    fprintf( stderr, " force=%d", req->force );
}

static void dump_get_desktop_window_reply( const struct get_desktop_window_reply *req )
{
    fprintf( stderr, " top_window=%08x", req->top_window );
    fprintf( stderr, ", msg_window=%08x", req->msg_window );
}

static void dump_set_window_owner_request( const struct set_window_owner_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", owner=%08x", req->owner );
}

static void dump_set_window_owner_reply( const struct set_window_owner_reply *req )
{
    fprintf( stderr, " full_owner=%08x", req->full_owner );
    fprintf( stderr, ", prev_owner=%08x", req->prev_owner );
}

static void dump_get_window_info_request( const struct get_window_info_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", offset=%d", req->offset );
    fprintf( stderr, ", size=%u", req->size );
}

static void dump_get_window_info_reply( const struct get_window_info_reply *req )
{
    fprintf( stderr, " last_active=%08x", req->last_active );
    fprintf( stderr, ", is_unicode=%d", req->is_unicode );
    dump_uint64( ", info=", &req->info );
}

static void dump_init_window_info_request( const struct init_window_info_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", style=%08x", req->style );
    fprintf( stderr, ", ex_style=%08x", req->ex_style );
    fprintf( stderr, ", is_unicode=%d", req->is_unicode );
}

static void dump_set_window_info_request( const struct set_window_info_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", offset=%d", req->offset );
    fprintf( stderr, ", size=%u", req->size );
    dump_uint64( ", new_info=", &req->new_info );
}

static void dump_set_window_info_reply( const struct set_window_info_reply *req )
{
    dump_uint64( " old_info=", &req->old_info );
}

static void dump_set_parent_request( const struct set_parent_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", parent=%08x", req->parent );
}

static void dump_set_parent_reply( const struct set_parent_reply *req )
{
    fprintf( stderr, " old_parent=%08x", req->old_parent );
    fprintf( stderr, ", full_parent=%08x", req->full_parent );
}

static void dump_get_window_parents_request( const struct get_window_parents_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_get_window_parents_reply( const struct get_window_parents_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
    dump_varargs_user_handles( ", parents=", cur_size );
}

static void dump_get_window_list_request( const struct get_window_list_request *req )
{
    fprintf( stderr, " desktop=%04x", req->desktop );
    fprintf( stderr, ", handle=%08x", req->handle );
    fprintf( stderr, ", tid=%04x", req->tid );
    fprintf( stderr, ", children=%d", req->children );
}

static void dump_get_window_list_reply( const struct get_window_list_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
    dump_varargs_user_handles( ", windows=", cur_size );
}

static void dump_get_class_windows_request( const struct get_class_windows_request *req )
{
    fprintf( stderr, " parent=%08x", req->parent );
    fprintf( stderr, ", child=%08x", req->child );
    fprintf( stderr, ", atom=%04x", req->atom );
    dump_varargs_unicode_str( ", class=", cur_size );
}

static void dump_get_class_windows_reply( const struct get_class_windows_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
    dump_varargs_user_handles( ", children=", cur_size );
}

static void dump_get_window_children_from_point_request( const struct get_window_children_from_point_request *req )
{
    fprintf( stderr, " parent=%08x", req->parent );
    fprintf( stderr, ", x=%d", req->x );
    fprintf( stderr, ", y=%d", req->y );
    fprintf( stderr, ", dpi=%d", req->dpi );
}

static void dump_get_window_children_from_point_reply( const struct get_window_children_from_point_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
    dump_varargs_user_handles( ", children=", cur_size );
}

static void dump_get_window_tree_request( const struct get_window_tree_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_get_window_tree_reply( const struct get_window_tree_reply *req )
{
    fprintf( stderr, " parent=%08x", req->parent );
    fprintf( stderr, ", owner=%08x", req->owner );
    fprintf( stderr, ", next_sibling=%08x", req->next_sibling );
    fprintf( stderr, ", prev_sibling=%08x", req->prev_sibling );
    fprintf( stderr, ", first_sibling=%08x", req->first_sibling );
    fprintf( stderr, ", last_sibling=%08x", req->last_sibling );
    fprintf( stderr, ", first_child=%08x", req->first_child );
    fprintf( stderr, ", last_child=%08x", req->last_child );
}

static void dump_set_window_pos_request( const struct set_window_pos_request *req )
{
    fprintf( stderr, " swp_flags=%04x", req->swp_flags );
    fprintf( stderr, ", paint_flags=%04x", req->paint_flags );
    fprintf( stderr, ", monitor_dpi=%08x", req->monitor_dpi );
    fprintf( stderr, ", handle=%08x", req->handle );
    fprintf( stderr, ", previous=%08x", req->previous );
    dump_rectangle( ", window=", &req->window );
    dump_rectangle( ", client=", &req->client );
    dump_varargs_rectangles( ", valid=", cur_size );
}

static void dump_set_window_pos_reply( const struct set_window_pos_reply *req )
{
    fprintf( stderr, " new_style=%08x", req->new_style );
    fprintf( stderr, ", new_ex_style=%08x", req->new_ex_style );
    fprintf( stderr, ", surface_win=%08x", req->surface_win );
}

static void dump_get_window_rectangles_request( const struct get_window_rectangles_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", relative=%d", req->relative );
    fprintf( stderr, ", dpi=%d", req->dpi );
}

static void dump_get_window_rectangles_reply( const struct get_window_rectangles_reply *req )
{
    dump_rectangle( " window=", &req->window );
    dump_rectangle( ", client=", &req->client );
}

static void dump_get_window_text_request( const struct get_window_text_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_get_window_text_reply( const struct get_window_text_reply *req )
{
    fprintf( stderr, " length=%u", req->length );
    dump_varargs_unicode_str( ", text=", cur_size );
}

static void dump_set_window_text_request( const struct set_window_text_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    dump_varargs_unicode_str( ", text=", cur_size );
}

static void dump_get_windows_offset_request( const struct get_windows_offset_request *req )
{
    fprintf( stderr, " from=%08x", req->from );
    fprintf( stderr, ", to=%08x", req->to );
    fprintf( stderr, ", dpi=%d", req->dpi );
}

static void dump_get_windows_offset_reply( const struct get_windows_offset_reply *req )
{
    fprintf( stderr, " x=%d", req->x );
    fprintf( stderr, ", y=%d", req->y );
    fprintf( stderr, ", mirror=%d", req->mirror );
}

static void dump_get_visible_region_request( const struct get_visible_region_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_get_visible_region_reply( const struct get_visible_region_reply *req )
{
    fprintf( stderr, " top_win=%08x", req->top_win );
    dump_rectangle( ", top_rect=", &req->top_rect );
    dump_rectangle( ", win_rect=", &req->win_rect );
    fprintf( stderr, ", paint_flags=%08x", req->paint_flags );
    fprintf( stderr, ", total_size=%u", req->total_size );
    dump_varargs_rectangles( ", region=", cur_size );
}

static void dump_get_window_region_request( const struct get_window_region_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", surface=%d", req->surface );
}

static void dump_get_window_region_reply( const struct get_window_region_reply *req )
{
    dump_rectangle( " visible_rect=", &req->visible_rect );
    fprintf( stderr, ", total_size=%u", req->total_size );
    dump_varargs_rectangles( ", region=", cur_size );
}

static void dump_set_window_region_request( const struct set_window_region_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", redraw=%d", req->redraw );
    dump_varargs_rectangles( ", region=", cur_size );
}

static void dump_get_update_region_request( const struct get_update_region_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", from_child=%08x", req->from_child );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_get_update_region_reply( const struct get_update_region_reply *req )
{
    fprintf( stderr, " child=%08x", req->child );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", total_size=%u", req->total_size );
    dump_varargs_rectangles( ", region=", cur_size );
}

static void dump_update_window_zorder_request( const struct update_window_zorder_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    dump_rectangle( ", rect=", &req->rect );
}

static void dump_redraw_window_request( const struct redraw_window_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", flags=%08x", req->flags );
    dump_varargs_rectangles( ", region=", cur_size );
}

static void dump_set_window_property_request( const struct set_window_property_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    dump_uint64( ", data=", &req->data );
    fprintf( stderr, ", atom=%04x", req->atom );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_remove_window_property_request( const struct remove_window_property_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", atom=%04x", req->atom );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_remove_window_property_reply( const struct remove_window_property_reply *req )
{
    dump_uint64( " data=", &req->data );
}

static void dump_get_window_property_request( const struct get_window_property_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", atom=%04x", req->atom );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_get_window_property_reply( const struct get_window_property_reply *req )
{
    dump_uint64( " data=", &req->data );
}

static void dump_get_window_properties_request( const struct get_window_properties_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
}

static void dump_get_window_properties_reply( const struct get_window_properties_reply *req )
{
    fprintf( stderr, " total=%d", req->total );
    dump_varargs_properties( ", props=", cur_size );
}

static void dump_create_winstation_request( const struct create_winstation_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_create_winstation_reply( const struct create_winstation_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_winstation_request( const struct open_winstation_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_winstation_reply( const struct open_winstation_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_close_winstation_request( const struct close_winstation_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_winstation_monitors_request( const struct set_winstation_monitors_request *req )
{
    fprintf( stderr, " increment=%d", req->increment );
    dump_varargs_monitor_infos( ", infos=", cur_size );
}

static void dump_set_winstation_monitors_reply( const struct set_winstation_monitors_reply *req )
{
    dump_uint64( " serial=", &req->serial );
}

static void dump_get_process_winstation_request( const struct get_process_winstation_request *req )
{
}

static void dump_get_process_winstation_reply( const struct get_process_winstation_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_process_winstation_request( const struct set_process_winstation_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_enum_winstation_request( const struct enum_winstation_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_enum_winstation_reply( const struct enum_winstation_reply *req )
{
    fprintf( stderr, " count=%u", req->count );
    fprintf( stderr, ", total=%u", req->total );
    dump_varargs_unicode_strings( ", names=", cur_size );
}

static void dump_create_desktop_request( const struct create_desktop_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_create_desktop_reply( const struct create_desktop_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_desktop_request( const struct open_desktop_request *req )
{
    fprintf( stderr, " winsta=%04x", req->winsta );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_desktop_reply( const struct open_desktop_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_input_desktop_request( const struct open_input_desktop_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
}

static void dump_open_input_desktop_reply( const struct open_input_desktop_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_input_desktop_request( const struct set_input_desktop_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_close_desktop_request( const struct close_desktop_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_thread_desktop_request( const struct get_thread_desktop_request *req )
{
    fprintf( stderr, " tid=%04x", req->tid );
}

static void dump_get_thread_desktop_reply( const struct get_thread_desktop_reply *req )
{
    dump_obj_locator( " locator=", &req->locator );
    fprintf( stderr, ", handle=%04x", req->handle );
}

static void dump_set_thread_desktop_request( const struct set_thread_desktop_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_thread_desktop_reply( const struct set_thread_desktop_reply *req )
{
    dump_obj_locator( " locator=", &req->locator );
}

static void dump_set_user_object_info_request( const struct set_user_object_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", obj_flags=%08x", req->obj_flags );
}

static void dump_set_user_object_info_reply( const struct set_user_object_info_reply *req )
{
    fprintf( stderr, " is_desktop=%d", req->is_desktop );
    fprintf( stderr, ", old_obj_flags=%08x", req->old_obj_flags );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_register_hotkey_request( const struct register_hotkey_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", id=%d", req->id );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", vkey=%08x", req->vkey );
}

static void dump_register_hotkey_reply( const struct register_hotkey_reply *req )
{
    fprintf( stderr, " replaced=%d", req->replaced );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", vkey=%08x", req->vkey );
}

static void dump_unregister_hotkey_request( const struct unregister_hotkey_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", id=%d", req->id );
}

static void dump_unregister_hotkey_reply( const struct unregister_hotkey_reply *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", vkey=%08x", req->vkey );
}

static void dump_attach_thread_input_request( const struct attach_thread_input_request *req )
{
    fprintf( stderr, " tid_from=%04x", req->tid_from );
    fprintf( stderr, ", tid_to=%04x", req->tid_to );
    fprintf( stderr, ", attach=%d", req->attach );
}

static void dump_get_thread_input_request( const struct get_thread_input_request *req )
{
    fprintf( stderr, " tid=%04x", req->tid );
}

static void dump_get_thread_input_reply( const struct get_thread_input_reply *req )
{
    dump_obj_locator( " locator=", &req->locator );
}

static void dump_get_last_input_time_request( const struct get_last_input_time_request *req )
{
}

static void dump_get_last_input_time_reply( const struct get_last_input_time_reply *req )
{
    fprintf( stderr, " time=%08x", req->time );
}

static void dump_get_key_state_request( const struct get_key_state_request *req )
{
    fprintf( stderr, " async=%d", req->async );
    fprintf( stderr, ", key=%d", req->key );
}

static void dump_get_key_state_reply( const struct get_key_state_reply *req )
{
    fprintf( stderr, " state=%02x", req->state );
}

static void dump_set_key_state_request( const struct set_key_state_request *req )
{
    fprintf( stderr, " async=%d", req->async );
    dump_varargs_bytes( ", keystate=", cur_size );
}

static void dump_set_foreground_window_request( const struct set_foreground_window_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_set_foreground_window_reply( const struct set_foreground_window_reply *req )
{
    fprintf( stderr, " previous=%08x", req->previous );
    fprintf( stderr, ", send_msg_old=%d", req->send_msg_old );
    fprintf( stderr, ", send_msg_new=%d", req->send_msg_new );
}

static void dump_set_focus_window_request( const struct set_focus_window_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_set_focus_window_reply( const struct set_focus_window_reply *req )
{
    fprintf( stderr, " previous=%08x", req->previous );
}

static void dump_set_active_window_request( const struct set_active_window_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_set_active_window_reply( const struct set_active_window_reply *req )
{
    fprintf( stderr, " previous=%08x", req->previous );
}

static void dump_set_capture_window_request( const struct set_capture_window_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_set_capture_window_reply( const struct set_capture_window_reply *req )
{
    fprintf( stderr, " previous=%08x", req->previous );
    fprintf( stderr, ", full_handle=%08x", req->full_handle );
}

static void dump_set_caret_window_request( const struct set_caret_window_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", width=%d", req->width );
    fprintf( stderr, ", height=%d", req->height );
}

static void dump_set_caret_window_reply( const struct set_caret_window_reply *req )
{
    fprintf( stderr, " previous=%08x", req->previous );
    dump_rectangle( ", old_rect=", &req->old_rect );
    fprintf( stderr, ", old_hide=%d", req->old_hide );
    fprintf( stderr, ", old_state=%d", req->old_state );
}

static void dump_set_caret_info_request( const struct set_caret_info_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", handle=%08x", req->handle );
    fprintf( stderr, ", x=%d", req->x );
    fprintf( stderr, ", y=%d", req->y );
    fprintf( stderr, ", hide=%d", req->hide );
    fprintf( stderr, ", state=%d", req->state );
}

static void dump_set_caret_info_reply( const struct set_caret_info_reply *req )
{
    fprintf( stderr, " full_handle=%08x", req->full_handle );
    dump_rectangle( ", old_rect=", &req->old_rect );
    fprintf( stderr, ", old_hide=%d", req->old_hide );
    fprintf( stderr, ", old_state=%d", req->old_state );
}

static void dump_set_hook_request( const struct set_hook_request *req )
{
    fprintf( stderr, " id=%d", req->id );
    fprintf( stderr, ", pid=%04x", req->pid );
    fprintf( stderr, ", tid=%04x", req->tid );
    fprintf( stderr, ", event_min=%d", req->event_min );
    fprintf( stderr, ", event_max=%d", req->event_max );
    dump_uint64( ", proc=", &req->proc );
    fprintf( stderr, ", flags=%d", req->flags );
    fprintf( stderr, ", unicode=%d", req->unicode );
    dump_varargs_unicode_str( ", module=", cur_size );
}

static void dump_set_hook_reply( const struct set_hook_reply *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_remove_hook_request( const struct remove_hook_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    dump_uint64( ", proc=", &req->proc );
    fprintf( stderr, ", id=%d", req->id );
}

static void dump_start_hook_chain_request( const struct start_hook_chain_request *req )
{
    fprintf( stderr, " id=%d", req->id );
    fprintf( stderr, ", event=%d", req->event );
    fprintf( stderr, ", window=%08x", req->window );
    fprintf( stderr, ", object_id=%d", req->object_id );
    fprintf( stderr, ", child_id=%d", req->child_id );
}

static void dump_start_hook_chain_reply( const struct start_hook_chain_reply *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", pid=%04x", req->pid );
    fprintf( stderr, ", tid=%04x", req->tid );
    fprintf( stderr, ", unicode=%d", req->unicode );
    dump_uint64( ", proc=", &req->proc );
    dump_varargs_unicode_str( ", module=", cur_size );
}

static void dump_finish_hook_chain_request( const struct finish_hook_chain_request *req )
{
    fprintf( stderr, " id=%d", req->id );
}

static void dump_get_hook_info_request( const struct get_hook_info_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", get_next=%d", req->get_next );
    fprintf( stderr, ", event=%d", req->event );
    fprintf( stderr, ", window=%08x", req->window );
    fprintf( stderr, ", object_id=%d", req->object_id );
    fprintf( stderr, ", child_id=%d", req->child_id );
}

static void dump_get_hook_info_reply( const struct get_hook_info_reply *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", id=%d", req->id );
    fprintf( stderr, ", pid=%04x", req->pid );
    fprintf( stderr, ", tid=%04x", req->tid );
    dump_uint64( ", proc=", &req->proc );
    fprintf( stderr, ", unicode=%d", req->unicode );
    dump_varargs_unicode_str( ", module=", cur_size );
}

static void dump_create_class_request( const struct create_class_request *req )
{
    fprintf( stderr, " local=%d", req->local );
    fprintf( stderr, ", atom=%04x", req->atom );
    fprintf( stderr, ", style=%08x", req->style );
    dump_uint64( ", instance=", &req->instance );
    fprintf( stderr, ", extra=%d", req->extra );
    fprintf( stderr, ", win_extra=%d", req->win_extra );
    dump_uint64( ", client_ptr=", &req->client_ptr );
    fprintf( stderr, ", name_offset=%u", req->name_offset );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_create_class_reply( const struct create_class_reply *req )
{
    fprintf( stderr, " atom=%04x", req->atom );
}

static void dump_destroy_class_request( const struct destroy_class_request *req )
{
    fprintf( stderr, " atom=%04x", req->atom );
    dump_uint64( ", instance=", &req->instance );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_destroy_class_reply( const struct destroy_class_reply *req )
{
    dump_uint64( " client_ptr=", &req->client_ptr );
}

static void dump_set_class_info_request( const struct set_class_info_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", atom=%04x", req->atom );
    fprintf( stderr, ", style=%08x", req->style );
    fprintf( stderr, ", win_extra=%d", req->win_extra );
    dump_uint64( ", instance=", &req->instance );
    fprintf( stderr, ", extra_offset=%d", req->extra_offset );
    fprintf( stderr, ", extra_size=%u", req->extra_size );
    dump_uint64( ", extra_value=", &req->extra_value );
}

static void dump_set_class_info_reply( const struct set_class_info_reply *req )
{
    fprintf( stderr, " old_atom=%04x", req->old_atom );
    fprintf( stderr, ", base_atom=%04x", req->base_atom );
    dump_uint64( ", old_instance=", &req->old_instance );
    dump_uint64( ", old_extra_value=", &req->old_extra_value );
    fprintf( stderr, ", old_style=%08x", req->old_style );
    fprintf( stderr, ", old_extra=%d", req->old_extra );
    fprintf( stderr, ", old_win_extra=%d", req->old_win_extra );
}

static void dump_open_clipboard_request( const struct open_clipboard_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
}

static void dump_open_clipboard_reply( const struct open_clipboard_reply *req )
{
    fprintf( stderr, " owner=%08x", req->owner );
}

static void dump_close_clipboard_request( const struct close_clipboard_request *req )
{
}

static void dump_close_clipboard_reply( const struct close_clipboard_reply *req )
{
    fprintf( stderr, " viewer=%08x", req->viewer );
    fprintf( stderr, ", owner=%08x", req->owner );
}

static void dump_empty_clipboard_request( const struct empty_clipboard_request *req )
{
}

static void dump_set_clipboard_data_request( const struct set_clipboard_data_request *req )
{
    fprintf( stderr, " format=%08x", req->format );
    fprintf( stderr, ", lcid=%08x", req->lcid );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_set_clipboard_data_reply( const struct set_clipboard_data_reply *req )
{
    fprintf( stderr, " seqno=%08x", req->seqno );
}

static void dump_get_clipboard_data_request( const struct get_clipboard_data_request *req )
{
    fprintf( stderr, " format=%08x", req->format );
    fprintf( stderr, ", render=%d", req->render );
    fprintf( stderr, ", cached=%d", req->cached );
    fprintf( stderr, ", seqno=%08x", req->seqno );
}

static void dump_get_clipboard_data_reply( const struct get_clipboard_data_reply *req )
{
    fprintf( stderr, " from=%08x", req->from );
    fprintf( stderr, ", owner=%08x", req->owner );
    fprintf( stderr, ", seqno=%08x", req->seqno );
    fprintf( stderr, ", total=%u", req->total );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_get_clipboard_formats_request( const struct get_clipboard_formats_request *req )
{
    fprintf( stderr, " format=%08x", req->format );
}

static void dump_get_clipboard_formats_reply( const struct get_clipboard_formats_reply *req )
{
    fprintf( stderr, " count=%08x", req->count );
    dump_varargs_uints( ", formats=", cur_size );
}

static void dump_enum_clipboard_formats_request( const struct enum_clipboard_formats_request *req )
{
    fprintf( stderr, " previous=%08x", req->previous );
}

static void dump_enum_clipboard_formats_reply( const struct enum_clipboard_formats_reply *req )
{
    fprintf( stderr, " format=%08x", req->format );
}

static void dump_release_clipboard_request( const struct release_clipboard_request *req )
{
    fprintf( stderr, " owner=%08x", req->owner );
}

static void dump_release_clipboard_reply( const struct release_clipboard_reply *req )
{
    fprintf( stderr, " viewer=%08x", req->viewer );
    fprintf( stderr, ", owner=%08x", req->owner );
}

static void dump_get_clipboard_info_request( const struct get_clipboard_info_request *req )
{
}

static void dump_get_clipboard_info_reply( const struct get_clipboard_info_reply *req )
{
    fprintf( stderr, " window=%08x", req->window );
    fprintf( stderr, ", owner=%08x", req->owner );
    fprintf( stderr, ", viewer=%08x", req->viewer );
    fprintf( stderr, ", seqno=%08x", req->seqno );
}

static void dump_set_clipboard_viewer_request( const struct set_clipboard_viewer_request *req )
{
    fprintf( stderr, " viewer=%08x", req->viewer );
    fprintf( stderr, ", previous=%08x", req->previous );
}

static void dump_set_clipboard_viewer_reply( const struct set_clipboard_viewer_reply *req )
{
    fprintf( stderr, " old_viewer=%08x", req->old_viewer );
    fprintf( stderr, ", owner=%08x", req->owner );
}

static void dump_add_clipboard_listener_request( const struct add_clipboard_listener_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
}

static void dump_remove_clipboard_listener_request( const struct remove_clipboard_listener_request *req )
{
    fprintf( stderr, " window=%08x", req->window );
}

static void dump_create_token_request( const struct create_token_request *req )
{
    dump_luid( " token_id=", &req->token_id );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", primary=%d", req->primary );
    fprintf( stderr, ", impersonation_level=%d", req->impersonation_level );
    dump_abstime( ", expire=", &req->expire );
    fprintf( stderr, ", group_count=%d", req->group_count );
    fprintf( stderr, ", primary_group=%d", req->primary_group );
    fprintf( stderr, ", priv_count=%d", req->priv_count );
}

static void dump_create_token_reply( const struct create_token_reply *req )
{
    fprintf( stderr, " token=%04x", req->token );
}

static void dump_open_token_request( const struct open_token_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_open_token_reply( const struct open_token_reply *req )
{
    fprintf( stderr, " token=%04x", req->token );
}

static void dump_set_desktop_shell_windows_request( const struct set_desktop_shell_windows_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", shell_window=%08x", req->shell_window );
    fprintf( stderr, ", shell_listview=%08x", req->shell_listview );
    fprintf( stderr, ", progman_window=%08x", req->progman_window );
    fprintf( stderr, ", taskman_window=%08x", req->taskman_window );
}

static void dump_set_desktop_shell_windows_reply( const struct set_desktop_shell_windows_reply *req )
{
    fprintf( stderr, " old_shell_window=%08x", req->old_shell_window );
    fprintf( stderr, ", old_shell_listview=%08x", req->old_shell_listview );
    fprintf( stderr, ", old_progman_window=%08x", req->old_progman_window );
    fprintf( stderr, ", old_taskman_window=%08x", req->old_taskman_window );
}

static void dump_adjust_token_privileges_request( const struct adjust_token_privileges_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", disable_all=%d", req->disable_all );
    fprintf( stderr, ", get_modified_state=%d", req->get_modified_state );
    dump_varargs_luid_attr( ", privileges=", cur_size );
}

static void dump_adjust_token_privileges_reply( const struct adjust_token_privileges_reply *req )
{
    fprintf( stderr, " len=%08x", req->len );
    dump_varargs_luid_attr( ", privileges=", cur_size );
}

static void dump_get_token_privileges_request( const struct get_token_privileges_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_token_privileges_reply( const struct get_token_privileges_reply *req )
{
    fprintf( stderr, " len=%08x", req->len );
    dump_varargs_luid_attr( ", privileges=", cur_size );
}

static void dump_check_token_privileges_request( const struct check_token_privileges_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", all_required=%d", req->all_required );
    dump_varargs_luid_attr( ", privileges=", cur_size );
}

static void dump_check_token_privileges_reply( const struct check_token_privileges_reply *req )
{
    fprintf( stderr, " has_privileges=%d", req->has_privileges );
    dump_varargs_luid_attr( ", privileges=", cur_size );
}

static void dump_duplicate_token_request( const struct duplicate_token_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", primary=%d", req->primary );
    fprintf( stderr, ", impersonation_level=%d", req->impersonation_level );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_duplicate_token_reply( const struct duplicate_token_reply *req )
{
    fprintf( stderr, " new_handle=%04x", req->new_handle );
}

static void dump_filter_token_request( const struct filter_token_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%08x", req->flags );
    fprintf( stderr, ", privileges_size=%u", req->privileges_size );
    dump_varargs_luid_attr( ", privileges=", min( cur_size, req->privileges_size ));
    dump_varargs_sid( ", disable_sids=", cur_size );
}

static void dump_filter_token_reply( const struct filter_token_reply *req )
{
    fprintf( stderr, " new_handle=%04x", req->new_handle );
}

static void dump_access_check_request( const struct access_check_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", desired_access=%08x", req->desired_access );
    dump_generic_map( ", mapping=", &req->mapping );
    dump_varargs_security_descriptor( ", sd=", cur_size );
}

static void dump_access_check_reply( const struct access_check_reply *req )
{
    fprintf( stderr, " access_granted=%08x", req->access_granted );
    fprintf( stderr, ", access_status=%08x", req->access_status );
    fprintf( stderr, ", privileges_len=%08x", req->privileges_len );
    dump_varargs_luid_attr( ", privileges=", cur_size );
}

static void dump_get_token_sid_request( const struct get_token_sid_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", which_sid=%08x", req->which_sid );
}

static void dump_get_token_sid_reply( const struct get_token_sid_reply *req )
{
    fprintf( stderr, " sid_len=%u", req->sid_len );
    dump_varargs_sid( ", sid=", cur_size );
}

static void dump_get_token_groups_request( const struct get_token_groups_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", attr_mask=%08x", req->attr_mask );
}

static void dump_get_token_groups_reply( const struct get_token_groups_reply *req )
{
    fprintf( stderr, " attr_len=%u", req->attr_len );
    fprintf( stderr, ", sid_len=%u", req->sid_len );
    dump_varargs_uints( ", attrs=", min( cur_size, req->attr_len ));
    dump_varargs_sids( ", sids=", cur_size );
}

static void dump_get_token_default_dacl_request( const struct get_token_default_dacl_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_token_default_dacl_reply( const struct get_token_default_dacl_reply *req )
{
    fprintf( stderr, " acl_len=%u", req->acl_len );
    dump_varargs_acl( ", acl=", cur_size );
}

static void dump_set_token_default_dacl_request( const struct set_token_default_dacl_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_varargs_acl( ", acl=", cur_size );
}

static void dump_set_security_object_request( const struct set_security_object_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", security_info=%08x", req->security_info );
    dump_varargs_security_descriptor( ", sd=", cur_size );
}

static void dump_get_security_object_request( const struct get_security_object_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", security_info=%08x", req->security_info );
}

static void dump_get_security_object_reply( const struct get_security_object_reply *req )
{
    fprintf( stderr, " sd_len=%08x", req->sd_len );
    dump_varargs_security_descriptor( ", sd=", cur_size );
}

static void dump_get_system_handles_request( const struct get_system_handles_request *req )
{
}

static void dump_get_system_handles_reply( const struct get_system_handles_reply *req )
{
    fprintf( stderr, " count=%08x", req->count );
    dump_varargs_handle_infos( ", data=", cur_size );
}

static void dump_get_tcp_connections_request( const struct get_tcp_connections_request *req )
{
    fprintf( stderr, " state_filter=%08x", req->state_filter );
}

static void dump_get_tcp_connections_reply( const struct get_tcp_connections_reply *req )
{
    fprintf( stderr, " count=%08x", req->count );
    dump_varargs_tcp_connections( ", connections=", cur_size );
}

static void dump_get_udp_endpoints_request( const struct get_udp_endpoints_request *req )
{
}

static void dump_get_udp_endpoints_reply( const struct get_udp_endpoints_reply *req )
{
    fprintf( stderr, " count=%08x", req->count );
    dump_varargs_udp_endpoints( ", endpoints=", cur_size );
}

static void dump_create_mailslot_request( const struct create_mailslot_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", options=%08x", req->options );
    dump_timeout( ", read_timeout=", &req->read_timeout );
    fprintf( stderr, ", max_msgsize=%08x", req->max_msgsize );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_mailslot_reply( const struct create_mailslot_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_mailslot_info_request( const struct set_mailslot_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_timeout( ", read_timeout=", &req->read_timeout );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_set_mailslot_info_reply( const struct set_mailslot_info_reply *req )
{
    dump_timeout( " read_timeout=", &req->read_timeout );
    fprintf( stderr, ", max_msgsize=%08x", req->max_msgsize );
}

static void dump_create_directory_request( const struct create_directory_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_directory_reply( const struct create_directory_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_directory_request( const struct open_directory_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", directory_name=", cur_size );
}

static void dump_open_directory_reply( const struct open_directory_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_directory_entries_request( const struct get_directory_entries_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", index=%08x", req->index );
    fprintf( stderr, ", max_count=%08x", req->max_count );
}

static void dump_get_directory_entries_reply( const struct get_directory_entries_reply *req )
{
    fprintf( stderr, " total_len=%u", req->total_len );
    fprintf( stderr, ", count=%08x", req->count );
    dump_varargs_directory_entries( ", entries=", cur_size );
}

static void dump_create_symlink_request( const struct create_symlink_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    dump_varargs_object_attributes( ", objattr=", cur_size );
    dump_varargs_unicode_str( ", target_name=", cur_size );
}

static void dump_create_symlink_reply( const struct create_symlink_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_symlink_request( const struct open_symlink_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_symlink_reply( const struct open_symlink_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_query_symlink_request( const struct query_symlink_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_query_symlink_reply( const struct query_symlink_reply *req )
{
    fprintf( stderr, " total=%u", req->total );
    dump_varargs_unicode_str( ", target_name=", cur_size );
}

static void dump_get_object_info_request( const struct get_object_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_object_info_reply( const struct get_object_info_reply *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", ref_count=%08x", req->ref_count );
    fprintf( stderr, ", handle_count=%08x", req->handle_count );
}

static void dump_get_object_name_request( const struct get_object_name_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_object_name_reply( const struct get_object_name_reply *req )
{
    fprintf( stderr, " total=%u", req->total );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_get_object_type_request( const struct get_object_type_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_object_type_reply( const struct get_object_type_reply *req )
{
    dump_varargs_object_type_info( " info=", cur_size );
}

static void dump_get_object_types_request( const struct get_object_types_request *req )
{
}

static void dump_get_object_types_reply( const struct get_object_types_reply *req )
{
    fprintf( stderr, " count=%d", req->count );
    dump_varargs_object_types_info( ", info=", cur_size );
}

static void dump_allocate_locally_unique_id_request( const struct allocate_locally_unique_id_request *req )
{
}

static void dump_allocate_locally_unique_id_reply( const struct allocate_locally_unique_id_reply *req )
{
    dump_luid( " luid=", &req->luid );
}

static void dump_create_device_manager_request( const struct create_device_manager_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
}

static void dump_create_device_manager_reply( const struct create_device_manager_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_create_device_request( const struct create_device_request *req )
{
    fprintf( stderr, " rootdir=%04x", req->rootdir );
    dump_uint64( ", user_ptr=", &req->user_ptr );
    fprintf( stderr, ", manager=%04x", req->manager );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_delete_device_request( const struct delete_device_request *req )
{
    fprintf( stderr, " manager=%04x", req->manager );
    dump_uint64( ", device=", &req->device );
}

static void dump_get_next_device_request_request( const struct get_next_device_request_request *req )
{
    fprintf( stderr, " manager=%04x", req->manager );
    fprintf( stderr, ", prev=%04x", req->prev );
    fprintf( stderr, ", status=%08x", req->status );
    dump_uint64( ", user_ptr=", &req->user_ptr );
    fprintf( stderr, ", pending=%d", req->pending );
    fprintf( stderr, ", iosb_status=%08x", req->iosb_status );
    fprintf( stderr, ", result=%u", req->result );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_get_next_device_request_reply( const struct get_next_device_request_reply *req )
{
    dump_irp_params( " params=", &req->params );
    fprintf( stderr, ", next=%04x", req->next );
    fprintf( stderr, ", client_tid=%04x", req->client_tid );
    dump_uint64( ", client_thread=", &req->client_thread );
    fprintf( stderr, ", in_size=%u", req->in_size );
    dump_varargs_bytes( ", next_data=", cur_size );
}

static void dump_get_kernel_object_ptr_request( const struct get_kernel_object_ptr_request *req )
{
    fprintf( stderr, " manager=%04x", req->manager );
    fprintf( stderr, ", handle=%04x", req->handle );
}

static void dump_get_kernel_object_ptr_reply( const struct get_kernel_object_ptr_reply *req )
{
    dump_uint64( " user_ptr=", &req->user_ptr );
}

static void dump_set_kernel_object_ptr_request( const struct set_kernel_object_ptr_request *req )
{
    fprintf( stderr, " manager=%04x", req->manager );
    fprintf( stderr, ", handle=%04x", req->handle );
    dump_uint64( ", user_ptr=", &req->user_ptr );
}

static void dump_grab_kernel_object_request( const struct grab_kernel_object_request *req )
{
    fprintf( stderr, " manager=%04x", req->manager );
    dump_uint64( ", user_ptr=", &req->user_ptr );
}

static void dump_release_kernel_object_request( const struct release_kernel_object_request *req )
{
    fprintf( stderr, " manager=%04x", req->manager );
    dump_uint64( ", user_ptr=", &req->user_ptr );
}

static void dump_get_kernel_object_handle_request( const struct get_kernel_object_handle_request *req )
{
    fprintf( stderr, " manager=%04x", req->manager );
    dump_uint64( ", user_ptr=", &req->user_ptr );
    fprintf( stderr, ", access=%08x", req->access );
}

static void dump_get_kernel_object_handle_reply( const struct get_kernel_object_handle_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_make_process_system_request( const struct make_process_system_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_make_process_system_reply( const struct make_process_system_reply *req )
{
    fprintf( stderr, " event=%04x", req->event );
}

static void dump_grant_process_admin_token_request( const struct grant_process_admin_token_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_token_info_request( const struct get_token_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_token_info_reply( const struct get_token_info_reply *req )
{
    dump_luid( " token_id=", &req->token_id );
    dump_luid( ", modified_id=", &req->modified_id );
    fprintf( stderr, ", session_id=%08x", req->session_id );
    fprintf( stderr, ", primary=%d", req->primary );
    fprintf( stderr, ", impersonation_level=%d", req->impersonation_level );
    fprintf( stderr, ", elevation_type=%d", req->elevation_type );
    fprintf( stderr, ", is_elevated=%d", req->is_elevated );
    fprintf( stderr, ", group_count=%d", req->group_count );
    fprintf( stderr, ", privilege_count=%d", req->privilege_count );
}

static void dump_create_linked_token_request( const struct create_linked_token_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_create_linked_token_reply( const struct create_linked_token_reply *req )
{
    fprintf( stderr, " linked=%04x", req->linked );
}

static void dump_create_completion_request( const struct create_completion_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", concurrent=%08x", req->concurrent );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_completion_reply( const struct create_completion_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_completion_request( const struct open_completion_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", filename=", cur_size );
}

static void dump_open_completion_reply( const struct open_completion_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_add_completion_request( const struct add_completion_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", ckey=", &req->ckey );
    dump_uint64( ", cvalue=", &req->cvalue );
    dump_uint64( ", information=", &req->information );
    fprintf( stderr, ", reserve_handle=%04x", req->reserve_handle );
    fprintf( stderr, ", status=%08x", req->status );
}

static void dump_remove_completion_request( const struct remove_completion_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", alertable=%d", req->alertable );
}

static void dump_remove_completion_reply( const struct remove_completion_reply *req )
{
    dump_uint64( " ckey=", &req->ckey );
    dump_uint64( ", cvalue=", &req->cvalue );
    dump_uint64( ", information=", &req->information );
    fprintf( stderr, ", status=%08x", req->status );
    fprintf( stderr, ", wait_handle=%04x", req->wait_handle );
}

static void dump_get_thread_completion_request( const struct get_thread_completion_request *req )
{
}

static void dump_get_thread_completion_reply( const struct get_thread_completion_reply *req )
{
    dump_uint64( " ckey=", &req->ckey );
    dump_uint64( ", cvalue=", &req->cvalue );
    dump_uint64( ", information=", &req->information );
    fprintf( stderr, ", status=%08x", req->status );
}

static void dump_query_completion_request( const struct query_completion_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_query_completion_reply( const struct query_completion_reply *req )
{
    fprintf( stderr, " depth=%08x", req->depth );
}

static void dump_set_completion_info_request( const struct set_completion_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", ckey=", &req->ckey );
    fprintf( stderr, ", chandle=%04x", req->chandle );
}

static void dump_add_fd_completion_request( const struct add_fd_completion_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", cvalue=", &req->cvalue );
    dump_uint64( ", information=", &req->information );
    fprintf( stderr, ", status=%08x", req->status );
    fprintf( stderr, ", async=%d", req->async );
}

static void dump_set_fd_completion_mode_request( const struct set_fd_completion_mode_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_set_fd_disp_info_request( const struct set_fd_disp_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_set_fd_name_info_request( const struct set_fd_name_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    fprintf( stderr, ", namelen=%u", req->namelen );
    fprintf( stderr, ", link=%d", req->link );
    fprintf( stderr, ", flags=%08x", req->flags );
    dump_varargs_unicode_str( ", name=", min( cur_size, req->namelen ));
    dump_varargs_string( ", filename=", cur_size );
}

static void dump_set_fd_eof_info_request( const struct set_fd_eof_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    dump_uint64( ", eof=", &req->eof );
}

static void dump_get_window_layered_info_request( const struct get_window_layered_info_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_get_window_layered_info_reply( const struct get_window_layered_info_reply *req )
{
    fprintf( stderr, " color_key=%08x", req->color_key );
    fprintf( stderr, ", alpha=%08x", req->alpha );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_set_window_layered_info_request( const struct set_window_layered_info_request *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
    fprintf( stderr, ", color_key=%08x", req->color_key );
    fprintf( stderr, ", alpha=%08x", req->alpha );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_alloc_user_handle_request( const struct alloc_user_handle_request *req )
{
    fprintf( stderr, " type=%04x", req->type );
}

static void dump_alloc_user_handle_reply( const struct alloc_user_handle_reply *req )
{
    fprintf( stderr, " handle=%08x", req->handle );
}

static void dump_free_user_handle_request( const struct free_user_handle_request *req )
{
    fprintf( stderr, " type=%04x", req->type );
    fprintf( stderr, ", handle=%08x", req->handle );
}

static void dump_set_cursor_request( const struct set_cursor_request *req )
{
    fprintf( stderr, " flags=%08x", req->flags );
    fprintf( stderr, ", handle=%08x", req->handle );
    fprintf( stderr, ", show_count=%d", req->show_count );
    fprintf( stderr, ", x=%d", req->x );
    fprintf( stderr, ", y=%d", req->y );
    dump_rectangle( ", clip=", &req->clip );
}

static void dump_set_cursor_reply( const struct set_cursor_reply *req )
{
    fprintf( stderr, " prev_handle=%08x", req->prev_handle );
    fprintf( stderr, ", prev_count=%d", req->prev_count );
    fprintf( stderr, ", prev_x=%d", req->prev_x );
    fprintf( stderr, ", prev_y=%d", req->prev_y );
    fprintf( stderr, ", new_x=%d", req->new_x );
    fprintf( stderr, ", new_y=%d", req->new_y );
    dump_rectangle( ", new_clip=", &req->new_clip );
    fprintf( stderr, ", last_change=%08x", req->last_change );
}

static void dump_get_cursor_history_request( const struct get_cursor_history_request *req )
{
}

static void dump_get_cursor_history_reply( const struct get_cursor_history_reply *req )
{
    dump_varargs_cursor_positions( " history=", cur_size );
}

static void dump_get_rawinput_buffer_request( const struct get_rawinput_buffer_request *req )
{
    fprintf( stderr, " header_size=%u", req->header_size );
    fprintf( stderr, ", read_data=%d", req->read_data );
}

static void dump_get_rawinput_buffer_reply( const struct get_rawinput_buffer_reply *req )
{
    fprintf( stderr, " next_size=%u", req->next_size );
    fprintf( stderr, ", time=%08x", req->time );
    fprintf( stderr, ", count=%08x", req->count );
    dump_varargs_bytes( ", data=", cur_size );
}

static void dump_update_rawinput_devices_request( const struct update_rawinput_devices_request *req )
{
    dump_varargs_rawinput_devices( " devices=", cur_size );
}

static void dump_create_job_request( const struct create_job_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    dump_varargs_object_attributes( ", objattr=", cur_size );
}

static void dump_create_job_reply( const struct create_job_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_open_job_request( const struct open_job_request *req )
{
    fprintf( stderr, " access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", rootdir=%04x", req->rootdir );
    dump_varargs_unicode_str( ", name=", cur_size );
}

static void dump_open_job_reply( const struct open_job_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_assign_job_request( const struct assign_job_request *req )
{
    fprintf( stderr, " job=%04x", req->job );
    fprintf( stderr, ", process=%04x", req->process );
}

static void dump_process_in_job_request( const struct process_in_job_request *req )
{
    fprintf( stderr, " job=%04x", req->job );
    fprintf( stderr, ", process=%04x", req->process );
}

static void dump_set_job_limits_request( const struct set_job_limits_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", limit_flags=%08x", req->limit_flags );
}

static void dump_set_job_completion_port_request( const struct set_job_completion_port_request *req )
{
    fprintf( stderr, " job=%04x", req->job );
    fprintf( stderr, ", port=%04x", req->port );
    dump_uint64( ", key=", &req->key );
}

static void dump_get_job_info_request( const struct get_job_info_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_job_info_reply( const struct get_job_info_reply *req )
{
    fprintf( stderr, " total_processes=%d", req->total_processes );
    fprintf( stderr, ", active_processes=%d", req->active_processes );
    dump_varargs_uints( ", pids=", cur_size );
}

static void dump_terminate_job_request( const struct terminate_job_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
    fprintf( stderr, ", status=%d", req->status );
}

static void dump_suspend_process_request( const struct suspend_process_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_resume_process_request( const struct resume_process_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_next_process_request( const struct get_next_process_request *req )
{
    fprintf( stderr, " last=%04x", req->last );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_get_next_process_reply( const struct get_next_process_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_next_thread_request( const struct get_next_thread_request *req )
{
    fprintf( stderr, " process=%04x", req->process );
    fprintf( stderr, ", last=%04x", req->last );
    fprintf( stderr, ", access=%08x", req->access );
    fprintf( stderr, ", attributes=%08x", req->attributes );
    fprintf( stderr, ", flags=%08x", req->flags );
}

static void dump_get_next_thread_reply( const struct get_next_thread_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_set_keyboard_repeat_request( const struct set_keyboard_repeat_request *req )
{
    fprintf( stderr, " enable=%d", req->enable );
    fprintf( stderr, ", delay=%d", req->delay );
    fprintf( stderr, ", period=%d", req->period );
}

static void dump_set_keyboard_repeat_reply( const struct set_keyboard_repeat_reply *req )
{
    fprintf( stderr, " enable=%d", req->enable );
}

static void dump_get_linux_sync_device_request( const struct get_linux_sync_device_request *req )
{
}

static void dump_get_linux_sync_obj_request( const struct get_linux_sync_obj_request *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

static void dump_get_linux_sync_obj_reply( const struct get_linux_sync_obj_reply *req )
{
    fprintf( stderr, " type=%d", req->type );
    fprintf( stderr, ", access=%08x", req->access );
}

static void dump_select_inproc_queue_request( const struct select_inproc_queue_request *req )
{
}

static void dump_unselect_inproc_queue_request( const struct unselect_inproc_queue_request *req )
{
    fprintf( stderr, " signaled=%d", req->signaled );
}

static void dump_get_inproc_alert_event_request( const struct get_inproc_alert_event_request *req )
{
}

static void dump_get_inproc_alert_event_reply( const struct get_inproc_alert_event_reply *req )
{
    fprintf( stderr, " handle=%04x", req->handle );
}

typedef void (*dump_func)( const void *req );

static const dump_func req_dumpers[REQ_NB_REQUESTS] =
{
    (dump_func)dump_new_process_request,
    (dump_func)dump_get_new_process_info_request,
    (dump_func)dump_new_thread_request,
    (dump_func)dump_get_startup_info_request,
    (dump_func)dump_init_process_done_request,
    (dump_func)dump_init_first_thread_request,
    (dump_func)dump_init_thread_request,
    (dump_func)dump_terminate_process_request,
    (dump_func)dump_terminate_thread_request,
    (dump_func)dump_get_process_info_request,
    (dump_func)dump_get_process_debug_info_request,
    (dump_func)dump_get_process_image_name_request,
    (dump_func)dump_get_process_vm_counters_request,
    (dump_func)dump_set_process_info_request,
    (dump_func)dump_get_thread_info_request,
    (dump_func)dump_get_thread_times_request,
    (dump_func)dump_set_thread_info_request,
    (dump_func)dump_suspend_thread_request,
    (dump_func)dump_resume_thread_request,
    (dump_func)dump_queue_apc_request,
    (dump_func)dump_get_apc_result_request,
    (dump_func)dump_close_handle_request,
    (dump_func)dump_set_handle_info_request,
    (dump_func)dump_dup_handle_request,
    (dump_func)dump_allocate_reserve_object_request,
    (dump_func)dump_compare_objects_request,
    (dump_func)dump_set_object_permanence_request,
    (dump_func)dump_open_process_request,
    (dump_func)dump_open_thread_request,
    (dump_func)dump_select_request,
    (dump_func)dump_create_event_request,
    (dump_func)dump_event_op_request,
    (dump_func)dump_query_event_request,
    (dump_func)dump_open_event_request,
    (dump_func)dump_create_keyed_event_request,
    (dump_func)dump_open_keyed_event_request,
    (dump_func)dump_create_mutex_request,
    (dump_func)dump_release_mutex_request,
    (dump_func)dump_open_mutex_request,
    (dump_func)dump_query_mutex_request,
    (dump_func)dump_create_semaphore_request,
    (dump_func)dump_release_semaphore_request,
    (dump_func)dump_query_semaphore_request,
    (dump_func)dump_open_semaphore_request,
    (dump_func)dump_create_file_request,
    (dump_func)dump_open_file_object_request,
    (dump_func)dump_alloc_file_handle_request,
    (dump_func)dump_get_handle_unix_name_request,
    (dump_func)dump_get_handle_fd_request,
    (dump_func)dump_get_directory_cache_entry_request,
    (dump_func)dump_flush_request,
    (dump_func)dump_get_file_info_request,
    (dump_func)dump_get_volume_info_request,
    (dump_func)dump_lock_file_request,
    (dump_func)dump_unlock_file_request,
    (dump_func)dump_recv_socket_request,
    (dump_func)dump_send_socket_request,
    (dump_func)dump_socket_get_events_request,
    (dump_func)dump_socket_send_icmp_id_request,
    (dump_func)dump_socket_get_icmp_id_request,
    (dump_func)dump_get_next_console_request_request,
    (dump_func)dump_read_directory_changes_request,
    (dump_func)dump_read_change_request,
    (dump_func)dump_create_mapping_request,
    (dump_func)dump_open_mapping_request,
    (dump_func)dump_get_mapping_info_request,
    (dump_func)dump_get_image_map_address_request,
    (dump_func)dump_map_view_request,
    (dump_func)dump_map_image_view_request,
    (dump_func)dump_map_builtin_view_request,
    (dump_func)dump_get_image_view_info_request,
    (dump_func)dump_unmap_view_request,
    (dump_func)dump_get_mapping_committed_range_request,
    (dump_func)dump_add_mapping_committed_range_request,
    (dump_func)dump_is_same_mapping_request,
    (dump_func)dump_get_mapping_filename_request,
    (dump_func)dump_list_processes_request,
    (dump_func)dump_create_debug_obj_request,
    (dump_func)dump_wait_debug_event_request,
    (dump_func)dump_queue_exception_event_request,
    (dump_func)dump_get_exception_status_request,
    (dump_func)dump_continue_debug_event_request,
    (dump_func)dump_debug_process_request,
    (dump_func)dump_set_debug_obj_info_request,
    (dump_func)dump_read_process_memory_request,
    (dump_func)dump_write_process_memory_request,
    (dump_func)dump_create_key_request,
    (dump_func)dump_open_key_request,
    (dump_func)dump_delete_key_request,
    (dump_func)dump_flush_key_request,
    (dump_func)dump_enum_key_request,
    (dump_func)dump_set_key_value_request,
    (dump_func)dump_get_key_value_request,
    (dump_func)dump_enum_key_value_request,
    (dump_func)dump_delete_key_value_request,
    (dump_func)dump_load_registry_request,
    (dump_func)dump_unload_registry_request,
    (dump_func)dump_save_registry_request,
    (dump_func)dump_set_registry_notification_request,
    (dump_func)dump_rename_key_request,
    (dump_func)dump_create_timer_request,
    (dump_func)dump_open_timer_request,
    (dump_func)dump_set_timer_request,
    (dump_func)dump_cancel_timer_request,
    (dump_func)dump_get_timer_info_request,
    (dump_func)dump_get_thread_context_request,
    (dump_func)dump_set_thread_context_request,
    (dump_func)dump_get_selector_entry_request,
    (dump_func)dump_add_atom_request,
    (dump_func)dump_delete_atom_request,
    (dump_func)dump_find_atom_request,
    (dump_func)dump_get_atom_information_request,
    (dump_func)dump_get_msg_queue_handle_request,
    (dump_func)dump_get_msg_queue_request,
    (dump_func)dump_set_queue_fd_request,
    (dump_func)dump_set_queue_mask_request,
    (dump_func)dump_get_queue_status_request,
    (dump_func)dump_get_process_idle_event_request,
    (dump_func)dump_send_message_request,
    (dump_func)dump_post_quit_message_request,
    (dump_func)dump_send_hardware_message_request,
    (dump_func)dump_get_message_request,
    (dump_func)dump_reply_message_request,
    (dump_func)dump_accept_hardware_message_request,
    (dump_func)dump_get_message_reply_request,
    (dump_func)dump_set_win_timer_request,
    (dump_func)dump_kill_win_timer_request,
    (dump_func)dump_is_window_hung_request,
    (dump_func)dump_get_serial_info_request,
    (dump_func)dump_set_serial_info_request,
    (dump_func)dump_cancel_sync_request,
    (dump_func)dump_register_async_request,
    (dump_func)dump_cancel_async_request,
    (dump_func)dump_get_async_result_request,
    (dump_func)dump_set_async_direct_result_request,
    (dump_func)dump_read_request,
    (dump_func)dump_write_request,
    (dump_func)dump_ioctl_request,
    (dump_func)dump_set_irp_result_request,
    (dump_func)dump_create_named_pipe_request,
    (dump_func)dump_set_named_pipe_info_request,
    (dump_func)dump_create_window_request,
    (dump_func)dump_destroy_window_request,
    (dump_func)dump_get_desktop_window_request,
    (dump_func)dump_set_window_owner_request,
    (dump_func)dump_get_window_info_request,
    (dump_func)dump_init_window_info_request,
    (dump_func)dump_set_window_info_request,
    (dump_func)dump_set_parent_request,
    (dump_func)dump_get_window_parents_request,
    (dump_func)dump_get_window_list_request,
    (dump_func)dump_get_class_windows_request,
    (dump_func)dump_get_window_children_from_point_request,
    (dump_func)dump_get_window_tree_request,
    (dump_func)dump_set_window_pos_request,
    (dump_func)dump_get_window_rectangles_request,
    (dump_func)dump_get_window_text_request,
    (dump_func)dump_set_window_text_request,
    (dump_func)dump_get_windows_offset_request,
    (dump_func)dump_get_visible_region_request,
    (dump_func)dump_get_window_region_request,
    (dump_func)dump_set_window_region_request,
    (dump_func)dump_get_update_region_request,
    (dump_func)dump_update_window_zorder_request,
    (dump_func)dump_redraw_window_request,
    (dump_func)dump_set_window_property_request,
    (dump_func)dump_remove_window_property_request,
    (dump_func)dump_get_window_property_request,
    (dump_func)dump_get_window_properties_request,
    (dump_func)dump_create_winstation_request,
    (dump_func)dump_open_winstation_request,
    (dump_func)dump_close_winstation_request,
    (dump_func)dump_set_winstation_monitors_request,
    (dump_func)dump_get_process_winstation_request,
    (dump_func)dump_set_process_winstation_request,
    (dump_func)dump_enum_winstation_request,
    (dump_func)dump_create_desktop_request,
    (dump_func)dump_open_desktop_request,
    (dump_func)dump_open_input_desktop_request,
    (dump_func)dump_set_input_desktop_request,
    (dump_func)dump_close_desktop_request,
    (dump_func)dump_get_thread_desktop_request,
    (dump_func)dump_set_thread_desktop_request,
    (dump_func)dump_set_user_object_info_request,
    (dump_func)dump_register_hotkey_request,
    (dump_func)dump_unregister_hotkey_request,
    (dump_func)dump_attach_thread_input_request,
    (dump_func)dump_get_thread_input_request,
    (dump_func)dump_get_last_input_time_request,
    (dump_func)dump_get_key_state_request,
    (dump_func)dump_set_key_state_request,
    (dump_func)dump_set_foreground_window_request,
    (dump_func)dump_set_focus_window_request,
    (dump_func)dump_set_active_window_request,
    (dump_func)dump_set_capture_window_request,
    (dump_func)dump_set_caret_window_request,
    (dump_func)dump_set_caret_info_request,
    (dump_func)dump_set_hook_request,
    (dump_func)dump_remove_hook_request,
    (dump_func)dump_start_hook_chain_request,
    (dump_func)dump_finish_hook_chain_request,
    (dump_func)dump_get_hook_info_request,
    (dump_func)dump_create_class_request,
    (dump_func)dump_destroy_class_request,
    (dump_func)dump_set_class_info_request,
    (dump_func)dump_open_clipboard_request,
    (dump_func)dump_close_clipboard_request,
    (dump_func)dump_empty_clipboard_request,
    (dump_func)dump_set_clipboard_data_request,
    (dump_func)dump_get_clipboard_data_request,
    (dump_func)dump_get_clipboard_formats_request,
    (dump_func)dump_enum_clipboard_formats_request,
    (dump_func)dump_release_clipboard_request,
    (dump_func)dump_get_clipboard_info_request,
    (dump_func)dump_set_clipboard_viewer_request,
    (dump_func)dump_add_clipboard_listener_request,
    (dump_func)dump_remove_clipboard_listener_request,
    (dump_func)dump_create_token_request,
    (dump_func)dump_open_token_request,
    (dump_func)dump_set_desktop_shell_windows_request,
    (dump_func)dump_adjust_token_privileges_request,
    (dump_func)dump_get_token_privileges_request,
    (dump_func)dump_check_token_privileges_request,
    (dump_func)dump_duplicate_token_request,
    (dump_func)dump_filter_token_request,
    (dump_func)dump_access_check_request,
    (dump_func)dump_get_token_sid_request,
    (dump_func)dump_get_token_groups_request,
    (dump_func)dump_get_token_default_dacl_request,
    (dump_func)dump_set_token_default_dacl_request,
    (dump_func)dump_set_security_object_request,
    (dump_func)dump_get_security_object_request,
    (dump_func)dump_get_system_handles_request,
    (dump_func)dump_get_tcp_connections_request,
    (dump_func)dump_get_udp_endpoints_request,
    (dump_func)dump_create_mailslot_request,
    (dump_func)dump_set_mailslot_info_request,
    (dump_func)dump_create_directory_request,
    (dump_func)dump_open_directory_request,
    (dump_func)dump_get_directory_entries_request,
    (dump_func)dump_create_symlink_request,
    (dump_func)dump_open_symlink_request,
    (dump_func)dump_query_symlink_request,
    (dump_func)dump_get_object_info_request,
    (dump_func)dump_get_object_name_request,
    (dump_func)dump_get_object_type_request,
    (dump_func)dump_get_object_types_request,
    (dump_func)dump_allocate_locally_unique_id_request,
    (dump_func)dump_create_device_manager_request,
    (dump_func)dump_create_device_request,
    (dump_func)dump_delete_device_request,
    (dump_func)dump_get_next_device_request_request,
    (dump_func)dump_get_kernel_object_ptr_request,
    (dump_func)dump_set_kernel_object_ptr_request,
    (dump_func)dump_grab_kernel_object_request,
    (dump_func)dump_release_kernel_object_request,
    (dump_func)dump_get_kernel_object_handle_request,
    (dump_func)dump_make_process_system_request,
    (dump_func)dump_grant_process_admin_token_request,
    (dump_func)dump_get_token_info_request,
    (dump_func)dump_create_linked_token_request,
    (dump_func)dump_create_completion_request,
    (dump_func)dump_open_completion_request,
    (dump_func)dump_add_completion_request,
    (dump_func)dump_remove_completion_request,
    (dump_func)dump_get_thread_completion_request,
    (dump_func)dump_query_completion_request,
    (dump_func)dump_set_completion_info_request,
    (dump_func)dump_add_fd_completion_request,
    (dump_func)dump_set_fd_completion_mode_request,
    (dump_func)dump_set_fd_disp_info_request,
    (dump_func)dump_set_fd_name_info_request,
    (dump_func)dump_set_fd_eof_info_request,
    (dump_func)dump_get_window_layered_info_request,
    (dump_func)dump_set_window_layered_info_request,
    (dump_func)dump_alloc_user_handle_request,
    (dump_func)dump_free_user_handle_request,
    (dump_func)dump_set_cursor_request,
    (dump_func)dump_get_cursor_history_request,
    (dump_func)dump_get_rawinput_buffer_request,
    (dump_func)dump_update_rawinput_devices_request,
    (dump_func)dump_create_job_request,
    (dump_func)dump_open_job_request,
    (dump_func)dump_assign_job_request,
    (dump_func)dump_process_in_job_request,
    (dump_func)dump_set_job_limits_request,
    (dump_func)dump_set_job_completion_port_request,
    (dump_func)dump_get_job_info_request,
    (dump_func)dump_terminate_job_request,
    (dump_func)dump_suspend_process_request,
    (dump_func)dump_resume_process_request,
    (dump_func)dump_get_next_process_request,
    (dump_func)dump_get_next_thread_request,
    (dump_func)dump_set_keyboard_repeat_request,
    (dump_func)dump_get_linux_sync_device_request,
    (dump_func)dump_get_linux_sync_obj_request,
    (dump_func)dump_select_inproc_queue_request,
    (dump_func)dump_unselect_inproc_queue_request,
    (dump_func)dump_get_inproc_alert_event_request,
};

static const dump_func reply_dumpers[REQ_NB_REQUESTS] =
{
    (dump_func)dump_new_process_reply,
    (dump_func)dump_get_new_process_info_reply,
    (dump_func)dump_new_thread_reply,
    (dump_func)dump_get_startup_info_reply,
    (dump_func)dump_init_process_done_reply,
    (dump_func)dump_init_first_thread_reply,
    (dump_func)dump_init_thread_reply,
    (dump_func)dump_terminate_process_reply,
    (dump_func)dump_terminate_thread_reply,
    (dump_func)dump_get_process_info_reply,
    (dump_func)dump_get_process_debug_info_reply,
    (dump_func)dump_get_process_image_name_reply,
    (dump_func)dump_get_process_vm_counters_reply,
    NULL,
    (dump_func)dump_get_thread_info_reply,
    (dump_func)dump_get_thread_times_reply,
    NULL,
    (dump_func)dump_suspend_thread_reply,
    (dump_func)dump_resume_thread_reply,
    (dump_func)dump_queue_apc_reply,
    (dump_func)dump_get_apc_result_reply,
    NULL,
    (dump_func)dump_set_handle_info_reply,
    (dump_func)dump_dup_handle_reply,
    (dump_func)dump_allocate_reserve_object_reply,
    NULL,
    NULL,
    (dump_func)dump_open_process_reply,
    (dump_func)dump_open_thread_reply,
    (dump_func)dump_select_reply,
    (dump_func)dump_create_event_reply,
    (dump_func)dump_event_op_reply,
    (dump_func)dump_query_event_reply,
    (dump_func)dump_open_event_reply,
    (dump_func)dump_create_keyed_event_reply,
    (dump_func)dump_open_keyed_event_reply,
    (dump_func)dump_create_mutex_reply,
    (dump_func)dump_release_mutex_reply,
    (dump_func)dump_open_mutex_reply,
    (dump_func)dump_query_mutex_reply,
    (dump_func)dump_create_semaphore_reply,
    (dump_func)dump_release_semaphore_reply,
    (dump_func)dump_query_semaphore_reply,
    (dump_func)dump_open_semaphore_reply,
    (dump_func)dump_create_file_reply,
    (dump_func)dump_open_file_object_reply,
    (dump_func)dump_alloc_file_handle_reply,
    (dump_func)dump_get_handle_unix_name_reply,
    (dump_func)dump_get_handle_fd_reply,
    (dump_func)dump_get_directory_cache_entry_reply,
    (dump_func)dump_flush_reply,
    (dump_func)dump_get_file_info_reply,
    (dump_func)dump_get_volume_info_reply,
    (dump_func)dump_lock_file_reply,
    NULL,
    (dump_func)dump_recv_socket_reply,
    (dump_func)dump_send_socket_reply,
    (dump_func)dump_socket_get_events_reply,
    NULL,
    (dump_func)dump_socket_get_icmp_id_reply,
    (dump_func)dump_get_next_console_request_reply,
    NULL,
    (dump_func)dump_read_change_reply,
    (dump_func)dump_create_mapping_reply,
    (dump_func)dump_open_mapping_reply,
    (dump_func)dump_get_mapping_info_reply,
    (dump_func)dump_get_image_map_address_reply,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_get_image_view_info_reply,
    NULL,
    (dump_func)dump_get_mapping_committed_range_reply,
    NULL,
    NULL,
    (dump_func)dump_get_mapping_filename_reply,
    (dump_func)dump_list_processes_reply,
    (dump_func)dump_create_debug_obj_reply,
    (dump_func)dump_wait_debug_event_reply,
    (dump_func)dump_queue_exception_event_reply,
    NULL,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_read_process_memory_reply,
    NULL,
    (dump_func)dump_create_key_reply,
    (dump_func)dump_open_key_reply,
    NULL,
    NULL,
    (dump_func)dump_enum_key_reply,
    NULL,
    (dump_func)dump_get_key_value_reply,
    (dump_func)dump_enum_key_value_reply,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_create_timer_reply,
    (dump_func)dump_open_timer_reply,
    (dump_func)dump_set_timer_reply,
    (dump_func)dump_cancel_timer_reply,
    (dump_func)dump_get_timer_info_reply,
    (dump_func)dump_get_thread_context_reply,
    (dump_func)dump_set_thread_context_reply,
    (dump_func)dump_get_selector_entry_reply,
    (dump_func)dump_add_atom_reply,
    NULL,
    (dump_func)dump_find_atom_reply,
    (dump_func)dump_get_atom_information_reply,
    (dump_func)dump_get_msg_queue_handle_reply,
    (dump_func)dump_get_msg_queue_reply,
    NULL,
    (dump_func)dump_set_queue_mask_reply,
    (dump_func)dump_get_queue_status_reply,
    (dump_func)dump_get_process_idle_event_reply,
    NULL,
    NULL,
    (dump_func)dump_send_hardware_message_reply,
    (dump_func)dump_get_message_reply,
    NULL,
    NULL,
    (dump_func)dump_get_message_reply_reply,
    (dump_func)dump_set_win_timer_reply,
    NULL,
    (dump_func)dump_is_window_hung_reply,
    (dump_func)dump_get_serial_info_reply,
    NULL,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_get_async_result_reply,
    (dump_func)dump_set_async_direct_result_reply,
    (dump_func)dump_read_reply,
    (dump_func)dump_write_reply,
    (dump_func)dump_ioctl_reply,
    NULL,
    (dump_func)dump_create_named_pipe_reply,
    NULL,
    (dump_func)dump_create_window_reply,
    NULL,
    (dump_func)dump_get_desktop_window_reply,
    (dump_func)dump_set_window_owner_reply,
    (dump_func)dump_get_window_info_reply,
    NULL,
    (dump_func)dump_set_window_info_reply,
    (dump_func)dump_set_parent_reply,
    (dump_func)dump_get_window_parents_reply,
    (dump_func)dump_get_window_list_reply,
    (dump_func)dump_get_class_windows_reply,
    (dump_func)dump_get_window_children_from_point_reply,
    (dump_func)dump_get_window_tree_reply,
    (dump_func)dump_set_window_pos_reply,
    (dump_func)dump_get_window_rectangles_reply,
    (dump_func)dump_get_window_text_reply,
    NULL,
    (dump_func)dump_get_windows_offset_reply,
    (dump_func)dump_get_visible_region_reply,
    (dump_func)dump_get_window_region_reply,
    NULL,
    (dump_func)dump_get_update_region_reply,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_remove_window_property_reply,
    (dump_func)dump_get_window_property_reply,
    (dump_func)dump_get_window_properties_reply,
    (dump_func)dump_create_winstation_reply,
    (dump_func)dump_open_winstation_reply,
    NULL,
    (dump_func)dump_set_winstation_monitors_reply,
    (dump_func)dump_get_process_winstation_reply,
    NULL,
    (dump_func)dump_enum_winstation_reply,
    (dump_func)dump_create_desktop_reply,
    (dump_func)dump_open_desktop_reply,
    (dump_func)dump_open_input_desktop_reply,
    NULL,
    NULL,
    (dump_func)dump_get_thread_desktop_reply,
    (dump_func)dump_set_thread_desktop_reply,
    (dump_func)dump_set_user_object_info_reply,
    (dump_func)dump_register_hotkey_reply,
    (dump_func)dump_unregister_hotkey_reply,
    NULL,
    (dump_func)dump_get_thread_input_reply,
    (dump_func)dump_get_last_input_time_reply,
    (dump_func)dump_get_key_state_reply,
    NULL,
    (dump_func)dump_set_foreground_window_reply,
    (dump_func)dump_set_focus_window_reply,
    (dump_func)dump_set_active_window_reply,
    (dump_func)dump_set_capture_window_reply,
    (dump_func)dump_set_caret_window_reply,
    (dump_func)dump_set_caret_info_reply,
    (dump_func)dump_set_hook_reply,
    NULL,
    (dump_func)dump_start_hook_chain_reply,
    NULL,
    (dump_func)dump_get_hook_info_reply,
    (dump_func)dump_create_class_reply,
    (dump_func)dump_destroy_class_reply,
    (dump_func)dump_set_class_info_reply,
    (dump_func)dump_open_clipboard_reply,
    (dump_func)dump_close_clipboard_reply,
    NULL,
    (dump_func)dump_set_clipboard_data_reply,
    (dump_func)dump_get_clipboard_data_reply,
    (dump_func)dump_get_clipboard_formats_reply,
    (dump_func)dump_enum_clipboard_formats_reply,
    (dump_func)dump_release_clipboard_reply,
    (dump_func)dump_get_clipboard_info_reply,
    (dump_func)dump_set_clipboard_viewer_reply,
    NULL,
    NULL,
    (dump_func)dump_create_token_reply,
    (dump_func)dump_open_token_reply,
    (dump_func)dump_set_desktop_shell_windows_reply,
    (dump_func)dump_adjust_token_privileges_reply,
    (dump_func)dump_get_token_privileges_reply,
    (dump_func)dump_check_token_privileges_reply,
    (dump_func)dump_duplicate_token_reply,
    (dump_func)dump_filter_token_reply,
    (dump_func)dump_access_check_reply,
    (dump_func)dump_get_token_sid_reply,
    (dump_func)dump_get_token_groups_reply,
    (dump_func)dump_get_token_default_dacl_reply,
    NULL,
    NULL,
    (dump_func)dump_get_security_object_reply,
    (dump_func)dump_get_system_handles_reply,
    (dump_func)dump_get_tcp_connections_reply,
    (dump_func)dump_get_udp_endpoints_reply,
    (dump_func)dump_create_mailslot_reply,
    (dump_func)dump_set_mailslot_info_reply,
    (dump_func)dump_create_directory_reply,
    (dump_func)dump_open_directory_reply,
    (dump_func)dump_get_directory_entries_reply,
    (dump_func)dump_create_symlink_reply,
    (dump_func)dump_open_symlink_reply,
    (dump_func)dump_query_symlink_reply,
    (dump_func)dump_get_object_info_reply,
    (dump_func)dump_get_object_name_reply,
    (dump_func)dump_get_object_type_reply,
    (dump_func)dump_get_object_types_reply,
    (dump_func)dump_allocate_locally_unique_id_reply,
    (dump_func)dump_create_device_manager_reply,
    NULL,
    NULL,
    (dump_func)dump_get_next_device_request_reply,
    (dump_func)dump_get_kernel_object_ptr_reply,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_get_kernel_object_handle_reply,
    (dump_func)dump_make_process_system_reply,
    NULL,
    (dump_func)dump_get_token_info_reply,
    (dump_func)dump_create_linked_token_reply,
    (dump_func)dump_create_completion_reply,
    (dump_func)dump_open_completion_reply,
    NULL,
    (dump_func)dump_remove_completion_reply,
    (dump_func)dump_get_thread_completion_reply,
    (dump_func)dump_query_completion_reply,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_get_window_layered_info_reply,
    NULL,
    (dump_func)dump_alloc_user_handle_reply,
    NULL,
    (dump_func)dump_set_cursor_reply,
    (dump_func)dump_get_cursor_history_reply,
    (dump_func)dump_get_rawinput_buffer_reply,
    NULL,
    (dump_func)dump_create_job_reply,
    (dump_func)dump_open_job_reply,
    NULL,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_get_job_info_reply,
    NULL,
    NULL,
    NULL,
    (dump_func)dump_get_next_process_reply,
    (dump_func)dump_get_next_thread_reply,
    (dump_func)dump_set_keyboard_repeat_reply,
    NULL,
    (dump_func)dump_get_linux_sync_obj_reply,
    NULL,
    NULL,
    (dump_func)dump_get_inproc_alert_event_reply,
};

static const char * const req_names[REQ_NB_REQUESTS] =
{
    "new_process",
    "get_new_process_info",
    "new_thread",
    "get_startup_info",
    "init_process_done",
    "init_first_thread",
    "init_thread",
    "terminate_process",
    "terminate_thread",
    "get_process_info",
    "get_process_debug_info",
    "get_process_image_name",
    "get_process_vm_counters",
    "set_process_info",
    "get_thread_info",
    "get_thread_times",
    "set_thread_info",
    "suspend_thread",
    "resume_thread",
    "queue_apc",
    "get_apc_result",
    "close_handle",
    "set_handle_info",
    "dup_handle",
    "allocate_reserve_object",
    "compare_objects",
    "set_object_permanence",
    "open_process",
    "open_thread",
    "select",
    "create_event",
    "event_op",
    "query_event",
    "open_event",
    "create_keyed_event",
    "open_keyed_event",
    "create_mutex",
    "release_mutex",
    "open_mutex",
    "query_mutex",
    "create_semaphore",
    "release_semaphore",
    "query_semaphore",
    "open_semaphore",
    "create_file",
    "open_file_object",
    "alloc_file_handle",
    "get_handle_unix_name",
    "get_handle_fd",
    "get_directory_cache_entry",
    "flush",
    "get_file_info",
    "get_volume_info",
    "lock_file",
    "unlock_file",
    "recv_socket",
    "send_socket",
    "socket_get_events",
    "socket_send_icmp_id",
    "socket_get_icmp_id",
    "get_next_console_request",
    "read_directory_changes",
    "read_change",
    "create_mapping",
    "open_mapping",
    "get_mapping_info",
    "get_image_map_address",
    "map_view",
    "map_image_view",
    "map_builtin_view",
    "get_image_view_info",
    "unmap_view",
    "get_mapping_committed_range",
    "add_mapping_committed_range",
    "is_same_mapping",
    "get_mapping_filename",
    "list_processes",
    "create_debug_obj",
    "wait_debug_event",
    "queue_exception_event",
    "get_exception_status",
    "continue_debug_event",
    "debug_process",
    "set_debug_obj_info",
    "read_process_memory",
    "write_process_memory",
    "create_key",
    "open_key",
    "delete_key",
    "flush_key",
    "enum_key",
    "set_key_value",
    "get_key_value",
    "enum_key_value",
    "delete_key_value",
    "load_registry",
    "unload_registry",
    "save_registry",
    "set_registry_notification",
    "rename_key",
    "create_timer",
    "open_timer",
    "set_timer",
    "cancel_timer",
    "get_timer_info",
    "get_thread_context",
    "set_thread_context",
    "get_selector_entry",
    "add_atom",
    "delete_atom",
    "find_atom",
    "get_atom_information",
    "get_msg_queue_handle",
    "get_msg_queue",
    "set_queue_fd",
    "set_queue_mask",
    "get_queue_status",
    "get_process_idle_event",
    "send_message",
    "post_quit_message",
    "send_hardware_message",
    "get_message",
    "reply_message",
    "accept_hardware_message",
    "get_message_reply",
    "set_win_timer",
    "kill_win_timer",
    "is_window_hung",
    "get_serial_info",
    "set_serial_info",
    "cancel_sync",
    "register_async",
    "cancel_async",
    "get_async_result",
    "set_async_direct_result",
    "read",
    "write",
    "ioctl",
    "set_irp_result",
    "create_named_pipe",
    "set_named_pipe_info",
    "create_window",
    "destroy_window",
    "get_desktop_window",
    "set_window_owner",
    "get_window_info",
    "init_window_info",
    "set_window_info",
    "set_parent",
    "get_window_parents",
    "get_window_list",
    "get_class_windows",
    "get_window_children_from_point",
    "get_window_tree",
    "set_window_pos",
    "get_window_rectangles",
    "get_window_text",
    "set_window_text",
    "get_windows_offset",
    "get_visible_region",
    "get_window_region",
    "set_window_region",
    "get_update_region",
    "update_window_zorder",
    "redraw_window",
    "set_window_property",
    "remove_window_property",
    "get_window_property",
    "get_window_properties",
    "create_winstation",
    "open_winstation",
    "close_winstation",
    "set_winstation_monitors",
    "get_process_winstation",
    "set_process_winstation",
    "enum_winstation",
    "create_desktop",
    "open_desktop",
    "open_input_desktop",
    "set_input_desktop",
    "close_desktop",
    "get_thread_desktop",
    "set_thread_desktop",
    "set_user_object_info",
    "register_hotkey",
    "unregister_hotkey",
    "attach_thread_input",
    "get_thread_input",
    "get_last_input_time",
    "get_key_state",
    "set_key_state",
    "set_foreground_window",
    "set_focus_window",
    "set_active_window",
    "set_capture_window",
    "set_caret_window",
    "set_caret_info",
    "set_hook",
    "remove_hook",
    "start_hook_chain",
    "finish_hook_chain",
    "get_hook_info",
    "create_class",
    "destroy_class",
    "set_class_info",
    "open_clipboard",
    "close_clipboard",
    "empty_clipboard",
    "set_clipboard_data",
    "get_clipboard_data",
    "get_clipboard_formats",
    "enum_clipboard_formats",
    "release_clipboard",
    "get_clipboard_info",
    "set_clipboard_viewer",
    "add_clipboard_listener",
    "remove_clipboard_listener",
    "create_token",
    "open_token",
    "set_desktop_shell_windows",
    "adjust_token_privileges",
    "get_token_privileges",
    "check_token_privileges",
    "duplicate_token",
    "filter_token",
    "access_check",
    "get_token_sid",
    "get_token_groups",
    "get_token_default_dacl",
    "set_token_default_dacl",
    "set_security_object",
    "get_security_object",
    "get_system_handles",
    "get_tcp_connections",
    "get_udp_endpoints",
    "create_mailslot",
    "set_mailslot_info",
    "create_directory",
    "open_directory",
    "get_directory_entries",
    "create_symlink",
    "open_symlink",
    "query_symlink",
    "get_object_info",
    "get_object_name",
    "get_object_type",
    "get_object_types",
    "allocate_locally_unique_id",
    "create_device_manager",
    "create_device",
    "delete_device",
    "get_next_device_request",
    "get_kernel_object_ptr",
    "set_kernel_object_ptr",
    "grab_kernel_object",
    "release_kernel_object",
    "get_kernel_object_handle",
    "make_process_system",
    "grant_process_admin_token",
    "get_token_info",
    "create_linked_token",
    "create_completion",
    "open_completion",
    "add_completion",
    "remove_completion",
    "get_thread_completion",
    "query_completion",
    "set_completion_info",
    "add_fd_completion",
    "set_fd_completion_mode",
    "set_fd_disp_info",
    "set_fd_name_info",
    "set_fd_eof_info",
    "get_window_layered_info",
    "set_window_layered_info",
    "alloc_user_handle",
    "free_user_handle",
    "set_cursor",
    "get_cursor_history",
    "get_rawinput_buffer",
    "update_rawinput_devices",
    "create_job",
    "open_job",
    "assign_job",
    "process_in_job",
    "set_job_limits",
    "set_job_completion_port",
    "get_job_info",
    "terminate_job",
    "suspend_process",
    "resume_process",
    "get_next_process",
    "get_next_thread",
    "set_keyboard_repeat",
    "get_linux_sync_device",
    "get_linux_sync_obj",
    "select_inproc_queue",
    "unselect_inproc_queue",
    "get_inproc_alert_event",
};

static const struct
{
    const char  *name;
    unsigned int value;
} status_names[] =
{
    { "ABANDONED_WAIT_0",            STATUS_ABANDONED_WAIT_0 },
    { "ACCESS_DENIED",               STATUS_ACCESS_DENIED },
    { "ACCESS_VIOLATION",            STATUS_ACCESS_VIOLATION },
    { "ADDRESS_ALREADY_ASSOCIATED",  STATUS_ADDRESS_ALREADY_ASSOCIATED },
    { "ALERTED",                     STATUS_ALERTED },
    { "BAD_DEVICE_TYPE",             STATUS_BAD_DEVICE_TYPE },
    { "BAD_IMPERSONATION_LEVEL",     STATUS_BAD_IMPERSONATION_LEVEL },
    { "BUFFER_OVERFLOW",             STATUS_BUFFER_OVERFLOW },
    { "BUFFER_TOO_SMALL",            STATUS_BUFFER_TOO_SMALL },
    { "CANCELLED",                   STATUS_CANCELLED },
    { "CANNOT_DELETE",               STATUS_CANNOT_DELETE },
    { "CANT_OPEN_ANONYMOUS",         STATUS_CANT_OPEN_ANONYMOUS },
    { "CHILD_MUST_BE_VOLATILE",      STATUS_CHILD_MUST_BE_VOLATILE },
    { "CONNECTION_ABORTED",          STATUS_CONNECTION_ABORTED },
    { "CONNECTION_ACTIVE",           STATUS_CONNECTION_ACTIVE },
    { "CONNECTION_REFUSED",          STATUS_CONNECTION_REFUSED },
    { "CONNECTION_RESET",            STATUS_CONNECTION_RESET },
    { "DEBUGGER_INACTIVE",           STATUS_DEBUGGER_INACTIVE },
    { "DEVICE_BUSY",                 STATUS_DEVICE_BUSY },
    { "DEVICE_NOT_READY",            STATUS_DEVICE_NOT_READY },
    { "DIRECTORY_NOT_EMPTY",         STATUS_DIRECTORY_NOT_EMPTY },
    { "DISK_FULL",                   STATUS_DISK_FULL },
    { "ERROR_CLASS_ALREADY_EXISTS",  0xc0010000 | ERROR_CLASS_ALREADY_EXISTS },
    { "ERROR_CLASS_DOES_NOT_EXIST",  0xc0010000 | ERROR_CLASS_DOES_NOT_EXIST },
    { "ERROR_CLASS_HAS_WINDOWS",     0xc0010000 | ERROR_CLASS_HAS_WINDOWS },
    { "ERROR_CLIPBOARD_NOT_OPEN",    0xc0010000 | ERROR_CLIPBOARD_NOT_OPEN },
    { "ERROR_HOTKEY_ALREADY_REGISTERED", 0xc0010000 | ERROR_HOTKEY_ALREADY_REGISTERED },
    { "ERROR_HOTKEY_NOT_REGISTERED", 0xc0010000 | ERROR_HOTKEY_NOT_REGISTERED },
    { "ERROR_INVALID_CURSOR_HANDLE", 0xc0010000 | ERROR_INVALID_CURSOR_HANDLE },
    { "ERROR_INVALID_INDEX",         0xc0010000 | ERROR_INVALID_INDEX },
    { "ERROR_INVALID_WINDOW_HANDLE", 0xc0010000 | ERROR_INVALID_WINDOW_HANDLE },
    { "ERROR_NO_MORE_USER_HANDLES",  0xc0010000 | ERROR_NO_MORE_USER_HANDLES },
    { "ERROR_WINDOW_OF_OTHER_THREAD", 0xc0010000 | ERROR_WINDOW_OF_OTHER_THREAD },
    { "FILE_DELETED",                STATUS_FILE_DELETED },
    { "FILE_INVALID",                STATUS_FILE_INVALID },
    { "FILE_IS_A_DIRECTORY",         STATUS_FILE_IS_A_DIRECTORY },
    { "FILE_LOCK_CONFLICT",          STATUS_FILE_LOCK_CONFLICT },
    { "GENERIC_NOT_MAPPED",          STATUS_GENERIC_NOT_MAPPED },
    { "HANDLES_CLOSED",              STATUS_HANDLES_CLOSED },
    { "HANDLE_NOT_CLOSABLE",         STATUS_HANDLE_NOT_CLOSABLE },
    { "HOST_UNREACHABLE",            STATUS_HOST_UNREACHABLE },
    { "ILLEGAL_FUNCTION",            STATUS_ILLEGAL_FUNCTION },
    { "IMAGE_MACHINE_TYPE_MISMATCH", STATUS_IMAGE_MACHINE_TYPE_MISMATCH },
    { "IMAGE_NOT_AT_BASE",           STATUS_IMAGE_NOT_AT_BASE },
    { "INFO_LENGTH_MISMATCH",        STATUS_INFO_LENGTH_MISMATCH },
    { "INSTANCE_NOT_AVAILABLE",      STATUS_INSTANCE_NOT_AVAILABLE },
    { "INSUFFICIENT_RESOURCES",      STATUS_INSUFFICIENT_RESOURCES },
    { "INVALID_ACL",                 STATUS_INVALID_ACL },
    { "INVALID_ADDRESS",             STATUS_INVALID_ADDRESS },
    { "INVALID_ADDRESS_COMPONENT",   STATUS_INVALID_ADDRESS_COMPONENT },
    { "INVALID_CID",                 STATUS_INVALID_CID },
    { "INVALID_CONNECTION",          STATUS_INVALID_CONNECTION },
    { "INVALID_DEVICE_REQUEST",      STATUS_INVALID_DEVICE_REQUEST },
    { "INVALID_FILE_FOR_SECTION",    STATUS_INVALID_FILE_FOR_SECTION },
    { "INVALID_HANDLE",              STATUS_INVALID_HANDLE },
    { "INVALID_IMAGE_FORMAT",        STATUS_INVALID_IMAGE_FORMAT },
    { "INVALID_IMAGE_NE_FORMAT",     STATUS_INVALID_IMAGE_NE_FORMAT },
    { "INVALID_IMAGE_NOT_MZ",        STATUS_INVALID_IMAGE_NOT_MZ },
    { "INVALID_IMAGE_PROTECT",       STATUS_INVALID_IMAGE_PROTECT },
    { "INVALID_IMAGE_WIN_16",        STATUS_INVALID_IMAGE_WIN_16 },
    { "INVALID_IMAGE_WIN_64",        STATUS_INVALID_IMAGE_WIN_64 },
    { "INVALID_LOCK_SEQUENCE",       STATUS_INVALID_LOCK_SEQUENCE },
    { "INVALID_OWNER",               STATUS_INVALID_OWNER },
    { "INVALID_PARAMETER",           STATUS_INVALID_PARAMETER },
    { "INVALID_PIPE_STATE",          STATUS_INVALID_PIPE_STATE },
    { "INVALID_READ_MODE",           STATUS_INVALID_READ_MODE },
    { "INVALID_SECURITY_DESCR",      STATUS_INVALID_SECURITY_DESCR },
    { "IO_TIMEOUT",                  STATUS_IO_TIMEOUT },
    { "KERNEL_APC",                  STATUS_KERNEL_APC },
    { "KEY_DELETED",                 STATUS_KEY_DELETED },
    { "MAPPED_FILE_SIZE_ZERO",       STATUS_MAPPED_FILE_SIZE_ZERO },
    { "MORE_ENTRIES",                STATUS_MORE_ENTRIES },
    { "MUTANT_NOT_OWNED",            STATUS_MUTANT_NOT_OWNED },
    { "NAME_TOO_LONG",               STATUS_NAME_TOO_LONG },
    { "NETWORK_BUSY",                STATUS_NETWORK_BUSY },
    { "NETWORK_UNREACHABLE",         STATUS_NETWORK_UNREACHABLE },
    { "NOT_ALL_ASSIGNED",            STATUS_NOT_ALL_ASSIGNED },
    { "NOT_A_DIRECTORY",             STATUS_NOT_A_DIRECTORY },
    { "NOT_FOUND",                   STATUS_NOT_FOUND },
    { "NOT_IMPLEMENTED",             STATUS_NOT_IMPLEMENTED },
    { "NOT_MAPPED_VIEW",             STATUS_NOT_MAPPED_VIEW },
    { "NOT_REGISTRY_FILE",           STATUS_NOT_REGISTRY_FILE },
    { "NOT_SAME_DEVICE",             STATUS_NOT_SAME_DEVICE },
    { "NOT_SAME_OBJECT",             STATUS_NOT_SAME_OBJECT },
    { "NOT_SUPPORTED",               STATUS_NOT_SUPPORTED },
    { "NO_DATA_DETECTED",            STATUS_NO_DATA_DETECTED },
    { "NO_IMPERSONATION_TOKEN",      STATUS_NO_IMPERSONATION_TOKEN },
    { "NO_MEMORY",                   STATUS_NO_MEMORY },
    { "NO_MORE_ENTRIES",             STATUS_NO_MORE_ENTRIES },
    { "NO_SUCH_DEVICE",              STATUS_NO_SUCH_DEVICE },
    { "NO_SUCH_FILE",                STATUS_NO_SUCH_FILE },
    { "NO_TOKEN",                    STATUS_NO_TOKEN },
    { "OBJECT_NAME_COLLISION",       STATUS_OBJECT_NAME_COLLISION },
    { "OBJECT_NAME_EXISTS",          STATUS_OBJECT_NAME_EXISTS },
    { "OBJECT_NAME_INVALID",         STATUS_OBJECT_NAME_INVALID },
    { "OBJECT_NAME_NOT_FOUND",       STATUS_OBJECT_NAME_NOT_FOUND },
    { "OBJECT_PATH_INVALID",         STATUS_OBJECT_PATH_INVALID },
    { "OBJECT_PATH_NOT_FOUND",       STATUS_OBJECT_PATH_NOT_FOUND },
    { "OBJECT_PATH_SYNTAX_BAD",      STATUS_OBJECT_PATH_SYNTAX_BAD },
    { "OBJECT_TYPE_MISMATCH",        STATUS_OBJECT_TYPE_MISMATCH },
    { "PENDING",                     STATUS_PENDING },
    { "PIPE_BROKEN",                 STATUS_PIPE_BROKEN },
    { "PIPE_BUSY",                   STATUS_PIPE_BUSY },
    { "PIPE_CLOSING",                STATUS_PIPE_CLOSING },
    { "PIPE_CONNECTED",              STATUS_PIPE_CONNECTED },
    { "PIPE_DISCONNECTED",           STATUS_PIPE_DISCONNECTED },
    { "PIPE_EMPTY",                  STATUS_PIPE_EMPTY },
    { "PIPE_LISTENING",              STATUS_PIPE_LISTENING },
    { "PIPE_NOT_AVAILABLE",          STATUS_PIPE_NOT_AVAILABLE },
    { "PORT_NOT_SET",                STATUS_PORT_NOT_SET },
    { "PREDEFINED_HANDLE",           STATUS_PREDEFINED_HANDLE },
    { "PRIVILEGE_NOT_HELD",          STATUS_PRIVILEGE_NOT_HELD },
    { "PROCESS_IN_JOB",              STATUS_PROCESS_IN_JOB },
    { "PROCESS_IS_TERMINATING",      STATUS_PROCESS_IS_TERMINATING },
    { "PROCESS_NOT_IN_JOB",          STATUS_PROCESS_NOT_IN_JOB },
    { "REPARSE_POINT_NOT_RESOLVED",  STATUS_REPARSE_POINT_NOT_RESOLVED },
    { "SECTION_TOO_BIG",             STATUS_SECTION_TOO_BIG },
    { "SEMAPHORE_LIMIT_EXCEEDED",    STATUS_SEMAPHORE_LIMIT_EXCEEDED },
    { "SHARING_VIOLATION",           STATUS_SHARING_VIOLATION },
    { "SHUTDOWN_IN_PROGRESS",        STATUS_SHUTDOWN_IN_PROGRESS },
    { "SUSPEND_COUNT_EXCEEDED",      STATUS_SUSPEND_COUNT_EXCEEDED },
    { "THREAD_IS_TERMINATING",       STATUS_THREAD_IS_TERMINATING },
    { "TIMEOUT",                     STATUS_TIMEOUT },
    { "TOO_MANY_OPENED_FILES",       STATUS_TOO_MANY_OPENED_FILES },
    { "UNSUCCESSFUL",                STATUS_UNSUCCESSFUL },
    { "USER_APC",                    STATUS_USER_APC },
    { "USER_MAPPED_FILE",            STATUS_USER_MAPPED_FILE },
    { "VOLUME_DISMOUNTED",           STATUS_VOLUME_DISMOUNTED },
    { "WAS_LOCKED",                  STATUS_WAS_LOCKED },
    { "WSAEACCES",                   0xc0010000 | WSAEACCES },
    { "WSAEADDRINUSE",               0xc0010000 | WSAEADDRINUSE },
    { "WSAEADDRNOTAVAIL",            0xc0010000 | WSAEADDRNOTAVAIL },
    { "WSAEAFNOSUPPORT",             0xc0010000 | WSAEAFNOSUPPORT },
    { "WSAEALREADY",                 0xc0010000 | WSAEALREADY },
    { "WSAEBADF",                    0xc0010000 | WSAEBADF },
    { "WSAECONNABORTED",             0xc0010000 | WSAECONNABORTED },
    { "WSAECONNREFUSED",             0xc0010000 | WSAECONNREFUSED },
    { "WSAECONNRESET",               0xc0010000 | WSAECONNRESET },
    { "WSAEDESTADDRREQ",             0xc0010000 | WSAEDESTADDRREQ },
    { "WSAEDQUOT",                   0xc0010000 | WSAEDQUOT },
    { "WSAEFAULT",                   0xc0010000 | WSAEFAULT },
    { "WSAEHOSTDOWN",                0xc0010000 | WSAEHOSTDOWN },
    { "WSAEHOSTUNREACH",             0xc0010000 | WSAEHOSTUNREACH },
    { "WSAEINTR",                    0xc0010000 | WSAEINTR },
    { "WSAEINVAL",                   0xc0010000 | WSAEINVAL },
    { "WSAEISCONN",                  0xc0010000 | WSAEISCONN },
    { "WSAELOOP",                    0xc0010000 | WSAELOOP },
    { "WSAEMFILE",                   0xc0010000 | WSAEMFILE },
    { "WSAEMSGSIZE",                 0xc0010000 | WSAEMSGSIZE },
    { "WSAENAMETOOLONG",             0xc0010000 | WSAENAMETOOLONG },
    { "WSAENETDOWN",                 0xc0010000 | WSAENETDOWN },
    { "WSAENETRESET",                0xc0010000 | WSAENETRESET },
    { "WSAENETUNREACH",              0xc0010000 | WSAENETUNREACH },
    { "WSAENOBUFS",                  0xc0010000 | WSAENOBUFS },
    { "WSAENOPROTOOPT",              0xc0010000 | WSAENOPROTOOPT },
    { "WSAENOTCONN",                 0xc0010000 | WSAENOTCONN },
    { "WSAENOTEMPTY",                0xc0010000 | WSAENOTEMPTY },
    { "WSAENOTSOCK",                 0xc0010000 | WSAENOTSOCK },
    { "WSAEOPNOTSUPP",               0xc0010000 | WSAEOPNOTSUPP },
    { "WSAEPFNOSUPPORT",             0xc0010000 | WSAEPFNOSUPPORT },
    { "WSAEPROCLIM",                 0xc0010000 | WSAEPROCLIM },
    { "WSAEPROTONOSUPPORT",          0xc0010000 | WSAEPROTONOSUPPORT },
    { "WSAEPROTOTYPE",               0xc0010000 | WSAEPROTOTYPE },
    { "WSAEREMOTE",                  0xc0010000 | WSAEREMOTE },
    { "WSAESHUTDOWN",                0xc0010000 | WSAESHUTDOWN },
    { "WSAESOCKTNOSUPPORT",          0xc0010000 | WSAESOCKTNOSUPPORT },
    { "WSAESTALE",                   0xc0010000 | WSAESTALE },
    { "WSAETIMEDOUT",                0xc0010000 | WSAETIMEDOUT },
    { "WSAETOOMANYREFS",             0xc0010000 | WSAETOOMANYREFS },
    { "WSAEUSERS",                   0xc0010000 | WSAEUSERS },
    { "WSAEWOULDBLOCK",              0xc0010000 | WSAEWOULDBLOCK },
    { NULL, 0 }
};
