/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: Sparc.td                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_Is64BitBit = 10,
  Feature_UseSoftMulDivBit = 11,
  Feature_HasV9Bit = 6,
  Feature_HasVISBit = 7,
  Feature_HasVIS2Bit = 8,
  Feature_HasVIS3Bit = 9,
  Feature_HasUA2005Bit = 4,
  Feature_HasUA2007Bit = 5,
  Feature_HasOSA2011Bit = 2,
  Feature_HasCryptoBit = 1,
  Feature_HasCASABit = 0,
  Feature_HasPWRPSRBit = 3,
};

static MCRegister MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 1 string to match.
    if (Name[0] != 'y')
      break;
    return SP::Y;	 // "y"
  case 2:	 // 86 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 16 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::C0;	 // "c0"
      case '1':	 // 1 string to match.
        return SP::C1;	 // "c1"
      case '2':	 // 2 strings to match.
        return SP::C2;	 // "c2"
      case '3':	 // 1 string to match.
        return SP::C3;	 // "c3"
      case '4':	 // 2 strings to match.
        return SP::C4;	 // "c4"
      case '5':	 // 1 string to match.
        return SP::C5;	 // "c5"
      case '6':	 // 2 strings to match.
        return SP::C6;	 // "c6"
      case '7':	 // 1 string to match.
        return SP::C7;	 // "c7"
      case '8':	 // 2 strings to match.
        return SP::C8;	 // "c8"
      case '9':	 // 1 string to match.
        return SP::C9;	 // "c9"
      case 'q':	 // 1 string to match.
        return SP::CPQ;	 // "cq"
      }
      break;
    case 'f':	 // 20 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 3 strings to match.
        return SP::D0;	 // "f0"
      case '1':	 // 1 string to match.
        return SP::F1;	 // "f1"
      case '2':	 // 2 strings to match.
        return SP::D1;	 // "f2"
      case '3':	 // 1 string to match.
        return SP::F3;	 // "f3"
      case '4':	 // 3 strings to match.
        return SP::D2;	 // "f4"
      case '5':	 // 1 string to match.
        return SP::F5;	 // "f5"
      case '6':	 // 2 strings to match.
        return SP::D3;	 // "f6"
      case '7':	 // 1 string to match.
        return SP::F7;	 // "f7"
      case '8':	 // 3 strings to match.
        return SP::D4;	 // "f8"
      case '9':	 // 1 string to match.
        return SP::F9;	 // "f9"
      case 'p':	 // 1 string to match.
        return SP::I6;	 // "fp"
      case 'q':	 // 1 string to match.
        return SP::FQ;	 // "fq"
      }
      break;
    case 'g':	 // 13 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::G0;	 // "g0"
      case '1':	 // 1 string to match.
        return SP::G1;	 // "g1"
      case '2':	 // 2 strings to match.
        return SP::G2;	 // "g2"
      case '3':	 // 1 string to match.
        return SP::G3;	 // "g3"
      case '4':	 // 2 strings to match.
        return SP::G4;	 // "g4"
      case '5':	 // 1 string to match.
        return SP::G5;	 // "g5"
      case '6':	 // 2 strings to match.
        return SP::G6;	 // "g6"
      case '7':	 // 1 string to match.
        return SP::G7;	 // "g7"
      case 'l':	 // 1 string to match.
        return SP::GL;	 // "gl"
      }
      break;
    case 'i':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::I0;	 // "i0"
      case '1':	 // 1 string to match.
        return SP::I1;	 // "i1"
      case '2':	 // 2 strings to match.
        return SP::I2;	 // "i2"
      case '3':	 // 1 string to match.
        return SP::I3;	 // "i3"
      case '4':	 // 2 strings to match.
        return SP::I4;	 // "i4"
      case '5':	 // 1 string to match.
        return SP::I5;	 // "i5"
      case '6':	 // 1 string to match.
        return SP::I6_I7;	 // "i6"
      case '7':	 // 1 string to match.
        return SP::I7;	 // "i7"
      }
      break;
    case 'l':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::L0;	 // "l0"
      case '1':	 // 1 string to match.
        return SP::L1;	 // "l1"
      case '2':	 // 2 strings to match.
        return SP::L2;	 // "l2"
      case '3':	 // 1 string to match.
        return SP::L3;	 // "l3"
      case '4':	 // 2 strings to match.
        return SP::L4;	 // "l4"
      case '5':	 // 1 string to match.
        return SP::L5;	 // "l5"
      case '6':	 // 2 strings to match.
        return SP::L6;	 // "l6"
      case '7':	 // 1 string to match.
        return SP::L7;	 // "l7"
      }
      break;
    case 'o':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return SP::O0;	 // "o0"
      case '1':	 // 1 string to match.
        return SP::O1;	 // "o1"
      case '2':	 // 2 strings to match.
        return SP::O2;	 // "o2"
      case '3':	 // 1 string to match.
        return SP::O3;	 // "o3"
      case '4':	 // 2 strings to match.
        return SP::O4;	 // "o4"
      case '5':	 // 1 string to match.
        return SP::O5;	 // "o5"
      case '6':	 // 1 string to match.
        return SP::O6_O7;	 // "o6"
      case '7':	 // 1 string to match.
        return SP::O7;	 // "o7"
      }
      break;
    case 's':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return SP::O6;	 // "sp"
    case 't':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'l':	 // 1 string to match.
        return SP::TL;	 // "tl"
      case 't':	 // 1 string to match.
        return SP::TT;	 // "tt"
      }
      break;
    }
    break;
  case 3:	 // 106 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 35 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::C10;	 // "c10"
        case '1':	 // 1 string to match.
          return SP::C11;	 // "c11"
        case '2':	 // 2 strings to match.
          return SP::C12;	 // "c12"
        case '3':	 // 1 string to match.
          return SP::C13;	 // "c13"
        case '4':	 // 2 strings to match.
          return SP::C14;	 // "c14"
        case '5':	 // 1 string to match.
          return SP::C15;	 // "c15"
        case '6':	 // 2 strings to match.
          return SP::C16;	 // "c16"
        case '7':	 // 1 string to match.
          return SP::C17;	 // "c17"
        case '8':	 // 2 strings to match.
          return SP::C18;	 // "c18"
        case '9':	 // 1 string to match.
          return SP::C19;	 // "c19"
        }
        break;
      case '2':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::C20;	 // "c20"
        case '1':	 // 1 string to match.
          return SP::C21;	 // "c21"
        case '2':	 // 2 strings to match.
          return SP::C22;	 // "c22"
        case '3':	 // 1 string to match.
          return SP::C23;	 // "c23"
        case '4':	 // 2 strings to match.
          return SP::C24;	 // "c24"
        case '5':	 // 1 string to match.
          return SP::C25;	 // "c25"
        case '6':	 // 2 strings to match.
          return SP::C26;	 // "c26"
        case '7':	 // 1 string to match.
          return SP::C27;	 // "c27"
        case '8':	 // 2 strings to match.
          return SP::C28;	 // "c28"
        case '9':	 // 1 string to match.
          return SP::C29;	 // "c29"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::C30;	 // "c30"
        case '1':	 // 1 string to match.
          return SP::C31;	 // "c31"
        }
        break;
      case 's':	 // 1 string to match.
        if (Name[2] != 'r')
          break;
        return SP::CPSR;	 // "csr"
      case 'w':	 // 1 string to match.
        if (Name[2] != 'p')
          break;
        return SP::CWP;	 // "cwp"
      }
      break;
    case 'f':	 // 63 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 17 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D5;	 // "f10"
        case '1':	 // 1 string to match.
          return SP::F11;	 // "f11"
        case '2':	 // 3 strings to match.
          return SP::D6;	 // "f12"
        case '3':	 // 1 string to match.
          return SP::F13;	 // "f13"
        case '4':	 // 2 strings to match.
          return SP::D7;	 // "f14"
        case '5':	 // 1 string to match.
          return SP::F15;	 // "f15"
        case '6':	 // 3 strings to match.
          return SP::D8;	 // "f16"
        case '7':	 // 1 string to match.
          return SP::F17;	 // "f17"
        case '8':	 // 2 strings to match.
          return SP::D9;	 // "f18"
        case '9':	 // 1 string to match.
          return SP::F19;	 // "f19"
        }
        break;
      case '2':	 // 18 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return SP::D10;	 // "f20"
        case '1':	 // 1 string to match.
          return SP::F21;	 // "f21"
        case '2':	 // 2 strings to match.
          return SP::D11;	 // "f22"
        case '3':	 // 1 string to match.
          return SP::F23;	 // "f23"
        case '4':	 // 3 strings to match.
          return SP::D12;	 // "f24"
        case '5':	 // 1 string to match.
          return SP::F25;	 // "f25"
        case '6':	 // 2 strings to match.
          return SP::D13;	 // "f26"
        case '7':	 // 1 string to match.
          return SP::F27;	 // "f27"
        case '8':	 // 3 strings to match.
          return SP::D14;	 // "f28"
        case '9':	 // 1 string to match.
          return SP::F29;	 // "f29"
        }
        break;
      case '3':	 // 9 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D15;	 // "f30"
        case '1':	 // 1 string to match.
          return SP::F31;	 // "f31"
        case '2':	 // 2 strings to match.
          return SP::D16;	 // "f32"
        case '4':	 // 1 string to match.
          return SP::D17;	 // "f34"
        case '6':	 // 2 strings to match.
          return SP::D18;	 // "f36"
        case '8':	 // 1 string to match.
          return SP::D19;	 // "f38"
        }
        break;
      case '4':	 // 8 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D20;	 // "f40"
        case '2':	 // 1 string to match.
          return SP::D21;	 // "f42"
        case '4':	 // 2 strings to match.
          return SP::D22;	 // "f44"
        case '6':	 // 1 string to match.
          return SP::D23;	 // "f46"
        case '8':	 // 2 strings to match.
          return SP::D24;	 // "f48"
        }
        break;
      case '5':	 // 7 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return SP::D25;	 // "f50"
        case '2':	 // 2 strings to match.
          return SP::D26;	 // "f52"
        case '4':	 // 1 string to match.
          return SP::D27;	 // "f54"
        case '6':	 // 2 strings to match.
          return SP::D28;	 // "f56"
        case '8':	 // 1 string to match.
          return SP::D29;	 // "f58"
        }
        break;
      case '6':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return SP::D30;	 // "f60"
        case '2':	 // 1 string to match.
          return SP::D31;	 // "f62"
        }
        break;
      case 's':	 // 1 string to match.
        if (Name[2] != 'r')
          break;
        return SP::FSR;	 // "fsr"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(Name.data()+1, "cc", 2) != 0)
        break;
      return SP::ICC;	 // "icc"
    case 'p':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return SP::PIL;	 // "pil"
      case 's':	 // 1 string to match.
        if (Name[2] != 'r')
          break;
        return SP::PSR;	 // "psr"
      }
      break;
    case 't':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'a':	 // 1 string to match.
          return SP::TBA;	 // "tba"
        case 'r':	 // 1 string to match.
          return SP::TBR;	 // "tbr"
        }
        break;
      case 'p':	 // 1 string to match.
        if (Name[2] != 'c')
          break;
        return SP::TPC;	 // "tpc"
      }
      break;
    case 'v':	 // 1 string to match.
      if (memcmp(Name.data()+1, "er", 2) != 0)
        break;
      return SP::VER;	 // "ver"
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "im", 2) != 0)
        break;
      return SP::WIM;	 // "wim"
    }
    break;
  case 4:	 // 15 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 9 strings to match.
      if (memcmp(Name.data()+1, "sr", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 1 string to match.
        return SP::ASR1;	 // "asr1"
      case '2':	 // 1 string to match.
        return SP::ASR2;	 // "asr2"
      case '3':	 // 1 string to match.
        return SP::ASR3;	 // "asr3"
      case '4':	 // 1 string to match.
        return SP::ASR4;	 // "asr4"
      case '5':	 // 1 string to match.
        return SP::ASR5;	 // "asr5"
      case '6':	 // 1 string to match.
        return SP::ASR6;	 // "asr6"
      case '7':	 // 1 string to match.
        return SP::ASR7;	 // "asr7"
      case '8':	 // 1 string to match.
        return SP::ASR8;	 // "asr8"
      case '9':	 // 1 string to match.
        return SP::ASR9;	 // "asr9"
      }
      break;
    case 'f':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "cc", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::FCC0;	 // "fcc0"
      case '1':	 // 1 string to match.
        return SP::FCC1;	 // "fcc1"
      case '2':	 // 1 string to match.
        return SP::FCC2;	 // "fcc2"
      case '3':	 // 1 string to match.
        return SP::FCC3;	 // "fcc3"
      }
      break;
    case 't':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (memcmp(Name.data()+2, "ck", 2) != 0)
          break;
        return SP::TICK;	 // "tick"
      case 'n':	 // 1 string to match.
        if (memcmp(Name.data()+2, "pc", 2) != 0)
          break;
        return SP::TNPC;	 // "tnpc"
      }
      break;
    }
    break;
  case 5:	 // 22 strings to match.
    if (memcmp(Name.data()+0, "asr", 3) != 0)
      break;
    switch (Name[3]) {
    default: break;
    case '1':	 // 10 strings to match.
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::ASR10;	 // "asr10"
      case '1':	 // 1 string to match.
        return SP::ASR11;	 // "asr11"
      case '2':	 // 1 string to match.
        return SP::ASR12;	 // "asr12"
      case '3':	 // 1 string to match.
        return SP::ASR13;	 // "asr13"
      case '4':	 // 1 string to match.
        return SP::ASR14;	 // "asr14"
      case '5':	 // 1 string to match.
        return SP::ASR15;	 // "asr15"
      case '6':	 // 1 string to match.
        return SP::ASR16;	 // "asr16"
      case '7':	 // 1 string to match.
        return SP::ASR17;	 // "asr17"
      case '8':	 // 1 string to match.
        return SP::ASR18;	 // "asr18"
      case '9':	 // 1 string to match.
        return SP::ASR19;	 // "asr19"
      }
      break;
    case '2':	 // 10 strings to match.
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::ASR20;	 // "asr20"
      case '1':	 // 1 string to match.
        return SP::ASR21;	 // "asr21"
      case '2':	 // 1 string to match.
        return SP::ASR22;	 // "asr22"
      case '3':	 // 1 string to match.
        return SP::ASR23;	 // "asr23"
      case '4':	 // 1 string to match.
        return SP::ASR24;	 // "asr24"
      case '5':	 // 1 string to match.
        return SP::ASR25;	 // "asr25"
      case '6':	 // 1 string to match.
        return SP::ASR26;	 // "asr26"
      case '7':	 // 1 string to match.
        return SP::ASR27;	 // "asr27"
      case '8':	 // 1 string to match.
        return SP::ASR28;	 // "asr28"
      case '9':	 // 1 string to match.
        return SP::ASR29;	 // "asr29"
      }
      break;
    case '3':	 // 2 strings to match.
      switch (Name[4]) {
      default: break;
      case '0':	 // 1 string to match.
        return SP::ASR30;	 // "asr30"
      case '1':	 // 1 string to match.
        return SP::ASR31;	 // "asr31"
      }
      break;
    }
    break;
  case 6:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'p':	 // 1 string to match.
      if (memcmp(Name.data()+1, "state", 5) != 0)
        break;
      return SP::PSTATE;	 // "pstate"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "state", 5) != 0)
        break;
      return SP::TSTATE;	 // "tstate"
    case 'w':	 // 1 string to match.
      if (memcmp(Name.data()+1, "state", 5) != 0)
        break;
      return SP::WSTATE;	 // "wstate"
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(Name.data()+0, "cansave", 7) != 0)
      break;
    return SP::CANSAVE;	 // "cansave"
  case 8:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "leanwin", 7) != 0)
        break;
      return SP::CLEANWIN;	 // "cleanwin"
    case 'o':	 // 1 string to match.
      if (memcmp(Name.data()+1, "therwin", 7) != 0)
        break;
      return SP::OTHERWIN;	 // "otherwin"
    }
    break;
  case 10:	 // 1 string to match.
    if (memcmp(Name.data()+0, "canrestore", 10) != 0)
      break;
    return SP::CANRESTORE;	 // "canrestore"
  }
  return SP::NoRegister;
}

static MCRegister MatchRegisterAltName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 1 string to match.
    if (memcmp(Name.data()+0, "pc", 2) != 0)
      break;
    return SP::ASR5;	 // "pc"
  case 3:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+1, "si", 2) != 0)
        break;
      return SP::ASR3;	 // "asi"
    case 'c':	 // 1 string to match.
      if (memcmp(Name.data()+1, "cr", 2) != 0)
        break;
      return SP::ASR2;	 // "ccr"
    }
    break;
  case 4:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "prs", 3) != 0)
        break;
      return SP::ASR6;	 // "fprs"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "ick", 3) != 0)
        break;
      return SP::ASR4;	 // "tick"
    }
    break;
  }
  return SP::NoRegister;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_Is64BitBit: return "";
  case Feature_UseSoftMulDivBit: return "";
  case Feature_HasV9Bit: return "";
  case Feature_HasVISBit: return "";
  case Feature_HasVIS2Bit: return "";
  case Feature_HasVIS3Bit: return "";
  case Feature_HasUA2005Bit: return "";
  case Feature_HasUA2007Bit: return "";
  case Feature_HasOSA2011Bit: return "";
  case Feature_HasCryptoBit: return "";
  case Feature_HasCASABit: return "";
  case Feature_HasPWRPSRBit: return "";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (Mnemonic.size()) {
  default: break;
  case 3:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "stw", 3) != 0)
      break;
    if (Features.test(Feature_HasV9Bit))	 // "stw"
      Mnemonic = "st";
    return;
  case 4:	 // 10 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ddc", 3) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "addc"
        Mnemonic = "addx";
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "duw", 3) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "lduw"
        Mnemonic = "ld";
      return;
    case 's':	 // 8 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 't':	 // 7 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 's':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "stb";	 // "stsb"
            return;
          case 'h':	 // 1 string to match.
            Mnemonic = "sth";	 // "stsh"
            return;
          case 'w':	 // 1 string to match.
            if (Features.test(Feature_HasV9Bit))	 // "stsw"
              Mnemonic = "st";
            return;
          }
          break;
        case 'u':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "stb";	 // "stub"
            return;
          case 'h':	 // 1 string to match.
            Mnemonic = "sth";	 // "stuh"
            return;
          case 'w':	 // 1 string to match.
            if (Features.test(Feature_HasV9Bit))	 // "stuw"
              Mnemonic = "st";
            return;
          }
          break;
        case 'w':	 // 1 string to match.
          if (Mnemonic[3] != 'a')
            break;
          if (Features.test(Feature_HasV9Bit))	 // "stwa"
            Mnemonic = "sta";
          return;
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "bc", 2) != 0)
          break;
        if (Features.test(Feature_HasV9Bit))	 // "subc"
          Mnemonic = "subx";
        return;
      }
      break;
    }
    break;
  case 5:	 // 8 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "duwa", 4) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "lduwa"
        Mnemonic = "lda";
      return;
    case 's':	 // 7 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "tuw", 3) != 0)
          break;
        if (Features.test(Feature_HasV9Bit))	 // "setuw"
          Mnemonic = "set";
        return;
      case 't':	 // 6 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 's':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            if (Mnemonic[4] != 'a')
              break;
            Mnemonic = "stba";	 // "stsba"
            return;
          case 'h':	 // 1 string to match.
            if (Mnemonic[4] != 'a')
              break;
            Mnemonic = "stha";	 // "stsha"
            return;
          case 'w':	 // 1 string to match.
            if (Mnemonic[4] != 'a')
              break;
            if (Features.test(Feature_HasV9Bit))	 // "stswa"
              Mnemonic = "sta";
            return;
          }
          break;
        case 'u':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            if (Mnemonic[4] != 'a')
              break;
            Mnemonic = "stba";	 // "stuba"
            return;
          case 'h':	 // 1 string to match.
            if (Mnemonic[4] != 'a')
              break;
            Mnemonic = "stha";	 // "stuha"
            return;
          case 'w':	 // 1 string to match.
            if (Mnemonic[4] != 'a')
              break;
            if (Features.test(Feature_HasV9Bit))	 // "stuwa"
              Mnemonic = "sta";
            return;
          }
          break;
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 4 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ddccc", 5) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "addccc"
        Mnemonic = "addxcc";
      return;
    case 'i':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "flush", 5) != 0)
        break;
      Mnemonic = "flush";	 // "iflush"
      return;
    case 'r':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "eturn", 5) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "return"
        Mnemonic = "rett";
      return;
    case 's':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ubccc", 5) != 0)
        break;
      if (Features.test(Feature_HasV9Bit))	 // "subccc"
        Mnemonic = "subxcc";
      return;
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "illtrap", 7) != 0)
      break;
    Mnemonic = "unimp";	 // "illtrap"
    return;
  }
}

enum {
  Tie0_1_1,
  Tie0_3_3,
  Tie0_5_5,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie0_5_5 */ { 0, 5, 5 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_Reg,
  CVT_95_addImmOperands,
  CVT_95_addTailRelocSymOperands,
  CVT_imm_95_8,
  CVT_imm_95_13,
  CVT_imm_95_5,
  CVT_imm_95_1,
  CVT_imm_95_10,
  CVT_imm_95_11,
  CVT_imm_95_12,
  CVT_imm_95_3,
  CVT_imm_95_2,
  CVT_imm_95_4,
  CVT_imm_95_0,
  CVT_imm_95_9,
  CVT_imm_95_6,
  CVT_imm_95_14,
  CVT_imm_95_7,
  CVT_regG0,
  CVT_imm_95_15,
  CVT_95_addCallTargetOperands,
  CVT_regO7,
  CVT_95_addMEMriOperands,
  CVT_95_addMEMrrOperands,
  CVT_imm_95_128,
  CVT_95_addASITagOperands,
  CVT_imm_95_136,
  CVT_regFCC0,
  CVT_95_addMembarTagOperands,
  CVT_regASR27,
  CVT_95_addPrefetchTagOperands,
  CVT_95_addShiftAmtImm5Operands,
  CVT_95_addShiftAmtImm6Operands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__Reg1_2__Reg1_0__Reg1_1,
  Convert__Reg1_2__Reg1_0__Imm1_1,
  Convert__Reg1_2__Reg1_0__Reg1_1__TailRelocSymAdd_TLS1_3,
  Convert__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_3__Reg1_0__Reg1_1__Imm1_2,
  Convert_NoOperands,
  Convert__Imm1_0__imm_95_8,
  Convert__Imm1_1__imm_95_8,
  Convert__Imm1_1__Imm1_0,
  Convert__Imm1_2__imm_95_8,
  Convert__Imm1_2__Imm1_0,
  Convert__Imm1_3__imm_95_8,
  Convert__Imm1_3__Imm1_0,
  Convert__Imm1_4__Imm1_0,
  Convert__Imm1_0,
  Convert__Imm1_0__imm_95_13,
  Convert__Imm1_1__imm_95_13,
  Convert__Imm1_2__imm_95_13,
  Convert__Imm1_3__imm_95_13,
  Convert__Reg1_1__Reg1_1__Reg1_0,
  Convert__Reg1_1__Reg1_1__Imm1_0,
  Convert__Imm1_0__imm_95_5,
  Convert__Imm1_1__imm_95_5,
  Convert__Imm1_2__imm_95_5,
  Convert__Imm1_3__imm_95_5,
  Convert__Imm1_0__imm_95_1,
  Convert__Imm1_1__imm_95_1,
  Convert__Imm1_2__imm_95_1,
  Convert__Imm1_3__imm_95_1,
  Convert__Imm1_0__imm_95_10,
  Convert__Imm1_1__imm_95_10,
  Convert__Imm1_2__imm_95_10,
  Convert__Imm1_3__imm_95_10,
  Convert__Imm1_0__imm_95_11,
  Convert__Imm1_1__imm_95_11,
  Convert__Imm1_2__imm_95_11,
  Convert__Imm1_3__imm_95_11,
  Convert__Imm1_0__imm_95_12,
  Convert__Imm1_1__imm_95_12,
  Convert__Imm1_2__imm_95_12,
  Convert__Imm1_3__imm_95_12,
  Convert__Imm1_0__imm_95_3,
  Convert__Imm1_1__imm_95_3,
  Convert__Imm1_2__imm_95_3,
  Convert__Imm1_3__imm_95_3,
  Convert__Imm1_0__imm_95_2,
  Convert__Imm1_1__imm_95_2,
  Convert__Imm1_2__imm_95_2,
  Convert__Imm1_3__imm_95_2,
  Convert__Imm1_0__imm_95_4,
  Convert__Imm1_1__imm_95_4,
  Convert__Imm1_2__imm_95_4,
  Convert__Imm1_3__imm_95_4,
  Convert__Imm1_0__imm_95_0,
  Convert__Imm1_1__imm_95_0,
  Convert__Imm1_2__imm_95_0,
  Convert__Imm1_3__imm_95_0,
  Convert__Imm1_0__imm_95_9,
  Convert__Imm1_1__imm_95_9,
  Convert__Imm1_2__imm_95_9,
  Convert__Imm1_3__imm_95_9,
  Convert__Imm1_0__imm_95_6,
  Convert__Imm1_1__imm_95_6,
  Convert__Imm1_2__imm_95_6,
  Convert__Imm1_3__imm_95_6,
  Convert__Imm1_0__imm_95_14,
  Convert__Imm1_1__imm_95_14,
  Convert__Imm1_2__imm_95_14,
  Convert__Imm1_3__imm_95_14,
  Convert__Imm1_2__Imm1_0__Reg1_1,
  Convert__Imm1_3__Imm1_0__Reg1_2,
  Convert__Imm1_4__Imm1_0__Reg1_3,
  Convert__Imm1_1__imm_95_1__Reg1_0,
  Convert__Imm1_2__imm_95_1__Reg1_1,
  Convert__Imm1_3__imm_95_1__Reg1_2,
  Convert__Imm1_1__imm_95_7__Reg1_0,
  Convert__Imm1_2__imm_95_7__Reg1_1,
  Convert__Imm1_3__imm_95_7__Reg1_2,
  Convert__Imm1_1__imm_95_6__Reg1_0,
  Convert__Imm1_2__imm_95_6__Reg1_1,
  Convert__Imm1_3__imm_95_6__Reg1_2,
  Convert__Imm1_1__imm_95_2__Reg1_0,
  Convert__Imm1_2__imm_95_2__Reg1_1,
  Convert__Imm1_3__imm_95_2__Reg1_2,
  Convert__Imm1_1__imm_95_3__Reg1_0,
  Convert__Imm1_2__imm_95_3__Reg1_1,
  Convert__Imm1_3__imm_95_3__Reg1_2,
  Convert__Imm1_1__imm_95_5__Reg1_0,
  Convert__Imm1_2__imm_95_5__Reg1_1,
  Convert__Imm1_3__imm_95_5__Reg1_2,
  Convert__regG0__Reg1_1__Reg1_0,
  Convert__regG0__Reg1_1__Imm1_0,
  Convert__Imm1_0__imm_95_15,
  Convert__Imm1_1__imm_95_15,
  Convert__Imm1_2__imm_95_15,
  Convert__Imm1_3__imm_95_15,
  Convert__Imm1_0__imm_95_7,
  Convert__Imm1_1__imm_95_7,
  Convert__Imm1_2__imm_95_7,
  Convert__Imm1_3__imm_95_7,
  Convert__CallTarget1_0,
  Convert__regO7__MEMri2_0,
  Convert__regO7__MEMrr2_0,
  Convert__CallTarget1_0__Imm1_1,
  Convert__CallTarget1_0__TailRelocSymCall_TLS1_1,
  Convert__MEMri2_0__Imm1_1,
  Convert__MEMrr2_0__Imm1_1,
  Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128,
  Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1,
  Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3,
  Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136,
  Convert__Reg1_0__regG0__regG0,
  Convert__MEMri2_1__regG0,
  Convert__MEMrr2_1__regG0,
  Convert__Reg1_0,
  Convert__regG0__Reg1_0__Reg1_1,
  Convert__regG0__Reg1_0__Imm1_1,
  Convert__Imm1_3__Imm1_0__Reg1_1__Reg1_2,
  Convert__Imm1_3__Imm1_0__Reg1_1__Imm1_2,
  Convert__Imm1_2__imm_95_13__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_13__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_5__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_5__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_1__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_1__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_10__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_10__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_11__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_11__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_12__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_12__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_3__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_3__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_2__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_2__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_4__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_4__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_9__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_9__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_6__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_6__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_14__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_14__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_15__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_15__Reg1_0__Imm1_1,
  Convert__Imm1_2__imm_95_7__Reg1_0__Reg1_1,
  Convert__Imm1_2__imm_95_7__Reg1_0__Imm1_1,
  Convert__Reg1_0__Reg1_0__imm_95_1,
  Convert__Reg1_1__Reg1_0,
  Convert__Imm1_1__imm_95_8__Reg1_0,
  Convert__Imm1_2__imm_95_8__Reg1_1,
  Convert__Imm1_3__imm_95_8__Reg1_2,
  Convert__Imm1_1__imm_95_9__Reg1_0,
  Convert__Imm1_2__imm_95_9__Reg1_1,
  Convert__Imm1_3__imm_95_9__Reg1_2,
  Convert__Imm1_1__imm_95_11__Reg1_0,
  Convert__Imm1_2__imm_95_11__Reg1_1,
  Convert__Imm1_3__imm_95_11__Reg1_2,
  Convert__Imm1_1__imm_95_4__Reg1_0,
  Convert__Imm1_2__imm_95_4__Reg1_1,
  Convert__Imm1_3__imm_95_4__Reg1_2,
  Convert__Imm1_1__imm_95_13__Reg1_0,
  Convert__Imm1_2__imm_95_13__Reg1_1,
  Convert__Imm1_3__imm_95_13__Reg1_2,
  Convert__Imm1_1__imm_95_0__Reg1_0,
  Convert__Imm1_2__imm_95_0__Reg1_1,
  Convert__Imm1_3__imm_95_0__Reg1_2,
  Convert__Imm1_1__imm_95_15__Reg1_0,
  Convert__Imm1_2__imm_95_15__Reg1_1,
  Convert__Imm1_3__imm_95_15__Reg1_2,
  Convert__Imm1_1__imm_95_10__Reg1_0,
  Convert__Imm1_2__imm_95_10__Reg1_1,
  Convert__Imm1_3__imm_95_10__Reg1_2,
  Convert__Imm1_1__imm_95_12__Reg1_0,
  Convert__Imm1_2__imm_95_12__Reg1_1,
  Convert__Imm1_3__imm_95_12__Reg1_2,
  Convert__Imm1_1__imm_95_14__Reg1_0,
  Convert__Imm1_2__imm_95_14__Reg1_1,
  Convert__Imm1_3__imm_95_14__Reg1_2,
  Convert__regFCC0__Reg1_0__Reg1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__MEMri2_0,
  Convert__MEMrr2_0,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7,
  Convert__regG0__MEMri2_0,
  Convert__regG0__MEMrr2_0,
  Convert__Reg1_1__MEMri2_0,
  Convert__Reg1_1__MEMrr2_0,
  Convert__MEMri2_1,
  Convert__Reg1_3__MEMri2_1,
  Convert__MEMrr2_1,
  Convert__Reg1_3__MEMrr2_1,
  Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4,
  Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4,
  Convert__Reg1_4__MEMri2_1,
  Convert__Reg1_4__MEMrr2_1__ASITag1_3,
  Convert__MembarTag1_0,
  Convert__Reg1_1,
  Convert__regG0__Reg1_0,
  Convert__Reg1_1__regG0__Reg1_0,
  Convert__regG0__Imm1_0,
  Convert__Reg1_1__regG0__Imm1_0,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8,
  Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_11,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_13,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_0,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_10,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_12,
  Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_14,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15,
  Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7,
  Convert__Reg1_0__regG0__Reg1_0,
  Convert__Reg1_0__Reg1_0__regG0,
  Convert__Reg1_1__Reg1_0__regG0,
  Convert__regASR27__regG0__Reg1_0,
  Convert__regASR27__regG0__Imm1_0,
  Convert__MEMri2_1__PrefetchTag1_3,
  Convert__MEMrr2_1__PrefetchTag1_3,
  Convert__MEMri2_1__PrefetchTag1_4,
  Convert__MEMrr2_1__ASITag1_3__PrefetchTag1_4,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Imm1_1,
  Convert__regG0__regG0__regG0,
  Convert__imm_95_8,
  Convert__Reg1_1__Imm1_0,
  Convert__Reg1_2__Imm1_0__Reg1_1,
  Convert__imm_95_0,
  Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1,
  Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1,
  Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0,
  Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0,
  Convert__MEMri2_2,
  Convert__MEMrr2_2,
  Convert__MEMri2_2__Reg1_0,
  Convert__MEMrr2_2__Reg1_0,
  Convert__MEMrr2_2__Reg1_0__ASITag1_4,
  Convert__Reg1_3__MEMri2_1__Tie0_1_1,
  Convert__Reg1_3__MEMrr2_1__Tie0_1_1,
  Convert__Reg1_4__MEMri2_1__Tie0_1_1,
  Convert__Reg1_4__MEMrr2_1__ASITag1_3__Tie0_1_1,
  Convert__regG0__Reg1_0__imm_95_8,
  Convert__regG0__Imm1_0__imm_95_8,
  Convert__regG0__Reg1_1__imm_95_8,
  Convert__regG0__Imm1_1__imm_95_8,
  Convert__Reg1_0__Reg1_2__imm_95_8,
  Convert__Reg1_0__Imm1_2__imm_95_8,
  Convert__Reg1_1__Reg1_3__imm_95_8,
  Convert__Reg1_1__Imm1_3__imm_95_8,
  Convert__Reg1_1__Reg1_3__Imm1_0,
  Convert__Reg1_1__Imm1_3__Imm1_0,
  Convert__Reg1_2__Reg1_4__Imm1_0,
  Convert__Reg1_2__Imm1_4__Imm1_0,
  Convert__regG0__Reg1_0__imm_95_13,
  Convert__regG0__Imm1_0__imm_95_13,
  Convert__regG0__Reg1_1__imm_95_13,
  Convert__regG0__Imm1_1__imm_95_13,
  Convert__Reg1_0__Reg1_2__imm_95_13,
  Convert__Reg1_0__Imm1_2__imm_95_13,
  Convert__Reg1_1__Reg1_3__imm_95_13,
  Convert__Reg1_1__Imm1_3__imm_95_13,
  Convert__regG0__Reg1_0__imm_95_5,
  Convert__regG0__Imm1_0__imm_95_5,
  Convert__regG0__Reg1_1__imm_95_5,
  Convert__regG0__Imm1_1__imm_95_5,
  Convert__Reg1_0__Reg1_2__imm_95_5,
  Convert__Reg1_0__Imm1_2__imm_95_5,
  Convert__Reg1_1__Reg1_3__imm_95_5,
  Convert__Reg1_1__Imm1_3__imm_95_5,
  Convert__regG0__Reg1_0__imm_95_1,
  Convert__regG0__Imm1_0__imm_95_1,
  Convert__regG0__Reg1_1__imm_95_1,
  Convert__regG0__Imm1_1__imm_95_1,
  Convert__Reg1_0__Reg1_2__imm_95_1,
  Convert__Reg1_0__Imm1_2__imm_95_1,
  Convert__Reg1_1__Reg1_3__imm_95_1,
  Convert__Reg1_1__Imm1_3__imm_95_1,
  Convert__regG0__Reg1_0__imm_95_10,
  Convert__regG0__Imm1_0__imm_95_10,
  Convert__regG0__Reg1_1__imm_95_10,
  Convert__regG0__Imm1_1__imm_95_10,
  Convert__Reg1_0__Reg1_2__imm_95_10,
  Convert__Reg1_0__Imm1_2__imm_95_10,
  Convert__Reg1_1__Reg1_3__imm_95_10,
  Convert__Reg1_1__Imm1_3__imm_95_10,
  Convert__regG0__Reg1_0__imm_95_11,
  Convert__regG0__Imm1_0__imm_95_11,
  Convert__regG0__Reg1_1__imm_95_11,
  Convert__regG0__Imm1_1__imm_95_11,
  Convert__Reg1_0__Reg1_2__imm_95_11,
  Convert__Reg1_0__Imm1_2__imm_95_11,
  Convert__Reg1_1__Reg1_3__imm_95_11,
  Convert__Reg1_1__Imm1_3__imm_95_11,
  Convert__regG0__Reg1_0__imm_95_12,
  Convert__regG0__Imm1_0__imm_95_12,
  Convert__regG0__Reg1_1__imm_95_12,
  Convert__regG0__Imm1_1__imm_95_12,
  Convert__Reg1_0__Reg1_2__imm_95_12,
  Convert__Reg1_0__Imm1_2__imm_95_12,
  Convert__Reg1_1__Reg1_3__imm_95_12,
  Convert__Reg1_1__Imm1_3__imm_95_12,
  Convert__regG0__Reg1_0__imm_95_3,
  Convert__regG0__Imm1_0__imm_95_3,
  Convert__regG0__Reg1_1__imm_95_3,
  Convert__regG0__Imm1_1__imm_95_3,
  Convert__Reg1_0__Reg1_2__imm_95_3,
  Convert__Reg1_0__Imm1_2__imm_95_3,
  Convert__Reg1_1__Reg1_3__imm_95_3,
  Convert__Reg1_1__Imm1_3__imm_95_3,
  Convert__regG0__Reg1_0__imm_95_2,
  Convert__regG0__Imm1_0__imm_95_2,
  Convert__regG0__Reg1_1__imm_95_2,
  Convert__regG0__Imm1_1__imm_95_2,
  Convert__Reg1_0__Reg1_2__imm_95_2,
  Convert__Reg1_0__Imm1_2__imm_95_2,
  Convert__Reg1_1__Reg1_3__imm_95_2,
  Convert__Reg1_1__Imm1_3__imm_95_2,
  Convert__regG0__Reg1_0__imm_95_4,
  Convert__regG0__Imm1_0__imm_95_4,
  Convert__regG0__Reg1_1__imm_95_4,
  Convert__regG0__Imm1_1__imm_95_4,
  Convert__Reg1_0__Reg1_2__imm_95_4,
  Convert__Reg1_0__Imm1_2__imm_95_4,
  Convert__Reg1_1__Reg1_3__imm_95_4,
  Convert__Reg1_1__Imm1_3__imm_95_4,
  Convert__regG0__Reg1_0__imm_95_0,
  Convert__regG0__Imm1_0__imm_95_0,
  Convert__regG0__Reg1_1__imm_95_0,
  Convert__regG0__Imm1_1__imm_95_0,
  Convert__Reg1_0__Reg1_2__imm_95_0,
  Convert__Reg1_0__Imm1_2__imm_95_0,
  Convert__Reg1_1__Reg1_3__imm_95_0,
  Convert__Reg1_1__Imm1_3__imm_95_0,
  Convert__regG0__Reg1_0__imm_95_9,
  Convert__regG0__Imm1_0__imm_95_9,
  Convert__regG0__Reg1_1__imm_95_9,
  Convert__regG0__Imm1_1__imm_95_9,
  Convert__Reg1_0__Reg1_2__imm_95_9,
  Convert__Reg1_0__Imm1_2__imm_95_9,
  Convert__Reg1_1__Reg1_3__imm_95_9,
  Convert__Reg1_1__Imm1_3__imm_95_9,
  Convert__regG0__Reg1_0__imm_95_6,
  Convert__regG0__Imm1_0__imm_95_6,
  Convert__regG0__Reg1_1__imm_95_6,
  Convert__regG0__Imm1_1__imm_95_6,
  Convert__Reg1_0__Reg1_2__imm_95_6,
  Convert__Reg1_0__Imm1_2__imm_95_6,
  Convert__Reg1_1__Reg1_3__imm_95_6,
  Convert__Reg1_1__Imm1_3__imm_95_6,
  Convert__regG0__Reg1_0__imm_95_14,
  Convert__regG0__Imm1_0__imm_95_14,
  Convert__regG0__Reg1_1__imm_95_14,
  Convert__regG0__Imm1_1__imm_95_14,
  Convert__Reg1_0__Reg1_2__imm_95_14,
  Convert__Reg1_0__Imm1_2__imm_95_14,
  Convert__Reg1_1__Reg1_3__imm_95_14,
  Convert__Reg1_1__Imm1_3__imm_95_14,
  Convert__regG0__Reg1_0__regG0,
  Convert__regG0__Reg1_0__imm_95_15,
  Convert__regG0__Imm1_0__imm_95_15,
  Convert__regG0__Reg1_1__imm_95_15,
  Convert__regG0__Imm1_1__imm_95_15,
  Convert__Reg1_0__Reg1_2__imm_95_15,
  Convert__Reg1_0__Imm1_2__imm_95_15,
  Convert__Reg1_1__Reg1_3__imm_95_15,
  Convert__Reg1_1__Imm1_3__imm_95_15,
  Convert__regG0__Reg1_0__imm_95_7,
  Convert__regG0__Imm1_0__imm_95_7,
  Convert__regG0__Reg1_1__imm_95_7,
  Convert__regG0__Imm1_1__imm_95_7,
  Convert__Reg1_0__Reg1_2__imm_95_7,
  Convert__Reg1_0__Imm1_2__imm_95_7,
  Convert__Reg1_1__Reg1_3__imm_95_7,
  Convert__Reg1_1__Imm1_3__imm_95_7,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][11] = {
  // Convert__Reg1_2__Reg1_0__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__TailRelocSymAdd_TLS1_3
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addTailRelocSymOperands, 4, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_0__Reg1_1__Imm1_2
  { CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Imm1_0__imm_95_8
  { CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_8
  { CVT_95_addImmOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_1__Imm1_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_8
  { CVT_95_addImmOperands, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_2__Imm1_0
  { CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_3__imm_95_8
  { CVT_95_addImmOperands, 4, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Imm1_3__Imm1_0
  { CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_4__Imm1_0
  { CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0__imm_95_13
  { CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_13
  { CVT_95_addImmOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_13
  { CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_13
  { CVT_95_addImmOperands, 4, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0__imm_95_5
  { CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_5
  { CVT_95_addImmOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_5
  { CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_5
  { CVT_95_addImmOperands, 4, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_1
  { CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_1
  { CVT_95_addImmOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_1
  { CVT_95_addImmOperands, 4, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_10
  { CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_10
  { CVT_95_addImmOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_10
  { CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_10
  { CVT_95_addImmOperands, 4, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_11
  { CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_11
  { CVT_95_addImmOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_11
  { CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_11
  { CVT_95_addImmOperands, 4, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_12
  { CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_12
  { CVT_95_addImmOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_12
  { CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_12
  { CVT_95_addImmOperands, 4, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_3
  { CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_3
  { CVT_95_addImmOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_3
  { CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_3
  { CVT_95_addImmOperands, 4, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_2
  { CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_2
  { CVT_95_addImmOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_2
  { CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_4
  { CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_4
  { CVT_95_addImmOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_4
  { CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_4
  { CVT_95_addImmOperands, 4, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_0
  { CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_0
  { CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_0
  { CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_9
  { CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_9
  { CVT_95_addImmOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_9
  { CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_9
  { CVT_95_addImmOperands, 4, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_6
  { CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_6
  { CVT_95_addImmOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_6
  { CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_6
  { CVT_95_addImmOperands, 4, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_14
  { CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_14
  { CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_14
  { CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_14
  { CVT_95_addImmOperands, 4, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Imm1_2__Imm1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__Imm1_0__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_4__Imm1_0__Reg1_3
  { CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 1, CVT_95_Reg, 4, CVT_Done },
  // Convert__Imm1_1__imm_95_1__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_1__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_1__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_1, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_7__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_7, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_7__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_7__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_7, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_6__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_6, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_6__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_6__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_6, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_2__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_2__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_2__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_2, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_3__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_3__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_3__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_3, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_5__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_5, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_5__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_5__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_5, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__regG0__Reg1_1__Reg1_0
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__regG0__Reg1_1__Imm1_0
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_0__imm_95_15
  { CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_15
  { CVT_95_addImmOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_15
  { CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_15
  { CVT_95_addImmOperands, 4, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Imm1_0__imm_95_7
  { CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Imm1_1__imm_95_7
  { CVT_95_addImmOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Imm1_2__imm_95_7
  { CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Imm1_3__imm_95_7
  { CVT_95_addImmOperands, 4, CVT_imm_95_7, 0, CVT_Done },
  // Convert__CallTarget1_0
  { CVT_95_addCallTargetOperands, 1, CVT_Done },
  // Convert__regO7__MEMri2_0
  { CVT_regO7, 0, CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__regO7__MEMrr2_0
  { CVT_regO7, 0, CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__CallTarget1_0__Imm1_1
  { CVT_95_addCallTargetOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__CallTarget1_0__TailRelocSymCall_TLS1_1
  { CVT_95_addCallTargetOperands, 1, CVT_95_addTailRelocSymOperands, 2, CVT_Done },
  // Convert__MEMri2_0__Imm1_1
  { CVT_95_addMEMriOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__MEMrr2_0__Imm1_1
  { CVT_95_addMEMrrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128
  { CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_5_5, CVT_imm_95_128, 0, CVT_Done },
  // Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1
  { CVT_95_Reg, 6, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3
  { CVT_95_Reg, 6, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_addASITagOperands, 4, CVT_Done },
  // Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136
  { CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_5_5, CVT_imm_95_136, 0, CVT_Done },
  // Convert__Reg1_0__regG0__regG0
  { CVT_95_Reg, 1, CVT_regG0, 0, CVT_regG0, 0, CVT_Done },
  // Convert__MEMri2_1__regG0
  { CVT_95_addMEMriOperands, 2, CVT_regG0, 0, CVT_Done },
  // Convert__MEMrr2_1__regG0
  { CVT_95_addMEMrrOperands, 2, CVT_regG0, 0, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__regG0__Reg1_0__Reg1_1
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__regG0__Reg1_0__Imm1_1
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_3__Imm1_0__Reg1_1__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_3__Imm1_0__Reg1_1__Imm1_2
  { CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Imm1_2__imm_95_13__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_13__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_5__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_5__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_1__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_1__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_10__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_10__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_11__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_11__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_12__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_12__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_3__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_3__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_2__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_2__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_4__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_4__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_9__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_9__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_6__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_6__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_14__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_14__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_15__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_15__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_7__Reg1_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_2__imm_95_7__Reg1_0__Imm1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_1__imm_95_8__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_8, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_8__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_8, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_8__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_8, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_9__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_9, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_9__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_9__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_9, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_11__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_11, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_11__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_11__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_11, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_4__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_4, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_4__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_4__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_4, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_13__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_13, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_13__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_13__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_13, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_0__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_0__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_0__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_15__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_15, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_15__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_15__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_15, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_10__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_10, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_10__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_10__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_10, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_12__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_12, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_12__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_12__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_12, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__Imm1_1__imm_95_14__Reg1_0
  { CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_2__imm_95_14__Reg1_1
  { CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Imm1_3__imm_95_14__Reg1_2
  { CVT_95_addImmOperands, 4, CVT_imm_95_14, 0, CVT_95_Reg, 3, CVT_Done },
  // Convert__regFCC0__Reg1_0__Reg1_1
  { CVT_regFCC0, 0, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__MEMri2_0
  { CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__MEMrr2_0
  { CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__regG0__MEMri2_0
  { CVT_regG0, 0, CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__regG0__MEMrr2_0
  { CVT_regG0, 0, CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__Reg1_1__MEMri2_0
  { CVT_95_Reg, 2, CVT_95_addMEMriOperands, 1, CVT_Done },
  // Convert__Reg1_1__MEMrr2_0
  { CVT_95_Reg, 2, CVT_95_addMEMrrOperands, 1, CVT_Done },
  // Convert__MEMri2_1
  { CVT_95_addMEMriOperands, 2, CVT_Done },
  // Convert__Reg1_3__MEMri2_1
  { CVT_95_Reg, 4, CVT_95_addMEMriOperands, 2, CVT_Done },
  // Convert__MEMrr2_1
  { CVT_95_addMEMrrOperands, 2, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_95_addTailRelocSymOperands, 5, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_95_addTailRelocSymOperands, 5, CVT_Done },
  // Convert__Reg1_4__MEMri2_1
  { CVT_95_Reg, 5, CVT_95_addMEMriOperands, 2, CVT_Done },
  // Convert__Reg1_4__MEMrr2_1__ASITag1_3
  { CVT_95_Reg, 5, CVT_95_addMEMrrOperands, 2, CVT_95_addASITagOperands, 4, CVT_Done },
  // Convert__MembarTag1_0
  { CVT_95_addMembarTagOperands, 1, CVT_Done },
  // Convert__Reg1_1
  { CVT_95_Reg, 2, CVT_Done },
  // Convert__regG0__Reg1_0
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__regG0__Reg1_0
  { CVT_95_Reg, 2, CVT_regG0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__regG0__Imm1_0
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__regG0__Imm1_0
  { CVT_95_Reg, 2, CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_addImmOperands, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Tied, Tie0_3_3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__regG0__Reg1_0
  { CVT_95_Reg, 1, CVT_regG0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_0__regG0
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_regG0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__regG0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_regG0, 0, CVT_Done },
  // Convert__regASR27__regG0__Reg1_0
  { CVT_regASR27, 0, CVT_regG0, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__regASR27__regG0__Imm1_0
  { CVT_regASR27, 0, CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__MEMri2_1__PrefetchTag1_3
  { CVT_95_addMEMriOperands, 2, CVT_95_addPrefetchTagOperands, 4, CVT_Done },
  // Convert__MEMrr2_1__PrefetchTag1_3
  { CVT_95_addMEMrrOperands, 2, CVT_95_addPrefetchTagOperands, 4, CVT_Done },
  // Convert__MEMri2_1__PrefetchTag1_4
  { CVT_95_addMEMriOperands, 2, CVT_95_addPrefetchTagOperands, 5, CVT_Done },
  // Convert__MEMrr2_1__ASITag1_3__PrefetchTag1_4
  { CVT_95_addMEMrrOperands, 2, CVT_95_addASITagOperands, 4, CVT_95_addPrefetchTagOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regG0__regG0__regG0
  { CVT_regG0, 0, CVT_regG0, 0, CVT_regG0, 0, CVT_Done },
  // Convert__imm_95_8
  { CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_0__Reg1_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__imm_95_0
  { CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addShiftAmtImm5Operands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addShiftAmtImm6Operands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__MEMri2_2
  { CVT_95_addMEMriOperands, 3, CVT_Done },
  // Convert__MEMrr2_2
  { CVT_95_addMEMrrOperands, 3, CVT_Done },
  // Convert__MEMri2_2__Reg1_0
  { CVT_95_addMEMriOperands, 3, CVT_95_Reg, 1, CVT_Done },
  // Convert__MEMrr2_2__Reg1_0
  { CVT_95_addMEMrrOperands, 3, CVT_95_Reg, 1, CVT_Done },
  // Convert__MEMrr2_2__Reg1_0__ASITag1_4
  { CVT_95_addMEMrrOperands, 3, CVT_95_Reg, 1, CVT_95_addASITagOperands, 5, CVT_Done },
  // Convert__Reg1_3__MEMri2_1__Tie0_1_1
  { CVT_95_Reg, 4, CVT_95_addMEMriOperands, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_3__MEMrr2_1__Tie0_1_1
  { CVT_95_Reg, 4, CVT_95_addMEMrrOperands, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_4__MEMri2_1__Tie0_1_1
  { CVT_95_Reg, 5, CVT_95_addMEMriOperands, 2, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_4__MEMrr2_1__ASITag1_3__Tie0_1_1
  { CVT_95_Reg, 5, CVT_95_addMEMrrOperands, 2, CVT_95_addASITagOperands, 4, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_8
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_8
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_8
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_8
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_8
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_3__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Imm1_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_13
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_13
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_13
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_13
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_13
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_13, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_5
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_5
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_5
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_5
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_5
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_5, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_1
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_1
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_1
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_1
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_1
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_10
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_10
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_10
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_10
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_10
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_11
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_11
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_11
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_11
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_11
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_11, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_12
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_12
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_12
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_12
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_12
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_12, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_3
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_3
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_3
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_3
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_3
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_3, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_2
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_2
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_2
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_2
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_2
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_2, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_4
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_4
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_4
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_4
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_4
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_4, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_0
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_0
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_0
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_0
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_9
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_9
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_9
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_9
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_9
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_9, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_6
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_6
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_6
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_6
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_6
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_6, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_14
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_14
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_14
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_14
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_14
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_14, 0, CVT_Done },
  // Convert__regG0__Reg1_0__regG0
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_regG0, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_15
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_15
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_15
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_15
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_15
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regG0__Reg1_0__imm_95_7
  { CVT_regG0, 0, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__regG0__Imm1_0__imm_95_7
  { CVT_regG0, 0, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__regG0__Reg1_1__imm_95_7
  { CVT_regG0, 0, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__regG0__Imm1_1__imm_95_7
  { CVT_regG0, 0, CVT_95_addImmOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Imm1_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_3__imm_95_7
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_3__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_imm_95_7, 0, CVT_Done },
};

void SparcAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_Reg:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addImmOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addTailRelocSymOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addTailRelocSymOperands(Inst, 1);
      break;
    case CVT_imm_95_8:
      Inst.addOperand(MCOperand::createImm(8));
      break;
    case CVT_imm_95_13:
      Inst.addOperand(MCOperand::createImm(13));
      break;
    case CVT_imm_95_5:
      Inst.addOperand(MCOperand::createImm(5));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_10:
      Inst.addOperand(MCOperand::createImm(10));
      break;
    case CVT_imm_95_11:
      Inst.addOperand(MCOperand::createImm(11));
      break;
    case CVT_imm_95_12:
      Inst.addOperand(MCOperand::createImm(12));
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_imm_95_4:
      Inst.addOperand(MCOperand::createImm(4));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_imm_95_9:
      Inst.addOperand(MCOperand::createImm(9));
      break;
    case CVT_imm_95_6:
      Inst.addOperand(MCOperand::createImm(6));
      break;
    case CVT_imm_95_14:
      Inst.addOperand(MCOperand::createImm(14));
      break;
    case CVT_imm_95_7:
      Inst.addOperand(MCOperand::createImm(7));
      break;
    case CVT_regG0:
      Inst.addOperand(MCOperand::createReg(SP::G0));
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addCallTargetOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addCallTargetOperands(Inst, 1);
      break;
    case CVT_regO7:
      Inst.addOperand(MCOperand::createReg(SP::O7));
      break;
    case CVT_95_addMEMriOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addMEMriOperands(Inst, 2);
      break;
    case CVT_95_addMEMrrOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addMEMrrOperands(Inst, 2);
      break;
    case CVT_imm_95_128:
      Inst.addOperand(MCOperand::createImm(128));
      break;
    case CVT_95_addASITagOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addASITagOperands(Inst, 1);
      break;
    case CVT_imm_95_136:
      Inst.addOperand(MCOperand::createImm(136));
      break;
    case CVT_regFCC0:
      Inst.addOperand(MCOperand::createReg(SP::FCC0));
      break;
    case CVT_95_addMembarTagOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addMembarTagOperands(Inst, 1);
      break;
    case CVT_regASR27:
      Inst.addOperand(MCOperand::createReg(SP::ASR27));
      break;
    case CVT_95_addPrefetchTagOperands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addPrefetchTagOperands(Inst, 1);
      break;
    case CVT_95_addShiftAmtImm5Operands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addShiftAmtImm5Operands(Inst, 1);
      break;
    case CVT_95_addShiftAmtImm6Operands:
      static_cast<SparcOperand &>(*Operands[OpIdx]).addShiftAmtImm6Operands(Inst, 1);
      break;
    }
  }
}

void SparcAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addTailRelocSymOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_8:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_13:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_10:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_11:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_12:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_9:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_6:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_14:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_7:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regG0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addCallTargetOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regO7:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addMEMriOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addMEMrrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_imm_95_128:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addASITagOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_136:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regFCC0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addMembarTagOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regASR27:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addPrefetchTagOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addShiftAmtImm5Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addShiftAmtImm6Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__PCT_asi, // '%asi'
  MCK__PCT_xcc, // '%xcc'
  MCK__43_, // '+'
  MCK_1, // '1'
  MCK_3, // '3'
  MCK_5, // '5'
  MCK__91_, // '['
  MCK__93_, // ']'
  MCK_a, // 'a'
  MCK_pn, // 'pn'
  MCK_pt, // 'pt'
  MCK_LAST_TOKEN = MCK_pt,
  MCK_Reg12, // derived register class
  MCK_CPQ, // register class 'CPQ'
  MCK_CPSR, // register class 'CPSR'
  MCK_FCC0, // register class 'FCC0'
  MCK_FQ, // register class 'FQ'
  MCK_FSR, // register class 'FSR'
  MCK_G0, // register class 'G0'
  MCK_ICC, // register class 'ICC'
  MCK_PSR, // register class 'PSR'
  MCK_TBR, // register class 'TBR'
  MCK_WIM, // register class 'WIM'
  MCK_Reg25, // derived register class
  MCK_Reg24, // derived register class
  MCK_FCCRegs, // register class 'FCCRegs'
  MCK_GPRIncomingArg, // register class 'GPRIncomingArg'
  MCK_GPROutgoingArg, // register class 'GPROutgoingArg'
  MCK_LowQFPRegs, // register class 'LowQFPRegs'
  MCK_CoprocPair, // register class 'CoprocPair'
  MCK_IntPair, // register class 'IntPair'
  MCK_LowDFPRegs, // register class 'LowDFPRegs'
  MCK_QFPRegs, // register class 'QFPRegs'
  MCK_PRRegs, // register class 'PRRegs'
  MCK_CoprocRegs, // register class 'CoprocRegs'
  MCK_DFPRegs, // register class 'DFPRegs'
  MCK_FPRegs, // register class 'FPRegs'
  MCK_IntRegs, // register class 'IntRegs,I64Regs'
  MCK_ASRRegs, // register class 'ASRRegs'
  MCK_LAST_REGISTER = MCK_ASRRegs,
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ASITag, // user defined class 'SparcASITagAsmOperand'
  MCK_CallTarget, // user defined class 'SparcCallTargetAsmOperand'
  MCK_MEMri, // user defined class 'SparcMEMriAsmOperand'
  MCK_MEMrr, // user defined class 'SparcMEMrrAsmOperand'
  MCK_MembarTag, // user defined class 'SparcMembarTagAsmOperand'
  MCK_PrefetchTag, // user defined class 'SparcPrefetchTagAsmOperand'
  MCK_ShiftAmtImm5, // user defined class 'anonymous_8744'
  MCK_ShiftAmtImm6, // user defined class 'anonymous_8745'
  MCK_TailRelocSymLoad_GOT, // user defined class 'anonymous_8746'
  MCK_TailRelocSymAdd_TLS, // user defined class 'anonymous_8747'
  MCK_TailRelocSymLoad_TLS, // user defined class 'anonymous_8748'
  MCK_TailRelocSymCall_TLS, // user defined class 'anonymous_8749'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 7 strings to match.
    switch (Name[0]) {
    default: break;
    case '+':	 // 1 string to match.
      return MCK__43_;	 // "+"
    case '1':	 // 1 string to match.
      return MCK_1;	 // "1"
    case '3':	 // 1 string to match.
      return MCK_3;	 // "3"
    case '5':	 // 1 string to match.
      return MCK_5;	 // "5"
    case '[':	 // 1 string to match.
      return MCK__91_;	 // "["
    case ']':	 // 1 string to match.
      return MCK__93_;	 // "]"
    case 'a':	 // 1 string to match.
      return MCK_a;	 // "a"
    }
    break;
  case 2:	 // 2 strings to match.
    if (Name[0] != 'p')
      break;
    switch (Name[1]) {
    default: break;
    case 'n':	 // 1 string to match.
      return MCK_pn;	 // "pn"
    case 't':	 // 1 string to match.
      return MCK_pt;	 // "pt"
    }
    break;
  case 4:	 // 2 strings to match.
    if (Name[0] != '%')
      break;
    switch (Name[1]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Name.data()+2, "si", 2) != 0)
        break;
      return MCK__PCT_asi;	 // "%asi"
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+2, "cc", 2) != 0)
        break;
      return MCK__PCT_xcc;	 // "%xcc"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  [[maybe_unused]] static constexpr struct {
    uint32_t Offset;
    uint16_t Start;
    uint16_t Length;
  } Table[] = {
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 34, 6},
    {6, 0, 0},
    {6, 0, 0},
    {6, 26, 1},
    {7, 0, 0},
    {7, 0, 0},
    {7, 38, 1},
    {8, 0, 0},
    {8, 0, 0},
    {8, 0, 0},
    {8, 0, 0},
    {8, 31, 1},
    {9, 31, 1},
    {10, 0, 0},
    {10, 38, 1},
    {11, 38, 1},
    {12, 33, 1},
    {13, 0, 0},
    {13, 0, 0},
    {13, 36, 1},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
    {14, 0, 0},
  };

  static constexpr uint8_t Data[] = {
    0xE1,
    0x3F,
  };

  auto &Entry = Table[A];
  unsigned Idx = B - Entry.Start;
  if (Idx >= Entry.Length)
    return false;
  Idx += Entry.Offset;
  return (Data[Idx / 8] >> (Idx % 8)) & 1;
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  SparcOperand &Operand = (SparcOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ASITag: {
    DiagnosticPredicate DP(Operand.isASITag());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_CallTarget: {
    DiagnosticPredicate DP(Operand.isCallTarget());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MEMri: {
    DiagnosticPredicate DP(Operand.isMEMri());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MEMrr: {
    DiagnosticPredicate DP(Operand.isMEMrr());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MembarTag: {
    DiagnosticPredicate DP(Operand.isMembarTag());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PrefetchTag: {
    DiagnosticPredicate DP(Operand.isPrefetchTag());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ShiftAmtImm5: {
    DiagnosticPredicate DP(Operand.isShiftAmtImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ShiftAmtImm6: {
    DiagnosticPredicate DP(Operand.isShiftAmtImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_TailRelocSymLoad_GOT: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_TailRelocSymAdd_TLS: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_TailRelocSymLoad_TLS: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_TailRelocSymCall_TLS: {
    DiagnosticPredicate DP(Operand.isTailRelocSym());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  } // end switch (Kind)

  if (Operand.isReg()) {
    static constexpr uint16_t Table[SP::NUM_TARGET_REGS] = {
      InvalidMatchClass,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_CPQ,
      MCK_CPSR,
      MCK_PRRegs,
      MCK_FQ,
      MCK_FSR,
      MCK_PRRegs,
      MCK_ICC,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_PSR,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_TBR,
      MCK_Reg12,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_PRRegs,
      MCK_WIM,
      MCK_PRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_ASRRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_CoprocRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_LowDFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_DFPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FPRegs,
      MCK_FCC0,
      MCK_FCCRegs,
      MCK_FCCRegs,
      MCK_FCCRegs,
      MCK_G0,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_GPRIncomingArg,
      MCK_GPRIncomingArg,
      MCK_GPRIncomingArg,
      MCK_GPRIncomingArg,
      MCK_GPRIncomingArg,
      MCK_GPRIncomingArg,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_GPROutgoingArg,
      MCK_GPROutgoingArg,
      MCK_GPROutgoingArg,
      MCK_GPROutgoingArg,
      MCK_GPROutgoingArg,
      MCK_GPROutgoingArg,
      MCK_IntRegs,
      MCK_IntRegs,
      MCK_LowQFPRegs,
      MCK_LowQFPRegs,
      MCK_LowQFPRegs,
      MCK_LowQFPRegs,
      MCK_LowQFPRegs,
      MCK_LowQFPRegs,
      MCK_LowQFPRegs,
      MCK_LowQFPRegs,
      MCK_QFPRegs,
      MCK_QFPRegs,
      MCK_QFPRegs,
      MCK_QFPRegs,
      MCK_QFPRegs,
      MCK_QFPRegs,
      MCK_QFPRegs,
      MCK_QFPRegs,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_CoprocPair,
      MCK_IntPair,
      MCK_IntPair,
      MCK_IntPair,
      MCK_IntPair,
      MCK_Reg25,
      MCK_Reg25,
      MCK_Reg25,
      MCK_IntPair,
      MCK_IntPair,
      MCK_IntPair,
      MCK_IntPair,
      MCK_IntPair,
      MCK_Reg24,
      MCK_Reg24,
      MCK_Reg24,
      MCK_IntPair,
    };

    MCRegister Reg = Operand.getReg();
    MatchClassKind OpKind = Reg.isPhysical() ? (MatchClassKind)Table[Reg.id()] : InvalidMatchClass;
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__PCT_asi: return "MCK__PCT_asi";
  case MCK__PCT_xcc: return "MCK__PCT_xcc";
  case MCK__43_: return "MCK__43_";
  case MCK_1: return "MCK_1";
  case MCK_3: return "MCK_3";
  case MCK_5: return "MCK_5";
  case MCK__91_: return "MCK__91_";
  case MCK__93_: return "MCK__93_";
  case MCK_a: return "MCK_a";
  case MCK_pn: return "MCK_pn";
  case MCK_pt: return "MCK_pt";
  case MCK_Reg12: return "MCK_Reg12";
  case MCK_CPQ: return "MCK_CPQ";
  case MCK_CPSR: return "MCK_CPSR";
  case MCK_FCC0: return "MCK_FCC0";
  case MCK_FQ: return "MCK_FQ";
  case MCK_FSR: return "MCK_FSR";
  case MCK_G0: return "MCK_G0";
  case MCK_ICC: return "MCK_ICC";
  case MCK_PSR: return "MCK_PSR";
  case MCK_TBR: return "MCK_TBR";
  case MCK_WIM: return "MCK_WIM";
  case MCK_Reg25: return "MCK_Reg25";
  case MCK_Reg24: return "MCK_Reg24";
  case MCK_FCCRegs: return "MCK_FCCRegs";
  case MCK_GPRIncomingArg: return "MCK_GPRIncomingArg";
  case MCK_GPROutgoingArg: return "MCK_GPROutgoingArg";
  case MCK_LowQFPRegs: return "MCK_LowQFPRegs";
  case MCK_CoprocPair: return "MCK_CoprocPair";
  case MCK_IntPair: return "MCK_IntPair";
  case MCK_LowDFPRegs: return "MCK_LowDFPRegs";
  case MCK_QFPRegs: return "MCK_QFPRegs";
  case MCK_PRRegs: return "MCK_PRRegs";
  case MCK_CoprocRegs: return "MCK_CoprocRegs";
  case MCK_DFPRegs: return "MCK_DFPRegs";
  case MCK_FPRegs: return "MCK_FPRegs";
  case MCK_IntRegs: return "MCK_IntRegs";
  case MCK_ASRRegs: return "MCK_ASRRegs";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ASITag: return "MCK_ASITag";
  case MCK_CallTarget: return "MCK_CallTarget";
  case MCK_MEMri: return "MCK_MEMri";
  case MCK_MEMrr: return "MCK_MEMrr";
  case MCK_MembarTag: return "MCK_MembarTag";
  case MCK_PrefetchTag: return "MCK_PrefetchTag";
  case MCK_ShiftAmtImm5: return "MCK_ShiftAmtImm5";
  case MCK_ShiftAmtImm6: return "MCK_ShiftAmtImm6";
  case MCK_TailRelocSymLoad_GOT: return "MCK_TailRelocSymLoad_GOT";
  case MCK_TailRelocSymAdd_TLS: return "MCK_TailRelocSymAdd_TLS";
  case MCK_TailRelocSymLoad_TLS: return "MCK_TailRelocSymLoad_TLS";
  case MCK_TailRelocSymCall_TLS: return "MCK_TailRelocSymCall_TLS";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset SparcAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[Sparc::FeatureV9])
    Features.set(Feature_Is64BitBit);
  if (FB[Sparc::FeatureSoftMulDiv])
    Features.set(Feature_UseSoftMulDivBit);
  if (FB[Sparc::FeatureV9])
    Features.set(Feature_HasV9Bit);
  if (FB[Sparc::FeatureVIS])
    Features.set(Feature_HasVISBit);
  if (FB[Sparc::FeatureVIS2])
    Features.set(Feature_HasVIS2Bit);
  if (FB[Sparc::FeatureVIS3])
    Features.set(Feature_HasVIS3Bit);
  if (FB[Sparc::FeatureUA2005])
    Features.set(Feature_HasUA2005Bit);
  if (FB[Sparc::FeatureUA2007])
    Features.set(Feature_HasUA2007Bit);
  if (FB[Sparc::FeatureOSA2011])
    Features.set(Feature_HasOSA2011Bit);
  if (FB[Sparc::FeatureCrypto])
    Features.set(Feature_HasCryptoBit);
  if (FB[Sparc::LeonCASA] || FB[Sparc::FeatureV9])
    Features.set(Feature_HasCASABit);
  if (FB[Sparc::FeaturePWRPSR])
    Features.set(Feature_HasPWRPSRBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const SparcAsmParser&AsmParser,
                               unsigned Kind, const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\003add\005addcc\004addx\005addxc\006addxcc\007addxccc\014aes_dround01\016"
    "aes_dround01_l\014aes_dround23\016aes_dround23_l\014aes_eround01\016aes"
    "_eround01_l\014aes_eround23\016aes_eround23_l\014aes_kexpand0\014aes_ke"
    "xpand1\014aes_kexpand2\talignaddr\nalignaddrl\010allclean\003and\005and"
    "cc\004andn\006andncc\007array16\007array32\006array8\001b\002ba\003bcc\004"
    "bclr\003bcs\002be\003beq\002bg\003bge\004bgeu\003bgt\003bgu\002bl\003bl"
    "e\004bleu\003blt\003blu\005bmask\002bn\003bne\004bneg\003bnz\004bpos\002"
    "br\003bre\005brgez\004brgz\005brlez\004brlz\004brne\004brnz\003brz\004b"
    "set\010bshuffle\004btog\004btst\003bvc\003bvs\002bz\004call\ncamellia_f"
    "\013camellia_fl\014camellia_fli\003cas\004casa\004casl\004casx\005casxa"
    "\005casxl\002cb\003cb0\004cb01\005cb012\005cb013\004cb02\005cb023\004cb"
    "03\003cb1\004cb12\005cb123\004cb13\003cb2\004cb23\003cb3\003cba\003cbn\003"
    "clr\004clrb\004clrh\007cmask16\007cmask32\006cmask8\003cmp\006crc32c\003"
    "cwb\005cwbcc\005cwbcs\004cwbe\004cwbg\005cwbge\006cwbgeu\005cwbgu\004cw"
    "bl\005cwble\006cwbleu\005cwblu\005cwbne\006cwbneg\006cwbpos\005cwbvc\005"
    "cwbvs\003cxb\005cxbcc\005cxbcs\004cxbe\004cxbg\005cxbge\006cxbgeu\005cx"
    "bgu\004cxbl\005cxble\006cxbleu\005cxblu\005cxbne\006cxbneg\006cxbpos\005"
    "cxbvc\005cxbvs\003dec\005deccc\007des_iip\006des_ip\013des_kexpand\tdes"
    "_round\004done\006edge16\007edge16l\010edge16ln\007edge16n\006edge32\007"
    "edge32l\010edge32ln\007edge32n\005edge8\006edge8l\007edge8ln\006edge8n\005"
    "fabsd\005fabsq\005fabss\005faddd\005faddq\005fadds\nfaligndata\004fand\010"
    "fandnot1\tfandnot1s\010fandnot2\tfandnot2s\005fands\002fb\003fba\003fbe"
    "\003fbg\004fbge\003fbl\004fble\004fblg\003fbn\004fbne\004fbnz\003fbo\003"
    "fbu\004fbue\004fbug\005fbuge\004fbul\005fbule\003fbz\010fchksm16\005fcm"
    "pd\006fcmped\006fcmpeq\010fcmpeq16\010fcmpeq32\006fcmpes\010fcmpgt16\010"
    "fcmpgt32\010fcmple16\010fcmple32\010fcmpne16\010fcmpne32\005fcmpq\005fc"
    "mps\005fdivd\005fdivq\005fdivs\006fdmulq\005fdtoi\005fdtoq\005fdtos\005"
    "fdtox\007fexpand\006fhaddd\006fhadds\006fhsubd\006fhsubs\005fitod\005fi"
    "toq\005fitos\006flcmpd\006flcmps\005flush\006flushw\006fmaddd\006fmadds"
    "\007fmean16\005fmovd\006fmovda\007fmovdcc\007fmovdcs\006fmovde\007fmovd"
    "eq\006fmovdg\007fmovdge\010fmovdgeu\007fmovdgt\007fmovdgu\006fmovdl\007"
    "fmovdle\010fmovdleu\007fmovdlg\007fmovdlt\007fmovdlu\006fmovdn\007fmovd"
    "ne\010fmovdneg\007fmovdnz\006fmovdo\010fmovdpos\006fmovdu\007fmovdue\007"
    "fmovdug\010fmovduge\007fmovdul\010fmovdule\007fmovdvc\007fmovdvs\006fmo"
    "vdz\005fmovq\006fmovqa\007fmovqcc\007fmovqcs\006fmovqe\007fmovqeq\006fm"
    "ovqg\007fmovqge\010fmovqgeu\007fmovqgt\007fmovqgu\006fmovql\007fmovqle\010"
    "fmovqleu\007fmovqlg\007fmovqlt\007fmovqlu\006fmovqn\007fmovqne\010fmovq"
    "neg\007fmovqnz\006fmovqo\010fmovqpos\006fmovqu\007fmovque\007fmovqug\010"
    "fmovquge\007fmovqul\010fmovqule\007fmovqvc\007fmovqvs\006fmovqz\006fmov"
    "rd\007fmovrde\tfmovrdgez\010fmovrdgz\tfmovrdlez\010fmovrdlz\010fmovrdne"
    "\010fmovrdnz\007fmovrdz\006fmovrq\007fmovrqe\tfmovrqgez\010fmovrqgz\tfm"
    "ovrqlez\010fmovrqlz\010fmovrqne\010fmovrqnz\007fmovrqz\006fmovrs\007fmo"
    "vrse\tfmovrsgez\010fmovrsgz\tfmovrslez\010fmovrslz\010fmovrsne\010fmovr"
    "snz\007fmovrsz\005fmovs\006fmovsa\007fmovscc\007fmovscs\006fmovse\007fm"
    "ovseq\006fmovsg\007fmovsge\010fmovsgeu\007fmovsgt\007fmovsgu\006fmovsl\007"
    "fmovsle\010fmovsleu\007fmovslg\007fmovslt\007fmovslu\006fmovsn\007fmovs"
    "ne\010fmovsneg\007fmovsnz\006fmovso\010fmovspos\006fmovsu\007fmovsue\007"
    "fmovsug\010fmovsuge\007fmovsul\010fmovsule\007fmovsvc\007fmovsvs\006fmo"
    "vsz\006fmsubd\006fmsubs\nfmul8sux16\nfmul8ulx16\010fmul8x16\nfmul8x16al"
    "\nfmul8x16au\005fmuld\013fmuld8sux16\013fmuld8ulx16\005fmulq\005fmuls\006"
    "fnaddd\006fnadds\005fnand\006fnands\005fnegd\005fnegq\005fnegs\007fnhad"
    "dd\007fnhadds\007fnmaddd\007fnmadds\007fnmsubd\007fnmsubs\006fnmuld\006"
    "fnmuls\004fnor\005fnors\005fnot1\006fnot1s\005fnot2\006fnot2s\007fnsmul"
    "d\004fone\005fones\003for\007fornot1\010fornot1s\007fornot2\010fornot2s"
    "\004fors\007fpack16\007fpack32\010fpackfix\007fpadd16\010fpadd16s\007fp"
    "add32\010fpadd32s\007fpadd64\007fpmaddx\tfpmaddxhi\007fpmerge\007fpsub1"
    "6\010fpsub16s\007fpsub32\010fpsub32s\005fqtod\005fqtoi\005fqtos\005fqto"
    "x\007fslas16\007fslas32\006fsll16\006fsll32\006fsmuld\006fsqrtd\006fsqr"
    "tq\006fsqrts\006fsra16\006fsra32\005fsrc1\006fsrc1s\005fsrc2\006fsrc2s\006"
    "fsrl16\006fsrl32\005fstod\005fstoi\005fstoq\005fstox\005fsubd\005fsubq\005"
    "fsubs\005fxnor\006fxnors\004fxor\005fxors\005fxtod\005fxtoq\005fxtos\005"
    "fzero\006fzeros\003inc\005inccc\006invalw\003jmp\004jmpl\002ld\003lda\003"
    "ldd\004ldda\003ldq\004ldqa\004ldsb\005ldsba\004ldsh\005ldsha\006ldstub\007"
    "ldstuba\004ldsw\005ldswa\004ldub\005lduba\004lduh\005lduha\003ldx\004ld"
    "xa\005lzcnt\003md5\006membar\007montmul\007montsqr\003mov\004mova\005mo"
    "vcc\005movcs\007movdtox\004move\005moveq\004movg\005movge\006movgeu\005"
    "movgt\005movgu\004movl\005movle\006movleu\005movlg\005movlt\005movlu\004"
    "movn\005movne\006movneg\005movnz\004movo\006movpos\004movr\005movre\007"
    "movrgez\006movrgz\007movrlez\006movrlz\006movrne\006movrnz\005movrz\010"
    "movstosw\010movstouw\004movu\005movue\005movug\006movuge\005movul\006mo"
    "vule\005movvc\005movvs\007movwtos\007movxtod\004movz\005mpmul\006mulscc"
    "\004mulx\003neg\003nop\007normalw\003not\002or\004orcc\003orn\005orncc\006"
    "otherw\005pause\005pdist\006pdistn\004popc\010prefetch\tprefetcha\003pw"
    "r\002rd\004rdpr\007restore\010restored\003ret\004retl\005retry\004rett\004"
    "save\005saved\004sdiv\006sdivcc\005sdivx\003set\005sethi\005setsw\004se"
    "tx\004sha1\006sha256\006sha512\010shutdown\004siam\005signx\003sir\003s"
    "ll\004sllx\004smac\004smul\006smulcc\003sra\004srax\003srl\004srlx\002s"
    "t\003sta\003stb\004stba\005stbar\003std\004stda\003sth\004stha\003stq\004"
    "stqa\003stx\004stxa\003sub\005subcc\004subx\006subxcc\004swap\005swapa\001"
    "t\002ta\006taddcc\010taddcctv\003tcc\003tcs\002te\003teq\002tg\003tge\004"
    "tgeu\003tgt\003tgu\002tl\003tle\004tleu\003tlt\003tlu\002tn\003tne\004t"
    "neg\003tnz\004tpos\003tst\006tsubcc\010tsubcctv\003tvc\003tvs\002tz\004"
    "udiv\006udivcc\005udivx\004umac\004umul\006umulcc\007umulxhi\005unimp\002"
    "wr\004wrpr\005xmulx\007xmulxhi\004xnor\006xnorcc\003xor\005xorcc";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_HasCASA,
  AMFBS_HasCrypto,
  AMFBS_HasOSA2011,
  AMFBS_HasPWRPSR,
  AMFBS_HasUA2005,
  AMFBS_HasUA2007,
  AMFBS_HasV9,
  AMFBS_HasVIS,
  AMFBS_HasVIS2,
  AMFBS_HasVIS3,
  AMFBS_Is64Bit,
  AMFBS_Is64Bit_HasV9,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_HasCASABit, },
  {Feature_HasCryptoBit, },
  {Feature_HasOSA2011Bit, },
  {Feature_HasPWRPSRBit, },
  {Feature_HasUA2005Bit, },
  {Feature_HasUA2007Bit, },
  {Feature_HasV9Bit, },
  {Feature_HasVISBit, },
  {Feature_HasVIS2Bit, },
  {Feature_HasVIS3Bit, },
  {Feature_Is64BitBit, },
  {Feature_Is64BitBit, Feature_HasV9Bit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[6];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* add */, SP::ADDrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 0 /* add */, SP::ADDri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 0 /* add */, SP::TLS_ADDrr, Convert__Reg1_2__Reg1_0__Reg1_1__TailRelocSymAdd_TLS1_3, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs, MCK_TailRelocSymAdd_TLS }, },
  { 4 /* addcc */, SP::ADDCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4 /* addcc */, SP::ADDCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 10 /* addx */, SP::ADDCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 10 /* addx */, SP::ADDCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 10 /* addx */, SP::ADDCri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_IntRegs }, },
  { 15 /* addxc */, SP::ADDXC, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 21 /* addxcc */, SP::ADDErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 21 /* addxcc */, SP::ADDEri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 28 /* addxccc */, SP::ADDXCCC, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 36 /* aes_dround01 */, SP::AES_DROUND01, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 49 /* aes_dround01_l */, SP::AES_DROUND01_LAST, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 64 /* aes_dround23 */, SP::AES_DROUND23, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 77 /* aes_dround23_l */, SP::AES_DROUND23_LAST, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 92 /* aes_eround01 */, SP::AES_EROUND01, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 105 /* aes_eround01_l */, SP::AES_EROUND01_LAST, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 120 /* aes_eround23 */, SP::AES_EROUND23, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 133 /* aes_eround23_l */, SP::AES_EROUND23_LAST, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 148 /* aes_kexpand0 */, SP::AES_KEXPAND0, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 161 /* aes_kexpand1 */, SP::AES_KEXPAND1, Convert__Reg1_3__Reg1_0__Reg1_1__Imm1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_Imm, MCK_DFPRegs }, },
  { 174 /* aes_kexpand2 */, SP::AES_KEXPAND2, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 187 /* alignaddr */, SP::ALIGNADDR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 197 /* alignaddrl */, SP::ALIGNADDRL, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 208 /* allclean */, SP::ALLCLEAN, Convert_NoOperands, AMFBS_HasUA2005, {  }, },
  { 217 /* and */, SP::ANDrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 217 /* and */, SP::ANDri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 221 /* andcc */, SP::ANDCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 221 /* andcc */, SP::ANDCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 227 /* andn */, SP::ANDNrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 227 /* andn */, SP::ANDNri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 232 /* andncc */, SP::ANDNCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 232 /* andncc */, SP::ANDNCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 239 /* array16 */, SP::ARRAY16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 247 /* array32 */, SP::ARRAY32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 255 /* array8 */, SP::ARRAY8, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 262 /* b */, SP::BCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 262 /* b */, SP::BPXCC, Convert__Imm1_1__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 262 /* b */, SP::BPICC, Convert__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BCOND, Convert__Imm1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 262 /* b */, SP::BPXCCA, Convert__Imm1_2__imm_95_8, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICCA, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCCNT, Convert__Imm1_2__imm_95_8, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICCNT, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCC, Convert__Imm1_2__imm_95_8, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICC, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCC, Convert__Imm1_2__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BCONDA, Convert__Imm1_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK_Imm }, },
  { 262 /* b */, SP::BPICC, Convert__Imm1_2__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCCANT, Convert__Imm1_3__imm_95_8, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICCANT, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCCA, Convert__Imm1_3__imm_95_8, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICCA, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCCA, Convert__Imm1_3__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICCA, Convert__Imm1_3__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCCNT, Convert__Imm1_3__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICCNT, Convert__Imm1_3__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 262 /* b */, SP::BPXCCANT, Convert__Imm1_4__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 262 /* b */, SP::BPICCANT, Convert__Imm1_4__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 264 /* ba */, SP::BA, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 264 /* ba */, SP::BCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 264 /* ba */, SP::BPXCC, Convert__Imm1_1__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 264 /* ba */, SP::BCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 264 /* ba */, SP::BPICC, Convert__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 264 /* ba */, SP::BPXCCA, Convert__Imm1_2__imm_95_8, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 264 /* ba */, SP::BPICCA, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 264 /* ba */, SP::BPXCCNT, Convert__Imm1_2__imm_95_8, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 264 /* ba */, SP::BPICCNT, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 264 /* ba */, SP::BPXCC, Convert__Imm1_2__imm_95_8, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 264 /* ba */, SP::BPICC, Convert__Imm1_2__imm_95_8, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 264 /* ba */, SP::BPXCCANT, Convert__Imm1_3__imm_95_8, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 264 /* ba */, SP::BPICCANT, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 264 /* ba */, SP::BPXCCA, Convert__Imm1_3__imm_95_8, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 264 /* ba */, SP::BPICCA, Convert__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 267 /* bcc */, SP::BCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 267 /* bcc */, SP::BPXCC, Convert__Imm1_1__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 267 /* bcc */, SP::BCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 267 /* bcc */, SP::BPICC, Convert__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 267 /* bcc */, SP::BPXCCA, Convert__Imm1_2__imm_95_13, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 267 /* bcc */, SP::BPICCA, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 267 /* bcc */, SP::BPXCCNT, Convert__Imm1_2__imm_95_13, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 267 /* bcc */, SP::BPICCNT, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 267 /* bcc */, SP::BPXCC, Convert__Imm1_2__imm_95_13, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 267 /* bcc */, SP::BPICC, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 267 /* bcc */, SP::BPXCCANT, Convert__Imm1_3__imm_95_13, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 267 /* bcc */, SP::BPICCANT, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 267 /* bcc */, SP::BPXCCA, Convert__Imm1_3__imm_95_13, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 267 /* bcc */, SP::BPICCA, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 271 /* bclr */, SP::ANDNrr, Convert__Reg1_1__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 271 /* bclr */, SP::ANDNri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 276 /* bcs */, SP::BCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 276 /* bcs */, SP::BPXCC, Convert__Imm1_1__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 276 /* bcs */, SP::BCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 276 /* bcs */, SP::BPICC, Convert__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 276 /* bcs */, SP::BPXCCA, Convert__Imm1_2__imm_95_5, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 276 /* bcs */, SP::BPICCA, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 276 /* bcs */, SP::BPXCCNT, Convert__Imm1_2__imm_95_5, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 276 /* bcs */, SP::BPICCNT, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 276 /* bcs */, SP::BPXCC, Convert__Imm1_2__imm_95_5, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 276 /* bcs */, SP::BPICC, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 276 /* bcs */, SP::BPXCCANT, Convert__Imm1_3__imm_95_5, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 276 /* bcs */, SP::BPICCANT, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 276 /* bcs */, SP::BPXCCA, Convert__Imm1_3__imm_95_5, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 276 /* bcs */, SP::BPICCA, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 280 /* be */, SP::BCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 280 /* be */, SP::BPXCC, Convert__Imm1_1__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 280 /* be */, SP::BCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 280 /* be */, SP::BPICC, Convert__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 280 /* be */, SP::BPXCCA, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 280 /* be */, SP::BPICCA, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 280 /* be */, SP::BPXCCNT, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 280 /* be */, SP::BPICCNT, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 280 /* be */, SP::BPXCC, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 280 /* be */, SP::BPICC, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 280 /* be */, SP::BPXCCANT, Convert__Imm1_3__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 280 /* be */, SP::BPICCANT, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 280 /* be */, SP::BPXCCA, Convert__Imm1_3__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 280 /* be */, SP::BPICCA, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 283 /* beq */, SP::BCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 283 /* beq */, SP::BPXCC, Convert__Imm1_1__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 283 /* beq */, SP::BCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 283 /* beq */, SP::BPICC, Convert__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 283 /* beq */, SP::BPXCCA, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 283 /* beq */, SP::BPICCA, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 283 /* beq */, SP::BPXCCNT, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 283 /* beq */, SP::BPICCNT, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 283 /* beq */, SP::BPXCC, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 283 /* beq */, SP::BPICC, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 283 /* beq */, SP::BPXCCANT, Convert__Imm1_3__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 283 /* beq */, SP::BPICCANT, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 283 /* beq */, SP::BPXCCA, Convert__Imm1_3__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 283 /* beq */, SP::BPICCA, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 287 /* bg */, SP::BCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 287 /* bg */, SP::BPXCC, Convert__Imm1_1__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 287 /* bg */, SP::BCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 287 /* bg */, SP::BPICC, Convert__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 287 /* bg */, SP::BPXCCA, Convert__Imm1_2__imm_95_10, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 287 /* bg */, SP::BPICCA, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 287 /* bg */, SP::BPXCCNT, Convert__Imm1_2__imm_95_10, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 287 /* bg */, SP::BPICCNT, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 287 /* bg */, SP::BPXCC, Convert__Imm1_2__imm_95_10, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 287 /* bg */, SP::BPICC, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 287 /* bg */, SP::BPXCCANT, Convert__Imm1_3__imm_95_10, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 287 /* bg */, SP::BPICCANT, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 287 /* bg */, SP::BPXCCA, Convert__Imm1_3__imm_95_10, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 287 /* bg */, SP::BPICCA, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 290 /* bge */, SP::BCOND, Convert__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 290 /* bge */, SP::BPXCC, Convert__Imm1_1__imm_95_11, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 290 /* bge */, SP::BCONDA, Convert__Imm1_1__imm_95_11, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 290 /* bge */, SP::BPICC, Convert__Imm1_1__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 290 /* bge */, SP::BPXCCA, Convert__Imm1_2__imm_95_11, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 290 /* bge */, SP::BPICCA, Convert__Imm1_2__imm_95_11, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 290 /* bge */, SP::BPXCCNT, Convert__Imm1_2__imm_95_11, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 290 /* bge */, SP::BPICCNT, Convert__Imm1_2__imm_95_11, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 290 /* bge */, SP::BPXCC, Convert__Imm1_2__imm_95_11, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 290 /* bge */, SP::BPICC, Convert__Imm1_2__imm_95_11, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 290 /* bge */, SP::BPXCCANT, Convert__Imm1_3__imm_95_11, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 290 /* bge */, SP::BPICCANT, Convert__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 290 /* bge */, SP::BPXCCA, Convert__Imm1_3__imm_95_11, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 290 /* bge */, SP::BPICCA, Convert__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 294 /* bgeu */, SP::BCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 294 /* bgeu */, SP::BPXCC, Convert__Imm1_1__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 294 /* bgeu */, SP::BCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPICC, Convert__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPXCCA, Convert__Imm1_2__imm_95_13, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPICCA, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_13, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPICCNT, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPXCC, Convert__Imm1_2__imm_95_13, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPICC, Convert__Imm1_2__imm_95_13, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_13, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPICCANT, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPXCCA, Convert__Imm1_3__imm_95_13, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 294 /* bgeu */, SP::BPICCA, Convert__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 299 /* bgt */, SP::BCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 299 /* bgt */, SP::BPXCC, Convert__Imm1_1__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 299 /* bgt */, SP::BCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 299 /* bgt */, SP::BPICC, Convert__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 299 /* bgt */, SP::BPXCCA, Convert__Imm1_2__imm_95_10, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 299 /* bgt */, SP::BPICCA, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 299 /* bgt */, SP::BPXCCNT, Convert__Imm1_2__imm_95_10, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 299 /* bgt */, SP::BPICCNT, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 299 /* bgt */, SP::BPXCC, Convert__Imm1_2__imm_95_10, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 299 /* bgt */, SP::BPICC, Convert__Imm1_2__imm_95_10, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 299 /* bgt */, SP::BPXCCANT, Convert__Imm1_3__imm_95_10, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 299 /* bgt */, SP::BPICCANT, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 299 /* bgt */, SP::BPXCCA, Convert__Imm1_3__imm_95_10, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 299 /* bgt */, SP::BPICCA, Convert__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 303 /* bgu */, SP::BCOND, Convert__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 303 /* bgu */, SP::BPXCC, Convert__Imm1_1__imm_95_12, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 303 /* bgu */, SP::BCONDA, Convert__Imm1_1__imm_95_12, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 303 /* bgu */, SP::BPICC, Convert__Imm1_1__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 303 /* bgu */, SP::BPXCCA, Convert__Imm1_2__imm_95_12, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 303 /* bgu */, SP::BPICCA, Convert__Imm1_2__imm_95_12, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 303 /* bgu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_12, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 303 /* bgu */, SP::BPICCNT, Convert__Imm1_2__imm_95_12, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 303 /* bgu */, SP::BPXCC, Convert__Imm1_2__imm_95_12, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 303 /* bgu */, SP::BPICC, Convert__Imm1_2__imm_95_12, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 303 /* bgu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_12, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 303 /* bgu */, SP::BPICCANT, Convert__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 303 /* bgu */, SP::BPXCCA, Convert__Imm1_3__imm_95_12, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 303 /* bgu */, SP::BPICCA, Convert__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 307 /* bl */, SP::BCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 307 /* bl */, SP::BPXCC, Convert__Imm1_1__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 307 /* bl */, SP::BCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 307 /* bl */, SP::BPICC, Convert__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 307 /* bl */, SP::BPXCCA, Convert__Imm1_2__imm_95_3, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 307 /* bl */, SP::BPICCA, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 307 /* bl */, SP::BPXCCNT, Convert__Imm1_2__imm_95_3, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 307 /* bl */, SP::BPICCNT, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 307 /* bl */, SP::BPXCC, Convert__Imm1_2__imm_95_3, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 307 /* bl */, SP::BPICC, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 307 /* bl */, SP::BPXCCANT, Convert__Imm1_3__imm_95_3, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 307 /* bl */, SP::BPICCANT, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 307 /* bl */, SP::BPXCCA, Convert__Imm1_3__imm_95_3, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 307 /* bl */, SP::BPICCA, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 310 /* ble */, SP::BCOND, Convert__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 310 /* ble */, SP::BPXCC, Convert__Imm1_1__imm_95_2, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 310 /* ble */, SP::BCONDA, Convert__Imm1_1__imm_95_2, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 310 /* ble */, SP::BPICC, Convert__Imm1_1__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 310 /* ble */, SP::BPXCCA, Convert__Imm1_2__imm_95_2, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 310 /* ble */, SP::BPICCA, Convert__Imm1_2__imm_95_2, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 310 /* ble */, SP::BPXCCNT, Convert__Imm1_2__imm_95_2, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 310 /* ble */, SP::BPICCNT, Convert__Imm1_2__imm_95_2, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 310 /* ble */, SP::BPXCC, Convert__Imm1_2__imm_95_2, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 310 /* ble */, SP::BPICC, Convert__Imm1_2__imm_95_2, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 310 /* ble */, SP::BPXCCANT, Convert__Imm1_3__imm_95_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 310 /* ble */, SP::BPICCANT, Convert__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 310 /* ble */, SP::BPXCCA, Convert__Imm1_3__imm_95_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 310 /* ble */, SP::BPICCA, Convert__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 314 /* bleu */, SP::BCOND, Convert__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 314 /* bleu */, SP::BPXCC, Convert__Imm1_1__imm_95_4, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 314 /* bleu */, SP::BCONDA, Convert__Imm1_1__imm_95_4, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 314 /* bleu */, SP::BPICC, Convert__Imm1_1__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 314 /* bleu */, SP::BPXCCA, Convert__Imm1_2__imm_95_4, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 314 /* bleu */, SP::BPICCA, Convert__Imm1_2__imm_95_4, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 314 /* bleu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_4, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 314 /* bleu */, SP::BPICCNT, Convert__Imm1_2__imm_95_4, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 314 /* bleu */, SP::BPXCC, Convert__Imm1_2__imm_95_4, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 314 /* bleu */, SP::BPICC, Convert__Imm1_2__imm_95_4, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 314 /* bleu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_4, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 314 /* bleu */, SP::BPICCANT, Convert__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 314 /* bleu */, SP::BPXCCA, Convert__Imm1_3__imm_95_4, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 314 /* bleu */, SP::BPICCA, Convert__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 319 /* blt */, SP::BCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 319 /* blt */, SP::BPXCC, Convert__Imm1_1__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 319 /* blt */, SP::BCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 319 /* blt */, SP::BPICC, Convert__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 319 /* blt */, SP::BPXCCA, Convert__Imm1_2__imm_95_3, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 319 /* blt */, SP::BPICCA, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 319 /* blt */, SP::BPXCCNT, Convert__Imm1_2__imm_95_3, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 319 /* blt */, SP::BPICCNT, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 319 /* blt */, SP::BPXCC, Convert__Imm1_2__imm_95_3, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 319 /* blt */, SP::BPICC, Convert__Imm1_2__imm_95_3, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 319 /* blt */, SP::BPXCCANT, Convert__Imm1_3__imm_95_3, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 319 /* blt */, SP::BPICCANT, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 319 /* blt */, SP::BPXCCA, Convert__Imm1_3__imm_95_3, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 319 /* blt */, SP::BPICCA, Convert__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 323 /* blu */, SP::BCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 323 /* blu */, SP::BPXCC, Convert__Imm1_1__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 323 /* blu */, SP::BCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 323 /* blu */, SP::BPICC, Convert__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 323 /* blu */, SP::BPXCCA, Convert__Imm1_2__imm_95_5, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 323 /* blu */, SP::BPICCA, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 323 /* blu */, SP::BPXCCNT, Convert__Imm1_2__imm_95_5, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 323 /* blu */, SP::BPICCNT, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 323 /* blu */, SP::BPXCC, Convert__Imm1_2__imm_95_5, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 323 /* blu */, SP::BPICC, Convert__Imm1_2__imm_95_5, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 323 /* blu */, SP::BPXCCANT, Convert__Imm1_3__imm_95_5, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 323 /* blu */, SP::BPICCANT, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 323 /* blu */, SP::BPXCCA, Convert__Imm1_3__imm_95_5, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 323 /* blu */, SP::BPICCA, Convert__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 327 /* bmask */, SP::BMASK, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 333 /* bn */, SP::BCOND, Convert__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 333 /* bn */, SP::BPXCC, Convert__Imm1_1__imm_95_0, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 333 /* bn */, SP::BCONDA, Convert__Imm1_1__imm_95_0, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 333 /* bn */, SP::BPICC, Convert__Imm1_1__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 333 /* bn */, SP::BPXCCA, Convert__Imm1_2__imm_95_0, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 333 /* bn */, SP::BPICCA, Convert__Imm1_2__imm_95_0, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 333 /* bn */, SP::BPXCCNT, Convert__Imm1_2__imm_95_0, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 333 /* bn */, SP::BPICCNT, Convert__Imm1_2__imm_95_0, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 333 /* bn */, SP::BPXCC, Convert__Imm1_2__imm_95_0, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 333 /* bn */, SP::BPICC, Convert__Imm1_2__imm_95_0, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 333 /* bn */, SP::BPXCCANT, Convert__Imm1_3__imm_95_0, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 333 /* bn */, SP::BPICCANT, Convert__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 333 /* bn */, SP::BPXCCA, Convert__Imm1_3__imm_95_0, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 333 /* bn */, SP::BPICCA, Convert__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 336 /* bne */, SP::BCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 336 /* bne */, SP::BPXCC, Convert__Imm1_1__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 336 /* bne */, SP::BCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 336 /* bne */, SP::BPICC, Convert__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 336 /* bne */, SP::BPXCCA, Convert__Imm1_2__imm_95_9, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 336 /* bne */, SP::BPICCA, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 336 /* bne */, SP::BPXCCNT, Convert__Imm1_2__imm_95_9, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 336 /* bne */, SP::BPICCNT, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 336 /* bne */, SP::BPXCC, Convert__Imm1_2__imm_95_9, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 336 /* bne */, SP::BPICC, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 336 /* bne */, SP::BPXCCANT, Convert__Imm1_3__imm_95_9, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 336 /* bne */, SP::BPICCANT, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 336 /* bne */, SP::BPXCCA, Convert__Imm1_3__imm_95_9, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 336 /* bne */, SP::BPICCA, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 340 /* bneg */, SP::BCOND, Convert__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 340 /* bneg */, SP::BPXCC, Convert__Imm1_1__imm_95_6, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 340 /* bneg */, SP::BCONDA, Convert__Imm1_1__imm_95_6, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 340 /* bneg */, SP::BPICC, Convert__Imm1_1__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 340 /* bneg */, SP::BPXCCA, Convert__Imm1_2__imm_95_6, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 340 /* bneg */, SP::BPICCA, Convert__Imm1_2__imm_95_6, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 340 /* bneg */, SP::BPXCCNT, Convert__Imm1_2__imm_95_6, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 340 /* bneg */, SP::BPICCNT, Convert__Imm1_2__imm_95_6, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 340 /* bneg */, SP::BPXCC, Convert__Imm1_2__imm_95_6, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 340 /* bneg */, SP::BPICC, Convert__Imm1_2__imm_95_6, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 340 /* bneg */, SP::BPXCCANT, Convert__Imm1_3__imm_95_6, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 340 /* bneg */, SP::BPICCANT, Convert__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 340 /* bneg */, SP::BPXCCA, Convert__Imm1_3__imm_95_6, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 340 /* bneg */, SP::BPICCA, Convert__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 345 /* bnz */, SP::BCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 345 /* bnz */, SP::BPXCC, Convert__Imm1_1__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 345 /* bnz */, SP::BCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 345 /* bnz */, SP::BPICC, Convert__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 345 /* bnz */, SP::BPXCCA, Convert__Imm1_2__imm_95_9, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 345 /* bnz */, SP::BPICCA, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 345 /* bnz */, SP::BPXCCNT, Convert__Imm1_2__imm_95_9, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 345 /* bnz */, SP::BPICCNT, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 345 /* bnz */, SP::BPXCC, Convert__Imm1_2__imm_95_9, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 345 /* bnz */, SP::BPICC, Convert__Imm1_2__imm_95_9, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 345 /* bnz */, SP::BPXCCANT, Convert__Imm1_3__imm_95_9, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 345 /* bnz */, SP::BPICCANT, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 345 /* bnz */, SP::BPXCCA, Convert__Imm1_3__imm_95_9, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 345 /* bnz */, SP::BPICCA, Convert__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 349 /* bpos */, SP::BCOND, Convert__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 349 /* bpos */, SP::BPXCC, Convert__Imm1_1__imm_95_14, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 349 /* bpos */, SP::BCONDA, Convert__Imm1_1__imm_95_14, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 349 /* bpos */, SP::BPICC, Convert__Imm1_1__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 349 /* bpos */, SP::BPXCCA, Convert__Imm1_2__imm_95_14, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 349 /* bpos */, SP::BPICCA, Convert__Imm1_2__imm_95_14, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 349 /* bpos */, SP::BPXCCNT, Convert__Imm1_2__imm_95_14, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 349 /* bpos */, SP::BPICCNT, Convert__Imm1_2__imm_95_14, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 349 /* bpos */, SP::BPXCC, Convert__Imm1_2__imm_95_14, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 349 /* bpos */, SP::BPICC, Convert__Imm1_2__imm_95_14, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 349 /* bpos */, SP::BPXCCANT, Convert__Imm1_3__imm_95_14, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 349 /* bpos */, SP::BPICCANT, Convert__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 349 /* bpos */, SP::BPXCCA, Convert__Imm1_3__imm_95_14, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 349 /* bpos */, SP::BPICCA, Convert__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 354 /* br */, SP::BPR, Convert__Imm1_2__Imm1_0__Reg1_1, AMFBS_Is64Bit, { MCK_Imm, MCK_IntRegs, MCK_Imm }, },
  { 354 /* br */, SP::BPRA, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_Is64Bit, { MCK_Imm, MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 354 /* br */, SP::BPRNT, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_Is64Bit, { MCK_Imm, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 354 /* br */, SP::BPRANT, Convert__Imm1_4__Imm1_0__Reg1_3, AMFBS_Is64Bit, { MCK_Imm, MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 357 /* bre */, SP::BPR, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 357 /* bre */, SP::BPRA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 357 /* bre */, SP::BPRNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 357 /* bre */, SP::BPR, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 357 /* bre */, SP::BPRANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 357 /* bre */, SP::BPRA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 361 /* brgez */, SP::BPR, Convert__Imm1_1__imm_95_7__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 361 /* brgez */, SP::BPRA, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 361 /* brgez */, SP::BPRNT, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 361 /* brgez */, SP::BPR, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 361 /* brgez */, SP::BPRANT, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 361 /* brgez */, SP::BPRA, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 367 /* brgz */, SP::BPR, Convert__Imm1_1__imm_95_6__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 367 /* brgz */, SP::BPRA, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 367 /* brgz */, SP::BPRNT, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 367 /* brgz */, SP::BPR, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 367 /* brgz */, SP::BPRANT, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 367 /* brgz */, SP::BPRA, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 372 /* brlez */, SP::BPR, Convert__Imm1_1__imm_95_2__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 372 /* brlez */, SP::BPRA, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 372 /* brlez */, SP::BPRNT, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 372 /* brlez */, SP::BPR, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 372 /* brlez */, SP::BPRANT, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 372 /* brlez */, SP::BPRA, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 378 /* brlz */, SP::BPR, Convert__Imm1_1__imm_95_3__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 378 /* brlz */, SP::BPRA, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 378 /* brlz */, SP::BPRNT, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 378 /* brlz */, SP::BPR, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 378 /* brlz */, SP::BPRANT, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 378 /* brlz */, SP::BPRA, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 383 /* brne */, SP::BPR, Convert__Imm1_1__imm_95_5__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 383 /* brne */, SP::BPRA, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 383 /* brne */, SP::BPRNT, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 383 /* brne */, SP::BPR, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 383 /* brne */, SP::BPRANT, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 383 /* brne */, SP::BPRA, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 388 /* brnz */, SP::BPR, Convert__Imm1_1__imm_95_5__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 388 /* brnz */, SP::BPRA, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 388 /* brnz */, SP::BPRNT, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 388 /* brnz */, SP::BPR, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 388 /* brnz */, SP::BPRANT, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 388 /* brnz */, SP::BPRA, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 393 /* brz */, SP::BPR, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm }, },
  { 393 /* brz */, SP::BPRA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_Is64Bit, { MCK_a, MCK_IntRegs, MCK_Imm }, },
  { 393 /* brz */, SP::BPRNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_Is64Bit, { MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 393 /* brz */, SP::BPR, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_Is64Bit, { MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 393 /* brz */, SP::BPRANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK_IntRegs, MCK_Imm }, },
  { 393 /* brz */, SP::BPRA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK_IntRegs, MCK_Imm }, },
  { 397 /* bset */, SP::ORrr, Convert__Reg1_1__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 397 /* bset */, SP::ORri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 402 /* bshuffle */, SP::BSHUFFLE, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 411 /* btog */, SP::XORrr, Convert__Reg1_1__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 411 /* btog */, SP::XORri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 416 /* btst */, SP::ANDCCrr, Convert__regG0__Reg1_1__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 416 /* btst */, SP::ANDCCri, Convert__regG0__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 421 /* bvc */, SP::BCOND, Convert__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 421 /* bvc */, SP::BPXCC, Convert__Imm1_1__imm_95_15, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 421 /* bvc */, SP::BCONDA, Convert__Imm1_1__imm_95_15, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 421 /* bvc */, SP::BPICC, Convert__Imm1_1__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 421 /* bvc */, SP::BPXCCA, Convert__Imm1_2__imm_95_15, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 421 /* bvc */, SP::BPICCA, Convert__Imm1_2__imm_95_15, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 421 /* bvc */, SP::BPXCCNT, Convert__Imm1_2__imm_95_15, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 421 /* bvc */, SP::BPICCNT, Convert__Imm1_2__imm_95_15, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 421 /* bvc */, SP::BPXCC, Convert__Imm1_2__imm_95_15, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 421 /* bvc */, SP::BPICC, Convert__Imm1_2__imm_95_15, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 421 /* bvc */, SP::BPXCCANT, Convert__Imm1_3__imm_95_15, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 421 /* bvc */, SP::BPICCANT, Convert__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 421 /* bvc */, SP::BPXCCA, Convert__Imm1_3__imm_95_15, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 421 /* bvc */, SP::BPICCA, Convert__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 425 /* bvs */, SP::BCOND, Convert__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 425 /* bvs */, SP::BPXCC, Convert__Imm1_1__imm_95_7, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 425 /* bvs */, SP::BCONDA, Convert__Imm1_1__imm_95_7, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 425 /* bvs */, SP::BPICC, Convert__Imm1_1__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 425 /* bvs */, SP::BPXCCA, Convert__Imm1_2__imm_95_7, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 425 /* bvs */, SP::BPICCA, Convert__Imm1_2__imm_95_7, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 425 /* bvs */, SP::BPXCCNT, Convert__Imm1_2__imm_95_7, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 425 /* bvs */, SP::BPICCNT, Convert__Imm1_2__imm_95_7, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 425 /* bvs */, SP::BPXCC, Convert__Imm1_2__imm_95_7, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 425 /* bvs */, SP::BPICC, Convert__Imm1_2__imm_95_7, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 425 /* bvs */, SP::BPXCCANT, Convert__Imm1_3__imm_95_7, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 425 /* bvs */, SP::BPICCANT, Convert__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 425 /* bvs */, SP::BPXCCA, Convert__Imm1_3__imm_95_7, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 425 /* bvs */, SP::BPICCA, Convert__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 429 /* bz */, SP::BCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 429 /* bz */, SP::BPXCC, Convert__Imm1_1__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm }, },
  { 429 /* bz */, SP::BCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 429 /* bz */, SP::BPICC, Convert__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 429 /* bz */, SP::BPXCCA, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK__PCT_xcc, MCK_Imm }, },
  { 429 /* bz */, SP::BPICCA, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_ICC, MCK_Imm }, },
  { 429 /* bz */, SP::BPXCCNT, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 429 /* bz */, SP::BPICCNT, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pn, MCK_ICC, MCK_Imm }, },
  { 429 /* bz */, SP::BPXCC, Convert__Imm1_2__imm_95_1, AMFBS_Is64Bit, { MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 429 /* bz */, SP::BPICC, Convert__Imm1_2__imm_95_1, AMFBS_HasV9, { MCK_pt, MCK_ICC, MCK_Imm }, },
  { 429 /* bz */, SP::BPXCCANT, Convert__Imm1_3__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK_pn, MCK__PCT_xcc, MCK_Imm }, },
  { 429 /* bz */, SP::BPICCANT, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_ICC, MCK_Imm }, },
  { 429 /* bz */, SP::BPXCCA, Convert__Imm1_3__imm_95_1, AMFBS_Is64Bit, { MCK_a, MCK_pt, MCK__PCT_xcc, MCK_Imm }, },
  { 429 /* bz */, SP::BPICCA, Convert__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_ICC, MCK_Imm }, },
  { 432 /* call */, SP::CALL, Convert__CallTarget1_0, AMFBS_None, { MCK_CallTarget }, },
  { 432 /* call */, SP::JMPLri, Convert__regO7__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 432 /* call */, SP::JMPLrr, Convert__regO7__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 432 /* call */, SP::CALLi, Convert__CallTarget1_0__Imm1_1, AMFBS_None, { MCK_CallTarget, MCK_Imm }, },
  { 432 /* call */, SP::TLS_CALL, Convert__CallTarget1_0__TailRelocSymCall_TLS1_1, AMFBS_None, { MCK_CallTarget, MCK_TailRelocSymCall_TLS }, },
  { 432 /* call */, SP::CALLrii, Convert__MEMri2_0__Imm1_1, AMFBS_None, { MCK_MEMri, MCK_Imm }, },
  { 432 /* call */, SP::CALLrri, Convert__MEMrr2_0__Imm1_1, AMFBS_None, { MCK_MEMrr, MCK_Imm }, },
  { 437 /* camellia_f */, SP::CAMELLIA_F, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 448 /* camellia_fl */, SP::CAMELLIA_FL, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 460 /* camellia_fli */, SP::CAMELLIA_FLI, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 473 /* cas */, SP::CASArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 477 /* casa */, SP::CASAri, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK__PCT_asi, MCK_IntRegs, MCK_IntRegs }, },
  { 477 /* casa */, SP::CASArr, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3, AMFBS_HasCASA, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_ASITag, MCK_IntRegs, MCK_IntRegs }, },
  { 482 /* casl */, SP::CASArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 487 /* casx */, SP::CASXArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_128, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 492 /* casxa */, SP::CASXAri, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1, AMFBS_Is64Bit_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK__PCT_asi, MCK_IntRegs, MCK_IntRegs }, },
  { 492 /* casxa */, SP::CASXArr, Convert__Reg1_5__Reg1_1__Reg1_4__Tie0_1_1__ASITag1_3, AMFBS_Is64Bit_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_ASITag, MCK_IntRegs, MCK_IntRegs }, },
  { 498 /* casxl */, SP::CASXArr, Convert__Reg1_4__Reg1_1__Reg1_3__Tie0_5_5__imm_95_136, AMFBS_HasV9, { MCK__91_, MCK_IntRegs, MCK__93_, MCK_IntRegs, MCK_IntRegs }, },
  { 504 /* cb */, SP::CPBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 504 /* cb */, SP::CPBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 504 /* cb */, SP::CPBCOND, Convert__Imm1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 504 /* cb */, SP::CPBCONDA, Convert__Imm1_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK_Imm }, },
  { 507 /* cb0 */, SP::CPBCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 507 /* cb0 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 511 /* cb01 */, SP::CPBCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 511 /* cb01 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 516 /* cb012 */, SP::CPBCOND, Convert__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 516 /* cb012 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_15, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 522 /* cb013 */, SP::CPBCOND, Convert__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 522 /* cb013 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_14, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 528 /* cb02 */, SP::CPBCOND, Convert__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 528 /* cb02 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_11, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 533 /* cb023 */, SP::CPBCOND, Convert__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 533 /* cb023 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_12, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 539 /* cb03 */, SP::CPBCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 539 /* cb03 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 544 /* cb1 */, SP::CPBCOND, Convert__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 544 /* cb1 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_4, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 548 /* cb12 */, SP::CPBCOND, Convert__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 548 /* cb12 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_2, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 553 /* cb123 */, SP::CPBCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 553 /* cb123 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 559 /* cb13 */, SP::CPBCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 559 /* cb13 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 564 /* cb2 */, SP::CPBCOND, Convert__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 564 /* cb2 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_6, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 568 /* cb23 */, SP::CPBCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 568 /* cb23 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 573 /* cb3 */, SP::CPBCOND, Convert__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 573 /* cb3 */, SP::CPBCONDA, Convert__Imm1_1__imm_95_7, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 577 /* cba */, SP::CPBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 577 /* cba */, SP::CPBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 581 /* cbn */, SP::CPBCOND, Convert__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 581 /* cbn */, SP::CPBCONDA, Convert__Imm1_1__imm_95_0, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 585 /* clr */, SP::ORrr, Convert__Reg1_0__regG0__regG0, AMFBS_None, { MCK_IntRegs }, },
  { 585 /* clr */, SP::STri, Convert__MEMri2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 585 /* clr */, SP::STrr, Convert__MEMrr2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 589 /* clrb */, SP::STBri, Convert__MEMri2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 589 /* clrb */, SP::STBrr, Convert__MEMrr2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 594 /* clrh */, SP::STHri, Convert__MEMri2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 594 /* clrh */, SP::STHrr, Convert__MEMrr2_1__regG0, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 599 /* cmask16 */, SP::CMASK16, Convert__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs }, },
  { 607 /* cmask32 */, SP::CMASK32, Convert__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs }, },
  { 615 /* cmask8 */, SP::CMASK8, Convert__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs }, },
  { 622 /* cmp */, SP::SUBCCrr, Convert__regG0__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 622 /* cmp */, SP::SUBCCri, Convert__regG0__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm }, },
  { 626 /* crc32c */, SP::CRC32C, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 633 /* cwb */, SP::CWBCONDrr, Convert__Imm1_3__Imm1_0__Reg1_1__Reg1_2, AMFBS_HasOSA2011, { MCK_Imm, MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 633 /* cwb */, SP::CWBCONDri, Convert__Imm1_3__Imm1_0__Reg1_1__Imm1_2, AMFBS_HasOSA2011, { MCK_Imm, MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 637 /* cwbcc */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_13__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 637 /* cwbcc */, SP::CWBCONDri, Convert__Imm1_2__imm_95_13__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 643 /* cwbcs */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_5__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 643 /* cwbcs */, SP::CWBCONDri, Convert__Imm1_2__imm_95_5__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 649 /* cwbe */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_1__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 649 /* cwbe */, SP::CWBCONDri, Convert__Imm1_2__imm_95_1__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 654 /* cwbg */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_10__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 654 /* cwbg */, SP::CWBCONDri, Convert__Imm1_2__imm_95_10__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 659 /* cwbge */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_11__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 659 /* cwbge */, SP::CWBCONDri, Convert__Imm1_2__imm_95_11__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 665 /* cwbgeu */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_13__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 665 /* cwbgeu */, SP::CWBCONDri, Convert__Imm1_2__imm_95_13__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 672 /* cwbgu */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_12__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 672 /* cwbgu */, SP::CWBCONDri, Convert__Imm1_2__imm_95_12__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 678 /* cwbl */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_3__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 678 /* cwbl */, SP::CWBCONDri, Convert__Imm1_2__imm_95_3__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 683 /* cwble */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_2__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 683 /* cwble */, SP::CWBCONDri, Convert__Imm1_2__imm_95_2__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 689 /* cwbleu */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_4__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 689 /* cwbleu */, SP::CWBCONDri, Convert__Imm1_2__imm_95_4__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 696 /* cwblu */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_5__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 696 /* cwblu */, SP::CWBCONDri, Convert__Imm1_2__imm_95_5__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 702 /* cwbne */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_9__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 702 /* cwbne */, SP::CWBCONDri, Convert__Imm1_2__imm_95_9__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 708 /* cwbneg */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_6__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 708 /* cwbneg */, SP::CWBCONDri, Convert__Imm1_2__imm_95_6__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 715 /* cwbpos */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_14__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 715 /* cwbpos */, SP::CWBCONDri, Convert__Imm1_2__imm_95_14__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 722 /* cwbvc */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_15__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 722 /* cwbvc */, SP::CWBCONDri, Convert__Imm1_2__imm_95_15__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 728 /* cwbvs */, SP::CWBCONDrr, Convert__Imm1_2__imm_95_7__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 728 /* cwbvs */, SP::CWBCONDri, Convert__Imm1_2__imm_95_7__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 734 /* cxb */, SP::CXBCONDrr, Convert__Imm1_3__Imm1_0__Reg1_1__Reg1_2, AMFBS_HasOSA2011, { MCK_Imm, MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 734 /* cxb */, SP::CXBCONDri, Convert__Imm1_3__Imm1_0__Reg1_1__Imm1_2, AMFBS_HasOSA2011, { MCK_Imm, MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 738 /* cxbcc */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_13__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 738 /* cxbcc */, SP::CXBCONDri, Convert__Imm1_2__imm_95_13__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 744 /* cxbcs */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_5__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 744 /* cxbcs */, SP::CXBCONDri, Convert__Imm1_2__imm_95_5__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 750 /* cxbe */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_1__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 750 /* cxbe */, SP::CXBCONDri, Convert__Imm1_2__imm_95_1__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 755 /* cxbg */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_10__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 755 /* cxbg */, SP::CXBCONDri, Convert__Imm1_2__imm_95_10__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 760 /* cxbge */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_11__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 760 /* cxbge */, SP::CXBCONDri, Convert__Imm1_2__imm_95_11__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 766 /* cxbgeu */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_13__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 766 /* cxbgeu */, SP::CXBCONDri, Convert__Imm1_2__imm_95_13__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 773 /* cxbgu */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_12__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 773 /* cxbgu */, SP::CXBCONDri, Convert__Imm1_2__imm_95_12__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 779 /* cxbl */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_3__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 779 /* cxbl */, SP::CXBCONDri, Convert__Imm1_2__imm_95_3__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 784 /* cxble */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_2__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 784 /* cxble */, SP::CXBCONDri, Convert__Imm1_2__imm_95_2__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 790 /* cxbleu */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_4__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 790 /* cxbleu */, SP::CXBCONDri, Convert__Imm1_2__imm_95_4__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 797 /* cxblu */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_5__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 797 /* cxblu */, SP::CXBCONDri, Convert__Imm1_2__imm_95_5__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 803 /* cxbne */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_9__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 803 /* cxbne */, SP::CXBCONDri, Convert__Imm1_2__imm_95_9__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 809 /* cxbneg */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_6__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 809 /* cxbneg */, SP::CXBCONDri, Convert__Imm1_2__imm_95_6__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 816 /* cxbpos */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_14__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 816 /* cxbpos */, SP::CXBCONDri, Convert__Imm1_2__imm_95_14__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 823 /* cxbvc */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_15__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 823 /* cxbvc */, SP::CXBCONDri, Convert__Imm1_2__imm_95_15__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 829 /* cxbvs */, SP::CXBCONDrr, Convert__Imm1_2__imm_95_7__Reg1_0__Reg1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_IntRegs, MCK_Imm }, },
  { 829 /* cxbvs */, SP::CXBCONDri, Convert__Imm1_2__imm_95_7__Reg1_0__Imm1_1, AMFBS_HasOSA2011, { MCK_IntRegs, MCK_Imm, MCK_Imm }, },
  { 835 /* dec */, SP::SUBri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 835 /* dec */, SP::SUBri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 839 /* deccc */, SP::SUBCCri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 839 /* deccc */, SP::SUBCCri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 845 /* des_iip */, SP::DES_IIP, Convert__Reg1_1__Reg1_0, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 853 /* des_ip */, SP::DES_IP, Convert__Reg1_1__Reg1_0, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 860 /* des_kexpand */, SP::DES_KEXPAND, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_Imm, MCK_DFPRegs }, },
  { 872 /* des_round */, SP::DES_ROUND, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasCrypto, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 882 /* done */, SP::DONE, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 887 /* edge16 */, SP::EDGE16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 894 /* edge16l */, SP::EDGE16L, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 902 /* edge16ln */, SP::EDGE16LN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 911 /* edge16n */, SP::EDGE16N, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 919 /* edge32 */, SP::EDGE32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 926 /* edge32l */, SP::EDGE32L, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 934 /* edge32ln */, SP::EDGE32LN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 943 /* edge32n */, SP::EDGE32N, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 951 /* edge8 */, SP::EDGE8, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 957 /* edge8l */, SP::EDGE8L, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 964 /* edge8ln */, SP::EDGE8LN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 972 /* edge8n */, SP::EDGE8N, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS2, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 979 /* fabsd */, SP::FABSD, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 985 /* fabsq */, SP::FABSQ, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 991 /* fabss */, SP::FABSS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 997 /* faddd */, SP::FADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1003 /* faddq */, SP::FADDQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1009 /* fadds */, SP::FADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1015 /* faligndata */, SP::FALIGNADATA, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1026 /* fand */, SP::FAND, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1031 /* fandnot1 */, SP::FANDNOT1, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1040 /* fandnot1s */, SP::FANDNOT1S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1050 /* fandnot2 */, SP::FANDNOT2, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1059 /* fandnot2s */, SP::FANDNOT2S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1069 /* fands */, SP::FANDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1075 /* fb */, SP::FBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 1075 /* fb */, SP::FBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCC, Convert__Imm1_1__imm_95_8__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::FBCOND, Convert__Imm1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCCA, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCCNT, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCC, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::FBCONDA, Convert__Imm1_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_a, MCK_Imm }, },
  { 1075 /* fb */, SP::FBCOND_V9, Convert__Imm1_2__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCC, Convert__Imm1_2__Imm1_0__Reg1_1, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCCANT, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCCA, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::FBCONDA_V9, Convert__Imm1_3__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_FCC0, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCCA, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCCNT, Convert__Imm1_3__Imm1_0__Reg1_2, AMFBS_HasV9, { MCK_Imm, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1075 /* fb */, SP::BPFCCANT, Convert__Imm1_4__Imm1_0__Reg1_3, AMFBS_HasV9, { MCK_Imm, MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1078 /* fba */, SP::FBCOND, Convert__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 1078 /* fba */, SP::FBCONDA, Convert__Imm1_1__imm_95_8, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1078 /* fba */, SP::BPFCC, Convert__Imm1_1__imm_95_8__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1078 /* fba */, SP::BPFCCA, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1078 /* fba */, SP::BPFCCNT, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1078 /* fba */, SP::BPFCC, Convert__Imm1_2__imm_95_8__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1078 /* fba */, SP::BPFCCANT, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1078 /* fba */, SP::BPFCCA, Convert__Imm1_3__imm_95_8__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1082 /* fbe */, SP::FBCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 1082 /* fbe */, SP::FBCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1082 /* fbe */, SP::BPFCC, Convert__Imm1_1__imm_95_9__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1082 /* fbe */, SP::BPFCCA, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1082 /* fbe */, SP::BPFCCNT, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1082 /* fbe */, SP::BPFCC, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1082 /* fbe */, SP::BPFCCANT, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1082 /* fbe */, SP::BPFCCA, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1086 /* fbg */, SP::FBCOND, Convert__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 1086 /* fbg */, SP::FBCONDA, Convert__Imm1_1__imm_95_6, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1086 /* fbg */, SP::BPFCC, Convert__Imm1_1__imm_95_6__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1086 /* fbg */, SP::BPFCCA, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1086 /* fbg */, SP::BPFCCNT, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1086 /* fbg */, SP::BPFCC, Convert__Imm1_2__imm_95_6__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1086 /* fbg */, SP::BPFCCANT, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1086 /* fbg */, SP::BPFCCA, Convert__Imm1_3__imm_95_6__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1090 /* fbge */, SP::FBCOND, Convert__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 1090 /* fbge */, SP::FBCONDA, Convert__Imm1_1__imm_95_11, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1090 /* fbge */, SP::BPFCC, Convert__Imm1_1__imm_95_11__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1090 /* fbge */, SP::BPFCCA, Convert__Imm1_2__imm_95_11__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1090 /* fbge */, SP::BPFCCNT, Convert__Imm1_2__imm_95_11__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1090 /* fbge */, SP::BPFCC, Convert__Imm1_2__imm_95_11__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1090 /* fbge */, SP::BPFCCANT, Convert__Imm1_3__imm_95_11__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1090 /* fbge */, SP::BPFCCA, Convert__Imm1_3__imm_95_11__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1095 /* fbl */, SP::FBCOND, Convert__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 1095 /* fbl */, SP::FBCONDA, Convert__Imm1_1__imm_95_4, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1095 /* fbl */, SP::BPFCC, Convert__Imm1_1__imm_95_4__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1095 /* fbl */, SP::BPFCCA, Convert__Imm1_2__imm_95_4__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1095 /* fbl */, SP::BPFCCNT, Convert__Imm1_2__imm_95_4__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1095 /* fbl */, SP::BPFCC, Convert__Imm1_2__imm_95_4__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1095 /* fbl */, SP::BPFCCANT, Convert__Imm1_3__imm_95_4__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1095 /* fbl */, SP::BPFCCA, Convert__Imm1_3__imm_95_4__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1099 /* fble */, SP::FBCOND, Convert__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 1099 /* fble */, SP::FBCONDA, Convert__Imm1_1__imm_95_13, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1099 /* fble */, SP::BPFCC, Convert__Imm1_1__imm_95_13__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1099 /* fble */, SP::BPFCCA, Convert__Imm1_2__imm_95_13__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1099 /* fble */, SP::BPFCCNT, Convert__Imm1_2__imm_95_13__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1099 /* fble */, SP::BPFCC, Convert__Imm1_2__imm_95_13__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1099 /* fble */, SP::BPFCCANT, Convert__Imm1_3__imm_95_13__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1099 /* fble */, SP::BPFCCA, Convert__Imm1_3__imm_95_13__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1104 /* fblg */, SP::FBCOND, Convert__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 1104 /* fblg */, SP::FBCONDA, Convert__Imm1_1__imm_95_2, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1104 /* fblg */, SP::BPFCC, Convert__Imm1_1__imm_95_2__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1104 /* fblg */, SP::BPFCCA, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1104 /* fblg */, SP::BPFCCNT, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1104 /* fblg */, SP::BPFCC, Convert__Imm1_2__imm_95_2__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1104 /* fblg */, SP::BPFCCANT, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1104 /* fblg */, SP::BPFCCA, Convert__Imm1_3__imm_95_2__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1109 /* fbn */, SP::FBCOND, Convert__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 1109 /* fbn */, SP::FBCONDA, Convert__Imm1_1__imm_95_0, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1109 /* fbn */, SP::BPFCC, Convert__Imm1_1__imm_95_0__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1109 /* fbn */, SP::BPFCCA, Convert__Imm1_2__imm_95_0__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1109 /* fbn */, SP::BPFCCNT, Convert__Imm1_2__imm_95_0__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1109 /* fbn */, SP::BPFCC, Convert__Imm1_2__imm_95_0__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1109 /* fbn */, SP::BPFCCANT, Convert__Imm1_3__imm_95_0__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1109 /* fbn */, SP::BPFCCA, Convert__Imm1_3__imm_95_0__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1113 /* fbne */, SP::FBCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 1113 /* fbne */, SP::FBCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1113 /* fbne */, SP::BPFCC, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1113 /* fbne */, SP::BPFCCA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1113 /* fbne */, SP::BPFCCNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1113 /* fbne */, SP::BPFCC, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1113 /* fbne */, SP::BPFCCANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1113 /* fbne */, SP::BPFCCA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1118 /* fbnz */, SP::FBCOND, Convert__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 1118 /* fbnz */, SP::FBCONDA, Convert__Imm1_1__imm_95_1, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1118 /* fbnz */, SP::BPFCC, Convert__Imm1_1__imm_95_1__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1118 /* fbnz */, SP::BPFCCA, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1118 /* fbnz */, SP::BPFCCNT, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1118 /* fbnz */, SP::BPFCC, Convert__Imm1_2__imm_95_1__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1118 /* fbnz */, SP::BPFCCANT, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1118 /* fbnz */, SP::BPFCCA, Convert__Imm1_3__imm_95_1__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1123 /* fbo */, SP::FBCOND, Convert__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 1123 /* fbo */, SP::FBCONDA, Convert__Imm1_1__imm_95_15, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1123 /* fbo */, SP::BPFCC, Convert__Imm1_1__imm_95_15__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1123 /* fbo */, SP::BPFCCA, Convert__Imm1_2__imm_95_15__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1123 /* fbo */, SP::BPFCCNT, Convert__Imm1_2__imm_95_15__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1123 /* fbo */, SP::BPFCC, Convert__Imm1_2__imm_95_15__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1123 /* fbo */, SP::BPFCCANT, Convert__Imm1_3__imm_95_15__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1123 /* fbo */, SP::BPFCCA, Convert__Imm1_3__imm_95_15__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1127 /* fbu */, SP::FBCOND, Convert__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 1127 /* fbu */, SP::FBCONDA, Convert__Imm1_1__imm_95_7, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1127 /* fbu */, SP::BPFCC, Convert__Imm1_1__imm_95_7__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1127 /* fbu */, SP::BPFCCA, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1127 /* fbu */, SP::BPFCCNT, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1127 /* fbu */, SP::BPFCC, Convert__Imm1_2__imm_95_7__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1127 /* fbu */, SP::BPFCCANT, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1127 /* fbu */, SP::BPFCCA, Convert__Imm1_3__imm_95_7__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1131 /* fbue */, SP::FBCOND, Convert__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 1131 /* fbue */, SP::FBCONDA, Convert__Imm1_1__imm_95_10, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1131 /* fbue */, SP::BPFCC, Convert__Imm1_1__imm_95_10__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1131 /* fbue */, SP::BPFCCA, Convert__Imm1_2__imm_95_10__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1131 /* fbue */, SP::BPFCCNT, Convert__Imm1_2__imm_95_10__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1131 /* fbue */, SP::BPFCC, Convert__Imm1_2__imm_95_10__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1131 /* fbue */, SP::BPFCCANT, Convert__Imm1_3__imm_95_10__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1131 /* fbue */, SP::BPFCCA, Convert__Imm1_3__imm_95_10__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1136 /* fbug */, SP::FBCOND, Convert__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 1136 /* fbug */, SP::FBCONDA, Convert__Imm1_1__imm_95_5, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1136 /* fbug */, SP::BPFCC, Convert__Imm1_1__imm_95_5__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1136 /* fbug */, SP::BPFCCA, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1136 /* fbug */, SP::BPFCCNT, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1136 /* fbug */, SP::BPFCC, Convert__Imm1_2__imm_95_5__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1136 /* fbug */, SP::BPFCCANT, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1136 /* fbug */, SP::BPFCCA, Convert__Imm1_3__imm_95_5__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1141 /* fbuge */, SP::FBCOND, Convert__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 1141 /* fbuge */, SP::FBCONDA, Convert__Imm1_1__imm_95_12, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1141 /* fbuge */, SP::BPFCC, Convert__Imm1_1__imm_95_12__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1141 /* fbuge */, SP::BPFCCA, Convert__Imm1_2__imm_95_12__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1141 /* fbuge */, SP::BPFCCNT, Convert__Imm1_2__imm_95_12__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1141 /* fbuge */, SP::BPFCC, Convert__Imm1_2__imm_95_12__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1141 /* fbuge */, SP::BPFCCANT, Convert__Imm1_3__imm_95_12__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1141 /* fbuge */, SP::BPFCCA, Convert__Imm1_3__imm_95_12__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1147 /* fbul */, SP::FBCOND, Convert__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 1147 /* fbul */, SP::FBCONDA, Convert__Imm1_1__imm_95_3, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1147 /* fbul */, SP::BPFCC, Convert__Imm1_1__imm_95_3__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1147 /* fbul */, SP::BPFCCA, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1147 /* fbul */, SP::BPFCCNT, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1147 /* fbul */, SP::BPFCC, Convert__Imm1_2__imm_95_3__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1147 /* fbul */, SP::BPFCCANT, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1147 /* fbul */, SP::BPFCCA, Convert__Imm1_3__imm_95_3__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1152 /* fbule */, SP::FBCOND, Convert__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 1152 /* fbule */, SP::FBCONDA, Convert__Imm1_1__imm_95_14, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1152 /* fbule */, SP::BPFCC, Convert__Imm1_1__imm_95_14__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1152 /* fbule */, SP::BPFCCA, Convert__Imm1_2__imm_95_14__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1152 /* fbule */, SP::BPFCCNT, Convert__Imm1_2__imm_95_14__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1152 /* fbule */, SP::BPFCC, Convert__Imm1_2__imm_95_14__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1152 /* fbule */, SP::BPFCCANT, Convert__Imm1_3__imm_95_14__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1152 /* fbule */, SP::BPFCCA, Convert__Imm1_3__imm_95_14__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1158 /* fbz */, SP::FBCOND, Convert__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 1158 /* fbz */, SP::FBCONDA, Convert__Imm1_1__imm_95_9, AMFBS_None, { MCK_a, MCK_Imm }, },
  { 1158 /* fbz */, SP::BPFCC, Convert__Imm1_1__imm_95_9__Reg1_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm }, },
  { 1158 /* fbz */, SP::BPFCCA, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_a, MCK_FCCRegs, MCK_Imm }, },
  { 1158 /* fbz */, SP::BPFCCNT, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1158 /* fbz */, SP::BPFCC, Convert__Imm1_2__imm_95_9__Reg1_1, AMFBS_HasV9, { MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1158 /* fbz */, SP::BPFCCANT, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pn, MCK_FCCRegs, MCK_Imm }, },
  { 1158 /* fbz */, SP::BPFCCA, Convert__Imm1_3__imm_95_9__Reg1_2, AMFBS_HasV9, { MCK_a, MCK_pt, MCK_FCCRegs, MCK_Imm }, },
  { 1162 /* fchksm16 */, SP::FCHKSM16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1171 /* fcmpd */, SP::V9FCMPD, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 1171 /* fcmpd */, SP::V9FCMPD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1177 /* fcmped */, SP::V9FCMPED, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 1177 /* fcmped */, SP::V9FCMPED, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1184 /* fcmpeq */, SP::V9FCMPEQ, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 1184 /* fcmpeq */, SP::V9FCMPEQ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1191 /* fcmpeq16 */, SP::FCMPEQ16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1200 /* fcmpeq32 */, SP::FCMPEQ32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1209 /* fcmpes */, SP::V9FCMPES, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 1209 /* fcmpes */, SP::V9FCMPES, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1216 /* fcmpgt16 */, SP::FCMPGT16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1225 /* fcmpgt32 */, SP::FCMPGT32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1234 /* fcmple16 */, SP::FCMPLE16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1243 /* fcmple32 */, SP::FCMPLE32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1252 /* fcmpne16 */, SP::FCMPNE16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1261 /* fcmpne32 */, SP::FCMPNE32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 1270 /* fcmpq */, SP::V9FCMPQ, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 1270 /* fcmpq */, SP::V9FCMPQ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1276 /* fcmps */, SP::V9FCMPS, Convert__regFCC0__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 1276 /* fcmps */, SP::V9FCMPS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1282 /* fdivd */, SP::FDIVD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1288 /* fdivq */, SP::FDIVQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1294 /* fdivs */, SP::FDIVS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1300 /* fdmulq */, SP::FDMULQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_QFPRegs }, },
  { 1307 /* fdtoi */, SP::FDTOI, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_FPRegs }, },
  { 1313 /* fdtoq */, SP::FDTOQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_QFPRegs }, },
  { 1319 /* fdtos */, SP::FDTOS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_FPRegs }, },
  { 1325 /* fdtox */, SP::FDTOX, Convert__Reg1_1__Reg1_0, AMFBS_Is64Bit, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 1331 /* fexpand */, SP::FEXPAND, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_DFPRegs }, },
  { 1339 /* fhaddd */, SP::FHADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1346 /* fhadds */, SP::FHADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1353 /* fhsubd */, SP::FHSUBD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1360 /* fhsubs */, SP::FHSUBS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1367 /* fitod */, SP::FITOD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_DFPRegs }, },
  { 1373 /* fitoq */, SP::FITOQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_QFPRegs }, },
  { 1379 /* fitos */, SP::FITOS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 1385 /* flcmpd */, SP::FLCMPD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVIS3, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1392 /* flcmps */, SP::FLCMPS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVIS3, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1399 /* flush */, SP::FLUSH, Convert_NoOperands, AMFBS_None, {  }, },
  { 1399 /* flush */, SP::FLUSH, Convert_NoOperands, AMFBS_None, { MCK_G0 }, },
  { 1399 /* flush */, SP::FLUSHri, Convert__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 1399 /* flush */, SP::FLUSHrr, Convert__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 1405 /* flushw */, SP::FLUSHW, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 1412 /* fmaddd */, SP::FMADDD, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1419 /* fmadds */, SP::FMADDS, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 1426 /* fmean16 */, SP::FMEAN16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::FMOVD, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::FMOVD_XCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::FMOVD_FCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::FMOVD_ICC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1434 /* fmovd */, SP::V9FMOVD_FCC, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1440 /* fmovda */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1440 /* fmovda */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1440 /* fmovda */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1447 /* fmovdcc */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1447 /* fmovdcc */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1455 /* fmovdcs */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1455 /* fmovdcs */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1463 /* fmovde */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1463 /* fmovde */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1463 /* fmovde */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1470 /* fmovdeq */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1470 /* fmovdeq */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1478 /* fmovdg */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1478 /* fmovdg */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1478 /* fmovdg */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1485 /* fmovdge */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1485 /* fmovdge */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1485 /* fmovdge */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1493 /* fmovdgeu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1493 /* fmovdgeu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1502 /* fmovdgt */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1502 /* fmovdgt */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1510 /* fmovdgu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1510 /* fmovdgu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1518 /* fmovdl */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1518 /* fmovdl */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1518 /* fmovdl */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1525 /* fmovdle */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1525 /* fmovdle */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1525 /* fmovdle */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1533 /* fmovdleu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1533 /* fmovdleu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1542 /* fmovdlg */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1550 /* fmovdlt */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1550 /* fmovdlt */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1558 /* fmovdlu */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1558 /* fmovdlu */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1566 /* fmovdn */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1566 /* fmovdn */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1566 /* fmovdn */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1573 /* fmovdne */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1573 /* fmovdne */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1573 /* fmovdne */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1581 /* fmovdneg */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1581 /* fmovdneg */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1590 /* fmovdnz */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1590 /* fmovdnz */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1590 /* fmovdnz */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1598 /* fmovdo */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1605 /* fmovdpos */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1605 /* fmovdpos */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1614 /* fmovdu */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1621 /* fmovdue */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1629 /* fmovdug */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1637 /* fmovduge */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1646 /* fmovdul */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1654 /* fmovdule */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1663 /* fmovdvc */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1663 /* fmovdvc */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1671 /* fmovdvs */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1671 /* fmovdvs */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1679 /* fmovdz */, SP::FMOVD_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1679 /* fmovdz */, SP::FMOVD_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1679 /* fmovdz */, SP::V9FMOVD_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1686 /* fmovq */, SP::FMOVQ, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 1686 /* fmovq */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1686 /* fmovq */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1686 /* fmovq */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1686 /* fmovq */, SP::FMOVQ_XCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1686 /* fmovq */, SP::FMOVQ_FCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1686 /* fmovq */, SP::FMOVQ_ICC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1686 /* fmovq */, SP::V9FMOVQ_FCC, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1692 /* fmovqa */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1692 /* fmovqa */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1692 /* fmovqa */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1699 /* fmovqcc */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1699 /* fmovqcc */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1707 /* fmovqcs */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1707 /* fmovqcs */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1715 /* fmovqe */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1715 /* fmovqe */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1715 /* fmovqe */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1722 /* fmovqeq */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1722 /* fmovqeq */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1730 /* fmovqg */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1730 /* fmovqg */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1730 /* fmovqg */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1737 /* fmovqge */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1737 /* fmovqge */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1737 /* fmovqge */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1745 /* fmovqgeu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1745 /* fmovqgeu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1754 /* fmovqgt */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1754 /* fmovqgt */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1762 /* fmovqgu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1762 /* fmovqgu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1770 /* fmovql */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1770 /* fmovql */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1770 /* fmovql */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1777 /* fmovqle */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1777 /* fmovqle */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1777 /* fmovqle */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1785 /* fmovqleu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1785 /* fmovqleu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1794 /* fmovqlg */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1802 /* fmovqlt */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1802 /* fmovqlt */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1810 /* fmovqlu */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1810 /* fmovqlu */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1818 /* fmovqn */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1818 /* fmovqn */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1818 /* fmovqn */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1825 /* fmovqne */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1825 /* fmovqne */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1825 /* fmovqne */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1833 /* fmovqneg */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1833 /* fmovqneg */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1842 /* fmovqnz */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1842 /* fmovqnz */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1842 /* fmovqnz */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1850 /* fmovqo */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1857 /* fmovqpos */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1857 /* fmovqpos */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1866 /* fmovqu */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1873 /* fmovque */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1881 /* fmovqug */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1889 /* fmovquge */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1898 /* fmovqul */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1906 /* fmovqule */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1915 /* fmovqvc */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1915 /* fmovqvc */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1923 /* fmovqvs */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1923 /* fmovqvs */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1931 /* fmovqz */, SP::FMOVQ_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1931 /* fmovqz */, SP::FMOVQ_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1931 /* fmovqz */, SP::V9FMOVQ_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 1938 /* fmovrd */, SP::FMOVRD, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1945 /* fmovrde */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1953 /* fmovrdgez */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1963 /* fmovrdgz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1972 /* fmovrdlez */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1982 /* fmovrdlz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 1991 /* fmovrdne */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2000 /* fmovrdnz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2009 /* fmovrdz */, SP::FMOVRD, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2017 /* fmovrq */, SP::FMOVRQ, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2024 /* fmovrqe */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2032 /* fmovrqgez */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2042 /* fmovrqgz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2051 /* fmovrqlez */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2061 /* fmovrqlz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2070 /* fmovrqne */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2079 /* fmovrqnz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2088 /* fmovrqz */, SP::FMOVRQ, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2096 /* fmovrs */, SP::FMOVRS, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2103 /* fmovrse */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2111 /* fmovrsgez */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2121 /* fmovrsgz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2130 /* fmovrslez */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2140 /* fmovrslz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2149 /* fmovrsne */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2158 /* fmovrsnz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2167 /* fmovrsz */, SP::FMOVRS, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::FMOVS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::FMOVS_XCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::FMOVS_FCC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::FMOVS_ICC, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2175 /* fmovs */, SP::V9FMOVS_FCC, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2181 /* fmovsa */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2181 /* fmovsa */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2181 /* fmovsa */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2188 /* fmovscc */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2188 /* fmovscc */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2196 /* fmovscs */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2196 /* fmovscs */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2204 /* fmovse */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2204 /* fmovse */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2204 /* fmovse */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2211 /* fmovseq */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2211 /* fmovseq */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2219 /* fmovsg */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2219 /* fmovsg */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2219 /* fmovsg */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2226 /* fmovsge */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2226 /* fmovsge */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2226 /* fmovsge */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2234 /* fmovsgeu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2234 /* fmovsgeu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2243 /* fmovsgt */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2243 /* fmovsgt */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2251 /* fmovsgu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2251 /* fmovsgu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2259 /* fmovsl */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2259 /* fmovsl */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2259 /* fmovsl */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2266 /* fmovsle */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2266 /* fmovsle */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2266 /* fmovsle */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2274 /* fmovsleu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2274 /* fmovsleu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2283 /* fmovslg */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2291 /* fmovslt */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2291 /* fmovslt */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2299 /* fmovslu */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2299 /* fmovslu */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2307 /* fmovsn */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2307 /* fmovsn */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2307 /* fmovsn */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2314 /* fmovsne */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2314 /* fmovsne */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2314 /* fmovsne */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2322 /* fmovsneg */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2322 /* fmovsneg */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2331 /* fmovsnz */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2331 /* fmovsnz */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2331 /* fmovsnz */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2339 /* fmovso */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2346 /* fmovspos */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2346 /* fmovspos */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2355 /* fmovsu */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2362 /* fmovsue */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2370 /* fmovsug */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2378 /* fmovsuge */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2387 /* fmovsul */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2395 /* fmovsule */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2404 /* fmovsvc */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2404 /* fmovsvc */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2412 /* fmovsvs */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2412 /* fmovsvs */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2420 /* fmovsz */, SP::FMOVS_XCC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_FPRegs, MCK_FPRegs }, },
  { 2420 /* fmovsz */, SP::FMOVS_ICC, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_FPRegs, MCK_FPRegs }, },
  { 2420 /* fmovsz */, SP::V9FMOVS_FCC, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2427 /* fmsubd */, SP::FMSUBD, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2434 /* fmsubs */, SP::FMSUBS, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2441 /* fmul8sux16 */, SP::FMUL8SUX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2452 /* fmul8ulx16 */, SP::FMUL8ULX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2463 /* fmul8x16 */, SP::FMUL8X16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2472 /* fmul8x16al */, SP::FMUL8X16AL, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2483 /* fmul8x16au */, SP::FMUL8X16AU, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2494 /* fmuld */, SP::FMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2500 /* fmuld8sux16 */, SP::FMULD8SUX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2512 /* fmuld8ulx16 */, SP::FMULD8ULX16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2524 /* fmulq */, SP::FMULQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 2530 /* fmuls */, SP::FMULS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2536 /* fnaddd */, SP::FNADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2543 /* fnadds */, SP::FNADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2550 /* fnand */, SP::FNAND, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2556 /* fnands */, SP::FNANDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2563 /* fnegd */, SP::FNEGD, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2569 /* fnegq */, SP::FNEGQ, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 2575 /* fnegs */, SP::FNEGS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 2581 /* fnhaddd */, SP::FNHADDD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2589 /* fnhadds */, SP::FNHADDS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2597 /* fnmaddd */, SP::FNMADDD, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2605 /* fnmadds */, SP::FNMADDS, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2613 /* fnmsubd */, SP::FNMSUBD, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2621 /* fnmsubs */, SP::FNMSUBS, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasUA2007, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2629 /* fnmuld */, SP::FNMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2636 /* fnmuls */, SP::FNMULS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2643 /* fnor */, SP::FNOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2648 /* fnors */, SP::FNORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2654 /* fnot1 */, SP::FNOT1, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2660 /* fnot1s */, SP::FNOT1S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2667 /* fnot2 */, SP::FNOT2, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2673 /* fnot2s */, SP::FNOT2S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2680 /* fnsmuld */, SP::FNSMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2688 /* fone */, SP::FONE, Convert__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs }, },
  { 2693 /* fones */, SP::FONES, Convert__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs }, },
  { 2699 /* for */, SP::FOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2703 /* fornot1 */, SP::FORNOT1, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2711 /* fornot1s */, SP::FORNOT1S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2720 /* fornot2 */, SP::FORNOT2, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2728 /* fornot2s */, SP::FORNOT2S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2737 /* fors */, SP::FORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2742 /* fpack16 */, SP::FPACK16, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2750 /* fpack32 */, SP::FPACK32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2758 /* fpackfix */, SP::FPACKFIX, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_FPRegs }, },
  { 2767 /* fpadd16 */, SP::FPADD16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2775 /* fpadd16s */, SP::FPADD16S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2784 /* fpadd32 */, SP::FPADD32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2792 /* fpadd32s */, SP::FPADD32S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2801 /* fpadd64 */, SP::FPADD64, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2809 /* fpmaddx */, SP::FPMADDX, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasOSA2011, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2817 /* fpmaddxhi */, SP::FPMADDXHI, Convert__Reg1_3__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasOSA2011, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2827 /* fpmerge */, SP::FPMERGE, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2835 /* fpsub16 */, SP::FPSUB16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2843 /* fpsub16s */, SP::FPSUB16S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2852 /* fpsub32 */, SP::FPSUB32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2860 /* fpsub32s */, SP::FPSUB32S, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 2869 /* fqtod */, SP::FQTOD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_DFPRegs }, },
  { 2875 /* fqtoi */, SP::FQTOI, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_FPRegs }, },
  { 2881 /* fqtos */, SP::FQTOS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_FPRegs }, },
  { 2887 /* fqtox */, SP::FQTOX, Convert__Reg1_1__Reg1_0, AMFBS_Is64Bit, { MCK_QFPRegs, MCK_DFPRegs }, },
  { 2893 /* fslas16 */, SP::FSLAS16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2901 /* fslas32 */, SP::FSLAS32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2909 /* fsll16 */, SP::FSLL16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2916 /* fsll32 */, SP::FSLL32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2923 /* fsmuld */, SP::FSMULD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_DFPRegs }, },
  { 2930 /* fsqrtd */, SP::FSQRTD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2937 /* fsqrtq */, SP::FSQRTQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs }, },
  { 2944 /* fsqrts */, SP::FSQRTS, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 2951 /* fsra16 */, SP::FSRA16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2958 /* fsra32 */, SP::FSRA32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2965 /* fsrc1 */, SP::FSRC1, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2971 /* fsrc1s */, SP::FSRC1S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2978 /* fsrc2 */, SP::FSRC2, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 2984 /* fsrc2s */, SP::FSRC2S, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs }, },
  { 2991 /* fsrl16 */, SP::FSRL16, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 2998 /* fsrl32 */, SP::FSRL32, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 3005 /* fstod */, SP::FSTOD, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_DFPRegs }, },
  { 3011 /* fstoi */, SP::FSTOI, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_FPRegs }, },
  { 3017 /* fstoq */, SP::FSTOQ, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK_QFPRegs }, },
  { 3023 /* fstox */, SP::FSTOX, Convert__Reg1_1__Reg1_0, AMFBS_Is64Bit, { MCK_FPRegs, MCK_DFPRegs }, },
  { 3029 /* fsubd */, SP::FSUBD, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 3035 /* fsubq */, SP::FSUBQ, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_QFPRegs, MCK_QFPRegs, MCK_QFPRegs }, },
  { 3041 /* fsubs */, SP::FSUBS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 3047 /* fxnor */, SP::FXNOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 3053 /* fxnors */, SP::FXNORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 3060 /* fxor */, SP::FXOR, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 3065 /* fxors */, SP::FXORS, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_FPRegs, MCK_FPRegs, MCK_FPRegs }, },
  { 3071 /* fxtod */, SP::FXTOD, Convert__Reg1_1__Reg1_0, AMFBS_Is64Bit, { MCK_DFPRegs, MCK_DFPRegs }, },
  { 3077 /* fxtoq */, SP::FXTOQ, Convert__Reg1_1__Reg1_0, AMFBS_Is64Bit, { MCK_DFPRegs, MCK_QFPRegs }, },
  { 3083 /* fxtos */, SP::FXTOS, Convert__Reg1_1__Reg1_0, AMFBS_Is64Bit, { MCK_DFPRegs, MCK_FPRegs }, },
  { 3089 /* fzero */, SP::FZERO, Convert__Reg1_0, AMFBS_HasVIS, { MCK_DFPRegs }, },
  { 3095 /* fzeros */, SP::FZEROS, Convert__Reg1_0, AMFBS_HasVIS, { MCK_FPRegs }, },
  { 3102 /* inc */, SP::ADDri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 3102 /* inc */, SP::ADDri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 3106 /* inccc */, SP::ADDCCri, Convert__Reg1_0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 3106 /* inccc */, SP::ADDCCri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 3112 /* invalw */, SP::INVALW, Convert_NoOperands, AMFBS_HasUA2005, {  }, },
  { 3119 /* jmp */, SP::JMPLri, Convert__regG0__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 3119 /* jmp */, SP::JMPLrr, Convert__regG0__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 3123 /* jmpl */, SP::JMPLri, Convert__Reg1_1__MEMri2_0, AMFBS_None, { MCK_MEMri, MCK_IntRegs }, },
  { 3123 /* jmpl */, SP::JMPLrr, Convert__Reg1_1__MEMrr2_0, AMFBS_None, { MCK_MEMrr, MCK_IntRegs }, },
  { 3128 /* ld */, SP::LDCSRri, Convert__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_CPSR }, },
  { 3128 /* ld */, SP::LDFSRri, Convert__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_FSR }, },
  { 3128 /* ld */, SP::LDCri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_CoprocRegs }, },
  { 3128 /* ld */, SP::LDFri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_FPRegs }, },
  { 3128 /* ld */, SP::LDri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3128 /* ld */, SP::LDCSRrr, Convert__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_CPSR }, },
  { 3128 /* ld */, SP::LDFSRrr, Convert__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_FSR }, },
  { 3128 /* ld */, SP::LDCrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_CoprocRegs }, },
  { 3128 /* ld */, SP::LDFrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_FPRegs }, },
  { 3128 /* ld */, SP::LDrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3128 /* ld */, SP::GDOP_LDrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_GOT }, },
  { 3128 /* ld */, SP::TLS_LDrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_TLS }, },
  { 3131 /* lda */, SP::LDFAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_FPRegs }, },
  { 3131 /* lda */, SP::LDAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3131 /* lda */, SP::LDFArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_FPRegs }, },
  { 3131 /* lda */, SP::LDArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3135 /* ldd */, SP::LDDCri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_CoprocPair }, },
  { 3135 /* ldd */, SP::LDDri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntPair }, },
  { 3135 /* ldd */, SP::LDDFri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_DFPRegs }, },
  { 3135 /* ldd */, SP::LDDCrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_CoprocPair }, },
  { 3135 /* ldd */, SP::LDDrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntPair }, },
  { 3135 /* ldd */, SP::LDDFrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_DFPRegs }, },
  { 3139 /* ldda */, SP::LDDAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntPair }, },
  { 3139 /* ldda */, SP::LDDFAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_DFPRegs }, },
  { 3139 /* ldda */, SP::LDDArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntPair }, },
  { 3139 /* ldda */, SP::LDDFArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_DFPRegs }, },
  { 3144 /* ldq */, SP::LDQFri, Convert__Reg1_3__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK_QFPRegs }, },
  { 3144 /* ldq */, SP::LDQFrr, Convert__Reg1_3__MEMrr2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_QFPRegs }, },
  { 3148 /* ldqa */, SP::LDQFAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_QFPRegs }, },
  { 3148 /* ldqa */, SP::LDQFArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_QFPRegs }, },
  { 3153 /* ldsb */, SP::LDSBri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3153 /* ldsb */, SP::LDSBrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3158 /* ldsba */, SP::LDSBAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3158 /* ldsba */, SP::LDSBArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3164 /* ldsh */, SP::LDSHri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3164 /* ldsh */, SP::LDSHrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3169 /* ldsha */, SP::LDSHAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3169 /* ldsha */, SP::LDSHArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3175 /* ldstub */, SP::LDSTUBri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3175 /* ldstub */, SP::LDSTUBrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3182 /* ldstuba */, SP::LDSTUBAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3182 /* ldstuba */, SP::LDSTUBArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3190 /* ldsw */, SP::LDSWri, Convert__Reg1_3__MEMri2_1, AMFBS_Is64Bit, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3190 /* ldsw */, SP::LDSWrr, Convert__Reg1_3__MEMrr2_1, AMFBS_Is64Bit, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3195 /* ldswa */, SP::LDSWAri, Convert__Reg1_4__MEMri2_1, AMFBS_Is64Bit, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3195 /* ldswa */, SP::LDSWArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_Is64Bit, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3201 /* ldub */, SP::LDUBri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3201 /* ldub */, SP::LDUBrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3206 /* lduba */, SP::LDUBAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3206 /* lduba */, SP::LDUBArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3212 /* lduh */, SP::LDUHri, Convert__Reg1_3__MEMri2_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3212 /* lduh */, SP::LDUHrr, Convert__Reg1_3__MEMrr2_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3217 /* lduha */, SP::LDUHAri, Convert__Reg1_4__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3217 /* lduha */, SP::LDUHArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3223 /* ldx */, SP::LDXFSRri, Convert__MEMri2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK_FSR }, },
  { 3223 /* ldx */, SP::LDXri, Convert__Reg1_3__MEMri2_1, AMFBS_Is64Bit, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3223 /* ldx */, SP::LDXFSRrr, Convert__MEMrr2_1, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_FSR }, },
  { 3223 /* ldx */, SP::LDXrr, Convert__Reg1_3__MEMrr2_1, AMFBS_Is64Bit, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3223 /* ldx */, SP::GDOP_LDXrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_GOT1_4, AMFBS_Is64Bit, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_GOT }, },
  { 3223 /* ldx */, SP::TLS_LDXrr, Convert__Reg1_3__MEMrr2_1__TailRelocSymLoad_TLS1_4, AMFBS_Is64Bit, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs, MCK_TailRelocSymLoad_TLS }, },
  { 3227 /* ldxa */, SP::LDXAri, Convert__Reg1_4__MEMri2_1, AMFBS_Is64Bit, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3227 /* ldxa */, SP::LDXArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3, AMFBS_Is64Bit, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3232 /* lzcnt */, SP::LZCNT, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs }, },
  { 3238 /* md5 */, SP::MD5, Convert_NoOperands, AMFBS_HasCrypto, {  }, },
  { 3242 /* membar */, SP::MEMBARi, Convert__MembarTag1_0, AMFBS_HasV9, { MCK_MembarTag }, },
  { 3249 /* montmul */, SP::MONTMUL, Convert__Imm1_0, AMFBS_HasCrypto, { MCK_Imm }, },
  { 3257 /* montsqr */, SP::MONTSQR, Convert__Imm1_0, AMFBS_HasCrypto, { MCK_Imm }, },
  { 3265 /* mov */, SP::RDPSR, Convert__Reg1_1, AMFBS_None, { MCK_PSR, MCK_IntRegs }, },
  { 3265 /* mov */, SP::RDTBR, Convert__Reg1_1, AMFBS_None, { MCK_TBR, MCK_IntRegs }, },
  { 3265 /* mov */, SP::RDWIM, Convert__Reg1_1, AMFBS_None, { MCK_WIM, MCK_IntRegs }, },
  { 3265 /* mov */, SP::WRPSRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_PSR }, },
  { 3265 /* mov */, SP::WRTBRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_TBR }, },
  { 3265 /* mov */, SP::WRWIMrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_WIM }, },
  { 3265 /* mov */, SP::ORrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::WRASRrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_ASRRegs }, },
  { 3265 /* mov */, SP::RDASR, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_ASRRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::WRPSRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_PSR }, },
  { 3265 /* mov */, SP::WRTBRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_TBR }, },
  { 3265 /* mov */, SP::WRWIMri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_WIM }, },
  { 3265 /* mov */, SP::ORri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 3265 /* mov */, SP::WRASRri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_ASRRegs }, },
  { 3265 /* mov */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3265 /* mov */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVXCCrr, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVXCCri, Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVFCCrr, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVFCCri, Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCC0, MCK_Imm, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVICCrr, Convert__Reg1_3__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::MOVICCri, Convert__Reg1_3__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3265 /* mov */, SP::V9MOVFCCrr, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3265 /* mov */, SP::V9MOVFCCri, Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3269 /* mova */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3269 /* mova */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3269 /* mova */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3269 /* mova */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3269 /* mova */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3269 /* mova */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_8, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3274 /* movcc */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3274 /* movcc */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3274 /* movcc */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3274 /* movcc */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3280 /* movcs */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3280 /* movcs */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3280 /* movcs */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3280 /* movcs */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3286 /* movdtox */, SP::MOVDTOX, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_IntRegs }, },
  { 3294 /* move */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3294 /* move */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3294 /* move */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3294 /* move */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3294 /* move */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3294 /* move */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3299 /* moveq */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3299 /* moveq */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3299 /* moveq */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3299 /* moveq */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3305 /* movg */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3305 /* movg */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3305 /* movg */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3305 /* movg */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3305 /* movg */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3305 /* movg */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3310 /* movge */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3310 /* movge */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3310 /* movge */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3310 /* movge */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3310 /* movge */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3310 /* movge */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_11, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3316 /* movgeu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3316 /* movgeu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3316 /* movgeu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3316 /* movgeu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3323 /* movgt */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3323 /* movgt */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3323 /* movgt */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3323 /* movgt */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3329 /* movgu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3329 /* movgu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3329 /* movgu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3329 /* movgu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3335 /* movl */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3335 /* movl */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3335 /* movl */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3335 /* movl */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3335 /* movl */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3335 /* movl */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3340 /* movle */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3340 /* movle */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3340 /* movle */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3340 /* movle */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3340 /* movle */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3340 /* movle */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_13, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3346 /* movleu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3346 /* movleu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3346 /* movleu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3346 /* movleu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3353 /* movlg */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3353 /* movlg */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3359 /* movlt */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3359 /* movlt */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3359 /* movlt */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3359 /* movlt */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3365 /* movlu */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3365 /* movlu */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3365 /* movlu */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3365 /* movlu */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3371 /* movn */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3371 /* movn */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3371 /* movn */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3371 /* movn */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3371 /* movn */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3371 /* movn */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_0, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3376 /* movne */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3376 /* movne */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3376 /* movne */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3376 /* movne */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3376 /* movne */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3376 /* movne */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3382 /* movneg */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3382 /* movneg */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3382 /* movneg */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3382 /* movneg */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3389 /* movnz */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3389 /* movnz */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3389 /* movnz */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3389 /* movnz */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3389 /* movnz */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3389 /* movnz */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3395 /* movo */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3395 /* movo */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3400 /* movpos */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3400 /* movpos */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3400 /* movpos */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3400 /* movpos */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3407 /* movr */, SP::MOVRrr, Convert__Reg1_3__Reg1_1__Reg1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3407 /* movr */, SP::MOVRri, Convert__Reg1_3__Reg1_1__Imm1_2__Tie0_1_1__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3412 /* movre */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3412 /* movre */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3418 /* movrgez */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3418 /* movrgez */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3426 /* movrgz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3426 /* movrgz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_6, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3433 /* movrlez */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3433 /* movrlez */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_2, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3441 /* movrlz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3441 /* movrlz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3448 /* movrne */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3448 /* movrne */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3455 /* movrnz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3455 /* movrnz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3462 /* movrz */, SP::MOVRrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3462 /* movrz */, SP::MOVRri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3468 /* movstosw */, SP::MOVSTOSW, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_FPRegs, MCK_IntRegs }, },
  { 3477 /* movstouw */, SP::MOVSTOUW, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_FPRegs, MCK_IntRegs }, },
  { 3486 /* movu */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3486 /* movu */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3491 /* movue */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3491 /* movue */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_10, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3497 /* movug */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3497 /* movug */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_5, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3503 /* movuge */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3503 /* movuge */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_12, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3510 /* movul */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3510 /* movul */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_3, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3516 /* movule */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3516 /* movule */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_14, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3523 /* movvc */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3523 /* movvc */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3523 /* movvc */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3523 /* movvc */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3529 /* movvs */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3529 /* movvs */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3529 /* movvs */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3529 /* movvs */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3535 /* movwtos */, SP::MOVWTOS, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs, MCK_FPRegs }, },
  { 3543 /* movxtod */, SP::MOVXTOD, Convert__Reg1_1__Reg1_0, AMFBS_HasVIS3, { MCK_IntRegs, MCK_DFPRegs }, },
  { 3551 /* movz */, SP::MOVXCCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_IntRegs, MCK_IntRegs }, },
  { 3551 /* movz */, SP::MOVXCCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_Is64Bit, { MCK__PCT_xcc, MCK_Imm, MCK_IntRegs }, },
  { 3551 /* movz */, SP::MOVICCrr, Convert__Reg1_2__Reg1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK_IntRegs }, },
  { 3551 /* movz */, SP::MOVICCri, Convert__Reg1_2__Imm1_1__Tie0_3_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm, MCK_IntRegs }, },
  { 3551 /* movz */, SP::V9MOVFCCrr, Convert__Reg1_2__Reg1_0__Reg1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3551 /* movz */, SP::V9MOVFCCri, Convert__Reg1_2__Reg1_0__Imm1_1__Tie0_3_3__imm_95_9, AMFBS_HasV9, { MCK_FCCRegs, MCK_Imm, MCK_IntRegs }, },
  { 3556 /* mpmul */, SP::MPMUL, Convert__Imm1_0, AMFBS_HasCrypto, { MCK_Imm }, },
  { 3562 /* mulscc */, SP::MULSCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3562 /* mulscc */, SP::MULSCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3569 /* mulx */, SP::MULXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3569 /* mulx */, SP::MULXri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3574 /* neg */, SP::SUBrr, Convert__Reg1_0__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs }, },
  { 3574 /* neg */, SP::SUBrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 3578 /* nop */, SP::NOP, Convert_NoOperands, AMFBS_None, {  }, },
  { 3582 /* normalw */, SP::NORMALW, Convert_NoOperands, AMFBS_HasUA2005, {  }, },
  { 3590 /* not */, SP::XNORrr, Convert__Reg1_0__Reg1_0__regG0, AMFBS_None, { MCK_IntRegs }, },
  { 3590 /* not */, SP::XNORrr, Convert__Reg1_1__Reg1_0__regG0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs }, },
  { 3594 /* or */, SP::ORrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3594 /* or */, SP::ORri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3594 /* or */, SP::ORri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK_IntRegs }, },
  { 3597 /* orcc */, SP::ORCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3597 /* orcc */, SP::ORCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3602 /* orn */, SP::ORNrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3602 /* orn */, SP::ORNri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3606 /* orncc */, SP::ORNCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3606 /* orncc */, SP::ORNCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3612 /* otherw */, SP::OTHERW, Convert_NoOperands, AMFBS_HasUA2005, {  }, },
  { 3619 /* pause */, SP::WRASRrr, Convert__regASR27__regG0__Reg1_0, AMFBS_HasOSA2011, { MCK_IntRegs }, },
  { 3619 /* pause */, SP::WRASRri, Convert__regASR27__regG0__Imm1_0, AMFBS_HasOSA2011, { MCK_Imm }, },
  { 3625 /* pdist */, SP::PDIST, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS, { MCK_DFPRegs, MCK_DFPRegs, MCK_DFPRegs }, },
  { 3631 /* pdistn */, SP::PDISTN, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_DFPRegs, MCK_DFPRegs, MCK_IntRegs }, },
  { 3638 /* popc */, SP::POPCrr, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK_IntRegs }, },
  { 3643 /* prefetch */, SP::PREFETCHi, Convert__MEMri2_1__PrefetchTag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK_PrefetchTag }, },
  { 3643 /* prefetch */, SP::PREFETCHr, Convert__MEMrr2_1__PrefetchTag1_3, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_PrefetchTag }, },
  { 3652 /* prefetcha */, SP::PREFETCHAi, Convert__MEMri2_1__PrefetchTag1_4, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_PrefetchTag }, },
  { 3652 /* prefetcha */, SP::PREFETCHAr, Convert__MEMrr2_1__ASITag1_3__PrefetchTag1_4, AMFBS_HasV9, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_PrefetchTag }, },
  { 3662 /* pwr */, SP::PWRPSRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_PSR }, },
  { 3662 /* pwr */, SP::PWRPSRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_PSR }, },
  { 3662 /* pwr */, SP::PWRPSRrr, Convert__Reg1_0__Reg1_1, AMFBS_HasPWRPSR, { MCK_IntRegs, MCK_IntRegs, MCK_PSR }, },
  { 3662 /* pwr */, SP::PWRPSRri, Convert__Reg1_0__Imm1_1, AMFBS_HasPWRPSR, { MCK_IntRegs, MCK_Imm, MCK_PSR }, },
  { 3666 /* rd */, SP::RDPSR, Convert__Reg1_1, AMFBS_None, { MCK_PSR, MCK_IntRegs }, },
  { 3666 /* rd */, SP::RDTBR, Convert__Reg1_1, AMFBS_None, { MCK_TBR, MCK_IntRegs }, },
  { 3666 /* rd */, SP::RDWIM, Convert__Reg1_1, AMFBS_None, { MCK_WIM, MCK_IntRegs }, },
  { 3666 /* rd */, SP::RDASR, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_ASRRegs, MCK_IntRegs }, },
  { 3669 /* rdpr */, SP::RDFQ, Convert__Reg1_1, AMFBS_HasV9, { MCK_FQ, MCK_IntRegs }, },
  { 3669 /* rdpr */, SP::RDPR, Convert__Reg1_1__Reg1_0, AMFBS_HasV9, { MCK_PRRegs, MCK_IntRegs }, },
  { 3674 /* restore */, SP::RESTORErr, Convert__regG0__regG0__regG0, AMFBS_None, {  }, },
  { 3674 /* restore */, SP::RESTORErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3674 /* restore */, SP::RESTOREri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3682 /* restored */, SP::RESTORED, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 3691 /* ret */, SP::RET, Convert__imm_95_8, AMFBS_None, {  }, },
  { 3695 /* retl */, SP::RETL, Convert__imm_95_8, AMFBS_None, {  }, },
  { 3700 /* retry */, SP::RETRY, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 3706 /* rett */, SP::RETTri, Convert__MEMri2_0, AMFBS_None, { MCK_MEMri }, },
  { 3706 /* rett */, SP::RETTrr, Convert__MEMrr2_0, AMFBS_None, { MCK_MEMrr }, },
  { 3711 /* save */, SP::SAVErr, Convert__regG0__regG0__regG0, AMFBS_None, {  }, },
  { 3711 /* save */, SP::SAVErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3711 /* save */, SP::SAVEri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3716 /* saved */, SP::SAVED, Convert_NoOperands, AMFBS_HasV9, {  }, },
  { 3722 /* sdiv */, SP::SDIVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3722 /* sdiv */, SP::SDIVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3727 /* sdivcc */, SP::SDIVCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3727 /* sdivcc */, SP::SDIVCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3734 /* sdivx */, SP::SDIVXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3734 /* sdivx */, SP::SDIVXri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3740 /* set */, SP::SET, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 3744 /* sethi */, SP::SETHIi, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs }, },
  { 3750 /* setsw */, SP::SETSW, Convert__Reg1_1__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_IntRegs }, },
  { 3756 /* setx */, SP::SETX, Convert__Reg1_2__Imm1_0__Reg1_1, AMFBS_Is64Bit_HasV9, { MCK_Imm, MCK_IntRegs, MCK_IntRegs }, },
  { 3761 /* sha1 */, SP::SHA1, Convert_NoOperands, AMFBS_HasCrypto, {  }, },
  { 3766 /* sha256 */, SP::SHA256, Convert_NoOperands, AMFBS_HasCrypto, {  }, },
  { 3773 /* sha512 */, SP::SHA512, Convert_NoOperands, AMFBS_HasCrypto, {  }, },
  { 3780 /* shutdown */, SP::SHUTDOWN, Convert_NoOperands, AMFBS_HasVIS, {  }, },
  { 3789 /* siam */, SP::SIAM, Convert__Imm1_0, AMFBS_HasVIS2, { MCK_Imm }, },
  { 3794 /* signx */, SP::SRArr, Convert__Reg1_0__Reg1_0__regG0, AMFBS_HasV9, { MCK_IntRegs }, },
  { 3794 /* signx */, SP::SRArr, Convert__Reg1_1__Reg1_0__regG0, AMFBS_HasV9, { MCK_IntRegs, MCK_IntRegs }, },
  { 3800 /* sir */, SP::SIR, Convert__imm_95_0, AMFBS_None, {  }, },
  { 3800 /* sir */, SP::SIR, Convert__Imm1_0, AMFBS_HasV9, { MCK_Imm }, },
  { 3804 /* sll */, SP::SLLrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3804 /* sll */, SP::SLLri, Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm5, MCK_IntRegs }, },
  { 3808 /* sllx */, SP::SLLXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3808 /* sllx */, SP::SLLXri, Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_ShiftAmtImm6, MCK_IntRegs }, },
  { 3813 /* smac */, SP::SMACrr, Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3813 /* smac */, SP::SMACri, Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3818 /* smul */, SP::SMULrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3818 /* smul */, SP::SMULri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3823 /* smulcc */, SP::SMULCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3823 /* smulcc */, SP::SMULCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3830 /* sra */, SP::SRArr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3830 /* sra */, SP::SRAri, Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm5, MCK_IntRegs }, },
  { 3834 /* srax */, SP::SRAXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3834 /* srax */, SP::SRAXri, Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_ShiftAmtImm6, MCK_IntRegs }, },
  { 3839 /* srl */, SP::SRLrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3839 /* srl */, SP::SRLri, Convert__Reg1_2__Reg1_0__ShiftAmtImm51_1, AMFBS_None, { MCK_IntRegs, MCK_ShiftAmtImm5, MCK_IntRegs }, },
  { 3843 /* srlx */, SP::SRLXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3843 /* srlx */, SP::SRLXri, Convert__Reg1_2__Reg1_0__ShiftAmtImm61_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_ShiftAmtImm6, MCK_IntRegs }, },
  { 3848 /* st */, SP::STCSRri, Convert__MEMri2_2, AMFBS_None, { MCK_CPSR, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3848 /* st */, SP::STCSRrr, Convert__MEMrr2_2, AMFBS_None, { MCK_CPSR, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3848 /* st */, SP::STFSRri, Convert__MEMri2_2, AMFBS_None, { MCK_FSR, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3848 /* st */, SP::STFSRrr, Convert__MEMrr2_2, AMFBS_None, { MCK_FSR, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3848 /* st */, SP::STCri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_CoprocRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3848 /* st */, SP::STCrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_CoprocRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3848 /* st */, SP::STFri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3848 /* st */, SP::STFrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_FPRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3848 /* st */, SP::STri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3848 /* st */, SP::STrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3851 /* sta */, SP::STFAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_FPRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3851 /* sta */, SP::STFArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_HasV9, { MCK_FPRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3851 /* sta */, SP::STAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3851 /* sta */, SP::STArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3855 /* stb */, SP::STBri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3855 /* stb */, SP::STBrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3859 /* stba */, SP::STBAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3859 /* stba */, SP::STBArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3864 /* stbar */, SP::STBAR, Convert_NoOperands, AMFBS_None, {  }, },
  { 3870 /* std */, SP::STDCQri, Convert__MEMri2_2, AMFBS_None, { MCK_CPQ, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3870 /* std */, SP::STDCQrr, Convert__MEMrr2_2, AMFBS_None, { MCK_CPQ, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3870 /* std */, SP::STDFQri, Convert__MEMri2_2, AMFBS_None, { MCK_FQ, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3870 /* std */, SP::STDFQrr, Convert__MEMrr2_2, AMFBS_None, { MCK_FQ, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3870 /* std */, SP::STDCri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_CoprocPair, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3870 /* std */, SP::STDCrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_CoprocPair, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3870 /* std */, SP::STDri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntPair, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3870 /* std */, SP::STDrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntPair, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3870 /* std */, SP::STDFri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3870 /* std */, SP::STDFrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_DFPRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3874 /* stda */, SP::STDAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntPair, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3874 /* stda */, SP::STDArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntPair, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3874 /* stda */, SP::STDFAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_DFPRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3874 /* stda */, SP::STDFArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_HasV9, { MCK_DFPRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3879 /* sth */, SP::STHri, Convert__MEMri2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3879 /* sth */, SP::STHrr, Convert__MEMrr2_2__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3883 /* stha */, SP::STHAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3883 /* stha */, SP::STHArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_None, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3888 /* stq */, SP::STQFri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3888 /* stq */, SP::STQFrr, Convert__MEMrr2_2__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3892 /* stqa */, SP::STQFAri, Convert__MEMri2_2__Reg1_0, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3892 /* stqa */, SP::STQFArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_HasV9, { MCK_QFPRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3897 /* stx */, SP::STXFSRri, Convert__MEMri2_2, AMFBS_HasV9, { MCK_FSR, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3897 /* stx */, SP::STXFSRrr, Convert__MEMrr2_2, AMFBS_HasV9, { MCK_FSR, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3897 /* stx */, SP::STXri, Convert__MEMri2_2__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_ }, },
  { 3897 /* stx */, SP::STXrr, Convert__MEMrr2_2__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_ }, },
  { 3901 /* stxa */, SP::STXAri, Convert__MEMri2_2__Reg1_0, AMFBS_Is64Bit, { MCK_IntRegs, MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi }, },
  { 3901 /* stxa */, SP::STXArr, Convert__MEMrr2_2__Reg1_0__ASITag1_4, AMFBS_Is64Bit, { MCK_IntRegs, MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag }, },
  { 3906 /* sub */, SP::SUBrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3906 /* sub */, SP::SUBri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3910 /* subcc */, SP::SUBCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3910 /* subcc */, SP::SUBCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3916 /* subx */, SP::SUBCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3916 /* subx */, SP::SUBCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3921 /* subxcc */, SP::SUBErr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3921 /* subxcc */, SP::SUBEri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3928 /* swap */, SP::SWAPri, Convert__Reg1_3__MEMri2_1__Tie0_1_1, AMFBS_None, { MCK__91_, MCK_MEMri, MCK__93_, MCK_IntRegs }, },
  { 3928 /* swap */, SP::SWAPrr, Convert__Reg1_3__MEMrr2_1__Tie0_1_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_IntRegs }, },
  { 3933 /* swapa */, SP::SWAPAri, Convert__Reg1_4__MEMri2_1__Tie0_1_1, AMFBS_HasV9, { MCK__91_, MCK_MEMri, MCK__93_, MCK__PCT_asi, MCK_IntRegs }, },
  { 3933 /* swapa */, SP::SWAPArr, Convert__Reg1_4__MEMrr2_1__ASITag1_3__Tie0_1_1, AMFBS_None, { MCK__91_, MCK_MEMrr, MCK__93_, MCK_ASITag, MCK_IntRegs }, },
  { 3939 /* t */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_8, AMFBS_None, { MCK_IntRegs }, },
  { 3939 /* t */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 3939 /* t */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3939 /* t */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3939 /* t */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3939 /* t */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3939 /* t */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3939 /* t */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3939 /* t */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3939 /* t */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3939 /* t */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3939 /* t */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3939 /* t */, SP::TRAPrr, Convert__Reg1_1__Reg1_3__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3939 /* t */, SP::TRAPri, Convert__Reg1_1__Imm1_3__Imm1_0, AMFBS_None, { MCK_Imm, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3939 /* t */, SP::TXCCrr, Convert__Reg1_2__Reg1_4__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3939 /* t */, SP::TXCCri, Convert__Reg1_2__Imm1_4__Imm1_0, AMFBS_Is64Bit, { MCK_Imm, MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3939 /* t */, SP::TICCrr, Convert__Reg1_2__Reg1_4__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3939 /* t */, SP::TICCri, Convert__Reg1_2__Imm1_4__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3941 /* ta */, SP::TA1, Convert_NoOperands, AMFBS_None, { MCK_1 }, },
  { 3941 /* ta */, SP::TA3, Convert_NoOperands, AMFBS_None, { MCK_3 }, },
  { 3941 /* ta */, SP::TA5, Convert_NoOperands, AMFBS_None, { MCK_5 }, },
  { 3941 /* ta */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_8, AMFBS_None, { MCK_IntRegs }, },
  { 3941 /* ta */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_8, AMFBS_None, { MCK_Imm }, },
  { 3941 /* ta */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3941 /* ta */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3941 /* ta */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3941 /* ta */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3941 /* ta */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3941 /* ta */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_8, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3941 /* ta */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3941 /* ta */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3941 /* ta */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3941 /* ta */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_8, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3944 /* taddcc */, SP::TADDCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3944 /* taddcc */, SP::TADDCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3951 /* taddcctv */, SP::TADDCCTVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 3951 /* taddcctv */, SP::TADDCCTVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 3960 /* tcc */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_13, AMFBS_None, { MCK_IntRegs }, },
  { 3960 /* tcc */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 3960 /* tcc */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3960 /* tcc */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3960 /* tcc */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3960 /* tcc */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3960 /* tcc */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3960 /* tcc */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3960 /* tcc */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3960 /* tcc */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3960 /* tcc */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3960 /* tcc */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3964 /* tcs */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_5, AMFBS_None, { MCK_IntRegs }, },
  { 3964 /* tcs */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 3964 /* tcs */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3964 /* tcs */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3964 /* tcs */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3964 /* tcs */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3964 /* tcs */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3964 /* tcs */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3964 /* tcs */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3964 /* tcs */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3964 /* tcs */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3964 /* tcs */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3968 /* te */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 3968 /* te */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 3968 /* te */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3968 /* te */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3968 /* te */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3968 /* te */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3968 /* te */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3968 /* te */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3968 /* te */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3968 /* te */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3968 /* te */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3968 /* te */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3971 /* teq */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 3971 /* teq */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 3971 /* teq */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3971 /* teq */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3971 /* teq */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3971 /* teq */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3971 /* teq */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3971 /* teq */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3971 /* teq */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3971 /* teq */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3971 /* teq */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3971 /* teq */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3975 /* tg */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_10, AMFBS_None, { MCK_IntRegs }, },
  { 3975 /* tg */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 3975 /* tg */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3975 /* tg */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3975 /* tg */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3975 /* tg */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3975 /* tg */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3975 /* tg */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3975 /* tg */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3975 /* tg */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3975 /* tg */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3975 /* tg */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3978 /* tge */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_11, AMFBS_None, { MCK_IntRegs }, },
  { 3978 /* tge */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_11, AMFBS_None, { MCK_Imm }, },
  { 3978 /* tge */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3978 /* tge */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3978 /* tge */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3978 /* tge */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3978 /* tge */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_11, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3978 /* tge */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_11, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3978 /* tge */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3978 /* tge */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3978 /* tge */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3978 /* tge */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_11, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3982 /* tgeu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_13, AMFBS_None, { MCK_IntRegs }, },
  { 3982 /* tgeu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_13, AMFBS_None, { MCK_Imm }, },
  { 3982 /* tgeu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3982 /* tgeu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3982 /* tgeu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3982 /* tgeu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3982 /* tgeu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3982 /* tgeu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_13, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3982 /* tgeu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3982 /* tgeu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3982 /* tgeu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3982 /* tgeu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_13, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3987 /* tgt */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_10, AMFBS_None, { MCK_IntRegs }, },
  { 3987 /* tgt */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_10, AMFBS_None, { MCK_Imm }, },
  { 3987 /* tgt */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3987 /* tgt */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3987 /* tgt */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3987 /* tgt */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3987 /* tgt */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3987 /* tgt */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_10, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3987 /* tgt */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3987 /* tgt */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3987 /* tgt */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3987 /* tgt */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_10, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3991 /* tgu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_12, AMFBS_None, { MCK_IntRegs }, },
  { 3991 /* tgu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_12, AMFBS_None, { MCK_Imm }, },
  { 3991 /* tgu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3991 /* tgu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3991 /* tgu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3991 /* tgu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3991 /* tgu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_12, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3991 /* tgu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_12, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3991 /* tgu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3991 /* tgu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3991 /* tgu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3991 /* tgu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_12, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3995 /* tl */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_3, AMFBS_None, { MCK_IntRegs }, },
  { 3995 /* tl */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 3995 /* tl */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3995 /* tl */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3995 /* tl */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3995 /* tl */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3995 /* tl */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3995 /* tl */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3995 /* tl */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3995 /* tl */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3995 /* tl */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3995 /* tl */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3998 /* tle */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_2, AMFBS_None, { MCK_IntRegs }, },
  { 3998 /* tle */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_2, AMFBS_None, { MCK_Imm }, },
  { 3998 /* tle */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 3998 /* tle */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 3998 /* tle */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 3998 /* tle */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 3998 /* tle */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3998 /* tle */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_2, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3998 /* tle */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3998 /* tle */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 3998 /* tle */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 3998 /* tle */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_2, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4002 /* tleu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_4, AMFBS_None, { MCK_IntRegs }, },
  { 4002 /* tleu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_4, AMFBS_None, { MCK_Imm }, },
  { 4002 /* tleu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4002 /* tleu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4002 /* tleu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4002 /* tleu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4002 /* tleu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_4, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4002 /* tleu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_4, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4002 /* tleu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4002 /* tleu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4002 /* tleu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4002 /* tleu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_4, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4007 /* tlt */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_3, AMFBS_None, { MCK_IntRegs }, },
  { 4007 /* tlt */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_3, AMFBS_None, { MCK_Imm }, },
  { 4007 /* tlt */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4007 /* tlt */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4007 /* tlt */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4007 /* tlt */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4007 /* tlt */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4007 /* tlt */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_3, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4007 /* tlt */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4007 /* tlt */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4007 /* tlt */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4007 /* tlt */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_3, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4011 /* tlu */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_5, AMFBS_None, { MCK_IntRegs }, },
  { 4011 /* tlu */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_5, AMFBS_None, { MCK_Imm }, },
  { 4011 /* tlu */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4011 /* tlu */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4011 /* tlu */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4011 /* tlu */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4011 /* tlu */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4011 /* tlu */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_5, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4011 /* tlu */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4011 /* tlu */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4011 /* tlu */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4011 /* tlu */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_5, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4015 /* tn */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_0, AMFBS_None, { MCK_IntRegs }, },
  { 4015 /* tn */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_0, AMFBS_None, { MCK_Imm }, },
  { 4015 /* tn */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4015 /* tn */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4015 /* tn */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4015 /* tn */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4015 /* tn */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4015 /* tn */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4015 /* tn */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4015 /* tn */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4015 /* tn */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4015 /* tn */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_0, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4018 /* tne */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_9, AMFBS_None, { MCK_IntRegs }, },
  { 4018 /* tne */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 4018 /* tne */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4018 /* tne */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4018 /* tne */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4018 /* tne */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4018 /* tne */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4018 /* tne */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4018 /* tne */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4018 /* tne */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4018 /* tne */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4018 /* tne */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4022 /* tneg */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_6, AMFBS_None, { MCK_IntRegs }, },
  { 4022 /* tneg */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_6, AMFBS_None, { MCK_Imm }, },
  { 4022 /* tneg */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4022 /* tneg */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4022 /* tneg */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4022 /* tneg */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4022 /* tneg */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4022 /* tneg */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_6, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4022 /* tneg */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4022 /* tneg */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4022 /* tneg */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4022 /* tneg */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_6, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4027 /* tnz */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_9, AMFBS_None, { MCK_IntRegs }, },
  { 4027 /* tnz */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_9, AMFBS_None, { MCK_Imm }, },
  { 4027 /* tnz */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4027 /* tnz */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4027 /* tnz */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4027 /* tnz */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4027 /* tnz */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4027 /* tnz */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_9, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4027 /* tnz */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4027 /* tnz */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4027 /* tnz */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4027 /* tnz */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_9, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4031 /* tpos */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_14, AMFBS_None, { MCK_IntRegs }, },
  { 4031 /* tpos */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_14, AMFBS_None, { MCK_Imm }, },
  { 4031 /* tpos */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4031 /* tpos */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4031 /* tpos */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4031 /* tpos */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4031 /* tpos */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_14, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4031 /* tpos */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_14, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4031 /* tpos */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4031 /* tpos */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4031 /* tpos */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4031 /* tpos */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_14, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4036 /* tst */, SP::ORCCrr, Convert__regG0__Reg1_0__regG0, AMFBS_None, { MCK_IntRegs }, },
  { 4040 /* tsubcc */, SP::TSUBCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4040 /* tsubcc */, SP::TSUBCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4047 /* tsubcctv */, SP::TSUBCCTVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4047 /* tsubcctv */, SP::TSUBCCTVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4056 /* tvc */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_15, AMFBS_None, { MCK_IntRegs }, },
  { 4056 /* tvc */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_15, AMFBS_None, { MCK_Imm }, },
  { 4056 /* tvc */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4056 /* tvc */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4056 /* tvc */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4056 /* tvc */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4056 /* tvc */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_15, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4056 /* tvc */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_15, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4056 /* tvc */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4056 /* tvc */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4056 /* tvc */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4056 /* tvc */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_15, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4060 /* tvs */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_7, AMFBS_None, { MCK_IntRegs }, },
  { 4060 /* tvs */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_7, AMFBS_None, { MCK_Imm }, },
  { 4060 /* tvs */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4060 /* tvs */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4060 /* tvs */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4060 /* tvs */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4060 /* tvs */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4060 /* tvs */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_7, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4060 /* tvs */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4060 /* tvs */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4060 /* tvs */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4060 /* tvs */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_7, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4064 /* tz */, SP::TRAPrr, Convert__regG0__Reg1_0__imm_95_1, AMFBS_None, { MCK_IntRegs }, },
  { 4064 /* tz */, SP::TRAPri, Convert__regG0__Imm1_0__imm_95_1, AMFBS_None, { MCK_Imm }, },
  { 4064 /* tz */, SP::TXCCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs }, },
  { 4064 /* tz */, SP::TXCCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_Imm }, },
  { 4064 /* tz */, SP::TICCrr, Convert__regG0__Reg1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs }, },
  { 4064 /* tz */, SP::TICCri, Convert__regG0__Imm1_1__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_Imm }, },
  { 4064 /* tz */, SP::TRAPrr, Convert__Reg1_0__Reg1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4064 /* tz */, SP::TRAPri, Convert__Reg1_0__Imm1_2__imm_95_1, AMFBS_None, { MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4064 /* tz */, SP::TXCCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4064 /* tz */, SP::TXCCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK__PCT_xcc, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4064 /* tz */, SP::TICCrr, Convert__Reg1_1__Reg1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_IntRegs }, },
  { 4064 /* tz */, SP::TICCri, Convert__Reg1_1__Imm1_3__imm_95_1, AMFBS_HasV9, { MCK_ICC, MCK_IntRegs, MCK__43_, MCK_Imm }, },
  { 4067 /* udiv */, SP::UDIVrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4067 /* udiv */, SP::UDIVri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4072 /* udivcc */, SP::UDIVCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4072 /* udivcc */, SP::UDIVCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4079 /* udivx */, SP::UDIVXrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4079 /* udivx */, SP::UDIVXri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_Is64Bit, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4085 /* umac */, SP::UMACrr, Convert__Reg1_2__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4085 /* umac */, SP::UMACri, Convert__Reg1_2__Reg1_0__Imm1_1__imm_95_0, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4090 /* umul */, SP::UMULrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4090 /* umul */, SP::UMULri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4095 /* umulcc */, SP::UMULCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4095 /* umulcc */, SP::UMULCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4102 /* umulxhi */, SP::UMULXHI, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4110 /* unimp */, SP::UNIMP, Convert__imm_95_0, AMFBS_None, {  }, },
  { 4110 /* unimp */, SP::UNIMP, Convert__Imm1_0, AMFBS_None, { MCK_Imm }, },
  { 4116 /* wr */, SP::WRPSRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_PSR }, },
  { 4116 /* wr */, SP::WRTBRrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_TBR }, },
  { 4116 /* wr */, SP::WRWIMrr, Convert__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_WIM }, },
  { 4116 /* wr */, SP::WRASRrr, Convert__Reg1_1__regG0__Reg1_0, AMFBS_None, { MCK_IntRegs, MCK_ASRRegs }, },
  { 4116 /* wr */, SP::WRPSRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_PSR }, },
  { 4116 /* wr */, SP::WRTBRri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_TBR }, },
  { 4116 /* wr */, SP::WRWIMri, Convert__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_WIM }, },
  { 4116 /* wr */, SP::WRASRri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_None, { MCK_Imm, MCK_ASRRegs }, },
  { 4116 /* wr */, SP::WRPSRrr, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_PSR }, },
  { 4116 /* wr */, SP::WRTBRrr, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_TBR }, },
  { 4116 /* wr */, SP::WRWIMrr, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_WIM }, },
  { 4116 /* wr */, SP::WRASRrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_ASRRegs }, },
  { 4116 /* wr */, SP::WRPSRri, Convert__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_PSR }, },
  { 4116 /* wr */, SP::WRTBRri, Convert__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_TBR }, },
  { 4116 /* wr */, SP::WRWIMri, Convert__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_WIM }, },
  { 4116 /* wr */, SP::WRASRri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_ASRRegs }, },
  { 4119 /* wrpr */, SP::WRPRrr, Convert__Reg1_1__Reg1_0__regG0, AMFBS_HasV9, { MCK_IntRegs, MCK_PRRegs }, },
  { 4119 /* wrpr */, SP::WRPRri, Convert__Reg1_1__regG0__Imm1_0, AMFBS_HasV9, { MCK_Imm, MCK_PRRegs }, },
  { 4119 /* wrpr */, SP::WRPRrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasV9, { MCK_IntRegs, MCK_IntRegs, MCK_PRRegs }, },
  { 4119 /* wrpr */, SP::WRPRri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_HasV9, { MCK_IntRegs, MCK_Imm, MCK_PRRegs }, },
  { 4124 /* xmulx */, SP::XMULX, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4130 /* xmulxhi */, SP::XMULXHI, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_HasVIS3, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4138 /* xnor */, SP::XNORrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4138 /* xnor */, SP::XNORri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4143 /* xnorcc */, SP::XNORCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4143 /* xnorcc */, SP::XNORCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4150 /* xor */, SP::XORrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4150 /* xor */, SP::XORri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
  { 4154 /* xorcc */, SP::XORCCrr, Convert__Reg1_2__Reg1_0__Reg1_1, AMFBS_None, { MCK_IntRegs, MCK_IntRegs, MCK_IntRegs }, },
  { 4154 /* xorcc */, SP::XORCCri, Convert__Reg1_2__Reg1_0__Imm1_1, AMFBS_None, { MCK_IntRegs, MCK_Imm, MCK_IntRegs }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned SparcAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 7) {
    ErrorInfo = 7;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((SparcOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 6; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs(), *getContext().getAsmInfo()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                          ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                         ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[178] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 0 /* add */, 8 /* 3 */, MCK_TailRelocSymAdd_TLS, AMFBS_None },
  { 432 /* call */, 1 /* 0 */, MCK_CallTarget, AMFBS_None },
  { 432 /* call */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 432 /* call */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 432 /* call */, 1 /* 0 */, MCK_CallTarget, AMFBS_None },
  { 432 /* call */, 1 /* 0 */, MCK_CallTarget, AMFBS_None },
  { 432 /* call */, 2 /* 1 */, MCK_TailRelocSymCall_TLS, AMFBS_None },
  { 432 /* call */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 432 /* call */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 477 /* casa */, 8 /* 3 */, MCK_ASITag, AMFBS_HasCASA },
  { 492 /* casxa */, 8 /* 3 */, MCK_ASITag, AMFBS_Is64Bit_HasV9 },
  { 585 /* clr */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 585 /* clr */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 589 /* clrb */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 589 /* clrb */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 594 /* clrh */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 594 /* clrh */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 1399 /* flush */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 1399 /* flush */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 3119 /* jmp */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 3119 /* jmp */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 3123 /* jmpl */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 3123 /* jmpl */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 16 /* 4 */, MCK_TailRelocSymLoad_GOT, AMFBS_None },
  { 3128 /* ld */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3128 /* ld */, 16 /* 4 */, MCK_TailRelocSymLoad_TLS, AMFBS_None },
  { 3131 /* lda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3131 /* lda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3131 /* lda */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 3131 /* lda */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3131 /* lda */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3131 /* lda */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3135 /* ldd */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3135 /* ldd */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3135 /* ldd */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3135 /* ldd */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3135 /* ldd */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3135 /* ldd */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3139 /* ldda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3139 /* ldda */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3139 /* ldda */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3139 /* ldda */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3139 /* ldda */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 3139 /* ldda */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3144 /* ldq */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3144 /* ldq */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3148 /* ldqa */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3148 /* ldqa */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 3148 /* ldqa */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3153 /* ldsb */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3153 /* ldsb */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3158 /* ldsba */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3158 /* ldsba */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3158 /* ldsba */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3164 /* ldsh */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3164 /* ldsh */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3169 /* ldsha */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3169 /* ldsha */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3169 /* ldsha */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3175 /* ldstub */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3175 /* ldstub */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3182 /* ldstuba */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3182 /* ldstuba */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3182 /* ldstuba */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3190 /* ldsw */, 2 /* 1 */, MCK_MEMri, AMFBS_Is64Bit },
  { 3190 /* ldsw */, 2 /* 1 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3195 /* ldswa */, 2 /* 1 */, MCK_MEMri, AMFBS_Is64Bit },
  { 3195 /* ldswa */, 8 /* 3 */, MCK_ASITag, AMFBS_Is64Bit },
  { 3195 /* ldswa */, 2 /* 1 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3201 /* ldub */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3201 /* ldub */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3206 /* lduba */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3206 /* lduba */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3206 /* lduba */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3212 /* lduh */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3212 /* lduh */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3217 /* lduha */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3217 /* lduha */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3217 /* lduha */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3223 /* ldx */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3223 /* ldx */, 2 /* 1 */, MCK_MEMri, AMFBS_Is64Bit },
  { 3223 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3223 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3223 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3223 /* ldx */, 16 /* 4 */, MCK_TailRelocSymLoad_GOT, AMFBS_Is64Bit },
  { 3223 /* ldx */, 2 /* 1 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3223 /* ldx */, 16 /* 4 */, MCK_TailRelocSymLoad_TLS, AMFBS_Is64Bit },
  { 3227 /* ldxa */, 2 /* 1 */, MCK_MEMri, AMFBS_Is64Bit },
  { 3227 /* ldxa */, 8 /* 3 */, MCK_ASITag, AMFBS_Is64Bit },
  { 3227 /* ldxa */, 2 /* 1 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3242 /* membar */, 1 /* 0 */, MCK_MembarTag, AMFBS_HasV9 },
  { 3643 /* prefetch */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3643 /* prefetch */, 8 /* 3 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3643 /* prefetch */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3643 /* prefetch */, 8 /* 3 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3652 /* prefetcha */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3652 /* prefetcha */, 16 /* 4 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3652 /* prefetcha */, 8 /* 3 */, MCK_ASITag, AMFBS_HasV9 },
  { 3652 /* prefetcha */, 2 /* 1 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3652 /* prefetcha */, 16 /* 4 */, MCK_PrefetchTag, AMFBS_HasV9 },
  { 3706 /* rett */, 1 /* 0 */, MCK_MEMri, AMFBS_None },
  { 3706 /* rett */, 1 /* 0 */, MCK_MEMrr, AMFBS_None },
  { 3804 /* sll */, 2 /* 1 */, MCK_ShiftAmtImm5, AMFBS_None },
  { 3808 /* sllx */, 2 /* 1 */, MCK_ShiftAmtImm6, AMFBS_Is64Bit },
  { 3830 /* sra */, 2 /* 1 */, MCK_ShiftAmtImm5, AMFBS_None },
  { 3834 /* srax */, 2 /* 1 */, MCK_ShiftAmtImm6, AMFBS_Is64Bit },
  { 3839 /* srl */, 2 /* 1 */, MCK_ShiftAmtImm5, AMFBS_None },
  { 3843 /* srlx */, 2 /* 1 */, MCK_ShiftAmtImm6, AMFBS_Is64Bit },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3848 /* st */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3851 /* sta */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3851 /* sta */, 16 /* 4 */, MCK_ASITag, AMFBS_HasV9 },
  { 3851 /* sta */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3851 /* sta */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3851 /* sta */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3851 /* sta */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3855 /* stb */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3855 /* stb */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3859 /* stba */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3859 /* stba */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3859 /* stba */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3870 /* std */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3874 /* stda */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3874 /* stda */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3874 /* stda */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3874 /* stda */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3874 /* stda */, 16 /* 4 */, MCK_ASITag, AMFBS_HasV9 },
  { 3874 /* stda */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3879 /* sth */, 4 /* 2 */, MCK_MEMri, AMFBS_None },
  { 3879 /* sth */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3883 /* stha */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3883 /* stha */, 16 /* 4 */, MCK_ASITag, AMFBS_None },
  { 3883 /* stha */, 4 /* 2 */, MCK_MEMrr, AMFBS_None },
  { 3888 /* stq */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3888 /* stq */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3892 /* stqa */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3892 /* stqa */, 16 /* 4 */, MCK_ASITag, AMFBS_HasV9 },
  { 3892 /* stqa */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3897 /* stx */, 4 /* 2 */, MCK_MEMri, AMFBS_HasV9 },
  { 3897 /* stx */, 4 /* 2 */, MCK_MEMrr, AMFBS_HasV9 },
  { 3897 /* stx */, 4 /* 2 */, MCK_MEMri, AMFBS_Is64Bit },
  { 3897 /* stx */, 4 /* 2 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3901 /* stxa */, 4 /* 2 */, MCK_MEMri, AMFBS_Is64Bit },
  { 3901 /* stxa */, 16 /* 4 */, MCK_ASITag, AMFBS_Is64Bit },
  { 3901 /* stxa */, 4 /* 2 */, MCK_MEMrr, AMFBS_Is64Bit },
  { 3928 /* swap */, 2 /* 1 */, MCK_MEMri, AMFBS_None },
  { 3928 /* swap */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
  { 3933 /* swapa */, 2 /* 1 */, MCK_MEMri, AMFBS_HasV9 },
  { 3933 /* swapa */, 8 /* 3 */, MCK_ASITag, AMFBS_None },
  { 3933 /* swapa */, 2 /* 1 */, MCK_MEMrr, AMFBS_None },
};

ParseStatus SparcAsmParser::
tryCustomParseOperand(OperandVector &Operands,
                      unsigned MCK) {

  switch(MCK) {
  case MCK_ASITag:
    return parseASITag(Operands);
  case MCK_CallTarget:
    return parseCallTarget(Operands);
  case MCK_MEMri:
    return parseMEMOperand(Operands);
  case MCK_MEMrr:
    return parseMEMOperand(Operands);
  case MCK_MembarTag:
    return parseMembarTag(Operands);
  case MCK_PrefetchTag:
    return parsePrefetchTag(Operands);
  case MCK_ShiftAmtImm5:
    return parseShiftAmtImm<5>(Operands);
  case MCK_ShiftAmtImm6:
    return parseShiftAmtImm<6>(Operands);
  case MCK_TailRelocSymLoad_GOT:
    return parseTailRelocSym<TailRelocKind::Load_GOT>(Operands);
  case MCK_TailRelocSymAdd_TLS:
    return parseTailRelocSym<TailRelocKind::Add_TLS>(Operands);
  case MCK_TailRelocSymLoad_TLS:
    return parseTailRelocSym<TailRelocKind::Load_TLS>(Operands);
  case MCK_TailRelocSymCall_TLS:
    return parseTailRelocSym<TailRelocKind::Call_TLS>(Operands);
  default:
    return ParseStatus::NoMatch;
  }
  return ParseStatus::NoMatch;
}

ParseStatus SparcAsmParser::
MatchOperandParserImpl(OperandVector &Operands,
                       StringRef Mnemonic,
                       bool ParseForAllFeatures) {
  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the next operand index.
  unsigned NextOpNum = Operands.size() - 1;
  // Search the table.
  auto MnemonicRange =
    std::equal_range(std::begin(OperandMatchTable), std::end(OperandMatchTable),
                     Mnemonic, LessOpcodeOperand());

  if (MnemonicRange.first == MnemonicRange.second)
    return ParseStatus::NoMatch;

  for (const OperandMatchEntry *it = MnemonicRange.first,
       *ie = MnemonicRange.second; it != ie; ++it) {
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());

    // check if the available features match
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    if (!ParseForAllFeatures && (AvailableFeatures & RequiredFeatures) != RequiredFeatures)
      continue;

    // check if the operand in question has a custom parser.
    if (!(it->OperandMask & (1 << NextOpNum)))
      continue;

    // call custom parse method to handle the operand
    ParseStatus Result = tryCustomParseOperand(Operands, it->Class);
    if (!Result.isNoMatch())
      return Result;
  }

  // Okay, we had no match.
  return ParseStatus::NoMatch;
}

#endif // GET_MATCHER_IMPLEMENTATION


#ifdef GET_MNEMONIC_SPELL_CHECKER
#undef GET_MNEMONIC_SPELL_CHECKER

static std::string SparcMnemonicSpellCheck(StringRef S, const FeatureBitset &FBS, unsigned VariantID) {
  const unsigned MaxEditDist = 2;
  std::vector<StringRef> Candidates;
  StringRef Prev = "";

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  for (auto I = Start; I < End; I++) {
    // Ignore unsupported instructions.
    const FeatureBitset &RequiredFeatures = FeatureBitsets[I->RequiredFeaturesIdx];
    if ((FBS & RequiredFeatures) != RequiredFeatures)
      continue;

    StringRef T = I->getMnemonic();
    // Avoid recomputing the edit distance for the same string.
    if (T == Prev)
      continue;

    Prev = T;
    unsigned Dist = S.edit_distance(T, false, MaxEditDist);
    if (Dist <= MaxEditDist)
      Candidates.push_back(T);
  }

  if (Candidates.empty())
    return "";

  std::string Res = ", did you mean: ";
  unsigned i = 0;
  for (; i < Candidates.size() - 1; i++)
    Res += Candidates[i].str() + ", ";
  return Res + Candidates[i].str() + "?";
}

#endif // GET_MNEMONIC_SPELL_CHECKER


#ifdef GET_MNEMONIC_CHECKER
#undef GET_MNEMONIC_CHECKER

static bool SparcCheckMnemonic(StringRef Mnemonic,
                                const FeatureBitset &AvailableFeatures,
                                unsigned VariantID) {
  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  if (MnemonicRange.first == MnemonicRange.second)
    return false;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures =
      FeatureBitsets[it->RequiredFeaturesIdx];
    if ((AvailableFeatures & RequiredFeatures) == RequiredFeatures)
      return true;
  }
  return false;
}

#endif // GET_MNEMONIC_CHECKER

