/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Utilities;

final class AutoHidingMenuBar {
    private final JFrame frame;
    private final int UNHIDE_MENU_BY_MOUSE_DELAY_MS = 400;
    private final Timer delayedAppearanceTimer = new Timer(400, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AutoHidingMenuBar.this.setMenuBarVisible(true);
        }
    });
    private JMenuBar menuBar;
    private boolean autoHideEnabled;
    private InputMap menuOpenKeyboardShortcuts = new InputMap();

    public AutoHidingMenuBar(JFrame jFrame) {
        if (jFrame == null) {
            throw new NullPointerException();
        }
        this.frame = jFrame;
        this.delayedAppearanceTimer.setRepeats(false);
    }

    public void setAutoHideEnabled(boolean bl) {
        if (this.autoHideEnabled == bl) {
            return;
        }
        if (bl && Utilities.isMac()) {
            throw new UnsupportedOperationException("AutoHidingMenuBar not needed on MacOS");
        }
        this.delayedAppearanceTimer.stop();
        if (bl) {
            this.menuBar = this.frame.getJMenuBar();
            if (this.menuBar == null) {
                return;
            }
        }
        this.autoHideEnabled = bl;
        AWTEventListener aWTEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                KeyEvent keyEvent;
                KeyStroke keyStroke;
                if (aWTEvent instanceof MouseEvent) {
                    AutoHidingMenuBar.this.updateMenuBarVisibility((MouseEvent)aWTEvent);
                } else if (aWTEvent instanceof KeyEvent && !AutoHidingMenuBar.this.menuBar.isVisible() && (keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent = (KeyEvent)aWTEvent)) != null && AutoHidingMenuBar.this.menuOpenKeyboardShortcuts.get(keyStroke) != null) {
                    AutoHidingMenuBar.this.setMenuBarVisible(true);
                    AutoHidingMenuBar.this.frame.validate();
                    MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
                }
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AutoHidingMenuBar.this.updateMenuBarVisibility(null);
            }
        };
        if (bl) {
            Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 40L);
            MenuSelectionManager.defaultManager().addChangeListener(changeListener);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
            MenuSelectionManager.defaultManager().removeChangeListener(changeListener);
        }
        this.updateMenuBarVisibility(null);
    }

    /*
     * WARNING - void declaration
     */
    private void populateMenuOpenKeyboardShortcuts(JComponent jComponent) {
        Serializable[] serializableArray;
        InputMap inputMap = jComponent.getInputMap(2);
        if (inputMap != null && (serializableArray = inputMap.allKeys()) != null) {
            void serializable;
            KeyStroke[] keyStrokeArray = serializableArray;
            int n = keyStrokeArray.length;
            boolean i = false;
            while (serializable < n) {
                KeyStroke keyStroke = keyStrokeArray[serializable];
                this.menuOpenKeyboardShortcuts.put(keyStroke, "OpenMenu");
                ++serializable;
            }
        }
        if (!(jComponent instanceof JMenu)) {
            for (Serializable serializable : jComponent.getComponents()) {
                if (!(serializable instanceof JComponent)) continue;
                this.populateMenuOpenKeyboardShortcuts((JComponent)serializable);
            }
        }
    }

    private void setMenuBarVisible(boolean bl) {
        this.delayedAppearanceTimer.stop();
        if (this.menuBar == null) {
            return;
        }
        if (bl == this.menuBar.isVisible()) {
            return;
        }
        if (!bl) {
            if (this.isMenuItemSelected()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            this.menuOpenKeyboardShortcuts = new InputMap();
            this.populateMenuOpenKeyboardShortcuts(this.menuBar);
        }
        this.menuBar.setVisible(bl);
        this.menuBar.revalidate();
    }

    private void updateMenuBarVisibility(MouseEvent mouseEvent) {
        Component component;
        Point point;
        if (!this.autoHideEnabled) {
            this.setMenuBarVisible(true);
            return;
        }
        if (mouseEvent == null && this.isMenuItemSelected()) {
            this.setMenuBarVisible(true);
            return;
        }
        if (mouseEvent == null || !(mouseEvent.getSource() instanceof Component)) {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            Point point2 = pointerInfo.getLocation();
            if (point2 == null) {
                return;
            }
            SwingUtilities.convertPointFromScreen(point2, this.frame);
            point = point2;
            component = this.frame.findComponentAt(point.x, point.y);
        } else {
            component = (Component)mouseEvent.getSource();
            Point point3 = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point3, component);
            SwingUtilities.convertPointFromScreen(point3, this.frame);
            point = point3;
        }
        if (point.y == 0 && !this.menuBar.isVisible()) {
            this.delayedAppearanceTimer.start();
        } else if (!(!this.menuBar.isVisible() && !this.delayedAppearanceTimer.isRunning() || point.y <= this.menuBar.getHeight() || this.isComponentInMenu(component) || this.isComponentInMenu(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) || this.isMenuItemSelected())) {
            this.setMenuBarVisible(false);
        }
    }

    private boolean isMenuItemSelected() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        return menuElementArray != null && menuElementArray.length > 0 && menuElementArray[0] == this.menuBar;
    }

    private boolean isComponentInMenu(Component component) {
        if (component == null) {
            return false;
        }
        if (component == this.menuBar) {
            return true;
        }
        return this.isComponentInMenu(component.getParent());
    }
}

