/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class TextArea
extends JTextArea {
    private String hint;
    private Color hintFg;
    private boolean showsHint;
    private boolean changeListener;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.swing.Bundle");
    }

    public TextArea() {
    }

    public TextArea(String text) {
        super(text);
    }

    public TextArea(int rows, int columns) {
        super(rows, columns);
    }

    public TextArea(String text, int rows, int columns) {
        super(text, rows, columns);
    }

    public TextArea(Document doc) {
        super(doc);
    }

    public TextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
    }

    @Override
    public void setText(String t) {
        if (this.showsHint() && !Objects.equals(t, this.hint)) {
            this.hideHint();
        }
        if (!this.changeListener) {
            this.changeListener = true;
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updated();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updated();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updated();
                }

                private void updated() {
                    if (!TextArea.this.showsHint()) {
                        TextArea.this.changed();
                    }
                }
            });
        }
        super.setText(t);
    }

    protected void changed() {
    }

    public void setHint(String hint) {
        this.hideHint();
        this.hint = hint;
        if (!this.isFocusOwner()) {
            this.showHint();
        }
    }

    public String getHint() {
        return this.hint;
    }

    public boolean showsHint() {
        return this.showsHint;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (this.isFocusOwner()) {
            this.hideHint();
        } else {
            this.showHint();
        }
        super.processFocusEvent(e);
    }

    private void showHint() {
        if (this.hint != null && this.getText().isEmpty()) {
            this.showsHint = true;
            this.setText(this.hint);
            this.hintFg = this.getForeground();
            this.setForeground(this.getDisabledTextColor());
        }
    }

    private void hideHint() {
        if (this.showsHint) {
            this.showsHint = false;
            this.setForeground(this.hintFg);
            if (Objects.equals(this.getText(), this.hint)) {
                this.setText("");
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isPopupTrigger() && this.isEnabled()) {
            this.showPopup(e);
        }
    }

    private void showPopup(MouseEvent e) {
        boolean editable = this.isEditable();
        boolean selectedText = this.getSelectedText() != null;
        JPopupMenu popup = new JPopupMenu();
        JMenuItem miCut = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Cut")){

            @Override
            protected void fireActionPerformed(ActionEvent ae) {
                super.fireActionPerformed(ae);
                TextArea.this.cut();
                this.requestFocusInWindow();
            }
        };
        miCut.setEnabled(editable && selectedText);
        popup.add(miCut);
        JMenuItem miCopy = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Copy")){

            @Override
            protected void fireActionPerformed(ActionEvent ae) {
                super.fireActionPerformed(ae);
                TextArea.this.copy();
                this.requestFocusInWindow();
            }
        };
        miCopy.setEnabled(selectedText);
        popup.add(miCopy);
        JMenuItem miPaste = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Paste")){

            @Override
            protected void fireActionPerformed(ActionEvent ae) {
                super.fireActionPerformed(ae);
                TextArea.this.hideHint();
                try {
                    TextArea.this.replaceSelection(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor).toString());
                    this.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TextArea.this.showHint();
            }
        };
        try {
            Transferable clipboardContent = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            miPaste.setEnabled(editable && clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor));
            this.requestFocusInWindow();
        }
        catch (Exception ex) {
            miPaste.setEnabled(false);
        }
        popup.add(miPaste);
        if (editable) {
            JMenuItem miDelete = new JMenuItem(TextArea.BUNDLE().getString("TextArea_Delete")){

                @Override
                protected void fireActionPerformed(ActionEvent ae) {
                    super.fireActionPerformed(ae);
                    try {
                        int selStart = TextArea.this.getSelectionStart();
                        TextArea.this.getDocument().remove(selStart, TextArea.this.getSelectionEnd() - selStart);
                        this.requestFocusInWindow();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            miDelete.setEnabled(selectedText);
            popup.add(miDelete);
        }
        popup.addSeparator();
        JMenuItem miSelect = new JMenuItem(TextArea.BUNDLE().getString("TextArea_SelectAll")){

            @Override
            protected void fireActionPerformed(ActionEvent ae) {
                super.fireActionPerformed(ae);
                TextArea.this.selectAll();
                this.requestFocusInWindow();
            }
        };
        miSelect.setEnabled(!this.showsHint() && !this.getText().isEmpty());
        popup.add(miSelect);
        this.customizePopup(popup);
        popup.show(this, e.getX(), e.getY());
    }

    protected void customizePopup(JPopupMenu popup) {
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.isControlDown() && e.getID() == 402) {
            int keyCode = e.getKeyCode();
            if (keyCode == 61 || keyCode == 521) {
                if (this.changeSize(e.isShiftDown(), true)) {
                    e.consume();
                }
            } else if (keyCode == 45) {
                if (this.changeSize(e.isShiftDown(), false)) {
                    e.consume();
                }
            } else if (keyCode == 48 && this.resetSize()) {
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    protected boolean changeSize(boolean vertical, boolean direction) {
        return false;
    }

    protected boolean resetSize() {
        return false;
    }

    protected final JMenu createResizeMenu() {
        JMenu menu = new JMenu(TextArea.BUNDLE().getString("TextArea_Resize"));
        JMenuItem horizPlus = new JMenuItem(TextArea.BUNDLE().getString("TextArea_HorizPlus")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TextArea.this.changeSize(false, true);
            }
        };
        horizPlus.setAccelerator(KeyStroke.getKeyStroke(521, 2));
        menu.add(horizPlus);
        JMenuItem horizMinus = new JMenuItem(TextArea.BUNDLE().getString("TextArea_HorizMinus")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TextArea.this.changeSize(false, false);
            }
        };
        horizMinus.setAccelerator(KeyStroke.getKeyStroke(45, 2));
        menu.add(horizMinus);
        JMenuItem vertPlus = new JMenuItem(TextArea.BUNDLE().getString("TextArea_VertPlus")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TextArea.this.changeSize(true, true);
            }
        };
        vertPlus.setAccelerator(KeyStroke.getKeyStroke(521, 3));
        menu.add(vertPlus);
        JMenuItem vertMinus = new JMenuItem(TextArea.BUNDLE().getString("TextArea_VertMinus")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TextArea.this.changeSize(true, false);
            }
        };
        vertMinus.setAccelerator(KeyStroke.getKeyStroke(45, 3));
        menu.add(vertMinus);
        menu.addSeparator();
        JMenuItem reset = new JMenuItem(TextArea.BUNDLE().getString("TextArea_DefaultSize")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                TextArea.this.resetSize();
            }
        };
        reset.setAccelerator(KeyStroke.getKeyStroke(48, 2));
        menu.add(reset);
        return menu;
    }
}

