# Indian (Nakshatras)

## Introduction

First historical proofs of nakṣatra are given in the Vedic culture which is archaeologically attested in the Indus Valley before 1000 BCE [#1],[#2],[#5],[#6]. It is known from traditional religious texts and rituals that astronomy was used for timekeeping in that time. When the Indus culture started to spread to the Ganges Plateau which has a different climate, flora and fauna, Vedic cultural astronomy was reworked and a new religious text of that time, the Arthavaveda (900 to 600 BCE), preserves a complete set of constellations called ‘nakṣatra’ (नक्षत्र). The first complete non-religious description, the Vedāṅgajyotiṣa, dates to roughly 300 BCE, and the standardized origin (Ashvini as first) was set in the first century BCE or CE. Hinduism took over the nakshatras. In the first centuries CE, astrological ideas from the Graeco-Babylonian world, including the zodiac as a division of the ecliptic into twelve equal sections, was added to the older Vedic nakshatra-division. Since the middle of the first millennium CE, the system is used in its present form. 

The number of stars per nakshatra-constellations may vary in different sources. In this sky culture, we present only one single historical source: the depictions in Tirupperunthurai (Athmanathaswamy temple) near Aranthangi, India, 10th century CE. There, they are drawn at two occasions in exactly the same way: engraved in a doorway of stone, and imprinted in a tiruvasi, a silver arch from the temple's main chamber. 

## Description

In the second millennium BCE, the nakshatras were likely observed as rising constellations were the moon stands. The moon travels roughly 12° per day (360° in 30 days). However, historians proved that in later times, the nakshatras were observed in culmination [#4]. The moon then stands in the meridian together with some constellations. It is much easier to observe simultaneous culminations, as the air mass is much thinner there than at the horizon. Additionally, it simplifies the coordinate system and timekeeping, as simultaneously culminating asterisms share the same right ascension (hour) circle. 

### Sky


### Moon and Sun

The nakshatras are defined as a circle of constellations to observe the motion of the moon. However, the Sun also travels the same path. The nakshatra of the sun is called the maLe nakshatra. 

### Planets

The planets travel the same path but were not considered. 

### Zodiac

The nakshatra are a lunar frame of reference, developed independent of the Babylonian zodiac but later merged with it due to exchange with the Greek culture which had adopted it already. The term "kṣatra" means "brilliance and "na" is a negation; so "nakṣatra" means "no brilliance"/ "not bright". In most cases, the stars used to define the asterisms that define the lunar stations (nakṣatra) are faint - with the exceptions of Spica, Betelgeuse, Arcturus. The fact that they are not bright and, thus, not easily visible, might have triggered the development of a coordinate system (which is, by definition, invisible), as the mental step from almost-invisible to invisible-by-definition is small. It is unknown when this step of mathematisation happened in the Vedic culture, but its existance in the first millennium BCE is highly likely while the zodiac schema (Rāśi, राशिः) was only adopted in India in the first millennium CE. 

### Milky Way

The Milky Way is not incorporated in this set.

## Constellations

##### Ashvini

The meaning is "Horse Head", is the first nakshatra since the canonisation in the first millennium CE.

#####  Bharani

The meaning is "Bearer".

#####  Krittika

The meaning of the name is uncertain, but it's a name for the Pleiades, mythologically represented by seven damsels. 

#####  Rohini

Literally, the meaning is "The Red One", a name for reddish Aldebaran and the Hyades.

#####  Mrigashira

The term's literal meaning is "Deer's Head". It is an asterism of three faint stars that seem to form a nebulous patch. 

#####  Ardra

The sixth nakshatra has the name "Wetness". It is identified with Betelgeuse as a single star-asterism.

#####  Punarvasu

The term means "Twin-Restorer" and refers to a deity.

#####  Pushya

Pushya means "Nourisher" and is a name for the open star cluster M44 which is surrounded by four stars forming a box-like quadrilateral. 

#####  Ashlesha

Ashlesha means "Embrace".

#####  Magha

This name sometimes refers to the single star-asterism Regulus and sometimes to a group of four stars in a zigzag pattern. The literal translation means "Bountiful".

#####  Purva Phalguni

Likely, there used to be a constellation "Phalguni", the Reddish, in very old times that was later split into two sections to obtain a number of 27 units in the path of the moon; Purva Phalguni is the "First Reddish".

#####  Uttara Phalguni

Uttara Phalguni is the "Second Reddish", the second half of the Phalguni-asterism, in the direction of monthly lunar motion.

#####  Hasta

Hasta means "Hand" and refers to a group of five stars.

#####  Chitra

Chitra, the "Bright One", used to be a star name for most of historical sources. However, in this specific engraving in the temple, interestingly, this single star-asterism is drawn as two stars and not only as one as it used to be the tradition. The companion is called "Apamvatsa" in later star catalogues and also bears this name in the IAU-Catalogue of Star Names. 

#####  Svati

Svati is the name of a goddess.

#####  Vishakha

The literal meaning is "Forked"; it is the name of an asterims in Libra, but only the identification of alpha and beta Librae is certain. 

#####  Jyeshtha

The name means "Eldest" but it is unknown what it signifies.

#####  Mula

Mula, the "Root", is located in the area of Sco which contains some of the brightest clouds of the Milky Way with a significant dark stripe in the middle, and also many bright stars. Hence, it is uncertain if the name refers to a group of (up to ten) stars or to a pattern of bright or dark clouds. 

#####  Purva Ashadha

Ashadha, the Invincible, was the name of a larger constellation that was split into two parts, the first of which is the "First Invincible".

#####  Uttara Ashadha

The "Second Invincible" is the second half of the formerly larger constellation of Ashadha, the Invincible, in the direction of the monthly motion of the moon.

#####  Shravana

Shravana means "Listening".

#####  Dhanishta

Dhanishta, the "Most Famous", is the name of an easily recognisable pattern of stars; it appears as a group even to inexperienced observers. 

#####  Shatabhisha

Literally, the term Shatabhisha means "Hundred Physicians" and some historical depictions really display 100 stars. Here, it is just represented as a group of many. 

#####  Purva Bhadrapada

From the Blessed Feet, here we see the "First Blessed Feet".

#####  Uttara Bhadrapada

As the Moon on its monthly path moves from west to east, the eastern part of the constellation of the Blessed Feet is called "Second Blessed Feet".

#####  Revati

Revati means the "Prosperous". In the canonical counting the last nakshatra, harbinger of the new cycle. 


## References

 - [#1]: Débarbat, S; Eddy, J. A.; Eichhorn, H. K. and Upgren, A.R. (ed.) 1988. Mapping the Sky. International Astronomical Union Symposia, Kluwer Academic, Dordrecht (NL).
 - [#2]: Dikshit, S.B. 1981. Bhāratīya Jyotish Śāstra (History of Indian Astronomy), vol. 2, New Delhi (First published in Marathi in 1896.)
 - [#3]: Hoffmann and Shylaja (forthcoming), Nakshatras in the first millennium BCE
 - [#4]: Shylaja B S and Shubha B S (2024). A Unique Application Of The Observation Of Stars In Indian Astronomical Texts , 2024,  Journal for Astronomical History and Heritage, 27(3): 595-604 
 - [#5]: Weber, A. 1860-1862. Die Vedischen Nachrichten von der Naxatra. Königliche Akademie der Wissenschaften, Berlin. 2 Volumes.
 - [#6]: Yano, M. 2017. ‘The Nakṣatra System of the Atharvaveda-Pariśiṣṭa,’ Journal of Indian Studies 28/29: 65–74.

## Authors

Susanne M Hoffmann

### About

With B.S. Shylaja, I studied the early history of the nakshatras in our research. 

### Acknowledgements

I thank B. S. Shylaja for consulting me in my studies of the history of Vedic astronomy. 

Students of the University of Jena, Germany: Vincent Gerlach, Fabian Hofer, Luca-Philipp Grumbach, Mher Mnatsakanyan, Richard Hofmann and Moritz Rätz. These students developed the "Sky Culture Maker Plugin" for Stellarium which I am herewith testing.  

## License

CC BY 4.0







