/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm.tree;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LabelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsnList
implements Iterable<AbstractInsnNode> {
    private int size;
    private AbstractInsnNode firstInsn;
    private AbstractInsnNode lastInsn;
    AbstractInsnNode[] cache;

    public int size() {
        return this.size;
    }

    public AbstractInsnNode getFirst() {
        return this.firstInsn;
    }

    public AbstractInsnNode getLast() {
        return this.lastInsn;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractInsnNode get(int index) {
        void var1_1;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return this.cache[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(AbstractInsnNode insnNode) {
        void var2_2;
        AbstractInsnNode currentInsn = this.firstInsn;
        while (currentInsn != null && currentInsn != insnNode) {
            currentInsn = currentInsn.nextInsn;
        }
        return var2_2 != null;
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(AbstractInsnNode insnNode) {
        void var1_1;
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return var1_1.index;
    }

    public void accept(MethodVisitor methodVisitor) {
        AbstractInsnNode currentInsn = this.firstInsn;
        while (currentInsn != null) {
            currentInsn.accept(methodVisitor);
            currentInsn = currentInsn.nextInsn;
        }
    }

    @Override
    public ListIterator<AbstractInsnNode> iterator() {
        return this.iterator(0);
    }

    /*
     * WARNING - void declaration
     */
    public ListIterator<AbstractInsnNode> iterator(int index) {
        void var1_1;
        return new InsnListIterator((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractInsnNode[] toArray() {
        void var3_3;
        int currentInsnIndex = 0;
        AbstractInsnNode currentInsn = this.firstInsn;
        AbstractInsnNode[] insnNodeArray = new AbstractInsnNode[this.size];
        while (currentInsn != null) {
            insnNodeArray[currentInsnIndex] = currentInsn;
            currentInsn.index = currentInsnIndex++;
            currentInsn = currentInsn.nextInsn;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void set(AbstractInsnNode oldInsnNode, AbstractInsnNode newInsnNode) {
        AbstractInsnNode previousInsn;
        AbstractInsnNode nextInsn;
        newInsnNode.nextInsn = nextInsn = oldInsnNode.nextInsn;
        if (nextInsn != null) {
            nextInsn.previousInsn = newInsnNode;
        } else {
            this.lastInsn = newInsnNode;
        }
        newInsnNode.previousInsn = previousInsn = oldInsnNode.previousInsn;
        if (previousInsn != null) {
            previousInsn.nextInsn = newInsnNode;
        } else {
            this.firstInsn = newInsnNode;
        }
        if (this.cache != null) {
            void var3_4;
            int index = oldInsnNode.index;
            this.cache[index] = newInsnNode;
            newInsnNode.index = var3_4;
        } else {
            var2_2.index = 0;
        }
        oldInsnNode.index = -1;
        oldInsnNode.previousInsn = null;
        var1_1.nextInsn = null;
    }

    public void add(AbstractInsnNode insnNode) {
        ++this.size;
        if (this.lastInsn == null) {
            this.firstInsn = insnNode;
            this.lastInsn = insnNode;
        } else {
            this.lastInsn.nextInsn = insnNode;
            insnNode.previousInsn = this.lastInsn;
        }
        this.lastInsn = insnNode;
        this.cache = null;
        var1_1.index = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void add(InsnList insnList) {
        void var1_1;
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.lastInsn == null) {
            this.firstInsn = insnList.firstInsn;
            this.lastInsn = insnList.lastInsn;
        } else {
            AbstractInsnNode firstInsnListElement;
            this.lastInsn.nextInsn = firstInsnListElement = insnList.firstInsn;
            var2_2.previousInsn = this.lastInsn;
            this.lastInsn = insnList.lastInsn;
        }
        this.cache = null;
        var1_1.removeAll(false);
    }

    public void insert(AbstractInsnNode insnNode) {
        ++this.size;
        if (this.firstInsn == null) {
            this.firstInsn = insnNode;
            this.lastInsn = insnNode;
        } else {
            this.firstInsn.previousInsn = insnNode;
            insnNode.nextInsn = this.firstInsn;
        }
        this.firstInsn = insnNode;
        this.cache = null;
        var1_1.index = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void insert(InsnList insnList) {
        void var1_1;
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.firstInsn == null) {
            this.firstInsn = insnList.firstInsn;
            this.lastInsn = insnList.lastInsn;
        } else {
            AbstractInsnNode lastInsnListElement;
            this.firstInsn.previousInsn = lastInsnListElement = insnList.lastInsn;
            var2_2.nextInsn = this.firstInsn;
            this.firstInsn = insnList.firstInsn;
        }
        this.cache = null;
        var1_1.removeAll(false);
    }

    /*
     * WARNING - void declaration
     */
    public void insert(AbstractInsnNode previousInsn, AbstractInsnNode insnNode) {
        void var1_1;
        void var3_3;
        ++this.size;
        AbstractInsnNode nextInsn = previousInsn.nextInsn;
        if (nextInsn == null) {
            this.lastInsn = insnNode;
        } else {
            nextInsn.previousInsn = insnNode;
        }
        previousInsn.nextInsn = insnNode;
        insnNode.nextInsn = var3_3;
        insnNode.previousInsn = var1_1;
        this.cache = null;
        var2_2.index = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void insert(AbstractInsnNode previousInsn, InsnList insnList) {
        void var2_2;
        void var1_1;
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode firstInsnListElement = insnList.firstInsn;
        AbstractInsnNode lastInsnListElement = insnList.lastInsn;
        AbstractInsnNode nextInsn = previousInsn.nextInsn;
        if (nextInsn == null) {
            this.lastInsn = lastInsnListElement;
        } else {
            nextInsn.previousInsn = lastInsnListElement;
        }
        previousInsn.nextInsn = firstInsnListElement;
        lastInsnListElement.nextInsn = nextInsn;
        var3_3.previousInsn = var1_1;
        this.cache = null;
        var2_2.removeAll(false);
    }

    /*
     * WARNING - void declaration
     */
    public void insertBefore(AbstractInsnNode nextInsn, AbstractInsnNode insnNode) {
        void var3_3;
        void var1_1;
        ++this.size;
        AbstractInsnNode previousInsn = nextInsn.previousInsn;
        if (previousInsn == null) {
            this.firstInsn = insnNode;
        } else {
            previousInsn.nextInsn = insnNode;
        }
        nextInsn.previousInsn = insnNode;
        insnNode.nextInsn = var1_1;
        insnNode.previousInsn = var3_3;
        this.cache = null;
        var2_2.index = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void insertBefore(AbstractInsnNode nextInsn, InsnList insnList) {
        void var2_2;
        void var1_1;
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode firstInsnListElement = insnList.firstInsn;
        AbstractInsnNode lastInsnListElement = insnList.lastInsn;
        AbstractInsnNode previousInsn = nextInsn.previousInsn;
        if (previousInsn == null) {
            this.firstInsn = firstInsnListElement;
        } else {
            previousInsn.nextInsn = firstInsnListElement;
        }
        nextInsn.previousInsn = lastInsnListElement;
        lastInsnListElement.nextInsn = var1_1;
        var3_3.previousInsn = previousInsn;
        this.cache = null;
        var2_2.removeAll(false);
    }

    /*
     * WARNING - void declaration
     */
    public void remove(AbstractInsnNode insnNode) {
        --this.size;
        AbstractInsnNode nextInsn = insnNode.nextInsn;
        AbstractInsnNode previousInsn = insnNode.previousInsn;
        if (nextInsn == null) {
            if (previousInsn == null) {
                this.firstInsn = null;
                this.lastInsn = null;
            } else {
                previousInsn.nextInsn = null;
                this.lastInsn = previousInsn;
            }
        } else if (previousInsn == null) {
            this.firstInsn = nextInsn;
            nextInsn.previousInsn = null;
        } else {
            void var3_3;
            previousInsn.nextInsn = nextInsn;
            var2_2.previousInsn = var3_3;
        }
        this.cache = null;
        insnNode.index = -1;
        insnNode.previousInsn = null;
        var1_1.nextInsn = null;
    }

    /*
     * WARNING - void declaration
     */
    void removeAll(boolean mark) {
        if (mark) {
            AbstractInsnNode currentInsn = this.firstInsn;
            while (currentInsn != null) {
                void var2_3;
                AbstractInsnNode next = currentInsn.nextInsn;
                currentInsn.index = -1;
                currentInsn.previousInsn = null;
                currentInsn.nextInsn = null;
                currentInsn = var2_3;
            }
        }
        this.size = 0;
        this.firstInsn = null;
        this.lastInsn = null;
        this.cache = null;
    }

    public void clear() {
        this.removeAll(false);
    }

    public void resetLabels() {
        AbstractInsnNode currentInsn = this.firstInsn;
        while (currentInsn != null) {
            if (currentInsn instanceof LabelNode) {
                ((LabelNode)currentInsn).resetLabel();
            }
            currentInsn = currentInsn.nextInsn;
        }
    }

    private final class InsnListIterator
    implements ListIterator {
        AbstractInsnNode nextInsn;
        AbstractInsnNode previousInsn;
        AbstractInsnNode remove;

        InsnListIterator(int index) {
            if (index < 0 || index > InsnList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (index == InsnList.this.size()) {
                this.nextInsn = null;
                this.previousInsn = InsnList.this.getLast();
                return;
            }
            AbstractInsnNode currentInsn = InsnList.this.getFirst();
            for (int i = 0; i < index; ++i) {
                currentInsn = currentInsn.nextInsn;
            }
            this.nextInsn = currentInsn;
            this.previousInsn = ((AbstractInsnNode)((Object)InsnList.this)).previousInsn;
        }

        public final boolean hasNext() {
            return this.nextInsn != null;
        }

        /*
         * WARNING - void declaration
         */
        public final Object next() {
            void var1_1;
            AbstractInsnNode result;
            if (this.nextInsn == null) {
                throw new NoSuchElementException();
            }
            this.previousInsn = result = this.nextInsn;
            this.nextInsn = result.nextInsn;
            this.remove = result;
            return var1_1;
        }

        public final void remove() {
            if (this.remove != null) {
                if (this.remove == this.nextInsn) {
                    this.nextInsn = this.nextInsn.nextInsn;
                } else {
                    this.previousInsn = this.previousInsn.previousInsn;
                }
                InsnList.this.remove(this.remove);
                this.remove = null;
                return;
            }
            throw new IllegalStateException();
        }

        public final boolean hasPrevious() {
            return this.previousInsn != null;
        }

        /*
         * WARNING - void declaration
         */
        public final Object previous() {
            void var1_1;
            AbstractInsnNode result;
            if (this.previousInsn == null) {
                throw new NoSuchElementException();
            }
            this.nextInsn = result = this.previousInsn;
            this.previousInsn = result.previousInsn;
            this.remove = result;
            return var1_1;
        }

        public final int nextIndex() {
            if (this.nextInsn == null) {
                return InsnList.this.size();
            }
            if (InsnList.this.cache == null) {
                InsnList.this.cache = InsnList.this.toArray();
            }
            return this.nextInsn.index;
        }

        public final int previousIndex() {
            if (this.previousInsn == null) {
                return -1;
            }
            if (InsnList.this.cache == null) {
                InsnList.this.cache = InsnList.this.toArray();
            }
            return this.previousInsn.index;
        }

        /*
         * WARNING - void declaration
         */
        public final void add(Object o) {
            void var1_1;
            if (this.nextInsn != null) {
                InsnList.this.insertBefore(this.nextInsn, (AbstractInsnNode)o);
            } else if (this.previousInsn != null) {
                InsnList.this.insert(this.previousInsn, (AbstractInsnNode)o);
            } else {
                InsnList.this.add((AbstractInsnNode)o);
            }
            this.previousInsn = (AbstractInsnNode)var1_1;
            this.remove = null;
        }

        /*
         * WARNING - void declaration
         */
        public final void set(Object o) {
            if (this.remove != null) {
                void var1_1;
                InsnList.this.set(this.remove, (AbstractInsnNode)o);
                if (this.remove == this.previousInsn) {
                    this.previousInsn = (AbstractInsnNode)o;
                    return;
                }
                this.nextInsn = (AbstractInsnNode)var1_1;
                return;
            }
            throw new IllegalStateException();
        }
    }
}

