/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.MatchedStringMatcher;
import proguard.util.SettableMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.VariableStringMatcher;

public class NameParser
implements StringParser {
    private List variableStringMatchers;

    public NameParser() {
        this(null);
    }

    public NameParser(List variableStringMatchers) {
        this.variableStringMatchers = variableStringMatchers;
    }

    @Override
    public StringMatcher parse(String regularExpression) {
        int index;
        StringMatcher nextMatcher = new EmptyStringMatcher();
        for (index = 0; index < regularExpression.length(); ++index) {
            if (regularExpression.charAt(index) == '*') {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, null, 0, Integer.MAX_VALUE, settableMatcher));
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                break;
            }
            if (regularExpression.charAt(index) == '?') {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = this.rememberVariableStringMatcher(new VariableStringMatcher(null, null, 1, 1, settableMatcher));
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                break;
            }
            int wildCardIndex = this.wildCardIndex(regularExpression, index);
            if (wildCardIndex <= 0) continue;
            int closingIndex = regularExpression.indexOf(62, index + 1);
            nextMatcher = new MatchedStringMatcher(this.retrieveVariableStringMatcher(wildCardIndex - 1), this.parse(regularExpression.substring(closingIndex + 1)));
            break;
        }
        return index != 0 ? new FixedStringMatcher(regularExpression.substring(0, index), nextMatcher) : nextMatcher;
    }

    private int wildCardIndex(String string, int index) throws IllegalArgumentException {
        if (this.variableStringMatchers == null || string.charAt(index) != '<') {
            return 0;
        }
        int closingBracketIndex = string.indexOf(62, index);
        if (closingBracketIndex < 0) {
            throw new IllegalArgumentException("Missing closing angular bracket");
        }
        String argumentBetweenBrackets = string.substring(index + 1, closingBracketIndex);
        try {
            int wildcardIndex = Integer.parseInt(argumentBetweenBrackets);
            if (wildcardIndex < 1 || wildcardIndex > this.variableStringMatchers.size()) {
                throw new IllegalArgumentException("Invalid reference to wildcard (" + wildcardIndex + ", must lie between 1 and " + this.variableStringMatchers.size() + ")");
            }
            return wildcardIndex;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private VariableStringMatcher rememberVariableStringMatcher(VariableStringMatcher variableStringMatcher) {
        if (this.variableStringMatchers != null) {
            this.variableStringMatchers.add(variableStringMatcher);
        }
        return variableStringMatcher;
    }

    private VariableStringMatcher retrieveVariableStringMatcher(int index) {
        return (VariableStringMatcher)this.variableStringMatchers.get(index);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Regular expression [" + args[0] + "]");
            NameParser parser = new NameParser();
            StringMatcher matcher = parser.parse(args[0]);
            for (int index = 1; index < args.length; ++index) {
                String string = args[index];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + matcher.matches(args[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

