/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import java.util.List;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.NodesCache;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;

public class ThreadStateNode
extends HeapViewerNode {
    private final Thread.State state;

    public ThreadStateNode(Thread.State state, List<HeapViewerNode> children) {
        this.state = state;
        this.setChildren(children.toArray(NO_NODES));
    }

    public String getName() {
        if (this.state == null) {
            return "Undefined";
        }
        return this.state.toString();
    }

    public Thread.State getState() {
        return this.state;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected void resetChildren() {
    }

    @Override
    public void forgetChildren(NodesCache cache) {
    }

    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.NAME) {
            return this.getName();
        }
        if (type == DataType.COUNT) {
            return DataType.COUNT.getUnsupportedValue();
        }
        if (type == DataType.OWN_SIZE) {
            return DataType.OWN_SIZE.getUnsupportedValue();
        }
        if (type == DataType.RETAINED_SIZE) {
            return DataType.RETAINED_SIZE.getUnsupportedValue();
        }
        if (type == DataType.INSTANCE) {
            return DataType.INSTANCE.getUnsupportedValue();
        }
        if (type == DataType.CLASS) {
            return DataType.CLASS.getUnsupportedValue();
        }
        if (type == DataType.LOGICAL_VALUE) {
            return DataType.LOGICAL_VALUE.getUnsupportedValue();
        }
        return super.getValue(type, heap);
    }
}

