/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import jogamp.common.os.BionicDynamicLinker32bitImpl;
import jogamp.common.os.BionicDynamicLinker64BitImpl;
import jogamp.common.os.DynamicLinkerImpl;
import jogamp.common.os.MacOSXDynamicLinkerImpl;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.common.os.PosixDynamicLinkerImpl;
import jogamp.common.os.WindowsDynamicLinkerImpl;

public final class NativeLibrary
implements DynamicLookupHelper {
    private static final String[] prefixes;
    private static final String[] suffixes;
    private static final boolean isOSX;
    private static String sys_env_lib_path_varname;
    private final DynamicLinker dynLink;
    private long libraryHandle;
    private final String libraryPath;
    private final boolean global;
    private static boolean initializedFindLibraryMethod;
    private static Method findLibraryMethod;

    private NativeLibrary(DynamicLinker dynamicLinker, long l, String string, boolean bl) {
        this.dynLink = dynamicLinker;
        this.libraryHandle = l;
        this.libraryPath = string;
        this.global = bl;
        if (DEBUG) {
            System.err.println("NativeLibrary.open(): Successfully loaded: " + this);
        }
    }

    public final String toString() {
        return "NativeLibrary[" + this.dynLink.getClass().getSimpleName() + ", " + this.libraryPath + ", 0x" + Long.toHexString(this.libraryHandle) + ", global " + this.global + "]";
    }

    public static final String getSystemEnvLibraryPathVarname() {
        return sys_env_lib_path_varname;
    }

    public static final List<String> getSystemEnvLibraryPaths() {
        String string = SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(NativeLibrary.getSystemEnvLibraryPathVarname());
            }
        });
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != string && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public static final NativeLibrary open(String string, boolean bl, boolean bl2, ClassLoader classLoader, boolean bl3) throws SecurityException {
        return NativeLibrary.open(string, string, string, bl, bl2, classLoader, bl3);
    }

    public static final NativeLibrary open(String string, String string2, String string3, boolean bl, boolean bl2, ClassLoader classLoader, boolean bl3) throws SecurityException {
        List<String> list = NativeLibrary.enumerateLibraryPaths(string, string2, string3, bl, bl2, classLoader);
        Platform.initSingleton();
        DynamicLinker dynamicLinker = NativeLibrary.getDynamicLinker();
        for (String string4 : list) {
            String string5;
            long l;
            if (DEBUG) {
                System.err.println("NativeLibrary.open(global " + bl3 + "): Trying to load " + string4);
            }
            Throwable throwable = null;
            try {
                l = bl3 ? dynamicLinker.openLibraryGlobal(string4, DEBUG) : dynamicLinker.openLibraryLocal(string4, DEBUG);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                l = 0L;
            }
            if (0L != l) {
                return new NativeLibrary(dynamicLinker, l, string4, bl3);
            }
            if (!DEBUG) continue;
            if (null != throwable) {
                System.err.println("NativeLibrary.open: Caught " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            }
            try {
                string5 = dynamicLinker.getLastError();
            }
            catch (Throwable throwable3) {
                string5 = null;
            }
            System.err.println("NativeLibrary.open: Last error " + string5);
            if (null == throwable) continue;
            throwable.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.open(global " + bl3 + "): Did not succeed in loading (" + string + ", " + string2 + ", " + string3 + ")");
        }
        return null;
    }

    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        this.dynLink.claimAllLinkPermission();
    }

    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        this.dynLink.releaseAllLinkPermission();
    }

    @Override
    public final long dynamicLookupFunction(String string) throws SecurityException {
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library is not open");
        }
        return this.dynLink.lookupSymbol(this.libraryHandle, string);
    }

    @Override
    public final boolean isFunctionAvailable(String string) throws SecurityException {
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library is not open");
        }
        return 0L != this.dynLink.lookupSymbol(this.libraryHandle, string);
    }

    public final long dynamicLookupFunctionGlobal(String string) throws SecurityException {
        return this.dynLink.lookupSymbolGlobal(string);
    }

    final DynamicLinker dynamicLinker() {
        return this.dynLink;
    }

    static DynamicLinker getDynamicLinker() {
        DynamicLinkerImpl dynamicLinkerImpl;
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                dynamicLinkerImpl = new WindowsDynamicLinkerImpl();
                break;
            }
            case MACOS: 
            case IOS: {
                dynamicLinkerImpl = new MacOSXDynamicLinkerImpl();
                break;
            }
            case ANDROID: {
                if (PlatformPropsImpl.CPU_ARCH.is32Bit) {
                    dynamicLinkerImpl = new BionicDynamicLinker32bitImpl();
                    break;
                }
                dynamicLinkerImpl = new BionicDynamicLinker64BitImpl();
                break;
            }
            default: {
                dynamicLinkerImpl = new PosixDynamicLinkerImpl();
            }
        }
        return dynamicLinkerImpl;
    }

    public final long getLibraryHandle() {
        return this.libraryHandle;
    }

    public final String getLibraryPath() {
        return this.libraryPath;
    }

    public final void close() throws SecurityException {
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): closing " + this);
        }
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library already closed");
        }
        long l = this.libraryHandle;
        this.libraryHandle = 0L;
        this.dynLink.closeLibrary(l, DEBUG);
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): Successfully closed " + this);
            ExceptionUtils.dumpStack(System.err);
        }
    }

    public static final String isValidNativeLibraryName(String string, boolean bl) {
        int n;
        String string2;
        try {
            string2 = IOUtil.getBasename(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        String string3 = bl ? string2 : string2.toLowerCase();
        int n2 = -1;
        for (n = 0; n < prefixes.length && 0 > n2; ++n) {
            if (!string3.startsWith(prefixes[n])) continue;
            n2 = n;
        }
        if (0 <= n2) {
            for (n = 0; n < suffixes.length; ++n) {
                if (!string3.endsWith(suffixes[n])) continue;
                int n3 = prefixes[n2].length();
                int n4 = suffixes[n].length();
                return string2.substring(n3, string2.length() - n4);
            }
        }
        return null;
    }

    public static final List<String> enumerateLibraryPaths(String string, String string2, String string3, ClassLoader classLoader) {
        return NativeLibrary.enumerateLibraryPaths(string, string2, string3, false, false, classLoader);
    }

    public static final List<String> enumerateLibraryPaths(String string, String string2, String string3, boolean bl, ClassLoader classLoader) {
        return NativeLibrary.enumerateLibraryPaths(string, string2, string3, true, bl, classLoader);
    }

    private static final List<String> enumerateLibraryPaths(String string, String string2, String string3, final boolean bl, final boolean bl2, ClassLoader classLoader) {
        String[] stringArray;
        String string4;
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string5 = NativeLibrary.selectName(string, string2, string3);
        if (string5 == null) {
            if (DEBUG) {
                System.err.println("NativeLibrary.enumerateLibraryPaths: empty, no libName selected");
            }
            return arrayList;
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.enumerateLibraryPaths: libName '" + string5 + "'");
        }
        if ((file = new File(string5)).isAbsolute()) {
            arrayList.add(string5);
            if (DEBUG) {
                System.err.println("NativeLibrary.enumerateLibraryPaths: done, absolute path found '" + string5 + "'");
            }
            return arrayList;
        }
        Object[] objectArray = NativeLibrary.buildNames(string5);
        if (DEBUG) {
            System.err.println("NativeLibrary.enumerateLibraryPaths: baseNames: " + Arrays.toString(objectArray));
        }
        if (bl && bl2) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (DEBUG) {
                    System.err.println("NativeLibrary.enumerateLibraryPaths: add.ssp_1st: " + (String)objectArray[i]);
                }
                arrayList.add((String)objectArray[i]);
            }
            if (isOSX) {
                NativeLibrary.addAbsPaths("add.ssp_1st_macos_old", "/Library/Frameworks/" + string5 + ".framework", (String[])objectArray, arrayList);
                NativeLibrary.addAbsPaths("add.ssp_1st_macos_cur", "/System/Library/Frameworks/" + string5 + ".framework", (String[])objectArray, arrayList);
            }
        }
        if ((string4 = NativeLibrary.findLibrary(string5, classLoader)) != null) {
            if (DEBUG) {
                System.err.println("NativeLibrary.enumerateLibraryPaths: add.clp: " + string4);
            }
            arrayList.add(string4);
        }
        if (null != (stringArray = SecurityUtil.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                String string;
                int n = 0;
                String string2 = System.getProperty("java.library.path");
                if (null != string2) {
                    ++n;
                }
                if (bl) {
                    string = System.getProperty("sun.boot.library.path");
                    if (null != string) {
                        ++n;
                    }
                } else {
                    string = null;
                }
                String[] stringArray = new String[n];
                int n2 = 0;
                if (null != string && bl2) {
                    stringArray[n2++] = string;
                }
                if (null != string2) {
                    stringArray[n2++] = string2;
                }
                if (null != string && !bl2) {
                    stringArray[n2++] = string;
                }
                return stringArray;
            }
        }))) {
            for (int i = 0; i < stringArray.length; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    NativeLibrary.addRelPaths("add.java.library.path", stringTokenizer.nextToken(), (String[])objectArray, arrayList);
                }
            }
        }
        String string6 = SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        });
        NativeLibrary.addAbsPaths("add.user.dir.std", string6, (String[])objectArray, arrayList);
        NativeLibrary.addAbsPaths("add.user.dir.fat", string6 + File.separator + "natives" + File.separator + PlatformPropsImpl.os_and_arch, (String[])objectArray, arrayList);
        if (bl && !bl2) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (DEBUG) {
                    System.err.println("NativeLibrary.enumerateLibraryPaths: add.ssp_lst: " + (String)objectArray[i]);
                }
                arrayList.add((String)objectArray[i]);
            }
            if (isOSX) {
                NativeLibrary.addAbsPaths("add.ssp_lst_macos_old", "/Library/Frameworks/" + string5 + ".Framework", (String[])objectArray, arrayList);
                NativeLibrary.addAbsPaths("add.ssp_lst_macos_cur", "/System/Library/Frameworks/" + string5 + ".Framework", (String[])objectArray, arrayList);
            }
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.enumerateLibraryPaths: done: " + ((Object)arrayList).toString());
        }
        return arrayList;
    }

    private static final String selectName(String string, String string2, String string3) {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return string;
            }
            case MACOS: 
            case IOS: {
                return string3;
            }
        }
        return string2;
    }

    private static final String[] buildNames(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        String string2;
        try {
            string2 = IOUtil.getBasename(string).toLowerCase();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        int n5 = -1;
        for (n4 = 0; n4 < prefixes.length && 0 > n5; ++n4) {
            if (!string2.startsWith(prefixes[n4])) continue;
            n5 = n4;
        }
        if (0 <= n5) {
            for (n4 = 0; n4 < suffixes.length; ++n4) {
                if (!string2.endsWith(suffixes[n4])) continue;
                return new String[]{string};
            }
            n4 = -1;
            for (n3 = 0; n3 < suffixes.length && 0 > n4; ++n3) {
                n4 = string2.indexOf(suffixes[n3]);
            }
            n3 = 1;
            if (n4 >= 0) {
                for (n2 = n4 + suffixes[0].length(); n2 < string.length(); ++n2) {
                    n = string.charAt(n2);
                    if (n == 46 || n >= 48 && n <= 57) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    return new String[]{string};
                }
            }
        }
        String[] stringArray = new String[prefixes.length * suffixes.length + (isOSX ? 1 : 0)];
        n3 = 0;
        for (n2 = 0; n2 < prefixes.length; ++n2) {
            for (n = 0; n < suffixes.length; ++n) {
                stringArray[n3++] = prefixes[n2] + string + suffixes[n];
            }
        }
        if (isOSX) {
            stringArray[n3++] = string;
        }
        return stringArray;
    }

    private static final void addRelPaths(String string, String string2, String[] stringArray, List<String> list) {
        String string3;
        try {
            File file = new File(string2);
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.err.println("NativeLibrary.enumerateLibraryPaths: " + string + ": Exception " + iOException.getMessage() + ", from path " + string2);
            }
            return;
        }
        NativeLibrary.addAbsPaths(string, string3, stringArray, list);
    }

    private static final void addAbsPaths(String string, String string2, String[] stringArray, List<String> list) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = string2 + File.separator + stringArray[i];
            if (DEBUG) {
                System.err.println("NativeLibrary.enumerateLibraryPaths: " + string + ": " + string3 + ", from path " + string2);
            }
            list.add(string3);
        }
    }

    private static final String findLibraryImpl(final String string, final ClassLoader classLoader) {
        block6: {
            if (PlatformPropsImpl.JAVA_9) {
                return null;
            }
            if (classLoader == null) {
                return null;
            }
            if (!initializedFindLibraryMethod) {
                SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            findLibraryMethod = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                            findLibraryMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initializedFindLibraryMethod = true;
                        return null;
                    }
                });
            }
            if (findLibraryMethod != null) {
                try {
                    return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            try {
                                return (String)findLibraryMethod.invoke((Object)classLoader, string);
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    if (!DEBUG) break block6;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static final String findLibrary(String string, ClassLoader classLoader) {
        String string2 = null;
        if (TempJarCache.isInitialized(true)) {
            string2 = TempJarCache.findLibrary(string);
            if (DEBUG) {
                System.err.println("NativeLibrary.findLibrary(<" + string + ">) (TempJarCache): " + string2);
            }
        }
        if (null == string2) {
            string2 = NativeLibrary.findLibraryImpl(string, classLoader);
            if (DEBUG) {
                System.err.println("NativeLibrary.findLibrary(<" + string + ">, " + classLoader + ") (CL): " + string2);
            }
        }
        return string2;
    }

    static {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                prefixes = new String[]{""};
                suffixes = new String[]{".dll"};
                sys_env_lib_path_varname = "PATH";
                isOSX = false;
                break;
            }
            case MACOS: 
            case IOS: {
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".dylib"};
                sys_env_lib_path_varname = "DYLD_LIBRARY_PATH";
                isOSX = true;
                break;
            }
            default: {
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".so"};
                sys_env_lib_path_varname = "LD_LIBRARY_PATH";
                isOSX = false;
            }
        }
        initializedFindLibraryMethod = false;
        findLibraryMethod = null;
    }
}

