/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.math;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.function.Strict;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class ConvFunction
extends ImplementorUDF {
    public ConvFunction() {
        super(new ConvImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.STRING_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.STRING_OR_INTEGER_INTEGER_INTEGER;
    }

    public static class ConvImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            RelDataType numberType = ((RexNode)call.getOperands().getFirst()).getType();
            Expression number = translatedOperands.getFirst();
            Expression fromBase = translatedOperands.get(1);
            Expression toBase = translatedOperands.get(2);
            if (numberType.getFamily() == SqlTypeFamily.NUMERIC) {
                number = Expressions.call((Expression)Expressions.box((Expression)number), (String)"toString", (Expression[])new Expression[0]);
            }
            return Expressions.call(ConvImplementor.class, (String)"conv", (Expression[])new Expression[]{number, fromBase, toBase});
        }

        @Strict
        public static String conv(String numStr, int fromBase, int toBase) {
            return Long.toString(Long.parseLong(numStr, fromBase), toBase);
        }
    }
}

