/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import org.opensearch.common.annotation.PublicApi;

@PublicApi(since="1.0.0")
public enum SearchType {
    DFS_QUERY_THEN_FETCH(0),
    QUERY_THEN_FETCH(1);

    public static final SearchType DEFAULT;
    public static final SearchType[] CURRENTLY_SUPPORTED;
    private byte id;

    private SearchType(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static SearchType fromId(byte id) {
        if (id == 0) {
            return DFS_QUERY_THEN_FETCH;
        }
        if (id == 1 || id == 3) {
            return QUERY_THEN_FETCH;
        }
        throw new IllegalArgumentException("No search type for [" + id + "]");
    }

    public static SearchType fromString(String searchType) {
        if (searchType == null) {
            return DEFAULT;
        }
        if ("dfs_query_then_fetch".equals(searchType)) {
            return DFS_QUERY_THEN_FETCH;
        }
        if ("query_then_fetch".equals(searchType)) {
            return QUERY_THEN_FETCH;
        }
        throw new IllegalArgumentException("No search type for [" + searchType + "]");
    }

    static {
        DEFAULT = QUERY_THEN_FETCH;
        CURRENTLY_SUPPORTED = new SearchType[]{QUERY_THEN_FETCH, DFS_QUERY_THEN_FETCH};
    }
}

