# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import functools

from . import abstract_mechanism
from . import bcachefs_mechanism
from . import btrfs_mechanism
from . import rsync_mechanism
from . import snap_type_enum


@functools.cache
def get(snap_type: snap_type_enum.SnapType) -> abstract_mechanism.SnapMechanism:
    """Singleton factory implementation."""
    if snap_type == snap_type_enum.SnapType.BTRFS:
        return btrfs_mechanism.BtrfsSnapMechanism()
    if snap_type == snap_type_enum.SnapType.RSYNC:
        return rsync_mechanism.RsyncSnapMechanism()
    if snap_type == snap_type_enum.SnapType.BCACHEFS:
        return bcachefs_mechanism.BcachefsSnapMechanism()
    raise RuntimeError(f"Unknown snap_type {snap_type}")
