type Dict = Record<string, readonly [number, number]>;
type looseString = string | number | bigint | boolean | null | undefined;
type Include<T, U> = T extends U ? T : never;
type True = void;
type False = never;
type STEquals<T, U> = T | U extends U ? True : False;
type unC<T> = Exclude<T, `\x1b[${number}m${string}`>;
type replace<V extends looseString, S extends looseString, R extends looseString> = V extends `${infer A extends string}${S}${infer Z extends string}` ? `${A}${R}${replace<Z, S, R>}` : V;
type colorsFunc<A extends number, D extends number> = <T extends looseString>(value: T) => unC<T> | `\x1b[${A}m${replace<STEquals<T, unC<T>> extends True ? T : Include<T, `\x1b[${number}m${string}`>, D, A>}\x1b[${D}m`;
type resetFunc = <T extends looseString = "">(value: T) => `\x1b[0m${T}`;
type dictMap<T extends Dict> = {
    [P in keyof T]: P extends "reset" ? resetFunc : colorsFunc<T[P][0], T[P][1]>;
};
/**
 * An object containing multiple functions used to colorize the text.
 *
 * @example
 * // Print error in the console.
 * console.error(colors.red("[Error]")+" Something's not right...")
 */
declare const colors: Readonly<dictMap<Readonly<{
    readonly black: readonly [30, 39];
    readonly red: readonly [31, 39];
    readonly green: readonly [32, 39];
    readonly yellow: readonly [33, 39];
    readonly blue: readonly [34, 39];
    readonly magenta: readonly [35, 39];
    readonly cyan: readonly [36, 39];
    readonly white: readonly [37, 39];
    readonly bgBlack: readonly [40, 49];
    readonly bgRed: readonly [41, 49];
    readonly bgGreen: readonly [42, 49];
    readonly bgYellow: readonly [43, 49];
    readonly bgBlue: readonly [44, 49];
    readonly bgMagenta: readonly [45, 49];
    readonly bgCyan: readonly [46, 49];
    readonly bgWhite: readonly [47, 49];
    readonly gray: readonly [90, 39];
    readonly redBright: readonly [91, 39];
    readonly greenBright: readonly [92, 39];
    readonly yellowBright: readonly [93, 39];
    readonly blueBright: readonly [94, 39];
    readonly magentaBright: readonly [95, 39];
    readonly cyanBright: readonly [96, 39];
    readonly whiteBright: readonly [97, 39];
    readonly bgGray: readonly [100, 49];
    readonly bgRedBright: readonly [101, 49];
    readonly bgGreenBright: readonly [102, 49];
    readonly bgYellowBright: readonly [103, 49];
    readonly bgBlueBright: readonly [104, 49];
    readonly bgMagentaBright: readonly [105, 49];
    readonly bgCyanBright: readonly [106, 49];
    readonly bgWhiteBright: readonly [107, 49];
}>> & {
    /** An alias of `colors.magenta`. */
    purple: colorsFunc<35, 39>;
    /** An alias of `colors.magentaBg`. */
    bgPurple: colorsFunc<45, 49>;
    /** An alias of `colors.white`. */
    lightGray: colorsFunc<37, 39>;
    /** An alias of `colors.white`. */
    lightGrey: colorsFunc<37, 39>;
    /** An alias of `colors.gray`. */
    grey: colorsFunc<90, 39>;
    /** An alias of `colors.gray`. */
    blackBright: colorsFunc<90, 39>;
    /** An alias of `colors.bgGray. */
    bgGrey: colorsFunc<100, 49>;
    /** An alias of `colors.bgGray`. */
    bgBlackBright: colorsFunc<100, 49>;
}>;
/**
 * An object grouped by platform support, including functions to transform text
 * in the console to change it appearance (e.g. make it underlined) rather than
 * just set a specific font color.
 */
declare const modifiers: Readonly<{
    /**
     * Modifiers working fine across most popular platforms/consoles.
     */
    safe: Readonly<dictMap<Readonly<{
        readonly reset: readonly [0, 0];
        readonly bold: readonly [1, 22];
        readonly underline: readonly [4, 24];
        readonly inverse: readonly [7, 27];
    }>> & {
        /** An alias of `modifiers.safe.inverse`. */
        swapColors: colorsFunc<7, 27>;
        /** An alias of `modifiers.safe.inverse`. */
        swapcolors: colorsFunc<7, 27>;
    }>;
    /**
     * Other modifiers that may not work with all consoles (e.g. `cmd.exe`).
     */
    other: Readonly<dictMap<Readonly<{
        readonly dim: readonly [2, 22];
        readonly italic: readonly [3, 23];
        readonly blink: readonly [5, 25];
        readonly rapidBlink: readonly [6, 25];
        readonly hidden: readonly [8, 28];
        readonly strikethrough: readonly [9, 29];
        readonly doubleunderline: readonly [21, 24];
        readonly framed: readonly [51, 54];
        readonly overlined: readonly [53, 55];
    }>> & {
        /** An alias of `modifiers.other.dim`. */
        faint: colorsFunc<2, 22>;
        /** An alias of `modifiers.other.strikethrough`. */
        strikeThrough: colorsFunc<9, 29>;
        /** An alias of `modifiers.other.strikethrough`. */
        crossedout: colorsFunc<9, 29>;
        /** An alias of `modifiers.other.strikethrough`. */
        crossedOut: colorsFunc<9, 29>;
        /** An alias of `modifiers.other.hidden`. */
        conceal: colorsFunc<8, 28>;
        /** An alias of `modifiers.other.doubleunderline`. */
        doubleUnderline: colorsFunc<21, 24>;
    }>;
}>;
declare const defaultExport: Readonly<{
    unsafe: Readonly<dictMap<Readonly<{
        readonly dim: readonly [2, 22];
        readonly italic: readonly [3, 23];
        readonly blink: readonly [5, 25];
        readonly rapidBlink: readonly [6, 25];
        readonly hidden: readonly [8, 28];
        readonly strikethrough: readonly [9, 29];
        readonly doubleunderline: readonly [21, 24];
        readonly framed: readonly [51, 54];
        readonly overlined: readonly [53, 55];
    }>> & {
        /** An alias of `modifiers.other.dim`. */
        faint: colorsFunc<2, 22>;
        /** An alias of `modifiers.other.strikethrough`. */
        strikeThrough: colorsFunc<9, 29>;
        /** An alias of `modifiers.other.strikethrough`. */
        crossedout: colorsFunc<9, 29>;
        /** An alias of `modifiers.other.strikethrough`. */
        crossedOut: colorsFunc<9, 29>;
        /** An alias of `modifiers.other.hidden`. */
        conceal: colorsFunc<8, 28>;
        /** An alias of `modifiers.other.doubleunderline`. */
        doubleUnderline: colorsFunc<21, 24>;
    }>;
    reset: resetFunc;
    bold: colorsFunc<1, 22>;
    underline: colorsFunc<4, 24>;
    inverse: colorsFunc<7, 27>;
    swapColors: colorsFunc<7, 27>;
    swapcolors: colorsFunc<7, 27>;
    black: colorsFunc<30, 39>;
    red: colorsFunc<31, 39>;
    green: colorsFunc<32, 39>;
    yellow: colorsFunc<33, 39>;
    blue: colorsFunc<34, 39>;
    magenta: colorsFunc<35, 39>;
    cyan: colorsFunc<36, 39>;
    white: colorsFunc<37, 39>;
    bgBlack: colorsFunc<40, 49>;
    bgRed: colorsFunc<41, 49>;
    bgGreen: colorsFunc<42, 49>;
    bgYellow: colorsFunc<43, 49>;
    bgBlue: colorsFunc<44, 49>;
    bgMagenta: colorsFunc<45, 49>;
    bgCyan: colorsFunc<46, 49>;
    bgWhite: colorsFunc<47, 49>;
    gray: colorsFunc<90, 39>;
    redBright: colorsFunc<91, 39>;
    greenBright: colorsFunc<92, 39>;
    yellowBright: colorsFunc<93, 39>;
    blueBright: colorsFunc<94, 39>;
    magentaBright: colorsFunc<95, 39>;
    cyanBright: colorsFunc<96, 39>;
    whiteBright: colorsFunc<97, 39>;
    bgGray: colorsFunc<100, 49>;
    bgRedBright: colorsFunc<101, 49>;
    bgGreenBright: colorsFunc<102, 49>;
    bgYellowBright: colorsFunc<103, 49>;
    bgBlueBright: colorsFunc<104, 49>;
    bgMagentaBright: colorsFunc<105, 49>;
    bgCyanBright: colorsFunc<106, 49>;
    bgWhiteBright: colorsFunc<107, 49>;
    purple: colorsFunc<35, 39>;
    bgPurple: colorsFunc<45, 49>;
    lightGray: colorsFunc<37, 39>;
    lightGrey: colorsFunc<37, 39>;
    grey: colorsFunc<90, 39>;
    blackBright: colorsFunc<90, 39>;
    bgGrey: colorsFunc<100, 49>;
    bgBlackBright: colorsFunc<100, 49>;
}>;
export { colors, modifiers };
export default defaultExport;
