/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

export function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

export var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

export function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

export function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

export function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

export function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

export function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

export function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

export function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

export function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

export function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

export function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

export var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

export function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

export function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

export function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
export function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
export function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

export function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

export function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

export function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

export function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

export function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

export function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

export function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

export function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

export function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

export function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

export function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

export function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
            if (async) inner = dispose;
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;

}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

export function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

export default {
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
};

var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
  get: (a, b) => (typeof require !== "undefined" ? require : a)[b]
}) : x)(function(x) {
  if (typeof require !== "undefined") return require.apply(this, arguments);
  throw Error('Dynamic require of "' + x + '" is not supported');
});

// out-build/vs/nls.messages.js
function $f() {
  return globalThis._VSCODE_NLS_MESSAGES;
}
function $g() {
  return globalThis._VSCODE_NLS_LANGUAGE;
}

// out-build/vs/nls.js
var isPseudo = $g() === "pseudo" || typeof document !== "undefined" && document.location && typeof document.location.hash === "string" && document.location.hash.indexOf("pseudo=true") >= 0;
function _format(message, args2) {
  let result;
  if (args2.length === 0) {
    result = message;
  } else {
    result = message.replace(/\{(\d+)\}/g, (match, rest) => {
      const index = rest[0];
      const arg = args2[index];
      let result2 = match;
      if (typeof arg === "string") {
        result2 = arg;
      } else if (typeof arg === "number" || typeof arg === "boolean" || arg === void 0 || arg === null) {
        result2 = String(arg);
      }
      return result2;
    });
  }
  if (isPseudo) {
    result = "\uFF3B" + result.replace(/[aouei]/g, "$&$&") + "\uFF3D";
  }
  return result;
}
function localize(data, message, ...args2) {
  if (typeof data === "number") {
    return _format(lookupMessage(data, message), args2);
  }
  return _format(message, args2);
}
function lookupMessage(index, fallback2) {
  const message = $f()?.[index];
  if (typeof message !== "string") {
    if (typeof fallback2 === "string") {
      return fallback2;
    }
    throw new Error(`!!! NLS MISSING: ${index} !!!`);
  }
  return message;
}
function localize2(data, originalMessage, ...args2) {
  let message;
  if (typeof data === "number") {
    message = lookupMessage(data, originalMessage);
  } else {
    message = originalMessage;
  }
  const value = _format(message, args2);
  return {
    value,
    original: originalMessage === message ? value : _format(originalMessage, args2)
  };
}

// out-build/vs/base/browser/window.js
function $_S(targetWindow, fallbackWindowId) {
  const codeWindow = targetWindow;
  if (typeof codeWindow.vscodeWindowId !== "number") {
    Object.defineProperty(codeWindow, "vscodeWindowId", {
      get: () => fallbackWindowId
    });
  }
}
var $aT = window;
function $bT(obj) {
  if (obj === $aT) {
    return false;
  }
  const candidate = obj;
  return typeof candidate?.vscodeWindowId === "number";
}

// out-build/vs/base/common/collections.js
var _a;
function $a(data, groupFn) {
  const result = /* @__PURE__ */ Object.create(null);
  for (const element of data) {
    const key = groupFn(element);
    let target = result[key];
    if (!target) {
      target = result[key] = [];
    }
    target.push(element);
  }
  return result;
}
function $b(before, after) {
  const removed = [];
  const added = [];
  for (const element of before) {
    if (!after.has(element)) {
      removed.push(element);
    }
  }
  for (const element of after) {
    if (!before.has(element)) {
      added.push(element);
    }
  }
  return { removed, added };
}
function $c(before, after) {
  const removed = [];
  const added = [];
  for (const [index, value] of before) {
    if (!after.has(index)) {
      removed.push(value);
    }
  }
  for (const [index, value] of after) {
    if (!before.has(index)) {
      added.push(value);
    }
  }
  return { removed, added };
}
function $d(setA, setB) {
  const result = /* @__PURE__ */ new Set();
  for (const elem of setB) {
    if (setA.has(elem)) {
      result.add(elem);
    }
  }
  return result;
}
var $e = class {
  static {
    _a = Symbol.toStringTag;
  }
  constructor(values, b) {
    this.b = b;
    this.a = /* @__PURE__ */ new Map();
    this[_a] = "SetWithKey";
    for (const value of values) {
      this.add(value);
    }
  }
  get size() {
    return this.a.size;
  }
  add(value) {
    const key = this.b(value);
    this.a.set(key, value);
    return this;
  }
  delete(value) {
    return this.a.delete(this.b(value));
  }
  has(value) {
    return this.a.has(this.b(value));
  }
  *entries() {
    for (const entry of this.a.values()) {
      yield [entry, entry];
    }
  }
  keys() {
    return this.values();
  }
  *values() {
    for (const entry of this.a.values()) {
      yield entry;
    }
  }
  clear() {
    this.a.clear();
  }
  forEach(callbackfn, thisArg) {
    this.a.forEach((entry) => callbackfn.call(thisArg, entry, entry, this));
  }
  [Symbol.iterator]() {
    return this.values();
  }
};

// out-build/vs/base/common/errors.js
var $8 = class {
  constructor() {
    this.b = [];
    this.a = function(e) {
      setTimeout(() => {
        if (e.stack) {
          if ($ob.isErrorNoTelemetry(e)) {
            throw new $ob(e.message + "\n\n" + e.stack);
          }
          throw new Error(e.message + "\n\n" + e.stack);
        }
        throw e;
      }, 0);
    };
  }
  addListener(listener) {
    this.b.push(listener);
    return () => {
      this.d(listener);
    };
  }
  c(e) {
    this.b.forEach((listener) => {
      listener(e);
    });
  }
  d(listener) {
    this.b.splice(this.b.indexOf(listener), 1);
  }
  setUnexpectedErrorHandler(newUnexpectedErrorHandler) {
    this.a = newUnexpectedErrorHandler;
  }
  getUnexpectedErrorHandler() {
    return this.a;
  }
  onUnexpectedError(e) {
    this.a(e);
    this.c(e);
  }
  // For external errors, we don't want the listeners to be called
  onUnexpectedExternalError(e) {
    this.a(e);
  }
};
var $9 = new $8();
function setUnexpectedErrorHandler(newUnexpectedErrorHandler) {
  $9.setUnexpectedErrorHandler(newUnexpectedErrorHandler);
}
function $_(e) {
  $9.onUnexpectedError(e);
  return void 0;
}
function $ab(e) {
  if (!$eb(e)) {
    $9.onUnexpectedError(e);
  }
  return void 0;
}
function $bb(e) {
  if (!$eb(e)) {
    $9.onUnexpectedExternalError(e);
  }
  return void 0;
}
function $cb(error) {
  if (error instanceof Error) {
    const { name, message } = error;
    const stack = error.stacktrace || error.stack;
    return {
      $isError: true,
      name,
      message,
      stack,
      noTelemetry: $ob.isErrorNoTelemetry(error)
    };
  }
  return error;
}
function $db(data) {
  let error;
  if (data.noTelemetry) {
    error = new $ob();
  } else {
    error = new Error();
    error.name = data.name;
  }
  error.message = data.message;
  error.stack = data.stack;
  return error;
}
var canceledName = "Canceled";
function $eb(error) {
  if (error instanceof $fb) {
    return true;
  }
  return error instanceof Error && error.name === canceledName && error.message === canceledName;
}
var $fb = class extends Error {
  constructor() {
    super(canceledName);
    this.name = this.message;
  }
};
function $gb() {
  const error = new Error(canceledName);
  error.name = error.message;
  return error;
}
function $hb(name) {
  if (name) {
    return new Error(`Illegal argument: ${name}`);
  } else {
    return new Error("Illegal argument");
  }
}
function $ib(name) {
  if (name) {
    return new Error(`Illegal state: ${name}`);
  } else {
    return new Error("Illegal state");
  }
}
function $kb(err) {
  if (!err) {
    return "Error";
  }
  if (err.message) {
    return err.message;
  }
  if (err.stack) {
    return err.stack.split("\n")[0];
  }
  return String(err);
}
var $mb = class extends Error {
  constructor(message) {
    super("NotSupported");
    if (message) {
      this.message = message;
    }
  }
};
var $ob = class _$ob extends Error {
  constructor(msg) {
    super(msg);
    this.name = "CodeExpectedError";
  }
  static fromError(err) {
    if (err instanceof _$ob) {
      return err;
    }
    const result = new _$ob();
    result.message = err.message;
    result.stack = err.stack;
    return result;
  }
  static isErrorNoTelemetry(err) {
    return err.name === "CodeExpectedError";
  }
};
var $pb = class _$pb extends Error {
  constructor(message) {
    super(message || "An unexpected bug occurred.");
    Object.setPrototypeOf(this, _$pb.prototype);
  }
};

// out-build/vs/base/common/functional.js
function $qb(fn, fnDidRunCallback) {
  const _this = this;
  let didCall = false;
  let result;
  return function() {
    if (didCall) {
      return result;
    }
    didCall = true;
    if (fnDidRunCallback) {
      try {
        result = fn.apply(_this, arguments);
      } finally {
        fnDidRunCallback();
      }
    } else {
      result = fn.apply(_this, arguments);
    }
    return result;
  };
}

// out-build/vs/base/common/arraysFind.js
function $rb(array2, predicate) {
  const idx = $sb(array2, predicate);
  if (idx === -1) {
    return void 0;
  }
  return array2[idx];
}
function $sb(array2, predicate, fromIndex = array2.length - 1) {
  for (let i = fromIndex; i >= 0; i--) {
    const element = array2[i];
    if (predicate(element)) {
      return i;
    }
  }
  return -1;
}
function $tb(array2, predicate) {
  const idx = $ub(array2, predicate);
  return idx === -1 ? void 0 : array2[idx];
}
function $ub(array2, predicate, startIdx = 0, endIdxEx = array2.length) {
  let i = startIdx;
  let j = endIdxEx;
  while (i < j) {
    const k = Math.floor((i + j) / 2);
    if (predicate(array2[k])) {
      i = k + 1;
    } else {
      j = k;
    }
  }
  return i - 1;
}
function $vb(array2, predicate) {
  const idx = $wb(array2, predicate);
  return idx === array2.length ? void 0 : array2[idx];
}
function $wb(array2, predicate, startIdx = 0, endIdxEx = array2.length) {
  let i = startIdx;
  let j = endIdxEx;
  while (i < j) {
    const k = Math.floor((i + j) / 2);
    if (predicate(array2[k])) {
      j = k;
    } else {
      i = k + 1;
    }
  }
  return i;
}
var $yb = class _$yb {
  static {
    this.assertInvariants = false;
  }
  constructor(e) {
    this.e = e;
    this.c = 0;
  }
  /**
   * The predicate must be monotonous, i.e. `arr.map(predicate)` must be like `[true, ..., true, false, ..., false]`!
   * For subsequent calls, current predicate must be weaker than (or equal to) the previous predicate, i.e. more entries must be `true`.
   */
  findLastMonotonous(predicate) {
    if (_$yb.assertInvariants) {
      if (this.d) {
        for (const item of this.e) {
          if (this.d(item) && !predicate(item)) {
            throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.");
          }
        }
      }
      this.d = predicate;
    }
    const idx = $ub(this.e, predicate, this.c);
    this.c = idx + 1;
    return idx === -1 ? void 0 : this.e[idx];
  }
};
function $zb(array2, comparator) {
  if (array2.length === 0) {
    return void 0;
  }
  let max = array2[0];
  for (let i = 1; i < array2.length; i++) {
    const item = array2[i];
    if (comparator(item, max) > 0) {
      max = item;
    }
  }
  return max;
}
function $Ab(array2, comparator) {
  if (array2.length === 0) {
    return void 0;
  }
  let max = array2[0];
  for (let i = 1; i < array2.length; i++) {
    const item = array2[i];
    if (comparator(item, max) >= 0) {
      max = item;
    }
  }
  return max;
}
function $Bb(array2, comparator) {
  return $zb(array2, (a, b) => -comparator(a, b));
}
function $Cb(array2, comparator) {
  if (array2.length === 0) {
    return -1;
  }
  let maxIdx = 0;
  for (let i = 1; i < array2.length; i++) {
    const item = array2[i];
    if (comparator(item, array2[maxIdx]) > 0) {
      maxIdx = i;
    }
  }
  return maxIdx;
}
function $Db(items, mapFn) {
  for (const value of items) {
    const mapped = mapFn(value);
    if (mapped !== void 0) {
      return mapped;
    }
  }
  return void 0;
}

// out-build/vs/base/common/arrays.js
function $Fb(array2, n = 0) {
  return array2[array2.length - (1 + n)];
}
function $Gb(arr) {
  if (arr.length === 0) {
    throw new Error("Invalid tail call");
  }
  return [arr.slice(0, arr.length - 1), arr[arr.length - 1]];
}
function $Hb(one, other4, itemEquals = (a, b) => a === b) {
  if (one === other4) {
    return true;
  }
  if (!one || !other4) {
    return false;
  }
  if (one.length !== other4.length) {
    return false;
  }
  for (let i = 0, len = one.length; i < len; i++) {
    if (!itemEquals(one[i], other4[i])) {
      return false;
    }
  }
  return true;
}
function $Ib(array2, index) {
  const last = array2.length - 1;
  if (index < last) {
    array2[index] = array2[last];
  }
  array2.pop();
}
function $Jb(array2, key, comparator) {
  return $Kb(array2.length, (i) => comparator(array2[i], key));
}
function $Kb(length, compareToKey) {
  let low = 0, high = length - 1;
  while (low <= high) {
    const mid = (low + high) / 2 | 0;
    const comp = compareToKey(mid);
    if (comp < 0) {
      low = mid + 1;
    } else if (comp > 0) {
      high = mid - 1;
    } else {
      return mid;
    }
  }
  return -(low + 1);
}
function $Lb(nth, data, compare5) {
  nth = nth | 0;
  if (nth >= data.length) {
    throw new TypeError("invalid index");
  }
  const pivotValue = data[Math.floor(data.length * Math.random())];
  const lower = [];
  const higher = [];
  const pivots = [];
  for (const value of data) {
    const val = compare5(value, pivotValue);
    if (val < 0) {
      lower.push(value);
    } else if (val > 0) {
      higher.push(value);
    } else {
      pivots.push(value);
    }
  }
  if (nth < lower.length) {
    return $Lb(nth, lower, compare5);
  } else if (nth < lower.length + pivots.length) {
    return pivots[0];
  } else {
    return $Lb(nth - (lower.length + pivots.length), higher, compare5);
  }
}
function $Mb(data, compare5) {
  const result = [];
  let currentGroup = void 0;
  for (const element of data.slice(0).sort(compare5)) {
    if (!currentGroup || compare5(currentGroup[0], element) !== 0) {
      currentGroup = [element];
      result.push(currentGroup);
    } else {
      currentGroup.push(element);
    }
  }
  return result;
}
function* $Nb(items, shouldBeGrouped) {
  let currentGroup;
  let last;
  for (const item of items) {
    if (last !== void 0 && shouldBeGrouped(last, item)) {
      currentGroup.push(item);
    } else {
      if (currentGroup) {
        yield currentGroup;
      }
      currentGroup = [item];
    }
    last = item;
  }
  if (currentGroup) {
    yield currentGroup;
  }
}
function $Ob(arr, f) {
  for (let i = 0; i <= arr.length; i++) {
    f(i === 0 ? void 0 : arr[i - 1], i === arr.length ? void 0 : arr[i]);
  }
}
function $Pb(arr, f) {
  for (let i = 0; i < arr.length; i++) {
    f(i === 0 ? void 0 : arr[i - 1], arr[i], i + 1 === arr.length ? void 0 : arr[i + 1]);
  }
}
function $Qb(before, after, compare5) {
  const result = [];
  function pushSplice(start, deleteCount, toInsert) {
    if (deleteCount === 0 && toInsert.length === 0) {
      return;
    }
    const latest = result[result.length - 1];
    if (latest && latest.start + latest.deleteCount === start) {
      latest.deleteCount += deleteCount;
      latest.toInsert.push(...toInsert);
    } else {
      result.push({ start, deleteCount, toInsert });
    }
  }
  let beforeIdx = 0;
  let afterIdx = 0;
  while (true) {
    if (beforeIdx === before.length) {
      pushSplice(beforeIdx, 0, after.slice(afterIdx));
      break;
    }
    if (afterIdx === after.length) {
      pushSplice(beforeIdx, before.length - beforeIdx, []);
      break;
    }
    const beforeElement = before[beforeIdx];
    const afterElement = after[afterIdx];
    const n = compare5(beforeElement, afterElement);
    if (n === 0) {
      beforeIdx += 1;
      afterIdx += 1;
    } else if (n < 0) {
      pushSplice(beforeIdx, 1, []);
      beforeIdx += 1;
    } else if (n > 0) {
      pushSplice(beforeIdx, 0, [afterElement]);
      afterIdx += 1;
    }
  }
  return result;
}
function $Rb(before, after, compare5) {
  const splices = $Qb(before, after, compare5);
  const removed = [];
  const added = [];
  for (const splice2 of splices) {
    removed.push(...before.slice(splice2.start, splice2.start + splice2.deleteCount));
    added.push(...splice2.toInsert);
  }
  return { removed, added };
}
function top(array2, compare5, n) {
  if (n === 0) {
    return [];
  }
  const result = array2.slice(0, n).sort(compare5);
  topStep(array2, compare5, result, n, array2.length);
  return result;
}
function topStep(array2, compare5, result, i, m) {
  for (const n = result.length; i < m; i++) {
    const element = array2[i];
    if (compare5(element, result[n - 1]) < 0) {
      result.pop();
      const j = $wb(result, (e) => compare5(element, e) < 0);
      result.splice(j, 0, element);
    }
  }
}
function $Ub(array2) {
  return array2.filter((e) => !!e);
}
function $Vb(array2) {
  let to = 0;
  for (let i = 0; i < array2.length; i++) {
    if (!!array2[i]) {
      array2[to] = array2[i];
      to += 1;
    }
  }
  array2.length = to;
}
function $Wb(array2, from, to) {
  array2.splice(to, 0, array2.splice(from, 1)[0]);
}
function $Xb(obj) {
  return !Array.isArray(obj) || obj.length === 0;
}
function $Yb(obj) {
  return Array.isArray(obj) && obj.length > 0;
}
function $Zb(array2, keyFn = (value) => value) {
  const seen = /* @__PURE__ */ new Set();
  return array2.filter((element) => {
    const key = keyFn(element);
    if (seen.has(key)) {
      return false;
    }
    seen.add(key);
    return true;
  });
}
function $1b(keyFn) {
  const seen = /* @__PURE__ */ new Set();
  return (element) => {
    const key = keyFn(element);
    if (seen.has(key)) {
      return false;
    }
    seen.add(key);
    return true;
  };
}
function $2b(one, other4, equals2 = (a, b) => a === b) {
  let result = 0;
  for (let i = 0, len = Math.min(one.length, other4.length); i < len && equals2(one[i], other4[i]); i++) {
    result++;
  }
  return result;
}
function $3b(arg, to) {
  let from = typeof to === "number" ? arg : 0;
  if (typeof to === "number") {
    from = arg;
  } else {
    from = 0;
    to = arg;
  }
  const result = [];
  if (from <= to) {
    for (let i = from; i < to; i++) {
      result.push(i);
    }
  } else {
    for (let i = from; i > to; i--) {
      result.push(i);
    }
  }
  return result;
}
function $4b(array2, indexer, mapper) {
  return array2.reduce((r2, t) => {
    r2[indexer(t)] = mapper ? mapper(t) : t;
    return r2;
  }, /* @__PURE__ */ Object.create(null));
}
function $5b(array2, element) {
  array2.push(element);
  return () => $6b(array2, element);
}
function $6b(array2, element) {
  const index = array2.indexOf(element);
  if (index > -1) {
    array2.splice(index, 1);
    return element;
  }
  return void 0;
}
function $7b(target, insertIndex, insertArr) {
  const before = target.slice(0, insertIndex);
  const after = target.slice(insertIndex);
  return before.concat(insertArr, after);
}
function $8b(array2, _seed) {
  let rand;
  if (typeof _seed === "number") {
    let seed = _seed;
    rand = () => {
      const x = Math.sin(seed++) * 179426549;
      return x - Math.floor(x);
    };
  } else {
    rand = Math.random;
  }
  for (let i = array2.length - 1; i > 0; i -= 1) {
    const j = Math.floor(rand() * (i + 1));
    const temp = array2[i];
    array2[i] = array2[j];
    array2[j] = temp;
  }
}
function $9b(arr, value) {
  const index = arr.indexOf(value);
  if (index > -1) {
    arr.splice(index, 1);
    arr.unshift(value);
  }
}
function $0b(arr, value) {
  const index = arr.indexOf(value);
  if (index > -1) {
    arr.splice(index, 1);
    arr.push(value);
  }
}
function $$b(arr, items) {
  for (const item of items) {
    arr.push(item);
  }
}
function $_b(items, fn) {
  return Array.isArray(items) ? items.map(fn) : fn(items);
}
function $ac(x) {
  return Array.isArray(x) ? x : [x];
}
function $cc(array2, start, newItems) {
  const startIdx = getActualStartIndex(array2, start);
  const originalLength = array2.length;
  const newItemsLength = newItems.length;
  array2.length = originalLength + newItemsLength;
  for (let i = originalLength - 1; i >= startIdx; i--) {
    array2[i + newItemsLength] = array2[i];
  }
  for (let i = 0; i < newItemsLength; i++) {
    array2[i + startIdx] = newItems[i];
  }
}
function $dc(array2, start, deleteCount, newItems) {
  const index = getActualStartIndex(array2, start);
  let result = array2.splice(index, deleteCount);
  if (result === void 0) {
    result = [];
  }
  $cc(array2, index, newItems);
  return result;
}
function getActualStartIndex(array2, start) {
  return start < 0 ? Math.max(start + array2.length, 0) : Math.min(start, array2.length);
}
var CompareResult;
(function(CompareResult2) {
  function isLessThan(result) {
    return result < 0;
  }
  CompareResult2.isLessThan = isLessThan;
  function isLessThanOrEqual(result) {
    return result <= 0;
  }
  CompareResult2.isLessThanOrEqual = isLessThanOrEqual;
  function isGreaterThan(result) {
    return result > 0;
  }
  CompareResult2.isGreaterThan = isGreaterThan;
  function isNeitherLessOrGreaterThan(result) {
    return result === 0;
  }
  CompareResult2.isNeitherLessOrGreaterThan = isNeitherLessOrGreaterThan;
  CompareResult2.greaterThan = 1;
  CompareResult2.lessThan = -1;
  CompareResult2.neitherLessOrGreaterThan = 0;
})(CompareResult || (CompareResult = {}));
function $ec(selector, comparator) {
  return (a, b) => comparator(selector(a), selector(b));
}
function $fc(...comparators) {
  return (item1, item2) => {
    for (const comparator of comparators) {
      const result = comparator(item1, item2);
      if (!CompareResult.isNeitherLessOrGreaterThan(result)) {
        return result;
      }
    }
    return CompareResult.neitherLessOrGreaterThan;
  };
}
var $gc = (a, b) => a - b;
var $hc = (a, b) => $gc(a ? 1 : 0, b ? 1 : 0);
function $ic(comparator) {
  return (a, b) => -comparator(a, b);
}
var $jc = class {
  /**
   * Constructs a queue that is backed by the given array. Runtime is O(1).
  */
  constructor(g) {
    this.g = g;
    this.c = 0;
    this.d = this.g.length - 1;
  }
  get length() {
    return this.d - this.c + 1;
  }
  /**
   * Consumes elements from the beginning of the queue as long as the predicate returns true.
   * If no elements were consumed, `null` is returned. Has a runtime of O(result.length).
  */
  takeWhile(predicate) {
    let startIdx = this.c;
    while (startIdx < this.g.length && predicate(this.g[startIdx])) {
      startIdx++;
    }
    const result = startIdx === this.c ? null : this.g.slice(this.c, startIdx);
    this.c = startIdx;
    return result;
  }
  /**
   * Consumes elements from the end of the queue as long as the predicate returns true.
   * If no elements were consumed, `null` is returned.
   * The result has the same order as the underlying array!
  */
  takeFromEndWhile(predicate) {
    let endIdx = this.d;
    while (endIdx >= 0 && predicate(this.g[endIdx])) {
      endIdx--;
    }
    const result = endIdx === this.d ? null : this.g.slice(endIdx + 1, this.d + 1);
    this.d = endIdx;
    return result;
  }
  peek() {
    if (this.length === 0) {
      return void 0;
    }
    return this.g[this.c];
  }
  peekLast() {
    if (this.length === 0) {
      return void 0;
    }
    return this.g[this.d];
  }
  dequeue() {
    const result = this.g[this.c];
    this.c++;
    return result;
  }
  removeLast() {
    const result = this.g[this.d];
    this.d--;
    return result;
  }
  takeCount(count) {
    const result = this.g.slice(this.c, this.c + count);
    this.c += count;
    return result;
  }
};
var $kc = class _$kc {
  static {
    this.empty = new _$kc((_callback) => {
    });
  }
  constructor(iterate) {
    this.iterate = iterate;
  }
  forEach(handler) {
    this.iterate((item) => {
      handler(item);
      return true;
    });
  }
  toArray() {
    const result = [];
    this.iterate((item) => {
      result.push(item);
      return true;
    });
    return result;
  }
  filter(predicate) {
    return new _$kc((cb) => this.iterate((item) => predicate(item) ? cb(item) : true));
  }
  map(mapFn) {
    return new _$kc((cb) => this.iterate((item) => cb(mapFn(item))));
  }
  some(predicate) {
    let result = false;
    this.iterate((item) => {
      result = predicate(item);
      return !result;
    });
    return result;
  }
  findFirst(predicate) {
    let result;
    this.iterate((item) => {
      if (predicate(item)) {
        result = item;
        return false;
      }
      return true;
    });
    return result;
  }
  findLast(predicate) {
    let result;
    this.iterate((item) => {
      if (predicate(item)) {
        result = item;
      }
      return true;
    });
    return result;
  }
  findLastMaxBy(comparator) {
    let result;
    let first = true;
    this.iterate((item) => {
      if (first || CompareResult.isGreaterThan(comparator(item, result))) {
        first = false;
        result = item;
      }
      return true;
    });
    return result;
  }
};
var $lc = class _$lc {
  constructor(c) {
    this.c = c;
  }
  /**
   * Returns a permutation that sorts the given array according to the given compare function.
   */
  static createSortPermutation(arr, compareFn) {
    const sortIndices = Array.from(arr.keys()).sort((index1, index2) => compareFn(arr[index1], arr[index2]));
    return new _$lc(sortIndices);
  }
  /**
   * Returns a new array with the elements of the given array re-arranged according to this permutation.
   */
  apply(arr) {
    return arr.map((_, index) => arr[this.c[index]]);
  }
  /**
   * Returns a new permutation that undoes the re-arrangement of this permutation.
  */
  inverse() {
    const inverseIndexMap = this.c.slice();
    for (let i = 0; i < this.c.length; i++) {
      inverseIndexMap[this.c[i]] = i;
    }
    return new _$lc(inverseIndexMap);
  }
};
async function $mc(array2, predicate) {
  const results = await Promise.all(array2.map(async (element, index) => ({ element, ok: await predicate(element, index) })));
  return results.find((r2) => r2.ok)?.element;
}

// out-build/vs/base/common/map.js
var _a2;
var _b;
var _c;
function $Jc(map, key, value) {
  let result = map.get(key);
  if (result === void 0) {
    result = value;
    map.set(key, result);
  }
  return result;
}
var ResourceMapEntry = class {
  constructor(uri, value) {
    this.uri = uri;
    this.value = value;
  }
};
function isEntries(arg) {
  return Array.isArray(arg);
}
var $Mc = class _$Mc {
  static {
    this.c = (resource) => resource.toString();
  }
  constructor(arg, toKey2) {
    this[_a2] = "ResourceMap";
    if (arg instanceof _$Mc) {
      this.d = new Map(arg.d);
      this.e = toKey2 ?? _$Mc.c;
    } else if (isEntries(arg)) {
      this.d = /* @__PURE__ */ new Map();
      this.e = toKey2 ?? _$Mc.c;
      for (const [resource, value] of arg) {
        this.set(resource, value);
      }
    } else {
      this.d = /* @__PURE__ */ new Map();
      this.e = arg ?? _$Mc.c;
    }
  }
  set(resource, value) {
    this.d.set(this.e(resource), new ResourceMapEntry(resource, value));
    return this;
  }
  get(resource) {
    return this.d.get(this.e(resource))?.value;
  }
  has(resource) {
    return this.d.has(this.e(resource));
  }
  get size() {
    return this.d.size;
  }
  clear() {
    this.d.clear();
  }
  delete(resource) {
    return this.d.delete(this.e(resource));
  }
  forEach(clb, thisArg) {
    if (typeof thisArg !== "undefined") {
      clb = clb.bind(thisArg);
    }
    for (const [_, entry] of this.d) {
      clb(entry.value, entry.uri, this);
    }
  }
  *values() {
    for (const entry of this.d.values()) {
      yield entry.value;
    }
  }
  *keys() {
    for (const entry of this.d.values()) {
      yield entry.uri;
    }
  }
  *entries() {
    for (const entry of this.d.values()) {
      yield [entry.uri, entry.value];
    }
  }
  *[(_a2 = Symbol.toStringTag, Symbol.iterator)]() {
    for (const [, entry] of this.d) {
      yield [entry.uri, entry.value];
    }
  }
};
var $Nc = class {
  constructor(entriesOrKey, toKey2) {
    this[_b] = "ResourceSet";
    if (!entriesOrKey || typeof entriesOrKey === "function") {
      this.c = new $Mc(entriesOrKey);
    } else {
      this.c = new $Mc(toKey2);
      entriesOrKey.forEach(this.add, this);
    }
  }
  get size() {
    return this.c.size;
  }
  add(value) {
    this.c.set(value, value);
    return this;
  }
  clear() {
    this.c.clear();
  }
  delete(value) {
    return this.c.delete(value);
  }
  forEach(callbackfn, thisArg) {
    this.c.forEach((_value, key) => callbackfn.call(thisArg, key, key, this));
  }
  has(value) {
    return this.c.has(value);
  }
  entries() {
    return this.c.entries();
  }
  keys() {
    return this.c.keys();
  }
  values() {
    return this.c.keys();
  }
  [(_b = Symbol.toStringTag, Symbol.iterator)]() {
    return this.keys();
  }
};
var Touch;
(function(Touch2) {
  Touch2[Touch2["None"] = 0] = "None";
  Touch2[Touch2["AsOld"] = 1] = "AsOld";
  Touch2[Touch2["AsNew"] = 2] = "AsNew";
})(Touch || (Touch = {}));
var $Oc = class {
  constructor() {
    this[_c] = "LinkedMap";
    this.c = /* @__PURE__ */ new Map();
    this.d = void 0;
    this.e = void 0;
    this.f = 0;
    this.g = 0;
  }
  clear() {
    this.c.clear();
    this.d = void 0;
    this.e = void 0;
    this.f = 0;
    this.g++;
  }
  isEmpty() {
    return !this.d && !this.e;
  }
  get size() {
    return this.f;
  }
  get first() {
    return this.d?.value;
  }
  get last() {
    return this.e?.value;
  }
  has(key) {
    return this.c.has(key);
  }
  get(key, touch = 0) {
    const item = this.c.get(key);
    if (!item) {
      return void 0;
    }
    if (touch !== 0) {
      this.m(item, touch);
    }
    return item.value;
  }
  set(key, value, touch = 0) {
    let item = this.c.get(key);
    if (item) {
      item.value = value;
      if (touch !== 0) {
        this.m(item, touch);
      }
    } else {
      item = { key, value, next: void 0, previous: void 0 };
      switch (touch) {
        case 0:
          this.k(item);
          break;
        case 1:
          this.j(item);
          break;
        case 2:
          this.k(item);
          break;
        default:
          this.k(item);
          break;
      }
      this.c.set(key, item);
      this.f++;
    }
    return this;
  }
  delete(key) {
    return !!this.remove(key);
  }
  remove(key) {
    const item = this.c.get(key);
    if (!item) {
      return void 0;
    }
    this.c.delete(key);
    this.l(item);
    this.f--;
    return item.value;
  }
  shift() {
    if (!this.d && !this.e) {
      return void 0;
    }
    if (!this.d || !this.e) {
      throw new Error("Invalid list");
    }
    const item = this.d;
    this.c.delete(item.key);
    this.l(item);
    this.f--;
    return item.value;
  }
  forEach(callbackfn, thisArg) {
    const state = this.g;
    let current = this.d;
    while (current) {
      if (thisArg) {
        callbackfn.bind(thisArg)(current.value, current.key, this);
      } else {
        callbackfn(current.value, current.key, this);
      }
      if (this.g !== state) {
        throw new Error(`LinkedMap got modified during iteration.`);
      }
      current = current.next;
    }
  }
  keys() {
    const map = this;
    const state = this.g;
    let current = this.d;
    const iterator = {
      [Symbol.iterator]() {
        return iterator;
      },
      next() {
        if (map.g !== state) {
          throw new Error(`LinkedMap got modified during iteration.`);
        }
        if (current) {
          const result = { value: current.key, done: false };
          current = current.next;
          return result;
        } else {
          return { value: void 0, done: true };
        }
      }
    };
    return iterator;
  }
  values() {
    const map = this;
    const state = this.g;
    let current = this.d;
    const iterator = {
      [Symbol.iterator]() {
        return iterator;
      },
      next() {
        if (map.g !== state) {
          throw new Error(`LinkedMap got modified during iteration.`);
        }
        if (current) {
          const result = { value: current.value, done: false };
          current = current.next;
          return result;
        } else {
          return { value: void 0, done: true };
        }
      }
    };
    return iterator;
  }
  entries() {
    const map = this;
    const state = this.g;
    let current = this.d;
    const iterator = {
      [Symbol.iterator]() {
        return iterator;
      },
      next() {
        if (map.g !== state) {
          throw new Error(`LinkedMap got modified during iteration.`);
        }
        if (current) {
          const result = { value: [current.key, current.value], done: false };
          current = current.next;
          return result;
        } else {
          return { value: void 0, done: true };
        }
      }
    };
    return iterator;
  }
  [(_c = Symbol.toStringTag, Symbol.iterator)]() {
    return this.entries();
  }
  h(newSize) {
    if (newSize >= this.size) {
      return;
    }
    if (newSize === 0) {
      this.clear();
      return;
    }
    let current = this.d;
    let currentSize = this.size;
    while (current && currentSize > newSize) {
      this.c.delete(current.key);
      current = current.next;
      currentSize--;
    }
    this.d = current;
    this.f = currentSize;
    if (current) {
      current.previous = void 0;
    }
    this.g++;
  }
  i(newSize) {
    if (newSize >= this.size) {
      return;
    }
    if (newSize === 0) {
      this.clear();
      return;
    }
    let current = this.e;
    let currentSize = this.size;
    while (current && currentSize > newSize) {
      this.c.delete(current.key);
      current = current.previous;
      currentSize--;
    }
    this.e = current;
    this.f = currentSize;
    if (current) {
      current.next = void 0;
    }
    this.g++;
  }
  j(item) {
    if (!this.d && !this.e) {
      this.e = item;
    } else if (!this.d) {
      throw new Error("Invalid list");
    } else {
      item.next = this.d;
      this.d.previous = item;
    }
    this.d = item;
    this.g++;
  }
  k(item) {
    if (!this.d && !this.e) {
      this.d = item;
    } else if (!this.e) {
      throw new Error("Invalid list");
    } else {
      item.previous = this.e;
      this.e.next = item;
    }
    this.e = item;
    this.g++;
  }
  l(item) {
    if (item === this.d && item === this.e) {
      this.d = void 0;
      this.e = void 0;
    } else if (item === this.d) {
      if (!item.next) {
        throw new Error("Invalid list");
      }
      item.next.previous = void 0;
      this.d = item.next;
    } else if (item === this.e) {
      if (!item.previous) {
        throw new Error("Invalid list");
      }
      item.previous.next = void 0;
      this.e = item.previous;
    } else {
      const next = item.next;
      const previous = item.previous;
      if (!next || !previous) {
        throw new Error("Invalid list");
      }
      next.previous = previous;
      previous.next = next;
    }
    item.next = void 0;
    item.previous = void 0;
    this.g++;
  }
  m(item, touch) {
    if (!this.d || !this.e) {
      throw new Error("Invalid list");
    }
    if (touch !== 1 && touch !== 2) {
      return;
    }
    if (touch === 1) {
      if (item === this.d) {
        return;
      }
      const next = item.next;
      const previous = item.previous;
      if (item === this.e) {
        previous.next = void 0;
        this.e = previous;
      } else {
        next.previous = previous;
        previous.next = next;
      }
      item.previous = void 0;
      item.next = this.d;
      this.d.previous = item;
      this.d = item;
      this.g++;
    } else if (touch === 2) {
      if (item === this.e) {
        return;
      }
      const next = item.next;
      const previous = item.previous;
      if (item === this.d) {
        next.previous = void 0;
        this.d = next;
      } else {
        next.previous = previous;
        previous.next = next;
      }
      item.next = void 0;
      item.previous = this.e;
      this.e.next = item;
      this.e = item;
      this.g++;
    }
  }
  toJSON() {
    const data = [];
    this.forEach((value, key) => {
      data.push([key, value]);
    });
    return data;
  }
  fromJSON(data) {
    this.clear();
    for (const [key, value] of data) {
      this.set(key, value);
    }
  }
};
var Cache = class extends $Oc {
  constructor(limit, ratio = 1) {
    super();
    this.n = limit;
    this.o = Math.min(Math.max(0, ratio), 1);
  }
  get limit() {
    return this.n;
  }
  set limit(limit) {
    this.n = limit;
    this.p();
  }
  get ratio() {
    return this.o;
  }
  set ratio(ratio) {
    this.o = Math.min(Math.max(0, ratio), 1);
    this.p();
  }
  get(key, touch = 2) {
    return super.get(key, touch);
  }
  peek(key) {
    return super.get(
      key,
      0
      /* Touch.None */
    );
  }
  set(key, value) {
    super.set(
      key,
      value,
      2
      /* Touch.AsNew */
    );
    return this;
  }
  p() {
    if (this.size > this.n) {
      this.q(Math.round(this.n * this.o));
    }
  }
};
var $Pc = class extends Cache {
  constructor(limit, ratio = 1) {
    super(limit, ratio);
  }
  q(newSize) {
    this.h(newSize);
  }
  set(key, value) {
    super.set(key, value);
    this.p();
    return this;
  }
};
var $Qc = class extends Cache {
  constructor(limit, ratio = 1) {
    super(limit, ratio);
  }
  q(newSize) {
    this.i(newSize);
  }
  set(key, value) {
    if (this.n <= this.size && !this.has(key)) {
      this.q(Math.round(this.n * this.o) - 1);
    }
    super.set(key, value);
    return this;
  }
};
var $Rc = class {
  constructor() {
    this.c = /* @__PURE__ */ new Map();
  }
  add(value) {
    this.c.set(value, (this.c.get(value) || 0) + 1);
    return this;
  }
  delete(value) {
    let counter = this.c.get(value) || 0;
    if (counter === 0) {
      return false;
    }
    counter--;
    if (counter === 0) {
      this.c.delete(value);
    } else {
      this.c.set(value, counter);
    }
    return true;
  }
  has(value) {
    return this.c.has(value);
  }
};
var $Sc = class {
  constructor(entries2) {
    this.c = /* @__PURE__ */ new Map();
    this.d = /* @__PURE__ */ new Map();
    if (entries2) {
      for (const [key, value] of entries2) {
        this.set(key, value);
      }
    }
  }
  clear() {
    this.c.clear();
    this.d.clear();
  }
  set(key, value) {
    this.c.set(key, value);
    this.d.set(value, key);
  }
  get(key) {
    return this.c.get(key);
  }
  getKey(value) {
    return this.d.get(value);
  }
  delete(key) {
    const value = this.c.get(key);
    if (value === void 0) {
      return false;
    }
    this.c.delete(key);
    this.d.delete(value);
    return true;
  }
  forEach(callbackfn, thisArg) {
    this.c.forEach((value, key) => {
      callbackfn.call(thisArg, value, key, this);
    });
  }
  keys() {
    return this.c.keys();
  }
  values() {
    return this.c.values();
  }
};
var $Tc = class {
  constructor() {
    this.c = /* @__PURE__ */ new Map();
  }
  add(key, value) {
    let values = this.c.get(key);
    if (!values) {
      values = /* @__PURE__ */ new Set();
      this.c.set(key, values);
    }
    values.add(value);
  }
  delete(key, value) {
    const values = this.c.get(key);
    if (!values) {
      return;
    }
    values.delete(value);
    if (values.size === 0) {
      this.c.delete(key);
    }
  }
  forEach(key, fn) {
    const values = this.c.get(key);
    if (!values) {
      return;
    }
    values.forEach(fn);
  }
  get(key) {
    const values = this.c.get(key);
    if (!values) {
      return /* @__PURE__ */ new Set();
    }
    return values;
  }
};
function $Uc(a, b) {
  if (a === b) {
    return true;
  }
  if (a.size !== b.size) {
    return false;
  }
  for (const [key, value] of a) {
    if (!b.has(key) || b.get(key) !== value) {
      return false;
    }
  }
  for (const [key] of b) {
    if (!a.has(key)) {
      return false;
    }
  }
  return true;
}
var $Vc = class {
  constructor() {
    this.c = {};
  }
  set(first, second, value) {
    if (!this.c[first]) {
      this.c[first] = {};
    }
    this.c[first][second] = value;
  }
  get(first, second) {
    return this.c[first]?.[second];
  }
  clear() {
    this.c = {};
  }
  *values() {
    for (const first in this.c) {
      for (const second in this.c[first]) {
        const value = this.c[first][second];
        if (value) {
          yield value;
        }
      }
    }
  }
};
var $Wc = class {
  constructor() {
    this.c = {};
  }
  set(first, second, third, value) {
    if (!this.c[first]) {
      this.c[first] = new $Vc();
    }
    this.c[first].set(second, third, value);
  }
  get(first, second, third) {
    return this.c[first]?.get(second, third);
  }
  clear() {
    this.c = {};
  }
  *values() {
    for (const first in this.c) {
      for (const value of this.c[first].values()) {
        if (value) {
          yield value;
        }
      }
    }
  }
};

// out-build/vs/base/common/iterator.js
var Iterable;
(function(Iterable2) {
  function is(thing) {
    return thing && typeof thing === "object" && typeof thing[Symbol.iterator] === "function";
  }
  Iterable2.is = is;
  const _empty2 = Object.freeze([]);
  function empty() {
    return _empty2;
  }
  Iterable2.empty = empty;
  function* single(element) {
    yield element;
  }
  Iterable2.single = single;
  function wrap(iterableOrElement) {
    if (is(iterableOrElement)) {
      return iterableOrElement;
    } else {
      return single(iterableOrElement);
    }
  }
  Iterable2.wrap = wrap;
  function from(iterable) {
    return iterable || _empty2;
  }
  Iterable2.from = from;
  function* reverse(array2) {
    for (let i = array2.length - 1; i >= 0; i--) {
      yield array2[i];
    }
  }
  Iterable2.reverse = reverse;
  function isEmpty(iterable) {
    return !iterable || iterable[Symbol.iterator]().next().done === true;
  }
  Iterable2.isEmpty = isEmpty;
  function first(iterable) {
    return iterable[Symbol.iterator]().next().value;
  }
  Iterable2.first = first;
  function some(iterable, predicate) {
    let i = 0;
    for (const element of iterable) {
      if (predicate(element, i++)) {
        return true;
      }
    }
    return false;
  }
  Iterable2.some = some;
  function find2(iterable, predicate) {
    for (const element of iterable) {
      if (predicate(element)) {
        return element;
      }
    }
    return void 0;
  }
  Iterable2.find = find2;
  function* filter(iterable, predicate) {
    for (const element of iterable) {
      if (predicate(element)) {
        yield element;
      }
    }
  }
  Iterable2.filter = filter;
  function* map(iterable, fn) {
    let index = 0;
    for (const element of iterable) {
      yield fn(element, index++);
    }
  }
  Iterable2.map = map;
  function* flatMap(iterable, fn) {
    let index = 0;
    for (const element of iterable) {
      yield* fn(element, index++);
    }
  }
  Iterable2.flatMap = flatMap;
  function* concat3(...iterables) {
    for (const iterable of iterables) {
      yield* iterable;
    }
  }
  Iterable2.concat = concat3;
  function reduce(iterable, reducer, initialValue) {
    let value = initialValue;
    for (const element of iterable) {
      value = reducer(value, element);
    }
    return value;
  }
  Iterable2.reduce = reduce;
  function* slice(arr, from2, to = arr.length) {
    if (from2 < 0) {
      from2 += arr.length;
    }
    if (to < 0) {
      to += arr.length;
    } else if (to > arr.length) {
      to = arr.length;
    }
    for (; from2 < to; from2++) {
      yield arr[from2];
    }
  }
  Iterable2.slice = slice;
  function consume(iterable, atMost = Number.POSITIVE_INFINITY) {
    const consumed = [];
    if (atMost === 0) {
      return [consumed, iterable];
    }
    const iterator = iterable[Symbol.iterator]();
    for (let i = 0; i < atMost; i++) {
      const next = iterator.next();
      if (next.done) {
        return [consumed, Iterable2.empty()];
      }
      consumed.push(next.value);
    }
    return [consumed, { [Symbol.iterator]() {
      return iterator;
    } }];
  }
  Iterable2.consume = consume;
  async function asyncToArray(iterable) {
    const result = [];
    for await (const item of iterable) {
      result.push(item);
    }
    return Promise.resolve(result);
  }
  Iterable2.asyncToArray = asyncToArray;
})(Iterable || (Iterable = {}));

// out-build/vs/base/common/lifecycle.js
var TRACK_DISPOSABLES = false;
var disposableTracker = null;
var $Yc = class _$Yc {
  constructor() {
    this.b = /* @__PURE__ */ new Map();
  }
  static {
    this.a = 0;
  }
  c(d) {
    let val = this.b.get(d);
    if (!val) {
      val = { parent: null, source: null, isSingleton: false, value: d, idx: _$Yc.a++ };
      this.b.set(d, val);
    }
    return val;
  }
  trackDisposable(d) {
    const data = this.c(d);
    if (!data.source) {
      data.source = new Error().stack;
    }
  }
  setParent(child, parent) {
    const data = this.c(child);
    data.parent = parent;
  }
  markAsDisposed(x) {
    this.b.delete(x);
  }
  markAsSingleton(disposable) {
    this.c(disposable).isSingleton = true;
  }
  f(data, cache2) {
    const cacheValue = cache2.get(data);
    if (cacheValue) {
      return cacheValue;
    }
    const result = data.parent ? this.f(this.c(data.parent), cache2) : data;
    cache2.set(data, result);
    return result;
  }
  getTrackedDisposables() {
    const rootParentCache = /* @__PURE__ */ new Map();
    const leaking = [...this.b.entries()].filter(([, v]) => v.source !== null && !this.f(v, rootParentCache).isSingleton).flatMap(([k]) => k);
    return leaking;
  }
  computeLeakingDisposables(maxReported = 10, preComputedLeaks) {
    let uncoveredLeakingObjs;
    if (preComputedLeaks) {
      uncoveredLeakingObjs = preComputedLeaks;
    } else {
      const rootParentCache = /* @__PURE__ */ new Map();
      const leakingObjects = [...this.b.values()].filter((info) => info.source !== null && !this.f(info, rootParentCache).isSingleton);
      if (leakingObjects.length === 0) {
        return;
      }
      const leakingObjsSet = new Set(leakingObjects.map((o) => o.value));
      uncoveredLeakingObjs = leakingObjects.filter((l) => {
        return !(l.parent && leakingObjsSet.has(l.parent));
      });
      if (uncoveredLeakingObjs.length === 0) {
        throw new Error("There are cyclic diposable chains!");
      }
    }
    if (!uncoveredLeakingObjs) {
      return void 0;
    }
    function getStackTracePath(leaking) {
      function removePrefix2(array2, linesToRemove) {
        while (array2.length > 0 && linesToRemove.some((regexp) => typeof regexp === "string" ? regexp === array2[0] : array2[0].match(regexp))) {
          array2.shift();
        }
      }
      const lines = leaking.source.split("\n").map((p) => p.trim().replace("at ", "")).filter((l) => l !== "");
      removePrefix2(lines, ["Error", /^trackDisposable \(.*\)$/, /^DisposableTracker.trackDisposable \(.*\)$/]);
      return lines.reverse();
    }
    const stackTraceStarts = new $Tc();
    for (const leaking of uncoveredLeakingObjs) {
      const stackTracePath = getStackTracePath(leaking);
      for (let i2 = 0; i2 <= stackTracePath.length; i2++) {
        stackTraceStarts.add(stackTracePath.slice(0, i2).join("\n"), leaking);
      }
    }
    uncoveredLeakingObjs.sort($ec((l) => l.idx, $gc));
    let message = "";
    let i = 0;
    for (const leaking of uncoveredLeakingObjs.slice(0, maxReported)) {
      i++;
      const stackTracePath = getStackTracePath(leaking);
      const stackTraceFormattedLines = [];
      for (let i2 = 0; i2 < stackTracePath.length; i2++) {
        let line = stackTracePath[i2];
        const starts = stackTraceStarts.get(stackTracePath.slice(0, i2 + 1).join("\n"));
        line = `(shared with ${starts.size}/${uncoveredLeakingObjs.length} leaks) at ${line}`;
        const prevStarts = stackTraceStarts.get(stackTracePath.slice(0, i2).join("\n"));
        const continuations = $a([...prevStarts].map((d) => getStackTracePath(d)[i2]), (v) => v);
        delete continuations[stackTracePath[i2]];
        for (const [cont, set] of Object.entries(continuations)) {
          stackTraceFormattedLines.unshift(`    - stacktraces of ${set.length} other leaks continue with ${cont}`);
        }
        stackTraceFormattedLines.unshift(line);
      }
      message += `


==================== Leaking disposable ${i}/${uncoveredLeakingObjs.length}: ${leaking.value.constructor.name} ====================
${stackTraceFormattedLines.join("\n")}
============================================================

`;
    }
    if (uncoveredLeakingObjs.length > maxReported) {
      message += `


... and ${uncoveredLeakingObjs.length - maxReported} more leaking disposables

`;
    }
    return { leaks: uncoveredLeakingObjs, details: message };
  }
};
function $Zc(tracker2) {
  disposableTracker = tracker2;
}
if (TRACK_DISPOSABLES) {
  const __is_disposable_tracked__ = "__is_disposable_tracked__";
  $Zc(new class {
    trackDisposable(x) {
      const stack = new Error("Potentially leaked disposable").stack;
      setTimeout(() => {
        if (!x[__is_disposable_tracked__]) {
          console.log(stack);
        }
      }, 3e3);
    }
    setParent(child, parent) {
      if (child && child !== $0c.None) {
        try {
          child[__is_disposable_tracked__] = true;
        } catch {
        }
      }
    }
    markAsDisposed(disposable) {
      if (disposable && disposable !== $0c.None) {
        try {
          disposable[__is_disposable_tracked__] = true;
        } catch {
        }
      }
    }
    markAsSingleton(disposable) {
    }
  }());
}
function $1c(x) {
  disposableTracker?.trackDisposable(x);
  return x;
}
function $2c(disposable) {
  disposableTracker?.markAsDisposed(disposable);
}
function setParentOfDisposable(child, parent) {
  disposableTracker?.setParent(child, parent);
}
function setParentOfDisposables(children, parent) {
  if (!disposableTracker) {
    return;
  }
  for (const child of children) {
    disposableTracker.setParent(child, parent);
  }
}
function $3c(singleton) {
  disposableTracker?.markAsSingleton(singleton);
  return singleton;
}
function $4c(thing) {
  return typeof thing === "object" && thing !== null && typeof thing.dispose === "function" && thing.dispose.length === 0;
}
function $5c(arg) {
  if (Iterable.is(arg)) {
    const errors = [];
    for (const d of arg) {
      if (d) {
        try {
          d.dispose();
        } catch (e) {
          errors.push(e);
        }
      }
    }
    if (errors.length === 1) {
      throw errors[0];
    } else if (errors.length > 1) {
      throw new AggregateError(errors, "Encountered errors while disposing of store");
    }
    return Array.isArray(arg) ? [] : arg;
  } else if (arg) {
    arg.dispose();
    return arg;
  }
}
function $6c(disposables) {
  for (const d of disposables) {
    if ($4c(d)) {
      d.dispose();
    }
  }
  return [];
}
function $7c(...disposables) {
  const parent = $8c(() => $5c(disposables));
  setParentOfDisposables(disposables, parent);
  return parent;
}
function $8c(fn) {
  const self2 = $1c({
    dispose: $qb(() => {
      $2c(self2);
      fn();
    })
  });
  return self2;
}
var $9c = class _$9c {
  static {
    this.DISABLE_DISPOSED_WARNING = false;
  }
  constructor() {
    this.f = /* @__PURE__ */ new Set();
    this.g = false;
    $1c(this);
  }
  /**
   * Dispose of all registered disposables and mark this object as disposed.
   *
   * Any future disposables added to this object will be disposed of on `add`.
   */
  dispose() {
    if (this.g) {
      return;
    }
    $2c(this);
    this.g = true;
    this.clear();
  }
  /**
   * @return `true` if this object has been disposed of.
   */
  get isDisposed() {
    return this.g;
  }
  /**
   * Dispose of all registered disposables but do not mark this object as disposed.
   */
  clear() {
    if (this.f.size === 0) {
      return;
    }
    try {
      $5c(this.f);
    } finally {
      this.f.clear();
    }
  }
  /**
   * Add a new {@link IDisposable disposable} to the collection.
   */
  add(o) {
    if (!o) {
      return o;
    }
    if (o === this) {
      throw new Error("Cannot register a disposable on itself!");
    }
    setParentOfDisposable(o, this);
    if (this.g) {
      if (!_$9c.DISABLE_DISPOSED_WARNING) {
        console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack);
      }
    } else {
      this.f.add(o);
    }
    return o;
  }
  /**
   * Deletes a disposable from store and disposes of it. This will not throw or warn and proceed to dispose the
   * disposable even when the disposable is not part in the store.
   */
  delete(o) {
    if (!o) {
      return;
    }
    if (o === this) {
      throw new Error("Cannot dispose a disposable on itself!");
    }
    this.f.delete(o);
    o.dispose();
  }
  /**
   * Deletes the value from the store, but does not dispose it.
   */
  deleteAndLeak(o) {
    if (!o) {
      return;
    }
    if (this.f.has(o)) {
      this.f.delete(o);
      setParentOfDisposable(o, null);
    }
  }
};
var $0c = class {
  static {
    this.None = Object.freeze({ dispose() {
    } });
  }
  constructor() {
    this.q = new $9c();
    $1c(this);
    setParentOfDisposable(this.q, this);
  }
  dispose() {
    $2c(this);
    this.q.dispose();
  }
  /**
   * Adds `o` to the collection of disposables managed by this object.
   */
  B(o) {
    if (o === this) {
      throw new Error("Cannot register a disposable on itself!");
    }
    return this.q.add(o);
  }
};
var $$c = class {
  constructor() {
    this.b = false;
    $1c(this);
  }
  get value() {
    return this.b ? void 0 : this.a;
  }
  set value(value) {
    if (this.b || value === this.a) {
      return;
    }
    this.a?.dispose();
    if (value) {
      setParentOfDisposable(value, this);
    }
    this.a = value;
  }
  /**
   * Resets the stored value and disposed of the previously stored value.
   */
  clear() {
    this.value = void 0;
  }
  dispose() {
    this.b = true;
    $2c(this);
    this.a?.dispose();
    this.a = void 0;
  }
  /**
   * Clears the value, but does not dispose it.
   * The old value is returned.
  */
  clearAndLeak() {
    const oldValue = this.a;
    this.a = void 0;
    if (oldValue) {
      setParentOfDisposable(oldValue, null);
    }
    return oldValue;
  }
};
var $_c = class {
  constructor(initialValue) {
    this.a = new $$c();
    this.b = false;
    this.a.value = initialValue;
  }
  get value() {
    return this.a.value;
  }
  set value(value) {
    if (this.b || value === this.a.value) {
      return;
    }
    this.a.value = value;
  }
  dispose() {
    this.b = true;
    this.a.dispose();
  }
};
var $ad = class {
  constructor(b) {
    this.b = b;
    this.a = 1;
  }
  acquire() {
    this.a++;
    return this;
  }
  release() {
    if (--this.a === 0) {
      this.b.dispose();
    }
    return this;
  }
};
var $cd = class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
  }
  acquire(key, ...args2) {
    let reference = this.a.get(key);
    if (!reference) {
      reference = { counter: 0, object: this.b(key, ...args2) };
      this.a.set(key, reference);
    }
    const { object } = reference;
    const dispose = $qb(() => {
      if (--reference.counter === 0) {
        this.c(key, reference.object);
        this.a.delete(key);
      }
    });
    reference.counter++;
    return { object, dispose };
  }
};
var $dd = class {
  constructor(a) {
    this.a = a;
  }
  async acquire(key, ...args2) {
    const ref = this.a.acquire(key, ...args2);
    try {
      const object = await ref.object;
      return {
        object,
        dispose: () => ref.dispose()
      };
    } catch (error) {
      ref.dispose();
      throw error;
    }
  }
};
var $gd = class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
    this.b = false;
    $1c(this);
  }
  /**
   * Disposes of all stored values and mark this object as disposed.
   *
   * Trying to use this object after it has been disposed of is an error.
   */
  dispose() {
    $2c(this);
    this.b = true;
    this.clearAndDisposeAll();
  }
  /**
   * Disposes of all stored values and clear the map, but DO NOT mark this object as disposed.
   */
  clearAndDisposeAll() {
    if (!this.a.size) {
      return;
    }
    try {
      $5c(this.a.values());
    } finally {
      this.a.clear();
    }
  }
  has(key) {
    return this.a.has(key);
  }
  get size() {
    return this.a.size;
  }
  get(key) {
    return this.a.get(key);
  }
  set(key, value, skipDisposeOnOverwrite = false) {
    if (this.b) {
      console.warn(new Error("Trying to add a disposable to a DisposableMap that has already been disposed of. The added object will be leaked!").stack);
    }
    if (!skipDisposeOnOverwrite) {
      this.a.get(key)?.dispose();
    }
    this.a.set(key, value);
  }
  /**
   * Delete the value stored for `key` from this map and also dispose of it.
   */
  deleteAndDispose(key) {
    this.a.get(key)?.dispose();
    this.a.delete(key);
  }
  /**
   * Delete the value stored for `key` from this map but return it. The caller is
   * responsible for disposing of the value.
   */
  deleteAndLeak(key) {
    const value = this.a.get(key);
    this.a.delete(key);
    return value;
  }
  keys() {
    return this.a.keys();
  }
  values() {
    return this.a.values();
  }
  [Symbol.iterator]() {
    return this.a[Symbol.iterator]();
  }
};

// out-build/vs/base/common/linkedList.js
var Node2 = class _Node {
  static {
    this.Undefined = new _Node(void 0);
  }
  constructor(element) {
    this.element = element;
    this.next = _Node.Undefined;
    this.prev = _Node.Undefined;
  }
};
var $hd = class {
  constructor() {
    this.a = Node2.Undefined;
    this.b = Node2.Undefined;
    this.c = 0;
  }
  get size() {
    return this.c;
  }
  isEmpty() {
    return this.a === Node2.Undefined;
  }
  clear() {
    let node = this.a;
    while (node !== Node2.Undefined) {
      const next = node.next;
      node.prev = Node2.Undefined;
      node.next = Node2.Undefined;
      node = next;
    }
    this.a = Node2.Undefined;
    this.b = Node2.Undefined;
    this.c = 0;
  }
  unshift(element) {
    return this.d(element, false);
  }
  push(element) {
    return this.d(element, true);
  }
  d(element, atTheEnd) {
    const newNode = new Node2(element);
    if (this.a === Node2.Undefined) {
      this.a = newNode;
      this.b = newNode;
    } else if (atTheEnd) {
      const oldLast = this.b;
      this.b = newNode;
      newNode.prev = oldLast;
      oldLast.next = newNode;
    } else {
      const oldFirst = this.a;
      this.a = newNode;
      newNode.next = oldFirst;
      oldFirst.prev = newNode;
    }
    this.c += 1;
    let didRemove = false;
    return () => {
      if (!didRemove) {
        didRemove = true;
        this.e(newNode);
      }
    };
  }
  shift() {
    if (this.a === Node2.Undefined) {
      return void 0;
    } else {
      const res = this.a.element;
      this.e(this.a);
      return res;
    }
  }
  pop() {
    if (this.b === Node2.Undefined) {
      return void 0;
    } else {
      const res = this.b.element;
      this.e(this.b);
      return res;
    }
  }
  e(node) {
    if (node.prev !== Node2.Undefined && node.next !== Node2.Undefined) {
      const anchor = node.prev;
      anchor.next = node.next;
      node.next.prev = anchor;
    } else if (node.prev === Node2.Undefined && node.next === Node2.Undefined) {
      this.a = Node2.Undefined;
      this.b = Node2.Undefined;
    } else if (node.next === Node2.Undefined) {
      this.b = this.b.prev;
      this.b.next = Node2.Undefined;
    } else if (node.prev === Node2.Undefined) {
      this.a = this.a.next;
      this.a.prev = Node2.Undefined;
    }
    this.c -= 1;
  }
  *[Symbol.iterator]() {
    let node = this.a;
    while (node !== Node2.Undefined) {
      yield node.element;
      node = node.next;
    }
  }
};

// out-build/vs/base/common/stopwatch.js
var hasPerformanceNow = globalThis.performance && typeof globalThis.performance.now === "function";
var $xe = class _$xe {
  static create(highResolution) {
    return new _$xe(highResolution);
  }
  constructor(highResolution) {
    this.c = hasPerformanceNow && highResolution === false ? Date.now : globalThis.performance.now.bind(globalThis.performance);
    this.a = this.c();
    this.b = -1;
  }
  stop() {
    this.b = this.c();
  }
  reset() {
    this.a = this.c();
    this.b = -1;
  }
  elapsed() {
    if (this.b !== -1) {
      return this.b - this.a;
    }
    return this.c() - this.a;
  }
};

// out-build/vs/base/common/event.js
var _enableListenerGCedWarning = false;
var _enableDisposeWithListenerWarning = false;
var _enableSnapshotPotentialLeakWarning = false;
var Event2;
(function(Event3) {
  Event3.None = () => $0c.None;
  function _addLeakageTraceLogic(options3) {
    if (_enableSnapshotPotentialLeakWarning) {
      const { onDidAddListener: origListenerDidAdd } = options3;
      const stack = Stacktrace.create();
      let count = 0;
      options3.onDidAddListener = () => {
        if (++count === 2) {
          console.warn("snapshotted emitter LIKELY used public and SHOULD HAVE BEEN created with DisposableStore. snapshotted here");
          stack.print();
        }
        origListenerDidAdd?.();
      };
    }
  }
  function defer(event, disposable) {
    return debounce(event, () => void 0, 0, void 0, true, void 0, disposable);
  }
  Event3.defer = defer;
  function once(event) {
    return (listener, thisArgs = null, disposables) => {
      let didFire = false;
      let result = void 0;
      result = event((e) => {
        if (didFire) {
          return;
        } else if (result) {
          result.dispose();
        } else {
          didFire = true;
        }
        return listener.call(thisArgs, e);
      }, null, disposables);
      if (didFire) {
        result.dispose();
      }
      return result;
    };
  }
  Event3.once = once;
  function onceIf(event, condition) {
    return Event3.once(Event3.filter(event, condition));
  }
  Event3.onceIf = onceIf;
  function map(event, map2, disposable) {
    return snapshot((listener, thisArgs = null, disposables) => event((i) => listener.call(thisArgs, map2(i)), null, disposables), disposable);
  }
  Event3.map = map;
  function forEach(event, each, disposable) {
    return snapshot((listener, thisArgs = null, disposables) => event((i) => {
      each(i);
      listener.call(thisArgs, i);
    }, null, disposables), disposable);
  }
  Event3.forEach = forEach;
  function filter(event, filter2, disposable) {
    return snapshot((listener, thisArgs = null, disposables) => event((e) => filter2(e) && listener.call(thisArgs, e), null, disposables), disposable);
  }
  Event3.filter = filter;
  function signal(event) {
    return event;
  }
  Event3.signal = signal;
  function any(...events) {
    return (listener, thisArgs = null, disposables) => {
      const disposable = $7c(...events.map((event) => event((e) => listener.call(thisArgs, e))));
      return addAndReturnDisposable(disposable, disposables);
    };
  }
  Event3.any = any;
  function reduce(event, merge, initial, disposable) {
    let output = initial;
    return map(event, (e) => {
      output = merge(output, e);
      return output;
    }, disposable);
  }
  Event3.reduce = reduce;
  function snapshot(event, disposable) {
    let listener;
    const options3 = {
      onWillAddFirstListener() {
        listener = event(emitter.fire, emitter);
      },
      onDidRemoveLastListener() {
        listener?.dispose();
      }
    };
    if (!disposable) {
      _addLeakageTraceLogic(options3);
    }
    const emitter = new $De(options3);
    disposable?.add(emitter);
    return emitter.event;
  }
  function addAndReturnDisposable(d, store) {
    if (store instanceof Array) {
      store.push(d);
    } else if (store) {
      store.add(d);
    }
    return d;
  }
  function debounce(event, merge, delay = 100, leading = false, flushOnListenerRemove = false, leakWarningThreshold, disposable) {
    let subscription;
    let output = void 0;
    let handle2 = void 0;
    let numDebouncedCalls = 0;
    let doFire;
    const options3 = {
      leakWarningThreshold,
      onWillAddFirstListener() {
        subscription = event((cur) => {
          numDebouncedCalls++;
          output = merge(output, cur);
          if (leading && !handle2) {
            emitter.fire(output);
            output = void 0;
          }
          doFire = () => {
            const _output = output;
            output = void 0;
            handle2 = void 0;
            if (!leading || numDebouncedCalls > 1) {
              emitter.fire(_output);
            }
            numDebouncedCalls = 0;
          };
          if (typeof delay === "number") {
            clearTimeout(handle2);
            handle2 = setTimeout(doFire, delay);
          } else {
            if (handle2 === void 0) {
              handle2 = 0;
              queueMicrotask(doFire);
            }
          }
        });
      },
      onWillRemoveListener() {
        if (flushOnListenerRemove && numDebouncedCalls > 0) {
          doFire?.();
        }
      },
      onDidRemoveLastListener() {
        doFire = void 0;
        subscription.dispose();
      }
    };
    if (!disposable) {
      _addLeakageTraceLogic(options3);
    }
    const emitter = new $De(options3);
    disposable?.add(emitter);
    return emitter.event;
  }
  Event3.debounce = debounce;
  function accumulate(event, delay = 0, disposable) {
    return Event3.debounce(event, (last, e) => {
      if (!last) {
        return [e];
      }
      last.push(e);
      return last;
    }, delay, void 0, true, void 0, disposable);
  }
  Event3.accumulate = accumulate;
  function latch(event, equals2 = (a, b) => a === b, disposable) {
    let firstCall = true;
    let cache2;
    return filter(event, (value) => {
      const shouldEmit = firstCall || !equals2(value, cache2);
      firstCall = false;
      cache2 = value;
      return shouldEmit;
    }, disposable);
  }
  Event3.latch = latch;
  function split(event, isT, disposable) {
    return [
      Event3.filter(event, isT, disposable),
      Event3.filter(event, (e) => !isT(e), disposable)
    ];
  }
  Event3.split = split;
  function buffer(event, flushAfterTimeout = false, _buffer = [], disposable) {
    let buffer2 = _buffer.slice();
    let listener = event((e) => {
      if (buffer2) {
        buffer2.push(e);
      } else {
        emitter.fire(e);
      }
    });
    if (disposable) {
      disposable.add(listener);
    }
    const flush = () => {
      buffer2?.forEach((e) => emitter.fire(e));
      buffer2 = null;
    };
    const emitter = new $De({
      onWillAddFirstListener() {
        if (!listener) {
          listener = event((e) => emitter.fire(e));
          if (disposable) {
            disposable.add(listener);
          }
        }
      },
      onDidAddFirstListener() {
        if (buffer2) {
          if (flushAfterTimeout) {
            setTimeout(flush);
          } else {
            flush();
          }
        }
      },
      onDidRemoveLastListener() {
        if (listener) {
          listener.dispose();
        }
        listener = null;
      }
    });
    if (disposable) {
      disposable.add(emitter);
    }
    return emitter.event;
  }
  Event3.buffer = buffer;
  function chain(event, sythensize) {
    const fn = (listener, thisArgs, disposables) => {
      const cs = sythensize(new ChainableSynthesis());
      return event(function(value) {
        const result = cs.evaluate(value);
        if (result !== HaltChainable) {
          listener.call(thisArgs, result);
        }
      }, void 0, disposables);
    };
    return fn;
  }
  Event3.chain = chain;
  const HaltChainable = Symbol("HaltChainable");
  class ChainableSynthesis {
    constructor() {
      this.f = [];
    }
    map(fn) {
      this.f.push(fn);
      return this;
    }
    forEach(fn) {
      this.f.push((v) => {
        fn(v);
        return v;
      });
      return this;
    }
    filter(fn) {
      this.f.push((v) => fn(v) ? v : HaltChainable);
      return this;
    }
    reduce(merge, initial) {
      let last = initial;
      this.f.push((v) => {
        last = merge(last, v);
        return last;
      });
      return this;
    }
    latch(equals2 = (a, b) => a === b) {
      let firstCall = true;
      let cache2;
      this.f.push((value) => {
        const shouldEmit = firstCall || !equals2(value, cache2);
        firstCall = false;
        cache2 = value;
        return shouldEmit ? value : HaltChainable;
      });
      return this;
    }
    evaluate(value) {
      for (const step of this.f) {
        value = step(value);
        if (value === HaltChainable) {
          break;
        }
      }
      return value;
    }
  }
  function fromNodeEventEmitter(emitter, eventName, map2 = (id2) => id2) {
    const fn = (...args2) => result.fire(map2(...args2));
    const onFirstListenerAdd = () => emitter.on(eventName, fn);
    const onLastListenerRemove = () => emitter.removeListener(eventName, fn);
    const result = new $De({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
    return result.event;
  }
  Event3.fromNodeEventEmitter = fromNodeEventEmitter;
  function fromDOMEventEmitter(emitter, eventName, map2 = (id2) => id2) {
    const fn = (...args2) => result.fire(map2(...args2));
    const onFirstListenerAdd = () => emitter.addEventListener(eventName, fn);
    const onLastListenerRemove = () => emitter.removeEventListener(eventName, fn);
    const result = new $De({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
    return result.event;
  }
  Event3.fromDOMEventEmitter = fromDOMEventEmitter;
  function toPromise(event) {
    return new Promise((resolve) => once(event)(resolve));
  }
  Event3.toPromise = toPromise;
  function fromPromise(promise) {
    const result = new $De();
    promise.then((res) => {
      result.fire(res);
    }, () => {
      result.fire(void 0);
    }).finally(() => {
      result.dispose();
    });
    return result.event;
  }
  Event3.fromPromise = fromPromise;
  function forward(from, to) {
    return from((e) => to.fire(e));
  }
  Event3.forward = forward;
  function runAndSubscribe(event, handler, initial) {
    handler(initial);
    return event((e) => handler(e));
  }
  Event3.runAndSubscribe = runAndSubscribe;
  class EmitterObserver {
    constructor(_observable, store) {
      this._observable = _observable;
      this.f = 0;
      this.g = false;
      const options3 = {
        onWillAddFirstListener: () => {
          _observable.addObserver(this);
          this._observable.reportChanges();
        },
        onDidRemoveLastListener: () => {
          _observable.removeObserver(this);
        }
      };
      if (!store) {
        _addLeakageTraceLogic(options3);
      }
      this.emitter = new $De(options3);
      if (store) {
        store.add(this.emitter);
      }
    }
    beginUpdate(_observable) {
      this.f++;
    }
    handlePossibleChange(_observable) {
    }
    handleChange(_observable, _change) {
      this.g = true;
    }
    endUpdate(_observable) {
      this.f--;
      if (this.f === 0) {
        this._observable.reportChanges();
        if (this.g) {
          this.g = false;
          this.emitter.fire(this._observable.get());
        }
      }
    }
  }
  function fromObservable(obs, store) {
    const observer = new EmitterObserver(obs, store);
    return observer.emitter.event;
  }
  Event3.fromObservable = fromObservable;
  function fromObservableLight(observable) {
    return (listener, thisArgs, disposables) => {
      let count = 0;
      let didChange = false;
      const observer = {
        beginUpdate() {
          count++;
        },
        endUpdate() {
          count--;
          if (count === 0) {
            observable.reportChanges();
            if (didChange) {
              didChange = false;
              listener.call(thisArgs);
            }
          }
        },
        handlePossibleChange() {
        },
        handleChange() {
          didChange = true;
        }
      };
      observable.addObserver(observer);
      observable.reportChanges();
      const disposable = {
        dispose() {
          observable.removeObserver(observer);
        }
      };
      if (disposables instanceof $9c) {
        disposables.add(disposable);
      } else if (Array.isArray(disposables)) {
        disposables.push(disposable);
      }
      return disposable;
    };
  }
  Event3.fromObservableLight = fromObservableLight;
})(Event2 || (Event2 = {}));
var $ze = class _$ze {
  static {
    this.all = /* @__PURE__ */ new Set();
  }
  static {
    this.f = 0;
  }
  constructor(name) {
    this.listenerCount = 0;
    this.invocationCount = 0;
    this.elapsedOverall = 0;
    this.durations = [];
    this.name = `${name}_${_$ze.f++}`;
    _$ze.all.add(this);
  }
  start(listenerCount) {
    this.g = new $xe();
    this.listenerCount = listenerCount;
  }
  stop() {
    if (this.g) {
      const elapsed = this.g.elapsed();
      this.durations.push(elapsed);
      this.elapsedOverall += elapsed;
      this.invocationCount += 1;
      this.g = void 0;
    }
  }
};
var _globalLeakWarningThreshold = -1;
function $Ae(n) {
  const oldValue = _globalLeakWarningThreshold;
  _globalLeakWarningThreshold = n;
  return {
    dispose() {
      _globalLeakWarningThreshold = oldValue;
    }
  };
}
var LeakageMonitor = class _LeakageMonitor {
  static {
    this.f = 1;
  }
  constructor(j, threshold, name = (_LeakageMonitor.f++).toString(16).padStart(3, "0")) {
    this.j = j;
    this.threshold = threshold;
    this.name = name;
    this.h = 0;
  }
  dispose() {
    this.g?.clear();
  }
  check(stack, listenerCount) {
    const threshold = this.threshold;
    if (threshold <= 0 || listenerCount < threshold) {
      return void 0;
    }
    if (!this.g) {
      this.g = /* @__PURE__ */ new Map();
    }
    const count = this.g.get(stack.value) || 0;
    this.g.set(stack.value, count + 1);
    this.h -= 1;
    if (this.h <= 0) {
      this.h = threshold * 0.5;
      const [topStack, topCount] = this.getMostFrequentStack();
      const message = `[${this.name}] potential listener LEAK detected, having ${listenerCount} listeners already. MOST frequent listener (${topCount}):`;
      console.warn(message);
      console.warn(topStack);
      const error = new $Be(message, topStack);
      this.j(error);
    }
    return () => {
      const count2 = this.g.get(stack.value) || 0;
      this.g.set(stack.value, count2 - 1);
    };
  }
  getMostFrequentStack() {
    if (!this.g) {
      return void 0;
    }
    let topStack;
    let topCount = 0;
    for (const [stack, count] of this.g) {
      if (!topStack || topCount < count) {
        topStack = [stack, count];
        topCount = count;
      }
    }
    return topStack;
  }
};
var Stacktrace = class _Stacktrace {
  static create() {
    const err = new Error();
    return new _Stacktrace(err.stack ?? "");
  }
  constructor(value) {
    this.value = value;
  }
  print() {
    console.warn(this.value.split("\n").slice(2).join("\n"));
  }
};
var $Be = class extends Error {
  constructor(message, stack) {
    super(message);
    this.name = "ListenerLeakError";
    this.stack = stack;
  }
};
var $Ce = class extends Error {
  constructor(message, stack) {
    super(message);
    this.name = "ListenerRefusalError";
    this.stack = stack;
  }
};
var id = 0;
var UniqueContainer = class {
  constructor(value) {
    this.value = value;
    this.id = id++;
  }
};
var compactionThreshold = 2;
var forEachListener = (listeners, fn) => {
  if (listeners instanceof UniqueContainer) {
    fn(listeners);
  } else {
    for (let i = 0; i < listeners.length; i++) {
      const l = listeners[i];
      if (l) {
        fn(l);
      }
    }
  }
};
var _listenerFinalizers;
if (_enableListenerGCedWarning) {
  const leaks = [];
  setInterval(() => {
    if (leaks.length === 0) {
      return;
    }
    console.warn("[LEAKING LISTENERS] GC'ed these listeners that were NOT yet disposed:");
    console.warn(leaks.join("\n"));
    leaks.length = 0;
  }, 3e3);
  _listenerFinalizers = new FinalizationRegistry((heldValue) => {
    if (typeof heldValue === "string") {
      leaks.push(heldValue);
    }
  });
}
var $De = class {
  constructor(options3) {
    this.z = 0;
    this.f = options3;
    this.g = _globalLeakWarningThreshold > 0 || this.f?.leakWarningThreshold ? new LeakageMonitor(options3?.onListenerError ?? $ab, this.f?.leakWarningThreshold ?? _globalLeakWarningThreshold) : void 0;
    this.j = this.f?._profName ? new $ze(this.f._profName) : void 0;
    this.w = this.f?.deliveryQueue;
  }
  dispose() {
    if (!this.m) {
      this.m = true;
      if (this.w?.current === this) {
        this.w.reset();
      }
      if (this.u) {
        if (_enableDisposeWithListenerWarning) {
          const listeners = this.u;
          queueMicrotask(() => {
            forEachListener(listeners, (l) => l.stack?.print());
          });
        }
        this.u = void 0;
        this.z = 0;
      }
      this.f?.onDidRemoveLastListener?.();
      this.g?.dispose();
    }
  }
  /**
   * For the public to allow to subscribe
   * to events from this Emitter
   */
  get event() {
    this.q ??= (callback, thisArgs, disposables) => {
      if (this.g && this.z > this.g.threshold ** 2) {
        const message = `[${this.g.name}] REFUSES to accept new listeners because it exceeded its threshold by far (${this.z} vs ${this.g.threshold})`;
        console.warn(message);
        const tuple = this.g.getMostFrequentStack() ?? ["UNKNOWN stack", -1];
        const error = new $Ce(`${message}. HINT: Stack shows most frequent listener (${tuple[1]}-times)`, tuple[0]);
        const errorHandler = this.f?.onListenerError || $ab;
        errorHandler(error);
        return $0c.None;
      }
      if (this.m) {
        return $0c.None;
      }
      if (thisArgs) {
        callback = callback.bind(thisArgs);
      }
      const contained = new UniqueContainer(callback);
      let removeMonitor;
      let stack;
      if (this.g && this.z >= Math.ceil(this.g.threshold * 0.2)) {
        contained.stack = Stacktrace.create();
        removeMonitor = this.g.check(contained.stack, this.z + 1);
      }
      if (_enableDisposeWithListenerWarning) {
        contained.stack = stack ?? Stacktrace.create();
      }
      if (!this.u) {
        this.f?.onWillAddFirstListener?.(this);
        this.u = contained;
        this.f?.onDidAddFirstListener?.(this);
      } else if (this.u instanceof UniqueContainer) {
        this.w ??= new EventDeliveryQueuePrivate();
        this.u = [this.u, contained];
      } else {
        this.u.push(contained);
      }
      this.z++;
      const result = $8c(() => {
        _listenerFinalizers?.unregister(result);
        removeMonitor?.();
        this.A(contained);
      });
      if (disposables instanceof $9c) {
        disposables.add(result);
      } else if (Array.isArray(disposables)) {
        disposables.push(result);
      }
      if (_listenerFinalizers) {
        const stack2 = new Error().stack.split("\n").slice(2, 3).join("\n").trim();
        const match = /(file:|vscode-file:\/\/vscode-app)?(\/[^:]*:\d+:\d+)/.exec(stack2);
        _listenerFinalizers.register(result, match?.[2] ?? stack2, result);
      }
      return result;
    };
    return this.q;
  }
  A(listener) {
    this.f?.onWillRemoveListener?.(this);
    if (!this.u) {
      return;
    }
    if (this.z === 1) {
      this.u = void 0;
      this.f?.onDidRemoveLastListener?.(this);
      this.z = 0;
      return;
    }
    const listeners = this.u;
    const index = listeners.indexOf(listener);
    if (index === -1) {
      console.log("disposed?", this.m);
      console.log("size?", this.z);
      console.log("arr?", JSON.stringify(this.u));
      throw new Error("Attempted to dispose unknown listener");
    }
    this.z--;
    listeners[index] = void 0;
    const adjustDeliveryQueue = this.w.current === this;
    if (this.z * compactionThreshold <= listeners.length) {
      let n = 0;
      for (let i = 0; i < listeners.length; i++) {
        if (listeners[i]) {
          listeners[n++] = listeners[i];
        } else if (adjustDeliveryQueue) {
          this.w.end--;
          if (n < this.w.i) {
            this.w.i--;
          }
        }
      }
      listeners.length = n;
    }
  }
  B(listener, value) {
    if (!listener) {
      return;
    }
    const errorHandler = this.f?.onListenerError || $ab;
    if (!errorHandler) {
      listener.value(value);
      return;
    }
    try {
      listener.value(value);
    } catch (e) {
      errorHandler(e);
    }
  }
  /** Delivers items in the queue. Assumes the queue is ready to go. */
  C(dq) {
    const listeners = dq.current.u;
    while (dq.i < dq.end) {
      this.B(listeners[dq.i++], dq.value);
    }
    dq.reset();
  }
  /**
   * To be kept private to fire an event to
   * subscribers
   */
  fire(event) {
    if (this.w?.current) {
      this.C(this.w);
      this.j?.stop();
    }
    this.j?.start(this.z);
    if (!this.u) {
    } else if (this.u instanceof UniqueContainer) {
      this.B(this.u, event);
    } else {
      const dq = this.w;
      dq.enqueue(this, event, this.u.length);
      this.C(dq);
    }
    this.j?.stop();
  }
  hasListeners() {
    return this.z > 0;
  }
};
var $Ee = () => new EventDeliveryQueuePrivate();
var EventDeliveryQueuePrivate = class {
  constructor() {
    this.i = -1;
    this.end = 0;
  }
  enqueue(emitter, value, end) {
    this.i = 0;
    this.end = end;
    this.current = emitter;
    this.value = value;
  }
  reset() {
    this.i = this.end;
    this.current = void 0;
    this.value = void 0;
  }
};
var $Fe = class extends $De {
  async fireAsync(data, token, promiseJoin) {
    if (!this.u) {
      return;
    }
    if (!this.h) {
      this.h = new $hd();
    }
    forEachListener(this.u, (listener) => this.h.push([listener.value, data]));
    while (this.h.size > 0 && !token.isCancellationRequested) {
      const [listener, data2] = this.h.shift();
      const thenables = [];
      const event = {
        ...data2,
        token,
        waitUntil: (p) => {
          if (Object.isFrozen(thenables)) {
            throw new Error("waitUntil can NOT be called asynchronous");
          }
          if (promiseJoin) {
            p = promiseJoin(p, listener);
          }
          thenables.push(p);
        }
      };
      try {
        listener(event);
      } catch (e) {
        $ab(e);
        continue;
      }
      Object.freeze(thenables);
      await Promise.allSettled(thenables).then((values) => {
        for (const value of values) {
          if (value.status === "rejected") {
            $ab(value.reason);
          }
        }
      });
    }
  }
};
var $Ge = class extends $De {
  get isPaused() {
    return this.h !== 0;
  }
  constructor(options3) {
    super(options3);
    this.h = 0;
    this.s = new $hd();
    this.t = options3?.merge;
  }
  pause() {
    this.h++;
  }
  resume() {
    if (this.h !== 0 && --this.h === 0) {
      if (this.t) {
        if (this.s.size > 0) {
          const events = Array.from(this.s);
          this.s.clear();
          super.fire(this.t(events));
        }
      } else {
        while (!this.h && this.s.size !== 0) {
          super.fire(this.s.shift());
        }
      }
    }
  }
  fire(event) {
    if (this.z) {
      if (this.h !== 0) {
        this.s.push(event);
      } else {
        super.fire(event);
      }
    }
  }
};
var $He = class extends $Ge {
  constructor(options3) {
    super(options3);
    this.k = options3.delay ?? 100;
  }
  fire(event) {
    if (!this.o) {
      this.pause();
      this.o = setTimeout(() => {
        this.o = void 0;
        this.resume();
      }, this.k);
    }
    super.fire(event);
  }
};
var $Ie = class extends $De {
  constructor(options3) {
    super(options3);
    this.h = [];
    this.k = options3?.merge;
  }
  fire(event) {
    if (!this.hasListeners()) {
      return;
    }
    this.h.push(event);
    if (this.h.length === 1) {
      queueMicrotask(() => {
        if (this.k) {
          super.fire(this.k(this.h));
        } else {
          this.h.forEach((e) => super.fire(e));
        }
        this.h = [];
      });
    }
  }
};
var $Je = class {
  constructor() {
    this.g = false;
    this.h = [];
    this.f = new $De({
      onWillAddFirstListener: () => this.j(),
      onDidRemoveLastListener: () => this.k()
    });
  }
  get event() {
    return this.f.event;
  }
  add(event) {
    const e = { event, listener: null };
    this.h.push(e);
    if (this.g) {
      this.m(e);
    }
    const dispose = () => {
      if (this.g) {
        this.o(e);
      }
      const idx = this.h.indexOf(e);
      this.h.splice(idx, 1);
    };
    return $8c($qb(dispose));
  }
  j() {
    this.g = true;
    this.h.forEach((e) => this.m(e));
  }
  k() {
    this.g = false;
    this.h.forEach((e) => this.o(e));
  }
  m(e) {
    e.listener = e.event((r2) => this.f.fire(r2));
  }
  o(e) {
    e.listener?.dispose();
    e.listener = null;
  }
  dispose() {
    this.f.dispose();
    for (const e of this.h) {
      e.listener?.dispose();
    }
    this.h = [];
  }
};
var $Ke = class {
  constructor(items, onAddItem, onRemoveItem, getEvent) {
    this.f = new $9c();
    const multiplexer = this.f.add(new $Je());
    const itemListeners = this.f.add(new $gd());
    function addItem(instance2) {
      itemListeners.set(instance2, multiplexer.add(getEvent(instance2)));
    }
    for (const instance2 of items) {
      addItem(instance2);
    }
    this.f.add(onAddItem((instance2) => {
      addItem(instance2);
    }));
    this.f.add(onRemoveItem((instance2) => {
      itemListeners.deleteAndDispose(instance2);
    }));
    this.event = multiplexer.event;
  }
  dispose() {
    this.f.dispose();
  }
};
var $Le = class {
  constructor() {
    this.f = [];
  }
  wrapEvent(event, reduce, initial) {
    return (listener, thisArgs, disposables) => {
      return event((i) => {
        const data = this.f[this.f.length - 1];
        if (!reduce) {
          if (data) {
            data.buffers.push(() => listener.call(thisArgs, i));
          } else {
            listener.call(thisArgs, i);
          }
          return;
        }
        const reduceData = data;
        if (!reduceData) {
          listener.call(thisArgs, reduce(initial, i));
          return;
        }
        reduceData.items ??= [];
        reduceData.items.push(i);
        if (reduceData.buffers.length === 0) {
          data.buffers.push(() => {
            reduceData.reducedResult ??= initial ? reduceData.items.reduce(reduce, initial) : reduceData.items.reduce(reduce);
            listener.call(thisArgs, reduceData.reducedResult);
          });
        }
      }, void 0, disposables);
    };
  }
  bufferEvents(fn) {
    const data = { buffers: new Array() };
    this.f.push(data);
    const r2 = fn();
    this.f.pop();
    data.buffers.forEach((flush) => flush());
    return r2;
  }
};
var $Me = class {
  constructor() {
    this.f = false;
    this.g = Event2.None;
    this.h = $0c.None;
    this.j = new $De({
      onDidAddFirstListener: () => {
        this.f = true;
        this.h = this.g(this.j.fire, this.j);
      },
      onDidRemoveLastListener: () => {
        this.f = false;
        this.h.dispose();
      }
    });
    this.event = this.j.event;
  }
  set input(event) {
    this.g = event;
    if (this.f) {
      this.h.dispose();
      this.h = event(this.j.fire, this.j);
    }
  }
  dispose() {
    this.h.dispose();
    this.j.dispose();
  }
};
var $Ne = class {
  static const(value) {
    return new ConstValueWithChangeEvent(value);
  }
  constructor(g) {
    this.g = g;
    this.f = new $De();
    this.onDidChange = this.f.event;
  }
  get value() {
    return this.g;
  }
  set value(value) {
    if (value !== this.g) {
      this.g = value;
      this.f.fire(void 0);
    }
  }
};
var ConstValueWithChangeEvent = class {
  constructor(value) {
    this.value = value;
    this.onDidChange = Event2.None;
  }
};
function $Oe(getData, onDidChangeData, handleItem) {
  const map = new $gd();
  let oldData = new Set(getData());
  for (const d of oldData) {
    map.set(d, handleItem(d));
  }
  const store = new $9c();
  store.add(onDidChangeData(() => {
    const newData = getData();
    const diff4 = $b(oldData, newData);
    for (const r2 of diff4.removed) {
      map.deleteAndDispose(r2);
    }
    for (const a of diff4.added) {
      map.set(a, handleItem(a));
    }
    oldData = new Set(newData);
  }));
  store.add(map);
  return store;
}

// out-build/vs/base/browser/browser.js
var WindowManager = class _WindowManager {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
    this.b = new $De();
    this.onDidChangeZoomLevel = this.b.event;
    this.c = /* @__PURE__ */ new Map();
    this.d = new $De();
    this.onDidChangeFullscreen = this.d.event;
    this.e = /* @__PURE__ */ new Map();
  }
  static {
    this.INSTANCE = new _WindowManager();
  }
  getZoomLevel(targetWindow) {
    return this.a.get(this.f(targetWindow)) ?? 0;
  }
  setZoomLevel(zoomLevel, targetWindow) {
    if (this.getZoomLevel(targetWindow) === zoomLevel) {
      return;
    }
    const targetWindowId = this.f(targetWindow);
    this.a.set(targetWindowId, zoomLevel);
    this.b.fire(targetWindowId);
  }
  getZoomFactor(targetWindow) {
    return this.c.get(this.f(targetWindow)) ?? 1;
  }
  setZoomFactor(zoomFactor, targetWindow) {
    this.c.set(this.f(targetWindow), zoomFactor);
  }
  setFullscreen(fullscreen, targetWindow) {
    if (this.isFullscreen(targetWindow) === fullscreen) {
      return;
    }
    const windowId = this.f(targetWindow);
    this.e.set(windowId, fullscreen);
    this.d.fire(windowId);
  }
  isFullscreen(targetWindow) {
    return !!this.e.get(this.f(targetWindow));
  }
  f(targetWindow) {
    return targetWindow.vscodeWindowId;
  }
};
function $dT(targetWindow, query, callback) {
  if (typeof query === "string") {
    query = targetWindow.matchMedia(query);
  }
  query.addEventListener("change", callback);
}
function $eT(zoomLevel, targetWindow) {
  WindowManager.INSTANCE.setZoomLevel(zoomLevel, targetWindow);
}
function $fT(targetWindow) {
  return WindowManager.INSTANCE.getZoomLevel(targetWindow);
}
var $gT = WindowManager.INSTANCE.onDidChangeZoomLevel;
function $hT(targetWindow) {
  return WindowManager.INSTANCE.getZoomFactor(targetWindow);
}
function $iT(zoomFactor, targetWindow) {
  WindowManager.INSTANCE.setZoomFactor(zoomFactor, targetWindow);
}
function $jT(fullscreen, targetWindow) {
  WindowManager.INSTANCE.setFullscreen(fullscreen, targetWindow);
}
function $kT(targetWindow) {
  return WindowManager.INSTANCE.isFullscreen(targetWindow);
}
var $lT = WindowManager.INSTANCE.onDidChangeFullscreen;
var userAgent = navigator.userAgent;
var $mT = userAgent.indexOf("Firefox") >= 0;
var $nT = userAgent.indexOf("AppleWebKit") >= 0;
var $oT = userAgent.indexOf("Chrome") >= 0;
var $pT = !$oT && userAgent.indexOf("Safari") >= 0;
var $qT = !$oT && !$pT && $nT;
var $rT = userAgent.indexOf("Electron/") >= 0;
var $sT = userAgent.indexOf("Android") >= 0;
var standalone = false;
if (typeof $aT.matchMedia === "function") {
  const standaloneMatchMedia = $aT.matchMedia("(display-mode: standalone) or (display-mode: window-controls-overlay)");
  const fullScreenMatchMedia = $aT.matchMedia("(display-mode: fullscreen)");
  standalone = standaloneMatchMedia.matches;
  $dT($aT, standaloneMatchMedia, ({ matches }) => {
    if (standalone && fullScreenMatchMedia.matches) {
      return;
    }
    standalone = matches;
  });
}
function $tT() {
  return standalone;
}
function $uT() {
  return navigator?.windowControlsOverlay?.visible;
}
function $vT(targetWindow) {
  return targetWindow.navigator?.windowControlsOverlay?.getTitlebarAreaRect();
}

// out-build/vs/base/common/types.js
function $yg(str) {
  return typeof str === "string";
}
function $zg(value) {
  return Array.isArray(value) && value.every((elem) => $yg(elem));
}
function $Ag(obj) {
  return typeof obj === "object" && obj !== null && !Array.isArray(obj) && !(obj instanceof RegExp) && !(obj instanceof Date);
}
function $Bg(obj) {
  const TypedArray = Object.getPrototypeOf(Uint8Array);
  return typeof obj === "object" && obj instanceof TypedArray;
}
function $Cg(obj) {
  return typeof obj === "number" && !isNaN(obj);
}
function $Dg(obj) {
  return !!obj && typeof obj[Symbol.iterator] === "function";
}
function $Eg(obj) {
  return obj === true || obj === false;
}
function $Fg(obj) {
  return typeof obj === "undefined";
}
function $Gg(arg) {
  return !$Hg(arg);
}
function $Hg(obj) {
  return $Fg(obj) || obj === null;
}
function $Ig(condition, type) {
  if (!condition) {
    throw new Error(type ? `Unexpected type, expected '${type}'` : "Unexpected type");
  }
}
function $Jg(arg) {
  if ($Hg(arg)) {
    throw new Error("Assertion Failed: argument is undefined or null");
  }
  return arg;
}
function $Kg(...args2) {
  const result = [];
  for (let i = 0; i < args2.length; i++) {
    const arg = args2[i];
    if ($Hg(arg)) {
      throw new Error(`Assertion Failed: argument at index ${i} is undefined or null`);
    }
    result.push(arg);
  }
  return result;
}
var hasOwnProperty = Object.prototype.hasOwnProperty;
function $Lg(obj) {
  if (!$Ag(obj)) {
    return false;
  }
  for (const key in obj) {
    if (hasOwnProperty.call(obj, key)) {
      return false;
    }
  }
  return true;
}
function $Mg(obj) {
  return typeof obj === "function";
}
function $Ng(...objects) {
  return objects.length > 0 && objects.every($Mg);
}
function $Og(args2, constraints) {
  const len = Math.min(args2.length, constraints.length);
  for (let i = 0; i < len; i++) {
    $Pg(args2[i], constraints[i]);
  }
}
function $Pg(arg, constraint) {
  if ($yg(constraint)) {
    if (typeof arg !== constraint) {
      throw new Error(`argument does not match constraint: typeof ${constraint}`);
    }
  } else if ($Mg(constraint)) {
    try {
      if (arg instanceof constraint) {
        return;
      }
    } catch {
    }
    if (!$Hg(arg) && arg.constructor === constraint) {
      return;
    }
    if (constraint.length === 1 && constraint.call(void 0, arg) === true) {
      return;
    }
    throw new Error(`argument does not match one of these constraints: arg instanceof constraint, arg.constructor === constraint, nor constraint(arg) === true`);
  }
}

// out-build/vs/base/common/platform.js
var $j = "en";
var _isWindows = false;
var _isMacintosh = false;
var _isLinux = false;
var _isLinuxSnap = false;
var _isNative = false;
var _isWeb = false;
var _isElectron = false;
var _isIOS = false;
var _isCI = false;
var _isMobile = false;
var _locale = void 0;
var _language = $j;
var _platformLocale = $j;
var _translationsConfigFile = void 0;
var _userAgent = void 0;
var $globalThis = globalThis;
var nodeProcess = void 0;
if (typeof $globalThis.vscode !== "undefined" && typeof $globalThis.vscode.process !== "undefined") {
  nodeProcess = $globalThis.vscode.process;
} else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
  nodeProcess = process;
}
var isElectronProcess = typeof nodeProcess?.versions?.electron === "string";
var isElectronRenderer = isElectronProcess && nodeProcess?.type === "renderer";
if (typeof nodeProcess === "object") {
  _isWindows = nodeProcess.platform === "win32";
  _isMacintosh = nodeProcess.platform === "darwin";
  _isLinux = nodeProcess.platform === "linux";
  _isLinuxSnap = _isLinux && !!nodeProcess.env["SNAP"] && !!nodeProcess.env["SNAP_REVISION"];
  _isElectron = isElectronProcess;
  _isCI = !!nodeProcess.env["CI"] || !!nodeProcess.env["BUILD_ARTIFACTSTAGINGDIRECTORY"];
  _locale = $j;
  _language = $j;
  const rawNlsConfig = nodeProcess.env["VSCODE_NLS_CONFIG"];
  if (rawNlsConfig) {
    try {
      const nlsConfig = JSON.parse(rawNlsConfig);
      _locale = nlsConfig.userLocale;
      _platformLocale = nlsConfig.osLocale;
      _language = nlsConfig.resolvedLanguage || $j;
      _translationsConfigFile = nlsConfig.languagePack?.translationsConfigFile;
    } catch (e) {
    }
  }
  _isNative = true;
} else if (typeof navigator === "object" && !isElectronRenderer) {
  _userAgent = navigator.userAgent;
  _isWindows = _userAgent.indexOf("Windows") >= 0;
  _isMacintosh = _userAgent.indexOf("Macintosh") >= 0;
  _isIOS = (_userAgent.indexOf("Macintosh") >= 0 || _userAgent.indexOf("iPad") >= 0 || _userAgent.indexOf("iPhone") >= 0) && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
  _isLinux = _userAgent.indexOf("Linux") >= 0;
  _isMobile = _userAgent?.indexOf("Mobi") >= 0;
  _isWeb = true;
  _language = $g() || $j;
  _locale = navigator.language.toLowerCase();
  _platformLocale = _locale;
} else {
  console.error("Unable to resolve platform.");
}
var Platform;
(function(Platform2) {
  Platform2[Platform2["Web"] = 0] = "Web";
  Platform2[Platform2["Mac"] = 1] = "Mac";
  Platform2[Platform2["Linux"] = 2] = "Linux";
  Platform2[Platform2["Windows"] = 3] = "Windows";
})(Platform || (Platform = {}));
function $k(platform) {
  switch (platform) {
    case 0:
      return "Web";
    case 1:
      return "Mac";
    case 2:
      return "Linux";
    case 3:
      return "Windows";
  }
}
var _platform = 0;
if (_isMacintosh) {
  _platform = 1;
} else if (_isWindows) {
  _platform = 3;
} else if (_isLinux) {
  _platform = 2;
}
var $l = _isWindows;
var $m = _isMacintosh;
var $n = _isLinux;
var $o = _isLinuxSnap;
var $p = _isNative;
var $r = _isWeb;
var $s = _isWeb && typeof $globalThis.importScripts === "function";
var $t = $s ? $globalThis.origin : void 0;
var $u = _isIOS;
var $v = _isMobile;
var $w = _isCI;
var $x = _platform;
var $y = _userAgent;
var $z = _language;
var Language;
(function(Language2) {
  function value() {
    return $z;
  }
  Language2.value = value;
  function isDefaultVariant() {
    if ($z.length === 2) {
      return $z === "en";
    } else if ($z.length >= 3) {
      return $z[0] === "e" && $z[1] === "n" && $z[2] === "-";
    } else {
      return false;
    }
  }
  Language2.isDefaultVariant = isDefaultVariant;
  function isDefault() {
    return $z === "en";
  }
  Language2.isDefault = isDefault;
})(Language || (Language = {}));
var $A = _locale;
var $B = _platformLocale;
var $C = _translationsConfigFile;
var $D = typeof $globalThis.postMessage === "function" && !$globalThis.importScripts;
var $E = (() => {
  if ($D) {
    const pending = [];
    $globalThis.addEventListener("message", (e) => {
      if (e.data && e.data.vscodeScheduleAsyncWork) {
        for (let i = 0, len = pending.length; i < len; i++) {
          const candidate = pending[i];
          if (candidate.id === e.data.vscodeScheduleAsyncWork) {
            pending.splice(i, 1);
            candidate.callback();
            return;
          }
        }
      }
    });
    let lastId = 0;
    return (callback) => {
      const myId = ++lastId;
      pending.push({
        id: myId,
        callback
      });
      $globalThis.postMessage({ vscodeScheduleAsyncWork: myId }, "*");
    };
  }
  return (callback) => setTimeout(callback);
})();
var OperatingSystem;
(function(OperatingSystem2) {
  OperatingSystem2[OperatingSystem2["Windows"] = 1] = "Windows";
  OperatingSystem2[OperatingSystem2["Macintosh"] = 2] = "Macintosh";
  OperatingSystem2[OperatingSystem2["Linux"] = 3] = "Linux";
})(OperatingSystem || (OperatingSystem = {}));
var OS = _isMacintosh || _isIOS ? 2 : _isWindows ? 1 : 3;
var _isLittleEndian = true;
var _isLittleEndianComputed = false;
function $G() {
  if (!_isLittleEndianComputed) {
    _isLittleEndianComputed = true;
    const test = new Uint8Array(2);
    test[0] = 1;
    test[1] = 2;
    const view = new Uint16Array(test.buffer);
    _isLittleEndian = view[0] === (2 << 8) + 1;
  }
  return _isLittleEndian;
}
var $H = !!($y && $y.indexOf("Chrome") >= 0);
var $I = !!($y && $y.indexOf("Firefox") >= 0);
var $J = !!(!$H && ($y && $y.indexOf("Safari") >= 0));
var $K = !!($y && $y.indexOf("Edg/") >= 0);
var $L = !!($y && $y.indexOf("Android") >= 0);
function $M(osVersion) {
  return parseFloat(osVersion) >= 20;
}

// out-build/vs/base/browser/canIUse.js
var KeyboardSupport;
(function(KeyboardSupport2) {
  KeyboardSupport2[KeyboardSupport2["Always"] = 0] = "Always";
  KeyboardSupport2[KeyboardSupport2["FullScreen"] = 1] = "FullScreen";
  KeyboardSupport2[KeyboardSupport2["None"] = 2] = "None";
})(KeyboardSupport || (KeyboardSupport = {}));
var $wT = {
  clipboard: {
    writeText: $p || document.queryCommandSupported && document.queryCommandSupported("copy") || !!(navigator && navigator.clipboard && navigator.clipboard.writeText),
    readText: $p || !!(navigator && navigator.clipboard && navigator.clipboard.readText)
  },
  keyboard: (() => {
    if ($p || $tT()) {
      return 0;
    }
    if (navigator.keyboard || $pT) {
      return 1;
    }
    return 2;
  })(),
  // 'ontouchstart' in window always evaluates to true with typescript's modern typings. This causes `window` to be
  // `never` later in `window.navigator`. That's why we need the explicit `window as Window` cast
  touch: "ontouchstart" in $aT || navigator.maxTouchPoints > 0,
  pointerEvents: $aT.PointerEvent && ("ontouchstart" in $aT || navigator.maxTouchPoints > 0)
};

// out-build/vs/base/common/keyCodes.js
var KeyCode;
(function(KeyCode3) {
  KeyCode3[KeyCode3["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
  KeyCode3[KeyCode3["Unknown"] = 0] = "Unknown";
  KeyCode3[KeyCode3["Backspace"] = 1] = "Backspace";
  KeyCode3[KeyCode3["Tab"] = 2] = "Tab";
  KeyCode3[KeyCode3["Enter"] = 3] = "Enter";
  KeyCode3[KeyCode3["Shift"] = 4] = "Shift";
  KeyCode3[KeyCode3["Ctrl"] = 5] = "Ctrl";
  KeyCode3[KeyCode3["Alt"] = 6] = "Alt";
  KeyCode3[KeyCode3["PauseBreak"] = 7] = "PauseBreak";
  KeyCode3[KeyCode3["CapsLock"] = 8] = "CapsLock";
  KeyCode3[KeyCode3["Escape"] = 9] = "Escape";
  KeyCode3[KeyCode3["Space"] = 10] = "Space";
  KeyCode3[KeyCode3["PageUp"] = 11] = "PageUp";
  KeyCode3[KeyCode3["PageDown"] = 12] = "PageDown";
  KeyCode3[KeyCode3["End"] = 13] = "End";
  KeyCode3[KeyCode3["Home"] = 14] = "Home";
  KeyCode3[KeyCode3["LeftArrow"] = 15] = "LeftArrow";
  KeyCode3[KeyCode3["UpArrow"] = 16] = "UpArrow";
  KeyCode3[KeyCode3["RightArrow"] = 17] = "RightArrow";
  KeyCode3[KeyCode3["DownArrow"] = 18] = "DownArrow";
  KeyCode3[KeyCode3["Insert"] = 19] = "Insert";
  KeyCode3[KeyCode3["Delete"] = 20] = "Delete";
  KeyCode3[KeyCode3["Digit0"] = 21] = "Digit0";
  KeyCode3[KeyCode3["Digit1"] = 22] = "Digit1";
  KeyCode3[KeyCode3["Digit2"] = 23] = "Digit2";
  KeyCode3[KeyCode3["Digit3"] = 24] = "Digit3";
  KeyCode3[KeyCode3["Digit4"] = 25] = "Digit4";
  KeyCode3[KeyCode3["Digit5"] = 26] = "Digit5";
  KeyCode3[KeyCode3["Digit6"] = 27] = "Digit6";
  KeyCode3[KeyCode3["Digit7"] = 28] = "Digit7";
  KeyCode3[KeyCode3["Digit8"] = 29] = "Digit8";
  KeyCode3[KeyCode3["Digit9"] = 30] = "Digit9";
  KeyCode3[KeyCode3["KeyA"] = 31] = "KeyA";
  KeyCode3[KeyCode3["KeyB"] = 32] = "KeyB";
  KeyCode3[KeyCode3["KeyC"] = 33] = "KeyC";
  KeyCode3[KeyCode3["KeyD"] = 34] = "KeyD";
  KeyCode3[KeyCode3["KeyE"] = 35] = "KeyE";
  KeyCode3[KeyCode3["KeyF"] = 36] = "KeyF";
  KeyCode3[KeyCode3["KeyG"] = 37] = "KeyG";
  KeyCode3[KeyCode3["KeyH"] = 38] = "KeyH";
  KeyCode3[KeyCode3["KeyI"] = 39] = "KeyI";
  KeyCode3[KeyCode3["KeyJ"] = 40] = "KeyJ";
  KeyCode3[KeyCode3["KeyK"] = 41] = "KeyK";
  KeyCode3[KeyCode3["KeyL"] = 42] = "KeyL";
  KeyCode3[KeyCode3["KeyM"] = 43] = "KeyM";
  KeyCode3[KeyCode3["KeyN"] = 44] = "KeyN";
  KeyCode3[KeyCode3["KeyO"] = 45] = "KeyO";
  KeyCode3[KeyCode3["KeyP"] = 46] = "KeyP";
  KeyCode3[KeyCode3["KeyQ"] = 47] = "KeyQ";
  KeyCode3[KeyCode3["KeyR"] = 48] = "KeyR";
  KeyCode3[KeyCode3["KeyS"] = 49] = "KeyS";
  KeyCode3[KeyCode3["KeyT"] = 50] = "KeyT";
  KeyCode3[KeyCode3["KeyU"] = 51] = "KeyU";
  KeyCode3[KeyCode3["KeyV"] = 52] = "KeyV";
  KeyCode3[KeyCode3["KeyW"] = 53] = "KeyW";
  KeyCode3[KeyCode3["KeyX"] = 54] = "KeyX";
  KeyCode3[KeyCode3["KeyY"] = 55] = "KeyY";
  KeyCode3[KeyCode3["KeyZ"] = 56] = "KeyZ";
  KeyCode3[KeyCode3["Meta"] = 57] = "Meta";
  KeyCode3[KeyCode3["ContextMenu"] = 58] = "ContextMenu";
  KeyCode3[KeyCode3["F1"] = 59] = "F1";
  KeyCode3[KeyCode3["F2"] = 60] = "F2";
  KeyCode3[KeyCode3["F3"] = 61] = "F3";
  KeyCode3[KeyCode3["F4"] = 62] = "F4";
  KeyCode3[KeyCode3["F5"] = 63] = "F5";
  KeyCode3[KeyCode3["F6"] = 64] = "F6";
  KeyCode3[KeyCode3["F7"] = 65] = "F7";
  KeyCode3[KeyCode3["F8"] = 66] = "F8";
  KeyCode3[KeyCode3["F9"] = 67] = "F9";
  KeyCode3[KeyCode3["F10"] = 68] = "F10";
  KeyCode3[KeyCode3["F11"] = 69] = "F11";
  KeyCode3[KeyCode3["F12"] = 70] = "F12";
  KeyCode3[KeyCode3["F13"] = 71] = "F13";
  KeyCode3[KeyCode3["F14"] = 72] = "F14";
  KeyCode3[KeyCode3["F15"] = 73] = "F15";
  KeyCode3[KeyCode3["F16"] = 74] = "F16";
  KeyCode3[KeyCode3["F17"] = 75] = "F17";
  KeyCode3[KeyCode3["F18"] = 76] = "F18";
  KeyCode3[KeyCode3["F19"] = 77] = "F19";
  KeyCode3[KeyCode3["F20"] = 78] = "F20";
  KeyCode3[KeyCode3["F21"] = 79] = "F21";
  KeyCode3[KeyCode3["F22"] = 80] = "F22";
  KeyCode3[KeyCode3["F23"] = 81] = "F23";
  KeyCode3[KeyCode3["F24"] = 82] = "F24";
  KeyCode3[KeyCode3["NumLock"] = 83] = "NumLock";
  KeyCode3[KeyCode3["ScrollLock"] = 84] = "ScrollLock";
  KeyCode3[KeyCode3["Semicolon"] = 85] = "Semicolon";
  KeyCode3[KeyCode3["Equal"] = 86] = "Equal";
  KeyCode3[KeyCode3["Comma"] = 87] = "Comma";
  KeyCode3[KeyCode3["Minus"] = 88] = "Minus";
  KeyCode3[KeyCode3["Period"] = 89] = "Period";
  KeyCode3[KeyCode3["Slash"] = 90] = "Slash";
  KeyCode3[KeyCode3["Backquote"] = 91] = "Backquote";
  KeyCode3[KeyCode3["BracketLeft"] = 92] = "BracketLeft";
  KeyCode3[KeyCode3["Backslash"] = 93] = "Backslash";
  KeyCode3[KeyCode3["BracketRight"] = 94] = "BracketRight";
  KeyCode3[KeyCode3["Quote"] = 95] = "Quote";
  KeyCode3[KeyCode3["OEM_8"] = 96] = "OEM_8";
  KeyCode3[KeyCode3["IntlBackslash"] = 97] = "IntlBackslash";
  KeyCode3[KeyCode3["Numpad0"] = 98] = "Numpad0";
  KeyCode3[KeyCode3["Numpad1"] = 99] = "Numpad1";
  KeyCode3[KeyCode3["Numpad2"] = 100] = "Numpad2";
  KeyCode3[KeyCode3["Numpad3"] = 101] = "Numpad3";
  KeyCode3[KeyCode3["Numpad4"] = 102] = "Numpad4";
  KeyCode3[KeyCode3["Numpad5"] = 103] = "Numpad5";
  KeyCode3[KeyCode3["Numpad6"] = 104] = "Numpad6";
  KeyCode3[KeyCode3["Numpad7"] = 105] = "Numpad7";
  KeyCode3[KeyCode3["Numpad8"] = 106] = "Numpad8";
  KeyCode3[KeyCode3["Numpad9"] = 107] = "Numpad9";
  KeyCode3[KeyCode3["NumpadMultiply"] = 108] = "NumpadMultiply";
  KeyCode3[KeyCode3["NumpadAdd"] = 109] = "NumpadAdd";
  KeyCode3[KeyCode3["NUMPAD_SEPARATOR"] = 110] = "NUMPAD_SEPARATOR";
  KeyCode3[KeyCode3["NumpadSubtract"] = 111] = "NumpadSubtract";
  KeyCode3[KeyCode3["NumpadDecimal"] = 112] = "NumpadDecimal";
  KeyCode3[KeyCode3["NumpadDivide"] = 113] = "NumpadDivide";
  KeyCode3[KeyCode3["KEY_IN_COMPOSITION"] = 114] = "KEY_IN_COMPOSITION";
  KeyCode3[KeyCode3["ABNT_C1"] = 115] = "ABNT_C1";
  KeyCode3[KeyCode3["ABNT_C2"] = 116] = "ABNT_C2";
  KeyCode3[KeyCode3["AudioVolumeMute"] = 117] = "AudioVolumeMute";
  KeyCode3[KeyCode3["AudioVolumeUp"] = 118] = "AudioVolumeUp";
  KeyCode3[KeyCode3["AudioVolumeDown"] = 119] = "AudioVolumeDown";
  KeyCode3[KeyCode3["BrowserSearch"] = 120] = "BrowserSearch";
  KeyCode3[KeyCode3["BrowserHome"] = 121] = "BrowserHome";
  KeyCode3[KeyCode3["BrowserBack"] = 122] = "BrowserBack";
  KeyCode3[KeyCode3["BrowserForward"] = 123] = "BrowserForward";
  KeyCode3[KeyCode3["MediaTrackNext"] = 124] = "MediaTrackNext";
  KeyCode3[KeyCode3["MediaTrackPrevious"] = 125] = "MediaTrackPrevious";
  KeyCode3[KeyCode3["MediaStop"] = 126] = "MediaStop";
  KeyCode3[KeyCode3["MediaPlayPause"] = 127] = "MediaPlayPause";
  KeyCode3[KeyCode3["LaunchMediaPlayer"] = 128] = "LaunchMediaPlayer";
  KeyCode3[KeyCode3["LaunchMail"] = 129] = "LaunchMail";
  KeyCode3[KeyCode3["LaunchApp2"] = 130] = "LaunchApp2";
  KeyCode3[KeyCode3["Clear"] = 131] = "Clear";
  KeyCode3[KeyCode3["MAX_VALUE"] = 132] = "MAX_VALUE";
})(KeyCode || (KeyCode = {}));
var ScanCode;
(function(ScanCode2) {
  ScanCode2[ScanCode2["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
  ScanCode2[ScanCode2["None"] = 0] = "None";
  ScanCode2[ScanCode2["Hyper"] = 1] = "Hyper";
  ScanCode2[ScanCode2["Super"] = 2] = "Super";
  ScanCode2[ScanCode2["Fn"] = 3] = "Fn";
  ScanCode2[ScanCode2["FnLock"] = 4] = "FnLock";
  ScanCode2[ScanCode2["Suspend"] = 5] = "Suspend";
  ScanCode2[ScanCode2["Resume"] = 6] = "Resume";
  ScanCode2[ScanCode2["Turbo"] = 7] = "Turbo";
  ScanCode2[ScanCode2["Sleep"] = 8] = "Sleep";
  ScanCode2[ScanCode2["WakeUp"] = 9] = "WakeUp";
  ScanCode2[ScanCode2["KeyA"] = 10] = "KeyA";
  ScanCode2[ScanCode2["KeyB"] = 11] = "KeyB";
  ScanCode2[ScanCode2["KeyC"] = 12] = "KeyC";
  ScanCode2[ScanCode2["KeyD"] = 13] = "KeyD";
  ScanCode2[ScanCode2["KeyE"] = 14] = "KeyE";
  ScanCode2[ScanCode2["KeyF"] = 15] = "KeyF";
  ScanCode2[ScanCode2["KeyG"] = 16] = "KeyG";
  ScanCode2[ScanCode2["KeyH"] = 17] = "KeyH";
  ScanCode2[ScanCode2["KeyI"] = 18] = "KeyI";
  ScanCode2[ScanCode2["KeyJ"] = 19] = "KeyJ";
  ScanCode2[ScanCode2["KeyK"] = 20] = "KeyK";
  ScanCode2[ScanCode2["KeyL"] = 21] = "KeyL";
  ScanCode2[ScanCode2["KeyM"] = 22] = "KeyM";
  ScanCode2[ScanCode2["KeyN"] = 23] = "KeyN";
  ScanCode2[ScanCode2["KeyO"] = 24] = "KeyO";
  ScanCode2[ScanCode2["KeyP"] = 25] = "KeyP";
  ScanCode2[ScanCode2["KeyQ"] = 26] = "KeyQ";
  ScanCode2[ScanCode2["KeyR"] = 27] = "KeyR";
  ScanCode2[ScanCode2["KeyS"] = 28] = "KeyS";
  ScanCode2[ScanCode2["KeyT"] = 29] = "KeyT";
  ScanCode2[ScanCode2["KeyU"] = 30] = "KeyU";
  ScanCode2[ScanCode2["KeyV"] = 31] = "KeyV";
  ScanCode2[ScanCode2["KeyW"] = 32] = "KeyW";
  ScanCode2[ScanCode2["KeyX"] = 33] = "KeyX";
  ScanCode2[ScanCode2["KeyY"] = 34] = "KeyY";
  ScanCode2[ScanCode2["KeyZ"] = 35] = "KeyZ";
  ScanCode2[ScanCode2["Digit1"] = 36] = "Digit1";
  ScanCode2[ScanCode2["Digit2"] = 37] = "Digit2";
  ScanCode2[ScanCode2["Digit3"] = 38] = "Digit3";
  ScanCode2[ScanCode2["Digit4"] = 39] = "Digit4";
  ScanCode2[ScanCode2["Digit5"] = 40] = "Digit5";
  ScanCode2[ScanCode2["Digit6"] = 41] = "Digit6";
  ScanCode2[ScanCode2["Digit7"] = 42] = "Digit7";
  ScanCode2[ScanCode2["Digit8"] = 43] = "Digit8";
  ScanCode2[ScanCode2["Digit9"] = 44] = "Digit9";
  ScanCode2[ScanCode2["Digit0"] = 45] = "Digit0";
  ScanCode2[ScanCode2["Enter"] = 46] = "Enter";
  ScanCode2[ScanCode2["Escape"] = 47] = "Escape";
  ScanCode2[ScanCode2["Backspace"] = 48] = "Backspace";
  ScanCode2[ScanCode2["Tab"] = 49] = "Tab";
  ScanCode2[ScanCode2["Space"] = 50] = "Space";
  ScanCode2[ScanCode2["Minus"] = 51] = "Minus";
  ScanCode2[ScanCode2["Equal"] = 52] = "Equal";
  ScanCode2[ScanCode2["BracketLeft"] = 53] = "BracketLeft";
  ScanCode2[ScanCode2["BracketRight"] = 54] = "BracketRight";
  ScanCode2[ScanCode2["Backslash"] = 55] = "Backslash";
  ScanCode2[ScanCode2["IntlHash"] = 56] = "IntlHash";
  ScanCode2[ScanCode2["Semicolon"] = 57] = "Semicolon";
  ScanCode2[ScanCode2["Quote"] = 58] = "Quote";
  ScanCode2[ScanCode2["Backquote"] = 59] = "Backquote";
  ScanCode2[ScanCode2["Comma"] = 60] = "Comma";
  ScanCode2[ScanCode2["Period"] = 61] = "Period";
  ScanCode2[ScanCode2["Slash"] = 62] = "Slash";
  ScanCode2[ScanCode2["CapsLock"] = 63] = "CapsLock";
  ScanCode2[ScanCode2["F1"] = 64] = "F1";
  ScanCode2[ScanCode2["F2"] = 65] = "F2";
  ScanCode2[ScanCode2["F3"] = 66] = "F3";
  ScanCode2[ScanCode2["F4"] = 67] = "F4";
  ScanCode2[ScanCode2["F5"] = 68] = "F5";
  ScanCode2[ScanCode2["F6"] = 69] = "F6";
  ScanCode2[ScanCode2["F7"] = 70] = "F7";
  ScanCode2[ScanCode2["F8"] = 71] = "F8";
  ScanCode2[ScanCode2["F9"] = 72] = "F9";
  ScanCode2[ScanCode2["F10"] = 73] = "F10";
  ScanCode2[ScanCode2["F11"] = 74] = "F11";
  ScanCode2[ScanCode2["F12"] = 75] = "F12";
  ScanCode2[ScanCode2["PrintScreen"] = 76] = "PrintScreen";
  ScanCode2[ScanCode2["ScrollLock"] = 77] = "ScrollLock";
  ScanCode2[ScanCode2["Pause"] = 78] = "Pause";
  ScanCode2[ScanCode2["Insert"] = 79] = "Insert";
  ScanCode2[ScanCode2["Home"] = 80] = "Home";
  ScanCode2[ScanCode2["PageUp"] = 81] = "PageUp";
  ScanCode2[ScanCode2["Delete"] = 82] = "Delete";
  ScanCode2[ScanCode2["End"] = 83] = "End";
  ScanCode2[ScanCode2["PageDown"] = 84] = "PageDown";
  ScanCode2[ScanCode2["ArrowRight"] = 85] = "ArrowRight";
  ScanCode2[ScanCode2["ArrowLeft"] = 86] = "ArrowLeft";
  ScanCode2[ScanCode2["ArrowDown"] = 87] = "ArrowDown";
  ScanCode2[ScanCode2["ArrowUp"] = 88] = "ArrowUp";
  ScanCode2[ScanCode2["NumLock"] = 89] = "NumLock";
  ScanCode2[ScanCode2["NumpadDivide"] = 90] = "NumpadDivide";
  ScanCode2[ScanCode2["NumpadMultiply"] = 91] = "NumpadMultiply";
  ScanCode2[ScanCode2["NumpadSubtract"] = 92] = "NumpadSubtract";
  ScanCode2[ScanCode2["NumpadAdd"] = 93] = "NumpadAdd";
  ScanCode2[ScanCode2["NumpadEnter"] = 94] = "NumpadEnter";
  ScanCode2[ScanCode2["Numpad1"] = 95] = "Numpad1";
  ScanCode2[ScanCode2["Numpad2"] = 96] = "Numpad2";
  ScanCode2[ScanCode2["Numpad3"] = 97] = "Numpad3";
  ScanCode2[ScanCode2["Numpad4"] = 98] = "Numpad4";
  ScanCode2[ScanCode2["Numpad5"] = 99] = "Numpad5";
  ScanCode2[ScanCode2["Numpad6"] = 100] = "Numpad6";
  ScanCode2[ScanCode2["Numpad7"] = 101] = "Numpad7";
  ScanCode2[ScanCode2["Numpad8"] = 102] = "Numpad8";
  ScanCode2[ScanCode2["Numpad9"] = 103] = "Numpad9";
  ScanCode2[ScanCode2["Numpad0"] = 104] = "Numpad0";
  ScanCode2[ScanCode2["NumpadDecimal"] = 105] = "NumpadDecimal";
  ScanCode2[ScanCode2["IntlBackslash"] = 106] = "IntlBackslash";
  ScanCode2[ScanCode2["ContextMenu"] = 107] = "ContextMenu";
  ScanCode2[ScanCode2["Power"] = 108] = "Power";
  ScanCode2[ScanCode2["NumpadEqual"] = 109] = "NumpadEqual";
  ScanCode2[ScanCode2["F13"] = 110] = "F13";
  ScanCode2[ScanCode2["F14"] = 111] = "F14";
  ScanCode2[ScanCode2["F15"] = 112] = "F15";
  ScanCode2[ScanCode2["F16"] = 113] = "F16";
  ScanCode2[ScanCode2["F17"] = 114] = "F17";
  ScanCode2[ScanCode2["F18"] = 115] = "F18";
  ScanCode2[ScanCode2["F19"] = 116] = "F19";
  ScanCode2[ScanCode2["F20"] = 117] = "F20";
  ScanCode2[ScanCode2["F21"] = 118] = "F21";
  ScanCode2[ScanCode2["F22"] = 119] = "F22";
  ScanCode2[ScanCode2["F23"] = 120] = "F23";
  ScanCode2[ScanCode2["F24"] = 121] = "F24";
  ScanCode2[ScanCode2["Open"] = 122] = "Open";
  ScanCode2[ScanCode2["Help"] = 123] = "Help";
  ScanCode2[ScanCode2["Select"] = 124] = "Select";
  ScanCode2[ScanCode2["Again"] = 125] = "Again";
  ScanCode2[ScanCode2["Undo"] = 126] = "Undo";
  ScanCode2[ScanCode2["Cut"] = 127] = "Cut";
  ScanCode2[ScanCode2["Copy"] = 128] = "Copy";
  ScanCode2[ScanCode2["Paste"] = 129] = "Paste";
  ScanCode2[ScanCode2["Find"] = 130] = "Find";
  ScanCode2[ScanCode2["AudioVolumeMute"] = 131] = "AudioVolumeMute";
  ScanCode2[ScanCode2["AudioVolumeUp"] = 132] = "AudioVolumeUp";
  ScanCode2[ScanCode2["AudioVolumeDown"] = 133] = "AudioVolumeDown";
  ScanCode2[ScanCode2["NumpadComma"] = 134] = "NumpadComma";
  ScanCode2[ScanCode2["IntlRo"] = 135] = "IntlRo";
  ScanCode2[ScanCode2["KanaMode"] = 136] = "KanaMode";
  ScanCode2[ScanCode2["IntlYen"] = 137] = "IntlYen";
  ScanCode2[ScanCode2["Convert"] = 138] = "Convert";
  ScanCode2[ScanCode2["NonConvert"] = 139] = "NonConvert";
  ScanCode2[ScanCode2["Lang1"] = 140] = "Lang1";
  ScanCode2[ScanCode2["Lang2"] = 141] = "Lang2";
  ScanCode2[ScanCode2["Lang3"] = 142] = "Lang3";
  ScanCode2[ScanCode2["Lang4"] = 143] = "Lang4";
  ScanCode2[ScanCode2["Lang5"] = 144] = "Lang5";
  ScanCode2[ScanCode2["Abort"] = 145] = "Abort";
  ScanCode2[ScanCode2["Props"] = 146] = "Props";
  ScanCode2[ScanCode2["NumpadParenLeft"] = 147] = "NumpadParenLeft";
  ScanCode2[ScanCode2["NumpadParenRight"] = 148] = "NumpadParenRight";
  ScanCode2[ScanCode2["NumpadBackspace"] = 149] = "NumpadBackspace";
  ScanCode2[ScanCode2["NumpadMemoryStore"] = 150] = "NumpadMemoryStore";
  ScanCode2[ScanCode2["NumpadMemoryRecall"] = 151] = "NumpadMemoryRecall";
  ScanCode2[ScanCode2["NumpadMemoryClear"] = 152] = "NumpadMemoryClear";
  ScanCode2[ScanCode2["NumpadMemoryAdd"] = 153] = "NumpadMemoryAdd";
  ScanCode2[ScanCode2["NumpadMemorySubtract"] = 154] = "NumpadMemorySubtract";
  ScanCode2[ScanCode2["NumpadClear"] = 155] = "NumpadClear";
  ScanCode2[ScanCode2["NumpadClearEntry"] = 156] = "NumpadClearEntry";
  ScanCode2[ScanCode2["ControlLeft"] = 157] = "ControlLeft";
  ScanCode2[ScanCode2["ShiftLeft"] = 158] = "ShiftLeft";
  ScanCode2[ScanCode2["AltLeft"] = 159] = "AltLeft";
  ScanCode2[ScanCode2["MetaLeft"] = 160] = "MetaLeft";
  ScanCode2[ScanCode2["ControlRight"] = 161] = "ControlRight";
  ScanCode2[ScanCode2["ShiftRight"] = 162] = "ShiftRight";
  ScanCode2[ScanCode2["AltRight"] = 163] = "AltRight";
  ScanCode2[ScanCode2["MetaRight"] = 164] = "MetaRight";
  ScanCode2[ScanCode2["BrightnessUp"] = 165] = "BrightnessUp";
  ScanCode2[ScanCode2["BrightnessDown"] = 166] = "BrightnessDown";
  ScanCode2[ScanCode2["MediaPlay"] = 167] = "MediaPlay";
  ScanCode2[ScanCode2["MediaRecord"] = 168] = "MediaRecord";
  ScanCode2[ScanCode2["MediaFastForward"] = 169] = "MediaFastForward";
  ScanCode2[ScanCode2["MediaRewind"] = 170] = "MediaRewind";
  ScanCode2[ScanCode2["MediaTrackNext"] = 171] = "MediaTrackNext";
  ScanCode2[ScanCode2["MediaTrackPrevious"] = 172] = "MediaTrackPrevious";
  ScanCode2[ScanCode2["MediaStop"] = 173] = "MediaStop";
  ScanCode2[ScanCode2["Eject"] = 174] = "Eject";
  ScanCode2[ScanCode2["MediaPlayPause"] = 175] = "MediaPlayPause";
  ScanCode2[ScanCode2["MediaSelect"] = 176] = "MediaSelect";
  ScanCode2[ScanCode2["LaunchMail"] = 177] = "LaunchMail";
  ScanCode2[ScanCode2["LaunchApp2"] = 178] = "LaunchApp2";
  ScanCode2[ScanCode2["LaunchApp1"] = 179] = "LaunchApp1";
  ScanCode2[ScanCode2["SelectTask"] = 180] = "SelectTask";
  ScanCode2[ScanCode2["LaunchScreenSaver"] = 181] = "LaunchScreenSaver";
  ScanCode2[ScanCode2["BrowserSearch"] = 182] = "BrowserSearch";
  ScanCode2[ScanCode2["BrowserHome"] = 183] = "BrowserHome";
  ScanCode2[ScanCode2["BrowserBack"] = 184] = "BrowserBack";
  ScanCode2[ScanCode2["BrowserForward"] = 185] = "BrowserForward";
  ScanCode2[ScanCode2["BrowserStop"] = 186] = "BrowserStop";
  ScanCode2[ScanCode2["BrowserRefresh"] = 187] = "BrowserRefresh";
  ScanCode2[ScanCode2["BrowserFavorites"] = 188] = "BrowserFavorites";
  ScanCode2[ScanCode2["ZoomToggle"] = 189] = "ZoomToggle";
  ScanCode2[ScanCode2["MailReply"] = 190] = "MailReply";
  ScanCode2[ScanCode2["MailForward"] = 191] = "MailForward";
  ScanCode2[ScanCode2["MailSend"] = 192] = "MailSend";
  ScanCode2[ScanCode2["MAX_VALUE"] = 193] = "MAX_VALUE";
})(ScanCode || (ScanCode = {}));
var KeyCodeStrMap = class {
  constructor() {
    this._keyCodeToStr = [];
    this._strToKeyCode = /* @__PURE__ */ Object.create(null);
  }
  define(keyCode, str) {
    this._keyCodeToStr[keyCode] = str;
    this._strToKeyCode[str.toLowerCase()] = keyCode;
  }
  keyCodeToStr(keyCode) {
    return this._keyCodeToStr[keyCode];
  }
  strToKeyCode(str) {
    return this._strToKeyCode[str.toLowerCase()] || 0;
  }
};
var uiMap = new KeyCodeStrMap();
var userSettingsUSMap = new KeyCodeStrMap();
var userSettingsGeneralMap = new KeyCodeStrMap();
var $ds = new Array(230);
var $es = {};
var scanCodeIntToStr = [];
var scanCodeStrToInt = /* @__PURE__ */ Object.create(null);
var scanCodeLowerCaseStrToInt = /* @__PURE__ */ Object.create(null);
var $fs = {
  lowerCaseToEnum: (scanCode) => scanCodeLowerCaseStrToInt[scanCode] || 0,
  toEnum: (scanCode) => scanCodeStrToInt[scanCode] || 0,
  toString: (scanCode) => scanCodeIntToStr[scanCode] || "None"
};
var $gs = [];
var $hs = [];
for (let i = 0; i <= 193; i++) {
  $gs[i] = -1;
}
for (let i = 0; i <= 132; i++) {
  $hs[i] = -1;
}
(function() {
  const empty = "";
  const mappings = [
    // immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel
    [1, 0, "None", 0, "unknown", 0, "VK_UNKNOWN", empty, empty],
    [1, 1, "Hyper", 0, empty, 0, empty, empty, empty],
    [1, 2, "Super", 0, empty, 0, empty, empty, empty],
    [1, 3, "Fn", 0, empty, 0, empty, empty, empty],
    [1, 4, "FnLock", 0, empty, 0, empty, empty, empty],
    [1, 5, "Suspend", 0, empty, 0, empty, empty, empty],
    [1, 6, "Resume", 0, empty, 0, empty, empty, empty],
    [1, 7, "Turbo", 0, empty, 0, empty, empty, empty],
    [1, 8, "Sleep", 0, empty, 0, "VK_SLEEP", empty, empty],
    [1, 9, "WakeUp", 0, empty, 0, empty, empty, empty],
    [0, 10, "KeyA", 31, "A", 65, "VK_A", empty, empty],
    [0, 11, "KeyB", 32, "B", 66, "VK_B", empty, empty],
    [0, 12, "KeyC", 33, "C", 67, "VK_C", empty, empty],
    [0, 13, "KeyD", 34, "D", 68, "VK_D", empty, empty],
    [0, 14, "KeyE", 35, "E", 69, "VK_E", empty, empty],
    [0, 15, "KeyF", 36, "F", 70, "VK_F", empty, empty],
    [0, 16, "KeyG", 37, "G", 71, "VK_G", empty, empty],
    [0, 17, "KeyH", 38, "H", 72, "VK_H", empty, empty],
    [0, 18, "KeyI", 39, "I", 73, "VK_I", empty, empty],
    [0, 19, "KeyJ", 40, "J", 74, "VK_J", empty, empty],
    [0, 20, "KeyK", 41, "K", 75, "VK_K", empty, empty],
    [0, 21, "KeyL", 42, "L", 76, "VK_L", empty, empty],
    [0, 22, "KeyM", 43, "M", 77, "VK_M", empty, empty],
    [0, 23, "KeyN", 44, "N", 78, "VK_N", empty, empty],
    [0, 24, "KeyO", 45, "O", 79, "VK_O", empty, empty],
    [0, 25, "KeyP", 46, "P", 80, "VK_P", empty, empty],
    [0, 26, "KeyQ", 47, "Q", 81, "VK_Q", empty, empty],
    [0, 27, "KeyR", 48, "R", 82, "VK_R", empty, empty],
    [0, 28, "KeyS", 49, "S", 83, "VK_S", empty, empty],
    [0, 29, "KeyT", 50, "T", 84, "VK_T", empty, empty],
    [0, 30, "KeyU", 51, "U", 85, "VK_U", empty, empty],
    [0, 31, "KeyV", 52, "V", 86, "VK_V", empty, empty],
    [0, 32, "KeyW", 53, "W", 87, "VK_W", empty, empty],
    [0, 33, "KeyX", 54, "X", 88, "VK_X", empty, empty],
    [0, 34, "KeyY", 55, "Y", 89, "VK_Y", empty, empty],
    [0, 35, "KeyZ", 56, "Z", 90, "VK_Z", empty, empty],
    [0, 36, "Digit1", 22, "1", 49, "VK_1", empty, empty],
    [0, 37, "Digit2", 23, "2", 50, "VK_2", empty, empty],
    [0, 38, "Digit3", 24, "3", 51, "VK_3", empty, empty],
    [0, 39, "Digit4", 25, "4", 52, "VK_4", empty, empty],
    [0, 40, "Digit5", 26, "5", 53, "VK_5", empty, empty],
    [0, 41, "Digit6", 27, "6", 54, "VK_6", empty, empty],
    [0, 42, "Digit7", 28, "7", 55, "VK_7", empty, empty],
    [0, 43, "Digit8", 29, "8", 56, "VK_8", empty, empty],
    [0, 44, "Digit9", 30, "9", 57, "VK_9", empty, empty],
    [0, 45, "Digit0", 21, "0", 48, "VK_0", empty, empty],
    [1, 46, "Enter", 3, "Enter", 13, "VK_RETURN", empty, empty],
    [1, 47, "Escape", 9, "Escape", 27, "VK_ESCAPE", empty, empty],
    [1, 48, "Backspace", 1, "Backspace", 8, "VK_BACK", empty, empty],
    [1, 49, "Tab", 2, "Tab", 9, "VK_TAB", empty, empty],
    [1, 50, "Space", 10, "Space", 32, "VK_SPACE", empty, empty],
    [0, 51, "Minus", 88, "-", 189, "VK_OEM_MINUS", "-", "OEM_MINUS"],
    [0, 52, "Equal", 86, "=", 187, "VK_OEM_PLUS", "=", "OEM_PLUS"],
    [0, 53, "BracketLeft", 92, "[", 219, "VK_OEM_4", "[", "OEM_4"],
    [0, 54, "BracketRight", 94, "]", 221, "VK_OEM_6", "]", "OEM_6"],
    [0, 55, "Backslash", 93, "\\", 220, "VK_OEM_5", "\\", "OEM_5"],
    [0, 56, "IntlHash", 0, empty, 0, empty, empty, empty],
    // has been dropped from the w3c spec
    [0, 57, "Semicolon", 85, ";", 186, "VK_OEM_1", ";", "OEM_1"],
    [0, 58, "Quote", 95, "'", 222, "VK_OEM_7", "'", "OEM_7"],
    [0, 59, "Backquote", 91, "`", 192, "VK_OEM_3", "`", "OEM_3"],
    [0, 60, "Comma", 87, ",", 188, "VK_OEM_COMMA", ",", "OEM_COMMA"],
    [0, 61, "Period", 89, ".", 190, "VK_OEM_PERIOD", ".", "OEM_PERIOD"],
    [0, 62, "Slash", 90, "/", 191, "VK_OEM_2", "/", "OEM_2"],
    [1, 63, "CapsLock", 8, "CapsLock", 20, "VK_CAPITAL", empty, empty],
    [1, 64, "F1", 59, "F1", 112, "VK_F1", empty, empty],
    [1, 65, "F2", 60, "F2", 113, "VK_F2", empty, empty],
    [1, 66, "F3", 61, "F3", 114, "VK_F3", empty, empty],
    [1, 67, "F4", 62, "F4", 115, "VK_F4", empty, empty],
    [1, 68, "F5", 63, "F5", 116, "VK_F5", empty, empty],
    [1, 69, "F6", 64, "F6", 117, "VK_F6", empty, empty],
    [1, 70, "F7", 65, "F7", 118, "VK_F7", empty, empty],
    [1, 71, "F8", 66, "F8", 119, "VK_F8", empty, empty],
    [1, 72, "F9", 67, "F9", 120, "VK_F9", empty, empty],
    [1, 73, "F10", 68, "F10", 121, "VK_F10", empty, empty],
    [1, 74, "F11", 69, "F11", 122, "VK_F11", empty, empty],
    [1, 75, "F12", 70, "F12", 123, "VK_F12", empty, empty],
    [1, 76, "PrintScreen", 0, empty, 0, empty, empty, empty],
    [1, 77, "ScrollLock", 84, "ScrollLock", 145, "VK_SCROLL", empty, empty],
    [1, 78, "Pause", 7, "PauseBreak", 19, "VK_PAUSE", empty, empty],
    [1, 79, "Insert", 19, "Insert", 45, "VK_INSERT", empty, empty],
    [1, 80, "Home", 14, "Home", 36, "VK_HOME", empty, empty],
    [1, 81, "PageUp", 11, "PageUp", 33, "VK_PRIOR", empty, empty],
    [1, 82, "Delete", 20, "Delete", 46, "VK_DELETE", empty, empty],
    [1, 83, "End", 13, "End", 35, "VK_END", empty, empty],
    [1, 84, "PageDown", 12, "PageDown", 34, "VK_NEXT", empty, empty],
    [1, 85, "ArrowRight", 17, "RightArrow", 39, "VK_RIGHT", "Right", empty],
    [1, 86, "ArrowLeft", 15, "LeftArrow", 37, "VK_LEFT", "Left", empty],
    [1, 87, "ArrowDown", 18, "DownArrow", 40, "VK_DOWN", "Down", empty],
    [1, 88, "ArrowUp", 16, "UpArrow", 38, "VK_UP", "Up", empty],
    [1, 89, "NumLock", 83, "NumLock", 144, "VK_NUMLOCK", empty, empty],
    [1, 90, "NumpadDivide", 113, "NumPad_Divide", 111, "VK_DIVIDE", empty, empty],
    [1, 91, "NumpadMultiply", 108, "NumPad_Multiply", 106, "VK_MULTIPLY", empty, empty],
    [1, 92, "NumpadSubtract", 111, "NumPad_Subtract", 109, "VK_SUBTRACT", empty, empty],
    [1, 93, "NumpadAdd", 109, "NumPad_Add", 107, "VK_ADD", empty, empty],
    [1, 94, "NumpadEnter", 3, empty, 0, empty, empty, empty],
    [1, 95, "Numpad1", 99, "NumPad1", 97, "VK_NUMPAD1", empty, empty],
    [1, 96, "Numpad2", 100, "NumPad2", 98, "VK_NUMPAD2", empty, empty],
    [1, 97, "Numpad3", 101, "NumPad3", 99, "VK_NUMPAD3", empty, empty],
    [1, 98, "Numpad4", 102, "NumPad4", 100, "VK_NUMPAD4", empty, empty],
    [1, 99, "Numpad5", 103, "NumPad5", 101, "VK_NUMPAD5", empty, empty],
    [1, 100, "Numpad6", 104, "NumPad6", 102, "VK_NUMPAD6", empty, empty],
    [1, 101, "Numpad7", 105, "NumPad7", 103, "VK_NUMPAD7", empty, empty],
    [1, 102, "Numpad8", 106, "NumPad8", 104, "VK_NUMPAD8", empty, empty],
    [1, 103, "Numpad9", 107, "NumPad9", 105, "VK_NUMPAD9", empty, empty],
    [1, 104, "Numpad0", 98, "NumPad0", 96, "VK_NUMPAD0", empty, empty],
    [1, 105, "NumpadDecimal", 112, "NumPad_Decimal", 110, "VK_DECIMAL", empty, empty],
    [0, 106, "IntlBackslash", 97, "OEM_102", 226, "VK_OEM_102", empty, empty],
    [1, 107, "ContextMenu", 58, "ContextMenu", 93, empty, empty, empty],
    [1, 108, "Power", 0, empty, 0, empty, empty, empty],
    [1, 109, "NumpadEqual", 0, empty, 0, empty, empty, empty],
    [1, 110, "F13", 71, "F13", 124, "VK_F13", empty, empty],
    [1, 111, "F14", 72, "F14", 125, "VK_F14", empty, empty],
    [1, 112, "F15", 73, "F15", 126, "VK_F15", empty, empty],
    [1, 113, "F16", 74, "F16", 127, "VK_F16", empty, empty],
    [1, 114, "F17", 75, "F17", 128, "VK_F17", empty, empty],
    [1, 115, "F18", 76, "F18", 129, "VK_F18", empty, empty],
    [1, 116, "F19", 77, "F19", 130, "VK_F19", empty, empty],
    [1, 117, "F20", 78, "F20", 131, "VK_F20", empty, empty],
    [1, 118, "F21", 79, "F21", 132, "VK_F21", empty, empty],
    [1, 119, "F22", 80, "F22", 133, "VK_F22", empty, empty],
    [1, 120, "F23", 81, "F23", 134, "VK_F23", empty, empty],
    [1, 121, "F24", 82, "F24", 135, "VK_F24", empty, empty],
    [1, 122, "Open", 0, empty, 0, empty, empty, empty],
    [1, 123, "Help", 0, empty, 0, empty, empty, empty],
    [1, 124, "Select", 0, empty, 0, empty, empty, empty],
    [1, 125, "Again", 0, empty, 0, empty, empty, empty],
    [1, 126, "Undo", 0, empty, 0, empty, empty, empty],
    [1, 127, "Cut", 0, empty, 0, empty, empty, empty],
    [1, 128, "Copy", 0, empty, 0, empty, empty, empty],
    [1, 129, "Paste", 0, empty, 0, empty, empty, empty],
    [1, 130, "Find", 0, empty, 0, empty, empty, empty],
    [1, 131, "AudioVolumeMute", 117, "AudioVolumeMute", 173, "VK_VOLUME_MUTE", empty, empty],
    [1, 132, "AudioVolumeUp", 118, "AudioVolumeUp", 175, "VK_VOLUME_UP", empty, empty],
    [1, 133, "AudioVolumeDown", 119, "AudioVolumeDown", 174, "VK_VOLUME_DOWN", empty, empty],
    [1, 134, "NumpadComma", 110, "NumPad_Separator", 108, "VK_SEPARATOR", empty, empty],
    [0, 135, "IntlRo", 115, "ABNT_C1", 193, "VK_ABNT_C1", empty, empty],
    [1, 136, "KanaMode", 0, empty, 0, empty, empty, empty],
    [0, 137, "IntlYen", 0, empty, 0, empty, empty, empty],
    [1, 138, "Convert", 0, empty, 0, empty, empty, empty],
    [1, 139, "NonConvert", 0, empty, 0, empty, empty, empty],
    [1, 140, "Lang1", 0, empty, 0, empty, empty, empty],
    [1, 141, "Lang2", 0, empty, 0, empty, empty, empty],
    [1, 142, "Lang3", 0, empty, 0, empty, empty, empty],
    [1, 143, "Lang4", 0, empty, 0, empty, empty, empty],
    [1, 144, "Lang5", 0, empty, 0, empty, empty, empty],
    [1, 145, "Abort", 0, empty, 0, empty, empty, empty],
    [1, 146, "Props", 0, empty, 0, empty, empty, empty],
    [1, 147, "NumpadParenLeft", 0, empty, 0, empty, empty, empty],
    [1, 148, "NumpadParenRight", 0, empty, 0, empty, empty, empty],
    [1, 149, "NumpadBackspace", 0, empty, 0, empty, empty, empty],
    [1, 150, "NumpadMemoryStore", 0, empty, 0, empty, empty, empty],
    [1, 151, "NumpadMemoryRecall", 0, empty, 0, empty, empty, empty],
    [1, 152, "NumpadMemoryClear", 0, empty, 0, empty, empty, empty],
    [1, 153, "NumpadMemoryAdd", 0, empty, 0, empty, empty, empty],
    [1, 154, "NumpadMemorySubtract", 0, empty, 0, empty, empty, empty],
    [1, 155, "NumpadClear", 131, "Clear", 12, "VK_CLEAR", empty, empty],
    [1, 156, "NumpadClearEntry", 0, empty, 0, empty, empty, empty],
    [1, 0, empty, 5, "Ctrl", 17, "VK_CONTROL", empty, empty],
    [1, 0, empty, 4, "Shift", 16, "VK_SHIFT", empty, empty],
    [1, 0, empty, 6, "Alt", 18, "VK_MENU", empty, empty],
    [1, 0, empty, 57, "Meta", 91, "VK_COMMAND", empty, empty],
    [1, 157, "ControlLeft", 5, empty, 0, "VK_LCONTROL", empty, empty],
    [1, 158, "ShiftLeft", 4, empty, 0, "VK_LSHIFT", empty, empty],
    [1, 159, "AltLeft", 6, empty, 0, "VK_LMENU", empty, empty],
    [1, 160, "MetaLeft", 57, empty, 0, "VK_LWIN", empty, empty],
    [1, 161, "ControlRight", 5, empty, 0, "VK_RCONTROL", empty, empty],
    [1, 162, "ShiftRight", 4, empty, 0, "VK_RSHIFT", empty, empty],
    [1, 163, "AltRight", 6, empty, 0, "VK_RMENU", empty, empty],
    [1, 164, "MetaRight", 57, empty, 0, "VK_RWIN", empty, empty],
    [1, 165, "BrightnessUp", 0, empty, 0, empty, empty, empty],
    [1, 166, "BrightnessDown", 0, empty, 0, empty, empty, empty],
    [1, 167, "MediaPlay", 0, empty, 0, empty, empty, empty],
    [1, 168, "MediaRecord", 0, empty, 0, empty, empty, empty],
    [1, 169, "MediaFastForward", 0, empty, 0, empty, empty, empty],
    [1, 170, "MediaRewind", 0, empty, 0, empty, empty, empty],
    [1, 171, "MediaTrackNext", 124, "MediaTrackNext", 176, "VK_MEDIA_NEXT_TRACK", empty, empty],
    [1, 172, "MediaTrackPrevious", 125, "MediaTrackPrevious", 177, "VK_MEDIA_PREV_TRACK", empty, empty],
    [1, 173, "MediaStop", 126, "MediaStop", 178, "VK_MEDIA_STOP", empty, empty],
    [1, 174, "Eject", 0, empty, 0, empty, empty, empty],
    [1, 175, "MediaPlayPause", 127, "MediaPlayPause", 179, "VK_MEDIA_PLAY_PAUSE", empty, empty],
    [1, 176, "MediaSelect", 128, "LaunchMediaPlayer", 181, "VK_MEDIA_LAUNCH_MEDIA_SELECT", empty, empty],
    [1, 177, "LaunchMail", 129, "LaunchMail", 180, "VK_MEDIA_LAUNCH_MAIL", empty, empty],
    [1, 178, "LaunchApp2", 130, "LaunchApp2", 183, "VK_MEDIA_LAUNCH_APP2", empty, empty],
    [1, 179, "LaunchApp1", 0, empty, 0, "VK_MEDIA_LAUNCH_APP1", empty, empty],
    [1, 180, "SelectTask", 0, empty, 0, empty, empty, empty],
    [1, 181, "LaunchScreenSaver", 0, empty, 0, empty, empty, empty],
    [1, 182, "BrowserSearch", 120, "BrowserSearch", 170, "VK_BROWSER_SEARCH", empty, empty],
    [1, 183, "BrowserHome", 121, "BrowserHome", 172, "VK_BROWSER_HOME", empty, empty],
    [1, 184, "BrowserBack", 122, "BrowserBack", 166, "VK_BROWSER_BACK", empty, empty],
    [1, 185, "BrowserForward", 123, "BrowserForward", 167, "VK_BROWSER_FORWARD", empty, empty],
    [1, 186, "BrowserStop", 0, empty, 0, "VK_BROWSER_STOP", empty, empty],
    [1, 187, "BrowserRefresh", 0, empty, 0, "VK_BROWSER_REFRESH", empty, empty],
    [1, 188, "BrowserFavorites", 0, empty, 0, "VK_BROWSER_FAVORITES", empty, empty],
    [1, 189, "ZoomToggle", 0, empty, 0, empty, empty, empty],
    [1, 190, "MailReply", 0, empty, 0, empty, empty, empty],
    [1, 191, "MailForward", 0, empty, 0, empty, empty, empty],
    [1, 192, "MailSend", 0, empty, 0, empty, empty, empty],
    // See https://lists.w3.org/Archives/Public/www-dom/2010JulSep/att-0182/keyCode-spec.html
    // If an Input Method Editor is processing key input and the event is keydown, return 229.
    [1, 0, empty, 114, "KeyInComposition", 229, empty, empty, empty],
    [1, 0, empty, 116, "ABNT_C2", 194, "VK_ABNT_C2", empty, empty],
    [1, 0, empty, 96, "OEM_8", 223, "VK_OEM_8", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_KANA", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_HANGUL", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_JUNJA", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_FINAL", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_HANJA", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_KANJI", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_CONVERT", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_NONCONVERT", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_ACCEPT", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_MODECHANGE", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_SELECT", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_PRINT", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_EXECUTE", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_SNAPSHOT", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_HELP", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_APPS", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_PROCESSKEY", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_PACKET", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_DBE_SBCSCHAR", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_DBE_DBCSCHAR", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_ATTN", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_CRSEL", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_EXSEL", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_EREOF", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_PLAY", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_ZOOM", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_NONAME", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_PA1", empty, empty],
    [1, 0, empty, 0, empty, 0, "VK_OEM_CLEAR", empty, empty]
  ];
  const seenKeyCode = [];
  const seenScanCode = [];
  for (const mapping2 of mappings) {
    const [immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel] = mapping2;
    if (!seenScanCode[scanCode]) {
      seenScanCode[scanCode] = true;
      scanCodeIntToStr[scanCode] = scanCodeStr;
      scanCodeStrToInt[scanCodeStr] = scanCode;
      scanCodeLowerCaseStrToInt[scanCodeStr.toLowerCase()] = scanCode;
      if (immutable) {
        $gs[scanCode] = keyCode;
        if (keyCode !== 0 && keyCode !== 3 && keyCode !== 5 && keyCode !== 4 && keyCode !== 6 && keyCode !== 57) {
          $hs[keyCode] = scanCode;
        }
      }
    }
    if (!seenKeyCode[keyCode]) {
      seenKeyCode[keyCode] = true;
      if (!keyCodeStr) {
        throw new Error(`String representation missing for key code ${keyCode} around scan code ${scanCodeStr}`);
      }
      uiMap.define(keyCode, keyCodeStr);
      userSettingsUSMap.define(keyCode, usUserSettingsLabel || keyCodeStr);
      userSettingsGeneralMap.define(keyCode, generalUserSettingsLabel || usUserSettingsLabel || keyCodeStr);
    }
    if (eventKeyCode) {
      $ds[eventKeyCode] = keyCode;
    }
    if (vkey) {
      $es[vkey] = keyCode;
    }
  }
  $hs[
    3
    /* KeyCode.Enter */
  ] = 46;
})();
var KeyCodeUtils;
(function(KeyCodeUtils2) {
  function toString(keyCode) {
    return uiMap.keyCodeToStr(keyCode);
  }
  KeyCodeUtils2.toString = toString;
  function fromString(key) {
    return uiMap.strToKeyCode(key);
  }
  KeyCodeUtils2.fromString = fromString;
  function toUserSettingsUS(keyCode) {
    return userSettingsUSMap.keyCodeToStr(keyCode);
  }
  KeyCodeUtils2.toUserSettingsUS = toUserSettingsUS;
  function toUserSettingsGeneral(keyCode) {
    return userSettingsGeneralMap.keyCodeToStr(keyCode);
  }
  KeyCodeUtils2.toUserSettingsGeneral = toUserSettingsGeneral;
  function fromUserSettings(key) {
    return userSettingsUSMap.strToKeyCode(key) || userSettingsGeneralMap.strToKeyCode(key);
  }
  KeyCodeUtils2.fromUserSettings = fromUserSettings;
  function toElectronAccelerator(keyCode) {
    if (keyCode >= 98 && keyCode <= 113) {
      return null;
    }
    switch (keyCode) {
      case 16:
        return "Up";
      case 18:
        return "Down";
      case 15:
        return "Left";
      case 17:
        return "Right";
    }
    return uiMap.keyCodeToStr(keyCode);
  }
  KeyCodeUtils2.toElectronAccelerator = toElectronAccelerator;
})(KeyCodeUtils || (KeyCodeUtils = {}));
var KeyMod;
(function(KeyMod2) {
  KeyMod2[KeyMod2["CtrlCmd"] = 2048] = "CtrlCmd";
  KeyMod2[KeyMod2["Shift"] = 1024] = "Shift";
  KeyMod2[KeyMod2["Alt"] = 512] = "Alt";
  KeyMod2[KeyMod2["WinCtrl"] = 256] = "WinCtrl";
})(KeyMod || (KeyMod = {}));
function $is(firstPart, secondPart) {
  const chordPart = (secondPart & 65535) << 16 >>> 0;
  return (firstPart | chordPart) >>> 0;
}

// out-build/vs/base/common/keybindings.js
var BinaryKeybindingsMask;
(function(BinaryKeybindingsMask2) {
  BinaryKeybindingsMask2[BinaryKeybindingsMask2["CtrlCmd"] = 2048] = "CtrlCmd";
  BinaryKeybindingsMask2[BinaryKeybindingsMask2["Shift"] = 1024] = "Shift";
  BinaryKeybindingsMask2[BinaryKeybindingsMask2["Alt"] = 512] = "Alt";
  BinaryKeybindingsMask2[BinaryKeybindingsMask2["WinCtrl"] = 256] = "WinCtrl";
  BinaryKeybindingsMask2[BinaryKeybindingsMask2["KeyCode"] = 255] = "KeyCode";
})(BinaryKeybindingsMask || (BinaryKeybindingsMask = {}));
function $js(keybinding, OS2) {
  if (typeof keybinding === "number") {
    if (keybinding === 0) {
      return null;
    }
    const firstChord = (keybinding & 65535) >>> 0;
    const secondChord = (keybinding & 4294901760) >>> 16;
    if (secondChord !== 0) {
      return new $ns([
        $ks(firstChord, OS2),
        $ks(secondChord, OS2)
      ]);
    }
    return new $ns([$ks(firstChord, OS2)]);
  } else {
    const chords = [];
    for (let i = 0; i < keybinding.length; i++) {
      chords.push($ks(keybinding[i], OS2));
    }
    return new $ns(chords);
  }
}
function $ks(keybinding, OS2) {
  const ctrlCmd = keybinding & 2048 ? true : false;
  const winCtrl = keybinding & 256 ? true : false;
  const ctrlKey = OS2 === 2 ? winCtrl : ctrlCmd;
  const shiftKey = keybinding & 1024 ? true : false;
  const altKey = keybinding & 512 ? true : false;
  const metaKey = OS2 === 2 ? ctrlCmd : winCtrl;
  const keyCode = keybinding & 255;
  return new $ls(ctrlKey, shiftKey, altKey, metaKey, keyCode);
}
var $ls = class _$ls {
  constructor(ctrlKey, shiftKey, altKey, metaKey, keyCode) {
    this.ctrlKey = ctrlKey;
    this.shiftKey = shiftKey;
    this.altKey = altKey;
    this.metaKey = metaKey;
    this.keyCode = keyCode;
  }
  equals(other4) {
    return other4 instanceof _$ls && this.ctrlKey === other4.ctrlKey && this.shiftKey === other4.shiftKey && this.altKey === other4.altKey && this.metaKey === other4.metaKey && this.keyCode === other4.keyCode;
  }
  getHashCode() {
    const ctrl = this.ctrlKey ? "1" : "0";
    const shift = this.shiftKey ? "1" : "0";
    const alt = this.altKey ? "1" : "0";
    const meta = this.metaKey ? "1" : "0";
    return `K${ctrl}${shift}${alt}${meta}${this.keyCode}`;
  }
  isModifierKey() {
    return this.keyCode === 0 || this.keyCode === 5 || this.keyCode === 57 || this.keyCode === 6 || this.keyCode === 4;
  }
  toKeybinding() {
    return new $ns([this]);
  }
  /**
   * Does this keybinding refer to the key code of a modifier and it also has the modifier flag?
   */
  isDuplicateModifierCase() {
    return this.ctrlKey && this.keyCode === 5 || this.shiftKey && this.keyCode === 4 || this.altKey && this.keyCode === 6 || this.metaKey && this.keyCode === 57;
  }
};
var $ms = class _$ms {
  constructor(ctrlKey, shiftKey, altKey, metaKey, scanCode) {
    this.ctrlKey = ctrlKey;
    this.shiftKey = shiftKey;
    this.altKey = altKey;
    this.metaKey = metaKey;
    this.scanCode = scanCode;
  }
  equals(other4) {
    return other4 instanceof _$ms && this.ctrlKey === other4.ctrlKey && this.shiftKey === other4.shiftKey && this.altKey === other4.altKey && this.metaKey === other4.metaKey && this.scanCode === other4.scanCode;
  }
  getHashCode() {
    const ctrl = this.ctrlKey ? "1" : "0";
    const shift = this.shiftKey ? "1" : "0";
    const alt = this.altKey ? "1" : "0";
    const meta = this.metaKey ? "1" : "0";
    return `S${ctrl}${shift}${alt}${meta}${this.scanCode}`;
  }
  /**
   * Does this keybinding refer to the key code of a modifier and it also has the modifier flag?
   */
  isDuplicateModifierCase() {
    return this.ctrlKey && (this.scanCode === 157 || this.scanCode === 161) || this.shiftKey && (this.scanCode === 158 || this.scanCode === 162) || this.altKey && (this.scanCode === 159 || this.scanCode === 163) || this.metaKey && (this.scanCode === 160 || this.scanCode === 164);
  }
};
var $ns = class {
  constructor(chords) {
    if (chords.length === 0) {
      throw $hb(`chords`);
    }
    this.chords = chords;
  }
  getHashCode() {
    let result = "";
    for (let i = 0, len = this.chords.length; i < len; i++) {
      if (i !== 0) {
        result += ";";
      }
      result += this.chords[i].getHashCode();
    }
    return result;
  }
  equals(other4) {
    if (other4 === null) {
      return false;
    }
    if (this.chords.length !== other4.chords.length) {
      return false;
    }
    for (let i = 0; i < this.chords.length; i++) {
      if (!this.chords[i].equals(other4.chords[i])) {
        return false;
      }
    }
    return true;
  }
};
var $os = class {
  constructor(ctrlKey, shiftKey, altKey, metaKey, keyLabel, keyAriaLabel) {
    this.ctrlKey = ctrlKey;
    this.shiftKey = shiftKey;
    this.altKey = altKey;
    this.metaKey = metaKey;
    this.keyLabel = keyLabel;
    this.keyAriaLabel = keyAriaLabel;
  }
};
var $ps = class {
};

// out-build/vs/base/browser/keyboardEvent.js
function extractKeyCode(e) {
  if (e.charCode) {
    const char = String.fromCharCode(e.charCode).toUpperCase();
    return KeyCodeUtils.fromString(char);
  }
  const keyCode = e.keyCode;
  if (keyCode === 3) {
    return 7;
  } else if ($mT) {
    switch (keyCode) {
      case 59:
        return 85;
      case 60:
        if ($n) {
          return 97;
        }
        break;
      case 61:
        return 86;
      case 107:
        return 109;
      case 109:
        return 111;
      case 173:
        return 88;
      case 224:
        if ($m) {
          return 57;
        }
        break;
    }
  } else if ($nT) {
    if ($m && keyCode === 93) {
      return 57;
    } else if (!$m && keyCode === 92) {
      return 57;
    }
  }
  return $ds[keyCode] || 0;
}
var ctrlKeyMod = $m ? 256 : 2048;
var altKeyMod = 512;
var shiftKeyMod = 1024;
var metaKeyMod = $m ? 2048 : 256;
function $CT(e) {
  const modifiers = [];
  if (e.ctrlKey) {
    modifiers.push(`ctrl`);
  }
  if (e.shiftKey) {
    modifiers.push(`shift`);
  }
  if (e.altKey) {
    modifiers.push(`alt`);
  }
  if (e.metaKey) {
    modifiers.push(`meta`);
  }
  return `modifiers: [${modifiers.join(",")}], code: ${e.code}, keyCode: ${e.keyCode}, key: ${e.key}`;
}
function $DT(e) {
  const modifiers = [];
  if (e.ctrlKey) {
    modifiers.push(`ctrl`);
  }
  if (e.shiftKey) {
    modifiers.push(`shift`);
  }
  if (e.altKey) {
    modifiers.push(`alt`);
  }
  if (e.metaKey) {
    modifiers.push(`meta`);
  }
  return `modifiers: [${modifiers.join(",")}], code: ${e.code}, keyCode: ${e.keyCode} ('${KeyCodeUtils.toString(e.keyCode)}')`;
}
var $ET = class {
  constructor(source) {
    this._standardKeyboardEventBrand = true;
    const e = source;
    this.browserEvent = e;
    this.target = e.target;
    this.ctrlKey = e.ctrlKey;
    this.shiftKey = e.shiftKey;
    this.altKey = e.altKey;
    this.metaKey = e.metaKey;
    this.altGraphKey = e.getModifierState?.("AltGraph");
    this.keyCode = extractKeyCode(e);
    this.code = e.code;
    this.ctrlKey = this.ctrlKey || this.keyCode === 5;
    this.altKey = this.altKey || this.keyCode === 6;
    this.shiftKey = this.shiftKey || this.keyCode === 4;
    this.metaKey = this.metaKey || this.keyCode === 57;
    this.a = this.c();
    this.b = this.d();
  }
  preventDefault() {
    if (this.browserEvent && this.browserEvent.preventDefault) {
      this.browserEvent.preventDefault();
    }
  }
  stopPropagation() {
    if (this.browserEvent && this.browserEvent.stopPropagation) {
      this.browserEvent.stopPropagation();
    }
  }
  toKeyCodeChord() {
    return this.b;
  }
  equals(other4) {
    return this.a === other4;
  }
  c() {
    let key = 0;
    if (this.keyCode !== 5 && this.keyCode !== 4 && this.keyCode !== 6 && this.keyCode !== 57) {
      key = this.keyCode;
    }
    let result = 0;
    if (this.ctrlKey) {
      result |= ctrlKeyMod;
    }
    if (this.altKey) {
      result |= altKeyMod;
    }
    if (this.shiftKey) {
      result |= shiftKeyMod;
    }
    if (this.metaKey) {
      result |= metaKeyMod;
    }
    result |= key;
    return result;
  }
  d() {
    let key = 0;
    if (this.keyCode !== 5 && this.keyCode !== 4 && this.keyCode !== 6 && this.keyCode !== 57) {
      key = this.keyCode;
    }
    return new $ls(this.ctrlKey, this.shiftKey, this.altKey, this.metaKey, key);
  }
};

// out-build/vs/base/browser/iframe.js
var sameOriginWindowChainCache = /* @__PURE__ */ new WeakMap();
function getParentWindowIfSameOrigin(w) {
  if (!w.parent || w.parent === w) {
    return null;
  }
  try {
    const location2 = w.location;
    const parentLocation = w.parent.location;
    if (location2.origin !== "null" && parentLocation.origin !== "null" && location2.origin !== parentLocation.origin) {
      return null;
    }
  } catch (e) {
    return null;
  }
  return w.parent;
}
var $xT = class {
  /**
   * Returns a chain of embedded windows with the same origin (which can be accessed programmatically).
   * Having a chain of length 1 might mean that the current execution environment is running outside of an iframe or inside an iframe embedded in a window with a different origin.
   */
  static a(targetWindow) {
    let windowChainCache = sameOriginWindowChainCache.get(targetWindow);
    if (!windowChainCache) {
      windowChainCache = [];
      sameOriginWindowChainCache.set(targetWindow, windowChainCache);
      let w = targetWindow;
      let parent;
      do {
        parent = getParentWindowIfSameOrigin(w);
        if (parent) {
          windowChainCache.push({
            window: new WeakRef(w),
            iframeElement: w.frameElement || null
          });
        } else {
          windowChainCache.push({
            window: new WeakRef(w),
            iframeElement: null
          });
        }
        w = parent;
      } while (w);
    }
    return windowChainCache.slice(0);
  }
  /**
   * Returns the position of `childWindow` relative to `ancestorWindow`
   */
  static getPositionOfChildWindowRelativeToAncestorWindow(childWindow, ancestorWindow) {
    if (!ancestorWindow || childWindow === ancestorWindow) {
      return {
        top: 0,
        left: 0
      };
    }
    let top2 = 0, left = 0;
    const windowChain = this.a(childWindow);
    for (const windowChainEl of windowChain) {
      const windowInChain = windowChainEl.window.deref();
      top2 += windowInChain?.scrollY ?? 0;
      left += windowInChain?.scrollX ?? 0;
      if (windowInChain === ancestorWindow) {
        break;
      }
      if (!windowChainEl.iframeElement) {
        break;
      }
      const boundingRect = windowChainEl.iframeElement.getBoundingClientRect();
      top2 += boundingRect.top;
      left += boundingRect.left;
    }
    return {
      top: top2,
      left
    };
  }
};
async function $yT(parentOrigin, salt) {
  if (!crypto.subtle) {
    throw new Error(`'crypto.subtle' is not available so webviews will not work. This is likely because the editor is not running in a secure context (https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts).`);
  }
  const strData = JSON.stringify({ parentOrigin, salt });
  const encoder = new TextEncoder();
  const arrData = encoder.encode(strData);
  const hash = await crypto.subtle.digest("sha-256", arrData);
  return sha256AsBase32(hash);
}
function sha256AsBase32(bytes) {
  const array2 = Array.from(new Uint8Array(bytes));
  const hexArray = array2.map((b) => b.toString(16).padStart(2, "0")).join("");
  return BigInt(`0x${hexArray}`).toString(32).padStart(52, "0");
}

// out-build/vs/base/browser/mouseEvent.js
var $zT = class {
  constructor(targetWindow, e) {
    this.timestamp = Date.now();
    this.browserEvent = e;
    this.leftButton = e.button === 0;
    this.middleButton = e.button === 1;
    this.rightButton = e.button === 2;
    this.buttons = e.buttons;
    this.target = e.target;
    this.detail = e.detail || 1;
    if (e.type === "dblclick") {
      this.detail = 2;
    }
    this.ctrlKey = e.ctrlKey;
    this.shiftKey = e.shiftKey;
    this.altKey = e.altKey;
    this.metaKey = e.metaKey;
    if (typeof e.pageX === "number") {
      this.posx = e.pageX;
      this.posy = e.pageY;
    } else {
      this.posx = e.clientX + this.target.ownerDocument.body.scrollLeft + this.target.ownerDocument.documentElement.scrollLeft;
      this.posy = e.clientY + this.target.ownerDocument.body.scrollTop + this.target.ownerDocument.documentElement.scrollTop;
    }
    const iframeOffsets = $xT.getPositionOfChildWindowRelativeToAncestorWindow(targetWindow, e.view);
    this.posx -= iframeOffsets.left;
    this.posy -= iframeOffsets.top;
  }
  preventDefault() {
    this.browserEvent.preventDefault();
  }
  stopPropagation() {
    this.browserEvent.stopPropagation();
  }
};
var $BT = class {
  constructor(e, deltaX = 0, deltaY = 0) {
    this.browserEvent = e || null;
    this.target = e ? e.target || e.targetNode || e.srcElement : null;
    this.deltaY = deltaY;
    this.deltaX = deltaX;
    let shouldFactorDPR = false;
    if ($oT) {
      const chromeVersionMatch = navigator.userAgent.match(/Chrome\/(\d+)/);
      const chromeMajorVersion = chromeVersionMatch ? parseInt(chromeVersionMatch[1]) : 123;
      shouldFactorDPR = chromeMajorVersion <= 122;
    }
    if (e) {
      const e1 = e;
      const e2 = e;
      const devicePixelRatio = e.view?.devicePixelRatio || 1;
      if (typeof e1.wheelDeltaY !== "undefined") {
        if (shouldFactorDPR) {
          this.deltaY = e1.wheelDeltaY / (120 * devicePixelRatio);
        } else {
          this.deltaY = e1.wheelDeltaY / 120;
        }
      } else if (typeof e2.VERTICAL_AXIS !== "undefined" && e2.axis === e2.VERTICAL_AXIS) {
        this.deltaY = -e2.detail / 3;
      } else if (e.type === "wheel") {
        const ev = e;
        if (ev.deltaMode === ev.DOM_DELTA_LINE) {
          if ($mT && !$m) {
            this.deltaY = -e.deltaY / 3;
          } else {
            this.deltaY = -e.deltaY;
          }
        } else {
          this.deltaY = -e.deltaY / 40;
        }
      }
      if (typeof e1.wheelDeltaX !== "undefined") {
        if ($pT && $l) {
          this.deltaX = -(e1.wheelDeltaX / 120);
        } else if (shouldFactorDPR) {
          this.deltaX = e1.wheelDeltaX / (120 * devicePixelRatio);
        } else {
          this.deltaX = e1.wheelDeltaX / 120;
        }
      } else if (typeof e2.HORIZONTAL_AXIS !== "undefined" && e2.axis === e2.HORIZONTAL_AXIS) {
        this.deltaX = -e.detail / 3;
      } else if (e.type === "wheel") {
        const ev = e;
        if (ev.deltaMode === ev.DOM_DELTA_LINE) {
          if ($mT && !$m) {
            this.deltaX = -e.deltaX / 3;
          } else {
            this.deltaX = -e.deltaX;
          }
        } else {
          this.deltaX = -e.deltaX / 40;
        }
      }
      if (this.deltaY === 0 && this.deltaX === 0 && e.wheelDelta) {
        if (shouldFactorDPR) {
          this.deltaY = e.wheelDelta / (120 * devicePixelRatio);
        } else {
          this.deltaY = e.wheelDelta / 120;
        }
      }
    }
  }
  preventDefault() {
    this.browserEvent?.preventDefault();
  }
  stopPropagation() {
    this.browserEvent?.stopPropagation();
  }
};

// out-build/vs/base/common/cancellation.js
var shortcutEvent = Object.freeze(function(callback, context) {
  const handle2 = setTimeout(callback.bind(context), 0);
  return { dispose() {
    clearTimeout(handle2);
  } };
});
var CancellationToken;
(function(CancellationToken2) {
  function isCancellationToken(thing) {
    if (thing === CancellationToken2.None || thing === CancellationToken2.Cancelled) {
      return true;
    }
    if (thing instanceof MutableToken) {
      return true;
    }
    if (!thing || typeof thing !== "object") {
      return false;
    }
    return typeof thing.isCancellationRequested === "boolean" && typeof thing.onCancellationRequested === "function";
  }
  CancellationToken2.isCancellationToken = isCancellationToken;
  CancellationToken2.None = Object.freeze({
    isCancellationRequested: false,
    onCancellationRequested: Event2.None
  });
  CancellationToken2.Cancelled = Object.freeze({
    isCancellationRequested: true,
    onCancellationRequested: shortcutEvent
  });
})(CancellationToken || (CancellationToken = {}));
var MutableToken = class {
  constructor() {
    this.a = false;
    this.b = null;
  }
  cancel() {
    if (!this.a) {
      this.a = true;
      if (this.b) {
        this.b.fire(void 0);
        this.dispose();
      }
    }
  }
  get isCancellationRequested() {
    return this.a;
  }
  get onCancellationRequested() {
    if (this.a) {
      return shortcutEvent;
    }
    if (!this.b) {
      this.b = new $De();
    }
    return this.b.event;
  }
  dispose() {
    if (this.b) {
      this.b.dispose();
      this.b = null;
    }
  }
};
var $Pe = class {
  constructor(parent) {
    this.f = void 0;
    this.g = void 0;
    this.g = parent && parent.onCancellationRequested(this.cancel, this);
  }
  get token() {
    if (!this.f) {
      this.f = new MutableToken();
    }
    return this.f;
  }
  cancel() {
    if (!this.f) {
      this.f = CancellationToken.Cancelled;
    } else if (this.f instanceof MutableToken) {
      this.f.cancel();
    }
  }
  dispose(cancel = false) {
    if (cancel) {
      this.cancel();
    }
    this.g?.dispose();
    if (!this.f) {
      this.f = CancellationToken.None;
    } else if (this.f instanceof MutableToken) {
      this.f.dispose();
    }
  }
};
function $Qe(store) {
  const source = new $Pe();
  store.add({ dispose() {
    source.cancel();
  } });
  return source.token;
}

// out-build/vs/base/common/process.js
var safeProcess;
var vscodeGlobal = globalThis.vscode;
if (typeof vscodeGlobal !== "undefined" && typeof vscodeGlobal.process !== "undefined") {
  const sandboxProcess = vscodeGlobal.process;
  safeProcess = {
    get platform() {
      return sandboxProcess.platform;
    },
    get arch() {
      return sandboxProcess.arch;
    },
    get env() {
      return sandboxProcess.env;
    },
    cwd() {
      return sandboxProcess.cwd();
    }
  };
} else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
  safeProcess = {
    get platform() {
      return process.platform;
    },
    get arch() {
      return process.arch;
    },
    get env() {
      return process.env;
    },
    cwd() {
      return process.env["VSCODE_CWD"] || process.cwd();
    }
  };
} else {
  safeProcess = {
    // Supported
    get platform() {
      return $l ? "win32" : $m ? "darwin" : "linux";
    },
    get arch() {
      return void 0;
    },
    // Unsupported
    get env() {
      return {};
    },
    cwd() {
      return "/";
    }
  };
}
var cwd = safeProcess.cwd;
var env = safeProcess.env;
var $pc = safeProcess.platform;
var $qc = safeProcess.arch;

// out-build/vs/base/common/path.js
var CHAR_UPPERCASE_A = 65;
var CHAR_LOWERCASE_A = 97;
var CHAR_UPPERCASE_Z = 90;
var CHAR_LOWERCASE_Z = 122;
var CHAR_DOT = 46;
var CHAR_FORWARD_SLASH = 47;
var CHAR_BACKWARD_SLASH = 92;
var CHAR_COLON = 58;
var CHAR_QUESTION_MARK = 63;
var ErrorInvalidArgType = class extends Error {
  constructor(name, expected, actual) {
    let determiner;
    if (typeof expected === "string" && expected.indexOf("not ") === 0) {
      determiner = "must not be";
      expected = expected.replace(/^not /, "");
    } else {
      determiner = "must be";
    }
    const type = name.indexOf(".") !== -1 ? "property" : "argument";
    let msg = `The "${name}" ${type} ${determiner} of type ${expected}`;
    msg += `. Received type ${typeof actual}`;
    super(msg);
    this.code = "ERR_INVALID_ARG_TYPE";
  }
};
function validateObject(pathObject, name) {
  if (pathObject === null || typeof pathObject !== "object") {
    throw new ErrorInvalidArgType(name, "Object", pathObject);
  }
}
function validateString(value, name) {
  if (typeof value !== "string") {
    throw new ErrorInvalidArgType(name, "string", value);
  }
}
var platformIsWin32 = $pc === "win32";
function isPathSeparator(code) {
  return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
}
function isPosixPathSeparator(code) {
  return code === CHAR_FORWARD_SLASH;
}
function isWindowsDeviceRoot(code) {
  return code >= CHAR_UPPERCASE_A && code <= CHAR_UPPERCASE_Z || code >= CHAR_LOWERCASE_A && code <= CHAR_LOWERCASE_Z;
}
function normalizeString(path, allowAboveRoot, separator, isPathSeparator2) {
  let res = "";
  let lastSegmentLength = 0;
  let lastSlash = -1;
  let dots = 0;
  let code = 0;
  for (let i = 0; i <= path.length; ++i) {
    if (i < path.length) {
      code = path.charCodeAt(i);
    } else if (isPathSeparator2(code)) {
      break;
    } else {
      code = CHAR_FORWARD_SLASH;
    }
    if (isPathSeparator2(code)) {
      if (lastSlash === i - 1 || dots === 1) {
      } else if (dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== CHAR_DOT || res.charCodeAt(res.length - 2) !== CHAR_DOT) {
          if (res.length > 2) {
            const lastSlashIndex = res.lastIndexOf(separator);
            if (lastSlashIndex === -1) {
              res = "";
              lastSegmentLength = 0;
            } else {
              res = res.slice(0, lastSlashIndex);
              lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
            }
            lastSlash = i;
            dots = 0;
            continue;
          } else if (res.length !== 0) {
            res = "";
            lastSegmentLength = 0;
            lastSlash = i;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          res += res.length > 0 ? `${separator}..` : "..";
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) {
          res += `${separator}${path.slice(lastSlash + 1, i)}`;
        } else {
          res = path.slice(lastSlash + 1, i);
        }
        lastSegmentLength = i - lastSlash - 1;
      }
      lastSlash = i;
      dots = 0;
    } else if (code === CHAR_DOT && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
function formatExt(ext) {
  return ext ? `${ext[0] === "." ? "" : "."}${ext}` : "";
}
function _format2(sep2, pathObject) {
  validateObject(pathObject, "pathObject");
  const dir = pathObject.dir || pathObject.root;
  const base = pathObject.base || `${pathObject.name || ""}${formatExt(pathObject.ext)}`;
  if (!dir) {
    return base;
  }
  return dir === pathObject.root ? `${dir}${base}` : `${dir}${sep2}${base}`;
}
var $rc = {
  // path.resolve([from ...], to)
  resolve(...pathSegments) {
    let resolvedDevice = "";
    let resolvedTail = "";
    let resolvedAbsolute = false;
    for (let i = pathSegments.length - 1; i >= -1; i--) {
      let path;
      if (i >= 0) {
        path = pathSegments[i];
        validateString(path, `paths[${i}]`);
        if (path.length === 0) {
          continue;
        }
      } else if (resolvedDevice.length === 0) {
        path = cwd();
      } else {
        path = env[`=${resolvedDevice}`] || cwd();
        if (path === void 0 || path.slice(0, 2).toLowerCase() !== resolvedDevice.toLowerCase() && path.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
          path = `${resolvedDevice}\\`;
        }
      }
      const len = path.length;
      let rootEnd = 0;
      let device = "";
      let isAbsolute = false;
      const code = path.charCodeAt(0);
      if (len === 1) {
        if (isPathSeparator(code)) {
          rootEnd = 1;
          isAbsolute = true;
        }
      } else if (isPathSeparator(code)) {
        isAbsolute = true;
        if (isPathSeparator(path.charCodeAt(1))) {
          let j = 2;
          let last = j;
          while (j < len && !isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            const firstPart = path.slice(last, j);
            last = j;
            while (j < len && isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j === len || j !== last) {
                device = `\\\\${firstPart}\\${path.slice(last, j)}`;
                rootEnd = j;
              }
            }
          }
        } else {
          rootEnd = 1;
        }
      } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
        device = path.slice(0, 2);
        rootEnd = 2;
        if (len > 2 && isPathSeparator(path.charCodeAt(2))) {
          isAbsolute = true;
          rootEnd = 3;
        }
      }
      if (device.length > 0) {
        if (resolvedDevice.length > 0) {
          if (device.toLowerCase() !== resolvedDevice.toLowerCase()) {
            continue;
          }
        } else {
          resolvedDevice = device;
        }
      }
      if (resolvedAbsolute) {
        if (resolvedDevice.length > 0) {
          break;
        }
      } else {
        resolvedTail = `${path.slice(rootEnd)}\\${resolvedTail}`;
        resolvedAbsolute = isAbsolute;
        if (isAbsolute && resolvedDevice.length > 0) {
          break;
        }
      }
    }
    resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
    return resolvedAbsolute ? `${resolvedDevice}\\${resolvedTail}` : `${resolvedDevice}${resolvedTail}` || ".";
  },
  normalize(path) {
    validateString(path, "path");
    const len = path.length;
    if (len === 0) {
      return ".";
    }
    let rootEnd = 0;
    let device;
    let isAbsolute = false;
    const code = path.charCodeAt(0);
    if (len === 1) {
      return isPosixPathSeparator(code) ? "\\" : path;
    }
    if (isPathSeparator(code)) {
      isAbsolute = true;
      if (isPathSeparator(path.charCodeAt(1))) {
        let j = 2;
        let last = j;
        while (j < len && !isPathSeparator(path.charCodeAt(j))) {
          j++;
        }
        if (j < len && j !== last) {
          const firstPart = path.slice(last, j);
          last = j;
          while (j < len && isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            last = j;
            while (j < len && !isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j === len) {
              return `\\\\${firstPart}\\${path.slice(last)}\\`;
            }
            if (j !== last) {
              device = `\\\\${firstPart}\\${path.slice(last, j)}`;
              rootEnd = j;
            }
          }
        }
      } else {
        rootEnd = 1;
      }
    } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
      device = path.slice(0, 2);
      rootEnd = 2;
      if (len > 2 && isPathSeparator(path.charCodeAt(2))) {
        isAbsolute = true;
        rootEnd = 3;
      }
    }
    let tail = rootEnd < len ? normalizeString(path.slice(rootEnd), !isAbsolute, "\\", isPathSeparator) : "";
    if (tail.length === 0 && !isAbsolute) {
      tail = ".";
    }
    if (tail.length > 0 && isPathSeparator(path.charCodeAt(len - 1))) {
      tail += "\\";
    }
    if (device === void 0) {
      return isAbsolute ? `\\${tail}` : tail;
    }
    return isAbsolute ? `${device}\\${tail}` : `${device}${tail}`;
  },
  isAbsolute(path) {
    validateString(path, "path");
    const len = path.length;
    if (len === 0) {
      return false;
    }
    const code = path.charCodeAt(0);
    return isPathSeparator(code) || // Possible device root
    len > 2 && isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON && isPathSeparator(path.charCodeAt(2));
  },
  join(...paths) {
    if (paths.length === 0) {
      return ".";
    }
    let joined;
    let firstPart;
    for (let i = 0; i < paths.length; ++i) {
      const arg = paths[i];
      validateString(arg, "path");
      if (arg.length > 0) {
        if (joined === void 0) {
          joined = firstPart = arg;
        } else {
          joined += `\\${arg}`;
        }
      }
    }
    if (joined === void 0) {
      return ".";
    }
    let needsReplace = true;
    let slashCount = 0;
    if (typeof firstPart === "string" && isPathSeparator(firstPart.charCodeAt(0))) {
      ++slashCount;
      const firstLen = firstPart.length;
      if (firstLen > 1 && isPathSeparator(firstPart.charCodeAt(1))) {
        ++slashCount;
        if (firstLen > 2) {
          if (isPathSeparator(firstPart.charCodeAt(2))) {
            ++slashCount;
          } else {
            needsReplace = false;
          }
        }
      }
    }
    if (needsReplace) {
      while (slashCount < joined.length && isPathSeparator(joined.charCodeAt(slashCount))) {
        slashCount++;
      }
      if (slashCount >= 2) {
        joined = `\\${joined.slice(slashCount)}`;
      }
    }
    return $rc.normalize(joined);
  },
  // It will solve the relative path from `from` to `to`, for instance:
  //  from = 'C:\\orandea\\test\\aaa'
  //  to = 'C:\\orandea\\impl\\bbb'
  // The output of the function should be: '..\\..\\impl\\bbb'
  relative(from, to) {
    validateString(from, "from");
    validateString(to, "to");
    if (from === to) {
      return "";
    }
    const fromOrig = $rc.resolve(from);
    const toOrig = $rc.resolve(to);
    if (fromOrig === toOrig) {
      return "";
    }
    from = fromOrig.toLowerCase();
    to = toOrig.toLowerCase();
    if (from === to) {
      return "";
    }
    let fromStart = 0;
    while (fromStart < from.length && from.charCodeAt(fromStart) === CHAR_BACKWARD_SLASH) {
      fromStart++;
    }
    let fromEnd = from.length;
    while (fromEnd - 1 > fromStart && from.charCodeAt(fromEnd - 1) === CHAR_BACKWARD_SLASH) {
      fromEnd--;
    }
    const fromLen = fromEnd - fromStart;
    let toStart = 0;
    while (toStart < to.length && to.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
      toStart++;
    }
    let toEnd = to.length;
    while (toEnd - 1 > toStart && to.charCodeAt(toEnd - 1) === CHAR_BACKWARD_SLASH) {
      toEnd--;
    }
    const toLen = toEnd - toStart;
    const length = fromLen < toLen ? fromLen : toLen;
    let lastCommonSep = -1;
    let i = 0;
    for (; i < length; i++) {
      const fromCode = from.charCodeAt(fromStart + i);
      if (fromCode !== to.charCodeAt(toStart + i)) {
        break;
      } else if (fromCode === CHAR_BACKWARD_SLASH) {
        lastCommonSep = i;
      }
    }
    if (i !== length) {
      if (lastCommonSep === -1) {
        return toOrig;
      }
    } else {
      if (toLen > length) {
        if (to.charCodeAt(toStart + i) === CHAR_BACKWARD_SLASH) {
          return toOrig.slice(toStart + i + 1);
        }
        if (i === 2) {
          return toOrig.slice(toStart + i);
        }
      }
      if (fromLen > length) {
        if (from.charCodeAt(fromStart + i) === CHAR_BACKWARD_SLASH) {
          lastCommonSep = i;
        } else if (i === 2) {
          lastCommonSep = 3;
        }
      }
      if (lastCommonSep === -1) {
        lastCommonSep = 0;
      }
    }
    let out = "";
    for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
      if (i === fromEnd || from.charCodeAt(i) === CHAR_BACKWARD_SLASH) {
        out += out.length === 0 ? ".." : "\\..";
      }
    }
    toStart += lastCommonSep;
    if (out.length > 0) {
      return `${out}${toOrig.slice(toStart, toEnd)}`;
    }
    if (toOrig.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
      ++toStart;
    }
    return toOrig.slice(toStart, toEnd);
  },
  toNamespacedPath(path) {
    if (typeof path !== "string" || path.length === 0) {
      return path;
    }
    const resolvedPath = $rc.resolve(path);
    if (resolvedPath.length <= 2) {
      return path;
    }
    if (resolvedPath.charCodeAt(0) === CHAR_BACKWARD_SLASH) {
      if (resolvedPath.charCodeAt(1) === CHAR_BACKWARD_SLASH) {
        const code = resolvedPath.charCodeAt(2);
        if (code !== CHAR_QUESTION_MARK && code !== CHAR_DOT) {
          return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
        }
      }
    } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0)) && resolvedPath.charCodeAt(1) === CHAR_COLON && resolvedPath.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
      return `\\\\?\\${resolvedPath}`;
    }
    return path;
  },
  dirname(path) {
    validateString(path, "path");
    const len = path.length;
    if (len === 0) {
      return ".";
    }
    let rootEnd = -1;
    let offset = 0;
    const code = path.charCodeAt(0);
    if (len === 1) {
      return isPathSeparator(code) ? path : ".";
    }
    if (isPathSeparator(code)) {
      rootEnd = offset = 1;
      if (isPathSeparator(path.charCodeAt(1))) {
        let j = 2;
        let last = j;
        while (j < len && !isPathSeparator(path.charCodeAt(j))) {
          j++;
        }
        if (j < len && j !== last) {
          last = j;
          while (j < len && isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            last = j;
            while (j < len && !isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j === len) {
              return path;
            }
            if (j !== last) {
              rootEnd = offset = j + 1;
            }
          }
        }
      }
    } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
      rootEnd = len > 2 && isPathSeparator(path.charCodeAt(2)) ? 3 : 2;
      offset = rootEnd;
    }
    let end = -1;
    let matchedSlash = true;
    for (let i = len - 1; i >= offset; --i) {
      if (isPathSeparator(path.charCodeAt(i))) {
        if (!matchedSlash) {
          end = i;
          break;
        }
      } else {
        matchedSlash = false;
      }
    }
    if (end === -1) {
      if (rootEnd === -1) {
        return ".";
      }
      end = rootEnd;
    }
    return path.slice(0, end);
  },
  basename(path, suffix) {
    if (suffix !== void 0) {
      validateString(suffix, "suffix");
    }
    validateString(path, "path");
    let start = 0;
    let end = -1;
    let matchedSlash = true;
    let i;
    if (path.length >= 2 && isWindowsDeviceRoot(path.charCodeAt(0)) && path.charCodeAt(1) === CHAR_COLON) {
      start = 2;
    }
    if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path.length) {
      if (suffix === path) {
        return "";
      }
      let extIdx = suffix.length - 1;
      let firstNonSlashEnd = -1;
      for (i = path.length - 1; i >= start; --i) {
        const code = path.charCodeAt(i);
        if (isPathSeparator(code)) {
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else {
          if (firstNonSlashEnd === -1) {
            matchedSlash = false;
            firstNonSlashEnd = i + 1;
          }
          if (extIdx >= 0) {
            if (code === suffix.charCodeAt(extIdx)) {
              if (--extIdx === -1) {
                end = i;
              }
            } else {
              extIdx = -1;
              end = firstNonSlashEnd;
            }
          }
        }
      }
      if (start === end) {
        end = firstNonSlashEnd;
      } else if (end === -1) {
        end = path.length;
      }
      return path.slice(start, end);
    }
    for (i = path.length - 1; i >= start; --i) {
      if (isPathSeparator(path.charCodeAt(i))) {
        if (!matchedSlash) {
          start = i + 1;
          break;
        }
      } else if (end === -1) {
        matchedSlash = false;
        end = i + 1;
      }
    }
    if (end === -1) {
      return "";
    }
    return path.slice(start, end);
  },
  extname(path) {
    validateString(path, "path");
    let start = 0;
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let preDotState = 0;
    if (path.length >= 2 && path.charCodeAt(1) === CHAR_COLON && isWindowsDeviceRoot(path.charCodeAt(0))) {
      start = startPart = 2;
    }
    for (let i = path.length - 1; i >= start; --i) {
      const code = path.charCodeAt(i);
      if (isPathSeparator(code)) {
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        matchedSlash = false;
        end = i + 1;
      }
      if (code === CHAR_DOT) {
        if (startDot === -1) {
          startDot = i;
        } else if (preDotState !== 1) {
          preDotState = 1;
        }
      } else if (startDot !== -1) {
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
    preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      return "";
    }
    return path.slice(startDot, end);
  },
  format: _format2.bind(null, "\\"),
  parse(path) {
    validateString(path, "path");
    const ret = { root: "", dir: "", base: "", ext: "", name: "" };
    if (path.length === 0) {
      return ret;
    }
    const len = path.length;
    let rootEnd = 0;
    let code = path.charCodeAt(0);
    if (len === 1) {
      if (isPathSeparator(code)) {
        ret.root = ret.dir = path;
        return ret;
      }
      ret.base = ret.name = path;
      return ret;
    }
    if (isPathSeparator(code)) {
      rootEnd = 1;
      if (isPathSeparator(path.charCodeAt(1))) {
        let j = 2;
        let last = j;
        while (j < len && !isPathSeparator(path.charCodeAt(j))) {
          j++;
        }
        if (j < len && j !== last) {
          last = j;
          while (j < len && isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            last = j;
            while (j < len && !isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j === len) {
              rootEnd = j;
            } else if (j !== last) {
              rootEnd = j + 1;
            }
          }
        }
      }
    } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
      if (len <= 2) {
        ret.root = ret.dir = path;
        return ret;
      }
      rootEnd = 2;
      if (isPathSeparator(path.charCodeAt(2))) {
        if (len === 3) {
          ret.root = ret.dir = path;
          return ret;
        }
        rootEnd = 3;
      }
    }
    if (rootEnd > 0) {
      ret.root = path.slice(0, rootEnd);
    }
    let startDot = -1;
    let startPart = rootEnd;
    let end = -1;
    let matchedSlash = true;
    let i = path.length - 1;
    let preDotState = 0;
    for (; i >= rootEnd; --i) {
      code = path.charCodeAt(i);
      if (isPathSeparator(code)) {
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        matchedSlash = false;
        end = i + 1;
      }
      if (code === CHAR_DOT) {
        if (startDot === -1) {
          startDot = i;
        } else if (preDotState !== 1) {
          preDotState = 1;
        }
      } else if (startDot !== -1) {
        preDotState = -1;
      }
    }
    if (end !== -1) {
      if (startDot === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        ret.base = ret.name = path.slice(startPart, end);
      } else {
        ret.name = path.slice(startPart, startDot);
        ret.base = path.slice(startPart, end);
        ret.ext = path.slice(startDot, end);
      }
    }
    if (startPart > 0 && startPart !== rootEnd) {
      ret.dir = path.slice(0, startPart - 1);
    } else {
      ret.dir = ret.root;
    }
    return ret;
  },
  sep: "\\",
  delimiter: ";",
  win32: null,
  posix: null
};
var posixCwd = (() => {
  if (platformIsWin32) {
    const regexp = /\\/g;
    return () => {
      const cwd2 = cwd().replace(regexp, "/");
      return cwd2.slice(cwd2.indexOf("/"));
    };
  }
  return () => cwd();
})();
var $sc = {
  // path.resolve([from ...], to)
  resolve(...pathSegments) {
    let resolvedPath = "";
    let resolvedAbsolute = false;
    for (let i = pathSegments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
      const path = i >= 0 ? pathSegments[i] : posixCwd();
      validateString(path, `paths[${i}]`);
      if (path.length === 0) {
        continue;
      }
      resolvedPath = `${path}/${resolvedPath}`;
      resolvedAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    }
    resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
    if (resolvedAbsolute) {
      return `/${resolvedPath}`;
    }
    return resolvedPath.length > 0 ? resolvedPath : ".";
  },
  normalize(path) {
    validateString(path, "path");
    if (path.length === 0) {
      return ".";
    }
    const isAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    const trailingSeparator = path.charCodeAt(path.length - 1) === CHAR_FORWARD_SLASH;
    path = normalizeString(path, !isAbsolute, "/", isPosixPathSeparator);
    if (path.length === 0) {
      if (isAbsolute) {
        return "/";
      }
      return trailingSeparator ? "./" : ".";
    }
    if (trailingSeparator) {
      path += "/";
    }
    return isAbsolute ? `/${path}` : path;
  },
  isAbsolute(path) {
    validateString(path, "path");
    return path.length > 0 && path.charCodeAt(0) === CHAR_FORWARD_SLASH;
  },
  join(...paths) {
    if (paths.length === 0) {
      return ".";
    }
    let joined;
    for (let i = 0; i < paths.length; ++i) {
      const arg = paths[i];
      validateString(arg, "path");
      if (arg.length > 0) {
        if (joined === void 0) {
          joined = arg;
        } else {
          joined += `/${arg}`;
        }
      }
    }
    if (joined === void 0) {
      return ".";
    }
    return $sc.normalize(joined);
  },
  relative(from, to) {
    validateString(from, "from");
    validateString(to, "to");
    if (from === to) {
      return "";
    }
    from = $sc.resolve(from);
    to = $sc.resolve(to);
    if (from === to) {
      return "";
    }
    const fromStart = 1;
    const fromEnd = from.length;
    const fromLen = fromEnd - fromStart;
    const toStart = 1;
    const toLen = to.length - toStart;
    const length = fromLen < toLen ? fromLen : toLen;
    let lastCommonSep = -1;
    let i = 0;
    for (; i < length; i++) {
      const fromCode = from.charCodeAt(fromStart + i);
      if (fromCode !== to.charCodeAt(toStart + i)) {
        break;
      } else if (fromCode === CHAR_FORWARD_SLASH) {
        lastCommonSep = i;
      }
    }
    if (i === length) {
      if (toLen > length) {
        if (to.charCodeAt(toStart + i) === CHAR_FORWARD_SLASH) {
          return to.slice(toStart + i + 1);
        }
        if (i === 0) {
          return to.slice(toStart + i);
        }
      } else if (fromLen > length) {
        if (from.charCodeAt(fromStart + i) === CHAR_FORWARD_SLASH) {
          lastCommonSep = i;
        } else if (i === 0) {
          lastCommonSep = 0;
        }
      }
    }
    let out = "";
    for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
      if (i === fromEnd || from.charCodeAt(i) === CHAR_FORWARD_SLASH) {
        out += out.length === 0 ? ".." : "/..";
      }
    }
    return `${out}${to.slice(toStart + lastCommonSep)}`;
  },
  toNamespacedPath(path) {
    return path;
  },
  dirname(path) {
    validateString(path, "path");
    if (path.length === 0) {
      return ".";
    }
    const hasRoot = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    let end = -1;
    let matchedSlash = true;
    for (let i = path.length - 1; i >= 1; --i) {
      if (path.charCodeAt(i) === CHAR_FORWARD_SLASH) {
        if (!matchedSlash) {
          end = i;
          break;
        }
      } else {
        matchedSlash = false;
      }
    }
    if (end === -1) {
      return hasRoot ? "/" : ".";
    }
    if (hasRoot && end === 1) {
      return "//";
    }
    return path.slice(0, end);
  },
  basename(path, suffix) {
    if (suffix !== void 0) {
      validateString(suffix, "ext");
    }
    validateString(path, "path");
    let start = 0;
    let end = -1;
    let matchedSlash = true;
    let i;
    if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path.length) {
      if (suffix === path) {
        return "";
      }
      let extIdx = suffix.length - 1;
      let firstNonSlashEnd = -1;
      for (i = path.length - 1; i >= 0; --i) {
        const code = path.charCodeAt(i);
        if (code === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else {
          if (firstNonSlashEnd === -1) {
            matchedSlash = false;
            firstNonSlashEnd = i + 1;
          }
          if (extIdx >= 0) {
            if (code === suffix.charCodeAt(extIdx)) {
              if (--extIdx === -1) {
                end = i;
              }
            } else {
              extIdx = -1;
              end = firstNonSlashEnd;
            }
          }
        }
      }
      if (start === end) {
        end = firstNonSlashEnd;
      } else if (end === -1) {
        end = path.length;
      }
      return path.slice(start, end);
    }
    for (i = path.length - 1; i >= 0; --i) {
      if (path.charCodeAt(i) === CHAR_FORWARD_SLASH) {
        if (!matchedSlash) {
          start = i + 1;
          break;
        }
      } else if (end === -1) {
        matchedSlash = false;
        end = i + 1;
      }
    }
    if (end === -1) {
      return "";
    }
    return path.slice(start, end);
  },
  extname(path) {
    validateString(path, "path");
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let preDotState = 0;
    for (let i = path.length - 1; i >= 0; --i) {
      const code = path.charCodeAt(i);
      if (code === CHAR_FORWARD_SLASH) {
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        matchedSlash = false;
        end = i + 1;
      }
      if (code === CHAR_DOT) {
        if (startDot === -1) {
          startDot = i;
        } else if (preDotState !== 1) {
          preDotState = 1;
        }
      } else if (startDot !== -1) {
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
    preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      return "";
    }
    return path.slice(startDot, end);
  },
  format: _format2.bind(null, "/"),
  parse(path) {
    validateString(path, "path");
    const ret = { root: "", dir: "", base: "", ext: "", name: "" };
    if (path.length === 0) {
      return ret;
    }
    const isAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    let start;
    if (isAbsolute) {
      ret.root = "/";
      start = 1;
    } else {
      start = 0;
    }
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let i = path.length - 1;
    let preDotState = 0;
    for (; i >= start; --i) {
      const code = path.charCodeAt(i);
      if (code === CHAR_FORWARD_SLASH) {
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        matchedSlash = false;
        end = i + 1;
      }
      if (code === CHAR_DOT) {
        if (startDot === -1) {
          startDot = i;
        } else if (preDotState !== 1) {
          preDotState = 1;
        }
      } else if (startDot !== -1) {
        preDotState = -1;
      }
    }
    if (end !== -1) {
      const start2 = startPart === 0 && isAbsolute ? 1 : startPart;
      if (startDot === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        ret.base = ret.name = path.slice(start2, end);
      } else {
        ret.name = path.slice(start2, startDot);
        ret.base = path.slice(start2, end);
        ret.ext = path.slice(startDot, end);
      }
    }
    if (startPart > 0) {
      ret.dir = path.slice(0, startPart - 1);
    } else if (isAbsolute) {
      ret.dir = "/";
    }
    return ret;
  },
  sep: "/",
  delimiter: ":",
  win32: null,
  posix: null
};
$sc.win32 = $rc.win32 = $rc;
$sc.posix = $rc.posix = $sc;
var $tc = platformIsWin32 ? $rc.normalize : $sc.normalize;
var $uc = platformIsWin32 ? $rc.isAbsolute : $sc.isAbsolute;
var $vc = platformIsWin32 ? $rc.join : $sc.join;
var $wc = platformIsWin32 ? $rc.resolve : $sc.resolve;
var $xc = platformIsWin32 ? $rc.relative : $sc.relative;
var $yc = platformIsWin32 ? $rc.dirname : $sc.dirname;
var $zc = platformIsWin32 ? $rc.basename : $sc.basename;
var $Ac = platformIsWin32 ? $rc.extname : $sc.extname;
var $Bc = platformIsWin32 ? $rc.format : $sc.format;
var $Cc = platformIsWin32 ? $rc.parse : $sc.parse;
var $Dc = platformIsWin32 ? $rc.toNamespacedPath : $sc.toNamespacedPath;
var sep = platformIsWin32 ? $rc.sep : $sc.sep;
var $Fc = platformIsWin32 ? $rc.delimiter : $sc.delimiter;

// out-build/vs/base/common/cache.js
var $pf = class {
  constructor(b) {
    this.b = b;
    this.a = null;
  }
  get() {
    if (this.a) {
      return this.a;
    }
    const cts = new $Pe();
    const promise = this.b(cts.token);
    this.a = {
      promise,
      dispose: () => {
        this.a = null;
        cts.cancel();
        cts.dispose();
      }
    };
    return this.a;
  }
};
function $qf(t) {
  return t;
}
var $rf = class {
  constructor(arg1, arg2) {
    this.a = void 0;
    this.b = void 0;
    if (typeof arg1 === "function") {
      this.c = arg1;
      this.d = $qf;
    } else {
      this.c = arg2;
      this.d = arg1.getCacheKey;
    }
  }
  get(arg) {
    const key = this.d(arg);
    if (this.b !== key) {
      this.b = key;
      this.a = this.c(arg);
    }
    return this.a;
  }
};
var $sf = class {
  get cachedValues() {
    return this.a;
  }
  constructor(arg1, arg2) {
    this.a = /* @__PURE__ */ new Map();
    this.b = /* @__PURE__ */ new Map();
    if (typeof arg1 === "function") {
      this.c = arg1;
      this.d = $qf;
    } else {
      this.c = arg2;
      this.d = arg1.getCacheKey;
    }
  }
  get(arg) {
    const key = this.d(arg);
    if (this.b.has(key)) {
      return this.b.get(key);
    }
    const value = this.c(arg);
    this.a.set(arg, value);
    this.b.set(key, value);
    return value;
  }
};

// out-build/vs/base/common/lazy.js
var $7 = class {
  constructor(d) {
    this.d = d;
    this.a = false;
  }
  /**
   * True if the lazy value has been resolved.
   */
  get hasValue() {
    return this.a;
  }
  /**
   * Get the wrapped value.
   *
   * This will force evaluation of the lazy value if it has not been resolved yet. Lazy values are only
   * resolved once. `getValue` will re-throw exceptions that are hit while resolving the value
   */
  get value() {
    if (!this.a) {
      try {
        this.b = this.d();
      } catch (err) {
        this.c = err;
      } finally {
        this.a = true;
      }
    }
    if (this.c) {
      throw this.c;
    }
    return this.b;
  }
  /**
   * Get the wrapped value without forcing evaluation.
   */
  get rawValue() {
    return this.b;
  }
};

// out-build/vs/base/common/strings.js
function $vf(str) {
  if (!str || typeof str !== "string") {
    return true;
  }
  return str.trim().length === 0;
}
var _formatRegexp = /{(\d+)}/g;
function $wf(value, ...args2) {
  if (args2.length === 0) {
    return value;
  }
  return value.replace(_formatRegexp, function(match, group2) {
    const idx = parseInt(group2, 10);
    return isNaN(idx) || idx < 0 || idx >= args2.length ? match : args2[idx];
  });
}
var _format2Regexp = /{([^}]+)}/g;
function $xf(template, values) {
  if (Object.keys(values).length === 0) {
    return template;
  }
  return template.replace(_format2Regexp, (match, group2) => values[group2] ?? match);
}
function $yf(value) {
  return value.replace(/[<>"'&]/g, (ch) => {
    switch (ch) {
      case "<":
        return "&lt;";
      case ">":
        return "&gt;";
      case '"':
        return "&quot;";
      case "'":
        return "&apos;";
      case "&":
        return "&amp;";
    }
    return ch;
  });
}
function $zf(html5) {
  return html5.replace(/[<>&]/g, function(match) {
    switch (match) {
      case "<":
        return "&lt;";
      case ">":
        return "&gt;";
      case "&":
        return "&amp;";
      default:
        return match;
    }
  });
}
function $Af(value) {
  return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, "\\$&");
}
function $Bf(value, substr) {
  let result = 0;
  let index = value.indexOf(substr);
  while (index !== -1) {
    result++;
    index = value.indexOf(substr, index + substr.length);
  }
  return result;
}
function $Cf(value, maxLength, suffix = "\u2026") {
  if (value.length <= maxLength) {
    return value;
  }
  return `${value.substr(0, maxLength)}${suffix}`;
}
function $Df(value, maxLength, suffix = "\u2026") {
  if (value.length <= maxLength) {
    return value;
  }
  const prefixLength = Math.ceil(maxLength / 2) - suffix.length / 2;
  const suffixLength = Math.floor(maxLength / 2) - suffix.length / 2;
  return `${value.substr(0, prefixLength)}${suffix}${value.substr(value.length - suffixLength)}`;
}
function $Ef(haystack, needle = " ") {
  const trimmed = $Ff(haystack, needle);
  return $Gf(trimmed, needle);
}
function $Ff(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  const needleLen = needle.length;
  if (needleLen === 0 || haystack.length === 0) {
    return haystack;
  }
  let offset = 0;
  while (haystack.indexOf(needle, offset) === offset) {
    offset = offset + needleLen;
  }
  return haystack.substring(offset);
}
function $Gf(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  const needleLen = needle.length, haystackLen = haystack.length;
  if (needleLen === 0 || haystackLen === 0) {
    return haystack;
  }
  let offset = haystackLen, idx = -1;
  while (true) {
    idx = haystack.lastIndexOf(needle, offset - 1);
    if (idx === -1 || idx + needleLen !== offset) {
      break;
    }
    if (idx === 0) {
      return "";
    }
    offset = idx;
  }
  return haystack.substring(0, offset);
}
function $Hf(pattern) {
  return pattern.replace(/[\-\\\{\}\+\?\|\^\$\.\,\[\]\(\)\#\s]/g, "\\$&").replace(/[\*]/g, ".*");
}
function $If(pattern) {
  return pattern.replace(/\*/g, "");
}
function $Jf(searchString, isRegex, options3 = {}) {
  if (!searchString) {
    throw new Error("Cannot create regex from empty string");
  }
  if (!isRegex) {
    searchString = $Af(searchString);
  }
  if (options3.wholeWord) {
    if (!/\B/.test(searchString.charAt(0))) {
      searchString = "\\b" + searchString;
    }
    if (!/\B/.test(searchString.charAt(searchString.length - 1))) {
      searchString = searchString + "\\b";
    }
  }
  let modifiers = "";
  if (options3.global) {
    modifiers += "g";
  }
  if (!options3.matchCase) {
    modifiers += "i";
  }
  if (options3.multiline) {
    modifiers += "m";
  }
  if (options3.unicode) {
    modifiers += "u";
  }
  return new RegExp(searchString, modifiers);
}
function $Kf(regexp) {
  if (regexp.source === "^" || regexp.source === "^$" || regexp.source === "$" || regexp.source === "^\\s*$") {
    return false;
  }
  const match = regexp.exec("");
  return !!(match && regexp.lastIndex === 0);
}
function $Lf(str) {
  return str.split(/\r\n|\r|\n/);
}
function $Mf(str) {
  const linesWithSeparators = [];
  const splitLinesAndSeparators = str.split(/(\r\n|\r|\n)/);
  for (let i = 0; i < Math.ceil(splitLinesAndSeparators.length / 2); i++) {
    linesWithSeparators.push(splitLinesAndSeparators[2 * i] + (splitLinesAndSeparators[2 * i + 1] ?? ""));
  }
  return linesWithSeparators;
}
function $Nf(str) {
  for (let i = 0, len = str.length; i < len; i++) {
    const chCode = str.charCodeAt(i);
    if (chCode !== 32 && chCode !== 9) {
      return i;
    }
  }
  return -1;
}
function $Of(str, start = 0, end = str.length) {
  for (let i = start; i < end; i++) {
    const chCode = str.charCodeAt(i);
    if (chCode !== 32 && chCode !== 9) {
      return str.substring(start, i);
    }
  }
  return str.substring(start, end);
}
function $Pf(str, startIndex = str.length - 1) {
  for (let i = startIndex; i >= 0; i--) {
    const chCode = str.charCodeAt(i);
    if (chCode !== 32 && chCode !== 9) {
      return i;
    }
  }
  return -1;
}
function $Qf(str) {
  const idx = $Nf(str);
  if (idx === -1) {
    return str.length;
  }
  return idx;
}
function $Rf(str, search2, replacer2) {
  const parts = [];
  let last = 0;
  for (const match of str.matchAll(search2)) {
    parts.push(str.slice(last, match.index));
    if (match.index === void 0) {
      throw new Error("match.index should be defined");
    }
    last = match.index + match[0].length;
    parts.push(replacer2(match[0], ...match.slice(1), match.index, str, match.groups));
  }
  parts.push(str.slice(last));
  return Promise.all(parts).then((p) => p.join(""));
}
function $Sf(a, b) {
  if (a < b) {
    return -1;
  } else if (a > b) {
    return 1;
  } else {
    return 0;
  }
}
function $Tf(a, b, aStart = 0, aEnd = a.length, bStart = 0, bEnd = b.length) {
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    const codeA = a.charCodeAt(aStart);
    const codeB = b.charCodeAt(bStart);
    if (codeA < codeB) {
      return -1;
    } else if (codeA > codeB) {
      return 1;
    }
  }
  const aLen = aEnd - aStart;
  const bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  } else if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function $Uf(a, b) {
  return $Vf(a, b, 0, a.length, 0, b.length);
}
function $Vf(a, b, aStart = 0, aEnd = a.length, bStart = 0, bEnd = b.length) {
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    let codeA = a.charCodeAt(aStart);
    let codeB = b.charCodeAt(bStart);
    if (codeA === codeB) {
      continue;
    }
    if (codeA >= 128 || codeB >= 128) {
      return $Tf(a.toLowerCase(), b.toLowerCase(), aStart, aEnd, bStart, bEnd);
    }
    if ($Xf(codeA)) {
      codeA -= 32;
    }
    if ($Xf(codeB)) {
      codeB -= 32;
    }
    const diff4 = codeA - codeB;
    if (diff4 === 0) {
      continue;
    }
    return diff4;
  }
  const aLen = aEnd - aStart;
  const bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  } else if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function $Wf(code) {
  return code >= 48 && code <= 57;
}
function $Xf(code) {
  return code >= 97 && code <= 122;
}
function $Yf(code) {
  return code >= 65 && code <= 90;
}
function $Zf(a, b) {
  return a.length === b.length && $Vf(a, b) === 0;
}
function $1f(str, candidate) {
  const candidateLength = candidate.length;
  if (candidate.length > str.length) {
    return false;
  }
  return $Vf(str, candidate, 0, candidateLength) === 0;
}
function $2f(a, b) {
  const len = Math.min(a.length, b.length);
  let i;
  for (i = 0; i < len; i++) {
    if (a.charCodeAt(i) !== b.charCodeAt(i)) {
      return i;
    }
  }
  return len;
}
function $3f(a, b) {
  const len = Math.min(a.length, b.length);
  let i;
  const aLastIndex = a.length - 1;
  const bLastIndex = b.length - 1;
  for (i = 0; i < len; i++) {
    if (a.charCodeAt(aLastIndex - i) !== b.charCodeAt(bLastIndex - i)) {
      return i;
    }
  }
  return len;
}
function $4f(charCode) {
  return 55296 <= charCode && charCode <= 56319;
}
function $5f(charCode) {
  return 56320 <= charCode && charCode <= 57343;
}
function $6f(highSurrogate, lowSurrogate) {
  return (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
}
function $7f(str, len, offset) {
  const charCode = str.charCodeAt(offset);
  if ($4f(charCode) && offset + 1 < len) {
    const nextCharCode = str.charCodeAt(offset + 1);
    if ($5f(nextCharCode)) {
      return $6f(charCode, nextCharCode);
    }
  }
  return charCode;
}
function getPrevCodePoint(str, offset) {
  const charCode = str.charCodeAt(offset - 1);
  if ($5f(charCode) && offset > 1) {
    const prevCharCode = str.charCodeAt(offset - 2);
    if ($4f(prevCharCode)) {
      return $6f(prevCharCode, charCode);
    }
  }
  return charCode;
}
var $8f = class {
  get offset() {
    return this.e;
  }
  constructor(str, offset = 0) {
    this.c = str;
    this.d = str.length;
    this.e = offset;
  }
  setOffset(offset) {
    this.e = offset;
  }
  prevCodePoint() {
    const codePoint = getPrevCodePoint(this.c, this.e);
    this.e -= codePoint >= 65536 ? 2 : 1;
    return codePoint;
  }
  nextCodePoint() {
    const codePoint = $7f(this.c, this.d, this.e);
    this.e += codePoint >= 65536 ? 2 : 1;
    return codePoint;
  }
  eol() {
    return this.e >= this.d;
  }
};
var $9f = class {
  get offset() {
    return this.c.offset;
  }
  constructor(str, offset = 0) {
    this.c = new $8f(str, offset);
  }
  nextGraphemeLength() {
    const graphemeBreakTree = GraphemeBreakTree.getInstance();
    const iterator = this.c;
    const initialOffset = iterator.offset;
    let graphemeBreakType = graphemeBreakTree.getGraphemeBreakType(iterator.nextCodePoint());
    while (!iterator.eol()) {
      const offset = iterator.offset;
      const nextGraphemeBreakType = graphemeBreakTree.getGraphemeBreakType(iterator.nextCodePoint());
      if (breakBetweenGraphemeBreakType(graphemeBreakType, nextGraphemeBreakType)) {
        iterator.setOffset(offset);
        break;
      }
      graphemeBreakType = nextGraphemeBreakType;
    }
    return iterator.offset - initialOffset;
  }
  prevGraphemeLength() {
    const graphemeBreakTree = GraphemeBreakTree.getInstance();
    const iterator = this.c;
    const initialOffset = iterator.offset;
    let graphemeBreakType = graphemeBreakTree.getGraphemeBreakType(iterator.prevCodePoint());
    while (iterator.offset > 0) {
      const offset = iterator.offset;
      const prevGraphemeBreakType = graphemeBreakTree.getGraphemeBreakType(iterator.prevCodePoint());
      if (breakBetweenGraphemeBreakType(prevGraphemeBreakType, graphemeBreakType)) {
        iterator.setOffset(offset);
        break;
      }
      graphemeBreakType = prevGraphemeBreakType;
    }
    return initialOffset - iterator.offset;
  }
  eol() {
    return this.c.eol();
  }
};
function $0f(str, initialOffset) {
  const iterator = new $9f(str, initialOffset);
  return iterator.nextGraphemeLength();
}
function $$f(str, initialOffset) {
  const iterator = new $9f(str, initialOffset);
  return iterator.prevGraphemeLength();
}
function $_f(str, offset) {
  if (offset > 0 && $5f(str.charCodeAt(offset))) {
    offset--;
  }
  const endOffset = offset + $0f(str, offset);
  const startOffset = endOffset - $$f(str, endOffset);
  return [startOffset, endOffset];
}
var CONTAINS_RTL = void 0;
function makeContainsRtl() {
  return /(?:[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05F4\u0608\u060B\u060D\u061B-\u064A\u066D-\u066F\u0671-\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u0710\u0712-\u072F\u074D-\u07A5\u07B1-\u07EA\u07F4\u07F5\u07FA\u07FE-\u0815\u081A\u0824\u0828\u0830-\u0858\u085E-\u088E\u08A0-\u08C9\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFD3D\uFD50-\uFDC7\uFDF0-\uFDFC\uFE70-\uFEFC]|\uD802[\uDC00-\uDD1B\uDD20-\uDE00\uDE10-\uDE35\uDE40-\uDEE4\uDEEB-\uDF35\uDF40-\uDFFF]|\uD803[\uDC00-\uDD23\uDE80-\uDEA9\uDEAD-\uDF45\uDF51-\uDF81\uDF86-\uDFF6]|\uD83A[\uDC00-\uDCCF\uDD00-\uDD43\uDD4B-\uDFFF]|\uD83B[\uDC00-\uDEBB])/;
}
function $bg(str) {
  if (!CONTAINS_RTL) {
    CONTAINS_RTL = makeContainsRtl();
  }
  return CONTAINS_RTL.test(str);
}
var IS_BASIC_ASCII = /^[\t\n\r\x20-\x7E]*$/;
function $cg(str) {
  return IS_BASIC_ASCII.test(str);
}
var $dg = /[\u2028\u2029]/;
function $eg(str) {
  return $dg.test(str);
}
function $fg(charCode) {
  return charCode >= 11904 && charCode <= 55215 || charCode >= 63744 && charCode <= 64255 || charCode >= 65281 && charCode <= 65374;
}
function $gg(x) {
  return x >= 127462 && x <= 127487 || x === 8986 || x === 8987 || x === 9200 || x === 9203 || x >= 9728 && x <= 10175 || x === 11088 || x === 11093 || x >= 127744 && x <= 128591 || x >= 128640 && x <= 128764 || x >= 128992 && x <= 129008 || x >= 129280 && x <= 129535 || x >= 129648 && x <= 129782;
}
function $hg(text2, n, prefix = "") {
  const trimmed = text2.trimStart();
  if (trimmed.length < n) {
    return trimmed;
  }
  const re = /\b/g;
  let i = 0;
  while (re.test(trimmed)) {
    if (trimmed.length - re.lastIndex < n) {
      break;
    }
    i = re.lastIndex;
    re.lastIndex += 1;
  }
  if (i === 0) {
    return trimmed;
  }
  return prefix + trimmed.substring(i).trimStart();
}
var CSI_SEQUENCE = /(?:(?:\x1b\[|\x9B)[=?>!]?[\d;:]*["$#'* ]?[a-zA-Z@^`{}|~])|(:?\x1b\].*?\x07)/g;
function* $ig(str) {
  let last = 0;
  for (const match of str.matchAll(CSI_SEQUENCE)) {
    if (last !== match.index) {
      yield { isCode: false, str: str.substring(last, match.index) };
    }
    yield { isCode: true, str: match[0] };
    last = match.index + match[0].length;
  }
  if (last !== str.length) {
    yield { isCode: false, str: str.substring(last) };
  }
}
function $jg(str) {
  if (str) {
    str = str.replace(CSI_SEQUENCE, "");
  }
  return str;
}
var PROMPT_NON_PRINTABLE = /\\\[.*?\\\]/g;
function $kg(str) {
  return $jg(str).replace(PROMPT_NON_PRINTABLE, "");
}
var $lg = String.fromCharCode(
  65279
  /* CharCode.UTF8_BOM */
);
function $mg(str) {
  return !!(str && str.length > 0 && str.charCodeAt(0) === 65279);
}
function $og(target, query) {
  if (!target || !query) {
    return false;
  }
  if (target.length < query.length) {
    return false;
  }
  const queryLen = query.length;
  const targetLower = target.toLowerCase();
  let index = 0;
  let lastIndexOf = -1;
  while (index < queryLen) {
    const indexOf = targetLower.indexOf(query[index], lastIndexOf + 1);
    if (indexOf < 0) {
      return false;
    }
    lastIndexOf = indexOf;
    index++;
  }
  return true;
}
function $pg(target, ignoreEscapedChars = false) {
  if (!target) {
    return false;
  }
  if (ignoreEscapedChars) {
    target = target.replace(/\\./g, "");
  }
  return target.toLowerCase() !== target;
}
function $qg(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}
function $rg(str, n = 1) {
  if (n === 0) {
    return "";
  }
  let idx = -1;
  do {
    idx = str.indexOf("\n", idx + 1);
    n--;
  } while (n > 0 && idx >= 0);
  if (idx === -1) {
    return str;
  }
  if (str[idx - 1] === "\r") {
    idx--;
  }
  return str.substr(0, idx);
}
function $sg(n) {
  const LETTERS_CNT = 90 - 65 + 1;
  n = n % (2 * LETTERS_CNT);
  if (n < LETTERS_CNT) {
    return String.fromCharCode(97 + n);
  }
  return String.fromCharCode(65 + n - LETTERS_CNT);
}
function breakBetweenGraphemeBreakType(breakTypeA, breakTypeB) {
  if (breakTypeA === 0) {
    return breakTypeB !== 5 && breakTypeB !== 7;
  }
  if (breakTypeA === 2) {
    if (breakTypeB === 3) {
      return false;
    }
  }
  if (breakTypeA === 4 || breakTypeA === 2 || breakTypeA === 3) {
    return true;
  }
  if (breakTypeB === 4 || breakTypeB === 2 || breakTypeB === 3) {
    return true;
  }
  if (breakTypeA === 8) {
    if (breakTypeB === 8 || breakTypeB === 9 || breakTypeB === 11 || breakTypeB === 12) {
      return false;
    }
  }
  if (breakTypeA === 11 || breakTypeA === 9) {
    if (breakTypeB === 9 || breakTypeB === 10) {
      return false;
    }
  }
  if (breakTypeA === 12 || breakTypeA === 10) {
    if (breakTypeB === 10) {
      return false;
    }
  }
  if (breakTypeB === 5 || breakTypeB === 13) {
    return false;
  }
  if (breakTypeB === 7) {
    return false;
  }
  if (breakTypeA === 1) {
    return false;
  }
  if (breakTypeA === 13 && breakTypeB === 14) {
    return false;
  }
  if (breakTypeA === 6 && breakTypeB === 6) {
    return false;
  }
  return true;
}
var GraphemeBreakType;
(function(GraphemeBreakType2) {
  GraphemeBreakType2[GraphemeBreakType2["Other"] = 0] = "Other";
  GraphemeBreakType2[GraphemeBreakType2["Prepend"] = 1] = "Prepend";
  GraphemeBreakType2[GraphemeBreakType2["CR"] = 2] = "CR";
  GraphemeBreakType2[GraphemeBreakType2["LF"] = 3] = "LF";
  GraphemeBreakType2[GraphemeBreakType2["Control"] = 4] = "Control";
  GraphemeBreakType2[GraphemeBreakType2["Extend"] = 5] = "Extend";
  GraphemeBreakType2[GraphemeBreakType2["Regional_Indicator"] = 6] = "Regional_Indicator";
  GraphemeBreakType2[GraphemeBreakType2["SpacingMark"] = 7] = "SpacingMark";
  GraphemeBreakType2[GraphemeBreakType2["L"] = 8] = "L";
  GraphemeBreakType2[GraphemeBreakType2["V"] = 9] = "V";
  GraphemeBreakType2[GraphemeBreakType2["T"] = 10] = "T";
  GraphemeBreakType2[GraphemeBreakType2["LV"] = 11] = "LV";
  GraphemeBreakType2[GraphemeBreakType2["LVT"] = 12] = "LVT";
  GraphemeBreakType2[GraphemeBreakType2["ZWJ"] = 13] = "ZWJ";
  GraphemeBreakType2[GraphemeBreakType2["Extended_Pictographic"] = 14] = "Extended_Pictographic";
})(GraphemeBreakType || (GraphemeBreakType = {}));
var GraphemeBreakTree = class _GraphemeBreakTree {
  static {
    this.c = null;
  }
  static getInstance() {
    if (!_GraphemeBreakTree.c) {
      _GraphemeBreakTree.c = new _GraphemeBreakTree();
    }
    return _GraphemeBreakTree.c;
  }
  constructor() {
    this.d = getGraphemeBreakRawData();
  }
  getGraphemeBreakType(codePoint) {
    if (codePoint < 32) {
      if (codePoint === 10) {
        return 3;
      }
      if (codePoint === 13) {
        return 2;
      }
      return 4;
    }
    if (codePoint < 127) {
      return 0;
    }
    const data = this.d;
    const nodeCount = data.length / 3;
    let nodeIndex = 1;
    while (nodeIndex <= nodeCount) {
      if (codePoint < data[3 * nodeIndex]) {
        nodeIndex = 2 * nodeIndex;
      } else if (codePoint > data[3 * nodeIndex + 1]) {
        nodeIndex = 2 * nodeIndex + 1;
      } else {
        return data[3 * nodeIndex + 2];
      }
    }
    return 0;
  }
};
function getGraphemeBreakRawData() {
  return JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]");
}
function $ug(offset, str) {
  if (offset === 0) {
    return 0;
  }
  const emojiOffset = getOffsetBeforeLastEmojiComponent(offset, str);
  if (emojiOffset !== void 0) {
    return emojiOffset;
  }
  const iterator = new $8f(str, offset);
  iterator.prevCodePoint();
  return iterator.offset;
}
function getOffsetBeforeLastEmojiComponent(initialOffset, str) {
  const iterator = new $8f(str, initialOffset);
  let codePoint = iterator.prevCodePoint();
  while (isEmojiModifier(codePoint) || codePoint === 65039 || codePoint === 8419) {
    if (iterator.offset === 0) {
      return void 0;
    }
    codePoint = iterator.prevCodePoint();
  }
  if (!$gg(codePoint)) {
    return void 0;
  }
  let resultOffset = iterator.offset;
  if (resultOffset > 0) {
    const optionalZwjCodePoint = iterator.prevCodePoint();
    if (optionalZwjCodePoint === 8205) {
      resultOffset = iterator.offset;
    }
  }
  return resultOffset;
}
function isEmojiModifier(codePoint) {
  return 127995 <= codePoint && codePoint <= 127999;
}
var CodePoint;
(function(CodePoint2) {
  CodePoint2[CodePoint2["zwj"] = 8205] = "zwj";
  CodePoint2[CodePoint2["emojiVariantSelector"] = 65039] = "emojiVariantSelector";
  CodePoint2[CodePoint2["enclosingKeyCap"] = 8419] = "enclosingKeyCap";
})(CodePoint || (CodePoint = {}));
var $vg = "\xA0";
var $wg = class _$wg {
  static {
    this.c = new $7(() => {
      return JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,8218,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,8242,96,1370,96,1523,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71922,67,71913,67,65315,67,8557,67,8450,67,8493,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71919,87,71910,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,66293,90,71909,90,65338,90,8484,90,8488,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65297,49,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"cs":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"es":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"fr":[65374,126,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"it":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ja":[8211,45,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65292,44,65307,59],"ko":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pt-BR":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ru":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"zh-hans":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41],"zh-hant":[8211,45,65374,126,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65307,59]}');
    });
  }
  static {
    this.d = new $rf({ getCacheKey: JSON.stringify }, (locales) => {
      function arrayToMap(arr) {
        const result = /* @__PURE__ */ new Map();
        for (let i = 0; i < arr.length; i += 2) {
          result.set(arr[i], arr[i + 1]);
        }
        return result;
      }
      function mergeMaps(map1, map2) {
        const result = new Map(map1);
        for (const [key, value] of map2) {
          result.set(key, value);
        }
        return result;
      }
      function intersectMaps(map1, map2) {
        if (!map1) {
          return map2;
        }
        const result = /* @__PURE__ */ new Map();
        for (const [key, value] of map1) {
          if (map2.has(key)) {
            result.set(key, value);
          }
        }
        return result;
      }
      const data = this.c.value;
      let filteredLocales = locales.filter((l) => !l.startsWith("_") && l in data);
      if (filteredLocales.length === 0) {
        filteredLocales = ["_default"];
      }
      let languageSpecificMap = void 0;
      for (const locale of filteredLocales) {
        const map2 = arrayToMap(data[locale]);
        languageSpecificMap = intersectMaps(languageSpecificMap, map2);
      }
      const commonMap = arrayToMap(data["_common"]);
      const map = mergeMaps(commonMap, languageSpecificMap);
      return new _$wg(map);
    });
  }
  static getInstance(locales) {
    return _$wg.d.get(Array.from(locales));
  }
  static {
    this.e = new $7(() => Object.keys(_$wg.c.value).filter((k) => !k.startsWith("_")));
  }
  static getLocales() {
    return _$wg.e.value;
  }
  constructor(f) {
    this.f = f;
  }
  isAmbiguous(codePoint) {
    return this.f.has(codePoint);
  }
  containsAmbiguousCharacter(str) {
    for (let i = 0; i < str.length; i++) {
      const codePoint = str.codePointAt(i);
      if (typeof codePoint === "number" && this.isAmbiguous(codePoint)) {
        return true;
      }
    }
    return false;
  }
  /**
   * Returns the non basic ASCII code point that the given code point can be confused,
   * or undefined if such code point does note exist.
   */
  getPrimaryConfusable(codePoint) {
    return this.f.get(codePoint);
  }
  getConfusableCodePoints() {
    return new Set(this.f.keys());
  }
};
var $xg = class _$xg {
  static c() {
    return JSON.parse("[9,10,11,12,13,32,127,160,173,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8203,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12288,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999]");
  }
  static {
    this.d = void 0;
  }
  static e() {
    if (!this.d) {
      this.d = new Set(_$xg.c());
    }
    return this.d;
  }
  static isInvisibleCharacter(codePoint) {
    return _$xg.e().has(codePoint);
  }
  static containsInvisibleCharacter(str) {
    for (let i = 0; i < str.length; i++) {
      const codePoint = str.codePointAt(i);
      if (typeof codePoint === "number" && _$xg.isInvisibleCharacter(codePoint)) {
        return true;
      }
    }
    return false;
  }
  static get codePoints() {
    return _$xg.e();
  }
};

// out-build/vs/base/common/extpath.js
function $Rg(code) {
  return code === 47 || code === 92;
}
function $Sg(osPath) {
  return osPath.replace(/[\\/]/g, $sc.sep);
}
function $Tg(osPath) {
  if (osPath.indexOf("/") === -1) {
    osPath = $Sg(osPath);
  }
  if (/^[a-zA-Z]:(\/|$)/.test(osPath)) {
    osPath = "/" + osPath;
  }
  return osPath;
}
function $Ug(path, sep2 = $sc.sep) {
  if (!path) {
    return "";
  }
  const len = path.length;
  const firstLetter = path.charCodeAt(0);
  if ($Rg(firstLetter)) {
    if ($Rg(path.charCodeAt(1))) {
      if (!$Rg(path.charCodeAt(2))) {
        let pos2 = 3;
        const start = pos2;
        for (; pos2 < len; pos2++) {
          if ($Rg(path.charCodeAt(pos2))) {
            break;
          }
        }
        if (start !== pos2 && !$Rg(path.charCodeAt(pos2 + 1))) {
          pos2 += 1;
          for (; pos2 < len; pos2++) {
            if ($Rg(path.charCodeAt(pos2))) {
              return path.slice(0, pos2 + 1).replace(/[\\/]/g, sep2);
            }
          }
        }
      }
    }
    return sep2;
  } else if ($Zg(firstLetter)) {
    if (path.charCodeAt(1) === 58) {
      if ($Rg(path.charCodeAt(2))) {
        return path.slice(0, 2) + sep2;
      } else {
        return path.slice(0, 2);
      }
    }
  }
  let pos = path.indexOf("://");
  if (pos !== -1) {
    pos += 3;
    for (; pos < len; pos++) {
      if ($Rg(path.charCodeAt(pos))) {
        return path.slice(0, pos + 1);
      }
    }
  }
  return "";
}
function $Vg(path) {
  if (!$l) {
    return false;
  }
  if (!path || path.length < 5) {
    return false;
  }
  let code = path.charCodeAt(0);
  if (code !== 92) {
    return false;
  }
  code = path.charCodeAt(1);
  if (code !== 92) {
    return false;
  }
  let pos = 2;
  const start = pos;
  for (; pos < path.length; pos++) {
    code = path.charCodeAt(pos);
    if (code === 92) {
      break;
    }
  }
  if (start === pos) {
    return false;
  }
  code = path.charCodeAt(pos + 1);
  if (isNaN(code) || code === 92) {
    return false;
  }
  return true;
}
var WINDOWS_INVALID_FILE_CHARS = /[\\/:\*\?"<>\|]/g;
var UNIX_INVALID_FILE_CHARS = /[/]/g;
var WINDOWS_FORBIDDEN_NAMES = /^(con|prn|aux|clock\$|nul|lpt[0-9]|com[0-9])(\.(.*?))?$/i;
function $Wg(name, isWindowsOS = $l) {
  const invalidFileChars = isWindowsOS ? WINDOWS_INVALID_FILE_CHARS : UNIX_INVALID_FILE_CHARS;
  if (!name || name.length === 0 || /^\s+$/.test(name)) {
    return false;
  }
  invalidFileChars.lastIndex = 0;
  if (invalidFileChars.test(name)) {
    return false;
  }
  if (isWindowsOS && WINDOWS_FORBIDDEN_NAMES.test(name)) {
    return false;
  }
  if (name === "." || name === "..") {
    return false;
  }
  if (isWindowsOS && name[name.length - 1] === ".") {
    return false;
  }
  if (isWindowsOS && name.length !== name.trim().length) {
    return false;
  }
  if (name.length > 255) {
    return false;
  }
  return true;
}
function $Xg(pathA, pathB, ignoreCase) {
  const identityEquals = pathA === pathB;
  if (!ignoreCase || identityEquals) {
    return identityEquals;
  }
  if (!pathA || !pathB) {
    return false;
  }
  return $Zf(pathA, pathB);
}
function $Yg(base, parentCandidate, ignoreCase, separator = sep) {
  if (base === parentCandidate) {
    return true;
  }
  if (!base || !parentCandidate) {
    return false;
  }
  if (parentCandidate.length > base.length) {
    return false;
  }
  if (ignoreCase) {
    const beginsWith = $1f(base, parentCandidate);
    if (!beginsWith) {
      return false;
    }
    if (parentCandidate.length === base.length) {
      return true;
    }
    let sepOffset = parentCandidate.length;
    if (parentCandidate.charAt(parentCandidate.length - 1) === separator) {
      sepOffset--;
    }
    return base.charAt(sepOffset) === separator;
  }
  if (parentCandidate.charAt(parentCandidate.length - 1) !== separator) {
    parentCandidate += separator;
  }
  return base.indexOf(parentCandidate) === 0;
}
function $Zg(char0) {
  return char0 >= 65 && char0 <= 90 || char0 >= 97 && char0 <= 122;
}
function $2g(candidate) {
  if ($l) {
    candidate = $Gf(candidate, sep);
    if (candidate.endsWith(":")) {
      candidate += sep;
    }
  } else {
    candidate = $Gf(candidate, sep);
    if (!candidate) {
      candidate = sep;
    }
  }
  return candidate;
}
function $4g(path, isWindowsOS = $l) {
  if (isWindowsOS) {
    return $Zg(path.charCodeAt(0)) && path.charCodeAt(1) === 58;
  }
  return false;
}
function $5g(path, isWindowsOS = $l) {
  return $4g(path, isWindowsOS) ? path[0] : void 0;
}
function $6g(path, candidate, ignoreCase) {
  if (candidate.length > path.length) {
    return -1;
  }
  if (path === candidate) {
    return 0;
  }
  if (ignoreCase) {
    path = path.toLowerCase();
    candidate = candidate.toLowerCase();
  }
  return path.indexOf(candidate);
}
function $7g(rawPath) {
  const segments = rawPath.split(":");
  let path = void 0;
  let line = void 0;
  let column = void 0;
  for (const segment of segments) {
    const segmentAsNumber = Number(segment);
    if (!$Cg(segmentAsNumber)) {
      path = !!path ? [path, segment].join(":") : segment;
    } else if (line === void 0) {
      line = segmentAsNumber;
    } else if (column === void 0) {
      column = segmentAsNumber;
    }
  }
  if (!path) {
    throw new Error("Format for `--goto` should be: `FILE:LINE(:COLUMN)`");
  }
  return {
    path,
    line: line !== void 0 ? line : void 0,
    column: column !== void 0 ? column : line !== void 0 ? 1 : void 0
    // if we have a line, make sure column is also set
  };
}
var pathChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
var windowsSafePathFirstChars = "BDEFGHIJKMOQRSTUVWXYZbdefghijkmoqrstuvwxyz0123456789";
function $8g(parent, prefix, randomLength = 8) {
  let suffix = "";
  for (let i = 0; i < randomLength; i++) {
    let pathCharsTouse;
    if (i === 0 && $l && !prefix && (randomLength === 3 || randomLength === 4)) {
      pathCharsTouse = windowsSafePathFirstChars;
    } else {
      pathCharsTouse = pathChars;
    }
    suffix += pathCharsTouse.charAt(Math.floor(Math.random() * pathCharsTouse.length));
  }
  let randomFileName;
  if (prefix) {
    randomFileName = `${prefix}-${suffix}`;
  } else {
    randomFileName = suffix;
  }
  if (parent) {
    return $vc(parent, randomFileName);
  }
  return randomFileName;
}

// out-build/vs/base/common/uri.js
var _schemePattern = /^\w[\w\d+.-]*$/;
var _singleSlashStart = /^\//;
var _doubleSlashStart = /^\/\//;
function _validateUri(ret, _strict) {
  if (!ret.scheme && _strict) {
    throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${ret.authority}", path: "${ret.path}", query: "${ret.query}", fragment: "${ret.fragment}"}`);
  }
  if (ret.scheme && !_schemePattern.test(ret.scheme)) {
    throw new Error("[UriError]: Scheme contains illegal characters.");
  }
  if (ret.path) {
    if (ret.authority) {
      if (!_singleSlashStart.test(ret.path)) {
        throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
      }
    } else {
      if (_doubleSlashStart.test(ret.path)) {
        throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
      }
    }
  }
}
function _schemeFix(scheme, _strict) {
  if (!scheme && !_strict) {
    return "file";
  }
  return scheme;
}
function _referenceResolution(scheme, path) {
  switch (scheme) {
    case "https":
    case "http":
    case "file":
      if (!path) {
        path = _slash;
      } else if (path[0] !== _slash) {
        path = _slash + path;
      }
      break;
  }
  return path;
}
var _empty = "";
var _slash = "/";
var _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
var URI = class _URI {
  static isUri(thing) {
    if (thing instanceof _URI) {
      return true;
    }
    if (!thing) {
      return false;
    }
    return typeof thing.authority === "string" && typeof thing.fragment === "string" && typeof thing.path === "string" && typeof thing.query === "string" && typeof thing.scheme === "string" && typeof thing.fsPath === "string" && typeof thing.with === "function" && typeof thing.toString === "function";
  }
  /**
   * @internal
   */
  constructor(schemeOrData, authority, path, query, fragment, _strict = false) {
    if (typeof schemeOrData === "object") {
      this.scheme = schemeOrData.scheme || _empty;
      this.authority = schemeOrData.authority || _empty;
      this.path = schemeOrData.path || _empty;
      this.query = schemeOrData.query || _empty;
      this.fragment = schemeOrData.fragment || _empty;
    } else {
      this.scheme = _schemeFix(schemeOrData, _strict);
      this.authority = authority || _empty;
      this.path = _referenceResolution(this.scheme, path || _empty);
      this.query = query || _empty;
      this.fragment = fragment || _empty;
      _validateUri(this, _strict);
    }
  }
  // ---- filesystem path -----------------------
  /**
   * Returns a string representing the corresponding file system path of this URI.
   * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
   * platform specific path separator.
   *
   * * Will *not* validate the path for invalid characters and semantics.
   * * Will *not* look at the scheme of this URI.
   * * The result shall *not* be used for display purposes but for accessing a file on disk.
   *
   *
   * The *difference* to `URI#path` is the use of the platform specific separator and the handling
   * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
   *
   * ```ts
      const u = URI.parse('file://server/c$/folder/file.txt')
      u.authority === 'server'
      u.path === '/shares/c$/file.txt'
      u.fsPath === '\\server\c$\folder\file.txt'
  ```
   *
   * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
   * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
   * with URIs that represent files on disk (`file` scheme).
   */
  get fsPath() {
    return $Ic(this, false);
  }
  // ---- modify to new -------------------------
  with(change) {
    if (!change) {
      return this;
    }
    let { scheme, authority, path, query, fragment } = change;
    if (scheme === void 0) {
      scheme = this.scheme;
    } else if (scheme === null) {
      scheme = _empty;
    }
    if (authority === void 0) {
      authority = this.authority;
    } else if (authority === null) {
      authority = _empty;
    }
    if (path === void 0) {
      path = this.path;
    } else if (path === null) {
      path = _empty;
    }
    if (query === void 0) {
      query = this.query;
    } else if (query === null) {
      query = _empty;
    }
    if (fragment === void 0) {
      fragment = this.fragment;
    } else if (fragment === null) {
      fragment = _empty;
    }
    if (scheme === this.scheme && authority === this.authority && path === this.path && query === this.query && fragment === this.fragment) {
      return this;
    }
    return new Uri(scheme, authority, path, query, fragment);
  }
  // ---- parse & validate ------------------------
  /**
   * Creates a new URI from a string, e.g. `http://www.example.com/some/path`,
   * `file:///usr/home`, or `scheme:with/path`.
   *
   * @param value A string which represents an URI (see `URI#toString`).
   */
  static parse(value, _strict = false) {
    const match = _regexp.exec(value);
    if (!match) {
      return new Uri(_empty, _empty, _empty, _empty, _empty);
    }
    return new Uri(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
  }
  /**
   * Creates a new URI from a file system path, e.g. `c:\my\files`,
   * `/usr/home`, or `\\server\share\some\path`.
   *
   * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
   * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
   * `URI.parse('file://' + path)` because the path might contain characters that are
   * interpreted (# and ?). See the following sample:
   * ```ts
  const good = URI.file('/coding/c#/project1');
  good.scheme === 'file';
  good.path === '/coding/c#/project1';
  good.fragment === '';
  const bad = URI.parse('file://' + '/coding/c#/project1');
  bad.scheme === 'file';
  bad.path === '/coding/c'; // path is now broken
  bad.fragment === '/project1';
  ```
   *
   * @param path A file system path (see `URI#fsPath`)
   */
  static file(path) {
    let authority = _empty;
    if ($l) {
      path = path.replace(/\\/g, _slash);
    }
    if (path[0] === _slash && path[1] === _slash) {
      const idx = path.indexOf(_slash, 2);
      if (idx === -1) {
        authority = path.substring(2);
        path = _slash;
      } else {
        authority = path.substring(2, idx);
        path = path.substring(idx) || _slash;
      }
    }
    return new Uri("file", authority, path, _empty, _empty);
  }
  /**
   * Creates new URI from uri components.
   *
   * Unless `strict` is `true` the scheme is defaults to be `file`. This function performs
   * validation and should be used for untrusted uri components retrieved from storage,
   * user input, command arguments etc
   */
  static from(components, strict) {
    const result = new Uri(components.scheme, components.authority, components.path, components.query, components.fragment, strict);
    return result;
  }
  /**
   * Join a URI path with path fragments and normalizes the resulting path.
   *
   * @param uri The input URI.
   * @param pathFragment The path fragment to add to the URI path.
   * @returns The resulting URI.
   */
  static joinPath(uri, ...pathFragment) {
    if (!uri.path) {
      throw new Error(`[UriError]: cannot call joinPath on URI without path`);
    }
    let newPath;
    if ($l && uri.scheme === "file") {
      newPath = _URI.file($rc.join($Ic(uri, true), ...pathFragment)).path;
    } else {
      newPath = $sc.join(uri.path, ...pathFragment);
    }
    return uri.with({ path: newPath });
  }
  // ---- printing/externalize ---------------------------
  /**
   * Creates a string representation for this URI. It's guaranteed that calling
   * `URI.parse` with the result of this function creates an URI which is equal
   * to this URI.
   *
   * * The result shall *not* be used for display purposes but for externalization or transport.
   * * The result will be encoded using the percentage encoding and encoding happens mostly
   * ignore the scheme-specific encoding rules.
   *
   * @param skipEncoding Do not encode the result, default is `false`
   */
  toString(skipEncoding = false) {
    return _asFormatted(this, skipEncoding);
  }
  toJSON() {
    return this;
  }
  static revive(data) {
    if (!data) {
      return data;
    } else if (data instanceof _URI) {
      return data;
    } else {
      const result = new Uri(data);
      result._formatted = data.external ?? null;
      result._fsPath = data._sep === _pathSepMarker ? data.fsPath ?? null : null;
      return result;
    }
  }
  [Symbol.for("debug.description")]() {
    return `URI(${this.toString()})`;
  }
};
function $Hc(thing) {
  if (!thing || typeof thing !== "object") {
    return false;
  }
  return typeof thing.scheme === "string" && (typeof thing.authority === "string" || typeof thing.authority === "undefined") && (typeof thing.path === "string" || typeof thing.path === "undefined") && (typeof thing.query === "string" || typeof thing.query === "undefined") && (typeof thing.fragment === "string" || typeof thing.fragment === "undefined");
}
var _pathSepMarker = $l ? 1 : void 0;
var Uri = class extends URI {
  constructor() {
    super(...arguments);
    this._formatted = null;
    this._fsPath = null;
  }
  get fsPath() {
    if (!this._fsPath) {
      this._fsPath = $Ic(this, false);
    }
    return this._fsPath;
  }
  toString(skipEncoding = false) {
    if (!skipEncoding) {
      if (!this._formatted) {
        this._formatted = _asFormatted(this, false);
      }
      return this._formatted;
    } else {
      return _asFormatted(this, true);
    }
  }
  toJSON() {
    const res = {
      $mid: 1
      /* MarshalledId.Uri */
    };
    if (this._fsPath) {
      res.fsPath = this._fsPath;
      res._sep = _pathSepMarker;
    }
    if (this._formatted) {
      res.external = this._formatted;
    }
    if (this.path) {
      res.path = this.path;
    }
    if (this.scheme) {
      res.scheme = this.scheme;
    }
    if (this.authority) {
      res.authority = this.authority;
    }
    if (this.query) {
      res.query = this.query;
    }
    if (this.fragment) {
      res.fragment = this.fragment;
    }
    return res;
  }
};
var encodeTable = {
  [
    58
    /* CharCode.Colon */
  ]: "%3A",
  // gen-delims
  [
    47
    /* CharCode.Slash */
  ]: "%2F",
  [
    63
    /* CharCode.QuestionMark */
  ]: "%3F",
  [
    35
    /* CharCode.Hash */
  ]: "%23",
  [
    91
    /* CharCode.OpenSquareBracket */
  ]: "%5B",
  [
    93
    /* CharCode.CloseSquareBracket */
  ]: "%5D",
  [
    64
    /* CharCode.AtSign */
  ]: "%40",
  [
    33
    /* CharCode.ExclamationMark */
  ]: "%21",
  // sub-delims
  [
    36
    /* CharCode.DollarSign */
  ]: "%24",
  [
    38
    /* CharCode.Ampersand */
  ]: "%26",
  [
    39
    /* CharCode.SingleQuote */
  ]: "%27",
  [
    40
    /* CharCode.OpenParen */
  ]: "%28",
  [
    41
    /* CharCode.CloseParen */
  ]: "%29",
  [
    42
    /* CharCode.Asterisk */
  ]: "%2A",
  [
    43
    /* CharCode.Plus */
  ]: "%2B",
  [
    44
    /* CharCode.Comma */
  ]: "%2C",
  [
    59
    /* CharCode.Semicolon */
  ]: "%3B",
  [
    61
    /* CharCode.Equals */
  ]: "%3D",
  [
    32
    /* CharCode.Space */
  ]: "%20"
};
function encodeURIComponentFast(uriComponent, isPath, isAuthority) {
  let res = void 0;
  let nativeEncodePos = -1;
  for (let pos = 0; pos < uriComponent.length; pos++) {
    const code = uriComponent.charCodeAt(pos);
    if (code >= 97 && code <= 122 || code >= 65 && code <= 90 || code >= 48 && code <= 57 || code === 45 || code === 46 || code === 95 || code === 126 || isPath && code === 47 || isAuthority && code === 91 || isAuthority && code === 93 || isAuthority && code === 58) {
      if (nativeEncodePos !== -1) {
        res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
        nativeEncodePos = -1;
      }
      if (res !== void 0) {
        res += uriComponent.charAt(pos);
      }
    } else {
      if (res === void 0) {
        res = uriComponent.substr(0, pos);
      }
      const escaped = encodeTable[code];
      if (escaped !== void 0) {
        if (nativeEncodePos !== -1) {
          res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
          nativeEncodePos = -1;
        }
        res += escaped;
      } else if (nativeEncodePos === -1) {
        nativeEncodePos = pos;
      }
    }
  }
  if (nativeEncodePos !== -1) {
    res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
  }
  return res !== void 0 ? res : uriComponent;
}
function encodeURIComponentMinimal(path) {
  let res = void 0;
  for (let pos = 0; pos < path.length; pos++) {
    const code = path.charCodeAt(pos);
    if (code === 35 || code === 63) {
      if (res === void 0) {
        res = path.substr(0, pos);
      }
      res += encodeTable[code];
    } else {
      if (res !== void 0) {
        res += path[pos];
      }
    }
  }
  return res !== void 0 ? res : path;
}
function $Ic(uri, keepDriveLetterCasing) {
  let value;
  if (uri.authority && uri.path.length > 1 && uri.scheme === "file") {
    value = `//${uri.authority}${uri.path}`;
  } else if (uri.path.charCodeAt(0) === 47 && (uri.path.charCodeAt(1) >= 65 && uri.path.charCodeAt(1) <= 90 || uri.path.charCodeAt(1) >= 97 && uri.path.charCodeAt(1) <= 122) && uri.path.charCodeAt(2) === 58) {
    if (!keepDriveLetterCasing) {
      value = uri.path[1].toLowerCase() + uri.path.substr(2);
    } else {
      value = uri.path.substr(1);
    }
  } else {
    value = uri.path;
  }
  if ($l) {
    value = value.replace(/\//g, "\\");
  }
  return value;
}
function _asFormatted(uri, skipEncoding) {
  const encoder = !skipEncoding ? encodeURIComponentFast : encodeURIComponentMinimal;
  let res = "";
  let { scheme, authority, path, query, fragment } = uri;
  if (scheme) {
    res += scheme;
    res += ":";
  }
  if (authority || scheme === "file") {
    res += _slash;
    res += _slash;
  }
  if (authority) {
    let idx = authority.indexOf("@");
    if (idx !== -1) {
      const userinfo = authority.substr(0, idx);
      authority = authority.substr(idx + 1);
      idx = userinfo.lastIndexOf(":");
      if (idx === -1) {
        res += encoder(userinfo, false, false);
      } else {
        res += encoder(userinfo.substr(0, idx), false, false);
        res += ":";
        res += encoder(userinfo.substr(idx + 1), false, true);
      }
      res += "@";
    }
    authority = authority.toLowerCase();
    idx = authority.lastIndexOf(":");
    if (idx === -1) {
      res += encoder(authority, false, true);
    } else {
      res += encoder(authority.substr(0, idx), false, true);
      res += authority.substr(idx);
    }
  }
  if (path) {
    if (path.length >= 3 && path.charCodeAt(0) === 47 && path.charCodeAt(2) === 58) {
      const code = path.charCodeAt(1);
      if (code >= 65 && code <= 90) {
        path = `/${String.fromCharCode(code + 32)}:${path.substr(3)}`;
      }
    } else if (path.length >= 2 && path.charCodeAt(1) === 58) {
      const code = path.charCodeAt(0);
      if (code >= 65 && code <= 90) {
        path = `${String.fromCharCode(code + 32)}:${path.substr(2)}`;
      }
    }
    res += encoder(path, true, false);
  }
  if (query) {
    res += "?";
    res += encoder(query, false, false);
  }
  if (fragment) {
    res += "#";
    res += !skipEncoding ? encodeURIComponentFast(fragment, false, false) : fragment;
  }
  return res;
}
function decodeURIComponentGraceful(str) {
  try {
    return decodeURIComponent(str);
  } catch {
    if (str.length > 3) {
      return str.substr(0, 3) + decodeURIComponentGraceful(str.substr(3));
    } else {
      return str;
    }
  }
}
var _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
function percentDecode(str) {
  if (!str.match(_rEncodedAsHex)) {
    return str;
  }
  return str.replace(_rEncodedAsHex, (match) => decodeURIComponentGraceful(match));
}

// out-build/vs/base/common/network.js
var Schemas;
(function(Schemas3) {
  Schemas3.inMemory = "inmemory";
  Schemas3.vscode = "vscode";
  Schemas3.internal = "private";
  Schemas3.walkThrough = "walkThrough";
  Schemas3.walkThroughSnippet = "walkThroughSnippet";
  Schemas3.http = "http";
  Schemas3.https = "https";
  Schemas3.file = "file";
  Schemas3.mailto = "mailto";
  Schemas3.untitled = "untitled";
  Schemas3.data = "data";
  Schemas3.command = "command";
  Schemas3.vscodeRemote = "vscode-remote";
  Schemas3.vscodeRemoteResource = "vscode-remote-resource";
  Schemas3.vscodeManagedRemoteResource = "vscode-managed-remote-resource";
  Schemas3.vscodeUserData = "vscode-userdata";
  Schemas3.vscodeCustomEditor = "vscode-custom-editor";
  Schemas3.vscodeNotebookCell = "vscode-notebook-cell";
  Schemas3.vscodeNotebookCellMetadata = "vscode-notebook-cell-metadata";
  Schemas3.vscodeNotebookCellMetadataDiff = "vscode-notebook-cell-metadata-diff";
  Schemas3.vscodeNotebookCellOutput = "vscode-notebook-cell-output";
  Schemas3.vscodeNotebookCellOutputDiff = "vscode-notebook-cell-output-diff";
  Schemas3.vscodeNotebookMetadata = "vscode-notebook-metadata";
  Schemas3.vscodeInteractiveInput = "vscode-interactive-input";
  Schemas3.vscodeSettings = "vscode-settings";
  Schemas3.vscodeWorkspaceTrust = "vscode-workspace-trust";
  Schemas3.vscodeTerminal = "vscode-terminal";
  Schemas3.vscodeChatCodeBlock = "vscode-chat-code-block";
  Schemas3.vscodeChatCodeCompareBlock = "vscode-chat-code-compare-block";
  Schemas3.vscodeChatSesssion = "vscode-chat-editor";
  Schemas3.webviewPanel = "webview-panel";
  Schemas3.vscodeWebview = "vscode-webview";
  Schemas3.extension = "extension";
  Schemas3.vscodeFileResource = "vscode-file";
  Schemas3.tmp = "tmp";
  Schemas3.vsls = "vsls";
  Schemas3.vscodeSourceControl = "vscode-scm";
  Schemas3.commentsInput = "comment";
  Schemas3.codeSetting = "code-setting";
  Schemas3.outputChannel = "output";
})(Schemas || (Schemas = {}));
function $9g(target, scheme) {
  if (URI.isUri(target)) {
    return $Zf(target.scheme, scheme);
  } else {
    return $1f(target, scheme + ":");
  }
}
function $0g(target, ...schemes) {
  return schemes.some((scheme) => $9g(target, scheme));
}
var $_g = "tkn";
var RemoteAuthoritiesImpl = class {
  constructor() {
    this.a = /* @__PURE__ */ Object.create(null);
    this.b = /* @__PURE__ */ Object.create(null);
    this.c = /* @__PURE__ */ Object.create(null);
    this.d = "http";
    this.e = null;
    this.f = "/";
  }
  setPreferredWebSchema(schema9) {
    this.d = schema9;
  }
  setDelegate(delegate) {
    this.e = delegate;
  }
  setServerRootPath(product2, serverBasePath) {
    this.f = $bh(product2, serverBasePath);
  }
  getServerRootPath() {
    return this.f;
  }
  get g() {
    return $sc.join(this.f, Schemas.vscodeRemoteResource);
  }
  set(authority, host, port) {
    this.a[authority] = host;
    this.b[authority] = port;
  }
  setConnectionToken(authority, connectionToken) {
    this.c[authority] = connectionToken;
  }
  getPreferredWebSchema() {
    return this.d;
  }
  rewrite(uri) {
    if (this.e) {
      try {
        return this.e(uri);
      } catch (err) {
        $ab(err);
        return uri;
      }
    }
    const authority = uri.authority;
    let host = this.a[authority];
    if (host && host.indexOf(":") !== -1 && host.indexOf("[") === -1) {
      host = `[${host}]`;
    }
    const port = this.b[authority];
    const connectionToken = this.c[authority];
    let query = `path=${encodeURIComponent(uri.path)}`;
    if (typeof connectionToken === "string") {
      query += `&${$_g}=${encodeURIComponent(connectionToken)}`;
    }
    return URI.from({
      scheme: $r ? this.d : Schemas.vscodeRemoteResource,
      authority: `${host}:${port}`,
      path: this.g,
      query
    });
  }
};
var $ah = new RemoteAuthoritiesImpl();
function $bh(product2, basePath) {
  return $sc.join(basePath ?? "/", `${product2.quality ?? "oss"}-${product2.commit ?? "dev"}`);
}
var $ch = "vs/../../extensions";
var $dh = "vs/../../node_modules";
var $eh = "vs/../../node_modules.asar";
var $fh = "vs/../../node_modules.asar.unpacked";
var $gh = "vscode-app";
var FileAccessImpl = class _FileAccessImpl {
  static {
    this.a = $gh;
  }
  /**
   * Returns a URI to use in contexts where the browser is responsible
   * for loading (e.g. fetch()) or when used within the DOM.
   *
   * **Note:** use `dom.ts#asCSSUrl` whenever the URL is to be used in CSS context.
   */
  asBrowserUri(resourcePath) {
    const uri = this.b(resourcePath);
    return this.uriToBrowserUri(uri);
  }
  /**
   * Returns a URI to use in contexts where the browser is responsible
   * for loading (e.g. fetch()) or when used within the DOM.
   *
   * **Note:** use `dom.ts#asCSSUrl` whenever the URL is to be used in CSS context.
   */
  uriToBrowserUri(uri) {
    if (uri.scheme === Schemas.vscodeRemote) {
      return $ah.rewrite(uri);
    }
    if (
      // ...only ever for `file` resources
      uri.scheme === Schemas.file && // ...and we run in native environments
      ($p || // ...or web worker extensions on desktop
      $t === `${Schemas.vscodeFileResource}://${_FileAccessImpl.a}`)
    ) {
      return uri.with({
        scheme: Schemas.vscodeFileResource,
        // We need to provide an authority here so that it can serve
        // as origin for network and loading matters in chromium.
        // If the URI is not coming with an authority already, we
        // add our own
        authority: uri.authority || _FileAccessImpl.a,
        query: null,
        fragment: null
      });
    }
    return uri;
  }
  /**
   * Returns the `file` URI to use in contexts where node.js
   * is responsible for loading.
   */
  asFileUri(resourcePath) {
    const uri = this.b(resourcePath);
    return this.uriToFileUri(uri);
  }
  /**
   * Returns the `file` URI to use in contexts where node.js
   * is responsible for loading.
   */
  uriToFileUri(uri) {
    if (uri.scheme === Schemas.vscodeFileResource) {
      return uri.with({
        scheme: Schemas.file,
        // Only preserve the `authority` if it is different from
        // our fallback authority. This ensures we properly preserve
        // Windows UNC paths that come with their own authority.
        authority: uri.authority !== _FileAccessImpl.a ? uri.authority : null,
        query: null,
        fragment: null
      });
    }
    return uri;
  }
  b(uriOrModule, moduleIdToUrl) {
    if (URI.isUri(uriOrModule)) {
      return uriOrModule;
    }
    if (globalThis._VSCODE_FILE_ROOT) {
      const rootUriOrPath = globalThis._VSCODE_FILE_ROOT;
      if (/^\w[\w\d+.-]*:\/\//.test(rootUriOrPath)) {
        return URI.joinPath(URI.parse(rootUriOrPath, true), uriOrModule);
      }
      const modulePath = $vc(rootUriOrPath, uriOrModule);
      return URI.file(modulePath);
    }
    return URI.parse(moduleIdToUrl.toUrl(uriOrModule));
  }
};
var $hh = new FileAccessImpl();
var COI;
(function(COI2) {
  const coiHeaders = /* @__PURE__ */ new Map([
    ["1", { "Cross-Origin-Opener-Policy": "same-origin" }],
    ["2", { "Cross-Origin-Embedder-Policy": "require-corp" }],
    ["3", { "Cross-Origin-Opener-Policy": "same-origin", "Cross-Origin-Embedder-Policy": "require-corp" }]
  ]);
  COI2.CoopAndCoep = Object.freeze(coiHeaders.get("3"));
  const coiSearchParamName = "vscode-coi";
  function getHeadersFromQuery(url) {
    let params;
    if (typeof url === "string") {
      params = new URL(url).searchParams;
    } else if (url instanceof URL) {
      params = url.searchParams;
    } else if (URI.isUri(url)) {
      params = new URL(url.toString(true)).searchParams;
    }
    const value = params?.get(coiSearchParamName);
    if (!value) {
      return void 0;
    }
    return coiHeaders.get(value);
  }
  COI2.getHeadersFromQuery = getHeadersFromQuery;
  function addSearchParam(urlOrSearch, coop, coep) {
    if (!globalThis.crossOriginIsolated) {
      return;
    }
    const value = coop && coep ? "3" : coep ? "2" : "1";
    if (urlOrSearch instanceof URLSearchParams) {
      urlOrSearch.set(coiSearchParamName, value);
    } else {
      urlOrSearch[coiSearchParamName] = value;
    }
  }
  COI2.addSearchParam = addSearchParam;
})(COI || (COI = {}));

// out-build/vs/base/common/resources.js
function $oh(uri) {
  return $Ic(uri, true);
}
var $ph = class {
  constructor(a) {
    this.a = a;
  }
  compare(uri1, uri2, ignoreFragment = false) {
    if (uri1 === uri2) {
      return 0;
    }
    return $Sf(this.getComparisonKey(uri1, ignoreFragment), this.getComparisonKey(uri2, ignoreFragment));
  }
  isEqual(uri1, uri2, ignoreFragment = false) {
    if (uri1 === uri2) {
      return true;
    }
    if (!uri1 || !uri2) {
      return false;
    }
    return this.getComparisonKey(uri1, ignoreFragment) === this.getComparisonKey(uri2, ignoreFragment);
  }
  getComparisonKey(uri, ignoreFragment = false) {
    return uri.with({
      path: this.a(uri) ? uri.path.toLowerCase() : void 0,
      fragment: ignoreFragment ? null : void 0
    }).toString();
  }
  ignorePathCasing(uri) {
    return this.a(uri);
  }
  isEqualOrParent(base, parentCandidate, ignoreFragment = false) {
    if (base.scheme === parentCandidate.scheme) {
      if (base.scheme === Schemas.file) {
        return $Yg($oh(base), $oh(parentCandidate), this.a(base)) && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
      }
      if ($Fh(base.authority, parentCandidate.authority)) {
        return $Yg(base.path, parentCandidate.path, this.a(base), "/") && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
      }
    }
    return false;
  }
  // --- path math
  joinPath(resource, ...pathFragment) {
    return URI.joinPath(resource, ...pathFragment);
  }
  basenameOrAuthority(resource) {
    return $xh(resource) || resource.authority;
  }
  basename(resource) {
    return $sc.basename(resource.path);
  }
  extname(resource) {
    return $sc.extname(resource.path);
  }
  dirname(resource) {
    if (resource.path.length === 0) {
      return resource;
    }
    let dirname;
    if (resource.scheme === Schemas.file) {
      dirname = URI.file($yc($oh(resource))).path;
    } else {
      dirname = $sc.dirname(resource.path);
      if (resource.authority && dirname.length && dirname.charCodeAt(0) !== 47) {
        console.error(`dirname("${resource.toString})) resulted in a relative path`);
        dirname = "/";
      }
    }
    return resource.with({
      path: dirname
    });
  }
  normalizePath(resource) {
    if (!resource.path.length) {
      return resource;
    }
    let normalizedPath;
    if (resource.scheme === Schemas.file) {
      normalizedPath = URI.file($tc($oh(resource))).path;
    } else {
      normalizedPath = $sc.normalize(resource.path);
    }
    return resource.with({
      path: normalizedPath
    });
  }
  relativePath(from, to) {
    if (from.scheme !== to.scheme || !$Fh(from.authority, to.authority)) {
      return void 0;
    }
    if (from.scheme === Schemas.file) {
      const relativePath = $xc($oh(from), $oh(to));
      return $l ? $Sg(relativePath) : relativePath;
    }
    let fromPath = from.path || "/";
    const toPath = to.path || "/";
    if (this.a(from)) {
      let i = 0;
      for (const len = Math.min(fromPath.length, toPath.length); i < len; i++) {
        if (fromPath.charCodeAt(i) !== toPath.charCodeAt(i)) {
          if (fromPath.charAt(i).toLowerCase() !== toPath.charAt(i).toLowerCase()) {
            break;
          }
        }
      }
      fromPath = toPath.substr(0, i) + fromPath.substr(i);
    }
    return $sc.relative(fromPath, toPath);
  }
  resolvePath(base, path) {
    if (base.scheme === Schemas.file) {
      const newURI = URI.file($wc($oh(base), path));
      return base.with({
        authority: newURI.authority,
        path: newURI.path
      });
    }
    path = $Tg(path);
    return base.with({
      path: $sc.resolve(base.path, path)
    });
  }
  // --- misc
  isAbsolutePath(resource) {
    return !!resource.path && resource.path[0] === "/";
  }
  isEqualAuthority(a1, a2) {
    return a1 === a2 || a1 !== void 0 && a2 !== void 0 && $Zf(a1, a2);
  }
  hasTrailingPathSeparator(resource, sep2 = sep) {
    if (resource.scheme === Schemas.file) {
      const fsp = $oh(resource);
      return fsp.length > $Ug(fsp).length && fsp[fsp.length - 1] === sep2;
    } else {
      const p = resource.path;
      return p.length > 1 && p.charCodeAt(p.length - 1) === 47 && !/^[a-zA-Z]:(\/$|\\$)/.test(resource.fsPath);
    }
  }
  removeTrailingPathSeparator(resource, sep2 = sep) {
    if ($Gh(resource, sep2)) {
      return resource.with({ path: resource.path.substr(0, resource.path.length - 1) });
    }
    return resource;
  }
  addTrailingPathSeparator(resource, sep2 = sep) {
    let isRootSep = false;
    if (resource.scheme === Schemas.file) {
      const fsp = $oh(resource);
      isRootSep = fsp !== void 0 && fsp.length === $Ug(fsp).length && fsp[fsp.length - 1] === sep2;
    } else {
      sep2 = "/";
      const p = resource.path;
      isRootSep = p.length === 1 && p.charCodeAt(p.length - 1) === 47;
    }
    if (!isRootSep && !$Gh(resource, sep2)) {
      return resource.with({ path: resource.path + "/" });
    }
    return resource;
  }
};
var $qh = new $ph(() => false);
var $rh = new $ph((uri) => {
  return uri.scheme === Schemas.file ? !$n : true;
});
var $sh = new $ph((_) => true);
var $th = $qh.isEqual.bind($qh);
var $uh = $qh.isEqualOrParent.bind($qh);
var $vh = $qh.getComparisonKey.bind($qh);
var $wh = $qh.basenameOrAuthority.bind($qh);
var $xh = $qh.basename.bind($qh);
var $yh = $qh.extname.bind($qh);
var $zh = $qh.dirname.bind($qh);
var $Ah = $qh.joinPath.bind($qh);
var $Bh = $qh.normalizePath.bind($qh);
var $Ch = $qh.relativePath.bind($qh);
var $Dh = $qh.resolvePath.bind($qh);
var $Eh = $qh.isAbsolutePath.bind($qh);
var $Fh = $qh.isEqualAuthority.bind($qh);
var $Gh = $qh.hasTrailingPathSeparator.bind($qh);
var $Hh = $qh.removeTrailingPathSeparator.bind($qh);
var $Ih = $qh.addTrailingPathSeparator.bind($qh);
function $Jh(items, resourceAccessor) {
  const distinctParents = [];
  for (let i = 0; i < items.length; i++) {
    const candidateResource = resourceAccessor(items[i]);
    if (items.some((otherItem, index) => {
      if (index === i) {
        return false;
      }
      return $uh(candidateResource, resourceAccessor(otherItem));
    })) {
      continue;
    }
    distinctParents.push(items[i]);
  }
  return distinctParents;
}
var DataUri;
(function(DataUri2) {
  DataUri2.META_DATA_LABEL = "label";
  DataUri2.META_DATA_DESCRIPTION = "description";
  DataUri2.META_DATA_SIZE = "size";
  DataUri2.META_DATA_MIME = "mime";
  function parseMetaData(dataUri) {
    const metadata = /* @__PURE__ */ new Map();
    const meta = dataUri.path.substring(dataUri.path.indexOf(";") + 1, dataUri.path.lastIndexOf(";"));
    meta.split(";").forEach((property) => {
      const [key, value] = property.split(":");
      if (key && value) {
        metadata.set(key, value);
      }
    });
    const mime = dataUri.path.substring(0, dataUri.path.indexOf(";"));
    if (mime) {
      metadata.set(DataUri2.META_DATA_MIME, mime);
    }
    return metadata;
  }
  DataUri2.parseMetaData = parseMetaData;
})(DataUri || (DataUri = {}));
function $Kh(resource, authority, localScheme) {
  if (authority) {
    let path = resource.path;
    if (path && path[0] !== $sc.sep) {
      path = $sc.sep + path;
    }
    return resource.with({ scheme: localScheme, authority, path });
  }
  return resource.with({ scheme: localScheme });
}

// out-build/vs/base/common/symbols.js
var $ye = Symbol("MicrotaskDelay");

// out-build/vs/base/common/async.js
function $Lh(obj) {
  return !!obj && typeof obj.then === "function";
}
function $Mh(callback) {
  const source = new $Pe();
  const thenable = callback(source.token);
  const promise = new Promise((resolve, reject) => {
    const subscription = source.token.onCancellationRequested(() => {
      subscription.dispose();
      reject(new $fb());
    });
    Promise.resolve(thenable).then((value) => {
      subscription.dispose();
      source.dispose();
      resolve(value);
    }, (err) => {
      subscription.dispose();
      source.dispose();
      reject(err);
    });
  });
  return new class {
    cancel() {
      source.cancel();
      source.dispose();
    }
    then(resolve, reject) {
      return promise.then(resolve, reject);
    }
    catch(reject) {
      return this.then(void 0, reject);
    }
    finally(onfinally) {
      return promise.finally(onfinally);
    }
  }();
}
function $Nh(promise, token, defaultValue) {
  return new Promise((resolve, reject) => {
    const ref = token.onCancellationRequested(() => {
      ref.dispose();
      resolve(defaultValue);
    });
    promise.then(resolve, reject).finally(() => ref.dispose());
  });
}
function $Oh(promise, token) {
  return new Promise((resolve, reject) => {
    const ref = token.onCancellationRequested(() => {
      ref.dispose();
      reject(new $fb());
    });
    promise.then(resolve, reject).finally(() => ref.dispose());
  });
}
async function $Ph(cancellablePromises) {
  let resolvedPromiseIndex = -1;
  const promises = cancellablePromises.map((promise, index) => promise.then((result) => {
    resolvedPromiseIndex = index;
    return result;
  }));
  try {
    const result = await Promise.race(promises);
    return result;
  } finally {
    cancellablePromises.forEach((cancellablePromise, index) => {
      if (index !== resolvedPromiseIndex) {
        cancellablePromise.cancel();
      }
    });
  }
}
function $Qh(promise, timeout, onTimeout) {
  let promiseResolve = void 0;
  const timer = setTimeout(() => {
    promiseResolve?.(void 0);
    onTimeout?.();
  }, timeout);
  return Promise.race([
    promise.finally(() => clearTimeout(timer)),
    new Promise((resolve) => promiseResolve = resolve)
  ]);
}
function $Sh() {
  let resolve;
  let reject;
  const promise = new Promise((res, rej) => {
    resolve = res;
    reject = rej;
  });
  return { promise, resolve, reject };
}
var $Th = class {
  constructor() {
    this.f = false;
    this.a = null;
    this.b = null;
    this.d = null;
  }
  queue(promiseFactory) {
    if (this.f) {
      return Promise.reject(new Error("Throttler is disposed"));
    }
    if (this.a) {
      this.d = promiseFactory;
      if (!this.b) {
        const onComplete = () => {
          this.b = null;
          if (this.f) {
            return;
          }
          const result = this.queue(this.d);
          this.d = null;
          return result;
        };
        this.b = new Promise((resolve) => {
          this.a.then(onComplete, onComplete).then(resolve);
        });
      }
      return new Promise((resolve, reject) => {
        this.b.then(resolve, reject);
      });
    }
    this.a = promiseFactory();
    return new Promise((resolve, reject) => {
      this.a.then((result) => {
        this.a = null;
        resolve(result);
      }, (err) => {
        this.a = null;
        reject(err);
      });
    });
  }
  dispose() {
    this.f = true;
  }
};
var $Uh = class {
  constructor() {
    this.a = Promise.resolve(null);
  }
  queue(promiseTask) {
    return this.a = this.a.then(() => promiseTask(), () => promiseTask());
  }
};
var $Vh = class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
  }
  queue(key, promiseTask) {
    const runningPromise = this.a.get(key) ?? Promise.resolve();
    const newPromise = runningPromise.catch(() => {
    }).then(promiseTask).finally(() => {
      if (this.a.get(key) === newPromise) {
        this.a.delete(key);
      }
    });
    this.a.set(key, newPromise);
    return newPromise;
  }
};
var timeoutDeferred = (timeout, fn) => {
  let scheduled = true;
  const handle2 = setTimeout(() => {
    scheduled = false;
    fn();
  }, timeout);
  return {
    isTriggered: () => scheduled,
    dispose: () => {
      clearTimeout(handle2);
      scheduled = false;
    }
  };
};
var microtaskDeferred = (fn) => {
  let scheduled = true;
  queueMicrotask(() => {
    if (scheduled) {
      scheduled = false;
      fn();
    }
  });
  return {
    isTriggered: () => scheduled,
    dispose: () => {
      scheduled = false;
    }
  };
};
var $Wh = class {
  constructor(defaultDelay) {
    this.defaultDelay = defaultDelay;
    this.a = null;
    this.b = null;
    this.d = null;
    this.f = null;
    this.g = null;
  }
  trigger(task, delay = this.defaultDelay) {
    this.g = task;
    this.h();
    if (!this.b) {
      this.b = new Promise((resolve, reject) => {
        this.d = resolve;
        this.f = reject;
      }).then(() => {
        this.b = null;
        this.d = null;
        if (this.g) {
          const task2 = this.g;
          this.g = null;
          return task2();
        }
        return void 0;
      });
    }
    const fn = () => {
      this.a = null;
      this.d?.(null);
    };
    this.a = delay === $ye ? microtaskDeferred(fn) : timeoutDeferred(delay, fn);
    return this.b;
  }
  isTriggered() {
    return !!this.a?.isTriggered();
  }
  cancel() {
    this.h();
    if (this.b) {
      this.f?.(new $fb());
      this.b = null;
    }
  }
  h() {
    this.a?.dispose();
    this.a = null;
  }
  dispose() {
    this.cancel();
  }
};
var $Xh = class {
  constructor(defaultDelay) {
    this.a = new $Wh(defaultDelay);
    this.b = new $Th();
  }
  trigger(promiseFactory, delay) {
    return this.a.trigger(() => this.b.queue(promiseFactory), delay);
  }
  isTriggered() {
    return this.a.isTriggered();
  }
  cancel() {
    this.a.cancel();
  }
  dispose() {
    this.a.dispose();
    this.b.dispose();
  }
};
var $Yh = class {
  constructor() {
    this.a = false;
    this.b = new Promise((c, e) => {
      this.d = c;
    });
  }
  isOpen() {
    return this.a;
  }
  open() {
    this.a = true;
    this.d(true);
  }
  wait() {
    return this.b;
  }
};
var $Zh = class extends $Yh {
  constructor(autoOpenTimeMs) {
    super();
    this.f = setTimeout(() => this.open(), autoOpenTimeMs);
  }
  open() {
    clearTimeout(this.f);
    super.open();
  }
};
function $1h(millis, token) {
  if (!token) {
    return $Mh((token2) => $1h(millis, token2));
  }
  return new Promise((resolve, reject) => {
    const handle2 = setTimeout(() => {
      disposable.dispose();
      resolve();
    }, millis);
    const disposable = token.onCancellationRequested(() => {
      clearTimeout(handle2);
      disposable.dispose();
      reject(new $fb());
    });
  });
}
function $2h(handler, timeout = 0, store) {
  const timer = setTimeout(() => {
    handler();
    if (store) {
      disposable.dispose();
    }
  }, timeout);
  const disposable = $8c(() => {
    clearTimeout(timer);
    store?.deleteAndLeak(disposable);
  });
  store?.add(disposable);
  return disposable;
}
function $3h(promiseFactories) {
  const results = [];
  let index = 0;
  const len = promiseFactories.length;
  function next() {
    return index < len ? promiseFactories[index++]() : null;
  }
  function thenHandler(result) {
    if (result !== void 0 && result !== null) {
      results.push(result);
    }
    const n = next();
    if (n) {
      return n.then(thenHandler);
    }
    return Promise.resolve(results);
  }
  return Promise.resolve(null).then(thenHandler);
}
function $4h(promiseFactories, shouldStop = (t) => !!t, defaultValue = null) {
  let index = 0;
  const len = promiseFactories.length;
  const loop = () => {
    if (index >= len) {
      return Promise.resolve(defaultValue);
    }
    const factory = promiseFactories[index++];
    const promise = Promise.resolve(factory());
    return promise.then((result) => {
      if (shouldStop(result)) {
        return Promise.resolve(result);
      }
      return loop();
    });
  };
  return loop();
}
var $6h = class {
  constructor(maxDegreeOfParalellism) {
    this.a = 0;
    this.b = false;
    this.f = maxDegreeOfParalellism;
    this.g = [];
    this.d = 0;
    this.h = new $De();
  }
  /**
   *
   * @returns A promise that resolved when all work is done (onDrained) or when
   * there is nothing to do
   */
  whenIdle() {
    return this.size > 0 ? Event2.toPromise(this.onDrained) : Promise.resolve();
  }
  get onDrained() {
    return this.h.event;
  }
  get size() {
    return this.a;
  }
  queue(factory) {
    if (this.b) {
      throw new Error("Object has been disposed");
    }
    this.a++;
    return new Promise((c, e) => {
      this.g.push({ factory, c, e });
      this.j();
    });
  }
  j() {
    while (this.g.length && this.d < this.f) {
      const iLimitedTask = this.g.shift();
      this.d++;
      const promise = iLimitedTask.factory();
      promise.then(iLimitedTask.c, iLimitedTask.e);
      promise.then(() => this.k(), () => this.k());
    }
  }
  k() {
    if (this.b) {
      return;
    }
    this.d--;
    if (--this.a === 0) {
      this.h.fire();
    }
    if (this.g.length > 0) {
      this.j();
    }
  }
  clear() {
    if (this.b) {
      throw new Error("Object has been disposed");
    }
    this.g.length = 0;
    this.a = this.d;
  }
  dispose() {
    this.b = true;
    this.g.length = 0;
    this.a = 0;
    this.h.dispose();
  }
};
var $7h = class extends $6h {
  constructor() {
    super(1);
  }
};
var $9h = class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
    this.b = /* @__PURE__ */ new Set();
    this.d = void 0;
    this.f = 0;
  }
  async whenDrained() {
    if (this.g()) {
      return;
    }
    const promise = new $ki();
    this.b.add(promise);
    return promise.p;
  }
  g() {
    for (const [, queue] of this.a) {
      if (queue.size > 0) {
        return false;
      }
    }
    return true;
  }
  queueSize(resource, extUri = $qh) {
    const key = extUri.getComparisonKey(resource);
    return this.a.get(key)?.size ?? 0;
  }
  queueFor(resource, factory, extUri = $qh) {
    const key = extUri.getComparisonKey(resource);
    let queue = this.a.get(key);
    if (!queue) {
      queue = new $7h();
      const drainListenerId = this.f++;
      const drainListener = Event2.once(queue.onDrained)(() => {
        queue?.dispose();
        this.a.delete(key);
        this.h();
        this.d?.deleteAndDispose(drainListenerId);
        if (this.d?.size === 0) {
          this.d.dispose();
          this.d = void 0;
        }
      });
      if (!this.d) {
        this.d = new $gd();
      }
      this.d.set(drainListenerId, drainListener);
      this.a.set(key, queue);
    }
    return queue.queue(factory);
  }
  h() {
    if (!this.g()) {
      return;
    }
    this.j();
  }
  j() {
    for (const drainer of this.b) {
      drainer.complete();
    }
    this.b.clear();
  }
  dispose() {
    for (const [, queue] of this.a) {
      queue.dispose();
    }
    this.a.clear();
    this.j();
    this.d?.dispose();
  }
};
var $0h = class {
  constructor(runner, timeout) {
    this.b = false;
    this.a = -1;
    if (typeof runner === "function" && typeof timeout === "number") {
      this.setIfNotSet(runner, timeout);
    }
  }
  dispose() {
    this.cancel();
    this.b = true;
  }
  cancel() {
    if (this.a !== -1) {
      clearTimeout(this.a);
      this.a = -1;
    }
  }
  cancelAndSet(runner, timeout) {
    if (this.b) {
      throw new $pb(`Calling 'cancelAndSet' on a disposed TimeoutTimer`);
    }
    this.cancel();
    this.a = setTimeout(() => {
      this.a = -1;
      runner();
    }, timeout);
  }
  setIfNotSet(runner, timeout) {
    if (this.b) {
      throw new $pb(`Calling 'setIfNotSet' on a disposed TimeoutTimer`);
    }
    if (this.a !== -1) {
      return;
    }
    this.a = setTimeout(() => {
      this.a = -1;
      runner();
    }, timeout);
  }
};
var $$h = class {
  constructor() {
    this.d = void 0;
    this.f = false;
  }
  cancel() {
    this.d?.dispose();
    this.d = void 0;
  }
  cancelAndSet(runner, interval, context = globalThis) {
    if (this.f) {
      throw new $pb(`Calling 'cancelAndSet' on a disposed IntervalTimer`);
    }
    this.cancel();
    const handle2 = context.setInterval(() => {
      runner();
    }, interval);
    this.d = $8c(() => {
      context.clearInterval(handle2);
      this.d = void 0;
    });
  }
  dispose() {
    this.cancel();
    this.f = true;
  }
};
var $_h = class {
  constructor(runner, delay) {
    this.b = -1;
    this.a = runner;
    this.d = delay;
    this.f = this.g.bind(this);
  }
  /**
   * Dispose RunOnceScheduler
   */
  dispose() {
    this.cancel();
    this.a = null;
  }
  /**
   * Cancel current scheduled runner (if any).
   */
  cancel() {
    if (this.isScheduled()) {
      clearTimeout(this.b);
      this.b = -1;
    }
  }
  /**
   * Cancel previous runner (if any) & schedule a new runner.
   */
  schedule(delay = this.d) {
    this.cancel();
    this.b = setTimeout(this.f, delay);
  }
  get delay() {
    return this.d;
  }
  set delay(value) {
    this.d = value;
  }
  /**
   * Returns true if scheduled.
   */
  isScheduled() {
    return this.b !== -1;
  }
  flush() {
    if (this.isScheduled()) {
      this.cancel();
      this.h();
    }
  }
  g() {
    this.b = -1;
    if (this.a) {
      this.h();
    }
  }
  h() {
    this.a?.();
  }
};
var $bi = class extends $_h {
  constructor(runner, timeout) {
    super(runner, timeout);
    this.j = [];
  }
  work(unit) {
    this.j.push(unit);
    if (!this.isScheduled()) {
      this.schedule();
    }
  }
  h() {
    const units = this.j;
    this.j = [];
    this.a?.(units);
  }
  dispose() {
    this.j = [];
    super.dispose();
  }
};
var $di;
var $ei;
(function() {
  if (typeof globalThis.requestIdleCallback !== "function" || typeof globalThis.cancelIdleCallback !== "function") {
    $ei = (_targetWindow, runner) => {
      $E(() => {
        if (disposed) {
          return;
        }
        const end = Date.now() + 15;
        const deadline = {
          didTimeout: true,
          timeRemaining() {
            return Math.max(0, end - Date.now());
          }
        };
        runner(Object.freeze(deadline));
      });
      let disposed = false;
      return {
        dispose() {
          if (disposed) {
            return;
          }
          disposed = true;
        }
      };
    };
  } else {
    $ei = (targetWindow, runner, timeout) => {
      const handle2 = targetWindow.requestIdleCallback(runner, typeof timeout === "number" ? { timeout } : void 0);
      let disposed = false;
      return {
        dispose() {
          if (disposed) {
            return;
          }
          disposed = true;
          targetWindow.cancelIdleCallback(handle2);
        }
      };
    };
  }
  $di = (runner) => $ei(globalThis, runner);
})();
var $fi = class {
  constructor(targetWindow, executor) {
    this.g = false;
    this.d = () => {
      try {
        this.j = executor();
      } catch (err) {
        this.l = err;
      } finally {
        this.g = true;
      }
    };
    this.f = $ei(targetWindow, () => this.d());
  }
  dispose() {
    this.f.dispose();
  }
  get value() {
    if (!this.g) {
      this.f.dispose();
      this.d();
    }
    if (this.l) {
      throw this.l;
    }
    return this.j;
  }
  get isInitialized() {
    return this.g;
  }
};
var $gi = class extends $fi {
  constructor(executor) {
    super(globalThis, executor);
  }
};
async function $hi(task, delay, retries) {
  let lastError;
  for (let i = 0; i < retries; i++) {
    try {
      return await task();
    } catch (error) {
      lastError = error;
      await $1h(delay);
    }
  }
  throw lastError;
}
var $ii = class {
  isRunning(taskId) {
    if (typeof taskId === "number") {
      return this.a?.taskId === taskId;
    }
    return !!this.a;
  }
  get running() {
    return this.a?.promise;
  }
  cancelRunning() {
    this.a?.cancel();
  }
  run(taskId, promise, onCancel) {
    this.a = { taskId, cancel: () => onCancel?.(), promise };
    promise.then(() => this.d(taskId), () => this.d(taskId));
    return promise;
  }
  d(taskId) {
    if (this.a && taskId === this.a.taskId) {
      this.a = void 0;
      this.f();
    }
  }
  f() {
    if (this.b) {
      const queued = this.b;
      this.b = void 0;
      queued.run().then(queued.promiseResolve, queued.promiseReject);
    }
  }
  /**
   * Note: the promise to schedule as next run MUST itself call `run`.
   *       Otherwise, this sequentializer will report `false` for `isRunning`
   *       even when this task is running. Missing this detail means that
   *       suddenly multiple tasks will run in parallel.
   */
  queue(run) {
    if (!this.b) {
      const { promise, resolve: promiseResolve, reject: promiseReject } = $Sh();
      this.b = {
        run,
        promise,
        promiseResolve,
        promiseReject
      };
    } else {
      this.b.run = run;
    }
    return this.b.promise;
  }
  hasQueued() {
    return !!this.b;
  }
  async join() {
    return this.b?.promise ?? this.a?.promise;
  }
};
var $ji = class {
  constructor(d, f = () => Date.now()) {
    this.d = d;
    this.f = f;
    this.a = 0;
    this.b = 0;
  }
  increment() {
    const now = this.f();
    if (now - this.a > this.d) {
      this.a = now;
      this.b = 0;
    }
    this.b++;
    return this.b;
  }
};
var DeferredOutcome;
(function(DeferredOutcome2) {
  DeferredOutcome2[DeferredOutcome2["Resolved"] = 0] = "Resolved";
  DeferredOutcome2[DeferredOutcome2["Rejected"] = 1] = "Rejected";
})(DeferredOutcome || (DeferredOutcome = {}));
var $ki = class {
  get isRejected() {
    return this.d?.outcome === 1;
  }
  get isResolved() {
    return this.d?.outcome === 0;
  }
  get isSettled() {
    return !!this.d;
  }
  get value() {
    return this.d?.outcome === 0 ? this.d?.value : void 0;
  }
  constructor() {
    this.p = new Promise((c, e) => {
      this.a = c;
      this.b = e;
    });
  }
  complete(value) {
    return new Promise((resolve) => {
      this.a(value);
      this.d = { outcome: 0, value };
      resolve();
    });
  }
  error(err) {
    return new Promise((resolve) => {
      this.b(err);
      this.d = { outcome: 1, value: err };
      resolve();
    });
  }
  cancel() {
    return this.error(new $fb());
  }
};
var Promises;
(function(Promises2) {
  async function settled(promises) {
    let firstError = void 0;
    const result = await Promise.all(promises.map((promise) => promise.then((value) => value, (error) => {
      if (!firstError) {
        firstError = error;
      }
      return void 0;
    })));
    if (typeof firstError !== "undefined") {
      throw firstError;
    }
    return result;
  }
  Promises2.settled = settled;
  function withAsyncBody(bodyFn) {
    return new Promise(async (resolve, reject) => {
      try {
        await bodyFn(resolve, reject);
      } catch (error) {
        reject(error);
      }
    });
  }
  Promises2.withAsyncBody = withAsyncBody;
})(Promises || (Promises = {}));
var $li = class {
  get value() {
    return this.a;
  }
  get error() {
    return this.b;
  }
  get isResolved() {
    return this.d;
  }
  constructor(promise) {
    this.a = void 0;
    this.b = void 0;
    this.d = false;
    this.promise = promise.then((value) => {
      this.a = value;
      this.d = true;
      return value;
    }, (error) => {
      this.b = error;
      this.d = true;
      throw error;
    });
  }
  /**
   * Returns the resolved value.
   * Throws if the promise is not resolved yet.
   */
  requireValue() {
    if (!this.d) {
      throw new $pb("Promise is not resolved yet");
    }
    if (this.b) {
      throw this.b;
    }
    return this.a;
  }
};
var $mi = class {
  constructor(b) {
    this.b = b;
    this.a = new $7(() => new $li(this.b()));
  }
  /**
   * Returns the resolved value.
   * Throws if the promise is not resolved yet.
   */
  requireValue() {
    return this.a.value.requireValue();
  }
  /**
   * Returns the promise (and triggers a computation of the promise if not yet done so).
   */
  getPromise() {
    return this.a.value.promise;
  }
  /**
   * Reads the current value without triggering a computation of the promise.
   */
  get currentValue() {
    return this.a.rawValue?.value;
  }
};
var AsyncIterableSourceState;
(function(AsyncIterableSourceState2) {
  AsyncIterableSourceState2[AsyncIterableSourceState2["Initial"] = 0] = "Initial";
  AsyncIterableSourceState2[AsyncIterableSourceState2["DoneOK"] = 1] = "DoneOK";
  AsyncIterableSourceState2[AsyncIterableSourceState2["DoneError"] = 2] = "DoneError";
})(AsyncIterableSourceState || (AsyncIterableSourceState = {}));
var $ni = class _$ni {
  static fromArray(items) {
    return new _$ni((writer) => {
      writer.emitMany(items);
    });
  }
  static fromPromise(promise) {
    return new _$ni(async (emitter) => {
      emitter.emitMany(await promise);
    });
  }
  static fromPromises(promises) {
    return new _$ni(async (emitter) => {
      await Promise.all(promises.map(async (p) => emitter.emitOne(await p)));
    });
  }
  static merge(iterables) {
    return new _$ni(async (emitter) => {
      await Promise.all(iterables.map(async (iterable) => {
        for await (const item of iterable) {
          emitter.emitOne(item);
        }
      }));
    });
  }
  static {
    this.EMPTY = _$ni.fromArray([]);
  }
  constructor(executor, onReturn) {
    this.a = 0;
    this.b = [];
    this.d = null;
    this.f = onReturn;
    this.g = new $De();
    queueMicrotask(async () => {
      const writer = {
        emitOne: (item) => this.h(item),
        emitMany: (items) => this.j(items),
        reject: (error) => this.l(error)
      };
      try {
        await Promise.resolve(executor(writer));
        this.k();
      } catch (err) {
        this.l(err);
      } finally {
        writer.emitOne = void 0;
        writer.emitMany = void 0;
        writer.reject = void 0;
      }
    });
  }
  [Symbol.asyncIterator]() {
    let i = 0;
    return {
      next: async () => {
        do {
          if (this.a === 2) {
            throw this.d;
          }
          if (i < this.b.length) {
            return { done: false, value: this.b[i++] };
          }
          if (this.a === 1) {
            return { done: true, value: void 0 };
          }
          await Event2.toPromise(this.g.event);
        } while (true);
      },
      return: async () => {
        this.f?.();
        return { done: true, value: void 0 };
      }
    };
  }
  static map(iterable, mapFn) {
    return new _$ni(async (emitter) => {
      for await (const item of iterable) {
        emitter.emitOne(mapFn(item));
      }
    });
  }
  map(mapFn) {
    return _$ni.map(this, mapFn);
  }
  static filter(iterable, filterFn) {
    return new _$ni(async (emitter) => {
      for await (const item of iterable) {
        if (filterFn(item)) {
          emitter.emitOne(item);
        }
      }
    });
  }
  filter(filterFn) {
    return _$ni.filter(this, filterFn);
  }
  static coalesce(iterable) {
    return _$ni.filter(iterable, (item) => !!item);
  }
  coalesce() {
    return _$ni.coalesce(this);
  }
  static async toPromise(iterable) {
    const result = [];
    for await (const item of iterable) {
      result.push(item);
    }
    return result;
  }
  toPromise() {
    return _$ni.toPromise(this);
  }
  /**
   * The value will be appended at the end.
   *
   * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
   */
  h(value) {
    if (this.a !== 0) {
      return;
    }
    this.b.push(value);
    this.g.fire();
  }
  /**
   * The values will be appended at the end.
   *
   * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
   */
  j(values) {
    if (this.a !== 0) {
      return;
    }
    this.b = this.b.concat(values);
    this.g.fire();
  }
  /**
   * Calling `resolve()` will mark the result array as complete.
   *
   * **NOTE** `resolve()` must be called, otherwise all consumers of this iterable will hang indefinitely, similar to a non-resolved promise.
   * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
   */
  k() {
    if (this.a !== 0) {
      return;
    }
    this.a = 1;
    this.g.fire();
  }
  /**
   * Writing an error will permanently invalidate this iterable.
   * The current users will receive an error thrown, as will all future users.
   *
   * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
   */
  l(error) {
    if (this.a !== 0) {
      return;
    }
    this.a = 2;
    this.d = error;
    this.g.fire();
  }
};
var $oi = class extends $ni {
  constructor(m, executor) {
    super(executor);
    this.m = m;
  }
  cancel() {
    this.m.cancel();
  }
};
function $pi(callback) {
  const source = new $Pe();
  const innerIterable = callback(source.token);
  return new $oi(source, async (emitter) => {
    const subscription = source.token.onCancellationRequested(() => {
      subscription.dispose();
      source.dispose();
      emitter.reject(new $fb());
    });
    try {
      for await (const item of innerIterable) {
        if (source.token.isCancellationRequested) {
          return;
        }
        emitter.emitOne(item);
      }
      subscription.dispose();
      source.dispose();
    } catch (err) {
      subscription.dispose();
      source.dispose();
      emitter.reject(err);
    }
  });
}
var $qi = class {
  /**
   *
   * @param onReturn A function that will be called when consuming the async iterable
   * has finished by the consumer, e.g the for-await-loop has be existed (break, return) early.
   * This is NOT called when resolving this source by its owner.
   */
  constructor(onReturn) {
    this.a = new $ki();
    this.b = new $ni((emitter) => {
      if (earlyError) {
        emitter.reject(earlyError);
        return;
      }
      if (earlyItems) {
        emitter.emitMany(earlyItems);
      }
      this.d = (error) => emitter.reject(error);
      this.f = (item) => emitter.emitOne(item);
      return this.a.p;
    }, onReturn);
    let earlyError;
    let earlyItems;
    this.f = (item) => {
      if (!earlyItems) {
        earlyItems = [];
      }
      earlyItems.push(item);
    };
    this.d = (error) => {
      if (!earlyError) {
        earlyError = error;
      }
    };
  }
  get asyncIterable() {
    return this.b;
  }
  resolve() {
    this.a.complete();
  }
  reject(error) {
    this.d(error);
    this.a.complete();
  }
  emitOne(item) {
    this.f(item);
  }
};

// out-build/vs/base/browser/dompurify/dompurify.js
var {
  entries,
  setPrototypeOf,
  isFrozen,
  getPrototypeOf,
  getOwnPropertyDescriptor
} = Object;
var {
  freeze,
  seal,
  create
} = Object;
var {
  apply,
  construct
} = typeof Reflect !== "undefined" && Reflect;
if (!apply) {
  apply = function apply2(fun, thisValue, args2) {
    return fun.apply(thisValue, args2);
  };
}
if (!freeze) {
  freeze = function freeze3(x) {
    return x;
  };
}
if (!seal) {
  seal = function seal2(x) {
    return x;
  };
}
if (!construct) {
  construct = function construct2(Func, args2) {
    return new Func(...args2);
  };
}
var arrayForEach = unapply(Array.prototype.forEach);
var arrayPop = unapply(Array.prototype.pop);
var arrayPush = unapply(Array.prototype.push);
var stringToLowerCase = unapply(String.prototype.toLowerCase);
var stringToString = unapply(String.prototype.toString);
var stringMatch = unapply(String.prototype.match);
var stringReplace = unapply(String.prototype.replace);
var stringIndexOf = unapply(String.prototype.indexOf);
var stringTrim = unapply(String.prototype.trim);
var regExpTest = unapply(RegExp.prototype.test);
var typeErrorCreate = unconstruct(TypeError);
function unapply(func) {
  return function(thisArg) {
    for (var _len = arguments.length, args2 = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args2[_key - 1] = arguments[_key];
    }
    return apply(func, thisArg, args2);
  };
}
function unconstruct(func) {
  return function() {
    for (var _len2 = arguments.length, args2 = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args2[_key2] = arguments[_key2];
    }
    return construct(func, args2);
  };
}
function addToSet(set, array2, transformCaseFunc) {
  var _transformCaseFunc;
  transformCaseFunc = (_transformCaseFunc = transformCaseFunc) !== null && _transformCaseFunc !== void 0 ? _transformCaseFunc : stringToLowerCase;
  if (setPrototypeOf) {
    setPrototypeOf(set, null);
  }
  let l = array2.length;
  while (l--) {
    let element = array2[l];
    if (typeof element === "string") {
      const lcElement = transformCaseFunc(element);
      if (lcElement !== element) {
        if (!isFrozen(array2)) {
          array2[l] = lcElement;
        }
        element = lcElement;
      }
    }
    set[element] = true;
  }
  return set;
}
function clone(object) {
  const newObject = create(null);
  for (const [property, value] of entries(object)) {
    newObject[property] = value;
  }
  return newObject;
}
function lookupGetter(object, prop) {
  while (object !== null) {
    const desc = getOwnPropertyDescriptor(object, prop);
    if (desc) {
      if (desc.get) {
        return unapply(desc.get);
      }
      if (typeof desc.value === "function") {
        return unapply(desc.value);
      }
    }
    object = getPrototypeOf(object);
  }
  function fallbackValue(element) {
    console.warn("fallback value for", element);
    return null;
  }
  return fallbackValue;
}
var html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
var svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
var svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
var svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
var mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "mprescripts"]);
var mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
var text = freeze(["#text"]);
var html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
var svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
var mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
var xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
var MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
var ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
var TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
var DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
var ARIA_ATTR = seal(/^aria-[\-\w]+$/);
var IS_ALLOWED_URI = seal(
  /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
  // eslint-disable-line no-useless-escape
);
var IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
var ATTR_WHITESPACE = seal(
  /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
  // eslint-disable-line no-control-regex
);
var DOCTYPE_NAME = seal(/^html$/i);
var EXPRESSIONS = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  MUSTACHE_EXPR,
  ERB_EXPR,
  TMPLIT_EXPR,
  DATA_ATTR,
  ARIA_ATTR,
  IS_ALLOWED_URI,
  IS_SCRIPT_OR_DATA,
  ATTR_WHITESPACE,
  DOCTYPE_NAME
});
var getGlobal = () => typeof window === "undefined" ? null : window;
var _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, purifyHostElement) {
  if (typeof trustedTypes !== "object" || typeof trustedTypes.createPolicy !== "function") {
    return null;
  }
  let suffix = null;
  const ATTR_NAME = "data-tt-policy-suffix";
  if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
    suffix = purifyHostElement.getAttribute(ATTR_NAME);
  }
  const policyName = "dompurify" + (suffix ? "#" + suffix : "");
  try {
    return trustedTypes.createPolicy(policyName, {
      createHTML(html5) {
        return html5;
      },
      createScriptURL(scriptUrl) {
        return scriptUrl;
      }
    });
  } catch (_) {
    console.warn("TrustedTypes policy " + policyName + " could not be created.");
    return null;
  }
};
function createDOMPurify() {
  let window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
  const DOMPurify = (root) => createDOMPurify(root);
  DOMPurify.version = "3.0.5";
  DOMPurify.removed = [];
  if (!window2 || !window2.document || window2.document.nodeType !== 9) {
    DOMPurify.isSupported = false;
    return DOMPurify;
  }
  const originalDocument = window2.document;
  const currentScript = originalDocument.currentScript;
  let {
    document: document2
  } = window2;
  const {
    DocumentFragment,
    HTMLTemplateElement,
    Node: Node6,
    Element: Element2,
    NodeFilter: NodeFilter2,
    NamedNodeMap = window2.NamedNodeMap || window2.MozNamedAttrMap,
    HTMLFormElement,
    DOMParser: DOMParser2,
    trustedTypes
  } = window2;
  const ElementPrototype = Element2.prototype;
  const cloneNode = lookupGetter(ElementPrototype, "cloneNode");
  const getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
  const getChildNodes = lookupGetter(ElementPrototype, "childNodes");
  const getParentNode = lookupGetter(ElementPrototype, "parentNode");
  if (typeof HTMLTemplateElement === "function") {
    const template = document2.createElement("template");
    if (template.content && template.content.ownerDocument) {
      document2 = template.content.ownerDocument;
    }
  }
  let trustedTypesPolicy;
  let emptyHTML = "";
  const {
    implementation,
    createNodeIterator,
    createDocumentFragment,
    getElementsByTagName
  } = document2;
  const {
    importNode
  } = originalDocument;
  let hooks = {};
  DOMPurify.isSupported = typeof entries === "function" && typeof getParentNode === "function" && implementation && implementation.createHTMLDocument !== void 0;
  const {
    MUSTACHE_EXPR: MUSTACHE_EXPR2,
    ERB_EXPR: ERB_EXPR2,
    TMPLIT_EXPR: TMPLIT_EXPR2,
    DATA_ATTR: DATA_ATTR2,
    ARIA_ATTR: ARIA_ATTR2,
    IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA2,
    ATTR_WHITESPACE: ATTR_WHITESPACE2
  } = EXPRESSIONS;
  let {
    IS_ALLOWED_URI: IS_ALLOWED_URI$1
  } = EXPRESSIONS;
  let ALLOWED_TAGS = null;
  const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text]);
  let ALLOWED_ATTR = null;
  const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html, ...svg, ...mathMl, ...xml]);
  let CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
    tagNameCheck: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: null
    },
    attributeNameCheck: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: null
    },
    allowCustomizedBuiltInElements: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: false
    }
  }));
  let FORBID_TAGS = null;
  let FORBID_ATTR = null;
  let ALLOW_ARIA_ATTR = true;
  let ALLOW_DATA_ATTR = true;
  let ALLOW_UNKNOWN_PROTOCOLS = false;
  let ALLOW_SELF_CLOSE_IN_ATTR = true;
  let SAFE_FOR_TEMPLATES = false;
  let WHOLE_DOCUMENT = false;
  let SET_CONFIG = false;
  let FORCE_BODY = false;
  let RETURN_DOM = false;
  let RETURN_DOM_FRAGMENT = false;
  let RETURN_TRUSTED_TYPE = false;
  let SANITIZE_DOM = true;
  let SANITIZE_NAMED_PROPS = false;
  const SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
  let KEEP_CONTENT = true;
  let IN_PLACE = false;
  let USE_PROFILES = {};
  let FORBID_CONTENTS = null;
  const DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
  let DATA_URI_TAGS = null;
  const DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
  let URI_SAFE_ATTRIBUTES = null;
  const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
  const MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
  const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
  const HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
  let NAMESPACE = HTML_NAMESPACE;
  let IS_EMPTY_INPUT = false;
  let ALLOWED_NAMESPACES = null;
  const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
  let PARSER_MEDIA_TYPE;
  const SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
  const DEFAULT_PARSER_MEDIA_TYPE = "text/html";
  let transformCaseFunc;
  let CONFIG = null;
  const formElement = document2.createElement("form");
  const isRegexOrFunction = function isRegexOrFunction2(testValue) {
    return testValue instanceof RegExp || testValue instanceof Function;
  };
  const _parseConfig = function _parseConfig2(cfg) {
    if (CONFIG && CONFIG === cfg) {
      return;
    }
    if (!cfg || typeof cfg !== "object") {
      cfg = {};
    }
    cfg = clone(cfg);
    PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
    SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
    transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
    ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
    ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
    ALLOWED_NAMESPACES = "ALLOWED_NAMESPACES" in cfg ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
    URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
      clone(DEFAULT_URI_SAFE_ATTRIBUTES),
      // eslint-disable-line indent
      cfg.ADD_URI_SAFE_ATTR,
      // eslint-disable-line indent
      transformCaseFunc
      // eslint-disable-line indent
    ) : DEFAULT_URI_SAFE_ATTRIBUTES;
    DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
      clone(DEFAULT_DATA_URI_TAGS),
      // eslint-disable-line indent
      cfg.ADD_DATA_URI_TAGS,
      // eslint-disable-line indent
      transformCaseFunc
      // eslint-disable-line indent
    ) : DEFAULT_DATA_URI_TAGS;
    FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
    FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
    FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
    USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
    ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
    ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
    ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
    ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
    SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
    WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
    RETURN_DOM = cfg.RETURN_DOM || false;
    RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
    RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
    FORCE_BODY = cfg.FORCE_BODY || false;
    SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
    SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
    KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
    IN_PLACE = cfg.IN_PLACE || false;
    IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
    NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
    CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
    if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
      CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
    }
    if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
      CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
    }
    if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
      CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
    }
    if (SAFE_FOR_TEMPLATES) {
      ALLOW_DATA_ATTR = false;
    }
    if (RETURN_DOM_FRAGMENT) {
      RETURN_DOM = true;
    }
    if (USE_PROFILES) {
      ALLOWED_TAGS = addToSet({}, [...text]);
      ALLOWED_ATTR = [];
      if (USE_PROFILES.html === true) {
        addToSet(ALLOWED_TAGS, html$1);
        addToSet(ALLOWED_ATTR, html);
      }
      if (USE_PROFILES.svg === true) {
        addToSet(ALLOWED_TAGS, svg$1);
        addToSet(ALLOWED_ATTR, svg);
        addToSet(ALLOWED_ATTR, xml);
      }
      if (USE_PROFILES.svgFilters === true) {
        addToSet(ALLOWED_TAGS, svgFilters);
        addToSet(ALLOWED_ATTR, svg);
        addToSet(ALLOWED_ATTR, xml);
      }
      if (USE_PROFILES.mathMl === true) {
        addToSet(ALLOWED_TAGS, mathMl$1);
        addToSet(ALLOWED_ATTR, mathMl);
        addToSet(ALLOWED_ATTR, xml);
      }
    }
    if (cfg.ADD_TAGS) {
      if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
        ALLOWED_TAGS = clone(ALLOWED_TAGS);
      }
      addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
    }
    if (cfg.ADD_ATTR) {
      if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
        ALLOWED_ATTR = clone(ALLOWED_ATTR);
      }
      addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
    }
    if (cfg.ADD_URI_SAFE_ATTR) {
      addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
    }
    if (cfg.FORBID_CONTENTS) {
      if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
        FORBID_CONTENTS = clone(FORBID_CONTENTS);
      }
      addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
    }
    if (KEEP_CONTENT) {
      ALLOWED_TAGS["#text"] = true;
    }
    if (WHOLE_DOCUMENT) {
      addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
    }
    if (ALLOWED_TAGS.table) {
      addToSet(ALLOWED_TAGS, ["tbody"]);
      delete FORBID_TAGS.tbody;
    }
    if (cfg.TRUSTED_TYPES_POLICY) {
      if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== "function") {
        throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
      }
      if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== "function") {
        throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
      }
      trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
      emptyHTML = trustedTypesPolicy.createHTML("");
    } else {
      if (trustedTypesPolicy === void 0) {
        trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
      }
      if (trustedTypesPolicy !== null && typeof emptyHTML === "string") {
        emptyHTML = trustedTypesPolicy.createHTML("");
      }
    }
    if (freeze) {
      freeze(cfg);
    }
    CONFIG = cfg;
  };
  const MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
  const HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
  const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
  const ALL_SVG_TAGS = addToSet({}, svg$1);
  addToSet(ALL_SVG_TAGS, svgFilters);
  addToSet(ALL_SVG_TAGS, svgDisallowed);
  const ALL_MATHML_TAGS = addToSet({}, mathMl$1);
  addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
  const _checkValidNamespace = function _checkValidNamespace2(element) {
    let parent = getParentNode(element);
    if (!parent || !parent.tagName) {
      parent = {
        namespaceURI: NAMESPACE,
        tagName: "template"
      };
    }
    const tagName = stringToLowerCase(element.tagName);
    const parentTagName = stringToLowerCase(parent.tagName);
    if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
      return false;
    }
    if (element.namespaceURI === SVG_NAMESPACE) {
      if (parent.namespaceURI === HTML_NAMESPACE) {
        return tagName === "svg";
      }
      if (parent.namespaceURI === MATHML_NAMESPACE) {
        return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
      }
      return Boolean(ALL_SVG_TAGS[tagName]);
    }
    if (element.namespaceURI === MATHML_NAMESPACE) {
      if (parent.namespaceURI === HTML_NAMESPACE) {
        return tagName === "math";
      }
      if (parent.namespaceURI === SVG_NAMESPACE) {
        return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
      }
      return Boolean(ALL_MATHML_TAGS[tagName]);
    }
    if (element.namespaceURI === HTML_NAMESPACE) {
      if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
        return false;
      }
      if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
        return false;
      }
      return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
    }
    if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element.namespaceURI]) {
      return true;
    }
    return false;
  };
  const _forceRemove = function _forceRemove2(node) {
    arrayPush(DOMPurify.removed, {
      element: node
    });
    try {
      node.parentNode.removeChild(node);
    } catch (_) {
      node.remove();
    }
  };
  const _removeAttribute = function _removeAttribute2(name, node) {
    try {
      arrayPush(DOMPurify.removed, {
        attribute: node.getAttributeNode(name),
        from: node
      });
    } catch (_) {
      arrayPush(DOMPurify.removed, {
        attribute: null,
        from: node
      });
    }
    node.removeAttribute(name);
    if (name === "is" && !ALLOWED_ATTR[name]) {
      if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
        try {
          _forceRemove(node);
        } catch (_) {
        }
      } else {
        try {
          node.setAttribute(name, "");
        } catch (_) {
        }
      }
    }
  };
  const _initDocument = function _initDocument2(dirty) {
    let doc;
    let leadingWhitespace;
    if (FORCE_BODY) {
      dirty = "<remove></remove>" + dirty;
    } else {
      const matches = stringMatch(dirty, /^[\r\n\t ]+/);
      leadingWhitespace = matches && matches[0];
    }
    if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
      dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
    }
    const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
    if (NAMESPACE === HTML_NAMESPACE) {
      try {
        doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
      } catch (_) {
      }
    }
    if (!doc || !doc.documentElement) {
      doc = implementation.createDocument(NAMESPACE, "template", null);
      try {
        doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
      } catch (_) {
      }
    }
    const body = doc.body || doc.documentElement;
    if (dirty && leadingWhitespace) {
      body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
    }
    if (NAMESPACE === HTML_NAMESPACE) {
      return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
    }
    return WHOLE_DOCUMENT ? doc.documentElement : body;
  };
  const _createIterator = function _createIterator2(root) {
    return createNodeIterator.call(
      root.ownerDocument || root,
      root,
      // eslint-disable-next-line no-bitwise
      NodeFilter2.SHOW_ELEMENT | NodeFilter2.SHOW_COMMENT | NodeFilter2.SHOW_TEXT,
      null,
      false
    );
  };
  const _isClobbered = function _isClobbered2(elm) {
    return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
  };
  const _isNode = function _isNode2(object) {
    return typeof Node6 === "object" ? object instanceof Node6 : object && typeof object === "object" && typeof object.nodeType === "number" && typeof object.nodeName === "string";
  };
  const _executeHook = function _executeHook2(entryPoint, currentNode, data) {
    if (!hooks[entryPoint]) {
      return;
    }
    arrayForEach(hooks[entryPoint], (hook) => {
      hook.call(DOMPurify, currentNode, data, CONFIG);
    });
  };
  const _sanitizeElements = function _sanitizeElements2(currentNode) {
    let content;
    _executeHook("beforeSanitizeElements", currentNode, null);
    if (_isClobbered(currentNode)) {
      _forceRemove(currentNode);
      return true;
    }
    const tagName = transformCaseFunc(currentNode.nodeName);
    _executeHook("uponSanitizeElement", currentNode, {
      tagName,
      allowedTags: ALLOWED_TAGS
    });
    if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
      _forceRemove(currentNode);
      return true;
    }
    if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
      if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
        if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) return false;
        if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) return false;
      }
      if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
        const parentNode = getParentNode(currentNode) || currentNode.parentNode;
        const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
        if (childNodes && parentNode) {
          const childCount = childNodes.length;
          for (let i = childCount - 1; i >= 0; --i) {
            parentNode.insertBefore(cloneNode(childNodes[i], true), getNextSibling(currentNode));
          }
        }
      }
      _forceRemove(currentNode);
      return true;
    }
    if (currentNode instanceof Element2 && !_checkValidNamespace(currentNode)) {
      _forceRemove(currentNode);
      return true;
    }
    if ((tagName === "noscript" || tagName === "noembed" || tagName === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
      _forceRemove(currentNode);
      return true;
    }
    if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
      content = currentNode.textContent;
      content = stringReplace(content, MUSTACHE_EXPR2, " ");
      content = stringReplace(content, ERB_EXPR2, " ");
      content = stringReplace(content, TMPLIT_EXPR2, " ");
      if (currentNode.textContent !== content) {
        arrayPush(DOMPurify.removed, {
          element: currentNode.cloneNode()
        });
        currentNode.textContent = content;
      }
    }
    _executeHook("afterSanitizeElements", currentNode, null);
    return false;
  };
  const _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value) {
    if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value in document2 || value in formElement)) {
      return false;
    }
    if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR2, lcName)) ;
    else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR2, lcName)) ;
    else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
      if (
        // First condition does a very basic check if a) it's basically a valid custom element tagname AND
        // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
        _basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
        // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value))
      ) ;
      else {
        return false;
      }
    } else if (URI_SAFE_ATTRIBUTES[lcName]) ;
    else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE2, ""))) ;
    else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value, "data:") === 0 && DATA_URI_TAGS[lcTag]) ;
    else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA2, stringReplace(value, ATTR_WHITESPACE2, ""))) ;
    else if (value) {
      return false;
    } else ;
    return true;
  };
  const _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
    return tagName.indexOf("-") > 0;
  };
  const _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
    let attr;
    let value;
    let lcName;
    let l;
    _executeHook("beforeSanitizeAttributes", currentNode, null);
    const {
      attributes
    } = currentNode;
    if (!attributes) {
      return;
    }
    const hookEvent = {
      attrName: "",
      attrValue: "",
      keepAttr: true,
      allowedAttributes: ALLOWED_ATTR
    };
    l = attributes.length;
    while (l--) {
      attr = attributes[l];
      const {
        name,
        namespaceURI
      } = attr;
      value = name === "value" ? attr.value : stringTrim(attr.value);
      lcName = transformCaseFunc(name);
      hookEvent.attrName = lcName;
      hookEvent.attrValue = value;
      hookEvent.keepAttr = true;
      hookEvent.forceKeepAttr = void 0;
      _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
      value = hookEvent.attrValue;
      if (hookEvent.forceKeepAttr) {
        continue;
      }
      _removeAttribute(name, currentNode);
      if (!hookEvent.keepAttr) {
        continue;
      }
      if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value)) {
        _removeAttribute(name, currentNode);
        continue;
      }
      if (SAFE_FOR_TEMPLATES) {
        value = stringReplace(value, MUSTACHE_EXPR2, " ");
        value = stringReplace(value, ERB_EXPR2, " ");
        value = stringReplace(value, TMPLIT_EXPR2, " ");
      }
      const lcTag = transformCaseFunc(currentNode.nodeName);
      if (!_isValidAttribute(lcTag, lcName, value)) {
        continue;
      }
      if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
        _removeAttribute(name, currentNode);
        value = SANITIZE_NAMED_PROPS_PREFIX + value;
      }
      if (trustedTypesPolicy && typeof trustedTypes === "object" && typeof trustedTypes.getAttributeType === "function") {
        if (namespaceURI) ;
        else {
          switch (trustedTypes.getAttributeType(lcTag, lcName)) {
            case "TrustedHTML": {
              value = trustedTypesPolicy.createHTML(value);
              break;
            }
            case "TrustedScriptURL": {
              value = trustedTypesPolicy.createScriptURL(value);
              break;
            }
          }
        }
      }
      try {
        if (namespaceURI) {
          currentNode.setAttributeNS(namespaceURI, name, value);
        } else {
          currentNode.setAttribute(name, value);
        }
        arrayPop(DOMPurify.removed);
      } catch (_) {
      }
    }
    _executeHook("afterSanitizeAttributes", currentNode, null);
  };
  const _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
    let shadowNode;
    const shadowIterator = _createIterator(fragment);
    _executeHook("beforeSanitizeShadowDOM", fragment, null);
    while (shadowNode = shadowIterator.nextNode()) {
      _executeHook("uponSanitizeShadowNode", shadowNode, null);
      if (_sanitizeElements(shadowNode)) {
        continue;
      }
      if (shadowNode.content instanceof DocumentFragment) {
        _sanitizeShadowDOM2(shadowNode.content);
      }
      _sanitizeAttributes(shadowNode);
    }
    _executeHook("afterSanitizeShadowDOM", fragment, null);
  };
  DOMPurify.sanitize = function(dirty) {
    let cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let body;
    let importedNode;
    let currentNode;
    let returnNode;
    IS_EMPTY_INPUT = !dirty;
    if (IS_EMPTY_INPUT) {
      dirty = "<!-->";
    }
    if (typeof dirty !== "string" && !_isNode(dirty)) {
      if (typeof dirty.toString === "function") {
        dirty = dirty.toString();
        if (typeof dirty !== "string") {
          throw typeErrorCreate("dirty is not a string, aborting");
        }
      } else {
        throw typeErrorCreate("toString is not a function");
      }
    }
    if (!DOMPurify.isSupported) {
      return dirty;
    }
    if (!SET_CONFIG) {
      _parseConfig(cfg);
    }
    DOMPurify.removed = [];
    if (typeof dirty === "string") {
      IN_PLACE = false;
    }
    if (IN_PLACE) {
      if (dirty.nodeName) {
        const tagName = transformCaseFunc(dirty.nodeName);
        if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
          throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
        }
      }
    } else if (dirty instanceof Node6) {
      body = _initDocument("<!---->");
      importedNode = body.ownerDocument.importNode(dirty, true);
      if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
        body = importedNode;
      } else if (importedNode.nodeName === "HTML") {
        body = importedNode;
      } else {
        body.appendChild(importedNode);
      }
    } else {
      if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
      dirty.indexOf("<") === -1) {
        return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
      }
      body = _initDocument(dirty);
      if (!body) {
        return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
      }
    }
    if (body && FORCE_BODY) {
      _forceRemove(body.firstChild);
    }
    const nodeIterator = _createIterator(IN_PLACE ? dirty : body);
    while (currentNode = nodeIterator.nextNode()) {
      if (_sanitizeElements(currentNode)) {
        continue;
      }
      if (currentNode.content instanceof DocumentFragment) {
        _sanitizeShadowDOM(currentNode.content);
      }
      _sanitizeAttributes(currentNode);
    }
    if (IN_PLACE) {
      return dirty;
    }
    if (RETURN_DOM) {
      if (RETURN_DOM_FRAGMENT) {
        returnNode = createDocumentFragment.call(body.ownerDocument);
        while (body.firstChild) {
          returnNode.appendChild(body.firstChild);
        }
      } else {
        returnNode = body;
      }
      if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
        returnNode = importNode.call(originalDocument, returnNode, true);
      }
      return returnNode;
    }
    let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
    if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
      serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
    }
    if (SAFE_FOR_TEMPLATES) {
      serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR2, " ");
      serializedHTML = stringReplace(serializedHTML, ERB_EXPR2, " ");
      serializedHTML = stringReplace(serializedHTML, TMPLIT_EXPR2, " ");
    }
    return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
  };
  DOMPurify.setConfig = function(cfg) {
    _parseConfig(cfg);
    SET_CONFIG = true;
  };
  DOMPurify.clearConfig = function() {
    CONFIG = null;
    SET_CONFIG = false;
  };
  DOMPurify.isValidAttribute = function(tag4, attr, value) {
    if (!CONFIG) {
      _parseConfig({});
    }
    const lcTag = transformCaseFunc(tag4);
    const lcName = transformCaseFunc(attr);
    return _isValidAttribute(lcTag, lcName, value);
  };
  DOMPurify.addHook = function(entryPoint, hookFunction) {
    if (typeof hookFunction !== "function") {
      return;
    }
    hooks[entryPoint] = hooks[entryPoint] || [];
    arrayPush(hooks[entryPoint], hookFunction);
  };
  DOMPurify.removeHook = function(entryPoint) {
    if (hooks[entryPoint]) {
      return arrayPop(hooks[entryPoint]);
    }
  };
  DOMPurify.removeHooks = function(entryPoint) {
    if (hooks[entryPoint]) {
      hooks[entryPoint] = [];
    }
  };
  DOMPurify.removeAllHooks = function() {
    hooks = {};
  };
  return DOMPurify;
}
var purify = createDOMPurify();
var version = purify.version;
var isSupported = purify.isSupported;
var sanitize = purify.sanitize;
var setConfig = purify.setConfig;
var clearConfig = purify.clearConfig;
var isValidAttribute = purify.isValidAttribute;
var addHook = purify.addHook;
var removeHook = purify.removeHook;
var removeHooks = purify.removeHooks;
var removeAllHooks = purify.removeAllHooks;

// out-build/vs/base/common/hash.js
function $Nj(obj) {
  return $Oj(obj, 0);
}
function $Oj(obj, hashVal) {
  switch (typeof obj) {
    case "object":
      if (obj === null) {
        return $Pj(349, hashVal);
      } else if (Array.isArray(obj)) {
        return arrayHash(obj, hashVal);
      }
      return objectHash(obj, hashVal);
    case "string":
      return $Qj(obj, hashVal);
    case "boolean":
      return booleanHash(obj, hashVal);
    case "number":
      return $Pj(obj, hashVal);
    case "undefined":
      return $Pj(937, hashVal);
    default:
      return $Pj(617, hashVal);
  }
}
function $Pj(val, initialHashVal) {
  return (initialHashVal << 5) - initialHashVal + val | 0;
}
function booleanHash(b, initialHashVal) {
  return $Pj(b ? 433 : 863, initialHashVal);
}
function $Qj(s, hashVal) {
  hashVal = $Pj(149417, hashVal);
  for (let i = 0, length = s.length; i < length; i++) {
    hashVal = $Pj(s.charCodeAt(i), hashVal);
  }
  return hashVal;
}
function arrayHash(arr, initialHashVal) {
  initialHashVal = $Pj(104579, initialHashVal);
  return arr.reduce((hashVal, item) => $Oj(item, hashVal), initialHashVal);
}
function objectHash(obj, initialHashVal) {
  initialHashVal = $Pj(181387, initialHashVal);
  return Object.keys(obj).sort().reduce((hashVal, key) => {
    hashVal = $Qj(key, hashVal);
    return $Oj(obj[key], hashVal);
  }, initialHashVal);
}
var $Rj = class {
  constructor() {
    this.g = 0;
  }
  get value() {
    return this.g;
  }
  hash(obj) {
    this.g = $Oj(obj, this.g);
    return this.g;
  }
};
var SHA1Constant;
(function(SHA1Constant2) {
  SHA1Constant2[SHA1Constant2["BLOCK_SIZE"] = 64] = "BLOCK_SIZE";
  SHA1Constant2[SHA1Constant2["UNICODE_REPLACEMENT"] = 65533] = "UNICODE_REPLACEMENT";
})(SHA1Constant || (SHA1Constant = {}));
function leftRotate(value, bits, totalBits = 32) {
  const delta = totalBits - bits;
  const mask = ~((1 << delta) - 1);
  return (value << bits | (mask & value) >>> delta) >>> 0;
}
function fill(dest, index = 0, count = dest.byteLength, value = 0) {
  for (let i = 0; i < count; i++) {
    dest[index + i] = value;
  }
}
function leftPad(value, length, char = "0") {
  while (value.length < length) {
    value = char + value;
  }
  return value;
}
function $Sj(bufferOrValue, bitsize = 32) {
  if (bufferOrValue instanceof ArrayBuffer) {
    return Array.from(new Uint8Array(bufferOrValue)).map((b) => b.toString(16).padStart(2, "0")).join("");
  }
  return leftPad((bufferOrValue >>> 0).toString(16), bitsize / 4);
}
var $Tj = class _$Tj {
  static {
    this.g = new DataView(new ArrayBuffer(320));
  }
  // 80 * 4 = 320
  constructor() {
    this.h = 1732584193;
    this.l = 4023233417;
    this.m = 2562383102;
    this.n = 271733878;
    this.o = 3285377520;
    this.p = new Uint8Array(
      64 + 3
      /* to fit any utf-8 */
    );
    this.q = new DataView(this.p.buffer);
    this.r = 0;
    this.t = 0;
    this.u = 0;
    this.v = false;
  }
  update(str) {
    const strLen = str.length;
    if (strLen === 0) {
      return;
    }
    const buff = this.p;
    let buffLen = this.r;
    let leftoverHighSurrogate = this.u;
    let charCode;
    let offset;
    if (leftoverHighSurrogate !== 0) {
      charCode = leftoverHighSurrogate;
      offset = -1;
      leftoverHighSurrogate = 0;
    } else {
      charCode = str.charCodeAt(0);
      offset = 0;
    }
    while (true) {
      let codePoint = charCode;
      if ($4f(charCode)) {
        if (offset + 1 < strLen) {
          const nextCharCode = str.charCodeAt(offset + 1);
          if ($5f(nextCharCode)) {
            offset++;
            codePoint = $6f(charCode, nextCharCode);
          } else {
            codePoint = 65533;
          }
        } else {
          leftoverHighSurrogate = charCode;
          break;
        }
      } else if ($5f(charCode)) {
        codePoint = 65533;
      }
      buffLen = this.w(buff, buffLen, codePoint);
      offset++;
      if (offset < strLen) {
        charCode = str.charCodeAt(offset);
      } else {
        break;
      }
    }
    this.r = buffLen;
    this.u = leftoverHighSurrogate;
  }
  w(buff, buffLen, codePoint) {
    if (codePoint < 128) {
      buff[buffLen++] = codePoint;
    } else if (codePoint < 2048) {
      buff[buffLen++] = 192 | (codePoint & 1984) >>> 6;
      buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
    } else if (codePoint < 65536) {
      buff[buffLen++] = 224 | (codePoint & 61440) >>> 12;
      buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
      buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
    } else {
      buff[buffLen++] = 240 | (codePoint & 1835008) >>> 18;
      buff[buffLen++] = 128 | (codePoint & 258048) >>> 12;
      buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
      buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
    }
    if (buffLen >= 64) {
      this.y();
      buffLen -= 64;
      this.t += 64;
      buff[0] = buff[64 + 0];
      buff[1] = buff[64 + 1];
      buff[2] = buff[64 + 2];
    }
    return buffLen;
  }
  digest() {
    if (!this.v) {
      this.v = true;
      if (this.u) {
        this.u = 0;
        this.r = this.w(
          this.p,
          this.r,
          65533
          /* SHA1Constant.UNICODE_REPLACEMENT */
        );
      }
      this.t += this.r;
      this.x();
    }
    return $Sj(this.h) + $Sj(this.l) + $Sj(this.m) + $Sj(this.n) + $Sj(this.o);
  }
  x() {
    this.p[this.r++] = 128;
    fill(this.p, this.r);
    if (this.r > 56) {
      this.y();
      fill(this.p);
    }
    const ml = 8 * this.t;
    this.q.setUint32(56, Math.floor(ml / 4294967296), false);
    this.q.setUint32(60, ml % 4294967296, false);
    this.y();
  }
  y() {
    const bigBlock32 = _$Tj.g;
    const data = this.q;
    for (let j = 0; j < 64; j += 4) {
      bigBlock32.setUint32(j, data.getUint32(j, false), false);
    }
    for (let j = 64; j < 320; j += 4) {
      bigBlock32.setUint32(j, leftRotate(bigBlock32.getUint32(j - 12, false) ^ bigBlock32.getUint32(j - 32, false) ^ bigBlock32.getUint32(j - 56, false) ^ bigBlock32.getUint32(j - 64, false), 1), false);
    }
    let a = this.h;
    let b = this.l;
    let c = this.m;
    let d = this.n;
    let e = this.o;
    let f, k;
    let temp;
    for (let j = 0; j < 80; j++) {
      if (j < 20) {
        f = b & c | ~b & d;
        k = 1518500249;
      } else if (j < 40) {
        f = b ^ c ^ d;
        k = 1859775393;
      } else if (j < 60) {
        f = b & c | b & d | c & d;
        k = 2400959708;
      } else {
        f = b ^ c ^ d;
        k = 3395469782;
      }
      temp = leftRotate(a, 5) + f + e + k + bigBlock32.getUint32(j * 4, false) & 4294967295;
      e = d;
      d = c;
      c = leftRotate(b, 30);
      b = a;
      a = temp;
    }
    this.h = this.h + a & 4294967295;
    this.l = this.l + b & 4294967295;
    this.m = this.m + c & 4294967295;
    this.n = this.n + d & 4294967295;
    this.o = this.o + e & 4294967295;
  }
};

// out-build/vs/base/common/numbers.js
function $6m(value, min, max) {
  return Math.min(Math.max(value, min), max);
}
function rot(index, modulo) {
  return (modulo + index % modulo) % modulo;
}
var $9m = class {
  constructor() {
    this.a = 1;
    this.b = 0;
  }
  update(value) {
    this.b = this.b + (value - this.b) / this.a;
    this.a += 1;
    return this.b;
  }
  get value() {
    return this.b;
  }
};
var $0m = class {
  constructor(size) {
    this.a = 0;
    this.b = 0;
    this.c = [];
    this.d = 0;
    this.e = 0;
    this.c = new Array(size);
    this.c.fill(0, 0, size);
  }
  update(value) {
    const oldValue = this.c[this.d];
    this.c[this.d] = value;
    this.d = (this.d + 1) % this.c.length;
    this.e -= oldValue;
    this.e += value;
    if (this.a < this.c.length) {
      this.a += 1;
    }
    this.b = this.e / this.a;
    return this.b;
  }
  get value() {
    return this.b;
  }
};
function $$m(x, y, ax, ay, bx, by, cx, cy) {
  const v0x = cx - ax;
  const v0y = cy - ay;
  const v1x = bx - ax;
  const v1y = by - ay;
  const v2x = x - ax;
  const v2y = y - ay;
  const dot00 = v0x * v0x + v0y * v0y;
  const dot01 = v0x * v1x + v0y * v1y;
  const dot02 = v0x * v2x + v0y * v2y;
  const dot11 = v1x * v1x + v1y * v1y;
  const dot12 = v1x * v2x + v1y * v2y;
  const invDenom = 1 / (dot00 * dot11 - dot01 * dot01);
  const u = (dot11 * dot02 - dot01 * dot12) * invDenom;
  const v = (dot00 * dot12 - dot01 * dot02) * invDenom;
  return u >= 0 && v >= 0 && u + v < 1;
}

// out-build/vs/base/browser/dom.js
var { registerWindow, getWindow, getDocument, getWindows, getWindowsCount, getWindowId, getWindowById, hasWindow, onDidRegisterWindow, onWillUnregisterWindow, onDidUnregisterWindow } = function() {
  const windows = /* @__PURE__ */ new Map();
  $_S($aT, 1);
  const mainWindowRegistration = { window: $aT, disposables: new $9c() };
  windows.set($aT.vscodeWindowId, mainWindowRegistration);
  const onDidRegisterWindow2 = new $De();
  const onDidUnregisterWindow2 = new $De();
  const onWillUnregisterWindow2 = new $De();
  function getWindowById2(windowId, fallbackToMain) {
    const window2 = typeof windowId === "number" ? windows.get(windowId) : void 0;
    return window2 ?? (fallbackToMain ? mainWindowRegistration : void 0);
  }
  return {
    onDidRegisterWindow: onDidRegisterWindow2.event,
    onWillUnregisterWindow: onWillUnregisterWindow2.event,
    onDidUnregisterWindow: onDidUnregisterWindow2.event,
    registerWindow(window2) {
      if (windows.has(window2.vscodeWindowId)) {
        return $0c.None;
      }
      const disposables = new $9c();
      const registeredWindow = {
        window: window2,
        disposables: disposables.add(new $9c())
      };
      windows.set(window2.vscodeWindowId, registeredWindow);
      disposables.add($8c(() => {
        windows.delete(window2.vscodeWindowId);
        onDidUnregisterWindow2.fire(window2);
      }));
      disposables.add($HT(window2, $IU.BEFORE_UNLOAD, () => {
        onWillUnregisterWindow2.fire(window2);
      }));
      onDidRegisterWindow2.fire(registeredWindow);
      return disposables;
    },
    getWindows() {
      return windows.values();
    },
    getWindowsCount() {
      return windows.size;
    },
    getWindowId(targetWindow) {
      return targetWindow.vscodeWindowId;
    },
    hasWindow(windowId) {
      return windows.has(windowId);
    },
    getWindowById: getWindowById2,
    getWindow(e) {
      const candidateNode = e;
      if (candidateNode?.ownerDocument?.defaultView) {
        return candidateNode.ownerDocument.defaultView.window;
      }
      const candidateEvent = e;
      if (candidateEvent?.view) {
        return candidateEvent.view.window;
      }
      return $aT;
    },
    getDocument(e) {
      const candidateNode = e;
      return getWindow(candidateNode).document;
    }
  };
}();
function $GT(node) {
  while (node.firstChild) {
    node.firstChild.remove();
  }
}
var DomListener = class {
  constructor(node, type, handler, options3) {
    this.f = node;
    this.g = type;
    this.d = handler;
    this.j = options3 || false;
    this.f.addEventListener(this.g, this.d, this.j);
  }
  dispose() {
    if (!this.d) {
      return;
    }
    this.f.removeEventListener(this.g, this.d, this.j);
    this.f = null;
    this.d = null;
  }
};
function $HT(node, type, handler, useCaptureOrOptions) {
  return new DomListener(node, type, handler, useCaptureOrOptions);
}
function _wrapAsStandardMouseEvent(targetWindow, handler) {
  return function(e) {
    return handler(new $zT(targetWindow, e));
  };
}
function _wrapAsStandardKeyboardEvent(handler) {
  return function(e) {
    return handler(new $ET(e));
  };
}
var $IT = function addStandardDisposableListener(node, type, handler, useCapture) {
  let wrapHandler = handler;
  if (type === "click" || type === "mousedown" || type === "contextmenu") {
    wrapHandler = _wrapAsStandardMouseEvent(getWindow(node), handler);
  } else if (type === "keydown" || type === "keypress" || type === "keyup") {
    wrapHandler = _wrapAsStandardKeyboardEvent(handler);
  }
  return $HT(node, type, wrapHandler, useCapture);
};
var $JT = function addStandardDisposableListener2(node, handler, useCapture) {
  const wrapHandler = _wrapAsStandardMouseEvent(getWindow(node), handler);
  return $LT(node, wrapHandler, useCapture);
};
var $KT = function addStandardDisposableListener3(node, handler, useCapture) {
  const wrapHandler = _wrapAsStandardMouseEvent(getWindow(node), handler);
  return $NT(node, wrapHandler, useCapture);
};
function $LT(node, handler, useCapture) {
  return $HT(node, $u && $wT.pointerEvents ? $IU.POINTER_DOWN : $IU.MOUSE_DOWN, handler, useCapture);
}
function $MT(node, handler, useCapture) {
  return $HT(node, $u && $wT.pointerEvents ? $IU.POINTER_MOVE : $IU.MOUSE_MOVE, handler, useCapture);
}
function $NT(node, handler, useCapture) {
  return $HT(node, $u && $wT.pointerEvents ? $IU.POINTER_UP : $IU.MOUSE_UP, handler, useCapture);
}
function $OT(targetWindow, callback, timeout) {
  return $ei(targetWindow, callback, timeout);
}
var $PT = class extends $fi {
  constructor(targetWindow, executor) {
    super(targetWindow, executor);
  }
};
var $QT;
var $RT;
function $ST(targetWindow, handler, interval, iterations) {
  let iteration = 0;
  const timer = targetWindow.setInterval(() => {
    iteration++;
    if (typeof iterations === "number" && iteration >= iterations || handler() === true) {
      disposable.dispose();
    }
  }, interval);
  const disposable = $8c(() => {
    targetWindow.clearInterval(timer);
  });
  return disposable;
}
var $TT = class extends $$h {
  /**
   *
   * @param node The optional node from which the target window is determined
   */
  constructor(node) {
    super();
    this.g = node && getWindow(node);
  }
  cancelAndSet(runner, interval, targetWindow) {
    return super.cancelAndSet(runner, interval, targetWindow ?? this.g);
  }
};
var AnimationFrameQueueItem = class {
  constructor(runner, priority = 0) {
    this.d = runner;
    this.priority = priority;
    this.f = false;
  }
  dispose() {
    this.f = true;
  }
  execute() {
    if (this.f) {
      return;
    }
    try {
      this.d();
    } catch (e) {
      $ab(e);
    }
  }
  // Sort by priority (largest to lowest)
  static sort(a, b) {
    return b.priority - a.priority;
  }
};
(function() {
  const NEXT_QUEUE = /* @__PURE__ */ new Map();
  const CURRENT_QUEUE = /* @__PURE__ */ new Map();
  const animFrameRequested = /* @__PURE__ */ new Map();
  const inAnimationFrameRunner = /* @__PURE__ */ new Map();
  const animationFrameRunner = (targetWindowId) => {
    animFrameRequested.set(targetWindowId, false);
    const currentQueue = NEXT_QUEUE.get(targetWindowId) ?? [];
    CURRENT_QUEUE.set(targetWindowId, currentQueue);
    NEXT_QUEUE.set(targetWindowId, []);
    inAnimationFrameRunner.set(targetWindowId, true);
    while (currentQueue.length > 0) {
      currentQueue.sort(AnimationFrameQueueItem.sort);
      const top2 = currentQueue.shift();
      top2.execute();
    }
    inAnimationFrameRunner.set(targetWindowId, false);
  };
  $RT = (targetWindow, runner, priority = 0) => {
    const targetWindowId = getWindowId(targetWindow);
    const item = new AnimationFrameQueueItem(runner, priority);
    let nextQueue = NEXT_QUEUE.get(targetWindowId);
    if (!nextQueue) {
      nextQueue = [];
      NEXT_QUEUE.set(targetWindowId, nextQueue);
    }
    nextQueue.push(item);
    if (!animFrameRequested.get(targetWindowId)) {
      animFrameRequested.set(targetWindowId, true);
      targetWindow.requestAnimationFrame(() => animationFrameRunner(targetWindowId));
    }
    return item;
  };
  $QT = (targetWindow, runner, priority) => {
    const targetWindowId = getWindowId(targetWindow);
    if (inAnimationFrameRunner.get(targetWindowId)) {
      const item = new AnimationFrameQueueItem(runner, priority);
      let currentQueue = CURRENT_QUEUE.get(targetWindowId);
      if (!currentQueue) {
        currentQueue = [];
        CURRENT_QUEUE.set(targetWindowId, currentQueue);
      }
      currentQueue.push(item);
      return item;
    } else {
      return $RT(targetWindow, runner, priority);
    }
  };
})();
function $UT(targetWindow, callback) {
  return $RT(
    targetWindow,
    callback,
    1e4
    /* must be early */
  );
}
function $VT(targetWindow, callback) {
  return $RT(
    targetWindow,
    callback,
    -1e4
    /* must be late */
  );
}
function $XT(el) {
  return getWindow(el).getComputedStyle(el, null);
}
function $YT(element, fallback2) {
  const elWindow = getWindow(element);
  const elDocument = elWindow.document;
  if (element !== elDocument.body) {
    return new $ZT(element.clientWidth, element.clientHeight);
  }
  if ($u && elWindow?.visualViewport) {
    return new $ZT(elWindow.visualViewport.width, elWindow.visualViewport.height);
  }
  if (elWindow?.innerWidth && elWindow.innerHeight) {
    return new $ZT(elWindow.innerWidth, elWindow.innerHeight);
  }
  if (elDocument.body && elDocument.body.clientWidth && elDocument.body.clientHeight) {
    return new $ZT(elDocument.body.clientWidth, elDocument.body.clientHeight);
  }
  if (elDocument.documentElement && elDocument.documentElement.clientWidth && elDocument.documentElement.clientHeight) {
    return new $ZT(elDocument.documentElement.clientWidth, elDocument.documentElement.clientHeight);
  }
  if (fallback2) {
    return $YT(fallback2);
  }
  throw new Error("Unable to figure out browser width and height");
}
var SizeUtils = class _SizeUtils {
  // Adapted from WinJS
  // Converts a CSS positioning string for the specified element to pixels.
  static d(element, value) {
    return parseFloat(value) || 0;
  }
  static f(element, cssPropertyName, jsPropertyName) {
    const computedStyle = $XT(element);
    const value = computedStyle ? computedStyle.getPropertyValue(cssPropertyName) : "0";
    return _SizeUtils.d(element, value);
  }
  static getBorderLeftWidth(element) {
    return _SizeUtils.f(element, "border-left-width", "borderLeftWidth");
  }
  static getBorderRightWidth(element) {
    return _SizeUtils.f(element, "border-right-width", "borderRightWidth");
  }
  static getBorderTopWidth(element) {
    return _SizeUtils.f(element, "border-top-width", "borderTopWidth");
  }
  static getBorderBottomWidth(element) {
    return _SizeUtils.f(element, "border-bottom-width", "borderBottomWidth");
  }
  static getPaddingLeft(element) {
    return _SizeUtils.f(element, "padding-left", "paddingLeft");
  }
  static getPaddingRight(element) {
    return _SizeUtils.f(element, "padding-right", "paddingRight");
  }
  static getPaddingTop(element) {
    return _SizeUtils.f(element, "padding-top", "paddingTop");
  }
  static getPaddingBottom(element) {
    return _SizeUtils.f(element, "padding-bottom", "paddingBottom");
  }
  static getMarginLeft(element) {
    return _SizeUtils.f(element, "margin-left", "marginLeft");
  }
  static getMarginTop(element) {
    return _SizeUtils.f(element, "margin-top", "marginTop");
  }
  static getMarginRight(element) {
    return _SizeUtils.f(element, "margin-right", "marginRight");
  }
  static getMarginBottom(element) {
    return _SizeUtils.f(element, "margin-bottom", "marginBottom");
  }
};
var $ZT = class _$ZT {
  static {
    this.None = new _$ZT(0, 0);
  }
  constructor(width2, height) {
    this.width = width2;
    this.height = height;
  }
  with(width2 = this.width, height = this.height) {
    if (width2 !== this.width || height !== this.height) {
      return new _$ZT(width2, height);
    } else {
      return this;
    }
  }
  static is(obj) {
    return typeof obj === "object" && typeof obj.height === "number" && typeof obj.width === "number";
  }
  static lift(obj) {
    if (obj instanceof _$ZT) {
      return obj;
    } else {
      return new _$ZT(obj.width, obj.height);
    }
  }
  static equals(a, b) {
    if (a === b) {
      return true;
    }
    if (!a || !b) {
      return false;
    }
    return a.width === b.width && a.height === b.height;
  }
};
function $1T(element) {
  let offsetParent = element.offsetParent;
  let top2 = element.offsetTop;
  let left = element.offsetLeft;
  while ((element = element.parentNode) !== null && element !== element.ownerDocument.body && element !== element.ownerDocument.documentElement) {
    top2 -= element.scrollTop;
    const c = $eU(element) ? null : $XT(element);
    if (c) {
      left -= c.direction !== "rtl" ? element.scrollLeft : -element.scrollLeft;
    }
    if (element === offsetParent) {
      left += SizeUtils.getBorderLeftWidth(element);
      top2 += SizeUtils.getBorderTopWidth(element);
      top2 += element.offsetTop;
      left += element.offsetLeft;
      offsetParent = element.offsetParent;
    }
  }
  return {
    left,
    top: top2
  };
}
function $2T(element, width2, height) {
  if (typeof width2 === "number") {
    element.style.width = `${width2}px`;
  }
  if (typeof height === "number") {
    element.style.height = `${height}px`;
  }
}
function $3T(element, top2, right, bottom, left, position = "absolute") {
  if (typeof top2 === "number") {
    element.style.top = `${top2}px`;
  }
  if (typeof right === "number") {
    element.style.right = `${right}px`;
  }
  if (typeof bottom === "number") {
    element.style.bottom = `${bottom}px`;
  }
  if (typeof left === "number") {
    element.style.left = `${left}px`;
  }
  element.style.position = position;
}
function $4T(domNode) {
  const bb = domNode.getBoundingClientRect();
  const window2 = getWindow(domNode);
  return {
    left: bb.left + window2.scrollX,
    top: bb.top + window2.scrollY,
    width: bb.width,
    height: bb.height
  };
}
function $5T(domNode) {
  let testElement = domNode;
  let zoom = 1;
  do {
    const elementZoomLevel = $XT(testElement).zoom;
    if (elementZoomLevel !== null && elementZoomLevel !== void 0 && elementZoomLevel !== "1") {
      zoom *= elementZoomLevel;
    }
    testElement = testElement.parentElement;
  } while (testElement !== null && testElement !== testElement.ownerDocument.documentElement);
  return zoom;
}
function $6T(element) {
  const margin = SizeUtils.getMarginLeft(element) + SizeUtils.getMarginRight(element);
  return element.offsetWidth + margin;
}
function $7T(element) {
  const border = SizeUtils.getBorderLeftWidth(element) + SizeUtils.getBorderRightWidth(element);
  const padding = SizeUtils.getPaddingLeft(element) + SizeUtils.getPaddingRight(element);
  return element.offsetWidth - border - padding;
}
function $8T(element) {
  const margin = SizeUtils.getMarginLeft(element) + SizeUtils.getMarginRight(element);
  return element.scrollWidth + margin;
}
function $9T(element) {
  const border = SizeUtils.getBorderTopWidth(element) + SizeUtils.getBorderBottomWidth(element);
  const padding = SizeUtils.getPaddingTop(element) + SizeUtils.getPaddingBottom(element);
  return element.offsetHeight - border - padding;
}
function $0T(element) {
  const margin = SizeUtils.getMarginTop(element) + SizeUtils.getMarginBottom(element);
  return element.offsetHeight + margin;
}
function getRelativeLeft(element, parent) {
  if (element === null) {
    return 0;
  }
  const elementPosition = $1T(element);
  const parentPosition = $1T(parent);
  return elementPosition.left - parentPosition.left;
}
function $$T(parent, children) {
  const childWidths = children.map((child) => {
    return Math.max($8T(child), $6T(child)) + getRelativeLeft(child, parent) || 0;
  });
  const maxWidth = Math.max(...childWidths);
  return maxWidth;
}
function $_T(testChild, testAncestor) {
  return Boolean(testAncestor?.contains(testChild));
}
var parentFlowToDataKey = "parentFlowToElementId";
function $aU(fromChildElement, toParentElement) {
  fromChildElement.dataset[parentFlowToDataKey] = toParentElement.id;
}
function getParentFlowToElement(node) {
  const flowToParentId = node.dataset[parentFlowToDataKey];
  if (typeof flowToParentId === "string") {
    return node.ownerDocument.getElementById(flowToParentId);
  }
  return null;
}
function $bU(testChild, testAncestor) {
  let node = testChild;
  while (node) {
    if (node === testAncestor) {
      return true;
    }
    if ($wU(node)) {
      const flowToParentElement = getParentFlowToElement(node);
      if (flowToParentElement) {
        node = flowToParentElement;
        continue;
      }
    }
    node = node.parentNode;
  }
  return false;
}
function $cU(node, clazz, stopAtClazzOrNode) {
  while (node && node.nodeType === node.ELEMENT_NODE) {
    if (node.classList.contains(clazz)) {
      return node;
    }
    if (stopAtClazzOrNode) {
      if (typeof stopAtClazzOrNode === "string") {
        if (node.classList.contains(stopAtClazzOrNode)) {
          return null;
        }
      } else {
        if (node === stopAtClazzOrNode) {
          return null;
        }
      }
    }
    node = node.parentNode;
  }
  return null;
}
function $dU(node, clazz, stopAtClazzOrNode) {
  return !!$cU(node, clazz, stopAtClazzOrNode);
}
function $eU(node) {
  return node && !!node.host && !!node.mode;
}
function $fU(domNode) {
  return !!$gU(domNode);
}
function $gU(domNode) {
  while (domNode.parentNode) {
    if (domNode === domNode.ownerDocument?.body) {
      return null;
    }
    domNode = domNode.parentNode;
  }
  return $eU(domNode) ? domNode : null;
}
function $hU() {
  let result = $lU().activeElement;
  while (result?.shadowRoot) {
    result = result.shadowRoot.activeElement;
  }
  return result;
}
function $iU(element) {
  return $hU() === element;
}
function $jU(ancestor) {
  return $_T($hU(), ancestor);
}
function $kU(element) {
  return element.ownerDocument === $lU();
}
function $lU() {
  if (getWindowsCount() <= 1) {
    return $aT.document;
  }
  const documents = Array.from(getWindows()).map(({ window: window2 }) => window2.document);
  return documents.find((doc) => doc.hasFocus()) ?? $aT.document;
}
function $mU() {
  const document2 = $lU();
  return document2.defaultView?.window ?? $aT;
}
var globalStylesheets = /* @__PURE__ */ new Map();
function $nU(node) {
  return globalStylesheets.has(node);
}
function $oU() {
  return new WrappedStyleElement();
}
var WrappedStyleElement = class {
  constructor() {
    this.d = "";
    this.f = void 0;
  }
  setStyle(cssStyle) {
    if (cssStyle === this.d) {
      return;
    }
    this.d = cssStyle;
    if (!this.f) {
      this.f = $pU($aT.document.head, (s) => s.innerText = cssStyle);
    } else {
      this.f.innerText = cssStyle;
    }
  }
  dispose() {
    if (this.f) {
      this.f.remove();
      this.f = void 0;
    }
  }
};
function $pU(container3 = $aT.document.head, beforeAppend, disposableStore) {
  const style = document.createElement("style");
  style.type = "text/css";
  style.media = "screen";
  beforeAppend?.(style);
  container3.appendChild(style);
  if (disposableStore) {
    disposableStore.add($8c(() => style.remove()));
  }
  if (container3 === $aT.document.head) {
    const globalStylesheetClones = /* @__PURE__ */ new Set();
    globalStylesheets.set(style, globalStylesheetClones);
    for (const { window: targetWindow, disposables } of getWindows()) {
      if (targetWindow === $aT) {
        continue;
      }
      const cloneDisposable = disposables.add(cloneGlobalStyleSheet(style, globalStylesheetClones, targetWindow));
      disposableStore?.add(cloneDisposable);
    }
  }
  return style;
}
function $qU(targetWindow) {
  const disposables = new $9c();
  for (const [globalStylesheet, clonedGlobalStylesheets] of globalStylesheets) {
    disposables.add(cloneGlobalStyleSheet(globalStylesheet, clonedGlobalStylesheets, targetWindow));
  }
  return disposables;
}
function cloneGlobalStyleSheet(globalStylesheet, globalStylesheetClones, targetWindow) {
  const disposables = new $9c();
  const clone2 = globalStylesheet.cloneNode(true);
  targetWindow.document.head.appendChild(clone2);
  disposables.add($8c(() => clone2.remove()));
  for (const rule of getDynamicStyleSheetRules(globalStylesheet)) {
    clone2.sheet?.insertRule(rule.cssText, clone2.sheet?.cssRules.length);
  }
  disposables.add($rU.observe(globalStylesheet, disposables, { childList: true })(() => {
    clone2.textContent = globalStylesheet.textContent;
  }));
  globalStylesheetClones.add(clone2);
  disposables.add($8c(() => globalStylesheetClones.delete(clone2)));
  return disposables;
}
var $rU = new class {
  constructor() {
    this.mutationObservers = /* @__PURE__ */ new Map();
  }
  observe(target, disposables, options3) {
    let mutationObserversPerTarget = this.mutationObservers.get(target);
    if (!mutationObserversPerTarget) {
      mutationObserversPerTarget = /* @__PURE__ */ new Map();
      this.mutationObservers.set(target, mutationObserversPerTarget);
    }
    const optionsHash = $Nj(options3);
    let mutationObserverPerOptions = mutationObserversPerTarget.get(optionsHash);
    if (!mutationObserverPerOptions) {
      const onDidMutate = new $De();
      const observer = new MutationObserver((mutations) => onDidMutate.fire(mutations));
      observer.observe(target, options3);
      const resolvedMutationObserverPerOptions = mutationObserverPerOptions = {
        users: 1,
        observer,
        onDidMutate: onDidMutate.event
      };
      disposables.add($8c(() => {
        resolvedMutationObserverPerOptions.users -= 1;
        if (resolvedMutationObserverPerOptions.users === 0) {
          onDidMutate.dispose();
          observer.disconnect();
          mutationObserversPerTarget?.delete(optionsHash);
          if (mutationObserversPerTarget?.size === 0) {
            this.mutationObservers.delete(target);
          }
        }
      }));
      mutationObserversPerTarget.set(optionsHash, mutationObserverPerOptions);
    } else {
      mutationObserverPerOptions.users += 1;
    }
    return mutationObserverPerOptions.onDidMutate;
  }
}();
function $sU(container3 = $aT.document.head) {
  return createHeadElement("meta", container3);
}
function $tU(container3 = $aT.document.head) {
  return createHeadElement("link", container3);
}
function createHeadElement(tagName, container3 = $aT.document.head) {
  const element = document.createElement(tagName);
  container3.appendChild(element);
  return element;
}
var _sharedStyleSheet = null;
function getSharedStyleSheet() {
  if (!_sharedStyleSheet) {
    _sharedStyleSheet = $pU();
  }
  return _sharedStyleSheet;
}
function getDynamicStyleSheetRules(style) {
  if (style?.sheet?.rules) {
    return style.sheet.rules;
  }
  if (style?.sheet?.cssRules) {
    return style.sheet.cssRules;
  }
  return [];
}
function $uU(selector, cssText, style = getSharedStyleSheet()) {
  if (!style || !cssText) {
    return;
  }
  style.sheet?.insertRule(`${selector} {${cssText}}`, 0);
  for (const clonedGlobalStylesheet of globalStylesheets.get(style) ?? []) {
    $uU(selector, cssText, clonedGlobalStylesheet);
  }
}
function $vU(ruleName, style = getSharedStyleSheet()) {
  if (!style) {
    return;
  }
  const rules = getDynamicStyleSheetRules(style);
  const toDelete = [];
  for (let i = 0; i < rules.length; i++) {
    const rule = rules[i];
    if (isCSSStyleRule(rule) && rule.selectorText.indexOf(ruleName) !== -1) {
      toDelete.push(i);
    }
  }
  for (let i = toDelete.length - 1; i >= 0; i--) {
    style.sheet?.deleteRule(toDelete[i]);
  }
  for (const clonedGlobalStylesheet of globalStylesheets.get(style) ?? []) {
    $vU(ruleName, clonedGlobalStylesheet);
  }
}
function isCSSStyleRule(rule) {
  return typeof rule.selectorText === "string";
}
function $wU(e) {
  return e instanceof HTMLElement || e instanceof getWindow(e).HTMLElement;
}
function $xU(e) {
  return e instanceof HTMLAnchorElement || e instanceof getWindow(e).HTMLAnchorElement;
}
function $zU(e) {
  return e instanceof HTMLTextAreaElement || e instanceof getWindow(e).HTMLTextAreaElement;
}
function $AU(e) {
  return e instanceof HTMLInputElement || e instanceof getWindow(e).HTMLInputElement;
}
function $BU(e) {
  return e instanceof HTMLButtonElement || e instanceof getWindow(e).HTMLButtonElement;
}
function $DU(e) {
  return e instanceof SVGElement || e instanceof getWindow(e).SVGElement;
}
function $EU(e) {
  return e instanceof MouseEvent || e instanceof getWindow(e).MouseEvent;
}
function $FU(e) {
  return e instanceof KeyboardEvent || e instanceof getWindow(e).KeyboardEvent;
}
function $GU(e) {
  return e instanceof PointerEvent || e instanceof getWindow(e).PointerEvent;
}
function $HU(e) {
  return e instanceof DragEvent || e instanceof getWindow(e).DragEvent;
}
var $IU = {
  // Mouse
  CLICK: "click",
  AUXCLICK: "auxclick",
  DBLCLICK: "dblclick",
  MOUSE_UP: "mouseup",
  MOUSE_DOWN: "mousedown",
  MOUSE_OVER: "mouseover",
  MOUSE_MOVE: "mousemove",
  MOUSE_OUT: "mouseout",
  MOUSE_ENTER: "mouseenter",
  MOUSE_LEAVE: "mouseleave",
  MOUSE_WHEEL: "wheel",
  POINTER_UP: "pointerup",
  POINTER_DOWN: "pointerdown",
  POINTER_MOVE: "pointermove",
  POINTER_LEAVE: "pointerleave",
  CONTEXT_MENU: "contextmenu",
  WHEEL: "wheel",
  // Keyboard
  KEY_DOWN: "keydown",
  KEY_PRESS: "keypress",
  KEY_UP: "keyup",
  // HTML Document
  LOAD: "load",
  BEFORE_UNLOAD: "beforeunload",
  UNLOAD: "unload",
  PAGE_SHOW: "pageshow",
  PAGE_HIDE: "pagehide",
  PASTE: "paste",
  ABORT: "abort",
  ERROR: "error",
  RESIZE: "resize",
  SCROLL: "scroll",
  FULLSCREEN_CHANGE: "fullscreenchange",
  WK_FULLSCREEN_CHANGE: "webkitfullscreenchange",
  // Form
  SELECT: "select",
  CHANGE: "change",
  SUBMIT: "submit",
  RESET: "reset",
  FOCUS: "focus",
  FOCUS_IN: "focusin",
  FOCUS_OUT: "focusout",
  BLUR: "blur",
  INPUT: "input",
  // Local Storage
  STORAGE: "storage",
  // Drag
  DRAG_START: "dragstart",
  DRAG: "drag",
  DRAG_ENTER: "dragenter",
  DRAG_LEAVE: "dragleave",
  DRAG_OVER: "dragover",
  DROP: "drop",
  DRAG_END: "dragend",
  // Animation
  ANIMATION_START: $nT ? "webkitAnimationStart" : "animationstart",
  ANIMATION_END: $nT ? "webkitAnimationEnd" : "animationend",
  ANIMATION_ITERATION: $nT ? "webkitAnimationIteration" : "animationiteration"
};
function $JU(obj) {
  const candidate = obj;
  return !!(candidate && typeof candidate.preventDefault === "function" && typeof candidate.stopPropagation === "function");
}
var $KU = {
  stop: (e, cancelBubble) => {
    e.preventDefault();
    if (cancelBubble) {
      e.stopPropagation();
    }
    return e;
  }
};
function $LU(node) {
  const r2 = [];
  for (let i = 0; node && node.nodeType === node.ELEMENT_NODE; i++) {
    r2[i] = node.scrollTop;
    node = node.parentNode;
  }
  return r2;
}
function $MU(node, state) {
  for (let i = 0; node && node.nodeType === node.ELEMENT_NODE; i++) {
    if (node.scrollTop !== state[i]) {
      node.scrollTop = state[i];
    }
    node = node.parentNode;
  }
}
var FocusTracker = class _FocusTracker extends $0c {
  static m(element) {
    if ($wU(element)) {
      const shadowRoot = $gU(element);
      const activeElement = shadowRoot ? shadowRoot.activeElement : element.ownerDocument.activeElement;
      return $_T(activeElement, element);
    } else {
      const window2 = element;
      return $_T(window2.document.activeElement, window2.document);
    }
  }
  constructor(element) {
    super();
    this.f = this.B(new $De());
    this.onDidFocus = this.f.event;
    this.g = this.B(new $De());
    this.onDidBlur = this.g.event;
    let hasFocus = _FocusTracker.m(element);
    let loosingFocus = false;
    const onFocus = () => {
      loosingFocus = false;
      if (!hasFocus) {
        hasFocus = true;
        this.f.fire();
      }
    };
    const onBlur = () => {
      if (hasFocus) {
        loosingFocus = true;
        ($wU(element) ? getWindow(element) : element).setTimeout(() => {
          if (loosingFocus) {
            loosingFocus = false;
            hasFocus = false;
            this.g.fire();
          }
        }, 0);
      }
    };
    this.j = () => {
      const currentNodeHasFocus = _FocusTracker.m(element);
      if (currentNodeHasFocus !== hasFocus) {
        if (hasFocus) {
          onBlur();
        } else {
          onFocus();
        }
      }
    };
    this.B($HT(element, $IU.FOCUS, onFocus, true));
    this.B($HT(element, $IU.BLUR, onBlur, true));
    if ($wU(element)) {
      this.B($HT(element, $IU.FOCUS_IN, () => this.j()));
      this.B($HT(element, $IU.FOCUS_OUT, () => this.j()));
    }
  }
  refreshState() {
    this.j();
  }
};
function $NU(element) {
  return new FocusTracker(element);
}
function $OU(sibling, child) {
  sibling.after(child);
  return child;
}
function $PU(parent, ...children) {
  parent.append(...children);
  if (children.length === 1 && typeof children[0] !== "string") {
    return children[0];
  }
}
function $QU(parent, child) {
  parent.insertBefore(child, parent.firstChild);
  return child;
}
function $RU(parent, ...children) {
  parent.innerText = "";
  $PU(parent, ...children);
}
var SELECTOR_REGEX = /([\w\-]+)?(#([\w\-]+))?((\.([\w\-]+))*)/;
var Namespace;
(function(Namespace2) {
  Namespace2["HTML"] = "http://www.w3.org/1999/xhtml";
  Namespace2["SVG"] = "http://www.w3.org/2000/svg";
})(Namespace || (Namespace = {}));
function _$(namespace, description, attrs, ...children) {
  const match = SELECTOR_REGEX.exec(description);
  if (!match) {
    throw new Error("Bad use of emmet");
  }
  const tagName = match[1] || "div";
  let result;
  if (namespace !== Namespace.HTML) {
    result = document.createElementNS(namespace, tagName);
  } else {
    result = document.createElement(tagName);
  }
  if (match[3]) {
    result.id = match[3];
  }
  if (match[4]) {
    result.className = match[4].replace(/\./g, " ").trim();
  }
  if (attrs) {
    Object.entries(attrs).forEach(([name, value]) => {
      if (typeof value === "undefined") {
        return;
      }
      if (/^on\w+$/.test(name)) {
        result[name] = value;
      } else if (name === "selected") {
        if (value) {
          result.setAttribute(name, "true");
        }
      } else {
        result.setAttribute(name, value);
      }
    });
  }
  result.append(...children);
  return result;
}
function $(description, attrs, ...children) {
  return _$(Namespace.HTML, description, attrs, ...children);
}
$.SVG = function(description, attrs, ...children) {
  return _$(Namespace.SVG, description, attrs, ...children);
};
function $UU(visible, ...elements) {
  if (visible) {
    $VU(...elements);
  } else {
    $WU(...elements);
  }
}
function $VU(...elements) {
  for (const element of elements) {
    element.style.display = "";
    element.removeAttribute("aria-hidden");
  }
}
function $WU(...elements) {
  for (const element of elements) {
    element.style.display = "none";
    element.setAttribute("aria-hidden", "true");
  }
}
function $YU(fn) {
  return (e) => {
    e.preventDefault();
    e.stopPropagation();
    fn(e);
  };
}
function $ZU(targetWindow) {
  return new Promise((resolve) => {
    const readyState = targetWindow.document.readyState;
    if (readyState === "complete" || targetWindow.document && targetWindow.document.body !== null) {
      resolve(void 0);
    } else {
      const listener = () => {
        targetWindow.window.removeEventListener("DOMContentLoaded", listener, false);
        resolve();
      };
      targetWindow.window.addEventListener("DOMContentLoaded", listener, false);
    }
  });
}
function $1U(window2, cssPx) {
  const screenPx = window2.devicePixelRatio * cssPx;
  return Math.max(1, Math.floor(screenPx)) / window2.devicePixelRatio;
}
function $2U(url) {
  $aT.open(url, "_blank", "noopener");
}
var popupWidth = 780;
var popupHeight = 640;
function $3U(url) {
  const left = Math.floor($aT.screenLeft + $aT.innerWidth / 2 - popupWidth / 2);
  const top2 = Math.floor($aT.screenTop + $aT.innerHeight / 2 - popupHeight / 2);
  $aT.open(url, "_blank", `width=${popupWidth},height=${popupHeight},top=${top2},left=${left}`);
}
function $4U(url, noOpener = true) {
  const newTab = $aT.open();
  if (newTab) {
    if (noOpener) {
      newTab.opener = null;
    }
    newTab.location.href = url;
    return true;
  }
  return false;
}
function $5U(targetWindow, fn) {
  const step = () => {
    fn();
    stepDisposable = $RT(targetWindow, step);
  };
  let stepDisposable = $RT(targetWindow, step);
  return $8c(() => stepDisposable.dispose());
}
$ah.setPreferredWebSchema(/^https:/.test($aT.location.href) ? "https" : "http");
function $6U(uri) {
  if (!uri) {
    return `url('')`;
  }
  return `url('${$hh.uriToBrowserUri(uri).toString(true).replace(/'/g, "%27")}')`;
}
function $7U(value) {
  return `'${value.replace(/'/g, "%27")}'`;
}
function $8U(cssPropertyValue, dflt) {
  if (cssPropertyValue !== void 0) {
    const variableMatch = cssPropertyValue.match(/^\s*var\((.+)\)$/);
    if (variableMatch) {
      const varArguments = variableMatch[1].split(",", 2);
      if (varArguments.length === 2) {
        dflt = $8U(varArguments[1].trim(), dflt);
      }
      return `var(${varArguments[0]}, ${dflt})`;
    }
    return cssPropertyValue;
  }
  return dflt;
}
function $9U(dataOrUri, name) {
  let url;
  if (URI.isUri(dataOrUri)) {
    url = dataOrUri.toString(true);
  } else {
    const blob = new Blob([dataOrUri]);
    url = URL.createObjectURL(blob);
    setTimeout(() => URL.revokeObjectURL(url));
  }
  const activeWindow = $mU();
  const anchor = document.createElement("a");
  activeWindow.document.body.appendChild(anchor);
  anchor.download = name;
  anchor.href = url;
  anchor.click();
  setTimeout(() => anchor.remove());
}
function $0U() {
  return new Promise((resolve) => {
    const activeWindow = $mU();
    const input = document.createElement("input");
    activeWindow.document.body.appendChild(input);
    input.type = "file";
    input.multiple = true;
    Event2.once(Event2.fromDOMEventEmitter(input, "input"))(() => {
      resolve(input.files ?? void 0);
    });
    input.click();
    setTimeout(() => input.remove());
  });
}
var DetectedFullscreenMode;
(function(DetectedFullscreenMode2) {
  DetectedFullscreenMode2[DetectedFullscreenMode2["DOCUMENT"] = 1] = "DOCUMENT";
  DetectedFullscreenMode2[DetectedFullscreenMode2["BROWSER"] = 2] = "BROWSER";
})(DetectedFullscreenMode || (DetectedFullscreenMode = {}));
function $_U(allowedProtocols2, allowDataImages = false) {
  const anchor = document.createElement("a");
  addHook("afterSanitizeAttributes", (node) => {
    for (const attr of ["href", "src"]) {
      if (node.hasAttribute(attr)) {
        const attrValue = node.getAttribute(attr);
        if (attr === "href" && attrValue.startsWith("#")) {
          continue;
        }
        anchor.href = attrValue;
        if (!allowedProtocols2.includes(anchor.protocol.replace(/:$/, ""))) {
          if (allowDataImages && attr === "src" && anchor.href.startsWith("data:")) {
            continue;
          }
          node.removeAttribute(attr);
        }
      }
    }
  });
  return $8c(() => {
    removeHook("afterSanitizeAttributes");
  });
}
var defaultSafeProtocols = [
  Schemas.http,
  Schemas.https,
  Schemas.command
];
var $aV = Object.freeze([
  "a",
  "abbr",
  "b",
  "bdo",
  "blockquote",
  "br",
  "caption",
  "cite",
  "code",
  "col",
  "colgroup",
  "dd",
  "del",
  "details",
  "dfn",
  "div",
  "dl",
  "dt",
  "em",
  "figcaption",
  "figure",
  "h1",
  "h2",
  "h3",
  "h4",
  "h5",
  "h6",
  "hr",
  "i",
  "img",
  "input",
  "ins",
  "kbd",
  "label",
  "li",
  "mark",
  "ol",
  "p",
  "pre",
  "q",
  "rp",
  "rt",
  "ruby",
  "samp",
  "small",
  "small",
  "source",
  "span",
  "strike",
  "strong",
  "sub",
  "summary",
  "sup",
  "table",
  "tbody",
  "td",
  "tfoot",
  "th",
  "thead",
  "time",
  "tr",
  "tt",
  "u",
  "ul",
  "var",
  "video",
  "wbr"
]);
var defaultDomPurifyConfig = Object.freeze({
  ALLOWED_TAGS: ["a", "button", "blockquote", "code", "div", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "input", "label", "li", "p", "pre", "select", "small", "span", "strong", "textarea", "ul", "ol"],
  ALLOWED_ATTR: ["href", "data-href", "data-command", "target", "title", "name", "src", "alt", "class", "id", "role", "tabindex", "style", "data-code", "width", "height", "align", "x-dispatch", "required", "checked", "placeholder", "type", "start"],
  RETURN_DOM: false,
  RETURN_DOM_FRAGMENT: false,
  RETURN_TRUSTED_TYPE: true
});
function $bV(node, value, extraDomPurifyConfig) {
  const hook = $_U(defaultSafeProtocols);
  try {
    const html5 = sanitize(value, { ...defaultDomPurifyConfig, ...extraDomPurifyConfig });
    node.innerHTML = html5;
  } finally {
    hook.dispose();
  }
}
function toBinary(str) {
  const codeUnits = new Uint16Array(str.length);
  for (let i = 0; i < codeUnits.length; i++) {
    codeUnits[i] = str.charCodeAt(i);
  }
  let binary = "";
  const uint8array = new Uint8Array(codeUnits.buffer);
  for (let i = 0; i < uint8array.length; i++) {
    binary += String.fromCharCode(uint8array[i]);
  }
  return binary;
}
function $cV(str) {
  return btoa(toBinary(str));
}
var $dV = class _$dV extends $De {
  constructor() {
    super();
    this.o = new $9c();
    this.D = {
      altKey: false,
      shiftKey: false,
      ctrlKey: false,
      metaKey: false
    };
    this.o.add(Event2.runAndSubscribe(onDidRegisterWindow, ({ window: window2, disposables }) => this.G(window2, disposables), { window: $aT, disposables: this.o }));
  }
  G(window2, disposables) {
    disposables.add($HT(window2, "keydown", (e) => {
      if (e.defaultPrevented) {
        return;
      }
      const event = new $ET(e);
      if (event.keyCode === 6 && e.repeat) {
        return;
      }
      if (e.altKey && !this.D.altKey) {
        this.D.lastKeyPressed = "alt";
      } else if (e.ctrlKey && !this.D.ctrlKey) {
        this.D.lastKeyPressed = "ctrl";
      } else if (e.metaKey && !this.D.metaKey) {
        this.D.lastKeyPressed = "meta";
      } else if (e.shiftKey && !this.D.shiftKey) {
        this.D.lastKeyPressed = "shift";
      } else if (event.keyCode !== 6) {
        this.D.lastKeyPressed = void 0;
      } else {
        return;
      }
      this.D.altKey = e.altKey;
      this.D.ctrlKey = e.ctrlKey;
      this.D.metaKey = e.metaKey;
      this.D.shiftKey = e.shiftKey;
      if (this.D.lastKeyPressed) {
        this.D.event = e;
        this.fire(this.D);
      }
    }, true));
    disposables.add($HT(window2, "keyup", (e) => {
      if (e.defaultPrevented) {
        return;
      }
      if (!e.altKey && this.D.altKey) {
        this.D.lastKeyReleased = "alt";
      } else if (!e.ctrlKey && this.D.ctrlKey) {
        this.D.lastKeyReleased = "ctrl";
      } else if (!e.metaKey && this.D.metaKey) {
        this.D.lastKeyReleased = "meta";
      } else if (!e.shiftKey && this.D.shiftKey) {
        this.D.lastKeyReleased = "shift";
      } else {
        this.D.lastKeyReleased = void 0;
      }
      if (this.D.lastKeyPressed !== this.D.lastKeyReleased) {
        this.D.lastKeyPressed = void 0;
      }
      this.D.altKey = e.altKey;
      this.D.ctrlKey = e.ctrlKey;
      this.D.metaKey = e.metaKey;
      this.D.shiftKey = e.shiftKey;
      if (this.D.lastKeyReleased) {
        this.D.event = e;
        this.fire(this.D);
      }
    }, true));
    disposables.add($HT(window2.document.body, "mousedown", () => {
      this.D.lastKeyPressed = void 0;
    }, true));
    disposables.add($HT(window2.document.body, "mouseup", () => {
      this.D.lastKeyPressed = void 0;
    }, true));
    disposables.add($HT(window2.document.body, "mousemove", (e) => {
      if (e.buttons) {
        this.D.lastKeyPressed = void 0;
      }
    }, true));
    disposables.add($HT(window2, "blur", () => {
      this.resetKeyStatus();
    }));
  }
  get keyStatus() {
    return this.D;
  }
  get isModifierPressed() {
    return this.D.altKey || this.D.ctrlKey || this.D.metaKey || this.D.shiftKey;
  }
  /**
   * Allows to explicitly reset the key status based on more knowledge (#109062)
   */
  resetKeyStatus() {
    this.H();
    this.fire(this.D);
  }
  H() {
    this.D = {
      altKey: false,
      shiftKey: false,
      ctrlKey: false,
      metaKey: false
    };
  }
  static getInstance() {
    if (!_$dV.F) {
      _$dV.F = new _$dV();
    }
    return _$dV.F;
  }
  dispose() {
    super.dispose();
    this.o.dispose();
  }
};
var $fV = class extends $0c {
  constructor(j, m) {
    super();
    this.j = j;
    this.m = m;
    this.f = 0;
    this.g = 0;
    this.n();
  }
  n() {
    if (this.m.onDragStart) {
      this.B($HT(this.j, $IU.DRAG_START, (e) => {
        this.m.onDragStart?.(e);
      }));
    }
    if (this.m.onDrag) {
      this.B($HT(this.j, $IU.DRAG, (e) => {
        this.m.onDrag?.(e);
      }));
    }
    this.B($HT(this.j, $IU.DRAG_ENTER, (e) => {
      this.f++;
      this.g = e.timeStamp;
      this.m.onDragEnter?.(e);
    }));
    this.B($HT(this.j, $IU.DRAG_OVER, (e) => {
      e.preventDefault();
      this.m.onDragOver?.(e, e.timeStamp - this.g);
    }));
    this.B($HT(this.j, $IU.DRAG_LEAVE, (e) => {
      this.f--;
      if (this.f === 0) {
        this.g = 0;
        this.m.onDragLeave?.(e);
      }
    }));
    this.B($HT(this.j, $IU.DRAG_END, (e) => {
      this.f = 0;
      this.g = 0;
      this.m.onDragEnd?.(e);
    }));
    this.B($HT(this.j, $IU.DROP, (e) => {
      this.f = 0;
      this.g = 0;
      this.m.onDrop?.(e);
    }));
  }
};
var H_REGEX = /(?<tag>[\w\-]+)?(?:#(?<id>[\w\-]+))?(?<class>(?:\.(?:[\w\-]+))*)(?:@(?<name>(?:[\w\_])+))?/;
function h(tag4, ...args2) {
  let attributes;
  let children;
  if (Array.isArray(args2[0])) {
    attributes = {};
    children = args2[0];
  } else {
    attributes = args2[0] || {};
    children = args2[1];
  }
  const match = H_REGEX.exec(tag4);
  if (!match || !match.groups) {
    throw new Error("Bad use of h");
  }
  const tagName = match.groups["tag"] || "div";
  const el = document.createElement(tagName);
  if (match.groups["id"]) {
    el.id = match.groups["id"];
  }
  const classNames = [];
  if (match.groups["class"]) {
    for (const className of match.groups["class"].split(".")) {
      if (className !== "") {
        classNames.push(className);
      }
    }
  }
  if (attributes.className !== void 0) {
    for (const className of attributes.className.split(".")) {
      if (className !== "") {
        classNames.push(className);
      }
    }
  }
  if (classNames.length > 0) {
    el.className = classNames.join(" ");
  }
  const result = {};
  if (match.groups["name"]) {
    result[match.groups["name"]] = el;
  }
  if (children) {
    for (const c of children) {
      if ($wU(c)) {
        el.appendChild(c);
      } else if (typeof c === "string") {
        el.append(c);
      } else if ("root" in c) {
        Object.assign(result, c);
        el.appendChild(c.root);
      }
    }
  }
  for (const [key, value] of Object.entries(attributes)) {
    if (key === "className") {
      continue;
    } else if (key === "style") {
      for (const [cssKey, cssValue] of Object.entries(value)) {
        el.style.setProperty(camelCaseToHyphenCase(cssKey), typeof cssValue === "number" ? cssValue + "px" : "" + cssValue);
      }
    } else if (key === "tabIndex") {
      el.tabIndex = value;
    } else {
      el.setAttribute(camelCaseToHyphenCase(key), value.toString());
    }
  }
  result["root"] = el;
  return result;
}
function $hV(tag4, ...args2) {
  let attributes;
  let children;
  if (Array.isArray(args2[0])) {
    attributes = {};
    children = args2[0];
  } else {
    attributes = args2[0] || {};
    children = args2[1];
  }
  const match = H_REGEX.exec(tag4);
  if (!match || !match.groups) {
    throw new Error("Bad use of h");
  }
  const tagName = match.groups["tag"] || "div";
  const el = document.createElementNS("http://www.w3.org/2000/svg", tagName);
  if (match.groups["id"]) {
    el.id = match.groups["id"];
  }
  const classNames = [];
  if (match.groups["class"]) {
    for (const className of match.groups["class"].split(".")) {
      if (className !== "") {
        classNames.push(className);
      }
    }
  }
  if (attributes.className !== void 0) {
    for (const className of attributes.className.split(".")) {
      if (className !== "") {
        classNames.push(className);
      }
    }
  }
  if (classNames.length > 0) {
    el.className = classNames.join(" ");
  }
  const result = {};
  if (match.groups["name"]) {
    result[match.groups["name"]] = el;
  }
  if (children) {
    for (const c of children) {
      if ($wU(c)) {
        el.appendChild(c);
      } else if (typeof c === "string") {
        el.append(c);
      } else if ("root" in c) {
        Object.assign(result, c);
        el.appendChild(c.root);
      }
    }
  }
  for (const [key, value] of Object.entries(attributes)) {
    if (key === "className") {
      continue;
    } else if (key === "style") {
      for (const [cssKey, cssValue] of Object.entries(value)) {
        el.style.setProperty(camelCaseToHyphenCase(cssKey), typeof cssValue === "number" ? cssValue + "px" : "" + cssValue);
      }
    } else if (key === "tabIndex") {
      el.tabIndex = value;
    } else {
      el.setAttribute(camelCaseToHyphenCase(key), value.toString());
    }
  }
  result["root"] = el;
  return result;
}
function camelCaseToHyphenCase(str) {
  return str.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
}
function $iV(from, to, filter) {
  for (const { name, value } of from.attributes) {
    if (!filter || filter.includes(name)) {
      to.setAttribute(name, value);
    }
  }
}
function copyAttribute(from, to, name) {
  const value = from.getAttribute(name);
  if (value) {
    to.setAttribute(name, value);
  } else {
    to.removeAttribute(name);
  }
}
function $jV(from, to, filter) {
  $iV(from, to, filter);
  const disposables = new $9c();
  disposables.add($rU.observe(from, disposables, { attributes: true, attributeFilter: filter })((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type === "attributes" && mutation.attributeName) {
        copyAttribute(from, to, mutation.attributeName);
      }
    }
  }));
  return disposables;
}
function $kV(element) {
  return element.tagName.toLowerCase() === "input" || element.tagName.toLowerCase() === "textarea" || $wU(element) && !!element.editContext;
}
var $lV = class {
  constructor(f, g, target) {
    this.f = f;
    this.g = g;
    this.d = new Int16Array(8);
    const { top: top2, left, right, bottom } = target.getBoundingClientRect();
    const t = this.d;
    let i = 0;
    t[i++] = left;
    t[i++] = top2;
    t[i++] = right;
    t[i++] = top2;
    t[i++] = left;
    t[i++] = bottom;
    t[i++] = right;
    t[i++] = bottom;
  }
  contains(x, y) {
    const { d: points, f: originX, g: originY } = this;
    for (let i = 0; i < 4; i++) {
      const p1 = 2 * i;
      const p2 = 2 * ((i + 1) % 4);
      if ($$m(x, y, originX, originY, points[p1], points[p1 + 1], points[p2], points[p2 + 1])) {
        return true;
      }
    }
    return false;
  }
};

// out-build/vs/base/browser/ui/aria/aria.js
var MAX_MESSAGE_LENGTH = 2e4;
var ariaContainer;
var alertContainer;
var alertContainer2;
var statusContainer;
var statusContainer2;
function $XV(parent) {
  ariaContainer = document.createElement("div");
  ariaContainer.className = "monaco-aria-container";
  const createAlertContainer = () => {
    const element = document.createElement("div");
    element.className = "monaco-alert";
    element.setAttribute("role", "alert");
    element.setAttribute("aria-atomic", "true");
    ariaContainer.appendChild(element);
    return element;
  };
  alertContainer = createAlertContainer();
  alertContainer2 = createAlertContainer();
  const createStatusContainer = () => {
    const element = document.createElement("div");
    element.className = "monaco-status";
    element.setAttribute("aria-live", "polite");
    element.setAttribute("aria-atomic", "true");
    ariaContainer.appendChild(element);
    return element;
  };
  statusContainer = createStatusContainer();
  statusContainer2 = createStatusContainer();
  parent.appendChild(ariaContainer);
}
function $YV(msg) {
  if (!ariaContainer) {
    return;
  }
  if (alertContainer.textContent !== msg) {
    $GT(alertContainer2);
    insertMessage(alertContainer, msg);
  } else {
    $GT(alertContainer);
    insertMessage(alertContainer2, msg);
  }
}
function $ZV(msg) {
  if (!ariaContainer) {
    return;
  }
  if (statusContainer.textContent !== msg) {
    $GT(statusContainer2);
    insertMessage(statusContainer, msg);
  } else {
    $GT(statusContainer);
    insertMessage(statusContainer2, msg);
  }
}
function insertMessage(target, msg) {
  $GT(target);
  if (msg.length > MAX_MESSAGE_LENGTH) {
    msg = msg.substr(0, MAX_MESSAGE_LENGTH);
  }
  target.textContent = msg;
  target.style.visibility = "hidden";
  target.style.visibility = "visible";
}

// out-build/vs/platform/instantiation/common/instantiation.js
var _util;
(function(_util2) {
  _util2.serviceIds = /* @__PURE__ */ new Map();
  _util2.DI_TARGET = "$di$target";
  _util2.DI_DEPENDENCIES = "$di$dependencies";
  function getServiceDependencies(ctor) {
    return ctor[_util2.DI_DEPENDENCIES] || [];
  }
  _util2.getServiceDependencies = getServiceDependencies;
})(_util || (_util = {}));
var $Yi = $Zi("instantiationService");
function storeServiceDependency(id2, target, index) {
  if (target[_util.DI_TARGET] === target) {
    target[_util.DI_DEPENDENCIES].push({ id: id2, index });
  } else {
    target[_util.DI_DEPENDENCIES] = [{ id: id2, index }];
    target[_util.DI_TARGET] = target;
  }
}
function $Zi(serviceId) {
  if (_util.serviceIds.has(serviceId)) {
    return _util.serviceIds.get(serviceId);
  }
  const id2 = function(target, key, index) {
    if (arguments.length !== 3) {
      throw new Error("@IServiceName-decorator can only be used to decorate a parameter");
    }
    storeServiceDependency(id2, target, index);
  };
  id2.toString = () => serviceId;
  _util.serviceIds.set(serviceId, id2);
  return id2;
}
function $1i(serviceIdentifier) {
  return serviceIdentifier;
}

// out-build/vs/editor/browser/services/codeEditorService.js
var $11 = $Zi("codeEditorService");

// out-build/vs/editor/common/core/position.js
var $_t = class _$_t {
  constructor(lineNumber, column) {
    this.lineNumber = lineNumber;
    this.column = column;
  }
  /**
   * Create a new position from this position.
   *
   * @param newLineNumber new line number
   * @param newColumn new column
   */
  with(newLineNumber = this.lineNumber, newColumn = this.column) {
    if (newLineNumber === this.lineNumber && newColumn === this.column) {
      return this;
    } else {
      return new _$_t(newLineNumber, newColumn);
    }
  }
  /**
   * Derive a new position from this position.
   *
   * @param deltaLineNumber line number delta
   * @param deltaColumn column delta
   */
  delta(deltaLineNumber = 0, deltaColumn = 0) {
    return this.with(this.lineNumber + deltaLineNumber, this.column + deltaColumn);
  }
  /**
   * Test if this position equals other position
   */
  equals(other4) {
    return _$_t.equals(this, other4);
  }
  /**
   * Test if position `a` equals position `b`
   */
  static equals(a, b) {
    if (!a && !b) {
      return true;
    }
    return !!a && !!b && a.lineNumber === b.lineNumber && a.column === b.column;
  }
  /**
   * Test if this position is before other position.
   * If the two positions are equal, the result will be false.
   */
  isBefore(other4) {
    return _$_t.isBefore(this, other4);
  }
  /**
   * Test if position `a` is before position `b`.
   * If the two positions are equal, the result will be false.
   */
  static isBefore(a, b) {
    if (a.lineNumber < b.lineNumber) {
      return true;
    }
    if (b.lineNumber < a.lineNumber) {
      return false;
    }
    return a.column < b.column;
  }
  /**
   * Test if this position is before other position.
   * If the two positions are equal, the result will be true.
   */
  isBeforeOrEqual(other4) {
    return _$_t.isBeforeOrEqual(this, other4);
  }
  /**
   * Test if position `a` is before position `b`.
   * If the two positions are equal, the result will be true.
   */
  static isBeforeOrEqual(a, b) {
    if (a.lineNumber < b.lineNumber) {
      return true;
    }
    if (b.lineNumber < a.lineNumber) {
      return false;
    }
    return a.column <= b.column;
  }
  /**
   * A function that compares positions, useful for sorting
   */
  static compare(a, b) {
    const aLineNumber = a.lineNumber | 0;
    const bLineNumber = b.lineNumber | 0;
    if (aLineNumber === bLineNumber) {
      const aColumn = a.column | 0;
      const bColumn = b.column | 0;
      return aColumn - bColumn;
    }
    return aLineNumber - bLineNumber;
  }
  /**
   * Clone this position.
   */
  clone() {
    return new _$_t(this.lineNumber, this.column);
  }
  /**
   * Convert to a human-readable representation.
   */
  toString() {
    return "(" + this.lineNumber + "," + this.column + ")";
  }
  // ---
  /**
   * Create a `Position` from an `IPosition`.
   */
  static lift(pos) {
    return new _$_t(pos.lineNumber, pos.column);
  }
  /**
   * Test if `obj` is an `IPosition`.
   */
  static isIPosition(obj) {
    return obj && typeof obj.lineNumber === "number" && typeof obj.column === "number";
  }
  toJSON() {
    return {
      lineNumber: this.lineNumber,
      column: this.column
    };
  }
};

// out-build/vs/editor/common/services/model.js
var $Lx = $Zi("modelService");

// out-build/vs/editor/common/services/resolverService.js
var $Hx = $Zi("textModelService");
function $Ix(model) {
  const candidate = model;
  return !!candidate.textEditorModel;
}

// out-build/vs/base/common/actions.js
var $Ej = class extends $0c {
  constructor(id2, label3 = "", cssClass = "", enabled = true, actionCallback) {
    super();
    this.j = this.B(new $De());
    this.onDidChange = this.j.event;
    this.z = true;
    this.m = id2;
    this.n = label3;
    this.w = cssClass;
    this.z = enabled;
    this.D = actionCallback;
  }
  get id() {
    return this.m;
  }
  get label() {
    return this.n;
  }
  set label(value) {
    this.F(value);
  }
  F(value) {
    if (this.n !== value) {
      this.n = value;
      this.j.fire({ label: value });
    }
  }
  get tooltip() {
    return this.u || "";
  }
  set tooltip(value) {
    this.G(value);
  }
  G(value) {
    if (this.u !== value) {
      this.u = value;
      this.j.fire({ tooltip: value });
    }
  }
  get class() {
    return this.w;
  }
  set class(value) {
    this.H(value);
  }
  H(value) {
    if (this.w !== value) {
      this.w = value;
      this.j.fire({ class: value });
    }
  }
  get enabled() {
    return this.z;
  }
  set enabled(value) {
    this.I(value);
  }
  I(value) {
    if (this.z !== value) {
      this.z = value;
      this.j.fire({ enabled: value });
    }
  }
  get checked() {
    return this.C;
  }
  set checked(value) {
    this.J(value);
  }
  J(value) {
    if (this.C !== value) {
      this.C = value;
      this.j.fire({ checked: value });
    }
  }
  async run(event, data) {
    if (this.D) {
      await this.D(event);
    }
  }
};
var $Fj = class extends $0c {
  constructor() {
    super(...arguments);
    this.f = this.B(new $De());
    this.onWillRun = this.f.event;
    this.m = this.B(new $De());
    this.onDidRun = this.m.event;
  }
  async run(action, context) {
    if (!action.enabled) {
      return;
    }
    this.f.fire({ action });
    let error = void 0;
    try {
      await this.u(action, context);
    } catch (e) {
      error = e;
    }
    this.m.fire({ action, error });
  }
  async u(action, context) {
    await action.run(context);
  }
};
var $Gj = class _$Gj {
  constructor() {
    this.id = _$Gj.ID;
    this.label = "";
    this.tooltip = "";
    this.class = "separator";
    this.enabled = false;
    this.checked = false;
  }
  /**
   * Joins all non-empty lists of actions with separators.
   */
  static join(...actionLists) {
    let out = [];
    for (const list4 of actionLists) {
      if (!list4.length) {
      } else if (out.length) {
        out = [...out, new _$Gj(), ...list4];
      } else {
        out = list4;
      }
    }
    return out;
  }
  static {
    this.ID = "vs.actions.separator";
  }
  async run() {
  }
};
var $Hj = class {
  get actions() {
    return this.a;
  }
  constructor(id2, label3, actions, cssClass) {
    this.tooltip = "";
    this.enabled = true;
    this.checked = void 0;
    this.id = id2;
    this.label = label3;
    this.class = cssClass;
    this.a = actions;
  }
  async run() {
  }
};
var $Ij = class _$Ij extends $Ej {
  static {
    this.ID = "vs.actions.empty";
  }
  constructor() {
    super(_$Ij.ID, localize(42, null), void 0, false);
  }
};
function $Jj(props) {
  return {
    id: props.id,
    label: props.label,
    tooltip: props.tooltip ?? props.label,
    class: props.class,
    enabled: props.enabled ?? true,
    checked: props.checked,
    run: async (...args2) => props.run(...args2)
  };
}

// out-build/vs/base/common/codiconsUtil.js
var _codiconFontCharacters = /* @__PURE__ */ Object.create(null);
function $hk(id2, fontCharacter) {
  if ($yg(fontCharacter)) {
    const val = _codiconFontCharacters[fontCharacter];
    if (val === void 0) {
      throw new Error(`${id2} references an unknown codicon: ${fontCharacter}`);
    }
    fontCharacter = val;
  }
  _codiconFontCharacters[id2] = fontCharacter;
  return { id: id2 };
}
function $ik() {
  return _codiconFontCharacters;
}

// out-build/vs/base/common/codiconsLibrary.js
var $jk = {
  add: $hk("add", 6e4),
  plus: $hk("plus", 6e4),
  gistNew: $hk("gist-new", 6e4),
  repoCreate: $hk("repo-create", 6e4),
  lightbulb: $hk("lightbulb", 60001),
  lightBulb: $hk("light-bulb", 60001),
  repo: $hk("repo", 60002),
  repoDelete: $hk("repo-delete", 60002),
  gistFork: $hk("gist-fork", 60003),
  repoForked: $hk("repo-forked", 60003),
  gitPullRequest: $hk("git-pull-request", 60004),
  gitPullRequestAbandoned: $hk("git-pull-request-abandoned", 60004),
  recordKeys: $hk("record-keys", 60005),
  keyboard: $hk("keyboard", 60005),
  tag: $hk("tag", 60006),
  gitPullRequestLabel: $hk("git-pull-request-label", 60006),
  tagAdd: $hk("tag-add", 60006),
  tagRemove: $hk("tag-remove", 60006),
  person: $hk("person", 60007),
  personFollow: $hk("person-follow", 60007),
  personOutline: $hk("person-outline", 60007),
  personFilled: $hk("person-filled", 60007),
  gitBranch: $hk("git-branch", 60008),
  gitBranchCreate: $hk("git-branch-create", 60008),
  gitBranchDelete: $hk("git-branch-delete", 60008),
  sourceControl: $hk("source-control", 60008),
  mirror: $hk("mirror", 60009),
  mirrorPublic: $hk("mirror-public", 60009),
  star: $hk("star", 60010),
  starAdd: $hk("star-add", 60010),
  starDelete: $hk("star-delete", 60010),
  starEmpty: $hk("star-empty", 60010),
  comment: $hk("comment", 60011),
  commentAdd: $hk("comment-add", 60011),
  alert: $hk("alert", 60012),
  warning: $hk("warning", 60012),
  search: $hk("search", 60013),
  searchSave: $hk("search-save", 60013),
  logOut: $hk("log-out", 60014),
  signOut: $hk("sign-out", 60014),
  logIn: $hk("log-in", 60015),
  signIn: $hk("sign-in", 60015),
  eye: $hk("eye", 60016),
  eyeUnwatch: $hk("eye-unwatch", 60016),
  eyeWatch: $hk("eye-watch", 60016),
  circleFilled: $hk("circle-filled", 60017),
  primitiveDot: $hk("primitive-dot", 60017),
  closeDirty: $hk("close-dirty", 60017),
  debugBreakpoint: $hk("debug-breakpoint", 60017),
  debugBreakpointDisabled: $hk("debug-breakpoint-disabled", 60017),
  debugHint: $hk("debug-hint", 60017),
  terminalDecorationSuccess: $hk("terminal-decoration-success", 60017),
  primitiveSquare: $hk("primitive-square", 60018),
  edit: $hk("edit", 60019),
  pencil: $hk("pencil", 60019),
  info: $hk("info", 60020),
  issueOpened: $hk("issue-opened", 60020),
  gistPrivate: $hk("gist-private", 60021),
  gitForkPrivate: $hk("git-fork-private", 60021),
  lock: $hk("lock", 60021),
  mirrorPrivate: $hk("mirror-private", 60021),
  close: $hk("close", 60022),
  removeClose: $hk("remove-close", 60022),
  x: $hk("x", 60022),
  repoSync: $hk("repo-sync", 60023),
  sync: $hk("sync", 60023),
  clone: $hk("clone", 60024),
  desktopDownload: $hk("desktop-download", 60024),
  beaker: $hk("beaker", 60025),
  microscope: $hk("microscope", 60025),
  vm: $hk("vm", 60026),
  deviceDesktop: $hk("device-desktop", 60026),
  file: $hk("file", 60027),
  fileText: $hk("file-text", 60027),
  more: $hk("more", 60028),
  ellipsis: $hk("ellipsis", 60028),
  kebabHorizontal: $hk("kebab-horizontal", 60028),
  mailReply: $hk("mail-reply", 60029),
  reply: $hk("reply", 60029),
  organization: $hk("organization", 60030),
  organizationFilled: $hk("organization-filled", 60030),
  organizationOutline: $hk("organization-outline", 60030),
  newFile: $hk("new-file", 60031),
  fileAdd: $hk("file-add", 60031),
  newFolder: $hk("new-folder", 60032),
  fileDirectoryCreate: $hk("file-directory-create", 60032),
  trash: $hk("trash", 60033),
  trashcan: $hk("trashcan", 60033),
  history: $hk("history", 60034),
  clock: $hk("clock", 60034),
  folder: $hk("folder", 60035),
  fileDirectory: $hk("file-directory", 60035),
  symbolFolder: $hk("symbol-folder", 60035),
  logoGithub: $hk("logo-github", 60036),
  markGithub: $hk("mark-github", 60036),
  github: $hk("github", 60036),
  terminal: $hk("terminal", 60037),
  console: $hk("console", 60037),
  repl: $hk("repl", 60037),
  zap: $hk("zap", 60038),
  symbolEvent: $hk("symbol-event", 60038),
  error: $hk("error", 60039),
  stop: $hk("stop", 60039),
  variable: $hk("variable", 60040),
  symbolVariable: $hk("symbol-variable", 60040),
  array: $hk("array", 60042),
  symbolArray: $hk("symbol-array", 60042),
  symbolModule: $hk("symbol-module", 60043),
  symbolPackage: $hk("symbol-package", 60043),
  symbolNamespace: $hk("symbol-namespace", 60043),
  symbolObject: $hk("symbol-object", 60043),
  symbolMethod: $hk("symbol-method", 60044),
  symbolFunction: $hk("symbol-function", 60044),
  symbolConstructor: $hk("symbol-constructor", 60044),
  symbolBoolean: $hk("symbol-boolean", 60047),
  symbolNull: $hk("symbol-null", 60047),
  symbolNumeric: $hk("symbol-numeric", 60048),
  symbolNumber: $hk("symbol-number", 60048),
  symbolStructure: $hk("symbol-structure", 60049),
  symbolStruct: $hk("symbol-struct", 60049),
  symbolParameter: $hk("symbol-parameter", 60050),
  symbolTypeParameter: $hk("symbol-type-parameter", 60050),
  symbolKey: $hk("symbol-key", 60051),
  symbolText: $hk("symbol-text", 60051),
  symbolReference: $hk("symbol-reference", 60052),
  goToFile: $hk("go-to-file", 60052),
  symbolEnum: $hk("symbol-enum", 60053),
  symbolValue: $hk("symbol-value", 60053),
  symbolRuler: $hk("symbol-ruler", 60054),
  symbolUnit: $hk("symbol-unit", 60054),
  activateBreakpoints: $hk("activate-breakpoints", 60055),
  archive: $hk("archive", 60056),
  arrowBoth: $hk("arrow-both", 60057),
  arrowDown: $hk("arrow-down", 60058),
  arrowLeft: $hk("arrow-left", 60059),
  arrowRight: $hk("arrow-right", 60060),
  arrowSmallDown: $hk("arrow-small-down", 60061),
  arrowSmallLeft: $hk("arrow-small-left", 60062),
  arrowSmallRight: $hk("arrow-small-right", 60063),
  arrowSmallUp: $hk("arrow-small-up", 60064),
  arrowUp: $hk("arrow-up", 60065),
  bell: $hk("bell", 60066),
  bold: $hk("bold", 60067),
  book: $hk("book", 60068),
  bookmark: $hk("bookmark", 60069),
  debugBreakpointConditionalUnverified: $hk("debug-breakpoint-conditional-unverified", 60070),
  debugBreakpointConditional: $hk("debug-breakpoint-conditional", 60071),
  debugBreakpointConditionalDisabled: $hk("debug-breakpoint-conditional-disabled", 60071),
  debugBreakpointDataUnverified: $hk("debug-breakpoint-data-unverified", 60072),
  debugBreakpointData: $hk("debug-breakpoint-data", 60073),
  debugBreakpointDataDisabled: $hk("debug-breakpoint-data-disabled", 60073),
  debugBreakpointLogUnverified: $hk("debug-breakpoint-log-unverified", 60074),
  debugBreakpointLog: $hk("debug-breakpoint-log", 60075),
  debugBreakpointLogDisabled: $hk("debug-breakpoint-log-disabled", 60075),
  briefcase: $hk("briefcase", 60076),
  broadcast: $hk("broadcast", 60077),
  browser: $hk("browser", 60078),
  bug: $hk("bug", 60079),
  calendar: $hk("calendar", 60080),
  caseSensitive: $hk("case-sensitive", 60081),
  check: $hk("check", 60082),
  checklist: $hk("checklist", 60083),
  chevronDown: $hk("chevron-down", 60084),
  chevronLeft: $hk("chevron-left", 60085),
  chevronRight: $hk("chevron-right", 60086),
  chevronUp: $hk("chevron-up", 60087),
  chromeClose: $hk("chrome-close", 60088),
  chromeMaximize: $hk("chrome-maximize", 60089),
  chromeMinimize: $hk("chrome-minimize", 60090),
  chromeRestore: $hk("chrome-restore", 60091),
  circleOutline: $hk("circle-outline", 60092),
  circle: $hk("circle", 60092),
  debugBreakpointUnverified: $hk("debug-breakpoint-unverified", 60092),
  terminalDecorationIncomplete: $hk("terminal-decoration-incomplete", 60092),
  circleSlash: $hk("circle-slash", 60093),
  circuitBoard: $hk("circuit-board", 60094),
  clearAll: $hk("clear-all", 60095),
  clippy: $hk("clippy", 60096),
  closeAll: $hk("close-all", 60097),
  cloudDownload: $hk("cloud-download", 60098),
  cloudUpload: $hk("cloud-upload", 60099),
  code: $hk("code", 60100),
  collapseAll: $hk("collapse-all", 60101),
  colorMode: $hk("color-mode", 60102),
  commentDiscussion: $hk("comment-discussion", 60103),
  creditCard: $hk("credit-card", 60105),
  dash: $hk("dash", 60108),
  dashboard: $hk("dashboard", 60109),
  database: $hk("database", 60110),
  debugContinue: $hk("debug-continue", 60111),
  debugDisconnect: $hk("debug-disconnect", 60112),
  debugPause: $hk("debug-pause", 60113),
  debugRestart: $hk("debug-restart", 60114),
  debugStart: $hk("debug-start", 60115),
  debugStepInto: $hk("debug-step-into", 60116),
  debugStepOut: $hk("debug-step-out", 60117),
  debugStepOver: $hk("debug-step-over", 60118),
  debugStop: $hk("debug-stop", 60119),
  debug: $hk("debug", 60120),
  deviceCameraVideo: $hk("device-camera-video", 60121),
  deviceCamera: $hk("device-camera", 60122),
  deviceMobile: $hk("device-mobile", 60123),
  diffAdded: $hk("diff-added", 60124),
  diffIgnored: $hk("diff-ignored", 60125),
  diffModified: $hk("diff-modified", 60126),
  diffRemoved: $hk("diff-removed", 60127),
  diffRenamed: $hk("diff-renamed", 60128),
  diff: $hk("diff", 60129),
  diffSidebyside: $hk("diff-sidebyside", 60129),
  discard: $hk("discard", 60130),
  editorLayout: $hk("editor-layout", 60131),
  emptyWindow: $hk("empty-window", 60132),
  exclude: $hk("exclude", 60133),
  extensions: $hk("extensions", 60134),
  eyeClosed: $hk("eye-closed", 60135),
  fileBinary: $hk("file-binary", 60136),
  fileCode: $hk("file-code", 60137),
  fileMedia: $hk("file-media", 60138),
  filePdf: $hk("file-pdf", 60139),
  fileSubmodule: $hk("file-submodule", 60140),
  fileSymlinkDirectory: $hk("file-symlink-directory", 60141),
  fileSymlinkFile: $hk("file-symlink-file", 60142),
  fileZip: $hk("file-zip", 60143),
  files: $hk("files", 60144),
  filter: $hk("filter", 60145),
  flame: $hk("flame", 60146),
  foldDown: $hk("fold-down", 60147),
  foldUp: $hk("fold-up", 60148),
  fold: $hk("fold", 60149),
  folderActive: $hk("folder-active", 60150),
  folderOpened: $hk("folder-opened", 60151),
  gear: $hk("gear", 60152),
  gift: $hk("gift", 60153),
  gistSecret: $hk("gist-secret", 60154),
  gist: $hk("gist", 60155),
  gitCommit: $hk("git-commit", 60156),
  gitCompare: $hk("git-compare", 60157),
  compareChanges: $hk("compare-changes", 60157),
  gitMerge: $hk("git-merge", 60158),
  githubAction: $hk("github-action", 60159),
  githubAlt: $hk("github-alt", 60160),
  globe: $hk("globe", 60161),
  grabber: $hk("grabber", 60162),
  graph: $hk("graph", 60163),
  gripper: $hk("gripper", 60164),
  heart: $hk("heart", 60165),
  home: $hk("home", 60166),
  horizontalRule: $hk("horizontal-rule", 60167),
  hubot: $hk("hubot", 60168),
  inbox: $hk("inbox", 60169),
  issueReopened: $hk("issue-reopened", 60171),
  issues: $hk("issues", 60172),
  italic: $hk("italic", 60173),
  jersey: $hk("jersey", 60174),
  json: $hk("json", 60175),
  kebabVertical: $hk("kebab-vertical", 60176),
  key: $hk("key", 60177),
  law: $hk("law", 60178),
  lightbulbAutofix: $hk("lightbulb-autofix", 60179),
  linkExternal: $hk("link-external", 60180),
  link: $hk("link", 60181),
  listOrdered: $hk("list-ordered", 60182),
  listUnordered: $hk("list-unordered", 60183),
  liveShare: $hk("live-share", 60184),
  loading: $hk("loading", 60185),
  location: $hk("location", 60186),
  mailRead: $hk("mail-read", 60187),
  mail: $hk("mail", 60188),
  markdown: $hk("markdown", 60189),
  megaphone: $hk("megaphone", 60190),
  mention: $hk("mention", 60191),
  milestone: $hk("milestone", 60192),
  gitPullRequestMilestone: $hk("git-pull-request-milestone", 60192),
  mortarBoard: $hk("mortar-board", 60193),
  move: $hk("move", 60194),
  multipleWindows: $hk("multiple-windows", 60195),
  mute: $hk("mute", 60196),
  noNewline: $hk("no-newline", 60197),
  note: $hk("note", 60198),
  octoface: $hk("octoface", 60199),
  openPreview: $hk("open-preview", 60200),
  package: $hk("package", 60201),
  paintcan: $hk("paintcan", 60202),
  pin: $hk("pin", 60203),
  play: $hk("play", 60204),
  run: $hk("run", 60204),
  plug: $hk("plug", 60205),
  preserveCase: $hk("preserve-case", 60206),
  preview: $hk("preview", 60207),
  project: $hk("project", 60208),
  pulse: $hk("pulse", 60209),
  question: $hk("question", 60210),
  quote: $hk("quote", 60211),
  radioTower: $hk("radio-tower", 60212),
  reactions: $hk("reactions", 60213),
  references: $hk("references", 60214),
  refresh: $hk("refresh", 60215),
  regex: $hk("regex", 60216),
  remoteExplorer: $hk("remote-explorer", 60217),
  remote: $hk("remote", 60218),
  remove: $hk("remove", 60219),
  replaceAll: $hk("replace-all", 60220),
  replace: $hk("replace", 60221),
  repoClone: $hk("repo-clone", 60222),
  repoForcePush: $hk("repo-force-push", 60223),
  repoPull: $hk("repo-pull", 60224),
  repoPush: $hk("repo-push", 60225),
  report: $hk("report", 60226),
  requestChanges: $hk("request-changes", 60227),
  rocket: $hk("rocket", 60228),
  rootFolderOpened: $hk("root-folder-opened", 60229),
  rootFolder: $hk("root-folder", 60230),
  rss: $hk("rss", 60231),
  ruby: $hk("ruby", 60232),
  saveAll: $hk("save-all", 60233),
  saveAs: $hk("save-as", 60234),
  save: $hk("save", 60235),
  screenFull: $hk("screen-full", 60236),
  screenNormal: $hk("screen-normal", 60237),
  searchStop: $hk("search-stop", 60238),
  server: $hk("server", 60240),
  settingsGear: $hk("settings-gear", 60241),
  settings: $hk("settings", 60242),
  shield: $hk("shield", 60243),
  smiley: $hk("smiley", 60244),
  sortPrecedence: $hk("sort-precedence", 60245),
  splitHorizontal: $hk("split-horizontal", 60246),
  splitVertical: $hk("split-vertical", 60247),
  squirrel: $hk("squirrel", 60248),
  starFull: $hk("star-full", 60249),
  starHalf: $hk("star-half", 60250),
  symbolClass: $hk("symbol-class", 60251),
  symbolColor: $hk("symbol-color", 60252),
  symbolConstant: $hk("symbol-constant", 60253),
  symbolEnumMember: $hk("symbol-enum-member", 60254),
  symbolField: $hk("symbol-field", 60255),
  symbolFile: $hk("symbol-file", 60256),
  symbolInterface: $hk("symbol-interface", 60257),
  symbolKeyword: $hk("symbol-keyword", 60258),
  symbolMisc: $hk("symbol-misc", 60259),
  symbolOperator: $hk("symbol-operator", 60260),
  symbolProperty: $hk("symbol-property", 60261),
  wrench: $hk("wrench", 60261),
  wrenchSubaction: $hk("wrench-subaction", 60261),
  symbolSnippet: $hk("symbol-snippet", 60262),
  tasklist: $hk("tasklist", 60263),
  telescope: $hk("telescope", 60264),
  textSize: $hk("text-size", 60265),
  threeBars: $hk("three-bars", 60266),
  thumbsdown: $hk("thumbsdown", 60267),
  thumbsup: $hk("thumbsup", 60268),
  tools: $hk("tools", 60269),
  triangleDown: $hk("triangle-down", 60270),
  triangleLeft: $hk("triangle-left", 60271),
  triangleRight: $hk("triangle-right", 60272),
  triangleUp: $hk("triangle-up", 60273),
  twitter: $hk("twitter", 60274),
  unfold: $hk("unfold", 60275),
  unlock: $hk("unlock", 60276),
  unmute: $hk("unmute", 60277),
  unverified: $hk("unverified", 60278),
  verified: $hk("verified", 60279),
  versions: $hk("versions", 60280),
  vmActive: $hk("vm-active", 60281),
  vmOutline: $hk("vm-outline", 60282),
  vmRunning: $hk("vm-running", 60283),
  watch: $hk("watch", 60284),
  whitespace: $hk("whitespace", 60285),
  wholeWord: $hk("whole-word", 60286),
  window: $hk("window", 60287),
  wordWrap: $hk("word-wrap", 60288),
  zoomIn: $hk("zoom-in", 60289),
  zoomOut: $hk("zoom-out", 60290),
  listFilter: $hk("list-filter", 60291),
  listFlat: $hk("list-flat", 60292),
  listSelection: $hk("list-selection", 60293),
  selection: $hk("selection", 60293),
  listTree: $hk("list-tree", 60294),
  debugBreakpointFunctionUnverified: $hk("debug-breakpoint-function-unverified", 60295),
  debugBreakpointFunction: $hk("debug-breakpoint-function", 60296),
  debugBreakpointFunctionDisabled: $hk("debug-breakpoint-function-disabled", 60296),
  debugStackframeActive: $hk("debug-stackframe-active", 60297),
  circleSmallFilled: $hk("circle-small-filled", 60298),
  debugStackframeDot: $hk("debug-stackframe-dot", 60298),
  terminalDecorationMark: $hk("terminal-decoration-mark", 60298),
  debugStackframe: $hk("debug-stackframe", 60299),
  debugStackframeFocused: $hk("debug-stackframe-focused", 60299),
  debugBreakpointUnsupported: $hk("debug-breakpoint-unsupported", 60300),
  symbolString: $hk("symbol-string", 60301),
  debugReverseContinue: $hk("debug-reverse-continue", 60302),
  debugStepBack: $hk("debug-step-back", 60303),
  debugRestartFrame: $hk("debug-restart-frame", 60304),
  debugAlt: $hk("debug-alt", 60305),
  callIncoming: $hk("call-incoming", 60306),
  callOutgoing: $hk("call-outgoing", 60307),
  menu: $hk("menu", 60308),
  expandAll: $hk("expand-all", 60309),
  feedback: $hk("feedback", 60310),
  gitPullRequestReviewer: $hk("git-pull-request-reviewer", 60310),
  groupByRefType: $hk("group-by-ref-type", 60311),
  ungroupByRefType: $hk("ungroup-by-ref-type", 60312),
  account: $hk("account", 60313),
  gitPullRequestAssignee: $hk("git-pull-request-assignee", 60313),
  bellDot: $hk("bell-dot", 60314),
  debugConsole: $hk("debug-console", 60315),
  library: $hk("library", 60316),
  output: $hk("output", 60317),
  runAll: $hk("run-all", 60318),
  syncIgnored: $hk("sync-ignored", 60319),
  pinned: $hk("pinned", 60320),
  githubInverted: $hk("github-inverted", 60321),
  serverProcess: $hk("server-process", 60322),
  serverEnvironment: $hk("server-environment", 60323),
  pass: $hk("pass", 60324),
  issueClosed: $hk("issue-closed", 60324),
  stopCircle: $hk("stop-circle", 60325),
  playCircle: $hk("play-circle", 60326),
  record: $hk("record", 60327),
  debugAltSmall: $hk("debug-alt-small", 60328),
  vmConnect: $hk("vm-connect", 60329),
  cloud: $hk("cloud", 60330),
  merge: $hk("merge", 60331),
  export: $hk("export", 60332),
  graphLeft: $hk("graph-left", 60333),
  magnet: $hk("magnet", 60334),
  notebook: $hk("notebook", 60335),
  redo: $hk("redo", 60336),
  checkAll: $hk("check-all", 60337),
  pinnedDirty: $hk("pinned-dirty", 60338),
  passFilled: $hk("pass-filled", 60339),
  circleLargeFilled: $hk("circle-large-filled", 60340),
  circleLarge: $hk("circle-large", 60341),
  circleLargeOutline: $hk("circle-large-outline", 60341),
  combine: $hk("combine", 60342),
  gather: $hk("gather", 60342),
  table: $hk("table", 60343),
  variableGroup: $hk("variable-group", 60344),
  typeHierarchy: $hk("type-hierarchy", 60345),
  typeHierarchySub: $hk("type-hierarchy-sub", 60346),
  typeHierarchySuper: $hk("type-hierarchy-super", 60347),
  gitPullRequestCreate: $hk("git-pull-request-create", 60348),
  runAbove: $hk("run-above", 60349),
  runBelow: $hk("run-below", 60350),
  notebookTemplate: $hk("notebook-template", 60351),
  debugRerun: $hk("debug-rerun", 60352),
  workspaceTrusted: $hk("workspace-trusted", 60353),
  workspaceUntrusted: $hk("workspace-untrusted", 60354),
  workspaceUnknown: $hk("workspace-unknown", 60355),
  terminalCmd: $hk("terminal-cmd", 60356),
  terminalDebian: $hk("terminal-debian", 60357),
  terminalLinux: $hk("terminal-linux", 60358),
  terminalPowershell: $hk("terminal-powershell", 60359),
  terminalTmux: $hk("terminal-tmux", 60360),
  terminalUbuntu: $hk("terminal-ubuntu", 60361),
  terminalBash: $hk("terminal-bash", 60362),
  arrowSwap: $hk("arrow-swap", 60363),
  copy: $hk("copy", 60364),
  personAdd: $hk("person-add", 60365),
  filterFilled: $hk("filter-filled", 60366),
  wand: $hk("wand", 60367),
  debugLineByLine: $hk("debug-line-by-line", 60368),
  inspect: $hk("inspect", 60369),
  layers: $hk("layers", 60370),
  layersDot: $hk("layers-dot", 60371),
  layersActive: $hk("layers-active", 60372),
  compass: $hk("compass", 60373),
  compassDot: $hk("compass-dot", 60374),
  compassActive: $hk("compass-active", 60375),
  azure: $hk("azure", 60376),
  issueDraft: $hk("issue-draft", 60377),
  gitPullRequestClosed: $hk("git-pull-request-closed", 60378),
  gitPullRequestDraft: $hk("git-pull-request-draft", 60379),
  debugAll: $hk("debug-all", 60380),
  debugCoverage: $hk("debug-coverage", 60381),
  runErrors: $hk("run-errors", 60382),
  folderLibrary: $hk("folder-library", 60383),
  debugContinueSmall: $hk("debug-continue-small", 60384),
  beakerStop: $hk("beaker-stop", 60385),
  graphLine: $hk("graph-line", 60386),
  graphScatter: $hk("graph-scatter", 60387),
  pieChart: $hk("pie-chart", 60388),
  bracket: $hk("bracket", 60175),
  bracketDot: $hk("bracket-dot", 60389),
  bracketError: $hk("bracket-error", 60390),
  lockSmall: $hk("lock-small", 60391),
  azureDevops: $hk("azure-devops", 60392),
  verifiedFilled: $hk("verified-filled", 60393),
  newline: $hk("newline", 60394),
  layout: $hk("layout", 60395),
  layoutActivitybarLeft: $hk("layout-activitybar-left", 60396),
  layoutActivitybarRight: $hk("layout-activitybar-right", 60397),
  layoutPanelLeft: $hk("layout-panel-left", 60398),
  layoutPanelCenter: $hk("layout-panel-center", 60399),
  layoutPanelJustify: $hk("layout-panel-justify", 60400),
  layoutPanelRight: $hk("layout-panel-right", 60401),
  layoutPanel: $hk("layout-panel", 60402),
  layoutSidebarLeft: $hk("layout-sidebar-left", 60403),
  layoutSidebarRight: $hk("layout-sidebar-right", 60404),
  layoutStatusbar: $hk("layout-statusbar", 60405),
  layoutMenubar: $hk("layout-menubar", 60406),
  layoutCentered: $hk("layout-centered", 60407),
  target: $hk("target", 60408),
  indent: $hk("indent", 60409),
  recordSmall: $hk("record-small", 60410),
  errorSmall: $hk("error-small", 60411),
  terminalDecorationError: $hk("terminal-decoration-error", 60411),
  arrowCircleDown: $hk("arrow-circle-down", 60412),
  arrowCircleLeft: $hk("arrow-circle-left", 60413),
  arrowCircleRight: $hk("arrow-circle-right", 60414),
  arrowCircleUp: $hk("arrow-circle-up", 60415),
  layoutSidebarRightOff: $hk("layout-sidebar-right-off", 60416),
  layoutPanelOff: $hk("layout-panel-off", 60417),
  layoutSidebarLeftOff: $hk("layout-sidebar-left-off", 60418),
  blank: $hk("blank", 60419),
  heartFilled: $hk("heart-filled", 60420),
  map: $hk("map", 60421),
  mapHorizontal: $hk("map-horizontal", 60421),
  foldHorizontal: $hk("fold-horizontal", 60421),
  mapFilled: $hk("map-filled", 60422),
  mapHorizontalFilled: $hk("map-horizontal-filled", 60422),
  foldHorizontalFilled: $hk("fold-horizontal-filled", 60422),
  circleSmall: $hk("circle-small", 60423),
  bellSlash: $hk("bell-slash", 60424),
  bellSlashDot: $hk("bell-slash-dot", 60425),
  commentUnresolved: $hk("comment-unresolved", 60426),
  gitPullRequestGoToChanges: $hk("git-pull-request-go-to-changes", 60427),
  gitPullRequestNewChanges: $hk("git-pull-request-new-changes", 60428),
  searchFuzzy: $hk("search-fuzzy", 60429),
  commentDraft: $hk("comment-draft", 60430),
  send: $hk("send", 60431),
  sparkle: $hk("sparkle", 60432),
  insert: $hk("insert", 60433),
  mic: $hk("mic", 60434),
  thumbsdownFilled: $hk("thumbsdown-filled", 60435),
  thumbsupFilled: $hk("thumbsup-filled", 60436),
  coffee: $hk("coffee", 60437),
  snake: $hk("snake", 60438),
  game: $hk("game", 60439),
  vr: $hk("vr", 60440),
  chip: $hk("chip", 60441),
  piano: $hk("piano", 60442),
  music: $hk("music", 60443),
  micFilled: $hk("mic-filled", 60444),
  repoFetch: $hk("repo-fetch", 60445),
  copilot: $hk("copilot", 60446),
  lightbulbSparkle: $hk("lightbulb-sparkle", 60447),
  robot: $hk("robot", 60448),
  sparkleFilled: $hk("sparkle-filled", 60449),
  diffSingle: $hk("diff-single", 60450),
  diffMultiple: $hk("diff-multiple", 60451),
  surroundWith: $hk("surround-with", 60452),
  share: $hk("share", 60453),
  gitStash: $hk("git-stash", 60454),
  gitStashApply: $hk("git-stash-apply", 60455),
  gitStashPop: $hk("git-stash-pop", 60456),
  vscode: $hk("vscode", 60457),
  vscodeInsiders: $hk("vscode-insiders", 60458),
  codeOss: $hk("code-oss", 60459),
  runCoverage: $hk("run-coverage", 60460),
  runAllCoverage: $hk("run-all-coverage", 60461),
  coverage: $hk("coverage", 60462),
  githubProject: $hk("github-project", 60463),
  mapVertical: $hk("map-vertical", 60464),
  foldVertical: $hk("fold-vertical", 60464),
  mapVerticalFilled: $hk("map-vertical-filled", 60465),
  foldVerticalFilled: $hk("fold-vertical-filled", 60465),
  goToSearch: $hk("go-to-search", 60466),
  percentage: $hk("percentage", 60467),
  sortPercentage: $hk("sort-percentage", 60467),
  attach: $hk("attach", 60468)
};

// out-build/vs/base/common/codicons.js
function $kk() {
  return Object.values($mk);
}
var $lk = {
  dialogError: $hk("dialog-error", "error"),
  dialogWarning: $hk("dialog-warning", "warning"),
  dialogInfo: $hk("dialog-info", "info"),
  dialogClose: $hk("dialog-close", "close"),
  treeItemExpanded: $hk("tree-item-expanded", "chevron-down"),
  // collapsed is done with rotation
  treeFilterOnTypeOn: $hk("tree-filter-on-type-on", "list-filter"),
  treeFilterOnTypeOff: $hk("tree-filter-on-type-off", "list-selection"),
  treeFilterClear: $hk("tree-filter-clear", "close"),
  treeItemLoading: $hk("tree-item-loading", "loading"),
  menuSelection: $hk("menu-selection", "check"),
  menuSubmenu: $hk("menu-submenu", "chevron-right"),
  menuBarMore: $hk("menubar-more", "more"),
  scrollbarButtonLeft: $hk("scrollbar-button-left", "triangle-left"),
  scrollbarButtonRight: $hk("scrollbar-button-right", "triangle-right"),
  scrollbarButtonUp: $hk("scrollbar-button-up", "triangle-up"),
  scrollbarButtonDown: $hk("scrollbar-button-down", "triangle-down"),
  toolBarMore: $hk("toolbar-more", "more"),
  quickInputBack: $hk("quick-input-back", "arrow-left"),
  dropDownButton: $hk("drop-down-button", 60084),
  symbolCustomColor: $hk("symbol-customcolor", 60252),
  exportIcon: $hk("export", 60332),
  workspaceUnspecified: $hk("workspace-unspecified", 60355),
  newLine: $hk("newline", 60394),
  thumbsDownFilled: $hk("thumbsdown-filled", 60435),
  thumbsUpFilled: $hk("thumbsup-filled", 60436),
  gitFetch: $hk("git-fetch", 60445),
  lightbulbSparkleAutofix: $hk("lightbulb-sparkle-autofix", 60447),
  debugBreakpointPending: $hk("debug-breakpoint-pending", 60377)
};
var $mk = {
  ...$jk,
  ...$lk
};

// out-build/vs/base/common/themables.js
var ThemeColor;
(function(ThemeColor2) {
  function isThemeColor2(obj) {
    return obj && typeof obj === "object" && typeof obj.id === "string";
  }
  ThemeColor2.isThemeColor = isThemeColor2;
})(ThemeColor || (ThemeColor = {}));
function $nk(id2) {
  return { id: id2 };
}
var ThemeIcon;
(function(ThemeIcon2) {
  ThemeIcon2.iconNameSegment = "[A-Za-z0-9]+";
  ThemeIcon2.iconNameExpression = "[A-Za-z0-9-]+";
  ThemeIcon2.iconModifierExpression = "~[A-Za-z]+";
  ThemeIcon2.iconNameCharacter = "[A-Za-z0-9~-]";
  const ThemeIconIdRegex = new RegExp(`^(${ThemeIcon2.iconNameExpression})(${ThemeIcon2.iconModifierExpression})?$`);
  function asClassNameArray(icon2) {
    const match = ThemeIconIdRegex.exec(icon2.id);
    if (!match) {
      return asClassNameArray($mk.error);
    }
    const [, id2, modifier] = match;
    const classNames = ["codicon", "codicon-" + id2];
    if (modifier) {
      classNames.push("codicon-modifier-" + modifier.substring(1));
    }
    return classNames;
  }
  ThemeIcon2.asClassNameArray = asClassNameArray;
  function asClassName(icon2) {
    return asClassNameArray(icon2).join(" ");
  }
  ThemeIcon2.asClassName = asClassName;
  function asCSSSelector(icon2) {
    return "." + asClassNameArray(icon2).join(".");
  }
  ThemeIcon2.asCSSSelector = asCSSSelector;
  function isThemeIcon(obj) {
    return obj && typeof obj === "object" && typeof obj.id === "string" && (typeof obj.color === "undefined" || ThemeColor.isThemeColor(obj.color));
  }
  ThemeIcon2.isThemeIcon = isThemeIcon;
  const _regexFromString = new RegExp(`^\\$\\((${ThemeIcon2.iconNameExpression}(?:${ThemeIcon2.iconModifierExpression})?)\\)$`);
  function fromString(str) {
    const match = _regexFromString.exec(str);
    if (!match) {
      return void 0;
    }
    const [, name] = match;
    return { id: name };
  }
  ThemeIcon2.fromString = fromString;
  function fromId(id2) {
    return { id: id2 };
  }
  ThemeIcon2.fromId = fromId;
  function modify(icon2, modifier) {
    let id2 = icon2.id;
    const tildeIndex = id2.lastIndexOf("~");
    if (tildeIndex !== -1) {
      id2 = id2.substring(0, tildeIndex);
    }
    if (modifier) {
      id2 = `${id2}~${modifier}`;
    }
    return { id: id2 };
  }
  ThemeIcon2.modify = modify;
  function getModifier(icon2) {
    const tildeIndex = icon2.id.lastIndexOf("~");
    if (tildeIndex !== -1) {
      return icon2.id.substring(tildeIndex + 1);
    }
    return void 0;
  }
  ThemeIcon2.getModifier = getModifier;
  function isEqual2(ti1, ti2) {
    return ti1.id === ti2.id && ti1.color?.id === ti2.color?.id;
  }
  ThemeIcon2.isEqual = isEqual2;
})(ThemeIcon || (ThemeIcon = {}));

// out-build/vs/platform/commands/common/commands.js
var $qk = $Zi("commandService");
var $rk = new class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
    this.b = new $De();
    this.onDidRegisterCommand = this.b.event;
  }
  registerCommand(idOrCommand, handler) {
    if (!idOrCommand) {
      throw new Error(`invalid command`);
    }
    if (typeof idOrCommand === "string") {
      if (!handler) {
        throw new Error(`invalid command`);
      }
      return this.registerCommand({ id: idOrCommand, handler });
    }
    if (idOrCommand.metadata && Array.isArray(idOrCommand.metadata.args)) {
      const constraints = [];
      for (const arg of idOrCommand.metadata.args) {
        constraints.push(arg.constraint);
      }
      const actualHandler = idOrCommand.handler;
      idOrCommand.handler = function(accessor, ...args2) {
        $Og(args2, constraints);
        return actualHandler(accessor, ...args2);
      };
    }
    const { id: id2 } = idOrCommand;
    let commands = this.a.get(id2);
    if (!commands) {
      commands = new $hd();
      this.a.set(id2, commands);
    }
    const removeFn = commands.unshift(idOrCommand);
    const ret = $8c(() => {
      removeFn();
      const command4 = this.a.get(id2);
      if (command4?.isEmpty()) {
        this.a.delete(id2);
      }
    });
    this.b.fire(id2);
    return ret;
  }
  registerCommandAlias(oldId, newId) {
    return $rk.registerCommand(oldId, (accessor, ...args2) => accessor.get($qk).executeCommand(newId, ...args2));
  }
  getCommand(id2) {
    const list4 = this.a.get(id2);
    if (!list4 || list4.isEmpty()) {
      return void 0;
    }
    return Iterable.first(list4);
  }
  getCommands() {
    const result = /* @__PURE__ */ new Map();
    for (const key of this.a.keys()) {
      const command4 = this.getCommand(key);
      if (command4) {
        result.set(key, command4);
      }
    }
    return result;
  }
}();
$rk.registerCommand("noop", () => {
});

// out-build/vs/platform/contextkey/common/scanner.js
var TokenType;
(function(TokenType4) {
  TokenType4[TokenType4["LParen"] = 0] = "LParen";
  TokenType4[TokenType4["RParen"] = 1] = "RParen";
  TokenType4[TokenType4["Neg"] = 2] = "Neg";
  TokenType4[TokenType4["Eq"] = 3] = "Eq";
  TokenType4[TokenType4["NotEq"] = 4] = "NotEq";
  TokenType4[TokenType4["Lt"] = 5] = "Lt";
  TokenType4[TokenType4["LtEq"] = 6] = "LtEq";
  TokenType4[TokenType4["Gt"] = 7] = "Gt";
  TokenType4[TokenType4["GtEq"] = 8] = "GtEq";
  TokenType4[TokenType4["RegexOp"] = 9] = "RegexOp";
  TokenType4[TokenType4["RegexStr"] = 10] = "RegexStr";
  TokenType4[TokenType4["True"] = 11] = "True";
  TokenType4[TokenType4["False"] = 12] = "False";
  TokenType4[TokenType4["In"] = 13] = "In";
  TokenType4[TokenType4["Not"] = 14] = "Not";
  TokenType4[TokenType4["And"] = 15] = "And";
  TokenType4[TokenType4["Or"] = 16] = "Or";
  TokenType4[TokenType4["Str"] = 17] = "Str";
  TokenType4[TokenType4["QuotedStr"] = 18] = "QuotedStr";
  TokenType4[TokenType4["Error"] = 19] = "Error";
  TokenType4[TokenType4["EOF"] = 20] = "EOF";
})(TokenType || (TokenType = {}));
function hintDidYouMean(...meant) {
  switch (meant.length) {
    case 1:
      return localize(1703, null, meant[0]);
    case 2:
      return localize(1704, null, meant[0], meant[1]);
    case 3:
      return localize(1705, null, meant[0], meant[1], meant[2]);
    default:
      return void 0;
  }
}
var hintDidYouForgetToOpenOrCloseQuote = localize(1706, null);
var hintDidYouForgetToEscapeSlash = localize(1707, null);
var $Uj = class _$Uj {
  constructor() {
    this.c = "";
    this.d = 0;
    this.e = 0;
    this.f = [];
    this.g = [];
    this.m = /[a-zA-Z0-9_<>\-\./\\:\*\?\+\[\]\^,#@;"%\$\p{L}-]+/uy;
  }
  static getLexeme(token) {
    switch (token.type) {
      case 0:
        return "(";
      case 1:
        return ")";
      case 2:
        return "!";
      case 3:
        return token.isTripleEq ? "===" : "==";
      case 4:
        return token.isTripleEq ? "!==" : "!=";
      case 5:
        return "<";
      case 6:
        return "<=";
      case 7:
        return ">=";
      case 8:
        return ">=";
      case 9:
        return "=~";
      case 10:
        return token.lexeme;
      case 11:
        return "true";
      case 12:
        return "false";
      case 13:
        return "in";
      case 14:
        return "not";
      case 15:
        return "&&";
      case 16:
        return "||";
      case 17:
        return token.lexeme;
      case 18:
        return token.lexeme;
      case 19:
        return token.lexeme;
      case 20:
        return "EOF";
      default:
        throw $ib(`unhandled token type: ${JSON.stringify(token)}; have you forgotten to add a case?`);
    }
  }
  static {
    this.a = new Set(["i", "g", "s", "m", "y", "u"].map((ch) => ch.charCodeAt(0)));
  }
  static {
    this.b = /* @__PURE__ */ new Map([
      [
        "not",
        14
        /* TokenType.Not */
      ],
      [
        "in",
        13
        /* TokenType.In */
      ],
      [
        "false",
        12
        /* TokenType.False */
      ],
      [
        "true",
        11
        /* TokenType.True */
      ]
    ]);
  }
  get errors() {
    return this.g;
  }
  reset(value) {
    this.c = value;
    this.d = 0;
    this.e = 0;
    this.f = [];
    this.g = [];
    return this;
  }
  scan() {
    while (!this.r()) {
      this.d = this.e;
      const ch = this.i();
      switch (ch) {
        case 40:
          this.k(
            0
            /* TokenType.LParen */
          );
          break;
        case 41:
          this.k(
            1
            /* TokenType.RParen */
          );
          break;
        case 33:
          if (this.h(
            61
            /* CharCode.Equals */
          )) {
            const isTripleEq = this.h(
              61
              /* CharCode.Equals */
            );
            this.f.push({ type: 4, offset: this.d, isTripleEq });
          } else {
            this.k(
              2
              /* TokenType.Neg */
            );
          }
          break;
        case 39:
          this.o();
          break;
        case 47:
          this.q();
          break;
        case 61:
          if (this.h(
            61
            /* CharCode.Equals */
          )) {
            const isTripleEq = this.h(
              61
              /* CharCode.Equals */
            );
            this.f.push({ type: 3, offset: this.d, isTripleEq });
          } else if (this.h(
            126
            /* CharCode.Tilde */
          )) {
            this.k(
              9
              /* TokenType.RegexOp */
            );
          } else {
            this.l(hintDidYouMean("==", "=~"));
          }
          break;
        case 60:
          this.k(
            this.h(
              61
              /* CharCode.Equals */
            ) ? 6 : 5
            /* TokenType.Lt */
          );
          break;
        case 62:
          this.k(
            this.h(
              61
              /* CharCode.Equals */
            ) ? 8 : 7
            /* TokenType.Gt */
          );
          break;
        case 38:
          if (this.h(
            38
            /* CharCode.Ampersand */
          )) {
            this.k(
              15
              /* TokenType.And */
            );
          } else {
            this.l(hintDidYouMean("&&"));
          }
          break;
        case 124:
          if (this.h(
            124
            /* CharCode.Pipe */
          )) {
            this.k(
              16
              /* TokenType.Or */
            );
          } else {
            this.l(hintDidYouMean("||"));
          }
          break;
        case 32:
        case 13:
        case 9:
        case 10:
        case 160:
          break;
        default:
          this.n();
      }
    }
    this.d = this.e;
    this.k(
      20
      /* TokenType.EOF */
    );
    return Array.from(this.f);
  }
  h(expected) {
    if (this.r()) {
      return false;
    }
    if (this.c.charCodeAt(this.e) !== expected) {
      return false;
    }
    this.e++;
    return true;
  }
  i() {
    return this.c.charCodeAt(this.e++);
  }
  j() {
    return this.r() ? 0 : this.c.charCodeAt(this.e);
  }
  k(type) {
    this.f.push({ type, offset: this.d });
  }
  l(additional) {
    const offset = this.d;
    const lexeme = this.c.substring(this.d, this.e);
    const errToken = { type: 19, offset: this.d, lexeme };
    this.g.push({ offset, lexeme, additionalInfo: additional });
    this.f.push(errToken);
  }
  n() {
    this.m.lastIndex = this.d;
    const match = this.m.exec(this.c);
    if (match) {
      this.e = this.d + match[0].length;
      const lexeme = this.c.substring(this.d, this.e);
      const keyword = _$Uj.b.get(lexeme);
      if (keyword) {
        this.k(keyword);
      } else {
        this.f.push({ type: 17, lexeme, offset: this.d });
      }
    }
  }
  // captures the lexeme without the leading and trailing '
  o() {
    while (this.j() !== 39 && !this.r()) {
      this.i();
    }
    if (this.r()) {
      this.l(hintDidYouForgetToOpenOrCloseQuote);
      return;
    }
    this.i();
    this.f.push({ type: 18, lexeme: this.c.substring(this.d + 1, this.e - 1), offset: this.d + 1 });
  }
  /*
   * Lexing a regex expression: /.../[igsmyu]*
   * Based on https://github.com/microsoft/TypeScript/blob/9247ef115e617805983740ba795d7a8164babf89/src/compiler/scanner.ts#L2129-L2181
   *
   * Note that we want slashes within a regex to be escaped, e.g., /file:\\/\\/\\// should match `file:///`
   */
  q() {
    let p = this.e;
    let inEscape = false;
    let inCharacterClass = false;
    while (true) {
      if (p >= this.c.length) {
        this.e = p;
        this.l(hintDidYouForgetToEscapeSlash);
        return;
      }
      const ch = this.c.charCodeAt(p);
      if (inEscape) {
        inEscape = false;
      } else if (ch === 47 && !inCharacterClass) {
        p++;
        break;
      } else if (ch === 91) {
        inCharacterClass = true;
      } else if (ch === 92) {
        inEscape = true;
      } else if (ch === 93) {
        inCharacterClass = false;
      }
      p++;
    }
    while (p < this.c.length && _$Uj.a.has(this.c.charCodeAt(p))) {
      p++;
    }
    this.e = p;
    const lexeme = this.c.substring(this.d, this.e);
    this.f.push({ type: 10, lexeme, offset: this.d });
  }
  r() {
    return this.e >= this.c.length;
  }
};

// out-build/vs/platform/contextkey/common/contextkey.js
var CONSTANT_VALUES = /* @__PURE__ */ new Map();
CONSTANT_VALUES.set("false", false);
CONSTANT_VALUES.set("true", true);
CONSTANT_VALUES.set("isMac", $m);
CONSTANT_VALUES.set("isLinux", $n);
CONSTANT_VALUES.set("isWindows", $l);
CONSTANT_VALUES.set("isWeb", $r);
CONSTANT_VALUES.set("isMacNative", $m && !$r);
CONSTANT_VALUES.set("isEdge", $K);
CONSTANT_VALUES.set("isFirefox", $I);
CONSTANT_VALUES.set("isChrome", $H);
CONSTANT_VALUES.set("isSafari", $J);
function $Vj(key, value) {
  if (CONSTANT_VALUES.get(key) !== void 0) {
    throw $hb("contextkey.setConstant(k, v) invoked with already set constant `k`");
  }
  CONSTANT_VALUES.set(key, value);
}
var hasOwnProperty2 = Object.prototype.hasOwnProperty;
var ContextKeyExprType;
(function(ContextKeyExprType2) {
  ContextKeyExprType2[ContextKeyExprType2["False"] = 0] = "False";
  ContextKeyExprType2[ContextKeyExprType2["True"] = 1] = "True";
  ContextKeyExprType2[ContextKeyExprType2["Defined"] = 2] = "Defined";
  ContextKeyExprType2[ContextKeyExprType2["Not"] = 3] = "Not";
  ContextKeyExprType2[ContextKeyExprType2["Equals"] = 4] = "Equals";
  ContextKeyExprType2[ContextKeyExprType2["NotEquals"] = 5] = "NotEquals";
  ContextKeyExprType2[ContextKeyExprType2["And"] = 6] = "And";
  ContextKeyExprType2[ContextKeyExprType2["Regex"] = 7] = "Regex";
  ContextKeyExprType2[ContextKeyExprType2["NotRegex"] = 8] = "NotRegex";
  ContextKeyExprType2[ContextKeyExprType2["Or"] = 9] = "Or";
  ContextKeyExprType2[ContextKeyExprType2["In"] = 10] = "In";
  ContextKeyExprType2[ContextKeyExprType2["NotIn"] = 11] = "NotIn";
  ContextKeyExprType2[ContextKeyExprType2["Greater"] = 12] = "Greater";
  ContextKeyExprType2[ContextKeyExprType2["GreaterEquals"] = 13] = "GreaterEquals";
  ContextKeyExprType2[ContextKeyExprType2["Smaller"] = 14] = "Smaller";
  ContextKeyExprType2[ContextKeyExprType2["SmallerEquals"] = 15] = "SmallerEquals";
})(ContextKeyExprType || (ContextKeyExprType = {}));
var defaultConfig = {
  regexParsingWithErrorRecovery: true
};
var errorEmptyString = localize(1683, null);
var hintEmptyString = localize(1684, null);
var errorNoInAfterNot = localize(1685, null);
var errorClosingParenthesis = localize(1686, null);
var errorUnexpectedToken = localize(1687, null);
var hintUnexpectedToken = localize(1688, null);
var errorUnexpectedEOF = localize(1689, null);
var hintUnexpectedEOF = localize(1690, null);
var $Wj = class _$Wj {
  static {
    this.c = new Error();
  }
  get lexingErrors() {
    return this.d.errors;
  }
  get parsingErrors() {
    return this.h;
  }
  constructor(k = defaultConfig) {
    this.k = k;
    this.d = new $Uj();
    this.f = [];
    this.g = 0;
    this.h = [];
    this.v = /g|y/g;
  }
  /**
   * Parse a context key expression.
   *
   * @param input the expression to parse
   * @returns the parsed expression or `undefined` if there's an error - call `lexingErrors` and `parsingErrors` to see the errors
   */
  parse(input) {
    if (input === "") {
      this.h.push({ message: errorEmptyString, offset: 0, lexeme: "", additionalInfo: hintEmptyString });
      return void 0;
    }
    this.f = this.d.reset(input).scan();
    this.g = 0;
    this.h = [];
    try {
      const expr = this.l();
      if (!this.E()) {
        const peek = this.D();
        const additionalInfo = peek.type === 17 ? hintUnexpectedToken : void 0;
        this.h.push({ message: errorUnexpectedToken, offset: peek.offset, lexeme: $Uj.getLexeme(peek), additionalInfo });
        throw _$Wj.c;
      }
      return expr;
    } catch (e) {
      if (!(e === _$Wj.c)) {
        throw e;
      }
      return void 0;
    }
  }
  l() {
    return this.m();
  }
  m() {
    const expr = [this.o()];
    while (this.y(
      16
      /* TokenType.Or */
    )) {
      const right = this.o();
      expr.push(right);
    }
    return expr.length === 1 ? expr[0] : $Xj.or(...expr);
  }
  o() {
    const expr = [this.s()];
    while (this.y(
      15
      /* TokenType.And */
    )) {
      const right = this.s();
      expr.push(right);
    }
    return expr.length === 1 ? expr[0] : $Xj.and(...expr);
  }
  s() {
    if (this.y(
      2
      /* TokenType.Neg */
    )) {
      const peek = this.D();
      switch (peek.type) {
        case 11:
          this.z();
          return $1j.INSTANCE;
        case 12:
          this.z();
          return $2j.INSTANCE;
        case 0: {
          this.z();
          const expr = this.l();
          this.A(1, errorClosingParenthesis);
          return expr?.negate();
        }
        case 17:
          this.z();
          return $8j.create(peek.lexeme);
        default:
          throw this.B(`KEY | true | false | '(' expression ')'`, peek);
      }
    }
    return this.t();
  }
  t() {
    const peek = this.D();
    switch (peek.type) {
      case 11:
        this.z();
        return $Xj.true();
      case 12:
        this.z();
        return $Xj.false();
      case 0: {
        this.z();
        const expr = this.l();
        this.A(1, errorClosingParenthesis);
        return expr;
      }
      case 17: {
        const key = peek.lexeme;
        this.z();
        if (this.y(
          9
          /* TokenType.RegexOp */
        )) {
          const expr = this.D();
          if (!this.k.regexParsingWithErrorRecovery) {
            this.z();
            if (expr.type !== 10) {
              throw this.B(`REGEX`, expr);
            }
            const regexLexeme = expr.lexeme;
            const closingSlashIndex = regexLexeme.lastIndexOf("/");
            const flags = closingSlashIndex === regexLexeme.length - 1 ? void 0 : this.w(regexLexeme.substring(closingSlashIndex + 1));
            let regexp;
            try {
              regexp = new RegExp(regexLexeme.substring(1, closingSlashIndex), flags);
            } catch (e) {
              throw this.B(`REGEX`, expr);
            }
            return $ak.create(key, regexp);
          }
          switch (expr.type) {
            case 10:
            case 19: {
              const lexemeReconstruction = [expr.lexeme];
              this.z();
              let followingToken = this.D();
              let parenBalance = 0;
              for (let i = 0; i < expr.lexeme.length; i++) {
                if (expr.lexeme.charCodeAt(i) === 40) {
                  parenBalance++;
                } else if (expr.lexeme.charCodeAt(i) === 41) {
                  parenBalance--;
                }
              }
              while (!this.E() && followingToken.type !== 15 && followingToken.type !== 16) {
                switch (followingToken.type) {
                  case 0:
                    parenBalance++;
                    break;
                  case 1:
                    parenBalance--;
                    break;
                  case 10:
                  case 18:
                    for (let i = 0; i < followingToken.lexeme.length; i++) {
                      if (followingToken.lexeme.charCodeAt(i) === 40) {
                        parenBalance++;
                      } else if (expr.lexeme.charCodeAt(i) === 41) {
                        parenBalance--;
                      }
                    }
                }
                if (parenBalance < 0) {
                  break;
                }
                lexemeReconstruction.push($Uj.getLexeme(followingToken));
                this.z();
                followingToken = this.D();
              }
              const regexLexeme = lexemeReconstruction.join("");
              const closingSlashIndex = regexLexeme.lastIndexOf("/");
              const flags = closingSlashIndex === regexLexeme.length - 1 ? void 0 : this.w(regexLexeme.substring(closingSlashIndex + 1));
              let regexp;
              try {
                regexp = new RegExp(regexLexeme.substring(1, closingSlashIndex), flags);
              } catch (e) {
                throw this.B(`REGEX`, expr);
              }
              return $Xj.regex(key, regexp);
            }
            case 18: {
              const serializedValue = expr.lexeme;
              this.z();
              let regex = null;
              if (!$vf(serializedValue)) {
                const start = serializedValue.indexOf("/");
                const end = serializedValue.lastIndexOf("/");
                if (start !== end && start >= 0) {
                  const value = serializedValue.slice(start + 1, end);
                  const caseIgnoreFlag = serializedValue[end + 1] === "i" ? "i" : "";
                  try {
                    regex = new RegExp(value, caseIgnoreFlag);
                  } catch (_e) {
                    throw this.B(`REGEX`, expr);
                  }
                }
              }
              if (regex === null) {
                throw this.B("REGEX", expr);
              }
              return $ak.create(key, regex);
            }
            default:
              throw this.B("REGEX", this.D());
          }
        }
        if (this.y(
          14
          /* TokenType.Not */
        )) {
          this.A(13, errorNoInAfterNot);
          const right = this.u();
          return $Xj.notIn(key, right);
        }
        const maybeOp = this.D().type;
        switch (maybeOp) {
          case 3: {
            this.z();
            const right = this.u();
            if (this.x().type === 18) {
              return $Xj.equals(key, right);
            }
            switch (right) {
              case "true":
                return $Xj.has(key);
              case "false":
                return $Xj.not(key);
              default:
                return $Xj.equals(key, right);
            }
          }
          case 4: {
            this.z();
            const right = this.u();
            if (this.x().type === 18) {
              return $Xj.notEquals(key, right);
            }
            switch (right) {
              case "true":
                return $Xj.not(key);
              case "false":
                return $Xj.has(key);
              default:
                return $Xj.notEquals(key, right);
            }
          }
          case 5:
            this.z();
            return $$j.create(key, this.u());
          case 6:
            this.z();
            return $_j.create(key, this.u());
          case 7:
            this.z();
            return $9j.create(key, this.u());
          case 8:
            this.z();
            return $0j.create(key, this.u());
          case 13:
            this.z();
            return $Xj.in(key, this.u());
          default:
            return $Xj.has(key);
        }
      }
      case 20:
        this.h.push({ message: errorUnexpectedEOF, offset: peek.offset, lexeme: "", additionalInfo: hintUnexpectedEOF });
        throw _$Wj.c;
      default:
        throw this.B(`true | false | KEY 
	| KEY '=~' REGEX 
	| KEY ('==' | '!=' | '<' | '<=' | '>' | '>=' | 'in' | 'not' 'in') value`, this.D());
    }
  }
  u() {
    const token = this.D();
    switch (token.type) {
      case 17:
      case 18:
        this.z();
        return token.lexeme;
      case 11:
        this.z();
        return "true";
      case 12:
        this.z();
        return "false";
      case 13:
        this.z();
        return "in";
      default:
        return "";
    }
  }
  w(flags) {
    return flags.replaceAll(this.v, "");
  }
  // careful: this can throw if current token is the initial one (ie index = 0)
  x() {
    return this.f[this.g - 1];
  }
  y(token) {
    if (this.C(token)) {
      this.z();
      return true;
    }
    return false;
  }
  z() {
    if (!this.E()) {
      this.g++;
    }
    return this.x();
  }
  A(type, message) {
    if (this.C(type)) {
      return this.z();
    }
    throw this.B(message, this.D());
  }
  B(expected, got, additionalInfo) {
    const message = localize(1691, null, expected, $Uj.getLexeme(got));
    const offset = got.offset;
    const lexeme = $Uj.getLexeme(got);
    this.h.push({ message, offset, lexeme, additionalInfo });
    return _$Wj.c;
  }
  C(type) {
    return this.D().type === type;
  }
  D() {
    return this.f[this.g];
  }
  E() {
    return this.D().type === 20;
  }
};
var $Xj = class {
  static false() {
    return $1j.INSTANCE;
  }
  static true() {
    return $2j.INSTANCE;
  }
  static has(key) {
    return $3j.create(key);
  }
  static equals(key, value) {
    return $4j.create(key, value);
  }
  static notEquals(key, value) {
    return $7j.create(key, value);
  }
  static regex(key, value) {
    return $ak.create(key, value);
  }
  static in(key, value) {
    return $5j.create(key, value);
  }
  static notIn(key, value) {
    return $6j.create(key, value);
  }
  static not(key) {
    return $8j.create(key);
  }
  static and(...expr) {
    return $ck.create(expr, null, true);
  }
  static or(...expr) {
    return $dk.create(expr, null, true);
  }
  static greater(key, value) {
    return $9j.create(key, value);
  }
  static greaterEquals(key, value) {
    return $0j.create(key, value);
  }
  static smaller(key, value) {
    return $$j.create(key, value);
  }
  static smallerEquals(key, value) {
    return $_j.create(key, value);
  }
  static {
    this.c = new $Wj({ regexParsingWithErrorRecovery: false });
  }
  static deserialize(serialized) {
    if (serialized === void 0 || serialized === null) {
      return void 0;
    }
    const expr = this.c.parse(serialized);
    return expr;
  }
};
function $Zj(a, b) {
  const aExpr = a ? a.substituteConstants() : void 0;
  const bExpr = b ? b.substituteConstants() : void 0;
  if (!aExpr && !bExpr) {
    return true;
  }
  if (!aExpr || !bExpr) {
    return false;
  }
  return aExpr.equals(bExpr);
}
function cmp(a, b) {
  return a.cmp(b);
}
var $1j = class _$1j {
  static {
    this.INSTANCE = new _$1j();
  }
  constructor() {
    this.type = 0;
  }
  cmp(other4) {
    return this.type - other4.type;
  }
  equals(other4) {
    return other4.type === this.type;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    return false;
  }
  serialize() {
    return "false";
  }
  keys() {
    return [];
  }
  map(mapFnc) {
    return this;
  }
  negate() {
    return $2j.INSTANCE;
  }
};
var $2j = class _$2j {
  static {
    this.INSTANCE = new _$2j();
  }
  constructor() {
    this.type = 1;
  }
  cmp(other4) {
    return this.type - other4.type;
  }
  equals(other4) {
    return other4.type === this.type;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    return true;
  }
  serialize() {
    return "true";
  }
  keys() {
    return [];
  }
  map(mapFnc) {
    return this;
  }
  negate() {
    return $1j.INSTANCE;
  }
};
var $3j = class _$3j {
  static create(key, negated = null) {
    const constantValue = CONSTANT_VALUES.get(key);
    if (typeof constantValue === "boolean") {
      return constantValue ? $2j.INSTANCE : $1j.INSTANCE;
    }
    return new _$3j(key, negated);
  }
  constructor(key, c) {
    this.key = key;
    this.c = c;
    this.type = 2;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp1(this.key, other4.key);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.key === other4.key;
    }
    return false;
  }
  substituteConstants() {
    const constantValue = CONSTANT_VALUES.get(this.key);
    if (typeof constantValue === "boolean") {
      return constantValue ? $2j.INSTANCE : $1j.INSTANCE;
    }
    return this;
  }
  evaluate(context) {
    return !!context.getValue(this.key);
  }
  serialize() {
    return this.key;
  }
  keys() {
    return [this.key];
  }
  map(mapFnc) {
    return mapFnc.mapDefined(this.key);
  }
  negate() {
    if (!this.c) {
      this.c = $8j.create(this.key, this);
    }
    return this.c;
  }
};
var $4j = class _$4j {
  static create(key, value, negated = null) {
    if (typeof value === "boolean") {
      return value ? $3j.create(key, negated) : $8j.create(key, negated);
    }
    const constantValue = CONSTANT_VALUES.get(key);
    if (typeof constantValue === "boolean") {
      const trueValue = constantValue ? "true" : "false";
      return value === trueValue ? $2j.INSTANCE : $1j.INSTANCE;
    }
    return new _$4j(key, value, negated);
  }
  constructor(c, d, f) {
    this.c = c;
    this.d = d;
    this.f = f;
    this.type = 4;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp2(this.c, this.d, other4.c, other4.d);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c === other4.c && this.d === other4.d;
    }
    return false;
  }
  substituteConstants() {
    const constantValue = CONSTANT_VALUES.get(this.c);
    if (typeof constantValue === "boolean") {
      const trueValue = constantValue ? "true" : "false";
      return this.d === trueValue ? $2j.INSTANCE : $1j.INSTANCE;
    }
    return this;
  }
  evaluate(context) {
    return context.getValue(this.c) == this.d;
  }
  serialize() {
    return `${this.c} == '${this.d}'`;
  }
  keys() {
    return [this.c];
  }
  map(mapFnc) {
    return mapFnc.mapEquals(this.c, this.d);
  }
  negate() {
    if (!this.f) {
      this.f = $7j.create(this.c, this.d, this);
    }
    return this.f;
  }
};
var $5j = class _$5j {
  static create(key, valueKey) {
    return new _$5j(key, valueKey);
  }
  constructor(d, f) {
    this.d = d;
    this.f = f;
    this.type = 10;
    this.c = null;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp2(this.d, this.f, other4.d, other4.f);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.d === other4.d && this.f === other4.f;
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    const source = context.getValue(this.f);
    const item = context.getValue(this.d);
    if (Array.isArray(source)) {
      return source.includes(item);
    }
    if (typeof item === "string" && typeof source === "object" && source !== null) {
      return hasOwnProperty2.call(source, item);
    }
    return false;
  }
  serialize() {
    return `${this.d} in '${this.f}'`;
  }
  keys() {
    return [this.d, this.f];
  }
  map(mapFnc) {
    return mapFnc.mapIn(this.d, this.f);
  }
  negate() {
    if (!this.c) {
      this.c = $6j.create(this.d, this.f);
    }
    return this.c;
  }
};
var $6j = class _$6j {
  static create(key, valueKey) {
    return new _$6j(key, valueKey);
  }
  constructor(d, f) {
    this.d = d;
    this.f = f;
    this.type = 11;
    this.c = $5j.create(d, f);
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return this.c.cmp(other4.c);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c.equals(other4.c);
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    return !this.c.evaluate(context);
  }
  serialize() {
    return `${this.d} not in '${this.f}'`;
  }
  keys() {
    return this.c.keys();
  }
  map(mapFnc) {
    return mapFnc.mapNotIn(this.d, this.f);
  }
  negate() {
    return this.c;
  }
};
var $7j = class _$7j {
  static create(key, value, negated = null) {
    if (typeof value === "boolean") {
      if (value) {
        return $8j.create(key, negated);
      }
      return $3j.create(key, negated);
    }
    const constantValue = CONSTANT_VALUES.get(key);
    if (typeof constantValue === "boolean") {
      const falseValue = constantValue ? "true" : "false";
      return value === falseValue ? $1j.INSTANCE : $2j.INSTANCE;
    }
    return new _$7j(key, value, negated);
  }
  constructor(c, d, f) {
    this.c = c;
    this.d = d;
    this.f = f;
    this.type = 5;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp2(this.c, this.d, other4.c, other4.d);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c === other4.c && this.d === other4.d;
    }
    return false;
  }
  substituteConstants() {
    const constantValue = CONSTANT_VALUES.get(this.c);
    if (typeof constantValue === "boolean") {
      const falseValue = constantValue ? "true" : "false";
      return this.d === falseValue ? $1j.INSTANCE : $2j.INSTANCE;
    }
    return this;
  }
  evaluate(context) {
    return context.getValue(this.c) != this.d;
  }
  serialize() {
    return `${this.c} != '${this.d}'`;
  }
  keys() {
    return [this.c];
  }
  map(mapFnc) {
    return mapFnc.mapNotEquals(this.c, this.d);
  }
  negate() {
    if (!this.f) {
      this.f = $4j.create(this.c, this.d, this);
    }
    return this.f;
  }
};
var $8j = class _$8j {
  static create(key, negated = null) {
    const constantValue = CONSTANT_VALUES.get(key);
    if (typeof constantValue === "boolean") {
      return constantValue ? $1j.INSTANCE : $2j.INSTANCE;
    }
    return new _$8j(key, negated);
  }
  constructor(c, d) {
    this.c = c;
    this.d = d;
    this.type = 3;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp1(this.c, other4.c);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c === other4.c;
    }
    return false;
  }
  substituteConstants() {
    const constantValue = CONSTANT_VALUES.get(this.c);
    if (typeof constantValue === "boolean") {
      return constantValue ? $1j.INSTANCE : $2j.INSTANCE;
    }
    return this;
  }
  evaluate(context) {
    return !context.getValue(this.c);
  }
  serialize() {
    return `!${this.c}`;
  }
  keys() {
    return [this.c];
  }
  map(mapFnc) {
    return mapFnc.mapNot(this.c);
  }
  negate() {
    if (!this.d) {
      this.d = $3j.create(this.c, this);
    }
    return this.d;
  }
};
function withFloatOrStr(value, callback) {
  if (typeof value === "string") {
    const n = parseFloat(value);
    if (!isNaN(n)) {
      value = n;
    }
  }
  if (typeof value === "string" || typeof value === "number") {
    return callback(value);
  }
  return $1j.INSTANCE;
}
var $9j = class _$9j {
  static create(key, _value, negated = null) {
    return withFloatOrStr(_value, (value) => new _$9j(key, value, negated));
  }
  constructor(c, d, f) {
    this.c = c;
    this.d = d;
    this.f = f;
    this.type = 12;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp2(this.c, this.d, other4.c, other4.d);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c === other4.c && this.d === other4.d;
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    if (typeof this.d === "string") {
      return false;
    }
    return parseFloat(context.getValue(this.c)) > this.d;
  }
  serialize() {
    return `${this.c} > ${this.d}`;
  }
  keys() {
    return [this.c];
  }
  map(mapFnc) {
    return mapFnc.mapGreater(this.c, this.d);
  }
  negate() {
    if (!this.f) {
      this.f = $_j.create(this.c, this.d, this);
    }
    return this.f;
  }
};
var $0j = class _$0j {
  static create(key, _value, negated = null) {
    return withFloatOrStr(_value, (value) => new _$0j(key, value, negated));
  }
  constructor(c, d, f) {
    this.c = c;
    this.d = d;
    this.f = f;
    this.type = 13;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp2(this.c, this.d, other4.c, other4.d);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c === other4.c && this.d === other4.d;
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    if (typeof this.d === "string") {
      return false;
    }
    return parseFloat(context.getValue(this.c)) >= this.d;
  }
  serialize() {
    return `${this.c} >= ${this.d}`;
  }
  keys() {
    return [this.c];
  }
  map(mapFnc) {
    return mapFnc.mapGreaterEquals(this.c, this.d);
  }
  negate() {
    if (!this.f) {
      this.f = $$j.create(this.c, this.d, this);
    }
    return this.f;
  }
};
var $$j = class _$$j {
  static create(key, _value, negated = null) {
    return withFloatOrStr(_value, (value) => new _$$j(key, value, negated));
  }
  constructor(c, d, f) {
    this.c = c;
    this.d = d;
    this.f = f;
    this.type = 14;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp2(this.c, this.d, other4.c, other4.d);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c === other4.c && this.d === other4.d;
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    if (typeof this.d === "string") {
      return false;
    }
    return parseFloat(context.getValue(this.c)) < this.d;
  }
  serialize() {
    return `${this.c} < ${this.d}`;
  }
  keys() {
    return [this.c];
  }
  map(mapFnc) {
    return mapFnc.mapSmaller(this.c, this.d);
  }
  negate() {
    if (!this.f) {
      this.f = $0j.create(this.c, this.d, this);
    }
    return this.f;
  }
};
var $_j = class _$_j {
  static create(key, _value, negated = null) {
    return withFloatOrStr(_value, (value) => new _$_j(key, value, negated));
  }
  constructor(c, d, f) {
    this.c = c;
    this.d = d;
    this.f = f;
    this.type = 15;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return cmp2(this.c, this.d, other4.c, other4.d);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c === other4.c && this.d === other4.d;
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    if (typeof this.d === "string") {
      return false;
    }
    return parseFloat(context.getValue(this.c)) <= this.d;
  }
  serialize() {
    return `${this.c} <= ${this.d}`;
  }
  keys() {
    return [this.c];
  }
  map(mapFnc) {
    return mapFnc.mapSmallerEquals(this.c, this.d);
  }
  negate() {
    if (!this.f) {
      this.f = $9j.create(this.c, this.d, this);
    }
    return this.f;
  }
};
var $ak = class _$ak {
  static create(key, regexp) {
    return new _$ak(key, regexp);
  }
  constructor(d, f) {
    this.d = d;
    this.f = f;
    this.type = 7;
    this.c = null;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    if (this.d < other4.d) {
      return -1;
    }
    if (this.d > other4.d) {
      return 1;
    }
    const thisSource = this.f ? this.f.source : "";
    const otherSource = other4.f ? other4.f.source : "";
    if (thisSource < otherSource) {
      return -1;
    }
    if (thisSource > otherSource) {
      return 1;
    }
    return 0;
  }
  equals(other4) {
    if (other4.type === this.type) {
      const thisSource = this.f ? this.f.source : "";
      const otherSource = other4.f ? other4.f.source : "";
      return this.d === other4.d && thisSource === otherSource;
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    const value = context.getValue(this.d);
    return this.f ? this.f.test(value) : false;
  }
  serialize() {
    const value = this.f ? `/${this.f.source}/${this.f.flags}` : "/invalid/";
    return `${this.d} =~ ${value}`;
  }
  keys() {
    return [this.d];
  }
  map(mapFnc) {
    return mapFnc.mapRegex(this.d, this.f);
  }
  negate() {
    if (!this.c) {
      this.c = $bk.create(this);
    }
    return this.c;
  }
};
var $bk = class _$bk {
  static create(actual) {
    return new _$bk(actual);
  }
  constructor(c) {
    this.c = c;
    this.type = 8;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    return this.c.cmp(other4.c);
  }
  equals(other4) {
    if (other4.type === this.type) {
      return this.c.equals(other4.c);
    }
    return false;
  }
  substituteConstants() {
    return this;
  }
  evaluate(context) {
    return !this.c.evaluate(context);
  }
  serialize() {
    return `!(${this.c.serialize()})`;
  }
  keys() {
    return this.c.keys();
  }
  map(mapFnc) {
    return new _$bk(this.c.map(mapFnc));
  }
  negate() {
    return this.c;
  }
};
function eliminateConstantsInArray(arr) {
  let newArr = null;
  for (let i = 0, len = arr.length; i < len; i++) {
    const newExpr = arr[i].substituteConstants();
    if (arr[i] !== newExpr) {
      if (newArr === null) {
        newArr = [];
        for (let j = 0; j < i; j++) {
          newArr[j] = arr[j];
        }
      }
    }
    if (newArr !== null) {
      newArr[i] = newExpr;
    }
  }
  if (newArr === null) {
    return arr;
  }
  return newArr;
}
var $ck = class _$ck {
  static create(_expr, negated, extraRedundantCheck) {
    return _$ck.d(_expr, negated, extraRedundantCheck);
  }
  constructor(expr, c) {
    this.expr = expr;
    this.c = c;
    this.type = 6;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    if (this.expr.length < other4.expr.length) {
      return -1;
    }
    if (this.expr.length > other4.expr.length) {
      return 1;
    }
    for (let i = 0, len = this.expr.length; i < len; i++) {
      const r2 = cmp(this.expr[i], other4.expr[i]);
      if (r2 !== 0) {
        return r2;
      }
    }
    return 0;
  }
  equals(other4) {
    if (other4.type === this.type) {
      if (this.expr.length !== other4.expr.length) {
        return false;
      }
      for (let i = 0, len = this.expr.length; i < len; i++) {
        if (!this.expr[i].equals(other4.expr[i])) {
          return false;
        }
      }
      return true;
    }
    return false;
  }
  substituteConstants() {
    const exprArr = eliminateConstantsInArray(this.expr);
    if (exprArr === this.expr) {
      return this;
    }
    return _$ck.create(exprArr, this.c, false);
  }
  evaluate(context) {
    for (let i = 0, len = this.expr.length; i < len; i++) {
      if (!this.expr[i].evaluate(context)) {
        return false;
      }
    }
    return true;
  }
  static d(arr, negated, extraRedundantCheck) {
    const expr = [];
    let hasTrue = false;
    for (const e of arr) {
      if (!e) {
        continue;
      }
      if (e.type === 1) {
        hasTrue = true;
        continue;
      }
      if (e.type === 0) {
        return $1j.INSTANCE;
      }
      if (e.type === 6) {
        expr.push(...e.expr);
        continue;
      }
      expr.push(e);
    }
    if (expr.length === 0 && hasTrue) {
      return $2j.INSTANCE;
    }
    if (expr.length === 0) {
      return void 0;
    }
    if (expr.length === 1) {
      return expr[0];
    }
    expr.sort(cmp);
    for (let i = 1; i < expr.length; i++) {
      if (expr[i - 1].equals(expr[i])) {
        expr.splice(i, 1);
        i--;
      }
    }
    if (expr.length === 1) {
      return expr[0];
    }
    while (expr.length > 1) {
      const lastElement = expr[expr.length - 1];
      if (lastElement.type !== 9) {
        break;
      }
      expr.pop();
      const secondToLastElement = expr.pop();
      const isFinished = expr.length === 0;
      const resultElement = $dk.create(lastElement.expr.map((el) => _$ck.create([el, secondToLastElement], null, extraRedundantCheck)), null, isFinished);
      if (resultElement) {
        expr.push(resultElement);
        expr.sort(cmp);
      }
    }
    if (expr.length === 1) {
      return expr[0];
    }
    if (extraRedundantCheck) {
      for (let i = 0; i < expr.length; i++) {
        for (let j = i + 1; j < expr.length; j++) {
          if (expr[i].negate().equals(expr[j])) {
            return $1j.INSTANCE;
          }
        }
      }
      if (expr.length === 1) {
        return expr[0];
      }
    }
    return new _$ck(expr, negated);
  }
  serialize() {
    return this.expr.map((e) => e.serialize()).join(" && ");
  }
  keys() {
    const result = [];
    for (const expr of this.expr) {
      result.push(...expr.keys());
    }
    return result;
  }
  map(mapFnc) {
    return new _$ck(this.expr.map((expr) => expr.map(mapFnc)), null);
  }
  negate() {
    if (!this.c) {
      const result = [];
      for (const expr of this.expr) {
        result.push(expr.negate());
      }
      this.c = $dk.create(result, this, true);
    }
    return this.c;
  }
};
var $dk = class _$dk {
  static create(_expr, negated, extraRedundantCheck) {
    return _$dk.d(_expr, negated, extraRedundantCheck);
  }
  constructor(expr, c) {
    this.expr = expr;
    this.c = c;
    this.type = 9;
  }
  cmp(other4) {
    if (other4.type !== this.type) {
      return this.type - other4.type;
    }
    if (this.expr.length < other4.expr.length) {
      return -1;
    }
    if (this.expr.length > other4.expr.length) {
      return 1;
    }
    for (let i = 0, len = this.expr.length; i < len; i++) {
      const r2 = cmp(this.expr[i], other4.expr[i]);
      if (r2 !== 0) {
        return r2;
      }
    }
    return 0;
  }
  equals(other4) {
    if (other4.type === this.type) {
      if (this.expr.length !== other4.expr.length) {
        return false;
      }
      for (let i = 0, len = this.expr.length; i < len; i++) {
        if (!this.expr[i].equals(other4.expr[i])) {
          return false;
        }
      }
      return true;
    }
    return false;
  }
  substituteConstants() {
    const exprArr = eliminateConstantsInArray(this.expr);
    if (exprArr === this.expr) {
      return this;
    }
    return _$dk.create(exprArr, this.c, false);
  }
  evaluate(context) {
    for (let i = 0, len = this.expr.length; i < len; i++) {
      if (this.expr[i].evaluate(context)) {
        return true;
      }
    }
    return false;
  }
  static d(arr, negated, extraRedundantCheck) {
    let expr = [];
    let hasFalse = false;
    if (arr) {
      for (let i = 0, len = arr.length; i < len; i++) {
        const e = arr[i];
        if (!e) {
          continue;
        }
        if (e.type === 0) {
          hasFalse = true;
          continue;
        }
        if (e.type === 1) {
          return $2j.INSTANCE;
        }
        if (e.type === 9) {
          expr = expr.concat(e.expr);
          continue;
        }
        expr.push(e);
      }
      if (expr.length === 0 && hasFalse) {
        return $1j.INSTANCE;
      }
      expr.sort(cmp);
    }
    if (expr.length === 0) {
      return void 0;
    }
    if (expr.length === 1) {
      return expr[0];
    }
    for (let i = 1; i < expr.length; i++) {
      if (expr[i - 1].equals(expr[i])) {
        expr.splice(i, 1);
        i--;
      }
    }
    if (expr.length === 1) {
      return expr[0];
    }
    if (extraRedundantCheck) {
      for (let i = 0; i < expr.length; i++) {
        for (let j = i + 1; j < expr.length; j++) {
          if (expr[i].negate().equals(expr[j])) {
            return $2j.INSTANCE;
          }
        }
      }
      if (expr.length === 1) {
        return expr[0];
      }
    }
    return new _$dk(expr, negated);
  }
  serialize() {
    return this.expr.map((e) => e.serialize()).join(" || ");
  }
  keys() {
    const result = [];
    for (const expr of this.expr) {
      result.push(...expr.keys());
    }
    return result;
  }
  map(mapFnc) {
    return new _$dk(this.expr.map((expr) => expr.map(mapFnc)), null);
  }
  negate() {
    if (!this.c) {
      const result = [];
      for (const expr of this.expr) {
        result.push(expr.negate());
      }
      while (result.length > 1) {
        const LEFT = result.shift();
        const RIGHT = result.shift();
        const all = [];
        for (const left of getTerminals(LEFT)) {
          for (const right of getTerminals(RIGHT)) {
            all.push($ck.create([left, right], null, false));
          }
        }
        result.unshift(_$dk.create(all, null, false));
      }
      this.c = _$dk.create(result, this, true);
    }
    return this.c;
  }
};
var $ek = class _$ek extends $3j {
  static {
    this.d = [];
  }
  static all() {
    return _$ek.d.values();
  }
  constructor(key, defaultValue, metaOrHide) {
    super(key, null);
    this.f = defaultValue;
    if (typeof metaOrHide === "object") {
      _$ek.d.push({ ...metaOrHide, key });
    } else if (metaOrHide !== true) {
      _$ek.d.push({ key, description: metaOrHide, type: defaultValue !== null && defaultValue !== void 0 ? typeof defaultValue : void 0 });
    }
  }
  bindTo(target) {
    return target.createKey(this.key, this.f);
  }
  getValue(target) {
    return target.getContextKeyValue(this.key);
  }
  toNegated() {
    return this.negate();
  }
  isEqualTo(value) {
    return $4j.create(this.key, value);
  }
  notEqualsTo(value) {
    return $7j.create(this.key, value);
  }
};
var $fk = $Zi("contextKeyService");
function cmp1(key1, key2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  return 0;
}
function cmp2(key1, value1, key2, value2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  if (value1 < value2) {
    return -1;
  }
  if (value1 > value2) {
    return 1;
  }
  return 0;
}
function $gk(p, q) {
  if (p.type === 0 || q.type === 1) {
    return true;
  }
  if (p.type === 9) {
    if (q.type === 9) {
      return allElementsIncluded(p.expr, q.expr);
    }
    return false;
  }
  if (q.type === 9) {
    for (const element of q.expr) {
      if ($gk(p, element)) {
        return true;
      }
    }
    return false;
  }
  if (p.type === 6) {
    if (q.type === 6) {
      return allElementsIncluded(q.expr, p.expr);
    }
    for (const element of p.expr) {
      if ($gk(element, q)) {
        return true;
      }
    }
    return false;
  }
  return p.equals(q);
}
function allElementsIncluded(p, q) {
  let pIndex = 0;
  let qIndex = 0;
  while (pIndex < p.length && qIndex < q.length) {
    const cmp4 = p[pIndex].cmp(q[qIndex]);
    if (cmp4 < 0) {
      return false;
    } else if (cmp4 === 0) {
      pIndex++;
      qIndex++;
    } else {
      qIndex++;
    }
  }
  return pIndex === p.length;
}
function getTerminals(node) {
  if (node.type === 9) {
    return node.expr;
  }
  return [node];
}

// out-build/vs/base/common/assert.js
function ok(value, message) {
  if (!value) {
    throw new Error(message ? `Assertion failed (${message})` : "Assertion Failed");
  }
}
function $md(value, message = "Unreachable") {
  throw new Error(message);
}
function $nd(condition, message = "unexpected state") {
  if (!condition) {
    throw new $pb(`Assertion Failed: ${message}`);
  }
}
function $od(condition) {
  if (!condition) {
    $ab(new $pb("Soft Assertion Failed"));
  }
}
function $pd(condition) {
  if (!condition()) {
    debugger;
    condition();
    $ab(new $pb("Assertion Failed"));
  }
}
function $qd(items, predicate) {
  let i = 0;
  while (i < items.length - 1) {
    const a = items[i];
    const b = items[i + 1];
    if (!predicate(a, b)) {
      return false;
    }
    i++;
  }
  return true;
}

// out-build/vs/platform/registry/common/platform.js
var RegistryImpl = class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
  }
  add(id2, data) {
    ok($yg(id2));
    ok($Ag(data));
    ok(!this.a.has(id2), "There is already an extension with this id");
    this.a.set(id2, data);
  }
  knows(id2) {
    return this.a.has(id2);
  }
  as(id2) {
    return this.a.get(id2) || null;
  }
};
var $Mo = new RegistryImpl();

// out-build/vs/platform/keybinding/common/keybindingsRegistry.js
var KeybindingWeight;
(function(KeybindingWeight2) {
  KeybindingWeight2[KeybindingWeight2["EditorCore"] = 0] = "EditorCore";
  KeybindingWeight2[KeybindingWeight2["EditorContrib"] = 100] = "EditorContrib";
  KeybindingWeight2[KeybindingWeight2["WorkbenchContrib"] = 200] = "WorkbenchContrib";
  KeybindingWeight2[KeybindingWeight2["BuiltinExtension"] = 300] = "BuiltinExtension";
  KeybindingWeight2[KeybindingWeight2["ExternalExtension"] = 400] = "ExternalExtension";
})(KeybindingWeight || (KeybindingWeight = {}));
var KeybindingsRegistryImpl = class _KeybindingsRegistryImpl {
  constructor() {
    this.c = new $hd();
    this.d = [];
    this.e = null;
  }
  /**
   * Take current platform into account and reduce to primary & secondary.
   */
  static f(kb) {
    if (OS === 1) {
      if (kb && kb.win) {
        return kb.win;
      }
    } else if (OS === 2) {
      if (kb && kb.mac) {
        return kb.mac;
      }
    } else {
      if (kb && kb.linux) {
        return kb.linux;
      }
    }
    return kb;
  }
  registerKeybindingRule(rule) {
    const actualKb = _KeybindingsRegistryImpl.f(rule);
    const result = new $9c();
    if (actualKb && actualKb.primary) {
      const kk = $js(actualKb.primary, OS);
      if (kk) {
        result.add(this.g(kk, rule.id, rule.args, rule.weight, 0, rule.when));
      }
    }
    if (actualKb && Array.isArray(actualKb.secondary)) {
      for (let i = 0, len = actualKb.secondary.length; i < len; i++) {
        const k = actualKb.secondary[i];
        const kk = $js(k, OS);
        if (kk) {
          result.add(this.g(kk, rule.id, rule.args, rule.weight, -i - 1, rule.when));
        }
      }
    }
    return result;
  }
  setExtensionKeybindings(rules) {
    const result = [];
    let keybindingsLen = 0;
    for (const rule of rules) {
      if (rule.keybinding) {
        result[keybindingsLen++] = {
          keybinding: rule.keybinding,
          command: rule.id,
          commandArgs: rule.args,
          when: rule.when,
          weight1: rule.weight,
          weight2: 0,
          extensionId: rule.extensionId || null,
          isBuiltinExtension: rule.isBuiltinExtension || false
        };
      }
    }
    this.d = result;
    this.e = null;
  }
  registerCommandAndKeybindingRule(desc) {
    return $7c(this.registerKeybindingRule(desc), $rk.registerCommand(desc));
  }
  g(keybinding, commandId, commandArgs, weight1, weight22, when) {
    const remove = this.c.push({
      keybinding,
      command: commandId,
      commandArgs,
      when,
      weight1,
      weight2: weight22,
      extensionId: null,
      isBuiltinExtension: false
    });
    this.e = null;
    return $8c(() => {
      remove();
      this.e = null;
    });
  }
  getDefaultKeybindings() {
    if (!this.e) {
      this.e = Array.from(this.c).concat(this.d);
      this.e.sort(sorter);
    }
    return this.e.slice(0);
  }
};
var $WE = new KeybindingsRegistryImpl();
var $XE = {
  EditorModes: "platform.keybindingsRegistry"
};
$Mo.add($XE.EditorModes, $WE);
function sorter(a, b) {
  if (a.weight1 !== b.weight1) {
    return a.weight1 - b.weight1;
  }
  if (a.command && b.command) {
    if (a.command < b.command) {
      return -1;
    }
    if (a.command > b.command) {
      return 1;
    }
  }
  return a.weight2 - b.weight2;
}

// out-build/vs/platform/actions/common/actions.js
var $5E_1;
function $YE(item) {
  return item.command !== void 0;
}
function $ZE(item) {
  return item.submenu !== void 0;
}
var $1E = class _$1E {
  static {
    this.a = /* @__PURE__ */ new Map();
  }
  static {
    this.CommandPalette = new _$1E("CommandPalette");
  }
  static {
    this.DebugBreakpointsContext = new _$1E("DebugBreakpointsContext");
  }
  static {
    this.DebugCallStackContext = new _$1E("DebugCallStackContext");
  }
  static {
    this.DebugConsoleContext = new _$1E("DebugConsoleContext");
  }
  static {
    this.DebugVariablesContext = new _$1E("DebugVariablesContext");
  }
  static {
    this.NotebookVariablesContext = new _$1E("NotebookVariablesContext");
  }
  static {
    this.DebugHoverContext = new _$1E("DebugHoverContext");
  }
  static {
    this.DebugWatchContext = new _$1E("DebugWatchContext");
  }
  static {
    this.DebugToolBar = new _$1E("DebugToolBar");
  }
  static {
    this.DebugToolBarStop = new _$1E("DebugToolBarStop");
  }
  static {
    this.DebugCallStackToolbar = new _$1E("DebugCallStackToolbar");
  }
  static {
    this.DebugCreateConfiguration = new _$1E("DebugCreateConfiguration");
  }
  static {
    this.EditorContext = new _$1E("EditorContext");
  }
  static {
    this.SimpleEditorContext = new _$1E("SimpleEditorContext");
  }
  static {
    this.EditorContent = new _$1E("EditorContent");
  }
  static {
    this.EditorLineNumberContext = new _$1E("EditorLineNumberContext");
  }
  static {
    this.EditorContextCopy = new _$1E("EditorContextCopy");
  }
  static {
    this.EditorContextPeek = new _$1E("EditorContextPeek");
  }
  static {
    this.EditorContextShare = new _$1E("EditorContextShare");
  }
  static {
    this.EditorTitle = new _$1E("EditorTitle");
  }
  static {
    this.EditorTitleRun = new _$1E("EditorTitleRun");
  }
  static {
    this.EditorTitleContext = new _$1E("EditorTitleContext");
  }
  static {
    this.EditorTitleContextShare = new _$1E("EditorTitleContextShare");
  }
  static {
    this.EmptyEditorGroup = new _$1E("EmptyEditorGroup");
  }
  static {
    this.EmptyEditorGroupContext = new _$1E("EmptyEditorGroupContext");
  }
  static {
    this.EditorTabsBarContext = new _$1E("EditorTabsBarContext");
  }
  static {
    this.EditorTabsBarShowTabsSubmenu = new _$1E("EditorTabsBarShowTabsSubmenu");
  }
  static {
    this.EditorTabsBarShowTabsZenModeSubmenu = new _$1E("EditorTabsBarShowTabsZenModeSubmenu");
  }
  static {
    this.EditorActionsPositionSubmenu = new _$1E("EditorActionsPositionSubmenu");
  }
  static {
    this.ExplorerContext = new _$1E("ExplorerContext");
  }
  static {
    this.ExplorerContextShare = new _$1E("ExplorerContextShare");
  }
  static {
    this.ExtensionContext = new _$1E("ExtensionContext");
  }
  static {
    this.ExtensionEditorContextMenu = new _$1E("ExtensionEditorContextMenu");
  }
  static {
    this.GlobalActivity = new _$1E("GlobalActivity");
  }
  static {
    this.CommandCenter = new _$1E("CommandCenter");
  }
  static {
    this.CommandCenterCenter = new _$1E("CommandCenterCenter");
  }
  static {
    this.LayoutControlMenuSubmenu = new _$1E("LayoutControlMenuSubmenu");
  }
  static {
    this.LayoutControlMenu = new _$1E("LayoutControlMenu");
  }
  static {
    this.MenubarMainMenu = new _$1E("MenubarMainMenu");
  }
  static {
    this.MenubarAppearanceMenu = new _$1E("MenubarAppearanceMenu");
  }
  static {
    this.MenubarDebugMenu = new _$1E("MenubarDebugMenu");
  }
  static {
    this.MenubarEditMenu = new _$1E("MenubarEditMenu");
  }
  static {
    this.MenubarCopy = new _$1E("MenubarCopy");
  }
  static {
    this.MenubarFileMenu = new _$1E("MenubarFileMenu");
  }
  static {
    this.MenubarGoMenu = new _$1E("MenubarGoMenu");
  }
  static {
    this.MenubarHelpMenu = new _$1E("MenubarHelpMenu");
  }
  static {
    this.MenubarLayoutMenu = new _$1E("MenubarLayoutMenu");
  }
  static {
    this.MenubarNewBreakpointMenu = new _$1E("MenubarNewBreakpointMenu");
  }
  static {
    this.PanelAlignmentMenu = new _$1E("PanelAlignmentMenu");
  }
  static {
    this.PanelPositionMenu = new _$1E("PanelPositionMenu");
  }
  static {
    this.ActivityBarPositionMenu = new _$1E("ActivityBarPositionMenu");
  }
  static {
    this.MenubarPreferencesMenu = new _$1E("MenubarPreferencesMenu");
  }
  static {
    this.MenubarRecentMenu = new _$1E("MenubarRecentMenu");
  }
  static {
    this.MenubarSelectionMenu = new _$1E("MenubarSelectionMenu");
  }
  static {
    this.MenubarShare = new _$1E("MenubarShare");
  }
  static {
    this.MenubarSwitchEditorMenu = new _$1E("MenubarSwitchEditorMenu");
  }
  static {
    this.MenubarSwitchGroupMenu = new _$1E("MenubarSwitchGroupMenu");
  }
  static {
    this.MenubarTerminalMenu = new _$1E("MenubarTerminalMenu");
  }
  static {
    this.MenubarViewMenu = new _$1E("MenubarViewMenu");
  }
  static {
    this.MenubarHomeMenu = new _$1E("MenubarHomeMenu");
  }
  static {
    this.OpenEditorsContext = new _$1E("OpenEditorsContext");
  }
  static {
    this.OpenEditorsContextShare = new _$1E("OpenEditorsContextShare");
  }
  static {
    this.ProblemsPanelContext = new _$1E("ProblemsPanelContext");
  }
  static {
    this.SCMInputBox = new _$1E("SCMInputBox");
  }
  static {
    this.SCMChangesContext = new _$1E("SCMChangesContext");
  }
  static {
    this.SCMChangeContext = new _$1E("SCMChangeContext");
  }
  static {
    this.SCMResourceContext = new _$1E("SCMResourceContext");
  }
  static {
    this.SCMResourceContextShare = new _$1E("SCMResourceContextShare");
  }
  static {
    this.SCMResourceFolderContext = new _$1E("SCMResourceFolderContext");
  }
  static {
    this.SCMResourceGroupContext = new _$1E("SCMResourceGroupContext");
  }
  static {
    this.SCMSourceControl = new _$1E("SCMSourceControl");
  }
  static {
    this.SCMSourceControlInline = new _$1E("SCMSourceControlInline");
  }
  static {
    this.SCMSourceControlTitle = new _$1E("SCMSourceControlTitle");
  }
  static {
    this.SCMHistoryTitle = new _$1E("SCMHistoryTitle");
  }
  static {
    this.SCMTitle = new _$1E("SCMTitle");
  }
  static {
    this.SearchContext = new _$1E("SearchContext");
  }
  static {
    this.SearchActionMenu = new _$1E("SearchActionContext");
  }
  static {
    this.StatusBarWindowIndicatorMenu = new _$1E("StatusBarWindowIndicatorMenu");
  }
  static {
    this.StatusBarRemoteIndicatorMenu = new _$1E("StatusBarRemoteIndicatorMenu");
  }
  static {
    this.StickyScrollContext = new _$1E("StickyScrollContext");
  }
  static {
    this.TestItem = new _$1E("TestItem");
  }
  static {
    this.TestItemGutter = new _$1E("TestItemGutter");
  }
  static {
    this.TestProfilesContext = new _$1E("TestProfilesContext");
  }
  static {
    this.TestMessageContext = new _$1E("TestMessageContext");
  }
  static {
    this.TestMessageContent = new _$1E("TestMessageContent");
  }
  static {
    this.TestPeekElement = new _$1E("TestPeekElement");
  }
  static {
    this.TestPeekTitle = new _$1E("TestPeekTitle");
  }
  static {
    this.TestCallStack = new _$1E("TestCallStack");
  }
  static {
    this.TouchBarContext = new _$1E("TouchBarContext");
  }
  static {
    this.TitleBarContext = new _$1E("TitleBarContext");
  }
  static {
    this.TitleBarTitleContext = new _$1E("TitleBarTitleContext");
  }
  static {
    this.TunnelContext = new _$1E("TunnelContext");
  }
  static {
    this.TunnelPrivacy = new _$1E("TunnelPrivacy");
  }
  static {
    this.TunnelProtocol = new _$1E("TunnelProtocol");
  }
  static {
    this.TunnelPortInline = new _$1E("TunnelInline");
  }
  static {
    this.TunnelTitle = new _$1E("TunnelTitle");
  }
  static {
    this.TunnelLocalAddressInline = new _$1E("TunnelLocalAddressInline");
  }
  static {
    this.TunnelOriginInline = new _$1E("TunnelOriginInline");
  }
  static {
    this.ViewItemContext = new _$1E("ViewItemContext");
  }
  static {
    this.ViewContainerTitle = new _$1E("ViewContainerTitle");
  }
  static {
    this.ViewContainerTitleContext = new _$1E("ViewContainerTitleContext");
  }
  static {
    this.ViewTitle = new _$1E("ViewTitle");
  }
  static {
    this.ViewTitleContext = new _$1E("ViewTitleContext");
  }
  static {
    this.CommentEditorActions = new _$1E("CommentEditorActions");
  }
  static {
    this.CommentThreadTitle = new _$1E("CommentThreadTitle");
  }
  static {
    this.CommentThreadActions = new _$1E("CommentThreadActions");
  }
  static {
    this.CommentThreadAdditionalActions = new _$1E("CommentThreadAdditionalActions");
  }
  static {
    this.CommentThreadTitleContext = new _$1E("CommentThreadTitleContext");
  }
  static {
    this.CommentThreadCommentContext = new _$1E("CommentThreadCommentContext");
  }
  static {
    this.CommentTitle = new _$1E("CommentTitle");
  }
  static {
    this.CommentActions = new _$1E("CommentActions");
  }
  static {
    this.CommentsViewThreadActions = new _$1E("CommentsViewThreadActions");
  }
  static {
    this.InteractiveToolbar = new _$1E("InteractiveToolbar");
  }
  static {
    this.InteractiveCellTitle = new _$1E("InteractiveCellTitle");
  }
  static {
    this.InteractiveCellDelete = new _$1E("InteractiveCellDelete");
  }
  static {
    this.InteractiveCellExecute = new _$1E("InteractiveCellExecute");
  }
  static {
    this.InteractiveInputExecute = new _$1E("InteractiveInputExecute");
  }
  static {
    this.InteractiveInputConfig = new _$1E("InteractiveInputConfig");
  }
  static {
    this.ReplInputExecute = new _$1E("ReplInputExecute");
  }
  static {
    this.IssueReporter = new _$1E("IssueReporter");
  }
  static {
    this.NotebookToolbar = new _$1E("NotebookToolbar");
  }
  static {
    this.NotebookStickyScrollContext = new _$1E("NotebookStickyScrollContext");
  }
  static {
    this.NotebookCellTitle = new _$1E("NotebookCellTitle");
  }
  static {
    this.NotebookCellDelete = new _$1E("NotebookCellDelete");
  }
  static {
    this.NotebookCellInsert = new _$1E("NotebookCellInsert");
  }
  static {
    this.NotebookCellBetween = new _$1E("NotebookCellBetween");
  }
  static {
    this.NotebookCellListTop = new _$1E("NotebookCellTop");
  }
  static {
    this.NotebookCellExecute = new _$1E("NotebookCellExecute");
  }
  static {
    this.NotebookCellExecuteGoTo = new _$1E("NotebookCellExecuteGoTo");
  }
  static {
    this.NotebookCellExecutePrimary = new _$1E("NotebookCellExecutePrimary");
  }
  static {
    this.NotebookDiffCellInputTitle = new _$1E("NotebookDiffCellInputTitle");
  }
  static {
    this.NotebookDiffDocumentMetadata = new _$1E("NotebookDiffDocumentMetadata");
  }
  static {
    this.NotebookDiffCellMetadataTitle = new _$1E("NotebookDiffCellMetadataTitle");
  }
  static {
    this.NotebookDiffCellOutputsTitle = new _$1E("NotebookDiffCellOutputsTitle");
  }
  static {
    this.NotebookOutputToolbar = new _$1E("NotebookOutputToolbar");
  }
  static {
    this.NotebookOutlineFilter = new _$1E("NotebookOutlineFilter");
  }
  static {
    this.NotebookOutlineActionMenu = new _$1E("NotebookOutlineActionMenu");
  }
  static {
    this.NotebookEditorLayoutConfigure = new _$1E("NotebookEditorLayoutConfigure");
  }
  static {
    this.NotebookKernelSource = new _$1E("NotebookKernelSource");
  }
  static {
    this.BulkEditTitle = new _$1E("BulkEditTitle");
  }
  static {
    this.BulkEditContext = new _$1E("BulkEditContext");
  }
  static {
    this.TimelineItemContext = new _$1E("TimelineItemContext");
  }
  static {
    this.TimelineTitle = new _$1E("TimelineTitle");
  }
  static {
    this.TimelineTitleContext = new _$1E("TimelineTitleContext");
  }
  static {
    this.TimelineFilterSubMenu = new _$1E("TimelineFilterSubMenu");
  }
  static {
    this.AccountsContext = new _$1E("AccountsContext");
  }
  static {
    this.SidebarTitle = new _$1E("SidebarTitle");
  }
  static {
    this.PanelTitle = new _$1E("PanelTitle");
  }
  static {
    this.AuxiliaryBarTitle = new _$1E("AuxiliaryBarTitle");
  }
  static {
    this.AuxiliaryBarHeader = new _$1E("AuxiliaryBarHeader");
  }
  static {
    this.TerminalInstanceContext = new _$1E("TerminalInstanceContext");
  }
  static {
    this.TerminalEditorInstanceContext = new _$1E("TerminalEditorInstanceContext");
  }
  static {
    this.TerminalNewDropdownContext = new _$1E("TerminalNewDropdownContext");
  }
  static {
    this.TerminalTabContext = new _$1E("TerminalTabContext");
  }
  static {
    this.TerminalTabEmptyAreaContext = new _$1E("TerminalTabEmptyAreaContext");
  }
  static {
    this.TerminalStickyScrollContext = new _$1E("TerminalStickyScrollContext");
  }
  static {
    this.WebviewContext = new _$1E("WebviewContext");
  }
  static {
    this.InlineCompletionsActions = new _$1E("InlineCompletionsActions");
  }
  static {
    this.InlineEditsActions = new _$1E("InlineEditsActions");
  }
  static {
    this.InlineEditActions = new _$1E("InlineEditActions");
  }
  static {
    this.NewFile = new _$1E("NewFile");
  }
  static {
    this.MergeInput1Toolbar = new _$1E("MergeToolbar1Toolbar");
  }
  static {
    this.MergeInput2Toolbar = new _$1E("MergeToolbar2Toolbar");
  }
  static {
    this.MergeBaseToolbar = new _$1E("MergeBaseToolbar");
  }
  static {
    this.MergeInputResultToolbar = new _$1E("MergeToolbarResultToolbar");
  }
  static {
    this.InlineSuggestionToolbar = new _$1E("InlineSuggestionToolbar");
  }
  static {
    this.InlineEditToolbar = new _$1E("InlineEditToolbar");
  }
  static {
    this.ChatContext = new _$1E("ChatContext");
  }
  static {
    this.ChatCodeBlock = new _$1E("ChatCodeblock");
  }
  static {
    this.ChatCompareBlock = new _$1E("ChatCompareBlock");
  }
  static {
    this.ChatMessageTitle = new _$1E("ChatMessageTitle");
  }
  static {
    this.ChatMessageFooter = new _$1E("ChatMessageFooter");
  }
  static {
    this.ChatExecute = new _$1E("ChatExecute");
  }
  static {
    this.ChatExecuteSecondary = new _$1E("ChatExecuteSecondary");
  }
  static {
    this.ChatInput = new _$1E("ChatInput");
  }
  static {
    this.ChatInputSide = new _$1E("ChatInputSide");
  }
  static {
    this.ChatInlineResourceAnchorContext = new _$1E("ChatInlineResourceAnchorContext");
  }
  static {
    this.ChatInlineSymbolAnchorContext = new _$1E("ChatInlineSymbolAnchorContext");
  }
  static {
    this.ChatCommandCenter = new _$1E("ChatCommandCenter");
  }
  static {
    this.AccessibleView = new _$1E("AccessibleView");
  }
  static {
    this.MultiDiffEditorFileToolbar = new _$1E("MultiDiffEditorFileToolbar");
  }
  static {
    this.DiffEditorHunkToolbar = new _$1E("DiffEditorHunkToolbar");
  }
  static {
    this.DiffEditorSelectionToolbar = new _$1E("DiffEditorSelectionToolbar");
  }
  /**
   * Create or reuse a `MenuId` with the given identifier
   */
  static for(identifier2) {
    return _$1E.a.get(identifier2) ?? new _$1E(identifier2);
  }
  /**
   * Create a new `MenuId` with the unique identifier. Will throw if a menu
   * with the identifier already exists, use `MenuId.for(ident)` or a unique
   * identifier
   */
  constructor(identifier2) {
    if (_$1E.a.has(identifier2)) {
      throw new TypeError(`MenuId with identifier '${identifier2}' already exists. Use MenuId.for(ident) or a unique identifier`);
    }
    _$1E.a.set(identifier2, this);
    this.id = identifier2;
  }
};
var $2E = $Zi("menuService");
var MenuRegistryChangeEvent = class _MenuRegistryChangeEvent {
  static {
    this.a = /* @__PURE__ */ new Map();
  }
  static for(id2) {
    let value = this.a.get(id2);
    if (!value) {
      value = new _MenuRegistryChangeEvent(id2);
      this.a.set(id2, value);
    }
    return value;
  }
  static merge(events) {
    const ids = /* @__PURE__ */ new Set();
    for (const item of events) {
      if (item instanceof _MenuRegistryChangeEvent) {
        ids.add(item.b);
      }
    }
    return ids;
  }
  constructor(b) {
    this.b = b;
    this.has = (candidate) => candidate === b;
  }
};
var $3E = new class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
    this.b = /* @__PURE__ */ new Map();
    this.c = new $Ie({
      merge: MenuRegistryChangeEvent.merge
    });
    this.onDidChangeMenu = this.c.event;
  }
  addCommand(command4) {
    this.a.set(command4.id, command4);
    this.c.fire(MenuRegistryChangeEvent.for($1E.CommandPalette));
    return $8c(() => {
      if (this.a.delete(command4.id)) {
        this.c.fire(MenuRegistryChangeEvent.for($1E.CommandPalette));
      }
    });
  }
  getCommand(id2) {
    return this.a.get(id2);
  }
  getCommands() {
    const map = /* @__PURE__ */ new Map();
    this.a.forEach((value, key) => map.set(key, value));
    return map;
  }
  appendMenuItem(id2, item) {
    let list4 = this.b.get(id2);
    if (!list4) {
      list4 = new $hd();
      this.b.set(id2, list4);
    }
    const rm = list4.push(item);
    this.c.fire(MenuRegistryChangeEvent.for(id2));
    return $8c(() => {
      rm();
      this.c.fire(MenuRegistryChangeEvent.for(id2));
    });
  }
  appendMenuItems(items) {
    const result = new $9c();
    for (const { id: id2, item } of items) {
      result.add(this.appendMenuItem(id2, item));
    }
    return result;
  }
  getMenuItems(id2) {
    let result;
    if (this.b.has(id2)) {
      result = [...this.b.get(id2)];
    } else {
      result = [];
    }
    if (id2 === $1E.CommandPalette) {
      this.d(result);
    }
    return result;
  }
  d(result) {
    const set = /* @__PURE__ */ new Set();
    for (const item of result) {
      if ($YE(item)) {
        set.add(item.command.id);
        if (item.alt) {
          set.add(item.alt.id);
        }
      }
    }
    this.a.forEach((command4, id2) => {
      if (!set.has(id2)) {
        result.push({ command: command4 });
      }
    });
  }
}();
var $4E = class extends $Hj {
  constructor(item, hideActions, actions) {
    super(`submenuitem.${item.submenu.id}`, typeof item.title === "string" ? item.title : item.title.value, actions, "submenu");
    this.item = item;
    this.hideActions = hideActions;
  }
};
var $5E = $5E_1 = class $5E2 {
  static label(action, options3) {
    return options3?.renderShortTitle && action.shortTitle ? typeof action.shortTitle === "string" ? action.shortTitle : action.shortTitle.value : typeof action.title === "string" ? action.title : action.title.value;
  }
  constructor(item, alt, options3, hideActions, menuKeybinding, contextKeyService, b) {
    this.hideActions = hideActions;
    this.menuKeybinding = menuKeybinding;
    this.b = b;
    this.id = item.id;
    this.label = $5E_1.label(item, options3);
    this.tooltip = (typeof item.tooltip === "string" ? item.tooltip : item.tooltip?.value) ?? "";
    this.enabled = !item.precondition || contextKeyService.contextMatchesRules(item.precondition);
    this.checked = void 0;
    let icon2;
    if (item.toggled) {
      const toggled = item.toggled.condition ? item.toggled : { condition: item.toggled };
      this.checked = contextKeyService.contextMatchesRules(toggled.condition);
      if (this.checked && toggled.tooltip) {
        this.tooltip = typeof toggled.tooltip === "string" ? toggled.tooltip : toggled.tooltip.value;
      }
      if (this.checked && ThemeIcon.isThemeIcon(toggled.icon)) {
        icon2 = toggled.icon;
      }
      if (this.checked && toggled.title) {
        this.label = typeof toggled.title === "string" ? toggled.title : toggled.title.value;
      }
    }
    if (!icon2) {
      icon2 = ThemeIcon.isThemeIcon(item.icon) ? item.icon : void 0;
    }
    this.item = item;
    this.alt = alt ? new $5E_1(alt, void 0, options3, hideActions, void 0, contextKeyService, b) : void 0;
    this.a = options3;
    this.class = icon2 && ThemeIcon.asClassName(icon2);
  }
  run(...args2) {
    let runArgs = [];
    if (this.a?.arg) {
      runArgs = [...runArgs, this.a.arg];
    }
    if (this.a?.shouldForwardArgs) {
      runArgs = [...runArgs, ...args2];
    }
    return this.b.executeCommand(this.id, ...runArgs);
  }
};
$5E = $5E_1 = __decorate([
  __param(5, $fk),
  __param(6, $qk)
], $5E);
var $6E = class {
  constructor(desc) {
    this.desc = desc;
  }
};
function $7E(ctor) {
  const disposables = [];
  const action = new ctor();
  const { f1, menu, keybinding, ...command4 } = action.desc;
  if ($rk.getCommand(command4.id)) {
    throw new Error(`Cannot register two commands with the same id: ${command4.id}`);
  }
  disposables.push($rk.registerCommand({
    id: command4.id,
    handler: (accessor, ...args2) => action.run(accessor, ...args2),
    metadata: command4.metadata
  }));
  if (Array.isArray(menu)) {
    for (const item of menu) {
      disposables.push($3E.appendMenuItem(item.id, { command: { ...command4, precondition: item.precondition === null ? void 0 : command4.precondition }, ...item }));
    }
  } else if (menu) {
    disposables.push($3E.appendMenuItem(menu.id, { command: { ...command4, precondition: menu.precondition === null ? void 0 : command4.precondition }, ...menu }));
  }
  if (f1) {
    disposables.push($3E.appendMenuItem($1E.CommandPalette, { command: command4, when: command4.precondition }));
    disposables.push($3E.addCommand(command4));
  }
  if (Array.isArray(keybinding)) {
    for (const item of keybinding) {
      disposables.push($WE.registerKeybindingRule({
        ...item,
        id: command4.id,
        when: command4.precondition ? $Xj.and(command4.precondition, item.when) : item.when
      }));
    }
  } else if (keybinding) {
    disposables.push($WE.registerKeybindingRule({
      ...keybinding,
      id: command4.id,
      when: command4.precondition ? $Xj.and(command4.precondition, keybinding.when) : keybinding.when
    }));
  }
  return {
    dispose() {
      $5c(disposables);
    }
  };
}

// out-build/vs/platform/telemetry/common/telemetry.js
var $tm = $Zi("telemetryService");
var $um = $Zi("customEndpointTelemetryService");
var $wm = "telemetry.firstSessionDate";
var $xm = "telemetry.lastSessionDate";
var $Bm = "telemetry";
var $Cm = "telemetry.telemetryLevel";
var $Dm = "telemetry.enableCrashReporter";
var $Em = "telemetry.enableTelemetry";
var TelemetryLevel;
(function(TelemetryLevel2) {
  TelemetryLevel2[TelemetryLevel2["NONE"] = 0] = "NONE";
  TelemetryLevel2[TelemetryLevel2["CRASH"] = 1] = "CRASH";
  TelemetryLevel2[TelemetryLevel2["ERROR"] = 2] = "ERROR";
  TelemetryLevel2[TelemetryLevel2["USAGE"] = 3] = "USAGE";
})(TelemetryLevel || (TelemetryLevel = {}));
var TelemetryConfiguration;
(function(TelemetryConfiguration2) {
  TelemetryConfiguration2["OFF"] = "off";
  TelemetryConfiguration2["CRASH"] = "crash";
  TelemetryConfiguration2["ERROR"] = "error";
  TelemetryConfiguration2["ON"] = "all";
})(TelemetryConfiguration || (TelemetryConfiguration = {}));

// out-build/vs/base/common/errorMessage.js
function exceptionToErrorMessage(exception, verbose) {
  if (verbose && (exception.stack || exception.stacktrace)) {
    return localize(108, null, detectSystemErrorMessage(exception), stackToString(exception.stack) || stackToString(exception.stacktrace));
  }
  return detectSystemErrorMessage(exception);
}
function stackToString(stack) {
  if (Array.isArray(stack)) {
    return stack.join("\n");
  }
  return stack;
}
function detectSystemErrorMessage(exception) {
  if (exception.code === "ERR_UNC_HOST_NOT_ALLOWED") {
    return `${exception.message}. Please update the 'security.allowedUNCHosts' setting if you want to allow this host.`;
  }
  if (typeof exception.code === "string" && typeof exception.errno === "number" && typeof exception.syscall === "string") {
    return localize(109, null, exception.message);
  }
  return exception.message || localize(110, null);
}
function $Kj(error = null, verbose = false) {
  if (!error) {
    return localize(111, null);
  }
  if (Array.isArray(error)) {
    const errors = $Ub(error);
    const msg = $Kj(errors[0], verbose);
    if (errors.length > 1) {
      return localize(112, null, msg, errors.length);
    }
    return msg;
  }
  if ($yg(error)) {
    return error;
  }
  if (error.detail) {
    const detail2 = error.detail;
    if (detail2.error) {
      return exceptionToErrorMessage(detail2.error, verbose);
    }
    if (detail2.exception) {
      return exceptionToErrorMessage(detail2.exception, verbose);
    }
  }
  if (error.stack) {
    return exceptionToErrorMessage(error, verbose);
  }
  if (error.message) {
    return error.message;
  }
  return localize(113, null);
}
function $Lj(obj) {
  const candidate = obj;
  return candidate instanceof Error && Array.isArray(candidate.actions);
}
function $Mj(messageOrError, actions) {
  let error;
  if (typeof messageOrError === "string") {
    error = new Error(messageOrError);
  } else {
    error = messageOrError;
  }
  error.actions = actions;
  return error;
}

// out-build/vs/platform/log/common/log.js
var $uk = $Zi("logService");
var $vk = $Zi("loggerService");
function $wk(thing) {
  return $Cg(thing);
}
var LogLevel;
(function(LogLevel2) {
  LogLevel2[LogLevel2["Off"] = 0] = "Off";
  LogLevel2[LogLevel2["Trace"] = 1] = "Trace";
  LogLevel2[LogLevel2["Debug"] = 2] = "Debug";
  LogLevel2[LogLevel2["Info"] = 3] = "Info";
  LogLevel2[LogLevel2["Warning"] = 4] = "Warning";
  LogLevel2[LogLevel2["Error"] = 5] = "Error";
})(LogLevel || (LogLevel = {}));
var $xk = LogLevel.Info;
function log(logger, level, message) {
  switch (level) {
    case LogLevel.Trace:
      logger.trace(message);
      break;
    case LogLevel.Debug:
      logger.debug(message);
      break;
    case LogLevel.Info:
      logger.info(message);
      break;
    case LogLevel.Warning:
      logger.warn(message);
      break;
    case LogLevel.Error:
      logger.error(message);
      break;
    case LogLevel.Off:
      break;
    default:
      throw new Error(`Invalid log level ${level}`);
  }
}
function format(args2, verbose = false) {
  let result = "";
  for (let i = 0; i < args2.length; i++) {
    let a = args2[i];
    if (a instanceof Error) {
      a = $Kj(a, verbose);
    }
    if (typeof a === "object") {
      try {
        a = JSON.stringify(a);
      } catch (e) {
      }
    }
    result += (i > 0 ? " " : "") + a;
  }
  return result;
}
var $zk = class extends $0c {
  constructor() {
    super(...arguments);
    this.b = $xk;
    this.c = this.B(new $De());
    this.onDidChangeLogLevel = this.c.event;
  }
  setLevel(level) {
    if (this.b !== level) {
      this.b = level;
      this.c.fire(this.b);
    }
  }
  getLevel() {
    return this.b;
  }
  f(level) {
    return this.b !== LogLevel.Off && this.b <= level;
  }
};
var $Ak = class extends $zk {
  constructor(h3) {
    super();
    this.h = h3;
  }
  f(level) {
    return this.h || super.f(level);
  }
  trace(message, ...args2) {
    if (this.f(LogLevel.Trace)) {
      this.g(LogLevel.Trace, format([message, ...args2], true));
    }
  }
  debug(message, ...args2) {
    if (this.f(LogLevel.Debug)) {
      this.g(LogLevel.Debug, format([message, ...args2]));
    }
  }
  info(message, ...args2) {
    if (this.f(LogLevel.Info)) {
      this.g(LogLevel.Info, format([message, ...args2]));
    }
  }
  warn(message, ...args2) {
    if (this.f(LogLevel.Warning)) {
      this.g(LogLevel.Warning, format([message, ...args2]));
    }
  }
  error(message, ...args2) {
    if (this.f(LogLevel.Error)) {
      if (message instanceof Error) {
        const array2 = Array.prototype.slice.call(arguments);
        array2[0] = message.stack;
        this.g(LogLevel.Error, format(array2));
      } else {
        this.g(LogLevel.Error, format([message, ...args2]));
      }
    }
  }
  flush() {
  }
};
var $Ck = class extends $zk {
  constructor(logLevel = $xk, g = true) {
    super();
    this.g = g;
    this.setLevel(logLevel);
  }
  trace(message, ...args2) {
    if (this.f(LogLevel.Trace)) {
      if (this.g) {
        console.log("%cTRACE", "color: #888", message, ...args2);
      } else {
        console.log(message, ...args2);
      }
    }
  }
  debug(message, ...args2) {
    if (this.f(LogLevel.Debug)) {
      if (this.g) {
        console.log("%cDEBUG", "background: #eee; color: #888", message, ...args2);
      } else {
        console.log(message, ...args2);
      }
    }
  }
  info(message, ...args2) {
    if (this.f(LogLevel.Info)) {
      if (this.g) {
        console.log("%c INFO", "color: #33f", message, ...args2);
      } else {
        console.log(message, ...args2);
      }
    }
  }
  warn(message, ...args2) {
    if (this.f(LogLevel.Warning)) {
      if (this.g) {
        console.log("%c WARN", "color: #993", message, ...args2);
      } else {
        console.log(message, ...args2);
      }
    }
  }
  error(message, ...args2) {
    if (this.f(LogLevel.Error)) {
      if (this.g) {
        console.log("%c  ERR", "color: #f33", message, ...args2);
      } else {
        console.error(message, ...args2);
      }
    }
  }
  flush() {
  }
};
var $Dk = class extends $zk {
  constructor(g, logLevel = $xk) {
    super();
    this.g = g;
    this.setLevel(logLevel);
  }
  trace(message, ...args2) {
    if (this.f(LogLevel.Trace)) {
      this.g.log(LogLevel.Trace, [this.h(message), ...args2]);
    }
  }
  debug(message, ...args2) {
    if (this.f(LogLevel.Debug)) {
      this.g.log(LogLevel.Debug, [this.h(message), ...args2]);
    }
  }
  info(message, ...args2) {
    if (this.f(LogLevel.Info)) {
      this.g.log(LogLevel.Info, [this.h(message), ...args2]);
    }
  }
  warn(message, ...args2) {
    if (this.f(LogLevel.Warning)) {
      this.g.log(LogLevel.Warning, [this.h(message), ...args2]);
    }
  }
  error(message, ...args2) {
    if (this.f(LogLevel.Error)) {
      this.g.log(LogLevel.Error, [this.h(message), ...args2]);
    }
  }
  h(msg) {
    if (typeof msg === "string") {
      return msg;
    }
    return $Kj(msg, this.f(LogLevel.Trace));
  }
  flush() {
  }
};
var $Ek = class extends $zk {
  constructor(g) {
    super();
    this.g = g;
    if (g.length) {
      this.setLevel(g[0].getLevel());
    }
  }
  setLevel(level) {
    for (const logger of this.g) {
      logger.setLevel(level);
    }
    super.setLevel(level);
  }
  trace(message, ...args2) {
    for (const logger of this.g) {
      logger.trace(message, ...args2);
    }
  }
  debug(message, ...args2) {
    for (const logger of this.g) {
      logger.debug(message, ...args2);
    }
  }
  info(message, ...args2) {
    for (const logger of this.g) {
      logger.info(message, ...args2);
    }
  }
  warn(message, ...args2) {
    for (const logger of this.g) {
      logger.warn(message, ...args2);
    }
  }
  error(message, ...args2) {
    for (const logger of this.g) {
      logger.error(message, ...args2);
    }
  }
  flush() {
    for (const logger of this.g) {
      logger.flush();
    }
  }
  dispose() {
    for (const logger of this.g) {
      logger.dispose();
    }
    super.dispose();
  }
};
var $Fk = class extends $0c {
  constructor(h3, j, loggerResources) {
    super();
    this.h = h3;
    this.j = j;
    this.b = new $Mc();
    this.c = this.B(new $De());
    this.onDidChangeLoggers = this.c.event;
    this.f = this.B(new $De());
    this.onDidChangeLogLevel = this.f.event;
    this.g = this.B(new $De());
    this.onDidChangeVisibility = this.g.event;
    if (loggerResources) {
      for (const loggerResource of loggerResources) {
        this.b.set(loggerResource.resource, { logger: void 0, info: loggerResource });
      }
    }
  }
  m(resourceOrId) {
    if ($yg(resourceOrId)) {
      return [...this.b.values()].find((logger) => logger.info.id === resourceOrId);
    }
    return this.b.get(resourceOrId);
  }
  getLogger(resourceOrId) {
    return this.m(resourceOrId)?.logger;
  }
  createLogger(idOrResource, options3) {
    const resource = this.n(idOrResource);
    const id2 = $yg(idOrResource) ? idOrResource : options3?.id ?? $Nj(resource.toString()).toString(16);
    let logger = this.b.get(resource)?.logger;
    const logLevel = options3?.logLevel === "always" ? LogLevel.Trace : options3?.logLevel;
    if (!logger) {
      logger = this.s(resource, logLevel ?? this.getLogLevel(resource) ?? this.h, { ...options3, id: id2 });
    }
    const loggerEntry = {
      logger,
      info: { resource, id: id2, logLevel, name: options3?.name, hidden: options3?.hidden, extensionId: options3?.extensionId, when: options3?.when }
    };
    this.registerLogger(loggerEntry.info);
    this.b.set(resource, loggerEntry);
    return logger;
  }
  n(idOrResource) {
    return $yg(idOrResource) ? $Ah(this.j, `${idOrResource}.log`) : idOrResource;
  }
  setLogLevel(arg1, arg2) {
    if (URI.isUri(arg1)) {
      const resource = arg1;
      const logLevel = arg2;
      const logger = this.b.get(resource);
      if (logger && logLevel !== logger.info.logLevel) {
        logger.info.logLevel = logLevel === this.h ? void 0 : logLevel;
        logger.logger?.setLevel(logLevel);
        this.b.set(logger.info.resource, logger);
        this.f.fire([resource, logLevel]);
      }
    } else {
      this.h = arg1;
      for (const [resource, logger] of this.b.entries()) {
        if (this.b.get(resource)?.info.logLevel === void 0) {
          logger.logger?.setLevel(this.h);
        }
      }
      this.f.fire(this.h);
    }
  }
  setVisibility(resourceOrId, visibility) {
    const logger = this.m(resourceOrId);
    if (logger && visibility !== !logger.info.hidden) {
      logger.info.hidden = !visibility;
      this.b.set(logger.info.resource, logger);
      this.g.fire([logger.info.resource, visibility]);
    }
  }
  getLogLevel(resource) {
    let logLevel;
    if (resource) {
      logLevel = this.b.get(resource)?.info.logLevel;
    }
    return logLevel ?? this.h;
  }
  registerLogger(resource) {
    const existing = this.b.get(resource.resource);
    if (existing) {
      if (existing.info.hidden !== resource.hidden) {
        this.setVisibility(resource.resource, !resource.hidden);
      }
    } else {
      this.b.set(resource.resource, { info: resource, logger: void 0 });
      this.c.fire({ added: [resource], removed: [] });
    }
  }
  deregisterLogger(resource) {
    const existing = this.b.get(resource);
    if (existing) {
      if (existing.logger) {
        existing.logger.dispose();
      }
      this.b.delete(resource);
      this.c.fire({ added: [], removed: [existing.info] });
    }
  }
  *getRegisteredLoggers() {
    for (const entry of this.b.values()) {
      yield entry.info;
    }
  }
  getRegisteredLogger(resource) {
    return this.b.get(resource)?.info;
  }
  dispose() {
    this.b.forEach((logger) => logger.logger?.dispose());
    this.b.clear();
    super.dispose();
  }
};
var $Gk = class {
  constructor() {
    this.onDidChangeLogLevel = new $De().event;
  }
  setLevel(level) {
  }
  getLevel() {
    return LogLevel.Info;
  }
  trace(message, ...args2) {
  }
  debug(message, ...args2) {
  }
  info(message, ...args2) {
  }
  warn(message, ...args2) {
  }
  error(message, ...args2) {
  }
  critical(message, ...args2) {
  }
  dispose() {
  }
  flush() {
  }
};
var $Hk = class extends $Gk {
};
function $Ik(environmentService) {
  if (environmentService.verbose) {
    return LogLevel.Trace;
  }
  if (typeof environmentService.logLevel === "string") {
    const logLevel = $Lk(environmentService.logLevel.toLowerCase());
    if (logLevel !== void 0) {
      return logLevel;
    }
  }
  return $xk;
}
function $Jk(logLevel) {
  switch (logLevel) {
    case LogLevel.Trace:
      return "trace";
    case LogLevel.Debug:
      return "debug";
    case LogLevel.Info:
      return "info";
    case LogLevel.Warning:
      return "warn";
    case LogLevel.Error:
      return "error";
    case LogLevel.Off:
      return "off";
  }
}
function $Kk(logLevel) {
  switch (logLevel) {
    case LogLevel.Trace:
      return { original: "Trace", value: localize(1973, null) };
    case LogLevel.Debug:
      return { original: "Debug", value: localize(1974, null) };
    case LogLevel.Info:
      return { original: "Info", value: localize(1975, null) };
    case LogLevel.Warning:
      return { original: "Warning", value: localize(1976, null) };
    case LogLevel.Error:
      return { original: "Error", value: localize(1977, null) };
    case LogLevel.Off:
      return { original: "Off", value: localize(1978, null) };
  }
}
function $Lk(logLevel) {
  switch (logLevel) {
    case "trace":
      return LogLevel.Trace;
    case "debug":
      return LogLevel.Debug;
    case "info":
      return LogLevel.Info;
    case "warn":
      return LogLevel.Warning;
    case "error":
      return LogLevel.Error;
    case "critical":
      return LogLevel.Error;
    case "off":
      return LogLevel.Off;
  }
  return void 0;
}
var $Mk = new $ek("logLevel", $Jk(LogLevel.Info));

// out-build/vs/editor/browser/editorExtensions.js
var EditorContributionInstantiation;
(function(EditorContributionInstantiation2) {
  EditorContributionInstantiation2[EditorContributionInstantiation2["Eager"] = 0] = "Eager";
  EditorContributionInstantiation2[EditorContributionInstantiation2["AfterFirstRender"] = 1] = "AfterFirstRender";
  EditorContributionInstantiation2[EditorContributionInstantiation2["BeforeFirstInteraction"] = 2] = "BeforeFirstInteraction";
  EditorContributionInstantiation2[EditorContributionInstantiation2["Eventually"] = 3] = "Eventually";
  EditorContributionInstantiation2[EditorContributionInstantiation2["Lazy"] = 4] = "Lazy";
})(EditorContributionInstantiation || (EditorContributionInstantiation = {}));
var $21 = class {
  constructor(opts) {
    this.id = opts.id;
    this.precondition = opts.precondition;
    this.f = opts.kbOpts;
    this.g = opts.menuOpts;
    this.metadata = opts.metadata;
  }
  register() {
    if (Array.isArray(this.g)) {
      this.g.forEach(this.o, this);
    } else if (this.g) {
      this.o(this.g);
    }
    if (this.f) {
      const kbOptsArr = Array.isArray(this.f) ? this.f : [this.f];
      for (const kbOpts of kbOptsArr) {
        let kbWhen = kbOpts.kbExpr;
        if (this.precondition) {
          if (kbWhen) {
            kbWhen = $Xj.and(kbWhen, this.precondition);
          } else {
            kbWhen = this.precondition;
          }
        }
        const desc = {
          id: this.id,
          weight: kbOpts.weight,
          args: kbOpts.args,
          when: kbWhen,
          primary: kbOpts.primary,
          secondary: kbOpts.secondary,
          win: kbOpts.win,
          linux: kbOpts.linux,
          mac: kbOpts.mac
        };
        $WE.registerKeybindingRule(desc);
      }
    }
    $rk.registerCommand({
      id: this.id,
      handler: (accessor, args2) => this.runCommand(accessor, args2),
      metadata: this.metadata
    });
  }
  o(item) {
    $3E.appendMenuItem(item.menuId, {
      group: item.group,
      command: {
        id: this.id,
        title: item.title,
        icon: item.icon,
        precondition: this.precondition
      },
      when: item.when,
      order: item.order
    });
  }
};
var $31 = class extends $21 {
  constructor() {
    super(...arguments);
    this.d = [];
  }
  /**
   * A higher priority gets to be looked at first
   */
  addImplementation(priority, name, implementation, when) {
    this.d.push({ priority, name, implementation, when });
    this.d.sort((a, b) => b.priority - a.priority);
    return {
      dispose: () => {
        for (let i = 0; i < this.d.length; i++) {
          if (this.d[i].implementation === implementation) {
            this.d.splice(i, 1);
            return;
          }
        }
      }
    };
  }
  runCommand(accessor, args2) {
    const logService = accessor.get($uk);
    const contextKeyService = accessor.get($fk);
    logService.trace(`Executing Command '${this.id}' which has ${this.d.length} bound.`);
    for (const impl of this.d) {
      if (impl.when) {
        const context = contextKeyService.getContext($hU());
        const value = impl.when.evaluate(context);
        if (!value) {
          continue;
        }
      }
      const result = impl.implementation(accessor, args2);
      if (result) {
        logService.trace(`Command '${this.id}' was handled by '${impl.name}'.`);
        if (typeof result === "boolean") {
          return;
        }
        return result;
      }
    }
    logService.trace(`The Command '${this.id}' was not handled by any implementation.`);
  }
};
var $41 = class extends $21 {
  constructor(d, opts) {
    super(opts);
    this.d = d;
  }
  runCommand(accessor, args2) {
    return this.d.runCommand(accessor, args2);
  }
};
var $51 = class _$51 extends $21 {
  /**
   * Create a command class that is bound to a certain editor contribution.
   */
  static bindToContribution(controllerGetter) {
    return class EditorControllerCommandImpl extends _$51 {
      constructor(opts) {
        super(opts);
        this.d = opts.handler;
      }
      runEditorCommand(accessor, editor, args2) {
        const controller = controllerGetter(editor);
        if (controller) {
          this.d(controller, args2);
        }
      }
    };
  }
  static runEditorCommand(accessor, args2, precondition, runner) {
    const codeEditorService = accessor.get($11);
    const editor = codeEditorService.getFocusedCodeEditor() || codeEditorService.getActiveCodeEditor();
    if (!editor) {
      return;
    }
    return editor.invokeWithinContext((editorAccessor) => {
      const kbService = editorAccessor.get($fk);
      if (!kbService.contextMatchesRules(precondition ?? void 0)) {
        return;
      }
      return runner(editorAccessor, editor, args2);
    });
  }
  runCommand(accessor, args2) {
    return _$51.runEditorCommand(accessor, args2, this.precondition, (accessor2, editor, args3) => this.runEditorCommand(accessor2, editor, args3));
  }
};
var $61 = class _$61 extends $51 {
  static q(opts) {
    let menuOpts;
    if (Array.isArray(opts.menuOpts)) {
      menuOpts = opts.menuOpts;
    } else if (opts.menuOpts) {
      menuOpts = [opts.menuOpts];
    } else {
      menuOpts = [];
    }
    function withDefaults(item) {
      if (!item.menuId) {
        item.menuId = $1E.EditorContext;
      }
      if (!item.title) {
        item.title = opts.label;
      }
      item.when = $Xj.and(opts.precondition, item.when);
      return item;
    }
    if (Array.isArray(opts.contextMenuOpts)) {
      menuOpts.push(...opts.contextMenuOpts.map(withDefaults));
    } else if (opts.contextMenuOpts) {
      menuOpts.push(withDefaults(opts.contextMenuOpts));
    }
    opts.menuOpts = menuOpts;
    return opts;
  }
  constructor(opts) {
    super(_$61.q(opts));
    this.label = opts.label;
    this.alias = opts.alias;
  }
  runEditorCommand(accessor, editor, args2) {
    this.u(accessor, editor);
    return this.run(accessor, editor, args2 || {});
  }
  u(accessor, editor) {
    accessor.get($tm).publicLog2("editorActionInvoked", { name: this.label, id: this.id });
  }
};
var $71 = class extends $61 {
  constructor() {
    super(...arguments);
    this.d = [];
  }
  /**
   * A higher priority gets to be looked at first
   */
  addImplementation(priority, implementation) {
    this.d.push([priority, implementation]);
    this.d.sort((a, b) => b[0] - a[0]);
    return {
      dispose: () => {
        for (let i = 0; i < this.d.length; i++) {
          if (this.d[i][1] === implementation) {
            this.d.splice(i, 1);
            return;
          }
        }
      }
    };
  }
  run(accessor, editor, args2) {
    for (const impl of this.d) {
      const result = impl[1](accessor, editor, args2);
      if (result) {
        if (typeof result === "boolean") {
          return;
        }
        return result;
      }
    }
  }
};
var $81 = class extends $6E {
  run(accessor, ...args2) {
    const codeEditorService = accessor.get($11);
    const editor = codeEditorService.getFocusedCodeEditor() || codeEditorService.getActiveCodeEditor();
    if (!editor) {
      return;
    }
    return editor.invokeWithinContext((editorAccessor) => {
      const kbService = editorAccessor.get($fk);
      const logService = editorAccessor.get($uk);
      const enabled = kbService.contextMatchesRules(this.desc.precondition ?? void 0);
      if (!enabled) {
        logService.debug(`[EditorAction2] NOT running command because its precondition is FALSE`, this.desc.id, this.desc.precondition?.serialize());
        return;
      }
      return this.runEditorCommand(editorAccessor, editor, ...args2);
    });
  }
};
function $91(id2, handler) {
  $rk.registerCommand(id2, function(accessor, ...args2) {
    const instaService = accessor.get($Yi);
    const [resource, position] = args2;
    $Ig(URI.isUri(resource));
    $Ig($_t.isIPosition(position));
    const model = accessor.get($Lx).getModel(resource);
    if (model) {
      const editorPosition = $_t.lift(position);
      return instaService.invokeFunction(handler, model, editorPosition, ...args2.slice(2));
    }
    return accessor.get($Hx).createModelReference(resource).then((reference) => {
      return new Promise((resolve, reject) => {
        try {
          const result = instaService.invokeFunction(handler, reference.object.textEditorModel, $_t.lift(position), args2.slice(2));
          resolve(result);
        } catch (err) {
          reject(err);
        }
      }).finally(() => {
        reference.dispose();
      });
    });
  });
}
function $01(editorCommand) {
  EditorContributionRegistry.INSTANCE.registerEditorCommand(editorCommand);
  return editorCommand;
}
function $$1(ctor) {
  const action = new ctor();
  EditorContributionRegistry.INSTANCE.registerEditorAction(action);
  return action;
}
function $_1(action) {
  EditorContributionRegistry.INSTANCE.registerEditorAction(action);
  return action;
}
function $a2(editorAction) {
  EditorContributionRegistry.INSTANCE.registerEditorAction(editorAction);
}
function $b2(id2, ctor, instantiation) {
  EditorContributionRegistry.INSTANCE.registerEditorContribution(id2, ctor, instantiation);
}
function $c2(id2, ctor) {
  EditorContributionRegistry.INSTANCE.registerDiffEditorContribution(id2, ctor);
}
var EditorExtensionsRegistry;
(function(EditorExtensionsRegistry2) {
  function getEditorCommand(commandId) {
    return EditorContributionRegistry.INSTANCE.getEditorCommand(commandId);
  }
  EditorExtensionsRegistry2.getEditorCommand = getEditorCommand;
  function getEditorActions() {
    return EditorContributionRegistry.INSTANCE.getEditorActions();
  }
  EditorExtensionsRegistry2.getEditorActions = getEditorActions;
  function getEditorContributions() {
    return EditorContributionRegistry.INSTANCE.getEditorContributions();
  }
  EditorExtensionsRegistry2.getEditorContributions = getEditorContributions;
  function getSomeEditorContributions(ids) {
    return EditorContributionRegistry.INSTANCE.getEditorContributions().filter((c) => ids.indexOf(c.id) >= 0);
  }
  EditorExtensionsRegistry2.getSomeEditorContributions = getSomeEditorContributions;
  function getDiffEditorContributions() {
    return EditorContributionRegistry.INSTANCE.getDiffEditorContributions();
  }
  EditorExtensionsRegistry2.getDiffEditorContributions = getDiffEditorContributions;
})(EditorExtensionsRegistry || (EditorExtensionsRegistry = {}));
var Extensions = {
  EditorCommonContributions: "editor.contributions"
};
var EditorContributionRegistry = class _EditorContributionRegistry {
  static {
    this.INSTANCE = new _EditorContributionRegistry();
  }
  constructor() {
    this.d = [];
    this.e = [];
    this.f = [];
    this.g = /* @__PURE__ */ Object.create(null);
  }
  registerEditorContribution(id2, ctor, instantiation) {
    this.d.push({ id: id2, ctor, instantiation });
  }
  getEditorContributions() {
    return this.d.slice(0);
  }
  registerDiffEditorContribution(id2, ctor) {
    this.e.push({ id: id2, ctor });
  }
  getDiffEditorContributions() {
    return this.e.slice(0);
  }
  registerEditorAction(action) {
    action.register();
    this.f.push(action);
  }
  getEditorActions() {
    return this.f;
  }
  registerEditorCommand(editorCommand) {
    editorCommand.register();
    this.g[editorCommand.id] = editorCommand;
  }
  getEditorCommand(commandId) {
    return this.g[commandId] || null;
  }
};
$Mo.add(Extensions.EditorCommonContributions, EditorContributionRegistry.INSTANCE);
function registerCommand(command4) {
  command4.register();
  return command4;
}
var $d2 = registerCommand(new $31({
  id: "undo",
  precondition: void 0,
  kbOpts: {
    weight: 0,
    primary: 2048 | 56
    /* KeyCode.KeyZ */
  },
  menuOpts: [{
    menuId: $1E.MenubarEditMenu,
    group: "1_do",
    title: localize(183, null),
    order: 1
  }, {
    menuId: $1E.CommandPalette,
    group: "",
    title: localize(184, null),
    order: 1
  }]
}));
registerCommand(new $41($d2, { id: "default:undo", precondition: void 0 }));
var $e2 = registerCommand(new $31({
  id: "redo",
  precondition: void 0,
  kbOpts: {
    weight: 0,
    primary: 2048 | 55,
    secondary: [
      2048 | 1024 | 56
      /* KeyCode.KeyZ */
    ],
    mac: {
      primary: 2048 | 1024 | 56
      /* KeyCode.KeyZ */
    }
  },
  menuOpts: [{
    menuId: $1E.MenubarEditMenu,
    group: "1_do",
    title: localize(185, null),
    order: 2
  }, {
    menuId: $1E.CommandPalette,
    group: "",
    title: localize(186, null),
    order: 1
  }]
}));
registerCommand(new $41($e2, { id: "default:redo", precondition: void 0 }));
var $f2 = registerCommand(new $31({
  id: "editor.action.selectAll",
  precondition: void 0,
  kbOpts: {
    weight: 0,
    kbExpr: null,
    primary: 2048 | 31
    /* KeyCode.KeyA */
  },
  menuOpts: [{
    menuId: $1E.MenubarSelectionMenu,
    group: "1_basic",
    title: localize(187, null),
    order: 1
  }, {
    menuId: $1E.CommandPalette,
    group: "",
    title: localize(188, null),
    order: 1
  }]
}));

// out-build/vs/editor/common/core/range.js
var $au = class _$au {
  constructor(startLineNumber, startColumn, endLineNumber, endColumn) {
    if (startLineNumber > endLineNumber || startLineNumber === endLineNumber && startColumn > endColumn) {
      this.startLineNumber = endLineNumber;
      this.startColumn = endColumn;
      this.endLineNumber = startLineNumber;
      this.endColumn = startColumn;
    } else {
      this.startLineNumber = startLineNumber;
      this.startColumn = startColumn;
      this.endLineNumber = endLineNumber;
      this.endColumn = endColumn;
    }
  }
  /**
   * Test if this range is empty.
   */
  isEmpty() {
    return _$au.isEmpty(this);
  }
  /**
   * Test if `range` is empty.
   */
  static isEmpty(range2) {
    return range2.startLineNumber === range2.endLineNumber && range2.startColumn === range2.endColumn;
  }
  /**
   * Test if position is in this range. If the position is at the edges, will return true.
   */
  containsPosition(position) {
    return _$au.containsPosition(this, position);
  }
  /**
   * Test if `position` is in `range`. If the position is at the edges, will return true.
   */
  static containsPosition(range2, position) {
    if (position.lineNumber < range2.startLineNumber || position.lineNumber > range2.endLineNumber) {
      return false;
    }
    if (position.lineNumber === range2.startLineNumber && position.column < range2.startColumn) {
      return false;
    }
    if (position.lineNumber === range2.endLineNumber && position.column > range2.endColumn) {
      return false;
    }
    return true;
  }
  /**
   * Test if `position` is in `range`. If the position is at the edges, will return false.
   * @internal
   */
  static strictContainsPosition(range2, position) {
    if (position.lineNumber < range2.startLineNumber || position.lineNumber > range2.endLineNumber) {
      return false;
    }
    if (position.lineNumber === range2.startLineNumber && position.column <= range2.startColumn) {
      return false;
    }
    if (position.lineNumber === range2.endLineNumber && position.column >= range2.endColumn) {
      return false;
    }
    return true;
  }
  /**
   * Test if range is in this range. If the range is equal to this range, will return true.
   */
  containsRange(range2) {
    return _$au.containsRange(this, range2);
  }
  /**
   * Test if `otherRange` is in `range`. If the ranges are equal, will return true.
   */
  static containsRange(range2, otherRange) {
    if (otherRange.startLineNumber < range2.startLineNumber || otherRange.endLineNumber < range2.startLineNumber) {
      return false;
    }
    if (otherRange.startLineNumber > range2.endLineNumber || otherRange.endLineNumber > range2.endLineNumber) {
      return false;
    }
    if (otherRange.startLineNumber === range2.startLineNumber && otherRange.startColumn < range2.startColumn) {
      return false;
    }
    if (otherRange.endLineNumber === range2.endLineNumber && otherRange.endColumn > range2.endColumn) {
      return false;
    }
    return true;
  }
  /**
   * Test if `range` is strictly in this range. `range` must start after and end before this range for the result to be true.
   */
  strictContainsRange(range2) {
    return _$au.strictContainsRange(this, range2);
  }
  /**
   * Test if `otherRange` is strictly in `range` (must start after, and end before). If the ranges are equal, will return false.
   */
  static strictContainsRange(range2, otherRange) {
    if (otherRange.startLineNumber < range2.startLineNumber || otherRange.endLineNumber < range2.startLineNumber) {
      return false;
    }
    if (otherRange.startLineNumber > range2.endLineNumber || otherRange.endLineNumber > range2.endLineNumber) {
      return false;
    }
    if (otherRange.startLineNumber === range2.startLineNumber && otherRange.startColumn <= range2.startColumn) {
      return false;
    }
    if (otherRange.endLineNumber === range2.endLineNumber && otherRange.endColumn >= range2.endColumn) {
      return false;
    }
    return true;
  }
  /**
   * A reunion of the two ranges.
   * The smallest position will be used as the start point, and the largest one as the end point.
   */
  plusRange(range2) {
    return _$au.plusRange(this, range2);
  }
  /**
   * A reunion of the two ranges.
   * The smallest position will be used as the start point, and the largest one as the end point.
   */
  static plusRange(a, b) {
    let startLineNumber;
    let startColumn;
    let endLineNumber;
    let endColumn;
    if (b.startLineNumber < a.startLineNumber) {
      startLineNumber = b.startLineNumber;
      startColumn = b.startColumn;
    } else if (b.startLineNumber === a.startLineNumber) {
      startLineNumber = b.startLineNumber;
      startColumn = Math.min(b.startColumn, a.startColumn);
    } else {
      startLineNumber = a.startLineNumber;
      startColumn = a.startColumn;
    }
    if (b.endLineNumber > a.endLineNumber) {
      endLineNumber = b.endLineNumber;
      endColumn = b.endColumn;
    } else if (b.endLineNumber === a.endLineNumber) {
      endLineNumber = b.endLineNumber;
      endColumn = Math.max(b.endColumn, a.endColumn);
    } else {
      endLineNumber = a.endLineNumber;
      endColumn = a.endColumn;
    }
    return new _$au(startLineNumber, startColumn, endLineNumber, endColumn);
  }
  /**
   * A intersection of the two ranges.
   */
  intersectRanges(range2) {
    return _$au.intersectRanges(this, range2);
  }
  /**
   * A intersection of the two ranges.
   */
  static intersectRanges(a, b) {
    let resultStartLineNumber = a.startLineNumber;
    let resultStartColumn = a.startColumn;
    let resultEndLineNumber = a.endLineNumber;
    let resultEndColumn = a.endColumn;
    const otherStartLineNumber = b.startLineNumber;
    const otherStartColumn = b.startColumn;
    const otherEndLineNumber = b.endLineNumber;
    const otherEndColumn = b.endColumn;
    if (resultStartLineNumber < otherStartLineNumber) {
      resultStartLineNumber = otherStartLineNumber;
      resultStartColumn = otherStartColumn;
    } else if (resultStartLineNumber === otherStartLineNumber) {
      resultStartColumn = Math.max(resultStartColumn, otherStartColumn);
    }
    if (resultEndLineNumber > otherEndLineNumber) {
      resultEndLineNumber = otherEndLineNumber;
      resultEndColumn = otherEndColumn;
    } else if (resultEndLineNumber === otherEndLineNumber) {
      resultEndColumn = Math.min(resultEndColumn, otherEndColumn);
    }
    if (resultStartLineNumber > resultEndLineNumber) {
      return null;
    }
    if (resultStartLineNumber === resultEndLineNumber && resultStartColumn > resultEndColumn) {
      return null;
    }
    return new _$au(resultStartLineNumber, resultStartColumn, resultEndLineNumber, resultEndColumn);
  }
  /**
   * Test if this range equals other.
   */
  equalsRange(other4) {
    return _$au.equalsRange(this, other4);
  }
  /**
   * Test if range `a` equals `b`.
   */
  static equalsRange(a, b) {
    if (!a && !b) {
      return true;
    }
    return !!a && !!b && a.startLineNumber === b.startLineNumber && a.startColumn === b.startColumn && a.endLineNumber === b.endLineNumber && a.endColumn === b.endColumn;
  }
  /**
   * Return the end position (which will be after or equal to the start position)
   */
  getEndPosition() {
    return _$au.getEndPosition(this);
  }
  /**
   * Return the end position (which will be after or equal to the start position)
   */
  static getEndPosition(range2) {
    return new $_t(range2.endLineNumber, range2.endColumn);
  }
  /**
   * Return the start position (which will be before or equal to the end position)
   */
  getStartPosition() {
    return _$au.getStartPosition(this);
  }
  /**
   * Return the start position (which will be before or equal to the end position)
   */
  static getStartPosition(range2) {
    return new $_t(range2.startLineNumber, range2.startColumn);
  }
  /**
   * Transform to a user presentable string representation.
   */
  toString() {
    return "[" + this.startLineNumber + "," + this.startColumn + " -> " + this.endLineNumber + "," + this.endColumn + "]";
  }
  /**
   * Create a new range using this range's start position, and using endLineNumber and endColumn as the end position.
   */
  setEndPosition(endLineNumber, endColumn) {
    return new _$au(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
  }
  /**
   * Create a new range using this range's end position, and using startLineNumber and startColumn as the start position.
   */
  setStartPosition(startLineNumber, startColumn) {
    return new _$au(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
  }
  /**
   * Create a new empty range using this range's start position.
   */
  collapseToStart() {
    return _$au.collapseToStart(this);
  }
  /**
   * Create a new empty range using this range's start position.
   */
  static collapseToStart(range2) {
    return new _$au(range2.startLineNumber, range2.startColumn, range2.startLineNumber, range2.startColumn);
  }
  /**
   * Create a new empty range using this range's end position.
   */
  collapseToEnd() {
    return _$au.collapseToEnd(this);
  }
  /**
   * Create a new empty range using this range's end position.
   */
  static collapseToEnd(range2) {
    return new _$au(range2.endLineNumber, range2.endColumn, range2.endLineNumber, range2.endColumn);
  }
  /**
   * Moves the range by the given amount of lines.
   */
  delta(lineCount) {
    return new _$au(this.startLineNumber + lineCount, this.startColumn, this.endLineNumber + lineCount, this.endColumn);
  }
  // ---
  static fromPositions(start, end = start) {
    return new _$au(start.lineNumber, start.column, end.lineNumber, end.column);
  }
  static lift(range2) {
    if (!range2) {
      return null;
    }
    return new _$au(range2.startLineNumber, range2.startColumn, range2.endLineNumber, range2.endColumn);
  }
  /**
   * Test if `obj` is an `IRange`.
   */
  static isIRange(obj) {
    return obj && typeof obj.startLineNumber === "number" && typeof obj.startColumn === "number" && typeof obj.endLineNumber === "number" && typeof obj.endColumn === "number";
  }
  /**
   * Test if the two ranges are touching in any way.
   */
  static areIntersectingOrTouching(a, b) {
    if (a.endLineNumber < b.startLineNumber || a.endLineNumber === b.startLineNumber && a.endColumn < b.startColumn) {
      return false;
    }
    if (b.endLineNumber < a.startLineNumber || b.endLineNumber === a.startLineNumber && b.endColumn < a.startColumn) {
      return false;
    }
    return true;
  }
  /**
   * Test if the two ranges are intersecting. If the ranges are touching it returns true.
   */
  static areIntersecting(a, b) {
    if (a.endLineNumber < b.startLineNumber || a.endLineNumber === b.startLineNumber && a.endColumn <= b.startColumn) {
      return false;
    }
    if (b.endLineNumber < a.startLineNumber || b.endLineNumber === a.startLineNumber && b.endColumn <= a.startColumn) {
      return false;
    }
    return true;
  }
  /**
   * A function that compares ranges, useful for sorting ranges
   * It will first compare ranges on the startPosition and then on the endPosition
   */
  static compareRangesUsingStarts(a, b) {
    if (a && b) {
      const aStartLineNumber = a.startLineNumber | 0;
      const bStartLineNumber = b.startLineNumber | 0;
      if (aStartLineNumber === bStartLineNumber) {
        const aStartColumn = a.startColumn | 0;
        const bStartColumn = b.startColumn | 0;
        if (aStartColumn === bStartColumn) {
          const aEndLineNumber = a.endLineNumber | 0;
          const bEndLineNumber = b.endLineNumber | 0;
          if (aEndLineNumber === bEndLineNumber) {
            const aEndColumn = a.endColumn | 0;
            const bEndColumn = b.endColumn | 0;
            return aEndColumn - bEndColumn;
          }
          return aEndLineNumber - bEndLineNumber;
        }
        return aStartColumn - bStartColumn;
      }
      return aStartLineNumber - bStartLineNumber;
    }
    const aExists = a ? 1 : 0;
    const bExists = b ? 1 : 0;
    return aExists - bExists;
  }
  /**
   * A function that compares ranges, useful for sorting ranges
   * It will first compare ranges on the endPosition and then on the startPosition
   */
  static compareRangesUsingEnds(a, b) {
    if (a.endLineNumber === b.endLineNumber) {
      if (a.endColumn === b.endColumn) {
        if (a.startLineNumber === b.startLineNumber) {
          return a.startColumn - b.startColumn;
        }
        return a.startLineNumber - b.startLineNumber;
      }
      return a.endColumn - b.endColumn;
    }
    return a.endLineNumber - b.endLineNumber;
  }
  /**
   * Test if the range spans multiple lines.
   */
  static spansMultipleLines(range2) {
    return range2.endLineNumber > range2.startLineNumber;
  }
  toJSON() {
    return this;
  }
};

// out-build/vs/editor/common/core/selection.js
var SelectionDirection;
(function(SelectionDirection3) {
  SelectionDirection3[SelectionDirection3["LTR"] = 0] = "LTR";
  SelectionDirection3[SelectionDirection3["RTL"] = 1] = "RTL";
})(SelectionDirection || (SelectionDirection = {}));
var $cu = class _$cu extends $au {
  constructor(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn) {
    super(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn);
    this.selectionStartLineNumber = selectionStartLineNumber;
    this.selectionStartColumn = selectionStartColumn;
    this.positionLineNumber = positionLineNumber;
    this.positionColumn = positionColumn;
  }
  /**
   * Transform to a human-readable representation.
   */
  toString() {
    return "[" + this.selectionStartLineNumber + "," + this.selectionStartColumn + " -> " + this.positionLineNumber + "," + this.positionColumn + "]";
  }
  /**
   * Test if equals other selection.
   */
  equalsSelection(other4) {
    return _$cu.selectionsEqual(this, other4);
  }
  /**
   * Test if the two selections are equal.
   */
  static selectionsEqual(a, b) {
    return a.selectionStartLineNumber === b.selectionStartLineNumber && a.selectionStartColumn === b.selectionStartColumn && a.positionLineNumber === b.positionLineNumber && a.positionColumn === b.positionColumn;
  }
  /**
   * Get directions (LTR or RTL).
   */
  getDirection() {
    if (this.selectionStartLineNumber === this.startLineNumber && this.selectionStartColumn === this.startColumn) {
      return 0;
    }
    return 1;
  }
  /**
   * Create a new selection with a different `positionLineNumber` and `positionColumn`.
   */
  setEndPosition(endLineNumber, endColumn) {
    if (this.getDirection() === 0) {
      return new _$cu(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
    }
    return new _$cu(endLineNumber, endColumn, this.startLineNumber, this.startColumn);
  }
  /**
   * Get the position at `positionLineNumber` and `positionColumn`.
   */
  getPosition() {
    return new $_t(this.positionLineNumber, this.positionColumn);
  }
  /**
   * Get the position at the start of the selection.
  */
  getSelectionStart() {
    return new $_t(this.selectionStartLineNumber, this.selectionStartColumn);
  }
  /**
   * Create a new selection with a different `selectionStartLineNumber` and `selectionStartColumn`.
   */
  setStartPosition(startLineNumber, startColumn) {
    if (this.getDirection() === 0) {
      return new _$cu(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
    }
    return new _$cu(this.endLineNumber, this.endColumn, startLineNumber, startColumn);
  }
  // ----
  /**
   * Create a `Selection` from one or two positions
   */
  static fromPositions(start, end = start) {
    return new _$cu(start.lineNumber, start.column, end.lineNumber, end.column);
  }
  /**
   * Creates a `Selection` from a range, given a direction.
   */
  static fromRange(range2, direction) {
    if (direction === 0) {
      return new _$cu(range2.startLineNumber, range2.startColumn, range2.endLineNumber, range2.endColumn);
    } else {
      return new _$cu(range2.endLineNumber, range2.endColumn, range2.startLineNumber, range2.startColumn);
    }
  }
  /**
   * Create a `Selection` from an `ISelection`.
   */
  static liftSelection(sel) {
    return new _$cu(sel.selectionStartLineNumber, sel.selectionStartColumn, sel.positionLineNumber, sel.positionColumn);
  }
  /**
   * `a` equals `b`.
   */
  static selectionsArrEqual(a, b) {
    if (a && !b || !a && b) {
      return false;
    }
    if (!a && !b) {
      return true;
    }
    if (a.length !== b.length) {
      return false;
    }
    for (let i = 0, len = a.length; i < len; i++) {
      if (!this.selectionsEqual(a[i], b[i])) {
        return false;
      }
    }
    return true;
  }
  /**
   * Test if `obj` is an `ISelection`.
   */
  static isISelection(obj) {
    return obj && typeof obj.selectionStartLineNumber === "number" && typeof obj.selectionStartColumn === "number" && typeof obj.positionLineNumber === "number" && typeof obj.positionColumn === "number";
  }
  /**
   * Create with a direction.
   */
  static createWithDirection(startLineNumber, startColumn, endLineNumber, endColumn, direction) {
    if (direction === 0) {
      return new _$cu(startLineNumber, startColumn, endLineNumber, endColumn);
    }
    return new _$cu(endLineNumber, endColumn, startLineNumber, startColumn);
  }
};

// out-build/vs/editor/common/languages/supports.js
function $vv(context, offset) {
  const tokenCount = context.getCount();
  const tokenIndex = context.findTokenIndexAtOffset(offset);
  const desiredLanguageId = context.getLanguageId(tokenIndex);
  let lastTokenIndex = tokenIndex;
  while (lastTokenIndex + 1 < tokenCount && context.getLanguageId(lastTokenIndex + 1) === desiredLanguageId) {
    lastTokenIndex++;
  }
  let firstTokenIndex = tokenIndex;
  while (firstTokenIndex > 0 && context.getLanguageId(firstTokenIndex - 1) === desiredLanguageId) {
    firstTokenIndex--;
  }
  return new $wv(context, desiredLanguageId, firstTokenIndex, lastTokenIndex + 1, context.getStartOffset(firstTokenIndex), context.getEndOffset(lastTokenIndex));
}
var $wv = class {
  constructor(actual, languageId, firstTokenIndex, lastTokenIndex, firstCharOffset, lastCharOffset) {
    this._scopedLineTokensBrand = void 0;
    this.a = actual;
    this.languageId = languageId;
    this.b = firstTokenIndex;
    this.c = lastTokenIndex;
    this.firstCharOffset = firstCharOffset;
    this.d = lastCharOffset;
    this.languageIdCodec = actual.languageIdCodec;
  }
  getLineContent() {
    const actualLineContent = this.a.getLineContent();
    return actualLineContent.substring(this.firstCharOffset, this.d);
  }
  getLineLength() {
    return this.d - this.firstCharOffset;
  }
  getActualLineContentBefore(offset) {
    const actualLineContent = this.a.getLineContent();
    return actualLineContent.substring(0, this.firstCharOffset + offset);
  }
  getTokenCount() {
    return this.c - this.b;
  }
  findTokenIndexAtOffset(offset) {
    return this.a.findTokenIndexAtOffset(offset + this.firstCharOffset) - this.b;
  }
  getStandardTokenType(tokenIndex) {
    return this.a.getStandardTokenType(tokenIndex + this.b);
  }
  toIViewLineTokens() {
    return this.a.sliceAndInflate(this.firstCharOffset, this.d, 0);
  }
};
var IgnoreBracketsInTokens;
(function(IgnoreBracketsInTokens2) {
  IgnoreBracketsInTokens2[IgnoreBracketsInTokens2["value"] = 3] = "value";
})(IgnoreBracketsInTokens || (IgnoreBracketsInTokens = {}));
function $xv(standardTokenType) {
  return (standardTokenType & 3) !== 0;
}

// out-build/vs/editor/common/core/cursorColumns.js
var $Iv = class _$Iv {
  static a(codePoint, visibleColumn, tabSize) {
    if (codePoint === 9) {
      return _$Iv.nextRenderTabStop(visibleColumn, tabSize);
    }
    if ($fg(codePoint) || $gg(codePoint)) {
      return visibleColumn + 2;
    }
    return visibleColumn + 1;
  }
  /**
   * Returns a visible column from a column.
   * @see {@link $Iv}
   */
  static visibleColumnFromColumn(lineContent, column, tabSize) {
    const textLen = Math.min(column - 1, lineContent.length);
    const text2 = lineContent.substring(0, textLen);
    const iterator = new $9f(text2);
    let result = 0;
    while (!iterator.eol()) {
      const codePoint = $7f(text2, textLen, iterator.offset);
      iterator.nextGraphemeLength();
      result = this.a(codePoint, result, tabSize);
    }
    return result;
  }
  /**
   * Returns the value to display as "Col" in the status bar.
   * @see {@link $Iv}
   */
  static toStatusbarColumn(lineContent, column, tabSize) {
    const text2 = lineContent.substring(0, Math.min(column - 1, lineContent.length));
    const iterator = new $8f(text2);
    let result = 0;
    while (!iterator.eol()) {
      const codePoint = iterator.nextCodePoint();
      if (codePoint === 9) {
        result = _$Iv.nextRenderTabStop(result, tabSize);
      } else {
        result = result + 1;
      }
    }
    return result + 1;
  }
  /**
   * Returns a column from a visible column.
   * @see {@link $Iv}
   */
  static columnFromVisibleColumn(lineContent, visibleColumn, tabSize) {
    if (visibleColumn <= 0) {
      return 1;
    }
    const lineContentLength = lineContent.length;
    const iterator = new $9f(lineContent);
    let beforeVisibleColumn = 0;
    let beforeColumn = 1;
    while (!iterator.eol()) {
      const codePoint = $7f(lineContent, lineContentLength, iterator.offset);
      iterator.nextGraphemeLength();
      const afterVisibleColumn = this.a(codePoint, beforeVisibleColumn, tabSize);
      const afterColumn = iterator.offset + 1;
      if (afterVisibleColumn >= visibleColumn) {
        const beforeDelta = visibleColumn - beforeVisibleColumn;
        const afterDelta = afterVisibleColumn - visibleColumn;
        if (afterDelta < beforeDelta) {
          return afterColumn;
        } else {
          return beforeColumn;
        }
      }
      beforeVisibleColumn = afterVisibleColumn;
      beforeColumn = afterColumn;
    }
    return lineContentLength + 1;
  }
  /**
   * ATTENTION: This works with 0-based columns (as opposed to the regular 1-based columns)
   * @see {@link $Iv}
   */
  static nextRenderTabStop(visibleColumn, tabSize) {
    return visibleColumn + tabSize - visibleColumn % tabSize;
  }
  /**
   * ATTENTION: This works with 0-based columns (as opposed to the regular 1-based columns)
   * @see {@link $Iv}
   */
  static nextIndentTabStop(visibleColumn, indentSize) {
    return _$Iv.nextRenderTabStop(visibleColumn, indentSize);
  }
  /**
   * ATTENTION: This works with 0-based columns (as opposed to the regular 1-based columns)
   * @see {@link $Iv}
   */
  static prevRenderTabStop(column, tabSize) {
    return Math.max(0, column - 1 - (column - 1) % tabSize);
  }
  /**
   * ATTENTION: This works with 0-based columns (as opposed to the regular 1-based columns)
   * @see {@link $Iv}
   */
  static prevIndentTabStop(column, indentSize) {
    return _$Iv.prevRenderTabStop(column, indentSize);
  }
};

// out-build/vs/editor/common/core/indentation.js
function _normalizeIndentationFromWhitespace(str, indentSize, insertSpaces) {
  let spacesCnt = 0;
  for (let i = 0; i < str.length; i++) {
    if (str.charAt(i) === "	") {
      spacesCnt = $Iv.nextIndentTabStop(spacesCnt, indentSize);
    } else {
      spacesCnt++;
    }
  }
  let result = "";
  if (!insertSpaces) {
    const tabsCnt = Math.floor(spacesCnt / indentSize);
    spacesCnt = spacesCnt % indentSize;
    for (let i = 0; i < tabsCnt; i++) {
      result += "	";
    }
  }
  for (let i = 0; i < spacesCnt; i++) {
    result += " ";
  }
  return result;
}
function $Ux(str, indentSize, insertSpaces) {
  let firstNonWhitespaceIndex = $Nf(str);
  if (firstNonWhitespaceIndex === -1) {
    firstNonWhitespaceIndex = str.length;
  }
  return _normalizeIndentationFromWhitespace(str.substring(0, firstNonWhitespaceIndex), indentSize, insertSpaces) + str.substring(firstNonWhitespaceIndex);
}

// out-build/vs/editor/common/cursorCommon.js
var EditOperationType;
(function(EditOperationType2) {
  EditOperationType2[EditOperationType2["Other"] = 0] = "Other";
  EditOperationType2[EditOperationType2["DeletingLeft"] = 2] = "DeletingLeft";
  EditOperationType2[EditOperationType2["DeletingRight"] = 3] = "DeletingRight";
  EditOperationType2[EditOperationType2["TypingOther"] = 4] = "TypingOther";
  EditOperationType2[EditOperationType2["TypingFirstSpace"] = 5] = "TypingFirstSpace";
  EditOperationType2[EditOperationType2["TypingConsecutiveSpace"] = 6] = "TypingConsecutiveSpace";
})(EditOperationType || (EditOperationType = {}));
var autoCloseAlways = () => true;
var autoCloseNever = () => false;
var autoCloseBeforeWhitespace = (chr) => chr === " " || chr === "	";
var $j1 = class {
  static shouldRecreate(e) {
    return e.hasChanged(
      148
      /* EditorOption.layoutInfo */
    ) || e.hasChanged(
      134
      /* EditorOption.wordSeparators */
    ) || e.hasChanged(
      38
      /* EditorOption.emptySelectionClipboard */
    ) || e.hasChanged(
      79
      /* EditorOption.multiCursorMergeOverlapping */
    ) || e.hasChanged(
      81
      /* EditorOption.multiCursorPaste */
    ) || e.hasChanged(
      82
      /* EditorOption.multiCursorLimit */
    ) || e.hasChanged(
      6
      /* EditorOption.autoClosingBrackets */
    ) || e.hasChanged(
      7
      /* EditorOption.autoClosingComments */
    ) || e.hasChanged(
      11
      /* EditorOption.autoClosingQuotes */
    ) || e.hasChanged(
      9
      /* EditorOption.autoClosingDelete */
    ) || e.hasChanged(
      10
      /* EditorOption.autoClosingOvertype */
    ) || e.hasChanged(
      14
      /* EditorOption.autoSurround */
    ) || e.hasChanged(
      131
      /* EditorOption.useTabStops */
    ) || e.hasChanged(
      52
      /* EditorOption.fontInfo */
    ) || e.hasChanged(
      94
      /* EditorOption.readOnly */
    ) || e.hasChanged(
      133
      /* EditorOption.wordSegmenterLocales */
    );
  }
  constructor(languageId, modelOptions, configuration2, languageConfigurationService) {
    this.languageConfigurationService = languageConfigurationService;
    this._cursorMoveConfigurationBrand = void 0;
    this.a = languageId;
    const options3 = configuration2.options;
    const layoutInfo = options3.get(
      148
      /* EditorOption.layoutInfo */
    );
    const fontInfo = options3.get(
      52
      /* EditorOption.fontInfo */
    );
    this.readOnly = options3.get(
      94
      /* EditorOption.readOnly */
    );
    this.tabSize = modelOptions.tabSize;
    this.indentSize = modelOptions.indentSize;
    this.insertSpaces = modelOptions.insertSpaces;
    this.stickyTabStops = options3.get(
      119
      /* EditorOption.stickyTabStops */
    );
    this.lineHeight = fontInfo.lineHeight;
    this.typicalHalfwidthCharacterWidth = fontInfo.typicalHalfwidthCharacterWidth;
    this.pageSize = Math.max(1, Math.floor(layoutInfo.height / this.lineHeight) - 2);
    this.useTabStops = options3.get(
      131
      /* EditorOption.useTabStops */
    );
    this.wordSeparators = options3.get(
      134
      /* EditorOption.wordSeparators */
    );
    this.emptySelectionClipboard = options3.get(
      38
      /* EditorOption.emptySelectionClipboard */
    );
    this.copyWithSyntaxHighlighting = options3.get(
      25
      /* EditorOption.copyWithSyntaxHighlighting */
    );
    this.multiCursorMergeOverlapping = options3.get(
      79
      /* EditorOption.multiCursorMergeOverlapping */
    );
    this.multiCursorPaste = options3.get(
      81
      /* EditorOption.multiCursorPaste */
    );
    this.multiCursorLimit = options3.get(
      82
      /* EditorOption.multiCursorLimit */
    );
    this.autoClosingBrackets = options3.get(
      6
      /* EditorOption.autoClosingBrackets */
    );
    this.autoClosingComments = options3.get(
      7
      /* EditorOption.autoClosingComments */
    );
    this.autoClosingQuotes = options3.get(
      11
      /* EditorOption.autoClosingQuotes */
    );
    this.autoClosingDelete = options3.get(
      9
      /* EditorOption.autoClosingDelete */
    );
    this.autoClosingOvertype = options3.get(
      10
      /* EditorOption.autoClosingOvertype */
    );
    this.autoSurround = options3.get(
      14
      /* EditorOption.autoSurround */
    );
    this.autoIndent = options3.get(
      12
      /* EditorOption.autoIndent */
    );
    this.wordSegmenterLocales = options3.get(
      133
      /* EditorOption.wordSegmenterLocales */
    );
    this.surroundingPairs = {};
    this.b = null;
    this.shouldAutoCloseBefore = {
      quote: this.d(languageId, this.autoClosingQuotes, true),
      comment: this.d(languageId, this.autoClosingComments, false),
      bracket: this.d(languageId, this.autoClosingBrackets, false)
    };
    this.autoClosingPairs = this.languageConfigurationService.getLanguageConfiguration(languageId).getAutoClosingPairs();
    const surroundingPairs = this.languageConfigurationService.getLanguageConfiguration(languageId).getSurroundingPairs();
    if (surroundingPairs) {
      for (const pair of surroundingPairs) {
        this.surroundingPairs[pair.open] = pair.close;
      }
    }
    const commentsConfiguration = this.languageConfigurationService.getLanguageConfiguration(languageId).comments;
    this.blockCommentStartToken = commentsConfiguration?.blockCommentStartToken ?? null;
  }
  get electricChars() {
    if (!this.b) {
      this.b = {};
      const electricChars = this.languageConfigurationService.getLanguageConfiguration(this.a).electricCharacter?.getElectricCharacters();
      if (electricChars) {
        for (const char of electricChars) {
          this.b[char] = true;
        }
      }
    }
    return this.b;
  }
  /**
   * Should return opening bracket type to match indentation with
   */
  onElectricCharacter(character, context, column) {
    const scopedLineTokens = $vv(context, column - 1);
    const electricCharacterSupport = this.languageConfigurationService.getLanguageConfiguration(scopedLineTokens.languageId).electricCharacter;
    if (!electricCharacterSupport) {
      return null;
    }
    return electricCharacterSupport.onElectricCharacter(character, scopedLineTokens, column - scopedLineTokens.firstCharOffset);
  }
  normalizeIndentation(str) {
    return $Ux(str, this.indentSize, this.insertSpaces);
  }
  d(languageId, autoCloseConfig, forQuotes) {
    switch (autoCloseConfig) {
      case "beforeWhitespace":
        return autoCloseBeforeWhitespace;
      case "languageDefined":
        return this.f(languageId, forQuotes);
      case "always":
        return autoCloseAlways;
      case "never":
        return autoCloseNever;
    }
  }
  f(languageId, forQuotes) {
    const autoCloseBeforeSet = this.languageConfigurationService.getLanguageConfiguration(languageId).getAutoCloseBeforeSet(forQuotes);
    return (c) => autoCloseBeforeSet.indexOf(c) !== -1;
  }
  /**
   * Returns a visible column from a column.
   * @see {@link $Iv}
   */
  visibleColumnFromColumn(model, position) {
    return $Iv.visibleColumnFromColumn(model.getLineContent(position.lineNumber), position.column, this.tabSize);
  }
  /**
   * Returns a visible column from a column.
   * @see {@link $Iv}
   */
  columnFromVisibleColumn(model, lineNumber, visibleColumn) {
    const result = $Iv.columnFromVisibleColumn(model.getLineContent(lineNumber), visibleColumn, this.tabSize);
    const minColumn = model.getLineMinColumn(lineNumber);
    if (result < minColumn) {
      return minColumn;
    }
    const maxColumn = model.getLineMaxColumn(lineNumber);
    if (result > maxColumn) {
      return maxColumn;
    }
    return result;
  }
};
var $k1 = class _$k1 {
  static fromModelState(modelState) {
    return new $l1(modelState);
  }
  static fromViewState(viewState) {
    return new $m1(viewState);
  }
  static fromModelSelection(modelSelection) {
    const selection = $cu.liftSelection(modelSelection);
    const modelState = new $n1($au.fromPositions(selection.getSelectionStart()), 0, 0, selection.getPosition(), 0);
    return _$k1.fromModelState(modelState);
  }
  static fromModelSelections(modelSelections) {
    const states = [];
    for (let i = 0, len = modelSelections.length; i < len; i++) {
      states[i] = this.fromModelSelection(modelSelections[i]);
    }
    return states;
  }
  constructor(modelState, viewState) {
    this._cursorStateBrand = void 0;
    this.modelState = modelState;
    this.viewState = viewState;
  }
  equals(other4) {
    return this.viewState.equals(other4.viewState) && this.modelState.equals(other4.modelState);
  }
};
var $l1 = class {
  constructor(modelState) {
    this.modelState = modelState;
    this.viewState = null;
  }
};
var $m1 = class {
  constructor(viewState) {
    this.modelState = null;
    this.viewState = viewState;
  }
};
var SelectionStartKind;
(function(SelectionStartKind2) {
  SelectionStartKind2[SelectionStartKind2["Simple"] = 0] = "Simple";
  SelectionStartKind2[SelectionStartKind2["Word"] = 1] = "Word";
  SelectionStartKind2[SelectionStartKind2["Line"] = 2] = "Line";
})(SelectionStartKind || (SelectionStartKind = {}));
var $n1 = class _$n1 {
  constructor(selectionStart, selectionStartKind, selectionStartLeftoverVisibleColumns, position, leftoverVisibleColumns) {
    this.selectionStart = selectionStart;
    this.selectionStartKind = selectionStartKind;
    this.selectionStartLeftoverVisibleColumns = selectionStartLeftoverVisibleColumns;
    this.position = position;
    this.leftoverVisibleColumns = leftoverVisibleColumns;
    this._singleCursorStateBrand = void 0;
    this.selection = _$n1.a(this.selectionStart, this.position);
  }
  equals(other4) {
    return this.selectionStartLeftoverVisibleColumns === other4.selectionStartLeftoverVisibleColumns && this.leftoverVisibleColumns === other4.leftoverVisibleColumns && this.selectionStartKind === other4.selectionStartKind && this.position.equals(other4.position) && this.selectionStart.equalsRange(other4.selectionStart);
  }
  hasSelection() {
    return !this.selection.isEmpty() || !this.selectionStart.isEmpty();
  }
  move(inSelectionMode, lineNumber, column, leftoverVisibleColumns) {
    if (inSelectionMode) {
      return new _$n1(this.selectionStart, this.selectionStartKind, this.selectionStartLeftoverVisibleColumns, new $_t(lineNumber, column), leftoverVisibleColumns);
    } else {
      return new _$n1(new $au(lineNumber, column, lineNumber, column), 0, leftoverVisibleColumns, new $_t(lineNumber, column), leftoverVisibleColumns);
    }
  }
  static a(selectionStart, position) {
    if (selectionStart.isEmpty() || !position.isBeforeOrEqual(selectionStart.getStartPosition())) {
      return $cu.fromPositions(selectionStart.getStartPosition(), position);
    } else {
      return $cu.fromPositions(selectionStart.getEndPosition(), position);
    }
  }
};
var $o1 = class {
  constructor(type, commands, opts) {
    this._editOperationResultBrand = void 0;
    this.type = type;
    this.commands = commands;
    this.shouldPushStackElementBefore = opts.shouldPushStackElementBefore;
    this.shouldPushStackElementAfter = opts.shouldPushStackElementAfter;
  }
};
function $p1(ch) {
  return ch === "'" || ch === '"' || ch === "`";
}

// out-build/vs/editor/common/cursor/cursorColumnSelection.js
var $g2 = class _$g2 {
  static columnSelect(config, model, fromLineNumber, fromVisibleColumn, toLineNumber, toVisibleColumn) {
    const lineCount = Math.abs(toLineNumber - fromLineNumber) + 1;
    const reversed = fromLineNumber > toLineNumber;
    const isRTL = fromVisibleColumn > toVisibleColumn;
    const isLTR = fromVisibleColumn < toVisibleColumn;
    const result = [];
    for (let i = 0; i < lineCount; i++) {
      const lineNumber = fromLineNumber + (reversed ? -i : i);
      const startColumn = config.columnFromVisibleColumn(model, lineNumber, fromVisibleColumn);
      const endColumn = config.columnFromVisibleColumn(model, lineNumber, toVisibleColumn);
      const visibleStartColumn = config.visibleColumnFromColumn(model, new $_t(lineNumber, startColumn));
      const visibleEndColumn = config.visibleColumnFromColumn(model, new $_t(lineNumber, endColumn));
      if (isLTR) {
        if (visibleStartColumn > toVisibleColumn) {
          continue;
        }
        if (visibleEndColumn < fromVisibleColumn) {
          continue;
        }
      }
      if (isRTL) {
        if (visibleEndColumn > fromVisibleColumn) {
          continue;
        }
        if (visibleStartColumn < toVisibleColumn) {
          continue;
        }
      }
      result.push(new $n1(new $au(lineNumber, startColumn, lineNumber, startColumn), 0, 0, new $_t(lineNumber, endColumn), 0));
    }
    if (result.length === 0) {
      for (let i = 0; i < lineCount; i++) {
        const lineNumber = fromLineNumber + (reversed ? -i : i);
        const maxColumn = model.getLineMaxColumn(lineNumber);
        result.push(new $n1(new $au(lineNumber, maxColumn, lineNumber, maxColumn), 0, 0, new $_t(lineNumber, maxColumn), 0));
      }
    }
    return {
      viewStates: result,
      reversed,
      fromLineNumber,
      fromVisualColumn: fromVisibleColumn,
      toLineNumber,
      toVisualColumn: toVisibleColumn
    };
  }
  static columnSelectLeft(config, model, prevColumnSelectData) {
    let toViewVisualColumn = prevColumnSelectData.toViewVisualColumn;
    if (toViewVisualColumn > 0) {
      toViewVisualColumn--;
    }
    return _$g2.columnSelect(config, model, prevColumnSelectData.fromViewLineNumber, prevColumnSelectData.fromViewVisualColumn, prevColumnSelectData.toViewLineNumber, toViewVisualColumn);
  }
  static columnSelectRight(config, model, prevColumnSelectData) {
    let maxVisualViewColumn = 0;
    const minViewLineNumber = Math.min(prevColumnSelectData.fromViewLineNumber, prevColumnSelectData.toViewLineNumber);
    const maxViewLineNumber = Math.max(prevColumnSelectData.fromViewLineNumber, prevColumnSelectData.toViewLineNumber);
    for (let lineNumber = minViewLineNumber; lineNumber <= maxViewLineNumber; lineNumber++) {
      const lineMaxViewColumn = model.getLineMaxColumn(lineNumber);
      const lineMaxVisualViewColumn = config.visibleColumnFromColumn(model, new $_t(lineNumber, lineMaxViewColumn));
      maxVisualViewColumn = Math.max(maxVisualViewColumn, lineMaxVisualViewColumn);
    }
    let toViewVisualColumn = prevColumnSelectData.toViewVisualColumn;
    if (toViewVisualColumn < maxVisualViewColumn) {
      toViewVisualColumn++;
    }
    return this.columnSelect(config, model, prevColumnSelectData.fromViewLineNumber, prevColumnSelectData.fromViewVisualColumn, prevColumnSelectData.toViewLineNumber, toViewVisualColumn);
  }
  static columnSelectUp(config, model, prevColumnSelectData, isPaged) {
    const linesCount = isPaged ? config.pageSize : 1;
    const toViewLineNumber = Math.max(1, prevColumnSelectData.toViewLineNumber - linesCount);
    return this.columnSelect(config, model, prevColumnSelectData.fromViewLineNumber, prevColumnSelectData.fromViewVisualColumn, toViewLineNumber, prevColumnSelectData.toViewVisualColumn);
  }
  static columnSelectDown(config, model, prevColumnSelectData, isPaged) {
    const linesCount = isPaged ? config.pageSize : 1;
    const toViewLineNumber = Math.min(model.getLineCount(), prevColumnSelectData.toViewLineNumber + linesCount);
    return this.columnSelect(config, model, prevColumnSelectData.fromViewLineNumber, prevColumnSelectData.fromViewVisualColumn, toViewLineNumber, prevColumnSelectData.toViewVisualColumn);
  }
};

// out-build/vs/editor/common/commands/replaceCommand.js
var $h2 = class {
  constructor(range2, text2, insertsAutoWhitespace = false) {
    this.a = range2;
    this.b = text2;
    this.insertsAutoWhitespace = insertsAutoWhitespace;
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(this.a, this.b);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    const srcRange = inverseEditOperations[0].range;
    return $cu.fromPositions(srcRange.getEndPosition());
  }
};
var $i2 = class {
  constructor(range2, text2) {
    this.a = range2;
    this.b = text2;
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(this.a, this.b);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    const srcRange = inverseEditOperations[0].range;
    return $cu.fromRange(
      srcRange,
      0
      /* SelectionDirection.LTR */
    );
  }
};
var $j2 = class {
  constructor(range2, text2, insertsAutoWhitespace = false) {
    this.a = range2;
    this.b = text2;
    this.insertsAutoWhitespace = insertsAutoWhitespace;
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(this.a, this.b);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    const srcRange = inverseEditOperations[0].range;
    return $cu.fromPositions(srcRange.getStartPosition());
  }
};
var $k2 = class {
  constructor(range2, text2, lineNumberDeltaOffset, columnDeltaOffset, insertsAutoWhitespace = false) {
    this.a = range2;
    this.b = text2;
    this.c = columnDeltaOffset;
    this.d = lineNumberDeltaOffset;
    this.insertsAutoWhitespace = insertsAutoWhitespace;
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(this.a, this.b);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    const srcRange = inverseEditOperations[0].range;
    return $cu.fromPositions(srcRange.getEndPosition().delta(this.d, this.c));
  }
};
var $l2 = class {
  constructor(editRange, text2, initialSelection, forceMoveMarkers = false) {
    this.a = editRange;
    this.b = text2;
    this.c = initialSelection;
    this.d = forceMoveMarkers;
    this.e = null;
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(this.a, this.b, this.d);
    this.e = builder.trackSelection(this.c);
  }
  computeCursorState(model, helper) {
    return helper.getTrackedSelection(this.e);
  }
};

// out-build/vs/editor/common/cursor/cursorAtomicMoveOperations.js
var Direction;
(function(Direction4) {
  Direction4[Direction4["Left"] = 0] = "Left";
  Direction4[Direction4["Right"] = 1] = "Right";
  Direction4[Direction4["Nearest"] = 2] = "Nearest";
})(Direction || (Direction = {}));
var $m2 = class _$m2 {
  /**
   * Get the visible column at the position. If we get to a non-whitespace character first
   * or past the end of string then return -1.
   *
   * **Note** `position` and the return value are 0-based.
   */
  static whitespaceVisibleColumn(lineContent, position, tabSize) {
    const lineLength = lineContent.length;
    let visibleColumn = 0;
    let prevTabStopPosition = -1;
    let prevTabStopVisibleColumn = -1;
    for (let i = 0; i < lineLength; i++) {
      if (i === position) {
        return [prevTabStopPosition, prevTabStopVisibleColumn, visibleColumn];
      }
      if (visibleColumn % tabSize === 0) {
        prevTabStopPosition = i;
        prevTabStopVisibleColumn = visibleColumn;
      }
      const chCode = lineContent.charCodeAt(i);
      switch (chCode) {
        case 32:
          visibleColumn += 1;
          break;
        case 9:
          visibleColumn = $Iv.nextRenderTabStop(visibleColumn, tabSize);
          break;
        default:
          return [-1, -1, -1];
      }
    }
    if (position === lineLength) {
      return [prevTabStopPosition, prevTabStopVisibleColumn, visibleColumn];
    }
    return [-1, -1, -1];
  }
  /**
   * Return the position that should result from a move left, right or to the
   * nearest tab, if atomic tabs are enabled. Left and right are used for the
   * arrow key movements, nearest is used for mouse selection. It returns
   * -1 if atomic tabs are not relevant and you should fall back to normal
   * behaviour.
   *
   * **Note**: `position` and the return value are 0-based.
   */
  static atomicPosition(lineContent, position, tabSize, direction) {
    const lineLength = lineContent.length;
    const [prevTabStopPosition, prevTabStopVisibleColumn, visibleColumn] = _$m2.whitespaceVisibleColumn(lineContent, position, tabSize);
    if (visibleColumn === -1) {
      return -1;
    }
    let left;
    switch (direction) {
      case 0:
        left = true;
        break;
      case 1:
        left = false;
        break;
      case 2:
        if (visibleColumn % tabSize === 0) {
          return position;
        }
        left = visibleColumn % tabSize <= tabSize / 2;
        break;
    }
    if (left) {
      if (prevTabStopPosition === -1) {
        return -1;
      }
      let currentVisibleColumn2 = prevTabStopVisibleColumn;
      for (let i = prevTabStopPosition; i < lineLength; ++i) {
        if (currentVisibleColumn2 === prevTabStopVisibleColumn + tabSize) {
          return prevTabStopPosition;
        }
        const chCode = lineContent.charCodeAt(i);
        switch (chCode) {
          case 32:
            currentVisibleColumn2 += 1;
            break;
          case 9:
            currentVisibleColumn2 = $Iv.nextRenderTabStop(currentVisibleColumn2, tabSize);
            break;
          default:
            return -1;
        }
      }
      if (currentVisibleColumn2 === prevTabStopVisibleColumn + tabSize) {
        return prevTabStopPosition;
      }
      return -1;
    }
    const targetVisibleColumn = $Iv.nextRenderTabStop(visibleColumn, tabSize);
    let currentVisibleColumn = visibleColumn;
    for (let i = position; i < lineLength; i++) {
      if (currentVisibleColumn === targetVisibleColumn) {
        return i;
      }
      const chCode = lineContent.charCodeAt(i);
      switch (chCode) {
        case 32:
          currentVisibleColumn += 1;
          break;
        case 9:
          currentVisibleColumn = $Iv.nextRenderTabStop(currentVisibleColumn, tabSize);
          break;
        default:
          return -1;
      }
    }
    if (currentVisibleColumn === targetVisibleColumn) {
      return lineLength;
    }
    return -1;
  }
};

// out-build/vs/editor/common/cursor/cursorMoveOperations.js
var $n2 = class {
  constructor(lineNumber, column, leftoverVisibleColumns) {
    this._cursorPositionBrand = void 0;
    this.lineNumber = lineNumber;
    this.column = column;
    this.leftoverVisibleColumns = leftoverVisibleColumns;
  }
};
var $o2 = class _$o2 {
  static leftPosition(model, position) {
    if (position.column > model.getLineMinColumn(position.lineNumber)) {
      return position.delta(void 0, -$$f(model.getLineContent(position.lineNumber), position.column - 1));
    } else if (position.lineNumber > 1) {
      const newLineNumber = position.lineNumber - 1;
      return new $_t(newLineNumber, model.getLineMaxColumn(newLineNumber));
    } else {
      return position;
    }
  }
  static a(model, position, tabSize) {
    if (position.column <= model.getLineIndentColumn(position.lineNumber)) {
      const minColumn = model.getLineMinColumn(position.lineNumber);
      const lineContent = model.getLineContent(position.lineNumber);
      const newPosition = $m2.atomicPosition(
        lineContent,
        position.column - 1,
        tabSize,
        0
        /* Direction.Left */
      );
      if (newPosition !== -1 && newPosition + 1 >= minColumn) {
        return new $_t(position.lineNumber, newPosition + 1);
      }
    }
    return this.leftPosition(model, position);
  }
  static b(config, model, position) {
    const pos = config.stickyTabStops ? _$o2.a(model, position, config.tabSize) : _$o2.leftPosition(model, position);
    return new $n2(pos.lineNumber, pos.column, 0);
  }
  /**
   * @param noOfColumns Must be either `1`
   * or `Math.round(viewModel.getLineContent(viewLineNumber).length / 2)` (for half lines).
  */
  static moveLeft(config, model, cursor, inSelectionMode, noOfColumns) {
    let lineNumber, column;
    if (cursor.hasSelection() && !inSelectionMode) {
      lineNumber = cursor.selection.startLineNumber;
      column = cursor.selection.startColumn;
    } else {
      const pos = cursor.position.delta(void 0, -(noOfColumns - 1));
      const normalizedPos = model.normalizePosition(
        _$o2.c(pos, model),
        0
        /* PositionAffinity.Left */
      );
      const p = _$o2.b(config, model, normalizedPos);
      lineNumber = p.lineNumber;
      column = p.column;
    }
    return cursor.move(inSelectionMode, lineNumber, column, 0);
  }
  /**
   * Adjusts the column so that it is within min/max of the line.
  */
  static c(position, model) {
    return new $_t(position.lineNumber, _$o2.d(position.column, model.getLineMinColumn(position.lineNumber), model.getLineMaxColumn(position.lineNumber)));
  }
  static d(value, min, max) {
    if (value < min) {
      return min;
    }
    if (value > max) {
      return max;
    }
    return value;
  }
  static rightPosition(model, lineNumber, column) {
    if (column < model.getLineMaxColumn(lineNumber)) {
      column = column + $0f(model.getLineContent(lineNumber), column - 1);
    } else if (lineNumber < model.getLineCount()) {
      lineNumber = lineNumber + 1;
      column = model.getLineMinColumn(lineNumber);
    }
    return new $_t(lineNumber, column);
  }
  static rightPositionAtomicSoftTabs(model, lineNumber, column, tabSize, indentSize) {
    if (column < model.getLineIndentColumn(lineNumber)) {
      const lineContent = model.getLineContent(lineNumber);
      const newPosition = $m2.atomicPosition(
        lineContent,
        column - 1,
        tabSize,
        1
        /* Direction.Right */
      );
      if (newPosition !== -1) {
        return new $_t(lineNumber, newPosition + 1);
      }
    }
    return this.rightPosition(model, lineNumber, column);
  }
  static right(config, model, position) {
    const pos = config.stickyTabStops ? _$o2.rightPositionAtomicSoftTabs(model, position.lineNumber, position.column, config.tabSize, config.indentSize) : _$o2.rightPosition(model, position.lineNumber, position.column);
    return new $n2(pos.lineNumber, pos.column, 0);
  }
  static moveRight(config, model, cursor, inSelectionMode, noOfColumns) {
    let lineNumber, column;
    if (cursor.hasSelection() && !inSelectionMode) {
      lineNumber = cursor.selection.endLineNumber;
      column = cursor.selection.endColumn;
    } else {
      const pos = cursor.position.delta(void 0, noOfColumns - 1);
      const normalizedPos = model.normalizePosition(
        _$o2.c(pos, model),
        1
        /* PositionAffinity.Right */
      );
      const r2 = _$o2.right(config, model, normalizedPos);
      lineNumber = r2.lineNumber;
      column = r2.column;
    }
    return cursor.move(inSelectionMode, lineNumber, column, 0);
  }
  static vertical(config, model, lineNumber, column, leftoverVisibleColumns, newLineNumber, allowMoveOnEdgeLine, normalizationAffinity) {
    const currentVisibleColumn = $Iv.visibleColumnFromColumn(model.getLineContent(lineNumber), column, config.tabSize) + leftoverVisibleColumns;
    const lineCount = model.getLineCount();
    const wasOnFirstPosition = lineNumber === 1 && column === 1;
    const wasOnLastPosition = lineNumber === lineCount && column === model.getLineMaxColumn(lineNumber);
    const wasAtEdgePosition = newLineNumber < lineNumber ? wasOnFirstPosition : wasOnLastPosition;
    lineNumber = newLineNumber;
    if (lineNumber < 1) {
      lineNumber = 1;
      if (allowMoveOnEdgeLine) {
        column = model.getLineMinColumn(lineNumber);
      } else {
        column = Math.min(model.getLineMaxColumn(lineNumber), column);
      }
    } else if (lineNumber > lineCount) {
      lineNumber = lineCount;
      if (allowMoveOnEdgeLine) {
        column = model.getLineMaxColumn(lineNumber);
      } else {
        column = Math.min(model.getLineMaxColumn(lineNumber), column);
      }
    } else {
      column = config.columnFromVisibleColumn(model, lineNumber, currentVisibleColumn);
    }
    if (wasAtEdgePosition) {
      leftoverVisibleColumns = 0;
    } else {
      leftoverVisibleColumns = currentVisibleColumn - $Iv.visibleColumnFromColumn(model.getLineContent(lineNumber), column, config.tabSize);
    }
    if (normalizationAffinity !== void 0) {
      const position = new $_t(lineNumber, column);
      const newPosition = model.normalizePosition(position, normalizationAffinity);
      leftoverVisibleColumns = leftoverVisibleColumns + (column - newPosition.column);
      lineNumber = newPosition.lineNumber;
      column = newPosition.column;
    }
    return new $n2(lineNumber, column, leftoverVisibleColumns);
  }
  static down(config, model, lineNumber, column, leftoverVisibleColumns, count, allowMoveOnLastLine) {
    return this.vertical(
      config,
      model,
      lineNumber,
      column,
      leftoverVisibleColumns,
      lineNumber + count,
      allowMoveOnLastLine,
      4
      /* PositionAffinity.RightOfInjectedText */
    );
  }
  static moveDown(config, model, cursor, inSelectionMode, linesCount) {
    let lineNumber, column;
    if (cursor.hasSelection() && !inSelectionMode) {
      lineNumber = cursor.selection.endLineNumber;
      column = cursor.selection.endColumn;
    } else {
      lineNumber = cursor.position.lineNumber;
      column = cursor.position.column;
    }
    let i = 0;
    let r2;
    do {
      r2 = _$o2.down(config, model, lineNumber + i, column, cursor.leftoverVisibleColumns, linesCount, true);
      const np = model.normalizePosition(
        new $_t(r2.lineNumber, r2.column),
        2
        /* PositionAffinity.None */
      );
      if (np.lineNumber > lineNumber) {
        break;
      }
    } while (i++ < 10 && lineNumber + i < model.getLineCount());
    return cursor.move(inSelectionMode, r2.lineNumber, r2.column, r2.leftoverVisibleColumns);
  }
  static translateDown(config, model, cursor) {
    const selection = cursor.selection;
    const selectionStart = _$o2.down(config, model, selection.selectionStartLineNumber, selection.selectionStartColumn, cursor.selectionStartLeftoverVisibleColumns, 1, false);
    const position = _$o2.down(config, model, selection.positionLineNumber, selection.positionColumn, cursor.leftoverVisibleColumns, 1, false);
    return new $n1(new $au(selectionStart.lineNumber, selectionStart.column, selectionStart.lineNumber, selectionStart.column), 0, selectionStart.leftoverVisibleColumns, new $_t(position.lineNumber, position.column), position.leftoverVisibleColumns);
  }
  static up(config, model, lineNumber, column, leftoverVisibleColumns, count, allowMoveOnFirstLine) {
    return this.vertical(
      config,
      model,
      lineNumber,
      column,
      leftoverVisibleColumns,
      lineNumber - count,
      allowMoveOnFirstLine,
      3
      /* PositionAffinity.LeftOfInjectedText */
    );
  }
  static moveUp(config, model, cursor, inSelectionMode, linesCount) {
    let lineNumber, column;
    if (cursor.hasSelection() && !inSelectionMode) {
      lineNumber = cursor.selection.startLineNumber;
      column = cursor.selection.startColumn;
    } else {
      lineNumber = cursor.position.lineNumber;
      column = cursor.position.column;
    }
    const r2 = _$o2.up(config, model, lineNumber, column, cursor.leftoverVisibleColumns, linesCount, true);
    return cursor.move(inSelectionMode, r2.lineNumber, r2.column, r2.leftoverVisibleColumns);
  }
  static translateUp(config, model, cursor) {
    const selection = cursor.selection;
    const selectionStart = _$o2.up(config, model, selection.selectionStartLineNumber, selection.selectionStartColumn, cursor.selectionStartLeftoverVisibleColumns, 1, false);
    const position = _$o2.up(config, model, selection.positionLineNumber, selection.positionColumn, cursor.leftoverVisibleColumns, 1, false);
    return new $n1(new $au(selectionStart.lineNumber, selectionStart.column, selectionStart.lineNumber, selectionStart.column), 0, selectionStart.leftoverVisibleColumns, new $_t(position.lineNumber, position.column), position.leftoverVisibleColumns);
  }
  static e(model, lineNumber) {
    if (model.getLineFirstNonWhitespaceColumn(lineNumber) === 0) {
      return true;
    }
    return false;
  }
  static moveToPrevBlankLine(config, model, cursor, inSelectionMode) {
    let lineNumber = cursor.position.lineNumber;
    while (lineNumber > 1 && this.e(model, lineNumber)) {
      lineNumber--;
    }
    while (lineNumber > 1 && !this.e(model, lineNumber)) {
      lineNumber--;
    }
    return cursor.move(inSelectionMode, lineNumber, model.getLineMinColumn(lineNumber), 0);
  }
  static moveToNextBlankLine(config, model, cursor, inSelectionMode) {
    const lineCount = model.getLineCount();
    let lineNumber = cursor.position.lineNumber;
    while (lineNumber < lineCount && this.e(model, lineNumber)) {
      lineNumber++;
    }
    while (lineNumber < lineCount && !this.e(model, lineNumber)) {
      lineNumber++;
    }
    return cursor.move(inSelectionMode, lineNumber, model.getLineMinColumn(lineNumber), 0);
  }
  static moveToBeginningOfLine(config, model, cursor, inSelectionMode) {
    const lineNumber = cursor.position.lineNumber;
    const minColumn = model.getLineMinColumn(lineNumber);
    const firstNonBlankColumn = model.getLineFirstNonWhitespaceColumn(lineNumber) || minColumn;
    let column;
    const relevantColumnNumber = cursor.position.column;
    if (relevantColumnNumber === firstNonBlankColumn) {
      column = minColumn;
    } else {
      column = firstNonBlankColumn;
    }
    return cursor.move(inSelectionMode, lineNumber, column, 0);
  }
  static moveToEndOfLine(config, model, cursor, inSelectionMode, sticky) {
    const lineNumber = cursor.position.lineNumber;
    const maxColumn = model.getLineMaxColumn(lineNumber);
    return cursor.move(inSelectionMode, lineNumber, maxColumn, sticky ? 1073741824 - maxColumn : 0);
  }
  static moveToBeginningOfBuffer(config, model, cursor, inSelectionMode) {
    return cursor.move(inSelectionMode, 1, 1, 0);
  }
  static moveToEndOfBuffer(config, model, cursor, inSelectionMode) {
    const lastLineNumber = model.getLineCount();
    const lastColumn = model.getLineMaxColumn(lastLineNumber);
    return cursor.move(inSelectionMode, lastLineNumber, lastColumn, 0);
  }
};

// out-build/vs/editor/common/cursor/cursorDeleteOperations.js
var $p2 = class _$p2 {
  static deleteRight(prevEditOperationType, config, model, selections) {
    const commands = [];
    let shouldPushStackElementBefore = prevEditOperationType !== 3;
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      let deleteSelection = selection;
      if (deleteSelection.isEmpty()) {
        const position = selection.getPosition();
        const rightOfPosition = $o2.right(config, model, position);
        deleteSelection = new $au(rightOfPosition.lineNumber, rightOfPosition.column, position.lineNumber, position.column);
      }
      if (deleteSelection.isEmpty()) {
        commands[i] = null;
        continue;
      }
      if (deleteSelection.startLineNumber !== deleteSelection.endLineNumber) {
        shouldPushStackElementBefore = true;
      }
      commands[i] = new $h2(deleteSelection, "");
    }
    return [shouldPushStackElementBefore, commands];
  }
  static isAutoClosingPairDelete(autoClosingDelete, autoClosingBrackets, autoClosingQuotes, autoClosingPairsOpen, model, selections, autoClosedCharacters) {
    if (autoClosingBrackets === "never" && autoClosingQuotes === "never") {
      return false;
    }
    if (autoClosingDelete === "never") {
      return false;
    }
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      const position = selection.getPosition();
      if (!selection.isEmpty()) {
        return false;
      }
      const lineText = model.getLineContent(position.lineNumber);
      if (position.column < 2 || position.column >= lineText.length + 1) {
        return false;
      }
      const character = lineText.charAt(position.column - 2);
      const autoClosingPairCandidates = autoClosingPairsOpen.get(character);
      if (!autoClosingPairCandidates) {
        return false;
      }
      if ($p1(character)) {
        if (autoClosingQuotes === "never") {
          return false;
        }
      } else {
        if (autoClosingBrackets === "never") {
          return false;
        }
      }
      const afterCharacter = lineText.charAt(position.column - 1);
      let foundAutoClosingPair = false;
      for (const autoClosingPairCandidate of autoClosingPairCandidates) {
        if (autoClosingPairCandidate.open === character && autoClosingPairCandidate.close === afterCharacter) {
          foundAutoClosingPair = true;
        }
      }
      if (!foundAutoClosingPair) {
        return false;
      }
      if (autoClosingDelete === "auto") {
        let found = false;
        for (let j = 0, lenJ = autoClosedCharacters.length; j < lenJ; j++) {
          const autoClosedCharacter = autoClosedCharacters[j];
          if (position.lineNumber === autoClosedCharacter.startLineNumber && position.column === autoClosedCharacter.startColumn) {
            found = true;
            break;
          }
        }
        if (!found) {
          return false;
        }
      }
    }
    return true;
  }
  static c(config, model, selections) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      const position = selections[i].getPosition();
      const deleteSelection = new $au(position.lineNumber, position.column - 1, position.lineNumber, position.column + 1);
      commands[i] = new $h2(deleteSelection, "");
    }
    return [true, commands];
  }
  static deleteLeft(prevEditOperationType, config, model, selections, autoClosedCharacters) {
    if (this.isAutoClosingPairDelete(config.autoClosingDelete, config.autoClosingBrackets, config.autoClosingQuotes, config.autoClosingPairs.autoClosingPairsOpenByEnd, model, selections, autoClosedCharacters)) {
      return this.c(config, model, selections);
    }
    const commands = [];
    let shouldPushStackElementBefore = prevEditOperationType !== 2;
    for (let i = 0, len = selections.length; i < len; i++) {
      const deleteRange = _$p2.d(selections[i], model, config);
      if (deleteRange.isEmpty()) {
        commands[i] = null;
        continue;
      }
      if (deleteRange.startLineNumber !== deleteRange.endLineNumber) {
        shouldPushStackElementBefore = true;
      }
      commands[i] = new $h2(deleteRange, "");
    }
    return [shouldPushStackElementBefore, commands];
  }
  static d(selection, model, config) {
    if (!selection.isEmpty()) {
      return selection;
    }
    const position = selection.getPosition();
    if (config.useTabStops && position.column > 1) {
      const lineContent = model.getLineContent(position.lineNumber);
      const firstNonWhitespaceIndex = $Nf(lineContent);
      const lastIndentationColumn = firstNonWhitespaceIndex === -1 ? (
        /* entire string is whitespace */
        lineContent.length + 1
      ) : firstNonWhitespaceIndex + 1;
      if (position.column <= lastIndentationColumn) {
        const fromVisibleColumn = config.visibleColumnFromColumn(model, position);
        const toVisibleColumn = $Iv.prevIndentTabStop(fromVisibleColumn, config.indentSize);
        const toColumn = config.columnFromVisibleColumn(model, position.lineNumber, toVisibleColumn);
        return new $au(position.lineNumber, toColumn, position.lineNumber, position.column);
      }
    }
    return $au.fromPositions(_$p2.e(position, model), position);
  }
  static e(position, model) {
    if (position.column > 1) {
      const idx = $ug(position.column - 1, model.getLineContent(position.lineNumber));
      return position.with(void 0, idx + 1);
    } else if (position.lineNumber > 1) {
      const newLine = position.lineNumber - 1;
      return new $_t(newLine, model.getLineMaxColumn(newLine));
    } else {
      return position;
    }
  }
  static cut(config, model, selections) {
    const commands = [];
    let lastCutRange = null;
    selections.sort((a, b) => $_t.compare(a.getStartPosition(), b.getEndPosition()));
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      if (selection.isEmpty()) {
        if (config.emptySelectionClipboard) {
          const position = selection.getPosition();
          let startLineNumber, startColumn, endLineNumber, endColumn;
          if (position.lineNumber < model.getLineCount()) {
            startLineNumber = position.lineNumber;
            startColumn = 1;
            endLineNumber = position.lineNumber + 1;
            endColumn = 1;
          } else if (position.lineNumber > 1 && lastCutRange?.endLineNumber !== position.lineNumber) {
            startLineNumber = position.lineNumber - 1;
            startColumn = model.getLineMaxColumn(position.lineNumber - 1);
            endLineNumber = position.lineNumber;
            endColumn = model.getLineMaxColumn(position.lineNumber);
          } else {
            startLineNumber = position.lineNumber;
            startColumn = 1;
            endLineNumber = position.lineNumber;
            endColumn = model.getLineMaxColumn(position.lineNumber);
          }
          const deleteSelection = new $au(startLineNumber, startColumn, endLineNumber, endColumn);
          lastCutRange = deleteSelection;
          if (!deleteSelection.isEmpty()) {
            commands[i] = new $h2(deleteSelection, "");
          } else {
            commands[i] = null;
          }
        } else {
          commands[i] = null;
        }
      } else {
        commands[i] = new $h2(selection, "");
      }
    }
    return new $o1(0, commands, {
      shouldPushStackElementBefore: true,
      shouldPushStackElementAfter: true
    });
  }
};

// out-build/vs/base/common/uint.js
var Constants;
(function(Constants27) {
  Constants27[Constants27["MAX_SAFE_SMALL_INTEGER"] = 1073741824] = "MAX_SAFE_SMALL_INTEGER";
  Constants27[Constants27["MIN_SAFE_SMALL_INTEGER"] = -1073741824] = "MIN_SAFE_SMALL_INTEGER";
  Constants27[Constants27["MAX_UINT_8"] = 255] = "MAX_UINT_8";
  Constants27[Constants27["MAX_UINT_16"] = 65535] = "MAX_UINT_16";
  Constants27[Constants27["MAX_UINT_32"] = 4294967295] = "MAX_UINT_32";
  Constants27[Constants27["UNICODE_SUPPLEMENTARY_PLANE_BEGIN"] = 65536] = "UNICODE_SUPPLEMENTARY_PLANE_BEGIN";
})(Constants || (Constants = {}));
function $tf(v) {
  if (v < 0) {
    return 0;
  }
  if (v > 255) {
    return 255;
  }
  return v | 0;
}
function $uf(v) {
  if (v < 0) {
    return 0;
  }
  if (v > 4294967295) {
    return 4294967295;
  }
  return v | 0;
}

// out-build/vs/editor/common/core/characterClassifier.js
var $Hu = class _$Hu {
  constructor(_defaultValue) {
    const defaultValue = $tf(_defaultValue);
    this.c = defaultValue;
    this.a = _$Hu.d(defaultValue);
    this.b = /* @__PURE__ */ new Map();
  }
  static d(defaultValue) {
    const asciiMap = new Uint8Array(256);
    asciiMap.fill(defaultValue);
    return asciiMap;
  }
  set(charCode, _value) {
    const value = $tf(_value);
    if (charCode >= 0 && charCode < 256) {
      this.a[charCode] = value;
    } else {
      this.b.set(charCode, value);
    }
  }
  get(charCode) {
    if (charCode >= 0 && charCode < 256) {
      return this.a[charCode];
    } else {
      return this.b.get(charCode) || this.c;
    }
  }
  clear() {
    this.a.fill(this.c);
    this.b.clear();
  }
};
var Boolean2;
(function(Boolean3) {
  Boolean3[Boolean3["False"] = 0] = "False";
  Boolean3[Boolean3["True"] = 1] = "True";
})(Boolean2 || (Boolean2 = {}));
var $Iu = class {
  constructor() {
    this.a = new $Hu(
      0
      /* Boolean.False */
    );
  }
  add(charCode) {
    this.a.set(
      charCode,
      1
      /* Boolean.True */
    );
  }
  has(charCode) {
    return this.a.get(charCode) === 1;
  }
  clear() {
    return this.a.clear();
  }
};

// out-build/vs/editor/common/core/wordCharacterClassifier.js
var WordCharacterClass;
(function(WordCharacterClass2) {
  WordCharacterClass2[WordCharacterClass2["Regular"] = 0] = "Regular";
  WordCharacterClass2[WordCharacterClass2["Whitespace"] = 1] = "Whitespace";
  WordCharacterClass2[WordCharacterClass2["WordSeparator"] = 2] = "WordSeparator";
})(WordCharacterClass || (WordCharacterClass = {}));
var $Ju = class extends $Hu {
  constructor(wordSeparators2, intlSegmenterLocales) {
    super(
      0
      /* WordCharacterClass.Regular */
    );
    this.e = null;
    this.f = null;
    this.g = [];
    this.intlSegmenterLocales = intlSegmenterLocales;
    if (this.intlSegmenterLocales.length > 0) {
      this.e = new Intl.Segmenter(this.intlSegmenterLocales, { granularity: "word" });
    } else {
      this.e = null;
    }
    for (let i = 0, len = wordSeparators2.length; i < len; i++) {
      this.set(
        wordSeparators2.charCodeAt(i),
        2
        /* WordCharacterClass.WordSeparator */
      );
    }
    this.set(
      32,
      1
      /* WordCharacterClass.Whitespace */
    );
    this.set(
      9,
      1
      /* WordCharacterClass.Whitespace */
    );
  }
  findPrevIntlWordBeforeOrAtOffset(line, offset) {
    let candidate = null;
    for (const segment of this.h(line)) {
      if (segment.index > offset) {
        break;
      }
      candidate = segment;
    }
    return candidate;
  }
  findNextIntlWordAtOrAfterOffset(lineContent, offset) {
    for (const segment of this.h(lineContent)) {
      if (segment.index < offset) {
        continue;
      }
      return segment;
    }
    return null;
  }
  h(line) {
    if (!this.e) {
      return [];
    }
    if (this.f === line) {
      return this.g;
    }
    this.f = line;
    this.g = this.j(this.e.segment(line));
    return this.g;
  }
  j(segments) {
    const result = [];
    for (const segment of segments) {
      if (this.k(segment)) {
        result.push(segment);
      }
    }
    return result;
  }
  k(segment) {
    if (segment.isWordLike) {
      return true;
    }
    return false;
  }
};
var wordClassifierCache = new $Pc(10);
function $Ku(wordSeparators2, intlSegmenterLocales) {
  const key = `${wordSeparators2}/${intlSegmenterLocales.join(",")}`;
  let result = wordClassifierCache.get(key);
  if (!result) {
    result = new $Ju(wordSeparators2, intlSegmenterLocales);
    wordClassifierCache.set(key, result);
  }
  return result;
}

// out-build/vs/editor/common/cursor/cursorWordOperations.js
var WordType;
(function(WordType2) {
  WordType2[WordType2["None"] = 0] = "None";
  WordType2[WordType2["Regular"] = 1] = "Regular";
  WordType2[WordType2["Separator"] = 2] = "Separator";
})(WordType || (WordType = {}));
var WordNavigationType;
(function(WordNavigationType2) {
  WordNavigationType2[WordNavigationType2["WordStart"] = 0] = "WordStart";
  WordNavigationType2[WordNavigationType2["WordStartFast"] = 1] = "WordStartFast";
  WordNavigationType2[WordNavigationType2["WordEnd"] = 2] = "WordEnd";
  WordNavigationType2[WordNavigationType2["WordAccessibility"] = 3] = "WordAccessibility";
})(WordNavigationType || (WordNavigationType = {}));
var $q2 = class _$q2 {
  static a(lineContent, wordType, nextCharClass, start, end) {
    return { start, end, wordType, nextCharClass };
  }
  static b(intlWord, nextCharClass) {
    return { start: intlWord.index, end: intlWord.index + intlWord.segment.length, wordType: 1, nextCharClass };
  }
  static c(wordSeparators2, model, position) {
    const lineContent = model.getLineContent(position.lineNumber);
    return this.d(lineContent, wordSeparators2, position);
  }
  static d(lineContent, wordSeparators2, position) {
    let wordType = 0;
    const previousIntlWord = wordSeparators2.findPrevIntlWordBeforeOrAtOffset(lineContent, position.column - 2);
    for (let chIndex = position.column - 2; chIndex >= 0; chIndex--) {
      const chCode = lineContent.charCodeAt(chIndex);
      const chClass = wordSeparators2.get(chCode);
      if (previousIntlWord && chIndex === previousIntlWord.index) {
        return this.b(previousIntlWord, chClass);
      }
      if (chClass === 0) {
        if (wordType === 2) {
          return this.a(lineContent, wordType, chClass, chIndex + 1, this.e(lineContent, wordSeparators2, wordType, chIndex + 1));
        }
        wordType = 1;
      } else if (chClass === 2) {
        if (wordType === 1) {
          return this.a(lineContent, wordType, chClass, chIndex + 1, this.e(lineContent, wordSeparators2, wordType, chIndex + 1));
        }
        wordType = 2;
      } else if (chClass === 1) {
        if (wordType !== 0) {
          return this.a(lineContent, wordType, chClass, chIndex + 1, this.e(lineContent, wordSeparators2, wordType, chIndex + 1));
        }
      }
    }
    if (wordType !== 0) {
      return this.a(lineContent, wordType, 1, 0, this.e(lineContent, wordSeparators2, wordType, 0));
    }
    return null;
  }
  static e(lineContent, wordSeparators2, wordType, startIndex) {
    const nextIntlWord = wordSeparators2.findNextIntlWordAtOrAfterOffset(lineContent, startIndex);
    const len = lineContent.length;
    for (let chIndex = startIndex; chIndex < len; chIndex++) {
      const chCode = lineContent.charCodeAt(chIndex);
      const chClass = wordSeparators2.get(chCode);
      if (nextIntlWord && chIndex === nextIntlWord.index + nextIntlWord.segment.length) {
        return chIndex;
      }
      if (chClass === 1) {
        return chIndex;
      }
      if (wordType === 1 && chClass === 2) {
        return chIndex;
      }
      if (wordType === 2 && chClass === 0) {
        return chIndex;
      }
    }
    return len;
  }
  static f(wordSeparators2, model, position) {
    const lineContent = model.getLineContent(position.lineNumber);
    return this.g(lineContent, wordSeparators2, position);
  }
  static g(lineContent, wordSeparators2, position) {
    let wordType = 0;
    const len = lineContent.length;
    const nextIntlWord = wordSeparators2.findNextIntlWordAtOrAfterOffset(lineContent, position.column - 1);
    for (let chIndex = position.column - 1; chIndex < len; chIndex++) {
      const chCode = lineContent.charCodeAt(chIndex);
      const chClass = wordSeparators2.get(chCode);
      if (nextIntlWord && chIndex === nextIntlWord.index) {
        return this.b(nextIntlWord, chClass);
      }
      if (chClass === 0) {
        if (wordType === 2) {
          return this.a(lineContent, wordType, chClass, this.h(lineContent, wordSeparators2, wordType, chIndex - 1), chIndex);
        }
        wordType = 1;
      } else if (chClass === 2) {
        if (wordType === 1) {
          return this.a(lineContent, wordType, chClass, this.h(lineContent, wordSeparators2, wordType, chIndex - 1), chIndex);
        }
        wordType = 2;
      } else if (chClass === 1) {
        if (wordType !== 0) {
          return this.a(lineContent, wordType, chClass, this.h(lineContent, wordSeparators2, wordType, chIndex - 1), chIndex);
        }
      }
    }
    if (wordType !== 0) {
      return this.a(lineContent, wordType, 1, this.h(lineContent, wordSeparators2, wordType, len - 1), len);
    }
    return null;
  }
  static h(lineContent, wordSeparators2, wordType, startIndex) {
    const previousIntlWord = wordSeparators2.findPrevIntlWordBeforeOrAtOffset(lineContent, startIndex);
    for (let chIndex = startIndex; chIndex >= 0; chIndex--) {
      const chCode = lineContent.charCodeAt(chIndex);
      const chClass = wordSeparators2.get(chCode);
      if (previousIntlWord && chIndex === previousIntlWord.index) {
        return chIndex;
      }
      if (chClass === 1) {
        return chIndex + 1;
      }
      if (wordType === 1 && chClass === 2) {
        return chIndex + 1;
      }
      if (wordType === 2 && chClass === 0) {
        return chIndex + 1;
      }
    }
    return 0;
  }
  static moveWordLeft(wordSeparators2, model, position, wordNavigationType, hasMulticursor) {
    let lineNumber = position.lineNumber;
    let column = position.column;
    if (column === 1) {
      if (lineNumber > 1) {
        lineNumber = lineNumber - 1;
        column = model.getLineMaxColumn(lineNumber);
      }
    }
    let prevWordOnLine = _$q2.c(wordSeparators2, model, new $_t(lineNumber, column));
    if (wordNavigationType === 0) {
      return new $_t(lineNumber, prevWordOnLine ? prevWordOnLine.start + 1 : 1);
    }
    if (wordNavigationType === 1) {
      if (!hasMulticursor && prevWordOnLine && prevWordOnLine.wordType === 2 && prevWordOnLine.end - prevWordOnLine.start === 1 && prevWordOnLine.nextCharClass === 0) {
        prevWordOnLine = _$q2.c(wordSeparators2, model, new $_t(lineNumber, prevWordOnLine.start + 1));
      }
      return new $_t(lineNumber, prevWordOnLine ? prevWordOnLine.start + 1 : 1);
    }
    if (wordNavigationType === 3) {
      while (prevWordOnLine && prevWordOnLine.wordType === 2) {
        prevWordOnLine = _$q2.c(wordSeparators2, model, new $_t(lineNumber, prevWordOnLine.start + 1));
      }
      return new $_t(lineNumber, prevWordOnLine ? prevWordOnLine.start + 1 : 1);
    }
    if (prevWordOnLine && column <= prevWordOnLine.end + 1) {
      prevWordOnLine = _$q2.c(wordSeparators2, model, new $_t(lineNumber, prevWordOnLine.start + 1));
    }
    return new $_t(lineNumber, prevWordOnLine ? prevWordOnLine.end + 1 : 1);
  }
  static _moveWordPartLeft(model, position) {
    const lineNumber = position.lineNumber;
    const maxColumn = model.getLineMaxColumn(lineNumber);
    if (position.column === 1) {
      return lineNumber > 1 ? new $_t(lineNumber - 1, model.getLineMaxColumn(lineNumber - 1)) : position;
    }
    const lineContent = model.getLineContent(lineNumber);
    for (let column = position.column - 1; column > 1; column--) {
      const left = lineContent.charCodeAt(column - 2);
      const right = lineContent.charCodeAt(column - 1);
      if (left === 95 && right !== 95) {
        return new $_t(lineNumber, column);
      }
      if (left === 45 && right !== 45) {
        return new $_t(lineNumber, column);
      }
      if (($Xf(left) || $Wf(left)) && $Yf(right)) {
        return new $_t(lineNumber, column);
      }
      if ($Yf(left) && $Yf(right)) {
        if (column + 1 < maxColumn) {
          const rightRight = lineContent.charCodeAt(column);
          if ($Xf(rightRight) || $Wf(rightRight)) {
            return new $_t(lineNumber, column);
          }
        }
      }
    }
    return new $_t(lineNumber, 1);
  }
  static moveWordRight(wordSeparators2, model, position, wordNavigationType) {
    let lineNumber = position.lineNumber;
    let column = position.column;
    let movedDown = false;
    if (column === model.getLineMaxColumn(lineNumber)) {
      if (lineNumber < model.getLineCount()) {
        movedDown = true;
        lineNumber = lineNumber + 1;
        column = 1;
      }
    }
    let nextWordOnLine = _$q2.f(wordSeparators2, model, new $_t(lineNumber, column));
    if (wordNavigationType === 2) {
      if (nextWordOnLine && nextWordOnLine.wordType === 2) {
        if (nextWordOnLine.end - nextWordOnLine.start === 1 && nextWordOnLine.nextCharClass === 0) {
          nextWordOnLine = _$q2.f(wordSeparators2, model, new $_t(lineNumber, nextWordOnLine.end + 1));
        }
      }
      if (nextWordOnLine) {
        column = nextWordOnLine.end + 1;
      } else {
        column = model.getLineMaxColumn(lineNumber);
      }
    } else if (wordNavigationType === 3) {
      if (movedDown) {
        column = 0;
      }
      while (nextWordOnLine && (nextWordOnLine.wordType === 2 || nextWordOnLine.start + 1 <= column)) {
        nextWordOnLine = _$q2.f(wordSeparators2, model, new $_t(lineNumber, nextWordOnLine.end + 1));
      }
      if (nextWordOnLine) {
        column = nextWordOnLine.start + 1;
      } else {
        column = model.getLineMaxColumn(lineNumber);
      }
    } else {
      if (nextWordOnLine && !movedDown && column >= nextWordOnLine.start + 1) {
        nextWordOnLine = _$q2.f(wordSeparators2, model, new $_t(lineNumber, nextWordOnLine.end + 1));
      }
      if (nextWordOnLine) {
        column = nextWordOnLine.start + 1;
      } else {
        column = model.getLineMaxColumn(lineNumber);
      }
    }
    return new $_t(lineNumber, column);
  }
  static _moveWordPartRight(model, position) {
    const lineNumber = position.lineNumber;
    const maxColumn = model.getLineMaxColumn(lineNumber);
    if (position.column === maxColumn) {
      return lineNumber < model.getLineCount() ? new $_t(lineNumber + 1, 1) : position;
    }
    const lineContent = model.getLineContent(lineNumber);
    for (let column = position.column + 1; column < maxColumn; column++) {
      const left = lineContent.charCodeAt(column - 2);
      const right = lineContent.charCodeAt(column - 1);
      if (left !== 95 && right === 95) {
        return new $_t(lineNumber, column);
      }
      if (left !== 45 && right === 45) {
        return new $_t(lineNumber, column);
      }
      if (($Xf(left) || $Wf(left)) && $Yf(right)) {
        return new $_t(lineNumber, column);
      }
      if ($Yf(left) && $Yf(right)) {
        if (column + 1 < maxColumn) {
          const rightRight = lineContent.charCodeAt(column);
          if ($Xf(rightRight) || $Wf(rightRight)) {
            return new $_t(lineNumber, column);
          }
        }
      }
    }
    return new $_t(lineNumber, maxColumn);
  }
  static i(model, position) {
    const lineContent = model.getLineContent(position.lineNumber);
    const startIndex = position.column - 2;
    const lastNonWhitespace = $Pf(lineContent, startIndex);
    if (lastNonWhitespace + 1 < startIndex) {
      return new $au(position.lineNumber, lastNonWhitespace + 2, position.lineNumber, position.column);
    }
    return null;
  }
  static deleteWordLeft(ctx, wordNavigationType) {
    const wordSeparators2 = ctx.wordSeparators;
    const model = ctx.model;
    const selection = ctx.selection;
    const whitespaceHeuristics = ctx.whitespaceHeuristics;
    if (!selection.isEmpty()) {
      return selection;
    }
    if ($p2.isAutoClosingPairDelete(ctx.autoClosingDelete, ctx.autoClosingBrackets, ctx.autoClosingQuotes, ctx.autoClosingPairs.autoClosingPairsOpenByEnd, ctx.model, [ctx.selection], ctx.autoClosedCharacters)) {
      const position2 = ctx.selection.getPosition();
      return new $au(position2.lineNumber, position2.column - 1, position2.lineNumber, position2.column + 1);
    }
    const position = new $_t(selection.positionLineNumber, selection.positionColumn);
    let lineNumber = position.lineNumber;
    let column = position.column;
    if (lineNumber === 1 && column === 1) {
      return null;
    }
    if (whitespaceHeuristics) {
      const r2 = this.i(model, position);
      if (r2) {
        return r2;
      }
    }
    let prevWordOnLine = _$q2.c(wordSeparators2, model, position);
    if (wordNavigationType === 0) {
      if (prevWordOnLine) {
        column = prevWordOnLine.start + 1;
      } else {
        if (column > 1) {
          column = 1;
        } else {
          lineNumber--;
          column = model.getLineMaxColumn(lineNumber);
        }
      }
    } else {
      if (prevWordOnLine && column <= prevWordOnLine.end + 1) {
        prevWordOnLine = _$q2.c(wordSeparators2, model, new $_t(lineNumber, prevWordOnLine.start + 1));
      }
      if (prevWordOnLine) {
        column = prevWordOnLine.end + 1;
      } else {
        if (column > 1) {
          column = 1;
        } else {
          lineNumber--;
          column = model.getLineMaxColumn(lineNumber);
        }
      }
    }
    return new $au(lineNumber, column, position.lineNumber, position.column);
  }
  static deleteInsideWord(wordSeparators2, model, selection) {
    if (!selection.isEmpty()) {
      return selection;
    }
    const position = new $_t(selection.positionLineNumber, selection.positionColumn);
    const r2 = this.k(model, position);
    if (r2) {
      return r2;
    }
    return this.l(wordSeparators2, model, position);
  }
  static j(str, index) {
    const charCode = str.charCodeAt(index);
    return charCode === 32 || charCode === 9;
  }
  static k(model, position) {
    const lineContent = model.getLineContent(position.lineNumber);
    const lineContentLength = lineContent.length;
    if (lineContentLength === 0) {
      return null;
    }
    let leftIndex = Math.max(position.column - 2, 0);
    if (!this.j(lineContent, leftIndex)) {
      return null;
    }
    let rightIndex = Math.min(position.column - 1, lineContentLength - 1);
    if (!this.j(lineContent, rightIndex)) {
      return null;
    }
    while (leftIndex > 0 && this.j(lineContent, leftIndex - 1)) {
      leftIndex--;
    }
    while (rightIndex + 1 < lineContentLength && this.j(lineContent, rightIndex + 1)) {
      rightIndex++;
    }
    return new $au(position.lineNumber, leftIndex + 1, position.lineNumber, rightIndex + 2);
  }
  static l(wordSeparators2, model, position) {
    const lineContent = model.getLineContent(position.lineNumber);
    const lineLength = lineContent.length;
    if (lineLength === 0) {
      if (position.lineNumber > 1) {
        return new $au(position.lineNumber - 1, model.getLineMaxColumn(position.lineNumber - 1), position.lineNumber, 1);
      } else {
        if (position.lineNumber < model.getLineCount()) {
          return new $au(position.lineNumber, 1, position.lineNumber + 1, 1);
        } else {
          return new $au(position.lineNumber, 1, position.lineNumber, 1);
        }
      }
    }
    const touchesWord = (word) => {
      return word.start + 1 <= position.column && position.column <= word.end + 1;
    };
    const createRangeWithPosition = (startColumn, endColumn) => {
      startColumn = Math.min(startColumn, position.column);
      endColumn = Math.max(endColumn, position.column);
      return new $au(position.lineNumber, startColumn, position.lineNumber, endColumn);
    };
    const deleteWordAndAdjacentWhitespace = (word) => {
      let startColumn = word.start + 1;
      let endColumn = word.end + 1;
      let expandedToTheRight = false;
      while (endColumn - 1 < lineLength && this.j(lineContent, endColumn - 1)) {
        expandedToTheRight = true;
        endColumn++;
      }
      if (!expandedToTheRight) {
        while (startColumn > 1 && this.j(lineContent, startColumn - 2)) {
          startColumn--;
        }
      }
      return createRangeWithPosition(startColumn, endColumn);
    };
    const prevWordOnLine = _$q2.c(wordSeparators2, model, position);
    if (prevWordOnLine && touchesWord(prevWordOnLine)) {
      return deleteWordAndAdjacentWhitespace(prevWordOnLine);
    }
    const nextWordOnLine = _$q2.f(wordSeparators2, model, position);
    if (nextWordOnLine && touchesWord(nextWordOnLine)) {
      return deleteWordAndAdjacentWhitespace(nextWordOnLine);
    }
    if (prevWordOnLine && nextWordOnLine) {
      return createRangeWithPosition(prevWordOnLine.end + 1, nextWordOnLine.start + 1);
    }
    if (prevWordOnLine) {
      return createRangeWithPosition(prevWordOnLine.start + 1, prevWordOnLine.end + 1);
    }
    if (nextWordOnLine) {
      return createRangeWithPosition(nextWordOnLine.start + 1, nextWordOnLine.end + 1);
    }
    return createRangeWithPosition(1, lineLength + 1);
  }
  static _deleteWordPartLeft(model, selection) {
    if (!selection.isEmpty()) {
      return selection;
    }
    const pos = selection.getPosition();
    const toPosition = _$q2._moveWordPartLeft(model, pos);
    return new $au(pos.lineNumber, pos.column, toPosition.lineNumber, toPosition.column);
  }
  static m(str, startIndex) {
    const len = str.length;
    for (let chIndex = startIndex; chIndex < len; chIndex++) {
      const ch = str.charAt(chIndex);
      if (ch !== " " && ch !== "	") {
        return chIndex;
      }
    }
    return len;
  }
  static n(model, position) {
    const lineContent = model.getLineContent(position.lineNumber);
    const startIndex = position.column - 1;
    const firstNonWhitespace = this.m(lineContent, startIndex);
    if (startIndex + 1 < firstNonWhitespace) {
      return new $au(position.lineNumber, position.column, position.lineNumber, firstNonWhitespace + 1);
    }
    return null;
  }
  static deleteWordRight(ctx, wordNavigationType) {
    const wordSeparators2 = ctx.wordSeparators;
    const model = ctx.model;
    const selection = ctx.selection;
    const whitespaceHeuristics = ctx.whitespaceHeuristics;
    if (!selection.isEmpty()) {
      return selection;
    }
    const position = new $_t(selection.positionLineNumber, selection.positionColumn);
    let lineNumber = position.lineNumber;
    let column = position.column;
    const lineCount = model.getLineCount();
    const maxColumn = model.getLineMaxColumn(lineNumber);
    if (lineNumber === lineCount && column === maxColumn) {
      return null;
    }
    if (whitespaceHeuristics) {
      const r2 = this.n(model, position);
      if (r2) {
        return r2;
      }
    }
    let nextWordOnLine = _$q2.f(wordSeparators2, model, position);
    if (wordNavigationType === 2) {
      if (nextWordOnLine) {
        column = nextWordOnLine.end + 1;
      } else {
        if (column < maxColumn || lineNumber === lineCount) {
          column = maxColumn;
        } else {
          lineNumber++;
          nextWordOnLine = _$q2.f(wordSeparators2, model, new $_t(lineNumber, 1));
          if (nextWordOnLine) {
            column = nextWordOnLine.start + 1;
          } else {
            column = model.getLineMaxColumn(lineNumber);
          }
        }
      }
    } else {
      if (nextWordOnLine && column >= nextWordOnLine.start + 1) {
        nextWordOnLine = _$q2.f(wordSeparators2, model, new $_t(lineNumber, nextWordOnLine.end + 1));
      }
      if (nextWordOnLine) {
        column = nextWordOnLine.start + 1;
      } else {
        if (column < maxColumn || lineNumber === lineCount) {
          column = maxColumn;
        } else {
          lineNumber++;
          nextWordOnLine = _$q2.f(wordSeparators2, model, new $_t(lineNumber, 1));
          if (nextWordOnLine) {
            column = nextWordOnLine.start + 1;
          } else {
            column = model.getLineMaxColumn(lineNumber);
          }
        }
      }
    }
    return new $au(lineNumber, column, position.lineNumber, position.column);
  }
  static _deleteWordPartRight(model, selection) {
    if (!selection.isEmpty()) {
      return selection;
    }
    const pos = selection.getPosition();
    const toPosition = _$q2._moveWordPartRight(model, pos);
    return new $au(pos.lineNumber, pos.column, toPosition.lineNumber, toPosition.column);
  }
  static o(model, lineNumber, word) {
    const range2 = new $au(lineNumber, word.start + 1, lineNumber, word.end + 1);
    return {
      word: model.getValueInRange(range2),
      startColumn: range2.startColumn,
      endColumn: range2.endColumn
    };
  }
  static getWordAtPosition(model, _wordSeparators, _intlSegmenterLocales, position) {
    const wordSeparators2 = $Ku(_wordSeparators, _intlSegmenterLocales);
    const prevWord = _$q2.c(wordSeparators2, model, position);
    if (prevWord && prevWord.wordType === 1 && prevWord.start <= position.column - 1 && position.column - 1 <= prevWord.end) {
      return _$q2.o(model, position.lineNumber, prevWord);
    }
    const nextWord2 = _$q2.f(wordSeparators2, model, position);
    if (nextWord2 && nextWord2.wordType === 1 && nextWord2.start <= position.column - 1 && position.column - 1 <= nextWord2.end) {
      return _$q2.o(model, position.lineNumber, nextWord2);
    }
    return null;
  }
  static word(config, model, cursor, inSelectionMode, position) {
    const wordSeparators2 = $Ku(config.wordSeparators, config.wordSegmenterLocales);
    const prevWord = _$q2.c(wordSeparators2, model, position);
    const nextWord2 = _$q2.f(wordSeparators2, model, position);
    if (!inSelectionMode) {
      let startColumn2;
      let endColumn2;
      if (prevWord && prevWord.wordType === 1 && prevWord.start <= position.column - 1 && position.column - 1 <= prevWord.end) {
        startColumn2 = prevWord.start + 1;
        endColumn2 = prevWord.end + 1;
      } else if (nextWord2 && nextWord2.wordType === 1 && nextWord2.start <= position.column - 1 && position.column - 1 <= nextWord2.end) {
        startColumn2 = nextWord2.start + 1;
        endColumn2 = nextWord2.end + 1;
      } else {
        if (prevWord) {
          startColumn2 = prevWord.end + 1;
        } else {
          startColumn2 = 1;
        }
        if (nextWord2) {
          endColumn2 = nextWord2.start + 1;
        } else {
          endColumn2 = model.getLineMaxColumn(position.lineNumber);
        }
      }
      return new $n1(new $au(position.lineNumber, startColumn2, position.lineNumber, endColumn2), 1, 0, new $_t(position.lineNumber, endColumn2), 0);
    }
    let startColumn;
    let endColumn;
    if (prevWord && prevWord.wordType === 1 && prevWord.start < position.column - 1 && position.column - 1 < prevWord.end) {
      startColumn = prevWord.start + 1;
      endColumn = prevWord.end + 1;
    } else if (nextWord2 && nextWord2.wordType === 1 && nextWord2.start < position.column - 1 && position.column - 1 < nextWord2.end) {
      startColumn = nextWord2.start + 1;
      endColumn = nextWord2.end + 1;
    } else {
      startColumn = position.column;
      endColumn = position.column;
    }
    const lineNumber = position.lineNumber;
    let column;
    if (cursor.selectionStart.containsPosition(position)) {
      column = cursor.selectionStart.endColumn;
    } else if (position.isBeforeOrEqual(cursor.selectionStart.getStartPosition())) {
      column = startColumn;
      const possiblePosition = new $_t(lineNumber, column);
      if (cursor.selectionStart.containsPosition(possiblePosition)) {
        column = cursor.selectionStart.endColumn;
      }
    } else {
      column = endColumn;
      const possiblePosition = new $_t(lineNumber, column);
      if (cursor.selectionStart.containsPosition(possiblePosition)) {
        column = cursor.selectionStart.startColumn;
      }
    }
    return cursor.move(true, lineNumber, column, 0);
  }
};
var $r2 = class extends $q2 {
  static deleteWordPartLeft(ctx) {
    const candidates = enforceDefined([
      $q2.deleteWordLeft(
        ctx,
        0
        /* WordNavigationType.WordStart */
      ),
      $q2.deleteWordLeft(
        ctx,
        2
        /* WordNavigationType.WordEnd */
      ),
      $q2._deleteWordPartLeft(ctx.model, ctx.selection)
    ]);
    candidates.sort($au.compareRangesUsingEnds);
    return candidates[2];
  }
  static deleteWordPartRight(ctx) {
    const candidates = enforceDefined([
      $q2.deleteWordRight(
        ctx,
        0
        /* WordNavigationType.WordStart */
      ),
      $q2.deleteWordRight(
        ctx,
        2
        /* WordNavigationType.WordEnd */
      ),
      $q2._deleteWordPartRight(ctx.model, ctx.selection)
    ]);
    candidates.sort($au.compareRangesUsingStarts);
    return candidates[0];
  }
  static moveWordPartLeft(wordSeparators2, model, position, hasMulticursor) {
    const candidates = enforceDefined([
      $q2.moveWordLeft(wordSeparators2, model, position, 0, hasMulticursor),
      $q2.moveWordLeft(wordSeparators2, model, position, 2, hasMulticursor),
      $q2._moveWordPartLeft(model, position)
    ]);
    candidates.sort($_t.compare);
    return candidates[2];
  }
  static moveWordPartRight(wordSeparators2, model, position) {
    const candidates = enforceDefined([
      $q2.moveWordRight(
        wordSeparators2,
        model,
        position,
        0
        /* WordNavigationType.WordStart */
      ),
      $q2.moveWordRight(
        wordSeparators2,
        model,
        position,
        2
        /* WordNavigationType.WordEnd */
      ),
      $q2._moveWordPartRight(model, position)
    ]);
    candidates.sort($_t.compare);
    return candidates[0];
  }
};
function enforceDefined(arr) {
  return arr.filter((el) => Boolean(el));
}

// out-build/vs/editor/common/cursor/cursorMoveCommands.js
var $s2 = class {
  static addCursorDown(viewModel, cursors, useLogicalLine) {
    const result = [];
    let resultLen = 0;
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[resultLen++] = new $k1(cursor.modelState, cursor.viewState);
      if (useLogicalLine) {
        result[resultLen++] = $k1.fromModelState($o2.translateDown(viewModel.cursorConfig, viewModel.model, cursor.modelState));
      } else {
        result[resultLen++] = $k1.fromViewState($o2.translateDown(viewModel.cursorConfig, viewModel, cursor.viewState));
      }
    }
    return result;
  }
  static addCursorUp(viewModel, cursors, useLogicalLine) {
    const result = [];
    let resultLen = 0;
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[resultLen++] = new $k1(cursor.modelState, cursor.viewState);
      if (useLogicalLine) {
        result[resultLen++] = $k1.fromModelState($o2.translateUp(viewModel.cursorConfig, viewModel.model, cursor.modelState));
      } else {
        result[resultLen++] = $k1.fromViewState($o2.translateUp(viewModel.cursorConfig, viewModel, cursor.viewState));
      }
    }
    return result;
  }
  static moveToBeginningOfLine(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = this.a(viewModel, cursor, inSelectionMode);
    }
    return result;
  }
  static a(viewModel, cursor, inSelectionMode) {
    const currentViewStateColumn = cursor.viewState.position.column;
    const currentModelStateColumn = cursor.modelState.position.column;
    const isFirstLineOfWrappedLine = currentViewStateColumn === currentModelStateColumn;
    const currentViewStatelineNumber = cursor.viewState.position.lineNumber;
    const firstNonBlankColumn = viewModel.getLineFirstNonWhitespaceColumn(currentViewStatelineNumber);
    const isBeginningOfViewLine = currentViewStateColumn === firstNonBlankColumn;
    if (!isFirstLineOfWrappedLine && !isBeginningOfViewLine) {
      return this.b(viewModel, cursor, inSelectionMode);
    } else {
      return this.c(viewModel, cursor, inSelectionMode);
    }
  }
  static b(viewModel, cursor, inSelectionMode) {
    return $k1.fromViewState($o2.moveToBeginningOfLine(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode));
  }
  static c(viewModel, cursor, inSelectionMode) {
    return $k1.fromModelState($o2.moveToBeginningOfLine(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode));
  }
  static moveToEndOfLine(viewModel, cursors, inSelectionMode, sticky) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = this.d(viewModel, cursor, inSelectionMode, sticky);
    }
    return result;
  }
  static d(viewModel, cursor, inSelectionMode, sticky) {
    const viewStatePosition = cursor.viewState.position;
    const viewModelMaxColumn = viewModel.getLineMaxColumn(viewStatePosition.lineNumber);
    const isEndOfViewLine = viewStatePosition.column === viewModelMaxColumn;
    const modelStatePosition = cursor.modelState.position;
    const modelMaxColumn = viewModel.model.getLineMaxColumn(modelStatePosition.lineNumber);
    const isEndLineOfWrappedLine = viewModelMaxColumn - viewStatePosition.column === modelMaxColumn - modelStatePosition.column;
    if (isEndOfViewLine || isEndLineOfWrappedLine) {
      return this.f(viewModel, cursor, inSelectionMode, sticky);
    } else {
      return this.e(viewModel, cursor, inSelectionMode, sticky);
    }
  }
  static e(viewModel, cursor, inSelectionMode, sticky) {
    return $k1.fromViewState($o2.moveToEndOfLine(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode, sticky));
  }
  static f(viewModel, cursor, inSelectionMode, sticky) {
    return $k1.fromModelState($o2.moveToEndOfLine(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode, sticky));
  }
  static expandLineSelection(viewModel, cursors) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const startLineNumber = cursor.modelState.selection.startLineNumber;
      const lineCount = viewModel.model.getLineCount();
      let endLineNumber = cursor.modelState.selection.endLineNumber;
      let endColumn;
      if (endLineNumber === lineCount) {
        endColumn = viewModel.model.getLineMaxColumn(lineCount);
      } else {
        endLineNumber++;
        endColumn = 1;
      }
      result[i] = $k1.fromModelState(new $n1(new $au(startLineNumber, 1, startLineNumber, 1), 0, 0, new $_t(endLineNumber, endColumn), 0));
    }
    return result;
  }
  static moveToBeginningOfBuffer(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = $k1.fromModelState($o2.moveToBeginningOfBuffer(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode));
    }
    return result;
  }
  static moveToEndOfBuffer(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = $k1.fromModelState($o2.moveToEndOfBuffer(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode));
    }
    return result;
  }
  static selectAll(viewModel, cursor) {
    const lineCount = viewModel.model.getLineCount();
    const maxColumn = viewModel.model.getLineMaxColumn(lineCount);
    return $k1.fromModelState(new $n1(new $au(1, 1, 1, 1), 0, 0, new $_t(lineCount, maxColumn), 0));
  }
  static line(viewModel, cursor, inSelectionMode, _position, _viewPosition) {
    const position = viewModel.model.validatePosition(_position);
    const viewPosition = _viewPosition ? viewModel.coordinatesConverter.validateViewPosition(new $_t(_viewPosition.lineNumber, _viewPosition.column), position) : viewModel.coordinatesConverter.convertModelPositionToViewPosition(position);
    if (!inSelectionMode) {
      const lineCount = viewModel.model.getLineCount();
      let selectToLineNumber = position.lineNumber + 1;
      let selectToColumn = 1;
      if (selectToLineNumber > lineCount) {
        selectToLineNumber = lineCount;
        selectToColumn = viewModel.model.getLineMaxColumn(selectToLineNumber);
      }
      return $k1.fromModelState(new $n1(new $au(position.lineNumber, 1, selectToLineNumber, selectToColumn), 2, 0, new $_t(selectToLineNumber, selectToColumn), 0));
    }
    const enteringLineNumber = cursor.modelState.selectionStart.getStartPosition().lineNumber;
    if (position.lineNumber < enteringLineNumber) {
      return $k1.fromViewState(cursor.viewState.move(true, viewPosition.lineNumber, 1, 0));
    } else if (position.lineNumber > enteringLineNumber) {
      const lineCount = viewModel.getLineCount();
      let selectToViewLineNumber = viewPosition.lineNumber + 1;
      let selectToViewColumn = 1;
      if (selectToViewLineNumber > lineCount) {
        selectToViewLineNumber = lineCount;
        selectToViewColumn = viewModel.getLineMaxColumn(selectToViewLineNumber);
      }
      return $k1.fromViewState(cursor.viewState.move(true, selectToViewLineNumber, selectToViewColumn, 0));
    } else {
      const endPositionOfSelectionStart = cursor.modelState.selectionStart.getEndPosition();
      return $k1.fromModelState(cursor.modelState.move(true, endPositionOfSelectionStart.lineNumber, endPositionOfSelectionStart.column, 0));
    }
  }
  static word(viewModel, cursor, inSelectionMode, _position) {
    const position = viewModel.model.validatePosition(_position);
    return $k1.fromModelState($q2.word(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode, position));
  }
  static cancelSelection(viewModel, cursor) {
    if (!cursor.modelState.hasSelection()) {
      return new $k1(cursor.modelState, cursor.viewState);
    }
    const lineNumber = cursor.viewState.position.lineNumber;
    const column = cursor.viewState.position.column;
    return $k1.fromViewState(new $n1(new $au(lineNumber, column, lineNumber, column), 0, 0, new $_t(lineNumber, column), 0));
  }
  static moveTo(viewModel, cursor, inSelectionMode, _position, _viewPosition) {
    if (inSelectionMode) {
      if (cursor.modelState.selectionStartKind === 1) {
        return this.word(viewModel, cursor, inSelectionMode, _position);
      }
      if (cursor.modelState.selectionStartKind === 2) {
        return this.line(viewModel, cursor, inSelectionMode, _position, _viewPosition);
      }
    }
    const position = viewModel.model.validatePosition(_position);
    const viewPosition = _viewPosition ? viewModel.coordinatesConverter.validateViewPosition(new $_t(_viewPosition.lineNumber, _viewPosition.column), position) : viewModel.coordinatesConverter.convertModelPositionToViewPosition(position);
    return $k1.fromViewState(cursor.viewState.move(inSelectionMode, viewPosition.lineNumber, viewPosition.column, 0));
  }
  static simpleMove(viewModel, cursors, direction, inSelectionMode, value, unit) {
    switch (direction) {
      case 0: {
        if (unit === 4) {
          return this.k(viewModel, cursors, inSelectionMode);
        } else {
          return this.j(viewModel, cursors, inSelectionMode, value);
        }
      }
      case 1: {
        if (unit === 4) {
          return this.m(viewModel, cursors, inSelectionMode);
        } else {
          return this.l(viewModel, cursors, inSelectionMode, value);
        }
      }
      case 2: {
        if (unit === 2) {
          return this.p(viewModel, cursors, inSelectionMode, value);
        } else {
          return this.q(viewModel, cursors, inSelectionMode, value);
        }
      }
      case 3: {
        if (unit === 2) {
          return this.n(viewModel, cursors, inSelectionMode, value);
        } else {
          return this.o(viewModel, cursors, inSelectionMode, value);
        }
      }
      case 4: {
        if (unit === 2) {
          return cursors.map((cursor) => $k1.fromViewState($o2.moveToPrevBlankLine(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode)));
        } else {
          return cursors.map((cursor) => $k1.fromModelState($o2.moveToPrevBlankLine(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode)));
        }
      }
      case 5: {
        if (unit === 2) {
          return cursors.map((cursor) => $k1.fromViewState($o2.moveToNextBlankLine(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode)));
        } else {
          return cursors.map((cursor) => $k1.fromModelState($o2.moveToNextBlankLine(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode)));
        }
      }
      case 6: {
        return this.t(viewModel, cursors, inSelectionMode);
      }
      case 7: {
        return this.u(viewModel, cursors, inSelectionMode);
      }
      case 8: {
        return this.v(viewModel, cursors, inSelectionMode);
      }
      case 9: {
        return this.w(viewModel, cursors, inSelectionMode);
      }
      case 10: {
        return this.x(viewModel, cursors, inSelectionMode);
      }
      default:
        return null;
    }
  }
  static viewportMove(viewModel, cursors, direction, inSelectionMode, value) {
    const visibleViewRange = viewModel.getCompletelyVisibleViewRange();
    const visibleModelRange = viewModel.coordinatesConverter.convertViewRangeToModelRange(visibleViewRange);
    switch (direction) {
      case 11: {
        const modelLineNumber = this.g(viewModel.model, visibleModelRange, value);
        const modelColumn = viewModel.model.getLineFirstNonWhitespaceColumn(modelLineNumber);
        return [this.s(viewModel, cursors[0], inSelectionMode, modelLineNumber, modelColumn)];
      }
      case 13: {
        const modelLineNumber = this.h(viewModel.model, visibleModelRange, value);
        const modelColumn = viewModel.model.getLineFirstNonWhitespaceColumn(modelLineNumber);
        return [this.s(viewModel, cursors[0], inSelectionMode, modelLineNumber, modelColumn)];
      }
      case 12: {
        const modelLineNumber = Math.round((visibleModelRange.startLineNumber + visibleModelRange.endLineNumber) / 2);
        const modelColumn = viewModel.model.getLineFirstNonWhitespaceColumn(modelLineNumber);
        return [this.s(viewModel, cursors[0], inSelectionMode, modelLineNumber, modelColumn)];
      }
      case 14: {
        const result = [];
        for (let i = 0, len = cursors.length; i < len; i++) {
          const cursor = cursors[i];
          result[i] = this.findPositionInViewportIfOutside(viewModel, cursor, visibleViewRange, inSelectionMode);
        }
        return result;
      }
      default:
        return null;
    }
  }
  static findPositionInViewportIfOutside(viewModel, cursor, visibleViewRange, inSelectionMode) {
    const viewLineNumber = cursor.viewState.position.lineNumber;
    if (visibleViewRange.startLineNumber <= viewLineNumber && viewLineNumber <= visibleViewRange.endLineNumber - 1) {
      return new $k1(cursor.modelState, cursor.viewState);
    } else {
      let newViewLineNumber;
      if (viewLineNumber > visibleViewRange.endLineNumber - 1) {
        newViewLineNumber = visibleViewRange.endLineNumber - 1;
      } else if (viewLineNumber < visibleViewRange.startLineNumber) {
        newViewLineNumber = visibleViewRange.startLineNumber;
      } else {
        newViewLineNumber = viewLineNumber;
      }
      const position = $o2.vertical(viewModel.cursorConfig, viewModel, viewLineNumber, cursor.viewState.position.column, cursor.viewState.leftoverVisibleColumns, newViewLineNumber, false);
      return $k1.fromViewState(cursor.viewState.move(inSelectionMode, position.lineNumber, position.column, position.leftoverVisibleColumns));
    }
  }
  /**
   * Find the nth line start included in the range (from the start).
   */
  static g(model, range2, count) {
    let startLineNumber = range2.startLineNumber;
    if (range2.startColumn !== model.getLineMinColumn(startLineNumber)) {
      startLineNumber++;
    }
    return Math.min(range2.endLineNumber, startLineNumber + count - 1);
  }
  /**
   * Find the nth line start included in the range (from the end).
   */
  static h(model, range2, count) {
    let startLineNumber = range2.startLineNumber;
    if (range2.startColumn !== model.getLineMinColumn(startLineNumber)) {
      startLineNumber++;
    }
    return Math.max(startLineNumber, range2.endLineNumber - count + 1);
  }
  static j(viewModel, cursors, inSelectionMode, noOfColumns) {
    return cursors.map((cursor) => $k1.fromViewState($o2.moveLeft(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode, noOfColumns)));
  }
  static k(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const viewLineNumber = cursor.viewState.position.lineNumber;
      const halfLine = Math.round(viewModel.getLineLength(viewLineNumber) / 2);
      result[i] = $k1.fromViewState($o2.moveLeft(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode, halfLine));
    }
    return result;
  }
  static l(viewModel, cursors, inSelectionMode, noOfColumns) {
    return cursors.map((cursor) => $k1.fromViewState($o2.moveRight(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode, noOfColumns)));
  }
  static m(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const viewLineNumber = cursor.viewState.position.lineNumber;
      const halfLine = Math.round(viewModel.getLineLength(viewLineNumber) / 2);
      result[i] = $k1.fromViewState($o2.moveRight(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode, halfLine));
    }
    return result;
  }
  static n(viewModel, cursors, inSelectionMode, linesCount) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = $k1.fromViewState($o2.moveDown(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode, linesCount));
    }
    return result;
  }
  static o(viewModel, cursors, inSelectionMode, linesCount) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = $k1.fromModelState($o2.moveDown(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode, linesCount));
    }
    return result;
  }
  static p(viewModel, cursors, inSelectionMode, linesCount) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = $k1.fromViewState($o2.moveUp(viewModel.cursorConfig, viewModel, cursor.viewState, inSelectionMode, linesCount));
    }
    return result;
  }
  static q(viewModel, cursors, inSelectionMode, linesCount) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      result[i] = $k1.fromModelState($o2.moveUp(viewModel.cursorConfig, viewModel.model, cursor.modelState, inSelectionMode, linesCount));
    }
    return result;
  }
  static r(viewModel, cursor, inSelectionMode, toViewLineNumber, toViewColumn) {
    return $k1.fromViewState(cursor.viewState.move(inSelectionMode, toViewLineNumber, toViewColumn, 0));
  }
  static s(viewModel, cursor, inSelectionMode, toModelLineNumber, toModelColumn) {
    return $k1.fromModelState(cursor.modelState.move(inSelectionMode, toModelLineNumber, toModelColumn, 0));
  }
  static t(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const viewLineNumber = cursor.viewState.position.lineNumber;
      const viewColumn = viewModel.getLineMinColumn(viewLineNumber);
      result[i] = this.r(viewModel, cursor, inSelectionMode, viewLineNumber, viewColumn);
    }
    return result;
  }
  static u(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const viewLineNumber = cursor.viewState.position.lineNumber;
      const viewColumn = viewModel.getLineFirstNonWhitespaceColumn(viewLineNumber);
      result[i] = this.r(viewModel, cursor, inSelectionMode, viewLineNumber, viewColumn);
    }
    return result;
  }
  static v(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const viewLineNumber = cursor.viewState.position.lineNumber;
      const viewColumn = Math.round((viewModel.getLineMaxColumn(viewLineNumber) + viewModel.getLineMinColumn(viewLineNumber)) / 2);
      result[i] = this.r(viewModel, cursor, inSelectionMode, viewLineNumber, viewColumn);
    }
    return result;
  }
  static w(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const viewLineNumber = cursor.viewState.position.lineNumber;
      const viewColumn = viewModel.getLineMaxColumn(viewLineNumber);
      result[i] = this.r(viewModel, cursor, inSelectionMode, viewLineNumber, viewColumn);
    }
    return result;
  }
  static x(viewModel, cursors, inSelectionMode) {
    const result = [];
    for (let i = 0, len = cursors.length; i < len; i++) {
      const cursor = cursors[i];
      const viewLineNumber = cursor.viewState.position.lineNumber;
      const viewColumn = viewModel.getLineLastNonWhitespaceColumn(viewLineNumber);
      result[i] = this.r(viewModel, cursor, inSelectionMode, viewLineNumber, viewColumn);
    }
    return result;
  }
};
var CursorMove;
(function(CursorMove2) {
  const isCursorMoveArgs = function(arg) {
    if (!$Ag(arg)) {
      return false;
    }
    const cursorMoveArg = arg;
    if (!$yg(cursorMoveArg.to)) {
      return false;
    }
    if (!$Fg(cursorMoveArg.select) && !$Eg(cursorMoveArg.select)) {
      return false;
    }
    if (!$Fg(cursorMoveArg.by) && !$yg(cursorMoveArg.by)) {
      return false;
    }
    if (!$Fg(cursorMoveArg.value) && !$Cg(cursorMoveArg.value)) {
      return false;
    }
    return true;
  };
  CursorMove2.metadata = {
    description: "Move cursor to a logical position in the view",
    args: [
      {
        name: "Cursor move argument object",
        description: `Property-value pairs that can be passed through this argument:
					* 'to': A mandatory logical position value providing where to move the cursor.
						\`\`\`
						'left', 'right', 'up', 'down', 'prevBlankLine', 'nextBlankLine',
						'wrappedLineStart', 'wrappedLineEnd', 'wrappedLineColumnCenter'
						'wrappedLineFirstNonWhitespaceCharacter', 'wrappedLineLastNonWhitespaceCharacter'
						'viewPortTop', 'viewPortCenter', 'viewPortBottom', 'viewPortIfOutside'
						\`\`\`
					* 'by': Unit to move. Default is computed based on 'to' value.
						\`\`\`
						'line', 'wrappedLine', 'character', 'halfLine'
						\`\`\`
					* 'value': Number of units to move. Default is '1'.
					* 'select': If 'true' makes the selection. Default is 'false'.
				`,
        constraint: isCursorMoveArgs,
        schema: {
          "type": "object",
          "required": ["to"],
          "properties": {
            "to": {
              "type": "string",
              "enum": ["left", "right", "up", "down", "prevBlankLine", "nextBlankLine", "wrappedLineStart", "wrappedLineEnd", "wrappedLineColumnCenter", "wrappedLineFirstNonWhitespaceCharacter", "wrappedLineLastNonWhitespaceCharacter", "viewPortTop", "viewPortCenter", "viewPortBottom", "viewPortIfOutside"]
            },
            "by": {
              "type": "string",
              "enum": ["line", "wrappedLine", "character", "halfLine"]
            },
            "value": {
              "type": "number",
              "default": 1
            },
            "select": {
              "type": "boolean",
              "default": false
            }
          }
        }
      }
    ]
  };
  CursorMove2.RawDirection = {
    Left: "left",
    Right: "right",
    Up: "up",
    Down: "down",
    PrevBlankLine: "prevBlankLine",
    NextBlankLine: "nextBlankLine",
    WrappedLineStart: "wrappedLineStart",
    WrappedLineFirstNonWhitespaceCharacter: "wrappedLineFirstNonWhitespaceCharacter",
    WrappedLineColumnCenter: "wrappedLineColumnCenter",
    WrappedLineEnd: "wrappedLineEnd",
    WrappedLineLastNonWhitespaceCharacter: "wrappedLineLastNonWhitespaceCharacter",
    ViewPortTop: "viewPortTop",
    ViewPortCenter: "viewPortCenter",
    ViewPortBottom: "viewPortBottom",
    ViewPortIfOutside: "viewPortIfOutside"
  };
  CursorMove2.RawUnit = {
    Line: "line",
    WrappedLine: "wrappedLine",
    Character: "character",
    HalfLine: "halfLine"
  };
  function parse5(args2) {
    if (!args2.to) {
      return null;
    }
    let direction;
    switch (args2.to) {
      case CursorMove2.RawDirection.Left:
        direction = 0;
        break;
      case CursorMove2.RawDirection.Right:
        direction = 1;
        break;
      case CursorMove2.RawDirection.Up:
        direction = 2;
        break;
      case CursorMove2.RawDirection.Down:
        direction = 3;
        break;
      case CursorMove2.RawDirection.PrevBlankLine:
        direction = 4;
        break;
      case CursorMove2.RawDirection.NextBlankLine:
        direction = 5;
        break;
      case CursorMove2.RawDirection.WrappedLineStart:
        direction = 6;
        break;
      case CursorMove2.RawDirection.WrappedLineFirstNonWhitespaceCharacter:
        direction = 7;
        break;
      case CursorMove2.RawDirection.WrappedLineColumnCenter:
        direction = 8;
        break;
      case CursorMove2.RawDirection.WrappedLineEnd:
        direction = 9;
        break;
      case CursorMove2.RawDirection.WrappedLineLastNonWhitespaceCharacter:
        direction = 10;
        break;
      case CursorMove2.RawDirection.ViewPortTop:
        direction = 11;
        break;
      case CursorMove2.RawDirection.ViewPortBottom:
        direction = 13;
        break;
      case CursorMove2.RawDirection.ViewPortCenter:
        direction = 12;
        break;
      case CursorMove2.RawDirection.ViewPortIfOutside:
        direction = 14;
        break;
      default:
        return null;
    }
    let unit = 0;
    switch (args2.by) {
      case CursorMove2.RawUnit.Line:
        unit = 1;
        break;
      case CursorMove2.RawUnit.WrappedLine:
        unit = 2;
        break;
      case CursorMove2.RawUnit.Character:
        unit = 3;
        break;
      case CursorMove2.RawUnit.HalfLine:
        unit = 4;
        break;
    }
    return {
      direction,
      unit,
      select: !!args2.select,
      value: args2.value || 1
    };
  }
  CursorMove2.parse = parse5;
  let Direction4;
  (function(Direction5) {
    Direction5[Direction5["Left"] = 0] = "Left";
    Direction5[Direction5["Right"] = 1] = "Right";
    Direction5[Direction5["Up"] = 2] = "Up";
    Direction5[Direction5["Down"] = 3] = "Down";
    Direction5[Direction5["PrevBlankLine"] = 4] = "PrevBlankLine";
    Direction5[Direction5["NextBlankLine"] = 5] = "NextBlankLine";
    Direction5[Direction5["WrappedLineStart"] = 6] = "WrappedLineStart";
    Direction5[Direction5["WrappedLineFirstNonWhitespaceCharacter"] = 7] = "WrappedLineFirstNonWhitespaceCharacter";
    Direction5[Direction5["WrappedLineColumnCenter"] = 8] = "WrappedLineColumnCenter";
    Direction5[Direction5["WrappedLineEnd"] = 9] = "WrappedLineEnd";
    Direction5[Direction5["WrappedLineLastNonWhitespaceCharacter"] = 10] = "WrappedLineLastNonWhitespaceCharacter";
    Direction5[Direction5["ViewPortTop"] = 11] = "ViewPortTop";
    Direction5[Direction5["ViewPortCenter"] = 12] = "ViewPortCenter";
    Direction5[Direction5["ViewPortBottom"] = 13] = "ViewPortBottom";
    Direction5[Direction5["ViewPortIfOutside"] = 14] = "ViewPortIfOutside";
  })(Direction4 = CursorMove2.Direction || (CursorMove2.Direction = {}));
  let Unit;
  (function(Unit2) {
    Unit2[Unit2["None"] = 0] = "None";
    Unit2[Unit2["Line"] = 1] = "Line";
    Unit2[Unit2["WrappedLine"] = 2] = "WrappedLine";
    Unit2[Unit2["Character"] = 3] = "Character";
    Unit2[Unit2["HalfLine"] = 4] = "HalfLine";
  })(Unit = CursorMove2.Unit || (CursorMove2.Unit = {}));
})(CursorMove || (CursorMove = {}));

// out-build/vs/editor/common/languages/languageConfiguration.js
var IndentAction;
(function(IndentAction3) {
  IndentAction3[IndentAction3["None"] = 0] = "None";
  IndentAction3[IndentAction3["Indent"] = 1] = "Indent";
  IndentAction3[IndentAction3["IndentOutdent"] = 2] = "IndentOutdent";
  IndentAction3[IndentAction3["Outdent"] = 3] = "Outdent";
})(IndentAction || (IndentAction = {}));
var $yv = class {
  constructor(source) {
    this.e = null;
    this.f = false;
    this.open = source.open;
    this.close = source.close;
    this.b = true;
    this.c = true;
    this.d = true;
    if (Array.isArray(source.notIn)) {
      for (let i = 0, len = source.notIn.length; i < len; i++) {
        const notIn = source.notIn[i];
        switch (notIn) {
          case "string":
            this.b = false;
            break;
          case "comment":
            this.c = false;
            break;
          case "regex":
            this.d = false;
            break;
        }
      }
    }
  }
  isOK(standardToken) {
    switch (standardToken) {
      case 0:
        return true;
      case 1:
        return this.c;
      case 2:
        return this.b;
      case 3:
        return this.d;
    }
  }
  shouldAutoClose(context, column) {
    if (context.getTokenCount() === 0) {
      return true;
    }
    const tokenIndex = context.findTokenIndexAtOffset(column - 2);
    const standardTokenType = context.getStandardTokenType(tokenIndex);
    return this.isOK(standardTokenType);
  }
  g(fromCharCode, toCharCode) {
    for (let charCode = fromCharCode; charCode <= toCharCode; charCode++) {
      const character = String.fromCharCode(charCode);
      if (!this.open.includes(character) && !this.close.includes(character)) {
        return character;
      }
    }
    return null;
  }
  /**
   * Find a character in the range [0-9a-zA-Z] that does not appear in the open or close
   */
  findNeutralCharacter() {
    if (!this.f) {
      this.f = true;
      if (!this.e) {
        this.e = this.g(
          48,
          57
          /* CharCode.Digit9 */
        );
      }
      if (!this.e) {
        this.e = this.g(
          97,
          122
          /* CharCode.z */
        );
      }
      if (!this.e) {
        this.e = this.g(
          65,
          90
          /* CharCode.Z */
        );
      }
    }
    return this.e;
  }
};
var $zv = class {
  constructor(autoClosingPairs) {
    this.autoClosingPairsOpenByStart = /* @__PURE__ */ new Map();
    this.autoClosingPairsOpenByEnd = /* @__PURE__ */ new Map();
    this.autoClosingPairsCloseByStart = /* @__PURE__ */ new Map();
    this.autoClosingPairsCloseByEnd = /* @__PURE__ */ new Map();
    this.autoClosingPairsCloseSingleChar = /* @__PURE__ */ new Map();
    for (const pair of autoClosingPairs) {
      appendEntry(this.autoClosingPairsOpenByStart, pair.open.charAt(0), pair);
      appendEntry(this.autoClosingPairsOpenByEnd, pair.open.charAt(pair.open.length - 1), pair);
      appendEntry(this.autoClosingPairsCloseByStart, pair.close.charAt(0), pair);
      appendEntry(this.autoClosingPairsCloseByEnd, pair.close.charAt(pair.close.length - 1), pair);
      if (pair.close.length === 1 && pair.open.length === 1) {
        appendEntry(this.autoClosingPairsCloseSingleChar, pair.close, pair);
      }
    }
  }
};
function appendEntry(target, key, value) {
  if (target.has(key)) {
    target.get(key).push(value);
  } else {
    target.set(key, [value]);
  }
}

// out-build/vs/editor/common/core/wordHelper.js
var $It = "`~!@#$%^&*()-=+[{]}\\|;:'\",.<>/?";
function createWordRegExp(allowInWords = "") {
  let source = "(-?\\d*\\.\\d\\w*)|([^";
  for (const sep2 of $It) {
    if (allowInWords.indexOf(sep2) >= 0) {
      continue;
    }
    source += "\\" + sep2;
  }
  source += "\\s]+)";
  return new RegExp(source, "g");
}
var $Jt = createWordRegExp();
function $Kt(wordDefinition) {
  let result = $Jt;
  if (wordDefinition && wordDefinition instanceof RegExp) {
    if (!wordDefinition.global) {
      let flags = "g";
      if (wordDefinition.ignoreCase) {
        flags += "i";
      }
      if (wordDefinition.multiline) {
        flags += "m";
      }
      if (wordDefinition.unicode) {
        flags += "u";
      }
      result = new RegExp(wordDefinition.source, flags);
    } else {
      result = wordDefinition;
    }
  }
  result.lastIndex = 0;
  return result;
}
var _defaultConfig = new $hd();
_defaultConfig.unshift({
  maxLen: 1e3,
  windowSize: 15,
  timeBudget: 150
});
function $Mt(column, wordDefinition, text2, textOffset, config) {
  wordDefinition = $Kt(wordDefinition);
  if (!config) {
    config = Iterable.first(_defaultConfig);
  }
  if (text2.length > config.maxLen) {
    let start = column - config.maxLen / 2;
    if (start < 0) {
      start = 0;
    } else {
      textOffset += start;
    }
    text2 = text2.substring(start, column + config.maxLen / 2);
    return $Mt(column, wordDefinition, text2, textOffset, config);
  }
  const t1 = Date.now();
  const pos = column - 1 - textOffset;
  let prevRegexIndex = -1;
  let match = null;
  for (let i = 1; ; i++) {
    if (Date.now() - t1 >= config.timeBudget) {
      break;
    }
    const regexIndex = pos - config.windowSize * i;
    wordDefinition.lastIndex = Math.max(0, regexIndex);
    const thisMatch = _findRegexMatchEnclosingPosition(wordDefinition, text2, pos, prevRegexIndex);
    if (!thisMatch && match) {
      break;
    }
    match = thisMatch;
    if (regexIndex <= 0) {
      break;
    }
    prevRegexIndex = regexIndex;
  }
  if (match) {
    const result = {
      word: match[0],
      startColumn: textOffset + 1 + match.index,
      endColumn: textOffset + 1 + match.index + match[0].length
    };
    wordDefinition.lastIndex = 0;
    return result;
  }
  return null;
}
function _findRegexMatchEnclosingPosition(wordDefinition, text2, pos, stopPos) {
  let match;
  while (match = wordDefinition.exec(text2)) {
    const matchIndex = match.index || 0;
    if (matchIndex <= pos && wordDefinition.lastIndex >= pos) {
      return match;
    } else if (stopPos > 0 && matchIndex > stopPos) {
      return null;
    }
  }
  return null;
}

// out-build/vs/editor/common/languages/supports/characterPair.js
var $0v = class _$0v {
  static {
    this.DEFAULT_AUTOCLOSE_BEFORE_LANGUAGE_DEFINED_QUOTES = ";:.,=}])> \n	";
  }
  static {
    this.DEFAULT_AUTOCLOSE_BEFORE_LANGUAGE_DEFINED_BRACKETS = "'\"`;:.,=}])> \n	";
  }
  static {
    this.DEFAULT_AUTOCLOSE_BEFORE_WHITESPACE = " \n	";
  }
  constructor(config) {
    if (config.autoClosingPairs) {
      this.a = config.autoClosingPairs.map((el) => new $yv(el));
    } else if (config.brackets) {
      this.a = config.brackets.map((b) => new $yv({ open: b[0], close: b[1] }));
    } else {
      this.a = [];
    }
    if (config.__electricCharacterSupport && config.__electricCharacterSupport.docComment) {
      const docComment = config.__electricCharacterSupport.docComment;
      this.a.push(new $yv({ open: docComment.open, close: docComment.close || "" }));
    }
    this.d = typeof config.autoCloseBefore === "string" ? config.autoCloseBefore : _$0v.DEFAULT_AUTOCLOSE_BEFORE_LANGUAGE_DEFINED_QUOTES;
    this.e = typeof config.autoCloseBefore === "string" ? config.autoCloseBefore : _$0v.DEFAULT_AUTOCLOSE_BEFORE_LANGUAGE_DEFINED_BRACKETS;
    this.c = config.surroundingPairs || this.a;
  }
  getAutoClosingPairs() {
    return this.a;
  }
  getAutoCloseBeforeSet(forQuotes) {
    return forQuotes ? this.d : this.e;
  }
  getSurroundingPairs() {
    return this.c;
  }
};

// out-build/vs/base/common/stream.js
function $Se(obj) {
  const candidate = obj;
  if (!candidate) {
    return false;
  }
  return [candidate.on, candidate.pause, candidate.resume, candidate.destroy].every((fn) => typeof fn === "function");
}
function $Te(obj) {
  const candidate = obj;
  if (!candidate) {
    return false;
  }
  return $Se(candidate.stream) && Array.isArray(candidate.buffer) && typeof candidate.ended === "boolean";
}
function $Ue(reducer, options3) {
  return new WriteableStreamImpl(reducer, options3);
}
var WriteableStreamImpl = class {
  constructor(e, f) {
    this.e = e;
    this.f = f;
    this.a = {
      flowing: false,
      ended: false,
      destroyed: false
    };
    this.b = {
      data: [],
      error: []
    };
    this.c = {
      data: [],
      error: [],
      end: []
    };
    this.d = [];
  }
  pause() {
    if (this.a.destroyed) {
      return;
    }
    this.a.flowing = false;
  }
  resume() {
    if (this.a.destroyed) {
      return;
    }
    if (!this.a.flowing) {
      this.a.flowing = true;
      this.j();
      this.k();
      this.l();
    }
  }
  write(data) {
    if (this.a.destroyed) {
      return;
    }
    if (this.a.flowing) {
      this.g(data);
    } else {
      this.b.data.push(data);
      if (typeof this.f?.highWaterMark === "number" && this.b.data.length > this.f.highWaterMark) {
        return new Promise((resolve) => this.d.push(resolve));
      }
    }
  }
  error(error) {
    if (this.a.destroyed) {
      return;
    }
    if (this.a.flowing) {
      this.h(error);
    } else {
      this.b.error.push(error);
    }
  }
  end(result) {
    if (this.a.destroyed) {
      return;
    }
    if (typeof result !== "undefined") {
      this.write(result);
    }
    if (this.a.flowing) {
      this.i();
      this.destroy();
    } else {
      this.a.ended = true;
    }
  }
  g(data) {
    this.c.data.slice(0).forEach((listener) => listener(data));
  }
  h(error) {
    if (this.c.error.length === 0) {
      $ab(error);
    } else {
      this.c.error.slice(0).forEach((listener) => listener(error));
    }
  }
  i() {
    this.c.end.slice(0).forEach((listener) => listener());
  }
  on(event, callback) {
    if (this.a.destroyed) {
      return;
    }
    switch (event) {
      case "data":
        this.c.data.push(callback);
        this.resume();
        break;
      case "end":
        this.c.end.push(callback);
        if (this.a.flowing && this.l()) {
          this.destroy();
        }
        break;
      case "error":
        this.c.error.push(callback);
        if (this.a.flowing) {
          this.k();
        }
        break;
    }
  }
  removeListener(event, callback) {
    if (this.a.destroyed) {
      return;
    }
    let listeners = void 0;
    switch (event) {
      case "data":
        listeners = this.c.data;
        break;
      case "end":
        listeners = this.c.end;
        break;
      case "error":
        listeners = this.c.error;
        break;
    }
    if (listeners) {
      const index = listeners.indexOf(callback);
      if (index >= 0) {
        listeners.splice(index, 1);
      }
    }
  }
  j() {
    if (this.b.data.length > 0) {
      const fullDataBuffer = this.e(this.b.data);
      this.g(fullDataBuffer);
      this.b.data.length = 0;
      const pendingWritePromises = [...this.d];
      this.d.length = 0;
      pendingWritePromises.forEach((pendingWritePromise) => pendingWritePromise());
    }
  }
  k() {
    if (this.c.error.length > 0) {
      for (const error of this.b.error) {
        this.h(error);
      }
      this.b.error.length = 0;
    }
  }
  l() {
    if (this.a.ended) {
      this.i();
      return this.c.end.length > 0;
    }
    return false;
  }
  destroy() {
    if (!this.a.destroyed) {
      this.a.destroyed = true;
      this.a.ended = true;
      this.b.data.length = 0;
      this.b.error.length = 0;
      this.c.data.length = 0;
      this.c.error.length = 0;
      this.c.end.length = 0;
      this.d.length = 0;
    }
  }
};
function $Ve(readable, reducer) {
  const chunks = [];
  let chunk;
  while ((chunk = readable.read()) !== null) {
    chunks.push(chunk);
  }
  return reducer(chunks);
}
function $We(readable, reducer, maxChunks) {
  const chunks = [];
  let chunk = void 0;
  while ((chunk = readable.read()) !== null && chunks.length < maxChunks) {
    chunks.push(chunk);
  }
  if (chunk === null && chunks.length > 0) {
    return reducer(chunks);
  }
  return {
    read: () => {
      if (chunks.length > 0) {
        return chunks.shift();
      }
      if (typeof chunk !== "undefined") {
        const lastReadChunk = chunk;
        chunk = void 0;
        return lastReadChunk;
      }
      return readable.read();
    }
  };
}
function $Xe(stream, reducer) {
  return new Promise((resolve, reject) => {
    const chunks = [];
    $Ye(stream, {
      onData: (chunk) => {
        if (reducer) {
          chunks.push(chunk);
        }
      },
      onError: (error) => {
        if (reducer) {
          reject(error);
        } else {
          resolve(void 0);
        }
      },
      onEnd: () => {
        if (reducer) {
          resolve(reducer(chunks));
        } else {
          resolve(void 0);
        }
      }
    });
  });
}
function $Ye(stream, listener, token) {
  stream.on("error", (error) => {
    if (!token?.isCancellationRequested) {
      listener.onError(error);
    }
  });
  stream.on("end", () => {
    if (!token?.isCancellationRequested) {
      listener.onEnd();
    }
  });
  stream.on("data", (data) => {
    if (!token?.isCancellationRequested) {
      listener.onData(data);
    }
  });
}
function $Ze(stream, maxChunks) {
  return new Promise((resolve, reject) => {
    const streamListeners = new $9c();
    const buffer = [];
    const dataListener = (chunk) => {
      buffer.push(chunk);
      if (buffer.length > maxChunks) {
        streamListeners.dispose();
        stream.pause();
        return resolve({ stream, buffer, ended: false });
      }
    };
    const errorListener = (error) => {
      streamListeners.dispose();
      return reject(error);
    };
    const endListener = () => {
      streamListeners.dispose();
      return resolve({ stream, buffer, ended: true });
    };
    streamListeners.add($8c(() => stream.removeListener("error", errorListener)));
    stream.on("error", errorListener);
    streamListeners.add($8c(() => stream.removeListener("end", endListener)));
    stream.on("end", endListener);
    streamListeners.add($8c(() => stream.removeListener("data", dataListener)));
    stream.on("data", dataListener);
  });
}
function $1e(t, reducer) {
  const stream = $Ue(reducer);
  stream.end(t);
  return stream;
}
function $2e() {
  const stream = $Ue(() => {
    throw new Error("not supported");
  });
  stream.end();
  return stream;
}
function $3e(t) {
  let consumed = false;
  return {
    read: () => {
      if (consumed) {
        return null;
      }
      consumed = true;
      return t;
    }
  };
}
function $4e(stream, transformer, reducer) {
  const target = $Ue(reducer);
  $Ye(stream, {
    onData: (data) => target.write(transformer.data(data)),
    onError: (error) => target.error(transformer.error ? transformer.error(error) : error),
    onEnd: () => target.end()
  });
  return target;
}
function $5e(prefix, readable, reducer) {
  let prefixHandled = false;
  return {
    read: () => {
      const chunk = readable.read();
      if (!prefixHandled) {
        prefixHandled = true;
        if (chunk !== null) {
          return reducer([prefix, chunk]);
        }
        return prefix;
      }
      return chunk;
    }
  };
}
function $6e(prefix, stream, reducer) {
  let prefixHandled = false;
  const target = $Ue(reducer);
  $Ye(stream, {
    onData: (data) => {
      if (!prefixHandled) {
        prefixHandled = true;
        return target.write(reducer([prefix, data]));
      }
      return target.write(data);
    },
    onError: (error) => target.error(error),
    onEnd: () => {
      if (!prefixHandled) {
        prefixHandled = true;
        target.write(prefix);
      }
      target.end();
    }
  });
  return target;
}

// out-build/vs/base/common/buffer.js
var hasBuffer = typeof Buffer !== "undefined";
var indexOfTable = new $7(() => new Uint8Array(256));
var textEncoder;
var textDecoder;
var $7e = class _$7e {
  /**
   * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
   * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
   */
  static alloc(byteLength) {
    if (hasBuffer) {
      return new _$7e(Buffer.allocUnsafe(byteLength));
    } else {
      return new _$7e(new Uint8Array(byteLength));
    }
  }
  /**
   * When running in a nodejs context, if `actual` is not a nodejs Buffer, the backing store for
   * the returned `VSBuffer` instance might use a nodejs Buffer allocated from node's Buffer pool,
   * which is not transferrable.
   */
  static wrap(actual) {
    if (hasBuffer && !Buffer.isBuffer(actual)) {
      actual = Buffer.from(actual.buffer, actual.byteOffset, actual.byteLength);
    }
    return new _$7e(actual);
  }
  /**
   * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
   * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
   */
  static fromString(source, options3) {
    const dontUseNodeBuffer = options3?.dontUseNodeBuffer || false;
    if (!dontUseNodeBuffer && hasBuffer) {
      return new _$7e(Buffer.from(source));
    } else {
      if (!textEncoder) {
        textEncoder = new TextEncoder();
      }
      return new _$7e(textEncoder.encode(source));
    }
  }
  /**
   * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
   * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
   */
  static fromByteArray(source) {
    const result = _$7e.alloc(source.length);
    for (let i = 0, len = source.length; i < len; i++) {
      result.buffer[i] = source[i];
    }
    return result;
  }
  /**
   * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
   * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
   */
  static concat(buffers, totalLength) {
    if (typeof totalLength === "undefined") {
      totalLength = 0;
      for (let i = 0, len = buffers.length; i < len; i++) {
        totalLength += buffers[i].byteLength;
      }
    }
    const ret = _$7e.alloc(totalLength);
    let offset = 0;
    for (let i = 0, len = buffers.length; i < len; i++) {
      const element = buffers[i];
      ret.set(element, offset);
      offset += element.byteLength;
    }
    return ret;
  }
  constructor(buffer) {
    this.buffer = buffer;
    this.byteLength = this.buffer.byteLength;
  }
  /**
   * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
   * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
   */
  clone() {
    const result = _$7e.alloc(this.byteLength);
    result.set(this);
    return result;
  }
  toString() {
    if (hasBuffer) {
      return this.buffer.toString();
    } else {
      if (!textDecoder) {
        textDecoder = new TextDecoder();
      }
      return textDecoder.decode(this.buffer);
    }
  }
  slice(start, end) {
    return new _$7e(this.buffer.subarray(start, end));
  }
  set(array2, offset) {
    if (array2 instanceof _$7e) {
      this.buffer.set(array2.buffer, offset);
    } else if (array2 instanceof Uint8Array) {
      this.buffer.set(array2, offset);
    } else if (array2 instanceof ArrayBuffer) {
      this.buffer.set(new Uint8Array(array2), offset);
    } else if (ArrayBuffer.isView(array2)) {
      this.buffer.set(new Uint8Array(array2.buffer, array2.byteOffset, array2.byteLength), offset);
    } else {
      throw new Error(`Unknown argument 'array'`);
    }
  }
  readUInt32BE(offset) {
    return $$e(this.buffer, offset);
  }
  writeUInt32BE(value, offset) {
    $_e(this.buffer, value, offset);
  }
  readUInt32LE(offset) {
    return $af(this.buffer, offset);
  }
  writeUInt32LE(value, offset) {
    $bf(this.buffer, value, offset);
  }
  readUInt8(offset) {
    return $cf(this.buffer, offset);
  }
  writeUInt8(value, offset) {
    $df(this.buffer, value, offset);
  }
  indexOf(subarray, offset = 0) {
    return $8e(this.buffer, subarray instanceof _$7e ? subarray.buffer : subarray, offset);
  }
};
function $8e(haystack, needle, offset = 0) {
  const needleLen = needle.byteLength;
  const haystackLen = haystack.byteLength;
  if (needleLen === 0) {
    return 0;
  }
  if (needleLen === 1) {
    return haystack.indexOf(needle[0]);
  }
  if (needleLen > haystackLen - offset) {
    return -1;
  }
  const table = indexOfTable.value;
  table.fill(needle.length);
  for (let i2 = 0; i2 < needle.length; i2++) {
    table[needle[i2]] = needle.length - i2 - 1;
  }
  let i = offset + needle.length - 1;
  let j = i;
  let result = -1;
  while (i < haystackLen) {
    if (haystack[i] === needle[j]) {
      if (j === 0) {
        result = i;
        break;
      }
      i--;
      j--;
    } else {
      i += Math.max(needle.length - j, table[haystack[i]]);
      j = needle.length - 1;
    }
  }
  return result;
}
function $9e(source, offset) {
  return source[offset + 0] << 0 >>> 0 | source[offset + 1] << 8 >>> 0;
}
function $0e(destination, value, offset) {
  destination[offset + 0] = value & 255;
  value = value >>> 8;
  destination[offset + 1] = value & 255;
}
function $$e(source, offset) {
  return source[offset] * 2 ** 24 + source[offset + 1] * 2 ** 16 + source[offset + 2] * 2 ** 8 + source[offset + 3];
}
function $_e(destination, value, offset) {
  destination[offset + 3] = value;
  value = value >>> 8;
  destination[offset + 2] = value;
  value = value >>> 8;
  destination[offset + 1] = value;
  value = value >>> 8;
  destination[offset] = value;
}
function $af(source, offset) {
  return source[offset + 0] << 0 >>> 0 | source[offset + 1] << 8 >>> 0 | source[offset + 2] << 16 >>> 0 | source[offset + 3] << 24 >>> 0;
}
function $bf(destination, value, offset) {
  destination[offset + 0] = value & 255;
  value = value >>> 8;
  destination[offset + 1] = value & 255;
  value = value >>> 8;
  destination[offset + 2] = value & 255;
  value = value >>> 8;
  destination[offset + 3] = value & 255;
}
function $cf(source, offset) {
  return source[offset];
}
function $df(destination, value, offset) {
  destination[offset] = value;
}
function $ef(readable) {
  return $Ve(readable, (chunks) => $7e.concat(chunks));
}
function $ff(buffer) {
  return $3e(buffer);
}
function $gf(stream) {
  return $Xe(stream, (chunks) => $7e.concat(chunks));
}
async function $hf(bufferedStream) {
  if (bufferedStream.ended) {
    return $7e.concat(bufferedStream.buffer);
  }
  return $7e.concat([
    // Include already read chunks...
    ...bufferedStream.buffer,
    // ...and all additional chunks
    await $gf(bufferedStream.stream)
  ]);
}
function $if(buffer) {
  return $1e(buffer, (chunks) => $7e.concat(chunks));
}
function $kf(options3) {
  return $Ue((chunks) => $7e.concat(chunks), options3);
}
function $lf(prefix, readable) {
  return $5e(prefix, readable, (chunks) => $7e.concat(chunks));
}
function $mf(prefix, stream) {
  return $6e(prefix, stream, (chunks) => $7e.concat(chunks));
}
function $nf(encoded) {
  let building = 0;
  let remainder = 0;
  let bufi = 0;
  const buffer = new Uint8Array(Math.floor(encoded.length / 4 * 3));
  const append2 = (value) => {
    switch (remainder) {
      case 3:
        buffer[bufi++] = building | value;
        remainder = 0;
        break;
      case 2:
        buffer[bufi++] = building | value >>> 2;
        building = value << 6;
        remainder = 3;
        break;
      case 1:
        buffer[bufi++] = building | value >>> 4;
        building = value << 4;
        remainder = 2;
        break;
      default:
        building = value << 2;
        remainder = 1;
    }
  };
  for (let i = 0; i < encoded.length; i++) {
    const code = encoded.charCodeAt(i);
    if (code >= 65 && code <= 90) {
      append2(code - 65);
    } else if (code >= 97 && code <= 122) {
      append2(code - 97 + 26);
    } else if (code >= 48 && code <= 57) {
      append2(code - 48 + 52);
    } else if (code === 43 || code === 45) {
      append2(62);
    } else if (code === 47 || code === 95) {
      append2(63);
    } else if (code === 61) {
      break;
    } else {
      throw new SyntaxError(`Unexpected base64 character ${encoded[i]}`);
    }
  }
  const unpadded = bufi;
  while (remainder > 0) {
    append2(0);
  }
  return $7e.wrap(buffer).slice(0, unpadded);
}
var base64Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
var base64UrlSafeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
function $of({ buffer }, padded = true, urlSafe = false) {
  const dictionary = urlSafe ? base64UrlSafeAlphabet : base64Alphabet;
  let output = "";
  const remainder = buffer.byteLength % 3;
  let i = 0;
  for (; i < buffer.byteLength - remainder; i += 3) {
    const a = buffer[i + 0];
    const b = buffer[i + 1];
    const c = buffer[i + 2];
    output += dictionary[a >>> 2];
    output += dictionary[(a << 4 | b >>> 4) & 63];
    output += dictionary[(b << 2 | c >>> 6) & 63];
    output += dictionary[c & 63];
  }
  if (remainder === 1) {
    const a = buffer[i + 0];
    output += dictionary[a >>> 2];
    output += dictionary[a << 4 & 63];
    if (padded) {
      output += "==";
    }
  } else if (remainder === 2) {
    const a = buffer[i + 0];
    const b = buffer[i + 1];
    output += dictionary[a >>> 2];
    output += dictionary[(a << 4 | b >>> 4) & 63];
    output += dictionary[b << 2 & 63];
    if (padded) {
      output += "=";
    }
  }
  return output;
}

// out-build/vs/editor/common/core/stringBuilder.js
var _utf16LE_TextDecoder;
function getUTF16LE_TextDecoder() {
  if (!_utf16LE_TextDecoder) {
    _utf16LE_TextDecoder = new TextDecoder("UTF-16LE");
  }
  return _utf16LE_TextDecoder;
}
var _utf16BE_TextDecoder;
function getUTF16BE_TextDecoder() {
  if (!_utf16BE_TextDecoder) {
    _utf16BE_TextDecoder = new TextDecoder("UTF-16BE");
  }
  return _utf16BE_TextDecoder;
}
var _platformTextDecoder;
function $Cu() {
  if (!_platformTextDecoder) {
    _platformTextDecoder = $G() ? getUTF16LE_TextDecoder() : getUTF16BE_TextDecoder();
  }
  return _platformTextDecoder;
}
function $Du(source, offset, len) {
  const view = new Uint16Array(source.buffer, offset, len);
  if (len > 0 && (view[0] === 65279 || view[0] === 65534)) {
    return compatDecodeUTF16LE(source, offset, len);
  }
  return getUTF16LE_TextDecoder().decode(view);
}
function compatDecodeUTF16LE(source, offset, len) {
  const result = [];
  let resultLen = 0;
  for (let i = 0; i < len; i++) {
    const charCode = $9e(source, offset);
    offset += 2;
    result[resultLen++] = String.fromCharCode(charCode);
  }
  return result.join("");
}
var $Eu = class {
  constructor(capacity) {
    this.a = capacity | 0;
    this.b = new Uint16Array(this.a);
    this.c = null;
    this.d = 0;
  }
  reset() {
    this.c = null;
    this.d = 0;
  }
  build() {
    if (this.c !== null) {
      this.f();
      return this.c.join("");
    }
    return this.e();
  }
  e() {
    if (this.d === 0) {
      return "";
    }
    const view = new Uint16Array(this.b.buffer, 0, this.d);
    return $Cu().decode(view);
  }
  f() {
    const bufferString = this.e();
    this.d = 0;
    if (this.c === null) {
      this.c = [bufferString];
    } else {
      this.c[this.c.length] = bufferString;
    }
  }
  /**
   * Append a char code (<2^16)
   */
  appendCharCode(charCode) {
    const remainingSpace = this.a - this.d;
    if (remainingSpace <= 1) {
      if (remainingSpace === 0 || $4f(charCode)) {
        this.f();
      }
    }
    this.b[this.d++] = charCode;
  }
  /**
   * Append an ASCII char code (<2^8)
   */
  appendASCIICharCode(charCode) {
    if (this.d === this.a) {
      this.f();
    }
    this.b[this.d++] = charCode;
  }
  appendString(str) {
    const strLen = str.length;
    if (this.d + strLen >= this.a) {
      this.f();
      this.c[this.c.length] = str;
      return;
    }
    for (let i = 0; i < strLen; i++) {
      this.b[this.d++] = str.charCodeAt(i);
    }
  }
};

// out-build/vs/editor/common/languages/supports/richEditBrackets.js
var $Av = class _$Av {
  constructor(languageId, index, open2, close2, forwardRegex, reversedRegex) {
    this._richEditBracketBrand = void 0;
    this.languageId = languageId;
    this.index = index;
    this.open = open2;
    this.close = close2;
    this.forwardRegex = forwardRegex;
    this.reversedRegex = reversedRegex;
    this.c = _$Av.e(this.open);
    this.d = _$Av.e(this.close);
  }
  /**
   * Check if the provided `text` is an open bracket in this group.
   */
  isOpen(text2) {
    return this.c.has(text2);
  }
  /**
   * Check if the provided `text` is a close bracket in this group.
   */
  isClose(text2) {
    return this.d.has(text2);
  }
  static e(arr) {
    const result = /* @__PURE__ */ new Set();
    for (const element of arr) {
      result.add(element);
    }
    return result;
  }
};
function groupFuzzyBrackets(brackets) {
  const N = brackets.length;
  brackets = brackets.map((b) => [b[0].toLowerCase(), b[1].toLowerCase()]);
  const group2 = [];
  for (let i = 0; i < N; i++) {
    group2[i] = i;
  }
  const areOverlapping = (a, b) => {
    const [aOpen, aClose] = a;
    const [bOpen, bClose] = b;
    return aOpen === bOpen || aOpen === bClose || aClose === bOpen || aClose === bClose;
  };
  const mergeGroups = (g1, g2) => {
    const newG = Math.min(g1, g2);
    const oldG = Math.max(g1, g2);
    for (let i = 0; i < N; i++) {
      if (group2[i] === oldG) {
        group2[i] = newG;
      }
    }
  };
  for (let i = 0; i < N; i++) {
    const a = brackets[i];
    for (let j = i + 1; j < N; j++) {
      const b = brackets[j];
      if (areOverlapping(a, b)) {
        mergeGroups(group2[i], group2[j]);
      }
    }
  }
  const result = [];
  for (let g = 0; g < N; g++) {
    const currentOpen = [];
    const currentClose = [];
    for (let i = 0; i < N; i++) {
      if (group2[i] === g) {
        const [open2, close2] = brackets[i];
        currentOpen.push(open2);
        currentClose.push(close2);
      }
    }
    if (currentOpen.length > 0) {
      result.push({
        open: currentOpen,
        close: currentClose
      });
    }
  }
  return result;
}
var $Bv = class {
  constructor(languageId, _brackets) {
    this._richEditBracketsBrand = void 0;
    const brackets = groupFuzzyBrackets(_brackets);
    this.brackets = brackets.map((b, index) => {
      return new $Av(languageId, index, b.open, b.close, getRegexForBracketPair(b.open, b.close, brackets, index), getReversedRegexForBracketPair(b.open, b.close, brackets, index));
    });
    this.forwardRegex = getRegexForBrackets(this.brackets);
    this.reversedRegex = getReversedRegexForBrackets(this.brackets);
    this.textIsBracket = {};
    this.textIsOpenBracket = {};
    this.maxBracketLength = 0;
    for (const bracket of this.brackets) {
      for (const open2 of bracket.open) {
        this.textIsBracket[open2] = bracket;
        this.textIsOpenBracket[open2] = true;
        this.maxBracketLength = Math.max(this.maxBracketLength, open2.length);
      }
      for (const close2 of bracket.close) {
        this.textIsBracket[close2] = bracket;
        this.textIsOpenBracket[close2] = false;
        this.maxBracketLength = Math.max(this.maxBracketLength, close2.length);
      }
    }
  }
};
function collectSuperstrings(str, brackets, currentIndex, dest) {
  for (let i = 0, len = brackets.length; i < len; i++) {
    if (i === currentIndex) {
      continue;
    }
    const bracket = brackets[i];
    for (const open2 of bracket.open) {
      if (open2.indexOf(str) >= 0) {
        dest.push(open2);
      }
    }
    for (const close2 of bracket.close) {
      if (close2.indexOf(str) >= 0) {
        dest.push(close2);
      }
    }
  }
}
function lengthcmp(a, b) {
  return a.length - b.length;
}
function unique(arr) {
  if (arr.length <= 1) {
    return arr;
  }
  const result = [];
  const seen = /* @__PURE__ */ new Set();
  for (const element of arr) {
    if (seen.has(element)) {
      continue;
    }
    result.push(element);
    seen.add(element);
  }
  return result;
}
function getRegexForBracketPair(open2, close2, brackets, currentIndex) {
  let pieces = [];
  pieces = pieces.concat(open2);
  pieces = pieces.concat(close2);
  for (let i = 0, len = pieces.length; i < len; i++) {
    collectSuperstrings(pieces[i], brackets, currentIndex, pieces);
  }
  pieces = unique(pieces);
  pieces.sort(lengthcmp);
  pieces.reverse();
  return $Cv(pieces);
}
function getReversedRegexForBracketPair(open2, close2, brackets, currentIndex) {
  let pieces = [];
  pieces = pieces.concat(open2);
  pieces = pieces.concat(close2);
  for (let i = 0, len = pieces.length; i < len; i++) {
    collectSuperstrings(pieces[i], brackets, currentIndex, pieces);
  }
  pieces = unique(pieces);
  pieces.sort(lengthcmp);
  pieces.reverse();
  return $Cv(pieces.map(toReversedString));
}
function getRegexForBrackets(brackets) {
  let pieces = [];
  for (const bracket of brackets) {
    for (const open2 of bracket.open) {
      pieces.push(open2);
    }
    for (const close2 of bracket.close) {
      pieces.push(close2);
    }
  }
  pieces = unique(pieces);
  return $Cv(pieces);
}
function getReversedRegexForBrackets(brackets) {
  let pieces = [];
  for (const bracket of brackets) {
    for (const open2 of bracket.open) {
      pieces.push(open2);
    }
    for (const close2 of bracket.close) {
      pieces.push(close2);
    }
  }
  pieces = unique(pieces);
  return $Cv(pieces.map(toReversedString));
}
function prepareBracketForRegExp(str) {
  const insertWordBoundaries = /^[\w ]+$/.test(str);
  str = $Af(str);
  return insertWordBoundaries ? `\\b${str}\\b` : str;
}
function $Cv(pieces, options3) {
  const regexStr = `(${pieces.map(prepareBracketForRegExp).join(")|(")})`;
  return $Jf(regexStr, true, options3);
}
var toReversedString = /* @__PURE__ */ function() {
  function reverse(str) {
    const arr = new Uint16Array(str.length);
    let offset = 0;
    for (let i = str.length - 1; i >= 0; i--) {
      arr[offset++] = str.charCodeAt(i);
    }
    return $Cu().decode(arr);
  }
  let lastInput = null;
  let lastOutput = null;
  return function toReversedString2(str) {
    if (lastInput !== str) {
      lastInput = str;
      lastOutput = reverse(lastInput);
    }
    return lastOutput;
  };
}();
var $Dv = class {
  static c(reversedBracketRegex, lineNumber, reversedText, offset) {
    const m = reversedText.match(reversedBracketRegex);
    if (!m) {
      return null;
    }
    const matchOffset = reversedText.length - (m.index || 0);
    const matchLength = m[0].length;
    const absoluteMatchOffset = offset + matchOffset;
    return new $au(lineNumber, absoluteMatchOffset - matchLength + 1, lineNumber, absoluteMatchOffset + 1);
  }
  static findPrevBracketInRange(reversedBracketRegex, lineNumber, lineText, startOffset, endOffset) {
    const reversedLineText = toReversedString(lineText);
    const reversedSubstr = reversedLineText.substring(lineText.length - endOffset, lineText.length - startOffset);
    return this.c(reversedBracketRegex, lineNumber, reversedSubstr, startOffset);
  }
  static findNextBracketInText(bracketRegex, lineNumber, text2, offset) {
    const m = text2.match(bracketRegex);
    if (!m) {
      return null;
    }
    const matchOffset = m.index || 0;
    const matchLength = m[0].length;
    if (matchLength === 0) {
      return null;
    }
    const absoluteMatchOffset = offset + matchOffset;
    return new $au(lineNumber, absoluteMatchOffset + 1, lineNumber, absoluteMatchOffset + 1 + matchLength);
  }
  static findNextBracketInRange(bracketRegex, lineNumber, lineText, startOffset, endOffset) {
    const substr = lineText.substring(startOffset, endOffset);
    return this.findNextBracketInText(bracketRegex, lineNumber, substr, startOffset);
  }
};

// out-build/vs/editor/common/languages/supports/electricCharacter.js
var $$v = class {
  constructor(richEditBrackets) {
    this.a = richEditBrackets;
  }
  getElectricCharacters() {
    const result = [];
    if (this.a) {
      for (const bracket of this.a.brackets) {
        for (const close2 of bracket.close) {
          const lastChar = close2.charAt(close2.length - 1);
          result.push(lastChar);
        }
      }
    }
    return $Zb(result);
  }
  onElectricCharacter(character, context, column) {
    if (!this.a || this.a.brackets.length === 0) {
      return null;
    }
    const tokenIndex = context.findTokenIndexAtOffset(column - 1);
    if ($xv(context.getStandardTokenType(tokenIndex))) {
      return null;
    }
    const reversedBracketRegex = this.a.reversedRegex;
    const text2 = context.getLineContent().substring(0, column - 1) + character;
    const r2 = $Dv.findPrevBracketInRange(reversedBracketRegex, 1, text2, 0, text2.length);
    if (!r2) {
      return null;
    }
    const bracketText = text2.substring(r2.startColumn - 1, r2.endColumn - 1).toLowerCase();
    const isOpen = this.a.textIsOpenBracket[bracketText];
    if (isOpen) {
      return null;
    }
    const textBeforeBracket = context.getActualLineContentBefore(r2.startColumn - 1);
    if (!/^\s*$/.test(textBeforeBracket)) {
      return null;
    }
    return {
      matchOpenBracket: bracketText
    };
  }
};

// out-build/vs/editor/common/languages/supports/indentRules.js
var IndentConsts;
(function(IndentConsts2) {
  IndentConsts2[IndentConsts2["INCREASE_MASK"] = 1] = "INCREASE_MASK";
  IndentConsts2[IndentConsts2["DECREASE_MASK"] = 2] = "DECREASE_MASK";
  IndentConsts2[IndentConsts2["INDENT_NEXTLINE_MASK"] = 4] = "INDENT_NEXTLINE_MASK";
  IndentConsts2[IndentConsts2["UNINDENT_MASK"] = 8] = "UNINDENT_MASK";
})(IndentConsts || (IndentConsts = {}));
function resetGlobalRegex(reg2) {
  if (reg2.global) {
    reg2.lastIndex = 0;
  }
  return true;
}
var $_v = class {
  constructor(indentationRules) {
    this.a = indentationRules;
  }
  shouldIncrease(text2) {
    if (this.a) {
      if (this.a.increaseIndentPattern && resetGlobalRegex(this.a.increaseIndentPattern) && this.a.increaseIndentPattern.test(text2)) {
        return true;
      }
    }
    return false;
  }
  shouldDecrease(text2) {
    if (this.a && this.a.decreaseIndentPattern && resetGlobalRegex(this.a.decreaseIndentPattern) && this.a.decreaseIndentPattern.test(text2)) {
      return true;
    }
    return false;
  }
  shouldIndentNextLine(text2) {
    if (this.a && this.a.indentNextLinePattern && resetGlobalRegex(this.a.indentNextLinePattern) && this.a.indentNextLinePattern.test(text2)) {
      return true;
    }
    return false;
  }
  shouldIgnore(text2) {
    if (this.a && this.a.unIndentedLinePattern && resetGlobalRegex(this.a.unIndentedLinePattern) && this.a.unIndentedLinePattern.test(text2)) {
      return true;
    }
    return false;
  }
  getIndentMetadata(text2) {
    let ret = 0;
    if (this.shouldIncrease(text2)) {
      ret += 1;
    }
    if (this.shouldDecrease(text2)) {
      ret += 2;
    }
    if (this.shouldIndentNextLine(text2)) {
      ret += 4;
    }
    if (this.shouldIgnore(text2)) {
      ret += 8;
    }
    return ret;
  }
};

// out-build/vs/editor/common/languages/supports/onEnter.js
var $aw = class _$aw {
  constructor(opts) {
    opts = opts || {};
    opts.brackets = opts.brackets || [
      ["(", ")"],
      ["{", "}"],
      ["[", "]"]
    ];
    this.a = [];
    opts.brackets.forEach((bracket) => {
      const openRegExp = _$aw.c(bracket[0]);
      const closeRegExp = _$aw.d(bracket[1]);
      if (openRegExp && closeRegExp) {
        this.a.push({
          open: bracket[0],
          openRegExp,
          close: bracket[1],
          closeRegExp
        });
      }
    });
    this.b = opts.onEnterRules || [];
  }
  onEnter(autoIndent, previousLineText, beforeEnterText, afterEnterText) {
    if (autoIndent >= 3) {
      for (let i = 0, len = this.b.length; i < len; i++) {
        const rule = this.b[i];
        const regResult = [{
          reg: rule.beforeText,
          text: beforeEnterText
        }, {
          reg: rule.afterText,
          text: afterEnterText
        }, {
          reg: rule.previousLineText,
          text: previousLineText
        }].every((obj) => {
          if (!obj.reg) {
            return true;
          }
          obj.reg.lastIndex = 0;
          return obj.reg.test(obj.text);
        });
        if (regResult) {
          return rule.action;
        }
      }
    }
    if (autoIndent >= 2) {
      if (beforeEnterText.length > 0 && afterEnterText.length > 0) {
        for (let i = 0, len = this.a.length; i < len; i++) {
          const bracket = this.a[i];
          if (bracket.openRegExp.test(beforeEnterText) && bracket.closeRegExp.test(afterEnterText)) {
            return { indentAction: IndentAction.IndentOutdent };
          }
        }
      }
    }
    if (autoIndent >= 2) {
      if (beforeEnterText.length > 0) {
        for (let i = 0, len = this.a.length; i < len; i++) {
          const bracket = this.a[i];
          if (bracket.openRegExp.test(beforeEnterText)) {
            return { indentAction: IndentAction.Indent };
          }
        }
      }
    }
    return null;
  }
  static c(bracket) {
    let str = $Af(bracket);
    if (!/\B/.test(str.charAt(0))) {
      str = "\\b" + str;
    }
    str += "\\s*$";
    return _$aw.e(str);
  }
  static d(bracket) {
    let str = $Af(bracket);
    if (!/\B/.test(str.charAt(str.length - 1))) {
      str = str + "\\b";
    }
    str = "^\\s*" + str;
    return _$aw.e(str);
  }
  static e(def4) {
    try {
      return new RegExp(def4);
    } catch (err) {
      $ab(err);
      return null;
    }
  }
};

// out-build/vs/platform/configuration/common/configuration.js
var $tj = $Zi("configurationService");
function $uj(thing) {
  return thing && typeof thing === "object" && (!thing.overrideIdentifier || typeof thing.overrideIdentifier === "string") && (!thing.resource || thing.resource instanceof URI);
}
function $vj(thing) {
  return thing && typeof thing === "object" && (!thing.overrideIdentifiers || Array.isArray(thing.overrideIdentifiers)) && !thing.overrideIdentifier && (!thing.resource || thing.resource instanceof URI);
}
var ConfigurationTarget;
(function(ConfigurationTarget3) {
  ConfigurationTarget3[ConfigurationTarget3["APPLICATION"] = 1] = "APPLICATION";
  ConfigurationTarget3[ConfigurationTarget3["USER"] = 2] = "USER";
  ConfigurationTarget3[ConfigurationTarget3["USER_LOCAL"] = 3] = "USER_LOCAL";
  ConfigurationTarget3[ConfigurationTarget3["USER_REMOTE"] = 4] = "USER_REMOTE";
  ConfigurationTarget3[ConfigurationTarget3["WORKSPACE"] = 5] = "WORKSPACE";
  ConfigurationTarget3[ConfigurationTarget3["WORKSPACE_FOLDER"] = 6] = "WORKSPACE_FOLDER";
  ConfigurationTarget3[ConfigurationTarget3["DEFAULT"] = 7] = "DEFAULT";
  ConfigurationTarget3[ConfigurationTarget3["MEMORY"] = 8] = "MEMORY";
})(ConfigurationTarget || (ConfigurationTarget = {}));
function $wj(configurationTarget) {
  switch (configurationTarget) {
    case 1:
      return "APPLICATION";
    case 2:
      return "USER";
    case 3:
      return "USER_LOCAL";
    case 4:
      return "USER_REMOTE";
    case 5:
      return "WORKSPACE";
    case 6:
      return "WORKSPACE_FOLDER";
    case 7:
      return "DEFAULT";
    case 8:
      return "MEMORY";
  }
}
function $xj(configValue) {
  return configValue.applicationValue !== void 0 || configValue.userValue !== void 0 || configValue.userLocalValue !== void 0 || configValue.userRemoteValue !== void 0 || configValue.workspaceValue !== void 0 || configValue.workspaceFolderValue !== void 0;
}
function $yj(properties, conflictReporter) {
  const root = /* @__PURE__ */ Object.create(null);
  for (const key in properties) {
    $zj(root, key, properties[key], conflictReporter);
  }
  return root;
}
function $zj(settingsTreeRoot, key, value, conflictReporter) {
  const segments = key.split(".");
  const last = segments.pop();
  let curr = settingsTreeRoot;
  for (let i = 0; i < segments.length; i++) {
    const s = segments[i];
    let obj = curr[s];
    switch (typeof obj) {
      case "undefined":
        obj = curr[s] = /* @__PURE__ */ Object.create(null);
        break;
      case "object":
        if (obj === null) {
          conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join(".")} is null`);
          return;
        }
        break;
      default:
        conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join(".")} is ${JSON.stringify(obj)}`);
        return;
    }
    curr = obj;
  }
  if (typeof curr === "object" && curr !== null) {
    try {
      curr[last] = value;
    } catch (e) {
      conflictReporter(`Ignoring ${key} as ${segments.join(".")} is ${JSON.stringify(curr)}`);
    }
  } else {
    conflictReporter(`Ignoring ${key} as ${segments.join(".")} is ${JSON.stringify(curr)}`);
  }
}
function $Aj(valueTree, key) {
  const segments = key.split(".");
  doRemoveFromValueTree(valueTree, segments);
}
function doRemoveFromValueTree(valueTree, segments) {
  const first = segments.shift();
  if (segments.length === 0) {
    delete valueTree[first];
    return;
  }
  if (Object.keys(valueTree).indexOf(first) !== -1) {
    const value = valueTree[first];
    if (typeof value === "object" && !Array.isArray(value)) {
      doRemoveFromValueTree(value, segments);
      if (Object.keys(value).length === 0) {
        delete valueTree[first];
      }
    }
  }
}
function $Bj(config, settingPath, defaultValue) {
  function accessSetting(config2, path2) {
    let current = config2;
    for (const component of path2) {
      if (typeof current !== "object" || current === null) {
        return void 0;
      }
      current = current[component];
    }
    return current;
  }
  const path = settingPath.split(".");
  const result = accessSetting(config, path);
  return typeof result === "undefined" ? defaultValue : result;
}
function $Dj(settingKey) {
  return settingKey.replace(/[\[\]]/g, "");
}

// out-build/vs/editor/common/languages/language.js
var $uv = $Zi("languageService");

// out-build/vs/platform/instantiation/common/descriptors.js
var $Wi = class {
  constructor(ctor, staticArguments = [], supportsDelayedInstantiation = false) {
    this.ctor = ctor;
    this.staticArguments = staticArguments;
    this.supportsDelayedInstantiation = supportsDelayedInstantiation;
  }
};

// out-build/vs/platform/instantiation/common/extensions.js
var _registry = [];
var InstantiationType;
(function(InstantiationType2) {
  InstantiationType2[InstantiationType2["Eager"] = 0] = "Eager";
  InstantiationType2[InstantiationType2["Delayed"] = 1] = "Delayed";
})(InstantiationType || (InstantiationType = {}));
function $bt(id2, ctorOrDescriptor, supportsDelayedInstantiation) {
  if (!(ctorOrDescriptor instanceof $Wi)) {
    ctorOrDescriptor = new $Wi(ctorOrDescriptor, [], Boolean(supportsDelayedInstantiation));
  }
  _registry.push([id2, ctorOrDescriptor]);
}
function $ct() {
  return _registry;
}

// out-build/vs/base/common/mime.js
var $ut = Object.freeze({
  text: "text/plain",
  binary: "application/octet-stream",
  unknown: "application/unknown",
  markdown: "text/markdown",
  latex: "text/latex",
  uriList: "text/uri-list"
});
var mapExtToTextMimes = {
  ".css": "text/css",
  ".csv": "text/csv",
  ".htm": "text/html",
  ".html": "text/html",
  ".ics": "text/calendar",
  ".js": "text/javascript",
  ".mjs": "text/javascript",
  ".txt": "text/plain",
  ".xml": "text/xml"
};
var mapExtToMediaMimes = {
  ".aac": "audio/x-aac",
  ".avi": "video/x-msvideo",
  ".bmp": "image/bmp",
  ".flv": "video/x-flv",
  ".gif": "image/gif",
  ".ico": "image/x-icon",
  ".jpe": "image/jpg",
  ".jpeg": "image/jpg",
  ".jpg": "image/jpg",
  ".m1v": "video/mpeg",
  ".m2a": "audio/mpeg",
  ".m2v": "video/mpeg",
  ".m3a": "audio/mpeg",
  ".mid": "audio/midi",
  ".midi": "audio/midi",
  ".mk3d": "video/x-matroska",
  ".mks": "video/x-matroska",
  ".mkv": "video/x-matroska",
  ".mov": "video/quicktime",
  ".movie": "video/x-sgi-movie",
  ".mp2": "audio/mpeg",
  ".mp2a": "audio/mpeg",
  ".mp3": "audio/mpeg",
  ".mp4": "video/mp4",
  ".mp4a": "audio/mp4",
  ".mp4v": "video/mp4",
  ".mpe": "video/mpeg",
  ".mpeg": "video/mpeg",
  ".mpg": "video/mpeg",
  ".mpg4": "video/mp4",
  ".mpga": "audio/mpeg",
  ".oga": "audio/ogg",
  ".ogg": "audio/ogg",
  ".opus": "audio/opus",
  ".ogv": "video/ogg",
  ".png": "image/png",
  ".psd": "image/vnd.adobe.photoshop",
  ".qt": "video/quicktime",
  ".spx": "audio/ogg",
  ".svg": "image/svg+xml",
  ".tga": "image/x-tga",
  ".tif": "image/tiff",
  ".tiff": "image/tiff",
  ".wav": "audio/x-wav",
  ".webm": "video/webm",
  ".webp": "image/webp",
  ".wma": "audio/x-ms-wma",
  ".wmv": "video/x-ms-wmv",
  ".woff": "application/font-woff"
};
function $vt(path) {
  const ext = $Ac(path);
  const textMime = mapExtToTextMimes[ext.toLowerCase()];
  if (textMime !== void 0) {
    return textMime;
  } else {
    return $wt(path);
  }
}
function $wt(path) {
  const ext = $Ac(path);
  return mapExtToMediaMimes[ext.toLowerCase()];
}
function $xt(mimeType) {
  for (const extension in mapExtToMediaMimes) {
    if (mapExtToMediaMimes[extension] === mimeType) {
      return extension;
    }
  }
  return void 0;
}
var _simplePattern = /^(.+)\/(.+?)(;.+)?$/;
function $yt(mimeType, strict) {
  const match = _simplePattern.exec(mimeType);
  if (!match) {
    return strict ? void 0 : mimeType;
  }
  return `${match[1].toLowerCase()}/${match[2].toLowerCase()}${match[3] ?? ""}`;
}

// out-build/vs/base/common/jsonSchema.js
function $pk(schema9) {
  let hasDups = false;
  const equalsByString = /* @__PURE__ */ new Map();
  const nodeToEquals = /* @__PURE__ */ new Map();
  const visitSchemas = (next) => {
    if (schema9 === next) {
      return true;
    }
    const val = JSON.stringify(next);
    if (val.length < 30) {
      return true;
    }
    const eq3 = equalsByString.get(val);
    if (!eq3) {
      const newEq = { schemas: [next] };
      equalsByString.set(val, newEq);
      nodeToEquals.set(next, newEq);
      return true;
    }
    eq3.schemas.push(next);
    nodeToEquals.set(next, eq3);
    hasDups = true;
    return false;
  };
  traverseNodes(schema9, visitSchemas);
  equalsByString.clear();
  if (!hasDups) {
    return JSON.stringify(schema9);
  }
  let defNodeName = "$defs";
  while (schema9.hasOwnProperty(defNodeName)) {
    defNodeName += "_";
  }
  const definitions3 = [];
  function stringify2(root) {
    return JSON.stringify(root, (_key, value) => {
      if (value !== root) {
        const eq3 = nodeToEquals.get(value);
        if (eq3 && eq3.schemas.length > 1) {
          if (!eq3.id) {
            eq3.id = `_${definitions3.length}`;
            definitions3.push(eq3.schemas[0]);
          }
          return { $ref: `#/${defNodeName}/${eq3.id}` };
        }
      }
      return value;
    });
  }
  const str = stringify2(schema9);
  const defStrings = [];
  for (let i = 0; i < definitions3.length; i++) {
    defStrings.push(`"_${i}":${stringify2(definitions3[i])}`);
  }
  if (defStrings.length) {
    return `${str.substring(0, str.length - 1)},"${defNodeName}":{${defStrings.join(",")}}}`;
  }
  return str;
}
function isObject(thing) {
  return typeof thing === "object" && thing !== null;
}
function traverseNodes(root, visit) {
  if (!root || typeof root !== "object") {
    return;
  }
  const collectEntries = (...entries2) => {
    for (const entry of entries2) {
      if (isObject(entry)) {
        toWalk.push(entry);
      }
    }
  };
  const collectMapEntries = (...maps) => {
    for (const map of maps) {
      if (isObject(map)) {
        for (const key in map) {
          const entry = map[key];
          if (isObject(entry)) {
            toWalk.push(entry);
          }
        }
      }
    }
  };
  const collectArrayEntries = (...arrays) => {
    for (const array2 of arrays) {
      if (Array.isArray(array2)) {
        for (const entry of array2) {
          if (isObject(entry)) {
            toWalk.push(entry);
          }
        }
      }
    }
  };
  const collectEntryOrArrayEntries = (items) => {
    if (Array.isArray(items)) {
      for (const entry of items) {
        if (isObject(entry)) {
          toWalk.push(entry);
        }
      }
    } else if (isObject(items)) {
      toWalk.push(items);
    }
  };
  const toWalk = [root];
  let next = toWalk.pop();
  while (next) {
    const visitChildern = visit(next);
    if (visitChildern) {
      collectEntries(next.additionalItems, next.additionalProperties, next.not, next.contains, next.propertyNames, next.if, next.then, next.else, next.unevaluatedItems, next.unevaluatedProperties);
      collectMapEntries(next.definitions, next.$defs, next.properties, next.patternProperties, next.dependencies, next.dependentSchemas);
      collectArrayEntries(next.anyOf, next.allOf, next.oneOf, next.prefixItems);
      collectEntryOrArrayEntries(next.items);
    }
    next = toWalk.pop();
  }
}

// out-build/vs/platform/jsonschemas/common/jsonContributionRegistry.js
var $No = {
  JSONContribution: "base.contributions.json"
};
function normalizeId(id2) {
  if (id2.length > 0 && id2.charAt(id2.length - 1) === "#") {
    return id2.substring(0, id2.length - 1);
  }
  return id2;
}
var JSONContributionRegistry = class {
  constructor() {
    this.b = new $De();
    this.onDidChangeSchema = this.b.event;
    this.a = {};
  }
  registerSchema(uri, unresolvedSchemaContent) {
    this.a[normalizeId(uri)] = unresolvedSchemaContent;
    this.b.fire(uri);
  }
  notifySchemaChanged(uri) {
    this.b.fire(uri);
  }
  getSchemaContributions() {
    return {
      schemas: this.a
    };
  }
  getSchemaContent(uri) {
    const schema9 = this.a[uri];
    return schema9 ? $pk(schema9) : void 0;
  }
  hasSchemaContent(uri) {
    return !!this.a[uri];
  }
};
var jsonContributionRegistry = new JSONContributionRegistry();
$Mo.add($No.JSONContribution, jsonContributionRegistry);

// out-build/vs/platform/configuration/common/configurationRegistry.js
var EditPresentationTypes;
(function(EditPresentationTypes2) {
  EditPresentationTypes2["Multiline"] = "multilineText";
  EditPresentationTypes2["Singleline"] = "singlelineText";
})(EditPresentationTypes || (EditPresentationTypes = {}));
var $Ro = {
  Configuration: "base.contributions.configuration"
};
var ConfigurationScope;
(function(ConfigurationScope2) {
  ConfigurationScope2[ConfigurationScope2["APPLICATION"] = 1] = "APPLICATION";
  ConfigurationScope2[ConfigurationScope2["MACHINE"] = 2] = "MACHINE";
  ConfigurationScope2[ConfigurationScope2["WINDOW"] = 3] = "WINDOW";
  ConfigurationScope2[ConfigurationScope2["RESOURCE"] = 4] = "RESOURCE";
  ConfigurationScope2[ConfigurationScope2["LANGUAGE_OVERRIDABLE"] = 5] = "LANGUAGE_OVERRIDABLE";
  ConfigurationScope2[ConfigurationScope2["MACHINE_OVERRIDABLE"] = 6] = "MACHINE_OVERRIDABLE";
})(ConfigurationScope || (ConfigurationScope = {}));
var $So = { properties: {}, patternProperties: {} };
var $To = { properties: {}, patternProperties: {} };
var $Uo = { properties: {}, patternProperties: {} };
var $Vo = { properties: {}, patternProperties: {} };
var $Wo = { properties: {}, patternProperties: {} };
var $Xo = { properties: {}, patternProperties: {} };
var $Yo = "vscode://schemas/settings/resourceLanguage";
var $Zo = "vscode://schemas/settings/configurationDefaults";
var contributionRegistry = $Mo.as($No.JSONContribution);
var ConfigurationRegistry = class {
  constructor() {
    this.a = [];
    this.i = /* @__PURE__ */ new Set();
    this.j = new $De();
    this.onDidSchemaChange = this.j.event;
    this.k = new $De();
    this.onDidUpdateConfiguration = this.k.event;
    this.b = /* @__PURE__ */ new Map();
    this.c = {
      id: "defaultOverrides",
      title: localize(1672, null),
      properties: {}
    };
    this.d = [this.c];
    this.h = {
      properties: {},
      patternProperties: {},
      additionalProperties: true,
      allowTrailingCommas: true,
      allowComments: true
    };
    this.e = {};
    this.f = /* @__PURE__ */ new Map();
    this.g = {};
    contributionRegistry.registerSchema($Yo, this.h);
    this.z();
  }
  registerConfiguration(configuration2, validate = true) {
    this.registerConfigurations([configuration2], validate);
  }
  registerConfigurations(configurations, validate = true) {
    const properties = /* @__PURE__ */ new Set();
    this.r(configurations, validate, properties);
    contributionRegistry.registerSchema($Yo, this.h);
    this.j.fire();
    this.k.fire({ properties });
  }
  deregisterConfigurations(configurations) {
    const properties = /* @__PURE__ */ new Set();
    this.s(configurations, properties);
    contributionRegistry.registerSchema($Yo, this.h);
    this.j.fire();
    this.k.fire({ properties });
  }
  updateConfigurations({ add, remove }) {
    const properties = /* @__PURE__ */ new Set();
    this.s(remove, properties);
    this.r(add, false, properties);
    contributionRegistry.registerSchema($Yo, this.h);
    this.j.fire();
    this.k.fire({ properties });
  }
  registerDefaultConfigurations(configurationDefaults) {
    const properties = /* @__PURE__ */ new Set();
    this.l(configurationDefaults, properties);
    this.j.fire();
    this.k.fire({ properties, defaultsOverrides: true });
  }
  l(configurationDefaults, bucket) {
    this.a.push(...configurationDefaults);
    const overrideIdentifiers = [];
    for (const { overrides, source } of configurationDefaults) {
      for (const key in overrides) {
        bucket.add(key);
        const configurationDefaultOverridesForKey = this.b.get(key) ?? this.b.set(key, { configurationDefaultOverrides: [] }).get(key);
        const value = overrides[key];
        configurationDefaultOverridesForKey.configurationDefaultOverrides.push({ value, source });
        if ($2o.test(key)) {
          const newDefaultOverride = this.o(key, value, source, configurationDefaultOverridesForKey.configurationDefaultOverrideValue);
          if (!newDefaultOverride) {
            continue;
          }
          configurationDefaultOverridesForKey.configurationDefaultOverrideValue = newDefaultOverride;
          this.n(key, newDefaultOverride, source);
          overrideIdentifiers.push(...$3o(key));
        } else {
          const newDefaultOverride = this.p(key, value, source, configurationDefaultOverridesForKey.configurationDefaultOverrideValue);
          if (!newDefaultOverride) {
            continue;
          }
          configurationDefaultOverridesForKey.configurationDefaultOverrideValue = newDefaultOverride;
          const property = this.e[key];
          if (property) {
            this.A(key, property);
            this.w(key, property);
          }
        }
      }
    }
    this.q(overrideIdentifiers);
  }
  deregisterDefaultConfigurations(defaultConfigurations) {
    const properties = /* @__PURE__ */ new Set();
    this.m(defaultConfigurations, properties);
    this.j.fire();
    this.k.fire({ properties, defaultsOverrides: true });
  }
  m(defaultConfigurations, bucket) {
    for (const defaultConfiguration of defaultConfigurations) {
      const index = this.a.indexOf(defaultConfiguration);
      if (index !== -1) {
        this.a.splice(index, 1);
      }
    }
    for (const { overrides, source } of defaultConfigurations) {
      for (const key in overrides) {
        const configurationDefaultOverridesForKey = this.b.get(key);
        if (!configurationDefaultOverridesForKey) {
          continue;
        }
        const index = configurationDefaultOverridesForKey.configurationDefaultOverrides.findIndex((configurationDefaultOverride) => source ? configurationDefaultOverride.source?.id === source.id : configurationDefaultOverride.value === overrides[key]);
        if (index === -1) {
          continue;
        }
        configurationDefaultOverridesForKey.configurationDefaultOverrides.splice(index, 1);
        if (configurationDefaultOverridesForKey.configurationDefaultOverrides.length === 0) {
          this.b.delete(key);
        }
        if ($2o.test(key)) {
          let configurationDefaultOverrideValue;
          for (const configurationDefaultOverride of configurationDefaultOverridesForKey.configurationDefaultOverrides) {
            configurationDefaultOverrideValue = this.o(key, configurationDefaultOverride.value, configurationDefaultOverride.source, configurationDefaultOverrideValue);
          }
          if (configurationDefaultOverrideValue && !$Lg(configurationDefaultOverrideValue.value)) {
            configurationDefaultOverridesForKey.configurationDefaultOverrideValue = configurationDefaultOverrideValue;
            this.n(key, configurationDefaultOverrideValue, source);
          } else {
            this.b.delete(key);
            delete this.e[key];
            delete this.c.properties[key];
          }
        } else {
          let configurationDefaultOverrideValue;
          for (const configurationDefaultOverride of configurationDefaultOverridesForKey.configurationDefaultOverrides) {
            configurationDefaultOverrideValue = this.p(key, configurationDefaultOverride.value, configurationDefaultOverride.source, configurationDefaultOverrideValue);
          }
          configurationDefaultOverridesForKey.configurationDefaultOverrideValue = configurationDefaultOverrideValue;
          const property = this.e[key];
          if (property) {
            this.A(key, property);
            this.w(key, property);
          }
        }
        bucket.add(key);
      }
    }
    this.y();
  }
  n(key, newDefaultOverride, source) {
    const property = {
      type: "object",
      default: newDefaultOverride.value,
      description: localize(1673, null, $Dj(key)),
      $ref: $Yo,
      defaultDefaultValue: newDefaultOverride.value,
      source,
      defaultValueSource: source
    };
    this.e[key] = property;
    this.c.properties[key] = property;
  }
  o(overrideIdentifier, configurationValueObject, valueSource, existingDefaultOverride) {
    const defaultValue = existingDefaultOverride?.value || {};
    const source = existingDefaultOverride?.source ?? /* @__PURE__ */ new Map();
    if (!(source instanceof Map)) {
      console.error("objectConfigurationSources is not a Map");
      return void 0;
    }
    for (const propertyKey of Object.keys(configurationValueObject)) {
      const propertyDefaultValue = configurationValueObject[propertyKey];
      const isObjectSetting2 = $Ag(propertyDefaultValue) && ($Fg(defaultValue[propertyKey]) || $Ag(defaultValue[propertyKey]));
      if (isObjectSetting2) {
        defaultValue[propertyKey] = { ...defaultValue[propertyKey] ?? {}, ...propertyDefaultValue };
        if (valueSource) {
          for (const objectKey in propertyDefaultValue) {
            source.set(`${propertyKey}.${objectKey}`, valueSource);
          }
        }
      } else {
        defaultValue[propertyKey] = propertyDefaultValue;
        if (valueSource) {
          source.set(propertyKey, valueSource);
        } else {
          source.delete(propertyKey);
        }
      }
    }
    return { value: defaultValue, source };
  }
  p(propertyKey, value, valuesSource, existingDefaultOverride) {
    const property = this.e[propertyKey];
    const existingDefaultValue = existingDefaultOverride?.value ?? property?.defaultDefaultValue;
    let source = valuesSource;
    const isObjectSetting2 = $Ag(value) && (property !== void 0 && property.type === "object" || property === void 0 && ($Fg(existingDefaultValue) || $Ag(existingDefaultValue)));
    if (isObjectSetting2) {
      source = existingDefaultOverride?.source ?? /* @__PURE__ */ new Map();
      if (!(source instanceof Map)) {
        console.error("defaultValueSource is not a Map");
        return void 0;
      }
      for (const objectKey in value) {
        if (valuesSource) {
          source.set(`${propertyKey}.${objectKey}`, valuesSource);
        }
      }
      value = { ...$Ag(existingDefaultValue) ? existingDefaultValue : {}, ...value };
    }
    return { value, source };
  }
  deltaConfiguration(delta) {
    let defaultsOverrides = false;
    const properties = /* @__PURE__ */ new Set();
    if (delta.removedDefaults) {
      this.m(delta.removedDefaults, properties);
      defaultsOverrides = true;
    }
    if (delta.addedDefaults) {
      this.l(delta.addedDefaults, properties);
      defaultsOverrides = true;
    }
    if (delta.removedConfigurations) {
      this.s(delta.removedConfigurations, properties);
    }
    if (delta.addedConfigurations) {
      this.r(delta.addedConfigurations, false, properties);
    }
    this.j.fire();
    this.k.fire({ properties, defaultsOverrides });
  }
  notifyConfigurationSchemaUpdated(...configurations) {
    this.j.fire();
  }
  registerOverrideIdentifiers(overrideIdentifiers) {
    this.q(overrideIdentifiers);
    this.j.fire();
  }
  q(overrideIdentifiers) {
    for (const overrideIdentifier of overrideIdentifiers) {
      this.i.add(overrideIdentifier);
    }
    this.y();
  }
  r(configurations, validate, bucket) {
    configurations.forEach((configuration2) => {
      this.u(configuration2, validate, configuration2.extensionInfo, configuration2.restrictedProperties, void 0, bucket);
      this.d.push(configuration2);
      this.v(configuration2);
    });
  }
  s(configurations, bucket) {
    const deregisterConfiguration = (configuration2) => {
      if (configuration2.properties) {
        for (const key in configuration2.properties) {
          bucket.add(key);
          const property = this.e[key];
          if (property?.policy?.name) {
            this.f.delete(property.policy.name);
          }
          delete this.e[key];
          this.x(key, configuration2.properties[key]);
        }
      }
      configuration2.allOf?.forEach((node) => deregisterConfiguration(node));
    };
    for (const configuration2 of configurations) {
      deregisterConfiguration(configuration2);
      const index = this.d.indexOf(configuration2);
      if (index !== -1) {
        this.d.splice(index, 1);
      }
    }
  }
  u(configuration2, validate = true, extensionInfo, restrictedProperties, scope = 3, bucket) {
    scope = $Hg(configuration2.scope) ? scope : configuration2.scope;
    const properties = configuration2.properties;
    if (properties) {
      for (const key in properties) {
        const property = properties[key];
        if (validate && $6o(key, property)) {
          delete properties[key];
          continue;
        }
        property.source = extensionInfo;
        property.defaultDefaultValue = properties[key].default;
        this.A(key, property);
        if ($2o.test(key)) {
          property.scope = void 0;
        } else {
          property.scope = $Hg(property.scope) ? scope : property.scope;
          property.restricted = $Hg(property.restricted) ? !!restrictedProperties?.includes(key) : property.restricted;
        }
        if (properties[key].hasOwnProperty("included") && !properties[key].included) {
          this.g[key] = properties[key];
          delete properties[key];
          continue;
        } else {
          this.e[key] = properties[key];
          if (properties[key].policy?.name) {
            this.f.set(properties[key].policy.name, key);
          }
        }
        if (!properties[key].deprecationMessage && properties[key].markdownDeprecationMessage) {
          properties[key].deprecationMessage = properties[key].markdownDeprecationMessage;
        }
        bucket.add(key);
      }
    }
    const subNodes = configuration2.allOf;
    if (subNodes) {
      for (const node of subNodes) {
        this.u(node, validate, extensionInfo, restrictedProperties, scope, bucket);
      }
    }
  }
  // TODO: @sandy081 - Remove this method and include required info in getConfigurationProperties
  getConfigurations() {
    return this.d;
  }
  getConfigurationProperties() {
    return this.e;
  }
  getPolicyConfigurations() {
    return this.f;
  }
  getExcludedConfigurationProperties() {
    return this.g;
  }
  getRegisteredDefaultConfigurations() {
    return [...this.a];
  }
  getConfigurationDefaultsOverrides() {
    const configurationDefaultsOverrides = /* @__PURE__ */ new Map();
    for (const [key, value] of this.b) {
      if (value.configurationDefaultOverrideValue) {
        configurationDefaultsOverrides.set(key, value.configurationDefaultOverrideValue);
      }
    }
    return configurationDefaultsOverrides;
  }
  v(configuration2) {
    const register2 = (configuration3) => {
      const properties = configuration3.properties;
      if (properties) {
        for (const key in properties) {
          this.w(key, properties[key]);
        }
      }
      const subNodes = configuration3.allOf;
      subNodes?.forEach(register2);
    };
    register2(configuration2);
  }
  w(key, property) {
    $So.properties[key] = property;
    switch (property.scope) {
      case 1:
        $To.properties[key] = property;
        break;
      case 2:
        $Uo.properties[key] = property;
        break;
      case 6:
        $Vo.properties[key] = property;
        break;
      case 3:
        $Wo.properties[key] = property;
        break;
      case 4:
        $Xo.properties[key] = property;
        break;
      case 5:
        $Xo.properties[key] = property;
        this.h.properties[key] = property;
        break;
    }
  }
  x(key, property) {
    delete $So.properties[key];
    switch (property.scope) {
      case 1:
        delete $To.properties[key];
        break;
      case 2:
        delete $Uo.properties[key];
        break;
      case 6:
        delete $Vo.properties[key];
        break;
      case 3:
        delete $Wo.properties[key];
        break;
      case 4:
      case 5:
        delete $Xo.properties[key];
        delete this.h.properties[key];
        break;
    }
  }
  y() {
    for (const overrideIdentifier of this.i.values()) {
      const overrideIdentifierProperty = `[${overrideIdentifier}]`;
      const resourceLanguagePropertiesSchema = {
        type: "object",
        description: localize(1674, null),
        errorMessage: localize(1675, null),
        $ref: $Yo
      };
      this.A(overrideIdentifierProperty, resourceLanguagePropertiesSchema);
      $So.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
      $To.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
      $Uo.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
      $Vo.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
      $Wo.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
      $Xo.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
    }
  }
  z() {
    const resourceLanguagePropertiesSchema = {
      type: "object",
      description: localize(1676, null),
      errorMessage: localize(1677, null),
      $ref: $Yo
    };
    $So.patternProperties[$1o] = resourceLanguagePropertiesSchema;
    $To.patternProperties[$1o] = resourceLanguagePropertiesSchema;
    $Uo.patternProperties[$1o] = resourceLanguagePropertiesSchema;
    $Vo.patternProperties[$1o] = resourceLanguagePropertiesSchema;
    $Wo.patternProperties[$1o] = resourceLanguagePropertiesSchema;
    $Xo.patternProperties[$1o] = resourceLanguagePropertiesSchema;
    this.j.fire();
  }
  A(key, property) {
    const configurationdefaultOverride = this.b.get(key)?.configurationDefaultOverrideValue;
    let defaultValue = void 0;
    let defaultSource = void 0;
    if (configurationdefaultOverride && (!property.disallowConfigurationDefault || !configurationdefaultOverride.source)) {
      defaultValue = configurationdefaultOverride.value;
      defaultSource = configurationdefaultOverride.source;
    }
    if ($Fg(defaultValue)) {
      defaultValue = property.defaultDefaultValue;
      defaultSource = void 0;
    }
    if ($Fg(defaultValue)) {
      defaultValue = $5o(property.type);
    }
    property.default = defaultValue;
    property.defaultValueSource = defaultSource;
  }
};
var OVERRIDE_IDENTIFIER_PATTERN = `\\[([^\\]]+)\\]`;
var OVERRIDE_IDENTIFIER_REGEX = new RegExp(OVERRIDE_IDENTIFIER_PATTERN, "g");
var $1o = `^(${OVERRIDE_IDENTIFIER_PATTERN})+$`;
var $2o = new RegExp($1o);
function $3o(key) {
  const identifiers2 = [];
  if ($2o.test(key)) {
    let matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
    while (matches?.length) {
      const identifier2 = matches[1].trim();
      if (identifier2) {
        identifiers2.push(identifier2);
      }
      matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
    }
  }
  return $Zb(identifiers2);
}
function $4o(overrideIdentifiers) {
  return overrideIdentifiers.reduce((result, overrideIdentifier) => `${result}[${overrideIdentifier}]`, "");
}
function $5o(type) {
  const t = Array.isArray(type) ? type[0] : type;
  switch (t) {
    case "boolean":
      return false;
    case "integer":
    case "number":
      return 0;
    case "string":
      return "";
    case "array":
      return [];
    case "object":
      return {};
    default:
      return null;
  }
}
var configurationRegistry = new ConfigurationRegistry();
$Mo.add($Ro.Configuration, configurationRegistry);
function $6o(property, schema9) {
  if (!property.trim()) {
    return localize(1678, null);
  }
  if ($2o.test(property)) {
    return localize(1679, null, property);
  }
  if (configurationRegistry.getConfigurationProperties()[property] !== void 0) {
    return localize(1680, null, property);
  }
  if (schema9.policy?.name && configurationRegistry.getPolicyConfigurations().get(schema9.policy?.name) !== void 0) {
    return localize(1681, null, property, schema9.policy?.name, configurationRegistry.getPolicyConfigurations().get(schema9.policy?.name));
  }
  return null;
}
function $7o() {
  const scopes = [];
  const configurationProperties = configurationRegistry.getConfigurationProperties();
  for (const key of Object.keys(configurationProperties)) {
    scopes.push([key, configurationProperties[key].scope]);
  }
  scopes.push([
    "launch",
    4
    /* ConfigurationScope.RESOURCE */
  ]);
  scopes.push([
    "task",
    4
    /* ConfigurationScope.RESOURCE */
  ]);
  return scopes;
}
function $8o(configurationNode) {
  const result = {};
  for (const configuration2 of configurationNode) {
    const properties = configuration2.properties;
    if ($Ag(properties)) {
      for (const key in properties) {
        result[key] = properties[key];
      }
    }
    if (configuration2.allOf) {
      Object.assign(result, $8o(configuration2.allOf));
    }
  }
  return result;
}
function $9o(scope) {
  switch (scope) {
    case "application":
      return 1;
    case "machine":
      return 2;
    case "resource":
      return 4;
    case "machine-overridable":
      return 6;
    case "language-overridable":
      return 5;
    default:
      return 3;
  }
}

// out-build/vs/editor/common/languages/modesRegistry.js
var $bw = {
  ModesRegistry: "editor.modesRegistry"
};
var $cw = class {
  constructor() {
    this.b = new $De();
    this.onDidChangeLanguages = this.b.event;
    this.a = [];
  }
  registerLanguage(def4) {
    this.a.push(def4);
    this.b.fire(void 0);
    return {
      dispose: () => {
        for (let i = 0, len = this.a.length; i < len; i++) {
          if (this.a[i] === def4) {
            this.a.splice(i, 1);
            return;
          }
        }
      }
    };
  }
  getLanguages() {
    return this.a;
  }
};
var $dw = new $cw();
$Mo.add($bw.ModesRegistry, $dw);
var $ew = "plaintext";
var $fw = ".txt";
$dw.registerLanguage({
  id: $ew,
  extensions: [$fw],
  aliases: [localize(821, null), "text"],
  mimetypes: [$ut.text]
});
$Mo.as($Ro.Configuration).registerDefaultConfigurations([{
  overrides: {
    "[plaintext]": {
      "editor.unicodeHighlight.ambiguousCharacters": false,
      "editor.unicodeHighlight.invisibleCharacters": false
    }
  }
}]);

// out-build/vs/editor/common/languages/supports/languageBracketsConfiguration.js
var $Ev = class {
  constructor(languageId, config) {
    this.languageId = languageId;
    const bracketPairs = config.brackets ? filterValidBrackets(config.brackets) : [];
    const openingBracketInfos = new $sf((bracket) => {
      const closing = /* @__PURE__ */ new Set();
      return {
        info: new $Gv(this, bracket, closing),
        closing
      };
    });
    const closingBracketInfos = new $sf((bracket) => {
      const opening = /* @__PURE__ */ new Set();
      const openingColorized = /* @__PURE__ */ new Set();
      return {
        info: new $Hv(this, bracket, opening, openingColorized),
        opening,
        openingColorized
      };
    });
    for (const [open2, close2] of bracketPairs) {
      const opening = openingBracketInfos.get(open2);
      const closing = closingBracketInfos.get(close2);
      opening.closing.add(closing.info);
      closing.opening.add(opening.info);
    }
    const colorizedBracketPairs = config.colorizedBracketPairs ? filterValidBrackets(config.colorizedBracketPairs) : bracketPairs.filter((p) => !(p[0] === "<" && p[1] === ">"));
    for (const [open2, close2] of colorizedBracketPairs) {
      const opening = openingBracketInfos.get(open2);
      const closing = closingBracketInfos.get(close2);
      opening.closing.add(closing.info);
      closing.openingColorized.add(opening.info);
      closing.opening.add(opening.info);
    }
    this.a = new Map([...openingBracketInfos.cachedValues].map(([k, v]) => [k, v.info]));
    this.b = new Map([...closingBracketInfos.cachedValues].map(([k, v]) => [k, v.info]));
  }
  /**
   * No two brackets have the same bracket text.
  */
  get openingBrackets() {
    return [...this.a.values()];
  }
  /**
   * No two brackets have the same bracket text.
  */
  get closingBrackets() {
    return [...this.b.values()];
  }
  getOpeningBracketInfo(bracketText) {
    return this.a.get(bracketText);
  }
  getClosingBracketInfo(bracketText) {
    return this.b.get(bracketText);
  }
  getBracketInfo(bracketText) {
    return this.getOpeningBracketInfo(bracketText) || this.getClosingBracketInfo(bracketText);
  }
  getBracketRegExp(options3) {
    const brackets = Array.from([...this.a.keys(), ...this.b.keys()]);
    return $Cv(brackets, options3);
  }
};
function filterValidBrackets(bracketPairs) {
  return bracketPairs.filter(([open2, close2]) => open2 !== "" && close2 !== "");
}
var $Fv = class {
  constructor(a, bracketText) {
    this.a = a;
    this.bracketText = bracketText;
  }
  get languageId() {
    return this.a.languageId;
  }
};
var $Gv = class extends $Fv {
  constructor(config, bracketText, openedBrackets) {
    super(config, bracketText);
    this.openedBrackets = openedBrackets;
    this.isOpeningBracket = true;
  }
};
var $Hv = class extends $Fv {
  constructor(config, bracketText, openingBrackets, b) {
    super(config, bracketText);
    this.openingBrackets = openingBrackets;
    this.b = b;
    this.isOpeningBracket = false;
  }
  /**
   * Checks if this bracket closes the given other bracket.
   * If the bracket infos come from different configurations, this method will return false.
  */
  closes(other4) {
    if (other4["a"] !== this.a) {
      return false;
    }
    return this.openingBrackets.has(other4);
  }
  closesColorized(other4) {
    if (other4["a"] !== this.a) {
      return false;
    }
    return this.b.has(other4);
  }
  getOpeningBrackets() {
    return [...this.openingBrackets];
  }
};

// out-build/vs/editor/common/languages/languageConfigurationRegistry.js
var $gw = class {
  constructor(languageId) {
    this.languageId = languageId;
  }
  affects(languageId) {
    return !this.languageId ? true : this.languageId === languageId;
  }
};
var $hw = $Zi("languageConfigurationService");
var $iw = class $iw2 extends $0c {
  constructor(h3, j) {
    super();
    this.h = h3;
    this.j = j;
    this.c = this.B(new $lw());
    this.f = this.B(new $De());
    this.onDidChange = this.f.event;
    this.g = /* @__PURE__ */ new Map();
    const languageConfigKeys = new Set(Object.values(customizedLanguageConfigKeys));
    this.B(this.h.onDidChangeConfiguration((e) => {
      const globalConfigChanged = e.change.keys.some((k) => languageConfigKeys.has(k));
      const localConfigChanged = e.change.overrides.filter(([overrideLangName, keys]) => keys.some((k) => languageConfigKeys.has(k))).map(([overrideLangName]) => overrideLangName);
      if (globalConfigChanged) {
        this.g.clear();
        this.f.fire(new $gw(void 0));
      } else {
        for (const languageId of localConfigChanged) {
          if (this.j.isRegisteredLanguageId(languageId)) {
            this.g.delete(languageId);
            this.f.fire(new $gw(languageId));
          }
        }
      }
    }));
    this.B(this.c.onDidChange((e) => {
      this.g.delete(e.languageId);
      this.f.fire(new $gw(e.languageId));
    }));
  }
  register(languageId, configuration2, priority) {
    return this.c.register(languageId, configuration2, priority);
  }
  getLanguageConfiguration(languageId) {
    let result = this.g.get(languageId);
    if (!result) {
      result = computeConfig(languageId, this.c, this.h, this.j);
      this.g.set(languageId, result);
    }
    return result;
  }
};
$iw = __decorate([
  __param(0, $tj),
  __param(1, $uv)
], $iw);
function computeConfig(languageId, registry4, configurationService, languageService) {
  let languageConfig = registry4.getLanguageConfiguration(languageId);
  if (!languageConfig) {
    if (!languageService.isRegisteredLanguageId(languageId)) {
      return new $mw(languageId, {});
    }
    languageConfig = new $mw(languageId, {});
  }
  const customizedConfig = getCustomizedLanguageConfig(languageConfig.languageId, configurationService);
  const data = combineLanguageConfigurations([languageConfig.underlyingConfig, customizedConfig]);
  const config = new $mw(languageConfig.languageId, data);
  return config;
}
var customizedLanguageConfigKeys = {
  brackets: "editor.language.brackets",
  colorizedBracketPairs: "editor.language.colorizedBracketPairs"
};
function getCustomizedLanguageConfig(languageId, configurationService) {
  const brackets = configurationService.getValue(customizedLanguageConfigKeys.brackets, {
    overrideIdentifier: languageId
  });
  const colorizedBracketPairs = configurationService.getValue(customizedLanguageConfigKeys.colorizedBracketPairs, {
    overrideIdentifier: languageId
  });
  return {
    brackets: validateBracketPairs(brackets),
    colorizedBracketPairs: validateBracketPairs(colorizedBracketPairs)
  };
}
function validateBracketPairs(data) {
  if (!Array.isArray(data)) {
    return void 0;
  }
  return data.map((pair) => {
    if (!Array.isArray(pair) || pair.length !== 2) {
      return void 0;
    }
    return [pair[0], pair[1]];
  }).filter((p) => !!p);
}
function $jw(model, lineNumber, column) {
  const lineText = model.getLineContent(lineNumber);
  let indentation = $Of(lineText);
  if (indentation.length > column - 1) {
    indentation = indentation.substring(0, column - 1);
  }
  return indentation;
}
var ComposedLanguageConfiguration = class {
  constructor(languageId) {
    this.languageId = languageId;
    this.f = null;
    this.c = [];
    this.d = 0;
    this.f = null;
  }
  register(configuration2, priority) {
    const entry = new LanguageConfigurationContribution(configuration2, priority, ++this.d);
    this.c.push(entry);
    this.f = null;
    return $8c(() => {
      for (let i = 0; i < this.c.length; i++) {
        if (this.c[i] === entry) {
          this.c.splice(i, 1);
          this.f = null;
          break;
        }
      }
    });
  }
  getResolvedConfiguration() {
    if (!this.f) {
      const config = this.g();
      if (config) {
        this.f = new $mw(this.languageId, config);
      }
    }
    return this.f;
  }
  g() {
    if (this.c.length === 0) {
      return null;
    }
    this.c.sort(LanguageConfigurationContribution.cmp);
    return combineLanguageConfigurations(this.c.map((e) => e.configuration));
  }
};
function combineLanguageConfigurations(configs) {
  let result = {
    comments: void 0,
    brackets: void 0,
    wordPattern: void 0,
    indentationRules: void 0,
    onEnterRules: void 0,
    autoClosingPairs: void 0,
    surroundingPairs: void 0,
    autoCloseBefore: void 0,
    folding: void 0,
    colorizedBracketPairs: void 0,
    __electricCharacterSupport: void 0
  };
  for (const entry of configs) {
    result = {
      comments: entry.comments || result.comments,
      brackets: entry.brackets || result.brackets,
      wordPattern: entry.wordPattern || result.wordPattern,
      indentationRules: entry.indentationRules || result.indentationRules,
      onEnterRules: entry.onEnterRules || result.onEnterRules,
      autoClosingPairs: entry.autoClosingPairs || result.autoClosingPairs,
      surroundingPairs: entry.surroundingPairs || result.surroundingPairs,
      autoCloseBefore: entry.autoCloseBefore || result.autoCloseBefore,
      folding: entry.folding || result.folding,
      colorizedBracketPairs: entry.colorizedBracketPairs || result.colorizedBracketPairs,
      __electricCharacterSupport: entry.__electricCharacterSupport || result.__electricCharacterSupport
    };
  }
  return result;
}
var LanguageConfigurationContribution = class {
  constructor(configuration2, priority, order) {
    this.configuration = configuration2;
    this.priority = priority;
    this.order = order;
  }
  static cmp(a, b) {
    if (a.priority === b.priority) {
      return a.order - b.order;
    }
    return a.priority - b.priority;
  }
};
var $kw = class {
  constructor(languageId) {
    this.languageId = languageId;
  }
};
var $lw = class extends $0c {
  constructor() {
    super();
    this.c = /* @__PURE__ */ new Map();
    this.f = this.B(new $De());
    this.onDidChange = this.f.event;
    this.B(this.register($ew, {
      brackets: [
        ["(", ")"],
        ["[", "]"],
        ["{", "}"]
      ],
      surroundingPairs: [
        { open: "{", close: "}" },
        { open: "[", close: "]" },
        { open: "(", close: ")" },
        { open: "<", close: ">" },
        { open: '"', close: '"' },
        { open: "'", close: "'" },
        { open: "`", close: "`" }
      ],
      colorizedBracketPairs: [],
      folding: {
        offSide: true
      }
    }, 0));
  }
  /**
   * @param priority Use a higher number for higher priority
   */
  register(languageId, configuration2, priority = 0) {
    let entries2 = this.c.get(languageId);
    if (!entries2) {
      entries2 = new ComposedLanguageConfiguration(languageId);
      this.c.set(languageId, entries2);
    }
    const disposable = entries2.register(configuration2, priority);
    this.f.fire(new $kw(languageId));
    return $8c(() => {
      disposable.dispose();
      this.f.fire(new $kw(languageId));
    });
  }
  getLanguageConfiguration(languageId) {
    const entries2 = this.c.get(languageId);
    return entries2?.getResolvedConfiguration() || null;
  }
};
var $mw = class _$mw {
  constructor(languageId, underlyingConfig) {
    this.languageId = languageId;
    this.underlyingConfig = underlyingConfig;
    this.c = null;
    this.d = null;
    this.f = this.underlyingConfig.brackets || this.underlyingConfig.indentationRules || this.underlyingConfig.onEnterRules ? new $aw(this.underlyingConfig) : null;
    this.comments = _$mw.g(this.underlyingConfig);
    this.characterPair = new $0v(this.underlyingConfig);
    this.wordDefinition = this.underlyingConfig.wordPattern || $Jt;
    this.indentationRules = this.underlyingConfig.indentationRules;
    if (this.underlyingConfig.indentationRules) {
      this.indentRulesSupport = new $_v(this.underlyingConfig.indentationRules);
    } else {
      this.indentRulesSupport = null;
    }
    this.foldingRules = this.underlyingConfig.folding || {};
    this.bracketsNew = new $Ev(languageId, this.underlyingConfig);
  }
  getWordDefinition() {
    return $Kt(this.wordDefinition);
  }
  get brackets() {
    if (!this.c && this.underlyingConfig.brackets) {
      this.c = new $Bv(this.languageId, this.underlyingConfig.brackets);
    }
    return this.c;
  }
  get electricCharacter() {
    if (!this.d) {
      this.d = new $$v(this.brackets);
    }
    return this.d;
  }
  onEnter(autoIndent, previousLineText, beforeEnterText, afterEnterText) {
    if (!this.f) {
      return null;
    }
    return this.f.onEnter(autoIndent, previousLineText, beforeEnterText, afterEnterText);
  }
  getAutoClosingPairs() {
    return new $zv(this.characterPair.getAutoClosingPairs());
  }
  getAutoCloseBeforeSet(forQuotes) {
    return this.characterPair.getAutoCloseBeforeSet(forQuotes);
  }
  getSurroundingPairs() {
    return this.characterPair.getSurroundingPairs();
  }
  static g(conf) {
    const commentRule = conf.comments;
    if (!commentRule) {
      return null;
    }
    const comments = {};
    if (commentRule.lineComment) {
      comments.lineCommentToken = commentRule.lineComment;
    }
    if (commentRule.blockComment) {
      const [blockStart, blockEnd] = commentRule.blockComment;
      comments.blockCommentStartToken = blockStart;
      comments.blockCommentEndToken = blockEnd;
    }
    return comments;
  }
};
$bt(
  $hw,
  $iw,
  1
  /* InstantiationType.Delayed */
);

// out-build/vs/editor/common/encodedTokenAttributes.js
var LanguageId;
(function(LanguageId2) {
  LanguageId2[LanguageId2["Null"] = 0] = "Null";
  LanguageId2[LanguageId2["PlainText"] = 1] = "PlainText";
})(LanguageId || (LanguageId = {}));
var FontStyle;
(function(FontStyle2) {
  FontStyle2[FontStyle2["NotSet"] = -1] = "NotSet";
  FontStyle2[FontStyle2["None"] = 0] = "None";
  FontStyle2[FontStyle2["Italic"] = 1] = "Italic";
  FontStyle2[FontStyle2["Bold"] = 2] = "Bold";
  FontStyle2[FontStyle2["Underline"] = 4] = "Underline";
  FontStyle2[FontStyle2["Strikethrough"] = 8] = "Strikethrough";
})(FontStyle || (FontStyle = {}));
var ColorId;
(function(ColorId2) {
  ColorId2[ColorId2["None"] = 0] = "None";
  ColorId2[ColorId2["DefaultForeground"] = 1] = "DefaultForeground";
  ColorId2[ColorId2["DefaultBackground"] = 2] = "DefaultBackground";
})(ColorId || (ColorId = {}));
var StandardTokenType;
(function(StandardTokenType3) {
  StandardTokenType3[StandardTokenType3["Other"] = 0] = "Other";
  StandardTokenType3[StandardTokenType3["Comment"] = 1] = "Comment";
  StandardTokenType3[StandardTokenType3["String"] = 2] = "String";
  StandardTokenType3[StandardTokenType3["RegEx"] = 3] = "RegEx";
})(StandardTokenType || (StandardTokenType = {}));
var MetadataConsts;
(function(MetadataConsts2) {
  MetadataConsts2[MetadataConsts2["LANGUAGEID_MASK"] = 255] = "LANGUAGEID_MASK";
  MetadataConsts2[MetadataConsts2["TOKEN_TYPE_MASK"] = 768] = "TOKEN_TYPE_MASK";
  MetadataConsts2[MetadataConsts2["BALANCED_BRACKETS_MASK"] = 1024] = "BALANCED_BRACKETS_MASK";
  MetadataConsts2[MetadataConsts2["FONT_STYLE_MASK"] = 30720] = "FONT_STYLE_MASK";
  MetadataConsts2[MetadataConsts2["FOREGROUND_MASK"] = 16744448] = "FOREGROUND_MASK";
  MetadataConsts2[MetadataConsts2["BACKGROUND_MASK"] = 4278190080] = "BACKGROUND_MASK";
  MetadataConsts2[MetadataConsts2["ITALIC_MASK"] = 2048] = "ITALIC_MASK";
  MetadataConsts2[MetadataConsts2["BOLD_MASK"] = 4096] = "BOLD_MASK";
  MetadataConsts2[MetadataConsts2["UNDERLINE_MASK"] = 8192] = "UNDERLINE_MASK";
  MetadataConsts2[MetadataConsts2["STRIKETHROUGH_MASK"] = 16384] = "STRIKETHROUGH_MASK";
  MetadataConsts2[MetadataConsts2["SEMANTIC_USE_ITALIC"] = 1] = "SEMANTIC_USE_ITALIC";
  MetadataConsts2[MetadataConsts2["SEMANTIC_USE_BOLD"] = 2] = "SEMANTIC_USE_BOLD";
  MetadataConsts2[MetadataConsts2["SEMANTIC_USE_UNDERLINE"] = 4] = "SEMANTIC_USE_UNDERLINE";
  MetadataConsts2[MetadataConsts2["SEMANTIC_USE_STRIKETHROUGH"] = 8] = "SEMANTIC_USE_STRIKETHROUGH";
  MetadataConsts2[MetadataConsts2["SEMANTIC_USE_FOREGROUND"] = 16] = "SEMANTIC_USE_FOREGROUND";
  MetadataConsts2[MetadataConsts2["SEMANTIC_USE_BACKGROUND"] = 32] = "SEMANTIC_USE_BACKGROUND";
  MetadataConsts2[MetadataConsts2["LANGUAGEID_OFFSET"] = 0] = "LANGUAGEID_OFFSET";
  MetadataConsts2[MetadataConsts2["TOKEN_TYPE_OFFSET"] = 8] = "TOKEN_TYPE_OFFSET";
  MetadataConsts2[MetadataConsts2["BALANCED_BRACKETS_OFFSET"] = 10] = "BALANCED_BRACKETS_OFFSET";
  MetadataConsts2[MetadataConsts2["FONT_STYLE_OFFSET"] = 11] = "FONT_STYLE_OFFSET";
  MetadataConsts2[MetadataConsts2["FOREGROUND_OFFSET"] = 15] = "FOREGROUND_OFFSET";
  MetadataConsts2[MetadataConsts2["BACKGROUND_OFFSET"] = 24] = "BACKGROUND_OFFSET";
})(MetadataConsts || (MetadataConsts = {}));
var $Vu = class {
  static getLanguageId(metadata) {
    return (metadata & 255) >>> 0;
  }
  static getTokenType(metadata) {
    return (metadata & 768) >>> 8;
  }
  static containsBalancedBrackets(metadata) {
    return (metadata & 1024) !== 0;
  }
  static getFontStyle(metadata) {
    return (metadata & 30720) >>> 11;
  }
  static getForeground(metadata) {
    return (metadata & 16744448) >>> 15;
  }
  static getBackground(metadata) {
    return (metadata & 4278190080) >>> 24;
  }
  static getClassNameFromMetadata(metadata) {
    const foreground = this.getForeground(metadata);
    let className = "mtk" + foreground;
    const fontStyle = this.getFontStyle(metadata);
    if (fontStyle & 1) {
      className += " mtki";
    }
    if (fontStyle & 2) {
      className += " mtkb";
    }
    if (fontStyle & 4) {
      className += " mtku";
    }
    if (fontStyle & 8) {
      className += " mtks";
    }
    return className;
  }
  static getInlineStyleFromMetadata(metadata, colorMap) {
    const foreground = this.getForeground(metadata);
    const fontStyle = this.getFontStyle(metadata);
    let result = `color: ${colorMap[foreground]};`;
    if (fontStyle & 1) {
      result += "font-style: italic;";
    }
    if (fontStyle & 2) {
      result += "font-weight: bold;";
    }
    let textDecoration = "";
    if (fontStyle & 4) {
      textDecoration += " underline";
    }
    if (fontStyle & 8) {
      textDecoration += " line-through";
    }
    if (textDecoration) {
      result += `text-decoration:${textDecoration};`;
    }
    return result;
  }
  static getPresentationFromMetadata(metadata) {
    const foreground = this.getForeground(metadata);
    const fontStyle = this.getFontStyle(metadata);
    return {
      foreground,
      italic: Boolean(
        fontStyle & 1
        /* FontStyle.Italic */
      ),
      bold: Boolean(
        fontStyle & 2
        /* FontStyle.Bold */
      ),
      underline: Boolean(
        fontStyle & 4
        /* FontStyle.Underline */
      ),
      strikethrough: Boolean(
        fontStyle & 8
        /* FontStyle.Strikethrough */
      )
    };
  }
};

// out-build/vs/editor/common/core/offsetRange.js
var $hu = class _$hu {
  static addRange(range2, sortedRanges) {
    let i = 0;
    while (i < sortedRanges.length && sortedRanges[i].endExclusive < range2.start) {
      i++;
    }
    let j = i;
    while (j < sortedRanges.length && sortedRanges[j].start <= range2.endExclusive) {
      j++;
    }
    if (i === j) {
      sortedRanges.splice(i, 0, range2);
    } else {
      const start = Math.min(range2.start, sortedRanges[i].start);
      const end = Math.max(range2.endExclusive, sortedRanges[j - 1].endExclusive);
      sortedRanges.splice(i, j - i, new _$hu(start, end));
    }
  }
  static tryCreate(start, endExclusive) {
    if (start > endExclusive) {
      return void 0;
    }
    return new _$hu(start, endExclusive);
  }
  static ofLength(length) {
    return new _$hu(0, length);
  }
  static ofStartAndLength(start, length) {
    return new _$hu(start, start + length);
  }
  static emptyAt(offset) {
    return new _$hu(offset, offset);
  }
  constructor(start, endExclusive) {
    this.start = start;
    this.endExclusive = endExclusive;
    if (start > endExclusive) {
      throw new $pb(`Invalid range: ${this.toString()}`);
    }
  }
  get isEmpty() {
    return this.start === this.endExclusive;
  }
  delta(offset) {
    return new _$hu(this.start + offset, this.endExclusive + offset);
  }
  deltaStart(offset) {
    return new _$hu(this.start + offset, this.endExclusive);
  }
  deltaEnd(offset) {
    return new _$hu(this.start, this.endExclusive + offset);
  }
  get length() {
    return this.endExclusive - this.start;
  }
  toString() {
    return `[${this.start}, ${this.endExclusive})`;
  }
  equals(other4) {
    return this.start === other4.start && this.endExclusive === other4.endExclusive;
  }
  containsRange(other4) {
    return this.start <= other4.start && other4.endExclusive <= this.endExclusive;
  }
  contains(offset) {
    return this.start <= offset && offset < this.endExclusive;
  }
  /**
   * for all numbers n: range1.contains(n) or range2.contains(n) => range1.join(range2).contains(n)
   * The joined range is the smallest range that contains both ranges.
   */
  join(other4) {
    return new _$hu(Math.min(this.start, other4.start), Math.max(this.endExclusive, other4.endExclusive));
  }
  /**
   * for all numbers n: range1.contains(n) and range2.contains(n) <=> range1.intersect(range2).contains(n)
   *
   * The resulting range is empty if the ranges do not intersect, but touch.
   * If the ranges don't even touch, the result is undefined.
   */
  intersect(other4) {
    const start = Math.max(this.start, other4.start);
    const end = Math.min(this.endExclusive, other4.endExclusive);
    if (start <= end) {
      return new _$hu(start, end);
    }
    return void 0;
  }
  intersectionLength(range2) {
    const start = Math.max(this.start, range2.start);
    const end = Math.min(this.endExclusive, range2.endExclusive);
    return Math.max(0, end - start);
  }
  intersects(other4) {
    const start = Math.max(this.start, other4.start);
    const end = Math.min(this.endExclusive, other4.endExclusive);
    return start < end;
  }
  intersectsOrTouches(other4) {
    const start = Math.max(this.start, other4.start);
    const end = Math.min(this.endExclusive, other4.endExclusive);
    return start <= end;
  }
  isBefore(other4) {
    return this.endExclusive <= other4.start;
  }
  isAfter(other4) {
    return this.start >= other4.endExclusive;
  }
  slice(arr) {
    return arr.slice(this.start, this.endExclusive);
  }
  substring(str) {
    return str.substring(this.start, this.endExclusive);
  }
  /**
   * Returns the given value if it is contained in this instance, otherwise the closest value that is contained.
   * The range must not be empty.
   */
  clip(value) {
    if (this.isEmpty) {
      throw new $pb(`Invalid clipping range: ${this.toString()}`);
    }
    return Math.max(this.start, Math.min(this.endExclusive - 1, value));
  }
  /**
   * Returns `r := value + k * length` such that `r` is contained in this range.
   * The range must not be empty.
   *
   * E.g. `[5, 10).clipCyclic(10) === 5`, `[5, 10).clipCyclic(11) === 6` and `[5, 10).clipCyclic(4) === 9`.
   */
  clipCyclic(value) {
    if (this.isEmpty) {
      throw new $pb(`Invalid clipping range: ${this.toString()}`);
    }
    if (value < this.start) {
      return this.endExclusive - (this.start - value) % this.length;
    }
    if (value >= this.endExclusive) {
      return this.start + (value - this.start) % this.length;
    }
    return value;
  }
  map(f) {
    const result = [];
    for (let i = this.start; i < this.endExclusive; i++) {
      result.push(f(i));
    }
    return result;
  }
  forEach(f) {
    for (let i = this.start; i < this.endExclusive; i++) {
      f(i);
    }
  }
};
var $iu = class _$iu {
  constructor() {
    this.a = [];
  }
  addRange(range2) {
    let i = 0;
    while (i < this.a.length && this.a[i].endExclusive < range2.start) {
      i++;
    }
    let j = i;
    while (j < this.a.length && this.a[j].start <= range2.endExclusive) {
      j++;
    }
    if (i === j) {
      this.a.splice(i, 0, range2);
    } else {
      const start = Math.min(range2.start, this.a[i].start);
      const end = Math.max(range2.endExclusive, this.a[j - 1].endExclusive);
      this.a.splice(i, j - i, new $hu(start, end));
    }
  }
  toString() {
    return this.a.map((r2) => r2.toString()).join(", ");
  }
  /**
   * Returns of there is a value that is contained in this instance and the given range.
   */
  intersectsStrict(other4) {
    let i = 0;
    while (i < this.a.length && this.a[i].endExclusive <= other4.start) {
      i++;
    }
    return i < this.a.length && this.a[i].start < other4.endExclusive;
  }
  intersectWithRange(other4) {
    const result = new _$iu();
    for (const range2 of this.a) {
      const intersection = range2.intersect(other4);
      if (intersection) {
        result.addRange(intersection);
      }
    }
    return result;
  }
  intersectWithRangeLength(other4) {
    return this.intersectWithRange(other4).length;
  }
  get length() {
    return this.a.reduce((prev, cur) => prev + cur.length, 0);
  }
};

// out-build/vs/editor/common/tokens/tokenArray.js
var $1u = class _$1u {
  static create(tokenInfo) {
    return new _$1u(tokenInfo);
  }
  constructor(a) {
    this.a = a;
  }
  forEach(cb) {
    let lengthSum = 0;
    for (const tokenInfo of this.a) {
      const range2 = new $hu(lengthSum, lengthSum + tokenInfo.length);
      cb(range2, tokenInfo);
      lengthSum += tokenInfo.length;
    }
  }
  slice(range2) {
    const result = [];
    let lengthSum = 0;
    for (const tokenInfo of this.a) {
      const tokenStart = lengthSum;
      const tokenEndEx = tokenStart + tokenInfo.length;
      if (tokenEndEx > range2.start) {
        if (tokenStart >= range2.endExclusive) {
          break;
        }
        const deltaBefore = Math.max(0, range2.start - tokenStart);
        const deltaAfter = Math.max(0, tokenEndEx - range2.endExclusive);
        result.push(new $2u(tokenInfo.length - deltaBefore - deltaAfter, tokenInfo.metadata));
      }
      lengthSum += tokenInfo.length;
    }
    return _$1u.create(result);
  }
};
var $2u = class {
  constructor(length, metadata) {
    this.length = length;
    this.metadata = metadata;
  }
};
var $3u = class {
  constructor() {
    this.a = [];
  }
  add(length, metadata) {
    this.a.push(new $2u(length, metadata));
  }
  build() {
    return $1u.create(this.a);
  }
};

// out-build/vs/editor/common/tokens/lineTokens.js
var $4u = class _$4u {
  static createEmpty(lineContent, decoder) {
    const defaultMetadata = _$4u.defaultTokenMetadata;
    const tokens = new Uint32Array(2);
    tokens[0] = lineContent.length;
    tokens[1] = defaultMetadata;
    return new _$4u(tokens, lineContent, decoder);
  }
  static createFromTextAndMetadata(data, decoder) {
    let offset = 0;
    let fullText = "";
    const tokens = new Array();
    for (const { text: text2, metadata } of data) {
      tokens.push(offset + text2.length, metadata);
      offset += text2.length;
      fullText += text2;
    }
    return new _$4u(new Uint32Array(tokens), fullText, decoder);
  }
  static convertToEndOffset(tokens, lineTextLength) {
    const tokenCount = tokens.length >>> 1;
    const lastTokenIndex = tokenCount - 1;
    for (let tokenIndex = 0; tokenIndex < lastTokenIndex; tokenIndex++) {
      tokens[tokenIndex << 1] = tokens[tokenIndex + 1 << 1];
    }
    tokens[lastTokenIndex << 1] = lineTextLength;
  }
  static findIndexInTokensArray(tokens, desiredIndex) {
    if (tokens.length <= 2) {
      return 0;
    }
    let low = 0;
    let high = (tokens.length >>> 1) - 1;
    while (low < high) {
      const mid = low + Math.floor((high - low) / 2);
      const endOffset = tokens[mid << 1];
      if (endOffset === desiredIndex) {
        return mid + 1;
      } else if (endOffset < desiredIndex) {
        low = mid + 1;
      } else if (endOffset > desiredIndex) {
        high = mid;
      }
    }
    return low;
  }
  static {
    this.defaultTokenMetadata = (0 << 11 | 1 << 15 | 2 << 24) >>> 0;
  }
  constructor(tokens, text2, decoder) {
    this._lineTokensBrand = void 0;
    this.a = tokens;
    this.b = this.a.length >>> 1;
    this.c = text2;
    this.languageIdCodec = decoder;
  }
  equals(other4) {
    if (other4 instanceof _$4u) {
      return this.slicedEquals(other4, 0, this.b);
    }
    return false;
  }
  slicedEquals(other4, sliceFromTokenIndex, sliceTokenCount) {
    if (this.c !== other4.c) {
      return false;
    }
    if (this.b !== other4.b) {
      return false;
    }
    const from = sliceFromTokenIndex << 1;
    const to = from + (sliceTokenCount << 1);
    for (let i = from; i < to; i++) {
      if (this.a[i] !== other4.a[i]) {
        return false;
      }
    }
    return true;
  }
  getLineContent() {
    return this.c;
  }
  getCount() {
    return this.b;
  }
  getStartOffset(tokenIndex) {
    if (tokenIndex > 0) {
      return this.a[tokenIndex - 1 << 1];
    }
    return 0;
  }
  getMetadata(tokenIndex) {
    const metadata = this.a[(tokenIndex << 1) + 1];
    return metadata;
  }
  getLanguageId(tokenIndex) {
    const metadata = this.a[(tokenIndex << 1) + 1];
    const languageId = $Vu.getLanguageId(metadata);
    return this.languageIdCodec.decodeLanguageId(languageId);
  }
  getStandardTokenType(tokenIndex) {
    const metadata = this.a[(tokenIndex << 1) + 1];
    return $Vu.getTokenType(metadata);
  }
  getForeground(tokenIndex) {
    const metadata = this.a[(tokenIndex << 1) + 1];
    return $Vu.getForeground(metadata);
  }
  getClassName(tokenIndex) {
    const metadata = this.a[(tokenIndex << 1) + 1];
    return $Vu.getClassNameFromMetadata(metadata);
  }
  getInlineStyle(tokenIndex, colorMap) {
    const metadata = this.a[(tokenIndex << 1) + 1];
    return $Vu.getInlineStyleFromMetadata(metadata, colorMap);
  }
  getPresentation(tokenIndex) {
    const metadata = this.a[(tokenIndex << 1) + 1];
    return $Vu.getPresentationFromMetadata(metadata);
  }
  getEndOffset(tokenIndex) {
    return this.a[tokenIndex << 1];
  }
  /**
   * Find the token containing offset `offset`.
   * @param offset The search offset
   * @return The index of the token containing the offset.
   */
  findTokenIndexAtOffset(offset) {
    return _$4u.findIndexInTokensArray(this.a, offset);
  }
  inflate() {
    return this;
  }
  sliceAndInflate(startOffset, endOffset, deltaOffset) {
    return new SliceLineTokens(this, startOffset, endOffset, deltaOffset);
  }
  /**
   * @pure
   * @param insertTokens Must be sorted by offset.
  */
  withInserted(insertTokens) {
    if (insertTokens.length === 0) {
      return this;
    }
    let nextOriginalTokenIdx = 0;
    let nextInsertTokenIdx = 0;
    let text2 = "";
    const newTokens = new Array();
    let originalEndOffset = 0;
    while (true) {
      const nextOriginalTokenEndOffset = nextOriginalTokenIdx < this.b ? this.a[nextOriginalTokenIdx << 1] : -1;
      const nextInsertToken = nextInsertTokenIdx < insertTokens.length ? insertTokens[nextInsertTokenIdx] : null;
      if (nextOriginalTokenEndOffset !== -1 && (nextInsertToken === null || nextOriginalTokenEndOffset <= nextInsertToken.offset)) {
        text2 += this.c.substring(originalEndOffset, nextOriginalTokenEndOffset);
        const metadata = this.a[(nextOriginalTokenIdx << 1) + 1];
        newTokens.push(text2.length, metadata);
        nextOriginalTokenIdx++;
        originalEndOffset = nextOriginalTokenEndOffset;
      } else if (nextInsertToken) {
        if (nextInsertToken.offset > originalEndOffset) {
          text2 += this.c.substring(originalEndOffset, nextInsertToken.offset);
          const metadata = this.a[(nextOriginalTokenIdx << 1) + 1];
          newTokens.push(text2.length, metadata);
          originalEndOffset = nextInsertToken.offset;
        }
        text2 += nextInsertToken.text;
        newTokens.push(text2.length, nextInsertToken.tokenMetadata);
        nextInsertTokenIdx++;
      } else {
        break;
      }
    }
    return new _$4u(new Uint32Array(newTokens), text2, this.languageIdCodec);
  }
  getTokensInRange(range2) {
    const builder = new $3u();
    const startTokenIndex = this.findTokenIndexAtOffset(range2.start);
    const endTokenIndex = this.findTokenIndexAtOffset(range2.endExclusive);
    for (let tokenIndex = startTokenIndex; tokenIndex <= endTokenIndex; tokenIndex++) {
      const tokenRange = new $hu(this.getStartOffset(tokenIndex), this.getEndOffset(tokenIndex));
      const length = tokenRange.intersectionLength(range2);
      if (length > 0) {
        builder.add(length, this.getMetadata(tokenIndex));
      }
    }
    return builder.build();
  }
  getTokenText(tokenIndex) {
    const startOffset = this.getStartOffset(tokenIndex);
    const endOffset = this.getEndOffset(tokenIndex);
    const text2 = this.c.substring(startOffset, endOffset);
    return text2;
  }
  forEach(callback) {
    const tokenCount = this.getCount();
    for (let tokenIndex = 0; tokenIndex < tokenCount; tokenIndex++) {
      callback(tokenIndex);
    }
  }
};
var SliceLineTokens = class _SliceLineTokens {
  constructor(source, startOffset, endOffset, deltaOffset) {
    this.a = source;
    this.b = startOffset;
    this.c = endOffset;
    this.d = deltaOffset;
    this.e = source.findTokenIndexAtOffset(startOffset);
    this.languageIdCodec = source.languageIdCodec;
    this.f = 0;
    for (let i = this.e, len = source.getCount(); i < len; i++) {
      const tokenStartOffset = source.getStartOffset(i);
      if (tokenStartOffset >= endOffset) {
        break;
      }
      this.f++;
    }
  }
  getMetadata(tokenIndex) {
    return this.a.getMetadata(this.e + tokenIndex);
  }
  getLanguageId(tokenIndex) {
    return this.a.getLanguageId(this.e + tokenIndex);
  }
  getLineContent() {
    return this.a.getLineContent().substring(this.b, this.c);
  }
  equals(other4) {
    if (other4 instanceof _SliceLineTokens) {
      return this.b === other4.b && this.c === other4.c && this.d === other4.d && this.a.slicedEquals(other4.a, this.e, this.f);
    }
    return false;
  }
  getCount() {
    return this.f;
  }
  getStandardTokenType(tokenIndex) {
    return this.a.getStandardTokenType(this.e + tokenIndex);
  }
  getForeground(tokenIndex) {
    return this.a.getForeground(this.e + tokenIndex);
  }
  getEndOffset(tokenIndex) {
    const tokenEndOffset = this.a.getEndOffset(this.e + tokenIndex);
    return Math.min(this.c, tokenEndOffset) - this.b + this.d;
  }
  getClassName(tokenIndex) {
    return this.a.getClassName(this.e + tokenIndex);
  }
  getInlineStyle(tokenIndex, colorMap) {
    return this.a.getInlineStyle(this.e + tokenIndex, colorMap);
  }
  getPresentation(tokenIndex) {
    return this.a.getPresentation(this.e + tokenIndex);
  }
  findTokenIndexAtOffset(offset) {
    return this.a.findTokenIndexAtOffset(offset + this.b - this.d) - this.e;
  }
  getTokenText(tokenIndex) {
    const adjustedTokenIndex = this.e + tokenIndex;
    const tokenStartOffset = this.a.getStartOffset(adjustedTokenIndex);
    const tokenEndOffset = this.a.getEndOffset(adjustedTokenIndex);
    let text2 = this.a.getTokenText(adjustedTokenIndex);
    if (tokenStartOffset < this.b) {
      text2 = text2.substring(this.b - tokenStartOffset);
    }
    if (tokenEndOffset > this.c) {
      text2 = text2.substring(0, text2.length - (tokenEndOffset - this.c));
    }
    return text2;
  }
  forEach(callback) {
    for (let tokenIndex = 0; tokenIndex < this.getCount(); tokenIndex++) {
      callback(tokenIndex);
    }
  }
};
function $5u(model, position) {
  const lineNumber = position.lineNumber;
  if (!model.tokenization.isCheapToTokenize(lineNumber)) {
    return void 0;
  }
  model.tokenization.forceTokenization(lineNumber);
  const lineTokens = model.tokenization.getLineTokens(lineNumber);
  const tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
  const tokenType = lineTokens.getStandardTokenType(tokenIndex);
  return tokenType;
}

// out-build/vs/editor/common/languages/supports/indentationLineProcessor.js
var $y2 = class {
  constructor(model, indentRulesSupport, languageConfigurationService) {
    this.a = indentRulesSupport;
    this.b = new IndentationLineProcessor(model, languageConfigurationService);
  }
  /**
   * Apply the new indentation and return whether the indentation level should be increased after the given line number
   */
  shouldIncrease(lineNumber, newIndentation) {
    const processedLine = this.b.getProcessedLine(lineNumber, newIndentation);
    return this.a.shouldIncrease(processedLine);
  }
  /**
   * Apply the new indentation and return whether the indentation level should be decreased after the given line number
   */
  shouldDecrease(lineNumber, newIndentation) {
    const processedLine = this.b.getProcessedLine(lineNumber, newIndentation);
    return this.a.shouldDecrease(processedLine);
  }
  /**
   * Apply the new indentation and return whether the indentation level should remain unchanged at the given line number
   */
  shouldIgnore(lineNumber, newIndentation) {
    const processedLine = this.b.getProcessedLine(lineNumber, newIndentation);
    return this.a.shouldIgnore(processedLine);
  }
  /**
   * Apply the new indentation and return whether the indentation level should increase on the line after the given line number
   */
  shouldIndentNextLine(lineNumber, newIndentation) {
    const processedLine = this.b.getProcessedLine(lineNumber, newIndentation);
    return this.a.shouldIndentNextLine(processedLine);
  }
};
var $z2 = class {
  constructor(model, languageConfigurationService) {
    this.a = model;
    this.b = new IndentationLineProcessor(model, languageConfigurationService);
  }
  /**
   * Returns the processed text, stripped from the language configuration brackets within the string, comment and regex tokens, around the given range
   */
  getProcessedTokenContextAroundRange(range2) {
    const beforeRangeProcessedTokens = this.c(range2);
    const afterRangeProcessedTokens = this.d(range2);
    const previousLineProcessedTokens = this.e(range2);
    return { beforeRangeProcessedTokens, afterRangeProcessedTokens, previousLineProcessedTokens };
  }
  c(range2) {
    this.a.tokenization.forceTokenization(range2.startLineNumber);
    const lineTokens = this.a.tokenization.getLineTokens(range2.startLineNumber);
    const scopedLineTokens = $vv(lineTokens, range2.startColumn - 1);
    let slicedTokens;
    if ($A2(this.a, range2.getStartPosition())) {
      const columnIndexWithinScope = range2.startColumn - 1 - scopedLineTokens.firstCharOffset;
      const firstCharacterOffset = scopedLineTokens.firstCharOffset;
      const lastCharacterOffset = firstCharacterOffset + columnIndexWithinScope;
      slicedTokens = lineTokens.sliceAndInflate(firstCharacterOffset, lastCharacterOffset, 0);
    } else {
      const columnWithinLine = range2.startColumn - 1;
      slicedTokens = lineTokens.sliceAndInflate(0, columnWithinLine, 0);
    }
    const processedTokens = this.b.getProcessedTokens(slicedTokens);
    return processedTokens;
  }
  d(range2) {
    const position = range2.isEmpty() ? range2.getStartPosition() : range2.getEndPosition();
    this.a.tokenization.forceTokenization(position.lineNumber);
    const lineTokens = this.a.tokenization.getLineTokens(position.lineNumber);
    const scopedLineTokens = $vv(lineTokens, position.column - 1);
    const columnIndexWithinScope = position.column - 1 - scopedLineTokens.firstCharOffset;
    const firstCharacterOffset = scopedLineTokens.firstCharOffset + columnIndexWithinScope;
    const lastCharacterOffset = scopedLineTokens.firstCharOffset + scopedLineTokens.getLineLength();
    const slicedTokens = lineTokens.sliceAndInflate(firstCharacterOffset, lastCharacterOffset, 0);
    const processedTokens = this.b.getProcessedTokens(slicedTokens);
    return processedTokens;
  }
  e(range2) {
    const getScopedLineTokensAtEndColumnOfLine = (lineNumber) => {
      this.a.tokenization.forceTokenization(lineNumber);
      const lineTokens2 = this.a.tokenization.getLineTokens(lineNumber);
      const endColumnOfLine = this.a.getLineMaxColumn(lineNumber) - 1;
      const scopedLineTokensAtEndColumn = $vv(lineTokens2, endColumnOfLine);
      return scopedLineTokensAtEndColumn;
    };
    this.a.tokenization.forceTokenization(range2.startLineNumber);
    const lineTokens = this.a.tokenization.getLineTokens(range2.startLineNumber);
    const scopedLineTokens = $vv(lineTokens, range2.startColumn - 1);
    const emptyTokens = $4u.createEmpty("", scopedLineTokens.languageIdCodec);
    const previousLineNumber = range2.startLineNumber - 1;
    const isFirstLine = previousLineNumber === 0;
    if (isFirstLine) {
      return emptyTokens;
    }
    const canScopeExtendOnPreviousLine = scopedLineTokens.firstCharOffset === 0;
    if (!canScopeExtendOnPreviousLine) {
      return emptyTokens;
    }
    const scopedLineTokensAtEndColumnOfPreviousLine = getScopedLineTokensAtEndColumnOfLine(previousLineNumber);
    const doesLanguageContinueOnPreviousLine = scopedLineTokens.languageId === scopedLineTokensAtEndColumnOfPreviousLine.languageId;
    if (!doesLanguageContinueOnPreviousLine) {
      return emptyTokens;
    }
    const previousSlicedLineTokens = scopedLineTokensAtEndColumnOfPreviousLine.toIViewLineTokens();
    const processedTokens = this.b.getProcessedTokens(previousSlicedLineTokens);
    return processedTokens;
  }
};
var IndentationLineProcessor = class {
  constructor(a, b) {
    this.a = a;
    this.b = b;
  }
  /**
   * Get the processed line for the given line number and potentially adjust the indentation level.
   * Remove the language configuration brackets from the regex, string and comment tokens.
   */
  getProcessedLine(lineNumber, newIndentation) {
    const replaceIndentation = (line, newIndentation2) => {
      const currentIndentation = $Of(line);
      const adjustedLine = newIndentation2 + line.substring(currentIndentation.length);
      return adjustedLine;
    };
    this.a.tokenization.forceTokenization?.(lineNumber);
    const tokens = this.a.tokenization.getLineTokens(lineNumber);
    let processedLine = this.getProcessedTokens(tokens).getLineContent();
    if (newIndentation !== void 0) {
      processedLine = replaceIndentation(processedLine, newIndentation);
    }
    return processedLine;
  }
  /**
   * Process the line with the given tokens, remove the language configuration brackets from the regex, string and comment tokens.
   */
  getProcessedTokens(tokens) {
    const shouldRemoveBracketsFromTokenType = (tokenType) => {
      return tokenType === 2 || tokenType === 3 || tokenType === 1;
    };
    const languageId = tokens.getLanguageId(0);
    const bracketsConfiguration = this.b.getLanguageConfiguration(languageId).bracketsNew;
    const bracketsRegExp = bracketsConfiguration.getBracketRegExp({ global: true });
    const textAndMetadata = [];
    tokens.forEach((tokenIndex) => {
      const tokenType = tokens.getStandardTokenType(tokenIndex);
      let text2 = tokens.getTokenText(tokenIndex);
      if (shouldRemoveBracketsFromTokenType(tokenType)) {
        text2 = text2.replace(bracketsRegExp, "");
      }
      const metadata = tokens.getMetadata(tokenIndex);
      textAndMetadata.push({ text: text2, metadata });
    });
    const processedLineTokens = $4u.createFromTextAndMetadata(textAndMetadata, tokens.languageIdCodec);
    return processedLineTokens;
  }
};
function $A2(model, position) {
  model.tokenization.forceTokenization(position.lineNumber);
  const lineTokens = model.tokenization.getLineTokens(position.lineNumber);
  const scopedLineTokens = $vv(lineTokens, position.column - 1);
  const doesScopeStartAtOffsetZero = scopedLineTokens.firstCharOffset === 0;
  const isScopedLanguageEqualToFirstLanguageOnLine = lineTokens.getLanguageId(0) === scopedLineTokens.languageId;
  const languageIsDifferentFromLineStart = !doesScopeStartAtOffsetZero && !isScopedLanguageEqualToFirstLanguageOnLine;
  return languageIsDifferentFromLineStart;
}

// out-build/vs/editor/common/languages/enterAction.js
function $B2(autoIndent, model, range2, languageConfigurationService) {
  model.tokenization.forceTokenization(range2.startLineNumber);
  const languageId = model.getLanguageIdAtPosition(range2.startLineNumber, range2.startColumn);
  const richEditSupport = languageConfigurationService.getLanguageConfiguration(languageId);
  if (!richEditSupport) {
    return null;
  }
  const indentationContextProcessor = new $z2(model, languageConfigurationService);
  const processedContextTokens = indentationContextProcessor.getProcessedTokenContextAroundRange(range2);
  const previousLineText = processedContextTokens.previousLineProcessedTokens.getLineContent();
  const beforeEnterText = processedContextTokens.beforeRangeProcessedTokens.getLineContent();
  const afterEnterText = processedContextTokens.afterRangeProcessedTokens.getLineContent();
  const enterResult = richEditSupport.onEnter(autoIndent, previousLineText, beforeEnterText, afterEnterText);
  if (!enterResult) {
    return null;
  }
  const indentAction = enterResult.indentAction;
  let appendText = enterResult.appendText;
  const removeText = enterResult.removeText || 0;
  if (!appendText) {
    if (indentAction === IndentAction.Indent || indentAction === IndentAction.IndentOutdent) {
      appendText = "	";
    } else {
      appendText = "";
    }
  } else if (indentAction === IndentAction.Indent) {
    appendText = "	" + appendText;
  }
  let indentation = $jw(model, range2.startLineNumber, range2.startColumn);
  if (removeText) {
    indentation = indentation.substring(0, indentation.length - removeText);
  }
  return {
    indentAction,
    appendText,
    removeText,
    indentation
  };
}

// out-build/vs/editor/common/commands/shiftCommand.js
var $C2_1;
var repeatCache = /* @__PURE__ */ Object.create(null);
function cachedStringRepeat(str, count) {
  if (count <= 0) {
    return "";
  }
  if (!repeatCache[str]) {
    repeatCache[str] = ["", str];
  }
  const cache2 = repeatCache[str];
  for (let i = cache2.length; i <= count; i++) {
    cache2[i] = cache2[i - 1] + str;
  }
  return cache2[count];
}
var $C2 = $C2_1 = class $C22 {
  static unshiftIndent(line, column, tabSize, indentSize, insertSpaces) {
    const contentStartVisibleColumn = $Iv.visibleColumnFromColumn(line, column, tabSize);
    if (insertSpaces) {
      const indent = cachedStringRepeat(" ", indentSize);
      const desiredTabStop = $Iv.prevIndentTabStop(contentStartVisibleColumn, indentSize);
      const indentCount = desiredTabStop / indentSize;
      return cachedStringRepeat(indent, indentCount);
    } else {
      const indent = "	";
      const desiredTabStop = $Iv.prevRenderTabStop(contentStartVisibleColumn, tabSize);
      const indentCount = desiredTabStop / tabSize;
      return cachedStringRepeat(indent, indentCount);
    }
  }
  static shiftIndent(line, column, tabSize, indentSize, insertSpaces) {
    const contentStartVisibleColumn = $Iv.visibleColumnFromColumn(line, column, tabSize);
    if (insertSpaces) {
      const indent = cachedStringRepeat(" ", indentSize);
      const desiredTabStop = $Iv.nextIndentTabStop(contentStartVisibleColumn, indentSize);
      const indentCount = desiredTabStop / indentSize;
      return cachedStringRepeat(indent, indentCount);
    } else {
      const indent = "	";
      const desiredTabStop = $Iv.nextRenderTabStop(contentStartVisibleColumn, tabSize);
      const indentCount = desiredTabStop / tabSize;
      return cachedStringRepeat(indent, indentCount);
    }
  }
  constructor(range2, opts, f) {
    this.f = f;
    this.a = opts;
    this.b = range2;
    this.c = null;
    this.d = false;
    this.e = false;
  }
  g(builder, range2, text2) {
    if (this.d) {
      builder.addTrackedEditOperation(range2, text2);
    } else {
      builder.addEditOperation(range2, text2);
    }
  }
  getEditOperations(model, builder) {
    const startLine = this.b.startLineNumber;
    let endLine = this.b.endLineNumber;
    if (this.b.endColumn === 1 && startLine !== endLine) {
      endLine = endLine - 1;
    }
    const { tabSize, indentSize, insertSpaces } = this.a;
    const shouldIndentEmptyLines = startLine === endLine;
    if (this.a.useTabStops) {
      if (this.b.isEmpty()) {
        if (/^\s*$/.test(model.getLineContent(startLine))) {
          this.d = true;
        }
      }
      let previousLineExtraSpaces = 0, extraSpaces = 0;
      for (let lineNumber = startLine; lineNumber <= endLine; lineNumber++, previousLineExtraSpaces = extraSpaces) {
        extraSpaces = 0;
        const lineText = model.getLineContent(lineNumber);
        let indentationEndIndex = $Nf(lineText);
        if (this.a.isUnshift && (lineText.length === 0 || indentationEndIndex === 0)) {
          continue;
        }
        if (!shouldIndentEmptyLines && !this.a.isUnshift && lineText.length === 0) {
          continue;
        }
        if (indentationEndIndex === -1) {
          indentationEndIndex = lineText.length;
        }
        if (lineNumber > 1) {
          const contentStartVisibleColumn = $Iv.visibleColumnFromColumn(lineText, indentationEndIndex + 1, tabSize);
          if (contentStartVisibleColumn % indentSize !== 0) {
            if (model.tokenization.isCheapToTokenize(lineNumber - 1)) {
              const enterAction = $B2(this.a.autoIndent, model, new $au(lineNumber - 1, model.getLineMaxColumn(lineNumber - 1), lineNumber - 1, model.getLineMaxColumn(lineNumber - 1)), this.f);
              if (enterAction) {
                extraSpaces = previousLineExtraSpaces;
                if (enterAction.appendText) {
                  for (let j = 0, lenJ = enterAction.appendText.length; j < lenJ && extraSpaces < indentSize; j++) {
                    if (enterAction.appendText.charCodeAt(j) === 32) {
                      extraSpaces++;
                    } else {
                      break;
                    }
                  }
                }
                if (enterAction.removeText) {
                  extraSpaces = Math.max(0, extraSpaces - enterAction.removeText);
                }
                for (let j = 0; j < extraSpaces; j++) {
                  if (indentationEndIndex === 0 || lineText.charCodeAt(indentationEndIndex - 1) !== 32) {
                    break;
                  }
                  indentationEndIndex--;
                }
              }
            }
          }
        }
        if (this.a.isUnshift && indentationEndIndex === 0) {
          continue;
        }
        let desiredIndent;
        if (this.a.isUnshift) {
          desiredIndent = $C2_1.unshiftIndent(lineText, indentationEndIndex + 1, tabSize, indentSize, insertSpaces);
        } else {
          desiredIndent = $C2_1.shiftIndent(lineText, indentationEndIndex + 1, tabSize, indentSize, insertSpaces);
        }
        this.g(builder, new $au(lineNumber, 1, lineNumber, indentationEndIndex + 1), desiredIndent);
        if (lineNumber === startLine && !this.b.isEmpty()) {
          this.e = this.b.startColumn <= indentationEndIndex + 1;
        }
      }
    } else {
      if (!this.a.isUnshift && this.b.isEmpty() && model.getLineLength(startLine) === 0) {
        this.d = true;
      }
      const oneIndent = insertSpaces ? cachedStringRepeat(" ", indentSize) : "	";
      for (let lineNumber = startLine; lineNumber <= endLine; lineNumber++) {
        const lineText = model.getLineContent(lineNumber);
        let indentationEndIndex = $Nf(lineText);
        if (this.a.isUnshift && (lineText.length === 0 || indentationEndIndex === 0)) {
          continue;
        }
        if (!shouldIndentEmptyLines && !this.a.isUnshift && lineText.length === 0) {
          continue;
        }
        if (indentationEndIndex === -1) {
          indentationEndIndex = lineText.length;
        }
        if (this.a.isUnshift && indentationEndIndex === 0) {
          continue;
        }
        if (this.a.isUnshift) {
          indentationEndIndex = Math.min(indentationEndIndex, indentSize);
          for (let i = 0; i < indentationEndIndex; i++) {
            const chr = lineText.charCodeAt(i);
            if (chr === 9) {
              indentationEndIndex = i + 1;
              break;
            }
          }
          this.g(builder, new $au(lineNumber, 1, lineNumber, indentationEndIndex + 1), "");
        } else {
          this.g(builder, new $au(lineNumber, 1, lineNumber, 1), oneIndent);
          if (lineNumber === startLine && !this.b.isEmpty()) {
            this.e = this.b.startColumn === 1;
          }
        }
      }
    }
    this.c = builder.trackSelection(this.b);
  }
  computeCursorState(model, helper) {
    if (this.d) {
      const lastOp = helper.getInverseEditOperations()[0];
      return new $cu(lastOp.range.endLineNumber, lastOp.range.endColumn, lastOp.range.endLineNumber, lastOp.range.endColumn);
    }
    const result = helper.getTrackedSelection(this.c);
    if (this.e) {
      const initialStartColumn = this.b.startColumn;
      const resultStartColumn = result.startColumn;
      if (resultStartColumn <= initialStartColumn) {
        return result;
      }
      if (result.getDirection() === 0) {
        return new $cu(result.startLineNumber, initialStartColumn, result.endLineNumber, result.endColumn);
      }
      return new $cu(result.endLineNumber, result.endColumn, result.startLineNumber, initialStartColumn);
    }
    return result;
  }
};
$C2 = $C2_1 = __decorate([
  __param(2, $hw)
], $C2);

// out-build/vs/editor/common/commands/surroundSelectionCommand.js
var $D2 = class {
  constructor(range2, charBeforeSelection, charAfterSelection) {
    this.a = range2;
    this.b = charBeforeSelection;
    this.c = charAfterSelection;
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(new $au(this.a.startLineNumber, this.a.startColumn, this.a.startLineNumber, this.a.startColumn), this.b);
    builder.addTrackedEditOperation(new $au(this.a.endLineNumber, this.a.endColumn, this.a.endLineNumber, this.a.endColumn), this.c);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    const firstOperationRange = inverseEditOperations[0].range;
    const secondOperationRange = inverseEditOperations[1].range;
    return new $cu(firstOperationRange.endLineNumber, firstOperationRange.endColumn, secondOperationRange.endLineNumber, secondOperationRange.endColumn - this.c.length);
  }
};
var $E2 = class {
  constructor(a, b, c) {
    this.a = a;
    this.b = b;
    this.c = c;
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(new $au(this.a.lineNumber, this.a.column, this.a.lineNumber, this.a.column), this.b + this.c);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    const opRange = inverseEditOperations[0].range;
    return new $cu(opRange.endLineNumber, opRange.startColumn, opRange.endLineNumber, opRange.endColumn - this.c.length);
  }
};

// out-build/vs/editor/common/languages/autoIndent.js
function getPrecedingValidLine(model, lineNumber, processedIndentRulesSupport) {
  const languageId = model.tokenization.getLanguageIdAtPosition(lineNumber, 0);
  if (lineNumber > 1) {
    let lastLineNumber;
    let resultLineNumber = -1;
    for (lastLineNumber = lineNumber - 1; lastLineNumber >= 1; lastLineNumber--) {
      if (model.tokenization.getLanguageIdAtPosition(lastLineNumber, 0) !== languageId) {
        return resultLineNumber;
      }
      const text2 = model.getLineContent(lastLineNumber);
      if (processedIndentRulesSupport.shouldIgnore(lastLineNumber) || /^\s+$/.test(text2) || text2 === "") {
        resultLineNumber = lastLineNumber;
        continue;
      }
      return lastLineNumber;
    }
  }
  return -1;
}
function $t2(autoIndent, model, lineNumber, honorIntentialIndent = true, languageConfigurationService) {
  if (autoIndent < 4) {
    return null;
  }
  const indentRulesSupport = languageConfigurationService.getLanguageConfiguration(model.tokenization.getLanguageId()).indentRulesSupport;
  if (!indentRulesSupport) {
    return null;
  }
  const processedIndentRulesSupport = new $y2(model, indentRulesSupport, languageConfigurationService);
  if (lineNumber <= 1) {
    return {
      indentation: "",
      action: null
    };
  }
  for (let priorLineNumber = lineNumber - 1; priorLineNumber > 0; priorLineNumber--) {
    if (model.getLineContent(priorLineNumber) !== "") {
      break;
    }
    if (priorLineNumber === 1) {
      return {
        indentation: "",
        action: null
      };
    }
  }
  const precedingUnIgnoredLine = getPrecedingValidLine(model, lineNumber, processedIndentRulesSupport);
  if (precedingUnIgnoredLine < 0) {
    return null;
  } else if (precedingUnIgnoredLine < 1) {
    return {
      indentation: "",
      action: null
    };
  }
  if (processedIndentRulesSupport.shouldIncrease(precedingUnIgnoredLine) || processedIndentRulesSupport.shouldIndentNextLine(precedingUnIgnoredLine)) {
    const precedingUnIgnoredLineContent = model.getLineContent(precedingUnIgnoredLine);
    return {
      indentation: $Of(precedingUnIgnoredLineContent),
      action: IndentAction.Indent,
      line: precedingUnIgnoredLine
    };
  } else if (processedIndentRulesSupport.shouldDecrease(precedingUnIgnoredLine)) {
    const precedingUnIgnoredLineContent = model.getLineContent(precedingUnIgnoredLine);
    return {
      indentation: $Of(precedingUnIgnoredLineContent),
      action: null,
      line: precedingUnIgnoredLine
    };
  } else {
    if (precedingUnIgnoredLine === 1) {
      return {
        indentation: $Of(model.getLineContent(precedingUnIgnoredLine)),
        action: null,
        line: precedingUnIgnoredLine
      };
    }
    const previousLine = precedingUnIgnoredLine - 1;
    const previousLineIndentMetadata = indentRulesSupport.getIndentMetadata(model.getLineContent(previousLine));
    if (!(previousLineIndentMetadata & (1 | 2)) && previousLineIndentMetadata & 4) {
      let stopLine = 0;
      for (let i = previousLine - 1; i > 0; i--) {
        if (processedIndentRulesSupport.shouldIndentNextLine(i)) {
          continue;
        }
        stopLine = i;
        break;
      }
      return {
        indentation: $Of(model.getLineContent(stopLine + 1)),
        action: null,
        line: stopLine + 1
      };
    }
    if (honorIntentialIndent) {
      return {
        indentation: $Of(model.getLineContent(precedingUnIgnoredLine)),
        action: null,
        line: precedingUnIgnoredLine
      };
    } else {
      for (let i = precedingUnIgnoredLine; i > 0; i--) {
        if (processedIndentRulesSupport.shouldIncrease(i)) {
          return {
            indentation: $Of(model.getLineContent(i)),
            action: IndentAction.Indent,
            line: i
          };
        } else if (processedIndentRulesSupport.shouldIndentNextLine(i)) {
          let stopLine = 0;
          for (let j = i - 1; j > 0; j--) {
            if (processedIndentRulesSupport.shouldIndentNextLine(i)) {
              continue;
            }
            stopLine = j;
            break;
          }
          return {
            indentation: $Of(model.getLineContent(stopLine + 1)),
            action: null,
            line: stopLine + 1
          };
        } else if (processedIndentRulesSupport.shouldDecrease(i)) {
          return {
            indentation: $Of(model.getLineContent(i)),
            action: null,
            line: i
          };
        }
      }
      return {
        indentation: $Of(model.getLineContent(1)),
        action: null,
        line: 1
      };
    }
  }
}
function $u2(autoIndent, virtualModel, languageId, lineNumber, indentConverter, languageConfigurationService) {
  if (autoIndent < 4) {
    return null;
  }
  const richEditSupport = languageConfigurationService.getLanguageConfiguration(languageId);
  if (!richEditSupport) {
    return null;
  }
  const indentRulesSupport = languageConfigurationService.getLanguageConfiguration(languageId).indentRulesSupport;
  if (!indentRulesSupport) {
    return null;
  }
  const processedIndentRulesSupport = new $y2(virtualModel, indentRulesSupport, languageConfigurationService);
  const indent = $t2(autoIndent, virtualModel, lineNumber, void 0, languageConfigurationService);
  if (indent) {
    const inheritLine = indent.line;
    if (inheritLine !== void 0) {
      let shouldApplyEnterRules = true;
      for (let inBetweenLine = inheritLine; inBetweenLine < lineNumber - 1; inBetweenLine++) {
        if (!/^\s*$/.test(virtualModel.getLineContent(inBetweenLine))) {
          shouldApplyEnterRules = false;
          break;
        }
      }
      if (shouldApplyEnterRules) {
        const enterResult = richEditSupport.onEnter(autoIndent, "", virtualModel.getLineContent(inheritLine), "");
        if (enterResult) {
          let indentation = $Of(virtualModel.getLineContent(inheritLine));
          if (enterResult.removeText) {
            indentation = indentation.substring(0, indentation.length - enterResult.removeText);
          }
          if (enterResult.indentAction === IndentAction.Indent || enterResult.indentAction === IndentAction.IndentOutdent) {
            indentation = indentConverter.shiftIndent(indentation);
          } else if (enterResult.indentAction === IndentAction.Outdent) {
            indentation = indentConverter.unshiftIndent(indentation);
          }
          if (processedIndentRulesSupport.shouldDecrease(lineNumber)) {
            indentation = indentConverter.unshiftIndent(indentation);
          }
          if (enterResult.appendText) {
            indentation += enterResult.appendText;
          }
          return $Of(indentation);
        }
      }
    }
    if (processedIndentRulesSupport.shouldDecrease(lineNumber)) {
      if (indent.action === IndentAction.Indent) {
        return indent.indentation;
      } else {
        return indentConverter.unshiftIndent(indent.indentation);
      }
    } else {
      if (indent.action === IndentAction.Indent) {
        return indentConverter.shiftIndent(indent.indentation);
      } else {
        return indent.indentation;
      }
    }
  }
  return null;
}
function $v2(autoIndent, model, range2, indentConverter, languageConfigurationService) {
  if (autoIndent < 4) {
    return null;
  }
  const languageId = model.getLanguageIdAtPosition(range2.startLineNumber, range2.startColumn);
  const indentRulesSupport = languageConfigurationService.getLanguageConfiguration(languageId).indentRulesSupport;
  if (!indentRulesSupport) {
    return null;
  }
  model.tokenization.forceTokenization(range2.startLineNumber);
  const indentationContextProcessor = new $z2(model, languageConfigurationService);
  const processedContextTokens = indentationContextProcessor.getProcessedTokenContextAroundRange(range2);
  const afterEnterProcessedTokens = processedContextTokens.afterRangeProcessedTokens;
  const beforeEnterProcessedTokens = processedContextTokens.beforeRangeProcessedTokens;
  const beforeEnterIndent = $Of(beforeEnterProcessedTokens.getLineContent());
  const virtualModel = createVirtualModelWithModifiedTokensAtLine(model, range2.startLineNumber, beforeEnterProcessedTokens);
  const languageIsDifferentFromLineStart = $A2(model, range2.getStartPosition());
  const currentLine = model.getLineContent(range2.startLineNumber);
  const currentLineIndent = $Of(currentLine);
  const afterEnterAction = $t2(autoIndent, virtualModel, range2.startLineNumber + 1, void 0, languageConfigurationService);
  if (!afterEnterAction) {
    const beforeEnter = languageIsDifferentFromLineStart ? currentLineIndent : beforeEnterIndent;
    return {
      beforeEnter,
      afterEnter: beforeEnter
    };
  }
  let afterEnterIndent = languageIsDifferentFromLineStart ? currentLineIndent : afterEnterAction.indentation;
  if (afterEnterAction.action === IndentAction.Indent) {
    afterEnterIndent = indentConverter.shiftIndent(afterEnterIndent);
  }
  if (indentRulesSupport.shouldDecrease(afterEnterProcessedTokens.getLineContent())) {
    afterEnterIndent = indentConverter.unshiftIndent(afterEnterIndent);
  }
  return {
    beforeEnter: languageIsDifferentFromLineStart ? currentLineIndent : beforeEnterIndent,
    afterEnter: afterEnterIndent
  };
}
function $w2(cursorConfig, model, range2, ch, indentConverter, languageConfigurationService) {
  const autoIndent = cursorConfig.autoIndent;
  if (autoIndent < 4) {
    return null;
  }
  const languageIsDifferentFromLineStart = $A2(model, range2.getStartPosition());
  if (languageIsDifferentFromLineStart) {
    return null;
  }
  const languageId = model.getLanguageIdAtPosition(range2.startLineNumber, range2.startColumn);
  const indentRulesSupport = languageConfigurationService.getLanguageConfiguration(languageId).indentRulesSupport;
  if (!indentRulesSupport) {
    return null;
  }
  const indentationContextProcessor = new $z2(model, languageConfigurationService);
  const processedContextTokens = indentationContextProcessor.getProcessedTokenContextAroundRange(range2);
  const beforeRangeText = processedContextTokens.beforeRangeProcessedTokens.getLineContent();
  const afterRangeText = processedContextTokens.afterRangeProcessedTokens.getLineContent();
  const textAroundRange = beforeRangeText + afterRangeText;
  const textAroundRangeWithCharacter = beforeRangeText + ch + afterRangeText;
  if (!indentRulesSupport.shouldDecrease(textAroundRange) && indentRulesSupport.shouldDecrease(textAroundRangeWithCharacter)) {
    const r2 = $t2(autoIndent, model, range2.startLineNumber, false, languageConfigurationService);
    if (!r2) {
      return null;
    }
    let indentation = r2.indentation;
    if (r2.action !== IndentAction.Indent) {
      indentation = indentConverter.unshiftIndent(indentation);
    }
    return indentation;
  }
  const previousLineNumber = range2.startLineNumber - 1;
  if (previousLineNumber > 0) {
    const previousLine = model.getLineContent(previousLineNumber);
    if (indentRulesSupport.shouldIndentNextLine(previousLine) && indentRulesSupport.shouldIncrease(textAroundRangeWithCharacter)) {
      const inheritedIndentationData = $t2(autoIndent, model, range2.startLineNumber, false, languageConfigurationService);
      const inheritedIndentation = inheritedIndentationData?.indentation;
      if (inheritedIndentation !== void 0) {
        const currentLine = model.getLineContent(range2.startLineNumber);
        const actualCurrentIndentation = $Of(currentLine);
        const inferredCurrentIndentation = indentConverter.shiftIndent(inheritedIndentation);
        const inferredIndentationEqualsActual = inferredCurrentIndentation === actualCurrentIndentation;
        const textAroundRangeContainsOnlyWhitespace = /^\s*$/.test(textAroundRange);
        const autoClosingPairs = cursorConfig.autoClosingPairs.autoClosingPairsOpenByEnd.get(ch);
        const autoClosingPairExists = autoClosingPairs && autoClosingPairs.length > 0;
        const isChFirstNonWhitespaceCharacterAndInAutoClosingPair = autoClosingPairExists && textAroundRangeContainsOnlyWhitespace;
        if (inferredIndentationEqualsActual && isChFirstNonWhitespaceCharacterAndInAutoClosingPair) {
          return inheritedIndentation;
        }
      }
    }
  }
  return null;
}
function $x2(model, lineNumber, languageConfigurationService) {
  const indentRulesSupport = languageConfigurationService.getLanguageConfiguration(model.getLanguageId()).indentRulesSupport;
  if (!indentRulesSupport) {
    return null;
  }
  if (lineNumber < 1 || lineNumber > model.getLineCount()) {
    return null;
  }
  return indentRulesSupport.getIndentMetadata(model.getLineContent(lineNumber));
}
function createVirtualModelWithModifiedTokensAtLine(model, modifiedLineNumber, modifiedTokens) {
  const virtualModel = {
    tokenization: {
      getLineTokens: (lineNumber) => {
        if (lineNumber === modifiedLineNumber) {
          return modifiedTokens;
        } else {
          return model.tokenization.getLineTokens(lineNumber);
        }
      },
      getLanguageId: () => {
        return model.getLanguageId();
      },
      getLanguageIdAtPosition: (lineNumber, column) => {
        return model.getLanguageIdAtPosition(lineNumber, column);
      }
    },
    getLineContent: (lineNumber) => {
      if (lineNumber === modifiedLineNumber) {
        return modifiedTokens.getLineContent();
      } else {
        return model.getLineContent(lineNumber);
      }
    }
  };
  return virtualModel;
}

// out-build/vs/editor/common/cursor/cursorTypeEditOperations.js
var $F2 = class {
  static getEdits(config, model, selections, ch, isDoingComposition) {
    if (!isDoingComposition && this.a(config, model, selections)) {
      const indentationForSelections = [];
      for (const selection of selections) {
        const indentation = this.b(config, model, selection, ch);
        if (indentation === null) {
          return;
        }
        indentationForSelections.push({ selection, indentation });
      }
      const autoClosingPairClose = $I2.getAutoClosingPairClose(config, model, selections, ch, false);
      return this.c(config, model, indentationForSelections, ch, autoClosingPairClose);
    }
    return;
  }
  static a(config, model, selections) {
    if (config.autoIndent < 4) {
      return false;
    }
    for (let i = 0, len = selections.length; i < len; i++) {
      if (!model.tokenization.isCheapToTokenize(selections[i].getEndPosition().lineNumber)) {
        return false;
      }
    }
    return true;
  }
  static b(config, model, selection, ch) {
    const actualIndentation = $w2(config, model, selection, ch, {
      shiftIndent: (indentation) => {
        return $S2(config, indentation);
      },
      unshiftIndent: (indentation) => {
        return $T2(config, indentation);
      }
    }, config.languageConfigurationService);
    if (actualIndentation === null) {
      return null;
    }
    const currentIndentation = $jw(model, selection.startLineNumber, selection.startColumn);
    if (actualIndentation === config.normalizeIndentation(currentIndentation)) {
      return null;
    }
    return actualIndentation;
  }
  static c(config, model, indentationForSelections, ch, autoClosingPairClose) {
    const commands = indentationForSelections.map(({ selection, indentation }) => {
      if (autoClosingPairClose !== null) {
        const indentationEdit = this.d(config, model, indentation, selection, ch, false);
        return new TypeWithIndentationAndAutoClosingCommand(indentationEdit, selection, ch, autoClosingPairClose);
      } else {
        const indentationEdit = this.d(config, model, indentation, selection, ch, true);
        return typeCommand(indentationEdit.range, indentationEdit.text, false);
      }
    });
    const editOptions = { shouldPushStackElementBefore: true, shouldPushStackElementAfter: false };
    return new $o1(4, commands, editOptions);
  }
  static d(config, model, indentation, selection, ch, includeChInEdit = true) {
    const startLineNumber = selection.startLineNumber;
    const firstNonWhitespaceColumn = model.getLineFirstNonWhitespaceColumn(startLineNumber);
    let text2 = config.normalizeIndentation(indentation);
    if (firstNonWhitespaceColumn !== 0) {
      const startLine = model.getLineContent(startLineNumber);
      text2 += startLine.substring(firstNonWhitespaceColumn - 1, selection.startColumn - 1);
    }
    text2 += includeChInEdit ? ch : "";
    const range2 = new $au(startLineNumber, 1, selection.endLineNumber, selection.endColumn);
    return { range: range2, text: text2 };
  }
};
var $G2 = class {
  static getEdits(prevEditOperationType, config, model, selections, autoClosedCharacters, ch) {
    if (isAutoClosingOvertype(config, model, selections, autoClosedCharacters, ch)) {
      return this.a(prevEditOperationType, selections, ch);
    }
    return;
  }
  static a(prevEditOperationType, selections, ch) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      const position = selection.getPosition();
      const typeSelection = new $au(position.lineNumber, position.column, position.lineNumber, position.column + 1);
      commands[i] = new $h2(typeSelection, ch);
    }
    return new $o1(4, commands, {
      shouldPushStackElementBefore: shouldPushStackElementBetween(
        prevEditOperationType,
        4
        /* EditOperationType.TypingOther */
      ),
      shouldPushStackElementAfter: false
    });
  }
};
var $H2 = class {
  static getEdits(config, model, selections, autoClosedCharacters, ch) {
    if (isAutoClosingOvertype(config, model, selections, autoClosedCharacters, ch)) {
      const commands = selections.map((s) => new $h2(new $au(s.positionLineNumber, s.positionColumn, s.positionLineNumber, s.positionColumn + 1), "", false));
      return new $o1(4, commands, {
        shouldPushStackElementBefore: true,
        shouldPushStackElementAfter: false
      });
    }
    return;
  }
};
var $I2 = class {
  static getEdits(config, model, selections, ch, chIsAlreadyTyped, isDoingComposition) {
    if (!isDoingComposition) {
      const autoClosingPairClose = this.getAutoClosingPairClose(config, model, selections, ch, chIsAlreadyTyped);
      if (autoClosingPairClose !== null) {
        return this.a(selections, ch, chIsAlreadyTyped, autoClosingPairClose);
      }
    }
    return;
  }
  static a(selections, ch, chIsAlreadyTyped, autoClosingPairClose) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      commands[i] = new TypeWithAutoClosingCommand(selection, ch, !chIsAlreadyTyped, autoClosingPairClose);
    }
    return new $o1(4, commands, {
      shouldPushStackElementBefore: true,
      shouldPushStackElementAfter: false
    });
  }
  static getAutoClosingPairClose(config, model, selections, ch, chIsAlreadyTyped) {
    for (const selection of selections) {
      if (!selection.isEmpty()) {
        return null;
      }
    }
    const positions = selections.map((s) => {
      const position = s.getPosition();
      if (chIsAlreadyTyped) {
        return { lineNumber: position.lineNumber, beforeColumn: position.column - ch.length, afterColumn: position.column };
      } else {
        return { lineNumber: position.lineNumber, beforeColumn: position.column, afterColumn: position.column };
      }
    });
    const pair = this.c(config, model, positions.map((p) => new $_t(p.lineNumber, p.beforeColumn)), ch);
    if (!pair) {
      return null;
    }
    let autoCloseConfig;
    let shouldAutoCloseBefore;
    const chIsQuote = $p1(ch);
    if (chIsQuote) {
      autoCloseConfig = config.autoClosingQuotes;
      shouldAutoCloseBefore = config.shouldAutoCloseBefore.quote;
    } else {
      const pairIsForComments = config.blockCommentStartToken ? pair.open.includes(config.blockCommentStartToken) : false;
      if (pairIsForComments) {
        autoCloseConfig = config.autoClosingComments;
        shouldAutoCloseBefore = config.shouldAutoCloseBefore.comment;
      } else {
        autoCloseConfig = config.autoClosingBrackets;
        shouldAutoCloseBefore = config.shouldAutoCloseBefore.bracket;
      }
    }
    if (autoCloseConfig === "never") {
      return null;
    }
    const containedPair = this.b(config, pair);
    const containedPairClose = containedPair ? containedPair.close : "";
    let isContainedPairPresent = true;
    for (const position of positions) {
      const { lineNumber, beforeColumn, afterColumn } = position;
      const lineText = model.getLineContent(lineNumber);
      const lineBefore = lineText.substring(0, beforeColumn - 1);
      const lineAfter = lineText.substring(afterColumn - 1);
      if (!lineAfter.startsWith(containedPairClose)) {
        isContainedPairPresent = false;
      }
      if (lineAfter.length > 0) {
        const characterAfter = lineAfter.charAt(0);
        const isBeforeCloseBrace = this.d(config, lineAfter);
        if (!isBeforeCloseBrace && !shouldAutoCloseBefore(characterAfter)) {
          return null;
        }
      }
      if (pair.open.length === 1 && (ch === "'" || ch === '"') && autoCloseConfig !== "always") {
        const wordSeparators2 = $Ku(config.wordSeparators, []);
        if (lineBefore.length > 0) {
          const characterBefore = lineBefore.charCodeAt(lineBefore.length - 1);
          if (wordSeparators2.get(characterBefore) === 0) {
            return null;
          }
        }
      }
      if (!model.tokenization.isCheapToTokenize(lineNumber)) {
        return null;
      }
      model.tokenization.forceTokenization(lineNumber);
      const lineTokens = model.tokenization.getLineTokens(lineNumber);
      const scopedLineTokens = $vv(lineTokens, beforeColumn - 1);
      if (!pair.shouldAutoClose(scopedLineTokens, beforeColumn - scopedLineTokens.firstCharOffset)) {
        return null;
      }
      const neutralCharacter = pair.findNeutralCharacter();
      if (neutralCharacter) {
        const tokenType = model.tokenization.getTokenTypeIfInsertingCharacter(lineNumber, beforeColumn, neutralCharacter);
        if (!pair.isOK(tokenType)) {
          return null;
        }
      }
    }
    if (isContainedPairPresent) {
      return pair.close.substring(0, pair.close.length - containedPairClose.length);
    } else {
      return pair.close;
    }
  }
  /**
   * Find another auto-closing pair that is contained by the one passed in.
   *
   * e.g. when having [(,)] and [(*,*)] as auto-closing pairs
   * this method will find [(,)] as a containment pair for [(*,*)]
   */
  static b(config, pair) {
    if (pair.open.length <= 1) {
      return null;
    }
    const lastChar = pair.close.charAt(pair.close.length - 1);
    const candidates = config.autoClosingPairs.autoClosingPairsCloseByEnd.get(lastChar) || [];
    let result = null;
    for (const candidate of candidates) {
      if (candidate.open !== pair.open && pair.open.includes(candidate.open) && pair.close.endsWith(candidate.close)) {
        if (!result || candidate.open.length > result.open.length) {
          result = candidate;
        }
      }
    }
    return result;
  }
  /**
   * Determine if typing `ch` at all `positions` in the `model` results in an
   * auto closing open sequence being typed.
   *
   * Auto closing open sequences can consist of multiple characters, which
   * can lead to ambiguities. In such a case, the longest auto-closing open
   * sequence is returned.
   */
  static c(config, model, positions, ch) {
    const candidates = config.autoClosingPairs.autoClosingPairsOpenByEnd.get(ch);
    if (!candidates) {
      return null;
    }
    let result = null;
    for (const candidate of candidates) {
      if (result === null || candidate.open.length > result.open.length) {
        let candidateIsMatch = true;
        for (const position of positions) {
          const relevantText = model.getValueInRange(new $au(position.lineNumber, position.column - candidate.open.length + 1, position.lineNumber, position.column));
          if (relevantText + ch !== candidate.open) {
            candidateIsMatch = false;
            break;
          }
        }
        if (candidateIsMatch) {
          result = candidate;
        }
      }
    }
    return result;
  }
  static d(config, lineAfter) {
    const nextChar = lineAfter.charAt(0);
    const potentialStartingBraces = config.autoClosingPairs.autoClosingPairsOpenByStart.get(nextChar) || [];
    const potentialClosingBraces = config.autoClosingPairs.autoClosingPairsCloseByStart.get(nextChar) || [];
    const isBeforeStartingBrace = potentialStartingBraces.some((x) => lineAfter.startsWith(x.open));
    const isBeforeClosingBrace = potentialClosingBraces.some((x) => lineAfter.startsWith(x.close));
    return !isBeforeStartingBrace && isBeforeClosingBrace;
  }
};
var $J2 = class {
  static getEdits(config, model, selections, ch, isDoingComposition) {
    if (!isDoingComposition && this.b(config, model, selections, ch)) {
      return this.a(config, selections, ch);
    }
    return;
  }
  static a(config, selections, ch) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      const closeCharacter = config.surroundingPairs[ch];
      commands[i] = new $D2(selection, ch, closeCharacter);
    }
    return new $o1(0, commands, {
      shouldPushStackElementBefore: true,
      shouldPushStackElementAfter: true
    });
  }
  static b(config, model, selections, ch) {
    if (!$U2(config, ch) || !config.surroundingPairs.hasOwnProperty(ch)) {
      return false;
    }
    const isTypingAQuoteCharacter = $p1(ch);
    for (const selection of selections) {
      if (selection.isEmpty()) {
        return false;
      }
      let selectionContainsOnlyWhitespace = true;
      for (let lineNumber = selection.startLineNumber; lineNumber <= selection.endLineNumber; lineNumber++) {
        const lineText = model.getLineContent(lineNumber);
        const startIndex = lineNumber === selection.startLineNumber ? selection.startColumn - 1 : 0;
        const endIndex = lineNumber === selection.endLineNumber ? selection.endColumn - 1 : lineText.length;
        const selectedText = lineText.substring(startIndex, endIndex);
        if (/[^ \t]/.test(selectedText)) {
          selectionContainsOnlyWhitespace = false;
          break;
        }
      }
      if (selectionContainsOnlyWhitespace) {
        return false;
      }
      if (isTypingAQuoteCharacter && selection.startLineNumber === selection.endLineNumber && selection.startColumn + 1 === selection.endColumn) {
        const selectionText = model.getValueInRange(selection);
        if ($p1(selectionText)) {
          return false;
        }
      }
    }
    return true;
  }
};
var $K2 = class {
  static getEdits(prevEditOperationType, config, model, selections, ch, isDoingComposition) {
    if (!isDoingComposition && this.a(config, model, selections)) {
      const r2 = this.b(prevEditOperationType, config, model, selections[0], ch);
      if (r2) {
        return r2;
      }
    }
    return;
  }
  static a(config, model, selections) {
    if (selections.length === 1 && model.tokenization.isCheapToTokenize(selections[0].getEndPosition().lineNumber)) {
      return true;
    }
    return false;
  }
  static b(prevEditOperationType, config, model, selection, ch) {
    if (!config.electricChars.hasOwnProperty(ch) || !selection.isEmpty()) {
      return null;
    }
    const position = selection.getPosition();
    model.tokenization.forceTokenization(position.lineNumber);
    const lineTokens = model.tokenization.getLineTokens(position.lineNumber);
    let electricAction;
    try {
      electricAction = config.onElectricCharacter(ch, lineTokens, position.column);
    } catch (e) {
      $ab(e);
      return null;
    }
    if (!electricAction) {
      return null;
    }
    if (electricAction.matchOpenBracket) {
      const endColumn = (lineTokens.getLineContent() + ch).lastIndexOf(electricAction.matchOpenBracket) + 1;
      const match = model.bracketPairs.findMatchingBracketUp(
        electricAction.matchOpenBracket,
        {
          lineNumber: position.lineNumber,
          column: endColumn
        },
        500
        /* give at most 500ms to compute */
      );
      if (match) {
        if (match.startLineNumber === position.lineNumber) {
          return null;
        }
        const matchLine = model.getLineContent(match.startLineNumber);
        const matchLineIndentation = $Of(matchLine);
        const newIndentation = config.normalizeIndentation(matchLineIndentation);
        const lineText = model.getLineContent(position.lineNumber);
        const lineFirstNonBlankColumn = model.getLineFirstNonWhitespaceColumn(position.lineNumber) || position.column;
        const prefix = lineText.substring(lineFirstNonBlankColumn - 1, position.column - 1);
        const typeText = newIndentation + prefix + ch;
        const typeSelection = new $au(position.lineNumber, 1, position.lineNumber, position.column);
        const command4 = new $h2(typeSelection, typeText);
        return new $o1(getTypingOperation(typeText, prevEditOperationType), [command4], {
          shouldPushStackElementBefore: false,
          shouldPushStackElementAfter: true
        });
      }
    }
    return null;
  }
};
var $L2 = class {
  static getEdits(prevEditOperationType, selections, ch) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      commands[i] = new $h2(selections[i], ch);
    }
    const opType = getTypingOperation(ch, prevEditOperationType);
    return new $o1(opType, commands, {
      shouldPushStackElementBefore: shouldPushStackElementBetween(prevEditOperationType, opType),
      shouldPushStackElementAfter: false
    });
  }
};
var $M2 = class {
  static getEdits(config, model, selections, ch, isDoingComposition) {
    if (!isDoingComposition && ch === "\n") {
      const commands = [];
      for (let i = 0, len = selections.length; i < len; i++) {
        commands[i] = this.a(config, model, false, selections[i]);
      }
      return new $o1(4, commands, {
        shouldPushStackElementBefore: true,
        shouldPushStackElementAfter: false
      });
    }
    return;
  }
  static a(config, model, keepPosition, range2) {
    if (config.autoIndent === 0) {
      return typeCommand(range2, "\n", keepPosition);
    }
    if (!model.tokenization.isCheapToTokenize(range2.getStartPosition().lineNumber) || config.autoIndent === 1) {
      const lineText2 = model.getLineContent(range2.startLineNumber);
      const indentation2 = $Of(lineText2).substring(0, range2.startColumn - 1);
      return typeCommand(range2, "\n" + config.normalizeIndentation(indentation2), keepPosition);
    }
    const r2 = $B2(config.autoIndent, model, range2, config.languageConfigurationService);
    if (r2) {
      if (r2.indentAction === IndentAction.None) {
        return typeCommand(range2, "\n" + config.normalizeIndentation(r2.indentation + r2.appendText), keepPosition);
      } else if (r2.indentAction === IndentAction.Indent) {
        return typeCommand(range2, "\n" + config.normalizeIndentation(r2.indentation + r2.appendText), keepPosition);
      } else if (r2.indentAction === IndentAction.IndentOutdent) {
        const normalIndent = config.normalizeIndentation(r2.indentation);
        const increasedIndent = config.normalizeIndentation(r2.indentation + r2.appendText);
        const typeText = "\n" + increasedIndent + "\n" + normalIndent;
        if (keepPosition) {
          return new $j2(range2, typeText, true);
        } else {
          return new $k2(range2, typeText, -1, increasedIndent.length - normalIndent.length, true);
        }
      } else if (r2.indentAction === IndentAction.Outdent) {
        const actualIndentation = $T2(config, r2.indentation);
        return typeCommand(range2, "\n" + config.normalizeIndentation(actualIndentation + r2.appendText), keepPosition);
      }
    }
    const lineText = model.getLineContent(range2.startLineNumber);
    const indentation = $Of(lineText).substring(0, range2.startColumn - 1);
    if (config.autoIndent >= 4) {
      const ir = $v2(config.autoIndent, model, range2, {
        unshiftIndent: (indent) => {
          return $T2(config, indent);
        },
        shiftIndent: (indent) => {
          return $S2(config, indent);
        },
        normalizeIndentation: (indent) => {
          return config.normalizeIndentation(indent);
        }
      }, config.languageConfigurationService);
      if (ir) {
        let oldEndViewColumn = config.visibleColumnFromColumn(model, range2.getEndPosition());
        const oldEndColumn = range2.endColumn;
        const newLineContent = model.getLineContent(range2.endLineNumber);
        const firstNonWhitespace = $Nf(newLineContent);
        if (firstNonWhitespace >= 0) {
          range2 = range2.setEndPosition(range2.endLineNumber, Math.max(range2.endColumn, firstNonWhitespace + 1));
        } else {
          range2 = range2.setEndPosition(range2.endLineNumber, model.getLineMaxColumn(range2.endLineNumber));
        }
        if (keepPosition) {
          return new $j2(range2, "\n" + config.normalizeIndentation(ir.afterEnter), true);
        } else {
          let offset = 0;
          if (oldEndColumn <= firstNonWhitespace + 1) {
            if (!config.insertSpaces) {
              oldEndViewColumn = Math.ceil(oldEndViewColumn / config.indentSize);
            }
            offset = Math.min(oldEndViewColumn + 1 - config.normalizeIndentation(ir.afterEnter).length - 1, 0);
          }
          return new $k2(range2, "\n" + config.normalizeIndentation(ir.afterEnter), 0, offset, true);
        }
      }
    }
    return typeCommand(range2, "\n" + config.normalizeIndentation(indentation), keepPosition);
  }
  static lineInsertBefore(config, model, selections) {
    if (model === null || selections === null) {
      return [];
    }
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      let lineNumber = selections[i].positionLineNumber;
      if (lineNumber === 1) {
        commands[i] = new $j2(new $au(1, 1, 1, 1), "\n");
      } else {
        lineNumber--;
        const column = model.getLineMaxColumn(lineNumber);
        commands[i] = this.a(config, model, false, new $au(lineNumber, column, lineNumber, column));
      }
    }
    return commands;
  }
  static lineInsertAfter(config, model, selections) {
    if (model === null || selections === null) {
      return [];
    }
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      const lineNumber = selections[i].positionLineNumber;
      const column = model.getLineMaxColumn(lineNumber);
      commands[i] = this.a(config, model, false, new $au(lineNumber, column, lineNumber, column));
    }
    return commands;
  }
  static lineBreakInsert(config, model, selections) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      commands[i] = this.a(config, model, true, selections[i]);
    }
    return commands;
  }
};
var $N2 = class {
  static getEdits(config, model, selections, text2, pasteOnNewLine, multicursorText) {
    const distributedPaste = this.a(config, selections, text2, pasteOnNewLine, multicursorText);
    if (distributedPaste) {
      selections = selections.sort($au.compareRangesUsingStarts);
      return this.b(config, model, selections, distributedPaste);
    } else {
      return this.c(config, model, selections, text2, pasteOnNewLine);
    }
  }
  static a(config, selections, text2, pasteOnNewLine, multicursorText) {
    if (pasteOnNewLine) {
      return null;
    }
    if (selections.length === 1) {
      return null;
    }
    if (multicursorText && multicursorText.length === selections.length) {
      return multicursorText;
    }
    if (config.multiCursorPaste === "spread") {
      if (text2.charCodeAt(text2.length - 1) === 10) {
        text2 = text2.substring(0, text2.length - 1);
      }
      if (text2.charCodeAt(text2.length - 1) === 13) {
        text2 = text2.substring(0, text2.length - 1);
      }
      const lines = $Lf(text2);
      if (lines.length === selections.length) {
        return lines;
      }
    }
    return null;
  }
  static b(config, model, selections, text2) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      commands[i] = new $h2(selections[i], text2[i]);
    }
    return new $o1(0, commands, {
      shouldPushStackElementBefore: true,
      shouldPushStackElementAfter: true
    });
  }
  static c(config, model, selections, text2, pasteOnNewLine) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      const position = selection.getPosition();
      if (pasteOnNewLine && !selection.isEmpty()) {
        pasteOnNewLine = false;
      }
      if (pasteOnNewLine && text2.indexOf("\n") !== text2.length - 1) {
        pasteOnNewLine = false;
      }
      if (pasteOnNewLine) {
        const typeSelection = new $au(position.lineNumber, 1, position.lineNumber, 1);
        commands[i] = new $l2(typeSelection, text2, selection, true);
      } else {
        commands[i] = new $h2(selection, text2);
      }
    }
    return new $o1(0, commands, {
      shouldPushStackElementBefore: true,
      shouldPushStackElementAfter: true
    });
  }
};
var $O2 = class {
  static getEdits(prevEditOperationType, config, model, selections, text2, replacePrevCharCnt, replaceNextCharCnt, positionDelta) {
    const commands = selections.map((selection) => this.a(model, selection, text2, replacePrevCharCnt, replaceNextCharCnt, positionDelta));
    return new $o1(4, commands, {
      shouldPushStackElementBefore: shouldPushStackElementBetween(
        prevEditOperationType,
        4
        /* EditOperationType.TypingOther */
      ),
      shouldPushStackElementAfter: false
    });
  }
  static a(model, selection, text2, replacePrevCharCnt, replaceNextCharCnt, positionDelta) {
    if (!selection.isEmpty()) {
      return null;
    }
    const pos = selection.getPosition();
    const startColumn = Math.max(1, pos.column - replacePrevCharCnt);
    const endColumn = Math.min(model.getLineMaxColumn(pos.lineNumber), pos.column + replaceNextCharCnt);
    const range2 = new $au(pos.lineNumber, startColumn, pos.lineNumber, endColumn);
    const oldText = model.getValueInRange(range2);
    if (oldText === text2 && positionDelta === 0) {
      return null;
    }
    return new $k2(range2, text2, 0, positionDelta);
  }
};
var $P2 = class {
  static getEdits(prevEditOperationType, selections, str) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      commands[i] = new $h2(selections[i], str);
    }
    const opType = getTypingOperation(str, prevEditOperationType);
    return new $o1(opType, commands, {
      shouldPushStackElementBefore: shouldPushStackElementBetween(prevEditOperationType, opType),
      shouldPushStackElementAfter: false
    });
  }
};
var $Q2 = class {
  static getCommands(config, model, selections) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      const selection = selections[i];
      if (selection.isEmpty()) {
        const lineText = model.getLineContent(selection.startLineNumber);
        if (/^\s*$/.test(lineText) && model.tokenization.isCheapToTokenize(selection.startLineNumber)) {
          let goodIndent = this.a(config, model, selection.startLineNumber);
          goodIndent = goodIndent || "	";
          const possibleTypeText = config.normalizeIndentation(goodIndent);
          if (!lineText.startsWith(possibleTypeText)) {
            commands[i] = new $h2(new $au(selection.startLineNumber, 1, selection.startLineNumber, lineText.length + 1), possibleTypeText, true);
            continue;
          }
        }
        commands[i] = this.b(config, model, selection, true);
      } else {
        if (selection.startLineNumber === selection.endLineNumber) {
          const lineMaxColumn = model.getLineMaxColumn(selection.startLineNumber);
          if (selection.startColumn !== 1 || selection.endColumn !== lineMaxColumn) {
            commands[i] = this.b(config, model, selection, false);
            continue;
          }
        }
        commands[i] = new $C2(selection, {
          isUnshift: false,
          tabSize: config.tabSize,
          indentSize: config.indentSize,
          insertSpaces: config.insertSpaces,
          useTabStops: config.useTabStops,
          autoIndent: config.autoIndent
        }, config.languageConfigurationService);
      }
    }
    return commands;
  }
  static a(config, model, lineNumber) {
    let action = null;
    let indentation = "";
    const expectedIndentAction = $t2(config.autoIndent, model, lineNumber, false, config.languageConfigurationService);
    if (expectedIndentAction) {
      action = expectedIndentAction.action;
      indentation = expectedIndentAction.indentation;
    } else if (lineNumber > 1) {
      let lastLineNumber;
      for (lastLineNumber = lineNumber - 1; lastLineNumber >= 1; lastLineNumber--) {
        const lineText = model.getLineContent(lastLineNumber);
        const nonWhitespaceIdx = $Pf(lineText);
        if (nonWhitespaceIdx >= 0) {
          break;
        }
      }
      if (lastLineNumber < 1) {
        return null;
      }
      const maxColumn = model.getLineMaxColumn(lastLineNumber);
      const expectedEnterAction = $B2(config.autoIndent, model, new $au(lastLineNumber, maxColumn, lastLineNumber, maxColumn), config.languageConfigurationService);
      if (expectedEnterAction) {
        indentation = expectedEnterAction.indentation + expectedEnterAction.appendText;
      }
    }
    if (action) {
      if (action === IndentAction.Indent) {
        indentation = $S2(config, indentation);
      }
      if (action === IndentAction.Outdent) {
        indentation = $T2(config, indentation);
      }
      indentation = config.normalizeIndentation(indentation);
    }
    if (!indentation) {
      return null;
    }
    return indentation;
  }
  static b(config, model, selection, insertsAutoWhitespace) {
    let typeText = "";
    const position = selection.getStartPosition();
    if (config.insertSpaces) {
      const visibleColumnFromColumn = config.visibleColumnFromColumn(model, position);
      const indentSize = config.indentSize;
      const spacesCnt = indentSize - visibleColumnFromColumn % indentSize;
      for (let i = 0; i < spacesCnt; i++) {
        typeText += " ";
      }
    } else {
      typeText = "	";
    }
    return new $h2(selection, typeText, insertsAutoWhitespace);
  }
};
var $R2 = class extends $k2 {
  constructor(selection, text2, lineNumberDeltaOffset, columnDeltaOffset, openCharacter, closeCharacter) {
    super(selection, text2, lineNumberDeltaOffset, columnDeltaOffset);
    this.f = openCharacter;
    this.g = closeCharacter;
    this.closeCharacterRange = null;
    this.enclosingRange = null;
  }
  h(model, range2, helper) {
    this.closeCharacterRange = new $au(range2.startLineNumber, range2.endColumn - this.g.length, range2.endLineNumber, range2.endColumn);
    this.enclosingRange = new $au(range2.startLineNumber, range2.endColumn - this.f.length - this.g.length, range2.endLineNumber, range2.endColumn);
    return super.computeCursorState(model, helper);
  }
};
var TypeWithAutoClosingCommand = class extends $R2 {
  constructor(selection, openCharacter, insertOpenCharacter, closeCharacter) {
    const text2 = (insertOpenCharacter ? openCharacter : "") + closeCharacter;
    const lineNumberDeltaOffset = 0;
    const columnDeltaOffset = -closeCharacter.length;
    super(selection, text2, lineNumberDeltaOffset, columnDeltaOffset, openCharacter, closeCharacter);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    const range2 = inverseEditOperations[0].range;
    return this.h(model, range2, helper);
  }
};
var TypeWithIndentationAndAutoClosingCommand = class extends $R2 {
  constructor(autoIndentationEdit, selection, openCharacter, closeCharacter) {
    const text2 = openCharacter + closeCharacter;
    const lineNumberDeltaOffset = 0;
    const columnDeltaOffset = openCharacter.length;
    super(selection, text2, lineNumberDeltaOffset, columnDeltaOffset, openCharacter, closeCharacter);
    this.k = autoIndentationEdit;
    this.l = { range: selection, text: text2 };
  }
  getEditOperations(model, builder) {
    builder.addTrackedEditOperation(this.k.range, this.k.text);
    builder.addTrackedEditOperation(this.l.range, this.l.text);
  }
  computeCursorState(model, helper) {
    const inverseEditOperations = helper.getInverseEditOperations();
    if (inverseEditOperations.length !== 2) {
      throw new Error("There should be two inverse edit operations!");
    }
    const range1 = inverseEditOperations[0].range;
    const range2 = inverseEditOperations[1].range;
    const range3 = range1.plusRange(range2);
    return this.h(model, range3, helper);
  }
};
function getTypingOperation(typedText, previousTypingOperation) {
  if (typedText === " ") {
    return previousTypingOperation === 5 || previousTypingOperation === 6 ? 6 : 5;
  }
  return 4;
}
function shouldPushStackElementBetween(previousTypingOperation, typingOperation) {
  if (isTypingOperation(previousTypingOperation) && !isTypingOperation(typingOperation)) {
    return true;
  }
  if (previousTypingOperation === 5) {
    return false;
  }
  return normalizeOperationType(previousTypingOperation) !== normalizeOperationType(typingOperation);
}
function normalizeOperationType(type) {
  return type === 6 || type === 5 ? "space" : type;
}
function isTypingOperation(type) {
  return type === 4 || type === 5 || type === 6;
}
function isAutoClosingOvertype(config, model, selections, autoClosedCharacters, ch) {
  if (config.autoClosingOvertype === "never") {
    return false;
  }
  if (!config.autoClosingPairs.autoClosingPairsCloseSingleChar.has(ch)) {
    return false;
  }
  for (let i = 0, len = selections.length; i < len; i++) {
    const selection = selections[i];
    if (!selection.isEmpty()) {
      return false;
    }
    const position = selection.getPosition();
    const lineText = model.getLineContent(position.lineNumber);
    const afterCharacter = lineText.charAt(position.column - 1);
    if (afterCharacter !== ch) {
      return false;
    }
    const chIsQuote = $p1(ch);
    const beforeCharacter = position.column > 2 ? lineText.charCodeAt(position.column - 2) : 0;
    if (beforeCharacter === 92 && chIsQuote) {
      return false;
    }
    if (config.autoClosingOvertype === "auto") {
      let found = false;
      for (let j = 0, lenJ = autoClosedCharacters.length; j < lenJ; j++) {
        const autoClosedCharacter = autoClosedCharacters[j];
        if (position.lineNumber === autoClosedCharacter.startLineNumber && position.column === autoClosedCharacter.startColumn) {
          found = true;
          break;
        }
      }
      if (!found) {
        return false;
      }
    }
  }
  return true;
}
function typeCommand(range2, text2, keepPosition) {
  if (keepPosition) {
    return new $j2(range2, text2, true);
  } else {
    return new $h2(range2, text2, true);
  }
}
function $S2(config, indentation, count) {
  count = count || 1;
  return $C2.shiftIndent(indentation, indentation.length + count, config.tabSize, config.indentSize, config.insertSpaces);
}
function $T2(config, indentation, count) {
  count = count || 1;
  return $C2.unshiftIndent(indentation, indentation.length + count, config.tabSize, config.indentSize, config.insertSpaces);
}
function $U2(config, ch) {
  if ($p1(ch)) {
    return config.autoSurround === "quotes" || config.autoSurround === "languageDefined";
  } else {
    return config.autoSurround === "brackets" || config.autoSurround === "languageDefined";
  }
}

// out-build/vs/editor/common/cursor/cursorTypeOperations.js
var $V2 = class {
  static indent(config, model, selections) {
    if (model === null || selections === null) {
      return [];
    }
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      commands[i] = new $C2(selections[i], {
        isUnshift: false,
        tabSize: config.tabSize,
        indentSize: config.indentSize,
        insertSpaces: config.insertSpaces,
        useTabStops: config.useTabStops,
        autoIndent: config.autoIndent
      }, config.languageConfigurationService);
    }
    return commands;
  }
  static outdent(config, model, selections) {
    const commands = [];
    for (let i = 0, len = selections.length; i < len; i++) {
      commands[i] = new $C2(selections[i], {
        isUnshift: true,
        tabSize: config.tabSize,
        indentSize: config.indentSize,
        insertSpaces: config.insertSpaces,
        useTabStops: config.useTabStops,
        autoIndent: config.autoIndent
      }, config.languageConfigurationService);
    }
    return commands;
  }
  static shiftIndent(config, indentation, count) {
    return $S2(config, indentation, count);
  }
  static unshiftIndent(config, indentation, count) {
    return $T2(config, indentation, count);
  }
  static paste(config, model, selections, text2, pasteOnNewLine, multicursorText) {
    return $N2.getEdits(config, model, selections, text2, pasteOnNewLine, multicursorText);
  }
  static tab(config, model, selections) {
    return $Q2.getCommands(config, model, selections);
  }
  static compositionType(prevEditOperationType, config, model, selections, text2, replacePrevCharCnt, replaceNextCharCnt, positionDelta) {
    return $O2.getEdits(prevEditOperationType, config, model, selections, text2, replacePrevCharCnt, replaceNextCharCnt, positionDelta);
  }
  /**
   * This is very similar with typing, but the character is already in the text buffer!
   */
  static compositionEndWithInterceptors(prevEditOperationType, config, model, compositions, selections, autoClosedCharacters) {
    if (!compositions) {
      return null;
    }
    let insertedText = null;
    for (const composition of compositions) {
      if (insertedText === null) {
        insertedText = composition.insertedText;
      } else if (insertedText !== composition.insertedText) {
        return null;
      }
    }
    if (!insertedText || insertedText.length !== 1) {
      return null;
    }
    const ch = insertedText;
    let hasDeletion = false;
    for (const composition of compositions) {
      if (composition.deletedText.length !== 0) {
        hasDeletion = true;
        break;
      }
    }
    if (hasDeletion) {
      if (!$U2(config, ch) || !config.surroundingPairs.hasOwnProperty(ch)) {
        return null;
      }
      const isTypingAQuoteCharacter = $p1(ch);
      for (const composition of compositions) {
        if (composition.deletedSelectionStart !== 0 || composition.deletedSelectionEnd !== composition.deletedText.length) {
          return null;
        }
        if (/^[ \t]+$/.test(composition.deletedText)) {
          return null;
        }
        if (isTypingAQuoteCharacter && $p1(composition.deletedText)) {
          return null;
        }
      }
      const positions = [];
      for (const selection of selections) {
        if (!selection.isEmpty()) {
          return null;
        }
        positions.push(selection.getPosition());
      }
      if (positions.length !== compositions.length) {
        return null;
      }
      const commands = [];
      for (let i = 0, len = positions.length; i < len; i++) {
        commands.push(new $E2(positions[i], compositions[i].deletedText, config.surroundingPairs[ch]));
      }
      return new $o1(4, commands, {
        shouldPushStackElementBefore: true,
        shouldPushStackElementAfter: false
      });
    }
    const autoClosingOvertypeEdits = $H2.getEdits(config, model, selections, autoClosedCharacters, ch);
    if (autoClosingOvertypeEdits !== void 0) {
      return autoClosingOvertypeEdits;
    }
    const autoClosingOpenCharEdits = $I2.getEdits(config, model, selections, ch, true, false);
    if (autoClosingOpenCharEdits !== void 0) {
      return autoClosingOpenCharEdits;
    }
    return null;
  }
  static typeWithInterceptors(isDoingComposition, prevEditOperationType, config, model, selections, autoClosedCharacters, ch) {
    const enterEdits = $M2.getEdits(config, model, selections, ch, isDoingComposition);
    if (enterEdits !== void 0) {
      return enterEdits;
    }
    const autoIndentEdits = $F2.getEdits(config, model, selections, ch, isDoingComposition);
    if (autoIndentEdits !== void 0) {
      return autoIndentEdits;
    }
    const autoClosingOverTypeEdits = $G2.getEdits(prevEditOperationType, config, model, selections, autoClosedCharacters, ch);
    if (autoClosingOverTypeEdits !== void 0) {
      return autoClosingOverTypeEdits;
    }
    const autoClosingOpenCharEdits = $I2.getEdits(config, model, selections, ch, false, isDoingComposition);
    if (autoClosingOpenCharEdits !== void 0) {
      return autoClosingOpenCharEdits;
    }
    const surroundSelectionEdits = $J2.getEdits(config, model, selections, ch, isDoingComposition);
    if (surroundSelectionEdits !== void 0) {
      return surroundSelectionEdits;
    }
    const interceptorElectricCharOperation = $K2.getEdits(prevEditOperationType, config, model, selections, ch, isDoingComposition);
    if (interceptorElectricCharOperation !== void 0) {
      return interceptorElectricCharOperation;
    }
    return $L2.getEdits(prevEditOperationType, selections, ch);
  }
  static typeWithoutInterceptors(prevEditOperationType, config, model, selections, str) {
    return $P2.getEdits(prevEditOperationType, selections, str);
  }
};
var $W2 = class {
  constructor(deletedText, deletedSelectionStart, deletedSelectionEnd, insertedText, insertedSelectionStart, insertedSelectionEnd) {
    this.deletedText = deletedText;
    this.deletedSelectionStart = deletedSelectionStart;
    this.deletedSelectionEnd = deletedSelectionEnd;
    this.insertedText = insertedText;
    this.insertedSelectionStart = insertedSelectionStart;
    this.insertedSelectionEnd = insertedSelectionEnd;
  }
};

// out-build/vs/editor/common/editorContextKeys.js
var EditorContextKeys;
(function(EditorContextKeys2) {
  EditorContextKeys2.editorSimpleInput = new $ek("editorSimpleInput", false, true);
  EditorContextKeys2.editorTextFocus = new $ek("editorTextFocus", false, localize(748, null));
  EditorContextKeys2.focus = new $ek("editorFocus", false, localize(749, null));
  EditorContextKeys2.textInputFocus = new $ek("textInputFocus", false, localize(750, null));
  EditorContextKeys2.readOnly = new $ek("editorReadonly", false, localize(751, null));
  EditorContextKeys2.inDiffEditor = new $ek("inDiffEditor", false, localize(752, null));
  EditorContextKeys2.isEmbeddedDiffEditor = new $ek("isEmbeddedDiffEditor", false, localize(753, null));
  EditorContextKeys2.multiDiffEditorAllCollapsed = new $ek("multiDiffEditorAllCollapsed", void 0, localize(754, null));
  EditorContextKeys2.hasChanges = new $ek("diffEditorHasChanges", false, localize(755, null));
  EditorContextKeys2.comparingMovedCode = new $ek("comparingMovedCode", false, localize(756, null));
  EditorContextKeys2.accessibleDiffViewerVisible = new $ek("accessibleDiffViewerVisible", false, localize(757, null));
  EditorContextKeys2.diffEditorRenderSideBySideInlineBreakpointReached = new $ek("diffEditorRenderSideBySideInlineBreakpointReached", false, localize(758, null));
  EditorContextKeys2.diffEditorInlineMode = new $ek("diffEditorInlineMode", false, localize(759, null));
  EditorContextKeys2.diffEditorOriginalWritable = new $ek("diffEditorOriginalWritable", false, localize(760, null));
  EditorContextKeys2.diffEditorModifiedWritable = new $ek("diffEditorModifiedWritable", false, localize(761, null));
  EditorContextKeys2.diffEditorOriginalUri = new $ek("diffEditorOriginalUri", "", localize(762, null));
  EditorContextKeys2.diffEditorModifiedUri = new $ek("diffEditorModifiedUri", "", localize(763, null));
  EditorContextKeys2.columnSelection = new $ek("editorColumnSelection", false, localize(764, null));
  EditorContextKeys2.writable = EditorContextKeys2.readOnly.toNegated();
  EditorContextKeys2.hasNonEmptySelection = new $ek("editorHasSelection", false, localize(765, null));
  EditorContextKeys2.hasOnlyEmptySelection = EditorContextKeys2.hasNonEmptySelection.toNegated();
  EditorContextKeys2.hasMultipleSelections = new $ek("editorHasMultipleSelections", false, localize(766, null));
  EditorContextKeys2.hasSingleSelection = EditorContextKeys2.hasMultipleSelections.toNegated();
  EditorContextKeys2.tabMovesFocus = new $ek("editorTabMovesFocus", false, localize(767, null));
  EditorContextKeys2.tabDoesNotMoveFocus = EditorContextKeys2.tabMovesFocus.toNegated();
  EditorContextKeys2.isInEmbeddedEditor = new $ek("isInEmbeddedEditor", false, true);
  EditorContextKeys2.canUndo = new $ek("canUndo", false, true);
  EditorContextKeys2.canRedo = new $ek("canRedo", false, true);
  EditorContextKeys2.hoverVisible = new $ek("editorHoverVisible", false, localize(768, null));
  EditorContextKeys2.hoverFocused = new $ek("editorHoverFocused", false, localize(769, null));
  EditorContextKeys2.stickyScrollFocused = new $ek("stickyScrollFocused", false, localize(770, null));
  EditorContextKeys2.stickyScrollVisible = new $ek("stickyScrollVisible", false, localize(771, null));
  EditorContextKeys2.standaloneColorPickerVisible = new $ek("standaloneColorPickerVisible", false, localize(772, null));
  EditorContextKeys2.standaloneColorPickerFocused = new $ek("standaloneColorPickerFocused", false, localize(773, null));
  EditorContextKeys2.inCompositeEditor = new $ek("inCompositeEditor", void 0, localize(774, null));
  EditorContextKeys2.notInCompositeEditor = EditorContextKeys2.inCompositeEditor.toNegated();
  EditorContextKeys2.languageId = new $ek("editorLangId", "", localize(775, null));
  EditorContextKeys2.hasCompletionItemProvider = new $ek("editorHasCompletionItemProvider", false, localize(776, null));
  EditorContextKeys2.hasCodeActionsProvider = new $ek("editorHasCodeActionsProvider", false, localize(777, null));
  EditorContextKeys2.hasCodeLensProvider = new $ek("editorHasCodeLensProvider", false, localize(778, null));
  EditorContextKeys2.hasDefinitionProvider = new $ek("editorHasDefinitionProvider", false, localize(779, null));
  EditorContextKeys2.hasDeclarationProvider = new $ek("editorHasDeclarationProvider", false, localize(780, null));
  EditorContextKeys2.hasImplementationProvider = new $ek("editorHasImplementationProvider", false, localize(781, null));
  EditorContextKeys2.hasTypeDefinitionProvider = new $ek("editorHasTypeDefinitionProvider", false, localize(782, null));
  EditorContextKeys2.hasHoverProvider = new $ek("editorHasHoverProvider", false, localize(783, null));
  EditorContextKeys2.hasDocumentHighlightProvider = new $ek("editorHasDocumentHighlightProvider", false, localize(784, null));
  EditorContextKeys2.hasDocumentSymbolProvider = new $ek("editorHasDocumentSymbolProvider", false, localize(785, null));
  EditorContextKeys2.hasReferenceProvider = new $ek("editorHasReferenceProvider", false, localize(786, null));
  EditorContextKeys2.hasRenameProvider = new $ek("editorHasRenameProvider", false, localize(787, null));
  EditorContextKeys2.hasSignatureHelpProvider = new $ek("editorHasSignatureHelpProvider", false, localize(788, null));
  EditorContextKeys2.hasInlayHintsProvider = new $ek("editorHasInlayHintsProvider", false, localize(789, null));
  EditorContextKeys2.hasDocumentFormattingProvider = new $ek("editorHasDocumentFormattingProvider", false, localize(790, null));
  EditorContextKeys2.hasDocumentSelectionFormattingProvider = new $ek("editorHasDocumentSelectionFormattingProvider", false, localize(791, null));
  EditorContextKeys2.hasMultipleDocumentFormattingProvider = new $ek("editorHasMultipleDocumentFormattingProvider", false, localize(792, null));
  EditorContextKeys2.hasMultipleDocumentSelectionFormattingProvider = new $ek("editorHasMultipleDocumentSelectionFormattingProvider", false, localize(793, null));
})(EditorContextKeys || (EditorContextKeys = {}));

// out-build/vs/editor/browser/coreCommands.js
var CORE_WEIGHT = 0;
var $X2 = class extends $51 {
  runEditorCommand(accessor, editor, args2) {
    const viewModel = editor._getViewModel();
    if (!viewModel) {
      return;
    }
    this.runCoreEditorCommand(viewModel, args2 || {});
  }
};
var EditorScroll_;
(function(EditorScroll_2) {
  const isEditorScrollArgs = function(arg) {
    if (!$Ag(arg)) {
      return false;
    }
    const scrollArg = arg;
    if (!$yg(scrollArg.to)) {
      return false;
    }
    if (!$Fg(scrollArg.by) && !$yg(scrollArg.by)) {
      return false;
    }
    if (!$Fg(scrollArg.value) && !$Cg(scrollArg.value)) {
      return false;
    }
    if (!$Fg(scrollArg.revealCursor) && !$Eg(scrollArg.revealCursor)) {
      return false;
    }
    return true;
  };
  EditorScroll_2.metadata = {
    description: "Scroll editor in the given direction",
    args: [
      {
        name: "Editor scroll argument object",
        description: `Property-value pairs that can be passed through this argument:
					* 'to': A mandatory direction value.
						\`\`\`
						'up', 'down'
						\`\`\`
					* 'by': Unit to move. Default is computed based on 'to' value.
						\`\`\`
						'line', 'wrappedLine', 'page', 'halfPage', 'editor'
						\`\`\`
					* 'value': Number of units to move. Default is '1'.
					* 'revealCursor': If 'true' reveals the cursor if it is outside view port.
				`,
        constraint: isEditorScrollArgs,
        schema: {
          "type": "object",
          "required": ["to"],
          "properties": {
            "to": {
              "type": "string",
              "enum": ["up", "down"]
            },
            "by": {
              "type": "string",
              "enum": ["line", "wrappedLine", "page", "halfPage", "editor"]
            },
            "value": {
              "type": "number",
              "default": 1
            },
            "revealCursor": {
              "type": "boolean"
            }
          }
        }
      }
    ]
  };
  EditorScroll_2.RawDirection = {
    Up: "up",
    Right: "right",
    Down: "down",
    Left: "left"
  };
  EditorScroll_2.RawUnit = {
    Line: "line",
    WrappedLine: "wrappedLine",
    Page: "page",
    HalfPage: "halfPage",
    Editor: "editor",
    Column: "column"
  };
  function parse5(args2) {
    let direction;
    switch (args2.to) {
      case EditorScroll_2.RawDirection.Up:
        direction = 1;
        break;
      case EditorScroll_2.RawDirection.Right:
        direction = 2;
        break;
      case EditorScroll_2.RawDirection.Down:
        direction = 3;
        break;
      case EditorScroll_2.RawDirection.Left:
        direction = 4;
        break;
      default:
        return null;
    }
    let unit;
    switch (args2.by) {
      case EditorScroll_2.RawUnit.Line:
        unit = 1;
        break;
      case EditorScroll_2.RawUnit.WrappedLine:
        unit = 2;
        break;
      case EditorScroll_2.RawUnit.Page:
        unit = 3;
        break;
      case EditorScroll_2.RawUnit.HalfPage:
        unit = 4;
        break;
      case EditorScroll_2.RawUnit.Editor:
        unit = 5;
        break;
      case EditorScroll_2.RawUnit.Column:
        unit = 6;
        break;
      default:
        unit = 2;
    }
    const value = Math.floor(args2.value || 1);
    const revealCursor = !!args2.revealCursor;
    return {
      direction,
      unit,
      value,
      revealCursor,
      select: !!args2.select
    };
  }
  EditorScroll_2.parse = parse5;
  let Direction4;
  (function(Direction5) {
    Direction5[Direction5["Up"] = 1] = "Up";
    Direction5[Direction5["Right"] = 2] = "Right";
    Direction5[Direction5["Down"] = 3] = "Down";
    Direction5[Direction5["Left"] = 4] = "Left";
  })(Direction4 = EditorScroll_2.Direction || (EditorScroll_2.Direction = {}));
  let Unit;
  (function(Unit2) {
    Unit2[Unit2["Line"] = 1] = "Line";
    Unit2[Unit2["WrappedLine"] = 2] = "WrappedLine";
    Unit2[Unit2["Page"] = 3] = "Page";
    Unit2[Unit2["HalfPage"] = 4] = "HalfPage";
    Unit2[Unit2["Editor"] = 5] = "Editor";
    Unit2[Unit2["Column"] = 6] = "Column";
  })(Unit = EditorScroll_2.Unit || (EditorScroll_2.Unit = {}));
})(EditorScroll_ || (EditorScroll_ = {}));
var RevealLine_;
(function(RevealLine_2) {
  const isRevealLineArgs = function(arg) {
    if (!$Ag(arg)) {
      return false;
    }
    const reveaLineArg = arg;
    if (!$Cg(reveaLineArg.lineNumber) && !$yg(reveaLineArg.lineNumber)) {
      return false;
    }
    if (!$Fg(reveaLineArg.at) && !$yg(reveaLineArg.at)) {
      return false;
    }
    return true;
  };
  RevealLine_2.metadata = {
    description: "Reveal the given line at the given logical position",
    args: [
      {
        name: "Reveal line argument object",
        description: `Property-value pairs that can be passed through this argument:
					* 'lineNumber': A mandatory line number value.
					* 'at': Logical position at which line has to be revealed.
						\`\`\`
						'top', 'center', 'bottom'
						\`\`\`
				`,
        constraint: isRevealLineArgs,
        schema: {
          "type": "object",
          "required": ["lineNumber"],
          "properties": {
            "lineNumber": {
              "type": ["number", "string"]
            },
            "at": {
              "type": "string",
              "enum": ["top", "center", "bottom"]
            }
          }
        }
      }
    ]
  };
  RevealLine_2.RawAtArgument = {
    Top: "top",
    Center: "center",
    Bottom: "bottom"
  };
})(RevealLine_ || (RevealLine_ = {}));
var EditorOrNativeTextInputCommand = class {
  constructor(target) {
    target.addImplementation(1e4, "code-editor", (accessor, args2) => {
      const focusedEditor = accessor.get($11).getFocusedCodeEditor();
      if (focusedEditor && focusedEditor.hasTextFocus()) {
        return this._runEditorCommand(accessor, focusedEditor, args2);
      }
      return false;
    });
    target.addImplementation(1e3, "generic-dom-input-textarea", (accessor, args2) => {
      const activeElement = $hU();
      if (activeElement && $kV(activeElement)) {
        this.runDOMCommand(activeElement);
        return true;
      }
      return false;
    });
    target.addImplementation(0, "generic-dom", (accessor, args2) => {
      const activeEditor = accessor.get($11).getActiveCodeEditor();
      if (activeEditor) {
        activeEditor.focus();
        return this._runEditorCommand(accessor, activeEditor, args2);
      }
      return false;
    });
  }
  _runEditorCommand(accessor, editor, args2) {
    const result = this.runEditorCommand(accessor, editor, args2);
    if (result) {
      return result;
    }
    return true;
  }
};
var NavigationCommandRevealType;
(function(NavigationCommandRevealType2) {
  NavigationCommandRevealType2[NavigationCommandRevealType2["Regular"] = 0] = "Regular";
  NavigationCommandRevealType2[NavigationCommandRevealType2["Minimal"] = 1] = "Minimal";
  NavigationCommandRevealType2[NavigationCommandRevealType2["None"] = 2] = "None";
})(NavigationCommandRevealType || (NavigationCommandRevealType = {}));
var CoreNavigationCommands;
(function(CoreNavigationCommands2) {
  class BaseMoveToCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.position) {
        return;
      }
      viewModel.model.pushStackElement();
      const cursorStateChanged = viewModel.setCursorStates(args2.source, 3, [
        $s2.moveTo(viewModel, viewModel.getPrimaryCursorState(), this.d, args2.position, args2.viewPosition)
      ]);
      if (cursorStateChanged && args2.revealType !== 2) {
        viewModel.revealAllCursors(args2.source, true, true);
      }
    }
  }
  CoreNavigationCommands2.MoveTo = $01(new BaseMoveToCommand({
    id: "_moveTo",
    inSelectionMode: false,
    precondition: void 0
  }));
  CoreNavigationCommands2.MoveToSelect = $01(new BaseMoveToCommand({
    id: "_moveToSelect",
    inSelectionMode: true,
    precondition: void 0
  }));
  class ColumnSelectCommand extends $X2 {
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      const result = this.d(viewModel, viewModel.getPrimaryCursorState(), viewModel.getCursorColumnSelectData(), args2);
      if (result === null) {
        return;
      }
      viewModel.setCursorStates(args2.source, 3, result.viewStates.map((viewState) => $k1.fromViewState(viewState)));
      viewModel.setCursorColumnSelectData({
        isReal: true,
        fromViewLineNumber: result.fromLineNumber,
        fromViewVisualColumn: result.fromVisualColumn,
        toViewLineNumber: result.toLineNumber,
        toViewVisualColumn: result.toVisualColumn
      });
      if (result.reversed) {
        viewModel.revealTopMostCursor(args2.source);
      } else {
        viewModel.revealBottomMostCursor(args2.source);
      }
    }
  }
  CoreNavigationCommands2.ColumnSelect = $01(new class extends ColumnSelectCommand {
    constructor() {
      super({
        id: "columnSelect",
        precondition: void 0
      });
    }
    d(viewModel, primary, prevColumnSelectData, args2) {
      if (typeof args2.position === "undefined" || typeof args2.viewPosition === "undefined" || typeof args2.mouseColumn === "undefined") {
        return null;
      }
      const validatedPosition = viewModel.model.validatePosition(args2.position);
      const validatedViewPosition = viewModel.coordinatesConverter.validateViewPosition(new $_t(args2.viewPosition.lineNumber, args2.viewPosition.column), validatedPosition);
      const fromViewLineNumber = args2.doColumnSelect ? prevColumnSelectData.fromViewLineNumber : validatedViewPosition.lineNumber;
      const fromViewVisualColumn = args2.doColumnSelect ? prevColumnSelectData.fromViewVisualColumn : args2.mouseColumn - 1;
      return $g2.columnSelect(viewModel.cursorConfig, viewModel, fromViewLineNumber, fromViewVisualColumn, validatedViewPosition.lineNumber, args2.mouseColumn - 1);
    }
  }());
  CoreNavigationCommands2.CursorColumnSelectLeft = $01(new class extends ColumnSelectCommand {
    constructor() {
      super({
        id: "cursorColumnSelectLeft",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 2048 | 1024 | 512 | 15,
          linux: { primary: 0 }
        }
      });
    }
    d(viewModel, primary, prevColumnSelectData, args2) {
      return $g2.columnSelectLeft(viewModel.cursorConfig, viewModel, prevColumnSelectData);
    }
  }());
  CoreNavigationCommands2.CursorColumnSelectRight = $01(new class extends ColumnSelectCommand {
    constructor() {
      super({
        id: "cursorColumnSelectRight",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 2048 | 1024 | 512 | 17,
          linux: { primary: 0 }
        }
      });
    }
    d(viewModel, primary, prevColumnSelectData, args2) {
      return $g2.columnSelectRight(viewModel.cursorConfig, viewModel, prevColumnSelectData);
    }
  }());
  class ColumnSelectUpCommand extends ColumnSelectCommand {
    constructor(opts) {
      super(opts);
      this.e = opts.isPaged;
    }
    d(viewModel, primary, prevColumnSelectData, args2) {
      return $g2.columnSelectUp(viewModel.cursorConfig, viewModel, prevColumnSelectData, this.e);
    }
  }
  CoreNavigationCommands2.CursorColumnSelectUp = $01(new ColumnSelectUpCommand({
    isPaged: false,
    id: "cursorColumnSelectUp",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 1024 | 512 | 16,
      linux: { primary: 0 }
    }
  }));
  CoreNavigationCommands2.CursorColumnSelectPageUp = $01(new ColumnSelectUpCommand({
    isPaged: true,
    id: "cursorColumnSelectPageUp",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 1024 | 512 | 11,
      linux: { primary: 0 }
    }
  }));
  class ColumnSelectDownCommand extends ColumnSelectCommand {
    constructor(opts) {
      super(opts);
      this.e = opts.isPaged;
    }
    d(viewModel, primary, prevColumnSelectData, args2) {
      return $g2.columnSelectDown(viewModel.cursorConfig, viewModel, prevColumnSelectData, this.e);
    }
  }
  CoreNavigationCommands2.CursorColumnSelectDown = $01(new ColumnSelectDownCommand({
    isPaged: false,
    id: "cursorColumnSelectDown",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 1024 | 512 | 18,
      linux: { primary: 0 }
    }
  }));
  CoreNavigationCommands2.CursorColumnSelectPageDown = $01(new ColumnSelectDownCommand({
    isPaged: true,
    id: "cursorColumnSelectPageDown",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 1024 | 512 | 12,
      linux: { primary: 0 }
    }
  }));
  class CursorMoveImpl extends $X2 {
    constructor() {
      super({
        id: "cursorMove",
        precondition: void 0,
        metadata: CursorMove.metadata
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      const parsed = CursorMove.parse(args2);
      if (!parsed) {
        return;
      }
      this.d(viewModel, args2.source, parsed);
    }
    d(viewModel, source, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(source, 3, CursorMoveImpl.e(viewModel, viewModel.getCursorStates(), args2));
      viewModel.revealAllCursors(source, true);
    }
    static e(viewModel, cursors, args2) {
      const inSelectionMode = args2.select;
      const value = args2.value;
      switch (args2.direction) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
          return $s2.simpleMove(viewModel, cursors, args2.direction, inSelectionMode, value, args2.unit);
        case 11:
        case 13:
        case 12:
        case 14:
          return $s2.viewportMove(viewModel, cursors, args2.direction, inSelectionMode, value);
        default:
          return null;
      }
    }
  }
  CoreNavigationCommands2.CursorMoveImpl = CursorMoveImpl;
  CoreNavigationCommands2.CursorMove = $01(new CursorMoveImpl());
  let Constants27;
  (function(Constants28) {
    Constants28[Constants28["PAGE_SIZE_MARKER"] = -1] = "PAGE_SIZE_MARKER";
  })(Constants27 || (Constants27 = {}));
  class CursorMoveBasedCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.args;
    }
    runCoreEditorCommand(viewModel, dynamicArgs) {
      let args2 = this.d;
      if (this.d.value === -1) {
        args2 = {
          direction: this.d.direction,
          unit: this.d.unit,
          select: this.d.select,
          value: dynamicArgs.pageSize || viewModel.cursorConfig.pageSize
        };
      }
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(dynamicArgs.source, 3, $s2.simpleMove(viewModel, viewModel.getCursorStates(), args2.direction, args2.select, args2.value, args2.unit));
      viewModel.revealAllCursors(dynamicArgs.source, true);
    }
  }
  CoreNavigationCommands2.CursorLeft = $01(new CursorMoveBasedCommand({
    args: {
      direction: 0,
      unit: 0,
      select: false,
      value: 1
    },
    id: "cursorLeft",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 15,
      mac: { primary: 15, secondary: [
        256 | 32
        /* KeyCode.KeyB */
      ] }
    }
  }));
  CoreNavigationCommands2.CursorLeftSelect = $01(new CursorMoveBasedCommand({
    args: {
      direction: 0,
      unit: 0,
      select: true,
      value: 1
    },
    id: "cursorLeftSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 15
      /* KeyCode.LeftArrow */
    }
  }));
  CoreNavigationCommands2.CursorRight = $01(new CursorMoveBasedCommand({
    args: {
      direction: 1,
      unit: 0,
      select: false,
      value: 1
    },
    id: "cursorRight",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 17,
      mac: { primary: 17, secondary: [
        256 | 36
        /* KeyCode.KeyF */
      ] }
    }
  }));
  CoreNavigationCommands2.CursorRightSelect = $01(new CursorMoveBasedCommand({
    args: {
      direction: 1,
      unit: 0,
      select: true,
      value: 1
    },
    id: "cursorRightSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 17
      /* KeyCode.RightArrow */
    }
  }));
  CoreNavigationCommands2.CursorUp = $01(new CursorMoveBasedCommand({
    args: {
      direction: 2,
      unit: 2,
      select: false,
      value: 1
    },
    id: "cursorUp",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 16,
      mac: { primary: 16, secondary: [
        256 | 46
        /* KeyCode.KeyP */
      ] }
    }
  }));
  CoreNavigationCommands2.CursorUpSelect = $01(new CursorMoveBasedCommand({
    args: {
      direction: 2,
      unit: 2,
      select: true,
      value: 1
    },
    id: "cursorUpSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 16,
      secondary: [
        2048 | 1024 | 16
        /* KeyCode.UpArrow */
      ],
      mac: {
        primary: 1024 | 16
        /* KeyCode.UpArrow */
      },
      linux: {
        primary: 1024 | 16
        /* KeyCode.UpArrow */
      }
    }
  }));
  CoreNavigationCommands2.CursorPageUp = $01(new CursorMoveBasedCommand({
    args: {
      direction: 2,
      unit: 2,
      select: false,
      value: -1
      /* Constants.PAGE_SIZE_MARKER */
    },
    id: "cursorPageUp",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 11
      /* KeyCode.PageUp */
    }
  }));
  CoreNavigationCommands2.CursorPageUpSelect = $01(new CursorMoveBasedCommand({
    args: {
      direction: 2,
      unit: 2,
      select: true,
      value: -1
      /* Constants.PAGE_SIZE_MARKER */
    },
    id: "cursorPageUpSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 11
      /* KeyCode.PageUp */
    }
  }));
  CoreNavigationCommands2.CursorDown = $01(new CursorMoveBasedCommand({
    args: {
      direction: 3,
      unit: 2,
      select: false,
      value: 1
    },
    id: "cursorDown",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 18,
      mac: { primary: 18, secondary: [
        256 | 44
        /* KeyCode.KeyN */
      ] }
    }
  }));
  CoreNavigationCommands2.CursorDownSelect = $01(new CursorMoveBasedCommand({
    args: {
      direction: 3,
      unit: 2,
      select: true,
      value: 1
    },
    id: "cursorDownSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 18,
      secondary: [
        2048 | 1024 | 18
        /* KeyCode.DownArrow */
      ],
      mac: {
        primary: 1024 | 18
        /* KeyCode.DownArrow */
      },
      linux: {
        primary: 1024 | 18
        /* KeyCode.DownArrow */
      }
    }
  }));
  CoreNavigationCommands2.CursorPageDown = $01(new CursorMoveBasedCommand({
    args: {
      direction: 3,
      unit: 2,
      select: false,
      value: -1
      /* Constants.PAGE_SIZE_MARKER */
    },
    id: "cursorPageDown",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 12
      /* KeyCode.PageDown */
    }
  }));
  CoreNavigationCommands2.CursorPageDownSelect = $01(new CursorMoveBasedCommand({
    args: {
      direction: 3,
      unit: 2,
      select: true,
      value: -1
      /* Constants.PAGE_SIZE_MARKER */
    },
    id: "cursorPageDownSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 12
      /* KeyCode.PageDown */
    }
  }));
  CoreNavigationCommands2.CreateCursor = $01(new class extends $X2 {
    constructor() {
      super({
        id: "createCursor",
        precondition: void 0
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.position) {
        return;
      }
      let newState;
      if (args2.wholeLine) {
        newState = $s2.line(viewModel, viewModel.getPrimaryCursorState(), false, args2.position, args2.viewPosition);
      } else {
        newState = $s2.moveTo(viewModel, viewModel.getPrimaryCursorState(), false, args2.position, args2.viewPosition);
      }
      const states = viewModel.getCursorStates();
      if (states.length > 1) {
        const newModelPosition = newState.modelState ? newState.modelState.position : null;
        const newViewPosition = newState.viewState ? newState.viewState.position : null;
        for (let i = 0, len = states.length; i < len; i++) {
          const state = states[i];
          if (newModelPosition && !state.modelState.selection.containsPosition(newModelPosition)) {
            continue;
          }
          if (newViewPosition && !state.viewState.selection.containsPosition(newViewPosition)) {
            continue;
          }
          states.splice(i, 1);
          viewModel.model.pushStackElement();
          viewModel.setCursorStates(args2.source, 3, states);
          return;
        }
      }
      states.push(newState);
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, states);
    }
  }());
  CoreNavigationCommands2.LastCursorMoveToSelect = $01(new class extends $X2 {
    constructor() {
      super({
        id: "_lastCursorMoveToSelect",
        precondition: void 0
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.position) {
        return;
      }
      const lastAddedCursorIndex = viewModel.getLastAddedCursorIndex();
      const states = viewModel.getCursorStates();
      const newStates = states.slice(0);
      newStates[lastAddedCursorIndex] = $s2.moveTo(viewModel, states[lastAddedCursorIndex], true, args2.position, args2.viewPosition);
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, newStates);
    }
  }());
  class HomeCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, $s2.moveToBeginningOfLine(viewModel, viewModel.getCursorStates(), this.d));
      viewModel.revealAllCursors(args2.source, true);
    }
  }
  CoreNavigationCommands2.CursorHome = $01(new HomeCommand({
    inSelectionMode: false,
    id: "cursorHome",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 14,
      mac: { primary: 14, secondary: [
        2048 | 15
        /* KeyCode.LeftArrow */
      ] }
    }
  }));
  CoreNavigationCommands2.CursorHomeSelect = $01(new HomeCommand({
    inSelectionMode: true,
    id: "cursorHomeSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 14,
      mac: { primary: 1024 | 14, secondary: [
        2048 | 1024 | 15
        /* KeyCode.LeftArrow */
      ] }
    }
  }));
  class LineStartCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, this.e(viewModel.getCursorStates()));
      viewModel.revealAllCursors(args2.source, true);
    }
    e(cursors) {
      const result = [];
      for (let i = 0, len = cursors.length; i < len; i++) {
        const cursor = cursors[i];
        const lineNumber = cursor.modelState.position.lineNumber;
        result[i] = $k1.fromModelState(cursor.modelState.move(this.d, lineNumber, 1, 0));
      }
      return result;
    }
  }
  CoreNavigationCommands2.CursorLineStart = $01(new LineStartCommand({
    inSelectionMode: false,
    id: "cursorLineStart",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 0,
      mac: {
        primary: 256 | 31
        /* KeyCode.KeyA */
      }
    }
  }));
  CoreNavigationCommands2.CursorLineStartSelect = $01(new LineStartCommand({
    inSelectionMode: true,
    id: "cursorLineStartSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 0,
      mac: {
        primary: 256 | 1024 | 31
        /* KeyCode.KeyA */
      }
    }
  }));
  class EndCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, $s2.moveToEndOfLine(viewModel, viewModel.getCursorStates(), this.d, args2.sticky || false));
      viewModel.revealAllCursors(args2.source, true);
    }
  }
  CoreNavigationCommands2.CursorEnd = $01(new EndCommand({
    inSelectionMode: false,
    id: "cursorEnd",
    precondition: void 0,
    kbOpts: {
      args: { sticky: false },
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 13,
      mac: { primary: 13, secondary: [
        2048 | 17
        /* KeyCode.RightArrow */
      ] }
    },
    metadata: {
      description: `Go to End`,
      args: [{
        name: "args",
        schema: {
          type: "object",
          properties: {
            "sticky": {
              description: localize(180, null),
              type: "boolean",
              default: false
            }
          }
        }
      }]
    }
  }));
  CoreNavigationCommands2.CursorEndSelect = $01(new EndCommand({
    inSelectionMode: true,
    id: "cursorEndSelect",
    precondition: void 0,
    kbOpts: {
      args: { sticky: false },
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 1024 | 13,
      mac: { primary: 1024 | 13, secondary: [
        2048 | 1024 | 17
        /* KeyCode.RightArrow */
      ] }
    },
    metadata: {
      description: `Select to End`,
      args: [{
        name: "args",
        schema: {
          type: "object",
          properties: {
            "sticky": {
              description: localize(181, null),
              type: "boolean",
              default: false
            }
          }
        }
      }]
    }
  }));
  class LineEndCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, this.e(viewModel, viewModel.getCursorStates()));
      viewModel.revealAllCursors(args2.source, true);
    }
    e(viewModel, cursors) {
      const result = [];
      for (let i = 0, len = cursors.length; i < len; i++) {
        const cursor = cursors[i];
        const lineNumber = cursor.modelState.position.lineNumber;
        const maxColumn = viewModel.model.getLineMaxColumn(lineNumber);
        result[i] = $k1.fromModelState(cursor.modelState.move(this.d, lineNumber, maxColumn, 0));
      }
      return result;
    }
  }
  CoreNavigationCommands2.CursorLineEnd = $01(new LineEndCommand({
    inSelectionMode: false,
    id: "cursorLineEnd",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 0,
      mac: {
        primary: 256 | 35
        /* KeyCode.KeyE */
      }
    }
  }));
  CoreNavigationCommands2.CursorLineEndSelect = $01(new LineEndCommand({
    inSelectionMode: true,
    id: "cursorLineEndSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 0,
      mac: {
        primary: 256 | 1024 | 35
        /* KeyCode.KeyE */
      }
    }
  }));
  class TopCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, $s2.moveToBeginningOfBuffer(viewModel, viewModel.getCursorStates(), this.d));
      viewModel.revealAllCursors(args2.source, true);
    }
  }
  CoreNavigationCommands2.CursorTop = $01(new TopCommand({
    inSelectionMode: false,
    id: "cursorTop",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 14,
      mac: {
        primary: 2048 | 16
        /* KeyCode.UpArrow */
      }
    }
  }));
  CoreNavigationCommands2.CursorTopSelect = $01(new TopCommand({
    inSelectionMode: true,
    id: "cursorTopSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 1024 | 14,
      mac: {
        primary: 2048 | 1024 | 16
        /* KeyCode.UpArrow */
      }
    }
  }));
  class BottomCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, $s2.moveToEndOfBuffer(viewModel, viewModel.getCursorStates(), this.d));
      viewModel.revealAllCursors(args2.source, true);
    }
  }
  CoreNavigationCommands2.CursorBottom = $01(new BottomCommand({
    inSelectionMode: false,
    id: "cursorBottom",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 13,
      mac: {
        primary: 2048 | 18
        /* KeyCode.DownArrow */
      }
    }
  }));
  CoreNavigationCommands2.CursorBottomSelect = $01(new BottomCommand({
    inSelectionMode: true,
    id: "cursorBottomSelect",
    precondition: void 0,
    kbOpts: {
      weight: CORE_WEIGHT,
      kbExpr: EditorContextKeys.textInputFocus,
      primary: 2048 | 1024 | 13,
      mac: {
        primary: 2048 | 1024 | 18
        /* KeyCode.DownArrow */
      }
    }
  }));
  class EditorScrollImpl extends $X2 {
    constructor() {
      super({
        id: "editorScroll",
        precondition: void 0,
        metadata: EditorScroll_.metadata
      });
    }
    determineScrollMethod(args2) {
      const horizontalUnits = [
        6
        /* EditorScroll_.Unit.Column */
      ];
      const verticalUnits = [
        1,
        2,
        3,
        4,
        5,
        6
        /* EditorScroll_.Unit.Column */
      ];
      const horizontalDirections = [
        4,
        2
        /* EditorScroll_.Direction.Right */
      ];
      const verticalDirections = [
        1,
        3
        /* EditorScroll_.Direction.Down */
      ];
      if (horizontalUnits.includes(args2.unit) && horizontalDirections.includes(args2.direction)) {
        return this._runHorizontalEditorScroll.bind(this);
      }
      if (verticalUnits.includes(args2.unit) && verticalDirections.includes(args2.direction)) {
        return this._runVerticalEditorScroll.bind(this);
      }
      return null;
    }
    runCoreEditorCommand(viewModel, args2) {
      const parsed = EditorScroll_.parse(args2);
      if (!parsed) {
        return;
      }
      const runEditorScroll = this.determineScrollMethod(parsed);
      if (!runEditorScroll) {
        return;
      }
      runEditorScroll(viewModel, args2.source, parsed);
    }
    _runVerticalEditorScroll(viewModel, source, args2) {
      const desiredScrollTop = this.d(viewModel, args2);
      if (args2.revealCursor) {
        const desiredVisibleViewRange = viewModel.getCompletelyVisibleViewRangeAtScrollTop(desiredScrollTop);
        viewModel.setCursorStates(source, 3, [
          $s2.findPositionInViewportIfOutside(viewModel, viewModel.getPrimaryCursorState(), desiredVisibleViewRange, args2.select)
        ]);
      }
      viewModel.viewLayout.setScrollPosition(
        { scrollTop: desiredScrollTop },
        0
        /* ScrollType.Smooth */
      );
    }
    d(viewModel, args2) {
      if (args2.unit === 1) {
        const futureViewport = viewModel.viewLayout.getFutureViewport();
        const visibleViewRange = viewModel.getCompletelyVisibleViewRangeAtScrollTop(futureViewport.top);
        const visibleModelRange = viewModel.coordinatesConverter.convertViewRangeToModelRange(visibleViewRange);
        let desiredTopModelLineNumber;
        if (args2.direction === 1) {
          desiredTopModelLineNumber = Math.max(1, visibleModelRange.startLineNumber - args2.value);
        } else {
          desiredTopModelLineNumber = Math.min(viewModel.model.getLineCount(), visibleModelRange.startLineNumber + args2.value);
        }
        const viewPosition = viewModel.coordinatesConverter.convertModelPositionToViewPosition(new $_t(desiredTopModelLineNumber, 1));
        return viewModel.viewLayout.getVerticalOffsetForLineNumber(viewPosition.lineNumber);
      }
      if (args2.unit === 5) {
        let desiredTopModelLineNumber = 0;
        if (args2.direction === 3) {
          desiredTopModelLineNumber = viewModel.model.getLineCount() - viewModel.cursorConfig.pageSize;
        }
        return viewModel.viewLayout.getVerticalOffsetForLineNumber(desiredTopModelLineNumber);
      }
      let noOfLines;
      if (args2.unit === 3) {
        noOfLines = viewModel.cursorConfig.pageSize * args2.value;
      } else if (args2.unit === 4) {
        noOfLines = Math.round(viewModel.cursorConfig.pageSize / 2) * args2.value;
      } else {
        noOfLines = args2.value;
      }
      const deltaLines = (args2.direction === 1 ? -1 : 1) * noOfLines;
      return viewModel.viewLayout.getCurrentScrollTop() + deltaLines * viewModel.cursorConfig.lineHeight;
    }
    _runHorizontalEditorScroll(viewModel, source, args2) {
      const desiredScrollLeft = this._computeDesiredScrollLeft(viewModel, args2);
      viewModel.viewLayout.setScrollPosition(
        { scrollLeft: desiredScrollLeft },
        0
        /* ScrollType.Smooth */
      );
    }
    _computeDesiredScrollLeft(viewModel, args2) {
      const deltaColumns = (args2.direction === 4 ? -1 : 1) * args2.value;
      return viewModel.viewLayout.getCurrentScrollLeft() + deltaColumns * viewModel.cursorConfig.typicalHalfwidthCharacterWidth;
    }
  }
  CoreNavigationCommands2.EditorScrollImpl = EditorScrollImpl;
  CoreNavigationCommands2.EditorScroll = $01(new EditorScrollImpl());
  CoreNavigationCommands2.ScrollLineUp = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollLineUp",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 2048 | 16,
          mac: {
            primary: 256 | 11
            /* KeyCode.PageUp */
          }
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Up,
        by: EditorScroll_.RawUnit.WrappedLine,
        value: 1,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  CoreNavigationCommands2.ScrollPageUp = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollPageUp",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 2048 | 11,
          win: {
            primary: 512 | 11
            /* KeyCode.PageUp */
          },
          linux: {
            primary: 512 | 11
            /* KeyCode.PageUp */
          }
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Up,
        by: EditorScroll_.RawUnit.Page,
        value: 1,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  CoreNavigationCommands2.ScrollEditorTop = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollEditorTop",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Up,
        by: EditorScroll_.RawUnit.Editor,
        value: 1,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  CoreNavigationCommands2.ScrollLineDown = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollLineDown",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 2048 | 18,
          mac: {
            primary: 256 | 12
            /* KeyCode.PageDown */
          }
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Down,
        by: EditorScroll_.RawUnit.WrappedLine,
        value: 1,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  CoreNavigationCommands2.ScrollPageDown = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollPageDown",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 2048 | 12,
          win: {
            primary: 512 | 12
            /* KeyCode.PageDown */
          },
          linux: {
            primary: 512 | 12
            /* KeyCode.PageDown */
          }
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Down,
        by: EditorScroll_.RawUnit.Page,
        value: 1,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  CoreNavigationCommands2.ScrollEditorBottom = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollEditorBottom",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Down,
        by: EditorScroll_.RawUnit.Editor,
        value: 1,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  CoreNavigationCommands2.ScrollLeft = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollLeft",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Left,
        by: EditorScroll_.RawUnit.Column,
        value: 2,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  CoreNavigationCommands2.ScrollRight = $01(new class extends $X2 {
    constructor() {
      super({
        id: "scrollRight",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      CoreNavigationCommands2.EditorScroll.runCoreEditorCommand(viewModel, {
        to: EditorScroll_.RawDirection.Right,
        by: EditorScroll_.RawUnit.Column,
        value: 2,
        revealCursor: false,
        select: false,
        source: args2.source
      });
    }
  }());
  class WordCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.position) {
        return;
      }
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, [
        $s2.word(viewModel, viewModel.getPrimaryCursorState(), this.d, args2.position)
      ]);
      if (args2.revealType !== 2) {
        viewModel.revealAllCursors(args2.source, true, true);
      }
    }
  }
  CoreNavigationCommands2.WordSelect = $01(new WordCommand({
    inSelectionMode: false,
    id: "_wordSelect",
    precondition: void 0
  }));
  CoreNavigationCommands2.WordSelectDrag = $01(new WordCommand({
    inSelectionMode: true,
    id: "_wordSelectDrag",
    precondition: void 0
  }));
  CoreNavigationCommands2.LastCursorWordSelect = $01(new class extends $X2 {
    constructor() {
      super({
        id: "lastCursorWordSelect",
        precondition: void 0
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.position) {
        return;
      }
      const lastAddedCursorIndex = viewModel.getLastAddedCursorIndex();
      const states = viewModel.getCursorStates();
      const newStates = states.slice(0);
      const lastAddedState = states[lastAddedCursorIndex];
      newStates[lastAddedCursorIndex] = $s2.word(viewModel, lastAddedState, lastAddedState.modelState.hasSelection(), args2.position);
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, newStates);
    }
  }());
  class LineCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.position) {
        return;
      }
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, [
        $s2.line(viewModel, viewModel.getPrimaryCursorState(), this.d, args2.position, args2.viewPosition)
      ]);
      if (args2.revealType !== 2) {
        viewModel.revealAllCursors(args2.source, false, true);
      }
    }
  }
  CoreNavigationCommands2.LineSelect = $01(new LineCommand({
    inSelectionMode: false,
    id: "_lineSelect",
    precondition: void 0
  }));
  CoreNavigationCommands2.LineSelectDrag = $01(new LineCommand({
    inSelectionMode: true,
    id: "_lineSelectDrag",
    precondition: void 0
  }));
  class LastCursorLineCommand extends $X2 {
    constructor(opts) {
      super(opts);
      this.d = opts.inSelectionMode;
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.position) {
        return;
      }
      const lastAddedCursorIndex = viewModel.getLastAddedCursorIndex();
      const states = viewModel.getCursorStates();
      const newStates = states.slice(0);
      newStates[lastAddedCursorIndex] = $s2.line(viewModel, states[lastAddedCursorIndex], this.d, args2.position, args2.viewPosition);
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, newStates);
    }
  }
  CoreNavigationCommands2.LastCursorLineSelect = $01(new LastCursorLineCommand({
    inSelectionMode: false,
    id: "lastCursorLineSelect",
    precondition: void 0
  }));
  CoreNavigationCommands2.LastCursorLineSelectDrag = $01(new LastCursorLineCommand({
    inSelectionMode: true,
    id: "lastCursorLineSelectDrag",
    precondition: void 0
  }));
  CoreNavigationCommands2.CancelSelection = $01(new class extends $X2 {
    constructor() {
      super({
        id: "cancelSelection",
        precondition: EditorContextKeys.hasNonEmptySelection,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 9,
          secondary: [
            1024 | 9
            /* KeyCode.Escape */
          ]
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, [
        $s2.cancelSelection(viewModel, viewModel.getPrimaryCursorState())
      ]);
      viewModel.revealAllCursors(args2.source, true);
    }
  }());
  CoreNavigationCommands2.RemoveSecondaryCursors = $01(new class extends $X2 {
    constructor() {
      super({
        id: "removeSecondaryCursors",
        precondition: EditorContextKeys.hasMultipleSelections,
        kbOpts: {
          weight: CORE_WEIGHT + 1,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 9,
          secondary: [
            1024 | 9
            /* KeyCode.Escape */
          ]
        }
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, [
        viewModel.getPrimaryCursorState()
      ]);
      viewModel.revealAllCursors(args2.source, true);
      $ZV(localize(182, null));
    }
  }());
  CoreNavigationCommands2.RevealLine = $01(new class extends $X2 {
    constructor() {
      super({
        id: "revealLine",
        precondition: void 0,
        metadata: RevealLine_.metadata
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      const revealLineArg = args2;
      const lineNumberArg = revealLineArg.lineNumber || 0;
      let lineNumber = typeof lineNumberArg === "number" ? lineNumberArg + 1 : parseInt(lineNumberArg) + 1;
      if (lineNumber < 1) {
        lineNumber = 1;
      }
      const lineCount = viewModel.model.getLineCount();
      if (lineNumber > lineCount) {
        lineNumber = lineCount;
      }
      const range2 = new $au(lineNumber, 1, lineNumber, viewModel.model.getLineMaxColumn(lineNumber));
      let revealAt = 0;
      if (revealLineArg.at) {
        switch (revealLineArg.at) {
          case RevealLine_.RawAtArgument.Top:
            revealAt = 3;
            break;
          case RevealLine_.RawAtArgument.Center:
            revealAt = 1;
            break;
          case RevealLine_.RawAtArgument.Bottom:
            revealAt = 4;
            break;
          default:
            break;
        }
      }
      const viewRange = viewModel.coordinatesConverter.convertModelRangeToViewRange(range2);
      viewModel.revealRange(
        args2.source,
        false,
        viewRange,
        revealAt,
        0
        /* ScrollType.Smooth */
      );
    }
  }());
  CoreNavigationCommands2.SelectAll = new class extends EditorOrNativeTextInputCommand {
    constructor() {
      super($f2);
    }
    runDOMCommand(activeElement) {
      if ($mT) {
        activeElement.focus();
        activeElement.select();
      }
      activeElement.ownerDocument.execCommand("selectAll");
    }
    runEditorCommand(accessor, editor, args2) {
      const viewModel = editor._getViewModel();
      if (!viewModel) {
        return;
      }
      this.runCoreEditorCommand(viewModel, args2);
    }
    runCoreEditorCommand(viewModel, args2) {
      viewModel.model.pushStackElement();
      viewModel.setCursorStates("keyboard", 3, [
        $s2.selectAll(viewModel, viewModel.getPrimaryCursorState())
      ]);
    }
  }();
  CoreNavigationCommands2.SetSelection = $01(new class extends $X2 {
    constructor() {
      super({
        id: "setSelection",
        precondition: void 0
      });
    }
    runCoreEditorCommand(viewModel, args2) {
      if (!args2.selection) {
        return;
      }
      viewModel.model.pushStackElement();
      viewModel.setCursorStates(args2.source, 3, [
        $k1.fromModelSelection(args2.selection)
      ]);
    }
  }());
})(CoreNavigationCommands || (CoreNavigationCommands = {}));
var columnSelectionCondition = $Xj.and(EditorContextKeys.textInputFocus, EditorContextKeys.columnSelection);
function registerColumnSelection(id2, keybinding) {
  $WE.registerKeybindingRule({
    id: id2,
    primary: keybinding,
    when: columnSelectionCondition,
    weight: CORE_WEIGHT + 1
  });
}
registerColumnSelection(
  CoreNavigationCommands.CursorColumnSelectLeft.id,
  1024 | 15
  /* KeyCode.LeftArrow */
);
registerColumnSelection(
  CoreNavigationCommands.CursorColumnSelectRight.id,
  1024 | 17
  /* KeyCode.RightArrow */
);
registerColumnSelection(
  CoreNavigationCommands.CursorColumnSelectUp.id,
  1024 | 16
  /* KeyCode.UpArrow */
);
registerColumnSelection(
  CoreNavigationCommands.CursorColumnSelectPageUp.id,
  1024 | 11
  /* KeyCode.PageUp */
);
registerColumnSelection(
  CoreNavigationCommands.CursorColumnSelectDown.id,
  1024 | 18
  /* KeyCode.DownArrow */
);
registerColumnSelection(
  CoreNavigationCommands.CursorColumnSelectPageDown.id,
  1024 | 12
  /* KeyCode.PageDown */
);
function registerCommand2(command4) {
  command4.register();
  return command4;
}
var CoreEditingCommands;
(function(CoreEditingCommands2) {
  class CoreEditingCommand extends $51 {
    runEditorCommand(accessor, editor, args2) {
      const viewModel = editor._getViewModel();
      if (!viewModel) {
        return;
      }
      this.runCoreEditingCommand(editor, viewModel, args2 || {});
    }
  }
  CoreEditingCommands2.CoreEditingCommand = CoreEditingCommand;
  CoreEditingCommands2.LineBreakInsert = $01(new class extends CoreEditingCommand {
    constructor() {
      super({
        id: "lineBreakInsert",
        precondition: EditorContextKeys.writable,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 0,
          mac: {
            primary: 256 | 45
            /* KeyCode.KeyO */
          }
        }
      });
    }
    runCoreEditingCommand(editor, viewModel, args2) {
      editor.pushUndoStop();
      editor.executeCommands(this.id, $M2.lineBreakInsert(viewModel.cursorConfig, viewModel.model, viewModel.getCursorStates().map((s) => s.modelState.selection)));
    }
  }());
  CoreEditingCommands2.Outdent = $01(new class extends CoreEditingCommand {
    constructor() {
      super({
        id: "outdent",
        precondition: EditorContextKeys.writable,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: $Xj.and(EditorContextKeys.editorTextFocus, EditorContextKeys.tabDoesNotMoveFocus),
          primary: 1024 | 2
          /* KeyCode.Tab */
        }
      });
    }
    runCoreEditingCommand(editor, viewModel, args2) {
      editor.pushUndoStop();
      editor.executeCommands(this.id, $V2.outdent(viewModel.cursorConfig, viewModel.model, viewModel.getCursorStates().map((s) => s.modelState.selection)));
      editor.pushUndoStop();
    }
  }());
  CoreEditingCommands2.Tab = $01(new class extends CoreEditingCommand {
    constructor() {
      super({
        id: "tab",
        precondition: EditorContextKeys.writable,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: $Xj.and(EditorContextKeys.editorTextFocus, EditorContextKeys.tabDoesNotMoveFocus),
          primary: 2
          /* KeyCode.Tab */
        }
      });
    }
    runCoreEditingCommand(editor, viewModel, args2) {
      editor.pushUndoStop();
      editor.executeCommands(this.id, $V2.tab(viewModel.cursorConfig, viewModel.model, viewModel.getCursorStates().map((s) => s.modelState.selection)));
      editor.pushUndoStop();
    }
  }());
  CoreEditingCommands2.DeleteLeft = $01(new class extends CoreEditingCommand {
    constructor() {
      super({
        id: "deleteLeft",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 1,
          secondary: [
            1024 | 1
            /* KeyCode.Backspace */
          ],
          mac: { primary: 1, secondary: [
            1024 | 1,
            256 | 38,
            256 | 1
            /* KeyCode.Backspace */
          ] }
        }
      });
    }
    runCoreEditingCommand(editor, viewModel, args2) {
      const [shouldPushStackElementBefore, commands] = $p2.deleteLeft(viewModel.getPrevEditOperationType(), viewModel.cursorConfig, viewModel.model, viewModel.getCursorStates().map((s) => s.modelState.selection), viewModel.getCursorAutoClosedCharacters());
      if (shouldPushStackElementBefore) {
        editor.pushUndoStop();
      }
      editor.executeCommands(this.id, commands);
      viewModel.setPrevEditOperationType(
        2
        /* EditOperationType.DeletingLeft */
      );
    }
  }());
  CoreEditingCommands2.DeleteRight = $01(new class extends CoreEditingCommand {
    constructor() {
      super({
        id: "deleteRight",
        precondition: void 0,
        kbOpts: {
          weight: CORE_WEIGHT,
          kbExpr: EditorContextKeys.textInputFocus,
          primary: 20,
          mac: { primary: 20, secondary: [
            256 | 34,
            256 | 20
            /* KeyCode.Delete */
          ] }
        }
      });
    }
    runCoreEditingCommand(editor, viewModel, args2) {
      const [shouldPushStackElementBefore, commands] = $p2.deleteRight(viewModel.getPrevEditOperationType(), viewModel.cursorConfig, viewModel.model, viewModel.getCursorStates().map((s) => s.modelState.selection));
      if (shouldPushStackElementBefore) {
        editor.pushUndoStop();
      }
      editor.executeCommands(this.id, commands);
      viewModel.setPrevEditOperationType(
        3
        /* EditOperationType.DeletingRight */
      );
    }
  }());
  CoreEditingCommands2.Undo = new class extends EditorOrNativeTextInputCommand {
    constructor() {
      super($d2);
    }
    runDOMCommand(activeElement) {
      activeElement.ownerDocument.execCommand("undo");
    }
    runEditorCommand(accessor, editor, args2) {
      if (!editor.hasModel() || editor.getOption(
        94
        /* EditorOption.readOnly */
      ) === true) {
        return;
      }
      return editor.getModel().undo();
    }
  }();
  CoreEditingCommands2.Redo = new class extends EditorOrNativeTextInputCommand {
    constructor() {
      super($e2);
    }
    runDOMCommand(activeElement) {
      activeElement.ownerDocument.execCommand("redo");
    }
    runEditorCommand(accessor, editor, args2) {
      if (!editor.hasModel() || editor.getOption(
        94
        /* EditorOption.readOnly */
      ) === true) {
        return;
      }
      return editor.getModel().redo();
    }
  }();
})(CoreEditingCommands || (CoreEditingCommands = {}));
var EditorHandlerCommand = class extends $21 {
  constructor(id2, handlerId, metadata) {
    super({
      id: id2,
      precondition: void 0,
      metadata
    });
    this.d = handlerId;
  }
  runCommand(accessor, args2) {
    const editor = accessor.get($11).getFocusedCodeEditor();
    if (!editor) {
      return;
    }
    editor.trigger("keyboard", this.d, args2);
  }
};
function registerOverwritableCommand(handlerId, metadata) {
  registerCommand2(new EditorHandlerCommand("default:" + handlerId, handlerId));
  registerCommand2(new EditorHandlerCommand(handlerId, handlerId, metadata));
}
registerOverwritableCommand("type", {
  description: `Type`,
  args: [{
    name: "args",
    schema: {
      "type": "object",
      "required": ["text"],
      "properties": {
        "text": {
          "type": "string"
        }
      }
    }
  }]
});
registerOverwritableCommand(
  "replacePreviousChar"
  /* Handler.ReplacePreviousChar */
);
registerOverwritableCommand(
  "compositionType"
  /* Handler.CompositionType */
);
registerOverwritableCommand(
  "compositionStart"
  /* Handler.CompositionStart */
);
registerOverwritableCommand(
  "compositionEnd"
  /* Handler.CompositionEnd */
);
registerOverwritableCommand(
  "paste"
  /* Handler.Paste */
);
registerOverwritableCommand(
  "cut"
  /* Handler.Cut */
);

// out-build/vs/editor/common/services/markerDecorations.js
var $Y2 = $Zi("markerDecorationsService");

// out-build/vs/editor/browser/services/markerDecorations.js
var $Z2 = class $Z22 {
  static {
    this.ID = "editor.contrib.markerDecorations";
  }
  constructor(_editor, _markerDecorationsService) {
  }
  dispose() {
  }
};
$Z2 = __decorate([
  __param(1, $Y2)
], $Z2);
$b2(
  $Z2.ID,
  $Z2,
  0
  /* EditorContributionInstantiation.Eager */
);

// out-build/vs/base/browser/fastDomNode.js
var $qV = class {
  constructor(domNode) {
    this.domNode = domNode;
    this.a = "";
    this.b = "";
    this.c = "";
    this.d = "";
    this.e = "";
    this.f = "";
    this.g = "";
    this.h = "";
    this.i = "";
    this.j = "";
    this.k = "";
    this.l = "";
    this.m = "";
    this.n = "";
    this.o = "";
    this.p = "";
    this.q = "";
    this.r = "";
    this.s = "";
    this.t = "";
    this.u = "";
    this.v = "";
    this.w = "";
    this.x = "";
    this.y = "";
    this.z = "";
    this.A = false;
    this.B = "none";
    this.C = "";
  }
  setMaxWidth(_maxWidth) {
    const maxWidth = numberAsPixels(_maxWidth);
    if (this.a === maxWidth) {
      return;
    }
    this.a = maxWidth;
    this.domNode.style.maxWidth = this.a;
  }
  setWidth(_width) {
    const width2 = numberAsPixels(_width);
    if (this.b === width2) {
      return;
    }
    this.b = width2;
    this.domNode.style.width = this.b;
  }
  setHeight(_height) {
    const height = numberAsPixels(_height);
    if (this.c === height) {
      return;
    }
    this.c = height;
    this.domNode.style.height = this.c;
  }
  setTop(_top) {
    const top2 = numberAsPixels(_top);
    if (this.d === top2) {
      return;
    }
    this.d = top2;
    this.domNode.style.top = this.d;
  }
  setLeft(_left) {
    const left = numberAsPixels(_left);
    if (this.e === left) {
      return;
    }
    this.e = left;
    this.domNode.style.left = this.e;
  }
  setBottom(_bottom) {
    const bottom = numberAsPixels(_bottom);
    if (this.f === bottom) {
      return;
    }
    this.f = bottom;
    this.domNode.style.bottom = this.f;
  }
  setRight(_right) {
    const right = numberAsPixels(_right);
    if (this.g === right) {
      return;
    }
    this.g = right;
    this.domNode.style.right = this.g;
  }
  setPaddingTop(_paddingTop) {
    const paddingTop = numberAsPixels(_paddingTop);
    if (this.h === paddingTop) {
      return;
    }
    this.h = paddingTop;
    this.domNode.style.paddingTop = this.h;
  }
  setPaddingLeft(_paddingLeft) {
    const paddingLeft = numberAsPixels(_paddingLeft);
    if (this.i === paddingLeft) {
      return;
    }
    this.i = paddingLeft;
    this.domNode.style.paddingLeft = this.i;
  }
  setPaddingBottom(_paddingBottom) {
    const paddingBottom = numberAsPixels(_paddingBottom);
    if (this.j === paddingBottom) {
      return;
    }
    this.j = paddingBottom;
    this.domNode.style.paddingBottom = this.j;
  }
  setPaddingRight(_paddingRight) {
    const paddingRight = numberAsPixels(_paddingRight);
    if (this.k === paddingRight) {
      return;
    }
    this.k = paddingRight;
    this.domNode.style.paddingRight = this.k;
  }
  setFontFamily(fontFamily) {
    if (this.l === fontFamily) {
      return;
    }
    this.l = fontFamily;
    this.domNode.style.fontFamily = this.l;
  }
  setFontWeight(fontWeight) {
    if (this.m === fontWeight) {
      return;
    }
    this.m = fontWeight;
    this.domNode.style.fontWeight = this.m;
  }
  setFontSize(_fontSize) {
    const fontSize = numberAsPixels(_fontSize);
    if (this.n === fontSize) {
      return;
    }
    this.n = fontSize;
    this.domNode.style.fontSize = this.n;
  }
  setFontStyle(fontStyle) {
    if (this.o === fontStyle) {
      return;
    }
    this.o = fontStyle;
    this.domNode.style.fontStyle = this.o;
  }
  setFontFeatureSettings(fontFeatureSettings) {
    if (this.p === fontFeatureSettings) {
      return;
    }
    this.p = fontFeatureSettings;
    this.domNode.style.fontFeatureSettings = this.p;
  }
  setFontVariationSettings(fontVariationSettings) {
    if (this.q === fontVariationSettings) {
      return;
    }
    this.q = fontVariationSettings;
    this.domNode.style.fontVariationSettings = this.q;
  }
  setTextDecoration(textDecoration) {
    if (this.r === textDecoration) {
      return;
    }
    this.r = textDecoration;
    this.domNode.style.textDecoration = this.r;
  }
  setLineHeight(_lineHeight) {
    const lineHeight = numberAsPixels(_lineHeight);
    if (this.s === lineHeight) {
      return;
    }
    this.s = lineHeight;
    this.domNode.style.lineHeight = this.s;
  }
  setLetterSpacing(_letterSpacing) {
    const letterSpacing = numberAsPixels(_letterSpacing);
    if (this.t === letterSpacing) {
      return;
    }
    this.t = letterSpacing;
    this.domNode.style.letterSpacing = this.t;
  }
  setClassName(className) {
    if (this.u === className) {
      return;
    }
    this.u = className;
    this.domNode.className = this.u;
  }
  toggleClassName(className, shouldHaveIt) {
    this.domNode.classList.toggle(className, shouldHaveIt);
    this.u = this.domNode.className;
  }
  setDisplay(display) {
    if (this.v === display) {
      return;
    }
    this.v = display;
    this.domNode.style.display = this.v;
  }
  setPosition(position) {
    if (this.w === position) {
      return;
    }
    this.w = position;
    this.domNode.style.position = this.w;
  }
  setVisibility(visibility) {
    if (this.x === visibility) {
      return;
    }
    this.x = visibility;
    this.domNode.style.visibility = this.x;
  }
  setColor(color2) {
    if (this.y === color2) {
      return;
    }
    this.y = color2;
    this.domNode.style.color = this.y;
  }
  setBackgroundColor(backgroundColor) {
    if (this.z === backgroundColor) {
      return;
    }
    this.z = backgroundColor;
    this.domNode.style.backgroundColor = this.z;
  }
  setLayerHinting(layerHint) {
    if (this.A === layerHint) {
      return;
    }
    this.A = layerHint;
    this.domNode.style.transform = this.A ? "translate3d(0px, 0px, 0px)" : "";
  }
  setBoxShadow(boxShadow) {
    if (this.C === boxShadow) {
      return;
    }
    this.C = boxShadow;
    this.domNode.style.boxShadow = boxShadow;
  }
  setContain(contain) {
    if (this.B === contain) {
      return;
    }
    this.B = contain;
    this.domNode.style.contain = this.B;
  }
  setAttribute(name, value) {
    this.domNode.setAttribute(name, value);
  }
  removeAttribute(name) {
    this.domNode.removeAttribute(name);
  }
  appendChild(child) {
    this.domNode.appendChild(child.domNode);
  }
  removeChild(child) {
    this.domNode.removeChild(child.domNode);
  }
};
function numberAsPixels(value) {
  return typeof value === "number" ? `${value}px` : value;
}
function $rV(domNode) {
  return new $qV(domNode);
}

// out-build/vs/editor/browser/config/domFontInfo.js
function $9Z(domNode, fontInfo) {
  if (domNode instanceof $qV) {
    domNode.setFontFamily(fontInfo.getMassagedFontFamily());
    domNode.setFontWeight(fontInfo.fontWeight);
    domNode.setFontSize(fontInfo.fontSize);
    domNode.setFontFeatureSettings(fontInfo.fontFeatureSettings);
    domNode.setFontVariationSettings(fontInfo.fontVariationSettings);
    domNode.setLineHeight(fontInfo.lineHeight);
    domNode.setLetterSpacing(fontInfo.letterSpacing);
  } else {
    domNode.style.fontFamily = fontInfo.getMassagedFontFamily();
    domNode.style.fontWeight = fontInfo.fontWeight;
    domNode.style.fontSize = fontInfo.fontSize + "px";
    domNode.style.fontFeatureSettings = fontInfo.fontFeatureSettings;
    domNode.style.fontVariationSettings = fontInfo.fontVariationSettings;
    domNode.style.lineHeight = fontInfo.lineHeight + "px";
    domNode.style.letterSpacing = fontInfo.letterSpacing + "px";
  }
}

// out-build/vs/base/common/objects.js
function $zo(obj) {
  if (!obj || typeof obj !== "object") {
    return obj;
  }
  if (obj instanceof RegExp) {
    return obj;
  }
  const result = Array.isArray(obj) ? [] : {};
  Object.entries(obj).forEach(([key, value]) => {
    result[key] = value && typeof value === "object" ? $zo(value) : value;
  });
  return result;
}
function $Ao(obj) {
  if (!obj || typeof obj !== "object") {
    return obj;
  }
  const stack = [obj];
  while (stack.length > 0) {
    const obj2 = stack.shift();
    Object.freeze(obj2);
    for (const key in obj2) {
      if (_hasOwnProperty.call(obj2, key)) {
        const prop = obj2[key];
        if (typeof prop === "object" && !Object.isFrozen(prop) && !$Bg(prop)) {
          stack.push(prop);
        }
      }
    }
  }
  return obj;
}
var _hasOwnProperty = Object.prototype.hasOwnProperty;
function $Bo(obj, changer) {
  return _cloneAndChange(obj, changer, /* @__PURE__ */ new Set());
}
function _cloneAndChange(obj, changer, seen) {
  if ($Hg(obj)) {
    return obj;
  }
  const changed = changer(obj);
  if (typeof changed !== "undefined") {
    return changed;
  }
  if (Array.isArray(obj)) {
    const r1 = [];
    for (const e of obj) {
      r1.push(_cloneAndChange(e, changer, seen));
    }
    return r1;
  }
  if ($Ag(obj)) {
    if (seen.has(obj)) {
      throw new Error("Cannot clone recursive data-structure");
    }
    seen.add(obj);
    const r2 = {};
    for (const i2 in obj) {
      if (_hasOwnProperty.call(obj, i2)) {
        r2[i2] = _cloneAndChange(obj[i2], changer, seen);
      }
    }
    seen.delete(obj);
    return r2;
  }
  return obj;
}
function $Co(destination, source, overwrite = true) {
  if (!$Ag(destination)) {
    return source;
  }
  if ($Ag(source)) {
    Object.keys(source).forEach((key) => {
      if (key in destination) {
        if (overwrite) {
          if ($Ag(destination[key]) && $Ag(source[key])) {
            $Co(destination[key], source[key], overwrite);
          } else {
            destination[key] = source[key];
          }
        }
      } else {
        destination[key] = source[key];
      }
    });
  }
  return destination;
}
function $Do(one, other4) {
  if (one === other4) {
    return true;
  }
  if (one === null || one === void 0 || other4 === null || other4 === void 0) {
    return false;
  }
  if (typeof one !== typeof other4) {
    return false;
  }
  if (typeof one !== "object") {
    return false;
  }
  if (Array.isArray(one) !== Array.isArray(other4)) {
    return false;
  }
  let i;
  let key;
  if (Array.isArray(one)) {
    if (one.length !== other4.length) {
      return false;
    }
    for (i = 0; i < one.length; i++) {
      if (!$Do(one[i], other4[i])) {
        return false;
      }
    }
  } else {
    const oneKeys = [];
    for (key in one) {
      oneKeys.push(key);
    }
    oneKeys.sort();
    const otherKeys = [];
    for (key in other4) {
      otherKeys.push(key);
    }
    otherKeys.sort();
    if (!$Do(oneKeys, otherKeys)) {
      return false;
    }
    for (i = 0; i < oneKeys.length; i++) {
      if (!$Do(one[oneKeys[i]], other4[oneKeys[i]])) {
        return false;
      }
    }
  }
  return true;
}
function $Eo(obj) {
  const seen = /* @__PURE__ */ new Set();
  return JSON.stringify(obj, (key, value) => {
    if ($Ag(value) || Array.isArray(value)) {
      if (seen.has(value)) {
        return "[Circular]";
      } else {
        seen.add(value);
      }
    }
    if (typeof value === "bigint") {
      return `[BigInt ${value.toString()}]`;
    }
    return value;
  });
}
function $Fo(base, target) {
  const result = /* @__PURE__ */ Object.create(null);
  if (!base || !target) {
    return result;
  }
  const targetKeys = Object.keys(target);
  targetKeys.forEach((k) => {
    const baseValue = base[k];
    const targetValue = target[k];
    if (!$Do(baseValue, targetValue)) {
      result[k] = targetValue;
    }
  });
  return result;
}
function $Ho(obj, predicate) {
  const result = /* @__PURE__ */ Object.create(null);
  for (const [key, value] of Object.entries(obj)) {
    if (predicate(key, value)) {
      result[key] = value;
    }
  }
  return result;
}
function $Io(obj) {
  let res = [];
  while (Object.prototype !== obj) {
    res = res.concat(Object.getOwnPropertyNames(obj));
    obj = Object.getPrototypeOf(obj);
  }
  return res;
}
function $Jo(obj) {
  const methods = [];
  for (const prop of $Io(obj)) {
    if (typeof obj[prop] === "function") {
      methods.push(prop);
    }
  }
  return methods;
}
function $Ko(methodNames, invoke) {
  const createProxyMethod = (method) => {
    return function() {
      const args2 = Array.prototype.slice.call(arguments, 0);
      return invoke(method, args2);
    };
  };
  const result = {};
  for (const methodName of methodNames) {
    result[methodName] = createProxyMethod(methodName);
  }
  return result;
}
function $Lo(obj, fn) {
  const result = {};
  for (const [key, value] of Object.entries(obj)) {
    result[key] = fn(value, key);
  }
  return result;
}

// out-build/vs/editor/browser/config/elementSizeObserver.js
var $8Z = class extends $0c {
  constructor(referenceDomElement, dimension) {
    super();
    this.a = this.B(new $De());
    this.onDidChange = this.a.event;
    this.b = referenceDomElement;
    this.c = -1;
    this.f = -1;
    this.g = null;
    this.h(false, dimension);
  }
  dispose() {
    this.stopObserving();
    super.dispose();
  }
  getWidth() {
    return this.c;
  }
  getHeight() {
    return this.f;
  }
  startObserving() {
    if (!this.g && this.b) {
      let observedDimenstion = null;
      const observeNow = () => {
        if (observedDimenstion) {
          this.observe({ width: observedDimenstion.width, height: observedDimenstion.height });
        } else {
          this.observe();
        }
      };
      let shouldObserve = false;
      let alreadyObservedThisAnimationFrame = false;
      const update = () => {
        if (shouldObserve && !alreadyObservedThisAnimationFrame) {
          try {
            shouldObserve = false;
            alreadyObservedThisAnimationFrame = true;
            observeNow();
          } finally {
            $RT(getWindow(this.b), () => {
              alreadyObservedThisAnimationFrame = false;
              update();
            });
          }
        }
      };
      this.g = new ResizeObserver((entries2) => {
        if (entries2 && entries2[0] && entries2[0].contentRect) {
          observedDimenstion = { width: entries2[0].contentRect.width, height: entries2[0].contentRect.height };
        } else {
          observedDimenstion = null;
        }
        shouldObserve = true;
        update();
      });
      this.g.observe(this.b);
    }
  }
  stopObserving() {
    if (this.g) {
      this.g.disconnect();
      this.g = null;
    }
  }
  observe(dimension) {
    this.h(true, dimension);
  }
  h(emitEvent, dimension) {
    let observedWidth = 0;
    let observedHeight = 0;
    if (dimension) {
      observedWidth = dimension.width;
      observedHeight = dimension.height;
    } else if (this.b) {
      observedWidth = this.b.clientWidth;
      observedHeight = this.b.clientHeight;
    }
    observedWidth = Math.max(5, observedWidth);
    observedHeight = Math.max(5, observedHeight);
    if (this.c !== observedWidth || this.f !== observedHeight) {
      this.c = observedWidth;
      this.f = observedHeight;
      if (emitEvent) {
        this.a.fire();
      }
    }
  }
};

// out-build/vs/base/browser/pixelRatio.js
var DevicePixelRatioMonitor = class extends $0c {
  constructor(targetWindow) {
    super();
    this.a = this.B(new $De());
    this.onDidChange = this.a.event;
    this.b = () => this.f(targetWindow, true);
    this.c = null;
    this.f(targetWindow, false);
  }
  f(targetWindow, fireEvent) {
    this.c?.removeEventListener("change", this.b);
    this.c = targetWindow.matchMedia(`(resolution: ${targetWindow.devicePixelRatio}dppx)`);
    this.c.addEventListener("change", this.b);
    if (fireEvent) {
      this.a.fire();
    }
  }
};
var PixelRatioMonitorImpl = class extends $0c {
  get value() {
    return this.b;
  }
  constructor(targetWindow) {
    super();
    this.a = this.B(new $De());
    this.onDidChange = this.a.event;
    this.b = this.c(targetWindow);
    const dprMonitor = this.B(new DevicePixelRatioMonitor(targetWindow));
    this.B(dprMonitor.onDidChange(() => {
      this.b = this.c(targetWindow);
      this.a.fire(this.b);
    }));
  }
  c(targetWindow) {
    const ctx = document.createElement("canvas").getContext("2d");
    const dpr = targetWindow.devicePixelRatio || 1;
    const bsr = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
    return dpr / bsr;
  }
};
var PixelRatioMonitorFacade = class {
  constructor() {
    this.a = /* @__PURE__ */ new Map();
  }
  b(targetWindow) {
    const targetWindowId = getWindowId(targetWindow);
    let pixelRatioMonitor = this.a.get(targetWindowId);
    if (!pixelRatioMonitor) {
      pixelRatioMonitor = $3c(new PixelRatioMonitorImpl(targetWindow));
      this.a.set(targetWindowId, pixelRatioMonitor);
      $3c(Event2.once(onDidUnregisterWindow)(({ vscodeWindowId }) => {
        if (vscodeWindowId === targetWindowId) {
          pixelRatioMonitor?.dispose();
          this.a.delete(targetWindowId);
        }
      }));
    }
    return pixelRatioMonitor;
  }
  getInstance(targetWindow) {
    return this.b(targetWindow);
  }
};
var $1W = new PixelRatioMonitorFacade();

// out-build/vs/editor/browser/config/charWidthReader.js
var CharWidthRequestType;
(function(CharWidthRequestType2) {
  CharWidthRequestType2[CharWidthRequestType2["Regular"] = 0] = "Regular";
  CharWidthRequestType2[CharWidthRequestType2["Italic"] = 1] = "Italic";
  CharWidthRequestType2[CharWidthRequestType2["Bold"] = 2] = "Bold";
})(CharWidthRequestType || (CharWidthRequestType = {}));
var $0Z = class {
  constructor(chr, type) {
    this.chr = chr;
    this.type = type;
    this.width = 0;
  }
  fulfill(width2) {
    this.width = width2;
  }
};
var DomCharWidthReader = class _DomCharWidthReader {
  constructor(bareFontInfo, requests) {
    this.a = bareFontInfo;
    this.b = requests;
    this.c = null;
    this.d = null;
  }
  read(targetWindow) {
    this.e();
    targetWindow.document.body.appendChild(this.c);
    this.g();
    this.c?.remove();
    this.c = null;
    this.d = null;
  }
  e() {
    const container3 = document.createElement("div");
    container3.style.position = "absolute";
    container3.style.top = "-50000px";
    container3.style.width = "50000px";
    const regularDomNode = document.createElement("div");
    $9Z(regularDomNode, this.a);
    container3.appendChild(regularDomNode);
    const boldDomNode = document.createElement("div");
    $9Z(boldDomNode, this.a);
    boldDomNode.style.fontWeight = "bold";
    container3.appendChild(boldDomNode);
    const italicDomNode = document.createElement("div");
    $9Z(italicDomNode, this.a);
    italicDomNode.style.fontStyle = "italic";
    container3.appendChild(italicDomNode);
    const testElements = [];
    for (const request of this.b) {
      let parent;
      if (request.type === 0) {
        parent = regularDomNode;
      }
      if (request.type === 2) {
        parent = boldDomNode;
      }
      if (request.type === 1) {
        parent = italicDomNode;
      }
      parent.appendChild(document.createElement("br"));
      const testElement = document.createElement("span");
      _DomCharWidthReader.f(testElement, request);
      parent.appendChild(testElement);
      testElements.push(testElement);
    }
    this.c = container3;
    this.d = testElements;
  }
  static f(testElement, request) {
    if (request.chr === " ") {
      let htmlString = "\xA0";
      for (let i = 0; i < 8; i++) {
        htmlString += htmlString;
      }
      testElement.innerText = htmlString;
    } else {
      let testString = request.chr;
      for (let i = 0; i < 8; i++) {
        testString += testString;
      }
      testElement.textContent = testString;
    }
  }
  g() {
    for (let i = 0, len = this.b.length; i < len; i++) {
      const request = this.b[i];
      const testElement = this.d[i];
      request.fulfill(testElement.offsetWidth / 256);
    }
  }
};
function $$Z(targetWindow, bareFontInfo, requests) {
  const reader = new DomCharWidthReader(bareFontInfo, requests);
  reader.read(targetWindow);
}

// out-build/vs/editor/common/core/textModelDefaults.js
var $Ht = {
  tabSize: 4,
  indentSize: 4,
  insertSpaces: true,
  detectIndentation: true,
  trimAutoWhitespace: true,
  largeFileOptimizations: true,
  bracketPairColorizationOptions: {
    enabled: true,
    independentColorPoolPerBracketType: false
  }
};

// out-build/vs/editor/common/config/editorOptions.js
var EditorAutoIndentStrategy;
(function(EditorAutoIndentStrategy3) {
  EditorAutoIndentStrategy3[EditorAutoIndentStrategy3["None"] = 0] = "None";
  EditorAutoIndentStrategy3[EditorAutoIndentStrategy3["Keep"] = 1] = "Keep";
  EditorAutoIndentStrategy3[EditorAutoIndentStrategy3["Brackets"] = 2] = "Brackets";
  EditorAutoIndentStrategy3[EditorAutoIndentStrategy3["Advanced"] = 3] = "Advanced";
  EditorAutoIndentStrategy3[EditorAutoIndentStrategy3["Full"] = 4] = "Full";
})(EditorAutoIndentStrategy || (EditorAutoIndentStrategy = {}));
var MINIMAP_GUTTER_WIDTH = 8;
var ConfigurationChangedEvent = class {
  /**
   * @internal
   */
  constructor(values) {
    this.c = values;
  }
  hasChanged(id2) {
    return this.c[id2];
  }
};
var ComputeOptionsMemory = class {
  constructor() {
    this.stableMinimapLayoutInput = null;
    this.stableFitMaxMinimapScale = 0;
    this.stableFitRemainingWidth = 0;
  }
};
var BaseEditorOption = class {
  constructor(id2, name, defaultValue, schema9) {
    this.id = id2;
    this.name = name;
    this.defaultValue = defaultValue;
    this.schema = schema9;
  }
  applyUpdate(value, update) {
    return applyUpdate(value, update);
  }
  compute(env2, options3, value) {
    return value;
  }
};
var ApplyUpdateResult = class {
  constructor(newValue, didChange) {
    this.newValue = newValue;
    this.didChange = didChange;
  }
};
function applyUpdate(value, update) {
  if (typeof value !== "object" || typeof update !== "object" || !value || !update) {
    return new ApplyUpdateResult(update, value !== update);
  }
  if (Array.isArray(value) || Array.isArray(update)) {
    const arrayEquals = Array.isArray(value) && Array.isArray(update) && $Hb(value, update);
    return new ApplyUpdateResult(update, !arrayEquals);
  }
  let didChange = false;
  for (const key in update) {
    if (update.hasOwnProperty(key)) {
      const result = applyUpdate(value[key], update[key]);
      if (result.didChange) {
        value[key] = result.newValue;
        didChange = true;
      }
    }
  }
  return new ApplyUpdateResult(value, didChange);
}
var ComputedEditorOption = class {
  constructor(id2) {
    this.schema = void 0;
    this.id = id2;
    this.name = "_never_";
    this.defaultValue = void 0;
  }
  applyUpdate(value, update) {
    return applyUpdate(value, update);
  }
  validate(input) {
    return this.defaultValue;
  }
};
var SimpleEditorOption = class {
  constructor(id2, name, defaultValue, schema9) {
    this.id = id2;
    this.name = name;
    this.defaultValue = defaultValue;
    this.schema = schema9;
  }
  applyUpdate(value, update) {
    return applyUpdate(value, update);
  }
  validate(input) {
    if (typeof input === "undefined") {
      return this.defaultValue;
    }
    return input;
  }
  compute(env2, options3, value) {
    return value;
  }
};
function boolean(value, defaultValue) {
  if (typeof value === "undefined") {
    return defaultValue;
  }
  if (value === "false") {
    return false;
  }
  return Boolean(value);
}
var EditorBooleanOption = class extends SimpleEditorOption {
  constructor(id2, name, defaultValue, schema9 = void 0) {
    if (typeof schema9 !== "undefined") {
      schema9.type = "boolean";
      schema9.default = defaultValue;
    }
    super(id2, name, defaultValue, schema9);
  }
  validate(input) {
    return boolean(input, this.defaultValue);
  }
};
function clampedInt(value, defaultValue, minimum, maximum) {
  if (typeof value === "undefined") {
    return defaultValue;
  }
  let r2 = parseInt(value, 10);
  if (isNaN(r2)) {
    return defaultValue;
  }
  r2 = Math.max(minimum, r2);
  r2 = Math.min(maximum, r2);
  return r2 | 0;
}
var EditorIntOption = class _EditorIntOption extends SimpleEditorOption {
  static clampedInt(value, defaultValue, minimum, maximum) {
    return clampedInt(value, defaultValue, minimum, maximum);
  }
  constructor(id2, name, defaultValue, minimum, maximum, schema9 = void 0) {
    if (typeof schema9 !== "undefined") {
      schema9.type = "integer";
      schema9.default = defaultValue;
      schema9.minimum = minimum;
      schema9.maximum = maximum;
    }
    super(id2, name, defaultValue, schema9);
    this.minimum = minimum;
    this.maximum = maximum;
  }
  validate(input) {
    return _EditorIntOption.clampedInt(input, this.defaultValue, this.minimum, this.maximum);
  }
};
function clampedFloat(value, defaultValue, minimum, maximum) {
  if (typeof value === "undefined") {
    return defaultValue;
  }
  const r2 = EditorFloatOption.float(value, defaultValue);
  return EditorFloatOption.clamp(r2, minimum, maximum);
}
var EditorFloatOption = class _EditorFloatOption extends SimpleEditorOption {
  static clamp(n, min, max) {
    if (n < min) {
      return min;
    }
    if (n > max) {
      return max;
    }
    return n;
  }
  static float(value, defaultValue) {
    if (typeof value === "number") {
      return value;
    }
    if (typeof value === "undefined") {
      return defaultValue;
    }
    const r2 = parseFloat(value);
    return isNaN(r2) ? defaultValue : r2;
  }
  constructor(id2, name, defaultValue, validationFn, schema9) {
    if (typeof schema9 !== "undefined") {
      schema9.type = "number";
      schema9.default = defaultValue;
    }
    super(id2, name, defaultValue, schema9);
    this.validationFn = validationFn;
  }
  validate(input) {
    return this.validationFn(_EditorFloatOption.float(input, this.defaultValue));
  }
};
var EditorStringOption = class _EditorStringOption extends SimpleEditorOption {
  static string(value, defaultValue) {
    if (typeof value !== "string") {
      return defaultValue;
    }
    return value;
  }
  constructor(id2, name, defaultValue, schema9 = void 0) {
    if (typeof schema9 !== "undefined") {
      schema9.type = "string";
      schema9.default = defaultValue;
    }
    super(id2, name, defaultValue, schema9);
  }
  validate(input) {
    return _EditorStringOption.string(input, this.defaultValue);
  }
};
function stringSet(value, defaultValue, allowedValues, renamedValues) {
  if (typeof value !== "string") {
    return defaultValue;
  }
  if (renamedValues && value in renamedValues) {
    return renamedValues[value];
  }
  if (allowedValues.indexOf(value) === -1) {
    return defaultValue;
  }
  return value;
}
var EditorStringEnumOption = class extends SimpleEditorOption {
  constructor(id2, name, defaultValue, allowedValues, schema9 = void 0) {
    if (typeof schema9 !== "undefined") {
      schema9.type = "string";
      schema9.enum = allowedValues;
      schema9.default = defaultValue;
    }
    super(id2, name, defaultValue, schema9);
    this.c = allowedValues;
  }
  validate(input) {
    return stringSet(input, this.defaultValue, this.c);
  }
};
var EditorEnumOption = class extends BaseEditorOption {
  constructor(id2, name, defaultValue, defaultStringValue, allowedValues, convert, schema9 = void 0) {
    if (typeof schema9 !== "undefined") {
      schema9.type = "string";
      schema9.enum = allowedValues;
      schema9.default = defaultStringValue;
    }
    super(id2, name, defaultValue, schema9);
    this.c = allowedValues;
    this.d = convert;
  }
  validate(input) {
    if (typeof input !== "string") {
      return this.defaultValue;
    }
    if (this.c.indexOf(input) === -1) {
      return this.defaultValue;
    }
    return this.d(input);
  }
};
function _autoIndentFromString(autoIndent) {
  switch (autoIndent) {
    case "none":
      return 0;
    case "keep":
      return 1;
    case "brackets":
      return 2;
    case "advanced":
      return 3;
    case "full":
      return 4;
  }
}
var EditorAccessibilitySupport = class extends BaseEditorOption {
  constructor() {
    super(2, "accessibilitySupport", 0, {
      type: "string",
      enum: ["auto", "on", "off"],
      enumDescriptions: [
        localize(306, null),
        localize(307, null),
        localize(308, null)
      ],
      default: "auto",
      tags: ["accessibility"],
      description: localize(309, null)
    });
  }
  validate(input) {
    switch (input) {
      case "auto":
        return 0;
      case "off":
        return 1;
      case "on":
        return 2;
    }
    return this.defaultValue;
  }
  compute(env2, options3, value) {
    if (value === 0) {
      return env2.accessibilitySupport;
    }
    return value;
  }
};
var EditorComments = class extends BaseEditorOption {
  constructor() {
    const defaults2 = {
      insertSpace: true,
      ignoreEmptyLines: true
    };
    super(23, "comments", defaults2, {
      "editor.comments.insertSpace": {
        type: "boolean",
        default: defaults2.insertSpace,
        description: localize(310, null)
      },
      "editor.comments.ignoreEmptyLines": {
        type: "boolean",
        default: defaults2.ignoreEmptyLines,
        description: localize(311, null)
      }
    });
  }
  validate(_input) {
    if (!_input || typeof _input !== "object") {
      return this.defaultValue;
    }
    const input = _input;
    return {
      insertSpace: boolean(input.insertSpace, this.defaultValue.insertSpace),
      ignoreEmptyLines: boolean(input.ignoreEmptyLines, this.defaultValue.ignoreEmptyLines)
    };
  }
};
var TextEditorCursorBlinkingStyle;
(function(TextEditorCursorBlinkingStyle3) {
  TextEditorCursorBlinkingStyle3[TextEditorCursorBlinkingStyle3["Hidden"] = 0] = "Hidden";
  TextEditorCursorBlinkingStyle3[TextEditorCursorBlinkingStyle3["Blink"] = 1] = "Blink";
  TextEditorCursorBlinkingStyle3[TextEditorCursorBlinkingStyle3["Smooth"] = 2] = "Smooth";
  TextEditorCursorBlinkingStyle3[TextEditorCursorBlinkingStyle3["Phase"] = 3] = "Phase";
  TextEditorCursorBlinkingStyle3[TextEditorCursorBlinkingStyle3["Expand"] = 4] = "Expand";
  TextEditorCursorBlinkingStyle3[TextEditorCursorBlinkingStyle3["Solid"] = 5] = "Solid";
})(TextEditorCursorBlinkingStyle || (TextEditorCursorBlinkingStyle = {}));
function cursorBlinkingStyleFromString(cursorBlinkingStyle) {
  switch (cursorBlinkingStyle) {
    case "blink":
      return 1;
    case "smooth":
      return 2;
    case "phase":
      return 3;
    case "expand":
      return 4;
    case "solid":
      return 5;
  }
}
var TextEditorCursorStyle;
(function(TextEditorCursorStyle3) {
  TextEditorCursorStyle3[TextEditorCursorStyle3["Line"] = 1] = "Line";
  TextEditorCursorStyle3[TextEditorCursorStyle3["Block"] = 2] = "Block";
  TextEditorCursorStyle3[TextEditorCursorStyle3["Underline"] = 3] = "Underline";
  TextEditorCursorStyle3[TextEditorCursorStyle3["LineThin"] = 4] = "LineThin";
  TextEditorCursorStyle3[TextEditorCursorStyle3["BlockOutline"] = 5] = "BlockOutline";
  TextEditorCursorStyle3[TextEditorCursorStyle3["UnderlineThin"] = 6] = "UnderlineThin";
})(TextEditorCursorStyle || (TextEditorCursorStyle = {}));
function cursorStyleToString(cursorStyle) {
  switch (cursorStyle) {
    case TextEditorCursorStyle.Line:
      return "line";
    case TextEditorCursorStyle.Block:
      return "block";
    case TextEditorCursorStyle.Underline:
      return "underline";
    case TextEditorCursorStyle.LineThin:
      return "line-thin";
    case TextEditorCursorStyle.BlockOutline:
      return "block-outline";
    case TextEditorCursorStyle.UnderlineThin:
      return "underline-thin";
  }
}
function cursorStyleFromString(cursorStyle) {
  switch (cursorStyle) {
    case "line":
      return TextEditorCursorStyle.Line;
    case "block":
      return TextEditorCursorStyle.Block;
    case "underline":
      return TextEditorCursorStyle.Underline;
    case "line-thin":
      return TextEditorCursorStyle.LineThin;
    case "block-outline":
      return TextEditorCursorStyle.BlockOutline;
    case "underline-thin":
      return TextEditorCursorStyle.UnderlineThin;
  }
}
var EditorClassName = class extends ComputedEditorOption {
  constructor() {
    super(
      145
      /* EditorOption.editorClassName */
    );
  }
  compute(env2, options3, _) {
    const classNames = ["monaco-editor"];
    if (options3.get(
      41
      /* EditorOption.extraEditorClassName */
    )) {
      classNames.push(options3.get(
        41
        /* EditorOption.extraEditorClassName */
      ));
    }
    if (env2.extraEditorClassName) {
      classNames.push(env2.extraEditorClassName);
    }
    if (options3.get(
      76
      /* EditorOption.mouseStyle */
    ) === "default") {
      classNames.push("mouse-default");
    } else if (options3.get(
      76
      /* EditorOption.mouseStyle */
    ) === "copy") {
      classNames.push("mouse-copy");
    }
    if (options3.get(
      114
      /* EditorOption.showUnused */
    )) {
      classNames.push("showUnused");
    }
    if (options3.get(
      143
      /* EditorOption.showDeprecated */
    )) {
      classNames.push("showDeprecated");
    }
    return classNames.join(" ");
  }
};
var EditorEmptySelectionClipboard = class extends EditorBooleanOption {
  constructor() {
    super(38, "emptySelectionClipboard", true, { description: localize(312, null) });
  }
  compute(env2, options3, value) {
    return value && env2.emptySelectionClipboard;
  }
};
var EditorFind = class extends BaseEditorOption {
  constructor() {
    const defaults2 = {
      cursorMoveOnType: true,
      seedSearchStringFromSelection: "always",
      autoFindInSelection: "never",
      globalFindClipboard: false,
      addExtraSpaceOnTop: true,
      loop: true
    };
    super(43, "find", defaults2, {
      "editor.find.cursorMoveOnType": {
        type: "boolean",
        default: defaults2.cursorMoveOnType,
        description: localize(313, null)
      },
      "editor.find.seedSearchStringFromSelection": {
        type: "string",
        enum: ["never", "always", "selection"],
        default: defaults2.seedSearchStringFromSelection,
        enumDescriptions: [
          localize(314, null),
          localize(315, null),
          localize(316, null)
        ],
        description: localize(317, null)
      },
      "editor.find.autoFindInSelection": {
        type: "string",
        enum: ["never", "always", "multiline"],
        default: defaults2.autoFindInSelection,
        enumDescriptions: [
          localize(318, null),
          localize(319, null),
          localize(320, null)
        ],
        description: localize(321, null)
      },
      "editor.find.globalFindClipboard": {
        type: "boolean",
        default: defaults2.globalFindClipboard,
        description: localize(322, null),
        included: $m
      },
      "editor.find.addExtraSpaceOnTop": {
        type: "boolean",
        default: defaults2.addExtraSpaceOnTop,
        description: localize(323, null)
      },
      "editor.find.loop": {
        type: "boolean",
        default: defaults2.loop,
        description: localize(324, null)
      }
    });
  }
  validate(_input) {
    if (!_input || typeof _input !== "object") {
      return this.defaultValue;
    }
    const input = _input;
    return {
      cursorMoveOnType: boolean(input.cursorMoveOnType, this.defaultValue.cursorMoveOnType),
      seedSearchStringFromSelection: typeof _input.seedSearchStringFromSelection === "boolean" ? _input.seedSearchStringFromSelection ? "always" : "never" : stringSet(input.seedSearchStringFromSelection, this.defaultValue.seedSearchStringFromSelection, ["never", "always", "selection"]),
      autoFindInSelection: typeof _input.autoFindInSelection === "boolean" ? _input.autoFindInSelection ? "always" : "never" : stringSet(input.autoFindInSelection, this.defaultValue.autoFindInSelection, ["never", "always", "multiline"]),
      globalFindClipboard: boolean(input.globalFindClipboard, this.defaultValue.globalFindClipboard),
      addExtraSpaceOnTop: boolean(input.addExtraSpaceOnTop, this.defaultValue.addExtraSpaceOnTop),
      loop: boolean(input.loop, this.defaultValue.loop)
    };
  }
};
var EditorFontLigatures = class _EditorFontLigatures extends BaseEditorOption {
  static {
    this.OFF = '"liga" off, "calt" off';
  }
  static {
    this.ON = '"liga" on, "calt" on';
  }
  constructor() {
    super(53, "fontLigatures", _EditorFontLigatures.OFF, {
      anyOf: [
        {
          type: "boolean",
          description: localize(325, null)
        },
        {
          type: "string",
          description: localize(326, null)
        }
      ],
      description: localize(327, null),
      default: false
    });
  }
  validate(input) {
    if (typeof input === "undefined") {
      return this.defaultValue;
    }
    if (typeof input === "string") {
      if (input === "false" || input.length === 0) {
        return _EditorFontLigatures.OFF;
      }
      if (input === "true") {
        return _EditorFontLigatures.ON;
      }
      return input;
    }
    if (Boolean(input)) {
      return _EditorFontLigatures.ON;
    }
    return _EditorFontLigatures.OFF;
  }
};
var EditorFontVariations = class _EditorFontVariations extends BaseEditorOption {
  static {
    this.OFF = "normal";
  }
  static {
    this.TRANSLATE = "translate";
  }
  constructor() {
    super(56, "fontVariations", _EditorFontVariations.OFF, {
      anyOf: [
        {
          type: "boolean",
          description: localize(328, null)
        },
        {
          type: "string",
          description: localize(329, null)
        }
      ],
      description: localize(330, null),
      default: false
    });
  }
  validate(input) {
    if (typeof input === "undefined") {
      return this.defaultValue;
    }
    if (typeof input === "string") {
      if (input === "false") {
        return _EditorFontVariations.OFF;
      }
      if (input === "true") {
        return _EditorFontVariations.TRANSLATE;
      }
      return input;
    }
    if (Boolean(input)) {
      return _EditorFontVariations.TRANSLATE;
    }
    return _EditorFontVariations.OFF;
  }
  compute(env2, options3, value) {
    return env2.fontInfo.fontVariationSettings;
  }
};
var EditorFontInfo = class extends ComputedEditorOption {
  constructor() {
    super(
      52
      /* EditorOption.fontInfo */
    );
  }
  compute(env2, options3, _) {
    return env2.fontInfo;
  }
};
var EditorFontSize = class extends SimpleEditorOption {
  constructor() {
    super(54, "fontSize", EDITOR_FONT_DEFAULTS.fontSize, {
      type: "number",
      minimum: 6,
      maximum: 100,
      default: EDITOR_FONT_DEFAULTS.fontSize,
      description: localize(331, null)
    });
  }
  validate(input) {
    const r2 = EditorFloatOption.float(input, this.defaultValue);
    if (r2 === 0) {
      return EDITOR_FONT_DEFAULTS.fontSize;
    }
    return EditorFloatOption.clamp(r2, 6, 100);
  }
  compute(env2, options3, value) {
    return env2.fontInfo.fontSize;
  }
};
var EditorFontWeight = class _EditorFontWeight extends BaseEditorOption {
  static {
    this.c = ["normal", "bold", "100", "200", "300", "400", "500", "600", "700", "800", "900"];
  }
  static {
    this.d = 1;
  }
  static {
    this.e = 1e3;
  }
  constructor() {
    super(55, "fontWeight", EDITOR_FONT_DEFAULTS.fontWeight, {
      anyOf: [
        {
          type: "number",
          minimum: _EditorFontWeight.d,
          maximum: _EditorFontWeight.e,
          errorMessage: localize(332, null)
        },
        {
          type: "string",
          pattern: "^(normal|bold|1000|[1-9][0-9]{0,2})$"
        },
        {
          enum: _EditorFontWeight.c
        }
      ],
      default: EDITOR_FONT_DEFAULTS.fontWeight,
      description: localize(333, null)
    });
  }
  validate(input) {
    if (input === "normal" || input === "bold") {
      return input;
    }
    return String(EditorIntOption.clampedInt(input, EDITOR_FONT_DEFAULTS.fontWeight, _EditorFontWeight.d, _EditorFontWeight.e));
  }
};
var EditorGoToLocation = class extends BaseEditorOption {
  constructor() {
    const defaults2 = {
      multiple: "peek",
      multipleDefinitions: "peek",
      multipleTypeDefinitions: "peek",
      multipleDeclarations: "peek",
      multipleImplementations: "peek",
      multipleReferences: "peek",
      multipleTests: "peek",
      alternativeDefinitionCommand: "editor.action.goToReferences",
      alternativeTypeDefinitionCommand: "editor.action.goToReferences",
      alternativeDeclarationCommand: "editor.action.goToReferences",
      alternativeImplementationCommand: "",
      alternativeReferenceCommand: "",
      alternativeTestsCommand: ""
    };
    const jsonSubset = {
      type: "string",
      enum: ["peek", "gotoAndPeek", "goto"],
      default: defaults2.multiple,
      enumDescriptions: [
        localize(334, null),
        localize(335, null),
        localize(336, null)
      ]
    };
    const alternativeCommandOptions = ["", "editor.action.referenceSearch.trigger", "editor.action.goToReferences", "editor.action.peekImplementation", "editor.action.goToImplementation", "editor.action.peekTypeDefinition", "editor.action.goToTypeDefinition", "editor.action.peekDeclaration", "editor.action.revealDeclaration", "editor.action.peekDefinition", "editor.action.revealDefinitionAside", "editor.action.revealDefinition"];
    super(60, "gotoLocation", defaults2, {
      "editor.gotoLocation.multiple": {
        deprecationMessage: localize(337, null)
      },
      "editor.gotoLocation.multipleDefinitions": {
        description: localize(338, null),
        ...jsonSubset
      },
      "editor.gotoLocation.multipleTypeDefinitions": {
        description: localize(339, null),
        ...jsonSubset
      },
      "editor.gotoLocation.multipleDeclarations": {
        description: localize(340, null),
        ...jsonSubset
      },
      "editor.gotoLocation.multipleImplementations": {
        description: localize(341, null),
        ...jsonSubset
      },
      "editor.gotoLocation.multipleReferences": {
        description: localize(342, null),
        ...jsonSubset
      },
      "editor.gotoLocation.alternativeDefinitionCommand": {
        type: "string",
        default: defaults2.alternativeDefinitionCommand,
        enum: alternativeCommandOptions,
        description: localize(343, null)
      },
      "editor.gotoLocation.alternativeTypeDefinitionCommand": {
        type: "string",
        default: defaults2.alternativeTypeDefinitionCommand,
        enum: alternativeCommandOptions,
        description: localize(344, null)
      },
      "editor.gotoLocation.alternativeDeclarationCommand": {
        type: "string",
        default: defaults2.alternativeDeclarationCommand,
        enum: alternativeCommandOptions,
        description: localize(345, null)
      },
      "editor.gotoLocation.alternativeImplementationCommand": {
        type: "string",
        default: defaults2.alternativeImplementationCommand,
        enum: alternativeCommandOptions,
        description: localize(346, null)
      },
      "editor.gotoLocation.alternativeReferenceCommand": {
        type: "string",
        default: defaults2.alternativeReferenceCommand,
        enum: alternativeCommandOptions,
        description: localize(347, null)
      }
    });
  }
  validate(_input) {
    if (!_input || typeof _input !== "object") {
      return this.defaultValue;
    }
    const input = _input;
    return {
      multiple: stringSet(input.multiple, this.defaultValue.multiple, ["peek", "gotoAndPeek", "goto"]),
      multipleDefinitions: input.multipleDefinitions ?? stringSet(input.multipleDefinitions, "peek", ["peek", "gotoAndPeek", "goto"]),
      multipleTypeDefinitions: input.multipleTypeDefinitions ?? stringSet(input.multipleTypeDefinitions, "peek", ["peek", "gotoAndPeek", "goto"]),
      multipleDeclarations: input.multipleDeclarations ?? stringSet(input.multipleDeclarations, "peek", ["peek", "gotoAndPeek", "goto"]),
      multipleImplementations: input.multipleImplementations ?? stringSet(input.multipleImplementations, "peek", ["peek", "gotoAndPeek", "goto"]),
      multipleReferences: input.multipleReferences ?? stringSet(input.multipleReferences, "peek", ["peek", "gotoAndPeek", "goto"]),
      multipleTests: input.multipleTests ?? stringSet(input.multipleTests, "peek", ["peek", "gotoAndPeek", "goto"]),
      alternativeDefinitionCommand: EditorStringOption.string(input.alternativeDefinitionCommand, this.defaultValue.alternativeDefinitionCommand),
      alternativeTypeDefinitionCommand: EditorStringOption.string(input.alternativeTypeDefinitionCommand, this.defaultValue.alternativeTypeDefinitionCommand),
      alternativeDeclarationCommand: EditorStringOption.string(input.alternativeDeclarationCommand, this.defaultValue.alternativeDeclarationCommand),
      alternativeImplementationCommand: EditorStringOption.string(input.alternativeImplementationCommand, this.defaultValue.alternativeI