"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseNativeEnumDef = void 0;
function parseNativeEnumDef(def) {
    const object = def.values;
    const actualKeys = Object.keys(def.values).filter((key) => {
        return typeof object[object[key]] !== 'number';
    });
    const actualValues = actualKeys.map((key) => object[key]);
    const parsedTypes = Array.from(new Set(actualValues.map((values) => typeof values)));
    return {
        type: parsedTypes.length === 1 ?
            parsedTypes[0] === 'string' ?
                'string'
                : 'number'
            : ['string', 'number'],
        enum: actualValues,
    };
}
exports.parseNativeEnumDef = parseNativeEnumDef;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/85c2c80db071b183592d5463d33ac97c5e1c39eb/node_modules/openai/_vendor/zod-to-json-schema/parsers/nativeEnum.js.map