/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.UncivGame;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapGenerator;
import com.unciv.logic.map.mapgenerator.MapResourceSetting;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.newgamescreen.IPreviousScreen;
import com.unciv.ui.screens.newgamescreen.MultiCheckboxTable;
import com.unciv.ui.screens.newgamescreen.NewGameScreen;
import com.unciv.ui.screens.victoryscreen.LoadMapPreview;
import com.unciv.utils.Concurrency;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001B?\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010B\u001a\u00020\fJ\u0006\u0010C\u001a\u00020\fJ\b\u0010D\u001a\u00020\fH\u0002J\b\u0010E\u001a\u00020\fH\u0002J\b\u0010F\u001a\u00020\fH\u0002J\b\u0010G\u001a\u00020\fH\u0002J\b\u0010H\u001a\u00020\fH\u0002J\b\u0010I\u001a\u00020\fH\u0002J\b\u0010J\u001a\u00020\fH\u0002J\b\u0010K\u001a\u00020\fH\u0002J\f\u0010L\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010M\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010N\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010O\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010P\u001a\u00020\f*\u00020\u0001H\u0002J\b\u0010Q\u001a\u00020\fH\u0002J\b\u0010R\u001a\u00020\fH\u0002J\u0010\u0010S\u001a\u00020\f2\u0006\u0010T\u001a\u00020\u0001H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u000e\u0010!\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0012\"\u0004\b'\u0010\u0014R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u000701j\b\u0012\u0004\u0012\u00020\u0007`2X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u000701j\b\u0012\u0004\u0012\u00020\u0007`2X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u0012\u0012\u0004\u0012\u00020\u000701j\b\u0012\u0004\u0012\u00020\u0007`2X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u00105\u001a\u0012\u0012\u0004\u0012\u00020\u000701j\b\u0012\u0004\u0012\u00020\u0007`2X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u00109\u001a*\u0012\u0004\u0012\u00020;\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u000b0:j\u0014\u0012\u0004\u0012\u00020;\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u000b`<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u00a8\u0006U"}, d2={"Lcom/unciv/ui/screens/newgamescreen/MapParametersTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "previousScreen", "Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "mapGeneratedMainType", "", "forMapEditor", "", "sizeChangedCallback", "Lkotlin/Function0;", "", "<init>", "(Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;Lcom/unciv/logic/map/MapParameters;Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)V", "mapTypeSelectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "getMapTypeSelectBox", "()Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "setMapTypeSelectBox", "(Lcom/unciv/ui/components/widgets/TranslatedSelectBox;)V", "customMapSizeRadius", "Lcom/unciv/ui/components/widgets/UncivTextField$Integer;", "getCustomMapSizeRadius", "()Lcom/unciv/ui/components/widgets/UncivTextField$Integer;", "setCustomMapSizeRadius", "(Lcom/unciv/ui/components/widgets/UncivTextField$Integer;)V", "customMapWidth", "getCustomMapWidth", "setCustomMapWidth", "customMapHeight", "getCustomMapHeight", "setCustomMapHeight", "worldSizeSelectBox", "customWorldSizeTable", "hexagonalSizeTable", "rectangularSizeTable", "resourceSelectBox", "getResourceSelectBox", "setResourceSelectBox", "noRuinsCheckbox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "noNaturalWondersCheckbox", "worldWrapCheckbox", "legendaryStartCheckbox", "strategicBalanceCheckbox", "seedTextField", "Lcom/unciv/ui/components/widgets/UncivTextField$Numeric;", "mapShapesOptionsValues", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "mapTypesOptionsValues", "mapSizesOptionsValues", "mapResourcesOptionsValues", "maxMapSize", "", "mapTypeExample", "advancedSliders", "Ljava/util/HashMap;", "Lcom/unciv/ui/components/widgets/UncivSlider;", "Lkotlin/collections/HashMap;", "randomizeSeed", "getRandomizeSeed", "()Z", "setRandomizeSeed", "(Z)V", "update", "reseed", "addMapShapeSelectBox", "generateExampleMap", "addMapTypeSelectBox", "addWorldSizeTable", "addHexagonalSizeTable", "addRectangularSizeTable", "updateWorldSizeTable", "addResourceSelectBox", "addNoRuinsCheckbox", "addNoNaturalWondersCheckbox", "addWorldWrapCheckbox", "addStrategicBalanceCheckbox", "addLegendaryStartCheckbox", "addWrappedCheckBoxes", "addAdvancedSettings", "addAdvancedControls", "table", "core"})
@SourceDebugExtension(value={"SMAP\nMapParametersTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapParametersTable.kt\ncom/unciv/ui/screens/newgamescreen/MapParametersTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n1#2:455\n*E\n"})
public final class MapParametersTable
extends Table {
    @Nullable
    private final IPreviousScreen previousScreen;
    @NotNull
    private final MapParameters mapParameters;
    @NotNull
    private final String mapGeneratedMainType;
    private final boolean forMapEditor;
    @Nullable
    private final Function0<Unit> sizeChangedCallback;
    public TranslatedSelectBox mapTypeSelectBox;
    public UncivTextField.Integer customMapSizeRadius;
    public UncivTextField.Integer customMapWidth;
    public UncivTextField.Integer customMapHeight;
    private TranslatedSelectBox worldSizeSelectBox;
    @NotNull
    private Table customWorldSizeTable;
    @NotNull
    private Table hexagonalSizeTable;
    @NotNull
    private Table rectangularSizeTable;
    public TranslatedSelectBox resourceSelectBox;
    private CheckBox noRuinsCheckbox;
    private CheckBox noNaturalWondersCheckbox;
    private CheckBox worldWrapCheckbox;
    private CheckBox legendaryStartCheckbox;
    private CheckBox strategicBalanceCheckbox;
    private UncivTextField.Numeric seedTextField;
    private HashSet<String> mapShapesOptionsValues;
    private HashSet<String> mapTypesOptionsValues;
    private HashSet<String> mapSizesOptionsValues;
    private HashSet<String> mapResourcesOptionsValues;
    private final float maxMapSize;
    @NotNull
    private final Table mapTypeExample;
    @NotNull
    private final HashMap<UncivSlider, Function0<Float>> advancedSliders;
    private boolean randomizeSeed;

    public MapParametersTable(@Nullable IPreviousScreen previousScreen, @NotNull MapParameters mapParameters, @NotNull String mapGeneratedMainType, boolean forMapEditor, @Nullable Function0<Unit> sizeChangedCallback) {
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        Intrinsics.checkNotNullParameter(mapGeneratedMainType, "mapGeneratedMainType");
        this.previousScreen = previousScreen;
        this.mapParameters = mapParameters;
        this.mapGeneratedMainType = mapGeneratedMainType;
        this.forMapEditor = forMapEditor;
        this.sizeChangedCallback = sizeChangedCallback;
        this.customWorldSizeTable = new Table();
        this.hexagonalSizeTable = new Table();
        this.rectangularSizeTable = new Table();
        IPreviousScreen iPreviousScreen = this.previousScreen;
        NewGameScreen newGameScreen = iPreviousScreen instanceof NewGameScreen ? (NewGameScreen)iPreviousScreen : null;
        this.maxMapSize = (newGameScreen != null ? newGameScreen.getColumnWidth$core() : 200.0f) - 10.0f;
        this.mapTypeExample = new Table();
        this.advancedSliders = new HashMap();
        this.randomizeSeed = true;
        this.update();
    }

    public /* synthetic */ MapParametersTable(IPreviousScreen iPreviousScreen, MapParameters mapParameters, String string, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iPreviousScreen = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function0 = null;
        }
        this(iPreviousScreen, mapParameters, string, bl, function0);
    }

    @NotNull
    public final TranslatedSelectBox getMapTypeSelectBox() {
        TranslatedSelectBox translatedSelectBox = this.mapTypeSelectBox;
        if (translatedSelectBox != null) {
            return translatedSelectBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException("mapTypeSelectBox");
        return null;
    }

    public final void setMapTypeSelectBox(@NotNull TranslatedSelectBox translatedSelectBox) {
        Intrinsics.checkNotNullParameter(translatedSelectBox, "<set-?>");
        this.mapTypeSelectBox = translatedSelectBox;
    }

    @NotNull
    public final UncivTextField.Integer getCustomMapSizeRadius() {
        UncivTextField.Integer integer = this.customMapSizeRadius;
        if (integer != null) {
            return integer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("customMapSizeRadius");
        return null;
    }

    public final void setCustomMapSizeRadius(@NotNull UncivTextField.Integer integer) {
        Intrinsics.checkNotNullParameter(integer, "<set-?>");
        this.customMapSizeRadius = integer;
    }

    @NotNull
    public final UncivTextField.Integer getCustomMapWidth() {
        UncivTextField.Integer integer = this.customMapWidth;
        if (integer != null) {
            return integer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("customMapWidth");
        return null;
    }

    public final void setCustomMapWidth(@NotNull UncivTextField.Integer integer) {
        Intrinsics.checkNotNullParameter(integer, "<set-?>");
        this.customMapWidth = integer;
    }

    @NotNull
    public final UncivTextField.Integer getCustomMapHeight() {
        UncivTextField.Integer integer = this.customMapHeight;
        if (integer != null) {
            return integer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("customMapHeight");
        return null;
    }

    public final void setCustomMapHeight(@NotNull UncivTextField.Integer integer) {
        Intrinsics.checkNotNullParameter(integer, "<set-?>");
        this.customMapHeight = integer;
    }

    @NotNull
    public final TranslatedSelectBox getResourceSelectBox() {
        TranslatedSelectBox translatedSelectBox = this.resourceSelectBox;
        if (translatedSelectBox != null) {
            return translatedSelectBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException("resourceSelectBox");
        return null;
    }

    public final void setResourceSelectBox(@NotNull TranslatedSelectBox translatedSelectBox) {
        Intrinsics.checkNotNullParameter(translatedSelectBox, "<set-?>");
        this.resourceSelectBox = translatedSelectBox;
    }

    public final boolean getRandomizeSeed() {
        return this.randomizeSeed;
    }

    public final void setRandomizeSeed(boolean bl) {
        this.randomizeSeed = bl;
    }

    public final void update() {
        this.clear();
        this.setSkin(BaseScreen.Companion.getSkin());
        Cell cell = this.defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 5.0f, 5.0f);
        if (Intrinsics.areEqual(this.mapGeneratedMainType, "Random Generated")) {
            String prompt = "Which options should be available to the random selection?";
            IPreviousScreen iPreviousScreen = this.previousScreen;
            NewGameScreen newGameScreen = iPreviousScreen instanceof NewGameScreen ? (NewGameScreen)iPreviousScreen : null;
            float width = newGameScreen != null ? newGameScreen.getColumnWidth$core() : 200.0f;
            WrappableLabel label = new WrappableLabel(prompt, width - 10.0f, null, 0, false, 28, null);
            label.setAlignment(1);
            label.setWrap(true);
            this.add((Actor)label).colspan(2).grow().row();
        }
        this.addMapShapeSelectBox();
        this.addMapTypeSelectBox();
        this.addWorldSizeTable();
        this.addResourceSelectBox();
        this.addWrappedCheckBoxes();
        this.addAdvancedSettings();
        this.generateExampleMap();
    }

    public final void reseed() {
        this.mapParameters.reseed();
        UncivTextField.Numeric numeric = this.seedTextField;
        if (numeric == null) {
            Intrinsics.throwUninitializedPropertyAccessException("seedTextField");
            numeric = null;
        }
        numeric.setValue(this.mapParameters.getSeed());
    }

    private final void addMapShapeSelectBox() {
        String[] stringArray = new String[]{"Hexagonal", "Flat Earth Hexagonal", "Rectangular"};
        List<String> mapShapes = CollectionsKt.listOfNotNull(stringArray);
        if (Intrinsics.areEqual(this.mapGeneratedMainType, "Random Generated")) {
            this.mapShapesOptionsValues = CollectionsKt.toHashSet((Iterable)mapShapes);
            HashSet<String> hashSet = this.mapShapesOptionsValues;
            if (hashSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapShapesOptionsValues");
                hashSet = null;
            }
            MultiCheckboxTable optionsTable = new MultiCheckboxTable("{Enabled Map Shapes}", "NewGameMapShapes", hashSet, arg_0 -> MapParametersTable.addMapShapeSelectBox$lambda$0(this, mapShapes, arg_0));
            this.add((Actor)optionsTable).colspan(2).grow().row();
        } else {
            TranslatedSelectBox mapShapeSelectBox = new TranslatedSelectBox((Collection<String>)mapShapes, this.mapParameters.getShape());
            ActivationExtensionsKt.onChange(mapShapeSelectBox, arg_0 -> MapParametersTable.addMapShapeSelectBox$lambda$1(this, mapShapeSelectBox, arg_0));
            this.add((Actor)Scene2dExtensionsKt.toLabel("{Map Shape}:")).left();
            this.add((Actor)mapShapeSelectBox).fillX().row();
        }
    }

    private final void generateExampleMap() {
        Ruleset ruleset = this.previousScreen instanceof NewGameScreen ? ((NewGameScreen)this.previousScreen).getRuleset() : RulesetCache.INSTANCE.getVanillaRuleset();
        Concurrency.run$default(Concurrency.INSTANCE, "Generate example map", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ruleset, null){
            int label;
            final /* synthetic */ MapParametersTable this$0;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.this$0 = $receiver;
                this.$ruleset = $ruleset;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        MapParameters mapParameters;
                        ResultKt.throwOnFailure($result);
                        if (MapParametersTable.access$getForMapEditor$p(this.this$0)) {
                            mapParameters = MapParametersTable.access$getMapParameters$p(this.this$0);
                        } else {
                            MapParameters mapParameters2;
                            MapParameters $this$invokeSuspend_u24lambda_u240 = mapParameters2 = MapParametersTable.access$getMapParameters$p(this.this$0).clone();
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240.setSeed(0L);
                            mapParameters = mapParameters2;
                        }
                        MapParameters mapParametersForExample = mapParameters;
                        TileMap exampleMap = new MapGenerator(this.$ruleset, null, 2, null).generateMap(mapParametersForExample, new GameParameters(), CollectionsKt.emptyList());
                        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, exampleMap, null){
                            int label;
                            final /* synthetic */ MapParametersTable this$0;
                            final /* synthetic */ TileMap $exampleMap;
                            {
                                this.this$0 = $receiver;
                                this.$exampleMap = $exampleMap;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        MapParametersTable.access$getMapTypeExample$p(this.this$0).clear();
                                        LoadMapPreview mapPreview = new LoadMapPreview(this.$exampleMap, MapParametersTable.access$getMaxMapSize$p(this.this$0), MapParametersTable.access$getMaxMapSize$p(this.this$0));
                                        if (!MapParametersTable.access$getForMapEditor$p(this.this$0)) {
                                            Label label = Scene2dExtensionsKt.toLabel("Example map");
                                            Scene2dExtensionsKt.centerX((Actor)label, mapPreview);
                                            label.setY(mapPreview.getHeight() - label.getHeight() - 10.0f);
                                            mapPreview.addActor(label);
                                        }
                                        MapParametersTable.access$getMapTypeExample$p(this.this$0).add((Actor)mapPreview);
                                        this.this$0.pack();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void addMapTypeSelectBox() {
        String[] stringArray = new String[]{"Pangaea", "Continent and Islands", "Two Continents", "Three Continents", "Four Corners", "Archipelago", "Inner Sea", "Perlin", "Fractal", "Lakes", "Small Continents", this.forMapEditor && !Intrinsics.areEqual(this.mapGeneratedMainType, "Random Generated") ? "Empty" : null};
        List<String> mapTypes = CollectionsKt.listOfNotNull(stringArray);
        if (Intrinsics.areEqual(this.mapGeneratedMainType, "Random Generated")) {
            this.mapTypesOptionsValues = CollectionsKt.toHashSet((Iterable)mapTypes);
            HashSet<String> hashSet = this.mapTypesOptionsValues;
            if (hashSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapTypesOptionsValues");
                hashSet = null;
            }
            MultiCheckboxTable optionsTable = new MultiCheckboxTable("{Enabled Map Generation Types}", "NewGameMapGenerationTypes", hashSet, arg_0 -> MapParametersTable.addMapTypeSelectBox$lambda$0(this, mapTypes, arg_0));
            this.add((Actor)optionsTable).colspan(2).grow().row();
        } else {
            this.setMapTypeSelectBox(new TranslatedSelectBox((Collection<String>)mapTypes, this.mapParameters.getType()));
            ActivationExtensionsKt.onChange(this.getMapTypeSelectBox(), arg_0 -> MapParametersTable.addMapTypeSelectBox$lambda$1(this, arg_0));
            this.add((Actor)Scene2dExtensionsKt.toLabel("{Map Generation Type}:")).left();
            this.add((Actor)this.getMapTypeSelectBox()).fillX().row();
            this.add((Actor)this.mapTypeExample).colspan(2).grow().row();
        }
    }

    private final void addWorldSizeTable() {
        if (Intrinsics.areEqual(this.mapGeneratedMainType, "Random Generated")) {
            List<String> mapSizes = MapSize.Companion.names();
            this.mapSizesOptionsValues = CollectionsKt.toHashSet((Iterable)mapSizes);
            HashSet<String> hashSet = this.mapSizesOptionsValues;
            if (hashSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapSizesOptionsValues");
                hashSet = null;
            }
            MultiCheckboxTable optionsTable = new MultiCheckboxTable("{Enabled World Sizes}", "NewGameWorldSizes", hashSet, arg_0 -> MapParametersTable.addWorldSizeTable$lambda$0(this, mapSizes, arg_0));
            this.add((Actor)optionsTable).colspan(2).grow().row();
        } else {
            List mapSizes = CollectionsKt.plus((Collection)MapSize.Companion.names(), (Iterable)CollectionsKt.listOf("Custom"));
            this.worldSizeSelectBox = new TranslatedSelectBox(mapSizes, this.mapParameters.getMapSize().getName());
            TranslatedSelectBox translatedSelectBox = this.worldSizeSelectBox;
            if (translatedSelectBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException("worldSizeSelectBox");
                translatedSelectBox = null;
            }
            ActivationExtensionsKt.onChange(translatedSelectBox, arg_0 -> MapParametersTable.addWorldSizeTable$lambda$1(this, arg_0));
            this.addHexagonalSizeTable();
            this.addRectangularSizeTable();
            this.add((Actor)Scene2dExtensionsKt.toLabel("{World Size}:")).left();
            TranslatedSelectBox translatedSelectBox2 = this.worldSizeSelectBox;
            if (translatedSelectBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("worldSizeSelectBox");
                translatedSelectBox2 = null;
            }
            this.add((Actor)translatedSelectBox2).fillX().row();
            this.add((Actor)this.customWorldSizeTable).colspan(2).grow().row();
            this.updateWorldSizeTable();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addHexagonalSizeTable() {
        void $this$addHexagonalSizeTable_u24lambda_u241;
        Label label;
        int defaultRadius = this.mapParameters.getMapSize().getRadius();
        this.setCustomMapSizeRadius(new UncivTextField.Integer("Radius", defaultRadius, null, 4, null));
        ActivationExtensionsKt.onChange(this.getCustomMapSizeRadius(), arg_0 -> MapParametersTable.addHexagonalSizeTable$lambda$0(this, arg_0));
        this.hexagonalSizeTable.add((Actor)Scene2dExtensionsKt.toLabel("{Radius}:")).grow().left();
        this.hexagonalSizeTable.add((Actor)this.getCustomMapSizeRadius()).right().row();
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        Label label2 = label = Scene2dExtensionsKt.toLabel$default("Anything above 40 may work very slowly on Android!", color, 0, 0, false, 14, null);
        Table table2 = this.hexagonalSizeTable;
        boolean bl = false;
        $this$addHexagonalSizeTable_u24lambda_u241.setWrap(true);
        table2.add((Actor)label).width(this.getPrefWidth()).colspan(this.hexagonalSizeTable.getColumns());
    }

    /*
     * WARNING - void declaration
     */
    private final void addRectangularSizeTable() {
        void $this$addRectangularSizeTable_u24lambda_u242;
        Label label;
        int defaultWidth = this.mapParameters.getMapSize().getWidth();
        this.setCustomMapWidth(new UncivTextField.Integer("Width", defaultWidth, null, 4, null));
        int defaultHeight = this.mapParameters.getMapSize().getHeight();
        this.setCustomMapHeight(new UncivTextField.Integer("Height", defaultHeight, null, 4, null));
        ActivationExtensionsKt.onChange(this.getCustomMapWidth(), arg_0 -> MapParametersTable.addRectangularSizeTable$lambda$0(this, arg_0));
        ActivationExtensionsKt.onChange(this.getCustomMapHeight(), arg_0 -> MapParametersTable.addRectangularSizeTable$lambda$1(this, arg_0));
        this.rectangularSizeTable.defaults().pad(5.0f);
        this.rectangularSizeTable.add((Actor)Scene2dExtensionsKt.toLabel("{Width}:")).grow().left();
        this.rectangularSizeTable.add((Actor)this.getCustomMapWidth()).right().row();
        this.rectangularSizeTable.add((Actor)Scene2dExtensionsKt.toLabel("{Height}:")).grow().left();
        this.rectangularSizeTable.add((Actor)this.getCustomMapHeight()).right().row();
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        Label label2 = label = Scene2dExtensionsKt.toLabel$default("Anything above 80 by 50 may work very slowly on Android!", color, 0, 0, false, 14, null);
        Table table2 = this.rectangularSizeTable;
        boolean bl = false;
        $this$addRectangularSizeTable_u24lambda_u242.setWrap(true);
        table2.add((Actor)label).width(this.getPrefWidth()).colspan(this.hexagonalSizeTable.getColumns());
    }

    /*
     * Unable to fully structure code
     */
    private final void updateWorldSizeTable() {
        block7: {
            block6: {
                block5: {
                    this.customWorldSizeTable.clear();
                    if (!Intrinsics.areEqual(this.mapParameters.getShape(), "Hexagonal") && !Intrinsics.areEqual(this.mapParameters.getShape(), "Flat Earth Hexagonal")) break block5;
                    v0 = this.worldSizeSelectBox;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("worldSizeSelectBox");
                        v0 = null;
                    }
                    if (!Intrinsics.areEqual(((TranslatedSelectBox.TranslatedString)v0.getSelected()).getValue(), "Custom")) break block5;
                    this.customWorldSizeTable.add((Actor)this.hexagonalSizeTable).grow().row();
                    break block6;
                }
                if (!Intrinsics.areEqual(this.mapParameters.getShape(), "Rectangular")) ** GOTO lbl-1000
                v1 = this.worldSizeSelectBox;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("worldSizeSelectBox");
                    v1 = null;
                }
                if (Intrinsics.areEqual(((TranslatedSelectBox.TranslatedString)v1.getSelected()).getValue(), "Custom")) {
                    this.customWorldSizeTable.add((Actor)this.rectangularSizeTable).grow().row();
                } else lbl-1000:
                // 2 sources

                {
                    if ((v2 = this.worldSizeSelectBox) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("worldSizeSelectBox");
                        v2 = null;
                    }
                    this.mapParameters.setMapSize(new MapSize(((TranslatedSelectBox.TranslatedString)v2.getSelected()).getValue()));
                }
            }
            v3 = this.sizeChangedCallback;
            if (v3 == null) break block7;
            v3.invoke();
        }
    }

    private final void addResourceSelectBox() {
        List<String> mapResources = MapResourceSetting.Companion.activeLabels();
        if (Intrinsics.areEqual(this.mapGeneratedMainType, "Random Generated")) {
            this.mapResourcesOptionsValues = CollectionsKt.toHashSet((Iterable)mapResources);
            HashSet<String> hashSet = this.mapResourcesOptionsValues;
            if (hashSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapResourcesOptionsValues");
                hashSet = null;
            }
            MultiCheckboxTable optionsTable = new MultiCheckboxTable("{Enabled Resource Settings}", "NewGameResourceSettings", hashSet, arg_0 -> MapParametersTable.addResourceSelectBox$lambda$0(this, mapResources, arg_0));
            this.add((Actor)optionsTable).colspan(2).grow().row();
        } else {
            this.setResourceSelectBox(new TranslatedSelectBox((Collection<String>)mapResources, this.mapParameters.getMapResources()));
            ActivationExtensionsKt.onChange(this.getResourceSelectBox(), arg_0 -> MapParametersTable.addResourceSelectBox$lambda$1(this, arg_0));
            if (this.forMapEditor) {
                String comment = "This is used for painting resources, not in map generator steps:";
                Disposable disposable = UncivGame.Companion.getCurrent().getScreen();
                float expectedWidth = (disposable != null && (disposable = ((BaseScreen)disposable).getStage()) != null ? ((Stage)disposable).getWidth() : 1200.0f) * 0.4f;
                Color color = Color.GOLD;
                Intrinsics.checkNotNullExpressionValue(color, "GOLD");
                WrappableLabel label = new WrappableLabel(comment, expectedWidth, color, 14, false, 16, null);
                label.setAlignment(1);
                label.setWrap(true);
                this.add((Actor)label).colspan(2).row();
            }
            this.add((Actor)Scene2dExtensionsKt.toLabel("{Resource Setting}:")).left();
            this.add((Actor)this.getResourceSelectBox()).fillX().row();
        }
    }

    private final void addNoRuinsCheckbox(Table $this$addNoRuinsCheckbox) {
        this.noRuinsCheckbox = Scene2dExtensionsKt.toCheckBox("No Ancient Ruins", this.mapParameters.getNoRuins(), arg_0 -> MapParametersTable.addNoRuinsCheckbox$lambda$0(this, arg_0));
        CheckBox checkBox = this.noRuinsCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("noRuinsCheckbox");
            checkBox = null;
        }
        $this$addNoRuinsCheckbox.add((Actor)checkBox).row();
    }

    private final void addNoNaturalWondersCheckbox(Table $this$addNoNaturalWondersCheckbox) {
        this.noNaturalWondersCheckbox = Scene2dExtensionsKt.toCheckBox("No Natural Wonders", this.mapParameters.getNoNaturalWonders(), arg_0 -> MapParametersTable.addNoNaturalWondersCheckbox$lambda$0(this, arg_0));
        CheckBox checkBox = this.noNaturalWondersCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("noNaturalWondersCheckbox");
            checkBox = null;
        }
        $this$addNoNaturalWondersCheckbox.add((Actor)checkBox).row();
    }

    private final void addWorldWrapCheckbox(Table $this$addWorldWrapCheckbox) {
        this.worldWrapCheckbox = Scene2dExtensionsKt.toCheckBox("World Wrap", this.mapParameters.getWorldWrap(), arg_0 -> MapParametersTable.addWorldWrapCheckbox$lambda$0(this, arg_0));
        CheckBox checkBox = this.worldWrapCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldWrapCheckbox");
            checkBox = null;
        }
        $this$addWorldWrapCheckbox.add((Actor)checkBox).row();
    }

    private final void addStrategicBalanceCheckbox(Table $this$addStrategicBalanceCheckbox) {
        this.strategicBalanceCheckbox = Scene2dExtensionsKt.toCheckBox("Strategic Balance", this.mapParameters.getStrategicBalance(), arg_0 -> MapParametersTable.addStrategicBalanceCheckbox$lambda$0(this, arg_0));
        CheckBox checkBox = this.strategicBalanceCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("strategicBalanceCheckbox");
            checkBox = null;
        }
        $this$addStrategicBalanceCheckbox.add((Actor)checkBox).row();
    }

    private final void addLegendaryStartCheckbox(Table $this$addLegendaryStartCheckbox) {
        this.legendaryStartCheckbox = Scene2dExtensionsKt.toCheckBox("Legendary Start", this.mapParameters.getLegendaryStart(), arg_0 -> MapParametersTable.addLegendaryStartCheckbox$lambda$0(this, arg_0));
        CheckBox checkBox = this.legendaryStartCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("legendaryStartCheckbox");
            checkBox = null;
        }
        $this$addLegendaryStartCheckbox.add((Actor)checkBox).row();
    }

    /*
     * WARNING - void declaration
     */
    private final void addWrappedCheckBoxes() {
        String worldWrapWarning = "World wrap maps are very memory intensive - creating large world wrap maps on Android can lead to crashes!";
        if (Intrinsics.areEqual(this.mapGeneratedMainType, "Random Generated")) {
            this.add((Actor)new ExpanderTab("{Other Settings}", 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "NewGameOtherSettings", null, null, arg_0 -> MapParametersTable.addWrappedCheckBoxes$lambda$0(this, worldWrapWarning, arg_0), 3574, null)).pad(10.0f).padTop(10.0f).colspan(2).growX().row();
        } else {
            void $this$addWrappedCheckBoxes_u24lambda_u242;
            Actor $this$addWrappedCheckBoxes_u24lambda_u241;
            Actor actor;
            Table table2 = actor = new Table(this.getSkin());
            MapParametersTable mapParametersTable = this;
            boolean bl = false;
            $this$addWrappedCheckBoxes_u24lambda_u241.defaults().left().pad(2.5f);
            this.addStrategicBalanceCheckbox((Table)$this$addWrappedCheckBoxes_u24lambda_u241);
            this.addLegendaryStartCheckbox((Table)$this$addWrappedCheckBoxes_u24lambda_u241);
            this.addNoRuinsCheckbox((Table)$this$addWrappedCheckBoxes_u24lambda_u241);
            this.addNoNaturalWondersCheckbox((Table)$this$addWrappedCheckBoxes_u24lambda_u241);
            this.addWorldWrapCheckbox((Table)$this$addWrappedCheckBoxes_u24lambda_u241);
            mapParametersTable.add((Actor)actor).colspan(2).center().row();
            $this$addWrappedCheckBoxes_u24lambda_u241 = actor = Scene2dExtensionsKt.toLabel$default(worldWrapWarning, null, 14, 0, false, 13, null);
            mapParametersTable = this;
            boolean bl2 = false;
            $this$addWrappedCheckBoxes_u24lambda_u242.setWrap(true);
            mapParametersTable.add((Actor)actor).colspan(2).fillX().row();
        }
    }

    private final void addAdvancedSettings() {
        ExpanderTab expander = new ExpanderTab("Advanced Settings", 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, null, null, arg_0 -> MapParametersTable.addAdvancedSettings$lambda$0(this, arg_0), 4070, null);
        this.add((Actor)expander).padTop(10.0f).colspan(2).growX().row();
    }

    private final void addAdvancedControls(Table table2) {
        UncivSlider uncivSlider;
        table2.defaults().pad(2.0f).padTop(10.0f);
        this.seedTextField = new UncivTextField.Numeric("RNG Seed", this.mapParameters.getSeed(), true, null, 8, null);
        UncivTextField.Numeric numeric = this.seedTextField;
        if (numeric == null) {
            Intrinsics.throwUninitializedPropertyAccessException("seedTextField");
            numeric = null;
        }
        ActivationExtensionsKt.onChange(numeric, arg_0 -> MapParametersTable.addAdvancedControls$lambda$0(this, arg_0));
        table2.add((Actor)Scene2dExtensionsKt.toLabel("RNG Seed")).left();
        UncivTextField.Numeric numeric2 = this.seedTextField;
        if (numeric2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("seedTextField");
            numeric2 = null;
        }
        table2.add((Actor)numeric2).fillX().padBottom(10.0f).row();
        if (this.forMapEditor) {
            MapParametersTable.addAdvancedControls$addCheckBox(table2, "Randomize seed", true, arg_0 -> MapParametersTable.addAdvancedControls$lambda$5(this, arg_0));
        }
        MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Map Elevation", () -> MapParametersTable.addAdvancedControls$lambda$6(this), 0.6f, 0.8f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$7(this, arg_0));
        MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Temperature intensity", () -> MapParametersTable.addAdvancedControls$lambda$8(this), 0.4f, 0.8f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$9(this, arg_0));
        MapParametersTable.addAdvancedControls$addSlider(table2, this, "Temperature shift", () -> MapParametersTable.addAdvancedControls$lambda$10(this), -0.4f, 0.4f, 0.1f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$11(this, arg_0));
        if (this.forMapEditor) {
            MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Resource richness", () -> MapParametersTable.addAdvancedControls$lambda$12(this), 0.0f, 0.5f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$13(this, arg_0));
        }
        MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Vegetation richness", () -> MapParametersTable.addAdvancedControls$lambda$14(this), 0.0f, 1.0f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$15(this, arg_0));
        MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Rare features richness", () -> MapParametersTable.addAdvancedControls$lambda$16(this), 0.0f, 0.5f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$17(this, arg_0));
        UncivSlider $this$addAdvancedControls_u24lambda_u2420 = uncivSlider = MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Max Coast extension", () -> MapParametersTable.addAdvancedControls$lambda$18(this), 1.0f, 5.0f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$19(this, arg_0));
        boolean bl = false;
        $this$addAdvancedControls_u24lambda_u2420.setStepSize(1.0f);
        UncivSlider $this$addAdvancedControls_u24lambda_u2423 = uncivSlider = MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Biome areas extension", () -> MapParametersTable.addAdvancedControls$lambda$21(this), 1.0f, 15.0f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$22(this, arg_0));
        boolean bl2 = false;
        $this$addAdvancedControls_u24lambda_u2423.setStepSize(1.0f);
        MapParametersTable.addAdvancedControls$addSlider$2(table2, this, "Water level", () -> MapParametersTable.addAdvancedControls$lambda$24(this), -0.1f, 0.1f, arg_0 -> MapParametersTable.addAdvancedControls$lambda$25(this, arg_0));
        MapParametersTable.addAdvancedControls$addTextButton(table2, "Reset to defaults", true, arg_0 -> MapParametersTable.addAdvancedControls$lambda$26(this, arg_0));
    }

    private static final Unit addMapShapeSelectBox$lambda$0(MapParametersTable this$0, List $mapShapes, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        HashSet<String> hashSet = this$0.mapShapesOptionsValues;
        if (hashSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mapShapesOptionsValues");
            hashSet = null;
        }
        if (hashSet.isEmpty()) {
            this$0.mapParameters.setShape((String)CollectionsKt.random($mapShapes, Random.Default));
        } else {
            MapParameters mapParameters = this$0.mapParameters;
            HashSet<String> hashSet2 = this$0.mapShapesOptionsValues;
            if (hashSet2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapShapesOptionsValues");
                hashSet2 = null;
            }
            mapParameters.setShape((String)CollectionsKt.random((Collection)hashSet2, Random.Default));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addMapShapeSelectBox$lambda$1(MapParametersTable this$0, TranslatedSelectBox $mapShapeSelectBox, ChangeListener.ChangeEvent it) {
        this$0.mapParameters.setShape(((TranslatedSelectBox.TranslatedString)$mapShapeSelectBox.getSelected()).getValue());
        this$0.updateWorldSizeTable();
        this$0.generateExampleMap();
        return Unit.INSTANCE;
    }

    private static final Unit addMapTypeSelectBox$lambda$0(MapParametersTable this$0, List $mapTypes, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        HashSet<String> hashSet = this$0.mapTypesOptionsValues;
        if (hashSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mapTypesOptionsValues");
            hashSet = null;
        }
        if (hashSet.isEmpty()) {
            this$0.mapParameters.setType((String)CollectionsKt.random($mapTypes, Random.Default));
        } else {
            MapParameters mapParameters = this$0.mapParameters;
            HashSet<String> hashSet2 = this$0.mapTypesOptionsValues;
            if (hashSet2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapTypesOptionsValues");
                hashSet2 = null;
            }
            mapParameters.setType((String)CollectionsKt.random((Collection)hashSet2, Random.Default));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addMapTypeSelectBox$lambda$1(MapParametersTable this$0, ChangeListener.ChangeEvent it) {
        this$0.mapParameters.setType(((TranslatedSelectBox.TranslatedString)this$0.getMapTypeSelectBox().getSelected()).getValue());
        CheckBox checkBox = this$0.noRuinsCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("noRuinsCheckbox");
            checkBox = null;
        }
        checkBox.setVisible(!Intrinsics.areEqual(this$0.mapParameters.getType(), "Empty"));
        CheckBox checkBox2 = this$0.noNaturalWondersCheckbox;
        if (checkBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("noNaturalWondersCheckbox");
            checkBox2 = null;
        }
        checkBox2.setVisible(!Intrinsics.areEqual(this$0.mapParameters.getType(), "Empty"));
        this$0.generateExampleMap();
        return Unit.INSTANCE;
    }

    private static final Unit addWorldSizeTable$lambda$0(MapParametersTable this$0, List $mapSizes, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        HashSet<String> hashSet = this$0.mapSizesOptionsValues;
        if (hashSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mapSizesOptionsValues");
            hashSet = null;
        }
        if (hashSet.isEmpty()) {
            this$0.mapParameters.setMapSize(new MapSize((String)CollectionsKt.random($mapSizes, Random.Default)));
        } else {
            MapParameters mapParameters = this$0.mapParameters;
            HashSet<String> hashSet2 = this$0.mapSizesOptionsValues;
            if (hashSet2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapSizesOptionsValues");
                hashSet2 = null;
            }
            mapParameters.setMapSize(new MapSize((String)CollectionsKt.random((Collection)hashSet2, Random.Default)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addWorldSizeTable$lambda$1(MapParametersTable this$0, ChangeListener.ChangeEvent it) {
        this$0.updateWorldSizeTable();
        this$0.generateExampleMap();
        return Unit.INSTANCE;
    }

    private static final Unit addHexagonalSizeTable$lambda$0(MapParametersTable this$0, ChangeListener.ChangeEvent it) {
        Integer n = this$0.getCustomMapSizeRadius().getIntValue();
        this$0.mapParameters.setMapSize(new MapSize(n != null ? n : 0));
        return Unit.INSTANCE;
    }

    private static final Unit addRectangularSizeTable$lambda$0(MapParametersTable this$0, ChangeListener.ChangeEvent it) {
        Integer n = this$0.getCustomMapWidth().getIntValue();
        Integer n2 = this$0.getCustomMapHeight().getIntValue();
        this$0.mapParameters.setMapSize(new MapSize(n != null ? n : 0, n2 != null ? n2 : 0));
        return Unit.INSTANCE;
    }

    private static final Unit addRectangularSizeTable$lambda$1(MapParametersTable this$0, ChangeListener.ChangeEvent it) {
        Integer n = this$0.getCustomMapWidth().getIntValue();
        Integer n2 = this$0.getCustomMapHeight().getIntValue();
        this$0.mapParameters.setMapSize(new MapSize(n != null ? n : 0, n2 != null ? n2 : 0));
        return Unit.INSTANCE;
    }

    private static final Unit addResourceSelectBox$lambda$0(MapParametersTable this$0, List $mapResources, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        HashSet<String> hashSet = this$0.mapResourcesOptionsValues;
        if (hashSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mapResourcesOptionsValues");
            hashSet = null;
        }
        if (hashSet.isEmpty()) {
            this$0.mapParameters.setMapResources((String)CollectionsKt.random($mapResources, Random.Default));
        } else {
            MapParameters mapParameters = this$0.mapParameters;
            HashSet<String> hashSet2 = this$0.mapResourcesOptionsValues;
            if (hashSet2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mapResourcesOptionsValues");
                hashSet2 = null;
            }
            mapParameters.setMapResources((String)CollectionsKt.random((Collection)hashSet2, Random.Default));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addResourceSelectBox$lambda$1(MapParametersTable this$0, ChangeListener.ChangeEvent it) {
        this$0.mapParameters.setMapResources(((TranslatedSelectBox.TranslatedString)this$0.getResourceSelectBox().getSelected()).getValue());
        return Unit.INSTANCE;
    }

    private static final Unit addNoRuinsCheckbox$lambda$0(MapParametersTable this$0, boolean it) {
        this$0.mapParameters.setNoRuins(it);
        return Unit.INSTANCE;
    }

    private static final Unit addNoNaturalWondersCheckbox$lambda$0(MapParametersTable this$0, boolean it) {
        this$0.mapParameters.setNoNaturalWonders(it);
        return Unit.INSTANCE;
    }

    private static final Unit addWorldWrapCheckbox$lambda$0(MapParametersTable this$0, boolean it) {
        this$0.mapParameters.setWorldWrap(it);
        return Unit.INSTANCE;
    }

    private static final Unit addStrategicBalanceCheckbox$lambda$0(MapParametersTable this$0, boolean it) {
        this$0.mapParameters.setStrategicBalance(it);
        return Unit.INSTANCE;
    }

    private static final Unit addLegendaryStartCheckbox$lambda$0(MapParametersTable this$0, boolean it) {
        this$0.mapParameters.setLegendaryStart(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addWrappedCheckBoxes$lambda$0(MapParametersTable this$0, String $worldWrapWarning, Table it) {
        void $this$addWrappedCheckBoxes_u24lambda_u240_u240;
        Label label;
        Intrinsics.checkNotNullParameter(it, "it");
        Cell cell = it.defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 5.0f, 0.0f);
        this$0.addStrategicBalanceCheckbox(it);
        this$0.addLegendaryStartCheckbox(it);
        this$0.addNoRuinsCheckbox(it);
        this$0.addNoNaturalWondersCheckbox(it);
        this$0.addWorldWrapCheckbox(it);
        Label label2 = label = Scene2dExtensionsKt.toLabel$default($worldWrapWarning, null, 14, 0, false, 13, null);
        Table table2 = it;
        boolean bl = false;
        $this$addWrappedCheckBoxes_u24lambda_u240_u240.setWrap(true);
        table2.add((Actor)label).colspan(2).fillX().row();
        return Unit.INSTANCE;
    }

    private static final Unit addAdvancedSettings$lambda$0(MapParametersTable this$0, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.addAdvancedControls(it);
        return Unit.INSTANCE;
    }

    private static final Unit addAdvancedControls$lambda$0(MapParametersTable this$0, ChangeListener.ChangeEvent it) {
        MapParameters mapParameters = this$0.mapParameters;
        UncivTextField.Numeric numeric = this$0.seedTextField;
        if (numeric == null) {
            Intrinsics.throwUninitializedPropertyAccessException("seedTextField");
            numeric = null;
        }
        Number number = numeric.getValue();
        mapParameters.setSeed(number != null ? number.longValue() : 0L);
        return Unit.INSTANCE;
    }

    private static final UncivSlider addAdvancedControls$addSlider(Table $table, MapParametersTable this$0, String text2, Function0<Float> getValue, float min, float max, float step, Function1<? super Float, Unit> onChange) {
        float f = ((Number)getValue.invoke()).floatValue();
        UncivSlider slider2 = new UncivSlider(min, max, step, false, false, f, null, null, null, arg_0 -> MapParametersTable.addAdvancedControls$addSlider$lambda$1(onChange, this$0, arg_0), 472, null);
        $table.add((Actor)Scene2dExtensionsKt.toLabel(text2)).left();
        $table.add((Actor)slider2).fillX().row();
        ((Map)this$0.advancedSliders).put(slider2, getValue);
        return slider2;
    }

    private static final Unit addAdvancedControls$addSlider$lambda$1(Function1 $onChange, MapParametersTable this$0, float it) {
        $onChange.invoke(Float.valueOf(it));
        this$0.generateExampleMap();
        return Unit.INSTANCE;
    }

    private static final UncivSlider addAdvancedControls$addSlider$2(Table $table, MapParametersTable this$0, String text2, Function0<Float> getValue, float min, float max, Function1<? super Float, Unit> onChange) {
        float step = (max - min) / (float)20;
        return MapParametersTable.addAdvancedControls$addSlider($table, this$0, text2, getValue, min, max, step, onChange);
    }

    private static final void addAdvancedControls$addTextButton(Table $table, String text2, boolean shouldAddToTable, Function1<? super Boolean, Unit> action2) {
        TextButton button = Scene2dExtensionsKt.toTextButton$default(text2, null, false, 3, null);
        ActivationExtensionsKt.onClick(button, () -> MapParametersTable.addAdvancedControls$addTextButton$lambda$3(action2));
        if (shouldAddToTable) {
            $table.add((Actor)button).colspan(2).padTop(10.0f).row();
        }
    }

    static /* synthetic */ void addAdvancedControls$addTextButton$default(Table table2, String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        MapParametersTable.addAdvancedControls$addTextButton(table2, string, bl, function1);
    }

    private static final Unit addAdvancedControls$addTextButton$lambda$3(Function1 $action) {
        $action.invoke(true);
        return Unit.INSTANCE;
    }

    private static final void addAdvancedControls$addCheckBox(Table $table, String text2, boolean initialState, Function1<? super Boolean, Unit> action2) {
        CheckBox checkbox = Scene2dExtensionsKt.toCheckBox(text2, initialState, arg_0 -> MapParametersTable.addAdvancedControls$addCheckBox$lambda$4(action2, arg_0));
        $table.add((Actor)checkbox).colspan(2).row();
    }

    private static final Unit addAdvancedControls$addCheckBox$lambda$4(Function1 $action, boolean it) {
        $action.invoke(it);
        return Unit.INSTANCE;
    }

    private static final Unit addAdvancedControls$lambda$5(MapParametersTable this$0, boolean it) {
        this$0.randomizeSeed = it;
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$6(MapParametersTable this$0) {
        return this$0.mapParameters.getElevationExponent();
    }

    private static final Unit addAdvancedControls$lambda$7(MapParametersTable this$0, float it) {
        this$0.mapParameters.setElevationExponent(it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$8(MapParametersTable this$0) {
        return this$0.mapParameters.getTemperatureintensity();
    }

    private static final Unit addAdvancedControls$lambda$9(MapParametersTable this$0, float it) {
        this$0.mapParameters.setTemperatureintensity(it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$10(MapParametersTable this$0) {
        return this$0.mapParameters.getTemperatureShift();
    }

    private static final Unit addAdvancedControls$lambda$11(MapParametersTable this$0, float it) {
        this$0.mapParameters.setTemperatureShift(it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$12(MapParametersTable this$0) {
        return this$0.mapParameters.getResourceRichness();
    }

    private static final Unit addAdvancedControls$lambda$13(MapParametersTable this$0, float it) {
        this$0.mapParameters.setResourceRichness(it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$14(MapParametersTable this$0) {
        return this$0.mapParameters.getVegetationRichness();
    }

    private static final Unit addAdvancedControls$lambda$15(MapParametersTable this$0, float it) {
        this$0.mapParameters.setVegetationRichness(it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$16(MapParametersTable this$0) {
        return this$0.mapParameters.getRareFeaturesRichness();
    }

    private static final Unit addAdvancedControls$lambda$17(MapParametersTable this$0, float it) {
        this$0.mapParameters.setRareFeaturesRichness(it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$18(MapParametersTable this$0) {
        return this$0.mapParameters.getMaxCoastExtension();
    }

    private static final Unit addAdvancedControls$lambda$19(MapParametersTable this$0, float it) {
        this$0.mapParameters.setMaxCoastExtension((int)it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$21(MapParametersTable this$0) {
        return this$0.mapParameters.getTilesPerBiomeArea();
    }

    private static final Unit addAdvancedControls$lambda$22(MapParametersTable this$0, float it) {
        this$0.mapParameters.setTilesPerBiomeArea((int)it);
        return Unit.INSTANCE;
    }

    private static final float addAdvancedControls$lambda$24(MapParametersTable this$0) {
        return this$0.mapParameters.getWaterThreshold();
    }

    private static final Unit addAdvancedControls$lambda$25(MapParametersTable this$0, float it) {
        this$0.mapParameters.setWaterThreshold(it);
        return Unit.INSTANCE;
    }

    private static final Unit addAdvancedControls$lambda$26(MapParametersTable this$0, boolean it) {
        this$0.mapParameters.resetAdvancedSettings();
        UncivTextField.Numeric numeric = this$0.seedTextField;
        if (numeric == null) {
            Intrinsics.throwUninitializedPropertyAccessException("seedTextField");
            numeric = null;
        }
        numeric.setValue(this$0.mapParameters.getSeed());
        for (Map.Entry entry : ((Map)this$0.advancedSliders).entrySet()) {
            ((UncivSlider)entry.getKey()).setValue(((Number)((Function0)entry.getValue()).invoke()).floatValue());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getForMapEditor$p(MapParametersTable $this) {
        return $this.forMapEditor;
    }

    public static final /* synthetic */ MapParameters access$getMapParameters$p(MapParametersTable $this) {
        return $this.mapParameters;
    }

    public static final /* synthetic */ Table access$getMapTypeExample$p(MapParametersTable $this) {
        return $this.mapTypeExample;
    }

    public static final /* synthetic */ float access$getMaxMapSize$p(MapParametersTable $this) {
        return $this.maxMapSize;
    }
}

