/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/unciv/models/ruleset/unique/UniqueTriggerExecutors;", "", "<init>", "()V", "triggerGlobalAlerts", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "alertText", "", "triggerNotificationText", "core"})
public final class UniqueTriggerExecutors {
    @NotNull
    public static final UniqueTriggerExecutors INSTANCE = new UniqueTriggerExecutors();

    private UniqueTriggerExecutors() {
    }

    public final boolean triggerGlobalAlerts(@NotNull Civilization civInfo, @NotNull String alertText, @NotNull String triggerNotificationText) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(alertText, "alertText");
        Intrinsics.checkNotNullParameter(triggerNotificationText, "triggerNotificationText");
        Pair<String, String> pair = StringsKt.startsWith$default(triggerNotificationText, "due to adopting ", false, 2, null) ? TuplesKt.to("has adopted the " + StringsKt.removePrefix(triggerNotificationText, (CharSequence)"due to adopting ") + " policy", "StatIcons/Culture") : (StringsKt.startsWith$default(triggerNotificationText, "due to researching ", false, 2, null) ? TuplesKt.to("has researched " + StringsKt.removePrefix(triggerNotificationText, (CharSequence)"due to researching "), "StatIcons/Science") : (StringsKt.startsWith$default(triggerNotificationText, "due to ", false, 2, null) ? TuplesKt.to(StringsKt.removePrefix(triggerNotificationText, (CharSequence)"due to "), "") : TuplesKt.to(triggerNotificationText, "")));
        String messageSuffix = pair.component1();
        String iconName = pair.component2();
        Iterator<Civilization> iterator2 = civInfo.getGameInfo().getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (Intrinsics.areEqual(civ, civInfo) || !civ.isMajorCiv()) continue;
            String defaultNotificationText = SequencesKt.contains(civ.getKnownCivs(), civInfo) ? '[' + civInfo.getCivName() + "] " + messageSuffix : "[An unknown civilization] " + messageSuffix;
            String[] stringArray = new String[]{iconName};
            civ.addNotification('{' + defaultNotificationText + "}.\n{" + alertText + '}', Notification.NotificationCategory.General, stringArray);
        }
        return true;
    }
}

