-- 
-- DO NOT EDIT THIS FILE. IT WILL BE OVERWRITTEN WHEN YOU UPGRADE RAINLENDAR!
-- 

--
-- Creates a new event or task from the given string.
--
-- Parameters: 
--    text - The text for the quick add.
--    window - The window where the event was created.
--    id - The id of the edit box item which is cleared after the event is created.
-- Return:
--    None
--
function Global_QuickAdd(text, window, id)
  Rainlendar_QuickAdd(text, window, id)
  if (window and id) then
    -- Clear the edit box 
    Rainlendar_SetItemValue(window, id, "text", "");
    Rainlendar_Redraw(1);
  end
end

--
-- Creates a new event from the given string.
--
-- Parameters: 
--    text - The text for the quick add.
--    window - The window where the event was created.
--    id - The id of the edit box item which is cleared after the event is created.
-- Return:
--    None
--
function Global_QuickAdd_Event(text, window, id)
  Rainlendar_QuickAdd("event " .. text, window, id)
  if (window and id) then
    -- Clear the edit box 
    Rainlendar_SetItemValue(window, id, "text", "");
    Rainlendar_Redraw(1);
  end
end

--
-- Creates a new task from the given string.
--
-- Parameters: 
--    text - The text for the quick add.
--    window - The window where the event was created.
--    id - The id of the edit box item which is cleared after the event is created.
-- Return:
--    None
--
function Global_QuickAdd_Task(text, window, id)
  Rainlendar_QuickAdd("todo " .. text, window, id)
  if (window and id) then
    -- Clear the edit box 
    Rainlendar_SetItemValue(window, id, "text", ""); 
    Rainlendar_Redraw(1);
  end
end
