# Copyright 2023 The JAX Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# ruff: noqa

import datetime
import numpy as np

array = np.array
float32 = np.float32

data_2024_08_05 = {}


# Pasted from the test output (see export_back_compat_test_util.py module docstring)
data_2024_08_05["f32_syevj"] = dict(
    testdata_version=1,
    platform='rocm',
    custom_call_targets=['hipsolver_syevj'],
    serialized_date=datetime.date(2024, 8, 5),
    inputs=(),
    expected_outputs=(array([[ 0.61857724 ,  0.07361191 ,  0.13168913 , -0.27208394 ,
         0.49487755 , -0.29494426 ,  0.39325187 ,  0.18446995 ],
       [ 0.4707088  ,  0.320408   , -0.62100405 ,  0.043493155,
        -0.45037657 ,  0.17930098 ,  0.03168225 ,  0.22856663 ],
       [ 0.32284078 , -0.5791365  ,  0.11131581 ,  0.41311264 ,
        -0.23173825 , -0.40550187 , -0.2912762  ,  0.27266365 ],
       [ 0.17497253 , -0.39477745 ,  0.16420567 , -0.38256654 ,
         0.061230693,  0.6971812  , -0.22375679 ,  0.31676033 ],
       [ 0.027104245,  0.45940062 ,  0.6868946  ,  0.21404612 ,
        -0.333589   ,  0.11481202 ,  0.1260774  ,  0.36085692 ],
       [-0.12076393 ,  0.39085838 , -0.112849206, -0.036542006,
         0.38946068 , -0.18016829 , -0.685892   ,  0.40495366 ],
       [-0.2686322  , -0.122857824, -0.24418682 ,  0.53927773 ,
         0.3737299  ,  0.24348967 ,  0.40210366 ,  0.4490505  ],
       [-0.41650033 , -0.14750715 , -0.11606514 , -0.51873696 ,
        -0.30359516 , -0.35416928 ,  0.24780981 ,  0.49314728 ]],
      dtype=float32), array([-2.4598804e+01, -1.3325786e-05, -5.9161835e-06, -1.0833635e-06,
        5.0254232e-07,  1.2251726e-06,  5.4492839e-06,  2.7659888e+02],
      dtype=float32)),
    mlir_module_text=r"""
#loc3 = loc("/release/jax/tests/export_back_compat_test.py":263:0)
#loc9 = loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))
module @jit__lambda_ attributes {jax.uses_shape_polymorphism = false, mhlo.num_partitions = 1 : i32, mhlo.num_replicas = 1 : i32} {
  func.func public @main() -> (tensor<8x8xf32> {jax.result_info = "[0]", mhlo.layout_mode = "default"}, tensor<8xf32> {jax.result_info = "[1]", mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<64xf32> loc(#loc4)
    %1 = stablehlo.reshape %0 : (tensor<64xf32>) -> tensor<8x8xf32> loc(#loc5)
    %2 = stablehlo.transpose %1, dims = [1, 0] : (tensor<8x8xf32>) -> tensor<8x8xf32> loc(#loc6)
    %3 = stablehlo.add %1, %2 : tensor<8x8xf32> loc(#loc7)
    %cst = stablehlo.constant dense<2.000000e+00> : tensor<f32> loc(#loc)
    %4 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f32>) -> tensor<8x8xf32> loc(#loc8)
    %5 = stablehlo.divide %3, %4 : tensor<8x8xf32> loc(#loc8)
    %6 = call @tril(%5) : (tensor<8x8xf32>) -> tensor<8x8xf32> loc(#loc9)
    %c = stablehlo.constant dense<8> : tensor<i64> loc(#loc10)
    %c_0 = stablehlo.constant dense<8> : tensor<i64> loc(#loc10)
    %7:4 = stablehlo.custom_call @hipsolver_syevj(%6) {api_version = 2 : i32, backend_config = "\00\00\00\00z\00\00\00\01\00\00\00\08\00\00\00\00\01\00\00", operand_layouts = [dense<[0, 1]> : tensor<2xindex>], output_operand_aliases = [#stablehlo.output_operand_alias<output_tuple_indices = [0], operand_index = 0, operand_tuple_indices = []>], result_layouts = [dense<[0, 1]> : tensor<2xindex>, dense<0> : tensor<1xindex>, dense<> : tensor<0xindex>, dense<0> : tensor<1xindex>]} : (tensor<8x8xf32>) -> (tensor<8x8xf32>, tensor<8xf32>, tensor<i32>, tensor<256xf32>) loc(#loc10)
    %c_1 = stablehlo.constant dense<0> : tensor<i32> loc(#loc10)
    %8 = stablehlo.broadcast_in_dim %c_1, dims = [] : (tensor<i32>) -> tensor<i32> loc(#loc10)
    %9 = stablehlo.compare  EQ, %7#2, %8,  SIGNED : (tensor<i32>, tensor<i32>) -> tensor<i1> loc(#loc10)
    %10 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1x1xi1> loc(#loc10)
    %cst_2 = stablehlo.constant dense<0x7FC00000> : tensor<f32> loc(#loc10)
    %11 = stablehlo.broadcast_in_dim %cst_2, dims = [] : (tensor<f32>) -> tensor<8x8xf32> loc(#loc10)
    %12 = stablehlo.broadcast_in_dim %10, dims = [0, 1] : (tensor<1x1xi1>) -> tensor<8x8xi1> loc(#loc10)
    %13 = stablehlo.select %12, %7#0, %11 : tensor<8x8xi1>, tensor<8x8xf32> loc(#loc10)
    %14 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1xi1> loc(#loc10)
    %cst_3 = stablehlo.constant dense<0x7FC00000> : tensor<f32> loc(#loc10)
    %15 = stablehlo.broadcast_in_dim %cst_3, dims = [] : (tensor<f32>) -> tensor<8xf32> loc(#loc10)
    %16 = stablehlo.broadcast_in_dim %14, dims = [0] : (tensor<1xi1>) -> tensor<8xi1> loc(#loc10)
    %17 = stablehlo.select %16, %7#1, %15 : tensor<8xi1>, tensor<8xf32> loc(#loc10)
    return %13, %17 : tensor<8x8xf32>, tensor<8xf32> loc(#loc)
  } loc(#loc)
  func.func private @tril(%arg0: tensor<8x8xf32> {mhlo.layout_mode = "default"} loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))) -> (tensor<8x8xf32> {mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<8x8xi32> loc(#loc11)
    %c = stablehlo.constant dense<0> : tensor<i32> loc(#loc9)
    %1 = stablehlo.broadcast_in_dim %c, dims = [] : (tensor<i32>) -> tensor<8x8xi32> loc(#loc12)
    %2 = stablehlo.add %0, %1 : tensor<8x8xi32> loc(#loc12)
    %3 = stablehlo.iota dim = 1 : tensor<8x8xi32> loc(#loc13)
    %4 = stablehlo.compare  GE, %2, %3,  SIGNED : (tensor<8x8xi32>, tensor<8x8xi32>) -> tensor<8x8xi1> loc(#loc14)
    %cst = stablehlo.constant dense<0.000000e+00> : tensor<f32> loc(#loc9)
    %5 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f32>) -> tensor<8x8xf32> loc(#loc15)
    %6 = stablehlo.select %4, %arg0, %5 : tensor<8x8xi1>, tensor<8x8xf32> loc(#loc16)
    return %6 : tensor<8x8xf32> loc(#loc9)
  } loc(#loc9)
} loc(#loc)
#loc = loc(unknown)
#loc1 = loc("/release/jax/tests/export_back_compat_test.py":255:0)
#loc2 = loc("/release/jax/tests/export_back_compat_test.py":257:0)
#loc4 = loc("jit(<lambda>)/jit(main)/iota[dtype=float32 shape=(64,) dimension=0]"(#loc1))
#loc5 = loc("jit(<lambda>)/jit(main)/reshape[new_sizes=(8, 8) dimensions=None]"(#loc1))
#loc6 = loc("jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]"(#loc2))
#loc7 = loc("jit(<lambda>)/jit(main)/add"(#loc2))
#loc8 = loc("jit(<lambda>)/jit(main)/div"(#loc2))
#loc10 = loc("jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]"(#loc3))
#loc11 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=0]"(#loc3))
#loc12 = loc("jit(<lambda>)/jit(main)/jit(tril)/add"(#loc3))
#loc13 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=1]"(#loc3))
#loc14 = loc("jit(<lambda>)/jit(main)/jit(tril)/ge"(#loc3))
#loc15 = loc("jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(8, 8) broadcast_dimensions=()]"(#loc3))
#loc16 = loc("jit(<lambda>)/jit(main)/jit(tril)/select_n"(#loc3))
""",
    mlir_module_serialized=b"ML\xefR\x01StableHLO_v0.9.0\x00\x01+\x05\x01\x03\x01\x03\x05\x03\x1b\x07\t\x0b\r\x0f\x11\x13\x15\x17\x19\x1b\x1d\x1f\x03n\x02\xeb9\x01\x97\x0f\x17\x13\x0f\x0b\x07\x0b\x0b\x0b\x17\x0f\x0b\x0b\x0b\x0b\x13\x0b\x13\x0f\x0b\x0b\x17\x0f\x13\x13+\x0b\x0f\x0b\x0b\x0b33\x0b\x0f\x0b\x0b\x13\x0f\x0b\x1b\x0f\x0b\x13\x0f\x0b\x0f\x0b\x0f\x0b\x0f\x0b\x13\x0b\x0f\x0b\x0f\x0b\x13\x0b\x13\x0b\x0bK\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x1b\x13\x13\x03U\x0b\x0b\x0b\x0b\x0f\x0b\x0bO/\x0b\x13\x1b\x0b\x1b\x0b\x0b\x0b\x13\x0b\x0b\x0f\x1f\x0f\x0f\x0b\x1fO\x1f/\x0b\x0b\x0b\x0b\x0f\x0f\x17\x1b\x0f\x0b\x1fO/\x01\x05\x0b\x0f\x035\x17\x0f\x07\x07\x0f\x07\x13\x17\x0f\x07\x07\x17\x13\x17\x17\x13\x17\x17\x13\x13\x13\x0f\x17\x13\x13\x13\x02\xae\x08\x1d}\x03\x17\x0f\x1e\x04\x01\x03\x03\x11\xc3\x1dC\x03\x05!\x1f\x05#\x05%\x05'\x17\x0f\x06\x04\x01\x11\x03\x05\x05)\x05+\x05-\x05/\x03\x03!\xbf\x051\x03\x03\t\xc1\x1dI\x03\x053\x055\x17\x0f\xfe\x03\x01\x1dw\x13\x03\x03\t\xcf\x03\x03\t\xe5\x03\t579\x15;\x15\r=\x057\x11\x01\x00\x059\x05;\x05=\x03\x0b\x17\x9b\x19\xa9\x1b\xab\r\xb5\x1d\xb7\x03\x0b\x17\x9f\x19\xbb\x1b\x9f\r\xa1\x1d\xbd\x05?\x1dG\x03\x05A\x05C\x03\x03!\xc5\x1dO\x03\x05E\x03\x05'\xa3)\xc7\x1dU\x03\x05G\x03\x03\t\xc9\x1d[\x03\x05I\x1d_\x03\x05K\x1dc+\x05M\x1dg+\x05O\x03\x03k\xcb\x05Q\x1do\x13\x05S\x1ds\x13\x05U\x03\x03\t\xcd\x05W\x03\x03{\xa1\x05Y\x05[\x03\x11\x81\xd1\x83\xd3\x85\xd5\x87\x9b\x89\xd7\x8b\xd9\x8d\xdb\x8f\xdf\x05]\x05_\x05a\x05c\x05e\x05g\x05i\x05k\x03\x05'\xa3)\xe3\x03\x03\x11\xe7\x03\x03\x11\xe9\x1dm\x1do\x03\x01\x1dq\x03\x03\xb9\x1ds\t\x07\x1f)!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f+\x11\x00\x00\x00\x00\x00\x00\x00\x00#\x1f\x03\x05\xad\xb1\r\x05\x9d\xaf\x97\x99\x1du\r\x05\x9d\xb3\x97\x99\x1dw\x1dy\x1d{\r\x03\x97\x99#!\x1d}\x13\t\x01\x1f\r\t\x00\x00\x00\x00\x1f#\x01\x13\t\x05\x07\x05\x1f\x07\t\x00\x00\x00\x00\x1f\x1d!\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x07\t\x00\x00\x00@\x1f\x15\x11\x08\x00\x00\x00\x00\x00\x00\x00\x0b\x05\x1d\x7f\x1d\x81\x05\x01\x03\x03\xa5\x03\x03\xdd\x15\x03\x01\x01\x01\x03\t\xa5\xa7\xe1\xa7\x1f-\x01\x07\x01\x1f\x07\t\x00\x00\xc0\x7f\x1f\x1d!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f7\x11\x00\x00\x00\x00\x00\x00\x00\x00\x01\t\x01\x02\x02)\x05!!\x0b)\x01\x0b\x1d\t)\x01\x19\x01)\x03!\x0b)\x05!!\x19)\x01\t\x13\x1b)\x05!!\x0f)\x03\t\t\x11\x01\x05\x05\x11\x11\x03\x05\x03\x05)\x03\x01\t)\x03\x02\x02\x0b)\x03\x02\x08\x0b)\x03\t\x17)\x03\x05\x17)\x03\x01\x17)\x01\x0f)\x05\x05\x05\x0f)\x03\x05\x0f)\x03!\x0f)\x03\x05\t\x04\x82\x04\x05\x01\x11\x0b3\x07\x03\x01\t\x0b\x11\x0b?\x07\x037e\x07\x03a\x1f\x03%\x13\x06e\x03\x05\x03\x01\x15\x07mi\x03\x05\x03\x03\r\x06q\x03\x05\x05\x03\x05\x05\x03\x0bu\x03\x07\x03\x07-\x05\x03\x05\x03\t\x17\x06-\x03\x05\x05\x07\x0b\x19\x07\x07y\x03\x05\x03\r\x05\x03\x01/\x03\x15\x05\x03\x01/\x03\x15\x1b\x07\x01\x7f\t\x05\x11\r'\x03\x0f\x05\x03\x01#\x03\r\x03\x07\x01\x05\x03\r\x03\x1d\x0f\x07\x01\x91\x03/\x05\x19\x1f\x03\x07\x01\x05\x031\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x05\x03%\x03\x07\x01\x93\x03\x1b\x03#\t\x06\x01\x03\x05\x07)\x15'\x03\x07\x01\x05\x033\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x11\x03/\x03\x07\x01\x95\x035\x03-\t\x06\x01\x03\x11\x073\x171\x11\x04\x0b\x05+5\x0b\x11\x07A\x07\x03\x15+\x03\x05\x07\x07\x03E\x1f\x03\x13\x05\x03\x07#\x03\r\x03\x07%\x05\x03\x13\x03\x05\r\x06%\x03\x13\x05\x03\x07\x07\x03MK\x03\x13\x0f\x07SQ\x03\x1b\x05\t\x0b\x05\x03\x07W\x03\x07\x03\x07Y\x05\x03\x05\x03\x0f\t\x06]\x03\x05\x07\r\x01\x11\x11\x04\x07\x03\x13\x06\x03\x01\x05\x01\x00\xf6\x19\x83!+\x11\x0f\x0b\t\t\x0b!\x11#\x1f/!!)#\x1f\x19\xa9\x0f99m\x19\x85\x89W\xb3K\x9bM\x9bn\x03\x1b%)9+\x1b\x1f\x1f\x15\x1d\x15+]\x13\r\x1f\x11\x15\x1b\x17\x15\x17\x0f\x11\x15\x11\x19)\x0f\x0b\x11builtin\x00vhlo\x00module\x00broadcast_in_dim_v1\x00constant_v1\x00iota_v1\x00select_v1\x00func_v1\x00add_v1\x00compare_v1\x00return_v1\x00reshape_v1\x00transpose_v1\x00divide_v1\x00call_v1\x00custom_call_v1\x00value\x00sym_name\x00/release/jax/tests/export_back_compat_test.py\x00broadcast_dimensions\x00arg_attrs\x00function_type\x00res_attrs\x00sym_visibility\x00iota_dimension\x00compare_type\x00comparison_direction\x00jax.uses_shape_polymorphism\x00mhlo.num_partitions\x00mhlo.num_replicas\x00jit__lambda_\x00jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=0]\x00jit(<lambda>)/jit(main)/jit(tril)/add\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=1]\x00jit(<lambda>)/jit(main)/jit(tril)/ge\x00jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(8, 8) broadcast_dimensions=()]\x00jit(<lambda>)/jit(main)/jit(tril)/select_n\x00jit(<lambda>)/jit(main)/iota[dtype=float32 shape=(64,) dimension=0]\x00jit(<lambda>)/jit(main)/reshape[new_sizes=(8, 8) dimensions=None]\x00permutation\x00jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]\x00jit(<lambda>)/jit(main)/add\x00jit(<lambda>)/jit(main)/div\x00callee\x00jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]\x00api_version\x00backend_config\x00call_target_name\x00called_computations\x00has_side_effect\x00operand_layouts\x00output_operand_aliases\x00result_layouts\x00mhlo.layout_mode\x00default\x00jax.result_info\x00tril\x00[0]\x00[1]\x00main\x00public\x00private\x00\x00\x00\x00\x00z\x00\x00\x00\x01\x00\x00\x00\x08\x00\x00\x00\x00\x01\x00\x00\x00hipsolver_syevj\x00",
    xla_call_module_version=9,
    nr_devices=1,
)  # End paste


# Pasted from the test output (see export_back_compat_test_util.py module docstring)
data_2024_08_05["f32_syevd"] = dict(
    testdata_version=1,
    platform='rocm',
    custom_call_targets=['hipsolver_syevd'],
    serialized_date=datetime.date(2024, 8, 5),
    inputs=(),
    expected_outputs=(array([[ 3.14863652e-01,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00, -9.45194840e-01,
         0.00000000e+00,  0.00000000e+00,  8.64148363e-02],
       [ 2.99391985e-01,  4.25571829e-01, -2.43780971e-01,
         9.64008365e-03,  4.19693999e-03,  8.43246430e-02,
        -2.03860849e-02,  1.74249988e-02, -1.47179840e-02,
        -1.60037074e-02,  7.07753235e-03,  4.85950802e-03,
        -4.31822762e-02, -5.24833985e-03,  3.59393889e-03,
        -1.55661895e-03, -8.69501568e-03,  3.28632382e-07,
         2.66459654e-03, -7.25963246e-03,  2.96158548e-02,
        -7.45778810e-03,  4.77074794e-02, -6.57704193e-03,
        -9.33276210e-03,  3.05249952e-02,  6.40692702e-03,
        -1.53717035e-02, -6.95880409e-03,  7.44953454e-02,
         5.03141060e-02,  1.27634211e-02,  1.08022302e-01,
         6.42597377e-02, -7.88945973e-01,  9.06610861e-02],
       [ 2.83920407e-01, -5.66396583e-03,  4.14810143e-02,
        -1.57968083e-03,  1.14318267e-01,  1.30412519e-01,
        -1.92104969e-02,  7.65830576e-02,  1.95931882e-01,
         2.91190930e-02, -1.13351583e-01,  2.49776512e-01,
        -1.26321644e-01, -5.73716536e-02,  1.07043944e-01,
         1.88543811e-01, -7.89253861e-02,  8.86788598e-07,
        -1.47134870e-01, -9.73718464e-02, -4.87296700e-01,
         5.06853938e-01, -8.14262126e-03,  2.41016045e-01,
         1.03090182e-01, -5.06266616e-02, -5.22911847e-02,
        -1.24461263e-01,  5.78761511e-02,  1.40601918e-02,
        -1.03997380e-01,  1.57857314e-01,  1.03256613e-01,
         8.38932395e-02,  1.15394592e-01,  9.49072838e-02],
       [ 2.68448800e-01,  9.82604641e-03,  1.02954552e-01,
         1.37329819e-02,  1.05068877e-01,  3.35026048e-02,
         2.37181917e-01, -1.92070007e-02,  4.67520580e-02,
         1.63625926e-01, -2.13791862e-01,  7.84423500e-02,
         2.68485576e-01,  1.77425414e-01, -9.57484692e-02,
        -7.43651576e-03,  2.35142961e-01, -4.09258018e-06,
         4.95102435e-01,  2.21400172e-01,  3.09783190e-01,
         5.24909534e-02,  1.26592234e-01,  2.52198577e-01,
         1.08772486e-01,  6.05245121e-02, -7.01531842e-02,
         7.64659494e-02,  1.49893969e-01,  4.93569635e-02,
        -8.27835202e-02,  1.98934451e-01,  9.84909162e-02,
         3.36067043e-02,  9.28091481e-02,  9.91534814e-02],
       [ 2.52977192e-01,  1.22667089e-01, -3.13225873e-02,
         1.16842046e-01, -9.34253111e-02, -7.98491016e-02,
        -1.08730324e-01,  9.39827636e-02,  2.83664733e-01,
        -8.95369053e-02,  6.38066605e-02, -4.05723125e-01,
        -1.59848899e-01,  1.11614212e-01,  1.67401105e-01,
         4.72837202e-02,  1.27244443e-01, -3.02539229e-06,
         1.71125844e-01,  3.22743729e-02,  5.44776358e-02,
         1.45618632e-01, -2.20855966e-01, -4.00584072e-01,
        -3.69722933e-01, -1.28009409e-01, -1.38256952e-01,
         6.75877333e-02,  4.79350127e-02,  5.31037748e-02,
        -1.43398523e-01,  7.18006119e-02,  9.37252194e-02,
         6.16254285e-02,  1.85258284e-01,  1.03399679e-01],
       [ 2.37505645e-01, -2.26043444e-02,  7.16757178e-02,
         3.40515710e-02, -2.92403959e-02,  7.67953396e-02,
         3.44246209e-01, -2.08549470e-01, -1.99930266e-01,
        -2.22235639e-02, -6.39125779e-02, -7.47432038e-02,
        -6.00659959e-02, -5.27023375e-02,  8.39961320e-03,
         5.35039008e-01, -3.36971395e-02, -1.76077253e-06,
        -2.28953421e-01, -2.41563842e-02,  9.03338310e-04,
        -3.03069711e-01, -6.68924674e-02, -2.47795761e-01,
         2.83889890e-01, -1.73643038e-01,  1.43337548e-02,
         1.88991889e-01,  3.63570750e-02,  1.53585002e-01,
         4.57682535e-02,  1.11801215e-01,  8.89595374e-02,
        -1.68208387e-02,  8.57105553e-02,  1.07645884e-01],
       [ 2.22034037e-01, -1.72449034e-02,  8.32246989e-02,
         6.67833388e-02, -7.13545233e-02,  9.38377082e-02,
         1.48278579e-01, -1.30030870e-01, -1.56442627e-01,
        -1.80125702e-02, -3.30680162e-02,  4.71623130e-02,
         1.15315686e-03,  3.11921000e-01,  1.59191623e-01,
        -6.15907907e-01, -1.13558687e-01,  4.03818058e-06,
        -1.82698831e-01, -7.19182147e-03, -1.49156436e-01,
        -1.93804353e-01, -2.34522581e-01,  1.83611229e-01,
        -1.03899136e-01, -2.31900841e-01,  9.18366238e-02,
         8.36111382e-02, -4.00230996e-02,  2.31817216e-01,
         4.15455084e-03,  2.40510777e-02,  8.41938406e-02,
        -3.75697389e-03,  7.56532103e-02,  1.11892089e-01],
       [ 2.06562459e-01,  3.74917947e-02,  1.30626351e-01,
        -3.07454225e-02,  1.40042052e-01, -2.14035347e-01,
        -7.24049434e-02,  2.58590251e-01, -1.06915243e-01,
         1.20999366e-01,  3.04683179e-01, -4.26934510e-01,
         2.33767658e-01, -2.88781315e-01, -9.02941525e-02,
        -7.55149350e-02,  3.20365913e-02, -6.79413517e-07,
         4.11994532e-02, -3.54389362e-02, -2.19872326e-01,
        -2.17722699e-01,  5.19639812e-03,  1.94356769e-01,
         1.95217118e-01, -1.51340276e-01, -1.33133143e-01,
        -3.04251820e-01,  8.42787102e-02, -8.91025062e-04,
         1.63074527e-02, -5.44062182e-02,  7.94281587e-02,
        -8.31298009e-02,  3.79052646e-02,  1.16138294e-01],
       [ 1.91090837e-01,  5.00162728e-02, -1.29520223e-01,
        -5.90372346e-02, -8.65406916e-02,  1.34236917e-01,
        -3.45097743e-02,  8.65988061e-02,  2.79490620e-01,
         2.05838233e-02,  1.63266227e-01,  1.37807339e-01,
        -2.88854484e-02, -1.97935328e-01, -1.91973224e-01,
        -1.78284153e-01, -1.59578741e-01,  3.80867868e-06,
        -2.52721816e-01,  2.00459901e-02,  1.48801759e-01,
        -2.65988290e-01,  9.35036540e-02, -3.38661298e-02,
        -7.47095421e-02,  1.72575608e-01,  7.48608708e-02,
         9.84557569e-02,  1.54632270e-01, -3.83311749e-01,
        -8.60809535e-03,  4.51848537e-01,  7.46624544e-02,
        -9.73466486e-02,  1.60882756e-01,  1.20384492e-01],
       [ 1.75619289e-01, -1.33098036e-01, -7.25874007e-02,
         1.13561042e-01, -9.90359262e-02, -1.12914242e-01,
         4.83775772e-02,  7.59186074e-02, -2.24475950e-01,
         5.46225905e-02, -9.59494561e-02, -1.16172619e-01,
        -1.36224702e-01,  1.72922000e-01, -1.57982349e-01,
         5.23963794e-02, -5.27825177e-01, -4.99983490e-01,
         1.32632498e-02,  1.19400941e-01,  1.14320301e-01,
         1.36612356e-01,  9.59459990e-02,  1.82795748e-02,
        -7.76202902e-02,  2.02041924e-01, -1.76296145e-01,
        -1.29697040e-01, -6.64295927e-02, -7.36788735e-02,
         1.28822401e-01, -1.39017746e-01,  6.98967725e-02,
        -4.42382134e-02,  5.66107631e-02,  1.24630705e-01],
       [ 1.60147697e-01, -1.34168208e-01, -9.76477116e-02,
         1.10807084e-01, -9.40499231e-02, -1.07364252e-01,
         5.10111302e-02,  7.79195130e-02, -2.19746202e-01,
         4.69483435e-02, -8.53394270e-02, -6.70133084e-02,
        -1.45403445e-01,  1.67372435e-01, -1.59806609e-01,
        -1.64794195e-02,  3.78816932e-01,  4.99985248e-01,
        -3.93349200e-01,  9.79585722e-02,  9.76026952e-02,
         1.38070405e-01,  1.18653804e-01,  3.96083295e-02,
        -8.18982199e-02,  2.08111987e-01, -1.50318757e-01,
        -1.45378843e-01, -5.75420968e-02, -1.07475698e-01,
         1.21410295e-01, -1.30408555e-01,  6.51310831e-02,
        -5.44557273e-02,  4.51887660e-02,  1.28876895e-01],
       [ 1.44676089e-01,  6.39092177e-02, -1.50388688e-01,
        -1.30178496e-01, -2.92952508e-01, -1.61994919e-02,
        -3.29122514e-01, -1.05322324e-01, -1.08343333e-01,
        -1.20083001e-02,  1.17546715e-01,  1.41790900e-02,
        -3.99599038e-02, -1.32525535e-02, -6.87524527e-02,
         8.26079026e-02,  9.49627385e-02, -1.86451052e-06,
         1.99367970e-01, -3.71279359e-01, -1.08482443e-01,
        -7.43135214e-02, -7.68682873e-03,  2.53974348e-01,
         5.78375086e-02,  2.90879250e-01, -9.90127623e-02,
         4.50800776e-01, -1.25206664e-01,  1.46664888e-01,
        -3.45899612e-02, -1.41382620e-01,  6.03653826e-02,
        -1.19981647e-01,  1.64673209e-01,  1.33123100e-01],
       [ 1.29204527e-01, -1.40800565e-01, -1.94648772e-01,
         1.19509801e-01, -7.36436099e-02,  2.40059756e-02,
         1.33266285e-01,  1.48748666e-01, -7.33441487e-02,
        -3.23292278e-02, -1.38458848e-01,  2.41324112e-01,
         2.46800348e-01, -1.97345074e-02,  4.24310595e-01,
         9.97781083e-02,  8.43451768e-02, -1.02501144e-06,
         2.46016040e-01, -1.84697926e-01, -1.84237137e-01,
        -2.62236238e-01, -6.04246706e-02, -1.51321203e-01,
        -1.67228580e-01,  1.67972878e-01,  1.63110465e-01,
        -2.70850420e-01, -1.00764349e-01, -2.82720745e-01,
         9.21235457e-02, -1.23493880e-01,  5.55997044e-02,
        -7.95066878e-02,  3.21729295e-02,  1.37369320e-01],
       [ 1.13732919e-01,  1.69869125e-01,  2.16636688e-01,
        -1.90086290e-02, -1.34947062e-01, -1.00553662e-01,
        -3.74003239e-02,  1.28211686e-02, -1.04226666e-02,
        -3.20411444e-01,  5.81970923e-02,  1.83232710e-01,
         2.06695735e-01, -1.20587878e-01, -1.33993238e-01,
         5.60946576e-03, -4.60022390e-01,  5.00015676e-01,
         1.82689577e-01,  1.17452890e-01,  1.03037581e-01,
         1.41579181e-01, -3.63076441e-02, -1.14752963e-01,
         4.46553566e-02, -7.44598135e-02,  9.40572768e-02,
        -9.97839496e-03, -1.65148243e-01,  1.09695913e-02,
         9.02701169e-02, -1.47811279e-01,  5.08340038e-02,
         8.22790936e-02,  9.38541964e-02,  1.41615495e-01],
       [ 9.82613340e-02,  1.68798998e-01,  1.91576466e-01,
        -2.17625964e-02, -1.29961073e-01, -9.50038210e-02,
        -3.47670279e-02,  1.48220630e-02, -5.69301564e-03,
        -3.28085810e-01,  6.88073561e-02,  2.32392371e-01,
         1.97516277e-01, -1.26137361e-01, -1.35816053e-01,
        -6.32714331e-02,  4.46556300e-01, -5.00015557e-01,
        -2.23909408e-01,  9.60104465e-02,  8.63204226e-02,
         1.43036515e-01, -1.35993678e-02, -9.34240893e-02,
         4.03775200e-02, -6.83897138e-02,  1.20034762e-01,
        -2.56601200e-02, -1.56260803e-01, -2.28271037e-02,
         8.28580037e-02, -1.39201969e-01,  4.60683145e-02,
         7.20615312e-02,  8.24322030e-02,  1.45861700e-01],
       [ 8.27897862e-02, -4.03536931e-02,  2.80626118e-01,
        -1.03671260e-01,  1.78634003e-01, -2.77522206e-01,
        -4.88885231e-02, -1.52302325e-01,  3.63253318e-02,
         2.09136933e-01, -7.79025108e-02, -1.49669230e-01,
        -6.80914847e-03, -1.58742175e-01,  4.82238591e-01,
        -1.27875641e-01, -5.78182079e-02,  1.66580094e-06,
        -1.31799474e-01, -2.12181762e-01,  2.21481338e-01,
         1.60462186e-01,  3.41644883e-01, -4.91144471e-02,
         1.68692935e-02,  7.76867941e-02,  1.37031004e-01,
         1.98929638e-01, -1.26049489e-01, -5.88694736e-02,
         2.02749372e-01,  5.61993904e-02,  4.13026363e-02,
         7.58461654e-02, -4.32764925e-02,  1.50107920e-01],
       [ 6.73182011e-02, -3.65638465e-01,  8.70986190e-03,
         8.47191513e-02,  3.29391025e-02,  4.41194803e-01,
        -2.64016509e-01, -2.21770808e-01,  1.73684984e-01,
         2.20590055e-01,  7.49032851e-03, -1.02773830e-01,
         1.71031758e-01, -1.19087823e-01, -1.62434027e-01,
         5.43118492e-02,  1.25464564e-02, -9.71963573e-07,
        -2.47708559e-02, -9.39220637e-02,  1.99302211e-01,
         5.80382394e-03, -2.70414054e-01,  3.95417884e-02,
        -3.88318747e-02, -5.80481216e-02, -1.22846523e-02,
        -1.44364744e-01, -2.29458287e-01,  2.90658474e-02,
         2.12228388e-01, -5.77764474e-02,  3.65369543e-02,
         3.05966675e-01, -8.44403207e-02,  1.54354140e-01],
       [ 5.18466011e-02, -7.75161758e-02,  7.81712830e-02,
        -9.84597281e-02,  1.02098189e-01, -2.45368868e-01,
        -1.83603108e-01, -1.08472176e-01, -1.36410519e-01,
         1.47689328e-01,  1.96252558e-02,  5.92750236e-02,
        -4.20911849e-01,  1.76000357e-01, -3.00298661e-01,
         2.31122691e-02,  1.06393531e-01, -1.55148587e-06,
         2.83350378e-01,  2.71575246e-02, -1.77185625e-01,
        -6.25264347e-02, -4.90352586e-02, -8.53841975e-02,
         3.00312396e-02, -1.68193743e-01,  4.86308187e-01,
        -6.63431063e-02, -7.58932829e-02, -2.19800696e-01,
         6.77596107e-02,  1.28289238e-01,  3.17712538e-02,
         7.34912679e-02, -4.58134562e-02,  1.58600315e-01],
       [ 3.63749862e-02,  4.81587462e-02,  5.25593422e-02,
        -8.46534520e-02,  2.30532423e-01,  1.13990083e-02,
        -2.77710587e-01,  1.75043136e-01,  6.22511134e-02,
        -1.02933154e-01, -1.73787430e-01,  5.89673854e-02,
        -2.54093200e-01, -6.24534227e-02,  2.03905135e-01,
         1.37850016e-01, -4.53693308e-02,  5.98640781e-07,
        -1.30994663e-01,  1.88126847e-01,  3.30323040e-01,
        -2.31418759e-01, -1.95374072e-01,  2.20114008e-01,
         4.25508656e-02,  1.77435249e-01,  2.32180998e-01,
        -1.83152139e-01,  4.82120365e-02,  2.40712211e-01,
        -2.95381129e-01, -1.81763768e-01,  2.70055570e-02,
        -9.93823633e-02,  7.66262710e-02,  1.62846535e-01],
       [ 2.09034570e-02, -2.56239772e-01, -4.04706374e-02,
        -1.23890854e-01,  4.66939583e-02, -1.03516327e-02,
         2.62541045e-02, -3.37462395e-01,  1.96690764e-03,
        -2.09092453e-01,  3.07102233e-01, -1.48152515e-01,
         2.59936899e-01,  2.42772937e-01,  6.58790255e-03,
         4.67206910e-02, -5.10406010e-02,  8.41754684e-07,
        -9.16339606e-02,  4.94455323e-02, -1.05436914e-01,
         4.79590334e-02,  2.25926265e-01, -6.13295250e-02,
        -2.16039959e-02,  2.04668537e-01,  1.54694051e-01,
        -9.19345394e-02,  3.91666554e-02, -3.28356847e-02,
        -5.42560995e-01, -2.04297472e-02,  2.22398862e-02,
         1.17302097e-01, -1.23939030e-01,  1.67092741e-01],
       [ 5.43181319e-03,  2.50838809e-02, -1.02779306e-01,
        -1.02687821e-01,  2.22480744e-01,  1.35961235e-01,
        -5.57574108e-02,  1.65588155e-01,  1.08848639e-01,
         1.29505530e-01, -4.18119937e-01, -2.57958416e-02,
         1.48789555e-01,  2.29904745e-02, -3.20416361e-01,
        -2.13522077e-01, -3.47398296e-02,  9.22293623e-07,
        -5.15471809e-02, -2.37549722e-01, -1.10481270e-01,
        -5.04077738e-03,  2.22880080e-01, -4.29255128e-01,
         1.01591334e-01, -4.52548973e-02,  7.09609538e-02,
         7.26235136e-02,  9.45597216e-02,  1.57972500e-01,
        -1.33614510e-01, -2.68927693e-01,  1.74741764e-02,
        -1.28151119e-01,  7.34205320e-02,  1.71338931e-01],
       [-1.00397188e-02, -3.00910711e-01,  8.56043696e-02,
         1.75961498e-02, -1.69328928e-01,  6.71046972e-02,
         2.61199683e-01,  6.07536100e-02, -4.49579023e-02,
        -9.58132669e-02,  7.72849321e-02,  9.12873447e-02,
        -4.04767483e-01, -3.59029472e-01,  5.06752059e-02,
        -3.01932335e-01,  6.57636151e-02,  2.19944042e-07,
         2.07033098e-01, -7.96570703e-02,  8.53365213e-02,
         6.57434389e-02, -8.93406421e-02, -1.44483760e-01,
         2.87826389e-01,  7.57826567e-02, -1.90344229e-01,
         1.07962061e-02,  1.54530242e-01, -4.74688336e-02,
        -2.12563545e-01, -1.35255679e-01,  1.27085056e-02,
         1.47437364e-01, -1.52892292e-01,  1.75585151e-01],
       [-2.55113598e-02, -3.41936350e-02, -1.57155722e-01,
        -1.39635980e-01,  1.74692243e-01,  2.01309770e-01,
         3.10802370e-01, -1.51689038e-01, -1.30450809e-02,
        -1.47769392e-01,  7.72994906e-02, -9.69107747e-02,
        -1.49312019e-01, -3.28001678e-01, -8.45355242e-02,
         5.88223115e-02,  2.95968186e-02, -3.76644039e-07,
         1.01851791e-01,  5.36320657e-02, -1.64607971e-03,
         7.92539567e-02,  2.11090624e-01,  2.47274742e-01,
        -4.90963936e-01, -2.18952850e-01,  1.41745538e-01,
         6.71107545e-02,  2.96216216e-02,  4.53960113e-02,
         1.10806309e-01, -2.09204257e-01,  7.94279575e-03,
        -2.25187987e-01,  6.06984533e-02,  1.79831341e-01],
       [-4.09828946e-02, -2.69865692e-01,  9.30668190e-02,
         1.48852155e-01, -1.19659379e-01, -1.79180011e-01,
        -1.34632915e-01,  2.66641051e-01,  1.15480475e-01,
         1.25649139e-01,  1.55761704e-01,  3.64120454e-01,
         8.09182879e-03,  1.30120128e-01, -2.65324302e-03,
         1.68084472e-01, -2.56777816e-02,  2.68758981e-07,
        -5.35751544e-02, -7.89128467e-02,  1.10822506e-01,
        -1.68846413e-01,  2.82794803e-01,  5.51218241e-02,
        -1.98852912e-01, -4.44184005e-01, -2.10420281e-01,
         1.01168394e-01, -1.69100389e-02,  1.20934203e-01,
        -1.50020435e-01, -2.21125111e-02,  3.17712361e-03,
        -2.14996655e-02, -1.75004259e-01,  1.84077546e-01],
       [-5.64545356e-02, -5.50655536e-02, -2.36422405e-01,
         3.32612619e-02,  1.85150102e-01,  1.23627931e-01,
         6.25657737e-02,  1.14417762e-01,  2.62211293e-01,
         6.54302910e-02,  4.30240303e-01,  4.65344824e-02,
        -5.43423295e-02,  2.41549447e-01,  1.67388260e-01,
        -4.03734781e-02,  1.91696547e-02, -2.38961491e-08,
         5.16050458e-02,  2.82968283e-01, -2.33161338e-02,
         1.00417718e-01,  1.44047923e-02, -1.16971873e-01,
         3.85417551e-01,  2.34236363e-02,  4.00992855e-02,
         1.23846941e-01, -1.84535190e-01,  7.82874450e-02,
         2.70389766e-01, -1.23978287e-01, -1.58858451e-03,
        -2.80083865e-01,  5.20883687e-02,  1.88323751e-01],
       [-7.19261169e-02,  7.34867975e-02, -8.42874646e-02,
         9.55602601e-02,  2.11905718e-01, -6.91847503e-02,
        -1.98261932e-01, -2.23434106e-01, -3.48864496e-01,
         2.98692524e-01, -1.51855685e-02,  2.04392910e-01,
         1.34785041e-01, -2.86466032e-01,  6.47615641e-02,
        -5.25124036e-02, -3.10684182e-03,  1.17442504e-07,
        -1.59793030e-02,  3.75033468e-01, -1.15383580e-01,
         8.51827636e-02, -2.07851961e-01, -1.82784066e-01,
        -1.26420230e-01, -9.24990745e-04, -2.42414743e-01,
         1.78146690e-01, -7.22998604e-02, -8.72587189e-02,
        -2.22138390e-01,  7.03677610e-02, -6.35427516e-03,
        -1.58991009e-01, -5.97564876e-03,  1.92569941e-01],
       [-8.73977020e-02,  2.87292689e-01, -1.21784508e-01,
        -2.33644858e-01, -3.20010725e-03, -3.18341479e-02,
        -3.64642106e-02, -3.49750996e-01,  3.26046869e-02,
         6.61358982e-02,  4.63743992e-02,  1.12831622e-01,
        -3.08868848e-02,  2.15081602e-01,  9.44394767e-02,
         2.16954481e-02, -2.63056383e-02,  6.64598986e-07,
        -2.63082087e-02, -2.39953876e-01,  2.26069152e-01,
         3.06502171e-02, -9.97788757e-02,  4.31696586e-02,
         1.28835574e-01, -2.70742953e-01, -2.58822471e-01,
        -2.62651592e-01,  3.03347290e-01, -3.10117781e-01,
         2.62615457e-02, -2.12059483e-01, -1.11199627e-02,
        -4.04487960e-02,  1.25501439e-01,  1.96816131e-01],
       [-1.02869235e-01, -2.87766516e-01, -1.69363081e-01,
         1.51522607e-01, -1.74015552e-01, -2.63873816e-01,
        -2.04572961e-01, -1.80643708e-01,  1.75760955e-01,
        -3.19337785e-01, -3.32763821e-01, -1.46892563e-01,
         1.31833881e-01, -7.72327781e-02,  2.28840150e-02,
        -2.18998492e-02, -3.38453706e-03, -1.47448809e-08,
        -5.14900824e-03,  1.28321990e-01, -8.38432088e-02,
         5.11623546e-02, -8.57671276e-02,  1.05329685e-01,
         1.47043064e-01, -9.85101089e-02,  4.35657576e-02,
         5.87313175e-02,  3.19091707e-01,  2.69246362e-02,
         2.11294845e-01,  1.45919994e-01, -1.58856306e-02,
        -2.63020128e-01, -1.77285656e-01,  2.01062366e-01],
       [-1.18340850e-01, -6.33897334e-02,  1.14582084e-01,
        -3.00839901e-01,  2.97080398e-01,  1.21246614e-02,
         8.10572058e-02,  2.66078532e-01,  2.50430815e-02,
        -2.59717673e-01, -1.62864462e-01, -1.19659327e-01,
         3.85241732e-02,  1.81554675e-01, -1.44591052e-02,
         6.44245893e-02, -1.02135502e-02, -2.95543828e-07,
        -5.04005812e-02,  5.29195219e-02, -1.23828910e-01,
        -1.27263069e-01, -2.09507838e-01,  1.32679760e-01,
        -4.22949493e-02,  1.16898511e-02, -2.51786977e-01,
         3.61538231e-01, -1.26778960e-01, -3.75109315e-01,
         4.86061983e-02, -4.18991446e-02, -2.06513330e-02,
         2.22759411e-01, -1.31302297e-01,  2.05308557e-01],
       [-1.33812442e-01, -1.03045860e-02,  1.22120328e-01,
         2.94654053e-02,  2.80586809e-01,  1.80876911e-01,
        -1.71303794e-01,  9.07608569e-02, -3.41809392e-01,
        -2.58828998e-01,  1.92820519e-01,  1.15975186e-01,
        -1.30385756e-02,  1.08747773e-01,  1.36592975e-02,
        -4.57025482e-04,  3.09628863e-02, -2.69946412e-07,
         8.11563805e-02, -1.84232488e-01,  2.08711494e-02,
         3.25913280e-02,  6.53147027e-02, -1.59370512e-01,
        -1.27535179e-01,  1.81222618e-01, -1.12322927e-01,
        -1.07644282e-01,  3.35670054e-01,  2.75747240e-01,
         2.94042140e-01,  3.14162493e-01, -2.54170299e-02,
         6.86797276e-02,  3.78607884e-02,  2.09554762e-01],
       [-1.49283990e-01,  1.18999239e-02,  1.61011234e-01,
        -2.63236284e-01, -2.05621704e-01, -2.21751928e-01,
         2.78930277e-01,  7.43842050e-02,  1.81285888e-01,
         3.71914834e-01,  1.08899079e-01,  7.89007768e-02,
         1.29290953e-01,  1.41764171e-02, -9.85676646e-02,
         9.64924023e-02, -2.98751835e-02, -1.71133038e-07,
        -9.76867601e-02,  1.19301053e-02, -8.63644034e-02,
         7.14343935e-02, -3.38676691e-01, -2.88167167e-02,
        -2.10557222e-01,  2.78975517e-01,  1.36579245e-01,
         1.48061896e-02,  2.68838614e-01,  2.22886056e-01,
         1.20790333e-01, -7.89825693e-02, -3.01827043e-02,
         9.23553389e-03, -1.14707150e-01,  2.13800967e-01],
       [-1.64755613e-01,  2.50414670e-01,  4.84913319e-01,
         3.37827832e-01, -1.04466721e-01,  2.06043482e-01,
        -3.32239345e-02, -2.26226255e-01,  2.39121899e-01,
         3.10006831e-02, -8.30238760e-02, -6.39717951e-02,
        -1.51006639e-01,  5.87666109e-02, -1.80561058e-02,
         2.01221183e-02,  3.08423918e-02, -6.48963862e-07,
         5.74074090e-02,  1.36510491e-01, -2.71617413e-01,
        -2.46268615e-01,  2.25856364e-01,  3.01351082e-02,
        -3.80010195e-02,  1.98807135e-01, -1.44765794e-01,
        -7.66455084e-02, -1.95906740e-02, -8.16477388e-02,
         3.53466198e-02, -1.24280065e-01, -3.49484049e-02,
        -9.09650996e-02, -3.61349806e-02,  2.18047172e-01],
       [-1.80227265e-01,  1.25613526e-01, -2.84022719e-01,
        -1.59043476e-01, -3.22989166e-01,  1.12933561e-01,
        -9.71403196e-02,  1.25533894e-01, -1.15951672e-01,
         1.16906494e-01, -9.11734179e-02, -9.93394628e-02,
        -3.21458559e-03, -5.95454089e-02,  1.76653475e-01,
        -4.82690660e-03,  1.81545701e-03,  8.53715107e-08,
        -4.87203151e-03,  3.33043903e-01, -1.23329632e-01,
        -7.83521906e-02,  2.83880621e-01,  3.06078736e-02,
         6.56477436e-02, -1.06089085e-01,  7.79625028e-02,
        -9.49532958e-04,  9.88103822e-02,  9.06326547e-02,
         6.59343079e-02,  1.08709410e-02, -3.97141166e-02,
         5.30595541e-01,  1.81649357e-01,  2.22293377e-01],
       [-1.95698813e-01,  2.80402079e-02,  5.89833520e-02,
        -3.71422738e-01, -2.49386549e-01,  1.10378250e-01,
         7.45397732e-02,  5.89645579e-02, -4.85502928e-02,
        -1.41202826e-02, -1.43713236e-01, -1.11844055e-01,
        -2.20679380e-02,  1.98342204e-02,  2.04059836e-02,
        -1.12726809e-02,  2.35774312e-02, -4.20148751e-07,
         4.83251922e-02, -6.80682287e-02,  5.45866415e-02,
         7.36164749e-02,  7.53621338e-03, -3.53311896e-02,
         3.39673348e-02, -6.37873635e-02, -1.21314578e-01,
        -2.84928590e-01, -4.64080334e-01,  1.18792303e-01,
        -1.15884535e-01,  4.16776925e-01, -4.44797911e-02,
        -3.27318609e-01, -5.93764856e-02,  2.26539567e-01],
       [-2.11170390e-01,  1.64693087e-01, -3.15090626e-01,
         3.50910455e-01,  2.41270930e-01, -3.65374863e-01,
         2.48012736e-01, -1.04791202e-01,  1.75162852e-01,
        -6.23711124e-02, -1.87206548e-02,  3.62230800e-02,
        -3.64686027e-02, -7.65869841e-02, -1.49266437e-01,
        -3.93332057e-02, -1.87110081e-02,  5.37212657e-07,
        -1.22440560e-02, -2.21213073e-01,  2.39097625e-02,
        -9.01631713e-02, -5.61458170e-02,  1.11406513e-01,
         2.42962576e-02,  9.36316252e-02, -6.66014999e-02,
        -8.40063319e-02, -2.71944344e-01,  1.74328908e-01,
        -6.15001358e-02,  1.49644703e-01, -4.92454804e-02,
         2.78115243e-01,  1.27662525e-01,  2.30785772e-01],
       [-2.26641953e-01,  1.51991069e-01,  5.27488776e-02,
         4.08855200e-01, -1.13871656e-01,  2.10292280e-01,
         5.63840158e-02,  2.58077025e-01, -2.25966513e-01,
         9.00448486e-02,  5.48437051e-02, -2.02088326e-01,
         1.10108718e-01,  5.60473539e-02,  1.15138860e-02,
         6.95619136e-02, -3.12283337e-02,  3.24556339e-07,
        -5.64295948e-02, -2.00546086e-01,  1.53913170e-01,
         2.65932292e-01, -1.18604340e-01,  1.42736882e-01,
         8.15560669e-02, -1.02896839e-01,  3.44772100e-01,
         1.74658805e-01,  8.30524191e-02, -2.31719613e-01,
        -1.91197023e-01,  3.11037414e-02, -5.40111661e-02,
        -9.28696394e-02, -2.49596257e-02,  2.35031962e-01]], dtype=float32), array([-1.89882324e+03, -9.15030774e-04, -2.36170061e-04, -2.09079895e-04,
       -1.40655597e-04, -1.14337396e-04, -8.52011290e-05, -7.45377401e-05,
       -7.01748504e-05, -6.77491407e-05, -4.28016501e-05, -3.48233516e-05,
       -3.24805987e-05, -2.43496979e-05, -1.56324259e-05, -3.18316279e-06,
       -1.31638060e-07, -1.52055191e-12,  8.87037857e-07,  8.56990846e-06,
        1.78414030e-05,  2.53292128e-05,  2.88430601e-05,  2.92068562e-05,
        4.22756675e-05,  6.49306021e-05,  8.50184006e-05,  1.04995546e-04,
        1.17416334e-04,  1.17763499e-04,  1.88847407e-04,  1.93809290e-04,
        2.13623047e-04,  2.35658721e-04,  1.24705711e-03,  2.52088262e+04],
      dtype=float32)),
    mlir_module_text=r"""
#loc3 = loc("/release/jax/tests/export_back_compat_test.py":263:0)
#loc9 = loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))
module @jit__lambda_ attributes {jax.uses_shape_polymorphism = false, mhlo.num_partitions = 1 : i32, mhlo.num_replicas = 1 : i32} {
  func.func public @main() -> (tensor<36x36xf32> {jax.result_info = "[0]", mhlo.layout_mode = "default"}, tensor<36xf32> {jax.result_info = "[1]", mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<1296xf32> loc(#loc4)
    %1 = stablehlo.reshape %0 : (tensor<1296xf32>) -> tensor<36x36xf32> loc(#loc5)
    %2 = stablehlo.transpose %1, dims = [1, 0] : (tensor<36x36xf32>) -> tensor<36x36xf32> loc(#loc6)
    %3 = stablehlo.add %1, %2 : tensor<36x36xf32> loc(#loc7)
    %cst = stablehlo.constant dense<2.000000e+00> : tensor<f32> loc(#loc)
    %4 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f32>) -> tensor<36x36xf32> loc(#loc8)
    %5 = stablehlo.divide %3, %4 : tensor<36x36xf32> loc(#loc8)
    %6 = call @tril(%5) : (tensor<36x36xf32>) -> tensor<36x36xf32> loc(#loc9)
    %c = stablehlo.constant dense<36> : tensor<i64> loc(#loc10)
    %c_0 = stablehlo.constant dense<36> : tensor<i64> loc(#loc10)
    %7:4 = stablehlo.custom_call @hipsolver_syevd(%6) {api_version = 2 : i32, backend_config = "\00\00\00\00z\00\00\00\01\00\00\00$\00\00\00@X\00\00", operand_layouts = [dense<[0, 1]> : tensor<2xindex>], output_operand_aliases = [#stablehlo.output_operand_alias<output_tuple_indices = [0], operand_index = 0, operand_tuple_indices = []>], result_layouts = [dense<[0, 1]> : tensor<2xindex>, dense<0> : tensor<1xindex>, dense<> : tensor<0xindex>, dense<0> : tensor<1xindex>]} : (tensor<36x36xf32>) -> (tensor<36x36xf32>, tensor<36xf32>, tensor<i32>, tensor<22592xf32>) loc(#loc10)
    %c_1 = stablehlo.constant dense<0> : tensor<i32> loc(#loc10)
    %8 = stablehlo.broadcast_in_dim %c_1, dims = [] : (tensor<i32>) -> tensor<i32> loc(#loc10)
    %9 = stablehlo.compare  EQ, %7#2, %8,  SIGNED : (tensor<i32>, tensor<i32>) -> tensor<i1> loc(#loc10)
    %10 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1x1xi1> loc(#loc10)
    %cst_2 = stablehlo.constant dense<0x7FC00000> : tensor<f32> loc(#loc10)
    %11 = stablehlo.broadcast_in_dim %cst_2, dims = [] : (tensor<f32>) -> tensor<36x36xf32> loc(#loc10)
    %12 = stablehlo.broadcast_in_dim %10, dims = [0, 1] : (tensor<1x1xi1>) -> tensor<36x36xi1> loc(#loc10)
    %13 = stablehlo.select %12, %7#0, %11 : tensor<36x36xi1>, tensor<36x36xf32> loc(#loc10)
    %14 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1xi1> loc(#loc10)
    %cst_3 = stablehlo.constant dense<0x7FC00000> : tensor<f32> loc(#loc10)
    %15 = stablehlo.broadcast_in_dim %cst_3, dims = [] : (tensor<f32>) -> tensor<36xf32> loc(#loc10)
    %16 = stablehlo.broadcast_in_dim %14, dims = [0] : (tensor<1xi1>) -> tensor<36xi1> loc(#loc10)
    %17 = stablehlo.select %16, %7#1, %15 : tensor<36xi1>, tensor<36xf32> loc(#loc10)
    return %13, %17 : tensor<36x36xf32>, tensor<36xf32> loc(#loc)
  } loc(#loc)
  func.func private @tril(%arg0: tensor<36x36xf32> {mhlo.layout_mode = "default"} loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))) -> (tensor<36x36xf32> {mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<36x36xi32> loc(#loc11)
    %c = stablehlo.constant dense<0> : tensor<i32> loc(#loc9)
    %1 = stablehlo.broadcast_in_dim %c, dims = [] : (tensor<i32>) -> tensor<36x36xi32> loc(#loc12)
    %2 = stablehlo.add %0, %1 : tensor<36x36xi32> loc(#loc12)
    %3 = stablehlo.iota dim = 1 : tensor<36x36xi32> loc(#loc13)
    %4 = stablehlo.compare  GE, %2, %3,  SIGNED : (tensor<36x36xi32>, tensor<36x36xi32>) -> tensor<36x36xi1> loc(#loc14)
    %cst = stablehlo.constant dense<0.000000e+00> : tensor<f32> loc(#loc9)
    %5 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f32>) -> tensor<36x36xf32> loc(#loc15)
    %6 = stablehlo.select %4, %arg0, %5 : tensor<36x36xi1>, tensor<36x36xf32> loc(#loc16)
    return %6 : tensor<36x36xf32> loc(#loc9)
  } loc(#loc9)
} loc(#loc)
#loc = loc(unknown)
#loc1 = loc("/release/jax/tests/export_back_compat_test.py":255:0)
#loc2 = loc("/release/jax/tests/export_back_compat_test.py":257:0)
#loc4 = loc("jit(<lambda>)/jit(main)/iota[dtype=float32 shape=(1296,) dimension=0]"(#loc1))
#loc5 = loc("jit(<lambda>)/jit(main)/reshape[new_sizes=(36, 36) dimensions=None]"(#loc1))
#loc6 = loc("jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]"(#loc2))
#loc7 = loc("jit(<lambda>)/jit(main)/add"(#loc2))
#loc8 = loc("jit(<lambda>)/jit(main)/div"(#loc2))
#loc10 = loc("jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]"(#loc3))
#loc11 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=0]"(#loc3))
#loc12 = loc("jit(<lambda>)/jit(main)/jit(tril)/add"(#loc3))
#loc13 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=1]"(#loc3))
#loc14 = loc("jit(<lambda>)/jit(main)/jit(tril)/ge"(#loc3))
#loc15 = loc("jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(36, 36) broadcast_dimensions=()]"(#loc3))
#loc16 = loc("jit(<lambda>)/jit(main)/jit(tril)/select_n"(#loc3))
""",
    mlir_module_serialized=b"ML\xefR\x01StableHLO_v0.9.0\x00\x01+\x05\x01\x03\x01\x03\x05\x03\x1b\x07\t\x0b\r\x0f\x11\x13\x15\x17\x19\x1b\x1d\x1f\x03n\x02\xeb9\x01\x97\x0f\x17\x13\x0f\x0b\x07\x0b\x0b\x0b\x17\x0f\x0b\x0b\x0b\x0b\x13\x0b\x13\x0f\x0b\x0b\x17\x0f\x13\x13+\x0b\x0f\x0b\x0b\x0b33\x0b\x0f\x0b\x0b\x13\x0f\x0b\x1b\x0f\x0b\x13\x0f\x0b\x0f\x0b\x0f\x0b\x0f\x0b\x13\x0b\x0f\x0b\x0f\x0b\x13\x0b\x13\x0b\x0bK\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x1b\x13\x13\x03U\x0b\x0b\x0b\x0b\x0f\x0b\x0bO/\x0b\x13\x1b\x0b\x1b\x0b\x0b\x0b\x13\x0b\x0b\x0f\x1f\x0f\x0f\x0b\x1fO\x1f/\x0b\x0b\x0b\x0b\x0f\x0f\x17\x1b\x0f\x0b\x1fO/\x01\x05\x0b\x0f\x035\x17\x0f\x07\x07\x0f\x07\x13\x17\x0f\x07\x07\x17\x13\x17\x17\x13\x17\x1b\x13\x13\x13\x0f\x17\x13\x13\x13\x02\xb2\x08\x1d}\x03\x17\x0f\x1e\x04\x01\x03\x03\x11\xc3\x1dC\x03\x05!\x1f\x05#\x05%\x05'\x17\x0f\x06\x04\x01\x11\x03\x05\x05)\x05+\x05-\x05/\x03\x03!\xbf\x051\x03\x03\t\xc1\x1dI\x03\x053\x055\x17\x0f\xfe\x03\x01\x1dw\x13\x03\x03\t\xcf\x03\x03\t\xe5\x03\t579\x15;\x15\r=\x057\x11\x01\x00\x059\x05;\x05=\x03\x0b\x17\x9b\x19\xa9\x1b\xab\r\xb5\x1d\xb7\x03\x0b\x17\x9f\x19\xbb\x1b\x9f\r\xa1\x1d\xbd\x05?\x1dG\x03\x05A\x05C\x03\x03!\xc5\x1dO\x03\x05E\x03\x05'\xa3)\xc7\x1dU\x03\x05G\x03\x03\t\xc9\x1d[\x03\x05I\x1d_\x03\x05K\x1dc+\x05M\x1dg+\x05O\x03\x03k\xcb\x05Q\x1do\x13\x05S\x1ds\x13\x05U\x03\x03\t\xcd\x05W\x03\x03{\xa1\x05Y\x05[\x03\x11\x81\xd1\x83\xd3\x85\xd5\x87\x9b\x89\xd7\x8b\xd9\x8d\xdb\x8f\xdf\x05]\x05_\x05a\x05c\x05e\x05g\x05i\x05k\x03\x05'\xa3)\xe3\x03\x03\x11\xe7\x03\x03\x11\xe9\x1dm\x1do\x03\x01\x1dq\x03\x03\xb9\x1ds\t\x07\x1f)!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f+\x11\x00\x00\x00\x00\x00\x00\x00\x00#\x1f\x03\x05\xad\xb1\r\x05\x9d\xaf\x97\x99\x1du\r\x05\x9d\xb3\x97\x99\x1dw\x1dy\x1d{\r\x03\x97\x99#!\x1d}\x13\t\x01\x1f\r\t\x00\x00\x00\x00\x1f#\x01\x13\t\x05\x07\x05\x1f\x07\t\x00\x00\x00\x00\x1f\x1d!\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x07\t\x00\x00\x00@\x1f\x15\x11$\x00\x00\x00\x00\x00\x00\x00\x0b\x05\x1d\x7f\x1d\x81\x05\x01\x03\x03\xa5\x03\x03\xdd\x15\x03\x01\x01\x01\x03\t\xa5\xa7\xe1\xa7\x1f-\x01\x07\x01\x1f\x07\t\x00\x00\xc0\x7f\x1f\x1d!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f7\x11\x00\x00\x00\x00\x00\x00\x00\x00\x01\t\x01\x02\x02)\x05\x91\x91\x0b)\x01\x0b\x1d\t)\x01\x19\x01)\x03\x91\x0b)\x05\x91\x91\x19)\x01\t\x13\x1b)\x05\x91\x91\x0f)\x03\t\t\x11\x01\x05\x05\x11\x11\x03\x05\x03\x05)\x03\x01\t)\x03\x82(\x0b)\x03\x04\x84\x05\x0b)\x03\t\x17)\x03\x05\x17)\x03\x01\x17)\x01\x0f)\x05\x05\x05\x0f)\x03\x05\x0f)\x03\x91\x0f)\x03\x05\t\x04\x82\x04\x05\x01\x11\x0b3\x07\x03\x01\t\x0b\x11\x0b?\x07\x037e\x07\x03a\x1f\x03%\x13\x06e\x03\x05\x03\x01\x15\x07mi\x03\x05\x03\x03\r\x06q\x03\x05\x05\x03\x05\x05\x03\x0bu\x03\x07\x03\x07-\x05\x03\x05\x03\t\x17\x06-\x03\x05\x05\x07\x0b\x19\x07\x07y\x03\x05\x03\r\x05\x03\x01/\x03\x15\x05\x03\x01/\x03\x15\x1b\x07\x01\x7f\t\x05\x11\r'\x03\x0f\x05\x03\x01#\x03\r\x03\x07\x01\x05\x03\r\x03\x1d\x0f\x07\x01\x91\x03/\x05\x19\x1f\x03\x07\x01\x05\x031\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x05\x03%\x03\x07\x01\x93\x03\x1b\x03#\t\x06\x01\x03\x05\x07)\x15'\x03\x07\x01\x05\x033\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x11\x03/\x03\x07\x01\x95\x035\x03-\t\x06\x01\x03\x11\x073\x171\x11\x04\x0b\x05+5\x0b\x11\x07A\x07\x03\x15+\x03\x05\x07\x07\x03E\x1f\x03\x13\x05\x03\x07#\x03\r\x03\x07%\x05\x03\x13\x03\x05\r\x06%\x03\x13\x05\x03\x07\x07\x03MK\x03\x13\x0f\x07SQ\x03\x1b\x05\t\x0b\x05\x03\x07W\x03\x07\x03\x07Y\x05\x03\x05\x03\x0f\t\x06]\x03\x05\x07\r\x01\x11\x11\x04\x07\x03\x13\x06\x03\x01\x05\x01\x00\x1e\x1a\x83!+\x11\x0f\x0b\t\t\x0b!\x11#\x1f/!!)#\x1f\x19\xa9\x0f99m\x19\x89\x8dW\xb7K\x9fM\x9fn\x03\x1b%)9+\x1b\x1f\x1f\x15\x1d\x15+]\x13\r\x1f\x11\x15\x1b\x17\x15\x17\x0f\x11\x15\x11\x19)\x0f\x0b\x11builtin\x00vhlo\x00module\x00broadcast_in_dim_v1\x00constant_v1\x00iota_v1\x00select_v1\x00func_v1\x00add_v1\x00compare_v1\x00return_v1\x00reshape_v1\x00transpose_v1\x00divide_v1\x00call_v1\x00custom_call_v1\x00value\x00sym_name\x00/release/jax/tests/export_back_compat_test.py\x00broadcast_dimensions\x00arg_attrs\x00function_type\x00res_attrs\x00sym_visibility\x00iota_dimension\x00compare_type\x00comparison_direction\x00jax.uses_shape_polymorphism\x00mhlo.num_partitions\x00mhlo.num_replicas\x00jit__lambda_\x00jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=0]\x00jit(<lambda>)/jit(main)/jit(tril)/add\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=1]\x00jit(<lambda>)/jit(main)/jit(tril)/ge\x00jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(36, 36) broadcast_dimensions=()]\x00jit(<lambda>)/jit(main)/jit(tril)/select_n\x00jit(<lambda>)/jit(main)/iota[dtype=float32 shape=(1296,) dimension=0]\x00jit(<lambda>)/jit(main)/reshape[new_sizes=(36, 36) dimensions=None]\x00permutation\x00jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]\x00jit(<lambda>)/jit(main)/add\x00jit(<lambda>)/jit(main)/div\x00callee\x00jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]\x00api_version\x00backend_config\x00call_target_name\x00called_computations\x00has_side_effect\x00operand_layouts\x00output_operand_aliases\x00result_layouts\x00mhlo.layout_mode\x00default\x00jax.result_info\x00tril\x00[0]\x00[1]\x00main\x00public\x00private\x00\x00\x00\x00\x00z\x00\x00\x00\x01\x00\x00\x00$\x00\x00\x00@X\x00\x00\x00hipsolver_syevd\x00",
    xla_call_module_version=9,
    nr_devices=1,
)  # End paste


# Pasted from the test output (see export_back_compat_test_util.py module docstring)
data_2024_08_05["f64_syevj"] = dict(
    testdata_version=1,
    platform='rocm',
    custom_call_targets=['hipsolver_syevj'],
    serialized_date=datetime.date(2024, 8, 5),
    inputs=(),
    expected_outputs=(array([[ 0.6185770004841215  , -0.0516063460511392  ,
        -0.21397518016866138 , -0.2936714371744935  ,
        -0.04969262205195002 ,  0.6244745291285012  ,
        -0.23707389865520645 ,  0.18446994643771733 ],
       [ 0.4707088148731455  , -0.5623853204016975  ,
        -0.04833819830022874 , -0.06113301142764708 ,
        -0.021826919763197138, -0.4617682701588645  ,
         0.43604248799190726 ,  0.22856669794666584 ],
       [ 0.3228406292621707  ,  0.3550194703403343  ,
         0.1719416377457023  ,  0.2252644229463615  ,
        -0.4927270475093298  , -0.4151240646463301  ,
        -0.44718433299485966 ,  0.2726634494556143  ],
       [ 0.17497244365119557 ,  0.06599028441276723 ,
         0.17989910779501656 ,  0.33885827608280317 ,
         0.8136434105540369  , -0.061972228785079665,
        -0.2272622372434422  ,  0.31676020096456303 ],
       [ 0.027104258040219605,  0.2822189885000828  ,
         0.16229633829955228 ,  0.4520520393470605  ,
        -0.19254110476141492 ,  0.37669569455679763 ,
         0.6162281968183188  ,  0.36085695247351146 ],
       [-0.12076392757075584 ,  0.507407767605187   ,
        -0.4718361708899124  , -0.46207395794383743 ,
         0.16117135492673798 , -0.24792994082708492 ,
         0.20094465114830004 ,  0.40495370398246006 ],
       [-0.26863211318173086 , -0.16497464529520123 ,
         0.6653341579545913  , -0.4912652924291929  ,
        -0.056847927295897015,  0.08856995340942347 ,
        -0.06234091616848442 ,  0.44905045549140854 ],
       [-0.416500298792706   , -0.431670199110333   ,
        -0.44532169243605996 ,  0.29196896059894506 ,
        -0.16117914409898593 ,  0.09705432732263665 ,
        -0.27935395089653303 ,  0.49314720700035736 ]]), array([-2.4598804776133615e+01, -1.1877848003994643e-14,
       -5.0122948268488769e-15, -2.5774124252445084e-15,
       -2.7564446711523010e-16,  1.1764826191467892e-15,
        9.1619817880559362e-15,  2.7659880477613370e+02])),
    mlir_module_text=r"""
#loc3 = loc("/release/jax/tests/export_back_compat_test.py":263:0)
#loc9 = loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))
module @jit__lambda_ attributes {jax.uses_shape_polymorphism = false, mhlo.num_partitions = 1 : i32, mhlo.num_replicas = 1 : i32} {
  func.func public @main() -> (tensor<8x8xf64> {jax.result_info = "[0]", mhlo.layout_mode = "default"}, tensor<8xf64> {jax.result_info = "[1]", mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<64xf64> loc(#loc4)
    %1 = stablehlo.reshape %0 : (tensor<64xf64>) -> tensor<8x8xf64> loc(#loc5)
    %2 = stablehlo.transpose %1, dims = [1, 0] : (tensor<8x8xf64>) -> tensor<8x8xf64> loc(#loc6)
    %3 = stablehlo.add %1, %2 : tensor<8x8xf64> loc(#loc7)
    %cst = stablehlo.constant dense<2.000000e+00> : tensor<f64> loc(#loc)
    %4 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f64>) -> tensor<8x8xf64> loc(#loc8)
    %5 = stablehlo.divide %3, %4 : tensor<8x8xf64> loc(#loc8)
    %6 = call @tril(%5) : (tensor<8x8xf64>) -> tensor<8x8xf64> loc(#loc9)
    %c = stablehlo.constant dense<8> : tensor<i64> loc(#loc10)
    %c_0 = stablehlo.constant dense<8> : tensor<i64> loc(#loc10)
    %7:4 = stablehlo.custom_call @hipsolver_syevj(%6) {api_version = 2 : i32, backend_config = "\01\00\00\00z\00\00\00\01\00\00\00\08\00\00\00\00\02\00\00", operand_layouts = [dense<[0, 1]> : tensor<2xindex>], output_operand_aliases = [#stablehlo.output_operand_alias<output_tuple_indices = [0], operand_index = 0, operand_tuple_indices = []>], result_layouts = [dense<[0, 1]> : tensor<2xindex>, dense<0> : tensor<1xindex>, dense<> : tensor<0xindex>, dense<0> : tensor<1xindex>]} : (tensor<8x8xf64>) -> (tensor<8x8xf64>, tensor<8xf64>, tensor<i32>, tensor<512xf64>) loc(#loc10)
    %c_1 = stablehlo.constant dense<0> : tensor<i32> loc(#loc10)
    %8 = stablehlo.broadcast_in_dim %c_1, dims = [] : (tensor<i32>) -> tensor<i32> loc(#loc10)
    %9 = stablehlo.compare  EQ, %7#2, %8,  SIGNED : (tensor<i32>, tensor<i32>) -> tensor<i1> loc(#loc10)
    %10 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1x1xi1> loc(#loc10)
    %cst_2 = stablehlo.constant dense<0x7FF8000000000000> : tensor<f64> loc(#loc10)
    %11 = stablehlo.broadcast_in_dim %cst_2, dims = [] : (tensor<f64>) -> tensor<8x8xf64> loc(#loc10)
    %12 = stablehlo.broadcast_in_dim %10, dims = [0, 1] : (tensor<1x1xi1>) -> tensor<8x8xi1> loc(#loc10)
    %13 = stablehlo.select %12, %7#0, %11 : tensor<8x8xi1>, tensor<8x8xf64> loc(#loc10)
    %14 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1xi1> loc(#loc10)
    %cst_3 = stablehlo.constant dense<0x7FF8000000000000> : tensor<f64> loc(#loc10)
    %15 = stablehlo.broadcast_in_dim %cst_3, dims = [] : (tensor<f64>) -> tensor<8xf64> loc(#loc10)
    %16 = stablehlo.broadcast_in_dim %14, dims = [0] : (tensor<1xi1>) -> tensor<8xi1> loc(#loc10)
    %17 = stablehlo.select %16, %7#1, %15 : tensor<8xi1>, tensor<8xf64> loc(#loc10)
    return %13, %17 : tensor<8x8xf64>, tensor<8xf64> loc(#loc)
  } loc(#loc)
  func.func private @tril(%arg0: tensor<8x8xf64> {mhlo.layout_mode = "default"} loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))) -> (tensor<8x8xf64> {mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<8x8xi32> loc(#loc11)
    %c = stablehlo.constant dense<0> : tensor<i32> loc(#loc9)
    %1 = stablehlo.broadcast_in_dim %c, dims = [] : (tensor<i32>) -> tensor<8x8xi32> loc(#loc12)
    %2 = stablehlo.add %0, %1 : tensor<8x8xi32> loc(#loc12)
    %3 = stablehlo.iota dim = 1 : tensor<8x8xi32> loc(#loc13)
    %4 = stablehlo.compare  GE, %2, %3,  SIGNED : (tensor<8x8xi32>, tensor<8x8xi32>) -> tensor<8x8xi1> loc(#loc14)
    %cst = stablehlo.constant dense<0.000000e+00> : tensor<f64> loc(#loc9)
    %5 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f64>) -> tensor<8x8xf64> loc(#loc15)
    %6 = stablehlo.select %4, %arg0, %5 : tensor<8x8xi1>, tensor<8x8xf64> loc(#loc16)
    return %6 : tensor<8x8xf64> loc(#loc9)
  } loc(#loc9)
} loc(#loc)
#loc = loc(unknown)
#loc1 = loc("/release/jax/tests/export_back_compat_test.py":255:0)
#loc2 = loc("/release/jax/tests/export_back_compat_test.py":257:0)
#loc4 = loc("jit(<lambda>)/jit(main)/iota[dtype=float64 shape=(64,) dimension=0]"(#loc1))
#loc5 = loc("jit(<lambda>)/jit(main)/reshape[new_sizes=(8, 8) dimensions=None]"(#loc1))
#loc6 = loc("jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]"(#loc2))
#loc7 = loc("jit(<lambda>)/jit(main)/add"(#loc2))
#loc8 = loc("jit(<lambda>)/jit(main)/div"(#loc2))
#loc10 = loc("jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]"(#loc3))
#loc11 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=0]"(#loc3))
#loc12 = loc("jit(<lambda>)/jit(main)/jit(tril)/add"(#loc3))
#loc13 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=1]"(#loc3))
#loc14 = loc("jit(<lambda>)/jit(main)/jit(tril)/ge"(#loc3))
#loc15 = loc("jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(8, 8) broadcast_dimensions=()]"(#loc3))
#loc16 = loc("jit(<lambda>)/jit(main)/jit(tril)/select_n"(#loc3))
""",
    mlir_module_serialized=b"ML\xefR\x01StableHLO_v0.9.0\x00\x01+\x05\x01\x03\x01\x03\x05\x03\x1b\x07\t\x0b\r\x0f\x11\x13\x15\x17\x19\x1b\x1d\x1f\x03n\x02\xeb9\x01\x97\x0f\x17\x13\x0f\x0b\x07\x0b\x0b\x0b\x17\x0f\x0b\x0b\x0b\x0b\x13\x0b\x13\x0f\x0b\x0b\x17\x0f\x13\x13+\x0b\x0f\x0b\x0b\x0b33\x0b\x0f\x0b\x0b\x13\x0f\x0b\x1b\x0f\x0b\x13\x0f\x0b\x0f\x0b\x0f\x0b\x0f\x0b\x13\x0b\x0f\x0b\x0f\x0b\x13\x0b\x13\x0b\x0bK\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x1b\x13\x13\x03U\x0b\x0b\x0b\x0b\x0f\x0b\x0bO/\x0b\x13\x1b\x0b\x1b\x0b\x0b\x0b\x13\x0b\x0b\x0f\x1f\x0f\x0f\x0b/O//\x0b\x0b\x0b\x0b\x0f\x0f\x17\x1b\x0f\x0b/O/\x01\x05\x0b\x0f\x035\x17\x0f\x07\x07\x0f\x07\x13\x17\x0f\x07\x07\x17\x13\x17\x17\x13\x17\x17\x13\x13\x13\x0f\x17\x13\x13\x13\x02\xde\x08\x1d}\x03\x17\x0f\x1e\x04\x01\x03\x03\x11\xc3\x1dC\x03\x05!\x1f\x05#\x05%\x05'\x17\x0f\x06\x04\x01\x11\x03\x05\x05)\x05+\x05-\x05/\x03\x03!\xbf\x051\x03\x03\t\xc1\x1dI\x03\x053\x055\x17\x0f\xfe\x03\x01\x1dw\x13\x03\x03\t\xcf\x03\x03\t\xe5\x03\t579\x15;\x15\r=\x057\x11\x01\x00\x059\x05;\x05=\x03\x0b\x17\x9b\x19\xa9\x1b\xab\r\xb5\x1d\xb7\x03\x0b\x17\x9f\x19\xbb\x1b\x9f\r\xa1\x1d\xbd\x05?\x1dG\x03\x05A\x05C\x03\x03!\xc5\x1dO\x03\x05E\x03\x05'\xa3)\xc7\x1dU\x03\x05G\x03\x03\t\xc9\x1d[\x03\x05I\x1d_\x03\x05K\x1dc+\x05M\x1dg+\x05O\x03\x03k\xcb\x05Q\x1do\x13\x05S\x1ds\x13\x05U\x03\x03\t\xcd\x05W\x03\x03{\xa1\x05Y\x05[\x03\x11\x81\xd1\x83\xd3\x85\xd5\x87\x9b\x89\xd7\x8b\xd9\x8d\xdb\x8f\xdf\x05]\x05_\x05a\x05c\x05e\x05g\x05i\x05k\x03\x05'\xa3)\xe3\x03\x03\x11\xe7\x03\x03\x11\xe9\x1dm\x1do\x03\x01\x1dq\x03\x03\xb9\x1ds\t\x07\x1f)!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f+\x11\x00\x00\x00\x00\x00\x00\x00\x00#\x1f\x03\x05\xad\xb1\r\x05\x9d\xaf\x97\x99\x1du\r\x05\x9d\xb3\x97\x99\x1dw\x1dy\x1d{\r\x03\x97\x99#!\x1d}\x13\t\x01\x1f\r\t\x00\x00\x00\x00\x1f#\x01\x13\t\x05\x07\x05\x1f\x07\x11\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x1d!\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x07\x11\x00\x00\x00\x00\x00\x00\x00@\x1f\x15\x11\x08\x00\x00\x00\x00\x00\x00\x00\x0b\x05\x1d\x7f\x1d\x81\x05\x01\x03\x03\xa5\x03\x03\xdd\x15\x03\x01\x01\x01\x03\t\xa5\xa7\xe1\xa7\x1f-\x01\x07\x01\x1f\x07\x11\x00\x00\x00\x00\x00\x00\xf8\x7f\x1f\x1d!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f7\x11\x00\x00\x00\x00\x00\x00\x00\x00\x01\t\x01\x02\x02)\x05!!\x0b)\x01\x0b\x1d\x0b)\x01\x19\x01)\x03!\x0b)\x05!!\x19)\x01\t\x13\x1b)\x05!!\x0f)\x03\t\t\x11\x01\x05\x05\x11\x11\x03\x05\x03\x05)\x03\x01\t)\x03\x02\x02\x0b)\x03\x02\x10\x0b)\x03\t\x17)\x03\x05\x17)\x03\x01\x17)\x01\x0f)\x05\x05\x05\x0f)\x03\x05\x0f)\x03!\x0f)\x03\x05\t\x04\x82\x04\x05\x01\x11\x0b3\x07\x03\x01\t\x0b\x11\x0b?\x07\x037e\x07\x03a\x1f\x03%\x13\x06e\x03\x05\x03\x01\x15\x07mi\x03\x05\x03\x03\r\x06q\x03\x05\x05\x03\x05\x05\x03\x0bu\x03\x07\x03\x07-\x05\x03\x05\x03\t\x17\x06-\x03\x05\x05\x07\x0b\x19\x07\x07y\x03\x05\x03\r\x05\x03\x01/\x03\x15\x05\x03\x01/\x03\x15\x1b\x07\x01\x7f\t\x05\x11\r'\x03\x0f\x05\x03\x01#\x03\r\x03\x07\x01\x05\x03\r\x03\x1d\x0f\x07\x01\x91\x03/\x05\x19\x1f\x03\x07\x01\x05\x031\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x05\x03%\x03\x07\x01\x93\x03\x1b\x03#\t\x06\x01\x03\x05\x07)\x15'\x03\x07\x01\x05\x033\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x11\x03/\x03\x07\x01\x95\x035\x03-\t\x06\x01\x03\x11\x073\x171\x11\x04\x0b\x05+5\x0b\x11\x07A\x07\x03\x15+\x03\x05\x07\x07\x03E\x1f\x03\x13\x05\x03\x07#\x03\r\x03\x07%\x05\x03\x13\x03\x05\r\x06%\x03\x13\x05\x03\x07\x07\x03MK\x03\x13\x0f\x07SQ\x03\x1b\x05\t\x0b\x05\x03\x07W\x03\x07\x03\x07Y\x05\x03\x05\x03\x0f\t\x06]\x03\x05\x07\r\x01\x11\x11\x04\x07\x03\x13\x06\x03\x01\x05\x01\x00\xf6\x19\x83!+\x11\x0f\x0b\t\t\x0b!\x11#\x1f/!!)#\x1f\x19\xa9\x0f99m\x19\x85\x89W\xb3K\x9bM\x9bn\x03\x1b%)9+\x1b\x1f\x1f\x15\x1d\x15+]\x13\r\x1f\x11\x15\x1b\x17\x15\x17\x0f\x11\x15\x11\x19)\x0f\x0b\x11builtin\x00vhlo\x00module\x00broadcast_in_dim_v1\x00constant_v1\x00iota_v1\x00select_v1\x00func_v1\x00add_v1\x00compare_v1\x00return_v1\x00reshape_v1\x00transpose_v1\x00divide_v1\x00call_v1\x00custom_call_v1\x00value\x00sym_name\x00/release/jax/tests/export_back_compat_test.py\x00broadcast_dimensions\x00arg_attrs\x00function_type\x00res_attrs\x00sym_visibility\x00iota_dimension\x00compare_type\x00comparison_direction\x00jax.uses_shape_polymorphism\x00mhlo.num_partitions\x00mhlo.num_replicas\x00jit__lambda_\x00jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=0]\x00jit(<lambda>)/jit(main)/jit(tril)/add\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(8, 8) dimension=1]\x00jit(<lambda>)/jit(main)/jit(tril)/ge\x00jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(8, 8) broadcast_dimensions=()]\x00jit(<lambda>)/jit(main)/jit(tril)/select_n\x00jit(<lambda>)/jit(main)/iota[dtype=float64 shape=(64,) dimension=0]\x00jit(<lambda>)/jit(main)/reshape[new_sizes=(8, 8) dimensions=None]\x00permutation\x00jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]\x00jit(<lambda>)/jit(main)/add\x00jit(<lambda>)/jit(main)/div\x00callee\x00jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]\x00api_version\x00backend_config\x00call_target_name\x00called_computations\x00has_side_effect\x00operand_layouts\x00output_operand_aliases\x00result_layouts\x00mhlo.layout_mode\x00default\x00jax.result_info\x00tril\x00[0]\x00[1]\x00main\x00public\x00private\x00\x01\x00\x00\x00z\x00\x00\x00\x01\x00\x00\x00\x08\x00\x00\x00\x00\x02\x00\x00\x00hipsolver_syevj\x00",
    xla_call_module_version=9,
    nr_devices=1,
)  # End paste


# Pasted from the test output (see export_back_compat_test_util.py module docstring)
data_2024_08_05["f64_syevd"] = dict(
    testdata_version=1,
    platform='rocm',
    custom_call_targets=['hipsolver_syevd'],
    serialized_date=datetime.date(2024, 8, 5),
    inputs=(),
    expected_outputs=(array([[ 3.1486359056225549e-01,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
        -9.4519489704155379e-01,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  0.0000000000000000e+00,
         0.0000000000000000e+00,  8.6414847942068662e-02],
       [ 2.9939200325938975e-01,  2.1183230542766462e-01,
         5.9236316049686372e-03,  4.5450186919036462e-02,
        -5.6997616251692222e-03,  8.3266600339079971e-04,
        -3.4380810242631487e-03,  7.2932773969562751e-03,
        -3.4758415166321541e-03,  3.1600682687548936e-03,
         7.8609217607780585e-03, -1.4748065712380425e-02,
         7.3166031174167433e-04,  3.6015279995076317e-02,
         1.3417020979113326e-03, -7.6369638773924652e-03,
        -1.1677841881559741e-03, -1.2906187378544421e-03,
         4.2488981289316580e-03, -3.0561230680560851e-03,
         8.1254259824823215e-03, -2.1918848905439613e-03,
         1.3878342947901721e-02, -5.5674323028278919e-03,
         8.2908154580486355e-03,  9.2161044076893156e-03,
         1.0802227394760651e-01, -1.7783530548177166e-02,
         3.1295191363441263e-02, -4.7138268632024661e-03,
        -2.3352950859632207e-03,  5.8888917003468155e-03,
        -4.2680036915387375e-02, -1.6003961096588085e-02,
        -9.1533103331508592e-01,  9.0661051391036751e-02],
       [ 2.8392041595652157e-01, -1.0868338152885229e-01,
        -1.0088723438789240e-02, -4.0165828364747041e-03,
        -1.8799129666757820e-03, -2.6829422594247443e-01,
        -1.3050407231052089e-01, -4.3838261605033568e-02,
        -9.3356174956575180e-02,  4.2855178487102401e-02,
        -1.7327346881074089e-02,  3.4482686268096752e-01,
        -4.4450695483569630e-04,  1.7931623605689609e-01,
        -6.2193527085928686e-02,  4.9289158829275664e-01,
         3.3425320608711795e-01,  2.2780656358831759e-02,
         7.4766635505537360e-02,  1.8212030131097340e-01,
         5.1814378781328350e-02, -3.9174846131681242e-02,
         8.3850313573205840e-03, -2.0772220039431991e-01,
         1.4348321062677888e-01,  2.3118452829128741e-01,
         1.0325658539109403e-01,  1.9132571530612272e-01,
        -1.7185447897743344e-01,  9.4376210582842637e-02,
         2.2576188105390249e-02,  1.2940923230858900e-01,
        -5.5810746346352143e-02, -1.1277353310366209e-01,
         8.6715615554929515e-02,  9.4907254840003508e-02],
       [ 2.6844882865365455e-01,  4.0606038514698441e-02,
        -4.6517892410154284e-02,  1.7287262493814046e-01,
        -9.3908447948207269e-02, -1.4695824761685630e-01,
        -7.4496001842783335e-02, -9.3645414930377136e-03,
        -1.8435787625826830e-01,  2.9908847663252242e-01,
        -8.1872742033583246e-03, -1.1168104975498980e-01,
         8.8157198740685130e-02, -9.9490362778996200e-02,
        -3.6930787358990280e-01, -3.4397088067110360e-01,
         6.7277484665597839e-02, -3.5284174308303606e-01,
         1.6294153246114509e-01, -1.6288928584620452e-01,
        -2.2115010739658189e-01,  1.3330170339610434e-01,
        -1.8013847384219422e-01,  9.5971452357455356e-02,
         3.6449076997085508e-02, -4.8250019619963155e-02,
         9.8490896834581995e-02,  1.5375061898917552e-01,
        -2.0762406332574102e-01, -2.9281631445254044e-02,
         2.0196709896361226e-01,  5.8986808591817687e-02,
        -6.3087862652909110e-02,  8.1661369783129739e-02,
         1.1693460632239845e-01,  9.9153458288970875e-02],
       [ 2.5297724135078753e-01,  6.1515333825263628e-03,
        -4.8573648934440959e-02,  2.1372131886111564e-01,
         2.3175774259391789e-02, -4.9254978324212245e-02,
        -1.1969666873140178e-01, -9.6181936401328161e-02,
        -1.7267563946201772e-01, -1.2082033709982985e-01,
        -1.5068208571255012e-01,  3.2409182089693130e-02,
        -1.2016966445444569e-02,  5.0950227094125736e-02,
         3.9166141725294923e-01, -2.8195795695876144e-02,
        -5.5819307727843426e-01,  2.0517958746770093e-01,
        -1.7211270642187529e-01, -2.0704985752979091e-01,
         5.9751347704577532e-02,  1.7398176071539637e-02,
         5.0041554011669577e-02, -1.2349522150586352e-01,
         3.7456835706536962e-02,  5.2113944769309861e-02,
         9.3725208278069960e-02,  1.5040102515120518e-01,
        -2.5338701112932144e-01, -1.0767299161145352e-01,
         2.0118511835222913e-01, -1.9647533745059748e-02,
        -7.3851689300974896e-02,  8.9911042396722929e-02,
         1.0986888720040150e-01,  1.0339966173793821e-01],
       [ 2.3750565404792059e-01,  3.2843508776843729e-02,
         1.2644487656349004e-01,  1.1433646843560429e-01,
         1.0894756332334465e-01,  1.1922710151087305e-01,
         3.4944246060394195e-02,  3.1845297470632680e-02,
         2.1188348659431269e-01, -6.2141703731896002e-02,
        -4.2241423880970706e-02, -9.6761599585183688e-04,
        -7.5483720151148653e-02, -2.3654378096370755e-02,
        -1.5453067722096919e-01,  1.6672376928425289e-01,
        -3.0371415658550333e-01,  3.3752890204023625e-02,
         2.1328686401438496e-01,  3.2192124660083082e-01,
        -2.8020180984470400e-02, -1.4151700746161067e-01,
        -5.6395225412776095e-01, -1.5381887199373770e-01,
        -1.0036290302284345e-01, -1.8191049927791600e-01,
         8.8959519721557925e-02, -2.5887331669281322e-01,
         1.1464925258425260e-01, -2.8883379011485751e-02,
         1.5020872070276784e-02,  1.0356872026440893e-01,
         3.4792022646091105e-03,  7.4920619940993236e-02,
         1.0676286976386783e-01,  1.0764586518690557e-01],
       [ 2.2203406674505363e-01, -1.9594121011972032e-01,
         1.0431036469958915e-01,  6.3490898009168337e-02,
         2.2056190485714811e-01,  1.2005831428231797e-01,
         1.1616394198281542e-01, -1.2718790730134324e-01,
         2.7478296719662784e-02, -6.1964754459031081e-02,
        -2.7139721178462817e-01, -3.6437106835993260e-01,
        -1.3756742187520105e-01,  1.2825949955162241e-01,
         9.2438445598610211e-02,  3.6452814340742656e-02,
         2.8294661708742885e-01,  1.6476880582364786e-01,
         2.1763132005718722e-01,  3.3964629398168515e-02,
        -1.5028904831491932e-01,  9.8001783643655319e-02,
         2.0845594000533216e-01,  2.2492321695251977e-01,
        -1.7464743265947627e-01,  2.3451292562688372e-01,
         8.4193831165045918e-02, -2.3781630020452235e-01,
        -6.1910685531022719e-02, -9.2163797799124134e-02,
         2.0961658576331735e-01, -7.0584233594529450e-02,
         1.8767804205824384e-01,  7.5766075314662645e-02,
         5.0620545135319037e-02,  1.1189206863587293e-01],
       [ 2.0656247944218661e-01,  7.8966351971780594e-03,
        -6.2279326023744884e-02, -1.1861305618072798e-01,
         7.3965589097043094e-02,  2.9378756427907632e-01,
        -9.0697735046555289e-02,  1.6437886081144895e-02,
        -2.5472963725595144e-01, -4.6412423669844843e-01,
         4.4943076407728162e-02,  1.3123388341640638e-01,
        -8.4331246073446359e-02,  7.3763444312115692e-02,
        -1.9401269846089399e-02, -3.4609907949789731e-01,
         2.5387635239910356e-01, -2.2371412591155895e-01,
        -1.6777754010853629e-01,  3.0376151808192016e-03,
         2.9830028180783652e-01, -1.8656470463949434e-01,
        -3.3116996123120933e-02, -5.0559188506391753e-02,
        -1.6942139295655806e-01, -3.1493547344904990e-02,
         7.9428142608533883e-02, -5.6428568136119059e-02,
        -1.1890121435669347e-03, -1.1314398153679338e-01,
        -6.4631677899817837e-03,  2.2059512916389162e-01,
         2.8091908179704375e-03, -1.1779863349198126e-01,
         9.2838070976896045e-02,  1.1613827208484027e-01],
       [ 1.9109089213931957e-01,  6.5805684104588466e-02,
         2.9680043397223532e-01, -1.3037778700663025e-01,
        -5.9723306212114143e-02, -2.4220777686374742e-01,
        -1.0553088301256362e-02, -2.5998725468607309e-01,
        -4.2954888590038189e-02,  2.5442293246726161e-01,
        -4.0217441507206311e-02, -2.5935495022822486e-01,
        -1.4856540807849450e-02, -1.0701117247885386e-01,
         1.5380925250528440e-02, -1.2747335063956697e-01,
        -1.9353652780398155e-02,  6.2280774754745916e-02,
        -2.3508968726542762e-01,  1.3943476924501094e-01,
         3.8733040541391184e-01, -2.7358022198437798e-01,
         6.2441806846941901e-02,  1.8442867809556943e-01,
         2.3643074781653045e-01,  1.4076289794008021e-02,
         7.4662454052021834e-02, -6.3396051460999026e-02,
         2.4578269641903852e-01,  2.4942326693481265e-01,
        -9.4234320055469663e-03,  5.0574606219927015e-02,
        -2.3304048493255011e-02,  3.4752496718804211e-02,
         1.0753322811351362e-01,  1.2038447553380761e-01],
       [ 1.7561930483645261e-01,  1.5666858369183698e-01,
        -1.3972120530667392e-01, -1.5429345429596150e-01,
         7.2419245549085381e-02, -2.2038892695559760e-02,
        -1.6407121753501799e-01, -1.1610668489411911e-02,
         1.3565127881439132e-01,  5.0379171349487287e-02,
        -1.6252732438655809e-01,  1.7174599753014214e-01,
        -1.1354200976611603e-01,  4.0157573982766530e-02,
        -9.9841928288647339e-02,  5.7305920018310356e-02,
        -2.2706216237441246e-01, -3.4381114888188478e-02,
         3.3717902438286991e-02, -3.0089085492290368e-01,
        -7.3066189231634146e-02,  3.0780673334147440e-01,
         1.4211353704813237e-01,  1.4636423635566376e-01,
        -2.5270635081465131e-01,  5.1185642041638703e-02,
         6.9896765495509799e-02, -4.9044073208011331e-02,
         3.1240000896173042e-01,  3.3346272455684906e-01,
        -1.9150145406657770e-01,  2.3457169173335857e-01,
         1.3483539360888028e-01, -2.3949911444513158e-01,
         1.1156010189586152e-01,  1.2463067898277495e-01],
       [ 1.6014771753358564e-01, -4.7593897841158736e-02,
        -1.2707484842750127e-01, -7.4263307668751541e-02,
         1.1460617110472414e-01,  1.3998296870860069e-01,
        -1.0903590841872627e-02,  7.9429637832636610e-02,
         6.3797716476678451e-02,  2.6138695634304743e-01,
        -7.3259207816453065e-02, -9.3868041507181241e-02,
         4.8388206810468365e-01, -8.3358771669074488e-02,
         9.1044752778134660e-02,  1.4517839622513828e-01,
         2.2164869985579264e-01,  2.2890510144100451e-01,
        -2.8065005511723956e-01, -2.3285975603349107e-01,
        -2.6556806114369676e-02, -6.6982108817582708e-02,
        -2.3392164196876916e-01,  2.9612085033989155e-02,
        -9.3096941740544045e-02, -1.0081592338700222e-01,
         6.5131076938997778e-02,  1.4907592929905261e-01,
         1.7900494779781734e-01, -3.6157796735373471e-01,
        -1.3807601496753660e-01,  5.2702045773883955e-03,
         7.1395121471801937e-02, -8.5872946789939064e-02,
         5.1822218026299056e-02,  1.2887688243174231e-01],
       [ 1.4467613023071862e-01, -9.8210831902730514e-02,
        -1.6328934245036386e-01, -1.4983736064487982e-01,
         1.6905586565676931e-01,  8.4367659212149337e-02,
         5.0696780299298187e-02,  5.6655897600394328e-02,
         3.5966820378552561e-02,  1.8839079004821829e-01,
         4.8736409213464926e-01,  8.4291316641301323e-02,
        -4.8176817163694646e-01, -2.2886825485111381e-01,
         8.9937924378600501e-02,  4.1903543937723359e-02,
        -8.8882042436196837e-02, -1.5635878275204299e-02,
         1.0358240017853186e-01,  1.4731327670252649e-02,
         6.9646150800415349e-02,  5.5645733095001731e-02,
         1.0465350081257501e-02,  2.1732395842734090e-01,
         1.1884656367787205e-01,  1.7062418071381477e-01,
         6.0365388382485737e-02,  1.4939315646933077e-01,
         1.0823063755624897e-01, -3.3209098361337930e-01,
        -6.4301401402765482e-02, -7.3805106653825323e-02,
        -6.3211087439031852e-02,  7.0139917994952561e-02,
         3.6025448026279411e-02,  1.3312308588070967e-01],
       [ 1.2920454292785163e-01,  1.6504626300565255e-02,
         2.3343019315911093e-01, -7.6209573605823339e-02,
        -1.6629397766487547e-01, -2.9086209244343821e-02,
        -6.9336871396437003e-02,  2.0375666105430396e-01,
        -9.3635146292641303e-02, -2.6810572579724801e-01,
         2.9516409588203740e-01, -2.2837607487422246e-01,
         8.9397911329711879e-02, -1.8340016905478143e-01,
        -8.7811603715848813e-02,  2.5442929574135120e-01,
        -5.7820181142142470e-02, -2.2644035917049186e-02,
         2.0522255739449324e-02, -2.9083643060969411e-01,
        -3.6924790464266005e-01, -2.6259042772153685e-01,
         2.7045616874449152e-01, -8.4177017299305310e-02,
         1.2811699144557948e-01, -2.2310870422594685e-02,
         5.5599699825973702e-02, -2.3955100449980876e-01,
        -5.3782766378790382e-03, -1.8032792234970771e-02,
        -1.1614204544616379e-01,  1.1259186669789023e-01,
        -1.0255022649276618e-01,  1.5963957299213648e-02,
         7.7273889101040022e-02,  1.3736928932967701e-01],
       [ 1.1373295562498462e-01,  5.1295154298268810e-03,
         2.4955966648296626e-01, -4.7780634235167103e-02,
        -1.7243763885405813e-01, -9.5383505197557450e-02,
        -1.3315016243930533e-01,  2.8714750526377431e-01,
         6.4818710629965540e-02,  4.5322526650491558e-02,
         1.2122187065236278e-02,  1.3507961183056896e-01,
         3.4000288347373508e-02, -1.8644573536582879e-01,
         3.2453503342230428e-01, -3.3668519740425457e-01,
         1.7287183761777586e-01,  2.0545188227968683e-01,
        -4.0548526740793060e-02,  3.1247696846141404e-01,
        -1.3358825389964646e-01,  4.4530800950213772e-01,
         2.1200357565858807e-02, -1.2129890849217795e-01,
         9.3269782467661749e-03, -5.0262161178643919e-02,
         5.0834011269461667e-02, -1.5568867454303920e-01,
        -5.9632469160551434e-02, -1.0132981647967037e-02,
        -1.7800558625893179e-01,  6.1043558667296390e-02,
        -9.5884961212593711e-02,  2.0415263347958557e-02,
         5.7887576570569206e-02,  1.4161549277864435e-01],
       [ 9.8261368322117654e-02,  3.7198786105076126e-02,
        -1.7949840694550875e-01, -2.7499104199626530e-02,
        -4.0648845014304699e-02, -8.6068476995359508e-02,
         2.2139779866634393e-01,  1.6224461417926068e-02,
         1.0486537617125442e-01, -2.2868223411710820e-01,
        -6.0432911383520069e-02,  1.8790547709182059e-01,
         1.4495330076151880e-01, -1.7718150565616214e-01,
        -2.3188754244515863e-01, -2.4454499171643426e-01,
         4.0916961036901317e-02,  4.7034751423769322e-01,
         4.2756195394735635e-01, -1.5056067335730949e-01,
         1.8765922890480904e-01, -1.4425576824718547e-01,
         6.9523170084246397e-02,  2.3730789495797468e-02,
         1.2820255818206996e-01, -4.7543111016546118e-02,
         4.6068322712949639e-02,  8.2730795226008902e-02,
        -6.6302691464351457e-02,  1.0049881157590673e-01,
        -1.2253570561414590e-01, -2.4258761414737454e-01,
        -5.0229428445863573e-03,  5.0407627102126897e-03,
         4.7570384950133132e-02,  1.4586169622761172e-01],
       [ 8.2789781019250663e-02,  1.3592827131697160e-02,
        -8.9831563315196025e-02, -8.0518206670288237e-02,
        -5.5367550837350649e-02, -5.5590699095869972e-02,
         2.1906041369226487e-01, -1.0301124342342542e-01,
        -1.0103527387840751e-01, -3.3265382334110422e-01,
         2.5738526717683341e-01, -3.3150416546572459e-01,
         1.2584352545586341e-01, -7.3590991560161273e-04,
        -2.3122717176440311e-01,  1.8587944106410376e-01,
        -8.0571248105326759e-02,  5.4992283122463010e-03,
        -2.6651896368469186e-01,  2.0123868281748730e-01,
         9.8139877330912256e-02,  4.8908722514011321e-01,
        -8.1311478544293311e-02, -3.4390411031141222e-03,
        -6.4428231261844618e-02, -3.3272232478503416e-02,
         4.1302634156437604e-02,  1.6020884063409374e-01,
        -5.4626250872647789e-02,  1.2217508270568732e-01,
        -1.9660772441730451e-02, -2.3929464768276526e-01,
         6.3549955577180989e-02, -5.6943848372134398e-02,
         3.5696213587107631e-02,  1.5010789967657906e-01],
       [ 6.7318193716383617e-02,  4.7192552657599598e-02,
         1.1228261938537479e-01,  2.3102250685970746e-01,
        -1.1987501829573463e-02,  1.8890711306383845e-01,
         8.7126380217867436e-02, -2.7547310817530768e-01,
         1.2455912996542337e-01,  1.7077249050505552e-01,
         2.0271354494820940e-01,  1.7324436835320389e-01,
         1.8385753630513543e-01,  1.4561930190258693e-01,
        -6.2983851584456768e-02,  1.8254010498085348e-02,
        -3.1259150130440783e-02, -8.0013669241937688e-02,
         1.0774644097663502e-01,  1.5028908825455953e-01,
         6.3392541246004991e-02,  5.6930759845667707e-02,
         5.2124335876502337e-01, -1.5821154210017119e-01,
        -1.5704617424265116e-01, -3.6879893561830746e-01,
         3.6536945599925555e-02,  3.6208521526568373e-02,
         1.7622031749208725e-01, -1.6469719442820485e-01,
         1.2584623367495343e-01, -3.1012782850411307e-02,
        -1.3489677018217311e-01, -3.5705259812859489e-03,
         8.3469660930809625e-02,  1.5435410312554640e-01],
       [ 5.1846606413516683e-02, -4.2046030373288731e-02,
        -1.5706166667791421e-01,  4.0763462523894518e-02,
         9.6379194625540680e-03, -1.8845123454344190e-01,
         1.8406743854324042e-01, -1.2171229675516169e-01,
        -6.7689074753759834e-02,  1.1161837789967856e-01,
        -4.3596582066818587e-02, -5.2764563324892183e-02,
        -4.4497423805233294e-01,  1.1160108627270478e-01,
         1.5936223021804968e-01, -2.2038064298149383e-02,
         2.0665145969043275e-01, -1.7306535896912955e-02,
        -1.5980422832949426e-01, -1.6072308723814138e-01,
        -2.0241209680162439e-01, -1.4237889879502957e-01,
        -7.5281982875997897e-02, -2.5190012891441466e-01,
        -1.0047292713357246e-01, -4.5303565456261102e-01,
         3.1771257043413541e-02, -4.8352040880537232e-02,
        -7.2851311810235950e-02,  1.5135942765333035e-01,
        -2.4584736051445130e-01, -2.5947984729794821e-01,
         3.5923699948819617e-02, -2.4590003997052266e-02,
         1.9773012433169777e-02,  1.5860030657451377e-01],
       [ 3.6375019110649699e-02, -4.1546329992206525e-02,
        -3.2681074314914943e-01, -4.4782613475112733e-02,
        -1.8431119496386536e-01,  6.0701062904800387e-02,
        -7.0518721692481898e-02, -4.2310509028514423e-02,
         2.4499944454376416e-01,  1.1032527129998414e-01,
         1.1362942749200880e-01, -6.8879241079178866e-02,
         1.8997725929180123e-01, -1.8982208831128564e-01,
         1.9263630539511861e-01, -2.0046293187861247e-02,
        -7.1027980843241703e-02, -1.7249715489401293e-01,
        -1.1861919334655566e-02,  2.6108332169987031e-01,
        -5.4846994507101926e-02, -3.2122856317342008e-01,
         7.8599839335568827e-02,  8.2038092871250343e-02,
        -4.1994948576841340e-01,  2.1866115678923068e-01,
         2.7005568486901516e-02, -5.2901277081786897e-03,
        -3.0980624460459888e-01,  2.4753227299541308e-01,
        -7.9021344953753139e-02, -8.0144451139789241e-02,
        -2.5105343358345140e-02, -5.2733891120088699e-03,
         1.0247341331599141e-03,  1.6284651002348111e-01],
       [ 2.0903431807782695e-02, -1.4772744384715575e-01,
         1.8383454921673281e-01, -2.9728126569038092e-02,
        -4.3190036576863905e-02,  1.1497847897353909e-01,
         1.4565936757199080e-01,  4.9997416304245268e-01,
        -3.1403786712900972e-01,  1.4190531692490732e-01,
        -4.2524691491541186e-02,  6.7080636659878082e-02,
         1.1125293293772689e-01,  1.7989271519412392e-01,
         1.9509300560369408e-01,  1.4166637542933558e-01,
        -1.2278901514701211e-01, -2.0496396651424695e-01,
         2.1193575559112215e-01, -1.0875248469733246e-02,
         2.0917155624891015e-01, -2.7965224707305843e-02,
        -1.8491651394136128e-02,  2.7243756592195867e-01,
        -1.3721728653401455e-02, -1.7993647828713921e-01,
         2.2239879930389478e-02,  1.9948568564116830e-03,
        -2.0720108636643274e-02,  1.6806390418342998e-01,
         3.9567662336546051e-02, -2.7030443097176082e-01,
         6.4029494270653187e-02, -1.9808483945315869e-01,
        -1.6036946879139516e-03,  1.6709271347244847e-01],
       [ 5.4318445049156838e-03,  9.5123004486633800e-02,
        -8.2743213258945611e-02, -1.3632303116507782e-01,
        -3.7911925335258101e-01, -2.0874694583555695e-01,
         1.2387683740249962e-01,  1.0174727084565142e-01,
         2.7867146269573162e-01, -2.1276412196034331e-01,
        -3.5531686057140732e-01, -8.0180174308987037e-02,
        -5.9511594412636239e-02, -4.3675937550186103e-02,
         1.6448495882902428e-01,  1.0231154106708719e-01,
         3.1579440542380266e-02, -3.7746791392873158e-01,
         1.1394056342915038e-01, -1.0912533308312301e-02,
         1.0666859498953078e-01,  2.1277795962633315e-02,
         5.2685634909873193e-02, -7.2804001477461522e-02,
         6.2822349782880788e-02, -1.2147336814810113e-02,
         1.7474191373877436e-02,  1.9586338142985385e-01,
         2.3328166608594794e-01, -2.9238498853633710e-01,
         5.8682590679853062e-02, -3.4042323499405679e-03,
         9.5547321108424621e-02,  2.2744594509241517e-01,
         3.2818773134362607e-02,  1.7133891692141578e-01],
       [-1.0039742797951329e-02, -3.3739639812286067e-02,
        -8.1340993422948232e-02,  1.8110920346284554e-01,
         6.3681375997702641e-02,  1.0819763585910419e-01,
         2.2024444795894427e-01, -3.9462674555240607e-02,
         1.2863666224976078e-01,  7.5131829284209958e-02,
         1.0354266824063227e-01,  1.3971050956672348e-01,
         1.3487839483482744e-01, -8.0037878799035553e-02,
         1.0433079816581067e-01, -8.0425614019440789e-02,
         5.4120662985839688e-02, -2.3783814959602306e-01,
        -1.0433924145693717e-01, -2.2181446071545260e-01,
         6.6358065676116851e-02,  1.0080361011375931e-01,
        -9.4492546315239470e-02, -3.4777462410145965e-01,
         2.8150379727004038e-01,  3.7274924451048985e-01,
         1.2708502817365399e-02, -3.8969910087848936e-01,
         1.4864219997356395e-01,  1.4555965032942930e-01,
         1.6612359477981214e-01, -2.1269062094361202e-01,
         8.7972702724313540e-02, -9.7478990601651161e-02,
         2.6586762791525061e-02,  1.7558512037038315e-01],
       [-2.5511330100818255e-02, -1.3673072827004570e-01,
        -5.7551208989182437e-02,  7.0348431188150901e-02,
         1.4862127900060368e-01,  2.8306976441718534e-01,
         4.7382403760370222e-03,  2.4977104937826436e-01,
         2.3772006617881658e-03,  1.6168837712930767e-01,
        -3.1763699444132165e-01, -4.7042660918653272e-02,
        -8.1736087702709362e-02,  1.9660334614721978e-04,
        -3.6389750678593896e-01,  4.5787573069748138e-03,
        -1.4469367704090658e-01, -5.5966756957195017e-02,
        -2.2579765775680105e-01,  1.3940162128374983e-01,
         7.8946455601833679e-02,  5.2243656205899216e-04,
         2.6745399784550039e-01, -1.6456978256623830e-01,
         2.0333184855337907e-01,  7.7928261245379590e-02,
         7.9428142608533869e-03,  2.8340918828417539e-02,
        -1.8249424745175929e-01, -8.9459857472710940e-03,
        -3.7735465297412119e-01,  3.5810373474862774e-02,
         7.6986622567440682e-02,  2.7528924164979846e-01,
        -2.5685173752612922e-02,  1.7983132381935052e-01],
       [-4.0982917403685232e-02, -1.1198548606874409e-01,
         3.5298411104856039e-03,  5.5316863196373453e-02,
         3.4811786586153876e-01,  9.7592538970084103e-02,
        -7.3772618099626847e-02, -1.7670904801327142e-01,
         2.2574084662808427e-01, -2.5909293217290863e-01,
        -2.9637529654779695e-02,  1.3728948794864992e-01,
         1.4621062012258768e-01, -1.0459419077964641e-01,
         2.0852256003123251e-01,  3.2571262018720931e-02,
         7.8609716897162299e-02, -2.0051881641806937e-01,
        -4.1007555720332302e-02,  3.6366798720005006e-02,
        -2.1583442498808555e-01,  2.9661243305395858e-02,
        -4.9287447129960978e-02,  3.5659020641874117e-01,
         3.9657973141321262e-01, -2.7322434108963845e-01,
         3.1771257043413598e-03,  1.5202075623070174e-01,
        -7.1300965574781203e-02,  2.3820073008043560e-01,
        -1.0939110174104727e-02,  8.3315888571288188e-02,
        -3.0229127411792144e-02,  1.1774100245062197e-01,
        -4.0231947704148424e-02,  1.8407752726831786e-01],
       [-5.6454504706552340e-02,  1.3326680512461950e-01,
         1.1762424331324160e-01,  1.3318590380929279e-01,
        -7.1831502379026912e-02, -5.9211102349876359e-02,
        -3.5821739924540130e-01,  4.2550563110666184e-02,
         4.5374135562631698e-03, -1.1762561906281745e-01,
        -4.8058415428428397e-02,  2.4248642390748648e-01,
        -7.9300236531033616e-02,  8.9112687512811067e-02,
        -2.1193825446730488e-01, -7.7853065979455016e-02,
        -1.7959138952798097e-02,  5.9805874325903285e-02,
        -2.5219663273706266e-01,  1.6137678534715644e-01,
        -2.8001705080934275e-01, -1.7673877152170461e-01,
        -2.2263576492680807e-03,  1.9135331821682505e-01,
        -2.1289702950285365e-02,  1.3423664592167975e-01,
        -1.5885628521707087e-03,  4.5777136732353882e-02,
         2.0815075359752916e-01, -1.3029900409645137e-01,
         1.0576127295356798e-01, -5.1187770527860577e-01,
         1.8234263244435975e-01, -7.0064297348815793e-02,
         3.1518448358186978e-02,  1.8832373071728520e-01],
       [-7.1926092009419226e-02, -7.3415421466677538e-03,
        -2.1599959418859593e-01, -1.6961808610041834e-01,
        -4.5174717367377430e-02,  1.9678206102983337e-01,
         8.9493776494291397e-02,  1.6635413601483640e-01,
        -4.4108175461030040e-03,  4.4162701878396014e-02,
         3.8303102468101552e-03, -2.3646136016177757e-01,
        -5.1154205751556499e-02,  3.0231339545127234e-01,
         3.7888649384070605e-02, -1.9233059765898408e-01,
        -3.8942696604433003e-02,  1.8519933390876969e-01,
         4.0474067524404148e-02,  1.8348899657685883e-01,
        -2.9923608318028738e-01, -1.1524717449115163e-01,
        -3.5377237014681958e-04, -1.8293337825341352e-01,
         2.0819827834162366e-01,  7.6950960399504206e-02,
        -6.3542514086827075e-03,  2.9038065644160171e-01,
         2.5615807473455332e-01,  1.8117553887801541e-01,
         2.6532461168581234e-01,  1.7048281076202104e-01,
        -2.0252310112342226e-01, -1.8758164364793575e-01,
         1.8332108270864501e-02,  1.9256993416625257e-01],
       [-8.7397679312286342e-02,  2.6273974836032515e-01,
         2.3873877812445871e-01,  9.8119482106585540e-02,
        -4.2502758163135278e-02, -2.8214668423296913e-02,
         2.2843859549529413e-01,  1.6881256797033367e-02,
         2.8578609234972491e-01, -7.5494272752010903e-03,
         1.0881231247538872e-01,  1.9182842038641474e-02,
        -1.6258342925925151e-02,  5.0354959739218463e-01,
        -1.6196823680050008e-02, -5.6425914971750674e-02,
         3.9136007703649812e-02,  4.3483632879358063e-03,
        -9.0604467774579089e-02, -1.8704052095652507e-01,
         4.3222308985708086e-02, -2.1417906720274495e-03,
        -1.4641714405041484e-01,  2.3051600865540522e-01,
        -5.8304801137656778e-02,  2.2145662815120437e-01,
        -1.1119939965194782e-02,  9.2760981648712503e-03,
        -2.1317893675383426e-01, -8.0138206700492695e-02,
        -2.4153732066168737e-01,  6.0718305169148903e-02,
        -3.3594133426828454e-01,  6.4567588312117036e-02,
         8.3196363975090462e-02,  1.9681613761521990e-01],
       [-1.0286926661515317e-01, -4.1615700437514563e-01,
         6.1180423399883034e-02, -3.4437853968029952e-01,
         4.1106892457245463e-02, -3.1254260178142673e-01,
         6.5777879702692390e-03, -2.4574020212159271e-02,
         2.4708746867958825e-01,  3.3864443089532070e-02,
         9.3513705865392691e-02,  7.1558219824646913e-02,
         5.1106962067881644e-02,  1.8516512594244738e-01,
        -1.5056950920959550e-01, -1.6368312780351765e-01,
        -1.9975154554055899e-01,  5.9569557095552972e-03,
        -8.4022762754776922e-02, -3.1726110856155343e-02,
         1.5357138698615836e-02, -2.6884045362324960e-02,
         3.0471548260171229e-02, -2.8112407929251841e-02,
         2.8686318843436195e-02, -1.2341807268172462e-01,
        -1.5885628521706757e-02, -1.5481400772805931e-01,
        -2.4312730190978879e-01, -2.1742640581532580e-01,
         1.7115184361727837e-01,  1.4887544548699974e-01,
         2.6961837651059301e-01, -2.2677870969009678e-01,
        -1.3453896122038758e-01,  2.0106234106418727e-01],
       [-1.1834085391802023e-01,  1.7803118015774877e-01,
        -1.2013500143990707e-01, -1.3244914589859855e-01,
        -3.7156068265192976e-01,  2.3324859157048658e-01,
         3.3759291653332128e-02, -3.6371757898167595e-01,
        -3.4576037297577417e-01,  1.0350252483484890e-01,
         4.6777798693331533e-02,  1.1734561070384639e-01,
         6.6167470525310412e-02,  1.4809703346751016e-01,
         9.2610547219828240e-02,  5.1116983488700210e-02,
        -4.9653805095944685e-02,  8.4051990789789463e-02,
         1.4673879949635998e-01,  8.0476549334084949e-02,
        -1.2504163721824851e-01,  4.3085071425842038e-02,
        -1.0238290719133047e-01,  1.1836769609747121e-01,
         2.0677389726716125e-01,  1.0064473015304205e-02,
        -2.0651317078218816e-02, -1.7501349163151469e-01,
        -8.1424853710587983e-02, -9.5803042768651439e-02,
        -1.7360215928160386e-01,  1.4838718411388044e-01,
         3.6627728171906154e-01,  1.2246908631265296e-01,
         4.4244791314802069e-04,  2.0530854451315461e-01],
       [-1.3381244122088717e-01, -2.8313435458955999e-01,
         4.2470023762077469e-01, -6.0830768919000265e-02,
        -8.4646737995349206e-02,  1.6325001082558038e-01,
         2.7884981346341124e-03, -9.7407697249893968e-02,
        -2.9451726979974911e-02,  4.8848631260514372e-03,
         1.0588809284462292e-01,  1.0871619953364489e-01,
        -4.9441011140632193e-02, -1.0422028868957478e-01,
        -1.5038674202098619e-02, -2.4926128107001268e-02,
         4.3056176463687854e-02,  7.7118869879466478e-02,
         3.0970074720814943e-02, -2.2523716862980783e-01,
        -3.4338801852160654e-03, -6.7263866434116772e-04,
        -1.4646503255841978e-01, -1.8922745920287160e-01,
        -2.9710638802600298e-01,  1.2022551168416584e-01,
        -2.5417005634730833e-02,  3.6652240785119583e-01,
         1.0074324099235002e-01,  2.4178114310814131e-01,
         7.1396100644252489e-02,  4.5789761949291193e-02,
         1.5347468076475004e-01,  3.5374370203317673e-01,
        -1.1658539232177931e-01,  2.0955474796212198e-01],
       [-1.4928402852375416e-01, -1.2512448028884757e-01,
        -1.2010696728927103e-01,  9.9878523018547549e-02,
        -3.6397005967963553e-01,  1.9343214402172418e-01,
        -2.4365318017226054e-02,  1.2656845297715548e-02,
         5.3784987749315900e-02,  3.5994675368120961e-02,
        -1.6215670708315150e-01,  9.3313614332384789e-02,
        -2.2370911863823884e-01, -2.3455765959521852e-01,
        -1.6099943341592290e-01,  2.1509485153278074e-01,
         1.1667378139073689e-01,  1.8659927143548516e-01,
        -2.1340193740618446e-01, -1.0945567078344001e-01,
         1.3375575410392410e-01,  9.2236064358825573e-02,
        -4.9876488698916456e-02,  2.1678093916243160e-01,
        -1.1826513824548218e-02, -1.4924542862022633e-01,
        -3.0182694191242865e-02, -2.0115515805969308e-01,
        -9.1412614267113140e-02,  3.1107277140225834e-02,
         3.4426674245161953e-01,  1.1021000807822498e-01,
        -3.3208832645555741e-01, -7.7634272113507902e-02,
        -5.4229150995271397e-02,  2.1380095141108932e-01],
       [-1.6475561582662129e-01,  4.8963577428599425e-01,
        -4.6915375806999567e-02, -4.1622537097133372e-01,
         3.7328045976527080e-01, -9.0987365780356308e-02,
        -4.2852370161757018e-02,  1.2279969313358668e-01,
        -1.0652339027075512e-01,  9.5582374363313127e-02,
        -7.8828993731884078e-03,  6.4035717441094112e-02,
         4.9792192881849419e-02, -4.9672189494765706e-02,
        -1.3075937283415776e-02,  9.7646569919367002e-02,
         6.3679396847154721e-02,  2.8969405419492666e-02,
        -1.0657727926552426e-02, -7.0635303809967369e-03,
         3.8730264360996365e-02,  1.4161717784803397e-02,
         4.4542928408764372e-02, -1.0641434241810327e-01,
        -1.1367600943637639e-01, -7.7713573477449824e-02,
        -3.4948382747754948e-02, -1.3745553107392897e-01,
        -1.4368101543623080e-01,  3.8655015319559810e-02,
         3.3064616439774630e-01, -6.1536682858578676e-02,
        -4.8221885544063189e-02,  3.2807072970427364e-01,
         4.4050330707541017e-02,  2.1804715486005660e-01],
       [-1.8022720312948826e-01, -1.3310674835568864e-01,
        -3.1444725051219002e-01,  4.2324289743428711e-01,
         5.5243434098142148e-02, -3.1205615197157116e-01,
        -2.5614303595143928e-01,  2.0087783253930652e-01,
        -8.6930033329778209e-02, -5.4893934406441067e-02,
         2.3975437650920806e-01, -1.4152776037438600e-01,
         6.6061694037507418e-02,  1.9283121010232024e-01,
         3.4263150580775684e-02, -1.3509739320201778e-02,
         7.4026098755653358e-02,  1.0142077270653711e-01,
         6.8243646692643725e-02, -3.4810605406456500e-03,
         1.9145444387090743e-01,  1.2068235611823569e-02,
        -7.3894753184909380e-03,  6.4089143995706921e-02,
        -6.2987150934921396e-02, -4.0942672834497491e-02,
        -3.9714071304266969e-02, -1.3519851681609374e-01,
         2.2737461694240482e-01,  5.5433136862337307e-02,
        -2.5675056136691396e-02,  1.9864632633488108e-01,
         1.0389160211688468e-01,  3.0166044974726092e-01,
        -3.7607806522835137e-02,  2.2229335830902400e-01],
       [-1.9569879043235516e-01, -2.5984376586687274e-01,
        -1.2385150671330732e-02, -1.6736925019052362e-01,
         1.3312806010356787e-01, -1.2048946432667480e-01,
        -1.5518297325163824e-01, -2.8085820948722184e-01,
        -2.7651195852976362e-01, -4.3136293046904507e-02,
        -2.1043022148620494e-01, -3.9622684058427199e-02,
         1.1453480855867262e-01, -3.3563585723167387e-02,
        -9.3991835404714907e-03, -1.2163632727320127e-02,
        -1.0553102696859883e-01, -1.2228540343645380e-01,
         1.9566749396297481e-01,  2.7364466566628387e-02,
        -3.3632720551115630e-02,  6.5440631903600083e-02,
        -7.2975630425753377e-02, -6.3449233788037379e-02,
        -8.6174286663653732e-02,  1.2470229181438505e-01,
        -4.4479759860778970e-02, -1.1863494022067639e-01,
         1.6740559132388452e-01, -1.4596836111335210e-01,
        -2.4115874674110754e-01, -1.6706594088237034e-01,
        -5.2521822083655523e-01, -5.8545820991378554e-02,
        -8.5092349312913249e-02,  2.2653956175799136e-01],
       [-2.1117037773522229e-01,  2.2901621334469016e-01,
         1.4418874588656086e-01,  1.2664571201410829e-01,
         5.6671883432294741e-02,  1.4150966513168090e-01,
        -4.2178374564979709e-01, -6.2872025378117063e-02,
         1.5526921060999249e-01,  3.0121046556592132e-02,
         2.0292134251752546e-02, -3.3547374177010825e-01,
        -1.2400445685111461e-01, -1.0197752545529995e-01,
         5.2000522724923670e-02,  4.9452086124449367e-02,
         8.0379003899127069e-02, -1.2940560026572387e-02,
         2.4682672856610280e-01, -8.4562277303037420e-02,
         2.3223548268633851e-01,  4.7537295145895241e-02,
        -4.4380222872105628e-02, -1.9151960326389653e-01,
         1.0460710531292929e-01, -3.8676824432320053e-02,
        -4.9245448417291053e-02,  1.5675810601178297e-01,
        -2.1339956766364723e-01, -5.1971300632802517e-02,
        -6.5750013288080542e-02, -4.4350620633534857e-02,
         1.4279295645029938e-01, -3.9365094014677049e-01,
         4.0779000761140662e-03,  2.3078576520695865e-01],
       [-2.2664196503808917e-01,  1.5967755289885807e-01,
         9.9823518118934682e-02,  2.9560951753687537e-01,
         1.8203260205566618e-01, -2.2434279377608360e-01,
         4.4064982901926419e-01,  2.3875546958934665e-02,
        -2.1837588574880429e-01, -3.1005249337601942e-02,
        -1.0008088284145909e-01,  8.5367256303817834e-02,
        -3.0705948897710451e-02, -3.3457341331174828e-01,
         1.2767839194635951e-02,  4.5512312863272685e-03,
        -4.3330562711037614e-02, -1.3083461946889827e-04,
        -6.4411722895079085e-02,  1.5226148208182727e-01,
        -1.2368632436985560e-01, -1.0016014892901307e-01,
         5.0502937238265398e-02,  5.2466997554931311e-02,
        -1.4188868371453020e-01,  1.1310889396882377e-01,
        -5.4011136973803046e-02,  1.2416551314191362e-01,
         1.5962911236885806e-02, -1.1347536995016223e-01,
        -1.9802040671322785e-02,  3.0304963716459316e-01,
         1.1702343445376304e-01, -2.8741378042586885e-01,
        -2.3494688115637950e-02,  2.3503196865592604e-01]]), array([-1.8988227080038207e+03, -2.6528241632548815e-12,
       -3.3277870639795909e-13, -3.3119872857787014e-13,
       -3.0073017871173614e-13, -2.4900871371101037e-13,
       -2.4380941968532238e-13, -2.0362837302066240e-13,
       -1.5715182694042467e-13, -9.4322445866870228e-14,
       -9.4153461366433536e-14, -6.7159529978666889e-14,
       -5.4818601719865571e-14, -5.0879468030872432e-14,
       -2.4063174734339525e-14, -1.9330265417602757e-14,
       -8.5260493003140241e-15,  1.0744395175755145e-14,
        1.6787354220908418e-14,  2.0679057789791284e-14,
        2.8839529139248562e-14,  4.2907634034476049e-14,
        5.2762839567527362e-14,  7.9568223093910615e-14,
        9.0734191344666915e-14,  9.0961574906642337e-14,
        1.1368683772161603e-13,  1.5586217579876092e-13,
        2.1519178578248814e-13,  2.2764864688867768e-13,
        2.4371850347966832e-13,  2.9248378306608422e-13,
        3.8821910276429753e-13,  4.2775901847492870e-13,
        1.0144319101652044e-12,  2.5208822708003856e+04])),
    mlir_module_text=r"""
#loc3 = loc("/release/jax/tests/export_back_compat_test.py":263:0)
#loc9 = loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))
module @jit__lambda_ attributes {jax.uses_shape_polymorphism = false, mhlo.num_partitions = 1 : i32, mhlo.num_replicas = 1 : i32} {
  func.func public @main() -> (tensor<36x36xf64> {jax.result_info = "[0]", mhlo.layout_mode = "default"}, tensor<36xf64> {jax.result_info = "[1]", mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<1296xf64> loc(#loc4)
    %1 = stablehlo.reshape %0 : (tensor<1296xf64>) -> tensor<36x36xf64> loc(#loc5)
    %2 = stablehlo.transpose %1, dims = [1, 0] : (tensor<36x36xf64>) -> tensor<36x36xf64> loc(#loc6)
    %3 = stablehlo.add %1, %2 : tensor<36x36xf64> loc(#loc7)
    %cst = stablehlo.constant dense<2.000000e+00> : tensor<f64> loc(#loc)
    %4 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f64>) -> tensor<36x36xf64> loc(#loc8)
    %5 = stablehlo.divide %3, %4 : tensor<36x36xf64> loc(#loc8)
    %6 = call @tril(%5) : (tensor<36x36xf64>) -> tensor<36x36xf64> loc(#loc9)
    %c = stablehlo.constant dense<36> : tensor<i64> loc(#loc10)
    %c_0 = stablehlo.constant dense<36> : tensor<i64> loc(#loc10)
    %7:4 = stablehlo.custom_call @hipsolver_syevd(%6) {api_version = 2 : i32, backend_config = "\01\00\00\00z\00\00\00\01\00\00\00$\00\00\00@\AC\00\00", operand_layouts = [dense<[0, 1]> : tensor<2xindex>], output_operand_aliases = [#stablehlo.output_operand_alias<output_tuple_indices = [0], operand_index = 0, operand_tuple_indices = []>], result_layouts = [dense<[0, 1]> : tensor<2xindex>, dense<0> : tensor<1xindex>, dense<> : tensor<0xindex>, dense<0> : tensor<1xindex>]} : (tensor<36x36xf64>) -> (tensor<36x36xf64>, tensor<36xf64>, tensor<i32>, tensor<44096xf64>) loc(#loc10)
    %c_1 = stablehlo.constant dense<0> : tensor<i32> loc(#loc10)
    %8 = stablehlo.broadcast_in_dim %c_1, dims = [] : (tensor<i32>) -> tensor<i32> loc(#loc10)
    %9 = stablehlo.compare  EQ, %7#2, %8,  SIGNED : (tensor<i32>, tensor<i32>) -> tensor<i1> loc(#loc10)
    %10 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1x1xi1> loc(#loc10)
    %cst_2 = stablehlo.constant dense<0x7FF8000000000000> : tensor<f64> loc(#loc10)
    %11 = stablehlo.broadcast_in_dim %cst_2, dims = [] : (tensor<f64>) -> tensor<36x36xf64> loc(#loc10)
    %12 = stablehlo.broadcast_in_dim %10, dims = [0, 1] : (tensor<1x1xi1>) -> tensor<36x36xi1> loc(#loc10)
    %13 = stablehlo.select %12, %7#0, %11 : tensor<36x36xi1>, tensor<36x36xf64> loc(#loc10)
    %14 = stablehlo.broadcast_in_dim %9, dims = [] : (tensor<i1>) -> tensor<1xi1> loc(#loc10)
    %cst_3 = stablehlo.constant dense<0x7FF8000000000000> : tensor<f64> loc(#loc10)
    %15 = stablehlo.broadcast_in_dim %cst_3, dims = [] : (tensor<f64>) -> tensor<36xf64> loc(#loc10)
    %16 = stablehlo.broadcast_in_dim %14, dims = [0] : (tensor<1xi1>) -> tensor<36xi1> loc(#loc10)
    %17 = stablehlo.select %16, %7#1, %15 : tensor<36xi1>, tensor<36xf64> loc(#loc10)
    return %13, %17 : tensor<36x36xf64>, tensor<36xf64> loc(#loc)
  } loc(#loc)
  func.func private @tril(%arg0: tensor<36x36xf64> {mhlo.layout_mode = "default"} loc("jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]"(#loc3))) -> (tensor<36x36xf64> {mhlo.layout_mode = "default"}) {
    %0 = stablehlo.iota dim = 0 : tensor<36x36xi32> loc(#loc11)
    %c = stablehlo.constant dense<0> : tensor<i32> loc(#loc9)
    %1 = stablehlo.broadcast_in_dim %c, dims = [] : (tensor<i32>) -> tensor<36x36xi32> loc(#loc12)
    %2 = stablehlo.add %0, %1 : tensor<36x36xi32> loc(#loc12)
    %3 = stablehlo.iota dim = 1 : tensor<36x36xi32> loc(#loc13)
    %4 = stablehlo.compare  GE, %2, %3,  SIGNED : (tensor<36x36xi32>, tensor<36x36xi32>) -> tensor<36x36xi1> loc(#loc14)
    %cst = stablehlo.constant dense<0.000000e+00> : tensor<f64> loc(#loc9)
    %5 = stablehlo.broadcast_in_dim %cst, dims = [] : (tensor<f64>) -> tensor<36x36xf64> loc(#loc15)
    %6 = stablehlo.select %4, %arg0, %5 : tensor<36x36xi1>, tensor<36x36xf64> loc(#loc16)
    return %6 : tensor<36x36xf64> loc(#loc9)
  } loc(#loc9)
} loc(#loc)
#loc = loc(unknown)
#loc1 = loc("/release/jax/tests/export_back_compat_test.py":255:0)
#loc2 = loc("/release/jax/tests/export_back_compat_test.py":257:0)
#loc4 = loc("jit(<lambda>)/jit(main)/iota[dtype=float64 shape=(1296,) dimension=0]"(#loc1))
#loc5 = loc("jit(<lambda>)/jit(main)/reshape[new_sizes=(36, 36) dimensions=None]"(#loc1))
#loc6 = loc("jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]"(#loc2))
#loc7 = loc("jit(<lambda>)/jit(main)/add"(#loc2))
#loc8 = loc("jit(<lambda>)/jit(main)/div"(#loc2))
#loc10 = loc("jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]"(#loc3))
#loc11 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=0]"(#loc3))
#loc12 = loc("jit(<lambda>)/jit(main)/jit(tril)/add"(#loc3))
#loc13 = loc("jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=1]"(#loc3))
#loc14 = loc("jit(<lambda>)/jit(main)/jit(tril)/ge"(#loc3))
#loc15 = loc("jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(36, 36) broadcast_dimensions=()]"(#loc3))
#loc16 = loc("jit(<lambda>)/jit(main)/jit(tril)/select_n"(#loc3))
""",
    mlir_module_serialized=b"ML\xefR\x01StableHLO_v0.9.0\x00\x01+\x05\x01\x03\x01\x03\x05\x03\x1b\x07\t\x0b\r\x0f\x11\x13\x15\x17\x19\x1b\x1d\x1f\x03n\x02\xeb9\x01\x97\x0f\x17\x13\x0f\x0b\x07\x0b\x0b\x0b\x17\x0f\x0b\x0b\x0b\x0b\x13\x0b\x13\x0f\x0b\x0b\x17\x0f\x13\x13+\x0b\x0f\x0b\x0b\x0b33\x0b\x0f\x0b\x0b\x13\x0f\x0b\x1b\x0f\x0b\x13\x0f\x0b\x0f\x0b\x0f\x0b\x0f\x0b\x13\x0b\x0f\x0b\x0f\x0b\x13\x0b\x13\x0b\x0bK\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x1b\x13\x13\x03U\x0b\x0b\x0b\x0b\x0f\x0b\x0bO/\x0b\x13\x1b\x0b\x1b\x0b\x0b\x0b\x13\x0b\x0b\x0f\x1f\x0f\x0f\x0b/O//\x0b\x0b\x0b\x0b\x0f\x0f\x17\x1b\x0f\x0b/O/\x01\x05\x0b\x0f\x035\x17\x0f\x07\x07\x0f\x07\x13\x17\x0f\x07\x07\x17\x13\x17\x17\x13\x17\x1b\x13\x13\x13\x0f\x17\x13\x13\x13\x02\xe2\x08\x1d}\x03\x17\x0f\x1e\x04\x01\x03\x03\x11\xc3\x1dC\x03\x05!\x1f\x05#\x05%\x05'\x17\x0f\x06\x04\x01\x11\x03\x05\x05)\x05+\x05-\x05/\x03\x03!\xbf\x051\x03\x03\t\xc1\x1dI\x03\x053\x055\x17\x0f\xfe\x03\x01\x1dw\x13\x03\x03\t\xcf\x03\x03\t\xe5\x03\t579\x15;\x15\r=\x057\x11\x01\x00\x059\x05;\x05=\x03\x0b\x17\x9b\x19\xa9\x1b\xab\r\xb5\x1d\xb7\x03\x0b\x17\x9f\x19\xbb\x1b\x9f\r\xa1\x1d\xbd\x05?\x1dG\x03\x05A\x05C\x03\x03!\xc5\x1dO\x03\x05E\x03\x05'\xa3)\xc7\x1dU\x03\x05G\x03\x03\t\xc9\x1d[\x03\x05I\x1d_\x03\x05K\x1dc+\x05M\x1dg+\x05O\x03\x03k\xcb\x05Q\x1do\x13\x05S\x1ds\x13\x05U\x03\x03\t\xcd\x05W\x03\x03{\xa1\x05Y\x05[\x03\x11\x81\xd1\x83\xd3\x85\xd5\x87\x9b\x89\xd7\x8b\xd9\x8d\xdb\x8f\xdf\x05]\x05_\x05a\x05c\x05e\x05g\x05i\x05k\x03\x05'\xa3)\xe3\x03\x03\x11\xe7\x03\x03\x11\xe9\x1dm\x1do\x03\x01\x1dq\x03\x03\xb9\x1ds\t\x07\x1f)!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f+\x11\x00\x00\x00\x00\x00\x00\x00\x00#\x1f\x03\x05\xad\xb1\r\x05\x9d\xaf\x97\x99\x1du\r\x05\x9d\xb3\x97\x99\x1dw\x1dy\x1d{\r\x03\x97\x99#!\x1d}\x13\t\x01\x1f\r\t\x00\x00\x00\x00\x1f#\x01\x13\t\x05\x07\x05\x1f\x07\x11\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x1d!\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x07\x11\x00\x00\x00\x00\x00\x00\x00@\x1f\x15\x11$\x00\x00\x00\x00\x00\x00\x00\x0b\x05\x1d\x7f\x1d\x81\x05\x01\x03\x03\xa5\x03\x03\xdd\x15\x03\x01\x01\x01\x03\t\xa5\xa7\xe1\xa7\x1f-\x01\x07\x01\x1f\x07\x11\x00\x00\x00\x00\x00\x00\xf8\x7f\x1f\x1d!\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x1f7\x11\x00\x00\x00\x00\x00\x00\x00\x00\x01\t\x01\x02\x02)\x05\x91\x91\x0b)\x01\x0b\x1d\x0b)\x01\x19\x01)\x03\x91\x0b)\x05\x91\x91\x19)\x01\t\x13\x1b)\x05\x91\x91\x0f)\x03\t\t\x11\x01\x05\x05\x11\x11\x03\x05\x03\x05)\x03\x01\t)\x03\x82(\x0b)\x03\x04\xc4\n\x0b)\x03\t\x17)\x03\x05\x17)\x03\x01\x17)\x01\x0f)\x05\x05\x05\x0f)\x03\x05\x0f)\x03\x91\x0f)\x03\x05\t\x04\x82\x04\x05\x01\x11\x0b3\x07\x03\x01\t\x0b\x11\x0b?\x07\x037e\x07\x03a\x1f\x03%\x13\x06e\x03\x05\x03\x01\x15\x07mi\x03\x05\x03\x03\r\x06q\x03\x05\x05\x03\x05\x05\x03\x0bu\x03\x07\x03\x07-\x05\x03\x05\x03\t\x17\x06-\x03\x05\x05\x07\x0b\x19\x07\x07y\x03\x05\x03\r\x05\x03\x01/\x03\x15\x05\x03\x01/\x03\x15\x1b\x07\x01\x7f\t\x05\x11\r'\x03\x0f\x05\x03\x01#\x03\r\x03\x07\x01\x05\x03\r\x03\x1d\x0f\x07\x01\x91\x03/\x05\x19\x1f\x03\x07\x01\x05\x031\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x05\x03%\x03\x07\x01\x93\x03\x1b\x03#\t\x06\x01\x03\x05\x07)\x15'\x03\x07\x01\x05\x033\x03!\x05\x03\x011\x03\x07\x03\x07\x01\x05\x03\x11\x03/\x03\x07\x01\x95\x035\x03-\t\x06\x01\x03\x11\x073\x171\x11\x04\x0b\x05+5\x0b\x11\x07A\x07\x03\x15+\x03\x05\x07\x07\x03E\x1f\x03\x13\x05\x03\x07#\x03\r\x03\x07%\x05\x03\x13\x03\x05\r\x06%\x03\x13\x05\x03\x07\x07\x03MK\x03\x13\x0f\x07SQ\x03\x1b\x05\t\x0b\x05\x03\x07W\x03\x07\x03\x07Y\x05\x03\x05\x03\x0f\t\x06]\x03\x05\x07\r\x01\x11\x11\x04\x07\x03\x13\x06\x03\x01\x05\x01\x00\x1e\x1a\x83!+\x11\x0f\x0b\t\t\x0b!\x11#\x1f/!!)#\x1f\x19\xa9\x0f99m\x19\x89\x8dW\xb7K\x9fM\x9fn\x03\x1b%)9+\x1b\x1f\x1f\x15\x1d\x15+]\x13\r\x1f\x11\x15\x1b\x17\x15\x17\x0f\x11\x15\x11\x19)\x0f\x0b\x11builtin\x00vhlo\x00module\x00broadcast_in_dim_v1\x00constant_v1\x00iota_v1\x00select_v1\x00func_v1\x00add_v1\x00compare_v1\x00return_v1\x00reshape_v1\x00transpose_v1\x00divide_v1\x00call_v1\x00custom_call_v1\x00value\x00sym_name\x00/release/jax/tests/export_back_compat_test.py\x00broadcast_dimensions\x00arg_attrs\x00function_type\x00res_attrs\x00sym_visibility\x00iota_dimension\x00compare_type\x00comparison_direction\x00jax.uses_shape_polymorphism\x00mhlo.num_partitions\x00mhlo.num_replicas\x00jit__lambda_\x00jit(<lambda>)/jit(main)/pjit[in_shardings=(UnspecifiedValue,) out_shardings=(UnspecifiedValue,) in_layouts=(None,) out_layouts=(None,) resource_env=None donated_invars=(False,) name=tril keep_unused=False inline=False]\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=0]\x00jit(<lambda>)/jit(main)/jit(tril)/add\x00jit(<lambda>)/jit(main)/jit(tril)/iota[dtype=int32 shape=(36, 36) dimension=1]\x00jit(<lambda>)/jit(main)/jit(tril)/ge\x00jit(<lambda>)/jit(main)/jit(tril)/broadcast_in_dim[shape=(36, 36) broadcast_dimensions=()]\x00jit(<lambda>)/jit(main)/jit(tril)/select_n\x00jit(<lambda>)/jit(main)/iota[dtype=float64 shape=(1296,) dimension=0]\x00jit(<lambda>)/jit(main)/reshape[new_sizes=(36, 36) dimensions=None]\x00permutation\x00jit(<lambda>)/jit(main)/transpose[permutation=(1, 0)]\x00jit(<lambda>)/jit(main)/add\x00jit(<lambda>)/jit(main)/div\x00callee\x00jit(<lambda>)/jit(main)/eigh[lower=True sort_eigenvalues=True subset_by_index=None]\x00api_version\x00backend_config\x00call_target_name\x00called_computations\x00has_side_effect\x00operand_layouts\x00output_operand_aliases\x00result_layouts\x00mhlo.layout_mode\x00default\x00jax.result_info\x00tril\x00[0]\x00[1]\x00main\x00public\x00private\x00\x01\x00\x00\x00z\x00\x00\x00\x01\x00\x00\x00$\x00\x00\x00@\xac\x00\x00\x00hipsolver_syevd\x00",
    xla_call_module_version=9,
    nr_devices=1,
)  # End paste
