export type RPCMessageBus = {
    postMessage: Function;
    addEventListener: Function;
    removeEventListener: Function;
};
export declare const close: unique symbol;
export declare const cancel: unique symbol;
export type Exposed<T> = {
    [k in keyof T]: T[k] & {
        close(): void;
    };
} & {
    [close]: () => void;
};
export declare function exposeAll<O extends object>(obj: O, messageBus: RPCMessageBus): Exposed<O>;
export type Caller<Impl, Keys extends keyof Impl = keyof Impl> = CancelableMethods<Pick<Impl, Keys>> & {
    [cancel]: () => void;
};
export declare function createCaller<Impl extends object>(methodNames: Extract<keyof Impl, string>[], messageBus: RPCMessageBus, processors?: Partial<Record<(typeof methodNames)[number], (...input: any[]) => any[]>>): Caller<Impl, (typeof methodNames)[number]>;
