import { ChatCompletionMessage } from '../inference';
/**
 * Native Route APIs
 * @description Enum of all the routes exposed by the app
 */
export declare enum NativeRoute {
    openExternalUrl = "openExternalUrl",
    openAppDirectory = "openAppDirectory",
    openFileExplore = "openFileExplorer",
    selectDirectory = "selectDirectory",
    selectFiles = "selectFiles",
    relaunch = "relaunch",
    setNativeThemeLight = "setNativeThemeLight",
    setNativeThemeDark = "setNativeThemeDark",
    setMinimizeApp = "setMinimizeApp",
    setCloseApp = "setCloseApp",
    setMaximizeApp = "setMaximizeApp",
    showOpenMenu = "showOpenMenu",
    hideQuickAskWindow = "hideQuickAskWindow",
    sendQuickAskInput = "sendQuickAskInput",
    hideMainWindow = "hideMainWindow",
    showMainWindow = "showMainWindow",
    quickAskSizeUpdated = "quickAskSizeUpdated",
    ackDeepLink = "ackDeepLink",
    factoryReset = "factoryReset",
    startServer = "startServer",
    stopServer = "stopServer",
    appUpdateDownload = "appUpdateDownload",
    appToken = "appToken"
}
/**
 * App Route APIs
 * @description Enum of all the routes exposed by the app
 */
export declare enum AppRoute {
    getAppConfigurations = "getAppConfigurations",
    updateAppConfiguration = "updateAppConfiguration",
    joinPath = "joinPath",
    dirName = "dirName",
    isSubdirectory = "isSubdirectory",
    baseName = "baseName",
    log = "log",
    showToast = "showToast"
}
export declare enum AppEvent {
    onAppUpdateNotAvailable = "onAppUpdateNotAvailable",
    onAppUpdateAvailable = "onAppUpdateAvailable",
    onAppUpdateDownloadUpdate = "onAppUpdateDownloadUpdate",
    onAppUpdateDownloadError = "onAppUpdateDownloadError",
    onAppUpdateDownloadSuccess = "onAppUpdateDownloadSuccess",
    onModelImported = "onModelImported",
    onUserSubmitQuickAsk = "onUserSubmitQuickAsk",
    onSelectedText = "onSelectedText",
    onDeepLink = "onDeepLink",
    onMainViewStateChange = "onMainViewStateChange"
}
export declare enum DownloadEvent {
    onFileDownloadUpdate = "onFileDownloadUpdate",
    onFileDownloadError = "onFileDownloadError",
    onFileDownloadSuccess = "onFileDownloadSuccess",
    onFileDownloadStopped = "onFileDownloadStopped",
    onFileDownloadStarted = "onFileDownloadStarted",
    onModelValidationStarted = "onModelValidationStarted",
    onModelValidationFailed = "onModelValidationFailed",
    onFileDownloadAndVerificationSuccess = "onFileDownloadAndVerificationSuccess"
}
export declare enum ExtensionRoute {
    baseExtensions = "baseExtensions",
    getActiveExtensions = "getActiveExtensions",
    installExtension = "installExtension",
    invokeExtensionFunc = "invokeExtensionFunc",
    updateExtension = "updateExtension",
    uninstallExtension = "uninstallExtension"
}
export declare enum FileSystemRoute {
    appendFileSync = "appendFileSync",
    unlinkSync = "unlinkSync",
    existsSync = "existsSync",
    readdirSync = "readdirSync",
    rm = "rm",
    mv = "mv",
    mkdir = "mkdir",
    readFileSync = "readFileSync",
    writeFileSync = "writeFileSync"
}
export declare enum FileManagerRoute {
    copyFile = "copyFile",
    getJanDataFolderPath = "getJanDataFolderPath",
    getResourcePath = "getResourcePath",
    getUserHomePath = "getUserHomePath",
    fileStat = "fileStat",
    writeBlob = "writeBlob",
    getGgufFiles = "getGgufFiles"
}
export type ApiFunction = (...args: any[]) => any;
export type NativeRouteFunctions = {
    [K in NativeRoute]: ApiFunction;
};
export type AppRouteFunctions = {
    [K in AppRoute]: ApiFunction;
};
export type AppEventFunctions = {
    [K in AppEvent]: ApiFunction;
};
export type DownloadEventFunctions = {
    [K in DownloadEvent]: ApiFunction;
};
export type ExtensionRouteFunctions = {
    [K in ExtensionRoute]: ApiFunction;
};
export type FileSystemRouteFunctions = {
    [K in FileSystemRoute]: ApiFunction;
};
export type FileManagerRouteFunctions = {
    [K in FileManagerRoute]: ApiFunction;
};
export type APIFunctions = NativeRouteFunctions & AppRouteFunctions & AppEventFunctions & DownloadEventFunctions & ExtensionRouteFunctions & FileSystemRouteFunctions & FileManagerRoute;
export declare const CoreRoutes: (AppRoute | ExtensionRoute | FileSystemRoute | FileManagerRoute)[];
export declare const APIRoutes: (NativeRoute | AppRoute | ExtensionRoute | FileSystemRoute | FileManagerRoute)[];
export declare const APIEvents: (AppEvent | DownloadEvent)[];
export type PayloadType = {
    messages: ChatCompletionMessage[];
    model: string;
    stream: boolean;
};
