import { ModelParams, ModelRuntimeParams, ModelSettingParams } from '../../types';
/**
 * Validation rules for model parameters
 */
export declare const validationRules: {
    [key: string]: (value: any) => boolean;
};
/**
 * There are some parameters that need to be normalized before being sent to the server
 * E.g. ctx_len should be an integer, but it can be a float from the input field
 * @param key
 * @param value
 * @returns
 */
export declare const normalizeValue: (key: string, value: any) => any;
/**
 * Extract inference parameters from flat model parameters
 * @param modelParams
 * @returns
 */
export declare const extractInferenceParams: (modelParams?: ModelParams, originParams?: ModelParams) => ModelRuntimeParams;
/**
 * Extract model load parameters from flat model parameters
 * @param modelParams
 * @returns
 */
export declare const extractModelLoadParams: (modelParams?: ModelParams, originParams?: ModelParams) => ModelSettingParams;
