import { Model } from '../../types';
/**
 * Manages the registered models across extensions.
 */
export declare class ModelManager {
    models: Map<string, Model>;
    constructor();
    /**
     * Registers a model.
     * @param model - The model to register.
     */
    register<T extends Model>(model: T): void;
    /**
     * Retrieves a model by it's id.
     * @param id - The id of the model to retrieve.
     * @returns The model, if found.
     */
    get<T extends Model>(id: string): T | undefined;
    /**
     * Shared instance of ExtensionManager.
     */
    static instance(): ModelManager;
}
