import { ModelEvent } from '../../types';
import { events } from '../events';
/**
 * Manages the registered models across extensions.
 */
export class ModelManager {
    constructor() {
        this.models = new Map();
        if (window) {
            window.core.modelManager = this;
        }
    }
    /**
     * Registers a model.
     * @param model - The model to register.
     */
    register(model) {
        if (this.models.has(model.id)) {
            this.models.set(model.id, Object.assign(Object.assign({}, model), this.models.get(model.id)));
        }
        else {
            this.models.set(model.id, model);
        }
        events.emit(ModelEvent.OnModelsUpdate, {});
    }
    /**
     * Retrieves a model by it's id.
     * @param id - The id of the model to retrieve.
     * @returns The model, if found.
     */
    get(id) {
        return this.models.get(id);
    }
    /**
     * Shared instance of ExtensionManager.
     */
    static instance() {
        if (!window.core.modelManager)
            window.core.modelManager = new ModelManager();
        return window.core.modelManager;
    }
}
//# sourceMappingURL=manager.js.map