import { __awaiter } from "tslib";
import { OAIEngine } from './OAIEngine';
/**
 * Base OAI Remote Inference Provider
 * Added the implementation of loading and unloading model (applicable to local inference providers)
 */
export class RemoteOAIEngine extends OAIEngine {
    /**
     * On extension load, subscribe to events.
     */
    onLoad() {
        super.onLoad();
    }
    /**
     * Headers for the inference request
     */
    headers() {
        return __awaiter(this, void 0, void 0, function* () {
            return Object.assign({}, (this.apiKey && {
                'Authorization': `Bearer ${this.apiKey}`,
                'api-key': `${this.apiKey}`,
            }));
        });
    }
}
//# sourceMappingURL=RemoteOAIEngine.js.map