/**
 * Manages the registration and retrieval of inference engines.
 */
export class EngineManager {
    constructor() {
        this.engines = new Map();
        this.controller = null;
    }
    /**
     * Registers an engine.
     * @param engine - The engine to register.
     */
    register(engine) {
        this.engines.set(engine.provider, engine);
    }
    /**
     * Retrieves a engine by provider.
     * @param provider - The name of the engine to retrieve.
     * @returns The engine, if found.
     */
    get(provider) {
        return this.engines.get(provider);
    }
    /**
     * The instance of the engine manager.
     */
    static instance() {
        var _a, _b;
        return (_b = (_a = window.core) === null || _a === void 0 ? void 0 : _a.engineManager) !== null && _b !== void 0 ? _b : new EngineManager();
    }
}
//# sourceMappingURL=EngineManager.js.map