import { BaseExtension } from '../../extension';
import { EngineManager } from './EngineManager';
/**
 * Base AIEngine
 * Applicable to all AI Engines
 */
export class AIEngine extends BaseExtension {
    /**
     * On extension load, subscribe to events.
     */
    onLoad() {
        this.registerEngine();
    }
    /**
     * Registers AI Engines
     */
    registerEngine() {
        EngineManager.instance().register(this);
    }
}
//# sourceMappingURL=AIEngine.js.map