/**
 * Gets Jan's data folder path.
 *
 * @returns {Promise<string>} A Promise that resolves with Jan's data folder path.
 */
const getJanDataFolderPath = () => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.getJanDataFolderPath(); };
/**
 * Opens the file explorer at a specific path.
 * @param {string} path - The path to open in the file explorer.
 * @returns {Promise<any>} A promise that resolves when the file explorer is opened.
 */
const openFileExplorer = (path) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.openFileExplorer({ path }); };
/**
 * Joins multiple paths together.
 * @param paths - The paths to join.
 * @returns {Promise<string>} A promise that resolves with the joined path.
 */
const joinPath = (args) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.joinPath({ args }); };
/**
 * Get dirname of a file path.
 * @param path - The file path to retrieve dirname.
 * @returns {Promise<string>} A promise that resolves the dirname.
 */
const dirName = (path) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.dirName(path); };
/**
 * Retrieve the basename from an url.
 * @param path - The path to retrieve.
 * @returns {Promise<string>} A promise that resolves with the basename.
 */
const baseName = (path) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.baseName(path); };
/**
 * Opens an external URL in the default web browser.
 *
 * @param {string} url - The URL to open.
 * @returns {Promise<any>} - A promise that resolves when the URL has been successfully opened.
 */
const openExternalUrl = (url) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.openExternalUrl(url); };
/**
 * Gets the resource path of the application.
 *
 * @returns {Promise<string>} - A promise that resolves with the resource path.
 */
const getResourcePath = () => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.getResourcePath(); };
/**
 * Gets the user's home path.
 * @returns return user's home path
 */
const getUserHomePath = () => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.getUserHomePath(); };
/**
 * Log to file from browser processes.
 *
 * @param message - Message to log.
 */
const log = (message, fileName) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.log(message, fileName); };
/**
 * Check whether the path is a subdirectory of another path.
 *
 * @param from - The path to check.
 * @param to - The path to check against.
 *
 * @returns {Promise<boolean>} - A promise that resolves with a boolean indicating whether the path is a subdirectory.
 */
const isSubdirectory = (from, to) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.isSubdirectory(from, to); };
/**
 * Show toast message from browser processes.
 * @param title
 * @param message
 * @returns
 */
const showToast = (title, message) => { var _a; return (_a = globalThis.core.api) === null || _a === void 0 ? void 0 : _a.showToast(title, message); };
/**
 * Functions exports
 */
export { getJanDataFolderPath, openFileExplorer, getResourcePath, joinPath, openExternalUrl, baseName, log, isSubdirectory, getUserHomePath, showToast, dirName, };
//# sourceMappingURL=core.js.map