# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_goxlr_client_global_optspecs
	string join \n device= status status-json status-http use-http= dynamic-gain= condenser-gain= jack-gain= h/help V/version
end

function __fish_goxlr_client_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_goxlr_client_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_goxlr_client_using_subcommand
	set -l cmd (__fish_goxlr_client_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l device -d 'The specific device\'s serial number to execute commands on. This field is optional if you have exactly one GoXLR, but required if you have more' -r
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l use-http -d 'Use HTTP Instead of IPC. Specify base path as the param (defaults to http://localhost:14564)' -r
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l dynamic-gain -d 'Set the gain of the plugged in dynamic (XLR) microphone. Value is in decibels and recommended to be lower than 72dB' -r
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l condenser-gain -d 'Set the gain of the plugged in condenser (XLR with phantom power) microphone. Value is in decibels and recommended to be lower than 72dB' -r
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l jack-gain -d 'Set the gain of the plugged in jack (3.5mm) microphone. Value is in decibels and recommended to be lower than 72dB' -r
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l status -d 'Display the device information after any subcommands have been executed'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l status-json -d 'Display device information as JSON after command..'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -l status-http
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -s V -l version -d 'Print version'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "firmware"
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "profiles" -d 'Profile Settings'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "microphone" -d 'Adjust the microphone settings (Eq, Gate and Compressor)'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "volume" -d 'Adjust Channel Volumes'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "submix" -d 'Adjust Submix Settings'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "bleep-volume" -d 'Configure the Bleep Button'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "faders" -d 'Commands to manipulate the individual GoXLR Faders'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "cough-button" -d 'Commands for configuring the cough button'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "router" -d 'Commands to manipulate the GoXLR Router'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "lighting" -d 'Commands to control the GoXLR lighting'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "effects" -d 'Commands to Control the Effects Panel'
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "sampler"
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "settings"
complete -c goxlr-client -n "__fish_goxlr_client_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and not __fish_seen_subcommand_from firmware-update continue-firmware-update clear-firmware-update help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and not __fish_seen_subcommand_from firmware-update continue-firmware-update clear-firmware-update help" -f -a "firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and not __fish_seen_subcommand_from firmware-update continue-firmware-update clear-firmware-update help" -f -a "continue-firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and not __fish_seen_subcommand_from firmware-update continue-firmware-update clear-firmware-update help" -f -a "clear-firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and not __fish_seen_subcommand_from firmware-update continue-firmware-update clear-firmware-update help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and __fish_seen_subcommand_from firmware-update" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and __fish_seen_subcommand_from continue-firmware-update" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and __fish_seen_subcommand_from clear-firmware-update" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and __fish_seen_subcommand_from help" -f -a "firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and __fish_seen_subcommand_from help" -f -a "continue-firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and __fish_seen_subcommand_from help" -f -a "clear-firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand firmware; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and not __fish_seen_subcommand_from device microphone help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and not __fish_seen_subcommand_from device microphone help" -f -a "device" -d 'General Device Profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and not __fish_seen_subcommand_from device microphone help" -f -a "microphone" -d 'Microphone Profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and not __fish_seen_subcommand_from device microphone help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from device" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from device" -f -a "new" -d 'Create a new profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from device" -f -a "load" -d 'Load a profile by name'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from device" -f -a "load-colours" -d 'Load a Profiles Colours Only'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from device" -f -a "save" -d 'Save the currently running profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from device" -f -a "save-as" -d 'Save the currently running profile with a new name'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from device" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from microphone" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from microphone" -f -a "new" -d 'Create a new profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from microphone" -f -a "load" -d 'Load a profile by name'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from microphone" -f -a "load-colours" -d 'Load a Profiles Colours Only'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from microphone" -f -a "save" -d 'Save the currently running profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from microphone" -f -a "save-as" -d 'Save the currently running profile with a new name'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from microphone" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from help" -f -a "device" -d 'General Device Profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from help" -f -a "microphone" -d 'Microphone Profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand profiles; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -f -a "equaliser" -d 'Configure the Equaliser for the Full GoXLR Device'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -f -a "equaliser-mini" -d 'Configure the Equaliser for the GoXLR Mini'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -f -a "noise-gate" -d 'Configure the microphone noise gate'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -f -a "compressor" -d 'Configure the Microphone Compressor'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -f -a "de-ess" -d 'Set the DeEss percentage'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -f -a "monitor-mic-with-fx" -d 'Enable Microphone Monitor whenever FX are enabled'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and not __fish_seen_subcommand_from equaliser equaliser-mini noise-gate compressor de-ess monitor-mic-with-fx help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser" -f -a "frequency" -d 'Fine tune the Equaliser Frequencies'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser" -f -a "gain"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser-mini" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser-mini" -f -a "frequency" -d 'Fine tune the Equaliser Frequencies'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser-mini" -f -a "gain" -d 'Set the Gain Value for frequencies'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from equaliser-mini" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from noise-gate" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from noise-gate" -f -a "threshold" -d 'Activation Threshold in dB [-59 - 0]'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from noise-gate" -f -a "attenuation" -d 'Attenuation Percentage [0 - 100]'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from noise-gate" -f -a "attack" -d 'Attack Time'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from noise-gate" -f -a "release" -d 'Release Time'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from noise-gate" -f -a "active" -d 'Is Gate Active?'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from noise-gate" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from compressor" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from compressor" -f -a "threshold" -d 'Activation Threshold in dB [-24 - 0]'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from compressor" -f -a "ratio"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from compressor" -f -a "attack"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from compressor" -f -a "release"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from compressor" -f -a "make-up"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from compressor" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from de-ess" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from monitor-mic-with-fx" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from help" -f -a "equaliser" -d 'Configure the Equaliser for the Full GoXLR Device'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from help" -f -a "equaliser-mini" -d 'Configure the Equaliser for the GoXLR Mini'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from help" -f -a "noise-gate" -d 'Configure the microphone noise gate'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from help" -f -a "compressor" -d 'Configure the Microphone Compressor'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from help" -f -a "de-ess" -d 'Set the DeEss percentage'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from help" -f -a "monitor-mic-with-fx" -d 'Enable Microphone Monitor whenever FX are enabled'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand microphone; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand volume" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and not __fish_seen_subcommand_from enabled volume linked output-mix monitor-mix help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and not __fish_seen_subcommand_from enabled volume linked output-mix monitor-mix help" -f -a "enabled" -d 'Enable / Disable SubMixes'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and not __fish_seen_subcommand_from enabled volume linked output-mix monitor-mix help" -f -a "volume" -d 'Change Submix Volumes'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and not __fish_seen_subcommand_from enabled volume linked output-mix monitor-mix help" -f -a "linked" -d 'Link / Unlink a volume -> submix volume'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and not __fish_seen_subcommand_from enabled volume linked output-mix monitor-mix help" -f -a "output-mix" -d 'Set the output mix for a channel'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and not __fish_seen_subcommand_from enabled volume linked output-mix monitor-mix help" -f -a "monitor-mix" -d 'Activate Mix Monitoring'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and not __fish_seen_subcommand_from enabled volume linked output-mix monitor-mix help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from enabled" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from volume" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from linked" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from output-mix" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from monitor-mix" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from help" -f -a "enabled" -d 'Enable / Disable SubMixes'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from help" -f -a "volume" -d 'Change Submix Volumes'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from help" -f -a "linked" -d 'Link / Unlink a volume -> submix volume'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from help" -f -a "output-mix" -d 'Set the output mix for a channel'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from help" -f -a "monitor-mix" -d 'Activate Mix Monitoring'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand submix; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand bleep-volume" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and not __fish_seen_subcommand_from channel mute-behaviour mute-state scribbles help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and not __fish_seen_subcommand_from channel mute-behaviour mute-state scribbles help" -f -a "channel" -d 'Assign a new Channel to a Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and not __fish_seen_subcommand_from channel mute-behaviour mute-state scribbles help" -f -a "mute-behaviour" -d 'Change the behaviour of a Fader Mute Button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and not __fish_seen_subcommand_from channel mute-behaviour mute-state scribbles help" -f -a "mute-state" -d 'Sets the Current Mute State of the Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and not __fish_seen_subcommand_from channel mute-behaviour mute-state scribbles help" -f -a "scribbles" -d 'Configure the Scribble Screen on a Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and not __fish_seen_subcommand_from channel mute-behaviour mute-state scribbles help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from channel" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from mute-behaviour" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from mute-state" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from scribbles" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from scribbles" -f -a "icon" -d 'Change a Scribble Icon'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from scribbles" -f -a "text" -d 'Change the Text on a Scribble'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from scribbles" -f -a "number" -d 'Change the Number field (Top Left)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from scribbles" -f -a "invert" -d 'Inverts a scribble display'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from scribbles" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from help" -f -a "channel" -d 'Assign a new Channel to a Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from help" -f -a "mute-behaviour" -d 'Change the behaviour of a Fader Mute Button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from help" -f -a "mute-state" -d 'Sets the Current Mute State of the Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from help" -f -a "scribbles" -d 'Configure the Scribble Screen on a Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand faders; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and not __fish_seen_subcommand_from button-is-hold mute-behaviour mute-state help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and not __fish_seen_subcommand_from button-is-hold mute-behaviour mute-state help" -f -a "button-is-hold" -d 'Sets whether the button is only active when held (so not toggled)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and not __fish_seen_subcommand_from button-is-hold mute-behaviour mute-state help" -f -a "mute-behaviour" -d 'Change the Mute Target on Press'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and not __fish_seen_subcommand_from button-is-hold mute-behaviour mute-state help" -f -a "mute-state" -d 'Change the current button Mute State'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and not __fish_seen_subcommand_from button-is-hold mute-behaviour mute-state help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and __fish_seen_subcommand_from button-is-hold" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and __fish_seen_subcommand_from mute-behaviour" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and __fish_seen_subcommand_from mute-state" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and __fish_seen_subcommand_from help" -f -a "button-is-hold" -d 'Sets whether the button is only active when held (so not toggled)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and __fish_seen_subcommand_from help" -f -a "mute-behaviour" -d 'Change the Mute Target on Press'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and __fish_seen_subcommand_from help" -f -a "mute-state" -d 'Change the current button Mute State'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand cough-button; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand router" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "animation" -d 'Change Global Animation States'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "global" -d 'Sets the Global GoXLR Colour'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "fader" -d 'Configure Lighting for a specific fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "faders-all" -d 'Configure lighting for all faders at once'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "button" -d 'Configure lighting for a specific button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "button-group" -d 'Configure lighting for a group of common bottoms'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "simple-colour" -d 'Change a \'Simple\' (one colour) target'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "encoder-colour" -d 'Change an Encoder Colour'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and not __fish_seen_subcommand_from animation global fader faders-all button button-group simple-colour encoder-colour help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from animation" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from animation" -f -a "mode" -d 'Change the Animation Mod'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from animation" -f -a "mod1" -d 'Change the Mod1 Value'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from animation" -f -a "mod2" -d 'Change the Mod2 Value'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from animation" -f -a "water-fall" -d 'Change the Waterfall Direction'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from animation" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from global" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from fader" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from fader" -f -a "display" -d 'Change the Faders Lighting Mode'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from fader" -f -a "colour" -d 'Sets the Top and Bottom colours of a fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from fader" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from faders-all" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from faders-all" -f -a "display" -d 'Change the Faders Lighting Mode'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from faders-all" -f -a "colour" -d 'Sets the Top and Bottom colours of a fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from faders-all" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button" -f -a "colour" -d 'Change a Buttons Colours'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button" -f -a "off-style" -d 'Set a Button\'s "Off" style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button-group" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button-group" -f -a "colour" -d 'Change a Buttons Groups Colours'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button-group" -f -a "off-style" -d 'Change a Button Group\'s "Off" style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from button-group" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from simple-colour" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from encoder-colour" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "animation" -d 'Change Global Animation States'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "global" -d 'Sets the Global GoXLR Colour'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "fader" -d 'Configure Lighting for a specific fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "faders-all" -d 'Configure lighting for all faders at once'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "button" -d 'Configure lighting for a specific button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "button-group" -d 'Configure lighting for a group of common bottoms'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "simple-colour" -d 'Change a \'Simple\' (one colour) target'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "encoder-colour" -d 'Change an Encoder Colour'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand lighting; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "load-effect-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "rename-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "save-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "set-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "reverb"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "echo"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "pitch"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "gender"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "megaphone"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "robot"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "hard-tune"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "enabled" -d 'Sets the current state of the FX'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and not __fish_seen_subcommand_from load-effect-preset rename-active-preset save-active-preset set-active-preset reverb echo pitch gender megaphone robot hard-tune enabled help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from load-effect-preset" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from rename-active-preset" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from save-active-preset" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from set-active-preset" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "style" -d 'Set the Reverb Style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "amount" -d 'Set the Reverb Amount'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "decay" -d 'Set the Reverb Decay'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "early-level" -d 'Set the Reverb Early Level'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "tail-level" -d 'Set the Reverb Tail Level'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "pre-delay" -d 'Set the Reverb Pre-Delay'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "low-colour" -d 'Set the Reverb Low \'Colour\''
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "high-colour" -d 'Set the Reverb High \'Colour\''
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "high-factor" -d 'Set the Reverb High Factor'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "diffuse" -d 'Set the Reverb Diffuse Level'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "mod-speed" -d 'Set the Reverb Mod Speed'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "mod-depth" -d 'Set the Reverb Mod Depth'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from reverb" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "style" -d 'Set the Echo Style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "amount" -d 'Set the Echo Amount (Percentage)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "feedback" -d 'Set the Echo Feedback Level'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "tempo" -d 'Set the Echo Tempo (only valid if \'Style\' is \'ClassicSlap\')'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "delay-left" -d 'Set the Reverb Left Delay (only valid if \'Style\' is not \'ClassicSlap\')'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "delay-right" -d 'Set the Reverb Right Delay (only valid if \'Style\' is not \'ClassicSlap\')'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "feedback-xfb-lto-r" -d 'Set the Echo XFB from Left to Right'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "feedback-xfb-rto-l" -d 'Set the Echo XFB from Right to Left'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from echo" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from pitch" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from pitch" -f -a "style" -d 'Set the Pitch Style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from pitch" -f -a "amount" -d 'Set the pitch Amount'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from pitch" -f -a "character" -d 'Set the Pitch Character'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from pitch" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from gender" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from gender" -f -a "style"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from gender" -f -a "amount"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from gender" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from megaphone" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from megaphone" -f -a "style" -d 'Set the Megaphone Style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from megaphone" -f -a "amount" -d 'Set the Megaphone Amount'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from megaphone" -f -a "post-gain" -d 'Set the Post Processing Gain'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from megaphone" -f -a "enabled" -d 'Sets the State of the Megaphone Button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from megaphone" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "style" -d 'Set the Robot Style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "gain" -d 'Sets the Robot Gain'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "frequency" -d 'Sets the Robot Frequency'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "bandwidth" -d 'Sets the Robot Bandwidth'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "wave-form" -d 'Sets the Robot Waveform'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "pulse-width" -d 'Sets the Robot Pulse Width'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "threshold" -d 'Sets the Robot Activation Threshold'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "dry-mix" -d 'Sets the Robot Dry Mix'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "enabled" -d 'Sets the Current state of the Robot Button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from robot" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -f -a "style" -d 'Sets the Hard Tune Style'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -f -a "amount" -d 'Sets the Hard Tune Amount'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -f -a "rate" -d 'Sets the Hard Tune Rate'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -f -a "window" -d 'Sets the Hard Tune Window'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -f -a "source" -d 'Sets the Hard Tune Source'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -f -a "enabled" -d 'Sets the current state of the HardTune Button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from hard-tune" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from enabled" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "load-effect-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "rename-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "save-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "set-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "reverb"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "echo"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "pitch"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "gender"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "megaphone"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "robot"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "hard-tune"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "enabled" -d 'Sets the current state of the FX'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand effects; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "add"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "remove-by-index"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "play-by-index"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "play-next-track"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "stop-playback"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "playback-mode"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "playback-order"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "start-percent"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "stop-percent"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and not __fish_seen_subcommand_from add remove-by-index play-by-index play-next-track stop-playback playback-mode playback-order start-percent stop-percent help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from remove-by-index" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from play-by-index" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from play-next-track" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from stop-playback" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from playback-mode" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from playback-order" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from start-percent" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from stop-percent" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "add"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "remove-by-index"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "play-by-index"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "play-next-track"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "stop-playback"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "playback-mode"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "playback-order"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "start-percent"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "stop-percent"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand sampler; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and not __fish_seen_subcommand_from mute-hold-duration sample-pre-record-buffer monitor-with-fx deafen-on-chat-mute lock-faders help" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and not __fish_seen_subcommand_from mute-hold-duration sample-pre-record-buffer monitor-with-fx deafen-on-chat-mute lock-faders help" -f -a "mute-hold-duration" -d 'How long to Hold a Mute button before it Mutes to All'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and not __fish_seen_subcommand_from mute-hold-duration sample-pre-record-buffer monitor-with-fx deafen-on-chat-mute lock-faders help" -f -a "sample-pre-record-buffer" -d 'How far in the past the sampler should listen for audio'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and not __fish_seen_subcommand_from mute-hold-duration sample-pre-record-buffer monitor-with-fx deafen-on-chat-mute lock-faders help" -f -a "monitor-with-fx" -d 'Enable Mic Monitoring when FX are enabled'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and not __fish_seen_subcommand_from mute-hold-duration sample-pre-record-buffer monitor-with-fx deafen-on-chat-mute lock-faders help" -f -a "deafen-on-chat-mute" -d 'Whether to mute The Microphone when Voice Chat is Muted'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and not __fish_seen_subcommand_from mute-hold-duration sample-pre-record-buffer monitor-with-fx deafen-on-chat-mute lock-faders help" -f -a "lock-faders" -d 'Locks the Faders to their current value on MuteToAll'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and not __fish_seen_subcommand_from mute-hold-duration sample-pre-record-buffer monitor-with-fx deafen-on-chat-mute lock-faders help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from mute-hold-duration" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from sample-pre-record-buffer" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from monitor-with-fx" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from deafen-on-chat-mute" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from lock-faders" -s h -l help -d 'Print help'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from help" -f -a "mute-hold-duration" -d 'How long to Hold a Mute button before it Mutes to All'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from help" -f -a "sample-pre-record-buffer" -d 'How far in the past the sampler should listen for audio'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from help" -f -a "monitor-with-fx" -d 'Enable Mic Monitoring when FX are enabled'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from help" -f -a "deafen-on-chat-mute" -d 'Whether to mute The Microphone when Voice Chat is Muted'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from help" -f -a "lock-faders" -d 'Locks the Faders to their current value on MuteToAll'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand settings; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "firmware"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "profiles" -d 'Profile Settings'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "microphone" -d 'Adjust the microphone settings (Eq, Gate and Compressor)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "volume" -d 'Adjust Channel Volumes'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "submix" -d 'Adjust Submix Settings'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "bleep-volume" -d 'Configure the Bleep Button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "faders" -d 'Commands to manipulate the individual GoXLR Faders'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "cough-button" -d 'Commands for configuring the cough button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "router" -d 'Commands to manipulate the GoXLR Router'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "lighting" -d 'Commands to control the GoXLR lighting'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "effects" -d 'Commands to Control the Effects Panel'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "sampler"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "settings"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and not __fish_seen_subcommand_from firmware profiles microphone volume submix bleep-volume faders cough-button router lighting effects sampler settings help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from firmware" -f -a "firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from firmware" -f -a "continue-firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from firmware" -f -a "clear-firmware-update"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from profiles" -f -a "device" -d 'General Device Profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from profiles" -f -a "microphone" -d 'Microphone Profile'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from microphone" -f -a "equaliser" -d 'Configure the Equaliser for the Full GoXLR Device'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from microphone" -f -a "equaliser-mini" -d 'Configure the Equaliser for the GoXLR Mini'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from microphone" -f -a "noise-gate" -d 'Configure the microphone noise gate'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from microphone" -f -a "compressor" -d 'Configure the Microphone Compressor'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from microphone" -f -a "de-ess" -d 'Set the DeEss percentage'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from microphone" -f -a "monitor-mic-with-fx" -d 'Enable Microphone Monitor whenever FX are enabled'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from submix" -f -a "enabled" -d 'Enable / Disable SubMixes'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from submix" -f -a "volume" -d 'Change Submix Volumes'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from submix" -f -a "linked" -d 'Link / Unlink a volume -> submix volume'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from submix" -f -a "output-mix" -d 'Set the output mix for a channel'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from submix" -f -a "monitor-mix" -d 'Activate Mix Monitoring'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from faders" -f -a "channel" -d 'Assign a new Channel to a Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from faders" -f -a "mute-behaviour" -d 'Change the behaviour of a Fader Mute Button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from faders" -f -a "mute-state" -d 'Sets the Current Mute State of the Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from faders" -f -a "scribbles" -d 'Configure the Scribble Screen on a Fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from cough-button" -f -a "button-is-hold" -d 'Sets whether the button is only active when held (so not toggled)'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from cough-button" -f -a "mute-behaviour" -d 'Change the Mute Target on Press'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from cough-button" -f -a "mute-state" -d 'Change the current button Mute State'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "animation" -d 'Change Global Animation States'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "global" -d 'Sets the Global GoXLR Colour'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "fader" -d 'Configure Lighting for a specific fader'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "faders-all" -d 'Configure lighting for all faders at once'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "button" -d 'Configure lighting for a specific button'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "button-group" -d 'Configure lighting for a group of common bottoms'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "simple-colour" -d 'Change a \'Simple\' (one colour) target'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from lighting" -f -a "encoder-colour" -d 'Change an Encoder Colour'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "load-effect-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "rename-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "save-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "set-active-preset"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "reverb"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "echo"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "pitch"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "gender"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "megaphone"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "robot"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "hard-tune"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from effects" -f -a "enabled" -d 'Sets the current state of the FX'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "add"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "remove-by-index"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "play-by-index"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "play-next-track"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "stop-playback"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "playback-mode"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "playback-order"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "start-percent"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from sampler" -f -a "stop-percent"
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from settings" -f -a "mute-hold-duration" -d 'How long to Hold a Mute button before it Mutes to All'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from settings" -f -a "sample-pre-record-buffer" -d 'How far in the past the sampler should listen for audio'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from settings" -f -a "monitor-with-fx" -d 'Enable Mic Monitoring when FX are enabled'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from settings" -f -a "deafen-on-chat-mute" -d 'Whether to mute The Microphone when Voice Chat is Muted'
complete -c goxlr-client -n "__fish_goxlr_client_using_subcommand help; and __fish_seen_subcommand_from settings" -f -a "lock-faders" -d 'Locks the Faders to their current value on MuteToAll'
