var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// node_modules/@girs/gnome-shell/dist/extensions/extension.js
var extension_exports = {};
__reExport(extension_exports, extension_star);
import * as extension_star from "resource:///org/gnome/shell/extensions/extension.js";

// src/modules/helpers.ts
import * as Main from "resource:///org/gnome/shell/ui/main.js";
function addQuickSettingsItems(items, width = 1) {
  const QuickSettingsMenu = Main.panel.statusArea.quickSettings;
  items.forEach((item) => QuickSettingsMenu.menu.addItem(item, width));
  for (const item of items) {
    QuickSettingsMenu.menu._grid.set_child_below_sibling(
      item,
      QuickSettingsMenu._backgroundApps.quickSettingsItems[0]
    );
  }
}

// node_modules/@girs/gnome-shell/dist/ui/accessDialog.js
var accessDialog_exports = {};
__reExport(accessDialog_exports, accessDialog_star);
import * as accessDialog_star from "resource:///org/gnome/shell/ui/accessDialog.js";

// node_modules/@girs/gnome-shell/dist/ui/altTab.js
var altTab_exports = {};
__reExport(altTab_exports, altTab_star);
import * as altTab_star from "resource:///org/gnome/shell/ui/altTab.js";

// node_modules/@girs/gnome-shell/dist/ui/animation.js
var animation_exports = {};
__reExport(animation_exports, animation_star);
import * as animation_star from "resource:///org/gnome/shell/ui/animation.js";

// node_modules/@girs/gnome-shell/dist/ui/appDisplay.js
var appDisplay_exports = {};
__reExport(appDisplay_exports, appDisplay_star);
import * as appDisplay_star from "resource:///org/gnome/shell/ui/appDisplay.js";

// node_modules/@girs/gnome-shell/dist/ui/appFavorites.js
var appFavorites_exports = {};
__reExport(appFavorites_exports, appFavorites_star);
import * as appFavorites_star from "resource:///org/gnome/shell/ui/appFavorites.js";

// node_modules/@girs/gnome-shell/dist/ui/appMenu.js
var appMenu_exports = {};
__reExport(appMenu_exports, appMenu_star);
import * as appMenu_star from "resource:///org/gnome/shell/ui/appMenu.js";

// node_modules/@girs/gnome-shell/dist/ui/audioDeviceSelection.js
var audioDeviceSelection_exports = {};
__reExport(audioDeviceSelection_exports, audioDeviceSelection_star);
import * as audioDeviceSelection_star from "resource:///org/gnome/shell/ui/audioDeviceSelection.js";

// node_modules/@girs/gnome-shell/dist/ui/background.js
var background_exports = {};
__reExport(background_exports, background_star);
import * as background_star from "resource:///org/gnome/shell/ui/background.js";

// node_modules/@girs/gnome-shell/dist/ui/backgroundMenu.js
var backgroundMenu_exports = {};
__reExport(backgroundMenu_exports, backgroundMenu_star);
import * as backgroundMenu_star from "resource:///org/gnome/shell/ui/backgroundMenu.js";

// node_modules/@girs/gnome-shell/dist/ui/barLevel.js
var barLevel_exports = {};
__reExport(barLevel_exports, barLevel_star);
import * as barLevel_star from "resource:///org/gnome/shell/ui/barLevel.js";

// node_modules/@girs/gnome-shell/dist/ui/boxpointer.js
var boxpointer_exports = {};
__reExport(boxpointer_exports, boxpointer_star);
import * as boxpointer_star from "resource:///org/gnome/shell/ui/boxpointer.js";

// node_modules/@girs/gnome-shell/dist/ui/calendar.js
var calendar_exports = {};
__reExport(calendar_exports, calendar_star);
import * as calendar_star from "resource:///org/gnome/shell/ui/calendar.js";

// node_modules/@girs/gnome-shell/dist/ui/checkBox.js
var checkBox_exports = {};
__reExport(checkBox_exports, checkBox_star);
import * as checkBox_star from "resource:///org/gnome/shell/ui/checkBox.js";

// node_modules/@girs/gnome-shell/dist/ui/closeDialog.js
var closeDialog_exports = {};
__reExport(closeDialog_exports, closeDialog_star);
import * as closeDialog_star from "resource:///org/gnome/shell/ui/closeDialog.js";

// node_modules/@girs/gnome-shell/dist/ui/components.js
var components_exports = {};
__reExport(components_exports, components_star);
import * as components_star from "resource:///org/gnome/shell/ui/components.js";

// node_modules/@girs/gnome-shell/dist/ui/dialog.js
var dialog_exports = {};
__reExport(dialog_exports, dialog_star);
import * as dialog_star from "resource:///org/gnome/shell/ui/dialog.js";

// node_modules/@girs/gnome-shell/dist/ui/dnd.js
var dnd_exports = {};
__reExport(dnd_exports, dnd_star);
import * as dnd_star from "resource:///org/gnome/shell/ui/dnd.js";

// node_modules/@girs/gnome-shell/dist/ui/iconGrid.js
var iconGrid_exports = {};
__reExport(iconGrid_exports, iconGrid_star);
import * as iconGrid_star from "resource:///org/gnome/shell/ui/iconGrid.js";

// node_modules/@girs/gnome-shell/dist/ui/layout.js
var layout_exports = {};
__reExport(layout_exports, layout_star);
import * as layout_star from "resource:///org/gnome/shell/ui/layout.js";

// node_modules/@girs/gnome-shell/dist/ui/main.js
var main_exports = {};
__reExport(main_exports, main_star);
import * as main_star from "resource:///org/gnome/shell/ui/main.js";

// node_modules/@girs/gnome-shell/dist/ui/messageList.js
var messageList_exports = {};
__reExport(messageList_exports, messageList_star);
import * as messageList_star from "resource:///org/gnome/shell/ui/messageList.js";

// node_modules/@girs/gnome-shell/dist/ui/messageTray.js
var messageTray_exports = {};
__reExport(messageTray_exports, messageTray_star);
import * as messageTray_star from "resource:///org/gnome/shell/ui/messageTray.js";

// node_modules/@girs/gnome-shell/dist/ui/modalDialog.js
var modalDialog_exports = {};
__reExport(modalDialog_exports, modalDialog_star);
import * as modalDialog_star from "resource:///org/gnome/shell/ui/modalDialog.js";

// node_modules/@girs/gnome-shell/dist/ui/mpris.js
var mpris_exports = {};
__reExport(mpris_exports, mpris_star);
import * as mpris_star from "resource:///org/gnome/shell/ui/mpris.js";

// node_modules/@girs/gnome-shell/dist/ui/notificationDaemon.js
var notificationDaemon_exports = {};
__reExport(notificationDaemon_exports, notificationDaemon_star);
import * as notificationDaemon_star from "resource:///org/gnome/shell/ui/notificationDaemon.js";

// node_modules/@girs/gnome-shell/dist/ui/panel.js
var panel_exports = {};
__reExport(panel_exports, panel_star);
import * as panel_star from "resource:///org/gnome/shell/ui/panel.js";

// node_modules/@girs/gnome-shell/dist/ui/panelMenu.js
var panelMenu_exports = {};
__reExport(panelMenu_exports, panelMenu_star);
import * as panelMenu_star from "resource:///org/gnome/shell/ui/panelMenu.js";

// node_modules/@girs/gnome-shell/dist/ui/popupMenu.js
var popupMenu_exports = {};
__reExport(popupMenu_exports, popupMenu_star);
import * as popupMenu_star from "resource:///org/gnome/shell/ui/popupMenu.js";

// node_modules/@girs/gnome-shell/dist/ui/quickSettings.js
var quickSettings_exports = {};
__reExport(quickSettings_exports, quickSettings_star);
import * as quickSettings_star from "resource:///org/gnome/shell/ui/quickSettings.js";

// node_modules/@girs/gnome-shell/dist/ui/ripples.js
var ripples_exports = {};
__reExport(ripples_exports, ripples_star);
import * as ripples_star from "resource:///org/gnome/shell/ui/ripples.js";

// node_modules/@girs/gnome-shell/dist/ui/search.js
var search_exports = {};
__reExport(search_exports, search_star);
import * as search_star from "resource:///org/gnome/shell/ui/search.js";

// node_modules/@girs/gnome-shell/dist/ui/slider.js
var slider_exports = {};
__reExport(slider_exports, slider_star);
import * as slider_star from "resource:///org/gnome/shell/ui/slider.js";

// node_modules/@girs/gnome-shell/dist/ui/switcherPopup.js
var switcherPopup_exports = {};
__reExport(switcherPopup_exports, switcherPopup_star);
import * as switcherPopup_star from "resource:///org/gnome/shell/ui/switcherPopup.js";

// node_modules/@girs/gnome-shell/dist/ui/userWidget.js
var userWidget_exports = {};
__reExport(userWidget_exports, userWidget_star);
import * as userWidget_star from "resource:///org/gnome/shell/ui/userWidget.js";

// node_modules/@girs/gnome-shell/dist/ui/windowManager.js
var windowManager_exports = {};
__reExport(windowManager_exports, windowManager_star);
import * as windowManager_star from "resource:///org/gnome/shell/ui/windowManager.js";

// node_modules/@girs/gnome-shell/dist/ui/components/automountManager.js
var automountManager_exports = {};
__reExport(automountManager_exports, automountManager_star);
import * as automountManager_star from "resource:///org/gnome/shell/ui/components/automountManager.js";

// node_modules/@girs/gnome-shell/dist/ui/components/autorunManager.js
var autorunManager_exports = {};
__reExport(autorunManager_exports, autorunManager_star);
import * as autorunManager_star from "resource:///org/gnome/shell/ui/components/autorunManager.js";

// node_modules/@girs/gnome-shell/dist/ui/components/keyring.js
var keyring_exports = {};
__reExport(keyring_exports, keyring_star);
import * as keyring_star from "resource:///org/gnome/shell/ui/components/keyring.js";

// node_modules/@girs/gnome-shell/dist/ui/components/networkAgent.js
var networkAgent_exports = {};
__reExport(networkAgent_exports, networkAgent_star);
import * as networkAgent_star from "resource:///org/gnome/shell/ui/components/networkAgent.js";

// node_modules/@girs/gnome-shell/dist/ui/components/polkitAgent.js
var polkitAgent_exports = {};
__reExport(polkitAgent_exports, polkitAgent_star);
import * as polkitAgent_star from "resource:///org/gnome/shell/ui/components/polkitAgent.js";

// node_modules/@girs/gnome-shell/dist/ui/components/telepathyClient.js
var telepathyClient_exports = {};
__reExport(telepathyClient_exports, telepathyClient_star);
import * as telepathyClient_star from "resource:///org/gnome/shell/ui/components/telepathyClient.js";

// node_modules/@girs/gnome-shell/dist/ui/status/accessibility.js
var accessibility_exports = {};
__reExport(accessibility_exports, accessibility_star);
import * as accessibility_star from "resource:///org/gnome/shell/ui/status/accessibility.js";

// node_modules/@girs/gnome-shell/dist/ui/status/autoRotate.js
var autoRotate_exports = {};
__reExport(autoRotate_exports, autoRotate_star);
import * as autoRotate_star from "resource:///org/gnome/shell/ui/status/autoRotate.js";

// node_modules/@girs/gnome-shell/dist/ui/status/backgroundApps.js
var backgroundApps_exports = {};
__reExport(backgroundApps_exports, backgroundApps_star);
import * as backgroundApps_star from "resource:///org/gnome/shell/ui/status/backgroundApps.js";

// node_modules/@girs/gnome-shell/dist/ui/status/backlight.js
var backlight_exports = {};
__reExport(backlight_exports, backlight_star);
import * as backlight_star from "resource:///org/gnome/shell/ui/status/backlight.js";

// node_modules/@girs/gnome-shell/dist/ui/status/bluetooth.js
var bluetooth_exports = {};
__reExport(bluetooth_exports, bluetooth_star);
import * as bluetooth_star from "resource:///org/gnome/shell/ui/status/bluetooth.js";

// node_modules/@girs/gnome-shell/dist/ui/status/brightness.js
var brightness_exports = {};
__reExport(brightness_exports, brightness_star);
import * as brightness_star from "resource:///org/gnome/shell/ui/status/brightness.js";

// node_modules/@girs/gnome-shell/dist/ui/status/camera.js
var camera_exports = {};
__reExport(camera_exports, camera_star);
import * as camera_star from "resource:///org/gnome/shell/ui/status/camera.js";

// node_modules/@girs/gnome-shell/dist/ui/status/darkMode.js
var darkMode_exports = {};
__reExport(darkMode_exports, darkMode_star);
import * as darkMode_star from "resource:///org/gnome/shell/ui/status/darkMode.js";

// node_modules/@girs/gnome-shell/dist/ui/status/dwellClick.js
var dwellClick_exports = {};
__reExport(dwellClick_exports, dwellClick_star);
import * as dwellClick_star from "resource:///org/gnome/shell/ui/status/dwellClick.js";

// node_modules/@girs/gnome-shell/dist/ui/status/keyboard.js
var keyboard_exports = {};
__reExport(keyboard_exports, keyboard_star);
import * as keyboard_star from "resource:///org/gnome/shell/ui/status/keyboard.js";

// node_modules/@girs/gnome-shell/dist/ui/status/location.js
var location_exports = {};
__reExport(location_exports, location_star);
import * as location_star from "resource:///org/gnome/shell/ui/status/location.js";

// node_modules/@girs/gnome-shell/dist/ui/status/network.js
var network_exports = {};
__reExport(network_exports, network_star);
import * as network_star from "resource:///org/gnome/shell/ui/status/network.js";

// node_modules/@girs/gnome-shell/dist/ui/status/nightLight.js
var nightLight_exports = {};
__reExport(nightLight_exports, nightLight_star);
import * as nightLight_star from "resource:///org/gnome/shell/ui/status/nightLight.js";

// node_modules/@girs/gnome-shell/dist/ui/status/powerProfiles.js
var powerProfiles_exports = {};
__reExport(powerProfiles_exports, powerProfiles_star);
import * as powerProfiles_star from "resource:///org/gnome/shell/ui/status/powerProfiles.js";

// node_modules/@girs/gnome-shell/dist/ui/status/remoteAccess.js
var remoteAccess_exports = {};
__reExport(remoteAccess_exports, remoteAccess_star);
import * as remoteAccess_star from "resource:///org/gnome/shell/ui/status/remoteAccess.js";

// node_modules/@girs/gnome-shell/dist/ui/status/rfkill.js
var rfkill_exports = {};
__reExport(rfkill_exports, rfkill_star);
import * as rfkill_star from "resource:///org/gnome/shell/ui/status/rfkill.js";

// node_modules/@girs/gnome-shell/dist/ui/status/system.js
var system_exports = {};
__reExport(system_exports, system_star);
import * as system_star from "resource:///org/gnome/shell/ui/status/system.js";

// node_modules/@girs/gnome-shell/dist/ui/status/thunderbolt.js
var thunderbolt_exports = {};
__reExport(thunderbolt_exports, thunderbolt_star);
import * as thunderbolt_star from "resource:///org/gnome/shell/ui/status/thunderbolt.js";

// node_modules/@girs/gnome-shell/dist/ui/status/volume.js
var volume_exports = {};
__reExport(volume_exports, volume_star);
import * as volume_star from "resource:///org/gnome/shell/ui/status/volume.js";

// node_modules/@girs/gio-2.0/gio-2.0.js
import Gio from "gi://Gio?version=2.0";
var gio_2_0_default = Gio;

// node_modules/@girs/gobject-2.0/gobject-2.0.js
import GObject from "gi://GObject?version=2.0";
var gobject_2_0_default = GObject;

// src/modules/rog_quick_toggle.ts
var AsusQuickToggle = GObject.registerClass(
  class AsusQuickToggle2 extends quickSettings_exports.QuickToggle {
    dbus;
    prop_name = "";
    toggle_callback = () => {
    };
    constructor(dbus, prop_name, setting, title) {
      super({
        label: title,
        icon_name: "selection-mode-symbolic",
        toggle_mode: true
      });
      this.prop_name = prop_name;
      this.label = title;
      this.dbus = dbus;
      this.dbus?.proxy.connect("g-properties-changed", (_proxy, changed, invalidated) => {
        const properties = changed.deepUnpack();
        for (const v of Object.entries(properties)) {
          if (v[0] == this.prop_name) {
            const checked = v[1].unpack();
            if (this.checked !== checked)
              this.checked = checked;
            break;
          }
        }
      });
      this.connectObject("clicked", () => this._toggleMode(), this);
      this.connect("destroy", () => {
        this.destroy();
      });
      extension_exports.Extension.lookupByUUID(uuid)?.getSettings().bind(setting, this, "checked", Gio.SettingsBindFlags.DEFAULT);
      this.sync();
      addQuickSettingsItems([this]);
    }
    _toggleMode() {
      const checked = this.dbus.proxy[this.prop_name];
      if (this.checked !== checked)
        this.dbus.proxy[this.prop_name] = this.checked;
      this.toggle_callback();
    }
    sync() {
      const checked = this.dbus.proxy[this.prop_name];
      if (this.checked !== checked)
        this.set({ checked });
    }
  }
);

// src/modules/rog_slider_100pc.ts
var AsusSlider = GObject.registerClass(
  class AsusSlider2 extends quickSettings_exports.QuickSlider {
    dbus;
    settings = void 0;
    setting = "";
    prop_name = "";
    constructor(dbus, prop_name, setting, title) {
      super({
        label: title,
        icon_name: "selection-mode-symbolic"
      });
      this.label = title;
      this.dbus = dbus;
      this.setting = setting;
      this.prop_name = prop_name;
      this.settings = extension_exports.Extension.lookupByUUID(uuid)?.getSettings();
      this._sliderChangedId = this.slider.connect("drag-end", this._onSliderChanged.bind(this));
      this.settings.connect(`changed::${this.setting}`, this._onSettingsChanged.bind(this));
      this.slider.accessible_name = title;
      this.dbus?.proxy.connect("g-properties-changed", (_proxy, changed, invalidated) => {
        const properties = changed.deepUnpack();
        for (const v of Object.entries(properties)) {
          if (v[0] == this.prop_name) {
            const checked = v[1].unpack();
            this._sync();
            break;
          }
        }
      });
      this._sync();
      this._onSettingsChanged();
      addQuickSettingsItems([this], 2);
    }
    _onSettingsChanged() {
      this.slider.block_signal_handler(this._sliderChangedId);
      this.slider.value = this.settings.get_uint(this.setting) / 100;
      this.slider.unblock_signal_handler(this._sliderChangedId);
    }
    _onSliderChanged() {
      const percent = Math.floor(this.slider.value * 100);
      const stored = Math.floor(this.settings.get_uint(this.setting) / 100);
      if (this.slider.value !== stored)
        this.dbus.proxy[this.prop_name] = percent;
      this.settings.set_uint(this.setting, percent);
    }
    _sync() {
      const value = this.dbus.proxy[this.prop_name];
      if (this.slider.value !== value / 100)
        this.settings.set_uint(this.setting, value);
    }
  }
);

// src/modules/rog_menu_toggle.ts
var AsusMenuToggle = GObject.registerClass(
  class AsusMenuToggle2 extends popupMenu_exports.PopupSwitchMenuItem {
    title = "";
    dbus;
    prop_name = "";
    toggle_callback = () => {
    };
    constructor(dbus, prop_name, setting, title) {
      super(title, true);
      this.prop_name = prop_name;
      this.dbus = dbus;
      this.title = title;
      this.dbus?.proxy.connect("g-properties-changed", (_proxy, changed, invalidated) => {
        const properties = changed.deepUnpack();
        for (const v of Object.entries(properties)) {
          if (v[0] == this.prop_name) {
            this.sync();
            break;
          }
        }
      });
      this.connectObject("toggled", () => this._toggleMode(), this);
      this.connect("destroy", () => {
        this.destroy();
      });
      this.sync();
    }
    _toggleMode() {
      const state = this.dbus.proxy[this.prop_name];
      if (this.state !== state)
        this.dbus.proxy[this.prop_name] = this.state;
      this.toggle_callback();
    }
    sync() {
      const state = this.dbus.proxy[this.prop_name];
      if (this.state !== state)
        this.setToggleState(state);
    }
  }
);

// src/modules/quick_menus/laptop_features.ts
var FeatureMenuToggle = GObject.registerClass(
  class FeatureMenuToggle2 extends quickSettings_exports.QuickMenuToggle {
    dbus_platform;
    dbus_anime;
    last_selection = "mini-led";
    supported_properties;
    supported_interfaces = [];
    miniLed;
    panelOd;
    animeDisplayPower;
    animePowersaveAnim;
    _itemsSection;
    constructor(dbus_platform, dbus_anime) {
      super({
        label: "Laptop",
        toggle_mode: true,
        icon_name: "selection-mode-symbolic"
      });
      this.label = "Laptop";
      this.title = "Laptop";
      this.dbus_platform = dbus_platform;
      this.dbus_anime = dbus_anime;
      this.menu.setHeader("selection-mode-symbolic", "Laptop features");
      this.last_selection = extension_exports.Extension.lookupByUUID(uuid)?.getSettings().get_string("primary-quickmenu-toggle");
      this.supported_interfaces = this.dbus_platform?.proxy.SupportedInterfacesSync()[0];
      this.supported_properties = this.dbus_platform?.proxy.SupportedPropertiesSync()[0];
      if (this.last_selection == "mini-led" && !this.supported_properties.includes("MiniLed")) {
        this.last_selection = "panel-od";
      } else if (this.last_selection == "panel-od" && !this.supported_properties.includes("PanelOd")) {
        this.last_selection = "anime-power";
      } else if (this.last_selection == "anime-power" && !this.supported_interfaces.includes("Anime")) {
        this.last_selection = "mini-led";
      } else if (this.last_selection.length == 0) {
        this.last_selection = "panel-od";
      }
      extension_exports.Extension.lookupByUUID(uuid)?.getSettings().set_string("primary-quickmenu-toggle", this.last_selection);
      this._itemsSection = new popupMenu_exports.PopupMenuSection();
      if (this.supported_properties.includes("MiniLed")) {
        if (this.miniLed == null) {
          this.miniLed = new AsusMenuToggle(
            this.dbus_platform,
            "MiniLed",
            "mini-led-enabled",
            "Mini-LED Enabled"
          );
          this._itemsSection.addMenuItem(this.miniLed, 0);
          this.miniLed.toggle_callback = () => {
            this.last_selection = "mini-led";
          };
        }
      }
      if (this.supported_properties.includes("PanelOd")) {
        if (this.panelOd == null) {
          this.panelOd = new AsusMenuToggle(
            this.dbus_platform,
            "PanelOd",
            "panel-od-enabled",
            "Panel Overdrive Enabled"
          );
          this._itemsSection.addMenuItem(this.panelOd, 1);
          this.panelOd.toggle_callback = () => {
            this.last_selection = "panel-od";
          };
        }
      }
      if (this.supported_interfaces.includes("Anime")) {
        if (this.animeDisplayPower == null) {
          this.animeDisplayPower = new AsusMenuToggle(
            this.dbus_anime,
            "EnableDisplay",
            "anime-power",
            "AniMe Display Enabled"
          );
          this._itemsSection.addMenuItem(this.animeDisplayPower, 2);
          this.animeDisplayPower.toggle_callback = () => {
            this.last_selection = "anime-power";
          };
        }
        if (this.animePowersaveAnim == null) {
          this.animePowersaveAnim = new AsusMenuToggle(
            this.dbus_anime,
            "BuiltinsEnabled",
            "anime-builtins",
            "AniMe Built-in Animations"
          );
          this._itemsSection.addMenuItem(this.animePowersaveAnim, 3);
          this.animePowersaveAnim.toggle_callback = () => {
            this.last_selection = "anime-builtins";
          };
        }
      }
      this.connectObject(
        "clicked",
        () => {
          this._toggle();
        },
        this
      );
      this.menu.addMenuItem(this._itemsSection, 0);
      this.dbus_platform?.proxy.connect("g-properties-changed", (_proxy, changed, invalidated) => {
        this.sync();
      });
      this.dbus_anime?.proxy.connect("g-properties-changed", (_proxy, changed, invalidated) => {
        this.sync();
      });
      this.sync();
      addQuickSettingsItems([this]);
    }
    _toggle() {
      if (this.last_selection == "mini-led" && this.miniLed != null) {
        if (this.checked !== this.dbus_platform.proxy.MiniLed)
          this.dbus_platform.proxy.MiniLed = this.checked;
      }
      if (this.last_selection == "panel-od" && this.panelOd != null) {
        if (this.checked !== this.dbus_platform.proxy.PanelOd) {
          this.dbus_platform.proxy.PanelOd = this.checked;
        }
      }
      if (this.last_selection == "anime-power" && this.animeDisplayPower != null) {
        if (this.checked !== this.dbus_anime.proxy.EnableDisplay)
          this.dbus_anime.proxy.EnableDisplay = this.checked;
      }
      if (this.last_selection == "anime-builtins" && this.animePowersaveAnim != null) {
        if (this.checked !== this.dbus_anime.proxy.BuiltinsEnabled)
          this.dbus_anime.proxy.BuiltinsEnabled = this.checked;
      }
    }
    sync() {
      let checked = false;
      if (this.last_selection == "mini-led" && this.miniLed != null) {
        this.title = this.miniLed.title;
        checked = this.dbus_platform.proxy.MiniLed;
      }
      if (this.last_selection == "panel-od" && this.panelOd != null) {
        this.title = this.panelOd.title;
        checked = this.dbus_platform.proxy.PanelOd;
      }
      if (this.last_selection == "anime-power" && this.animeDisplayPower != null) {
        this.title = this.animeDisplayPower.title;
        checked = this.dbus_anime.proxy.EnableDisplay;
      }
      if (this.last_selection == "anime-builtins" && this.animePowersaveAnim != null) {
        this.title = this.animePowersaveAnim.title;
        checked = this.dbus_anime.proxy.BuiltinsEnabled;
      }
      if (this.checked !== checked)
        this.set({ checked });
    }
    destroy() {
    }
  }
);

// node_modules/@girs/glib-2.0/glib-2.0.js
import GLib from "gi://GLib?version=2.0";
var glib_2_0_default = GLib;

// node_modules/@girs/gjs/gjs.js
var imports = globalThis.imports || {};
var gjs_default = imports;

// src/modules/dbus_proxy.ts
function getStringResource(path) {
  const data = Gio.resources_lookup_data(path, 0);
  return new TextDecoder().decode(data.get_data()?.buffer);
}
var DbusBase5 = class {
  proxy;
  connected = false;
  ifaceXml = "";
  dbus_path = "";
  constructor(file_name, dbus_path) {
    let extensionObject = extension_exports.Extension.lookupByUUID("asusctl-gnome@asus-linux.org");
    const path = extensionObject?.path + "/resources/dbus/" + file_name;
    const [ok, data] = GLib.file_get_contents(path);
    if (!ok) {
      throw new Error("could not read interface file");
    }
    this.ifaceXml = imports.byteArray.toString(data);
    this.dbus_path = dbus_path;
  }
  async start() {
    log(`Starting ${this.dbus_path} dbus module`);
    try {
      log(this.ifaceXml);
      this.proxy = Gio.DBusProxy.makeProxyWrapper(this.ifaceXml)(
        Gio.DBus.system,
        "org.asuslinux.Daemon",
        this.dbus_path
      );
      this.connected = true;
      log(`${this.dbus_path} client started successfully.`);
    } catch (e) {
      logError(`${this.xml_resource} dbus init failed!`, e);
    }
  }
  async stop() {
    log(`Stopping ${this.xml_resource} dbus module`);
    if (this.connected && this.proxy != void 0) {
      this.proxy.run_dispose();
      this.proxy = void 0;
      this.connected = false;
    }
  }
  isRunning() {
    return this.connected;
  }
};

// src/extension.ts
var uuid = "asusctl-gnome@asus-linux.org";
var AsusExtension = class extends extension_exports.Extension {
  // public dbus_aura: AuraDbus = new AuraDbus;
  // public dbus_anime: AnimeDbus = new AnimeDbus;
  dbus_platform;
  dbus_anime;
  individual = false;
  supported_properties;
  supported_interfaces = [];
  feature_menu = null;
  panel_od = null;
  mini_led = null;
  anime_display = null;
  anime_builtins = null;
  charge_thres = null;
  // private _feature: typeof FeatureMenuToggle;
  async enable() {
    log(this.path);
    if (this.dbus_platform == void 0) {
      this.dbus_platform = new DbusBase5("org-asuslinux-platform-4.xml", "/org/asuslinux/Platform");
      await this.dbus_platform.start();
    }
    if (this.dbus_anime == void 0) {
      this.dbus_anime = new DbusBase5("org-asuslinux-anime-4.xml", "/org/asuslinux/Anime");
      await this.dbus_anime.start();
    }
    this.supported_interfaces = this.dbus_platform?.proxy.SupportedInterfacesSync()[0];
    this.supported_properties = this.dbus_platform?.proxy.SupportedPropertiesSync()[0];
    log(this.supported_interfaces);
    log(this.supported_properties);
    if (!this.individual) {
      if (this.feature_menu == null)
        this.feature_menu = new FeatureMenuToggle(this.dbus_platform, this.dbus_anime);
    } else {
      if (this.supported_properties.includes("PanelOd") && this.dbus_platform.proxy.PanelOd != null) {
        if (this.panel_od == null) {
          this.panel_od = new AsusQuickToggle(
            this.dbus_platform,
            "PanelOd",
            "panel-od-enabled",
            "Panel Overdrive"
          );
        }
      }
      if (this.supported_properties.includes("MiniLed") && this.dbus_platform.proxy.MiniLed != null) {
        if (this.mini_led == null) {
          this.mini_led = new AsusQuickToggle(
            this.dbus_platform,
            "MiniLed",
            "mini-led-enabled",
            "Mini-LED"
          );
        }
      }
      if (this.supported_interfaces.includes("Anime") && this.dbus_anime.proxy.EnableDisplay != null) {
        if (this.anime_display == null) {
          this.anime_display = new AsusQuickToggle(
            this.dbus_anime,
            "EnableDisplay",
            "anime-power",
            "AniMe Display"
          );
        }
      }
      if (this.supported_interfaces.includes("Anime") && this.dbus_anime.proxy.BuiltinsEnabled != null) {
        if (this.anime_builtins == null) {
          this.anime_builtins = new AsusQuickToggle(
            this.dbus_anime,
            "BuiltinsEnabled",
            "anime-builtins",
            "Use builtins"
          );
        }
      }
    }
    if (this.supported_properties.includes("ChargeControlEndThreshold") && this.dbus_platform.proxy.ChargeControlEndThreshold != null) {
      if (this.charge_thres == null) {
        this.charge_thres = new AsusSlider(
          this.dbus_platform,
          "ChargeControlEndThreshold",
          "charge-level",
          "Charge Level"
        );
      }
    }
  }
  disable() {
    this.dbus_platform?.stop();
    this.dbus_anime?.stop();
    this.feature_menu?.destroy();
    feature_menu?.destroy();
    panel_od?.destroy();
    mini_led?.destroy();
    anime_display?.destroy();
    anime_builtins?.destroy();
    charge_thres?.destroy();
  }
};
export {
  AsusExtension as default,
  uuid
};
