/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwk;

import java.security.Key;
import java.util.Collection;
import java.util.List;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.SelectorSupport;
import org.jose4j.jwk.SimpleJwkFilter;
import org.jose4j.lang.ExceptionHelp;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptionJwkSelector {
    private static final Logger log = LoggerFactory.getLogger(DecryptionJwkSelector.class);

    public JsonWebKey select(JsonWebEncryption jwe, Collection<JsonWebKey> keys2) throws JoseException {
        List<JsonWebKey> jsonWebKeys = this.selectList(jwe, keys2);
        return jsonWebKeys.isEmpty() ? null : jsonWebKeys.get(0);
    }

    public List<JsonWebKey> selectList(JsonWebEncryption jwe, Collection<JsonWebKey> keys2) throws JoseException {
        SimpleJwkFilter filter = SelectorSupport.filterForInboundEncrypted(jwe);
        return filter.filter(keys2);
    }

    public JsonWebKey attemptDecryptDisambiguate(JsonWebEncryption jwe, List<JsonWebKey> jsonWebKeys) {
        for (JsonWebKey jwk : jsonWebKeys) {
            Key key;
            if (jwk instanceof PublicJsonWebKey) {
                PublicJsonWebKey publicJwk = (PublicJsonWebKey)jwk;
                key = publicJwk.getPrivateKey();
            } else {
                key = jwk.getKey();
            }
            if (key == null) continue;
            jwe.setKey(key);
            try {
                byte[] plaintextBytes = jwe.getPlaintextBytes();
                if (plaintextBytes == null) continue;
                return jwk;
            }
            catch (JoseException e11) {
                log.debug("Not using key (kid={}) b/c attempt to decrypt failed trying to disambiguate ({}).", (Object)jwk.getKeyId(), (Object)ExceptionHelp.toStringWithCauses(e11));
            }
        }
        return null;
    }
}

