/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.GCMParameterSpec;
import org.jose4j.jwe.CipherStrengthSupport;
import org.jose4j.jwe.CipherUtil;
import org.jose4j.keys.AesKey;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.ExceptionHelp;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;

public class SimpleAeadCipher {
    public static final String GCM_TRANSFORMATION_NAME = "AES/GCM/NoPadding";
    private String algorithm;
    private int tagByteLength;

    public SimpleAeadCipher(String algorithm, int tagByteLength) {
        this.algorithm = algorithm;
        this.tagByteLength = tagByteLength;
    }

    public Cipher getInitialisedCipher(Key key, byte[] iv2, int mode, String provider) throws JoseException {
        Cipher cipher = CipherUtil.getCipher(this.algorithm, provider);
        try {
            GCMParameterSpec parameterSpec = new GCMParameterSpec(ByteUtil.bitLength(this.tagByteLength), iv2);
            cipher.init(mode, key, parameterSpec);
            return cipher;
        }
        catch (InvalidKeyException e11) {
            throw new JoseException("Invalid key for " + this.algorithm, e11);
        }
        catch (InvalidAlgorithmParameterException e12) {
            throw new JoseException(e12.toString(), e12);
        }
    }

    public CipherOutput encrypt(Key key, byte[] iv2, byte[] plaintext, byte[] aad, String provider) throws JoseException {
        byte[] cipherOutput;
        Cipher cipher = this.getInitialisedCipher(key, iv2, 1, provider);
        this.updateAad(cipher, aad);
        try {
            cipherOutput = cipher.doFinal(plaintext);
        }
        catch (BadPaddingException | IllegalBlockSizeException e11) {
            throw new JoseException(e11.toString(), e11);
        }
        CipherOutput result = new CipherOutput();
        int tagIndex = cipherOutput.length - this.tagByteLength;
        CipherOutput.access$002(result, ByteUtil.subArray(cipherOutput, 0, tagIndex));
        CipherOutput.access$102(result, ByteUtil.subArray(cipherOutput, tagIndex, this.tagByteLength));
        return result;
    }

    private void updateAad(Cipher cipher, byte[] aad) {
        if (aad != null && aad.length > 0) {
            cipher.updateAAD(aad);
        }
    }

    public byte[] decrypt(Key key, byte[] iv2, byte[] ciphertext, byte[] tag, byte[] aad, String provider) throws JoseException {
        Cipher cipher = this.getInitialisedCipher(key, iv2, 2, provider);
        return this.decrypt(ciphertext, tag, aad, cipher);
    }

    public byte[] decrypt(byte[] ciphertext, byte[] tag, byte[] aad, Cipher cipher) throws JoseException {
        this.updateAad(cipher, aad);
        try {
            return cipher.doFinal(ByteUtil.concat(ciphertext, tag));
        }
        catch (BadPaddingException | IllegalBlockSizeException e11) {
            throw new JoseException(e11.toString(), e11);
        }
    }

    public boolean isAvailable(Logger log, int keyByteLength, int ivByteLength, String joseAlg) {
        boolean isAvailable = false;
        if (CipherStrengthSupport.isAvailable(this.algorithm, keyByteLength)) {
            byte[] plain = new byte[]{112, 108, 97, 105, 110, 116, 101, 120, 116};
            byte[] aad = new byte[]{97, 97, 100};
            byte[] cek = ByteUtil.randomBytes(keyByteLength);
            byte[] iv2 = ByteUtil.randomBytes(ivByteLength);
            try {
                this.encrypt(new AesKey(cek), iv2, plain, aad, null);
                isAvailable = true;
            }
            catch (Throwable e11) {
                log.debug("{} is not available ({}).", (Object)joseAlg, (Object)ExceptionHelp.toStringWithCauses(e11));
            }
        }
        return isAvailable;
    }

    public static class CipherOutput {
        private byte[] ciphertext;
        private byte[] tag;

        public byte[] getCiphertext() {
            return this.ciphertext;
        }

        public byte[] getTag() {
            return this.tag;
        }

        static /* synthetic */ byte[] access$002(CipherOutput x02, byte[] x12) {
            x02.ciphertext = x12;
            return x12;
        }

        static /* synthetic */ byte[] access$102(CipherOutput x02, byte[] x12) {
            x02.tag = x12;
            return x12;
        }
    }
}

