/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@ElementTypesAreNonnullByDefault
abstract class AbstractByteHasher
extends AbstractHasher {
    private final ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    protected void update(byte[] b11) {
        this.update(b11, 0, b11.length);
    }

    protected void update(byte[] b11, int off, int len) {
        for (int i11 = off; i11 < off + len; ++i11) {
            this.update(b11[i11]);
        }
    }

    protected void update(ByteBuffer b11) {
        if (b11.hasArray()) {
            this.update(b11.array(), b11.arrayOffset() + b11.position(), b11.remaining());
            Java8Compatibility.position(b11, b11.limit());
        } else {
            for (int remaining = b11.remaining(); remaining > 0; --remaining) {
                this.update(b11.get());
            }
        }
    }

    @CanIgnoreReturnValue
    private Hasher update(int bytes) {
        try {
            this.update(this.scratch.array(), 0, bytes);
        }
        finally {
            Java8Compatibility.clear(this.scratch);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putByte(byte b11) {
        this.update(b11);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] bytes) {
        Preconditions.checkNotNull(bytes);
        this.update(bytes);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        this.update(bytes, off, len);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(ByteBuffer bytes) {
        this.update(bytes);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putShort(short s11) {
        this.scratch.putShort(s11);
        return this.update(2);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putInt(int i11) {
        this.scratch.putInt(i11);
        return this.update(4);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putLong(long l11) {
        this.scratch.putLong(l11);
        return this.update(8);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putChar(char c11) {
        this.scratch.putChar(c11);
        return this.update(2);
    }
}

