/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableMap;

public final class RuntimeEnabledSdkManifestCompatibilityValidator
extends SubValidator {
    @Override
    public void validateBundleWithSdkModules(AppBundle bundle, ImmutableMap<String, BundleModule> sdkModules) {
        RuntimeEnabledSdkManifestCompatibilityValidator.validateMinSdkVersionBetweeenAppAndSdks(bundle, sdkModules);
        RuntimeEnabledSdkManifestCompatibilityValidator.validateMinAndTargetSdkVersionAcrossSdks(sdkModules);
    }

    private static void validateMinSdkVersionBetweeenAppAndSdks(AppBundle bundle, ImmutableMap<String, BundleModule> sdkModules) {
        int baseMinSdk = bundle.getModules().values().stream().filter(BundleModule::isBaseModule).map(BundleModule::getAndroidManifest).mapToInt(AndroidManifest::getEffectiveMinSdkVersion).findFirst().orElseThrow(BundleValidationUtils::createNoBaseModuleException);
        sdkModules.entrySet().forEach(sdkModule -> {
            if (((BundleModule)sdkModule.getValue()).getAndroidManifest().getEffectiveMinSdkVersion() > baseMinSdk) {
                throw InvalidBundleException.builder().withUserMessage("Runtime-enabled SDKs must not have a minSdkVersion greater than the app, but found SDK '%s' with minSdkVersion (%d) higher than the app's minSdkVersion (%d).", sdkModule.getKey(), ((BundleModule)sdkModule.getValue()).getAndroidManifest().getEffectiveMinSdkVersion(), baseMinSdk).build();
            }
        });
    }

    private static void validateMinAndTargetSdkVersionAcrossSdks(ImmutableMap<String, BundleModule> sdkModules) {
        sdkModules.entrySet().forEach(nameToModule1 -> {
            AndroidManifest manifest1 = ((BundleModule)nameToModule1.getValue()).getAndroidManifest();
            sdkModules.entrySet().forEach(nameToModule2 -> {
                AndroidManifest manifest2 = ((BundleModule)nameToModule2.getValue()).getAndroidManifest();
                if (manifest1.getEffectiveMinSdkVersion() > manifest2.getEffectiveTargetSdkVersion()) {
                    throw InvalidBundleException.builder().withUserMessage("Runtime-enabled SDKs must have a minSdkVersion lower or equal to the targetSdkVersion of another SDK, but found SDK '%s' with minSdkVersion (%d) higher than the targetSdkVersion (%d) of SDK '%s'.", nameToModule1.getKey(), manifest1.getEffectiveMinSdkVersion(), manifest2.getEffectiveTargetSdkVersion(), nameToModule2.getKey()).build();
                }
            });
        });
    }
}

