/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.FingerprintDigestValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class RuntimeEnabledSdkConfigValidator
extends SubValidator {
    private static final int RESOURCES_PACKAGE_ID_MIN_VALUE = 2;
    private static final int RESOURCES_PACKAGE_ID_MAX_VALUE = 255;

    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        ImmutableList<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdks = modules.stream().filter(module -> module.getRuntimeEnabledSdkConfig().isPresent()).map(module -> module.getRuntimeEnabledSdkConfig().get()).flatMap(runtimeEnabledSdkConfig -> runtimeEnabledSdkConfig.getRuntimeEnabledSdkList().stream()).collect(ImmutableList.toImmutableList());
        runtimeEnabledSdks.forEach(runtimeEnabledSdk -> RuntimeEnabledSdkConfigValidator.validateRuntimeEnabledSdk(runtimeEnabledSdk));
        RuntimeEnabledSdkConfigValidator.validateUniqueSdkPackageNames(runtimeEnabledSdks);
        RuntimeEnabledSdkConfigValidator.validateUniqueResourcePackageId(runtimeEnabledSdks);
    }

    private static void validateUniqueSdkPackageNames(ImmutableList<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdks) {
        Map runtimeEnabledSdksByPackageName = runtimeEnabledSdks.stream().collect(ImmutableListMultimap.toImmutableListMultimap(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk::getPackageName, Function.identity())).asMap();
        runtimeEnabledSdksByPackageName.forEach((key, value) -> RuntimeEnabledSdkConfigValidator.validate(value.size() == 1, "Found multiple dependencies on the same runtime-enabled SDK '%s'.", key));
    }

    private static void validateUniqueResourcePackageId(ImmutableList<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdks) {
        Map runtimeEnabledSkdsPerResourcesPackageId = runtimeEnabledSdks.stream().collect(ImmutableListMultimap.toImmutableListMultimap(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk::getResourcesPackageId, Function.identity())).asMap();
        ((ImmutableMap)runtimeEnabledSkdsPerResourcesPackageId).entrySet().forEach(sdksPerResourcesPackageId -> RuntimeEnabledSdkConfigValidator.validate(((Collection)sdksPerResourcesPackageId.getValue()).size() == 1, "Found dependencies on runtime-enabled SDKs '%s', which specify the same 'resources_package_id' value %d. resources_package_id values must be unique across all runtime-enabled SDK dependencies.", ((Collection)sdksPerResourcesPackageId.getValue()).stream().map(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk::getPackageName).collect(Collectors.joining(", ")), sdksPerResourcesPackageId.getKey()));
    }

    private static void validateRuntimeEnabledSdk(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk runtimeEnabledSdk) {
        RuntimeEnabledSdkConfigValidator.validate(!runtimeEnabledSdk.getPackageName().isEmpty(), "Found dependency on runtime-enabled SDK with an empty package name.", new Object[0]);
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMajor() >= 0, "Found dependency on runtime-enabled SDK '%s' with a negative major version.", runtimeEnabledSdk.getPackageName());
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMajor() <= 199999, "Found dependency on runtime-enabled SDK '%s' with illegal major version. Major version must be <= %d.", runtimeEnabledSdk.getPackageName(), 199999);
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMinor() >= 0, "Found dependency on runtime-enabled SDK '%s' with a negative minor version.", runtimeEnabledSdk.getPackageName());
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMinor() <= 9999, "Found dependency on runtime-enabled SDK '%s' with illegal minor version. Minor version must be <= %d.", runtimeEnabledSdk.getPackageName(), 9999);
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getBuildTimeVersionPatch() >= 0, "Found dependency on runtime-enabled SDK '%s' with a negative patch version.", runtimeEnabledSdk.getPackageName());
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getBuildTimeVersionPatch() <= 9999, "Found dependency on runtime-enabled SDK '%s' with illegal patch version. Patch version must be <= %d.", runtimeEnabledSdk.getPackageName(), 9999);
        RuntimeEnabledSdkConfigValidator.validate(FingerprintDigestValidator.isValidFingerprintDigest(runtimeEnabledSdk.getCertificateDigest()), "Found dependency on runtime-enabled SDK '%s' with a signing certificate digest of unexpected format.", runtimeEnabledSdk.getPackageName());
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getResourcesPackageId() >= 2 && runtimeEnabledSdk.getResourcesPackageId() <= 255, "Illegal value of resources_package_id in RuntimeEnabledSdkConfig for SDK '%s': value must be an integer between %d and %d, but was %d", runtimeEnabledSdk.getPackageName(), 2, 255, runtimeEnabledSdk.getResourcesPackageId());
    }

    @FormatMethod
    private static void validate(boolean condition2, @FormatString String message2, Object ... args2) {
        if (!condition2) {
            throw InvalidBundleException.builder().withUserMessage(message2, args2).build();
        }
    }
}

