/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.splitters.AssetsDimensionSplitterFactory;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class DeviceGroupAssetsSplitter {
    public static ModuleSplitSplitter create(boolean stripTargetingSuffix) {
        return AssetsDimensionSplitterFactory.createSplitter(Targeting.AssetsDirectoryTargeting::getDeviceGroup, DeviceGroupAssetsSplitter::fromDeviceGroup, Targeting.ApkTargeting::hasDeviceGroupTargeting, stripTargetingSuffix ? Optional.of(TargetingDimension.DEVICE_GROUP) : Optional.empty());
    }

    private static Targeting.ApkTargeting fromDeviceGroup(Targeting.DeviceGroupTargeting targeting) {
        Preconditions.checkState(targeting.getValueCount() == 1, "Device Group targeting must have exactly 1 entry - found %s", (Object)targeting.getValueList());
        return Targeting.ApkTargeting.newBuilder().setDeviceGroupTargeting(targeting).build();
    }

    private DeviceGroupAssetsSplitter() {
    }
}

