/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_InstallApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.tools.build.bundletool.device.AdbRunner;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.device.LocalTestingPathResolver;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.ResultUtils;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.Int32Value;
import com.google.protobuf.StringValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;

@AutoValue
public abstract class InstallApksCommand {
    public static final String COMMAND_NAME = "install-apks";
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<Path> APKS_ARCHIVE_FILE_FLAG = Flag.path("apks");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<ImmutableSet<String>> MODULES_FLAG = Flag.stringSet("modules");
    private static final Flag<Boolean> ALLOW_DOWNGRADE_FLAG = Flag.booleanFlag("allow-downgrade");
    private static final Flag<Boolean> ALLOW_TEST_ONLY_FLAG = Flag.booleanFlag("allow-test-only");
    private static final Flag<Boolean> GRANT_RUNTIME_PERMISSIONS_FLAG = Flag.booleanFlag("grant-runtime-permissions");
    private static final Flag<Integer> DEVICE_TIER_FLAG = Flag.nonNegativeInteger("device-tier");
    private static final Flag<ImmutableSet<String>> DEVICE_GROUPS_FLAG = Flag.stringSet("device-groups");
    private static final Flag<String> COUNTRY_SET_FLAG = Flag.string("country-set");
    private static final Flag<ImmutableList<Path>> ADDITIONAL_LOCAL_TESTING_FILES_FLAG = Flag.pathList("additional-local-testing-files");
    private static final Flag<Integer> TIMEOUT_MILLIS_FLAG = Flag.positiveInteger("timeout-millis");
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    public abstract Path getAdbPath();

    public abstract Path getApksArchivePath();

    public abstract Optional<String> getDeviceId();

    public abstract Optional<ImmutableSet<String>> getModules();

    public abstract boolean getAllowDowngrade();

    public abstract boolean getAllowTestOnly();

    public abstract boolean getGrantRuntimePermissions();

    public abstract Optional<Integer> getDeviceTier();

    public abstract Optional<ImmutableSet<String>> getDeviceGroups();

    public abstract Optional<String> getCountrySet();

    public abstract Optional<ImmutableList<Path>> getAdditionalLocalTestingFiles();

    abstract AdbServer getAdbServer();

    public abstract Duration getTimeout();

    public static Builder builder() {
        return new AutoValue_InstallApksCommand.Builder().setAllowDowngrade(false).setAllowTestOnly(false).setGrantRuntimePermissions(false).setTimeout(Device.DEFAULT_ADB_TIMEOUT);
    }

    public static InstallApksCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return InstallApksCommand.fromFlags(flags, DEFAULT_PROVIDER, adbServer);
    }

    public static InstallApksCommand fromFlags(ParsedFlags flags, SystemEnvironmentProvider systemEnvironmentProvider, AdbServer adbServer) {
        Path apksArchivePath = APKS_ARCHIVE_FILE_FLAG.getRequiredValue(flags);
        Path adbPath = CommandUtils.getAdbPath(flags, ADB_PATH_FLAG, systemEnvironmentProvider);
        Optional<String> deviceSerialName = CommandUtils.getDeviceSerialName(flags, DEVICE_ID_FLAG, systemEnvironmentProvider);
        Optional<ImmutableSet<String>> modules = MODULES_FLAG.getValue(flags);
        Optional<Boolean> allowDowngrade = ALLOW_DOWNGRADE_FLAG.getValue(flags);
        Optional<Boolean> allowTestOnly = ALLOW_TEST_ONLY_FLAG.getValue(flags);
        Optional<Boolean> grantRuntimePermissions = GRANT_RUNTIME_PERMISSIONS_FLAG.getValue(flags);
        Optional<Integer> deviceTier = DEVICE_TIER_FLAG.getValue(flags);
        Optional<ImmutableSet<String>> deviceGroups = DEVICE_GROUPS_FLAG.getValue(flags);
        Optional<String> countrySet = COUNTRY_SET_FLAG.getValue(flags);
        Optional<ImmutableList<Path>> additionalLocalTestingFiles = ADDITIONAL_LOCAL_TESTING_FILES_FLAG.getValue(flags);
        Optional<Integer> timeoutMillis = TIMEOUT_MILLIS_FLAG.getValue(flags);
        flags.checkNoUnknownFlags();
        Builder command = InstallApksCommand.builder().setAdbPath(adbPath).setAdbServer(adbServer).setApksArchivePath(apksArchivePath);
        deviceSerialName.ifPresent(command::setDeviceId);
        modules.ifPresent(command::setModules);
        allowDowngrade.ifPresent(command::setAllowDowngrade);
        allowTestOnly.ifPresent(command::setAllowTestOnly);
        grantRuntimePermissions.ifPresent(command::setGrantRuntimePermissions);
        deviceTier.ifPresent(command::setDeviceTier);
        deviceGroups.ifPresent(command::setDeviceGroups);
        countrySet.ifPresent(command::setCountrySet);
        additionalLocalTestingFiles.ifPresent(command::setAdditionalLocalTestingFiles);
        timeoutMillis.ifPresent(timeout -> command.setTimeout(Duration.ofMillis(timeout.intValue())));
        return command.build();
    }

    public void execute() {
        Commands.BuildApksResult toc = this.readBuildApksResult();
        this.validateInput(toc);
        AdbServer adbServer = this.getAdbServer();
        adbServer.init(this.getAdbPath());
        try (TempDirectory tempDirectory = new TempDirectory();){
            Devices.DeviceSpec deviceSpec = new DeviceAnalyzer(adbServer).getDeviceSpec(this.getDeviceId());
            if (this.getDeviceTier().isPresent()) {
                deviceSpec = deviceSpec.toBuilder().setDeviceTier(Int32Value.of(this.getDeviceTier().get())).build();
            }
            if (this.getDeviceGroups().isPresent()) {
                deviceSpec = deviceSpec.toBuilder().addAllDeviceGroups((Iterable<String>)this.getDeviceGroups().get()).build();
            }
            if (this.getCountrySet().isPresent()) {
                deviceSpec = deviceSpec.toBuilder().setCountrySet(StringValue.of(this.getCountrySet().get())).build();
            }
            ImmutableList<Path> apksToInstall = this.getApksToInstall(toc, deviceSpec, tempDirectory.getPath());
            ImmutableCollection filesToPush = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getApksToPushToStorage(toc, deviceSpec, tempDirectory.getPath()))).addAll((Iterable)this.getAdditionalLocalTestingFiles().orElse(ImmutableList.of()))).build();
            AdbRunner adbRunner = new AdbRunner(adbServer);
            Device.InstallOptions installOptions = Device.InstallOptions.builder().setAllowDowngrade(this.getAllowDowngrade()).setAllowTestOnly(this.getAllowTestOnly()).setGrantRuntimePermissions(this.getGrantRuntimePermissions()).setTimeout(this.getTimeout()).build();
            if (this.getDeviceId().isPresent()) {
                adbRunner.run(device -> device.installApks(apksToInstall, installOptions), this.getDeviceId().get());
            } else {
                adbRunner.run(device -> device.installApks(apksToInstall, installOptions));
            }
            if (!filesToPush.isEmpty()) {
                this.pushFiles((ImmutableList<Path>)filesToPush, toc, adbRunner);
            }
            if (toc.getLocalTestingInfo().getEnabled()) {
                this.cleanUpEmulatedSplits(adbRunner, toc);
            }
        }
    }

    private void cleanUpEmulatedSplits(AdbRunner adbRunner, Commands.BuildApksResult toc) {
        if (this.getDeviceId().isPresent()) {
            adbRunner.run(device -> this.removeRemotePath((Device)device, toc), this.getDeviceId().get());
        } else {
            adbRunner.run(device -> this.removeRemotePath((Device)device, toc));
        }
    }

    private void removeRemotePath(Device device, Commands.BuildApksResult toc) {
        try {
            device.removeRemotePath(LocalTestingPathResolver.getLocalTestingWorkingDir(toc.getPackageName()), Optional.of(toc.getPackageName()), this.getTimeout());
        }
        catch (IOException e11) {
            System.err.println("Failed to remove working directory with local testing splits. Your app might still have been installed correctly but have previous version of dynamic feature modules. If you see legacy versions of dynamic feature modules installed try to uninstall and install the app again.");
        }
    }

    private ImmutableList<Path> getApksToInstall(Commands.BuildApksResult toc, Devices.DeviceSpec deviceSpec, Path output) {
        ExtractApksCommand.Builder extractApksCommand = ExtractApksCommand.builder().setApksArchivePath(this.getApksArchivePath()).setDeviceSpec(deviceSpec);
        if (!Files.isDirectory(this.getApksArchivePath(), new LinkOption[0])) {
            extractApksCommand.setOutputDirectory(output);
        }
        ImmutableSet dynamicAssetModules = toc.getAssetSliceSetList().stream().map(Commands.AssetSliceSet::getAssetModuleMetadata).filter(metadata -> metadata.getDeliveryType() != Commands.DeliveryType.INSTALL_TIME).map(Commands.AssetModuleMetadata::getName).collect(ImmutableSet.toImmutableSet());
        this.getModules().map(modules -> ExtractApksCommand.resolveRequestedModules(modules, toc, deviceSpec)).map(modules -> Sets.difference(modules, dynamicAssetModules).immutableCopy()).ifPresent(extractApksCommand::setModules);
        return extractApksCommand.build().execute();
    }

    private ImmutableList<Path> getApksToPushToStorage(Commands.BuildApksResult toc, Devices.DeviceSpec deviceSpec, Path output) {
        if (!toc.getLocalTestingInfo().getEnabled()) {
            return ImmutableList.of();
        }
        ExtractApksCommand.Builder extractApksCommand = ExtractApksCommand.builder().setApksArchivePath(this.getApksArchivePath()).setDeviceSpec(InstallApksCommand.addAllSupportedLanguages(deviceSpec, toc));
        if (!Files.isDirectory(this.getApksArchivePath(), new LinkOption[0])) {
            extractApksCommand.setOutputDirectory(output);
        }
        ImmutableSet installTimeAssetModules = toc.getAssetSliceSetList().stream().map(Commands.AssetSliceSet::getAssetModuleMetadata).filter(metadata -> metadata.getDeliveryType() == Commands.DeliveryType.INSTALL_TIME).map(Commands.AssetModuleMetadata::getName).collect(ImmutableSet.toImmutableSet());
        ImmutableSet<String> allModules = ExtractApksCommand.resolveRequestedModules(ImmutableSet.of("_ALL_"), toc, deviceSpec);
        extractApksCommand.setModules(Sets.difference(allModules, installTimeAssetModules).immutableCopy());
        extractApksCommand.setIncludeInstallTimeAssetModules(false);
        return extractApksCommand.build().execute().stream().filter(apk -> !ResultUtils.getAllBaseMasterSplitPaths(toc).contains(apk.getFileName().toString())).collect(ImmutableList.toImmutableList());
    }

    private void pushFiles(ImmutableList<Path> files, Commands.BuildApksResult toc, AdbRunner adbRunner) {
        String packageName = toc.getPackageName();
        if (packageName.isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("Unable to determine the package name of the base APK. If your APK set was produced using an older version of bundletool, please regenerate it.").build();
        }
        Device.PushOptions.Builder pushOptions = Device.PushOptions.builder().setDestinationPath(toc.getLocalTestingInfo().getLocalTestingPath()).setClearDestinationPath(true).setPackageName(packageName).setTimeout(this.getTimeout());
        if (this.getDeviceId().isPresent()) {
            adbRunner.run(device -> device.push(files, pushOptions.build()), this.getDeviceId().get());
        } else {
            adbRunner.run(device -> device.push(files, pushOptions.build()));
        }
    }

    private static Devices.DeviceSpec addAllSupportedLanguages(Devices.DeviceSpec deviceSpec, Commands.BuildApksResult toc) {
        ImmutableSet<String> targetedLanguages = ResultUtils.getAllTargetedLanguages(toc);
        return deviceSpec.toBuilder().addAllSupportedLocales(targetedLanguages).build();
    }

    private void validateInput(Commands.BuildApksResult toc) {
        FilePreconditions.checkFileExistsAndExecutable(this.getAdbPath());
        if (this.getAdditionalLocalTestingFiles().isPresent()) {
            Preconditions.checkArgument(toc.getLocalTestingInfo().getEnabled(), "'%s' flag is only supported for APKs built in local testing mode.", (Object)ADDITIONAL_LOCAL_TESTING_FILES_FLAG.getName());
        }
    }

    private Commands.BuildApksResult readBuildApksResult() {
        if (Files.isDirectory(this.getApksArchivePath(), new LinkOption[0])) {
            FilePreconditions.checkDirectoryExists(this.getApksArchivePath());
        } else {
            FilePreconditions.checkFileExistsAndReadable(this.getApksArchivePath());
        }
        return ResultUtils.readTableOfContents(this.getApksArchivePath());
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Installs APKs extracted from an APK Set to a connected device. Replaces already installed package.").addAdditionalParagraph("This will extract from the APK Set archive and install only the APKs that would be served to that device. If the app is not compatible with the device or if the APK Set archive was generated for a different type of device, this command will fail.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s or %s environment variable is set.", "ANDROID_HOME", "PATH").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_FILE_FLAG.getName()).setExampleValue("archive.apks").setDescription("Path to the archive file generated by the '%s' command.", "build-apks").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. If absent, this uses the %s environment variable. Either this flag or the environment variable is required when more than one device or emulator is connected.", "ANDROID_SERIAL").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ALLOW_DOWNGRADE_FLAG.getName()).setOptional(true).setDescription("If set, allows APKs to be installed on the device even if the app is already installed with a lower version code.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("base,module1,module2").setOptional(true).setDescription("List of modules to be installed, or \"%s\" for all modules. Defaults to modules installed during the first install, i.e. not on-demand. Note that the dependent modules will also be extracted. The value of this flag is ignored if the device receives a standalone APK.", "_ALL_").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ALLOW_TEST_ONLY_FLAG.getName()).setOptional(true).setDescription("If set, apps with 'android:testOnly=true' set in their manifest can also be deployed").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(GRANT_RUNTIME_PERMISSIONS_FLAG.getName()).setOptional(true).setDescription("If set, apps are granted runtime permissions. Available on API level 23(Android M) and above.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_TIER_FLAG.getName()).setExampleValue("1").setOptional(true).setDescription("Device tier of the given device. This value will be used to match the correct device tier targeted APKs to this device. This flag is only relevant if the bundle uses device tier targeting, and should be set in that case.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_GROUPS_FLAG.getName()).setExampleValue("highRam,googlePixel").setOptional(true).setDescription("Device groups the given device belongs to. This value will be used to match the correct device group conditional modules to this device. This flag is only relevant if the bundle uses device group targeting and should be set in that case.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(COUNTRY_SET_FLAG.getName()).setExampleValue("country_set_name").setOptional(true).setDescription("Country set for the user account on the device. This value will be used to match the correct country set targeted APKs to this device. This flag is only relevant if the bundle uses country set targeting, and should be set in that case.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADDITIONAL_LOCAL_TESTING_FILES_FLAG.getName()).setOptional(true).setDescription("List of files which will be additionally pushed to local testing folder. This flag is only supported for APKs built in local testing mode.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(TIMEOUT_MILLIS_FLAG.getName()).setExampleValue("60000").setOptional(true).setDescription("Timeout in milliseconds which is passed to adb commands. Default is 10 minutes.").build()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setAdbPath(Path var1);

        public abstract Builder setApksArchivePath(Path var1);

        public abstract Builder setDeviceId(String var1);

        public abstract Builder setModules(ImmutableSet<String> var1);

        public abstract Builder setAllowDowngrade(boolean var1);

        public abstract Builder setAdbServer(AdbServer var1);

        public abstract Builder setAllowTestOnly(boolean var1);

        public abstract Builder setGrantRuntimePermissions(boolean var1);

        public abstract Builder setDeviceTier(Integer var1);

        public abstract Builder setDeviceGroups(ImmutableSet<String> var1);

        public abstract Builder setCountrySet(String var1);

        public abstract Builder setAdditionalLocalTestingFiles(ImmutableList<Path> var1);

        public abstract Builder setTimeout(Duration var1);

        public abstract InstallApksCommand build();
    }
}

