/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Log;
import com.android.ddmlib.SimpleConnectedSocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class SocketChannelWithTimeouts
implements SimpleConnectedSocket {
    private static final String LOG_TAG = "SocketChannelWithTimeouts";
    private final SocketChannel channel;
    private Selector readSelector;
    private Selector writeSelector;

    public static SocketChannelWithTimeouts wrap(SocketChannel channel) throws IOException {
        SocketChannelWithTimeouts wrappedChannel = new SocketChannelWithTimeouts(channel);
        try {
            wrappedChannel.init();
        }
        catch (IOException e11) {
            wrappedChannel.close();
            throw e11;
        }
        return wrappedChannel;
    }

    private SocketChannelWithTimeouts(SocketChannel channel) {
        this.channel = channel;
    }

    private void init() throws IOException {
        if (this.channel.isBlocking()) {
            Log.d(LOG_TAG, "SocketChannel is a blocking channel. Changing it to non-blocking");
            this.channel.configureBlocking(false);
        }
        this.readSelector = Selector.open();
        this.channel.register(this.readSelector, 1);
        this.writeSelector = Selector.open();
        this.channel.register(this.writeSelector, 4);
    }

    @Override
    public int read(ByteBuffer dst, long timeoutMs) throws IOException {
        this.readSelector.select(timeoutMs);
        return this.channel.read(dst);
    }

    @Override
    public int write(ByteBuffer dst, long timeoutMs) throws IOException {
        this.writeSelector.select(timeoutMs);
        return this.channel.write(dst);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        try (SocketChannel c11 = this.channel;
             Selector r11 = this.readSelector;){
            Selector w11 = this.writeSelector;
            if (w11 != null) {
                w11.close();
            }
        }
    }
}

