${setOutputPath(info.packageName?replace(".", "/") + "/" + info.className + "Extension.java")}<#rt>
package ${info.packageName};

<#if info.numMidiInPorts gt 0>
import com.bitwig.extension.api.util.midi.ShortMidiMessage;
import com.bitwig.extension.callback.ShortMidiMessageReceivedCallback;
</#if>
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.Transport;
import com.bitwig.extension.controller.ControllerExtension;

public class ${info.className}Extension extends ControllerExtension
{
   protected ${info.className}Extension(final ${info.className}ExtensionDefinition definition, final ControllerHost host)
   {
      super(definition, host);
   }

   @Override
   public void init()
   {
      final ControllerHost host = getHost();      
<#if info.numMidiInPorts gt 0>

      mTransport = host.createTransport();
   <#list 0..(info.numMidiInPorts - 1) as i>
      host.getMidiInPort(${i}).setMidiCallback((ShortMidiMessageReceivedCallback)msg -> onMidi${i}(msg));
      host.getMidiInPort(${i}).setSysexCallback((String data) -> onSysex${i}(data));
   </#list>
</#if>

      // TODO: Perform your driver initialization here.
      // For now just show a popup notification for verification that it is running.
      host.showPopupNotification("${info.name?j_string} Initialized");
   }

   @Override
   public void exit()
   {
      // TODO: Perform any cleanup once the driver exits
      // For now just show a popup notification for verification that it is no longer running.
      getHost().showPopupNotification("${info.name?j_string} Exited");
   }

   @Override
   public void flush()
   {
      // TODO Send any updates you need here.
   }

<#if info.numMidiInPorts gt 0>
   <#list 0..(info.numMidiInPorts - 1) as i>
   /** Called when we receive short MIDI message on port ${i}. */
   private void onMidi${i}(ShortMidiMessage msg) 
   {
      // TODO: Implement your MIDI input handling code here.
   }

   /** Called when we receive sysex MIDI message on port ${i}. */
   private void onSysex${i}(final String data) 
   {
      <#if i == 0>
      // MMC Transport Controls:
      if (data.equals("f07f7f0605f7"))
            mTransport.rewind();
      else if (data.equals("f07f7f0604f7"))
            mTransport.fastForward();
      else if (data.equals("f07f7f0601f7"))
            mTransport.stop();
      else if (data.equals("f07f7f0602f7"))
            mTransport.play();
      else if (data.equals("f07f7f0606f7"))
            mTransport.record();
      </#if>
   }
   </#list>
</#if>

<#if info.numMidiInPorts gt 0>
   private Transport mTransport;
</#if>
}
