loadAPI(1);
load("bcf_pages.js");
load("bc_stepsequencer.js");

host.defineController("Behringer", "BCF2000", "1.0", "e6fab2e0-5f2e-11e2-bcfd-0800200c9a66");
host.defineMidiPorts(1, 1);
host.addDeviceNameBasedDiscoveryPair(["BCF2000"], ["BCF2000"]);
host.addDeviceNameBasedDiscoveryPair(["BCF2000 port 1"], ["BCF2000 port 1"]);
host.addDeviceNameBasedDiscoveryPair(["BCF2000 port 2"], ["BCF2000 port 2"]);
host.addDeviceNameBasedDiscoveryPair(["BCF2000 port 3"], ["BCF2000 port 3"]);
host.addDeviceNameBasedDiscoveryPair(["BCF2000 Port 1"], ["BCF2000 Port 1"]);
host.addDeviceNameBasedDiscoveryPair(["BCF2000 Port 2"], ["BCF2000 Port 2"]);

for ( var i = 1; i < 9; i++)
{
	var name = i.toString() + "- BCF2000";
	host.addDeviceNameBasedDiscoveryPair([name], [name]);
	host.addDeviceNameBasedDiscoveryPair(["BCF2000 MIDI " + i.toString()], ["BCF2000 MIDI " + i.toString()]);
}

var CC =
{
	CLICKENC0 : 8,
	FADER0 : 81
};

var NOTE =
{
	BUTTONROW_UPPER0 : 65,
	BUTTONROW_LOWER0 : 73,
	CLICKENCBUTTON0 : 33,
	EGBUTTON1 : 57,
	EGBUTTON2 : 58,
	EGBUTTON3 : 59,
	EGBUTTON4 : 60,
	FBUTTON1 : 53,
	FBUTTON2 : 54,
	FBUTTON3 : 55,
	FBUTTON4 : 56,
	PREV_PRESET : 63,
	NEXT_PRESET : 64,
	UBUTTON1 : 49,
	UBUTTON2 : 50,
	UBUTTON3 : 51,
	UBUTTON4 : 52
};

var isShift = false;
var isAlt = false;
var isEncoderClick = initArray(false, 8);

var SYSEX_HDR = "f0 00 20 32 00 14";

var encoderPages = [new EncoderPage(0),new EncoderPage(1),new EncoderPage(2),new EncoderPage(3),new EncoderPage(4),new EncoderPage(5),new EncoderPage(6),new EncoderPage(7)];
var buttonPages = [new ButtonPage(0),new ButtonPage(1),new ButtonPage(2),new ButtonPage(3),new ButtonPage(4)];

var ENCODER_PAGE =
{
	PAN : 0,
	SEND0 : 1,
	SEND1 : 2,
	SEND2 : 3,
	SEND3 : 4,
	SEND4 : 5,
	STEPSEQ : 6,
	DEVICE : 7
};
var BUTTON_PAGE =
{
	SELECT_SOLO : 0,
	ARM_MUTE : 1,
	STEPSEQ : 2,
	DEVICE : 3,
	APP : 4
};

var bcfActiveEncoderPage = ENCODER_PAGE.PAN;
var bcfActiveButtonPage = BUTTON_PAGE.SELECT_SOLO;
var bcfActiveSendPage = ENCODER_PAGE.SEND0;

var lowerRow = 0;
var upperRow = 1;
var numSendPages = 5;
var isPlaybackFollow = false;

var BCFBitwigPreset = "F0 00 20 32 7F 14 20 00 00 24 72 65 76 20 46 31 20 3B 20 46 69 72 6D 77 61 72 65 20 31 2E 31 30 3B 20 42 43 20 4D 61 6E 61 67 65 72 20 32 2E 34 2E 30 F7 F0 00 20 32 7F 14 20 00 01 24 70 72 65 73 65 74 F7 F0 00 20 32 7F 14 20 00 02 20 20 2E 6E 61 6D 65 20 27 62 69 74 77 69 67 54 69 6D 6F 20 20 20 20 20 20 20 20 20 20 20 20 20 20 27 F7 F0 00 20 32 7F 14 20 00 03 20 20 2E 73 6E 61 70 73 68 6F 74 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 04 20 20 2E 72 65 71 75 65 73 74 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 05 20 20 2E 65 67 72 6F 75 70 73 20 31 F7 F0 00 20 32 7F 14 20 00 06 20 20 2E 66 6B 65 79 73 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 07 20 20 2E 6C 6F 63 6B 20 6F 6E F7 F0 00 20 32 7F 14 20 00 08 20 20 2E 69 6E 69 74 F7 F0 00 20 32 7F 14 20 00 09 24 65 6E 63 6F 64 65 72 20 31 F7 F0 00 20 32 7F 14 20 00 0A 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 0B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 0C 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 0D 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 0E 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 0F 24 65 6E 63 6F 64 65 72 20 32 F7 F0 00 20 32 7F 14 20 00 10 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 39 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 11 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 12 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 13 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 14 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 15 24 65 6E 63 6F 64 65 72 20 33 F7 F0 00 20 32 7F 14 20 00 16 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 31 30 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 17 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 18 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 19 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 1A 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 1B 24 65 6E 63 6F 64 65 72 20 34 F7 F0 00 20 32 7F 14 20 00 1C 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 31 31 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 1D 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 1E 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 1F 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 20 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 21 24 65 6E 63 6F 64 65 72 20 35 F7 F0 00 20 32 7F 14 20 00 22 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 31 32 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 23 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 24 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 25 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 26 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 27 24 65 6E 63 6F 64 65 72 20 36 F7 F0 00 20 32 7F 14 20 00 28 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 31 33 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 29 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 2A 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 2B 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 2C 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 2D 24 65 6E 63 6F 64 65 72 20 37 F7 F0 00 20 32 7F 14 20 00 2E 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 31 34 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 2F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 30 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 31 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 32 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 33 24 65 6E 63 6F 64 65 72 20 38 F7 F0 00 20 32 7F 14 20 00 34 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 31 35 20 30 20 31 32 37 20 72 65 6C 61 74 69 76 65 2D 31 F7 F0 00 20 32 7F 14 20 00 35 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 36 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 37 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 38 20 20 2E 64 65 66 61 75 6C 74 20 33 36 F7 F0 00 20 32 7F 14 20 00 39 24 65 6E 63 6F 64 65 72 20 39 F7 F0 00 20 32 7F 14 20 00 3A 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 3B 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 3C 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 3D 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 3E 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 3F 24 65 6E 63 6F 64 65 72 20 31 30 F7 F0 00 20 32 7F 14 20 00 40 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 41 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 42 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 43 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 44 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 45 24 65 6E 63 6F 64 65 72 20 31 31 F7 F0 00 20 32 7F 14 20 00 46 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 47 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 48 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 49 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 4A 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 4B 24 65 6E 63 6F 64 65 72 20 31 32 F7 F0 00 20 32 7F 14 20 00 4C 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 4D 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 4E 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 4F 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 50 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 51 24 65 6E 63 6F 64 65 72 20 31 33 F7 F0 00 20 32 7F 14 20 00 52 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 53 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 54 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 55 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 56 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 57 24 65 6E 63 6F 64 65 72 20 31 34 F7 F0 00 20 32 7F 14 20 00 58 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 59 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 5A 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 5B 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 5C 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 5D 24 65 6E 63 6F 64 65 72 20 31 35 F7 F0 00 20 32 7F 14 20 00 5E 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 5F 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 60 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 61 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 62 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 63 24 65 6E 63 6F 64 65 72 20 31 36 F7 F0 00 20 32 7F 14 20 00 64 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 65 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 66 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 67 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 68 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 69 24 65 6E 63 6F 64 65 72 20 31 37 F7 F0 00 20 32 7F 14 20 00 6A 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 6B 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 6C 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 6D 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 6E 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 6F 24 65 6E 63 6F 64 65 72 20 31 38 F7 F0 00 20 32 7F 14 20 00 70 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 71 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 72 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 73 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 74 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 75 24 65 6E 63 6F 64 65 72 20 31 39 F7 F0 00 20 32 7F 14 20 00 76 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 77 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 78 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 79 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 00 7A 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 00 7B 24 65 6E 63 6F 64 65 72 20 32 30 F7 F0 00 20 32 7F 14 20 00 7C 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 00 7D 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 00 7E 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 00 7F 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 00 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 01 24 65 6E 63 6F 64 65 72 20 32 31 F7 F0 00 20 32 7F 14 20 01 02 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 03 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 04 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 05 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 06 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 07 24 65 6E 63 6F 64 65 72 20 32 32 F7 F0 00 20 32 7F 14 20 01 08 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 09 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 0A 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 0B 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 0C 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 0D 24 65 6E 63 6F 64 65 72 20 32 33 F7 F0 00 20 32 7F 14 20 01 0E 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 0F 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 10 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 11 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 12 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 13 24 65 6E 63 6F 64 65 72 20 32 34 F7 F0 00 20 32 7F 14 20 01 14 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 15 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 16 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 17 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 18 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 19 24 65 6E 63 6F 64 65 72 20 32 35 F7 F0 00 20 32 7F 14 20 01 1A 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 1B 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 1C 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 1D 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 1E 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 1F 24 65 6E 63 6F 64 65 72 20 32 36 F7 F0 00 20 32 7F 14 20 01 20 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 21 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 22 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 23 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 24 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 25 24 65 6E 63 6F 64 65 72 20 32 37 F7 F0 00 20 32 7F 14 20 01 26 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 27 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 28 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 29 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 2A 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 2B 24 65 6E 63 6F 64 65 72 20 32 38 F7 F0 00 20 32 7F 14 20 01 2C 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 2D 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 2E 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 2F 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 30 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 31 24 65 6E 63 6F 64 65 72 20 32 39 F7 F0 00 20 32 7F 14 20 01 32 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 33 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 34 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 35 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 36 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 37 24 65 6E 63 6F 64 65 72 20 33 30 F7 F0 00 20 32 7F 14 20 01 38 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 39 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 3A 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 3B 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 3C 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 3D 24 65 6E 63 6F 64 65 72 20 33 31 F7 F0 00 20 32 7F 14 20 01 3E 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 3F 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 40 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 41 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 42 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 43 24 65 6E 63 6F 64 65 72 20 33 32 F7 F0 00 20 32 7F 14 20 01 44 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 45 20 20 2E 6D 6F 64 65 20 31 32 64 6F 74 F7 F0 00 20 32 7F 14 20 01 46 20 20 2E 72 65 73 6F 6C 75 74 69 6F 6E 20 39 36 20 39 36 20 39 36 20 39 36 F7 F0 00 20 32 7F 14 20 01 47 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 48 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 49 24 62 75 74 74 6F 6E 20 31 F7 F0 00 20 32 7F 14 20 01 4A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 33 33 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 4B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 4C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 4D 24 62 75 74 74 6F 6E 20 32 F7 F0 00 20 32 7F 14 20 01 4E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 33 34 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 4F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 50 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 51 24 62 75 74 74 6F 6E 20 33 F7 F0 00 20 32 7F 14 20 01 52 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 33 35 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 53 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 54 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 55 24 62 75 74 74 6F 6E 20 34 F7 F0 00 20 32 7F 14 20 01 56 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 33 36 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 57 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 58 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 59 24 62 75 74 74 6F 6E 20 35 F7 F0 00 20 32 7F 14 20 01 5A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 33 37 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 5B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 5C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 5D 24 62 75 74 74 6F 6E 20 36 F7 F0 00 20 32 7F 14 20 01 5E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 33 38 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 5F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 60 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 61 24 62 75 74 74 6F 6E 20 37 F7 F0 00 20 32 7F 14 20 01 62 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 33 39 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 63 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 64 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 65 24 62 75 74 74 6F 6E 20 38 F7 F0 00 20 32 7F 14 20 01 66 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 34 30 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 01 67 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 68 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 69 24 62 75 74 74 6F 6E 20 39 F7 F0 00 20 32 7F 14 20 01 6A 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 6B 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 6C 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 01 6D 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 6E 24 62 75 74 74 6F 6E 20 31 30 F7 F0 00 20 32 7F 14 20 01 6F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 70 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 71 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 01 72 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 73 24 62 75 74 74 6F 6E 20 31 31 F7 F0 00 20 32 7F 14 20 01 74 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 75 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 76 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 01 77 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 78 24 62 75 74 74 6F 6E 20 31 32 F7 F0 00 20 32 7F 14 20 01 79 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 7A 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 01 7B 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 01 7C 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 01 7D 24 62 75 74 74 6F 6E 20 31 33 F7 F0 00 20 32 7F 14 20 01 7E 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 01 7F 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 00 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 01 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 02 24 62 75 74 74 6F 6E 20 31 34 F7 F0 00 20 32 7F 14 20 02 03 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 04 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 05 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 06 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 07 24 62 75 74 74 6F 6E 20 31 35 F7 F0 00 20 32 7F 14 20 02 08 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 09 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 0A 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 0B 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 0C 24 62 75 74 74 6F 6E 20 31 36 F7 F0 00 20 32 7F 14 20 02 0D 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 0E 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 0F 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 10 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 11 24 62 75 74 74 6F 6E 20 31 37 F7 F0 00 20 32 7F 14 20 02 12 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 13 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 14 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 15 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 16 24 62 75 74 74 6F 6E 20 31 38 F7 F0 00 20 32 7F 14 20 02 17 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 18 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 19 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 1A 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 1B 24 62 75 74 74 6F 6E 20 31 39 F7 F0 00 20 32 7F 14 20 02 1C 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 1D 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 1E 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 1F 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 20 24 62 75 74 74 6F 6E 20 32 30 F7 F0 00 20 32 7F 14 20 02 21 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 22 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 23 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 24 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 25 24 62 75 74 74 6F 6E 20 32 31 F7 F0 00 20 32 7F 14 20 02 26 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 27 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 28 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 29 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 2A 24 62 75 74 74 6F 6E 20 32 32 F7 F0 00 20 32 7F 14 20 02 2B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 2C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 2D 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 2E 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 2F 24 62 75 74 74 6F 6E 20 32 33 F7 F0 00 20 32 7F 14 20 02 30 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 31 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 32 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 33 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 34 24 62 75 74 74 6F 6E 20 32 34 F7 F0 00 20 32 7F 14 20 02 35 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 36 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 37 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 38 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 39 24 62 75 74 74 6F 6E 20 32 35 F7 F0 00 20 32 7F 14 20 02 3A 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 3B 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 3C 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 3D 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 3E 24 62 75 74 74 6F 6E 20 32 36 F7 F0 00 20 32 7F 14 20 02 3F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 40 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 41 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 42 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 43 24 62 75 74 74 6F 6E 20 32 37 F7 F0 00 20 32 7F 14 20 02 44 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 45 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 46 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 47 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 48 24 62 75 74 74 6F 6E 20 32 38 F7 F0 00 20 32 7F 14 20 02 49 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 4A 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 4B 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 4C 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 4D 24 62 75 74 74 6F 6E 20 32 39 F7 F0 00 20 32 7F 14 20 02 4E 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 4F 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 50 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 51 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 52 24 62 75 74 74 6F 6E 20 33 30 F7 F0 00 20 32 7F 14 20 02 53 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 54 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 55 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 56 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 57 24 62 75 74 74 6F 6E 20 33 31 F7 F0 00 20 32 7F 14 20 02 58 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 59 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 5A 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 5B 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 5C 24 62 75 74 74 6F 6E 20 33 32 F7 F0 00 20 32 7F 14 20 02 5D 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 5E 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 5F 20 20 2E 6D 6F 64 65 20 64 6F 77 6E F7 F0 00 20 32 7F 14 20 02 60 20 20 2E 6D 69 6E 6D 61 78 20 30 20 30 F7 F0 00 20 32 7F 14 20 02 61 24 62 75 74 74 6F 6E 20 33 33 F7 F0 00 20 32 7F 14 20 02 62 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 35 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 63 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 64 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 65 24 62 75 74 74 6F 6E 20 33 34 F7 F0 00 20 32 7F 14 20 02 66 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 36 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 67 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 68 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 69 24 62 75 74 74 6F 6E 20 33 35 F7 F0 00 20 32 7F 14 20 02 6A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 37 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 6B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 6C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 6D 24 62 75 74 74 6F 6E 20 33 36 F7 F0 00 20 32 7F 14 20 02 6E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 38 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 6F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 70 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 71 24 62 75 74 74 6F 6E 20 33 37 F7 F0 00 20 32 7F 14 20 02 72 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 39 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 73 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 74 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 75 24 62 75 74 74 6F 6E 20 33 38 F7 F0 00 20 32 7F 14 20 02 76 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 30 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 77 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 78 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 79 24 62 75 74 74 6F 6E 20 33 39 F7 F0 00 20 32 7F 14 20 02 7A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 31 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 7B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 02 7C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 02 7D 24 62 75 74 74 6F 6E 20 34 30 F7 F0 00 20 32 7F 14 20 02 7E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 32 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 02 7F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 00 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 01 24 62 75 74 74 6F 6E 20 34 31 F7 F0 00 20 32 7F 14 20 03 02 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 33 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 03 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 04 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 05 24 62 75 74 74 6F 6E 20 34 32 F7 F0 00 20 32 7F 14 20 03 06 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 34 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 07 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 08 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 09 24 62 75 74 74 6F 6E 20 34 33 F7 F0 00 20 32 7F 14 20 03 0A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 35 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 0B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 0C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 0D 24 62 75 74 74 6F 6E 20 34 34 F7 F0 00 20 32 7F 14 20 03 0E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 36 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 0F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 10 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 11 24 62 75 74 74 6F 6E 20 34 35 F7 F0 00 20 32 7F 14 20 03 12 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 37 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 13 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 14 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 15 24 62 75 74 74 6F 6E 20 34 36 F7 F0 00 20 32 7F 14 20 03 16 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 38 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 17 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 18 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 19 24 62 75 74 74 6F 6E 20 34 37 F7 F0 00 20 32 7F 14 20 03 1A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 37 39 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 1B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 1C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 1D 24 62 75 74 74 6F 6E 20 34 38 F7 F0 00 20 32 7F 14 20 03 1E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 38 30 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 1F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 20 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 21 24 62 75 74 74 6F 6E 20 34 39 F7 F0 00 20 32 7F 14 20 03 22 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 34 39 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 23 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 24 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 25 24 62 75 74 74 6F 6E 20 35 30 F7 F0 00 20 32 7F 14 20 03 26 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 30 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 27 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 28 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 29 24 62 75 74 74 6F 6E 20 35 31 F7 F0 00 20 32 7F 14 20 03 2A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 31 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 2B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 2C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 2D 24 62 75 74 74 6F 6E 20 35 32 F7 F0 00 20 32 7F 14 20 03 2E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 32 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 2F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 30 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 31 24 62 75 74 74 6F 6E 20 35 33 F7 F0 00 20 32 7F 14 20 03 32 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 33 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 33 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 34 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 35 24 62 75 74 74 6F 6E 20 35 34 F7 F0 00 20 32 7F 14 20 03 36 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 34 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 37 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 38 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 39 24 62 75 74 74 6F 6E 20 35 35 F7 F0 00 20 32 7F 14 20 03 3A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 35 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 3B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 3C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 3D 24 62 75 74 74 6F 6E 20 35 36 F7 F0 00 20 32 7F 14 20 03 3E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 36 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 3F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 40 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 41 24 62 75 74 74 6F 6E 20 35 37 F7 F0 00 20 32 7F 14 20 03 42 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 37 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 43 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 44 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 45 24 62 75 74 74 6F 6E 20 35 38 F7 F0 00 20 32 7F 14 20 03 46 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 38 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 47 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 48 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 49 24 62 75 74 74 6F 6E 20 35 39 F7 F0 00 20 32 7F 14 20 03 4A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 35 39 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 4B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 4C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 4D 24 62 75 74 74 6F 6E 20 36 30 F7 F0 00 20 32 7F 14 20 03 4E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 30 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 4F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 50 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 51 24 62 75 74 74 6F 6E 20 36 31 F7 F0 00 20 32 7F 14 20 03 52 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 31 30 39 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 53 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 54 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 55 24 62 75 74 74 6F 6E 20 36 32 F7 F0 00 20 32 7F 14 20 03 56 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 31 31 30 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 57 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 58 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 59 24 62 75 74 74 6F 6E 20 36 33 F7 F0 00 20 32 7F 14 20 03 5A 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 33 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 5B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 5C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 5D 24 62 75 74 74 6F 6E 20 36 34 F7 F0 00 20 32 7F 14 20 03 5E 20 20 2E 65 61 73 79 70 61 72 20 4E 4F 54 45 20 31 20 36 34 20 31 32 37 20 74 6F 67 67 6C 65 6F 66 66 F7 F0 00 20 32 7F 14 20 03 5F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 60 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 61 24 66 61 64 65 72 20 31 F7 F0 00 20 32 7F 14 20 03 62 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 31 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 03 63 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 64 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 03 65 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 03 66 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 67 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 68 24 66 61 64 65 72 20 32 F7 F0 00 20 32 7F 14 20 03 69 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 32 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 03 6A 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 6B 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 03 6C 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 03 6D 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 6E 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 6F 24 66 61 64 65 72 20 33 F7 F0 00 20 32 7F 14 20 03 70 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 33 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 03 71 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 72 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 03 73 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 03 74 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 75 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 76 24 66 61 64 65 72 20 34 F7 F0 00 20 32 7F 14 20 03 77 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 34 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 03 78 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 79 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 03 7A 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 03 7B 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 03 7C 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 03 7D 24 66 61 64 65 72 20 35 F7 F0 00 20 32 7F 14 20 03 7E 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 35 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 03 7F 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 00 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 04 01 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 04 02 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 03 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 04 04 24 66 61 64 65 72 20 36 F7 F0 00 20 32 7F 14 20 04 05 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 36 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 04 06 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 07 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 04 08 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 04 09 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 0A 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 04 0B 24 66 61 64 65 72 20 37 F7 F0 00 20 32 7F 14 20 04 0C 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 37 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 04 0D 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 0E 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 04 0F 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 04 10 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 11 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 04 12 24 66 61 64 65 72 20 38 F7 F0 00 20 32 7F 14 20 04 13 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 38 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 04 14 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 15 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 04 16 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 04 17 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 18 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 04 19 24 66 61 64 65 72 20 39 F7 F0 00 20 32 7F 14 20 04 1A 20 20 2E 65 61 73 79 70 61 72 20 43 43 20 31 20 38 39 20 30 20 31 32 37 20 61 62 73 6F 6C 75 74 65 F7 F0 00 20 32 7F 14 20 04 1B 20 20 2E 73 68 6F 77 76 61 6C 75 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 1C 20 20 2E 6D 6F 74 6F 72 20 6F 6E F7 F0 00 20 32 7F 14 20 04 1D 20 20 2E 6F 76 65 72 72 69 64 65 20 6D 6F 76 65 F7 F0 00 20 32 7F 14 20 04 1E 20 20 2E 6B 65 79 6F 76 65 72 72 69 64 65 20 6F 66 66 F7 F0 00 20 32 7F 14 20 04 1F 20 20 2E 64 65 66 61 75 6C 74 20 30 F7 F0 00 20 32 7F 14 20 04 20 24 65 6E 64 F7";

function init()
{

	host.getMidiInPort(0).setMidiCallback(onMidi);
	host.getMidiInPort(0).setSysexCallback(onSysex);

	// /////////////////////// ///////////////////////////// host

	transport = host.createTransportSection();
	arranger = host.createArrangerSection(0);
	application = host.createApplicationSection();
	trackBank = host.createTrackBankSection(8, 5, 0);
	cursorTrack = host.createCursorTrackSection(2, 0);
	cursorDevice = host.createCursorDeviceSection(8);
	// groove = host.createGrooveSection();

	// ////////////////////////////////////////////* TRANSPORT */

	transport.addIsPlayingObserver(function(on)
	{
		// setButton(play,on);
	});
	transport.addIsLoopActiveObserver(function(on)
	{
		// setButton(loop,on);
	});
	transport.addIsRecordingObserver(function(on)
	{
		// setButton(record,on);
	});
	transport.addIsWritingArrangerAutomationObserver(function(on)
	{
		// sendNoteOn(0, 61, on ? 127 : 0);
	});
	// transport.addIsWritingClipLauncherAutomationObserver(function (on)
	// {
	// sendNoteOn(0, AUTOMATION.CLIP, on ? 127 : 0);
	// });
	transport.addClickObserver(function(on)
	{
		sendNoteOn(0, 62, on ? 127 : 0);
	});

	// //////////////////////////////////////////// /* GROOVE */
	//
	// groove.getEnabled().addValueDisplayObserver(6, "", function (text)
	// {
	// transportPage.enableGroove.set(0, text.toUpperCase());
	// });
	//
	// groove.getShuffleAmount().addValueDisplayObserver(6, "", transportPage.shuffleAmount.setter(0));
	// groove.getShuffleRate().addValueDisplayObserver(6, "", transportPage.shuffleRate.setter(0));
	// groove.getAccentAmount().addValueDisplayObserver(6, "", transportPage.accentAmount.setter(0));
	// groove.getAccentRate().addValueDisplayObserver(6, "", transportPage.accentRate.setter(0));
	// groove.getAccentPhase().addValueDisplayObserver(6, "", transportPage.accentPhase.setter(0));

	// //////////////////////////////////////////* TRACK BANK */

	for ( var t = 0; t < 8; t++)
	{
		var track = trackBank.getTrack(t);

		track.addVuMeterObserver(15, -1, true, function()
		{
		});

		track.getVolume().addValueObserver(128, makeIndexedFunction(t, function(index, value)
		{
			// encoderPages[ENCODER_PAGE.VOLUME].setEncoder(index, value);
			sendChannelController(0, CC.FADER0 + index, value);
		}));
		track.getVolume().setLabel("V" + (t + 1));
		track.getVolume().setIndication(true);
		track.getPan().addValueObserver(128, makeIndexedFunction(t, function(index, value)
		{
			encoderPages[ENCODER_PAGE.PAN].setEncoder(index, value);
			// println("pan" + value);
		}));
		track.getPan().setLabel("P" + (t + 1));
		track.getSend(0).addValueObserver(128, makeIndexedFunction(t, function(index, value)
		{
			encoderPages[ENCODER_PAGE.SEND0].setEncoder(index, value);
		}));
		track.getSend(1).addValueObserver(128, makeIndexedFunction(t, function(index, value)
		{
			encoderPages[ENCODER_PAGE.SEND1].setEncoder(index, value);
		}));
		track.getSend(2).addValueObserver(128, makeIndexedFunction(t, function(index, value)
		{
			encoderPages[ENCODER_PAGE.SEND2].setEncoder(index, value);
		}));
		track.getSend(3).addValueObserver(128, makeIndexedFunction(t, function(index, value)
		{
			encoderPages[ENCODER_PAGE.SEND3].setEncoder(index, value);
		}));
		track.getSend(4).addValueObserver(128, makeIndexedFunction(t, function(index, value)
		{
			encoderPages[ENCODER_PAGE.SEND4].setEncoder(index, value);
		}));

		track.addIsSelectedObserver(makeIndexedFunction(t, function(col, isSelected)
		{
			// sendNoteOn(0, NOTE.BUTTONROW_LOWER0 + col, isSelected ? 127 :
			// 0);
			buttonPages[BUTTON_PAGE.SELECT_SOLO].setButton(lowerRow, col, isSelected ? 127 : 0);
		}));
		track.getMute().addValueObserver(makeIndexedFunction(t, function(col, on)
		{
			buttonPages[BUTTON_PAGE.ARM_MUTE].setButton(upperRow, col, on ? 127 : 0);
		}));
		track.getSolo().addValueObserver(makeIndexedFunction(t, function(col, on)
		{
			buttonPages[BUTTON_PAGE.SELECT_SOLO].setButton(upperRow, col, on ? 127 : 0);
		}));
		track.getArm().addValueObserver(makeIndexedFunction(t, function(col, on)
		{
			// sendNoteOn(0, NOTE.BUTTONROW_UPPER0 + col, on ? 127 : 0);
			buttonPages[BUTTON_PAGE.ARM_MUTE].setButton(lowerRow, col, on ? 127 : 0);
		}));
	}
	transport.addAutomationOverrideObserver(function(on)
	{
		sendNoteOn(0, NOTE.FBUTTON1, on ? 127 : 0);
	});
	arranger.addPlaybackFollowObserver(function(on)
	{
		sendNoteOn(0, NOTE.FBUTTON3, on ? 127 : 0);
		isPlaybackFollow = on;
	});

	// ///////////////////////////////////////////// /* CURSOR TRACK */

	primaryInstrument = cursorTrack.getPrimaryInstrument();

	/* CURSOR DEVICE */
	cursorDevice.addSelectedPageObserver(0, function(page)
	{
	});
	for ( var p = 0; p < 8; p++)
	{
		// var parameter = cursorDevice.getParameter(p);
		var parameter = primaryInstrument.getMacro(p).getAmount();
		parameter.addValueObserver(128, makeIndexedFunction(p, function(col, value)
		{
			encoderPages[ENCODER_PAGE.DEVICE].setEncoder(col, value);
		}));
		// parameter.setLabel("P" + (p + 1));
	}
	// cursorClip = host.createCursorClipSection(16, 1);
	// cursorClip.addStepDataObserver(seqPage.onStepExists);
	// cursorClip.addPlayingStepObserver(seqPage.onStepPlay);

	initState();
}

/* ----------------------- onMidi ----------------- */

function onMidi(status, data1, data2)
{
//	printMidi(status, data1, data2);
	/* ---------------------- Buttons --- */
	if (isNoteOn(status))
	{

		var button = data1;
		var pressed = data2;

		if (button == NOTE.EGBUTTON1)
		{
			isAlt = pressed > 0;
			if (bcfActiveEncoderPage != ENCODER_PAGE.STEPSEQ) // && bcfActiveEncoderPage != ENCODER_PAGE.DEVICE)
			{
				isAlt ? setButtonPage(BUTTON_PAGE.ARM_MUTE) : setButtonPage(BUTTON_PAGE.SELECT_SOLO);
			}
		}
		else if (button == NOTE.EGBUTTON3)
		{
			isShift = pressed > 0;
		}
		else if (button >= NOTE.CLICKENCBUTTON0 && button < (NOTE.CLICKENCBUTTON0 + 8))
		{
			isEncoderClick[button - NOTE.CLICKENCBUTTON0] = pressed > 0;
		}

		if (pressed > 0) // Check button presses (but not releases) in here
		{
			switch (button)
			{
				case NOTE.EGBUTTON2:
					switchMode();
					break;
				case NOTE.EGBUTTON4:
					application.nextPerspective();
					break;
				case NOTE.FBUTTON1:
					transport.resetAutomationOverrides();
					break;
				case NOTE.FBUTTON2:
					transport.returnToArrangerment();
					break;
				case NOTE.FBUTTON3:
					arranger.togglePlaybackFollow();
					break;
				case NOTE.FBUTTON4:
					break;
				case NOTE.PREV_PRESET:
					flipPage("prev");
					break;
				case NOTE.NEXT_PRESET:
					flipPage("next");
					break;
				case NOTE.UBUTTON1:
					// cursorDevice.selectPrevious();
					trackBank.scrollTracksPageUp();
					break;
				case NOTE.UBUTTON2:
					// cursorDevice.selectNext();
					trackBank.scrollTracksPageDown();
					break;
				case NOTE.UBUTTON3:
					isShift ? application.toggleAutomationEditor() : application.toggleNoteEditor();
					break;
				case NOTE.UBUTTON4:
					isShift ? application.toggleDevices() : application.toggleMixer();
					break;
			}

			if (button >= NOTE.BUTTONROW_UPPER0 && button < NOTE.BUTTONROW_UPPER0 + 8)
			{
				var track = button - NOTE.BUTTONROW_UPPER0;
				getButtonObjPath(track, "upper");

			}
			if (button >= NOTE.BUTTONROW_LOWER0 && button < NOTE.BUTTONROW_LOWER0 + 8)
			{
				var track = button - NOTE.BUTTONROW_LOWER0;
				getButtonObjPath(track, "lower");

			}
		}
		else if (pressed == 0) // Check button releases. important with BCR and
		// BCF because LED state must be set on release
		{
			if (bcfActiveEncoderPage != ENCODER_PAGE.STEPSEQ)// && bcfActiveEncoderPage != ENCODER_PAGE.DEVICE)
			{
				isAlt ? setButtonPage(BUTTON_PAGE.ARM_MUTE) : setButtonPage(BUTTON_PAGE.SELECT_SOLO);
			}
			if (button == NOTE.EGBUTTON2)
			{
				switch (bcfActiveEncoderPage)
				{
					case ENCODER_PAGE.PAN:
						sendNoteOn(0, NOTE.EGBUTTON2, 127);
						break;
					case bcfActiveSendPage:
						sendNoteOn(0, NOTE.EGBUTTON2, 0);
						break;
					case ENCODER_PAGE.STEPSEQ:
						sendNoteOn(0, NOTE.EGBUTTON2, 0);
						break;
					case ENCODER_PAGE.DEVICE:
						sendNoteOn(0, NOTE.EGBUTTON2, 0);
						break;
				}
			}
			else if (button == NOTE.FBUTTON3)
				sendNoteOn(0, NOTE.FBUTTON3, isPlaybackFollow ? 127 : 0);
			else if (button >= NOTE.CLICKENCBUTTON0 && button < (NOTE.CLICKENCBUTTON0 + 8)) encoderPages[bcfActiveEncoderPage].sendEncoderToBControl(button - NOTE.CLICKENCBUTTON0);
		}

	}
	/* encoders */
	if (isChannelController(status))
	{
		var cc = data1;
		var delta = data2;
		var relativeRange = isEncoderClick[cc - CC.CLICKENC0] ? 512 : 128;
		if (delta > 64)
		{
			delta = (-1) * (128 - delta);
		}
		if (cc >= CC.CLICKENC0 && cc < (CC.CLICKENC0 + 8))
		{
			var col = cc - CC.CLICKENC0;

			getEncoderObjectPath("encoder", col).inc(delta, relativeRange);
		}
		if (cc >= CC.FADER0 && cc < (CC.FADER0 + 8))
		{
			var col = cc - CC.FADER0;

			getEncoderObjectPath("fader", col).set(data2, 128);
		}
	}

}

function getEncoderObjectPath(obj, index)
{
	if (bcfActiveEncoderPage == ENCODER_PAGE.PAN)
	{
		switch (obj)
		{
			case "fader":
				return trackBank.getTrack(index).getVolume();
			case "encoder":
				return trackBank.getTrack(index).getPan();

		}
	}
	else if (bcfActiveEncoderPage == bcfActiveSendPage)
	{
		switch (obj)
		{
			case "fader":
				return trackBank.getTrack(index).getVolume();
				break;
			case "encoder":
				return trackBank.getTrack(index).getSend(bcfActiveSendPage - 1);
				break;
		}
	}
	else if (bcfActiveEncoderPage == ENCODER_PAGE.STEPSEQ)
	{
		switch (obj)
		{
			case "fader":
				return trackBank.getTrack(index).getVolume();
				// case 1:
				// return trackBank.getTrack(index).getPan();
				// break;
				// case 2:
				// return trackBank.getTrack(index).getSend(0);
				// break;
			case "encoder":
				return cursorDevice.getParameter(index);

		}
	}

	else if (bcfActiveEncoderPage == ENCODER_PAGE.DEVICE)
	{
		switch (obj)
		{
			case "fader":
				return trackBank.getTrack(index).getVolume();
				// case 1:
				// return trackBank.getTrack(index).getPan();
				// break;
				// case 2:
				// return trackBank.getTrack(index).getSend(0);
				// break;
			case "encoder":
				// return cursorDevice.getParameter(index);
				return primaryInstrument.getMacro(index).getAmount();

		}
	}

}
function getButtonObjPath(track, row)
{
	if (row == "upper")
	{
		switch (bcfActiveEncoderPage)
		{
			case bcfActiveSendPage:
				if (isAlt)
					trackBank.getTrack(track).getMute().toggle();
				else trackBank.getTrack(track).getSolo().toggle();
				break;
			case ENCODER_PAGE.STEPSEQ:
				break;
			case ENCODER_PAGE.DEVICE:
				if (isAlt)
					trackBank.getTrack(track).getMute().toggle();
				else trackBank.getTrack(track).getSolo().toggle();
				break;
			case ENCODER_PAGE.PAN:
				if (isAlt)
					trackBank.getTrack(track).getMute().toggle();
				else trackBank.getTrack(track).getSolo().toggle();
				break;
		}
	}
	else if (row == "lower")
	{
		switch (bcfActiveEncoderPage)
		{
			case ENCODER_PAGE.PAN:
				if (isAlt)
					trackBank.getTrack(track).getArm().toggle();
				else trackBank.getTrack(track).select();
				break;
			case bcfActiveSendPage:
				if (isAlt)
					trackBank.getTrack(track).getArm().toggle();
				else trackBank.getTrack(track).select();
				break;
			case ENCODER_PAGE.STEPSEQ:

				break;
			case ENCODER_PAGE.DEVICE:
				if (isAlt)
					trackBank.getTrack(track).getArm().toggle();
				else trackBank.getTrack(track).select();
				break;
		}
	}

}

function switchMode()
{
	switch (bcfActiveEncoderPage)
	{
		case ENCODER_PAGE.PAN:
			setBcfEncoderPage(bcfActiveSendPage);
			isAlt ? setButtonPage(BUTTON_PAGE.ARM_MUTE) : setButtonPage(BUTTON_PAGE.SELECT_SOLO);
			setIndications("send");
			break;
		// else if (bcfActiveEncoderPage == ENCODER_PAGE.SEND0 || bcfActiveEncoderPage == ENCODER_PAGE.SEND1 || bcfActiveEncoderPage == ENCODER_PAGE.SEND2 || bcfActiveEncoderPage == ENCODER_PAGE.SEND3 || bcfActiveEncoderPage == ENCODER_PAGE.SEND4)

		case bcfActiveSendPage:
			setBcfEncoderPage(ENCODER_PAGE.DEVICE);
			// setButtonPage(BUTTON_PAGE.DEVICE);
			isAlt ? setButtonPage(BUTTON_PAGE.ARM_MUTE) : setButtonPage(BUTTON_PAGE.SELECT_SOLO);
			setIndications("device");
			// setBcfEncoderPage(ENCODER_PAGE.STEPSEQ);
			// setButtonPage(BUTTON_PAGE.STEPSEQ);
			// setIndications("off");
			break;

		case ENCODER_PAGE.STEPSEQ:
			// setBcfEncoderPage(ENCODER_PAGE.DEVICE);
			// setButtonPage(BUTTON_PAGE.DEVICE);
			// setIndications("device");
			break;

		case ENCODER_PAGE.DEVICE:
			setBcfEncoderPage(ENCODER_PAGE.PAN);
			isAlt ? setButtonPage(BUTTON_PAGE.ARM_MUTE) : setButtonPage(BUTTON_PAGE.SELECT_SOLO);
			setIndications("pan");
			break;

		default:
			sendNoteOn(0, NOTE.EGBUTTON2, 0); // all enc_assign off
	}
}

function makeIndexedFunction(index, f)
{
	return function(value)
	{
		f(index, value);
	};
}
function onSysex(data)
{
	printSysex(data);
}
function initState()
{
	// sendSysex(BCFpresetSend);
	// sendSysex(BCFBitwigPreset);
	sendNoteOn(0, NOTE.EGBUTTON2, 127);
	for ( var col = 0; col < 8; col++)
	{
		buttonPages[BUTTON_PAGE.STEPSEQ].setButton(lowerRow, col, 0);
		buttonPages[BUTTON_PAGE.STEPSEQ].setButton(upperRow, col, 0);
		buttonPages[BUTTON_PAGE.DEVICE].setButton(upperRow, col, 0);
		buttonPages[BUTTON_PAGE.DEVICE].setButton(lowerRow, col, 0);
	}
}
function flushLEDs()
{
}

function exit()
{
	setIndications("off");
}
