/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.controller.api.Application;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.ClipLauncherSlot;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class q2x {
    private final OscAddressSpace Ivg;
    private final ControllerHost OSp;
    private final Transport oHp;
    private final OscConnection UB2;
    private final MasterTrack ZAb;
    private final TrackBank lXt;
    private final TrackBank onT;
    private final Application Nyy;
    private final Clip tGb;
    private final Clip Fqp;
    private final CursorTrack QCa;

    public q2x(ControllerHost controllerHost) {
        this.OSp = controllerHost;
        this.Nyy = controllerHost.createApplication();
        this.oHp = controllerHost.createTransport();
        this.oHp.tempo().markInterested();
        this.oHp.isMetronomeEnabled().markInterested();
        this.oHp.isMetronomeEnabled().addValueObserver(this::Ivg);
        this.oHp.isPlaying().markInterested();
        this.oHp.isPlaying().addValueObserver(this::OSp);
        this.oHp.isArrangerRecordEnabled().markInterested();
        this.oHp.isArrangerRecordEnabled().addValueObserver(this::oHp);
        this.oHp.isClipLauncherOverdubEnabled().markInterested();
        this.oHp.isClipLauncherOverdubEnabled().addValueObserver(this::UB2);
        this.oHp.isClipLauncherAutomationWriteEnabled().markInterested();
        this.oHp.isClipLauncherAutomationWriteEnabled().addValueObserver(this::ZAb);
        this.oHp.isArrangerLoopEnabled().markInterested();
        this.oHp.isArrangerLoopEnabled().addValueObserver(this::lXt);
        this.QCa = this.OSp.createCursorTrack(0, 0);
        this.QCa.position().addValueObserver(n2 -> this.ZAb());
        this.QCa.trackType().markInterested();
        this.ZAb = this.OSp.createMasterTrack(100);
        this.lXt = this.OSp.createMainTrackBank(100, 20, 100);
        this.onT = this.OSp.createEffectTrackBank(20, 100);
        this.lXt.itemCount().markInterested();
        this.lXt.sceneBank().itemCount().markInterested();
        this.onT.itemCount().markInterested();
        for (int i2 = 0; i2 < this.lXt.getSizeOfBank(); ++i2) {
            int n3 = i2;
            Track track = (Track)this.lXt.getItemAt(i2);
            track.trackType().markInterested();
            track.mute().addValueObserver(bl2 -> this.Ivg(track, n3));
            track.arm().addValueObserver(bl2 -> this.OSp(track, n3));
            track.solo().addValueObserver(bl2 -> this.oHp(track, n3));
            track.volume().value().addValueObserver(d2 -> this.UB2(track, n3));
            track.pan().value().addValueObserver(d2 -> this.ZAb(track, n3));
        }
        this.tGb = this.OSp.createArrangerCursorClip(1, 1);
        this.Fqp = this.OSp.createLauncherCursorClip(1, 1);
        OscModule oscModule = this.OSp.getOscModule();
        this.Ivg = oscModule.createAddressSpace();
        this.Ivg.registerObjectMethods("/dawctrl", this);
        this.UB2 = oscModule.connectToUdpServer("localhost", 7577, this.Ivg);
        oscModule.createUdpServer(7578, this.Ivg);
    }

    public void Ivg() {
        this.onT();
    }

    private int Ivg(Track track) {
        String string;
        switch (string = track.trackType().get()) {
            case "Group": {
                return 3;
            }
            case "Instrument": {
                return 2;
            }
            case "Audio": {
                return 1;
            }
            case "Hybrid": {
                return 0;
            }
            case "Effect": {
                return 4;
            }
            case "Master": {
                return 5;
            }
        }
        return 0;
    }

    private void Ivg(String string, Object ... objectArray) {
        try {
            this.UB2.sendMessage(string, objectArray);
        }
        catch (IOException iOException) {
            this.OSp.println("Error while sending OSC message to: " + string + "\n" + iOException.getMessage() + "\n");
        }
    }

    private void OSp() {
        this.UB2();
        this.ZAb();
        this.lXt();
        this.UB2(this.ZAb, 0);
        this.ZAb(this.ZAb, 0);
        this.ZAb(this.oHp.isClipLauncherAutomationWriteEnabled().get());
        this.lXt(this.oHp.isArrangerLoopEnabled().get());
        this.Ivg(this.oHp.isMetronomeEnabled().get());
    }

    private void oHp() {
        this.Ivg("/dawctrl/pong", new Object[0]);
    }

    private void Ivg(boolean bl2) {
        this.Ivg("/dawctrl/metronome", bl2 ? 1 : 0);
    }

    private void OSp(boolean bl2) {
        this.Ivg("/dawctrl/play", bl2 ? 1 : 0);
    }

    private void oHp(boolean bl2) {
        this.Ivg("/dawctrl/record", bl2 ? 1 : 0);
    }

    private void UB2(boolean bl2) {
        this.Ivg("/dawctrl/session_record", bl2 ? 1 : 0);
    }

    private void ZAb(boolean bl2) {
        this.Ivg("/dawctrl/session_automation_record", bl2 ? 1 : 0);
    }

    private void lXt(boolean bl2) {
        this.Ivg("/dawctrl/loop", bl2 ? 1 : 0);
    }

    private void UB2() {
        this.Ivg("/dawctrl/size", this.lXt.itemCount().get(), this.lXt.sceneBank().itemCount().get(), this.onT.itemCount().get());
    }

    private void ZAb() {
        int n2 = this.QCa.position().get();
        int n3 = this.Ivg(this.QCa);
        this.Ivg("/dawctrl/track", n3, n2, "");
    }

    private void lXt() {
        this.Ivg("/dawctrl/scene", 0, "");
    }

    private void Ivg(Track track, int n2) {
        int n3 = this.Ivg(track);
        boolean bl2 = track.mute().get();
        this.Ivg("/dawctrl/track/mute", n3, n2, bl2 ? 1 : 0);
    }

    private void OSp(Track track, int n2) {
        int n3 = this.Ivg(track);
        boolean bl2 = track.arm().get();
        this.Ivg("/dawctrl/track/arm", n3, n2, bl2 ? 1 : 0);
    }

    private void oHp(Track track, int n2) {
        int n3 = this.Ivg(track);
        boolean bl2 = track.solo().get();
        this.Ivg("/dawctrl/track/solo", n3, n2, bl2 ? 1 : 0);
    }

    private void UB2(Track track, int n2) {
        int n3 = this.Ivg(track);
        float f2 = (float)track.volume().get();
        this.Ivg("/dawctrl/track/solo", n3, n2, Float.valueOf(f2));
    }

    private void ZAb(Track track, int n2) {
        int n3 = this.Ivg(track);
        float f2 = (float)track.pan().get();
        this.Ivg("/dawctrl/track/pan", n3, n2, Float.valueOf(f2));
    }

    private void onT() {
        this.Ivg("/dawctrl/shutdown", new Object[0]);
    }

    @OscMethod(address="/init")
    public void handleInit() {
        this.OSp();
    }

    @OscMethod(address="/ping")
    public void handlePing() {
        this.oHp();
    }

    @OscMethod(address="/stop/all_clips")
    public void handleStopAllClips() {
        this.ZAb.stop();
    }

    @OscMethod(address="/stop/track")
    public void handleStopTrack(int n2) {
        this.lXt.getChannel(n2).stop();
    }

    @OscMethod(address="/play/scene")
    public void handlePlayScene(int n2) {
        ((ClipLauncherSlot)this.ZAb.clipLauncherSlotBank().getItemAt(n2)).launch();
    }

    @OscMethod(address="/play/clip")
    public void handlePlayClip(int n2, int n3) {
        ((ClipLauncherSlot)this.lXt.getChannel(n2).clipLauncherSlotBank().getItemAt(n3)).launch();
    }

    @OscMethod(address="/stop/clip")
    public void handleStopClip(int n2, int n3) {
        this.lXt.getChannel(n2).stop();
    }

    @OscMethod(address="/undo")
    public void handleUndo() {
        this.Nyy.undo();
    }

    @OscMethod(address="/redo")
    public void handleRedo() {
        this.Nyy.redo();
    }

    @OscMethod(address="/loop")
    public void handleLoop(int n2) {
        this.oHp.isArrangerLoopEnabled().set(n2 != 0);
    }

    @OscMethod(address="/play")
    public void handlePlay() {
        this.oHp.play();
    }

    @OscMethod(address="/record")
    public void handleRecord(int n2) {
        this.oHp.isArrangerRecordEnabled().set(n2 != 0);
    }

    @OscMethod(address="/session_record")
    public void handleSessionRecord(int n2) {
        this.oHp.isClipLauncherOverdubEnabled().set(n2 != 0);
        this.oHp.isClipLauncherAutomationWriteEnabled().set(n2 != 0);
    }

    @OscMethod(address="/metronome")
    public void handleMetronome(int n2) {
        this.oHp.isMetronomeEnabled().set(n2 != 0);
    }

    @OscMethod(address="/stop")
    public void handleStop() {
        this.oHp.stop();
    }

    @OscMethod(address="/scrub")
    public void handleScrub(float f2) {
    }

    @OscMethod(address="/automation")
    public void handleAutomation(int n2) {
        this.oHp.isArrangerAutomationWriteEnabled().set(n2 != 0);
    }

    private Track Ivg(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.lXt.getChannel(n3);
            }
            case 1: {
                return this.lXt.getChannel(n3);
            }
            case 2: {
                return this.lXt.getChannel(n3);
            }
            case 3: {
                return this.lXt.getChannel(n3);
            }
            case 4: {
                return this.onT.getChannel(n3);
            }
            case 5: {
                return this.ZAb;
            }
            case 6: {
                return this.lXt.getChannel(n3);
            }
        }
        this.OSp.println("Received invalid track type: " + n2);
        return null;
    }

    @OscMethod(address="/track/arm")
    public void handleTrackArm(int n2, int n3, int n4) {
        this.Ivg(n2, n3).getArm().set(n4 != 0);
    }

    @OscMethod(address="/track/mute")
    public void handleTrackMute(int n2, int n3, int n4) {
        this.Ivg(n2, n3).getMute().set(n4 != 0);
    }

    @OscMethod(address="/track/solo")
    public void handleTrackSolo(int n2, int n3, int n4) {
        this.Ivg(n2, n3).getSolo().set(n4 != 0);
    }

    @OscMethod(address="/track/volume")
    public void handleTrackVolume(int n2, int n3, float f2) {
        this.Ivg(n2, n3).getVolume().set(f2);
    }

    @OscMethod(address="/track/pan")
    public void handleTrackPan(int n2, int n3, float f2) {
        this.Ivg(n2, n3).getPan().set(f2);
    }

    @OscMethod(address="/tap_tempo")
    public void handleTapTempo() {
        this.oHp.tapTempo();
    }

    @OscMethod(address="/clip/quantize")
    public void handleClipQuantize() {
        this.tGb.quantize(1.0);
        this.Fqp.quantize(1.0);
    }

    @OscMethod(address="/scene/view")
    public void handleSceneView() {
    }

    @OscMethod(address="/track/view")
    public void handleTrackView() {
    }

    @OscMethod(address="/midi_arm_exclusive")
    public void handleMidiArmExclusive() {
        this.QCa.getArm().set(true);
    }

    @OscMethod(address="/track/info")
    public void handleTrackInfo() {
    }
}

