/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.x11_windowing_system;

import com.bitwig.base.geom.vy2;
import com.bitwig.windowing_system.Blg;
import com.bitwig.windowing_system.aIi;
import com.bitwig.x11_windowing_system.X11Display;
import com.bitwig.x11_windowing_system.X11TopLevelWindowHandle;

class X11TextInputSession
implements aIi {
    private final X11Display mDisplay;
    private final Blg mTextInputTarget;
    private final X11TopLevelWindowHandle mWindowHandle;
    private boolean mHasScheduledUpdateToImmWindowPos;
    private boolean mIsCursorPositionValid;
    private int mCursorX;
    private int mCursorY;
    private int mNativeCursorX;
    private int mNativeCursorY;
    private final ccl mCompositionTextBuffer = new aGT(10);

    public X11TextInputSession(X11Display x11Display, Blg blg2) {
        this.mDisplay = x11Display;
        this.mTextInputTarget = blg2;
        this.mWindowHandle = (X11TopLevelWindowHandle)blg2.Ivg();
    }

    @Override
    public Blg getTextInputTarget() {
        return this.mTextInputTarget;
    }

    public X11TopLevelWindowHandle getWindowHandle() {
        return this.mWindowHandle;
    }

    @Override
    public void cursorPositionChanged() {
        assert (bSo.oHp(this.mDisplay.isEventDispatchThread()));
        this.invalidateTextInputCursorPos();
    }

    @Override
    public void areaOnScreenChanged() {
        assert (bSo.oHp(this.mDisplay.isEventDispatchThread()));
        this.invalidateTextInputCursorPos();
    }

    void started() {
        assert (bSo.oHp(this.mDisplay.isEventDispatchThread()));
        this.updateTextInputCursorPos(false);
        this.mNativeCursorX = this.mCursorX;
        this.mNativeCursorY = this.mCursorY;
    }

    void startedOnNativeThread() {
        assert (bSo.oHp(this.mDisplay.Ivg()));
        this.sendTextInputCusorPos();
    }

    private void invalidateTextInputCursorPos() {
        assert (bSo.oHp(this.mDisplay.isEventDispatchThread()));
        if (!this.mHasScheduledUpdateToImmWindowPos) {
            this.mHasScheduledUpdateToImmWindowPos = true;
            this.mDisplay.asyncExec(() -> {
                this.mHasScheduledUpdateToImmWindowPos = false;
                if (this.isActive()) {
                    this.updateTextInputCursorPos(true);
                }
            });
        }
    }

    private void updateTextInputCursorPos(boolean bl2) {
        assert (bSo.oHp(this.mDisplay.isEventDispatchThread()));
        assert (bSo.oHp(this.isActive()));
        int n2 = this.mTextInputTarget.oHp();
        vy2 vy22 = this.mTextInputTarget.Ivg(n2);
        int n3 = (int)vy22.UB2() - this.mWindowHandle.Nyy();
        int n4 = (int)(vy22.ZAb() + vy22.onT() - (long)this.mWindowHandle.onT() + 5L);
        if (!this.mIsCursorPositionValid || n3 != this.mCursorX || n4 != this.mCursorY) {
            this.mCursorX = n3;
            this.mCursorY = n4;
            this.mIsCursorPositionValid = true;
            if (bl2) {
                this.mDisplay.OSp(() -> {
                    assert (bSo.oHp(this.mDisplay.Ivg()));
                    if (!this.isActiveOnNativeThread()) {
                        return;
                    }
                    this.mNativeCursorX = n3;
                    this.mNativeCursorY = n4;
                    this.sendTextInputCusorPos();
                });
            }
        }
    }

    private void sendTextInputCusorPos() {
        assert (bSo.oHp(this.mDisplay.Ivg()));
        assert (bSo.oHp(this.isActiveOnNativeThread()));
        if (bSo.ZAb.OSp()) {
            bSo.ZAb.Ivg("setTextInputScreenCursorPos(" + this.mNativeCursorX + ", " + this.mNativeCursorY + ")");
        }
        this.mDisplay.Ivg(this.mNativeCursorX, this.mNativeCursorY);
    }

    @Override
    public void cancelComposition() {
        assert (bSo.oHp(this.mDisplay.isEventDispatchThread()));
    }

    private void insertText(String string) {
        assert (bSo.oHp(this.mDisplay.Ivg()));
        if (bSo.ZAb.OSp()) {
            bSo.ZAb.Ivg("insertText(" + X11TextInputSession.stringDebugInfo(string) + ")");
        }
        if (X11TextInputSession.hasNullChar(string)) {
            bSo.ZAb.ZAb("Text to insert contains null character: " + X11TextInputSession.stringDebugInfo(string));
            return;
        }
        String string2 = X11TextInputSession.simplifyInternationalChars(string);
        this.mDisplay.asyncExec(() -> {
            if (this.isActive()) {
                this.mTextInputTarget.Ivg(string2);
            }
        });
    }

    private void startComposing() {
        assert (bSo.oHp(this.mDisplay.Ivg()));
        bSo.ZAb.Ivg("startComposing()");
        assert (bSo.oHp(this.mCompositionTextBuffer.Ivg() == 0));
        this.mCompositionTextBuffer.OSp();
        this.sendTextInputCusorPos();
    }

    private void setCompositionText(String string, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        assert (bSo.oHp(this.mDisplay.Ivg()));
        if (bSo.ZAb.OSp()) {
            bSo.ZAb.Ivg("setCompositionText(" + X11TextInputSession.stringDebugInfo(string) + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ")");
        }
        if (n3 > 0) {
            n8 = Syh.Ivg(n2, 0, this.mCompositionTextBuffer.Ivg() - 1);
            n7 = Syh.Ivg(n3, 0, this.mCompositionTextBuffer.Ivg() - n8);
            assert (bSo.oHp(n8 == n2));
            assert (bSo.oHp(n7 == n3));
            this.mCompositionTextBuffer.Ivg(n8, n8 + n7);
        }
        if (string != null) {
            n8 = Syh.Ivg(n2, 0, this.mCompositionTextBuffer.Ivg());
            assert (bSo.oHp(n8 == n2));
            this.mCompositionTextBuffer.Ivg(n8, string);
        }
        String string2 = X11TextInputSession.simplifyInternationalChars(this.mCompositionTextBuffer.toString());
        n7 = (int)string2.codePoints().count();
        int n9 = Syh.Ivg(n4, 0, n7);
        int n10 = Syh.Ivg(n5, 0, n7);
        int n11 = Syh.Ivg(n6, 0, n7 - n10);
        this.mDisplay.asyncExec(() -> {
            if (this.isActive()) {
                if (!string2.isEmpty()) {
                    this.mTextInputTarget.Ivg(string2, n9, n10, n11);
                } else if (this.mTextInputTarget.OSp()) {
                    this.mTextInputTarget.UB2();
                }
            }
        });
    }

    private void endComposing() {
        assert (bSo.oHp(this.mDisplay.Ivg()));
        bSo.ZAb.Ivg("endComposing()");
        this.mCompositionTextBuffer.OSp();
        this.mDisplay.asyncExec(() -> {
            if (this.isActive()) {
                this.mTextInputTarget.UB2();
            }
        });
    }

    private boolean isActive() {
        assert (bSo.oHp(this.mDisplay.isEventDispatchThread()));
        return this.mDisplay.NhN() == this;
    }

    private boolean isActiveOnNativeThread() {
        assert (bSo.oHp(this.mDisplay.Ivg()));
        return this.mDisplay.zEU() == this;
    }

    private static boolean hasNullChar(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\u0000') continue;
            return true;
        }
        return false;
    }

    private static String stringDebugInfo(String string) {
        int n2;
        if (string == null) {
            return "null";
        }
        int[] nArray = string.codePoints().toArray();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\" length = ");
        stringBuilder.append(string.length());
        stringBuilder.append(", chars = [");
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            char c2 = string.charAt(n2);
            stringBuilder.append(c2 & 0xFFFF);
        }
        stringBuilder.append("], codePoints = [");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(nArray[n2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String simplifyInternationalChars(String string) {
        aGT aGT2 = new aGT((int)string.codePoints().count());
        aGT2.Ivg(string);
        aGT2.OSp(8205);
        return aGT2.toString();
    }
}

