/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.document.api.document;

import com.bitwig.base.io.soX;
import com.bitwig.base.io.tSK;
import com.bitwig.extension.api.project.Factory;
import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.mixer.NativeDevice;
import com.bitwig.extension.api.project.mixer.PluginPreset;
import com.bitwig.extension.api.project.mixer.PluginStateID;
import com.bitwig.extension.api.project.parameter.AutomationEvents;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extension.api.project.timeline.AudioClip;
import com.bitwig.extension.api.project.timeline.AudioNote;
import com.bitwig.extension.api.project.timeline.CueMarker;
import com.bitwig.extension.api.project.timeline.InstrumentNote;
import com.bitwig.extension.api.project.timeline.MidiEvent;
import com.bitwig.extension.api.project.timeline.MidiEvents;
import com.bitwig.extension.api.project.timeline.NoteClip;
import com.bitwig.extension.api.project.timeline.TimeSignature;
import com.bitwig.extension.api.project.timeline.WarpMarker;
import com.bitwig.extension.api.project.timeline.WarpMarkers;
import com.bitwig.extension.api.project.track.Track;
import com.bitwig.extension.api.project.track.TrackGroup;
import com.bitwig.flt.device.InvalidDeviceIdException;
import com.bitwig.flt.document.api.document.ApiAudioNoteClipEvent;
import com.bitwig.flt.document.api.document.ApiAudioNoteEvent;
import com.bitwig.flt.document.api.document.ApiAutomationEvents;
import com.bitwig.flt.document.api.document.ApiInstrumentNoteClipEvent;
import com.bitwig.flt.document.api.document.ApiInstrumentNoteEvent;
import com.bitwig.flt.document.api.document.ApiMidiEvent;
import com.bitwig.flt.document.api.document.ApiMidiEvents;
import com.bitwig.flt.document.api.document.ApiNativeDevice;
import com.bitwig.flt.document.api.document.ApiPluginStateID;
import com.bitwig.flt.document.api.document.ApiRelatedObject;
import com.bitwig.flt.document.api.document.ApiSampleReference;
import com.bitwig.flt.document.api.document.ApiTimeSignature;
import com.bitwig.flt.document.api.document.ApiTitledCueMarker;
import com.bitwig.flt.document.api.document.ApiTrack;
import com.bitwig.flt.document.api.document.ApiTrackGroup;
import com.bitwig.flt.document.api.document.ApiVst2Preset;
import com.bitwig.flt.document.api.document.ApiVst3Preset;
import com.bitwig.flt.document.api.document.ApiWarpMarker;
import com.bitwig.flt.document.api.document.ApiWarpMarkers;
import com.bitwig.flt.document.core.master.R1k;
import com.bitwig.flt.document.core.master.X2Z;
import com.bitwig.flt.document.core.master.ZZF;
import com.bitwig.flt.document.core.master.yh2;
import com.bitwig.samplefile.VLQ;
import com.bitwig.samplefile.Xpb;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.UUID;

public class ApiFactory
extends ApiRelatedObject
implements Factory {
    private final ZZF mProject;

    public ApiFactory(ZZF zZF) {
        this.mProject = zZF;
    }

    @Override
    public Track createInstrumentTrack() {
        return (Track)((Object)this.wrap(this.getRootTrackGroup().OSp(VSZ.Ivg), ApiTrack.class));
    }

    private R1k getRootTrackGroup() {
        return this.mProject.ACo();
    }

    @Override
    public Track createAudioTrack() {
        return (Track)((Object)this.wrap(this.getRootTrackGroup().OSp(VSZ.OSp), ApiTrack.class));
    }

    @Override
    public Track createHybridTrack() {
        return (Track)((Object)this.wrap(this.getRootTrackGroup().OSp(VSZ.oHp), ApiTrack.class));
    }

    @Override
    public TrackGroup createTrackGroup() {
        return (TrackGroup)((Object)this.wrap(this.getRootTrackGroup().mhq(), ApiTrackGroup.class));
    }

    @Override
    public NoteClip createNoteClip() {
        PF3 pF3 = PF3.Ivg(0.0, 1.0);
        return (NoteClip)((Object)this.wrap(pF3, ApiInstrumentNoteClipEvent.class));
    }

    @Override
    public AudioClip createAudioClip() {
        fhG fhG2 = fhG.Ivg(0.0, 1.0);
        return (AudioClip)((Object)this.wrap(fhG2, ApiAudioNoteClipEvent.class));
    }

    @Override
    public WarpMarkers createWarpEvents() {
        return new ApiWarpMarkers(new Xpb(32));
    }

    @Override
    public WarpMarker createWarpEvent(double d2, double d3) {
        return new ApiWarpMarker(new VLQ(d2, d3));
    }

    @Override
    public MidiEvents createMidiEvents() {
        return new ApiMidiEvents();
    }

    @Override
    public MidiEvent createMidi1Event(double d2, int n2, int n3, int n4) {
        return new ApiMidiEvent(d2, n2, n3, n4);
    }

    @Override
    public CueMarker createCueMarker(double d2) {
        lTr lTr2 = lTr.UB2(d2);
        return (CueMarker)((Object)this.wrap(lTr2, ApiTitledCueMarker.class));
    }

    @Override
    public NativeDevice createNativeDevice(UUID uUID) {
        try {
            return ApiNativeDevice.create(uUID);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public PluginPreset createVst2DevicePreset(String string, int n2, int n3) {
        return new ApiVst2Preset(string, n2, n3);
    }

    @Override
    public PluginPreset createVst3DevicePreset(String string, byte[] byArray) {
        try {
            ApiVst3Preset apiVst3Preset = new ApiVst3Preset(string, byArray, "");
            return apiVst3Preset;
        }
        catch (InvalidDeviceIdException invalidDeviceIdException) {
            throw new IOException(invalidDeviceIdException);
        }
    }

    @Override
    public PluginPreset createVst3DevicePreset(String string, byte[] byArray, int n2) {
        try {
            ApiVst3Preset apiVst3Preset = new ApiVst3Preset(string, byArray, "", n2);
            return apiVst3Preset;
        }
        catch (InvalidDeviceIdException invalidDeviceIdException) {
            throw new IOException(invalidDeviceIdException);
        }
    }

    @Override
    public AutomationEvents createBooleanAutomationEvents() {
        return new ApiAutomationEvents(Unit.NONE);
    }

    @Override
    public AutomationEvents createIntegerAutomationEvents() {
        return new ApiAutomationEvents(Unit.NONE);
    }

    @Override
    public AutomationEvents createDoubleAutomationEvents(Unit unit) {
        return new ApiAutomationEvents(unit);
    }

    @Override
    public AutomationEvents createTimeSignatureEvents() {
        return new ApiAutomationEvents(Unit.NONE);
    }

    @Override
    public PluginStateID createPluginStateID(String string) {
        return ApiPluginStateID.randomWithExtension(string);
    }

    @Override
    public OutputStream createPluginStateOutput(PluginStateID pluginStateID) {
        File file = ((ApiPluginStateID)pluginStateID).getFile(this.mProject);
        file.getParentFile().mkdirs();
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    @Override
    public InputStream createPluginStateInput(PluginStateID pluginStateID) {
        File file = ((ApiPluginStateID)pluginStateID).getFile(this.mProject);
        return new BufferedInputStream(new FileInputStream(file));
    }

    @Override
    public AudioNote createAudioNote(double d2, double d3, SampleReference sampleReference) {
        X2Z x2Z = (X2Z)((ApiSampleReference)sampleReference).getTarget();
        ESF eSF = ESF.Ivg(d2, Bu.Ivg(d3), x2Z);
        return (AudioNote)((Object)this.wrap(eSF, ApiAudioNoteEvent.class));
    }

    @Override
    public SampleReference createSampleReferenceForLocalFile(File file) {
        return (SampleReference)((Object)this.wrap(X2Z.Ivg(new soX(file)), ApiSampleReference.class));
    }

    @Override
    public InstrumentNote createInstrumentNote(int n2, int n3, double d2, double d3, double d4, double d5) {
        return new ApiInstrumentNoteEvent(n2, n3, d2, d3, d4, d5);
    }

    @Override
    public SampleReference createSampleReferenceForInputStream(InputStream inputStream, String string) {
        File file = this.mProject.Fqp().OSp(string);
        file.getParentFile().mkdirs();
        Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        return this.createSampleReferenceForLocalFile(file);
    }

    @Override
    public SampleReference createSampleReferenceForRelativePath(String string, int n2, int n3, int n4, Collection collection) {
        String string2 = tSK.Ivg(string);
        String string3 = tSK.ZAb(string);
        double d2 = (double)n2 / (double)n3;
        X2Z x2Z = X2Z.Ivg(string2, "", d2, n3, n4);
        yh2 yh22 = yh2.Ivg(string2, x2Z, 0L);
        yh22.OSp(string3);
        return (SampleReference)((Object)this.wrap(x2Z, ApiSampleReference.class));
    }

    @Override
    public SampleReference createSampleReferenceForAbsolutePath(File file, int n2, int n3, int n4) {
        String string = file.getName();
        double d2 = (double)n2 / (double)n3;
        X2Z x2Z = X2Z.Ivg(string, "", d2, n3, n4);
        yh2 yh22 = yh2.Ivg(string, x2Z, 0L);
        yh22.UB2(file.getAbsolutePath());
        return (SampleReference)((Object)this.wrap(x2Z, ApiSampleReference.class));
    }

    @Override
    public TimeSignature createTimeSignature(int n2, int n3, int n4) {
        ApiTimeSignature apiTimeSignature;
        if (n3 == 1) {
            n2 *= 2;
            n3 *= 2;
        }
        if ((apiTimeSignature = new ApiTimeSignature(n2, n3, n4)).getIntValue() == -1) {
            throw new IllegalArgumentException("Invalid time signature " + n2 + "/" + n3 + "," + n4);
        }
        return apiTimeSignature;
    }
}

