/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.document.api.document;

import com.bitwig.base.geom.mKW;
import com.bitwig.base.io.DVl;
import com.bitwig.base.io.soX;
import com.bitwig.base.serial.SerializationException;
import com.bitwig.dawproject.Arrangement;
import com.bitwig.dawproject.BoolParameter;
import com.bitwig.dawproject.Channel;
import com.bitwig.dawproject.ContentType;
import com.bitwig.dawproject.ExpressionType;
import com.bitwig.dawproject.FileReference;
import com.bitwig.dawproject.Interpolation;
import com.bitwig.dawproject.Lane;
import com.bitwig.dawproject.MixerRole;
import com.bitwig.dawproject.Parameter;
import com.bitwig.dawproject.Project;
import com.bitwig.dawproject.RealParameter;
import com.bitwig.dawproject.Referenceable;
import com.bitwig.dawproject.Scene;
import com.bitwig.dawproject.Send;
import com.bitwig.dawproject.TimeSignatureParameter;
import com.bitwig.dawproject.Track;
import com.bitwig.dawproject.Unit;
import com.bitwig.dawproject.device.ClapPlugin;
import com.bitwig.dawproject.device.Compressor;
import com.bitwig.dawproject.device.Device;
import com.bitwig.dawproject.device.EqBand;
import com.bitwig.dawproject.device.Equalizer;
import com.bitwig.dawproject.device.Limiter;
import com.bitwig.dawproject.device.NoiseGate;
import com.bitwig.dawproject.device.Vst2Plugin;
import com.bitwig.dawproject.device.Vst3Plugin;
import com.bitwig.dawproject.timeline.Audio;
import com.bitwig.dawproject.timeline.BoolPoint;
import com.bitwig.dawproject.timeline.Clip;
import com.bitwig.dawproject.timeline.ClipSlot;
import com.bitwig.dawproject.timeline.Clips;
import com.bitwig.dawproject.timeline.Lanes;
import com.bitwig.dawproject.timeline.Marker;
import com.bitwig.dawproject.timeline.Markers;
import com.bitwig.dawproject.timeline.Note;
import com.bitwig.dawproject.timeline.Notes;
import com.bitwig.dawproject.timeline.Point;
import com.bitwig.dawproject.timeline.Points;
import com.bitwig.dawproject.timeline.RealPoint;
import com.bitwig.dawproject.timeline.TimeSignaturePoint;
import com.bitwig.dawproject.timeline.TimeUnit;
import com.bitwig.dawproject.timeline.Timeline;
import com.bitwig.dawproject.timeline.Warp;
import com.bitwig.dawproject.timeline.Warps;
import com.bitwig.flt.device.InvalidDeviceIdException;
import com.bitwig.flt.device.WPD;
import com.bitwig.flt.device.fvK;
import com.bitwig.flt.device.itl;
import com.bitwig.flt.device.rAn;
import com.bitwig.flt.document.api.document.ApiDawProjectImporter$ChannelConsumer;
import com.bitwig.flt.document.api.document.ApiDawProjectImporter$TrackConsumer;
import com.bitwig.flt.document.api.document.TimeTransforms;
import com.bitwig.flt.document.core.iface.JqE;
import com.bitwig.flt.document.core.master.GzT;
import com.bitwig.flt.document.core.master.KCp;
import com.bitwig.flt.document.core.master.R1k;
import com.bitwig.flt.document.core.master.X2Z;
import com.bitwig.flt.document.core.master.XSQ;
import com.bitwig.flt.document.core.master.ZZF;
import com.bitwig.flt.document.core.master.device.BJm;
import com.bitwig.flt.document.core.master.device.JGp;
import com.bitwig.flt.document.core.master.device.QRV;
import com.bitwig.flt.document.core.master.device.tgf;
import com.bitwig.flt.document.core.master.device.ufD;
import com.bitwig.flt.document.core.master.yh2;
import com.bitwig.flt.document.file.qzd;
import com.bitwig.flt.packaging.core.mii;
import com.bitwig.samplefile.Xpb;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

public class ApiDawProjectImporter {
    private final TimeTransforms mTimeTransforms;
    private final ZZF mProject;
    private final Project mDawProject;
    private final Function mStreamProvider;
    private final Map mTrackTrackMap = new HashMap();
    private final Map mChannelTrackMap = new HashMap();
    private fhG mAudioNoteClipEvent;
    private PF3 mInstrumentNoteClipEvent;
    private final Stack mClipRange = new Stack();
    private final Stack mDawClip = new Stack();
    private final Stack mDawClipRange = new Stack();
    private final Stack mDawClipOutsideTimeUnit = new Stack();
    private final Stack mDawClipContentTimeUnit = new Stack();
    private final Stack mTrack = new Stack();
    private final Stack mTimeUnit = new Stack();
    private final Map mParameterMap = new HashMap();
    private Map mRealValueConverters = new HashMap();
    private final Stack mWarps = new Stack();
    private wFb mScene;
    private xl mInstrumentNoteEvent;
    private ESF mAudioNoteEvent;
    private final qzd mProjectDir;
    private static i3i PLUGIN_VALUE_TYPE = i3i.OSp(0.0, 1.0, 0.0);
    private final File mDawProjectParentDir;

    public ApiDawProjectImporter(ZZF zZF, Project project, Function function, File file) {
        Referenceable.setAutoID((boolean)false);
        this.mProject = zZF;
        this.mDawProject = project;
        this.mStreamProvider = function;
        this.mDawProjectParentDir = file;
        this.mProjectDir = this.mProject.Fqp();
        assert (bRI.UB2(this.mProjectDir.Ivg().isDirectory()));
        this.mTimeTransforms = new TimeTransforms(zZF);
    }

    public void convertPhase1() {
        this.importTransport();
        this.createScenes();
        this.importTracks();
    }

    public void convertPhase2() {
        this.forEachTrack(this::importTrackSettings);
        this.forEachChannel(this::importChannelDevices);
        this.forEachChannel(this::importChannelSettings);
        this.importArrangement();
        this.importScenes();
    }

    private void importTransport() {
        if (this.mDawProject.transport == null) {
            return;
        }
        luJ luJ2 = this.mProject.ApA();
        this.importParameter(luJ2.UrB(), (Parameter)this.mDawProject.transport.tempo);
        this.importParameter(luJ2.tuK(), (Parameter)this.mDawProject.transport.timeSignature);
    }

    private void importTracks() {
        this.importTracks(this.mDawProject.structure, this.mProject.ACo());
        this.mProject.oft();
    }

    private void forEachTrack(ApiDawProjectImporter$TrackConsumer apiDawProjectImporter$TrackConsumer) {
        for (Map.Entry entry : this.mTrackTrackMap.entrySet()) {
            apiDawProjectImporter$TrackConsumer.accept((Track)entry.getKey(), ((GzT)entry.getValue()).vol());
        }
    }

    private void forEachChannel(ApiDawProjectImporter$ChannelConsumer apiDawProjectImporter$ChannelConsumer) {
        for (Map.Entry entry : this.mChannelTrackMap.entrySet()) {
            apiDawProjectImporter$ChannelConsumer.accept((Channel)entry.getKey(), ((QKi)entry.getValue()).vol());
        }
    }

    private void importTracks(List list, R1k r1k) {
        for (Lane lane : list) {
            if (lane instanceof Track) {
                Track track = (Track)lane;
                if (!this.shouldCreateTrack(track)) continue;
                this.importTrackToTrackGroup(track, r1k);
                continue;
            }
            if (!(lane instanceof Channel)) continue;
            Channel channel = (Channel)lane;
            this.importChannelToTrackGroup(channel, r1k);
        }
    }

    private void importChannelToTrackGroup(Channel channel, R1k r1k) {
        if (channel.role == MixerRole.MASTER) {
            this.assignChannelToResulting(r1k.SM(), channel);
            return;
        }
        QKi qKi = QKi.rxT();
        qKi.Ivg(VSZ.OSp);
        if (channel.name != null && !channel.name.isEmpty()) {
            qKi.e_(channel.name);
        }
        if (channel.color != null) {
            qKi.Ivg(this.convertColor(channel.color));
        }
        this.assignChannelToResulting(qKi, channel);
        if (channel.role == MixerRole.EFFECT_TRACK) {
            r1k.OSp(Collections.singletonList(qKi), r1k.CsW(), false, null);
        } else if (channel.role != MixerRole.VCA) {
            r1k.UB2(Collections.singletonList(qKi), r1k.HQa(), false, null);
        }
    }

    private boolean shouldCreateTrack(Track track) {
        return track.channel != null || track.tracks != null && !track.tracks.isEmpty();
    }

    private void importTrackToTrackGroup(Track track, R1k r1k) {
        List<Object> list = track.contentType != null ? Arrays.asList(track.contentType) : Collections.emptyList();
        boolean bl2 = list.contains(ContentType.TRACKS);
        if (bl2) {
            R1k r1k2 = this.createGroupTrack();
            if (track.name != null) {
                r1k2.e_(track.name);
            }
            if (track.color != null) {
                r1k2.Ivg(this.convertColor(track.color));
            }
            r1k.UB2(Collections.singletonList(r1k2), r1k.HQa(), false, null);
            this.importTracks(track.tracks, r1k2);
            this.assignTrackToResulting(r1k2.SM(), track);
            return;
        }
        Channel channel = track.channel;
        if (channel == null) {
            QKi qKi = this.createTrack(track);
            r1k.UB2(Collections.singletonList(qKi), r1k.HQa(), false, null);
        } else {
            if (channel.role == MixerRole.MASTER) {
                this.assignTrackToResulting(r1k.SM(), track);
                return;
            }
            if (channel.role == MixerRole.EFFECT_TRACK) {
                QKi qKi = this.createTrack(track);
                r1k.OSp(Collections.singletonList(qKi), r1k.CsW(), false, null);
            } else if (channel.role != MixerRole.VCA) {
                QKi qKi = this.createTrack(track);
                r1k.UB2(Collections.singletonList(qKi), r1k.HQa(), false, null);
            }
        }
    }

    private QKi createTrack(Track track) {
        QKi qKi = QKi.rxT();
        this.assignTrackToResulting(qKi, track);
        if (track.contentType != null) {
            List<ContentType> list = Arrays.asList(track.contentType);
            if (list.contains(ContentType.AUDIO) && list.contains(ContentType.NOTES)) {
                qKi.Ivg(VSZ.oHp);
            } else if (list.contains(ContentType.NOTES)) {
                qKi.Ivg(VSZ.Ivg);
            } else if (list.contains(ContentType.AUDIO)) {
                qKi.Ivg(VSZ.OSp);
            } else {
                qKi.Ivg(VSZ.OSp);
            }
        }
        return qKi;
    }

    private R1k createGroupTrack() {
        R1k r1k = R1k.nzK();
        return r1k;
    }

    private void assignTrackToResulting(QKi qKi, Track track) {
        if (this.mTrackTrackMap.containsKey(track)) {
            throw new IllegalArgumentException("Track already in map.");
        }
        this.mTrackTrackMap.put(track, qKi);
        if (track.channel != null) {
            this.assignChannelToResulting(qKi, track.channel);
        }
    }

    private void assignChannelToResulting(QKi qKi, Channel channel) {
        if (this.mChannelTrackMap.containsKey(channel)) {
            throw new IllegalArgumentException("Channel already in map.");
        }
        this.mChannelTrackMap.put(channel, qKi);
    }

    private void importTrackSettings(Track track, QKi qKi) {
        if (track.name != null) {
            qKi.e_(track.name);
        }
        if (track.comment != null) {
            qKi.QCa(track.comment);
        }
        if (track.color != null) {
            qKi.Ivg(this.convertColor(track.color));
        }
        if (track.loaded != null) {
            qKi.GC2(track.loaded);
        }
        Channel channel = track.channel;
    }

    private void importChannelSettings(Channel channel, QKi qKi) {
        if (channel.solo != null) {
            qKi.Oor().OSp(channel.solo);
        }
        this.importParameter(qKi.Oor().KHP(), (Parameter)channel.volume);
        this.importParameter(qKi.Oor().u2V(), (Parameter)channel.pan);
        this.importParameter(qKi.Oor().LTB(), (Parameter)channel.mute);
        if (channel.sends != null) {
            for (Send send : channel.sends) {
                QKi qKi2 = (QKi)this.mChannelTrackMap.get(send.destination);
                if (qKi2 == null) continue;
                for (qeE qeE2 : qKi.Oor().Vma()) {
                    if (qeE2.nJN() != qKi2) continue;
                    this.importParameter(qeE2.QEM(), (Parameter)send.volume);
                    if (send.enable != null && send.enable.value != null) {
                        qeE2.Ivg(send.enable.value);
                        continue;
                    }
                    qeE2.Ivg(true);
                }
            }
        }
        if (channel.destination != null) {
            QKi qKi3 = (QKi)this.mChannelTrackMap.get(channel.destination);
            if (qKi3 == null) {
                throw new IllegalStateException("destinationTrack is not found for " + channel.destination.id);
            }
            qKi.fSJ().ZAb(qKi3.njS());
        }
    }

    private void importChannelDevices(Channel channel, QKi qKi) {
        if (channel == null || channel.devices == null) {
            return;
        }
        for (Device device : channel.devices) {
            tgf tgf2 = this.importDevice(device);
            if (tgf2 == null) continue;
            qKi.EAT().OSp(tgf2);
            this.importDeviceSettings(device, tgf2);
        }
    }

    private void importDeviceSettings(Device device, tgf tgf2) {
        if (device.enabled != null) {
            this.importParameter(tgf2.aNQ(), (Parameter)device.enabled);
        }
        if (device.loaded != null) {
            tgf2.Ivg(device.loaded);
        }
    }

    private tgf importDevice(Device device) {
        if (device instanceof ClapPlugin) {
            ClapPlugin clapPlugin = (ClapPlugin)device;
            return this.createClapPlugin(clapPlugin);
        }
        if (device instanceof Vst3Plugin) {
            Vst3Plugin vst3Plugin = (Vst3Plugin)device;
            return this.createVst3Plugin(vst3Plugin);
        }
        if (device instanceof Vst2Plugin) {
            Vst2Plugin vst2Plugin = (Vst2Plugin)device;
            return this.createVst2Plugin(vst2Plugin);
        }
        if (device instanceof Equalizer) {
            Equalizer equalizer = (Equalizer)device;
            return this.createEqualizer(equalizer);
        }
        if (device instanceof Limiter) {
            Limiter limiter = (Limiter)device;
            return this.createLimiter(limiter);
        }
        if (device instanceof Compressor) {
            Compressor compressor = (Compressor)device;
            return this.createCompressor(compressor);
        }
        if (device instanceof NoiseGate) {
            NoiseGate noiseGate = (NoiseGate)device;
            return this.createNoiseGate(noiseGate);
        }
        return null;
    }

    private X2Z create(Audio audio) {
        if (audio.file != null) {
            InputStream inputStream;
            File file = this.mProject.Fqp().OSp(audio.file.path);
            if (!file.exists() && (inputStream = (InputStream)this.mStreamProvider.apply(audio.file.path)) != null) {
                this.copyFileToProjectDir(inputStream, file);
            }
            if (file.exists()) {
                return this.createSampleReference(file);
            }
        }
        return null;
    }

    private QRV createVst3Plugin(Vst3Plugin vst3Plugin) {
        if (vst3Plugin.id == null) {
            return null;
        }
        if (vst3Plugin.state == null) {
            return null;
        }
        try {
            Object object;
            WPD wPD = (WPD)fvK.OSp("vst3:" + vst3Plugin.deviceID);
            String string = new File(vst3Plugin.state.path).getName();
            File file = new File(Yx.glf(), string);
            if (!file.exists() && (object = this.resolve(vst3Plugin.state)) != null) {
                this.copyFileToProjectDir((InputStream)object, file);
            }
            object = vst3Plugin.deviceName != null ? vst3Plugin.deviceName : "";
            String string2 = vst3Plugin.pluginVersion != null ? vst3Plugin.pluginVersion : "";
            QRV qRV = QRV.Ivg((String)object, wPD, string2, file);
            for (Parameter parameter : vst3Plugin.automatedParameters) {
                String string3 = "CONTENTS/PID" + Integer.toHexString(parameter.parameterID);
                XSQ xSQ = XSQ.Ivg(qRV, string3, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, xSQ);
            }
            return qRV;
        }
        catch (InvalidDeviceIdException invalidDeviceIdException) {
            throw new IOException(invalidDeviceIdException);
        }
    }

    private JGp createClapPlugin(ClapPlugin clapPlugin) {
        if (clapPlugin.id == null) {
            return null;
        }
        if (clapPlugin.state == null) {
            return null;
        }
        try {
            Object object;
            itl itl2 = (itl)fvK.OSp("clap:" + clapPlugin.deviceID);
            String string = new File(clapPlugin.state.path).getName();
            File file = new File(Yx.glf(), string);
            if (!file.exists() && (object = this.resolve(clapPlugin.state)) != null) {
                this.copyFileToProjectDir((InputStream)object, file);
            }
            object = clapPlugin.deviceName != null ? clapPlugin.deviceName : "";
            String string2 = clapPlugin.pluginVersion != null ? clapPlugin.pluginVersion : "";
            JGp jGp = JGp.Ivg((String)object, itl2, string2, file);
            for (Parameter parameter : clapPlugin.automatedParameters) {
                String string3 = "CONTENTS/PID" + Integer.toHexString(parameter.parameterID);
                XSQ xSQ = XSQ.Ivg(jGp, string3, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, xSQ);
            }
            return jGp;
        }
        catch (InvalidDeviceIdException invalidDeviceIdException) {
            throw new IOException(invalidDeviceIdException);
        }
    }

    private BJm createVst2Plugin(Vst2Plugin vst2Plugin) {
        if (vst2Plugin.id == null) {
            return null;
        }
        if (vst2Plugin.state == null) {
            return null;
        }
        try {
            rAn rAn2 = (rAn)fvK.OSp("vst:" + vst2Plugin.deviceID);
            String string = new File(vst2Plugin.state.path).getName();
            File file = new File(Yx.glf(), string);
            if (!file.exists()) {
                this.copyFileToProjectDir(this.resolve(vst2Plugin.state), file);
            }
            String string2 = vst2Plugin.deviceName != null ? vst2Plugin.deviceName : "";
            int n2 = vst2Plugin.pluginVersion != null ? Integer.parseInt(vst2Plugin.pluginVersion) : 0;
            BJm bJm2 = BJm.Ivg(string2, rAn2, n2, file);
            for (Parameter parameter : vst2Plugin.automatedParameters) {
                String string3 = "CONTENTS/PARAM" + parameter.parameterID;
                XSQ xSQ = XSQ.Ivg(bJm2, string3, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, xSQ);
            }
            return bJm2;
        }
        catch (SerializationException | InvalidDeviceIdException thl2) {
            throw new IOException(thl2);
        }
    }

    private ufD createEqualizer(Equalizer equalizer) {
        try {
            ufD ufD2 = ufD.onT(mii.QkE);
            int n2 = 1;
            for (EqBand eqBand : equalizer.bands) {
                tov tov2 = this.getFilterType(eqBand);
                if (tov2 == null) continue;
                if (eqBand.freq != null) {
                    this.importParameter(ufD2, "FREQ" + n2, (Parameter)eqBand.freq);
                }
                if (eqBand.gain != null) {
                    this.importParameter(ufD2, "GAIN" + n2, (Parameter)eqBand.gain);
                }
                if (eqBand.Q != null) {
                    this.importParameter(ufD2, "Q" + n2, (Parameter)eqBand.Q);
                }
                if (eqBand.enabled != null) {
                    this.importParameter(ufD2, "ENABLE" + n2, (Parameter)eqBand.enabled);
                }
                Kzl kzl = (Kzl)ufD2.JDh("CONTENTS/TYPE" + n2);
                kzl.Ivg(tov2.Ivg());
                if (++n2 <= 8) continue;
                break;
            }
            return ufD2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private ufD createLimiter(Limiter limiter) {
        try {
            ufD ufD2 = ufD.onT(mii.BuB);
            if (limiter.inputGain != null) {
                this.importParameter(ufD2, "GAIN", (Parameter)limiter.inputGain);
            }
            if (limiter.threshold != null) {
                this.importParameter(ufD2, "CEILING", (Parameter)limiter.threshold);
            }
            if (limiter.release != null) {
                this.importParameter(ufD2, "RELEASE", (Parameter)limiter.release);
            }
            return ufD2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private ufD createCompressor(Compressor compressor) {
        try {
            ufD ufD2 = ufD.onT(mii.Lea);
            if (compressor.inputGain != null) {
                this.importParameter(ufD2, "INPUT", (Parameter)compressor.inputGain);
            }
            if (compressor.outputGain != null) {
                this.importParameter(ufD2, "OUTPUT", (Parameter)compressor.outputGain);
            }
            if (compressor.threshold != null) {
                this.importParameter(ufD2, "THRESHOLD", (Parameter)compressor.threshold);
            }
            if (compressor.ratio != null) {
                this.importParameter(ufD2, "RATIO", (Parameter)compressor.ratio);
            }
            if (compressor.attack != null) {
                this.importParameter(ufD2, "ATTACK", (Parameter)compressor.attack);
            }
            if (compressor.release != null) {
                this.importParameter(ufD2, "RELEASE", (Parameter)compressor.release);
            }
            if (compressor.autoMakeup != null) {
                this.importParameter(ufD2, "MAKEUP_GAIN", (Parameter)compressor.autoMakeup);
            }
            return ufD2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private ufD createNoiseGate(NoiseGate noiseGate) {
        try {
            ufD ufD2 = ufD.onT(mii.Pbi);
            if (noiseGate.threshold != null) {
                this.importParameter(ufD2, "THRESHOLD_LEVEL", (Parameter)noiseGate.threshold);
            }
            if (noiseGate.range != null) {
                this.importParameter(ufD2, "DEPTH", (Parameter)noiseGate.range, d2 -> -d2);
            }
            return ufD2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private tov getFilterType(EqBand eqBand) {
        if (eqBand.type == null) {
            return null;
        }
        int n2 = eqBand.order != null ? eqBand.order : 2;
        switch (eqBand.type) {
            case HIGH_PASS: {
                if (n2 >= 8) {
                    return tov.QCa;
                }
                if (n2 >= 6) {
                    return tov.Fqp;
                }
                if (n2 >= 4) {
                    return tov.tGb;
                }
                if (n2 == 1) {
                    return tov.Nyy;
                }
                return tov.onT;
            }
            case LOW_PASS: {
                if (n2 >= 8) {
                    return tov.ZAb;
                }
                if (n2 >= 6) {
                    return tov.UB2;
                }
                if (n2 >= 4) {
                    return tov.oHp;
                }
                if (n2 == 1) {
                    return tov.lXt;
                }
                return tov.OSp;
            }
            case HIGH_SHELF: {
                return tov.Lea;
            }
            case LOW_SHELF: {
                return tov.GXr;
            }
            case BELL: {
                return tov.fjZ;
            }
            case NOTCH: {
                return tov.GC2;
            }
        }
        return null;
    }

    private void importParameter(tgf tgf2, String string, Parameter parameter, DoubleUnaryOperator doubleUnaryOperator) {
        this.mRealValueConverters.put(parameter, doubleUnaryOperator);
        this.importParameter(tgf2, string, parameter);
    }

    private void importParameter(tgf tgf2, String string, Parameter parameter) {
        Zcr zcr = (Zcr)tgf2.JDh("CONTENTS/" + string);
        assert (bRI.UB2(zcr != null));
        this.importParameter(zcr, parameter);
    }

    private void importParameter(Zcr zcr, Parameter parameter) {
        if (parameter == null) {
            return;
        }
        if (zcr instanceof hPY && parameter instanceof BoolParameter) {
            this.importBoolParameter((hPY)zcr, (BoolParameter)parameter);
        } else if (zcr instanceof DMa && parameter instanceof RealParameter) {
            this.importRealParameter((DMa)zcr, (RealParameter)parameter);
        } else if (zcr instanceof ThP && parameter instanceof TimeSignatureParameter) {
            this.importTimeSignatureParameter((ThP)zcr, (TimeSignatureParameter)parameter);
        }
        this.mParameterMap.put(parameter, KCp.Ivg(zcr));
    }

    private void importBoolParameter(hPY hPY2, BoolParameter boolParameter) {
        if (boolParameter.value != null) {
            hPY2.Ivg(boolParameter.value);
        }
    }

    private void importRealParameter(DMa dMa2, RealParameter realParameter) {
        if (realParameter.value != null) {
            DoubleUnaryOperator doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(realParameter);
            double d2 = doubleUnaryOperator != null ? doubleUnaryOperator.applyAsDouble(realParameter.value) : realParameter.value.doubleValue();
            dMa2.GC2(this.convertRealValue(d2, realParameter.unit, dMa2.QPv()));
        }
    }

    private void importTimeSignatureParameter(ThP thP, TimeSignatureParameter timeSignatureParameter) {
        if (timeSignatureParameter.numerator != null && timeSignatureParameter.denominator != null) {
            int n2 = LBs.Ivg(timeSignatureParameter.numerator, timeSignatureParameter.denominator, 16);
            thP.zEU(n2);
        }
    }

    private double convertRealValue(double d2, Unit unit, i3i i3i2) {
        double d3 = unit == Unit.NORMALIZED ? i3i2.OSp(d2) : nRJ.Ivg(d2, this.convertUnit(unit), i3i2.GC2());
        return Syh.OSp(d3, i3i2.lXt(), i3i2.Nyy());
    }

    private BGs convertUnit(Unit unit) {
        if (unit == null) {
            return BGs.Ivg;
        }
        switch (unit) {
            case LINEAR: {
                return BGs.Ivg;
            }
            case NORMALIZED: {
                throw new IllegalStateException("Needs context of value type");
            }
            case PERCENT: {
                return BGs.OSp;
            }
            case DECIBEL: {
                return BGs.UB2;
            }
            case HERTZ: {
                return BGs.onT;
            }
            case SEMITONES: {
                return BGs.Nyy;
            }
            case SECONDS: {
                return BGs.ZAb;
            }
            case BEATS: {
                return BGs.kpx;
            }
            case BPM: {
                return BGs.QCa;
            }
        }
        return BGs.Ivg;
    }

    private void importArrangement() {
        Arrangement arrangement = this.mDawProject.arrangement;
        luJ luJ2 = this.mProject.ApA();
        if (arrangement != null) {
            if (arrangement.tempoAutomation != null) {
                this.importAutomationForAtom(KCp.Ivg(luJ2.UrB()), arrangement.tempoAutomation);
            }
            if (arrangement.timeSignatureAutomation != null) {
                this.importAutomationForAtom(KCp.Ivg(luJ2.tuK()), arrangement.timeSignatureAutomation);
            }
            if (arrangement.markers != null) {
                this.importMarkers(arrangement.markers);
            }
            this.mTimeUnit.push(TimeUnit.BEATS);
            if (arrangement.lanes != null) {
                this.importTimeline((Timeline)arrangement.lanes);
            }
            this.mTimeUnit.pop();
        }
    }

    private double getTimeAsBeats(double d2) {
        if (!this.mTimeUnit.isEmpty() && this.mTimeUnit.peek() == TimeUnit.SECONDS) {
            return this.mProject.Fqp(d2);
        }
        return d2;
    }

    private double getTimeAsSeconds(double d2) {
        if (!this.mTimeUnit.isEmpty() && this.mTimeUnit.peek() == TimeUnit.BEATS) {
            return this.mProject.tGb(d2);
        }
        return d2;
    }

    private double getClipTimeAsBeats(WCT wCT, double d2) {
        if (!this.mDawClipContentTimeUnit.isEmpty() && this.mDawClipContentTimeUnit.peek() == TimeUnit.SECONDS) {
            if (wCT.FvX()) {
                return this.mProject.Fqp(d2);
            }
            double d3 = this.mProject.tGb(wCT.dYG());
            return this.mProject.Fqp(d3 + d2) - wCT.dYG();
        }
        return d2;
    }

    protected void createScenes() {
        if (this.mDawProject.scenes == null) {
            return;
        }
        this.mProject.ACo().eFH(this.mDawProject.scenes.size());
    }

    private void importScenes() {
        if (this.mDawProject.scenes == null) {
            return;
        }
        int n2 = 0;
        for (Scene scene : this.mDawProject.scenes) {
            this.importScene(scene, this.mProject.ACo().rr(n2++));
        }
    }

    private void importScene(Scene scene, wFb wFb2) {
        if (scene.name != null) {
            wFb2.OSp(scene.name);
        }
        if (scene.comment != null) {
            wFb2.Fqp(scene.comment);
        }
        if (scene.color != null) {
            wFb2.UB2(this.convertColor(scene.color));
        }
        this.mScene = wFb2;
        this.mTimeUnit.push(TimeUnit.BEATS);
        this.importTimeline(scene.content);
        this.mTimeUnit.pop();
        this.mScene = null;
    }

    private void importTimeline(Timeline timeline) {
        GzT gzT;
        TimeUnit timeUnit = (TimeUnit)this.mTimeUnit.peek();
        if (timeline.timeUnit != null) {
            this.mTimeUnit.push(timeline.timeUnit);
        }
        if (timeline.track != null && this.shouldCreateTrack(timeline.track)) {
            gzT = (GzT)this.mTrackTrackMap.get(timeline.track);
            if (gzT == null) {
                throw new IOException("Importing timeline to track, but track with id " + timeline.track.id + " not imported yet.");
            }
            this.mTrack.push(gzT.vol());
        }
        if (timeline instanceof Lanes) {
            this.importLanes((Lanes)timeline);
        } else if (timeline instanceof Clips) {
            this.importClips((Clips)timeline);
        } else if (timeline instanceof Markers) {
            this.importMarkers((Markers)timeline);
        } else if (timeline instanceof Warps) {
            gzT = (Warps)timeline;
            this.importWarps((Warps)gzT, timeUnit);
        } else if (timeline instanceof Notes) {
            this.importNotes((Notes)timeline);
        } else if (timeline instanceof Audio) {
            this.importAudio((Audio)timeline);
        } else if (timeline instanceof Points) {
            this.importPoints((Points)timeline);
        } else if (timeline instanceof ClipSlot) {
            this.importClipSlot((ClipSlot)timeline);
        }
        if (timeline.track != null && this.shouldCreateTrack(timeline.track)) {
            this.mTrack.pop();
        }
        if (timeline.timeUnit != null) {
            this.mTimeUnit.pop();
        }
    }

    private void importLanes(Lanes lanes) {
        for (Timeline timeline : lanes.lanes) {
            this.importTimeline(timeline);
        }
    }

    private void importClipSlot(ClipSlot clipSlot) {
        RFq rFq;
        QKi qKi = (QKi)this.mTrack.peek();
        RFq rFq2 = rFq = this.mScene != null && qKi != null ? qKi.oHp(this.mScene.qGa()) : null;
        if (rFq != null) {
            if (clipSlot.hasStop != null) {
                rFq.f_(clipSlot.hasStop);
            }
            if (clipSlot.clip != null) {
                this.importClip(clipSlot.clip);
            }
        }
    }

    private void importClips(Clips clips) {
        for (Clip clip : clips.clips) {
            this.importClip(clip);
        }
    }

    private void importClip(Clip clip) {
        mKW mKW2;
        double d2 = this.getTimeAsBeats(clip.time);
        boolean bl2 = clip.duration != null && clip.duration > 0.0;
        double d3 = bl2 ? this.getTimeAsBeats(clip.time + clip.duration) : this.estimateClipEndTimeFromContent(d2, clip);
        this.mDawClip.push(clip);
        this.mDawClipRange.push(new mKW(d2, d3));
        if (this.mDawClip.size() > 1) {
            mKW2 = this.mClipRange.isEmpty() ? null : (mKW)this.mClipRange.peek();
            mKW mKW3 = mKW2 != null ? new mKW(Math.max(d2, mKW2.Ivg()), Math.min(d3, mKW2.OSp())) : new mKW(d2, d3);
            this.mClipRange.push(mKW3);
        }
        this.mDawClipOutsideTimeUnit.push((TimeUnit)this.mTimeUnit.peek());
        if (clip.contentTimeUnit != null) {
            this.mTimeUnit.push(clip.contentTimeUnit);
        }
        this.mDawClipContentTimeUnit.push((TimeUnit)this.mTimeUnit.peek());
        Object object = mKW2 = clip.content != null ? clip.content : clip.reference;
        if (mKW2 != null) {
            this.importTimeline((Timeline)mKW2);
        }
        if (clip.contentTimeUnit != null) {
            this.mTimeUnit.pop();
        }
        if (this.mDawClip.size() > 1) {
            this.mClipRange.pop();
        }
        this.mDawClip.pop();
        this.mDawClipRange.pop();
        this.mDawClipOutsideTimeUnit.pop();
        this.mDawClipContentTimeUnit.pop();
        this.mAudioNoteEvent = null;
        if (this.mDawClip.isEmpty()) {
            if (this.mInstrumentNoteClipEvent != null) {
                this.addClipToTimelineOrScene(this.mInstrumentNoteClipEvent, clip);
            }
            if (this.mAudioNoteClipEvent != null) {
                this.addClipToTimelineOrScene(this.mAudioNoteClipEvent, clip);
            }
            this.mAudioNoteClipEvent = null;
            this.mInstrumentNoteClipEvent = null;
        }
    }

    private double estimateClipEndTimeFromContent(double d2, Clip clip) {
        double d3 = clip.playStop != null ? clip.playStop : 0.0;
        double d4 = clip.playStart != null ? clip.playStart : 0.0;
        double d5 = d3 - d4;
        if (clip.contentTimeUnit == TimeUnit.SECONDS && !this.mTimeUnit.isEmpty() && this.mTimeUnit.peek() == TimeUnit.BEATS) {
            return this.mProject.Fqp(this.mProject.tGb(d2) + d5);
        }
        return this.getTimeAsBeats(clip.time + d5);
    }

    private void importMarkers(Markers markers) {
        Lzp lzp = this.mProject.ACo().I1P().Hsr();
        this.mTimeUnit.push(markers.timeUnit);
        for (Marker marker : markers.markers) {
            double d2 = Bu.ZAb(this.getTimeAsBeats(marker.time));
            lTr lTr2 = lTr.UB2(d2);
            if (marker.name != null) {
                lTr2.Ivg(marker.name);
            }
            if (marker.color != null) {
                lTr2.Ivg(this.convertColor(marker.color));
            }
            lzp.oHp(lTr2);
        }
        this.mTimeUnit.pop();
    }

    private void importWarps(Warps warps, TimeUnit timeUnit) {
        if (warps.contentTimeUnit == null) {
            throw new DVl("Warps must define a contentTimeUnit");
        }
        if (warps.events == null) {
            throw new DVl("Warps must define events");
        }
        if (warps.events.isEmpty()) {
            throw new DVl("Warps must contain events");
        }
        this.mWarps.push(new atb(warps, timeUnit));
        this.mTimeUnit.push(warps.contentTimeUnit);
        this.importTimeline(warps.content);
        this.mTimeUnit.pop();
        this.mWarps.pop();
    }

    private double localSecondsToBeats(double d2) {
        return this.getTimeAsBeats(d2);
    }

    private void importAudio(Audio audio) {
        ESF eSF;
        double d2;
        Object object;
        Object object2;
        if (this.mDawClip.size() < 1) {
            return;
        }
        if (this.mAudioNoteClipEvent == null) {
            object2 = (Clip)this.mDawClip.get(0);
            object = (mKW)this.mDawClipRange.get(0);
            this.mAudioNoteClipEvent = fhG.Ivg(Bu.ZAb(((mKW)object).Ivg()), Bu.lXt(((mKW)object).ZAb()));
            this.importClipSettings((Clip)object2, this.mAudioNoteClipEvent);
            this.requireTrackForTimeline((Timeline)audio);
        }
        object2 = this.mAudioNoteClipEvent.bkV().OSp(true);
        object = this.createSampleReference(audio);
        if (object == null) {
            return;
        }
        atb atb2 = this.mWarps.isEmpty() ? null : (atb)this.mWarps.peek();
        Warps warps = atb2 != null ? (Warps)atb2.Ivg() : null;
        TimeUnit timeUnit = atb2 != null ? (TimeUnit)atb2.OSp() : null;
        mKW mKW2 = this.mClipRange.isEmpty() ? null : (mKW)this.mClipRange.peek();
        double d3 = mKW2 != null ? mKW2.Ivg() : 0.0;
        double d4 = d2 = mKW2 != null ? mKW2.ZAb() : this.mAudioNoteClipEvent.HQa();
        if (warps != null) {
            double d5 = ((Warp)warps.events.get((int)(warps.events.size() - 1))).time;
            d2 = Math.min(d2, timeUnit == TimeUnit.SECONDS ? this.localSecondsToBeats(d5) : d5);
        }
        this.mAudioNoteEvent = eSF = ESF.Ivg(Bu.ZAb(d3), Bu.lXt(d2), (X2Z)object);
        Clip clip = (Clip)this.mDawClip.peek();
        if (warps != null) {
            Xpb xpb = new Xpb(warps.events.size());
            for (Warp warp : warps.events) {
                xpb.Ivg(timeUnit == TimeUnit.SECONDS ? this.localSecondsToBeats(warp.time) : warp.time, warp.contentTime);
            }
            eSF.cS2().Ivg(xpb);
            eSF.Ivg(G.OSp);
            if (clip.playStart != null) {
                eSF.Fqp(clip.playStart);
            }
        } else {
            eSF.Ivg(G.Ivg);
            if (clip.playStart != null) {
                eSF.Fqp(this.getTimeAsSeconds(clip.playStart));
            }
            if (clip.playStop != null) {
                eSF.Hsr(this.getTimeAsSeconds(clip.playStop));
            }
        }
        if (clip.fadeInTime != null) {
            eSF.Ivg(this.getTimeAsBeats(clip.fadeInTime));
        }
        if (clip.fadeOutTime != null) {
            eSF.oHp(this.getTimeAsBeats(clip.fadeOutTime));
        }
        ((sUk)object2).oHp(eSF);
    }

    private void requireTrackForTimeline(Timeline timeline) {
        if (this.mTrack.isEmpty()) {
            throw new IOException("Importing timeline with id " + timeline.id + " to track, but track is not specified.");
        }
    }

    private X2Z createSampleReference(Audio audio) {
        if (audio.file != null) {
            InputStream inputStream;
            if (audio.file.path == null || audio.file.path.isEmpty()) {
                throw new IOException("FileReference path cannot be empty.");
            }
            if (Boolean.TRUE.equals(audio.file.external)) {
                File file = new File(audio.file.path);
                if (file.isAbsolute()) {
                    return this.createSampleReference(file);
                }
                File file2 = new File(this.mDawProjectParentDir, audio.file.path);
                if (file2.exists()) {
                    return this.createSampleReference(file2);
                }
                return this.createMissingSampleReference(audio);
            }
            File file = this.mProject.Fqp().OSp(audio.file.path);
            if (!file.exists() && (inputStream = this.resolve(audio.file)) != null) {
                this.copyFileToProjectDir(inputStream, file);
            }
            if (file.exists()) {
                return this.createSampleReference(file);
            }
        }
        return null;
    }

    InputStream resolve(FileReference fileReference) {
        return (InputStream)this.mStreamProvider.apply(fileReference.path);
    }

    private void copyFileToProjectDir(InputStream inputStream, File file) {
        assert (bRI.UB2(this.mProject.Fqp().Ivg().exists()));
        assert (bRI.UB2(!file.exists()));
        file.getParentFile().mkdirs();
        Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        inputStream.close();
    }

    private X2Z createSampleReference(File file) {
        return X2Z.Ivg(new soX(file));
    }

    private X2Z createMissingSampleReference(Audio audio) {
        if (audio.file.path == null) {
            return null;
        }
        String string = audio.name != null ? audio.name : new File(audio.file.path).getName();
        X2Z x2Z = X2Z.Ivg(string, "", audio.duration, audio.sampleRate, audio.channels);
        yh2.Ivg(audio.file.path, x2Z, 0L);
        return x2Z;
    }

    private void importNotes(Notes notes) {
        if (this.mDawClip.size() < 1) {
            return;
        }
        if (this.mInstrumentNoteClipEvent == null) {
            Clip clip = (Clip)this.mDawClip.get(0);
            Object object = (mKW)this.mDawClipRange.get(0);
            this.mInstrumentNoteClipEvent = PF3.Ivg(Bu.ZAb(((mKW)object).Ivg()), Bu.lXt(((mKW)object).ZAb()));
            this.importClipSettings(clip, this.mInstrumentNoteClipEvent);
        }
        for (Object object : notes.notes) {
            this.importNote((Note)object);
        }
    }

    private void importNote(Note note) {
        double d2 = this.getTimeAsBeats(note.time);
        double d3 = this.getTimeAsBeats(note.time + note.duration);
        xl xl2 = xl.UB2(Bu.ZAb(d2), Bu.lXt(d3 - d2));
        if (note.velocity != null) {
            xl2.Ivg(note.velocity);
        }
        if (note.releaseVelocity != null) {
            xl2.OSp(note.releaseVelocity);
        }
        this.mInstrumentNoteEvent = xl2;
        if (note.content != null) {
            this.importTimeline(note.content);
        }
        this.mInstrumentNoteEvent = null;
        this.mInstrumentNoteClipEvent.OSp(xl2, null, note.channel, note.key);
    }

    private void addClipToTimelineOrScene(owV owV2, Clip clip) {
        QKi qKi = (QKi)this.mTrack.peek();
        if (qKi != null) {
            if (clip.enable != null) {
                owV2.tGb(clip.enable == false);
            }
            if (this.mScene != null) {
                qKi.oHp(this.mScene.qGa()).OSp((FGC)owV2);
            } else {
                qKi.Nzn().glf().oHp((MFA)owV2);
                List list = owV2.z2R().iIX();
                for (zrd zrd2 : list) {
                    qKi.Ivg(zrd2.Ldm(), owV2, false, true);
                }
            }
        }
    }

    private a1x getArrangement() {
        return this.mProject.ACo().I1P();
    }

    private void importClipSettings(Clip clip, owV owV2) {
        if (clip.name != null) {
            owV2.Ivg(clip.name);
        }
        if (clip.color != null) {
            owV2.UB2(this.convertColor(clip.color));
        }
        if (clip.playStart != null) {
            owV2.R3w(this.getClipTimeAsBeats(owV2, clip.playStart));
        }
        if (clip.loopStart != null) {
            owV2.ktC().zEU(this.getClipTimeAsBeats(owV2, clip.loopStart));
        }
        if (clip.loopEnd != null) {
            owV2.ktC().fjZ(this.getClipTimeAsBeats(owV2, clip.loopEnd));
        }
        if (clip.loopStart != null && clip.loopEnd != null) {
            owV2.Fy(true);
        }
        if (owV2 instanceof fhG) {
            fhG fhG2 = (fhG)owV2;
            if (clip.fadeInTime != null) {
                fhG2.Ivg(clip.fadeInTime);
            }
            if (clip.fadeOutTime != null) {
                fhG2.oHp(clip.fadeOutTime);
            }
        }
    }

    private void importPoints(Points points) {
        h h4 = this.mInstrumentNoteEvent != null ? this.mInstrumentNoteEvent : this.mAudioNoteEvent;
        QKi qKi = this.mTrack.isEmpty() ? null : (QKi)this.mTrack.peek();
        ExpressionType expressionType = points.target.expression;
        if (expressionType != null) {
            if (h4 != null) {
                this.importNoteExpression(points, h4);
            } else if (qKi != null) {
                YrE yrE = qKi.wWL();
                if (expressionType == ExpressionType.CHANNEL_CONTROLLER) {
                    PIB pIB = yrE.Ivg(points.target.channel, iDP.oHp, (int)points.target.controller);
                    this.importAutomationForAtom(KCp.Ivg(pIB), points);
                } else if (expressionType == ExpressionType.CHANNEL_PRESSURE) {
                    PIB pIB = yrE.Ivg(points.target.channel, iDP.OSp, 0);
                    this.importAutomationForAtom(KCp.Ivg(pIB), points);
                } else if (expressionType == ExpressionType.PITCH_BEND) {
                    PIB pIB = yrE.Ivg(points.target.channel, iDP.Ivg, 0);
                    this.importAutomationForAtom(KCp.Ivg(pIB), points);
                }
            }
        } else if (points.target.parameter != null) {
            this.importAutomation(points);
        }
    }

    private void importNoteExpression(Points points, h h4) {
        String string = this.getExpressionName(points.target.expression);
        if (string == null) {
            return;
        }
        uKr uKr2 = h4.uKS().OSp(string, true);
        this.insertPoints(points, uKr2);
    }

    private void importAutomation(Points points) {
        KCp kCp = (KCp)this.mParameterMap.get(points.target.parameter);
        if (kCp == null) {
            return;
        }
        this.importAutomationForAtom(kCp, points);
    }

    private UsN createRealEvent(double d2, double d3, i3i i3i2) {
        if (i3i2 instanceof wJr) {
            return VRT.oHp(Bu.ZAb(d2), d3);
        }
        return UsN.Ivg(Bu.ZAb(d2), d3);
    }

    private void insertPoints(Points points, xFL xFL2) {
        Double d2 = null;
        double d3 = 0.0;
        yV yV2 = xFL2.aH_();
        for (Point point : points.points) {
            Object object;
            TimeSignaturePoint timeSignaturePoint;
            double d4 = this.getTimeAsBeats(point.time);
            if (point instanceof RealPoint) {
                RealPoint realPoint = (RealPoint)point;
                if (yV2 instanceof i3i) {
                    boolean bl2;
                    DoubleUnaryOperator doubleUnaryOperator;
                    timeSignaturePoint = points.unit != null ? points.unit : (points.target.parameter instanceof RealParameter ? ((RealParameter)points.target.parameter).unit : null);
                    i3i i3i2 = (i3i)yV2;
                    object = realPoint.value;
                    if (points.target.parameter instanceof RealParameter && (doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(points.target.parameter)) != null) {
                        object = doubleUnaryOperator.applyAsDouble((Double)object);
                    }
                    double d5 = this.convertRealValue((Double)object, (Unit)timeSignaturePoint, i3i2);
                    boolean bl3 = bl2 = realPoint.interpolation != Interpolation.LINEAR;
                    if (bl2 && d2 != null && d4 > d3) {
                        xFL2.oHp(this.createRealEvent(d4, d2, i3i2));
                    }
                    xFL2.oHp(this.createRealEvent(d4, d5, i3i2));
                    d2 = d5;
                    d3 = d4;
                    continue;
                }
            }
            if (point instanceof TimeSignaturePoint && yV2 instanceof WQW) {
                timeSignaturePoint = (TimeSignaturePoint)point;
                int n2 = LBs.Ivg(timeSignaturePoint.numerator, timeSignaturePoint.denominator, 16);
                object = SXK.Ivg(Bu.ZAb(d4), n2);
                xFL2.oHp((MFA)object);
                continue;
            }
            if (!(point instanceof BoolPoint)) continue;
            timeSignaturePoint = (BoolPoint)point;
            xFL2.Ivg(d4, timeSignaturePoint.value != false ? 1.0 : 0.0, 0.0, -1, (njX)null);
        }
    }

    private void importAutomationForAtom(KCp kCp, Points points) {
        QKi qKi;
        owV owV2 = this.getCurrentClip();
        QKi qKi2 = qKi = this.mTrack.isEmpty() ? kCp.oCu() : (QKi)this.mTrack.peek();
        if (owV2 != null) {
            ArrayList<Double> arrayList = new ArrayList<Double>(points.points.size());
            ArrayList<Double> arrayList2 = new ArrayList<Double>(points.points.size());
            int n2 = 0;
            boolean bl2 = false;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Point point : points.points) {
                if (point instanceof RealPoint) {
                    RealPoint realPoint = (RealPoint)point;
                    double d4 = this.convertRealValue(realPoint.value, points.unit, (i3i)kCp.aH_());
                    if (bl2 && point.time > d3 && d4 != d2) {
                        arrayList.add(point.time);
                        arrayList2.add(d2);
                    }
                    arrayList.add(point.time);
                    arrayList2.add(d4);
                    bl2 = realPoint.interpolation == Interpolation.HOLD;
                    d2 = d4;
                    d3 = point.time;
                }
                ++n2;
            }
            qKi.OSp(kCp, qPw.Ivg, (WCT)owV2, vNl.OSp(arrayList), vNl.OSp(arrayList2), null, null);
        } else {
            qKi.OSp(kCp, qPw.Ivg, false);
            lR lR2 = qKi.OSp((JqE)kCp);
            QKw qKw = lR2.HQa().glf();
            qKw.nmW();
            this.insertPoints(points, qKw);
        }
    }

    private owV getCurrentClip() {
        if (this.mInstrumentNoteClipEvent != null) {
            return this.mInstrumentNoteClipEvent;
        }
        return this.mAudioNoteClipEvent;
    }

    private String getExpressionName(ExpressionType expressionType) {
        switch (expressionType) {
            case GAIN: {
                return "amplitude";
            }
            case PAN: {
                return "panning";
            }
            case TRANSPOSE: {
                return "transpose";
            }
            case TIMBRE: {
                return "timbre";
            }
            case FORMANT: {
                return "formant";
            }
            case PRESSURE: {
                return "pressure";
            }
        }
        return null;
    }

    private TimeUnit getTimeUnit() {
        try {
            return (TimeUnit)this.mTimeUnit.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private QKi getTrack() {
        try {
            return (QKi)this.mTrack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private RjR convertColor(String string) {
        try {
            return RjR.Ivg(string);
        }
        catch (CVd cVd2) {
            cVd2.printStackTrace();
            return RjR.QCa;
        }
    }
}

