/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.document.api.document;

import com.bitwig.dawproject.Arrangement;
import com.bitwig.dawproject.BoolParameter;
import com.bitwig.dawproject.Channel;
import com.bitwig.dawproject.ContentType;
import com.bitwig.dawproject.EnumParameter;
import com.bitwig.dawproject.ExpressionType;
import com.bitwig.dawproject.FileReference;
import com.bitwig.dawproject.IntegerParameter;
import com.bitwig.dawproject.Interpolation;
import com.bitwig.dawproject.MixerRole;
import com.bitwig.dawproject.Parameter;
import com.bitwig.dawproject.Project;
import com.bitwig.dawproject.RealParameter;
import com.bitwig.dawproject.Referenceable;
import com.bitwig.dawproject.Scene;
import com.bitwig.dawproject.Send;
import com.bitwig.dawproject.SendType;
import com.bitwig.dawproject.TimeSignatureParameter;
import com.bitwig.dawproject.Track;
import com.bitwig.dawproject.Transport;
import com.bitwig.dawproject.Unit;
import com.bitwig.dawproject.device.BuiltinDevice;
import com.bitwig.dawproject.device.ClapPlugin;
import com.bitwig.dawproject.device.Compressor;
import com.bitwig.dawproject.device.Device;
import com.bitwig.dawproject.device.DeviceRole;
import com.bitwig.dawproject.device.EqBand;
import com.bitwig.dawproject.device.EqBandType;
import com.bitwig.dawproject.device.Equalizer;
import com.bitwig.dawproject.device.Limiter;
import com.bitwig.dawproject.device.NoiseGate;
import com.bitwig.dawproject.device.Plugin;
import com.bitwig.dawproject.device.Vst2Plugin;
import com.bitwig.dawproject.device.Vst3Plugin;
import com.bitwig.dawproject.timeline.Audio;
import com.bitwig.dawproject.timeline.BoolPoint;
import com.bitwig.dawproject.timeline.Clip;
import com.bitwig.dawproject.timeline.ClipSlot;
import com.bitwig.dawproject.timeline.Clips;
import com.bitwig.dawproject.timeline.EnumPoint;
import com.bitwig.dawproject.timeline.IntegerPoint;
import com.bitwig.dawproject.timeline.Lanes;
import com.bitwig.dawproject.timeline.Marker;
import com.bitwig.dawproject.timeline.Markers;
import com.bitwig.dawproject.timeline.Note;
import com.bitwig.dawproject.timeline.Notes;
import com.bitwig.dawproject.timeline.Points;
import com.bitwig.dawproject.timeline.RealPoint;
import com.bitwig.dawproject.timeline.TimeSignaturePoint;
import com.bitwig.dawproject.timeline.TimeUnit;
import com.bitwig.dawproject.timeline.Timeline;
import com.bitwig.dawproject.timeline.Warp;
import com.bitwig.dawproject.timeline.Warps;
import com.bitwig.flt.document.core.master.Fto;
import com.bitwig.flt.document.core.master.GzT;
import com.bitwig.flt.document.core.master.R1k;
import com.bitwig.flt.document.core.master.X2Z;
import com.bitwig.flt.document.core.master.ZZF;
import com.bitwig.flt.document.core.master.avs;
import com.bitwig.flt.document.core.master.device.BJm;
import com.bitwig.flt.document.core.master.device.D1q;
import com.bitwig.flt.document.core.master.device.HfK;
import com.bitwig.flt.document.core.master.device.JGp;
import com.bitwig.flt.document.core.master.device.QRV;
import com.bitwig.flt.document.core.master.device.aZj;
import com.bitwig.flt.document.core.master.device.tgf;
import com.bitwig.flt.document.core.master.device.ufD;
import com.bitwig.flt.document.core.master.yh2;
import com.bitwig.flt.packaging.core.mii;
import com.bitwig.ramona.core.zin;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;

public class ApiDawProjectExporter {
    private final Map mEmbeddedFiles;
    private final ZZF mSourceProject;
    private Project mProject;
    private final List mAllTracks = new ArrayList();
    private final Map mTrackToTrackMap = new HashMap();
    private final Map mAtomReferences = new HashMap();
    private Map mRealValueConverters = new HashMap();

    public ApiDawProjectExporter(ZZF zZF, Map map) {
        this.mSourceProject = zZF;
        this.mEmbeddedFiles = map;
    }

    public Project convert() {
        Referenceable.setAutoID((boolean)true);
        this.mProject = new Project();
        this.mProject.application.name = "Bitwig Studio";
        this.mProject.application.version = "5.3.13";
        this.createTransport();
        this.createRootTracks();
        this.routeTracks();
        this.createArrangement();
        this.createScenes();
        return this.mProject;
    }

    private void createScenes() {
        for (wFb wFb2 : this.mSourceProject.ACo().DTP()) {
            this.mProject.scenes.add(this.createScene(wFb2));
        }
    }

    private void createTransport() {
        luJ luJ2 = this.mSourceProject.ApA();
        this.mProject.transport = new Transport();
        this.mProject.transport.tempo = (RealParameter)this.createParameter(luJ2.UrB());
        ThP thP = luJ2.tuK();
        this.mProject.transport.timeSignature = (TimeSignatureParameter)this.createParameter(thP);
    }

    private void createRootTracks() {
        R1k r1k = this.mSourceProject.ACo();
        List list = this.mProject.structure;
        for (GzT gzT : r1k.OUx()) {
            Track track;
            if (gzT instanceof QKi) {
                track = this.createTrack((QKi)gzT);
                list.add(track);
                continue;
            }
            if (gzT instanceof R1k) {
                track = this.createGroupTrack((R1k)gzT);
                list.add(track);
                continue;
            }
            throw new IllegalStateException();
        }
        for (GzT gzT : r1k.KdE()) {
            list.add(this.createTrack((QKi)gzT));
        }
        list.add(this.createTrack(r1k.SM()));
    }

    private Track createGroupTrack(R1k r1k) {
        Track track = this.createTrack(r1k.SM());
        track.name = r1k.dJJ();
        track.color = this.getColor(r1k.Sl());
        track.contentType = new ContentType[]{ContentType.TRACKS};
        List list = track.tracks;
        for (GzT gzT : r1k.OUx()) {
            Track track2;
            if (gzT instanceof QKi) {
                track2 = this.createTrack((QKi)gzT);
                list.add(track2);
                continue;
            }
            if (gzT instanceof R1k) {
                track2 = this.createGroupTrack((R1k)gzT);
                list.add(track2);
                continue;
            }
            throw new IllegalStateException();
        }
        for (GzT gzT : r1k.KdE()) {
            list.add(this.createTrack((QKi)gzT));
        }
        assert (bRI.UB2(track.channel.role == MixerRole.MASTER));
        return track;
    }

    private Track createTrack(QKi qKi) {
        ContentType[] contentTypeArray2;
        Track track = new Track();
        track.channel = new Channel();
        this.mTrackToTrackMap.put(qKi, track);
        this.mAllTracks.add(qKi);
        track.name = qKi.dJJ();
        track.comment = qKi.X2n();
        track.color = this.getColor(qKi.Sl());
        track.loaded = qKi.Pbi();
        KkZ kkZ = qKi.Oor();
        track.name = qKi.dJJ();
        track.color = this.getColor(qKi.Sl());
        Channel channel = track.channel;
        channel.volume = (RealParameter)this.createParameter(kkZ.KHP());
        channel.pan = (RealParameter)this.createParameter(kkZ.u2V(), Unit.NORMALIZED);
        channel.mute = (BoolParameter)this.createParameter(kkZ.LTB());
        channel.solo = kkZ.kyS();
        channel.role = qKi.Car() ? MixerRole.MASTER : (qKi.ij2() ? MixerRole.EFFECT_TRACK : MixerRole.REGULAR);
        for (ContentType[] contentTypeArray2 : qKi.EAT().dJJ()) {
            if (channel.devices == null) {
                channel.devices = new ArrayList();
            }
            channel.devices.add(this.createDevice((tgf)contentTypeArray2));
        }
        ContentType[] contentTypeArray3 = new ContentType[]{ContentType.NOTES};
        contentTypeArray2 = new ContentType[]{ContentType.AUDIO};
        ContentType[] contentTypeArray4 = new ContentType[]{ContentType.AUDIO, ContentType.NOTES};
        switch (qKi.onT()) {
            case Ivg: {
                track.contentType = contentTypeArray3;
                break;
            }
            case OSp: {
                track.contentType = contentTypeArray2;
                break;
            }
            case oHp: {
                track.contentType = contentTypeArray4;
            }
        }
        return track;
    }

    private void routeTracks() {
        for (QKi qKi : this.mAllTracks) {
            this.routeTrack(qKi);
        }
    }

    private void routeTrack(QKi qKi) {
        int n2;
        QKi qKi2;
        Track track = (Track)this.mTrackToTrackMap.get(qKi);
        Channel channel = track.channel;
        WSK wSK = qKi.fSJ().zoh();
        QKi qKi3 = qKi2 = wSK != null ? wSK.Sl() : null;
        if (qKi2 != null) {
            Track track2 = (Track)this.mTrackToTrackMap.get(qKi2);
            channel.destination = track2.channel;
        }
        if ((n2 = qKi.Oor().rr()) > 0) {
            channel.sends = new ArrayList();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            qeE qeE2 = qKi.Oor().UB2(i2);
            Send send = new Send();
            send.volume = (RealParameter)this.createParameter(qeE2.QEM());
            QKi qKi4 = qeE2.nJN().vol();
            send.destination = ((Track)this.mTrackToTrackMap.get((Object)qKi4)).channel;
            if (!qeE2.UB2()) {
                send.enable = new BoolParameter();
                send.enable.value = false;
            }
            send.type = this.getEffectiveSendMode(qeE2);
            channel.sends.add(send);
        }
    }

    Parameter createParameter(Zcr zcr) {
        return this.createParameter(zcr, null);
    }

    Parameter createParameter(Zcr zcr, Unit unit, DoubleUnaryOperator doubleUnaryOperator) {
        Parameter parameter = this.createParameterOfType(zcr, unit, doubleUnaryOperator);
        parameter.name = this.nullIfEmpty(zcr.R3w());
        this.mAtomReferences.put(zcr, parameter);
        return parameter;
    }

    Parameter createParameter(Zcr zcr, Unit unit) {
        Parameter parameter = this.createParameterOfType(zcr, unit, null);
        parameter.name = this.nullIfEmpty(zcr.R3w());
        this.mAtomReferences.put(zcr, parameter);
        return parameter;
    }

    private Parameter createParameterOfType(Zcr zcr, Unit unit, DoubleUnaryOperator doubleUnaryOperator) {
        if (zcr instanceof hPY) {
            BoolParameter boolParameter = new BoolParameter();
            boolParameter.value = ((hPY)zcr).Ivg();
            return boolParameter;
        }
        if (zcr instanceof DMa) {
            RealParameter realParameter = new RealParameter();
            if (doubleUnaryOperator != null) {
                this.mRealValueConverters.put(realParameter, doubleUnaryOperator);
            }
            this.assignUnitAndValue((DMa)zcr, realParameter, unit);
            return realParameter;
        }
        if (zcr instanceof HfK) {
            RealParameter realParameter = new RealParameter();
            HfK hfK = (HfK)zcr;
            realParameter.value = hfK.HWM();
            realParameter.min = 0.0;
            realParameter.max = 1.0;
            realParameter.unit = Unit.NORMALIZED;
            realParameter.parameterID = hfK.UB2();
            return realParameter;
        }
        if (zcr instanceof Kzl) {
            EnumParameter enumParameter = new EnumParameter();
            enumParameter.value = ((Kzl)zcr).UB2();
            rNz rNz2 = ((Kzl)zcr).Reh();
            enumParameter.count = rNz2.Nyy();
            enumParameter.labels = rNz2.QCa();
            return enumParameter;
        }
        if (zcr instanceof psQ) {
            IntegerParameter integerParameter = new IntegerParameter();
            integerParameter.value = ((psQ)zcr).tDu();
            integerParameter.min = ((psQ)zcr).QPv().UB2();
            integerParameter.max = ((psQ)zcr).QPv().lXt();
            return integerParameter;
        }
        if (zcr instanceof ThP) {
            TimeSignatureParameter timeSignatureParameter = new TimeSignatureParameter();
            ThP thP = (ThP)zcr;
            timeSignatureParameter.numerator = thP.Nyy();
            timeSignatureParameter.denominator = thP.Fqp();
            return timeSignatureParameter;
        }
        if (zcr == null) {
            throw new NullPointerException();
        }
        throw new zin(zcr.getClass().getName());
    }

    private void assignUnitAndValue(DMa dMa2, RealParameter realParameter, Unit unit) {
        i3i i3i2 = dMa2.QPv();
        if (unit != null) {
            realParameter.unit = unit;
        } else {
            switch (i3i2.GC2()) {
                case OSp: {
                    realParameter.unit = Unit.DECIBEL;
                    break;
                }
                case oHp: 
                case Nyy: {
                    realParameter.unit = Unit.SEMITONES;
                    break;
                }
                default: {
                    realParameter.unit = Unit.LINEAR;
                }
            }
            if (realParameter.unit == Unit.LINEAR) {
                switch (i3i2.zvj()) {
                    case kpx: {
                        realParameter.unit = Unit.BEATS;
                        break;
                    }
                    case QCa: {
                        realParameter.unit = Unit.BPM;
                        break;
                    }
                    case ZAb: {
                        realParameter.unit = Unit.SECONDS;
                        break;
                    }
                    case onT: {
                        realParameter.unit = Unit.HERTZ;
                    }
                }
            }
        }
        DoubleUnaryOperator doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(realParameter);
        realParameter.value = this.convertValue(doubleUnaryOperator, dMa2.Ivg(), i3i2, realParameter.unit);
        realParameter.min = this.convertValue(doubleUnaryOperator, i3i2.lXt(), i3i2, realParameter.unit);
        realParameter.max = this.convertValue(doubleUnaryOperator, i3i2.Nyy(), i3i2, realParameter.unit);
    }

    private BGs convertUnit(Unit unit) {
        if (unit == null) {
            return BGs.Ivg;
        }
        switch (unit) {
            case LINEAR: 
            case NORMALIZED: {
                return BGs.Ivg;
            }
            case PERCENT: {
                return BGs.OSp;
            }
            case DECIBEL: {
                return BGs.UB2;
            }
            case HERTZ: {
                return BGs.onT;
            }
            case SEMITONES: {
                return BGs.Nyy;
            }
            case SECONDS: {
                return BGs.ZAb;
            }
            case BEATS: {
                return BGs.kpx;
            }
            case BPM: {
                return BGs.QCa;
            }
        }
        return null;
    }

    private double convertValue(DoubleUnaryOperator doubleUnaryOperator, double d2, i3i i3i2, Unit unit) {
        jNY jNY2 = i3i2.GC2();
        if (unit == Unit.NORMALIZED) {
            double d3 = i3i2.Ivg(d2);
            assert (bRI.UB2(Double.isFinite(d3)));
            if (doubleUnaryOperator != null) {
                return doubleUnaryOperator.applyAsDouble(d3);
            }
            return d3;
        }
        BGs bGs2 = this.convertUnit(unit);
        double d4 = nRJ.Ivg(d2, jNY2, bGs2);
        assert (bRI.UB2(Double.isFinite(d4)));
        if (doubleUnaryOperator != null) {
            return doubleUnaryOperator.applyAsDouble(d4);
        }
        return d4;
    }

    private void createArrangement() {
        Lanes lanes;
        Arrangement arrangement = new Arrangement();
        arrangement.lanes = lanes = new Lanes();
        lanes.timeUnit = TimeUnit.BEATS;
        for (QKi qKi : this.mAllTracks) {
            Lanes lanes2 = new Lanes();
            lanes2.track = (Track)this.mTrackToTrackMap.get(qKi);
            lanes.lanes.add(lanes2);
            Clips clips = new Clips();
            lanes2.lanes.add(clips);
            NcB ncB2 = qKi.Nzn();
            for (sAG sAG2 : ncB2.glf().fb_()) {
                clips.clips.add(this.createArrangerClip((owV)sAG2));
            }
            for (sAG sAG2 : ncB2.zRD()) {
                Zcr zcr = ((neB)sAG2).Sl();
                Points points = this.createPoints((Mx)sAG2);
                if (points == null) continue;
                if (zcr == this.mSourceProject.ApA().UrB()) {
                    arrangement.tempoAutomation = points;
                    continue;
                }
                if (zcr == this.mSourceProject.ApA().tuK()) {
                    arrangement.timeSignatureAutomation = points;
                    continue;
                }
                if (points.target.parameter == null && points.target.expression == null) continue;
                lanes2.lanes.add(points);
            }
        }
        arrangement.markers = this.createCueMarkers();
        this.mProject.arrangement = arrangement;
    }

    private Scene createScene(wFb wFb2) {
        Scene scene = new Scene();
        scene.name = this.nullIfEmpty(wFb2.ZAb());
        scene.color = this.getColor(wFb2.cS2());
        scene.comment = wFb2.HZb();
        Lanes lanes = new Lanes();
        scene.content = lanes;
        int n2 = wFb2.qGa();
        for (QKi qKi : this.mAllTracks) {
            RFq rFq = qKi.oHp(n2);
            ClipSlot clipSlot = new ClipSlot();
            clipSlot.track = (Track)this.mTrackToTrackMap.get(qKi);
            clipSlot.hasStop = rFq.Fqp();
            lanes.lanes.add(clipSlot);
            owV owV2 = rFq.QEM();
            if (owV2 == null) continue;
            clipSlot.clip = this.createClip(owV2);
            this.addClipAutomation(clipSlot.clip, owV2);
        }
        return scene;
    }

    private Points createPoints(Mx mx2) {
        Zcr zcr = mx2.Sl();
        if (zcr instanceof PIB) {
            PIB pIB = (PIB)zcr;
            iDP iDP2 = pIB.nzK();
            Points points = this.createPoints(mx2.glf(), Unit.NORMALIZED, null);
            switch (iDP2) {
                case oHp: {
                    points.target.expression = ExpressionType.CHANNEL_CONTROLLER;
                    points.target.controller = pIB.QPv();
                    break;
                }
                case OSp: {
                    points.target.expression = ExpressionType.CHANNEL_PRESSURE;
                    break;
                }
                case Ivg: {
                    points.target.expression = ExpressionType.PITCH_BEND;
                }
            }
            points.target.channel = pIB.UB2();
            points.unit = Unit.NORMALIZED;
            return points;
        }
        Parameter parameter = this.getParameter(zcr);
        if (parameter == null) {
            return null;
        }
        DoubleUnaryOperator doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(parameter);
        Points points = this.createPoints(mx2.glf(), this.getUnit(parameter), doubleUnaryOperator);
        points.target.parameter = parameter;
        return points;
    }

    private Unit getUnit(Parameter parameter) {
        if (parameter instanceof RealParameter) {
            return ((RealParameter)parameter).unit;
        }
        return null;
    }

    private Points createPoints(xFL xFL2, Unit unit, DoubleUnaryOperator doubleUnaryOperator) {
        Points points = new Points();
        yV yV2 = xFL2.aH_();
        points.unit = unit;
        for (mId mId2 : xFL2.fb_()) {
            Object object;
            if (mId2 instanceof UsN) {
                object = new RealPoint();
                ((RealPoint)object).time = mId2.dYG();
                double d2 = this.convertValue(doubleUnaryOperator, ((UsN)mId2).Ivg(), (i3i)yV2, unit);
                ((RealPoint)object).value = d2;
                ((RealPoint)object).interpolation = Interpolation.LINEAR;
                points.points.add(object);
                continue;
            }
            if (mId2 instanceof F3C) {
                object = new BoolPoint();
                ((BoolPoint)object).time = mId2.dYG();
                ((BoolPoint)object).value = ((F3C)mId2).lXt();
                points.points.add(object);
                continue;
            }
            if (mId2 instanceof OGh) {
                object = (OGh)mId2;
                EnumPoint enumPoint = new EnumPoint();
                rNz rNz2 = (rNz)((mId)object).EN();
                enumPoint.time = mId2.dYG();
                enumPoint.value = rNz2.OSp(((GAr)object).x3R());
                points.points.add(enumPoint);
                continue;
            }
            if (mId2 instanceof ZHd) {
                object = new IntegerPoint();
                ((IntegerPoint)object).time = mId2.dYG();
                ((IntegerPoint)object).value = ((ZHd)mId2).rr();
                points.points.add(object);
                continue;
            }
            if (!(mId2 instanceof SXK)) continue;
            object = new TimeSignaturePoint();
            ((TimeSignaturePoint)object).time = mId2.dYG();
            SXK sXK = (SXK)mId2;
            ((TimeSignaturePoint)object).numerator = sXK.Nyy();
            ((TimeSignaturePoint)object).denominator = sXK.tGb();
            points.points.add(object);
        }
        return points;
    }

    private Parameter getParameter(Zcr zcr) {
        return (Parameter)this.mAtomReferences.get(zcr);
    }

    private Markers createCueMarkers() {
        Lzp lzp = this.mSourceProject.ACo().I1P().Hsr();
        if (lzp.rr() == 0) {
            return null;
        }
        Markers markers = new Markers();
        for (lTr lTr2 : lzp.fb_()) {
            Marker marker = new Marker();
            marker.time = lTr2.dYG();
            marker.name = this.nullIfEmpty(lTr2.Ivg());
            marker.color = this.getColor(lTr2.ZAb());
            markers.markers.add(marker);
        }
        return markers;
    }

    private String getColor(RjR rjR2) {
        return rjR2.kpx() ? null : rjR2.NhN();
    }

    private Clip createArrangerClip(owV owV2) {
        return this.createClip(owV2);
    }

    private Clip createClip(owV owV2) {
        Clip clip = new Clip();
        clip.name = this.nullIfEmpty(owV2.x3R());
        clip.color = this.getColor(owV2.daf());
        clip.time = owV2.dYG();
        clip.duration = owV2.HQa();
        clip.playStart = owV2.oHG();
        clip.enable = !owV2.Jbo();
        if (owV2.Ffu()) {
            clip.loopStart = owV2.ktC().dYG();
            clip.loopEnd = owV2.ktC().Omx();
        }
        if (owV2 instanceof fhG) {
            fhG fhG2 = (fhG)owV2;
            clip.fadeTimeUnit = TimeUnit.BEATS;
            clip.fadeInTime = fhG2.ZAb();
            clip.fadeOutTime = fhG2.lXt();
            clip.content = this.createAudioEventTimeline(fhG2.bkV());
        } else if (owV2 instanceof PF3) {
            clip.content = this.createNoteTimeline(((PF3)owV2).Fqp());
        }
        return clip;
    }

    private String nullIfEmpty(String string) {
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    private void addClipAutomation(Clip clip, owV owV2) {
        List list = owV2.z2R().iIX();
        if (list.isEmpty()) {
            return;
        }
        Lanes lanes = new Lanes();
        lanes.lanes.add(clip.content);
        clip.content = lanes;
        for (zrd zrd2 : list) {
            Points points = this.createPoints(zrd2);
            if (points == null) continue;
            lanes.lanes.add(points);
        }
    }

    private Notes createNoteTimeline(wtx wtx2) {
        Notes notes = new Notes();
        wtx2.HQg().tGb().forEach(h4 -> notes.notes.add(this.createNote((xl)h4)));
        return notes;
    }

    private Clips createAudioEventTimeline(CBX cBX2) {
        ppJ ppJ2 = cBX2.KdE();
        if (ppJ2 == null) {
            return null;
        }
        Clips clips = new Clips();
        for (ESF eSF : ppJ2.fb_()) {
            clips.clips.add(this.createAudioNote(eSF));
        }
        return clips;
    }

    private Clip createAudioNote(ESF eSF) {
        Clip clip = new Clip();
        clip.time = eSF.dYG();
        clip.duration = eSF.HQa();
        clip.fadeTimeUnit = TimeUnit.BEATS;
        clip.fadeInTime = eSF.ZAb();
        clip.fadeOutTime = eSF.lXt();
        Audio audio = this.createAudio(eSF);
        if (eSF.Lea() == G.Ivg) {
            clip.contentTimeUnit = TimeUnit.SECONDS;
            clip.content = this.wrapAudioContentWithExpressions(eSF, (Timeline)audio);
            clip.playStart = eSF.CsW();
            clip.playStop = eSF.NhN();
        } else {
            clip.contentTimeUnit = TimeUnit.BEATS;
            Warps warps = this.createWarps(eSF.cS2(), audio);
            clip.content = this.wrapAudioContentWithExpressions(eSF, (Timeline)warps);
            clip.playStart = eSF.zoh();
        }
        return clip;
    }

    private Timeline wrapAudioContentWithExpressions(ESF eSF, Timeline timeline) {
        BHZ bHZ2 = eSF.f2j();
        List list = bHZ2.nYD();
        if (!list.isEmpty()) {
            Lanes lanes = new Lanes();
            lanes.lanes.add(timeline);
            for (uKr uKr2 : list) {
                lanes.lanes.add(this.createExpressionTimeline(uKr2));
            }
            return lanes;
        }
        return timeline;
    }

    private Audio createAudio(ESF eSF) {
        Audio audio = new Audio();
        X2Z x2Z = eSF.oHG();
        File file = this.getFile(x2Z);
        if (!this.mEmbeddedFiles.containsKey(file)) {
            String string = this.getUniquePath("audio/" + file.getName());
            this.embed(string, file);
        }
        audio.file.path = (String)this.mEmbeddedFiles.get(file);
        audio.duration = x2Z.tGb();
        audio.sampleRate = x2Z.Nyy();
        audio.channels = x2Z.Fqp();
        audio.algorithm = eSF.Lea().OSp();
        return audio;
    }

    private File getFile(X2Z x2Z) {
        File file = x2Z.qFU();
        if (file != null) {
            return file;
        }
        yh2 yh22 = x2Z.eFH();
        String string = yh22.tGb();
        if (string != null && !string.isEmpty()) {
            return this.mSourceProject.Fqp().OSp(string);
        }
        Fto fto = yh22.dJJ();
        return new File(fto.UB2());
    }

    private Warps createWarps(axt axt2, Audio audio) {
        int n2 = axt2.rr();
        Warps warps = new Warps();
        warps.timeUnit = TimeUnit.BEATS;
        warps.contentTimeUnit = TimeUnit.SECONDS;
        warps.content = audio;
        for (int i2 = 0; i2 < n2; ++i2) {
            TCy tCy = axt2.OSp(i2);
            Warp warp = new Warp();
            warp.time = tCy.dYG();
            warp.contentTime = tCy.UB2();
            warps.events.add(warp);
        }
        return warps;
    }

    private String getUniquePath(String string) {
        for (String string2 : this.mEmbeddedFiles.values()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            int n2 = string.lastIndexOf(".");
            if (n2 == -1) {
                return this.getUniquePath(string + "2");
            }
            return this.getUniquePath(string.substring(0, n2) + "2" + string.substring(n2));
        }
        return string;
    }

    private Note createNote(xl xl2) {
        Note note = new Note();
        note.time = xl2.dYG();
        note.duration = xl2.HQa();
        note.channel = xl2.zRD();
        note.key = xl2.Ivg();
        note.velocity = xl2.lXt();
        note.releaseVelocity = xl2.onT();
        gD2 gD22 = xl2.okW();
        List list = gD22.nYD();
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                note.content = this.createExpressionTimeline((uKr)list.get(0));
            } else {
                Lanes lanes = new Lanes();
                note.content = lanes;
                for (uKr uKr2 : list) {
                    lanes.lanes.add(this.createExpressionTimeline(uKr2));
                }
            }
        }
        return note;
    }

    private Points createExpressionTimeline(uKr uKr2) {
        Unit unit = this.getExpressionUnit(uKr2.QTZ());
        Points points = this.createPoints(uKr2, unit, null);
        points.target.expression = this.getExpression(uKr2.QTZ());
        points.unit = unit;
        return points;
    }

    private ExpressionType getExpression(String string) {
        if (string.equals("amplitude")) {
            return ExpressionType.GAIN;
        }
        if (string.equals("panning")) {
            return ExpressionType.PAN;
        }
        if (string.equals("transpose")) {
            return ExpressionType.TRANSPOSE;
        }
        if (string.equals("timbre")) {
            return ExpressionType.TIMBRE;
        }
        if (string.equals("formant")) {
            return ExpressionType.FORMANT;
        }
        if (string.equals("pressure")) {
            return ExpressionType.PRESSURE;
        }
        return null;
    }

    private Unit getExpressionUnit(String string) {
        if (string.equals("amplitude")) {
            return Unit.LINEAR;
        }
        if (string.equals("panning")) {
            return Unit.LINEAR;
        }
        if (string.equals("transpose")) {
            return Unit.SEMITONES;
        }
        if (string.equals("timbre")) {
            return Unit.LINEAR;
        }
        if (string.equals("formant")) {
            return Unit.SEMITONES;
        }
        if (string.equals("pressure")) {
            return Unit.LINEAR;
        }
        return null;
    }

    public SendType getEffectiveSendMode(qeE qeE2) {
        YtL ytL2 = qeE2.Ffu();
        if (ytL2 == YtL.Ivg) {
            avs avs2 = qeE2.nJN();
            QKi qKi = avs2.vol();
            return qKi.Lwx() ? SendType.PRE : SendType.POST;
        }
        if (ytL2 == YtL.OSp) {
            return SendType.PRE;
        }
        return SendType.POST;
    }

    private Device createDevice(tgf tgf2) {
        if (tgf2 instanceof JGp) {
            return this.createClapDevice((JGp)tgf2);
        }
        if (tgf2 instanceof QRV) {
            return this.createVst3Device((QRV)tgf2);
        }
        if (tgf2 instanceof BJm) {
            return this.createVst2Device((BJm)tgf2);
        }
        if (tgf2 instanceof ufD) {
            return this.createBuiltinDevice((ufD)tgf2);
        }
        return null;
    }

    private ClapPlugin createClapDevice(JGp jGp) {
        ClapPlugin clapPlugin = new ClapPlugin();
        this.initPlugin(jGp, (Plugin)clapPlugin);
        clapPlugin.deviceID = jGp.AHQ().oHp();
        return clapPlugin;
    }

    private Vst3Plugin createVst3Device(QRV qRV) {
        Vst3Plugin vst3Plugin = new Vst3Plugin();
        this.initPlugin(qRV, (Plugin)vst3Plugin);
        vst3Plugin.deviceID = qRV.AHQ().oHp();
        return vst3Plugin;
    }

    private Vst2Plugin createVst2Device(BJm bJm2) {
        Vst2Plugin vst2Plugin = new Vst2Plugin();
        this.initPlugin(bJm2, (Plugin)vst2Plugin);
        return vst2Plugin;
    }

    private BuiltinDevice createBuiltinDeviceObject(ufD ufD2, ArrayList arrayList) {
        UUID uUID = ufD2.ZiK().oHp();
        boolean bl2 = uUID.equals(mii.QkE);
        boolean bl3 = uUID.equals(mii.oCu);
        boolean bl4 = uUID.equals(mii.Hsr);
        boolean bl5 = uUID.equals(mii.Lea);
        boolean bl6 = uUID.equals(mii.eFH);
        boolean bl7 = uUID.equals(mii.Pbi);
        boolean bl8 = uUID.equals(mii.BuB);
        if (bl2 || bl3) {
            return this.createEqualizer(ufD2, bl2);
        }
        if (bl4) {
            return this.createEqualizerFromEQ2(ufD2);
        }
        if (bl5) {
            return this.createCompressor(ufD2);
        }
        if (bl8) {
            return this.createLimiter(ufD2);
        }
        if (bl7) {
            return this.createGate(ufD2);
        }
        return new BuiltinDevice();
    }

    private Compressor createCompressor(ufD ufD2) {
        Compressor compressor = new Compressor();
        compressor.inputGain = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "INPUT"));
        compressor.outputGain = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "OUTPUT"));
        compressor.threshold = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "THRESHOLD"));
        compressor.ratio = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "RATIO"), Unit.PERCENT);
        compressor.attack = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "ATTACK"));
        compressor.release = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "RELEASE"));
        compressor.autoMakeup = (BoolParameter)this.createParameter(this.getDeviceParameter(ufD2, "MAKEUP_GAIN"));
        return compressor;
    }

    private Limiter createLimiter(ufD ufD2) {
        Limiter limiter = new Limiter();
        limiter.inputGain = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "GAIN"));
        limiter.threshold = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "CEILING"));
        limiter.release = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "RELEASE"));
        return limiter;
    }

    private NoiseGate createGate(ufD ufD2) {
        NoiseGate noiseGate = new NoiseGate();
        noiseGate.threshold = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "THRESHOLD_LEVEL"), Unit.DECIBEL);
        noiseGate.range = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "DEPTH"), Unit.DECIBEL, d2 -> -d2);
        noiseGate.attack = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "ATTACK"));
        noiseGate.release = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "RELEASE"));
        return noiseGate;
    }

    private Equalizer createEqualizerFromEQ2(ufD ufD2) {
        Equalizer equalizer = new Equalizer();
        String[] stringArray = new String[]{"LO_FREQ", "HI_FREQ"};
        String[] stringArray2 = new String[]{"LO_GAIN", "HI_GAIN"};
        String[] stringArray3 = new String[]{"LO_Q", "HI_Q"};
        String[] stringArray4 = new String[]{"TYPE1", "HI_TYPE"};
        String[] stringArray5 = new String[]{"LO_ENABLE", "HI_ENABLE"};
        for (int i2 = 0; i2 < 2; ++i2) {
            EqBand eqBand = new EqBand();
            eqBand.freq = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, stringArray[i2]));
            eqBand.gain = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, stringArray2[i2]));
            eqBand.Q = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, stringArray3[i2]));
            eqBand.enabled = (BoolParameter)this.createParameter((Zcr)ufD2.JDh("CONTENTS/" + stringArray5[i2]));
            tov tov2 = tov.Ivg(this.getIndexedValueAtom(ufD2, stringArray4[i2]).UB2());
            eqBand.type = this.convertEqType(tov2);
            eqBand.order = this.convertEqOrder(tov2);
            if (eqBand.type == null) continue;
            equalizer.bands.add(eqBand);
        }
        return equalizer;
    }

    private Equalizer createEqualizer(ufD ufD2, boolean bl2) {
        Equalizer equalizer = new Equalizer();
        int n2 = bl2 ? 8 : 5;
        for (int i2 = 0; i2 < n2; ++i2) {
            EqBand eqBand = new EqBand();
            int n3 = i2 + 1;
            eqBand.freq = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "FREQ" + n3));
            eqBand.gain = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "GAIN" + n3));
            eqBand.Q = (RealParameter)this.createParameter(this.getDeviceParameter(ufD2, "Q" + n3));
            eqBand.enabled = (BoolParameter)this.createParameter((Zcr)ufD2.JDh("CONTENTS/ENABLE" + n3));
            tov tov2 = tov.Ivg(this.getIndexedValueAtom(ufD2, "TYPE" + n3).UB2());
            eqBand.type = this.convertEqType(tov2);
            eqBand.order = this.convertEqOrder(tov2);
            if (eqBand.type == null) continue;
            equalizer.bands.add(eqBand);
        }
        return equalizer;
    }

    private EqBandType convertEqType(tov tov2) {
        switch (tov2) {
            case Ivg: {
                return null;
            }
            case OSp: 
            case oHp: 
            case UB2: 
            case ZAb: 
            case lXt: {
                return EqBandType.LOW_PASS;
            }
            case onT: 
            case Nyy: 
            case tGb: 
            case Fqp: 
            case QCa: {
                return EqBandType.HIGH_PASS;
            }
            case kpx: 
            case zEU: {
                return EqBandType.BAND_PASS;
            }
            case fjZ: {
                return EqBandType.BELL;
            }
            case GC2: {
                return EqBandType.NOTCH;
            }
            case GXr: {
                return EqBandType.LOW_SHELF;
            }
            case Lea: {
                return EqBandType.HIGH_SHELF;
            }
            case kyS: {
                return null;
            }
        }
        return null;
    }

    private int convertEqOrder(tov tov2) {
        switch (tov2) {
            case Ivg: 
            case kyS: {
                return 0;
            }
            case lXt: 
            case Nyy: {
                return 1;
            }
            case OSp: 
            case onT: 
            case kpx: 
            case fjZ: 
            case GC2: 
            case GXr: 
            case Lea: {
                return 2;
            }
            case oHp: 
            case tGb: 
            case zEU: {
                return 4;
            }
            case UB2: 
            case Fqp: {
                return 6;
            }
            case ZAb: 
            case QCa: {
                return 8;
            }
        }
        return 0;
    }

    private Kzl getIndexedValueAtom(ufD ufD2, String string) {
        Kzl kzl = (Kzl)ufD2.JDh("CONTENTS/" + string);
        assert (bRI.UB2(kzl != null));
        return kzl;
    }

    private Zcr getDeviceParameter(ufD ufD2, String string) {
        Zcr zcr = (Zcr)ufD2.JDh("CONTENTS/" + string);
        assert (bRI.UB2(zcr != null));
        return zcr;
    }

    private BuiltinDevice createBuiltinDevice(ufD ufD2) {
        ArrayList arrayList = new ArrayList();
        BuiltinDevice builtinDevice = this.createBuiltinDeviceObject(ufD2, arrayList);
        this.initDevice(ufD2, (Device)builtinDevice);
        builtinDevice.deviceID = ufD2.ZiK().oHp().toString();
        return builtinDevice;
    }

    private void initDevice(tgf tgf2, Device device) {
        device.name = this.nullIfEmpty(tgf2.Akb());
        device.deviceName = tgf2.x3R();
        device.enabled = (BoolParameter)this.createParameter(tgf2.aNQ());
        device.loaded = tgf2.Omx();
        device.deviceRole = switch (tgf2.LTB()) {
            default -> throw new MatchException(null, null);
            case lwa.Ivg -> DeviceRole.AUDIO_FX;
            case lwa.OSp -> DeviceRole.NOTE_FX;
            case lwa.oHp -> DeviceRole.INSTRUMENT;
            case lwa.UB2 -> DeviceRole.ANALYZER;
        };
    }

    private void initPlugin(aZj aZj2, Plugin plugin) {
        this.initDevice(aZj2, (Device)plugin);
        plugin.deviceID = aZj2.AHQ().oHp();
        D1q d1q = aZj2.JaM();
        assert (bRI.lXt(!d1q.Mti()));
        File file = d1q.PDy();
        if (file != null && file.exists()) {
            plugin.state = new FileReference();
            plugin.state.path = "plugins/" + file.getName();
            this.embed(plugin.state.path, file);
        }
        for (HfK hfK : d1q.Vma()) {
            if (!hfK.LTB()) continue;
            plugin.automatedParameters.add(this.createParameter(hfK));
        }
    }

    File getFile(String string) {
        return new File(Yx.glf(), string);
    }

    void embed(String string, File file) {
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.mEmbeddedFiles.put(file, string);
    }
}

