/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class StringValueProxy
extends ValueProxy
implements StringValue,
xOW {
    private qQ mValue;
    private final qQ mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createTruncatableString(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return SHq.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        assert (this.UB2(n2 >= 1));
        return this.mValue.getLimited(n2);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(qQ2 -> stringValueChangedCallback.valueChanged(qQ2.get()));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(qQ2 -> {
            if (qQ2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(qQ2.getLimited(n2));
            }
        });
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (this.UB2(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(SHq sHq) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(sHq != null));
        if (sHq.isObservable()) {
            sHq.removeListener(this);
        }
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(SHq sHq) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(sHq != null));
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(this.isActiveOnDocumentThread()));
        if (sHq.isObservable()) {
            sHq.addListener(this);
        }
        this.updateValue();
    }

    public qQ getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(FNz fNz) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(Objects.equals(fNz.Ivg(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (this.UB2(this.isDocumentThread()));
        String string = (String)((SHq)this.getTarget()).getValue();
        assert (this.UB2(string != null));
        qQ qQ2 = this.createTruncatableString(string);
        assert (this.UB2(qQ2 != null));
        this.queueNotifyObservers(qQ2);
    }

    private void queueNotifyObservers(qQ qQ2) {
        assert (this.UB2(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(qQ2));
    }

    protected qQ createTruncatableString(String string) {
        assert (this.UB2(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return qQ.EMPTY;
        }
        return new xmn(string);
    }

    private void notifyObservers(qQ qQ2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        if (qQ2.equals(this.mValue)) {
            return;
        }
        this.mValue = qQ2;
        if (this.mObservers != null) {
            for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                controlSurfaceStringValueChangedCallback.valueChanged(qQ2);
            }
        }
    }
}

