/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.ramona.core.Oac;

public class StringSetting
extends SettableStringValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private VD2 mIsEnabled;
    private VD2 mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private Oac mSetting;

    public StringSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject, string3);
        this.notEmpty(string, "label");
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(oY oY2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(oY2 != null));
        assert (this.ZAb(this.mSetting == null));
        this.mSetting = oY2;
        this.setTarget(oY2.tGb());
        this.connectEnableAndVisibleValues(oY2.oc(), oY2.QkE());
    }

    public void disconnectFromSetting(oY oY2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(oY2 != null));
        assert (this.ZAb(this.mSetting == oY2));
        this.disconnectEnableAndVisibleValues(oY2.oc(), oY2.QkE());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(loc loc2) {
        assert (this.ZAb(this.mSetting == null));
        this.mSetting = loc2;
        this.setTarget(loc2.Ivg());
        this.connectEnableAndVisibleValues(loc2.tGb(), loc2.Fqp());
    }

    public void disconnectFromSetting(loc loc2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(loc2 != null));
        assert (this.ZAb(this.mSetting == loc2));
        this.disconnectEnableAndVisibleValues(loc2.tGb(), loc2.Fqp());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = vD2;
        this.mIsVisible = vD22;
    }

    private void disconnectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public Oac getSetting() {
        return this.mSetting;
    }
}

