/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SignalProxy;
import com.bitwig.ramona.core.Oac;

public class SignalSetting
extends SignalProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final String mAction;
    private VD2 mIsEnabled;
    private VD2 mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private Oac mSetting;

    public SignalSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new QWx("Error: label for setting can't be empty.");
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mAction = string3;
    }

    public void connectToSetting(oW oW2) {
        assert (this.ZAb(this.mSetting == null));
        this.mSetting = oW2;
        this.setTarget(oW2.Fqp());
        this.connectEnableAndVisibleValues(oW2.oc(), oW2.QkE());
    }

    public void disconnectFromSetting(oW oW2) {
        assert (this.ZAb(this.mSetting == oW2));
        this.disconnectEnableAndVisibleValues(oW2.oc(), oW2.QkE());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(ijZ ijZ2) {
        assert (this.ZAb(this.mSetting == null));
        this.mSetting = ijZ2;
        this.setTarget(ijZ2.UB2());
        this.connectEnableAndVisibleValues(ijZ2.tGb(), ijZ2.Fqp());
    }

    public void disconnectFromSetting(ijZ ijZ2) {
        assert (this.ZAb(this.mSetting == ijZ2));
        this.disconnectEnableAndVisibleValues(ijZ2.tGb(), ijZ2.Fqp());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = vD2;
        this.mIsVisible = vD22;
    }

    private void disconnectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public String getAction() {
        return this.mAction;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public Oac getSetting() {
        return this.mSetting;
    }
}

