/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.MultiManuallyMappedParameterTarget;
import com.bitwig.flt.control_surface.values.ParameterProxy;
import com.bitwig.flt.control_surface.values.ParameterTarget;
import com.bitwig.flt.control_surface.values.RemappableRangedValueProxy;
import com.bitwig.flt.control_surface.values.SingleManuallyMappedParameterTarget;
import java.util.ArrayList;
import java.util.List;

public class RemappableParameterProxy
extends ParameterProxy {
    int mTouchId;
    private List mManualMappings;
    private ParameterTarget mTargetToUseWhenNotMapped;
    private boolean mHasScheduledUpdateToTarget;

    public RemappableParameterProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        assert (this.UB2(string != null));
        assert (this.UB2(!string.isEmpty()));
        this.mValue.setKey(string);
        this.getHost().rememberRemappableParameterProxy(this);
    }

    public void setTarget(ParameterTarget parameterTarget) {
        if (!this.hasManualMappings()) {
            super.setTarget(parameterTarget);
        }
        this.mTargetToUseWhenNotMapped = parameterTarget;
    }

    @Override
    protected RemappableRangedValueProxy createValueProxy() {
        return new RemappableRangedValueProxy(this);
    }

    @Override
    public RemappableRangedValueProxy getValueProxy() {
        return (RemappableRangedValueProxy)super.getValueProxy();
    }

    public String getParameterId() {
        return this.mValue.getKey();
    }

    public void manualMappingAdded(AOT aOT2) {
        assert (this.UB2(aOT2 != null));
        assert (this.UB2(aOT2.tGb().equals(this.getParameterId())));
        if (this.mManualMappings == null) {
            this.mManualMappings = new ArrayList(2);
        }
        assert (this.UB2(!this.mManualMappings.contains(aOT2)));
        this.mManualMappings.add(aOT2);
        this.invalidateTarget();
    }

    public void manualMappingRemoved(AOT aOT2) {
        assert (this.UB2(aOT2 != null));
        assert (this.UB2(aOT2.tGb().equals(this.getParameterId())));
        assert (this.UB2(this.mManualMappings != null && this.mManualMappings.contains(aOT2)));
        this.mManualMappings.remove(aOT2);
        if (this.mManualMappings.isEmpty()) {
            this.mManualMappings = null;
        }
        this.invalidateTarget();
    }

    private void invalidateTarget() {
        if (!this.mHasScheduledUpdateToTarget) {
            this.mHasScheduledUpdateToTarget = true;
            this.runAtEndOfEvent(this::updateTarget);
        }
    }

    private void updateTarget() {
        ParameterTarget parameterTarget = this.calculateTarget();
        super.setTarget(parameterTarget);
        this.mHasScheduledUpdateToTarget = false;
    }

    private ParameterTarget calculateTarget() {
        if (!this.hasManualMappings()) {
            return this.mTargetToUseWhenNotMapped;
        }
        if (this.mManualMappings.size() == 1) {
            return new SingleManuallyMappedParameterTarget((AOT)this.mManualMappings.get(0));
        }
        return new MultiManuallyMappedParameterTarget(this.mManualMappings);
    }

    public boolean hasManualMappings() {
        return this.mManualMappings != null && !this.mManualMappings.isEmpty();
    }

    @Override
    public void touch(boolean bl2) {
        if (bl2) {
            ++this.mTouchId;
        }
        this.postEvent(new UVh(this.mValue, bl2));
    }
}

