/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.AbsoluteHardwareControl;
import com.bitwig.extension.controller.api.AbsoluteHardwareControlBinding;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlToRangedValueBinding;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy;
import com.bitwig.flt.control_surface.values.DocumentNumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.NumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.PreferencesNumberSettingRangedValueTarget;
import com.bitwig.ramona.core.Oac;

public class NumberSetting
extends AbstractRangedValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final double mMinValue;
    private final double mMaxValue;
    private final double mStepResolution;
    private final String mUnit;
    private final double mDefaultValue;
    private VD2 mIsEnabled;
    private VD2 mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private Oac mSetting;

    public NumberSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, double d2, double d3, double d4, String string3, double d5) {
        super(controlSurfaceObject, d5, d3 != d2 ? (d5 - d2) / (d3 - d2) : 0.0);
        if (string == null || string.isEmpty()) {
            throw new QWx("Error: label for setting can't be empty.");
        }
        if (string3 == null) {
            string3 = "";
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mMinValue = d2;
        this.mMaxValue = d3;
        this.mStepResolution = d4;
        this.mUnit = string3;
        this.mDefaultValue = d5;
        this.setKey("Setting/" + string2 + "/" + string);
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    @Override
    public Class getTargetType() {
        return NumberSettingRangedValueTarget.class;
    }

    public void connectToSetting(oN oN2) {
        assert (this.ZAb(this.mSetting == null));
        this.mSetting = oN2;
        this.setTarget(new PreferencesNumberSettingRangedValueTarget(oN2));
        this.connectEnableAndVisibleValues(oN2.oc(), oN2.QkE());
    }

    public void disconnectFromSetting(oN oN2) {
        assert (this.ZAb(this.mSetting == oN2));
        this.disconnectEnableAndVisibleValues(oN2.oc(), oN2.QkE());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(Fce fce) {
        assert (this.ZAb(this.mSetting == null));
        this.mSetting = fce;
        this.setTarget(new DocumentNumberSettingRangedValueTarget(fce));
        this.connectEnableAndVisibleValues(fce.tGb(), fce.Fqp());
    }

    public void disconnectFromSetting(Fce fce) {
        assert (this.ZAb(this.mSetting == fce));
        this.disconnectEnableAndVisibleValues(fce.tGb(), fce.Fqp());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = vD2;
        this.mIsVisible = vD22;
    }

    private void disconnectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    protected double getCurrentValue() {
        double d2 = super.getCurrentValue();
        int n2 = (int)Math.round(d2 / this.mStepResolution);
        return this.mStepResolution * (double)n2;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public double getStepResolution() {
        return this.mStepResolution;
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getUnit() {
        return this.mUnit;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public Oac getSetting() {
        return this.mSetting;
    }

    @Override
    public AbsoluteHardwareControlBinding addBindingWithRange(AbsoluteHardwareControl absoluteHardwareControl, double d2, double d3) {
        throw new QWx("Not supported");
    }

    @Override
    public RelativeHardwareControlToRangedValueBinding addBindingWithRangeAndSensitivity(RelativeHardwareControl relativeHardwareControl, double d2, double d3, double d4) {
        throw new QWx("Not supported");
    }
}

